/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.DIS;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.MetadataSet;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFInt32;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFInt32;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.jsail.fields.SFTime;
import org.web3d.x3d.jsail.fields.SFVec3d;
import org.web3d.x3d.jsail.fields.SFVec3f;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;

public class SignalPdu
extends X3DConcreteNode
implements org.web3d.x3d.sai.DIS.SignalPdu {
    private ArrayList<String> commentsList;
    private String address = new String();
    private int applicationID;
    private float[] bboxCenter;
    private boolean bboxDisplay;
    private float[] bboxSize;
    private ArrayList<Integer> data = new ArrayList();
    private int dataLength;
    private String description = new String();
    private boolean enabled;
    private int encodingScheme;
    private int entityID;
    private double[] geoCoords;
    private ArrayList<String> geoSystem = new ArrayList();
    private IS IS;
    private boolean isActive;
    private boolean isNetworkReader;
    private boolean isNetworkWriter;
    private boolean isRtpHeaderHeard;
    private boolean isStandAlone;
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private String multicastRelayHost = new String();
    private int multicastRelayPort;
    private String networkMode = new String();
    private int port;
    private int radioID;
    private double readInterval;
    private boolean rtpHeaderExpected;
    private int sampleRate;
    private int samples;
    private int siteID;
    private int tdlType;
    private double timestamp;
    private boolean visible;
    private int whichGeometry;
    private double writeInterval;
    static boolean networkModeWarningAlreadyProvided = false;
    public static final String NETWORKMODE_STANDALONE = "standAlone";
    public static final String NETWORKMODE_NETWORKREADER = "networkReader";
    public static final String NETWORKMODE_NETWORKWRITER = "networkWriter";
    public static final String NAME = "SignalPdu";
    public static final String COMPONENT = "DIS";
    public static final int LEVEL = 1;
    public static final String ADDRESS_DEFAULT_VALUE = "localhost";
    public static final int APPLICATIONID_DEFAULT_VALUE = 0;
    public static final float[] BBOXCENTER_DEFAULT_VALUE = new float[]{0.0f, 0.0f, 0.0f};
    public static final boolean BBOXDISPLAY_DEFAULT_VALUE = false;
    public static final float[] BBOXSIZE_DEFAULT_VALUE = new float[]{-1.0f, -1.0f, -1.0f};
    public static final ArrayList<Integer> DATA_DEFAULT_VALUE = new ArrayList<Integer>(Arrays.asList(new Integer[0]));
    public static final int DATALENGTH_DEFAULT_VALUE = 0;
    public static final String DESCRIPTION_DEFAULT_VALUE = "";
    public static final boolean ENABLED_DEFAULT_VALUE = true;
    public static final int ENCODINGSCHEME_DEFAULT_VALUE = 0;
    public static final int ENTITYID_DEFAULT_VALUE = 0;
    public static final double[] GEOCOORDS_DEFAULT_VALUE = new double[]{0.0, 0.0, 0.0};
    public static final ArrayList<String> GEOSYSTEM_DEFAULT_VALUE = new ArrayList<String>(Arrays.asList("GD", "WE"));
    public static final IS IS_DEFAULT_VALUE = null;
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final String MULTICASTRELAYHOST_DEFAULT_VALUE = "";
    public static final int MULTICASTRELAYPORT_DEFAULT_VALUE = 0;
    public static final String NETWORKMODE_DEFAULT_VALUE = "standAlone";
    public static final int PORT_DEFAULT_VALUE = 0;
    public static final int RADIOID_DEFAULT_VALUE = 0;
    public static final double READINTERVAL_DEFAULT_VALUE = 0.1;
    public static final boolean RTPHEADEREXPECTED_DEFAULT_VALUE = false;
    public static final int SAMPLERATE_DEFAULT_VALUE = 0;
    public static final int SAMPLES_DEFAULT_VALUE = 0;
    public static final int SITEID_DEFAULT_VALUE = 0;
    public static final int TDLTYPE_DEFAULT_VALUE = 0;
    public static final boolean VISIBLE_DEFAULT_VALUE = true;
    public static final int WHICHGEOMETRY_DEFAULT_VALUE = 1;
    public static final double WRITEINTERVAL_DEFAULT_VALUE = 1.0;
    public static final String containerField_DEFAULT_VALUE = "children";
    public static final String fromField_ADDRESS = "address";
    public static final String toField_ADDRESS = "address";
    public static final String fromField_APPLICATIONID = "applicationID";
    public static final String toField_APPLICATIONID = "applicationID";
    public static final String fromField_BBOXDISPLAY = "bboxDisplay";
    public static final String toField_BBOXDISPLAY = "bboxDisplay";
    public static final String fromField_DATA = "data";
    public static final String toField_DATA = "data";
    public static final String fromField_DATALENGTH = "dataLength";
    public static final String toField_DATALENGTH = "dataLength";
    public static final String fromField_DESCRIPTION = "description";
    public static final String toField_DESCRIPTION = "description";
    public static final String fromField_ENABLED = "enabled";
    public static final String toField_ENABLED = "enabled";
    public static final String fromField_ENCODINGSCHEME = "encodingScheme";
    public static final String toField_ENCODINGSCHEME = "encodingScheme";
    public static final String fromField_ENTITYID = "entityID";
    public static final String toField_ENTITYID = "entityID";
    public static final String fromField_GEOCOORDS = "geoCoords";
    public static final String toField_GEOCOORDS = "geoCoords";
    public static final String fromField_IS = "IS";
    public static final String fromField_ISACTIVE = "isActive";
    public static final String fromField_ISNETWORKREADER = "isNetworkReader";
    public static final String fromField_ISNETWORKWRITER = "isNetworkWriter";
    public static final String fromField_ISRTPHEADERHEARD = "isRtpHeaderHeard";
    public static final String fromField_ISSTANDALONE = "isStandAlone";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String fromField_MULTICASTRELAYHOST = "multicastRelayHost";
    public static final String toField_MULTICASTRELAYHOST = "multicastRelayHost";
    public static final String fromField_MULTICASTRELAYPORT = "multicastRelayPort";
    public static final String toField_MULTICASTRELAYPORT = "multicastRelayPort";
    public static final String fromField_NETWORKMODE = "networkMode";
    public static final String toField_NETWORKMODE = "networkMode";
    public static final String fromField_PORT = "port";
    public static final String toField_PORT = "port";
    public static final String fromField_RADIOID = "radioID";
    public static final String toField_RADIOID = "radioID";
    public static final String fromField_READINTERVAL = "readInterval";
    public static final String toField_READINTERVAL = "readInterval";
    public static final String fromField_RTPHEADEREXPECTED = "rtpHeaderExpected";
    public static final String toField_RTPHEADEREXPECTED = "rtpHeaderExpected";
    public static final String fromField_SAMPLERATE = "sampleRate";
    public static final String toField_SAMPLERATE = "sampleRate";
    public static final String fromField_SAMPLES = "samples";
    public static final String toField_SAMPLES = "samples";
    public static final String fromField_SITEID = "siteID";
    public static final String toField_SITEID = "siteID";
    public static final String fromField_TDLTYPE = "tdlType";
    public static final String toField_TDLTYPE = "tdlType";
    public static final String fromField_TIMESTAMP = "timestamp";
    public static final String fromField_VISIBLE = "visible";
    public static final String toField_VISIBLE = "visible";
    public static final String fromField_WHICHGEOMETRY = "whichGeometry";
    public static final String toField_WHICHGEOMETRY = "whichGeometry";
    public static final String fromField_WRITEINTERVAL = "writeInterval";
    public static final String toField_WRITEINTERVAL = "writeInterval";
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 1;
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case "address" -> "SFString";
            case "applicationID" -> "SFInt32";
            case "bboxCenter" -> "SFVec3f";
            case "bboxDisplay" -> "SFBool";
            case "bboxSize" -> "SFVec3f";
            case "data" -> "MFInt32";
            case "dataLength" -> "SFInt32";
            case "description" -> "SFString";
            case "enabled" -> "SFBool";
            case "encodingScheme" -> "SFInt32";
            case "entityID" -> "SFInt32";
            case "geoCoords" -> "SFVec3d";
            case "geoSystem" -> "MFString";
            case fromField_IS -> "SFNode";
            case fromField_ISACTIVE -> "SFBool";
            case fromField_ISNETWORKREADER -> "SFBool";
            case fromField_ISNETWORKWRITER -> "SFBool";
            case fromField_ISRTPHEADERHEARD -> "SFBool";
            case fromField_ISSTANDALONE -> "SFBool";
            case "metadata" -> "SFNode";
            case "multicastRelayHost" -> "SFString";
            case "multicastRelayPort" -> "SFInt32";
            case "networkMode" -> "SFString";
            case "port" -> "SFInt32";
            case "radioID" -> "SFInt32";
            case "readInterval" -> "SFTime";
            case "rtpHeaderExpected" -> "SFBool";
            case "sampleRate" -> "SFInt32";
            case "samples" -> "SFInt32";
            case "siteID" -> "SFInt32";
            case "tdlType" -> "SFInt32";
            case fromField_TIMESTAMP -> "SFTime";
            case "visible" -> "SFBool";
            case "whichGeometry" -> "SFInt32";
            case "writeInterval" -> "SFTime";
            case "DEF" -> "SFString";
            case "USE" -> "SFString";
            case "class" -> "SFString";
            case "id" -> "SFString";
            case "style" -> "SFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case "address" -> "inputOutput";
            case "applicationID" -> "inputOutput";
            case "bboxCenter" -> "initializeOnly";
            case "bboxDisplay" -> "inputOutput";
            case "bboxSize" -> "initializeOnly";
            case "data" -> "inputOutput";
            case "dataLength" -> "inputOutput";
            case "description" -> "inputOutput";
            case "enabled" -> "inputOutput";
            case "encodingScheme" -> "inputOutput";
            case "entityID" -> "inputOutput";
            case "geoCoords" -> "inputOutput";
            case "geoSystem" -> "initializeOnly";
            case fromField_IS -> "inputOutput";
            case fromField_ISACTIVE -> "outputOnly";
            case fromField_ISNETWORKREADER -> "outputOnly";
            case fromField_ISNETWORKWRITER -> "outputOnly";
            case fromField_ISRTPHEADERHEARD -> "outputOnly";
            case fromField_ISSTANDALONE -> "outputOnly";
            case "metadata" -> "inputOutput";
            case "multicastRelayHost" -> "inputOutput";
            case "multicastRelayPort" -> "inputOutput";
            case "networkMode" -> "inputOutput";
            case "port" -> "inputOutput";
            case "radioID" -> "inputOutput";
            case "readInterval" -> "inputOutput";
            case "rtpHeaderExpected" -> "inputOutput";
            case "sampleRate" -> "inputOutput";
            case "samples" -> "inputOutput";
            case "siteID" -> "inputOutput";
            case "tdlType" -> "inputOutput";
            case fromField_TIMESTAMP -> "outputOnly";
            case "visible" -> "inputOutput";
            case "whichGeometry" -> "inputOutput";
            case "writeInterval" -> "inputOutput";
            case "DEF" -> "inputOutput";
            case "USE" -> "inputOutput";
            case "class" -> "inputOutput";
            case "id" -> "inputOutput";
            case "style" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public SignalPdu() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride("");
        this.containerField_ALTERNATE_VALUES = new String[]{containerField_DEFAULT_VALUE};
        this.address = ADDRESS_DEFAULT_VALUE;
        this.applicationID = 0;
        this.bboxCenter = BBOXCENTER_DEFAULT_VALUE;
        this.bboxDisplay = false;
        this.bboxSize = BBOXSIZE_DEFAULT_VALUE;
        this.data = new ArrayList();
        this.dataLength = 0;
        this.description = "";
        this.enabled = true;
        this.encodingScheme = 0;
        this.entityID = 0;
        this.geoCoords = GEOCOORDS_DEFAULT_VALUE;
        this.geoSystem = new ArrayList<String>(GEOSYSTEM_DEFAULT_VALUE);
        this.IS = null;
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.multicastRelayHost = "";
        this.multicastRelayPort = 0;
        this.networkMode = "standAlone";
        this.port = 0;
        this.radioID = 0;
        this.readInterval = 0.1;
        this.rtpHeaderExpected = false;
        this.sampleRate = 0;
        this.samples = 0;
        this.siteID = 0;
        this.tdlType = 0;
        this.visible = true;
        this.whichGeometry = 1;
        this.writeInterval = 1.0;
        this.commentsList = new ArrayList();
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public SignalPdu setAddress(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.address = newValue;
        return this;
    }

    public SignalPdu setAddress(SFString newValue) {
        this.setAddress(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public int getApplicationID() {
        return this.applicationID;
    }

    @Override
    public SignalPdu setApplicationID(int newValue) {
        this.applicationID = newValue;
        return this;
    }

    public SignalPdu setApplicationID(SFInt32 newValue) {
        this.setApplicationID(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float[] getBboxCenter() {
        return this.bboxCenter;
    }

    @Override
    public SignalPdu setBboxCenter(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("SignalPdu bboxCenter newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        this.bboxCenter = newValue;
        return this;
    }

    public SignalPdu setBboxCenter(SFVec3f newValue) {
        this.setBboxCenter(newValue.getPrimitiveValue());
        return this;
    }

    public SignalPdu setBboxCenter(float x, float y, float z) {
        this.setBboxCenter(new float[]{x, y, z});
        return this;
    }

    public SignalPdu setBboxCenter(double x, double y, double z) {
        return this.setBboxCenter(new SFVec3f(x, y, z));
    }

    public SignalPdu setBboxCenter(double[] newArray) {
        return this.setBboxCenter(new SFVec3f(newArray));
    }

    @Override
    public boolean getBboxDisplay() {
        return this.bboxDisplay;
    }

    @Override
    public SignalPdu setBboxDisplay(boolean newValue) {
        this.bboxDisplay = newValue;
        return this;
    }

    public SignalPdu setBboxDisplay(SFBool newValue) {
        this.setBboxDisplay(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float[] getBboxSize() {
        return this.bboxSize;
    }

    @Override
    public SignalPdu setBboxSize(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("SignalPdu bboxSize newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        if ((newValue[0] < 0.0f || newValue[1] < 0.0f || newValue[2] < 0.0f) && (newValue[0] != -1.0f || newValue[1] != -1.0f || newValue[2] != -1.0f)) {
            throw new InvalidFieldValueException("SignalPdu bboxSize newValue=" + SFVec3f.toString(newValue) + " has negative value but is not equal to sentinel {-1,-1,-1} value.");
        }
        this.bboxSize = newValue;
        return this;
    }

    public SignalPdu setBboxSize(SFVec3f newValue) {
        this.setBboxSize(newValue.getPrimitiveValue());
        return this;
    }

    public SignalPdu setBboxSize(float x, float y, float z) {
        this.setBboxSize(new float[]{x, y, z});
        return this;
    }

    public SignalPdu setBboxSize(double x, double y, double z) {
        return this.setBboxSize(new SFVec3f(x, y, z));
    }

    public SignalPdu setBboxSize(double[] newArray) {
        return this.setBboxSize(new SFVec3f(newArray));
    }

    @Override
    public int[] getData() {
        int[] valuesArray = new int[this.data.size()];
        int i = 0;
        for (Integer arrayElement : this.data) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<Integer> getDataList() {
        return this.data;
    }

    public String getDataString() {
        StringBuilder result = new StringBuilder();
        for (Integer arrayElement : this.data) {
            result.append(arrayElement.toString());
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public SignalPdu setData(int[] newValue) {
        if (newValue == null) {
            this.clearData();
            return this;
        }
        this.clearData();
        for (int i = 0; i < newValue.length; ++i) {
            this.data.add(newValue[i]);
        }
        return this;
    }

    public SignalPdu setData(MFInt32 newValue) {
        if (newValue == null) {
            this.clearData();
            return this;
        }
        this.setData(newValue.getPrimitiveValue());
        return this;
    }

    public SignalPdu setData(ArrayList<Integer> newValue) {
        if (newValue == null) {
            this.clearData();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearData();
        } else {
            int[] newArray = new int[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setData(newArray);
        }
        return this;
    }

    public SignalPdu clearData() {
        this.data.clear();
        return this;
    }

    public SignalPdu addData(int newValue) {
        this.data.add(newValue);
        return this;
    }

    public SignalPdu addData(SFInt32 newValue) {
        if (newValue == null) {
            return this;
        }
        this.data.add(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public int getDataLength() {
        return this.dataLength;
    }

    @Override
    public SignalPdu setDataLength(int newValue) {
        this.dataLength = newValue;
        return this;
    }

    public SignalPdu setDataLength(SFInt32 newValue) {
        this.setDataLength(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public SignalPdu setDescription(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.description = newValue;
        return this;
    }

    public SignalPdu setDescription(SFString newValue) {
        this.setDescription(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public SignalPdu setEnabled(boolean newValue) {
        this.enabled = newValue;
        return this;
    }

    public SignalPdu setEnabled(SFBool newValue) {
        this.setEnabled(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public int getEncodingScheme() {
        return this.encodingScheme;
    }

    @Override
    public SignalPdu setEncodingScheme(int newValue) {
        this.encodingScheme = newValue;
        return this;
    }

    public SignalPdu setEncodingScheme(SFInt32 newValue) {
        this.setEncodingScheme(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public int getEntityID() {
        return this.entityID;
    }

    @Override
    public SignalPdu setEntityID(int newValue) {
        this.entityID = newValue;
        return this;
    }

    public SignalPdu setEntityID(SFInt32 newValue) {
        this.setEntityID(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public double[] getGeoCoords() {
        return this.geoCoords;
    }

    @Override
    public SignalPdu setGeoCoords(double[] newValue) {
        if (newValue == null) {
            newValue = new double[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("SignalPdu geoCoords newValue=" + SFVec3d.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        this.geoCoords = newValue;
        return this;
    }

    public SignalPdu setGeoCoords(SFVec3d newValue) {
        this.setGeoCoords(newValue.getPrimitiveValue());
        return this;
    }

    public SignalPdu setGeoCoords(double x, double y, double z) {
        this.setGeoCoords(new double[]{x, y, z});
        return this;
    }

    @Override
    public String[] getGeoSystem() {
        String[] valuesArray = new String[this.geoSystem.size()];
        int i = 0;
        for (String arrayElement : this.geoSystem) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<String> getGeoSystemList() {
        return this.geoSystem;
    }

    public String getGeoSystemString() {
        StringBuilder result = new StringBuilder();
        for (String arrayElement : this.geoSystem) {
            result.append("\"");
            result.append(arrayElement);
            result.append("\"");
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public SignalPdu setGeoSystem(String[] newValue) {
        if (newValue == null) {
            this.clearGeoSystem();
            return this;
        }
        this.clearGeoSystem();
        for (int i = 0; i < newValue.length; ++i) {
            this.geoSystem.add(newValue[i]);
        }
        return this;
    }

    public SignalPdu setGeoSystem(MFString newValue) {
        if (newValue == null) {
            this.clearGeoSystem();
            return this;
        }
        this.setGeoSystem(newValue.getPrimitiveValue());
        return this;
    }

    public SignalPdu setGeoSystem(SFString newValue) {
        if (newValue == null) {
            this.clearGeoSystem();
            return this;
        }
        if (newValue.getValue().length() - newValue.getValue().replace("\"", "").length() > 2) {
            return this.setGeoSystem(new MFString(newValue));
        }
        this.setGeoSystem(newValue.getValue());
        return this;
    }

    public SignalPdu setGeoSystem(String newValue) {
        if (newValue == null) {
            this.clearGeoSystem();
            return this;
        }
        if (newValue.length() - newValue.replace("\"", "").length() > 2) {
            return this.setGeoSystem(new MFString(newValue));
        }
        this.clearGeoSystem();
        this.geoSystem.add(newValue);
        return this;
    }

    public SignalPdu setGeoSystem(ArrayList<String> newValue) {
        if (newValue == null) {
            this.clearGeoSystem();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearGeoSystem();
        } else {
            String[] newArray = new String[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setGeoSystem(newArray);
        }
        return this;
    }

    public SignalPdu clearGeoSystem() {
        this.geoSystem.clear();
        return this;
    }

    public SignalPdu addGeoSystem(String newValue) {
        if (newValue == null) {
            return this;
        }
        if (!(newValue = MFString.cleanupEnumerationValue(newValue)).isEmpty() && !this.geoSystem.contains(newValue)) {
            this.geoSystem.add(newValue);
        }
        return this;
    }

    public SignalPdu addGeoSystem(SFString newValue) {
        if (newValue == null) {
            return this;
        }
        newValue.setValue(MFString.cleanupEnumerationValue(newValue.getValue()));
        if (!newValue.getValue().isEmpty() && !this.geoSystem.contains(newValue.getValue())) {
            this.geoSystem.add(newValue.getValue());
        }
        return this;
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public SignalPdu setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public SignalPdu clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public boolean getIsActive() {
        return this.isActive;
    }

    @Override
    public boolean getIsNetworkReader() {
        return this.isNetworkReader;
    }

    @Override
    public boolean getIsNetworkWriter() {
        return this.isNetworkWriter;
    }

    @Override
    public boolean getIsRtpHeaderHeard() {
        return this.isRtpHeaderHeard;
    }

    @Override
    public boolean getIsStandAlone() {
        return this.isStandAlone;
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public SignalPdu setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
            if (this.metadata instanceof MetadataSet) {
                ((X3DConcreteNode)((Object)this.metadata)).setContainerFieldOverride("metadata");
            }
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public SignalPdu clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public SignalPdu setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public String getMulticastRelayHost() {
        return this.multicastRelayHost;
    }

    @Override
    public SignalPdu setMulticastRelayHost(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.multicastRelayHost = newValue;
        return this;
    }

    public SignalPdu setMulticastRelayHost(SFString newValue) {
        this.setMulticastRelayHost(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public int getMulticastRelayPort() {
        return this.multicastRelayPort;
    }

    @Override
    public SignalPdu setMulticastRelayPort(int newValue) {
        this.multicastRelayPort = newValue;
        return this;
    }

    public SignalPdu setMulticastRelayPort(SFInt32 newValue) {
        this.setMulticastRelayPort(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getNetworkMode() {
        return this.networkMode;
    }

    @Override
    public SignalPdu setNetworkMode(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!((newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue)).isEmpty() || newValue.toString().replace("\"", "").equals("standAlone") || newValue.toString().replace("\"", "").equals(NETWORKMODE_NETWORKREADER) || newValue.toString().replace("\"", "").equals(NETWORKMODE_NETWORKWRITER))) {
            String warningMessage = "[warning] SignalPdu networkMode newValue='" + newValue + "' includes an unrecognized optional value not matching any of the required enumeration string tokens.";
            if (!networkModeWarningAlreadyProvided) {
                warningMessage = warningMessage + "\n      Supported values are standAlone, networkReader, networkWriter";
                networkModeWarningAlreadyProvided = true;
            }
            if (ConfigurationProperties.isConsoleOutputVerbose()) {
                System.out.println(warningMessage);
            }
            if (!newValue.isEmpty()) {
                throw new InvalidFieldValueException(warningMessage);
            }
        }
        if (newValue == null) {
            newValue = new String();
        }
        this.networkMode = newValue;
        return this;
    }

    public SignalPdu setNetworkMode(SFString newValue) {
        this.setNetworkMode(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public SignalPdu setPort(int newValue) {
        this.port = newValue;
        return this;
    }

    public SignalPdu setPort(SFInt32 newValue) {
        this.setPort(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public int getRadioID() {
        return this.radioID;
    }

    @Override
    public SignalPdu setRadioID(int newValue) {
        this.radioID = newValue;
        return this;
    }

    public SignalPdu setRadioID(SFInt32 newValue) {
        this.setRadioID(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public double getReadInterval() {
        return this.readInterval;
    }

    @Override
    public SignalPdu setReadInterval(double newValue) {
        if (newValue < 0.0) {
            throw new InvalidFieldValueException("SignalPdu readInterval newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.readInterval = newValue;
        return this;
    }

    public SignalPdu setReadInterval(SFTime newValue) {
        this.setReadInterval(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public boolean getRtpHeaderExpected() {
        return this.rtpHeaderExpected;
    }

    @Override
    public SignalPdu setRtpHeaderExpected(boolean newValue) {
        this.rtpHeaderExpected = newValue;
        return this;
    }

    public SignalPdu setRtpHeaderExpected(SFBool newValue) {
        this.setRtpHeaderExpected(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public int getSampleRate() {
        return this.sampleRate;
    }

    @Override
    public SignalPdu setSampleRate(int newValue) {
        this.sampleRate = newValue;
        return this;
    }

    public SignalPdu setSampleRate(SFInt32 newValue) {
        this.setSampleRate(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public int getSamples() {
        return this.samples;
    }

    @Override
    public SignalPdu setSamples(int newValue) {
        this.samples = newValue;
        return this;
    }

    public SignalPdu setSamples(SFInt32 newValue) {
        this.setSamples(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public int getSiteID() {
        return this.siteID;
    }

    @Override
    public SignalPdu setSiteID(int newValue) {
        this.siteID = newValue;
        return this;
    }

    public SignalPdu setSiteID(SFInt32 newValue) {
        this.setSiteID(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public int getTdlType() {
        return this.tdlType;
    }

    @Override
    public SignalPdu setTdlType(int newValue) {
        this.tdlType = newValue;
        return this;
    }

    public SignalPdu setTdlType(SFInt32 newValue) {
        this.setTdlType(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public double getTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean getVisible() {
        return this.visible;
    }

    @Override
    public SignalPdu setVisible(boolean newValue) {
        this.visible = newValue;
        return this;
    }

    public SignalPdu setVisible(SFBool newValue) {
        this.setVisible(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public int getWhichGeometry() {
        return this.whichGeometry;
    }

    @Override
    public SignalPdu setWhichGeometry(int newValue) {
        this.whichGeometry = newValue;
        return this;
    }

    public SignalPdu setWhichGeometry(SFInt32 newValue) {
        this.setWhichGeometry(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public double getWriteInterval() {
        return this.writeInterval;
    }

    @Override
    public SignalPdu setWriteInterval(double newValue) {
        if (newValue < 0.0) {
            throw new InvalidFieldValueException("SignalPdu writeInterval newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.writeInterval = newValue;
        return this;
    }

    public SignalPdu setWriteInterval(SFTime newValue) {
        this.setWriteInterval(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final SignalPdu setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("SignalPdu DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE("");
        this.setConcreteDEF(newValue);
        return this;
    }

    public SignalPdu setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final SignalPdu setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("SignalPdu USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF("");
        this.setConcreteUSE(newValue);
        return this;
    }

    public SignalPdu setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final SignalPdu setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public SignalPdu setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getHtmlID() {
        return super.getHtmlID();
    }

    @Override
    public final SignalPdu setHtmlID(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteHtmlID(newValue);
        return this;
    }

    public SignalPdu setHtmlID(SFString newValue) {
        this.setHtmlID(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    @Override
    public final SignalPdu setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public SignalPdu setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    public SignalPdu setUSE(SignalPdu DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "setUSE(DEFnode) invoked on SignalPdu that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public SignalPdu(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    @Override
    public SignalPdu addComments(String newComment) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(\"" + newComment + "\")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public SignalPdu addComments(String[] newComments) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(" + Arrays.toString(newComments) + ")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public SignalPdu addComments(CommentsBlock newCommentsBlock) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(CommentsBlock) cannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasChild = false;
        }
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<SignalPdu");
        if (hasAttributes) {
            if (!this.getDEF().equals("") && !this.hasUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals("")) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isEmpty() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(this.getAddress().equals(ADDRESS_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" address='").append(new SFString(this.getAddress()).toStringX3D()).append("'");
            }
            if (!(this.getApplicationID() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" applicationID='").append(SFInt32.toString(this.getApplicationID())).append("'");
            }
            if (!(Arrays.equals(this.getBboxCenter(), BBOXCENTER_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" bboxCenter='").append(SFVec3f.toString(this.getBboxCenter())).append("'");
            }
            if (!(!this.getBboxDisplay() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" bboxDisplay='").append(SFBool.toString(this.getBboxDisplay())).append("'");
            }
            if (!(Arrays.equals(this.getBboxSize(), BBOXSIZE_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" bboxSize='").append(SFVec3f.toString(this.getBboxSize())).append("'");
            }
            if (!(this.getCssClass().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(this.getData().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" data='").append(MFInt32.toString(this.getData())).append("'");
            }
            if (!(this.getDataLength() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" dataLength='").append(SFInt32.toString(this.getDataLength())).append("'");
            }
            if (!(this.getDescription().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" description='").append(new SFString(this.getDescription()).toStringX3D()).append("'");
            }
            if (!(this.getEnabled() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" enabled='").append(SFBool.toString(this.getEnabled())).append("'");
            }
            if (!(this.getEncodingScheme() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" encodingScheme='").append(SFInt32.toString(this.getEncodingScheme())).append("'");
            }
            if (!(this.getEntityID() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" entityID='").append(SFInt32.toString(this.getEntityID())).append("'");
            }
            if (!(Arrays.equals(this.getGeoCoords(), GEOCOORDS_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" geoCoords='").append(SFVec3d.toString(this.getGeoCoords())).append("'");
            }
            if (!(this.getGeoSystem().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" geoSystem='").append(new MFString(this.getGeoSystem()).toStringX3D()).append("'");
            }
            if (!(this.getHtmlID().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlID()).toStringX3D()).append("'");
            }
            if (!(this.getMulticastRelayHost().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" multicastRelayHost='").append(new SFString(this.getMulticastRelayHost()).toStringX3D()).append("'");
            }
            if (!(this.getMulticastRelayPort() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" multicastRelayPort='").append(SFInt32.toString(this.getMulticastRelayPort())).append("'");
            }
            if (!(this.getNetworkMode().equals("standAlone") && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" networkMode='").append(new SFString(this.getNetworkMode()).toStringX3D()).append("'");
            }
            if (!(this.getPort() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" port='").append(SFInt32.toString(this.getPort())).append("'");
            }
            if (!(this.getRadioID() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" radioID='").append(SFInt32.toString(this.getRadioID())).append("'");
            }
            if (!(this.getReadInterval() == 0.1 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" readInterval='").append(SFTime.toString(this.getReadInterval())).append("'");
            }
            if (!(!this.getRtpHeaderExpected() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" rtpHeaderExpected='").append(SFBool.toString(this.getRtpHeaderExpected())).append("'");
            }
            if (!(this.getSampleRate() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" sampleRate='").append(SFInt32.toString(this.getSampleRate())).append("'");
            }
            if (!(this.getSamples() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" samples='").append(SFInt32.toString(this.getSamples())).append("'");
            }
            if (!(this.getSiteID() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" siteID='").append(SFInt32.toString(this.getSiteID())).append("'");
            }
            if (!(this.getCssStyle().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
            if (!(this.getTdlType() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" tdlType='").append(SFInt32.toString(this.getTdlType())).append("'");
            }
            if (!(this.getVisible() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" visible='").append(SFBool.toString(this.getVisible())).append("'");
            }
            if (!(this.getWhichGeometry() == 1 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" whichGeometry='").append(SFInt32.toString(this.getWhichGeometry())).append("'");
            }
            if (!(this.getWriteInterval() == 1.0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" writeInterval='").append(SFTime.toString(this.getWriteInterval())).append("'");
            }
        }
        if (hasChild && !this.hasUSE()) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</SignalPdu>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals("")) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals("")) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("address")) continue;
                        stringClassicVRML.append(indentCharacter).append("address").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getAddress().equals(ADDRESS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("address ").append("\"").append(SFString.toString(this.getAddress())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("applicationID")) continue;
                        stringClassicVRML.append(indentCharacter).append("applicationID").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getApplicationID() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("applicationID ").append(SFInt32.toString(this.getApplicationID())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("bboxCenter")) continue;
                        stringClassicVRML.append(indentCharacter).append("bboxCenter").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getBboxCenter(), BBOXCENTER_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("bboxCenter ").append(SFVec3f.toString(this.getBboxCenter())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("bboxDisplay")) continue;
                        stringClassicVRML.append(indentCharacter).append("bboxDisplay").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getBboxDisplay() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("bboxDisplay ").append(SFBool.toString(this.getBboxDisplay())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("bboxSize")) continue;
                        stringClassicVRML.append(indentCharacter).append("bboxSize").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getBboxSize(), BBOXSIZE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("bboxSize ").append(SFVec3f.toString(this.getBboxSize())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("data")) continue;
                        stringClassicVRML.append(indentCharacter).append("data").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getData().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("data ").append("[ ").append(MFInt32.toString(this.getData())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("dataLength")) continue;
                        stringClassicVRML.append(indentCharacter).append("dataLength").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getDataLength() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("dataLength ").append(SFInt32.toString(this.getDataLength())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("description")) continue;
                        stringClassicVRML.append(indentCharacter).append("description").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getDescription().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("description ").append("\"").append(SFString.toString(this.getDescription())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("enabled")) continue;
                        stringClassicVRML.append(indentCharacter).append("enabled").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getEnabled() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("enabled ").append(SFBool.toString(this.getEnabled())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("encodingScheme")) continue;
                        stringClassicVRML.append(indentCharacter).append("encodingScheme").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getEncodingScheme() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("encodingScheme ").append(SFInt32.toString(this.getEncodingScheme())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("entityID")) continue;
                        stringClassicVRML.append(indentCharacter).append("entityID").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getEntityID() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("entityID ").append(SFInt32.toString(this.getEntityID())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("geoCoords")) continue;
                        stringClassicVRML.append(indentCharacter).append("geoCoords").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getGeoCoords(), GEOCOORDS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("geoCoords ").append(SFVec3d.toString(this.getGeoCoords())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("geoSystem")) continue;
                        stringClassicVRML.append(indentCharacter).append("geoSystem").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getGeoSystem().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("geoSystem ").append("[ ").append(MFString.toString(this.getGeoSystem())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("id")) continue;
                        stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getHtmlID().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(this.getHtmlID())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("multicastRelayHost")) continue;
                        stringClassicVRML.append(indentCharacter).append("multicastRelayHost").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getMulticastRelayHost().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("multicastRelayHost ").append("\"").append(SFString.toString(this.getMulticastRelayHost())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("multicastRelayPort")) continue;
                        stringClassicVRML.append(indentCharacter).append("multicastRelayPort").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getMulticastRelayPort() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("multicastRelayPort ").append(SFInt32.toString(this.getMulticastRelayPort())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("networkMode")) continue;
                        stringClassicVRML.append(indentCharacter).append("networkMode").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getNetworkMode().equals("standAlone") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("networkMode ").append("\"").append(SFString.toString(this.getNetworkMode())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("port")) continue;
                        stringClassicVRML.append(indentCharacter).append("port").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getPort() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("port ").append(SFInt32.toString(this.getPort())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("radioID")) continue;
                        stringClassicVRML.append(indentCharacter).append("radioID").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getRadioID() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("radioID ").append(SFInt32.toString(this.getRadioID())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("readInterval")) continue;
                        stringClassicVRML.append(indentCharacter).append("readInterval").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getReadInterval() != 0.1 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("readInterval ").append(SFTime.toString(this.getReadInterval())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("rtpHeaderExpected")) continue;
                        stringClassicVRML.append(indentCharacter).append("rtpHeaderExpected").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getRtpHeaderExpected() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("rtpHeaderExpected ").append(SFBool.toString(this.getRtpHeaderExpected())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("sampleRate")) continue;
                        stringClassicVRML.append(indentCharacter).append("sampleRate").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getSampleRate() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("sampleRate ").append(SFInt32.toString(this.getSampleRate())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("samples")) continue;
                        stringClassicVRML.append(indentCharacter).append("samples").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getSamples() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("samples ").append(SFInt32.toString(this.getSamples())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("siteID")) continue;
                        stringClassicVRML.append(indentCharacter).append("siteID").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getSiteID() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("siteID ").append(SFInt32.toString(this.getSiteID())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("style")) continue;
                        stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssStyle().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(this.getCssStyle())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("tdlType")) continue;
                        stringClassicVRML.append(indentCharacter).append("tdlType").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getTdlType() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("tdlType ").append(SFInt32.toString(this.getTdlType())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("visible")) continue;
                        stringClassicVRML.append(indentCharacter).append("visible").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getVisible() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("visible ").append(SFBool.toString(this.getVisible())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("whichGeometry")) continue;
                        stringClassicVRML.append(indentCharacter).append("whichGeometry").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getWhichGeometry() != 1 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("whichGeometry ").append(SFInt32.toString(this.getWhichGeometry())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("writeInterval")) continue;
                        stringClassicVRML.append(indentCharacter).append("writeInterval").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getWriteInterval() != 1.0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("writeInterval ").append(SFTime.toString(this.getWriteInterval())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (hasAttributes || hasChild) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setAddress(this.getAddress());
        this.setApplicationID(this.getApplicationID());
        this.setBboxCenter(this.getBboxCenter());
        this.setBboxDisplay(this.getBboxDisplay());
        this.setBboxSize(this.getBboxSize());
        this.setData(this.getData());
        this.setDataLength(this.getDataLength());
        this.setDescription(this.getDescription());
        this.setEnabled(this.getEnabled());
        this.setEncodingScheme(this.getEncodingScheme());
        this.setEntityID(this.getEntityID());
        this.setGeoCoords(this.getGeoCoords());
        this.setGeoSystem(this.getGeoSystem());
        this.setMulticastRelayHost(this.getMulticastRelayHost());
        this.setMulticastRelayPort(this.getMulticastRelayPort());
        this.setNetworkMode(this.getNetworkMode());
        this.setPort(this.getPort());
        this.setRadioID(this.getRadioID());
        this.setReadInterval(this.getReadInterval());
        this.setRtpHeaderExpected(this.getRtpHeaderExpected());
        this.setSampleRate(this.getSampleRate());
        this.setSamples(this.getSamples());
        this.setSiteID(this.getSiteID());
        this.setTdlType(this.getTdlType());
        this.setVisible(this.getVisible());
        this.setWhichGeometry(this.getWhichGeometry());
        this.setWriteInterval(this.getWriteInterval());
        if (!this.hasUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.hasUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        this.setHtmlID(this.getHtmlID());
        this.setCssStyle(this.getCssStyle());
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.hasUSE() && this.hasIS()) {
            String errorNotice = "SignalPdu USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "SignalPdu USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.hasUSE() && this.hasMetadata()) {
            String errorNotice = "SignalPdu USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "SignalPdu USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            String errorNotice = "IS statement present, but contains no connect statements";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidProtoException(errorNotice);
        }
        if (!this.getContainerFieldOverride().isEmpty() && !Arrays.asList(this.containerField_ALTERNATE_VALUES).contains(this.getContainerFieldOverride())) {
            String errorNotice = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALTERNATE_VALUES='" + new MFString(this.containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        if (this.findAncestorX3D() != null) {
            boolean hasSatisfactorySupport;
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean bl = hasSatisfactorySupport = this.findAncestorX3D().supportsX3dProfile(modelProfile) || this.findAncestorX3D().supportsX3dComponent(COMPONENT, 1);
            if (!hasSatisfactorySupport) {
                String errorNotice = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for current X3D model containing 'SignalPdu' node, ensure sufficient support by adding head statement <component name='DIS' level='1'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"DIS\").setLevel(1);";
                this.validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldException(errorNotice);
            }
        }
        return this.validationResult.toString();
    }
}

