/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.DIS;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.MetadataSet;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFInt32;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.jsail.fields.SFTime;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;

public class DISEntityTypeMapping
extends X3DConcreteNode
implements org.web3d.x3d.sai.DIS.DISEntityTypeMapping {
    private ArrayList<String> commentsList;
    private double autoRefresh;
    private double autoRefreshTimeLimit;
    private int category;
    private int country;
    private String description = new String();
    private int domain;
    private int extra;
    private IS IS;
    private int kind;
    private boolean load;
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private int specific;
    private int subcategory;
    private ArrayList<String> url = new ArrayList();
    public static final String NAME = "DISEntityTypeMapping";
    public static final String COMPONENT = "DIS";
    public static final int LEVEL = 2;
    public static final double AUTOREFRESH_DEFAULT_VALUE = 0.0;
    public static final double AUTOREFRESHTIMELIMIT_DEFAULT_VALUE = 3600.0;
    public static final int CATEGORY_DEFAULT_VALUE = 0;
    public static final int COUNTRY_DEFAULT_VALUE = 0;
    public static final String DESCRIPTION_DEFAULT_VALUE = "";
    public static final int DOMAIN_DEFAULT_VALUE = 0;
    public static final int EXTRA_DEFAULT_VALUE = 0;
    public static final IS IS_DEFAULT_VALUE = null;
    public static final int KIND_DEFAULT_VALUE = 0;
    public static final boolean LOAD_DEFAULT_VALUE = true;
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final int SPECIFIC_DEFAULT_VALUE = 0;
    public static final int SUBCATEGORY_DEFAULT_VALUE = 0;
    public static final ArrayList<String> URL_DEFAULT_VALUE = new ArrayList<String>(Arrays.asList(new String[0]));
    public static final String containerField_DEFAULT_VALUE = "children";
    public static final String fromField_AUTOREFRESH = "autoRefresh";
    public static final String toField_AUTOREFRESH = "autoRefresh";
    public static final String fromField_AUTOREFRESHTIMELIMIT = "autoRefreshTimeLimit";
    public static final String toField_AUTOREFRESHTIMELIMIT = "autoRefreshTimeLimit";
    public static final String fromField_DESCRIPTION = "description";
    public static final String toField_DESCRIPTION = "description";
    public static final String fromField_IS = "IS";
    public static final String fromField_LOAD = "load";
    public static final String toField_LOAD = "load";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String fromField_URL = "url";
    public static final String toField_URL = "url";
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 2;
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case "autoRefresh" -> "SFTime";
            case "autoRefreshTimeLimit" -> "SFTime";
            case "category" -> "SFInt32";
            case "country" -> "SFInt32";
            case "description" -> "SFString";
            case "domain" -> "SFInt32";
            case "extra" -> "SFInt32";
            case fromField_IS -> "SFNode";
            case "kind" -> "SFInt32";
            case "load" -> "SFBool";
            case "metadata" -> "SFNode";
            case "specific" -> "SFInt32";
            case "subcategory" -> "SFInt32";
            case "url" -> "MFString";
            case "DEF" -> "SFString";
            case "USE" -> "SFString";
            case "class" -> "SFString";
            case "id" -> "SFString";
            case "style" -> "SFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case "autoRefresh" -> "inputOutput";
            case "autoRefreshTimeLimit" -> "inputOutput";
            case "category" -> "initializeOnly";
            case "country" -> "initializeOnly";
            case "description" -> "inputOutput";
            case "domain" -> "initializeOnly";
            case "extra" -> "initializeOnly";
            case fromField_IS -> "inputOutput";
            case "kind" -> "initializeOnly";
            case "load" -> "inputOutput";
            case "metadata" -> "inputOutput";
            case "specific" -> "initializeOnly";
            case "subcategory" -> "initializeOnly";
            case "url" -> "inputOutput";
            case "DEF" -> "inputOutput";
            case "USE" -> "inputOutput";
            case "class" -> "inputOutput";
            case "id" -> "inputOutput";
            case "style" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public DISEntityTypeMapping() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride(DESCRIPTION_DEFAULT_VALUE);
        this.containerField_ALTERNATE_VALUES = new String[]{containerField_DEFAULT_VALUE, "mapping", containerField_DEFAULT_VALUE};
        this.autoRefresh = 0.0;
        this.autoRefreshTimeLimit = 3600.0;
        this.category = 0;
        this.country = 0;
        this.description = DESCRIPTION_DEFAULT_VALUE;
        this.domain = 0;
        this.extra = 0;
        this.IS = null;
        this.kind = 0;
        this.load = true;
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.specific = 0;
        this.subcategory = 0;
        this.url = new ArrayList<String>(URL_DEFAULT_VALUE);
        this.commentsList = new ArrayList();
    }

    @Override
    public double getAutoRefresh() {
        return this.autoRefresh;
    }

    @Override
    public DISEntityTypeMapping setAutoRefresh(double newValue) {
        if (newValue < 0.0) {
            throw new InvalidFieldValueException("DISEntityTypeMapping autoRefresh newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.autoRefresh = newValue;
        return this;
    }

    public DISEntityTypeMapping setAutoRefresh(SFTime newValue) {
        this.setAutoRefresh(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public double getAutoRefreshTimeLimit() {
        return this.autoRefreshTimeLimit;
    }

    @Override
    public DISEntityTypeMapping setAutoRefreshTimeLimit(double newValue) {
        if (newValue < 0.0) {
            throw new InvalidFieldValueException("DISEntityTypeMapping autoRefreshTimeLimit newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.autoRefreshTimeLimit = newValue;
        return this;
    }

    public DISEntityTypeMapping setAutoRefreshTimeLimit(SFTime newValue) {
        this.setAutoRefreshTimeLimit(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public int getCategory() {
        return this.category;
    }

    @Override
    public DISEntityTypeMapping setCategory(int newValue) {
        if (newValue < 0) {
            throw new InvalidFieldValueException("DISEntityTypeMapping category newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 255) {
            throw new InvalidFieldValueException("DISEntityTypeMapping category newValue=" + SFInt32.toString(newValue) + " has component value greater than restriction maxInclusive=255");
        }
        this.category = newValue;
        return this;
    }

    public DISEntityTypeMapping setCategory(SFInt32 newValue) {
        this.setCategory(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public int getCountry() {
        return this.country;
    }

    @Override
    public DISEntityTypeMapping setCountry(int newValue) {
        if (newValue < 0) {
            throw new InvalidFieldValueException("DISEntityTypeMapping country newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 65535) {
            throw new InvalidFieldValueException("DISEntityTypeMapping country newValue=" + SFInt32.toString(newValue) + " has component value greater than restriction maxInclusive=65535");
        }
        this.country = newValue;
        return this;
    }

    public DISEntityTypeMapping setCountry(SFInt32 newValue) {
        this.setCountry(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public DISEntityTypeMapping setDescription(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.description = newValue;
        return this;
    }

    public DISEntityTypeMapping setDescription(SFString newValue) {
        this.setDescription(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public int getDomain() {
        return this.domain;
    }

    @Override
    public DISEntityTypeMapping setDomain(int newValue) {
        if (newValue < 0) {
            throw new InvalidFieldValueException("DISEntityTypeMapping domain newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 255) {
            throw new InvalidFieldValueException("DISEntityTypeMapping domain newValue=" + SFInt32.toString(newValue) + " has component value greater than restriction maxInclusive=255");
        }
        this.domain = newValue;
        return this;
    }

    public DISEntityTypeMapping setDomain(SFInt32 newValue) {
        this.setDomain(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public int getExtra() {
        return this.extra;
    }

    @Override
    public DISEntityTypeMapping setExtra(int newValue) {
        if (newValue < 0) {
            throw new InvalidFieldValueException("DISEntityTypeMapping extra newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 255) {
            throw new InvalidFieldValueException("DISEntityTypeMapping extra newValue=" + SFInt32.toString(newValue) + " has component value greater than restriction maxInclusive=255");
        }
        this.extra = newValue;
        return this;
    }

    public DISEntityTypeMapping setExtra(SFInt32 newValue) {
        this.setExtra(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public DISEntityTypeMapping setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public DISEntityTypeMapping clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public int getKind() {
        return this.kind;
    }

    @Override
    public DISEntityTypeMapping setKind(int newValue) {
        if (newValue < 0) {
            throw new InvalidFieldValueException("DISEntityTypeMapping kind newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 255) {
            throw new InvalidFieldValueException("DISEntityTypeMapping kind newValue=" + SFInt32.toString(newValue) + " has component value greater than restriction maxInclusive=255");
        }
        this.kind = newValue;
        return this;
    }

    public DISEntityTypeMapping setKind(SFInt32 newValue) {
        this.setKind(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public boolean getLoad() {
        return this.load;
    }

    @Override
    public DISEntityTypeMapping setLoad(boolean newValue) {
        this.load = newValue;
        return this;
    }

    public DISEntityTypeMapping setLoad(SFBool newValue) {
        this.setLoad(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public DISEntityTypeMapping setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
            if (this.metadata instanceof MetadataSet) {
                ((X3DConcreteNode)((Object)this.metadata)).setContainerFieldOverride("metadata");
            }
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public DISEntityTypeMapping clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public DISEntityTypeMapping setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public int getSpecific() {
        return this.specific;
    }

    @Override
    public DISEntityTypeMapping setSpecific(int newValue) {
        if (newValue < 0) {
            throw new InvalidFieldValueException("DISEntityTypeMapping specific newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 255) {
            throw new InvalidFieldValueException("DISEntityTypeMapping specific newValue=" + SFInt32.toString(newValue) + " has component value greater than restriction maxInclusive=255");
        }
        this.specific = newValue;
        return this;
    }

    public DISEntityTypeMapping setSpecific(SFInt32 newValue) {
        this.setSpecific(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public int getSubcategory() {
        return this.subcategory;
    }

    @Override
    public DISEntityTypeMapping setSubcategory(int newValue) {
        if (newValue < 0) {
            throw new InvalidFieldValueException("DISEntityTypeMapping subcategory newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 255) {
            throw new InvalidFieldValueException("DISEntityTypeMapping subcategory newValue=" + SFInt32.toString(newValue) + " has component value greater than restriction maxInclusive=255");
        }
        this.subcategory = newValue;
        return this;
    }

    public DISEntityTypeMapping setSubcategory(SFInt32 newValue) {
        this.setSubcategory(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String[] getUrl() {
        String[] valuesArray = new String[this.url.size()];
        int i = 0;
        for (String arrayElement : this.url) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<String> getUrlList() {
        return this.url;
    }

    public String getUrlString() {
        StringBuilder result = new StringBuilder();
        for (String arrayElement : this.url) {
            result.append("\"");
            result.append(arrayElement);
            result.append("\"");
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public DISEntityTypeMapping setUrl(String[] newValue) {
        if (newValue == null) {
            this.clearUrl();
            return this;
        }
        this.clearUrl();
        for (int i = 0; i < newValue.length; ++i) {
            this.url.add(newValue[i]);
        }
        return this;
    }

    public DISEntityTypeMapping setUrl(MFString newValue) {
        if (newValue == null) {
            this.clearUrl();
            return this;
        }
        this.setUrl(newValue.getPrimitiveValue());
        return this;
    }

    public DISEntityTypeMapping setUrl(SFString newValue) {
        if (newValue == null) {
            this.clearUrl();
            return this;
        }
        if (newValue.getValue().length() - newValue.getValue().replace("\"", DESCRIPTION_DEFAULT_VALUE).length() > 2) {
            return this.setUrl(new MFString(newValue));
        }
        this.setUrl(newValue.getValue());
        return this;
    }

    public DISEntityTypeMapping setUrl(String newValue) {
        if (newValue == null) {
            this.clearUrl();
            return this;
        }
        if (newValue.length() - newValue.replace("\"", DESCRIPTION_DEFAULT_VALUE).length() > 2) {
            return this.setUrl(new MFString(newValue));
        }
        this.clearUrl();
        this.url.add(newValue);
        return this;
    }

    public DISEntityTypeMapping setUrl(ArrayList<String> newValue) {
        if (newValue == null) {
            this.clearUrl();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearUrl();
        } else {
            String[] newArray = new String[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setUrl(newArray);
        }
        return this;
    }

    public DISEntityTypeMapping clearUrl() {
        this.url.clear();
        return this;
    }

    public DISEntityTypeMapping addUrl(String newValue) {
        if (newValue == null) {
            return this;
        }
        if (!(newValue = MFString.cleanupEnumerationValue(newValue)).isEmpty() && !this.url.contains(newValue)) {
            this.url.add(newValue);
        }
        return this;
    }

    public DISEntityTypeMapping addUrl(SFString newValue) {
        if (newValue == null) {
            return this;
        }
        newValue.setValue(MFString.cleanupEnumerationValue(newValue.getValue()));
        if (!newValue.getValue().isEmpty() && !this.url.contains(newValue.getValue())) {
            this.url.add(newValue.getValue());
        }
        return this;
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final DISEntityTypeMapping setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("DISEntityTypeMapping DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE(DESCRIPTION_DEFAULT_VALUE);
        this.setConcreteDEF(newValue);
        return this;
    }

    public DISEntityTypeMapping setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final DISEntityTypeMapping setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("DISEntityTypeMapping USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF(DESCRIPTION_DEFAULT_VALUE);
        this.setConcreteUSE(newValue);
        return this;
    }

    public DISEntityTypeMapping setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final DISEntityTypeMapping setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public DISEntityTypeMapping setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getHtmlID() {
        return super.getHtmlID();
    }

    @Override
    public final DISEntityTypeMapping setHtmlID(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteHtmlID(newValue);
        return this;
    }

    public DISEntityTypeMapping setHtmlID(SFString newValue) {
        this.setHtmlID(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    @Override
    public final DISEntityTypeMapping setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public DISEntityTypeMapping setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    public DISEntityTypeMapping setUSE(DISEntityTypeMapping DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "setUSE(DEFnode) invoked on DISEntityTypeMapping that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public DISEntityTypeMapping(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    @Override
    public DISEntityTypeMapping addComments(String newComment) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(\"" + newComment + "\")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public DISEntityTypeMapping addComments(String[] newComments) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(" + Arrays.toString(newComments) + ")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public DISEntityTypeMapping addComments(CommentsBlock newCommentsBlock) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(CommentsBlock) cannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasChild = false;
        }
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<DISEntityTypeMapping");
        if (hasAttributes) {
            if (!this.getDEF().equals(DESCRIPTION_DEFAULT_VALUE) && !this.hasUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals(DESCRIPTION_DEFAULT_VALUE)) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isEmpty() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(this.getAutoRefresh() == 0.0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" autoRefresh='").append(SFTime.toString(this.getAutoRefresh())).append("'");
            }
            if (!(this.getAutoRefreshTimeLimit() == 3600.0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" autoRefreshTimeLimit='").append(SFTime.toString(this.getAutoRefreshTimeLimit())).append("'");
            }
            if (!(this.getCategory() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" category='").append(SFInt32.toString(this.getCategory())).append("'");
            }
            if (!(this.getCssClass().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(this.getCountry() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" country='").append(SFInt32.toString(this.getCountry())).append("'");
            }
            if (!(this.getDescription().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" description='").append(new SFString(this.getDescription()).toStringX3D()).append("'");
            }
            if (!(this.getDomain() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" domain='").append(SFInt32.toString(this.getDomain())).append("'");
            }
            if (!(this.getExtra() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" extra='").append(SFInt32.toString(this.getExtra())).append("'");
            }
            if (!(this.getHtmlID().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlID()).toStringX3D()).append("'");
            }
            if (!(this.getKind() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" kind='").append(SFInt32.toString(this.getKind())).append("'");
            }
            if (!(this.getLoad() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" load='").append(SFBool.toString(this.getLoad())).append("'");
            }
            if (!(this.getSpecific() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" specific='").append(SFInt32.toString(this.getSpecific())).append("'");
            }
            if (!(this.getCssStyle().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
            if (!(this.getSubcategory() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" subcategory='").append(SFInt32.toString(this.getSubcategory())).append("'");
            }
            if (!(this.getUrl().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" url='").append(new MFString(this.getUrl()).toStringX3D()).append("'");
            }
        }
        if (hasChild && !this.hasUSE()) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</DISEntityTypeMapping>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals(DESCRIPTION_DEFAULT_VALUE)) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals(DESCRIPTION_DEFAULT_VALUE)) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("autoRefresh")) continue;
                        stringClassicVRML.append(indentCharacter).append("autoRefresh").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getAutoRefresh() != 0.0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("autoRefresh ").append(SFTime.toString(this.getAutoRefresh())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("autoRefreshTimeLimit")) continue;
                        stringClassicVRML.append(indentCharacter).append("autoRefreshTimeLimit").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getAutoRefreshTimeLimit() != 3600.0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("autoRefreshTimeLimit ").append(SFTime.toString(this.getAutoRefreshTimeLimit())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("category")) continue;
                        stringClassicVRML.append(indentCharacter).append("category").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getCategory() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("category ").append(SFInt32.toString(this.getCategory())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("country")) continue;
                        stringClassicVRML.append(indentCharacter).append("country").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getCountry() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("country ").append(SFInt32.toString(this.getCountry())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("description")) continue;
                        stringClassicVRML.append(indentCharacter).append("description").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("description ").append("\"").append(SFString.toString(this.getDescription())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("domain")) continue;
                        stringClassicVRML.append(indentCharacter).append("domain").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getDomain() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("domain ").append(SFInt32.toString(this.getDomain())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("extra")) continue;
                        stringClassicVRML.append(indentCharacter).append("extra").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getExtra() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("extra ").append(SFInt32.toString(this.getExtra())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("id")) continue;
                        stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getHtmlID().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(this.getHtmlID())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("kind")) continue;
                        stringClassicVRML.append(indentCharacter).append("kind").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getKind() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("kind ").append(SFInt32.toString(this.getKind())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("load")) continue;
                        stringClassicVRML.append(indentCharacter).append("load").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getLoad() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("load ").append(SFBool.toString(this.getLoad())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("specific")) continue;
                        stringClassicVRML.append(indentCharacter).append("specific").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getSpecific() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("specific ").append(SFInt32.toString(this.getSpecific())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("style")) continue;
                        stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssStyle().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(this.getCssStyle())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("subcategory")) continue;
                        stringClassicVRML.append(indentCharacter).append("subcategory").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getSubcategory() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("subcategory ").append(SFInt32.toString(this.getSubcategory())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("url")) continue;
                        stringClassicVRML.append(indentCharacter).append("url").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getUrl().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("url ").append("[ ").append(MFString.toString(this.getUrl())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (hasAttributes || hasChild) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, DESCRIPTION_DEFAULT_VALUE);
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setAutoRefresh(this.getAutoRefresh());
        this.setAutoRefreshTimeLimit(this.getAutoRefreshTimeLimit());
        this.setCategory(this.getCategory());
        this.setCountry(this.getCountry());
        this.setDescription(this.getDescription());
        this.setDomain(this.getDomain());
        this.setExtra(this.getExtra());
        this.setKind(this.getKind());
        this.setLoad(this.getLoad());
        this.setSpecific(this.getSpecific());
        this.setSubcategory(this.getSubcategory());
        this.setUrl(this.getUrl());
        if (!this.hasUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.hasUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        this.setHtmlID(this.getHtmlID());
        this.setCssStyle(this.getCssStyle());
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.hasUSE() && this.hasIS()) {
            String errorNotice = "DISEntityTypeMapping USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "DISEntityTypeMapping USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.hasUSE() && this.hasMetadata()) {
            String errorNotice = "DISEntityTypeMapping USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "DISEntityTypeMapping USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            String errorNotice = "IS statement present, but contains no connect statements";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidProtoException(errorNotice);
        }
        if (!this.getContainerFieldOverride().isEmpty() && !Arrays.asList(this.containerField_ALTERNATE_VALUES).contains(this.getContainerFieldOverride())) {
            String errorNotice = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALTERNATE_VALUES='" + new MFString(this.containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        if (this.findAncestorX3D() != null) {
            boolean hasSatisfactorySupport;
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean bl = hasSatisfactorySupport = this.findAncestorX3D().supportsX3dProfile(modelProfile) || this.findAncestorX3D().supportsX3dComponent(COMPONENT, 2);
            if (!hasSatisfactorySupport) {
                String errorNotice = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for current X3D model containing 'DISEntityTypeMapping' node, ensure sufficient support by adding head statement <component name='DIS' level='2'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"DIS\").setLevel(2);";
                this.validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldException(errorNotice);
            }
        }
        return this.validationResult.toString();
    }
}

