/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Core;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.X3DConcreteStatement;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class meta
extends X3DConcreteStatement {
    private ArrayList<String> commentsList;
    private String content = new String();
    private String dir = new String();
    private String http_equiv = new String();
    private String lang = new String();
    private String name = new String();
    private String scheme = new String();
    static boolean dirWarningAlreadyProvided = false;
    public static final String DIR_RTL = "rtl";
    public static final String DIR_LTR = "ltr";
    static boolean nameWarningAlreadyProvided = false;
    public static final String NAME_ACCESSRIGHTS = "accessRights";
    public static final String NAME_AUTHOR = "author";
    public static final String NAME_CML_VERSION = "CML-version";
    public static final String NAME_CONTRIBUTOR = "contributor";
    public static final String NAME_CREATED = "created";
    public static final String NAME_CREATOR = "creator";
    public static final String NAME_DESCRIPTION = "description";
    public static final String NAME_DISCLAIMER = "disclaimer";
    public static final String NAME_DRAWING = "drawing";
    public static final String NAME_ERROR = "error";
    public static final String NAME_GENERATOR = "generator";
    public static final String NAME_HINT = "hint";
    public static final String NAME_IDENTIFIER = "identifier";
    public static final String NAME_IMAGE = "Image";
    public static final String NAME_INFO = "info";
    public static final String NAME_INFORMATION = "information";
    public static final String NAME_ISVERSIONOF = "isVersionOf";
    public static final String NAME_KEYWORDS = "keywords";
    public static final String NAME_LICENSE = "license";
    public static final String NAME_MEDIATOR = "mediator";
    public static final String NAME_MODIFIED = "modified";
    public static final String NAME_MOVIE = "movie";
    public static final String NAME_MOVINGIMAGE = "MovingImage";
    public static final String NAME_ORIGINAL = "original";
    public static final String NAME_PHOTO = "photo";
    public static final String NAME_PHOTOGRAPH = "photograph";
    public static final String NAME_PUBLISHER = "publisher";
    public static final String NAME_REFERENCE = "reference";
    public static final String NAME_REQUIRES = "requires";
    public static final String NAME_RIGHTS = "rights";
    public static final String NAME_ROBOTS = "robots";
    public static final String NAME_SOUND = "Sound";
    public static final String NAME_SOURCE = "source";
    public static final String NAME_SPECIFICATIONSECTION = "specificationSection";
    public static final String NAME_SPECIFICATIONURL = "specificationUrl";
    public static final String NAME_SUBJECT = "subject";
    public static final String NAME_TEXT = "Text";
    public static final String NAME_TITLE = "title";
    public static final String NAME_TODO = "TODO";
    public static final String NAME_TRANSLATOR = "translator";
    public static final String NAME_TRANSLATED = "translated";
    public static final String NAME_VERSION = "version";
    public static final String NAME_WARNING = "warning";
    public static final String NAME = "meta";
    public static final String COMPONENT = "Core";
    public static final int LEVEL = 1;
    public static final String CONTENT_DEFAULT_VALUE = "";
    public static final String DIR_DEFAULT_VALUE = "";
    public static final String HTTP_EQUIV_DEFAULT_VALUE = "";
    public static final String LANG_DEFAULT_VALUE = "";
    public static final String NAME_DEFAULT_VALUE = "";
    public static final String SCHEME_DEFAULT_VALUE = "";
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 1;
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case "class" -> "SFString";
            case "content" -> "SFString";
            case "dir" -> "SFString";
            case "http_equiv" -> "SFString";
            case "id" -> "SFString";
            case "lang" -> "SFString";
            case "name" -> "SFString";
            case "scheme" -> "SFString";
            case "style" -> "SFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case "class" -> "inputOutput";
            case "content" -> "inputOutput";
            case "dir" -> "inputOutput";
            case "http_equiv" -> "inputOutput";
            case "id" -> "inputOutput";
            case "lang" -> "inputOutput";
            case "name" -> "inputOutput";
            case "scheme" -> "inputOutput";
            case "style" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    public meta() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.content = "";
        this.dir = "";
        this.http_equiv = "";
        this.lang = "";
        this.name = "";
        this.scheme = "";
        this.commentsList = new ArrayList();
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    public final meta setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public meta setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public final meta setContent(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.content = newValue;
        return this;
    }

    public meta setContent(SFString newValue) {
        this.setContent(newValue.getPrimitiveValue());
        return this;
    }

    public String getDir() {
        return this.dir;
    }

    public meta setDir(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!((newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue)).isEmpty() || newValue.toString().replace("\"", "").equals(DIR_RTL) || newValue.toString().replace("\"", "").equals(DIR_LTR))) {
            String warningMessage = "[warning] meta dir newValue='" + newValue + "' includes an unrecognized optional value not matching any of the required enumeration string tokens.";
            if (!dirWarningAlreadyProvided) {
                warningMessage = warningMessage + "\n      Supported values are rtl, ltr";
                dirWarningAlreadyProvided = true;
            }
            if (ConfigurationProperties.isConsoleOutputVerbose()) {
                System.out.println(warningMessage);
            }
            if (!newValue.isEmpty()) {
                throw new InvalidFieldValueException(warningMessage);
            }
        }
        if (newValue == null) {
            newValue = new String();
        }
        this.dir = newValue;
        return this;
    }

    public meta setDir(SFString newValue) {
        this.setDir(newValue.getPrimitiveValue());
        return this;
    }

    public String getHttp_equiv() {
        return this.http_equiv;
    }

    public meta setHttp_equiv(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.http_equiv = newValue;
        return this;
    }

    public meta setHttp_equiv(SFString newValue) {
        this.setHttp_equiv(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getHtmlID() {
        return super.getHtmlID();
    }

    public final meta setHtmlID(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteHtmlID(newValue);
        return this;
    }

    public meta setHtmlID(SFString newValue) {
        this.setHtmlID(newValue.getPrimitiveValue());
        return this;
    }

    public String getLang() {
        return this.lang;
    }

    public meta setLang(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.lang = newValue;
        return this;
    }

    public meta setLang(SFString newValue) {
        this.setLang(newValue.getPrimitiveValue());
        return this;
    }

    public String getName() {
        return this.name;
    }

    public final meta setName(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!((newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue)).isEmpty() || newValue.toString().replace("\"", "").equals(NAME_ACCESSRIGHTS) || newValue.toString().replace("\"", "").equals(NAME_AUTHOR) || newValue.toString().replace("\"", "").equals(NAME_CML_VERSION) || newValue.toString().replace("\"", "").equals(NAME_CONTRIBUTOR) || newValue.toString().replace("\"", "").equals(NAME_CREATED) || newValue.toString().replace("\"", "").equals(NAME_CREATOR) || newValue.toString().replace("\"", "").equals(NAME_DESCRIPTION) || newValue.toString().replace("\"", "").equals(NAME_DISCLAIMER) || newValue.toString().replace("\"", "").equals(NAME_DRAWING) || newValue.toString().replace("\"", "").equals(NAME_ERROR) || newValue.toString().replace("\"", "").equals(NAME_GENERATOR) || newValue.toString().replace("\"", "").equals(NAME_HINT) || newValue.toString().replace("\"", "").equals(NAME_IDENTIFIER) || newValue.toString().replace("\"", "").equals(NAME_IMAGE) || newValue.toString().replace("\"", "").equals(NAME_INFO) || newValue.toString().replace("\"", "").equals(NAME_INFORMATION) || newValue.toString().replace("\"", "").equals(NAME_ISVERSIONOF) || newValue.toString().replace("\"", "").equals(NAME_KEYWORDS) || newValue.toString().replace("\"", "").equals(NAME_LICENSE) || newValue.toString().replace("\"", "").equals(NAME_MEDIATOR) || newValue.toString().replace("\"", "").equals(NAME_MODIFIED) || newValue.toString().replace("\"", "").equals(NAME_MOVIE) || newValue.toString().replace("\"", "").equals(NAME_MOVINGIMAGE) || newValue.toString().replace("\"", "").equals(NAME_ORIGINAL) || newValue.toString().replace("\"", "").equals(NAME_PHOTO) || newValue.toString().replace("\"", "").equals(NAME_PHOTOGRAPH) || newValue.toString().replace("\"", "").equals(NAME_PUBLISHER) || newValue.toString().replace("\"", "").equals(NAME_REFERENCE) || newValue.toString().replace("\"", "").equals(NAME_REQUIRES) || newValue.toString().replace("\"", "").equals(NAME_RIGHTS) || newValue.toString().replace("\"", "").equals(NAME_ROBOTS) || newValue.toString().replace("\"", "").equals(NAME_SOUND) || newValue.toString().replace("\"", "").equals(NAME_SOURCE) || newValue.toString().replace("\"", "").equals(NAME_SPECIFICATIONSECTION) || newValue.toString().replace("\"", "").equals(NAME_SPECIFICATIONURL) || newValue.toString().replace("\"", "").equals(NAME_SUBJECT) || newValue.toString().replace("\"", "").equals(NAME_TEXT) || newValue.toString().replace("\"", "").equals(NAME_TITLE) || newValue.toString().replace("\"", "").equals(NAME_TODO) || newValue.toString().replace("\"", "").equals(NAME_TRANSLATOR) || newValue.toString().replace("\"", "").equals(NAME_TRANSLATED) || newValue.toString().replace("\"", "").equals(NAME_VERSION) || newValue.toString().replace("\"", "").equals(NAME_WARNING))) {
            String warningMessage = "[info] meta name newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
            if (!nameWarningAlreadyProvided) {
                warningMessage = warningMessage + "\n      Supported values are accessRights, author, CML-version, contributor, created, creator, description, disclaimer, drawing, error, generator, hint, identifier, Image, info, information, isVersionOf, keywords, license, mediator, modified, movie, MovingImage, original, photo, photograph, publisher, reference, requires, rights, robots, Sound, source, specificationSection, specificationUrl, subject, Text, title, TODO, translator, translated, version, warning";
                nameWarningAlreadyProvided = true;
            }
            if (newValue.equalsIgnoreCase("permissions")) {
                warningMessage = warningMessage + " Suggested meta term: name='accessRights'";
            } else if (newValue.equalsIgnoreCase("audio") || newValue.equalsIgnoreCase("midi") || newValue.equalsIgnoreCase("sounds")) {
                warningMessage = warningMessage + " Suggested meta term: name='Sound'";
            } else if (newValue.equalsIgnoreCase("generated") || newValue.equalsIgnoreCase("imported")) {
                warningMessage = warningMessage + " Suggested meta term: name='created'";
            } else if (newValue.equalsIgnoreCase("organization")) {
                warningMessage = warningMessage + " Suggested meta term: name='contributor'";
            } else if (newValue.equalsIgnoreCase("comment")) {
                warningMessage = warningMessage + " Suggested meta term: name='hint' or name='info'";
            } else if (newValue.toLowerCase().startsWith("revised") || newValue.equalsIgnoreCase("revision")) {
                warningMessage = warningMessage + " Suggested meta term: name='modified' or name='contributor'";
            } else if (newValue.toLowerCase().startsWith("film") || newValue.toLowerCase().startsWith(NAME_MOVIE) || newValue.equalsIgnoreCase("video")) {
                warningMessage = warningMessage + " Suggested meta term: name='MovingImage'";
            } else if (newValue.toLowerCase().equalsIgnoreCase("diagram") || newValue.equalsIgnoreCase("painting") || newValue.equalsIgnoreCase("picture") || newValue.toLowerCase().contains("texture")) {
                warningMessage = warningMessage + " Suggested meta term: name='Image'";
            } else if (newValue.equalsIgnoreCase("documentation") || newValue.equalsIgnoreCase("example") || newValue.equalsIgnoreCase("resource")) {
                warningMessage = warningMessage + " Suggested meta term: name='reference'";
            } else if (newValue.equalsIgnoreCase("name") || newValue.equalsIgnoreCase("filename")) {
                warningMessage = warningMessage + " Suggested meta term: name='title'";
            } else if (newValue.trim().toUpperCase().startsWith("TODO ")) {
                warningMessage = warningMessage + " Suggested meta term: name='TODO' with additional information '" + newValue.trim().substring(5) + "' moved into content attribute";
            } else if (!newValue.equals(NAME_TODO) && newValue.toUpperCase().equals(NAME_TODO)) {
                warningMessage = warningMessage + " Suggested meta term: name='TODO'";
            }
            if (newValue.contains("[") || newValue.contains("]")) {
                warningMessage = warningMessage + " Avoid [square brackets] in name value.";
            }
            if (newValue.contains("(") || newValue.contains(")")) {
                warningMessage = warningMessage + " Avoid (parentheses) in name value.";
            }
            if (newValue.contains("'")) {
                warningMessage = warningMessage + " Avoid 'apostrophes' in name value.";
            }
            if (newValue.contains("\"")) {
                warningMessage = warningMessage + " Avoid \"quotation marks\" in name value.";
            }
            if (ConfigurationProperties.isConsoleOutputVerbose()) {
                System.out.println(warningMessage);
            }
        }
        if (newValue == null) {
            newValue = new String();
        }
        if (!SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("meta name newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        if (!newValue.equals(NAME_SOUND) && !newValue.equals(NAME_TEXT) && !SFString.meetsX3dInteroperabilityNamingConventions(newValue) && ConfigurationProperties.isConsoleOutputVerbose()) {
            System.out.println("[warning] meta name newValue='" + newValue + "' has name value that does not meet X3D naming conventions.");
        }
        this.name = newValue;
        return this;
    }

    public meta setName(SFString newValue) {
        this.setName(newValue.getPrimitiveValue());
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public meta setScheme(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.scheme = newValue;
        return this;
    }

    public meta setScheme(SFString newValue) {
        this.setScheme(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    public final meta setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public meta setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    public meta(String newName, String newContent) {
        this.initialize();
        this.setName(newName);
        this.setContent(newContent);
    }

    @Override
    public meta addComments(String newComment) {
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public meta addComments(String[] newComments) {
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public meta addComments(CommentsBlock newCommentsBlock) {
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasAttributes = true;
        boolean hasChild = !this.commentsList.isEmpty();
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<meta");
        if (hasAttributes) {
            if (!this.getCssClass().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!this.getContent().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" content='").append(new SFString(this.getContent()).toStringX3D()).append("'");
            }
            if (!this.getDir().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" dir='").append(new SFString(this.getDir()).toStringX3D()).append("'");
            }
            if (!this.getHttp_equiv().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" http_equiv='").append(new SFString(this.getHttp_equiv()).toStringX3D()).append("'");
            }
            if (!this.getHtmlID().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlID()).toStringX3D()).append("'");
            }
            if (!this.getLang().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" lang='").append(new SFString(this.getLang()).toStringX3D()).append("'");
            }
            if (!this.getName().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" name='").append(new SFString(this.getName()).toStringX3D()).append("'");
            }
            if (!this.getScheme().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" scheme='").append(new SFString(this.getScheme()).toStringX3D()).append("'");
            }
            if (!this.getCssStyle().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
        }
        if (hasChild) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</meta>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = !this.commentsList.isEmpty();
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        stringClassicVRML.append("META \"").append(this.name).append("\" \"").append(this.content).append("\"").append("\n");
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result.replaceAll("META ", "#META ");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (elementName == null) {
            elementName = "";
        }
        if (this.getName().equals(nameValue) && (elementName.isEmpty() || elementName.equals(this.getElementName()))) {
            return this;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setCssClass(this.getCssClass());
        if (this.getContent().isEmpty()) {
            Object errorNotice = "ERROR_VALUE_NOT_FOUND, meta content field is required but no value found. ";
            errorNotice = (String)errorNotice + "(meta name='" + this.getName() + "')";
            this.validationResult.append((String)errorNotice).append("\n");
            throw new InvalidFieldValueException((String)errorNotice);
        }
        this.setContent(this.getContent());
        this.setDir(this.getDir());
        this.setHttp_equiv(this.getHttp_equiv());
        this.setHtmlID(this.getHtmlID());
        this.setLang(this.getLang());
        if (this.getName().isEmpty()) {
            String errorNotice = "ERROR_VALUE_NOT_FOUND, meta name field is required but no value found. ";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setName(this.getName());
        this.setScheme(this.getScheme());
        this.setCssStyle(this.getCssStyle());
        Object warningMessage = new String();
        if (this.getName().contains("\"")) {
            warningMessage = (String)warningMessage + "WARNING:avoid quotes in name, <meta name='" + this.getName() + "' content='" + this.getContent() + "'/>";
        }
        if (this.getContent().startsWith("\"") && this.getContent().endsWith("\"")) {
            warningMessage = (String)warningMessage + "WARNING:avoid quoting content value, <meta name='" + this.getName() + "' content='" + this.getContent() + "'/>";
        }
        if (!this.getName().isBlank() && !this.getContent().isBlank()) {
            if ((this.getName().equalsIgnoreCase(NAME_TITLE) || this.getName().equalsIgnoreCase("filename") || this.getName().equalsIgnoreCase("name")) && (SFString.isX3dNodeName(this.getContent()) || SFString.isX3dNodeName(this.getContent().substring(0, this.getContent().lastIndexOf("."))))) {
                warningMessage = (String)warningMessage + "WARNING:avoid duplicating a built-in X3D node name as model title, <meta name='" + this.getName() + "' content='" + this.getContent() + "'/>";
            }
            if ((this.getName().equalsIgnoreCase(NAME_TITLE) || this.getName().equalsIgnoreCase("filename") || this.getName().equalsIgnoreCase("name")) && (SFString.isX3dStatementName(this.getContent()) || SFString.isX3dStatementName(this.getContent().substring(0, this.getContent().lastIndexOf("."))))) {
                warningMessage = (String)warningMessage + "WARNING:avoid duplicating a built-in X3D statement name as model title, <meta name='" + this.getName() + "' content='" + this.getContent() + "'/>";
            }
        }
        if (!(this.getName().equals(NAME_ERROR) || this.getName().equals(NAME_HINT) || this.getName().equals(NAME_INFO) || this.getName().equals(NAME_INFORMATION) || this.getName().equals(NAME_WARNING) || ((String)warningMessage).isBlank())) {
            System.out.println();
            System.out.print((String)warningMessage);
        }
        return this.validationResult.toString();
    }
}

