/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Core;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.ProtoDeclare;
import org.web3d.x3d.jsail.Core.field;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.X3DConcreteStatement;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class ProtoInterface
extends X3DConcreteStatement {
    private ArrayList<String> commentsList;
    private ArrayList<field> fieldList = new ArrayList();
    public static final String NAME = "ProtoInterface";
    public static final String COMPONENT = "Core";
    public static final int LEVEL = 2;
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 2;
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case "class" -> "SFString";
            case "field" -> "MFNode";
            case "id" -> "SFString";
            case "style" -> "SFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case "class" -> "inputOutput";
            case "field" -> "inputOutput";
            case "id" -> "inputOutput";
            case "style" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    public ProtoInterface() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.fieldList = new ArrayList();
        this.commentsList = new ArrayList();
        this.fieldList = new ArrayList();
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    public final ProtoInterface setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public ProtoInterface setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    public ArrayList<field> getFieldList() {
        return this.fieldList;
    }

    public ProtoInterface setFieldList(ArrayList<field> newValue) {
        this.fieldList = newValue;
        for (field arrayElement : this.fieldList) {
            arrayElement.setParent(this);
        }
        return this;
    }

    public ProtoInterface setField(field newValue) {
        if (newValue == null) {
            this.clearField();
            return this;
        }
        for (field element : this.fieldList) {
            element.clearParent();
        }
        this.clearField();
        this.fieldList.add(newValue);
        newValue.setParent(this);
        return this;
    }

    public ProtoInterface clearField() {
        for (field element : this.fieldList) {
            element.clearParent();
        }
        this.fieldList.clear();
        return this;
    }

    public boolean hasField() {
        return !this.fieldList.isEmpty();
    }

    @Override
    public String getHtmlID() {
        return super.getHtmlID();
    }

    public final ProtoInterface setHtmlID(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteHtmlID(newValue);
        return this;
    }

    public ProtoInterface setHtmlID(SFString newValue) {
        this.setHtmlID(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    public final ProtoInterface setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public ProtoInterface setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public ProtoInterface addComments(String newComment) {
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public ProtoInterface addComments(String[] newComments) {
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public ProtoInterface addComments(CommentsBlock newCommentsBlock) {
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasAttributes = true;
        boolean hasChild = !this.fieldList.isEmpty() || !this.commentsList.isEmpty();
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<ProtoInterface");
        if (hasAttributes) {
            if (!this.getCssClass().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!this.getHtmlID().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlID()).toStringX3D()).append("'");
            }
            if (!this.getCssStyle().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
        }
        if (hasChild) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            for (field element : this.fieldList) {
                stringX3D.append(((X3DConcreteElement)element).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</ProtoInterface>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = !this.fieldList.isEmpty() || !this.commentsList.isEmpty();
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        stringClassicVRML.append("# ProtoInterface");
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        for (field element : this.fieldList) {
            X3DConcreteElement referenceElement;
            if (!(element instanceof X3DConcreteElement) || (referenceElement = ((X3DConcreteElement)element).findElementByNameValue(nameValue, elementName)) == null) continue;
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setCssClass(this.getCssClass());
        this.setHtmlID(this.getHtmlID());
        this.setCssStyle(this.getCssStyle());
        for (field element : this.fieldList) {
            try {
                ((X3DConcreteElement)element).validate();
                this.validationResult.append(element.getValidationResult());
            }
            catch (Exception e) {
                String exceptionMessage = "[exception] during validation: " + e.getMessage();
                this.validationResult.append(exceptionMessage);
                e.printStackTrace();
            }
        }
        this.setFieldList(this.getFieldList());
        return this.validationResult.toString();
    }

    public ProtoInterface addField(field newField) {
        String errorNotice = "Illegal addField() invocation for ProtoInterface  name='" + this.getName() + "', ";
        if (newField == null) {
            errorNotice = errorNotice + "provided null field";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        for (field priorField : this.fieldList) {
            if (!priorField.getName().equals(newField.getName())) continue;
            errorNotice = errorNotice + "trying to add field with duplicate name='" + newField.getName() + "'";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        String fieldValidationResult = newField.validate();
        if (!fieldValidationResult.trim().isEmpty()) {
            errorNotice = errorNotice + "newField.validation() failure: " + fieldValidationResult;
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        this.fieldList.add(newField);
        newField.setParent(this);
        return this;
    }

    public field findFieldByName(String fieldName) {
        for (field element : this.fieldList) {
            if (!element.getName().equalsIgnoreCase(fieldName)) continue;
            return element;
        }
        return null;
    }

    public boolean removeField(field fieldToRemove) {
        String errorNotice = "Illegal removeField() invocation for ProtoInterface parent ProtoDeclare name='" + this.getName() + "', ";
        if (fieldToRemove == null) {
            errorNotice = errorNotice + "provided null field";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        int fieldIndex = this.fieldList.indexOf(fieldToRemove);
        if (fieldIndex >= 0) {
            field removedField = this.fieldList.remove(fieldIndex);
            return removedField != null;
        }
        return false;
    }

    public boolean removeField(String fieldName) {
        String errorNotice = "Illegal removeField() invocation for ProtoInterface parent ProtoDeclare name='" + this.getName() + "', ";
        if (fieldName == null || fieldName.isEmpty()) {
            errorNotice = errorNotice + "provided null or empty fieldName string";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        field fieldToRemove = this.findFieldByName(fieldName);
        if (fieldToRemove != null) {
            return this.removeField(fieldToRemove);
        }
        return false;
    }

    public void clearFields() {
        this.fieldList.clear();
    }

    public boolean hasField(String fieldName) {
        return this.findFieldByName(fieldName) != null;
    }

    public String getName() {
        if (this.getParent() != null) {
            return ((ProtoDeclare)this.getParent()).getName();
        }
        return "ERROR_NOT_CONNECTED_TO_SCENE_GRAPH: " + this.getElementName() + "Object has no parent ProtoDeclare, thus getName() cannot be checked.";
    }
}

