/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Core;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.ProtoDeclare;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.X3DConcreteStatement;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.sai.Core.X3DNode;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class ProtoBody
extends X3DConcreteStatement {
    private ArrayList<X3DNode> children = new ArrayList();
    private X3DConcreteNode primaryNode;
    public static final String NAME = "ProtoBody";
    public static final String COMPONENT = "Core";
    public static final int LEVEL = 2;
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 2;
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case "children" -> "MFNode";
            case "class" -> "SFString";
            case "id" -> "SFString";
            case "style" -> "SFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case "children" -> "inputOutput";
            case "class" -> "inputOutput";
            case "id" -> "inputOutput";
            case "style" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    public ProtoBody() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.children = new ArrayList();
    }

    public ArrayList<X3DNode> getChildren() {
        return this.children;
    }

    public ProtoBody setChildren(ArrayList<X3DNode> newValue) {
        if (this.primaryNode != null) {
            this.primaryNode.setParent(null);
            this.primaryNode = null;
        }
        this.children = newValue;
        for (X3DNode arrayElement : this.children) {
            if (this.primaryNode == null && arrayElement instanceof X3DConcreteNode) {
                this.primaryNode = (X3DConcreteNode)((Object)arrayElement);
                this.primaryNode.setParent(this);
            }
            ((X3DConcreteElement)((Object)arrayElement)).setParent(this);
        }
        return this;
    }

    public void addChildren(X3DNode newValue) {
        if (newValue == null) {
            return;
        }
        this.children.add(newValue);
        ((X3DConcreteElement)((Object)newValue)).setParent(this);
        if (this.primaryNode == null && newValue instanceof X3DConcreteNode) {
            this.primaryNode = (X3DConcreteNode)((Object)newValue);
            this.primaryNode.setParent(this);
        }
    }

    public ProtoBody addChildren(ProtoInstance newValue) {
        if (newValue == null) {
            return this;
        }
        this.children.add(newValue);
        newValue.setParent(this);
        return this;
    }

    public ProtoBody addChild(X3DNode newValue) {
        if (newValue == null) {
            return this;
        }
        if (this.primaryNode == null && newValue instanceof X3DConcreteNode) {
            this.primaryNode = (X3DConcreteNode)((Object)newValue);
            this.primaryNode.setParent(this);
        }
        this.children.add(newValue);
        ((X3DConcreteElement)((Object)newValue)).setParent(this);
        return this;
    }

    public void addChildren(X3DNode[] newValue) {
        if (newValue == null) {
            return;
        }
        for (int i = 0; i < newValue.length; ++i) {
            if (this.primaryNode == null && newValue[i] instanceof X3DConcreteNode) {
                this.primaryNode = (X3DConcreteNode)((Object)newValue[i]);
                this.primaryNode.setParent(this);
            }
            if (newValue[i] instanceof X3DNode || newValue[i] instanceof ProtoInstance) {
                this.children.add(newValue[i]);
                ((X3DConcreteElement)((Object)newValue[i])).setParent(this);
                if (!(newValue[i] instanceof ProtoInstance)) continue;
                ((ProtoInstance)newValue[i]).setContainerField("children");
                continue;
            }
            throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue[" + i + "] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance, array newValue=" + Arrays.toString(newValue));
        }
    }

    public ProtoBody setChildren(X3DNode newValue) {
        if (newValue == null && this.primaryNode != null) {
            this.primaryNode.setParent(null);
            this.primaryNode = null;
        }
        if (newValue == null) {
            this.clearChildren();
            return this;
        }
        if (newValue instanceof X3DNode) {
            for (X3DNode element : this.children) {
                ((X3DConcreteElement)((Object)element)).clearParent();
            }
            this.clearChildren();
            ((X3DConcreteElement)((Object)newValue)).setParent(this);
            if (newValue instanceof X3DConcreteNode && this.primaryNode == null) {
                this.primaryNode = (X3DConcreteNode)((Object)newValue);
            }
        } else {
            throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode newValue is not instanceof org.web3d.x3d.sai.Core.X3DNode; newValue=" + String.valueOf(newValue));
        }
        this.children.add(newValue);
        return this;
    }

    public ProtoBody clearChildren() {
        for (X3DNode element : this.children) {
            ((X3DConcreteElement)((Object)element)).clearParent();
        }
        this.children.clear();
        if (this.primaryNode != null) {
            this.primaryNode.setParent(null);
            this.primaryNode = null;
        }
        return this;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public ProtoBody addComments(String newComment) {
        if (newComment == null) {
            return this;
        }
        this.children.add(new CommentsBlock(newComment));
        return this;
    }

    @Override
    public ProtoBody addComments(String[] newComments) {
        if (newComments == null) {
            return this;
        }
        this.children.add(new CommentsBlock(newComments));
        return this;
    }

    @Override
    public ProtoBody addComments(CommentsBlock newCommentsBlock) {
        if (newCommentsBlock == null) {
            return this;
        }
        this.children.add(newCommentsBlock);
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    public final ProtoBody setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public ProtoBody setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getHtmlID() {
        return super.getHtmlID();
    }

    public final ProtoBody setHtmlID(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteHtmlID(newValue);
        return this;
    }

    public ProtoBody setHtmlID(SFString newValue) {
        this.setHtmlID(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    public final ProtoBody setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public ProtoBody setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    public String getNodeType() {
        if (this.primaryNode != null) {
            return this.primaryNode.getElementName();
        }
        String prototypeName = "ParentProtoDeclareNameNotKnown";
        if (this.getParent() != null) {
            prototypeName = ((ProtoDeclare)this.getParent()).getName();
        }
        String errorNotice = "ERROR_UNKNOWN_PROTODECLARE_NODE_TYPE: ProtoDeclare name='" + prototypeName + "' ProtoBody has no initial node and thus has no node type yet.";
        this.validationResult.append(errorNotice).append("\n");
        return errorNotice;
    }

    public String getContainerFieldDefault() {
        if (this.primaryNode != null) {
            return this.primaryNode.getContainerFieldDefault();
        }
        return "";
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasAttributes = true;
        boolean hasChild = !this.children.isEmpty();
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<ProtoBody");
        if (hasAttributes) {
            if (!this.getCssClass().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!this.getHtmlID().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlID()).toStringX3D()).append("'");
            }
            if (!this.getCssStyle().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
        }
        if (hasChild) {
            stringX3D.append(">").append("\n");
            for (X3DNode element : this.children) {
                stringX3D.append(((X3DConcreteElement)((Object)element)).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</ProtoBody>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = !this.children.isEmpty();
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        stringClassicVRML.append("# ProtoBody");
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        for (X3DNode element : this.children) {
            X3DConcreteElement referenceElement;
            if (!(element instanceof X3DConcreteElement) || (referenceElement = ((X3DConcreteElement)((Object)element)).findElementByNameValue(nameValue, elementName)) == null) continue;
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        for (X3DNode element : this.children) {
            X3DConcreteNode referenceNode;
            if (!(element instanceof X3DConcreteNode) || (referenceNode = ((X3DConcreteElement)((Object)element)).findNodeByDEF(DEFvalue)) == null) continue;
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setCssClass(this.getCssClass());
        this.setHtmlID(this.getHtmlID());
        this.setCssStyle(this.getCssStyle());
        for (X3DNode element : this.children) {
            try {
                ((X3DConcreteElement)((Object)element)).validate();
                this.validationResult.append(((X3DConcreteElement)((Object)element)).getValidationResult());
            }
            catch (Exception e) {
                String exceptionMessage = "[exception] during validation: " + e.getMessage();
                this.validationResult.append(exceptionMessage);
                e.printStackTrace();
            }
        }
        this.setChildren(this.getChildren());
        if (this.children.isEmpty()) {
            String errorNotice = "ERROR_UNKNOWN_PROTODECLARE_NODE_TYPE: ProtoBody does not have any child nodes and so ProtoDeclare has no node type. ";
            String ProtoDeclare_description = "Parent ProtoDeclare name: " + this.getName();
            this.validationResult.append(ProtoDeclare_description).append("\n").append(errorNotice).append("\n");
        }
        return this.validationResult.toString();
    }

    public String getName() {
        if (this.getParent() != null) {
            return ((ProtoDeclare)this.getParent()).getName();
        }
        return "ERROR_NOT_CONNECTED_TO_SCENE_GRAPH: " + this.getElementName() + "Object has no parent ProtoDeclare, thus getName() cannot be checked.";
    }
}

