/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Core;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.field;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.X3DConcreteStatement;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.sai.Core.X3DChildNode;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;

public class ExternProtoDeclare
extends X3DConcreteStatement
implements X3DChildNode {
    private ArrayList<String> commentsList;
    private String appinfo = new String();
    private String documentation = new String();
    private ArrayList<field> fieldList = new ArrayList();
    private String name = new String();
    private ArrayList<String> url = new ArrayList();
    public static final String NAME = "ExternProtoDeclare";
    public static final String COMPONENT = "Core";
    public static final int LEVEL = 2;
    public static final String APPINFO_DEFAULT_VALUE = "";
    public static final String DOCUMENTATION_DEFAULT_VALUE = "";
    public static final String NAME_DEFAULT_VALUE = "";
    public static final ArrayList<String> URL_DEFAULT_VALUE = new ArrayList<String>(Arrays.asList(new String[0]));
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 2;
    }

    @Override
    public String getFieldType(String fieldName) {
        String result = switch (fieldName) {
            case "containerField" -> "SFString";
            case "appinfo" -> "SFString";
            case "class" -> "SFString";
            case "documentation" -> "SFString";
            case "field" -> "MFNode";
            case "id" -> "SFString";
            case "name" -> "SFString";
            case "style" -> "SFString";
            case "url" -> "MFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
        field fieldDeclaration = this.findFieldByName(fieldName);
        if (fieldDeclaration != null) {
            result = fieldDeclaration.getType();
        }
        return result;
    }

    @Override
    public String getAccessType(String fieldName) {
        String result = switch (fieldName) {
            case "appinfo" -> "inputOutput";
            case "class" -> "inputOutput";
            case "documentation" -> "inputOutput";
            case "field" -> "inputOutput";
            case "id" -> "inputOutput";
            case "name" -> "inputOutput";
            case "style" -> "inputOutput";
            case "url" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
        field fieldDeclaration = this.findFieldByName(fieldName);
        if (fieldDeclaration != null) {
            result = fieldDeclaration.getAccessType();
        }
        return result;
    }

    public ExternProtoDeclare() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.appinfo = "";
        this.documentation = "";
        this.fieldList = new ArrayList();
        this.name = "";
        this.url = new ArrayList<String>(URL_DEFAULT_VALUE);
        this.commentsList = new ArrayList();
    }

    public String getAppinfo() {
        return this.appinfo;
    }

    public ExternProtoDeclare setAppinfo(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.appinfo = newValue;
        return this;
    }

    public ExternProtoDeclare setAppinfo(SFString newValue) {
        this.setAppinfo(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    public final ExternProtoDeclare setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public ExternProtoDeclare setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public ExternProtoDeclare setDocumentation(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.documentation = newValue;
        return this;
    }

    public ExternProtoDeclare setDocumentation(SFString newValue) {
        this.setDocumentation(newValue.getPrimitiveValue());
        return this;
    }

    public ArrayList<field> getFieldList() {
        return this.fieldList;
    }

    public ExternProtoDeclare setFieldList(ArrayList<field> newValue) {
        this.fieldList = newValue;
        for (field arrayElement : this.fieldList) {
            if (!(arrayElement.getValue().isEmpty() && arrayElement.getChildren().isEmpty() || !arrayElement.hasChildrenElements())) {
                String foundValue = !arrayElement.getValue().isEmpty() ? arrayElement.getValue() : arrayElement.getChildren().toString();
                throw new InvalidProtoException("ExternProtoDeclare name='" + this.name + "' with field name='" + arrayElement.getName() + "' cannot have any initial value (found \"" + foundValue + "\"). Instead use ProtoInstance fieldValue to override the original default ProtoDeclare field value.");
            }
            arrayElement.setParent(this);
        }
        return this;
    }

    public ExternProtoDeclare setField(field newValue) {
        if (newValue == null) {
            this.clearField();
            return this;
        }
        if (!(newValue.getValue().isEmpty() && newValue.getChildren().isEmpty() || !newValue.hasChildrenElements())) {
            String foundValue = !newValue.getValue().isEmpty() ? newValue.getValue() : newValue.getChildren().toString();
            throw new InvalidProtoException("ExternProtoDeclare name='" + this.name + "' with field name='" + newValue.getName() + "' cannot have any initial value (found \"" + foundValue + "\"). Instead use ProtoInstance fieldValue to override the original default ProtoDeclare field value.");
        }
        for (field element : this.fieldList) {
            element.clearParent();
        }
        this.clearField();
        this.fieldList.add(newValue);
        newValue.setParent(this);
        return this;
    }

    public ExternProtoDeclare clearField() {
        for (field element : this.fieldList) {
            element.clearParent();
        }
        this.fieldList.clear();
        return this;
    }

    public boolean hasField() {
        return !this.fieldList.isEmpty();
    }

    @Override
    public String getHtmlID() {
        return super.getHtmlID();
    }

    public final ExternProtoDeclare setHtmlID(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteHtmlID(newValue);
        return this;
    }

    public ExternProtoDeclare setHtmlID(SFString newValue) {
        this.setHtmlID(newValue.getPrimitiveValue());
        return this;
    }

    public String getName() {
        return this.name;
    }

    public final ExternProtoDeclare setName(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("ExternProtoDeclare name newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        if (!SFString.meetsX3dInteroperabilityNamingConventions(newValue) && ConfigurationProperties.isConsoleOutputVerbose()) {
            System.out.println("[warning] ExternProtoDeclare name newValue='" + newValue + "' has name value that does not meet X3D naming conventions.");
        }
        this.name = newValue;
        return this;
    }

    public ExternProtoDeclare setName(SFString newValue) {
        this.setName(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    public final ExternProtoDeclare setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public ExternProtoDeclare setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    public String[] getUrl() {
        String[] valuesArray = new String[this.url.size()];
        int i = 0;
        for (String arrayElement : this.url) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ExternProtoDeclare setUrl(String[] newValue) {
        if (newValue == null) {
            this.clearUrl();
            return this;
        }
        this.clearUrl();
        for (int i = 0; i < newValue.length; ++i) {
            this.url.add(newValue[i]);
        }
        return this;
    }

    public ExternProtoDeclare setUrl(MFString newValue) {
        if (newValue == null) {
            this.clearUrl();
            return this;
        }
        this.setUrl(newValue.getPrimitiveValue());
        return this;
    }

    public ExternProtoDeclare clearUrl() {
        this.url.clear();
        return this;
    }

    public ExternProtoDeclare addUrl(String newValue) {
        if (newValue == null) {
            return this;
        }
        if (!(newValue = MFString.cleanupEnumerationValue(newValue)).isEmpty() && !this.url.contains(newValue)) {
            this.url.add(newValue);
        }
        return this;
    }

    public ExternProtoDeclare addUrl(SFString newValue) {
        if (newValue == null) {
            return this;
        }
        newValue.setValue(MFString.cleanupEnumerationValue(newValue.getValue()));
        if (!newValue.getValue().isEmpty() && !this.url.contains(newValue.getValue())) {
            this.url.add(newValue.getValue());
        }
        return this;
    }

    public ExternProtoDeclare(String prototypeName) {
        this.initialize();
        this.setName(prototypeName);
    }

    public String getNodeType() {
        Object errorNotice = new String();
        if (this.findAncestorScene() == null) {
            if (!ConfigurationProperties.isCreationConnectionValidationExceptionAllowed()) {
                errorNotice = "ERROR_UNKNOWN_EXTERNPROTODECLARE_NODE_TYPE: ExternProtoDeclare name='" + this.getName() + "' must first be connected to Scene scene graph in order to get checked.";
                this.validationResult.append((String)errorNotice).append("\n");
            }
            return errorNotice;
        }
        errorNotice = "ERROR_UNKNOWN_EXTERNPROTODECLARE_NODE_TYPE: ExternProtoDeclare name='" + this.getName() + "' type cannot be remotely accessed at run time.\nTODO X3DJSAIL needs to add further capability that retrieves the ExternProtoDeclare file.";
        this.validationResult.append((String)errorNotice).append("\n");
        return errorNotice;
    }

    @Override
    public ExternProtoDeclare addComments(String newComment) {
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public ExternProtoDeclare addComments(String[] newComments) {
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public ExternProtoDeclare addComments(CommentsBlock newCommentsBlock) {
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasAttributes = true;
        boolean hasChild = !this.fieldList.isEmpty() || !this.commentsList.isEmpty();
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<ExternProtoDeclare");
        if (hasAttributes) {
            if (!this.getName().equals("")) {
                stringX3D.append(" name='").append(SFString.toString(this.getName())).append("'");
            }
            if (!this.getAppinfo().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" appinfo='").append(new SFString(this.getAppinfo()).toStringX3D()).append("'");
            }
            if (!this.getCssClass().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!this.getDocumentation().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" documentation='").append(new SFString(this.getDocumentation()).toStringX3D()).append("'");
            }
            if (!this.getHtmlID().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlID()).toStringX3D()).append("'");
            }
            if (!this.getCssStyle().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
            if (this.getUrl().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" url='").append(new MFString(this.getUrl()).toStringX3D()).append("'");
            }
        }
        if (hasChild) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            for (field element : this.fieldList) {
                stringX3D.append(((X3DConcreteElement)element).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</ExternProtoDeclare>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = !this.fieldList.isEmpty() || !this.commentsList.isEmpty();
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        stringClassicVRML.append("EXTERNPROTO ").append(this.name).append(" [").append("\n").append((CharSequence)indent);
        if (!this.getAppinfo().equals("") || !this.getAppinfo().isEmpty() && !ConfigurationProperties.getStripDefaultAttributes()) {
            stringClassicVRML.append((CharSequence)indent).append(indentCharacter).append(indentCharacter);
            stringClassicVRML.append(" # [appinfo] ").append("\"").append(SFString.toString(this.getAppinfo())).append("\"");
        }
        if (!this.getDocumentation().equals("") || !this.getDocumentation().isEmpty() && !ConfigurationProperties.getStripDefaultAttributes()) {
            stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            stringClassicVRML.append("# [documentation] ").append("\"").append(SFString.toString(this.getDocumentation())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
        }
        if (this.getUrl().length > 0) {
            stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            stringClassicVRML.append("url ").append("[ ").append(MFString.toString(this.getUrl())).append(" ]");
        }
        for (field element : this.fieldList) {
            stringClassicVRML.append(((X3DConcreteElement)element).toStringClassicVRML(indentLevel));
        }
        if (!this.commentsList.isEmpty()) {
            CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
            stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
        }
        stringClassicVRML.append("]").append("\n").append((CharSequence)indent);
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (elementName == null) {
            elementName = "";
        }
        if (this.getName().equals(nameValue) && (elementName.isEmpty() || elementName.equals(this.getElementName()))) {
            return this;
        }
        for (field element : this.fieldList) {
            X3DConcreteElement referenceElement;
            if (!(element instanceof X3DConcreteElement) || (referenceElement = ((X3DConcreteElement)element).findElementByNameValue(nameValue, elementName)) == null) continue;
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setAppinfo(this.getAppinfo());
        this.setCssClass(this.getCssClass());
        this.setDocumentation(this.getDocumentation());
        this.setHtmlID(this.getHtmlID());
        if (this.getName().isEmpty()) {
            String errorNotice = "ERROR_VALUE_NOT_FOUND, ExternProtoDeclare name field is required but no value found. ";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setName(this.getName());
        this.setCssStyle(this.getCssStyle());
        this.setUrl(this.getUrl());
        for (field element : this.fieldList) {
            try {
                ((X3DConcreteElement)element).validate();
                this.validationResult.append(element.getValidationResult());
            }
            catch (Exception e) {
                String exceptionMessage = "[exception] during validation: " + e.getMessage();
                this.validationResult.append(exceptionMessage);
                e.printStackTrace();
            }
        }
        this.setFieldList(this.getFieldList());
        if (this.findAncestorScene().findElementByNameValue(this.getName(), "ProtoInstance") == null) {
            String warningNotice = "WARNING_PROTOINSTANCE_NOT_FOUND, ExternProtoDeclare " + this.getName() + " has no corresponding ProtoInstance attached to the scene graph. ";
            this.validationResult.append(warningNotice).append("\n");
        }
        return this.validationResult.toString();
    }

    public ExternProtoDeclare addField(field newField) {
        String errorNotice = "Illegal addField() invocation for ExternProtoDeclare  name='" + this.getName() + "', ";
        if (newField == null) {
            errorNotice = errorNotice + "provided null field";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        for (field priorField : this.fieldList) {
            if (!priorField.getName().equals(newField.getName())) continue;
            errorNotice = errorNotice + "trying to add field with duplicate name='" + newField.getName() + "'";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        String fieldValidationResult = newField.validate();
        if (!fieldValidationResult.trim().isEmpty()) {
            errorNotice = errorNotice + "newField.validation() failure: " + fieldValidationResult;
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        this.fieldList.add(newField);
        newField.setParent(this);
        return this;
    }

    public field findFieldByName(String fieldName) {
        for (field element : this.fieldList) {
            if (!element.getName().equalsIgnoreCase(fieldName)) continue;
            return element;
        }
        return null;
    }

    public boolean removeField(field fieldToRemove) {
        String errorNotice = "Illegal removeField() invocation for ExternProtoDeclare name='" + this.getName() + "', ";
        if (fieldToRemove == null) {
            errorNotice = errorNotice + "provided null field";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        int fieldIndex = this.fieldList.indexOf(fieldToRemove);
        if (fieldIndex >= 0) {
            field removedField = this.fieldList.remove(fieldIndex);
            return removedField != null;
        }
        return false;
    }

    public boolean removeField(String fieldName) {
        String errorNotice = "Illegal removeField() invocation for ExternProtoDeclare name='" + this.getName() + "', ";
        if (fieldName == null || fieldName.isEmpty()) {
            errorNotice = errorNotice + "provided null or empty fieldName string";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        field fieldToRemove = this.findFieldByName(fieldName);
        if (fieldToRemove != null) {
            return this.removeField(fieldToRemove);
        }
        return false;
    }

    public void clearFields() {
        this.fieldList.clear();
    }

    public boolean hasField(String fieldName) {
        return this.findFieldByName(fieldName) != null;
    }

    @Override
    @Deprecated
    public X3DMetadataObject getMetadata() {
        return null;
    }

    @Override
    @Deprecated
    public ExternProtoDeclare setMetadata(X3DMetadataObject newValue) {
        return this;
    }

    @Deprecated
    public ExternProtoDeclare setDEF(String newValue) {
        return this;
    }

    @Deprecated
    public ExternProtoDeclare setUSE(String newValue) {
        return this;
    }
}

