/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Core;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.X3DConcreteStatement;
import org.web3d.x3d.sai.Core.X3DChildNode;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class CommentsBlock
extends X3DConcreteStatement
implements X3DChildNode {
    private ArrayList<String> commentsList;
    protected static final String NAME = "CommentsBlock";
    public static final String COMPONENT = "Core";
    public static final int LEVEL = 1;
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 1;
    }

    public CommentsBlock() {
        this.initialize();
    }

    public CommentsBlock(String newComment) {
        this.initialize();
        this.commentsList.add(newComment);
    }

    public CommentsBlock(String[] newComments) {
        this.initialize();
        if (newComments != null && newComments.length > 0) {
            this.commentsList.addAll(Arrays.asList(newComments));
        }
    }

    public CommentsBlock(ArrayList<String> newCommentsList) {
        this.initialize();
        this.commentsList.addAll(newCommentsList);
    }

    @Override
    public CommentsBlock addComments(String newComment) {
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public CommentsBlock addComments(String[] newComments) {
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    public CommentsBlock addComments(ArrayList<String> newCommentsList) {
        this.commentsList.addAll(newCommentsList);
        return this;
    }

    @Override
    public CommentsBlock addComments(CommentsBlock newCommentsBlock) {
        this.commentsList.addAll(Arrays.asList(newCommentsBlock.toStrings()));
        return this;
    }

    public String[] toStrings() {
        return (String[])this.commentsList.toArray();
    }

    public ArrayList<String> toStringList() {
        return this.commentsList;
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.commentsList = new ArrayList();
    }

    public CommentsBlock clear() {
        this.initialize();
        return this;
    }

    public static String cleanXmlCommentDelimiters(String newComment) {
        String result = newComment;
        if (result == null) {
            result = new String();
        }
        if (result.contains("--")) {
            result = result.replaceAll("--", "- -");
        }
        return result;
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        for (String comment : this.commentsList) {
            if (ConfigurationProperties.isNormalizeCommentWhitespace()) {
                comment = comment.replaceAll("\\s+", " ");
            }
            stringX3D.append((CharSequence)indent).append("<!-- ").append(CommentsBlock.cleanXmlCommentDelimiters(comment).trim()).append(" -->").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        StringBuilder stringClassicVRML = new StringBuilder();
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        for (String comment : this.commentsList) {
            if (ConfigurationProperties.isNormalizeCommentWhitespace()) {
                comment = comment.replaceAll("\\s+", " ");
            }
            stringClassicVRML.append("# ").append(comment.replaceAll("\n", "\n#\t")).append("\n").append((CharSequence)indent);
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        return this.validationResult.toString();
    }

    @Override
    @Deprecated
    public X3DMetadataObject getMetadata() {
        return null;
    }

    @Override
    @Deprecated
    public CommentsBlock setMetadata(X3DMetadataObject newValue) {
        return this;
    }

    @Deprecated
    public CommentsBlock setDEF(String newValue) {
        return this;
    }

    @Deprecated
    public CommentsBlock setUSE(String newValue) {
        return this;
    }

    @Override
    @Deprecated
    public String getFieldType(String fieldName) {
        return "ERROR_UNKNOWN_FIELD_TYPE";
    }

    @Override
    @Deprecated
    public String getAccessType(String fieldName) {
        return "ERROR_UNKNOWN_FIELD_ACCESSTYPE";
    }
}

