/**
 *<p>
 *	This entire book was presented as a tutorial during the ACM Special Interest Group on Graphics (SIGGRAPH) conference in 1998.
 *</p>
 *<p>
 *	The SIGGRAPH98 online course
 *	<a href="http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm" target="Vrml2SourcebookCourse">Introduction to VRML97</a>
 *	by David R. Nadeau, John L. Moreland, and Michael M. Heck
 *	includes all of the examples translated here.
 *	Many of these X3D scenes are adapted directly from the
 *	<a href="http://www.wiley.com/legacy/compbooks/vrml2sbk/cover/cover.htm" target="Vrml2Sourcebook">original VRML 2.0 Sourcebook chapter examples</a>.
 *</p>
 *
 *<p>
 *	A large number of 
 *	<a href="interesting.html">Interesting Scenes</a>
 *	have been added to this course for learning VRML and X3D.
 *
 *	<a href="originals/">Source code</a>
 *	for the original example models is also provided.
 *</p>
 *
 *<p>
 *	Original Course Abstract.
 *	<!-- slight editorial changes added for readability -->
 *	<i>The Virtual Reality Modeling Language (VRML) is an international standard for describing 3D shapes 
 *	and scenery on the World Wide Web. VRML's technology has very broad applicability, including web-based entertainment, 
 *	distributed visualization, 3D user interfaces to remote web resources, 3D collaborative environments, 
 *	interactive simulations for education, virtual museums, virtual retail spaces, and more. 
 *	VRML is a key technology shaping the future of the Web.
 *
 *	Participants in this tutorial will learn how to use VRML 97 (a.k.a. ISO VRML, VRML 2.0, and Moving Worlds) 
 *	to author their own 3D virtual worlds on the World Wide Web. 
 *	Participants will learn VRML concepts and terminology, and be introduced to VRML's text-format syntax. 
 *	Participants also will learn tips and techniques for increasing performance and realism. 
 *	The tutorial includes numerous VRML examples and information on where to find out more about VRML features and use.
 *        </i>
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course" target="_blank">X3D VRML2 Sourcebook Siggraph 98 Course</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Vrml2Sourcebook.Siggraph98Course;

