####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python VectorField1.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    meta(content='VectorField1.x3d',name='title'),
    meta(content='Vector field: this world illustrates the use of an external prototype to define a generic vector. This scene uses the new vector node repeatedly to place, orient, scale, and color vectors throughout a visualization volume.',name='description'),
    meta(content='David R. Nadeau, John L. Moreland',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='1 July 1998',name='created'),
    meta(content='2 February 2014',name='translated'),
    meta(content='20 October 2019',name='modified'),
    meta(content='originals/vecfld1.wrl',name='reference'),
    meta(content='http://www.siggraph.org/s98',name='reference'),
    meta(content='http://www.siggraph.org/s98/conference/courses/18.html',name='reference'),
    meta(content='http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0496.htm',name='reference'),
    meta(content='http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/X3dResources.html',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/VectorField1.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(info=["Copyright (c) 1997, David R. Nadeau, John L. Moreland"],title='Vector field'),
    ExternProtoDeclare(name='Vector',url=["Vector.x3d#Vector","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Vector.x3d#Vector","Vector.wrl#Vector","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Vector.wrl#Vector"],
      field=[
      field(accessType='initializeOnly',name='color',type='SFColor'),
      field(accessType='initializeOnly',name='rotation',type='SFRotation'),
      field(accessType='initializeOnly',name='scale',type='SFVec3f'),
      field(accessType='initializeOnly',name='translation',type='SFVec3f')]),
    Viewpoint(description='Entry view',position=(0.0,0.0,20.0)),
    NavigationInfo(),
    Transform(bboxSize=(13.0,13.0,13.0),translation=(1.047196,1.047196,1.047196),
      children=[
      Shape(
        appearance=Appearance(
          material=Material(diffuseColor=(1.0,1.0,1.0),emissiveColor=(1.0,1.0,1.0))),
        geometry=IndexedLineSet(coordIndex=[0,1,2,3,0,-1,7,6,5,4,7,-1,0,4,-1,1,5,-1,2,6,-1,3,7,-1],
          coord=Coordinate(point=[(-6.28318,4.188787,-6.28318),(4.188787,4.188787,-6.28318),(4.188787,4.188787,4.188787),(-6.28318,4.188787,4.188787),(-6.28318,-6.28318,-6.28318),(4.188787,-6.28318,-6.28318),(4.188787,-6.28318,4.188787),(-6.28318,-6.28318,4.188787)]))),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-0.707107,0.0,-0.707107,-1.850551)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-6.28318,-6.28318,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-0.5547,0.0,-0.83205,-1.501518)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-6.28318,-6.28318,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-0.316228,0.0,-0.948683,-0.907286)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-6.28318,-6.28318,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.0,0.0,-1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-6.28318,-6.28318,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.316228,0.0,-0.948683,0.907286)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-6.28318,-6.28318,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.5547,0.0,-0.83205,1.501518)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-6.28318,-6.28318,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(-0.707107,0.0,-0.707107,-1.850551)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(-6.28318,-4.188787,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(-0.5547,0.0,-0.83205,-1.501518)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(-6.28318,-4.188787,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-0.316228,0.0,-0.948683,-0.907286)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-6.28318,-4.188787,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.0,0.0,-1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-6.28318,-4.188787,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.316228,0.0,-0.948683,0.907286)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-6.28318,-4.188787,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.5547,0.0,-0.83205,1.501518)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(-6.28318,-4.188787,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(-0.707107,0.0,-0.707107,-1.850551)),
        fieldValue(name='scale',value=(1.0,0.100002,1.0)),
        fieldValue(name='translation',value=(-6.28318,-2.094393,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(-0.5547,0.0,-0.83205,-1.501518)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(-6.28318,-2.094393,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(-0.316228,0.0,-0.948683,-0.907286)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(-6.28318,-2.094393,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.0,0.0,-1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-6.28318,-2.094393,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.316228,0.0,-0.948683,0.907286)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(-6.28318,-2.094393,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.5547,0.0,-0.83205,1.501518)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(-6.28318,-2.094393,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(-0.707107,0.0,-0.707107,-1.850551)),
        fieldValue(name='scale',value=(1.0,0.100002,1.0)),
        fieldValue(name='translation',value=(-6.28318,0.0,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(-0.5547,0.0,-0.83205,-1.501518)),
        fieldValue(name='scale',value=(1.0,0.100002,1.0)),
        fieldValue(name='translation',value=(-6.28318,0.0,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(-0.316228,0.0,-0.948683,-0.907286)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(-6.28318,0.0,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.0,0.0,-1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-6.28318,0.0,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.316228,0.0,-0.948683,0.907286)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(-6.28318,0.0,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.5547,0.0,-0.83205,1.501518)),
        fieldValue(name='scale',value=(1.0,0.100002,1.0)),
        fieldValue(name='translation',value=(-6.28318,0.0,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(-0.707107,0.0,-0.707107,-1.850551)),
        fieldValue(name='scale',value=(1.0,0.100002,1.0)),
        fieldValue(name='translation',value=(-6.28318,2.094394,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(-0.5547,0.0,-0.83205,-1.501518)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(-6.28318,2.094394,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(-0.316228,0.0,-0.948683,-0.907286)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(-6.28318,2.094394,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.0,0.0,-1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-6.28318,2.094394,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.316228,0.0,-0.948683,0.907286)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(-6.28318,2.094394,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.5547,0.0,-0.83205,1.501518)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(-6.28318,2.094394,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(-0.707107,0.0,-0.707107,-1.850551)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(-6.28318,4.188787,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(-0.5547,0.0,-0.83205,-1.501518)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(-6.28318,4.188787,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-0.316228,0.0,-0.948683,-0.907286)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-6.28318,4.188787,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.0,0.0,-1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-6.28318,4.188787,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.316228,0.0,-0.948683,0.907286)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-6.28318,4.188787,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.5547,0.0,-0.83205,1.501518)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(-6.28318,4.188787,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-0.83205,0.0,-0.5547,-2.121654)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-4.188787,-6.28318,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-0.707107,0.0,-0.707107,-1.850551)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-4.188787,-6.28318,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-0.447214,0.0,-0.894427,-1.241623)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-4.188787,-6.28318,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.0,0.0,-1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-4.188787,-6.28318,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.447214,0.0,-0.894427,1.241623)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-4.188787,-6.28318,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.707107,0.0,-0.707107,1.850551)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-4.188787,-6.28318,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.25,0.0,0.75)),
        fieldValue(name='rotation',value=(-0.83205,0.0,-0.5547,-2.121654)),
        fieldValue(name='scale',value=(1.0,0.475,1.0)),
        fieldValue(name='translation',value=(-4.188787,-4.188787,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216507,0.0,0.783493)),
        fieldValue(name='rotation',value=(-0.707107,0.0,-0.707107,-1.850551)),
        fieldValue(name='scale',value=(1.0,0.42476,1.0)),
        fieldValue(name='translation',value=(-4.188787,-4.188787,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.125001,0.0,0.874999)),
        fieldValue(name='rotation',value=(-0.447214,0.0,-0.894427,-1.241623)),
        fieldValue(name='scale',value=(1.0,0.287501,1.0)),
        fieldValue(name='translation',value=(-4.188787,-4.188787,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.0,0.0,-1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(-4.188787,-4.188787,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.125,0.0,0.875)),
        fieldValue(name='rotation',value=(0.447214,0.0,-0.894427,1.241623)),
        fieldValue(name='scale',value=(1.0,0.287499,1.0)),
        fieldValue(name='translation',value=(-4.188787,-4.188787,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216506,0.0,0.783494)),
        fieldValue(name='rotation',value=(0.707107,0.0,-0.707107,1.850551)),
        fieldValue(name='scale',value=(1.0,0.424759,1.0)),
        fieldValue(name='translation',value=(-4.188787,-4.188787,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433013,0.0,0.566987)),
        fieldValue(name='rotation',value=(-0.83205,0.0,-0.5547,-2.121654)),
        fieldValue(name='scale',value=(1.0,0.74952,1.0)),
        fieldValue(name='translation',value=(-4.188787,-2.094393,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.375001,0.0,0.624999)),
        fieldValue(name='rotation',value=(-0.707107,0.0,-0.707107,-1.850551)),
        fieldValue(name='scale',value=(1.0,0.662501,1.0)),
        fieldValue(name='translation',value=(-4.188787,-2.094393,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216507,0.0,0.783493)),
        fieldValue(name='rotation',value=(-0.447214,0.0,-0.894427,-1.241623)),
        fieldValue(name='scale',value=(1.0,0.424761,1.0)),
        fieldValue(name='translation',value=(-4.188787,-2.094393,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.0,0.0,-1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.100002,1.0)),
        fieldValue(name='translation',value=(-4.188787,-2.094393,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216506,0.0,0.783494)),
        fieldValue(name='rotation',value=(0.447214,0.0,-0.894427,1.241623)),
        fieldValue(name='scale',value=(1.0,0.424758,1.0)),
        fieldValue(name='translation',value=(-4.188787,-2.094393,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.375,0.0,0.625)),
        fieldValue(name='rotation',value=(0.707107,0.0,-0.707107,1.850551)),
        fieldValue(name='scale',value=(1.0,0.6625,1.0)),
        fieldValue(name='translation',value=(-4.188787,-2.094393,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.500001,0.0,0.499999)),
        fieldValue(name='rotation',value=(-0.83205,0.0,-0.5547,-2.121654)),
        fieldValue(name='scale',value=(1.0,0.850001,1.0)),
        fieldValue(name='translation',value=(-4.188787,0.0,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433014,0.0,0.566986)),
        fieldValue(name='rotation',value=(-0.707107,0.0,-0.707107,-1.850551)),
        fieldValue(name='scale',value=(1.0,0.749521,1.0)),
        fieldValue(name='translation',value=(-4.188787,0.0,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.250001,0.0,0.749999)),
        fieldValue(name='rotation',value=(-0.447214,0.0,-0.894427,-1.241623)),
        fieldValue(name='scale',value=(1.0,0.475002,1.0)),
        fieldValue(name='translation',value=(-4.188787,0.0,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.0,0.0,-1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.100002,1.0)),
        fieldValue(name='translation',value=(-4.188787,0.0,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.249999,0.0,0.750001)),
        fieldValue(name='rotation',value=(0.447214,0.0,-0.894427,1.241623)),
        fieldValue(name='scale',value=(1.0,0.474999,1.0)),
        fieldValue(name='translation',value=(-4.188787,0.0,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433013,0.0,0.566987)),
        fieldValue(name='rotation',value=(0.707107,0.0,-0.707107,1.850551)),
        fieldValue(name='scale',value=(1.0,0.749519,1.0)),
        fieldValue(name='translation',value=(-4.188787,0.0,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433014,0.0,0.566986)),
        fieldValue(name='rotation',value=(-0.83205,0.0,-0.5547,-2.121654)),
        fieldValue(name='scale',value=(1.0,0.749521,1.0)),
        fieldValue(name='translation',value=(-4.188787,2.094394,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.375001,0.0,0.624999)),
        fieldValue(name='rotation',value=(-0.707107,0.0,-0.707107,-1.850551)),
        fieldValue(name='scale',value=(1.0,0.662502,1.0)),
        fieldValue(name='translation',value=(-4.188787,2.094394,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216508,0.0,0.783492)),
        fieldValue(name='rotation',value=(-0.447214,0.0,-0.894427,-1.241623)),
        fieldValue(name='scale',value=(1.0,0.424761,1.0)),
        fieldValue(name='translation',value=(-4.188787,2.094394,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.0,0.0,-1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.100002,1.0)),
        fieldValue(name='translation',value=(-4.188787,2.094394,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216506,0.0,0.783494)),
        fieldValue(name='rotation',value=(0.447214,0.0,-0.894427,1.241623)),
        fieldValue(name='scale',value=(1.0,0.424759,1.0)),
        fieldValue(name='translation',value=(-4.188787,2.094394,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.375,0.0,0.625)),
        fieldValue(name='rotation',value=(0.707107,0.0,-0.707107,1.850551)),
        fieldValue(name='scale',value=(1.0,0.6625,1.0)),
        fieldValue(name='translation',value=(-4.188787,2.094394,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.250001,0.0,0.749999)),
        fieldValue(name='rotation',value=(-0.83205,0.0,-0.5547,-2.121654)),
        fieldValue(name='scale',value=(1.0,0.475002,1.0)),
        fieldValue(name='translation',value=(-4.188787,4.188787,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216508,0.0,0.783492)),
        fieldValue(name='rotation',value=(-0.707107,0.0,-0.707107,-1.850551)),
        fieldValue(name='scale',value=(1.0,0.424761,1.0)),
        fieldValue(name='translation',value=(-4.188787,4.188787,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.125001,0.0,0.874999)),
        fieldValue(name='rotation',value=(-0.447214,0.0,-0.894427,-1.241623)),
        fieldValue(name='scale',value=(1.0,0.287502,1.0)),
        fieldValue(name='translation',value=(-4.188787,4.188787,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.0,0.0,-1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(-4.188787,4.188787,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.125,0.0,0.875)),
        fieldValue(name='rotation',value=(0.447214,0.0,-0.894427,1.241623)),
        fieldValue(name='scale',value=(1.0,0.2875,1.0)),
        fieldValue(name='translation',value=(-4.188787,4.188787,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216507,0.0,0.783493)),
        fieldValue(name='rotation',value=(0.707107,0.0,-0.707107,1.850551)),
        fieldValue(name='scale',value=(1.0,0.424761,1.0)),
        fieldValue(name='translation',value=(-4.188787,4.188787,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-0.948683,0.0,-0.316228,-2.363877)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-2.094393,-6.28318,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-0.894427,0.0,-0.447214,-2.252432)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-2.094393,-6.28318,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-0.707107,0.0,-0.707107,-1.850551)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-2.094393,-6.28318,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.0,0.0,-1.0,1.0E-6)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-2.094393,-6.28318,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.707107,0.0,-0.707107,1.850551)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-2.094393,-6.28318,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.894427,0.0,-0.447213,2.252432)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(-2.094393,-6.28318,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433013,0.0,0.566987)),
        fieldValue(name='rotation',value=(-0.948683,0.0,-0.316228,-2.363877)),
        fieldValue(name='scale',value=(1.0,0.749519,1.0)),
        fieldValue(name='translation',value=(-2.094393,-4.188787,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.375,0.0,0.625)),
        fieldValue(name='rotation',value=(-0.894427,0.0,-0.447214,-2.252432)),
        fieldValue(name='scale',value=(1.0,0.6625,1.0)),
        fieldValue(name='translation',value=(-2.094393,-4.188787,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216507,0.0,0.783493)),
        fieldValue(name='rotation',value=(-0.707107,0.0,-0.707107,-1.850551)),
        fieldValue(name='scale',value=(1.0,0.424761,1.0)),
        fieldValue(name='translation',value=(-2.094393,-4.188787,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.0,0.0,-1.0,1.0E-6)),
        fieldValue(name='scale',value=(1.0,0.100002,1.0)),
        fieldValue(name='translation',value=(-2.094393,-4.188787,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216505,0.0,0.783495)),
        fieldValue(name='rotation',value=(0.707107,0.0,-0.707107,1.850551)),
        fieldValue(name='scale',value=(1.0,0.424758,1.0)),
        fieldValue(name='translation',value=(-2.094393,-4.188787,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.374999,0.0,0.625001)),
        fieldValue(name='rotation',value=(0.894427,0.0,-0.447213,2.252432)),
        fieldValue(name='scale',value=(1.0,0.662499,1.0)),
        fieldValue(name='translation',value=(-2.094393,-4.188787,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.75,0.0,0.25)),
        fieldValue(name='rotation',value=(-0.948683,0.0,-0.316228,-2.363877)),
        fieldValue(name='scale',value=(1.0,1.225,1.0)),
        fieldValue(name='translation',value=(-2.094393,-2.094393,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.64952,0.0,0.35048)),
        fieldValue(name='rotation',value=(-0.894427,0.0,-0.447214,-2.252432)),
        fieldValue(name='scale',value=(1.0,1.074279,1.0)),
        fieldValue(name='translation',value=(-2.094393,-2.094393,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.375001,0.0,0.624999)),
        fieldValue(name='rotation',value=(-0.707107,0.0,-0.707107,-1.850551)),
        fieldValue(name='scale',value=(1.0,0.662502,1.0)),
        fieldValue(name='translation',value=(-2.094393,-2.094393,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(2.0E-6,0.0,0.999998)),
        fieldValue(name='rotation',value=(0.0,0.0,-1.0,1.0E-6)),
        fieldValue(name='scale',value=(1.0,0.100003,1.0)),
        fieldValue(name='translation',value=(-2.094393,-2.094393,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.374998,0.0,0.625002)),
        fieldValue(name='rotation',value=(0.707107,0.0,-0.707107,1.850551)),
        fieldValue(name='scale',value=(1.0,0.662497,1.0)),
        fieldValue(name='translation',value=(-2.094393,-2.094393,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.649518,0.0,0.350482)),
        fieldValue(name='rotation',value=(0.894427,0.0,-0.447213,2.252432)),
        fieldValue(name='scale',value=(1.0,1.074277,1.0)),
        fieldValue(name='translation',value=(-2.094393,-2.094393,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.866026,0.0,0.133974)),
        fieldValue(name='rotation',value=(-0.948683,0.0,-0.316228,-2.363877)),
        fieldValue(name='scale',value=(1.0,1.399039,1.0)),
        fieldValue(name='translation',value=(-2.094393,0.0,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.750001,0.0,0.249999)),
        fieldValue(name='rotation',value=(-0.894427,0.0,-0.447214,-2.252432)),
        fieldValue(name='scale',value=(1.0,1.225001,1.0)),
        fieldValue(name='translation',value=(-2.094393,0.0,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433014,0.0,0.566986)),
        fieldValue(name='rotation',value=(-0.707107,0.0,-0.707107,-1.850551)),
        fieldValue(name='scale',value=(1.0,0.749521,1.0)),
        fieldValue(name='translation',value=(-2.094393,0.0,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(2.0E-6,0.0,0.999998)),
        fieldValue(name='rotation',value=(0.0,0.0,-1.0,1.0E-6)),
        fieldValue(name='scale',value=(1.0,0.100003,1.0)),
        fieldValue(name='translation',value=(-2.094393,0.0,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433011,0.0,0.566989)),
        fieldValue(name='rotation',value=(0.707107,0.0,-0.707107,1.850551)),
        fieldValue(name='scale',value=(1.0,0.749516,1.0)),
        fieldValue(name='translation',value=(-2.094393,0.0,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.749999,0.0,0.250001)),
        fieldValue(name='rotation',value=(0.894427,0.0,-0.447213,2.252432)),
        fieldValue(name='scale',value=(1.0,1.224998,1.0)),
        fieldValue(name='translation',value=(-2.094393,0.0,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.750001,0.0,0.249999)),
        fieldValue(name='rotation',value=(-0.948683,0.0,-0.316228,-2.363877)),
        fieldValue(name='scale',value=(1.0,1.225001,1.0)),
        fieldValue(name='translation',value=(-2.094393,2.094394,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.64952,0.0,0.35048)),
        fieldValue(name='rotation',value=(-0.894427,0.0,-0.447214,-2.252432)),
        fieldValue(name='scale',value=(1.0,1.074281,1.0)),
        fieldValue(name='translation',value=(-2.094393,2.094394,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.375002,0.0,0.624998)),
        fieldValue(name='rotation',value=(-0.707107,0.0,-0.707107,-1.850551)),
        fieldValue(name='scale',value=(1.0,0.662503,1.0)),
        fieldValue(name='translation',value=(-2.094393,2.094394,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(2.0E-6,0.0,0.999998)),
        fieldValue(name='rotation',value=(0.0,0.0,-1.0,1.0E-6)),
        fieldValue(name='scale',value=(1.0,0.100003,1.0)),
        fieldValue(name='translation',value=(-2.094393,2.094394,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.374999,0.0,0.625001)),
        fieldValue(name='rotation',value=(0.707107,0.0,-0.707107,1.850551)),
        fieldValue(name='scale',value=(1.0,0.662498,1.0)),
        fieldValue(name='translation',value=(-2.094393,2.094394,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.649519,0.0,0.350481)),
        fieldValue(name='rotation',value=(0.894427,0.0,-0.447213,2.252432)),
        fieldValue(name='scale',value=(1.0,1.074278,1.0)),
        fieldValue(name='translation',value=(-2.094393,2.094394,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433014,0.0,0.566986)),
        fieldValue(name='rotation',value=(-0.948683,0.0,-0.316228,-2.363877)),
        fieldValue(name='scale',value=(1.0,0.749521,1.0)),
        fieldValue(name='translation',value=(-2.094393,4.188787,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.375002,0.0,0.624998)),
        fieldValue(name='rotation',value=(-0.894427,0.0,-0.447214,-2.252432)),
        fieldValue(name='scale',value=(1.0,0.662503,1.0)),
        fieldValue(name='translation',value=(-2.094393,4.188787,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216508,0.0,0.783492)),
        fieldValue(name='rotation',value=(-0.707107,0.0,-0.707107,-1.850551)),
        fieldValue(name='scale',value=(1.0,0.424762,1.0)),
        fieldValue(name='translation',value=(-2.094393,4.188787,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.0,0.0,-1.0,1.0E-6)),
        fieldValue(name='scale',value=(1.0,0.100002,1.0)),
        fieldValue(name='translation',value=(-2.094393,4.188787,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216506,0.0,0.783494)),
        fieldValue(name='rotation',value=(0.707107,0.0,-0.707107,1.850551)),
        fieldValue(name='scale',value=(1.0,0.424759,1.0)),
        fieldValue(name='translation',value=(-2.094393,4.188787,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.375001,0.0,0.624999)),
        fieldValue(name='rotation',value=(0.894427,0.0,-0.447213,2.252432)),
        fieldValue(name='scale',value=(1.0,0.662501,1.0)),
        fieldValue(name='translation',value=(-2.094393,4.188787,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-1.0,0.0,0.0,-2.467401)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(0.0,-6.28318,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-1.0,0.0,0.0,-2.467401)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(0.0,-6.28318,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-1.0,0.0,0.0,-2.467401)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(0.0,-6.28318,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.707107,0.0,0.707107,0.61685)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(0.0,-6.28318,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(1.0,0.0,0.0,2.467401)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(0.0,-6.28318,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(1.0,0.0,0.0,2.467401)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(0.0,-6.28318,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.5,0.0,0.5)),
        fieldValue(name='rotation',value=(-1.0,0.0,0.0,-2.467401)),
        fieldValue(name='scale',value=(1.0,0.85,1.0)),
        fieldValue(name='translation',value=(0.0,-4.188787,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433013,0.0,0.566987)),
        fieldValue(name='rotation',value=(-1.0,0.0,0.0,-2.467401)),
        fieldValue(name='scale',value=(1.0,0.749519,1.0)),
        fieldValue(name='translation',value=(0.0,-4.188787,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.250001,0.0,0.749999)),
        fieldValue(name='rotation',value=(-1.0,0.0,0.0,-2.467401)),
        fieldValue(name='scale',value=(1.0,0.475001,1.0)),
        fieldValue(name='translation',value=(0.0,-4.188787,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.707107,0.0,0.707107,0.61685)),
        fieldValue(name='scale',value=(1.0,0.100002,1.0)),
        fieldValue(name='translation',value=(0.0,-4.188787,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.249999,0.0,0.750001)),
        fieldValue(name='rotation',value=(1.0,0.0,0.0,2.467401)),
        fieldValue(name='scale',value=(1.0,0.474998,1.0)),
        fieldValue(name='translation',value=(0.0,-4.188787,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433012,0.0,0.566988)),
        fieldValue(name='rotation',value=(1.0,0.0,0.0,2.467401)),
        fieldValue(name='scale',value=(1.0,0.749517,1.0)),
        fieldValue(name='translation',value=(0.0,-4.188787,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.866025,0.0,0.133975)),
        fieldValue(name='rotation',value=(-1.0,0.0,0.0,-2.467401)),
        fieldValue(name='scale',value=(1.0,1.399038,1.0)),
        fieldValue(name='translation',value=(0.0,-2.094393,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.75,0.0,0.25)),
        fieldValue(name='rotation',value=(-1.0,0.0,0.0,-2.467401)),
        fieldValue(name='scale',value=(1.0,1.225001,1.0)),
        fieldValue(name='translation',value=(0.0,-2.094393,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433014,0.0,0.566986)),
        fieldValue(name='rotation',value=(-1.0,0.0,0.0,-2.467401)),
        fieldValue(name='scale',value=(1.0,0.749521,1.0)),
        fieldValue(name='translation',value=(0.0,-2.094393,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(2.0E-6,0.0,0.999998)),
        fieldValue(name='rotation',value=(0.707107,0.0,0.707107,0.61685)),
        fieldValue(name='scale',value=(1.0,0.100003,1.0)),
        fieldValue(name='translation',value=(0.0,-2.094393,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.43301,0.0,0.56699)),
        fieldValue(name='rotation',value=(1.0,0.0,0.0,2.467401)),
        fieldValue(name='scale',value=(1.0,0.749516,1.0)),
        fieldValue(name='translation',value=(0.0,-2.094393,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.749998,0.0,0.250002)),
        fieldValue(name='rotation',value=(1.0,0.0,0.0,2.467401)),
        fieldValue(name='scale',value=(1.0,1.224997,1.0)),
        fieldValue(name='translation',value=(0.0,-2.094393,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0,0.0,0.0)),
        fieldValue(name='rotation',value=(-1.0,0.0,0.0,-2.467401)),
        fieldValue(name='scale',value=(1.0,1.6,1.0)),
        fieldValue(name='translation',value=(0.0,0.0,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.866026,0.0,0.133974)),
        fieldValue(name='rotation',value=(-1.0,0.0,0.0,-2.467401)),
        fieldValue(name='scale',value=(1.0,1.399039,1.0)),
        fieldValue(name='translation',value=(0.0,0.0,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.500002,0.0,0.499998)),
        fieldValue(name='rotation',value=(-1.0,0.0,0.0,-2.467401)),
        fieldValue(name='scale',value=(1.0,0.850003,1.0)),
        fieldValue(name='translation',value=(0.0,0.0,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(3.0E-6,0.0,0.999997)),
        fieldValue(name='rotation',value=(0.707107,0.0,0.707107,0.61685)),
        fieldValue(name='scale',value=(1.0,0.100004,1.0)),
        fieldValue(name='translation',value=(0.0,0.0,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.499997,0.0,0.500003)),
        fieldValue(name='rotation',value=(1.0,0.0,0.0,2.467401)),
        fieldValue(name='scale',value=(1.0,0.849996,1.0)),
        fieldValue(name='translation',value=(0.0,0.0,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.866024,0.0,0.133976)),
        fieldValue(name='rotation',value=(1.0,0.0,0.0,2.467401)),
        fieldValue(name='scale',value=(1.0,1.399036,1.0)),
        fieldValue(name='translation',value=(0.0,0.0,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.866026,0.0,0.133974)),
        fieldValue(name='rotation',value=(-1.0,0.0,0.0,-2.467401)),
        fieldValue(name='scale',value=(1.0,1.399039,1.0)),
        fieldValue(name='translation',value=(0.0,2.094394,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.750001,0.0,0.249999)),
        fieldValue(name='rotation',value=(-1.0,0.0,0.0,-2.467401)),
        fieldValue(name='scale',value=(1.0,1.225002,1.0)),
        fieldValue(name='translation',value=(0.0,2.094394,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433015,0.0,0.566985)),
        fieldValue(name='rotation',value=(-1.0,0.0,0.0,-2.467401)),
        fieldValue(name='scale',value=(1.0,0.749522,1.0)),
        fieldValue(name='translation',value=(0.0,2.094394,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(2.0E-6,0.0,0.999998)),
        fieldValue(name='rotation',value=(0.707107,0.0,0.707107,0.61685)),
        fieldValue(name='scale',value=(1.0,0.100003,1.0)),
        fieldValue(name='translation',value=(0.0,2.094394,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433011,0.0,0.566989)),
        fieldValue(name='rotation',value=(1.0,0.0,0.0,2.467401)),
        fieldValue(name='scale',value=(1.0,0.749516,1.0)),
        fieldValue(name='translation',value=(0.0,2.094394,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.749999,0.0,0.250001)),
        fieldValue(name='rotation',value=(1.0,0.0,0.0,2.467401)),
        fieldValue(name='scale',value=(1.0,1.224999,1.0)),
        fieldValue(name='translation',value=(0.0,2.094394,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.500002,0.0,0.499998)),
        fieldValue(name='rotation',value=(-1.0,0.0,0.0,-2.467401)),
        fieldValue(name='scale',value=(1.0,0.850003,1.0)),
        fieldValue(name='translation',value=(0.0,4.188787,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433015,0.0,0.566985)),
        fieldValue(name='rotation',value=(-1.0,0.0,0.0,-2.467401)),
        fieldValue(name='scale',value=(1.0,0.749522,1.0)),
        fieldValue(name='translation',value=(0.0,4.188787,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.250002,0.0,0.749998)),
        fieldValue(name='rotation',value=(-1.0,0.0,0.0,-2.467401)),
        fieldValue(name='scale',value=(1.0,0.475003,1.0)),
        fieldValue(name='translation',value=(0.0,4.188787,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.707107,0.0,0.707107,0.61685)),
        fieldValue(name='scale',value=(1.0,0.100002,1.0)),
        fieldValue(name='translation',value=(0.0,4.188787,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.25,0.0,0.75)),
        fieldValue(name='rotation',value=(1.0,0.0,0.0,2.467401)),
        fieldValue(name='scale',value=(1.0,0.474999,1.0)),
        fieldValue(name='translation',value=(0.0,4.188787,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433013,0.0,0.566987)),
        fieldValue(name='rotation',value=(1.0,0.0,0.0,2.467401)),
        fieldValue(name='scale',value=(1.0,0.74952,1.0)),
        fieldValue(name='translation',value=(0.0,4.188787,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-0.948683,0.0,0.316228,-1.560115)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(2.094394,-6.28318,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-0.894427,0.0,0.447214,-1.225778)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(2.094394,-6.28318,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-0.707107,0.0,0.707107,-0.61685)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(2.094394,-6.28318,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.0,0.0,1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(2.094394,-6.28318,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.707107,0.0,0.707107,0.61685)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(2.094394,-6.28318,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.894427,0.0,0.447214,1.225778)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(2.094394,-6.28318,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433013,0.0,0.566988)),
        fieldValue(name='rotation',value=(-0.948683,0.0,0.316228,-1.560115)),
        fieldValue(name='scale',value=(1.0,0.749519,1.0)),
        fieldValue(name='translation',value=(2.094394,-4.188787,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.375,0.0,0.625)),
        fieldValue(name='rotation',value=(-0.894427,0.0,0.447214,-1.225778)),
        fieldValue(name='scale',value=(1.0,0.6625,1.0)),
        fieldValue(name='translation',value=(2.094394,-4.188787,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216507,0.0,0.783493)),
        fieldValue(name='rotation',value=(-0.707107,0.0,0.707107,-0.61685)),
        fieldValue(name='scale',value=(1.0,0.42476,1.0)),
        fieldValue(name='translation',value=(2.094394,-4.188787,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.0,0.0,1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.100002,1.0)),
        fieldValue(name='translation',value=(2.094394,-4.188787,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216505,0.0,0.783495)),
        fieldValue(name='rotation',value=(0.707107,0.0,0.707107,0.61685)),
        fieldValue(name='scale',value=(1.0,0.424758,1.0)),
        fieldValue(name='translation',value=(2.094394,-4.188787,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.374999,0.0,0.625001)),
        fieldValue(name='rotation',value=(0.894427,0.0,0.447214,1.225778)),
        fieldValue(name='scale',value=(1.0,0.662499,1.0)),
        fieldValue(name='translation',value=(2.094394,-4.188787,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.75,0.0,0.25)),
        fieldValue(name='rotation',value=(-0.948683,0.0,0.316228,-1.560115)),
        fieldValue(name='scale',value=(1.0,1.225,1.0)),
        fieldValue(name='translation',value=(2.094394,-2.094393,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.64952,0.0,0.35048)),
        fieldValue(name='rotation',value=(-0.894427,0.0,0.447214,-1.225778)),
        fieldValue(name='scale',value=(1.0,1.074279,1.0)),
        fieldValue(name='translation',value=(2.094394,-2.094393,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.375001,0.0,0.624999)),
        fieldValue(name='rotation',value=(-0.707107,0.0,0.707107,-0.61685)),
        fieldValue(name='scale',value=(1.0,0.662502,1.0)),
        fieldValue(name='translation',value=(2.094394,-2.094393,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(2.0E-6,0.0,0.999998)),
        fieldValue(name='rotation',value=(0.0,0.0,1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.100003,1.0)),
        fieldValue(name='translation',value=(2.094394,-2.094393,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.374998,0.0,0.625002)),
        fieldValue(name='rotation',value=(0.707107,0.0,0.707107,0.61685)),
        fieldValue(name='scale',value=(1.0,0.662497,1.0)),
        fieldValue(name='translation',value=(2.094394,-2.094393,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.649518,0.0,0.350482)),
        fieldValue(name='rotation',value=(0.894427,0.0,0.447214,1.225778)),
        fieldValue(name='scale',value=(1.0,1.074277,1.0)),
        fieldValue(name='translation',value=(2.094394,-2.094393,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.866026,0.0,0.133974)),
        fieldValue(name='rotation',value=(-0.948683,0.0,0.316228,-1.560115)),
        fieldValue(name='scale',value=(1.0,1.399038,1.0)),
        fieldValue(name='translation',value=(2.094394,0.0,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.750001,0.0,0.249999)),
        fieldValue(name='rotation',value=(-0.894427,0.0,0.447214,-1.225778)),
        fieldValue(name='scale',value=(1.0,1.225001,1.0)),
        fieldValue(name='translation',value=(2.094394,0.0,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433014,0.0,0.566986)),
        fieldValue(name='rotation',value=(-0.707107,0.0,0.707107,-0.61685)),
        fieldValue(name='scale',value=(1.0,0.749521,1.0)),
        fieldValue(name='translation',value=(2.094394,0.0,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(2.0E-6,0.0,0.999998)),
        fieldValue(name='rotation',value=(0.0,0.0,1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.100003,1.0)),
        fieldValue(name='translation',value=(2.094394,0.0,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433011,0.0,0.566989)),
        fieldValue(name='rotation',value=(0.707107,0.0,0.707107,0.61685)),
        fieldValue(name='scale',value=(1.0,0.749516,1.0)),
        fieldValue(name='translation',value=(2.094394,0.0,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.749999,0.0,0.250001)),
        fieldValue(name='rotation',value=(0.894427,0.0,0.447214,1.225778)),
        fieldValue(name='scale',value=(1.0,1.224998,1.0)),
        fieldValue(name='translation',value=(2.094394,0.0,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.750001,0.0,0.249999)),
        fieldValue(name='rotation',value=(-0.948683,0.0,0.316228,-1.560115)),
        fieldValue(name='scale',value=(1.0,1.225001,1.0)),
        fieldValue(name='translation',value=(2.094394,2.094394,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.64952,0.0,0.35048)),
        fieldValue(name='rotation',value=(-0.894427,0.0,0.447214,-1.225778)),
        fieldValue(name='scale',value=(1.0,1.074281,1.0)),
        fieldValue(name='translation',value=(2.094394,2.094394,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.375002,0.0,0.624998)),
        fieldValue(name='rotation',value=(-0.707107,0.0,0.707107,-0.61685)),
        fieldValue(name='scale',value=(1.0,0.662503,1.0)),
        fieldValue(name='translation',value=(2.094394,2.094394,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(2.0E-6,0.0,0.999998)),
        fieldValue(name='rotation',value=(0.0,0.0,1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.100003,1.0)),
        fieldValue(name='translation',value=(2.094394,2.094394,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.374999,0.0,0.625001)),
        fieldValue(name='rotation',value=(0.707107,0.0,0.707107,0.61685)),
        fieldValue(name='scale',value=(1.0,0.662498,1.0)),
        fieldValue(name='translation',value=(2.094394,2.094394,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.649519,0.0,0.350481)),
        fieldValue(name='rotation',value=(0.894427,0.0,0.447214,1.225778)),
        fieldValue(name='scale',value=(1.0,1.074278,1.0)),
        fieldValue(name='translation',value=(2.094394,2.094394,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433014,0.0,0.566986)),
        fieldValue(name='rotation',value=(-0.948683,0.0,0.316228,-1.560115)),
        fieldValue(name='scale',value=(1.0,0.749521,1.0)),
        fieldValue(name='translation',value=(2.094394,4.188787,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.375002,0.0,0.624998)),
        fieldValue(name='rotation',value=(-0.894427,0.0,0.447214,-1.225778)),
        fieldValue(name='scale',value=(1.0,0.662503,1.0)),
        fieldValue(name='translation',value=(2.094394,4.188787,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216508,0.0,0.783492)),
        fieldValue(name='rotation',value=(-0.707107,0.0,0.707107,-0.61685)),
        fieldValue(name='scale',value=(1.0,0.424762,1.0)),
        fieldValue(name='translation',value=(2.094394,4.188787,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.0,0.0,1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.100002,1.0)),
        fieldValue(name='translation',value=(2.094394,4.188787,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216506,0.0,0.783494)),
        fieldValue(name='rotation',value=(0.707107,0.0,0.707107,0.61685)),
        fieldValue(name='scale',value=(1.0,0.424759,1.0)),
        fieldValue(name='translation',value=(2.094394,4.188787,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.375001,0.0,0.624999)),
        fieldValue(name='rotation',value=(0.894427,0.0,0.447214,1.225778)),
        fieldValue(name='scale',value=(1.0,0.662501,1.0)),
        fieldValue(name='translation',value=(2.094394,4.188787,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-0.83205,0.0,0.5547,-0.965883)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(4.188787,-6.28318,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-0.707107,0.0,0.707107,-0.61685)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(4.188787,-6.28318,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(-0.447213,0.0,0.894427,-0.214969)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(4.188787,-6.28318,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.0,0.0,1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(4.188787,-6.28318,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.447214,0.0,0.894427,0.214969)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(4.188787,-6.28318,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.0,0.0,1.0)),
        fieldValue(name='rotation',value=(0.707107,0.0,0.707107,0.61685)),
        fieldValue(name='scale',value=(1.0,0.1,1.0)),
        fieldValue(name='translation',value=(4.188787,-6.28318,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.25,0.0,0.75)),
        fieldValue(name='rotation',value=(-0.83205,0.0,0.5547,-0.965883)),
        fieldValue(name='scale',value=(1.0,0.475,1.0)),
        fieldValue(name='translation',value=(4.188787,-4.188787,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216507,0.0,0.783493)),
        fieldValue(name='rotation',value=(-0.707107,0.0,0.707107,-0.61685)),
        fieldValue(name='scale',value=(1.0,0.42476,1.0)),
        fieldValue(name='translation',value=(4.188787,-4.188787,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.125,0.0,0.875)),
        fieldValue(name='rotation',value=(-0.447213,0.0,0.894427,-0.214969)),
        fieldValue(name='scale',value=(1.0,0.287501,1.0)),
        fieldValue(name='translation',value=(4.188787,-4.188787,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.0,0.0,1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(4.188787,-4.188787,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.124999,0.0,0.875001)),
        fieldValue(name='rotation',value=(0.447214,0.0,0.894427,0.214969)),
        fieldValue(name='scale',value=(1.0,0.287499,1.0)),
        fieldValue(name='translation',value=(4.188787,-4.188787,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216506,0.0,0.783494)),
        fieldValue(name='rotation',value=(0.707107,0.0,0.707107,0.61685)),
        fieldValue(name='scale',value=(1.0,0.424759,1.0)),
        fieldValue(name='translation',value=(4.188787,-4.188787,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433013,0.0,0.566987)),
        fieldValue(name='rotation',value=(-0.83205,0.0,0.5547,-0.965883)),
        fieldValue(name='scale',value=(1.0,0.74952,1.0)),
        fieldValue(name='translation',value=(4.188787,-2.094393,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.375001,0.0,0.624999)),
        fieldValue(name='rotation',value=(-0.707107,0.0,0.707107,-0.61685)),
        fieldValue(name='scale',value=(1.0,0.662501,1.0)),
        fieldValue(name='translation',value=(4.188787,-2.094393,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216507,0.0,0.783493)),
        fieldValue(name='rotation',value=(-0.447213,0.0,0.894427,-0.214969)),
        fieldValue(name='scale',value=(1.0,0.424761,1.0)),
        fieldValue(name='translation',value=(4.188787,-2.094393,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.0,0.0,1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.100002,1.0)),
        fieldValue(name='translation',value=(4.188787,-2.094393,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216505,0.0,0.783495)),
        fieldValue(name='rotation',value=(0.447214,0.0,0.894427,0.214969)),
        fieldValue(name='scale',value=(1.0,0.424758,1.0)),
        fieldValue(name='translation',value=(4.188787,-2.094393,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.375,0.0,0.625)),
        fieldValue(name='rotation',value=(0.707107,0.0,0.707107,0.61685)),
        fieldValue(name='scale',value=(1.0,0.662499,1.0)),
        fieldValue(name='translation',value=(4.188787,-2.094393,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.500001,0.0,0.499999)),
        fieldValue(name='rotation',value=(-0.83205,0.0,0.5547,-0.965883)),
        fieldValue(name='scale',value=(1.0,0.850001,1.0)),
        fieldValue(name='translation',value=(4.188787,0.0,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433014,0.0,0.566986)),
        fieldValue(name='rotation',value=(-0.707107,0.0,0.707107,-0.61685)),
        fieldValue(name='scale',value=(1.0,0.74952,1.0)),
        fieldValue(name='translation',value=(4.188787,0.0,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.250001,0.0,0.749999)),
        fieldValue(name='rotation',value=(-0.447213,0.0,0.894427,-0.214969)),
        fieldValue(name='scale',value=(1.0,0.475002,1.0)),
        fieldValue(name='translation',value=(4.188787,0.0,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.0,0.0,1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.100002,1.0)),
        fieldValue(name='translation',value=(4.188787,0.0,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.249999,0.0,0.750001)),
        fieldValue(name='rotation',value=(0.447214,0.0,0.894427,0.214969)),
        fieldValue(name='scale',value=(1.0,0.474999,1.0)),
        fieldValue(name='translation',value=(4.188787,0.0,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433012,0.0,0.566988)),
        fieldValue(name='rotation',value=(0.707107,0.0,0.707107,0.61685)),
        fieldValue(name='scale',value=(1.0,0.749519,1.0)),
        fieldValue(name='translation',value=(4.188787,0.0,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.433014,0.0,0.566986)),
        fieldValue(name='rotation',value=(-0.83205,0.0,0.5547,-0.965883)),
        fieldValue(name='scale',value=(1.0,0.74952,1.0)),
        fieldValue(name='translation',value=(4.188787,2.094394,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.375001,0.0,0.624999)),
        fieldValue(name='rotation',value=(-0.707107,0.0,0.707107,-0.61685)),
        fieldValue(name='scale',value=(1.0,0.662502,1.0)),
        fieldValue(name='translation',value=(4.188787,2.094394,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216508,0.0,0.783492)),
        fieldValue(name='rotation',value=(-0.447213,0.0,0.894427,-0.214969)),
        fieldValue(name='scale',value=(1.0,0.424761,1.0)),
        fieldValue(name='translation',value=(4.188787,2.094394,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.0,0.0,1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.100002,1.0)),
        fieldValue(name='translation',value=(4.188787,2.094394,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216506,0.0,0.783494)),
        fieldValue(name='rotation',value=(0.447214,0.0,0.894427,0.214969)),
        fieldValue(name='scale',value=(1.0,0.424759,1.0)),
        fieldValue(name='translation',value=(4.188787,2.094394,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.375,0.0,0.625)),
        fieldValue(name='rotation',value=(0.707107,0.0,0.707107,0.61685)),
        fieldValue(name='scale',value=(1.0,0.6625,1.0)),
        fieldValue(name='translation',value=(4.188787,2.094394,4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.250001,0.0,0.749999)),
        fieldValue(name='rotation',value=(-0.83205,0.0,0.5547,-0.965883)),
        fieldValue(name='scale',value=(1.0,0.475002,1.0)),
        fieldValue(name='translation',value=(4.188787,4.188787,-6.28318))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216508,0.0,0.783492)),
        fieldValue(name='rotation',value=(-0.707107,0.0,0.707107,-0.61685)),
        fieldValue(name='scale',value=(1.0,0.424761,1.0)),
        fieldValue(name='translation',value=(4.188787,4.188787,-4.188787))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.125001,0.0,0.874999)),
        fieldValue(name='rotation',value=(-0.447213,0.0,0.894427,-0.214969)),
        fieldValue(name='scale',value=(1.0,0.287501,1.0)),
        fieldValue(name='translation',value=(4.188787,4.188787,-2.094393))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(1.0E-6,0.0,0.999999)),
        fieldValue(name='rotation',value=(0.0,0.0,1.0,0.0)),
        fieldValue(name='scale',value=(1.0,0.100001,1.0)),
        fieldValue(name='translation',value=(4.188787,4.188787,0.0))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.125,0.0,0.875)),
        fieldValue(name='rotation',value=(0.447214,0.0,0.894427,0.214969)),
        fieldValue(name='scale',value=(1.0,0.2875,1.0)),
        fieldValue(name='translation',value=(4.188787,4.188787,2.094394))]),
      ProtoInstance(name='Vector',
        fieldValue=[
        fieldValue(name='color',value=(0.216507,0.0,0.783493)),
        fieldValue(name='rotation',value=(0.707107,0.0,0.707107,0.61685)),
        fieldValue(name='scale',value=(1.0,0.42476,1.0)),
        fieldValue(name='translation',value=(4.188787,4.188787,4.188787))])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for VectorField1.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python VectorField1.py load and self-test diagnostics complete.")
