package Vrml2Sourcebook.Siggraph98Course;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Vector field: this world illustrates the use of an external prototype to define a generic vector. This scene uses the new vector node repeatedly to place, orient, scale, and color vectors throughout a visualization volume. </p>
 <p> Related links: Catalog page <a href="../../../Siggraph98Course/VectorField1Index.html" target="_blank">VectorField1</a>,  source <a href="../../../Siggraph98Course/VectorField1.java">VectorField1.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Siggraph98Course/VectorField1.x3d">VectorField1.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Vector field: this world illustrates the use of an external prototype to define a generic vector. This scene uses the new vector node repeatedly to place, orient, scale, and color vectors throughout a visualization volume. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> David R. Nadeau, John L. Moreland </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 1 July 1998 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 2 February 2014 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> originals/vecfld1.wrl </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.siggraph.org/s98" target="_blank">http://www.siggraph.org/s98</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.siggraph.org/s98/conference/courses/18.html" target="_blank">http://www.siggraph.org/s98/conference/courses/18.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0496.htm" target="_blank">http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0496.htm</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm" target="_blank">http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">https://www.web3d.org/x3d/content/examples/X3dResources.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/VectorField1.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/VectorField1.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Siggraph98Course/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author David R. Nadeau, John L. Moreland
 */

public class VectorField1
{
	/** Default constructor to create this object. */
	public VectorField1 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("VectorField1.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Vector field: this world illustrates the use of an external prototype to define a generic vector. This scene uses the new vector node repeatedly to place, orient, scale, and color vectors throughout a visualization volume."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("David R. Nadeau, John L. Moreland"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("1 July 1998"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("2 February 2014"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("originals/vecfld1.wrl"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.siggraph.org/s98"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.siggraph.org/s98/conference/courses/18.html"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0496.htm"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/x3d/content/examples/X3dResources.html"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/VectorField1.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setInfo(new String[] {"Copyright (c) 1997, David R. Nadeau, John L. Moreland"}).setTitle("Vector field"))
    .addChild(new ExternProtoDeclare("Vector").setName("Vector").setUrl(new String[] {"Vector.x3d#Vector","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Vector.x3d#Vector","Vector.wrl#Vector","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Vector.wrl#Vector"})
      .addField(new field().setName("color").setType(field.TYPE_SFCOLOR).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
      .addField(new field().setName("rotation").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
      .addField(new field().setName("scale").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
      .addField(new field().setName("translation").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)))
    .addChild(new Viewpoint().setDescription("Entry view").setPosition(0.0,0.0,20.0))
    .addChild(new NavigationInfo())
    .addChild(new Transform().setBboxSize(13.0,13.0,13.0).setTranslation(1.047196,1.047196,1.047196)
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setDiffuseColor(1.0,1.0,1.0).setEmissiveColor(1.0,1.0,1.0)))
        .setGeometry(new IndexedLineSet().setCoordIndex(new int[] {0,1,2,3,0,-1,7,6,5,4,7,-1,0,4,-1,1,5,-1,2,6,-1,3,7,-1})
          .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-6.28318,4.188787,-6.28318,4.188787,4.188787,-6.28318,4.188787,4.188787,4.188787,-6.28318,4.188787,4.188787,-6.28318,-6.28318,-6.28318,4.188787,-6.28318,-6.28318,4.188787,-6.28318,4.188787,-6.28318,-6.28318,4.188787})))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,-0.707107,-1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,-6.28318,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.5547,0.0,-0.83205,-1.501518)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,-6.28318,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.316228,0.0,-0.948683,-0.907286)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,-6.28318,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,-1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,-6.28318,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.316228,0.0,-0.948683,0.907286)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,-6.28318,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.5547,0.0,-0.83205,1.501518)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,-6.28318,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,-0.707107,-1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,-4.188787,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.5547,0.0,-0.83205,-1.501518)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,-4.188787,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.316228,0.0,-0.948683,-0.907286)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,-4.188787,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,-1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,-4.188787,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.316228,0.0,-0.948683,0.907286)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,-4.188787,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.5547,0.0,-0.83205,1.501518)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,-4.188787,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,-0.707107,-1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,-2.094393,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.5547,0.0,-0.83205,-1.501518)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,-2.094393,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.316228,0.0,-0.948683,-0.907286)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,-2.094393,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,-1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,-2.094393,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.316228,0.0,-0.948683,0.907286)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,-2.094393,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.5547,0.0,-0.83205,1.501518)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,-2.094393,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,-0.707107,-1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,0.0,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.5547,0.0,-0.83205,-1.501518)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,0.0,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.316228,0.0,-0.948683,-0.907286)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,0.0,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,-1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,0.0,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.316228,0.0,-0.948683,0.907286)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,0.0,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.5547,0.0,-0.83205,1.501518)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,0.0,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,-0.707107,-1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,2.094394,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.5547,0.0,-0.83205,-1.501518)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,2.094394,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.316228,0.0,-0.948683,-0.907286)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,2.094394,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,-1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,2.094394,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.316228,0.0,-0.948683,0.907286)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,2.094394,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.5547,0.0,-0.83205,1.501518)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,2.094394,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,-0.707107,-1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,4.188787,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.5547,0.0,-0.83205,-1.501518)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,4.188787,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.316228,0.0,-0.948683,-0.907286)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,4.188787,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,-1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,4.188787,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.316228,0.0,-0.948683,0.907286)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,4.188787,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.5547,0.0,-0.83205,1.501518)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-6.28318,4.188787,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.83205,0.0,-0.5547,-2.121654)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,-6.28318,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,-0.707107,-1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,-6.28318,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.447214,0.0,-0.894427,-1.241623)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,-6.28318,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,-1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,-6.28318,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.447214,0.0,-0.894427,1.241623)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,-6.28318,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,-0.707107,1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,-6.28318,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.25,0.0,0.75)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.83205,0.0,-0.5547,-2.121654)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.475,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,-4.188787,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216507,0.0,0.783493)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,-0.707107,-1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.42476,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,-4.188787,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.125001,0.0,0.874999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.447214,0.0,-0.894427,-1.241623)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.287501,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,-4.188787,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,-1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,-4.188787,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.125,0.0,0.875)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.447214,0.0,-0.894427,1.241623)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.287499,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,-4.188787,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216506,0.0,0.783494)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,-0.707107,1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424759,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,-4.188787,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433013,0.0,0.566987)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.83205,0.0,-0.5547,-2.121654)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.74952,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,-2.094393,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.375001,0.0,0.624999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,-0.707107,-1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.662501,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,-2.094393,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216507,0.0,0.783493)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.447214,0.0,-0.894427,-1.241623)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424761,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,-2.094393,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,-1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,-2.094393,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216506,0.0,0.783494)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.447214,0.0,-0.894427,1.241623)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424758,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,-2.094393,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.375,0.0,0.625)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,-0.707107,1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.6625,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,-2.094393,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.500001,0.0,0.499999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.83205,0.0,-0.5547,-2.121654)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.850001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,0.0,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433014,0.0,0.566986)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,-0.707107,-1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.749521,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,0.0,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.250001,0.0,0.749999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.447214,0.0,-0.894427,-1.241623)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.475002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,0.0,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,-1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,0.0,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.249999,0.0,0.750001)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.447214,0.0,-0.894427,1.241623)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.474999,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,0.0,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433013,0.0,0.566987)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,-0.707107,1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.749519,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,0.0,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433014,0.0,0.566986)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.83205,0.0,-0.5547,-2.121654)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.749521,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,2.094394,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.375001,0.0,0.624999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,-0.707107,-1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.662502,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,2.094394,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216508,0.0,0.783492)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.447214,0.0,-0.894427,-1.241623)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424761,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,2.094394,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,-1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,2.094394,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216506,0.0,0.783494)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.447214,0.0,-0.894427,1.241623)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424759,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,2.094394,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.375,0.0,0.625)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,-0.707107,1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.6625,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,2.094394,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.250001,0.0,0.749999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.83205,0.0,-0.5547,-2.121654)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.475002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,4.188787,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216508,0.0,0.783492)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,-0.707107,-1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424761,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,4.188787,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.125001,0.0,0.874999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.447214,0.0,-0.894427,-1.241623)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.287502,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,4.188787,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,-1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,4.188787,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.125,0.0,0.875)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.447214,0.0,-0.894427,1.241623)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.2875,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,4.188787,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216507,0.0,0.783493)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,-0.707107,1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424761,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-4.188787,4.188787,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.948683,0.0,-0.316228,-2.363877)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,-6.28318,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.894427,0.0,-0.447214,-2.252432)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,-6.28318,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,-0.707107,-1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,-6.28318,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,-1.0,1.0E-6)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,-6.28318,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,-0.707107,1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,-6.28318,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.894427,0.0,-0.447213,2.252432)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,-6.28318,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433013,0.0,0.566987)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.948683,0.0,-0.316228,-2.363877)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.749519,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,-4.188787,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.375,0.0,0.625)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.894427,0.0,-0.447214,-2.252432)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.6625,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,-4.188787,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216507,0.0,0.783493)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,-0.707107,-1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424761,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,-4.188787,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,-1.0,1.0E-6)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,-4.188787,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216505,0.0,0.783495)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,-0.707107,1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424758,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,-4.188787,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.374999,0.0,0.625001)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.894427,0.0,-0.447213,2.252432)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.662499,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,-4.188787,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.75,0.0,0.25)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.948683,0.0,-0.316228,-2.363877)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.225,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,-2.094393,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.64952,0.0,0.35048)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.894427,0.0,-0.447214,-2.252432)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.074279,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,-2.094393,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.375001,0.0,0.624999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,-0.707107,-1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.662502,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,-2.094393,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(2.0E-6,0.0,0.999998)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,-1.0,1.0E-6)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100003,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,-2.094393,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.374998,0.0,0.625002)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,-0.707107,1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.662497,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,-2.094393,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.649518,0.0,0.350482)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.894427,0.0,-0.447213,2.252432)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.074277,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,-2.094393,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.866026,0.0,0.133974)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.948683,0.0,-0.316228,-2.363877)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.399039,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,0.0,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.750001,0.0,0.249999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.894427,0.0,-0.447214,-2.252432)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.225001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,0.0,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433014,0.0,0.566986)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,-0.707107,-1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.749521,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,0.0,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(2.0E-6,0.0,0.999998)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,-1.0,1.0E-6)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100003,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,0.0,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433011,0.0,0.566989)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,-0.707107,1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.749516,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,0.0,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.749999,0.0,0.250001)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.894427,0.0,-0.447213,2.252432)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.224998,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,0.0,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.750001,0.0,0.249999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.948683,0.0,-0.316228,-2.363877)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.225001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,2.094394,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.64952,0.0,0.35048)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.894427,0.0,-0.447214,-2.252432)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.074281,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,2.094394,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.375002,0.0,0.624998)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,-0.707107,-1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.662503,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,2.094394,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(2.0E-6,0.0,0.999998)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,-1.0,1.0E-6)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100003,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,2.094394,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.374999,0.0,0.625001)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,-0.707107,1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.662498,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,2.094394,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.649519,0.0,0.350481)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.894427,0.0,-0.447213,2.252432)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.074278,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,2.094394,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433014,0.0,0.566986)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.948683,0.0,-0.316228,-2.363877)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.749521,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,4.188787,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.375002,0.0,0.624998)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.894427,0.0,-0.447214,-2.252432)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.662503,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,4.188787,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216508,0.0,0.783492)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,-0.707107,-1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424762,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,4.188787,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,-1.0,1.0E-6)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,4.188787,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216506,0.0,0.783494)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,-0.707107,1.850551)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424759,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,4.188787,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.375001,0.0,0.624999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.894427,0.0,-0.447213,2.252432)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.662501,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(-2.094393,4.188787,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-1.0,0.0,0.0,-2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,-6.28318,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-1.0,0.0,0.0,-2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,-6.28318,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-1.0,0.0,0.0,-2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,-6.28318,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,0.707107,0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,-6.28318,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(1.0,0.0,0.0,2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,-6.28318,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(1.0,0.0,0.0,2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,-6.28318,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.5,0.0,0.5)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-1.0,0.0,0.0,-2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.85,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,-4.188787,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433013,0.0,0.566987)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-1.0,0.0,0.0,-2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.749519,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,-4.188787,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.250001,0.0,0.749999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-1.0,0.0,0.0,-2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.475001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,-4.188787,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,0.707107,0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,-4.188787,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.249999,0.0,0.750001)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(1.0,0.0,0.0,2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.474998,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,-4.188787,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433012,0.0,0.566988)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(1.0,0.0,0.0,2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.749517,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,-4.188787,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.866025,0.0,0.133975)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-1.0,0.0,0.0,-2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.399038,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,-2.094393,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.75,0.0,0.25)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-1.0,0.0,0.0,-2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.225001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,-2.094393,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433014,0.0,0.566986)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-1.0,0.0,0.0,-2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.749521,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,-2.094393,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(2.0E-6,0.0,0.999998)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,0.707107,0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100003,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,-2.094393,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.43301,0.0,0.56699)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(1.0,0.0,0.0,2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.749516,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,-2.094393,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.749998,0.0,0.250002)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(1.0,0.0,0.0,2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.224997,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,-2.094393,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0,0.0,0.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-1.0,0.0,0.0,-2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.6,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,0.0,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.866026,0.0,0.133974)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-1.0,0.0,0.0,-2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.399039,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,0.0,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.500002,0.0,0.499998)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-1.0,0.0,0.0,-2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.850003,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,0.0,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(3.0E-6,0.0,0.999997)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,0.707107,0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100004,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,0.0,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.499997,0.0,0.500003)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(1.0,0.0,0.0,2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.849996,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,0.0,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.866024,0.0,0.133976)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(1.0,0.0,0.0,2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.399036,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,0.0,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.866026,0.0,0.133974)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-1.0,0.0,0.0,-2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.399039,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,2.094394,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.750001,0.0,0.249999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-1.0,0.0,0.0,-2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.225002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,2.094394,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433015,0.0,0.566985)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-1.0,0.0,0.0,-2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.749522,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,2.094394,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(2.0E-6,0.0,0.999998)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,0.707107,0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100003,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,2.094394,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433011,0.0,0.566989)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(1.0,0.0,0.0,2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.749516,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,2.094394,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.749999,0.0,0.250001)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(1.0,0.0,0.0,2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.224999,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,2.094394,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.500002,0.0,0.499998)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-1.0,0.0,0.0,-2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.850003,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,4.188787,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433015,0.0,0.566985)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-1.0,0.0,0.0,-2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.749522,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,4.188787,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.250002,0.0,0.749998)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-1.0,0.0,0.0,-2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.475003,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,4.188787,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,0.707107,0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,4.188787,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.25,0.0,0.75)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(1.0,0.0,0.0,2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.474999,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,4.188787,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433013,0.0,0.566987)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(1.0,0.0,0.0,2.467401)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.74952,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(0.0,4.188787,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.948683,0.0,0.316228,-1.560115)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,-6.28318,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.894427,0.0,0.447214,-1.225778)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,-6.28318,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,0.707107,-0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,-6.28318,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,-6.28318,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,0.707107,0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,-6.28318,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.894427,0.0,0.447214,1.225778)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,-6.28318,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433013,0.0,0.566988)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.948683,0.0,0.316228,-1.560115)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.749519,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,-4.188787,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.375,0.0,0.625)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.894427,0.0,0.447214,-1.225778)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.6625,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,-4.188787,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216507,0.0,0.783493)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,0.707107,-0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.42476,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,-4.188787,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,-4.188787,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216505,0.0,0.783495)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,0.707107,0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424758,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,-4.188787,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.374999,0.0,0.625001)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.894427,0.0,0.447214,1.225778)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.662499,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,-4.188787,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.75,0.0,0.25)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.948683,0.0,0.316228,-1.560115)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.225,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,-2.094393,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.64952,0.0,0.35048)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.894427,0.0,0.447214,-1.225778)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.074279,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,-2.094393,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.375001,0.0,0.624999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,0.707107,-0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.662502,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,-2.094393,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(2.0E-6,0.0,0.999998)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100003,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,-2.094393,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.374998,0.0,0.625002)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,0.707107,0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.662497,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,-2.094393,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.649518,0.0,0.350482)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.894427,0.0,0.447214,1.225778)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.074277,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,-2.094393,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.866026,0.0,0.133974)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.948683,0.0,0.316228,-1.560115)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.399038,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,0.0,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.750001,0.0,0.249999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.894427,0.0,0.447214,-1.225778)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.225001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,0.0,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433014,0.0,0.566986)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,0.707107,-0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.749521,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,0.0,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(2.0E-6,0.0,0.999998)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100003,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,0.0,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433011,0.0,0.566989)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,0.707107,0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.749516,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,0.0,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.749999,0.0,0.250001)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.894427,0.0,0.447214,1.225778)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.224998,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,0.0,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.750001,0.0,0.249999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.948683,0.0,0.316228,-1.560115)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.225001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,2.094394,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.64952,0.0,0.35048)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.894427,0.0,0.447214,-1.225778)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.074281,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,2.094394,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.375002,0.0,0.624998)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,0.707107,-0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.662503,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,2.094394,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(2.0E-6,0.0,0.999998)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100003,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,2.094394,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.374999,0.0,0.625001)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,0.707107,0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.662498,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,2.094394,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.649519,0.0,0.350481)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.894427,0.0,0.447214,1.225778)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,1.074278,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,2.094394,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433014,0.0,0.566986)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.948683,0.0,0.316228,-1.560115)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.749521,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,4.188787,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.375002,0.0,0.624998)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.894427,0.0,0.447214,-1.225778)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.662503,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,4.188787,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216508,0.0,0.783492)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,0.707107,-0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424762,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,4.188787,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,4.188787,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216506,0.0,0.783494)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,0.707107,0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424759,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,4.188787,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.375001,0.0,0.624999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.894427,0.0,0.447214,1.225778)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.662501,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(2.094394,4.188787,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.83205,0.0,0.5547,-0.965883)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,-6.28318,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,0.707107,-0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,-6.28318,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.447213,0.0,0.894427,-0.214969)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,-6.28318,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,-6.28318,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.447214,0.0,0.894427,0.214969)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,-6.28318,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,0.707107,0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.1,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,-6.28318,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.25,0.0,0.75)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.83205,0.0,0.5547,-0.965883)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.475,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,-4.188787,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216507,0.0,0.783493)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,0.707107,-0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.42476,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,-4.188787,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.125,0.0,0.875)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.447213,0.0,0.894427,-0.214969)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.287501,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,-4.188787,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,-4.188787,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.124999,0.0,0.875001)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.447214,0.0,0.894427,0.214969)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.287499,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,-4.188787,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216506,0.0,0.783494)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,0.707107,0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424759,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,-4.188787,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433013,0.0,0.566987)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.83205,0.0,0.5547,-0.965883)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.74952,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,-2.094393,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.375001,0.0,0.624999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,0.707107,-0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.662501,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,-2.094393,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216507,0.0,0.783493)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.447213,0.0,0.894427,-0.214969)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424761,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,-2.094393,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,-2.094393,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216505,0.0,0.783495)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.447214,0.0,0.894427,0.214969)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424758,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,-2.094393,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.375,0.0,0.625)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,0.707107,0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.662499,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,-2.094393,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.500001,0.0,0.499999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.83205,0.0,0.5547,-0.965883)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.850001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,0.0,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433014,0.0,0.566986)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,0.707107,-0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.74952,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,0.0,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.250001,0.0,0.749999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.447213,0.0,0.894427,-0.214969)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.475002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,0.0,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,0.0,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.249999,0.0,0.750001)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.447214,0.0,0.894427,0.214969)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.474999,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,0.0,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433012,0.0,0.566988)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,0.707107,0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.749519,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,0.0,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.433014,0.0,0.566986)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.83205,0.0,0.5547,-0.965883)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.74952,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,2.094394,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.375001,0.0,0.624999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,0.707107,-0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.662502,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,2.094394,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216508,0.0,0.783492)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.447213,0.0,0.894427,-0.214969)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424761,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,2.094394,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,2.094394,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216506,0.0,0.783494)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.447214,0.0,0.894427,0.214969)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424759,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,2.094394,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.375,0.0,0.625)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,0.707107,0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.6625,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,2.094394,4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.250001,0.0,0.749999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.83205,0.0,0.5547,-0.965883)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.475002,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,4.188787,-6.28318))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216508,0.0,0.783492)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.707107,0.0,0.707107,-0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.424761,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,4.188787,-4.188787))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.125001,0.0,0.874999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(-0.447213,0.0,0.894427,-0.214969)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.287501,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,4.188787,-2.094393))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(1.0E-6,0.0,0.999999)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.0,0.0,1.0,0.0)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.100001,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,4.188787,0.0))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.125,0.0,0.875)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.447214,0.0,0.894427,0.214969)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.2875,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,4.188787,2.094394))))
      .addChild(new ProtoInstance("Vector").setContainerField("children")
        .addFieldValue(new fieldValue().setName("color").setValue(new SFColor(0.216507,0.0,0.783493)))
        .addFieldValue(new fieldValue().setName("rotation").setValue(new SFRotation(0.707107,0.0,0.707107,0.61685)))
        .addFieldValue(new fieldValue().setName("scale").setValue(new SFVec3f(1.0,0.42476,1.0)))
        .addFieldValue(new fieldValue().setName("translation").setValue(new SFVec3f(4.188787,4.188787,4.188787))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return VectorField1 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new VectorField1().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Vrml2Sourcebook.Siggraph98Course.VectorField1\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Vrml2Sourcebook.Siggraph98Course.VectorField1 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Siggraph98Course/VectorField1_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Siggraph98Course/VectorField1_JavaExport.x3d"; 
                String filenameX3DV = "Siggraph98Course/VectorField1_JavaExport.x3dv"; 
                String filenameJSON = "Siggraph98Course/VectorField1_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
