package Vrml2Sourcebook.Siggraph98Course;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> The Stairway world uses a twisting, branching, floating stairway to lead the visitor to six doorways. Each doorway is a selectable anchor leading to another world. </p>
 <p> Related links: Catalog page <a href="../../../Siggraph98Course/StairwayIndex.html" target="_blank">Stairway</a>,  source <a href="../../../Siggraph98Course/Stairway.java">Stairway.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Siggraph98Course/Stairway.x3d">Stairway.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> The Stairway world uses a twisting, branching, floating stairway to lead the visitor to six doorways. Each doorway is a selectable anchor leading to another world. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> David R. Nadeau </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 1 July 1998 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 2 February 2014 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 16 December 2023 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> originals/stairwy.wrl </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.siggraph.org/s98" target="_blank">http://www.siggraph.org/s98</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.siggraph.org/s98/conference/courses/18.html" target="_blank">http://www.siggraph.org/s98/conference/courses/18.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0095.htm" target="_blank">http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0095.htm</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm" target="_blank">http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">https://www.web3d.org/x3d/content/examples/X3dResources.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Stairway.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Stairway.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Siggraph98Course/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author David R. Nadeau
 */

public class Stairway
{
	/** Default constructor to create this object. */
	public Stairway ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERACTIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("Stairway.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("The Stairway world uses a twisting, branching, floating stairway to lead the visitor to six doorways. Each doorway is a selectable anchor leading to another world."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("David R. Nadeau"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("1 July 1998"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("2 February 2014"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("16 December 2023"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("originals/stairwy.wrl"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.siggraph.org/s98"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.siggraph.org/s98/conference/courses/18.html"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0095.htm"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/x3d/content/examples/X3dResources.html"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Stairway.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addComments(" This world was *hand authored*, which is way tough to do given the number of stairs to be positioned and oriented. This accounts for the heavy use of DEF and USE and rather convoluted nested transforms. By using a world builder application (when they become available), you can position each stair or group of stairs interactively, instead of typing in translations and rotations and hoping they work out. ")
    .addComments(" Things to experiment with: ")
    .addComments(" Change the anchor urls to point to your own worlds. ")
    .addComments(" Add a flock of birds following a path animated by a PositionInterpolator and an OrientationInterpolator. ")
    .addComments(" Drop the sky background wall and replace it with a Background node. ")
    .addComments(" Add sound. Perhaps a gentle wind with some occasional wind chimes. ")
    .addChild(new WorldInfo().setInfo(new String[] {"copyright (c) 1997, David R. Nadeau"}).setTitle("The Stairway"))
    .addChild(new Background().setSkyAngle(new double[] {1.37,1.57,1.77}).setSkyColor(new MFColor(new double[] {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.1,0.5,0.0,0.0,0.0})))
    .addChild(new Transform().setScale(0.4,0.4,0.4)
      .addChild(new Viewpoint().setDescription("Entry view").setOrientation(1.0,0.0,0.0,0.1).setPosition(9.0,-5.0,25.0))
      .addChild(new NavigationInfo().setAvatarSize(new double[] {0.5,4.0,1.5}).setHeadlight(false).setSpeed(4.0).setType("\"WALK\" \"ANY\""))
      .addChild(new DirectionalLight().setColor(0.0,0.3,1.0).setDirection(-3.0,2.0,-1.0))
      .addChild(new PointLight().setAmbientIntensity(0.3).setLocation(14.0,10.0,14.0))
      .addChild(new Transform().setTranslation(5.0,-3.0,5.0)
        .addChild(new Shape("Platform")
          .setAppearance(new Appearance("Marble")
            .setMaterial(new Material().setDiffuseColor(1.0,1.0,1.0))
            .setTexture(new ImageTexture().setUrl(new String[] {"marble_g.jpg","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/marble_g.jpg"})))
          .setGeometry(new Box().setSize(4.0,0.25,4.0))))
      .addChild(new Transform().setTranslation(5.0,-2.5,2.5)
        .addChild(new Group("ThreeUpStraightStairs")
          .addChild(new Shape("Stair")
            .setAppearance(new Appearance().setUSE("Marble"))
            .setGeometry(new Box().setSize(4.0,0.25,1.0)))
          .addChild(new Transform().setTranslation(0.0,0.5,-1.0)
            .addChild(new Shape().setUSE("Stair")))
          .addChild(new Transform().setTranslation(0.0,1.0,-2.0)
            .addChild(new Shape().setUSE("Stair")))))
      .addChild(new Transform().setTranslation(5.0,-1.0,-0.5)
        .addChild(new Group().setUSE("ThreeUpStraightStairs")))
      .addChild(new Transform().setTranslation(5.0,0.5,-5.0)
        .addChild(new Shape().setUSE("Platform")))
      .addChild(new Transform().setTranslation(5.0,1.0,-7.5)
        .addChild(new Group().setUSE("ThreeUpStraightStairs")))
      .addChild(new Transform().setTranslation(5.0,5.0,-10.1)
        .addChild(new Anchor().setDescription("Temple of the Orb").setUrl(new String[] {"Temple.x3d","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Temple.x3d","Temple.wrl","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Temple.wrl"})
          .addChild(new Group("Door")
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setTextureTransform(new TextureTransform().setScale(1.0,2.0))
                .setMaterial(new Material().setDiffuseColor(1.0,1.0,1.0))
                .setTexture(new ImageTexture().setUrl(new String[] {"panel.jpg","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/panel.jpg"})))
              .setGeometry(new Box().setSize(3.0,6.0,0.2)))
            .addChild(new Transform().setTranslation(1.18,-0.0,0.2)
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(1.0,1.0,1.0))
                  .setTexture(new ImageTexture().setUrl(new String[] {"blur.jpg","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/blur.jpg"})))
                .setGeometry(new Sphere().setRadius(0.15)))))))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(2.5,1.0,-5.0)
        .addChild(new Transform("ThreeUpRightCurvingStairs").setTranslation(5.0,0.0,0.0)
          .addChild(new Transform("OffToLeftStair").setTranslation(-5.0,0.0,0.0)
            .addChild(new Shape().setUSE("Stair")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.26).setTranslation(0.0,0.5,0.0)
            .addChild(new Transform().setUSE("OffToLeftStair")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.52).setTranslation(0.0,1.0,0.0)
            .addChild(new Transform().setUSE("OffToLeftStair")))))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(2.5,2.5,-5.0)
        .addChild(new Transform().setCenter(5.0,0.0,0.0).setRotation(0.0,1.0,0.0,-0.785)
          .addChild(new Transform().setUSE("ThreeUpRightCurvingStairs"))))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(2.5,4.0,-5.0)
        .addChild(new Transform().setCenter(5.0,0.0,0.0).setRotation(0.0,1.0,0.0,-1.57)
          .addChild(new Transform().setUSE("ThreeUpRightCurvingStairs"))))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(2.5,5.0,-5.0)
        .addChild(new Transform().setCenter(5.0,0.0,0.0).setRotation(0.0,1.0,0.0,-2.09)
          .addChild(new Transform().setTranslation(0.0,3.0,-0.6)
            .addChild(new Anchor().setDescription("Primitives on Pedestals").setUrl(new String[] {"Primitives.x3d","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Primitives.x3d","Primitives.wrl","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Primitives.wrl"})
              .addChild(new Group().setUSE("Door"))))))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(7.5,0.0,-5.0)
        .addChild(new Transform("ThreeDownLeftCurvingStairs").setTranslation(5.0,0.0,0.0)
          .addChild(new Transform().setUSE("OffToLeftStair"))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.26).setTranslation(0.0,-0.5,0.0)
            .addChild(new Transform().setUSE("OffToLeftStair")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.52).setTranslation(0.0,-1.0,0.0)
            .addChild(new Transform().setUSE("OffToLeftStair")))))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(7.5,-1.5,-5.0)
        .addChild(new Transform().setCenter(5.0,0.0,0.0).setRotation(0.0,1.0,0.0,0.785)
          .addChild(new Transform().setUSE("ThreeDownLeftCurvingStairs"))))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(7.5,-2.5,-5.0)
        .addChild(new Transform().setCenter(5.0,0.0,0.0).setRotation(0.0,1.0,0.0,1.31)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,3.14).setTranslation(0.0,3.0,0.6)
            .addChild(new Anchor().setDescription("The Doorway").setUrl(new String[] {"Doorway.x3d","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Doorway.x3d","Doorway.wrl","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Doorway.wrl"})
              .addChild(new Group().setUSE("Door"))))))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(2.5,-2.5,5.0)
        .addChild(new Group().setUSE("ThreeUpStraightStairs")))
      .addChild(new Transform().setTranslation(-2.0,-1.0,5.0)
        .addChild(new Shape().setUSE("Platform")))
      .addChild(new Transform().setTranslation(-2.0,-0.5,2.5)
        .addChild(new Transform("ThreeUpLeftCurvingStairs").setTranslation(-5.0,0.0,0.0)
          .addChild(new Transform("OffToRightStair").setTranslation(5.0,0.0,0.0)
            .addChild(new Shape().setUSE("Stair")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.26).setTranslation(0.0,0.5,0.0)
            .addChild(new Transform().setUSE("OffToRightStair")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.52).setTranslation(0.0,1.0,0.0)
            .addChild(new Transform().setUSE("OffToRightStair")))))
      .addChild(new Transform().setTranslation(-2.0,0.5,2.5)
        .addChild(new Transform().setCenter(-5.0,0.0,0.0).setRotation(0.0,1.0,0.0,0.52)
          .addChild(new Transform().setTranslation(0.0,3.0,-0.6)
            .addChild(new Anchor().setDescription("Monolith World").setUrl(new String[] {"Monolith.x3d","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Monolith.x3d","Monolith.wrl","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Monolith.wrl"})
              .addChild(new Group().setUSE("Door"))))))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(-4.5,-0.5,5.0)
        .addChild(new Group().setUSE("ThreeUpStraightStairs")))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(-7.5,1.0,5.0)
        .addChild(new Group().setUSE("ThreeUpStraightStairs")))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(-10.1,5.0,5.0)
        .addChild(new Anchor().setDescription("The Tower").setUrl(new String[] {"Towers.x3d","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Towers.x3d","Towers.wrl","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Towers.wrl"})
          .addChild(new Group().setUSE("Door"))))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(9.5,-4.5,5.0)
        .addChild(new Group().setUSE("ThreeUpStraightStairs")))
      .addChild(new Transform().setTranslation(12.0,-5.0,5.0)
        .addChild(new Shape().setUSE("Platform")))
      .addChild(new Transform().setTranslation(12.0,-6.5,9.5)
        .addChild(new Group().setUSE("ThreeUpStraightStairs")))
      .addChild(new Transform().setTranslation(12.0,-7.0,12.0)
        .addChild(new Shape().setUSE("Platform")))
      .addChild(new Transform().setTranslation(12.0,-8.5,16.5)
        .addChild(new Group().setUSE("ThreeUpStraightStairs")))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,3.14).setTranslation(5.0,-3.5,7.5)
        .addChild(new Transform("ThreeDownRightCurvingStairs").setTranslation(5.0,0.0,0.0)
          .addChild(new Transform().setUSE("OffToLeftStair"))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.26).setTranslation(0.0,-0.5,0.0)
            .addChild(new Transform().setUSE("OffToLeftStair")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.52).setTranslation(0.0,-1.0,0.0)
            .addChild(new Transform().setUSE("OffToLeftStair")))))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,3.14).setTranslation(5.0,-5.0,7.5)
        .addChild(new Transform().setCenter(5.0,0.0,0.0).setRotation(0.0,1.0,0.0,-0.785)
          .addChild(new Transform().setUSE("ThreeDownRightCurvingStairs"))))
      .addChild(new Transform().setTranslation(5.0,-6.0,7.5)
        .addChild(new Transform().setCenter(-5.0,0.0,0.0).setRotation(0.0,1.0,0.0,-1.48)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,3.14).setTranslation(0.0,3.0,-0.6)
            .addChild(new Anchor().setDescription("Robot Bill").setUrl(new String[] {"RoboBill.x3d","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/RoboBill.x3d","RoboBill.wrl","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/RoboBill.wrl"})
              .addChild(new Group().setUSE("Door"))))))
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setTextureTransform(new TextureTransform().setScale(20.0,20.0))
          .setMaterial(new Material().setAmbientIntensity(0.3))
          .setTexture(new ImageTexture().setUrl(new String[] {"stone2.jpg","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/stone2.jpg"})))
        .setGeometry(new IndexedFaceSet().setSolid(false).setCoordIndex(new int[] {0,1,2,3,-1})
          .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-30.0,-9.0,30.0,30.0,-9.0,30.0,30.0,-9.0,-30.0,-30.0,-9.0,-30.0})))))
      .addChild(new Shape()
        .setAppearance(new Appearance("ShadowColor")
          .setMaterial(new Material().setAmbientIntensity(0.0).setDiffuseColor(0.1,0.1,0.1).setTransparency(0.25)))
        .setGeometry(new IndexedFaceSet().setCoordIndex(new int[] {0,1,2,3,-1,4,5,6,7,-1,8,9,10,11,-1})
          .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {10.0,-8.5,17.0,14.0,-8.5,17.0,14.0,-8.5,3.0,10.0,-8.5,3.0,-10.0,-8.5,7.0,10.0,-8.5,7.0,10.0,-8.5,3.0,-10.0,-8.5,3.0,3.0,-8.5,7.0,7.0,-8.5,7.0,7.0,-8.5,-10.0,3.0,-8.5,-10.0})))))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(2.5,-8.5,-5.0)
        .addChild(new Transform("ThreeUpRightCurvingShadows").setTranslation(5.0,0.0,0.0)
          .addChild(new Transform("OffToLeftShadow").setTranslation(-5.0,0.0,0.0)
            .addChild(new Shape("Shadow")
              .setAppearance(new Appearance().setUSE("ShadowColor"))
              .setGeometry(new IndexedFaceSet().setCoordIndex(new int[] {0,1,2,3,-1})
                .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-2.0,0.0,0.5,2.0,0.0,0.5,2.0,0.0,-0.5,-2.0,0.0,-0.5}))))))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.26)
            .addChild(new Transform().setUSE("OffToLeftShadow")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.52)
            .addChild(new Transform().setUSE("OffToLeftShadow")))))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(2.5,-8.5,-5.0)
        .addChild(new Transform().setCenter(5.0,0.0,0.0).setRotation(0.0,1.0,0.0,-0.785)
          .addChild(new Transform().setUSE("ThreeUpRightCurvingShadows"))))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(2.5,-8.5,-5.0)
        .addChild(new Transform().setCenter(5.0,0.0,0.0).setRotation(0.0,1.0,0.0,-1.57)
          .addChild(new Transform().setUSE("ThreeUpRightCurvingShadows"))))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(7.5,-8.5,-5.0)
        .addChild(new Transform("ThreeDownLeftCurvingShadows").setTranslation(5.0,0.0,0.0)
          .addChild(new Transform().setUSE("OffToLeftShadow"))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.26)
            .addChild(new Transform().setUSE("OffToLeftShadow")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.52)
            .addChild(new Transform().setUSE("OffToLeftShadow")))))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(7.5,-8.5,-5.0)
        .addChild(new Transform().setCenter(5.0,0.0,0.0).setRotation(0.0,1.0,0.0,0.785)
          .addChild(new Transform().setUSE("ThreeDownLeftCurvingShadows"))))
      .addChild(new Transform().setTranslation(-2.0,-8.5,2.5)
        .addChild(new Transform("ThreeUpLeftCurvingShadows").setTranslation(-5.0,0.0,0.0)
          .addChild(new Transform("OffToRightShadow").setTranslation(5.0,0.0,0.0)
            .addChild(new Shape().setUSE("Shadow")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.26)
            .addChild(new Transform().setUSE("OffToRightShadow")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.52)
            .addChild(new Transform().setUSE("OffToRightShadow")))))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,3.14).setTranslation(5.0,-8.5,7.5)
        .addChild(new Transform("ThreeDownRightCurvingShadows").setTranslation(5.0,0.0,0.0)
          .addChild(new Transform().setUSE("OffToLeftShadow"))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.26)
            .addChild(new Transform().setUSE("OffToLeftShadow")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.52)
            .addChild(new Transform().setUSE("OffToLeftShadow")))))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,3.14).setTranslation(5.0,-8.5,7.5)
        .addChild(new Transform().setCenter(5.0,0.0,0.0).setRotation(0.0,1.0,0.0,-0.785)
          .addChild(new Transform().setUSE("ThreeDownRightCurvingShadows"))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return Stairway model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new Stairway().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Vrml2Sourcebook.Siggraph98Course.Stairway\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Vrml2Sourcebook.Siggraph98Course.Stairway self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Siggraph98Course/Stairway_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Siggraph98Course/Stairway_JavaExport.x3d"; 
                String filenameX3DV = "Siggraph98Course/Stairway_JavaExport.x3dv"; 
                String filenameJSON = "Siggraph98Course/Stairway_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
