####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python Spiral.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.3',
  head=head(
    children=[
    meta(content='Spiral.x3d',name='title'),
    meta(content='Spiral flow shows how to move a set of particles (spheres) along a pre-computed animation path. Such an approach might be used to visualize the results of a fluid flow simulation.',name='description'),
    meta(content='David R. Nadeau',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='1 July 1998',name='created'),
    meta(content='2 February 2014',name='translated'),
    meta(content='20 October 2019',name='modified'),
    meta(content='Spiral.png',name='Image'),
    meta(content='originals/spiral.wrl',name='reference'),
    meta(content='build the track that the balls follow',name='TODO'),
    meta(content='http://www.siggraph.org/s98',name='reference'),
    meta(content='http://www.siggraph.org/s98/conference/courses/18.html',name='reference'),
    meta(content='http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0008.htm',name='reference'),
    meta(content='http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0151.htm',name='reference'),
    meta(content='http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/X3dResources.html',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Spiral.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(info=["Copyright (c) 1997, David R. Nadeau"],title='Spiral flow'),
    Viewpoint(description='Entry view',position=(0.0,9.0,35.0)),
    NavigationInfo(),
    #  Center pole 
    Transform(translation=(0.0,8.0,0.0),
      children=[
      Shape(
        appearance=Appearance(DEF='BaseColor',
          material=Material(diffuseColor=(0.0,0.5,1.0))),
        geometry=Cylinder(height=18.0,radius=0.5))]),
    #  Ground under pole 
    Transform(translation=(0.0,-1.0,0.0),
      children=[
      Shape(
        appearance=Appearance(USE='BaseColor'),
        geometry=Cylinder(height=0.25,radius=6.0))]),
    #  Particle source 
    Transform(translation=(0.0,16.0,0.0),
      children=[
      Transform(rotation=(1.0,0.0,0.0,-1.571),translation=(4.5,0.0,-1.0),
        children=[
        Shape(
          appearance=Appearance(USE='BaseColor'),
          geometry=Cone(bottomRadius=1.2,height=2.5))]),
      Transform(translation=(2.25,0.0,0.0),
        children=[
        Shape(
          appearance=Appearance(USE='BaseColor'),
          geometry=Box(size=(4.5,0.5,0.5)))])]),
    #  Particle sink 
    Transform(
      children=[
      Transform(rotation=(1.0,0.0,0.0,1.571),translation=(4.5,0.0,1.0),
        children=[
        Shape(
          appearance=Appearance(USE='BaseColor'),
          geometry=Cone(bottomRadius=1.2,height=2.5))]),
      Transform(translation=(2.25,0.0,0.0),
        children=[
        Shape(
          appearance=Appearance(USE='BaseColor'),
          geometry=Box(size=(4.5,0.5,0.5)))])]),
    #  Set of particles to spin around the pole 
    Transform(DEF='Particle1',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='Material1')),
        geometry=Sphere(DEF='Particle'))]),
    Transform(DEF='Particle2',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='Material2')),
        geometry=Sphere(USE='Particle'))]),
    Transform(DEF='Particle3',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='Material3')),
        geometry=Sphere(USE='Particle'))]),
    Transform(DEF='Particle4',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='Material4')),
        geometry=Sphere(USE='Particle'))]),
    Transform(DEF='Particle5',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='Material5')),
        geometry=Sphere(USE='Particle'))]),
    Transform(DEF='Particle6',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='Material6')),
        geometry=Sphere(USE='Particle'))]),
    Transform(DEF='Particle7',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='Material7')),
        geometry=Sphere(USE='Particle'))]),
    Transform(DEF='Particle8',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='Material8')),
        geometry=Sphere(USE='Particle'))]),
    Transform(DEF='Particle9',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='Material9')),
        geometry=Sphere(USE='Particle'))]),
    Transform(DEF='Particle10',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='Material10')),
        geometry=Sphere(USE='Particle'))]),
    Transform(DEF='Particle11',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='Material11')),
        geometry=Sphere(USE='Particle'))]),
    Transform(DEF='Particle12',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='Material12')),
        geometry=Sphere(USE='Particle'))]),
    #  Set of timers, one per particle 
    TimeSensor(DEF='Timer1',cycleInterval=12.0,loop=True,stopTime=-1.0),
    TimeSensor(DEF='Timer2',cycleInterval=12.0,loop=True,startTime=0.25,stopTime=-1.0),
    TimeSensor(DEF='Timer3',cycleInterval=12.0,loop=True,startTime=0.5,stopTime=-1.0),
    TimeSensor(DEF='Timer4',cycleInterval=12.0,loop=True,startTime=0.7500000000000001,stopTime=-1.0),
    TimeSensor(DEF='Timer5',cycleInterval=12.0,loop=True,startTime=1.0,stopTime=-1.0),
    TimeSensor(DEF='Timer6',cycleInterval=12.0,loop=True,startTime=1.25,stopTime=-1.0),
    TimeSensor(DEF='Timer7',cycleInterval=12.0,loop=True,startTime=6.0,stopTime=-1.0),
    TimeSensor(DEF='Timer8',cycleInterval=12.0,loop=True,startTime=6.25,stopTime=-1.0),
    TimeSensor(DEF='Timer9',cycleInterval=12.0,loop=True,startTime=6.5,stopTime=-1.0),
    TimeSensor(DEF='Timer10',cycleInterval=12.0,loop=True,startTime=6.75,stopTime=-1.0),
    TimeSensor(DEF='Timer11',cycleInterval=12.0,loop=True,startTime=7.0,stopTime=-1.0),
    TimeSensor(DEF='Timer12',cycleInterval=12.0,loop=True,startTime=7.25,stopTime=-1.0),
    #  Set of position interpolators, one per particle. All paths are identical 
    PositionInterpolator(DEF='Position1',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(4.5,16.0,0.0),(3.89,15.75,2.81),(1.63,15.49,4.83),(-1.49,15.24,5.17),(-4.33,14.98,3.65),(-5.88,14.73,0.81),(-5.71,14.48,-2.4),(-4.01,14.22,-5.02),(-1.41,13.97,-6.5),(1.36,13.71,-6.71),(3.76,13.46,-5.93),(5.52,13.21,-4.57),(6.62,12.95,-3.07),(7.19,12.7,-1.72),(7.42,12.44,-0.71),(7.49,12.19,-0.13),(7.5,11.94,-0.01),(7.47,11.68,-0.36),(7.33,11.43,-1.16),(6.95,11.17,-2.36),(6.14,10.92,-3.82),(4.73,10.67,-5.29),(2.63,10.41,-6.42),(-0.01,10.16,-6.75),(-2.78,9.9,-5.92),(-5.02,9.65,-3.83),(-6.01,9.4,-0.81),(-5.31,9.14,2.34),(-3.02,8.89,4.63),(0.11,8.63,5.24),(2.93,8.38,3.98),(4.42,8.13,1.43),(4.14,7.87,-1.34),(2.4,7.62,-3.26),(0.08,7.37,-3.76),(-1.9,7.11,-2.91),(-2.93,6.86,-1.29),(-2.91,6.6,0.39),(-2.14,6.35,1.63),(-1.04,6.1,2.23),(0.0,5.84,2.25),(0.78,5.59,1.91),(1.27,5.33,1.42),(1.5,5.08,0.93),(1.57,4.83,0.53),(1.56,4.57,0.25),(1.52,4.32,0.07),(1.5,4.06,0.0),(1.51,3.81,0.03),(1.54,3.56,0.15),(1.57,3.3,0.38),(1.55,3.05,0.72),(1.41,2.79,1.17),(1.06,2.54,1.67),(0.43,2.29,2.11),(-0.5,2.03,2.3),(-1.6,1.78,2.01),(-2.59,1.52,1.09),(-3.04,1.27,-0.42),(-2.55,1.02,-2.15),(-1.0,0.76,-3.47),(1.25,0.51,-3.7),(3.41,0.25,-2.46),(4.5,0.0,0.0)]),
    PositionInterpolator(DEF='Position2',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(4.5,16.0,0.0),(3.89,15.75,2.81),(1.63,15.49,4.83),(-1.49,15.24,5.17),(-4.33,14.98,3.65),(-5.88,14.73,0.81),(-5.71,14.48,-2.4),(-4.01,14.22,-5.02),(-1.41,13.97,-6.5),(1.36,13.71,-6.71),(3.76,13.46,-5.93),(5.52,13.21,-4.57),(6.62,12.95,-3.07),(7.19,12.7,-1.72),(7.42,12.44,-0.71),(7.49,12.19,-0.13),(7.5,11.94,-0.01),(7.47,11.68,-0.36),(7.33,11.43,-1.16),(6.95,11.17,-2.36),(6.14,10.92,-3.82),(4.73,10.67,-5.29),(2.63,10.41,-6.42),(-0.01,10.16,-6.75),(-2.78,9.9,-5.92),(-5.02,9.65,-3.83),(-6.01,9.4,-0.81),(-5.31,9.14,2.34),(-3.02,8.89,4.63),(0.11,8.63,5.24),(2.93,8.38,3.98),(4.42,8.13,1.43),(4.14,7.87,-1.34),(2.4,7.62,-3.26),(0.08,7.37,-3.76),(-1.9,7.11,-2.91),(-2.93,6.86,-1.29),(-2.91,6.6,0.39),(-2.14,6.35,1.63),(-1.04,6.1,2.23),(0.0,5.84,2.25),(0.78,5.59,1.91),(1.27,5.33,1.42),(1.5,5.08,0.93),(1.57,4.83,0.53),(1.56,4.57,0.25),(1.52,4.32,0.07),(1.5,4.06,0.0),(1.51,3.81,0.03),(1.54,3.56,0.15),(1.57,3.3,0.38),(1.55,3.05,0.72),(1.41,2.79,1.17),(1.06,2.54,1.67),(0.43,2.29,2.11),(-0.5,2.03,2.3),(-1.6,1.78,2.01),(-2.59,1.52,1.09),(-3.04,1.27,-0.42),(-2.55,1.02,-2.15),(-1.0,0.76,-3.47),(1.25,0.51,-3.7),(3.41,0.25,-2.46),(4.5,0.0,0.0)]),
    PositionInterpolator(DEF='Position3',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(4.5,16.0,0.0),(3.89,15.75,2.81),(1.63,15.49,4.83),(-1.49,15.24,5.17),(-4.33,14.98,3.65),(-5.88,14.73,0.81),(-5.71,14.48,-2.4),(-4.01,14.22,-5.02),(-1.41,13.97,-6.5),(1.36,13.71,-6.71),(3.76,13.46,-5.93),(5.52,13.21,-4.57),(6.62,12.95,-3.07),(7.19,12.7,-1.72),(7.42,12.44,-0.71),(7.49,12.19,-0.13),(7.5,11.94,-0.01),(7.47,11.68,-0.36),(7.33,11.43,-1.16),(6.95,11.17,-2.36),(6.14,10.92,-3.82),(4.73,10.67,-5.29),(2.63,10.41,-6.42),(-0.01,10.16,-6.75),(-2.78,9.9,-5.92),(-5.02,9.65,-3.83),(-6.01,9.4,-0.81),(-5.31,9.14,2.34),(-3.02,8.89,4.63),(0.11,8.63,5.24),(2.93,8.38,3.98),(4.42,8.13,1.43),(4.14,7.87,-1.34),(2.4,7.62,-3.26),(0.08,7.37,-3.76),(-1.9,7.11,-2.91),(-2.93,6.86,-1.29),(-2.91,6.6,0.39),(-2.14,6.35,1.63),(-1.04,6.1,2.23),(0.0,5.84,2.25),(0.78,5.59,1.91),(1.27,5.33,1.42),(1.5,5.08,0.93),(1.57,4.83,0.53),(1.56,4.57,0.25),(1.52,4.32,0.07),(1.5,4.06,0.0),(1.51,3.81,0.03),(1.54,3.56,0.15),(1.57,3.3,0.38),(1.55,3.05,0.72),(1.41,2.79,1.17),(1.06,2.54,1.67),(0.43,2.29,2.11),(-0.5,2.03,2.3),(-1.6,1.78,2.01),(-2.59,1.52,1.09),(-3.04,1.27,-0.42),(-2.55,1.02,-2.15),(-1.0,0.76,-3.47),(1.25,0.51,-3.7),(3.41,0.25,-2.46),(4.5,0.0,0.0)]),
    PositionInterpolator(DEF='Position4',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(4.5,16.0,0.0),(3.89,15.75,2.81),(1.63,15.49,4.83),(-1.49,15.24,5.17),(-4.33,14.98,3.65),(-5.88,14.73,0.81),(-5.71,14.48,-2.4),(-4.01,14.22,-5.02),(-1.41,13.97,-6.5),(1.36,13.71,-6.71),(3.76,13.46,-5.93),(5.52,13.21,-4.57),(6.62,12.95,-3.07),(7.19,12.7,-1.72),(7.42,12.44,-0.71),(7.49,12.19,-0.13),(7.5,11.94,-0.01),(7.47,11.68,-0.36),(7.33,11.43,-1.16),(6.95,11.17,-2.36),(6.14,10.92,-3.82),(4.73,10.67,-5.29),(2.63,10.41,-6.42),(-0.01,10.16,-6.75),(-2.78,9.9,-5.92),(-5.02,9.65,-3.83),(-6.01,9.4,-0.81),(-5.31,9.14,2.34),(-3.02,8.89,4.63),(0.11,8.63,5.24),(2.93,8.38,3.98),(4.42,8.13,1.43),(4.14,7.87,-1.34),(2.4,7.62,-3.26),(0.08,7.37,-3.76),(-1.9,7.11,-2.91),(-2.93,6.86,-1.29),(-2.91,6.6,0.39),(-2.14,6.35,1.63),(-1.04,6.1,2.23),(0.0,5.84,2.25),(0.78,5.59,1.91),(1.27,5.33,1.42),(1.5,5.08,0.93),(1.57,4.83,0.53),(1.56,4.57,0.25),(1.52,4.32,0.07),(1.5,4.06,0.0),(1.51,3.81,0.03),(1.54,3.56,0.15),(1.57,3.3,0.38),(1.55,3.05,0.72),(1.41,2.79,1.17),(1.06,2.54,1.67),(0.43,2.29,2.11),(-0.5,2.03,2.3),(-1.6,1.78,2.01),(-2.59,1.52,1.09),(-3.04,1.27,-0.42),(-2.55,1.02,-2.15),(-1.0,0.76,-3.47),(1.25,0.51,-3.7),(3.41,0.25,-2.46),(4.5,0.0,0.0)]),
    PositionInterpolator(DEF='Position5',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(4.5,16.0,0.0),(3.89,15.75,2.81),(1.63,15.49,4.83),(-1.49,15.24,5.17),(-4.33,14.98,3.65),(-5.88,14.73,0.81),(-5.71,14.48,-2.4),(-4.01,14.22,-5.02),(-1.41,13.97,-6.5),(1.36,13.71,-6.71),(3.76,13.46,-5.93),(5.52,13.21,-4.57),(6.62,12.95,-3.07),(7.19,12.7,-1.72),(7.42,12.44,-0.71),(7.49,12.19,-0.13),(7.5,11.94,-0.01),(7.47,11.68,-0.36),(7.33,11.43,-1.16),(6.95,11.17,-2.36),(6.14,10.92,-3.82),(4.73,10.67,-5.29),(2.63,10.41,-6.42),(-0.01,10.16,-6.75),(-2.78,9.9,-5.92),(-5.02,9.65,-3.83),(-6.01,9.4,-0.81),(-5.31,9.14,2.34),(-3.02,8.89,4.63),(0.11,8.63,5.24),(2.93,8.38,3.98),(4.42,8.13,1.43),(4.14,7.87,-1.34),(2.4,7.62,-3.26),(0.08,7.37,-3.76),(-1.9,7.11,-2.91),(-2.93,6.86,-1.29),(-2.91,6.6,0.39),(-2.14,6.35,1.63),(-1.04,6.1,2.23),(0.0,5.84,2.25),(0.78,5.59,1.91),(1.27,5.33,1.42),(1.5,5.08,0.93),(1.57,4.83,0.53),(1.56,4.57,0.25),(1.52,4.32,0.07),(1.5,4.06,0.0),(1.51,3.81,0.03),(1.54,3.56,0.15),(1.57,3.3,0.38),(1.55,3.05,0.72),(1.41,2.79,1.17),(1.06,2.54,1.67),(0.43,2.29,2.11),(-0.5,2.03,2.3),(-1.6,1.78,2.01),(-2.59,1.52,1.09),(-3.04,1.27,-0.42),(-2.55,1.02,-2.15),(-1.0,0.76,-3.47),(1.25,0.51,-3.7),(3.41,0.25,-2.46),(4.5,0.0,0.0)]),
    PositionInterpolator(DEF='Position6',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(4.5,16.0,0.0),(3.89,15.75,2.81),(1.63,15.49,4.83),(-1.49,15.24,5.17),(-4.33,14.98,3.65),(-5.88,14.73,0.81),(-5.71,14.48,-2.4),(-4.01,14.22,-5.02),(-1.41,13.97,-6.5),(1.36,13.71,-6.71),(3.76,13.46,-5.93),(5.52,13.21,-4.57),(6.62,12.95,-3.07),(7.19,12.7,-1.72),(7.42,12.44,-0.71),(7.49,12.19,-0.13),(7.5,11.94,-0.01),(7.47,11.68,-0.36),(7.33,11.43,-1.16),(6.95,11.17,-2.36),(6.14,10.92,-3.82),(4.73,10.67,-5.29),(2.63,10.41,-6.42),(-0.01,10.16,-6.75),(-2.78,9.9,-5.92),(-5.02,9.65,-3.83),(-6.01,9.4,-0.81),(-5.31,9.14,2.34),(-3.02,8.89,4.63),(0.11,8.63,5.24),(2.93,8.38,3.98),(4.42,8.13,1.43),(4.14,7.87,-1.34),(2.4,7.62,-3.26),(0.08,7.37,-3.76),(-1.9,7.11,-2.91),(-2.93,6.86,-1.29),(-2.91,6.6,0.39),(-2.14,6.35,1.63),(-1.04,6.1,2.23),(0.0,5.84,2.25),(0.78,5.59,1.91),(1.27,5.33,1.42),(1.5,5.08,0.93),(1.57,4.83,0.53),(1.56,4.57,0.25),(1.52,4.32,0.07),(1.5,4.06,0.0),(1.51,3.81,0.03),(1.54,3.56,0.15),(1.57,3.3,0.38),(1.55,3.05,0.72),(1.41,2.79,1.17),(1.06,2.54,1.67),(0.43,2.29,2.11),(-0.5,2.03,2.3),(-1.6,1.78,2.01),(-2.59,1.52,1.09),(-3.04,1.27,-0.42),(-2.55,1.02,-2.15),(-1.0,0.76,-3.47),(1.25,0.51,-3.7),(3.41,0.25,-2.46),(4.5,0.0,0.0)]),
    PositionInterpolator(DEF='Position7',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(4.5,16.0,0.0),(3.89,15.75,2.81),(1.63,15.49,4.83),(-1.49,15.24,5.17),(-4.33,14.98,3.65),(-5.88,14.73,0.81),(-5.71,14.48,-2.4),(-4.01,14.22,-5.02),(-1.41,13.97,-6.5),(1.36,13.71,-6.71),(3.76,13.46,-5.93),(5.52,13.21,-4.57),(6.62,12.95,-3.07),(7.19,12.7,-1.72),(7.42,12.44,-0.71),(7.49,12.19,-0.13),(7.5,11.94,-0.01),(7.47,11.68,-0.36),(7.33,11.43,-1.16),(6.95,11.17,-2.36),(6.14,10.92,-3.82),(4.73,10.67,-5.29),(2.63,10.41,-6.42),(-0.01,10.16,-6.75),(-2.78,9.9,-5.92),(-5.02,9.65,-3.83),(-6.01,9.4,-0.81),(-5.31,9.14,2.34),(-3.02,8.89,4.63),(0.11,8.63,5.24),(2.93,8.38,3.98),(4.42,8.13,1.43),(4.14,7.87,-1.34),(2.4,7.62,-3.26),(0.08,7.37,-3.76),(-1.9,7.11,-2.91),(-2.93,6.86,-1.29),(-2.91,6.6,0.39),(-2.14,6.35,1.63),(-1.04,6.1,2.23),(0.0,5.84,2.25),(0.78,5.59,1.91),(1.27,5.33,1.42),(1.5,5.08,0.93),(1.57,4.83,0.53),(1.56,4.57,0.25),(1.52,4.32,0.07),(1.5,4.06,0.0),(1.51,3.81,0.03),(1.54,3.56,0.15),(1.57,3.3,0.38),(1.55,3.05,0.72),(1.41,2.79,1.17),(1.06,2.54,1.67),(0.43,2.29,2.11),(-0.5,2.03,2.3),(-1.6,1.78,2.01),(-2.59,1.52,1.09),(-3.04,1.27,-0.42),(-2.55,1.02,-2.15),(-1.0,0.76,-3.47),(1.25,0.51,-3.7),(3.41,0.25,-2.46),(4.5,0.0,0.0)]),
    PositionInterpolator(DEF='Position8',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(4.5,16.0,0.0),(3.89,15.75,2.81),(1.63,15.49,4.83),(-1.49,15.24,5.17),(-4.33,14.98,3.65),(-5.88,14.73,0.81),(-5.71,14.48,-2.4),(-4.01,14.22,-5.02),(-1.41,13.97,-6.5),(1.36,13.71,-6.71),(3.76,13.46,-5.93),(5.52,13.21,-4.57),(6.62,12.95,-3.07),(7.19,12.7,-1.72),(7.42,12.44,-0.71),(7.49,12.19,-0.13),(7.5,11.94,-0.01),(7.47,11.68,-0.36),(7.33,11.43,-1.16),(6.95,11.17,-2.36),(6.14,10.92,-3.82),(4.73,10.67,-5.29),(2.63,10.41,-6.42),(-0.01,10.16,-6.75),(-2.78,9.9,-5.92),(-5.02,9.65,-3.83),(-6.01,9.4,-0.81),(-5.31,9.14,2.34),(-3.02,8.89,4.63),(0.11,8.63,5.24),(2.93,8.38,3.98),(4.42,8.13,1.43),(4.14,7.87,-1.34),(2.4,7.62,-3.26),(0.08,7.37,-3.76),(-1.9,7.11,-2.91),(-2.93,6.86,-1.29),(-2.91,6.6,0.39),(-2.14,6.35,1.63),(-1.04,6.1,2.23),(0.0,5.84,2.25),(0.78,5.59,1.91),(1.27,5.33,1.42),(1.5,5.08,0.93),(1.57,4.83,0.53),(1.56,4.57,0.25),(1.52,4.32,0.07),(1.5,4.06,0.0),(1.51,3.81,0.03),(1.54,3.56,0.15),(1.57,3.3,0.38),(1.55,3.05,0.72),(1.41,2.79,1.17),(1.06,2.54,1.67),(0.43,2.29,2.11),(-0.5,2.03,2.3),(-1.6,1.78,2.01),(-2.59,1.52,1.09),(-3.04,1.27,-0.42),(-2.55,1.02,-2.15),(-1.0,0.76,-3.47),(1.25,0.51,-3.7),(3.41,0.25,-2.46),(4.5,0.0,0.0)]),
    PositionInterpolator(DEF='Position9',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(4.5,16.0,0.0),(3.89,15.75,2.81),(1.63,15.49,4.83),(-1.49,15.24,5.17),(-4.33,14.98,3.65),(-5.88,14.73,0.81),(-5.71,14.48,-2.4),(-4.01,14.22,-5.02),(-1.41,13.97,-6.5),(1.36,13.71,-6.71),(3.76,13.46,-5.93),(5.52,13.21,-4.57),(6.62,12.95,-3.07),(7.19,12.7,-1.72),(7.42,12.44,-0.71),(7.49,12.19,-0.13),(7.5,11.94,-0.01),(7.47,11.68,-0.36),(7.33,11.43,-1.16),(6.95,11.17,-2.36),(6.14,10.92,-3.82),(4.73,10.67,-5.29),(2.63,10.41,-6.42),(-0.01,10.16,-6.75),(-2.78,9.9,-5.92),(-5.02,9.65,-3.83),(-6.01,9.4,-0.81),(-5.31,9.14,2.34),(-3.02,8.89,4.63),(0.11,8.63,5.24),(2.93,8.38,3.98),(4.42,8.13,1.43),(4.14,7.87,-1.34),(2.4,7.62,-3.26),(0.08,7.37,-3.76),(-1.9,7.11,-2.91),(-2.93,6.86,-1.29),(-2.91,6.6,0.39),(-2.14,6.35,1.63),(-1.04,6.1,2.23),(0.0,5.84,2.25),(0.78,5.59,1.91),(1.27,5.33,1.42),(1.5,5.08,0.93),(1.57,4.83,0.53),(1.56,4.57,0.25),(1.52,4.32,0.07),(1.5,4.06,0.0),(1.51,3.81,0.03),(1.54,3.56,0.15),(1.57,3.3,0.38),(1.55,3.05,0.72),(1.41,2.79,1.17),(1.06,2.54,1.67),(0.43,2.29,2.11),(-0.5,2.03,2.3),(-1.6,1.78,2.01),(-2.59,1.52,1.09),(-3.04,1.27,-0.42),(-2.55,1.02,-2.15),(-1.0,0.76,-3.47),(1.25,0.51,-3.7),(3.41,0.25,-2.46),(4.5,0.0,0.0)]),
    PositionInterpolator(DEF='Position10',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(4.5,16.0,0.0),(3.89,15.75,2.81),(1.63,15.49,4.83),(-1.49,15.24,5.17),(-4.33,14.98,3.65),(-5.88,14.73,0.81),(-5.71,14.48,-2.4),(-4.01,14.22,-5.02),(-1.41,13.97,-6.5),(1.36,13.71,-6.71),(3.76,13.46,-5.93),(5.52,13.21,-4.57),(6.62,12.95,-3.07),(7.19,12.7,-1.72),(7.42,12.44,-0.71),(7.49,12.19,-0.13),(7.5,11.94,-0.01),(7.47,11.68,-0.36),(7.33,11.43,-1.16),(6.95,11.17,-2.36),(6.14,10.92,-3.82),(4.73,10.67,-5.29),(2.63,10.41,-6.42),(-0.01,10.16,-6.75),(-2.78,9.9,-5.92),(-5.02,9.65,-3.83),(-6.01,9.4,-0.81),(-5.31,9.14,2.34),(-3.02,8.89,4.63),(0.11,8.63,5.24),(2.93,8.38,3.98),(4.42,8.13,1.43),(4.14,7.87,-1.34),(2.4,7.62,-3.26),(0.08,7.37,-3.76),(-1.9,7.11,-2.91),(-2.93,6.86,-1.29),(-2.91,6.6,0.39),(-2.14,6.35,1.63),(-1.04,6.1,2.23),(0.0,5.84,2.25),(0.78,5.59,1.91),(1.27,5.33,1.42),(1.5,5.08,0.93),(1.57,4.83,0.53),(1.56,4.57,0.25),(1.52,4.32,0.07),(1.5,4.06,0.0),(1.51,3.81,0.03),(1.54,3.56,0.15),(1.57,3.3,0.38),(1.55,3.05,0.72),(1.41,2.79,1.17),(1.06,2.54,1.67),(0.43,2.29,2.11),(-0.5,2.03,2.3),(-1.6,1.78,2.01),(-2.59,1.52,1.09),(-3.04,1.27,-0.42),(-2.55,1.02,-2.15),(-1.0,0.76,-3.47),(1.25,0.51,-3.7),(3.41,0.25,-2.46),(4.5,0.0,0.0)]),
    PositionInterpolator(DEF='Position11',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(4.5,16.0,0.0),(3.89,15.75,2.81),(1.63,15.49,4.83),(-1.49,15.24,5.17),(-4.33,14.98,3.65),(-5.88,14.73,0.81),(-5.71,14.48,-2.4),(-4.01,14.22,-5.02),(-1.41,13.97,-6.5),(1.36,13.71,-6.71),(3.76,13.46,-5.93),(5.52,13.21,-4.57),(6.62,12.95,-3.07),(7.19,12.7,-1.72),(7.42,12.44,-0.71),(7.49,12.19,-0.13),(7.5,11.94,-0.01),(7.47,11.68,-0.36),(7.33,11.43,-1.16),(6.95,11.17,-2.36),(6.14,10.92,-3.82),(4.73,10.67,-5.29),(2.63,10.41,-6.42),(-0.01,10.16,-6.75),(-2.78,9.9,-5.92),(-5.02,9.65,-3.83),(-6.01,9.4,-0.81),(-5.31,9.14,2.34),(-3.02,8.89,4.63),(0.11,8.63,5.24),(2.93,8.38,3.98),(4.42,8.13,1.43),(4.14,7.87,-1.34),(2.4,7.62,-3.26),(0.08,7.37,-3.76),(-1.9,7.11,-2.91),(-2.93,6.86,-1.29),(-2.91,6.6,0.39),(-2.14,6.35,1.63),(-1.04,6.1,2.23),(0.0,5.84,2.25),(0.78,5.59,1.91),(1.27,5.33,1.42),(1.5,5.08,0.93),(1.57,4.83,0.53),(1.56,4.57,0.25),(1.52,4.32,0.07),(1.5,4.06,0.0),(1.51,3.81,0.03),(1.54,3.56,0.15),(1.57,3.3,0.38),(1.55,3.05,0.72),(1.41,2.79,1.17),(1.06,2.54,1.67),(0.43,2.29,2.11),(-0.5,2.03,2.3),(-1.6,1.78,2.01),(-2.59,1.52,1.09),(-3.04,1.27,-0.42),(-2.55,1.02,-2.15),(-1.0,0.76,-3.47),(1.25,0.51,-3.7),(3.41,0.25,-2.46),(4.5,0.0,0.0)]),
    PositionInterpolator(DEF='Position12',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(4.5,16.0,0.0),(3.89,15.75,2.81),(1.63,15.49,4.83),(-1.49,15.24,5.17),(-4.33,14.98,3.65),(-5.88,14.73,0.81),(-5.71,14.48,-2.4),(-4.01,14.22,-5.02),(-1.41,13.97,-6.5),(1.36,13.71,-6.71),(3.76,13.46,-5.93),(5.52,13.21,-4.57),(6.62,12.95,-3.07),(7.19,12.7,-1.72),(7.42,12.44,-0.71),(7.49,12.19,-0.13),(7.5,11.94,-0.01),(7.47,11.68,-0.36),(7.33,11.43,-1.16),(6.95,11.17,-2.36),(6.14,10.92,-3.82),(4.73,10.67,-5.29),(2.63,10.41,-6.42),(-0.01,10.16,-6.75),(-2.78,9.9,-5.92),(-5.02,9.65,-3.83),(-6.01,9.4,-0.81),(-5.31,9.14,2.34),(-3.02,8.89,4.63),(0.11,8.63,5.24),(2.93,8.38,3.98),(4.42,8.13,1.43),(4.14,7.87,-1.34),(2.4,7.62,-3.26),(0.08,7.37,-3.76),(-1.9,7.11,-2.91),(-2.93,6.86,-1.29),(-2.91,6.6,0.39),(-2.14,6.35,1.63),(-1.04,6.1,2.23),(0.0,5.84,2.25),(0.78,5.59,1.91),(1.27,5.33,1.42),(1.5,5.08,0.93),(1.57,4.83,0.53),(1.56,4.57,0.25),(1.52,4.32,0.07),(1.5,4.06,0.0),(1.51,3.81,0.03),(1.54,3.56,0.15),(1.57,3.3,0.38),(1.55,3.05,0.72),(1.41,2.79,1.17),(1.06,2.54,1.67),(0.43,2.29,2.11),(-0.5,2.03,2.3),(-1.6,1.78,2.01),(-2.59,1.52,1.09),(-3.04,1.27,-0.42),(-2.55,1.02,-2.15),(-1.0,0.76,-3.47),(1.25,0.51,-3.7),(3.41,0.25,-2.46),(4.5,0.0,0.0)]),
    #  Set of color interpolators to vary particle color 
    ColorInterpolator(DEF='Color1',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(0.5,0.5,0.0),(0.45,0.55,0.0),(0.4,0.6,0.0),(0.35,0.65,0.0),(0.31,0.69,0.0),(0.26,0.74,0.0),(0.22,0.78,0.0),(0.18,0.82,0.0),(0.14,0.86,0.0),(0.11,0.89,0.0),(0.08,0.92,0.0),(0.06,0.94,0.0),(0.03,0.97,0.0),(0.02,0.98,0.0),(0.01,0.99,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.01,0.99,0.0),(0.03,0.97,0.0),(0.04,0.96,0.0),(0.07,0.93,0.0),(0.09,0.91,0.0),(0.13,0.87,0.0),(0.16,0.84,0.0),(0.2,0.8,0.0),(0.24,0.76,0.0),(0.28,0.72,0.0),(0.33,0.67,0.0),(0.38,0.62,0.0),(0.43,0.57,0.0),(0.48,0.52,0.0),(0.52,0.48,0.0),(0.57,0.43,0.0),(0.62,0.38,0.0),(0.67,0.33,0.0),(0.72,0.28,0.0),(0.76,0.24,0.0),(0.8,0.2,0.0),(0.84,0.16,0.0),(0.87,0.13,0.0),(0.91,0.09,0.0),(0.93,0.07,0.0),(0.96,0.04,0.0),(0.97,0.03,0.0),(0.99,0.01,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(0.99,0.01,0.0),(0.98,0.02,0.0),(0.97,0.03,0.0),(0.94,0.06,0.0),(0.92,0.08,0.0),(0.89,0.11,0.0),(0.86,0.14,0.0),(0.82,0.18,0.0),(0.78,0.22,0.0),(0.74,0.26,0.0),(0.69,0.31,0.0),(0.65,0.35,0.0),(0.6,0.4,0.0),(0.55,0.45,0.0),(0.5,0.5,0.0)]),
    ColorInterpolator(DEF='Color2',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(0.5,0.5,0.0),(0.45,0.55,0.0),(0.4,0.6,0.0),(0.35,0.65,0.0),(0.31,0.69,0.0),(0.26,0.74,0.0),(0.22,0.78,0.0),(0.18,0.82,0.0),(0.14,0.86,0.0),(0.11,0.89,0.0),(0.08,0.92,0.0),(0.06,0.94,0.0),(0.03,0.97,0.0),(0.02,0.98,0.0),(0.01,0.99,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.01,0.99,0.0),(0.03,0.97,0.0),(0.04,0.96,0.0),(0.07,0.93,0.0),(0.09,0.91,0.0),(0.13,0.87,0.0),(0.16,0.84,0.0),(0.2,0.8,0.0),(0.24,0.76,0.0),(0.28,0.72,0.0),(0.33,0.67,0.0),(0.38,0.62,0.0),(0.43,0.57,0.0),(0.48,0.52,0.0),(0.52,0.48,0.0),(0.57,0.43,0.0),(0.62,0.38,0.0),(0.67,0.33,0.0),(0.72,0.28,0.0),(0.76,0.24,0.0),(0.8,0.2,0.0),(0.84,0.16,0.0),(0.87,0.13,0.0),(0.91,0.09,0.0),(0.93,0.07,0.0),(0.96,0.04,0.0),(0.97,0.03,0.0),(0.99,0.01,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(0.99,0.01,0.0),(0.98,0.02,0.0),(0.97,0.03,0.0),(0.94,0.06,0.0),(0.92,0.08,0.0),(0.89,0.11,0.0),(0.86,0.14,0.0),(0.82,0.18,0.0),(0.78,0.22,0.0),(0.74,0.26,0.0),(0.69,0.31,0.0),(0.65,0.35,0.0),(0.6,0.4,0.0),(0.55,0.45,0.0),(0.5,0.5,0.0)]),
    ColorInterpolator(DEF='Color3',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(0.5,0.5,0.0),(0.45,0.55,0.0),(0.4,0.6,0.0),(0.35,0.65,0.0),(0.31,0.69,0.0),(0.26,0.74,0.0),(0.22,0.78,0.0),(0.18,0.82,0.0),(0.14,0.86,0.0),(0.11,0.89,0.0),(0.08,0.92,0.0),(0.06,0.94,0.0),(0.03,0.97,0.0),(0.02,0.98,0.0),(0.01,0.99,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.01,0.99,0.0),(0.03,0.97,0.0),(0.04,0.96,0.0),(0.07,0.93,0.0),(0.09,0.91,0.0),(0.13,0.87,0.0),(0.16,0.84,0.0),(0.2,0.8,0.0),(0.24,0.76,0.0),(0.28,0.72,0.0),(0.33,0.67,0.0),(0.38,0.62,0.0),(0.43,0.57,0.0),(0.48,0.52,0.0),(0.52,0.48,0.0),(0.57,0.43,0.0),(0.62,0.38,0.0),(0.67,0.33,0.0),(0.72,0.28,0.0),(0.76,0.24,0.0),(0.8,0.2,0.0),(0.84,0.16,0.0),(0.87,0.13,0.0),(0.91,0.09,0.0),(0.93,0.07,0.0),(0.96,0.04,0.0),(0.97,0.03,0.0),(0.99,0.01,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(0.99,0.01,0.0),(0.98,0.02,0.0),(0.97,0.03,0.0),(0.94,0.06,0.0),(0.92,0.08,0.0),(0.89,0.11,0.0),(0.86,0.14,0.0),(0.82,0.18,0.0),(0.78,0.22,0.0),(0.74,0.26,0.0),(0.69,0.31,0.0),(0.65,0.35,0.0),(0.6,0.4,0.0),(0.55,0.45,0.0),(0.5,0.5,0.0)]),
    ColorInterpolator(DEF='Color4',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(0.5,0.5,0.0),(0.45,0.55,0.0),(0.4,0.6,0.0),(0.35,0.65,0.0),(0.31,0.69,0.0),(0.26,0.74,0.0),(0.22,0.78,0.0),(0.18,0.82,0.0),(0.14,0.86,0.0),(0.11,0.89,0.0),(0.08,0.92,0.0),(0.06,0.94,0.0),(0.03,0.97,0.0),(0.02,0.98,0.0),(0.01,0.99,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.01,0.99,0.0),(0.03,0.97,0.0),(0.04,0.96,0.0),(0.07,0.93,0.0),(0.09,0.91,0.0),(0.13,0.87,0.0),(0.16,0.84,0.0),(0.2,0.8,0.0),(0.24,0.76,0.0),(0.28,0.72,0.0),(0.33,0.67,0.0),(0.38,0.62,0.0),(0.43,0.57,0.0),(0.48,0.52,0.0),(0.52,0.48,0.0),(0.57,0.43,0.0),(0.62,0.38,0.0),(0.67,0.33,0.0),(0.72,0.28,0.0),(0.76,0.24,0.0),(0.8,0.2,0.0),(0.84,0.16,0.0),(0.87,0.13,0.0),(0.91,0.09,0.0),(0.93,0.07,0.0),(0.96,0.04,0.0),(0.97,0.03,0.0),(0.99,0.01,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(0.99,0.01,0.0),(0.98,0.02,0.0),(0.97,0.03,0.0),(0.94,0.06,0.0),(0.92,0.08,0.0),(0.89,0.11,0.0),(0.86,0.14,0.0),(0.82,0.18,0.0),(0.78,0.22,0.0),(0.74,0.26,0.0),(0.69,0.31,0.0),(0.65,0.35,0.0),(0.6,0.4,0.0),(0.55,0.45,0.0),(0.5,0.5,0.0)]),
    ColorInterpolator(DEF='Color5',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(0.5,0.5,0.0),(0.45,0.55,0.0),(0.4,0.6,0.0),(0.35,0.65,0.0),(0.31,0.69,0.0),(0.26,0.74,0.0),(0.22,0.78,0.0),(0.18,0.82,0.0),(0.14,0.86,0.0),(0.11,0.89,0.0),(0.08,0.92,0.0),(0.06,0.94,0.0),(0.03,0.97,0.0),(0.02,0.98,0.0),(0.01,0.99,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.01,0.99,0.0),(0.03,0.97,0.0),(0.04,0.96,0.0),(0.07,0.93,0.0),(0.09,0.91,0.0),(0.13,0.87,0.0),(0.16,0.84,0.0),(0.2,0.8,0.0),(0.24,0.76,0.0),(0.28,0.72,0.0),(0.33,0.67,0.0),(0.38,0.62,0.0),(0.43,0.57,0.0),(0.48,0.52,0.0),(0.52,0.48,0.0),(0.57,0.43,0.0),(0.62,0.38,0.0),(0.67,0.33,0.0),(0.72,0.28,0.0),(0.76,0.24,0.0),(0.8,0.2,0.0),(0.84,0.16,0.0),(0.87,0.13,0.0),(0.91,0.09,0.0),(0.93,0.07,0.0),(0.96,0.04,0.0),(0.97,0.03,0.0),(0.99,0.01,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(0.99,0.01,0.0),(0.98,0.02,0.0),(0.97,0.03,0.0),(0.94,0.06,0.0),(0.92,0.08,0.0),(0.89,0.11,0.0),(0.86,0.14,0.0),(0.82,0.18,0.0),(0.78,0.22,0.0),(0.74,0.26,0.0),(0.69,0.31,0.0),(0.65,0.35,0.0),(0.6,0.4,0.0),(0.55,0.45,0.0),(0.5,0.5,0.0)]),
    ColorInterpolator(DEF='Color6',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(0.5,0.5,0.0),(0.45,0.55,0.0),(0.4,0.6,0.0),(0.35,0.65,0.0),(0.31,0.69,0.0),(0.26,0.74,0.0),(0.22,0.78,0.0),(0.18,0.82,0.0),(0.14,0.86,0.0),(0.11,0.89,0.0),(0.08,0.92,0.0),(0.06,0.94,0.0),(0.03,0.97,0.0),(0.02,0.98,0.0),(0.01,0.99,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.01,0.99,0.0),(0.03,0.97,0.0),(0.04,0.96,0.0),(0.07,0.93,0.0),(0.09,0.91,0.0),(0.13,0.87,0.0),(0.16,0.84,0.0),(0.2,0.8,0.0),(0.24,0.76,0.0),(0.28,0.72,0.0),(0.33,0.67,0.0),(0.38,0.62,0.0),(0.43,0.57,0.0),(0.48,0.52,0.0),(0.52,0.48,0.0),(0.57,0.43,0.0),(0.62,0.38,0.0),(0.67,0.33,0.0),(0.72,0.28,0.0),(0.76,0.24,0.0),(0.8,0.2,0.0),(0.84,0.16,0.0),(0.87,0.13,0.0),(0.91,0.09,0.0),(0.93,0.07,0.0),(0.96,0.04,0.0),(0.97,0.03,0.0),(0.99,0.01,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(0.99,0.01,0.0),(0.98,0.02,0.0),(0.97,0.03,0.0),(0.94,0.06,0.0),(0.92,0.08,0.0),(0.89,0.11,0.0),(0.86,0.14,0.0),(0.82,0.18,0.0),(0.78,0.22,0.0),(0.74,0.26,0.0),(0.69,0.31,0.0),(0.65,0.35,0.0),(0.6,0.4,0.0),(0.55,0.45,0.0),(0.5,0.5,0.0)]),
    ColorInterpolator(DEF='Color7',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(0.5,0.5,0.0),(0.45,0.55,0.0),(0.4,0.6,0.0),(0.35,0.65,0.0),(0.31,0.69,0.0),(0.26,0.74,0.0),(0.22,0.78,0.0),(0.18,0.82,0.0),(0.14,0.86,0.0),(0.11,0.89,0.0),(0.08,0.92,0.0),(0.06,0.94,0.0),(0.03,0.97,0.0),(0.02,0.98,0.0),(0.01,0.99,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.01,0.99,0.0),(0.03,0.97,0.0),(0.04,0.96,0.0),(0.07,0.93,0.0),(0.09,0.91,0.0),(0.13,0.87,0.0),(0.16,0.84,0.0),(0.2,0.8,0.0),(0.24,0.76,0.0),(0.28,0.72,0.0),(0.33,0.67,0.0),(0.38,0.62,0.0),(0.43,0.57,0.0),(0.48,0.52,0.0),(0.52,0.48,0.0),(0.57,0.43,0.0),(0.62,0.38,0.0),(0.67,0.33,0.0),(0.72,0.28,0.0),(0.76,0.24,0.0),(0.8,0.2,0.0),(0.84,0.16,0.0),(0.87,0.13,0.0),(0.91,0.09,0.0),(0.93,0.07,0.0),(0.96,0.04,0.0),(0.97,0.03,0.0),(0.99,0.01,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(0.99,0.01,0.0),(0.98,0.02,0.0),(0.97,0.03,0.0),(0.94,0.06,0.0),(0.92,0.08,0.0),(0.89,0.11,0.0),(0.86,0.14,0.0),(0.82,0.18,0.0),(0.78,0.22,0.0),(0.74,0.26,0.0),(0.69,0.31,0.0),(0.65,0.35,0.0),(0.6,0.4,0.0),(0.55,0.45,0.0),(0.5,0.5,0.0)]),
    ColorInterpolator(DEF='Color8',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(0.5,0.5,0.0),(0.45,0.55,0.0),(0.4,0.6,0.0),(0.35,0.65,0.0),(0.31,0.69,0.0),(0.26,0.74,0.0),(0.22,0.78,0.0),(0.18,0.82,0.0),(0.14,0.86,0.0),(0.11,0.89,0.0),(0.08,0.92,0.0),(0.06,0.94,0.0),(0.03,0.97,0.0),(0.02,0.98,0.0),(0.01,0.99,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.01,0.99,0.0),(0.03,0.97,0.0),(0.04,0.96,0.0),(0.07,0.93,0.0),(0.09,0.91,0.0),(0.13,0.87,0.0),(0.16,0.84,0.0),(0.2,0.8,0.0),(0.24,0.76,0.0),(0.28,0.72,0.0),(0.33,0.67,0.0),(0.38,0.62,0.0),(0.43,0.57,0.0),(0.48,0.52,0.0),(0.52,0.48,0.0),(0.57,0.43,0.0),(0.62,0.38,0.0),(0.67,0.33,0.0),(0.72,0.28,0.0),(0.76,0.24,0.0),(0.8,0.2,0.0),(0.84,0.16,0.0),(0.87,0.13,0.0),(0.91,0.09,0.0),(0.93,0.07,0.0),(0.96,0.04,0.0),(0.97,0.03,0.0),(0.99,0.01,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(0.99,0.01,0.0),(0.98,0.02,0.0),(0.97,0.03,0.0),(0.94,0.06,0.0),(0.92,0.08,0.0),(0.89,0.11,0.0),(0.86,0.14,0.0),(0.82,0.18,0.0),(0.78,0.22,0.0),(0.74,0.26,0.0),(0.69,0.31,0.0),(0.65,0.35,0.0),(0.6,0.4,0.0),(0.55,0.45,0.0),(0.5,0.5,0.0)]),
    ColorInterpolator(DEF='Color9',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(0.5,0.5,0.0),(0.45,0.55,0.0),(0.4,0.6,0.0),(0.35,0.65,0.0),(0.31,0.69,0.0),(0.26,0.74,0.0),(0.22,0.78,0.0),(0.18,0.82,0.0),(0.14,0.86,0.0),(0.11,0.89,0.0),(0.08,0.92,0.0),(0.06,0.94,0.0),(0.03,0.97,0.0),(0.02,0.98,0.0),(0.01,0.99,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.01,0.99,0.0),(0.03,0.97,0.0),(0.04,0.96,0.0),(0.07,0.93,0.0),(0.09,0.91,0.0),(0.13,0.87,0.0),(0.16,0.84,0.0),(0.2,0.8,0.0),(0.24,0.76,0.0),(0.28,0.72,0.0),(0.33,0.67,0.0),(0.38,0.62,0.0),(0.43,0.57,0.0),(0.48,0.52,0.0),(0.52,0.48,0.0),(0.57,0.43,0.0),(0.62,0.38,0.0),(0.67,0.33,0.0),(0.72,0.28,0.0),(0.76,0.24,0.0),(0.8,0.2,0.0),(0.84,0.16,0.0),(0.87,0.13,0.0),(0.91,0.09,0.0),(0.93,0.07,0.0),(0.96,0.04,0.0),(0.97,0.03,0.0),(0.99,0.01,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(0.99,0.01,0.0),(0.98,0.02,0.0),(0.97,0.03,0.0),(0.94,0.06,0.0),(0.92,0.08,0.0),(0.89,0.11,0.0),(0.86,0.14,0.0),(0.82,0.18,0.0),(0.78,0.22,0.0),(0.74,0.26,0.0),(0.69,0.31,0.0),(0.65,0.35,0.0),(0.6,0.4,0.0),(0.55,0.45,0.0),(0.5,0.5,0.0)]),
    ColorInterpolator(DEF='Color10',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(0.5,0.5,0.0),(0.45,0.55,0.0),(0.4,0.6,0.0),(0.35,0.65,0.0),(0.31,0.69,0.0),(0.26,0.74,0.0),(0.22,0.78,0.0),(0.18,0.82,0.0),(0.14,0.86,0.0),(0.11,0.89,0.0),(0.08,0.92,0.0),(0.06,0.94,0.0),(0.03,0.97,0.0),(0.02,0.98,0.0),(0.01,0.99,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.01,0.99,0.0),(0.03,0.97,0.0),(0.04,0.96,0.0),(0.07,0.93,0.0),(0.09,0.91,0.0),(0.13,0.87,0.0),(0.16,0.84,0.0),(0.2,0.8,0.0),(0.24,0.76,0.0),(0.28,0.72,0.0),(0.33,0.67,0.0),(0.38,0.62,0.0),(0.43,0.57,0.0),(0.48,0.52,0.0),(0.52,0.48,0.0),(0.57,0.43,0.0),(0.62,0.38,0.0),(0.67,0.33,0.0),(0.72,0.28,0.0),(0.76,0.24,0.0),(0.8,0.2,0.0),(0.84,0.16,0.0),(0.87,0.13,0.0),(0.91,0.09,0.0),(0.93,0.07,0.0),(0.96,0.04,0.0),(0.97,0.03,0.0),(0.99,0.01,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(0.99,0.01,0.0),(0.98,0.02,0.0),(0.97,0.03,0.0),(0.94,0.06,0.0),(0.92,0.08,0.0),(0.89,0.11,0.0),(0.86,0.14,0.0),(0.82,0.18,0.0),(0.78,0.22,0.0),(0.74,0.26,0.0),(0.69,0.31,0.0),(0.65,0.35,0.0),(0.6,0.4,0.0),(0.55,0.45,0.0),(0.5,0.5,0.0)]),
    ColorInterpolator(DEF='Color11',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(0.5,0.5,0.0),(0.45,0.55,0.0),(0.4,0.6,0.0),(0.35,0.65,0.0),(0.31,0.69,0.0),(0.26,0.74,0.0),(0.22,0.78,0.0),(0.18,0.82,0.0),(0.14,0.86,0.0),(0.11,0.89,0.0),(0.08,0.92,0.0),(0.06,0.94,0.0),(0.03,0.97,0.0),(0.02,0.98,0.0),(0.01,0.99,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.01,0.99,0.0),(0.03,0.97,0.0),(0.04,0.96,0.0),(0.07,0.93,0.0),(0.09,0.91,0.0),(0.13,0.87,0.0),(0.16,0.84,0.0),(0.2,0.8,0.0),(0.24,0.76,0.0),(0.28,0.72,0.0),(0.33,0.67,0.0),(0.38,0.62,0.0),(0.43,0.57,0.0),(0.48,0.52,0.0),(0.52,0.48,0.0),(0.57,0.43,0.0),(0.62,0.38,0.0),(0.67,0.33,0.0),(0.72,0.28,0.0),(0.76,0.24,0.0),(0.8,0.2,0.0),(0.84,0.16,0.0),(0.87,0.13,0.0),(0.91,0.09,0.0),(0.93,0.07,0.0),(0.96,0.04,0.0),(0.97,0.03,0.0),(0.99,0.01,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(0.99,0.01,0.0),(0.98,0.02,0.0),(0.97,0.03,0.0),(0.94,0.06,0.0),(0.92,0.08,0.0),(0.89,0.11,0.0),(0.86,0.14,0.0),(0.82,0.18,0.0),(0.78,0.22,0.0),(0.74,0.26,0.0),(0.69,0.31,0.0),(0.65,0.35,0.0),(0.6,0.4,0.0),(0.55,0.45,0.0),(0.5,0.5,0.0)]),
    ColorInterpolator(DEF='Color12',key=[0.0,0.02,0.03,0.05,0.06,0.08,0.1,0.11,0.13,0.14,0.16,0.17,0.19,0.21,0.22,0.24,0.25,0.27,0.29,0.3,0.32,0.33,0.35,0.37,0.38,0.4,0.41,0.43,0.44,0.46,0.48,0.49,0.51,0.52,0.54,0.56,0.57,0.59,0.6,0.62,0.63,0.65,0.67,0.68,0.7,0.71,0.73,0.75,0.76,0.78,0.79,0.81,0.83,0.84,0.86,0.87,0.89,0.9,0.92,0.94,0.95,0.97,0.98,1.0],keyValue=[(0.5,0.5,0.0),(0.45,0.55,0.0),(0.4,0.6,0.0),(0.35,0.65,0.0),(0.31,0.69,0.0),(0.26,0.74,0.0),(0.22,0.78,0.0),(0.18,0.82,0.0),(0.14,0.86,0.0),(0.11,0.89,0.0),(0.08,0.92,0.0),(0.06,0.94,0.0),(0.03,0.97,0.0),(0.02,0.98,0.0),(0.01,0.99,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.01,0.99,0.0),(0.03,0.97,0.0),(0.04,0.96,0.0),(0.07,0.93,0.0),(0.09,0.91,0.0),(0.13,0.87,0.0),(0.16,0.84,0.0),(0.2,0.8,0.0),(0.24,0.76,0.0),(0.28,0.72,0.0),(0.33,0.67,0.0),(0.38,0.62,0.0),(0.43,0.57,0.0),(0.48,0.52,0.0),(0.52,0.48,0.0),(0.57,0.43,0.0),(0.62,0.38,0.0),(0.67,0.33,0.0),(0.72,0.28,0.0),(0.76,0.24,0.0),(0.8,0.2,0.0),(0.84,0.16,0.0),(0.87,0.13,0.0),(0.91,0.09,0.0),(0.93,0.07,0.0),(0.96,0.04,0.0),(0.97,0.03,0.0),(0.99,0.01,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0),(0.99,0.01,0.0),(0.98,0.02,0.0),(0.97,0.03,0.0),(0.94,0.06,0.0),(0.92,0.08,0.0),(0.89,0.11,0.0),(0.86,0.14,0.0),(0.82,0.18,0.0),(0.78,0.22,0.0),(0.74,0.26,0.0),(0.69,0.31,0.0),(0.65,0.35,0.0),(0.6,0.4,0.0),(0.55,0.45,0.0),(0.5,0.5,0.0)]),
    #  Wire the animation circuit 
    ROUTE(fromField='fraction_changed',fromNode='Timer1',toField='set_fraction',toNode='Position1'),
    ROUTE(fromField='value_changed',fromNode='Position1',toField='set_translation',toNode='Particle1'),
    ROUTE(fromField='fraction_changed',fromNode='Timer1',toField='set_fraction',toNode='Color1'),
    ROUTE(fromField='value_changed',fromNode='Color1',toField='set_diffuseColor',toNode='Material1'),
    ROUTE(fromField='fraction_changed',fromNode='Timer2',toField='set_fraction',toNode='Position2'),
    ROUTE(fromField='value_changed',fromNode='Position2',toField='set_translation',toNode='Particle2'),
    ROUTE(fromField='fraction_changed',fromNode='Timer2',toField='set_fraction',toNode='Color2'),
    ROUTE(fromField='value_changed',fromNode='Color2',toField='set_diffuseColor',toNode='Material2'),
    ROUTE(fromField='fraction_changed',fromNode='Timer3',toField='set_fraction',toNode='Position3'),
    ROUTE(fromField='value_changed',fromNode='Position3',toField='set_translation',toNode='Particle3'),
    ROUTE(fromField='fraction_changed',fromNode='Timer3',toField='set_fraction',toNode='Color3'),
    ROUTE(fromField='value_changed',fromNode='Color3',toField='set_diffuseColor',toNode='Material3'),
    ROUTE(fromField='fraction_changed',fromNode='Timer4',toField='set_fraction',toNode='Position4'),
    ROUTE(fromField='value_changed',fromNode='Position4',toField='set_translation',toNode='Particle4'),
    ROUTE(fromField='fraction_changed',fromNode='Timer4',toField='set_fraction',toNode='Color4'),
    ROUTE(fromField='value_changed',fromNode='Color4',toField='set_diffuseColor',toNode='Material4'),
    ROUTE(fromField='fraction_changed',fromNode='Timer5',toField='set_fraction',toNode='Position5'),
    ROUTE(fromField='value_changed',fromNode='Position5',toField='set_translation',toNode='Particle5'),
    ROUTE(fromField='fraction_changed',fromNode='Timer5',toField='set_fraction',toNode='Color5'),
    ROUTE(fromField='value_changed',fromNode='Color5',toField='set_diffuseColor',toNode='Material5'),
    ROUTE(fromField='fraction_changed',fromNode='Timer6',toField='set_fraction',toNode='Position6'),
    ROUTE(fromField='value_changed',fromNode='Position6',toField='set_translation',toNode='Particle6'),
    ROUTE(fromField='fraction_changed',fromNode='Timer6',toField='set_fraction',toNode='Color6'),
    ROUTE(fromField='value_changed',fromNode='Color6',toField='set_diffuseColor',toNode='Material6'),
    ROUTE(fromField='fraction_changed',fromNode='Timer7',toField='set_fraction',toNode='Position7'),
    ROUTE(fromField='value_changed',fromNode='Position7',toField='set_translation',toNode='Particle7'),
    ROUTE(fromField='fraction_changed',fromNode='Timer7',toField='set_fraction',toNode='Color7'),
    ROUTE(fromField='value_changed',fromNode='Color7',toField='set_diffuseColor',toNode='Material7'),
    ROUTE(fromField='fraction_changed',fromNode='Timer8',toField='set_fraction',toNode='Position8'),
    ROUTE(fromField='value_changed',fromNode='Position8',toField='set_translation',toNode='Particle8'),
    ROUTE(fromField='fraction_changed',fromNode='Timer8',toField='set_fraction',toNode='Color8'),
    ROUTE(fromField='value_changed',fromNode='Color8',toField='set_diffuseColor',toNode='Material8'),
    ROUTE(fromField='fraction_changed',fromNode='Timer9',toField='set_fraction',toNode='Position9'),
    ROUTE(fromField='value_changed',fromNode='Position9',toField='set_translation',toNode='Particle9'),
    ROUTE(fromField='fraction_changed',fromNode='Timer9',toField='set_fraction',toNode='Color9'),
    ROUTE(fromField='value_changed',fromNode='Color9',toField='set_diffuseColor',toNode='Material9'),
    ROUTE(fromField='fraction_changed',fromNode='Timer10',toField='set_fraction',toNode='Position10'),
    ROUTE(fromField='value_changed',fromNode='Position10',toField='set_translation',toNode='Particle10'),
    ROUTE(fromField='fraction_changed',fromNode='Timer10',toField='set_fraction',toNode='Color10'),
    ROUTE(fromField='value_changed',fromNode='Color10',toField='set_diffuseColor',toNode='Material10'),
    ROUTE(fromField='fraction_changed',fromNode='Timer11',toField='set_fraction',toNode='Position11'),
    ROUTE(fromField='value_changed',fromNode='Position11',toField='set_translation',toNode='Particle11'),
    ROUTE(fromField='fraction_changed',fromNode='Timer11',toField='set_fraction',toNode='Color11'),
    ROUTE(fromField='value_changed',fromNode='Color11',toField='set_diffuseColor',toNode='Material11'),
    ROUTE(fromField='fraction_changed',fromNode='Timer12',toField='set_fraction',toNode='Position12'),
    ROUTE(fromField='value_changed',fromNode='Position12',toField='set_translation',toNode='Particle12'),
    ROUTE(fromField='fraction_changed',fromNode='Timer12',toField='set_fraction',toNode='Color12'),
    ROUTE(fromField='value_changed',fromNode='Color12',toField='set_diffuseColor',toNode='Material12')])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for Spiral.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python Spiral.py load and self-test diagnostics complete.")
