package Vrml2Sourcebook.Siggraph98Course;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.EnvironmentalSensor.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Sound.*;
import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Proximity pillars example illustrates the use of proximity sensors to sense when the user gets close, and trigger animations or sounds. </p>
 <p> Related links: Catalog page <a href="../../../Siggraph98Course/Proximity2Index.html" target="_blank">Proximity2</a>,  source <a href="../../../Siggraph98Course/Proximity2.java">Proximity2.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Siggraph98Course/Proximity2.x3d">Proximity2.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Proximity pillars example illustrates the use of proximity sensors to sense when the user gets close, and trigger animations or sounds. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> David R. Nadeau </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 1 July 1998 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 2 February 2014 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> originals/prox2.wrl </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.siggraph.org/s98" target="_blank">http://www.siggraph.org/s98</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.siggraph.org/s98/conference/courses/18.html" target="_blank">http://www.siggraph.org/s98/conference/courses/18.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0376.htm" target="_blank">http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0376.htm</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm" target="_blank">http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">https://www.web3d.org/x3d/content/examples/X3dResources.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Proximity2.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Proximity2.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Siggraph98Course/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author David R. Nadeau
 */

public class Proximity2
{
	/** Default constructor to create this object. */
	public Proximity2 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("Proximity2.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Proximity pillars example illustrates the use of proximity sensors to sense when the user gets close, and trigger animations or sounds."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("David R. Nadeau"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("1 July 1998"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("2 February 2014"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("originals/prox2.wrl"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.siggraph.org/s98"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.siggraph.org/s98/conference/courses/18.html"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0376.htm"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/x3d/content/examples/X3dResources.html"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Proximity2.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setInfo(new String[] {"Copyright (c) 1997, David R. Nadeau"}).setTitle("Proximity pillars"))
    .addChild(new Viewpoint().setDescription("Entry view").setOrientation(0.0,1.0,0.0,0.785).setPosition(7.5,1.7,7.5))
    .addChild(new NavigationInfo().setHeadlight(false).setSpeed(3.0))
    .addChild(new Background().setSkyAngle(new double[] {1.57,1.87}).setSkyColor(new MFColor(new double[] {0.0,0.0,0.0,0.0,0.0,0.0,1.0,1.0,1.0})))
    .addChild(new Fog().setColor(0.1,0.1,0.1).setVisibilityRange(18.0))
    .addChild(new DirectionalLight().setDirection(-1.0,-0.5,-0.5))
    .addChild(new Shape()
      .setAppearance(new Appearance()
        .setTextureTransform(new TextureTransform().setScale(16.0,16.0))
        .setTexture(new ImageTexture().setUrl(new String[] {"grill.png","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/grill.png"})))
      .setGeometry(new IndexedFaceSet().setCoordIndex(new int[] {0,1,2,3}).setTexCoordIndex(new int[] {0,1,2,3})
        .setTexCoord(new TextureCoordinate().setPoint(new MFVec2f(new double[] {0.0,0.0,1.0,0.0,1.0,1.0,0.0,1.0})))
        .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-16.0,0.0,16.0,16.0,0.0,16.0,16.0,0.0,-16.0,-16.0,0.0,-16.0})))))
    .addChild(new Sound().setMaxBack(100.0).setMaxFront(100.0).setMinBack(100.0).setMinFront(100.0)
      .setSource(new AudioClip("Bonk").setStopTime(1.0).setUrl(new String[] {"dropbrk.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/dropbrk.wav"})))
    .addChild(new Collision("HitBar1")
      .addChild(new Transform().setTranslation(-2.0,0.0,2.0)
        .addChild(new ProximitySensor("NearBar1").setSize(14.0,14.0,14.0))
        .addChild(new Shape()
          .setAppearance(new Appearance()
            .setMaterial(new Material("MaterialBar1").setDiffuseColor(0.0,0.3,1.0).setTransparency(1.0)))
          .setGeometry(new IndexedFaceSet().setCoordIndex(new int[] {0,1,5,4,-1,1,2,6,5,-1,2,3,7,6,-1,3,0,4,7,-1,4,5,6,7,-1})
            .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-0.5,0.0,0.5,0.5,0.0,0.5,0.5,0.0,-0.5,-0.5,0.0,-0.5,-0.5,4.0,0.5,0.5,4.0,0.5,0.5,4.0,-0.5,-0.5,4.0,-0.5})))))))
    .addChild(new TimeSensor("ClockOnBar1").setStopTime(1.0))
    .addChild(new TimeSensor("ClockOffBar1").setStopTime(1.0))
    .addChild(new ScalarInterpolator("OnBar1").setKey(new double[] {0.0,1.0}).setKeyValue(new double[] {1.0,0.0}))
    .addChild(new ScalarInterpolator("OffBar1").setKey(new double[] {0.0,1.0}).setKeyValue(new double[] {0.0,1.0}))
    .addChild(new ROUTE().setFromNode("NearBar1").setFromField("enterTime").setToNode("ClockOnBar1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("NearBar1").setFromField("exitTime").setToNode("ClockOffBar1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockOnBar1").setFromField("fraction_changed").setToNode("OnBar1").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("ClockOffBar1").setFromField("fraction_changed").setToNode("OffBar1").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("OnBar1").setFromField("value_changed").setToNode("MaterialBar1").setToField("set_transparency"))
    .addChild(new ROUTE().setFromNode("OffBar1").setFromField("value_changed").setToNode("MaterialBar1").setToField("set_transparency"))
    .addChild(new ROUTE().setFromNode("HitBar1").setFromField("collideTime").setToNode("Bonk").setToField("set_startTime"))
    .addChild(new Collision("HitBar2")
      .addChild(new Transform().setTranslation(4.0,0.0,0.0)
        .addChild(new ProximitySensor("NearBar2").setSize(14.0,14.0,14.0))
        .addChild(new Shape()
          .setAppearance(new Appearance()
            .setMaterial(new Material("MaterialBar2").setDiffuseColor(0.0,1.0,0.0).setTransparency(1.0)))
          .setGeometry(new IndexedFaceSet().setCoordIndex(new int[] {0,1,5,4,-1,1,2,6,5,-1,2,3,7,6,-1,3,0,4,7,-1,4,5,6,7,-1})
            .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-0.5,0.0,0.5,0.5,0.0,0.5,0.5,0.0,-0.5,-0.5,0.0,-0.5,-0.5,2.0,0.5,0.5,2.0,0.5,0.5,2.0,-0.5,-0.5,2.0,-0.5})))))))
    .addChild(new TimeSensor("ClockOnBar2").setStopTime(1.0))
    .addChild(new TimeSensor("ClockOffBar2").setStopTime(1.0))
    .addChild(new ScalarInterpolator("OnBar2").setKey(new double[] {0.0,1.0}).setKeyValue(new double[] {1.0,0.0}))
    .addChild(new ScalarInterpolator("OffBar2").setKey(new double[] {0.0,1.0}).setKeyValue(new double[] {0.0,1.0}))
    .addChild(new ROUTE().setFromNode("NearBar2").setFromField("enterTime").setToNode("ClockOnBar2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("NearBar2").setFromField("exitTime").setToNode("ClockOffBar2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockOnBar2").setFromField("fraction_changed").setToNode("OnBar2").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("ClockOffBar2").setFromField("fraction_changed").setToNode("OffBar2").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("OnBar2").setFromField("value_changed").setToNode("MaterialBar2").setToField("set_transparency"))
    .addChild(new ROUTE().setFromNode("OffBar2").setFromField("value_changed").setToNode("MaterialBar2").setToField("set_transparency"))
    .addChild(new ROUTE().setFromNode("HitBar2").setFromField("collideTime").setToNode("Bonk").setToField("set_startTime"))
    .addChild(new Collision("HitBar3")
      .addChild(new Transform().setTranslation(-4.0,0.0,-4.0)
        .addChild(new ProximitySensor("NearBar3").setSize(14.0,14.0,14.0))
        .addChild(new Shape()
          .setAppearance(new Appearance()
            .setMaterial(new Material("MaterialBar3").setDiffuseColor(1.0,1.0,0.0).setTransparency(1.0)))
          .setGeometry(new IndexedFaceSet().setCoordIndex(new int[] {0,1,5,4,-1,1,2,6,5,-1,2,3,7,6,-1,3,0,4,7,-1,4,5,6,7,-1})
            .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-0.5,0.0,0.5,0.5,0.0,0.5,0.5,0.0,-0.5,-0.5,0.0,-0.5,-0.5,4.0,0.5,0.5,4.0,0.5,0.5,4.0,-0.5,-0.5,4.0,-0.5})))))))
    .addChild(new TimeSensor("ClockOnBar3").setStopTime(1.0))
    .addChild(new TimeSensor("ClockOffBar3").setStopTime(1.0))
    .addChild(new ScalarInterpolator("OnBar3").setKey(new double[] {0.0,1.0}).setKeyValue(new double[] {1.0,0.0}))
    .addChild(new ScalarInterpolator("OffBar3").setKey(new double[] {0.0,1.0}).setKeyValue(new double[] {0.0,1.0}))
    .addChild(new ROUTE().setFromNode("NearBar3").setFromField("enterTime").setToNode("ClockOnBar3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("NearBar3").setFromField("exitTime").setToNode("ClockOffBar3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockOnBar3").setFromField("fraction_changed").setToNode("OnBar3").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("ClockOffBar3").setFromField("fraction_changed").setToNode("OffBar3").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("OnBar3").setFromField("value_changed").setToNode("MaterialBar3").setToField("set_transparency"))
    .addChild(new ROUTE().setFromNode("OffBar3").setFromField("value_changed").setToNode("MaterialBar3").setToField("set_transparency"))
    .addChild(new ROUTE().setFromNode("HitBar3").setFromField("collideTime").setToNode("Bonk").setToField("set_startTime"))
    .addChild(new Collision("HitBar4")
      .addChild(new Transform().setTranslation(2.0,0.0,-2.0)
        .addChild(new ProximitySensor("NearBar4").setSize(14.0,14.0,14.0))
        .addChild(new Shape()
          .setAppearance(new Appearance()
            .setMaterial(new Material("MaterialBar4").setDiffuseColor(1.0,0.0,0.0).setTransparency(1.0)))
          .setGeometry(new IndexedFaceSet().setCoordIndex(new int[] {0,1,5,4,-1,1,2,6,5,-1,2,3,7,6,-1,3,0,4,7,-1,4,5,6,7,-1})
            .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-0.5,0.0,0.5,0.5,0.0,0.5,0.5,0.0,-0.5,-0.5,0.0,-0.5,-0.5,3.0,0.5,0.5,3.0,0.5,0.5,3.0,-0.5,-0.5,3.0,-0.5})))))))
    .addChild(new TimeSensor("ClockOnBar4").setStopTime(1.0))
    .addChild(new TimeSensor("ClockOffBar4").setStopTime(1.0))
    .addChild(new ScalarInterpolator("OnBar4").setKey(new double[] {0.0,1.0}).setKeyValue(new double[] {1.0,0.0}))
    .addChild(new ScalarInterpolator("OffBar4").setKey(new double[] {0.0,1.0}).setKeyValue(new double[] {0.0,1.0}))
    .addChild(new ROUTE().setFromNode("NearBar4").setFromField("enterTime").setToNode("ClockOnBar4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("NearBar4").setFromField("exitTime").setToNode("ClockOffBar4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockOnBar4").setFromField("fraction_changed").setToNode("OnBar4").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("ClockOffBar4").setFromField("fraction_changed").setToNode("OffBar4").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("OnBar4").setFromField("value_changed").setToNode("MaterialBar4").setToField("set_transparency"))
    .addChild(new ROUTE().setFromNode("OffBar4").setFromField("value_changed").setToNode("MaterialBar4").setToField("set_transparency"))
    .addChild(new ROUTE().setFromNode("HitBar4").setFromField("collideTime").setToNode("Bonk").setToField("set_startTime")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return Proximity2 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new Proximity2().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Vrml2Sourcebook.Siggraph98Course.Proximity2\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Vrml2Sourcebook.Siggraph98Course.Proximity2 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Siggraph98Course/Proximity2_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Siggraph98Course/Proximity2_JavaExport.x3d"; 
                String filenameX3DV = "Siggraph98Course/Proximity2_JavaExport.x3dv"; 
                String filenameJSON = "Siggraph98Course/Proximity2_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
