####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python Mountain32.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interactive',version='3.3',
  head=head(
    children=[
    meta(content='Mountain32.x3d',name='title'),
    meta(content='Mid-resolution mountain.',name='description'),
    meta(content='John L. Moreland',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='1 July 1998',name='created'),
    meta(content='2 February 2014',name='translated'),
    meta(content='20 October 2019',name='modified'),
    meta(content='originals/mount32.wrl',name='reference'),
    meta(content='http://www.siggraph.org/s98',name='reference'),
    meta(content='http://www.siggraph.org/s98/conference/courses/18.html',name='reference'),
    meta(content='http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0201.htm',name='reference'),
    meta(content='http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/X3dResources.html',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Mountain32.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(info=["copyright (c) 1997, John L. Moreland"],title='Mid-res Mountain'),
    Viewpoint(description='Entry view',orientation=(1.0,0.0,0.0,-0.2),position=(1.2,0.9,4.0)),
    NavigationInfo(),
    Shape(
      appearance=Appearance(
        material=Material(),),
      geometry=ElevationGrid(height=[0.019608,0.027451,0.031373,0.035294,0.043137,0.043137,0.05098,0.047059,0.054902,0.054902,0.054902,0.054902,0.066667,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.058824,0.058824,0.062745,0.054902,0.054902,0.047059,0.05098,0.047059,0.039216,0.035294,0.031373,0.031373,0.019608,0.019608,0.027451,0.039216,0.039216,0.047059,0.047059,0.05098,0.047059,0.058824,0.058824,0.062745,0.062745,0.066667,0.070588,0.066667,0.070588,0.070588,0.066667,0.062745,0.066667,0.07451,0.070588,0.078431,0.07451,0.062745,0.062745,0.054902,0.047059,0.043137,0.039216,0.031373,0.027451,0.035294,0.039216,0.035294,0.05098,0.039216,0.058824,0.054902,0.05098,0.062745,0.066667,0.066667,0.066667,0.070588,0.070588,0.070588,0.070588,0.070588,0.066667,0.070588,0.07451,0.098039,0.121569,0.129412,0.113725,0.086275,0.101961,0.078431,0.066667,0.066667,0.047059,0.043137,0.035294,0.031373,0.043137,0.047059,0.05098,0.058824,0.066667,0.066667,0.062745,0.062745,0.066667,0.058824,0.070588,0.058824,0.070588,0.070588,0.062745,0.062745,0.070588,0.070588,0.082353,0.113725,0.160784,0.227451,0.196078,0.196078,0.145098,0.12549,0.105882,0.062745,0.05098,0.047059,0.031373,0.039216,0.047059,0.05098,0.047059,0.058824,0.070588,0.07451,0.066667,0.066667,0.066667,0.062745,0.058824,0.054902,0.062745,0.062745,0.054902,0.058824,0.062745,0.066667,0.082353,0.145098,0.247059,0.27451,0.270588,0.227451,0.219608,0.168627,0.121569,0.07451,0.058824,0.05098,0.043137,0.047059,0.05098,0.054902,0.062745,0.062745,0.07451,0.070588,0.070588,0.058824,0.058824,0.062745,0.05098,0.047059,0.054902,0.039216,0.058824,0.054902,0.05098,0.058824,0.086275,0.129412,0.254902,0.333333,0.305882,0.294118,0.25098,0.211765,0.129412,0.070588,0.058824,0.05098,0.047059,0.035294,0.05098,0.058824,0.05098,0.070588,0.078431,0.07451,0.066667,0.062745,0.054902,0.058824,0.047059,0.047059,0.039216,0.039216,0.035294,0.054902,0.066667,0.058824,0.090196,0.211765,0.301961,0.356863,0.364706,0.32549,0.298039,0.223529,0.121569,0.07451,0.058824,0.05098,0.047059,0.047059,0.058824,0.058824,0.066667,0.070588,0.078431,0.078431,0.062745,0.058824,0.05098,0.039216,0.047059,0.039216,0.039216,0.043137,0.05098,0.082353,0.117647,0.07451,0.152941,0.219608,0.32549,0.384314,0.372549,0.356863,0.317647,0.247059,0.105882,0.066667,0.054902,0.054902,0.043137,0.054902,0.05098,0.070588,0.066667,0.07451,0.086275,0.078431,0.058824,0.054902,0.043137,0.047059,0.035294,0.035294,0.031373,0.027451,0.05098,0.086275,0.235294,0.129412,0.160784,0.231373,0.286275,0.372549,0.329412,0.321569,0.254902,0.231373,0.172549,0.082353,0.05098,0.058824,0.058824,0.058824,0.062745,0.066667,0.078431,0.082353,0.086275,0.078431,0.062745,0.039216,0.039216,0.035294,0.035294,0.027451,0.027451,0.035294,0.098039,0.203922,0.243137,0.305882,0.270588,0.258824,0.254902,0.239216,0.160784,0.152941,0.141176,0.129412,0.117647,0.090196,0.062745,0.058824,0.05098,0.054902,0.062745,0.066667,0.070588,0.082353,0.078431,0.07451,0.047059,0.035294,0.031373,0.023529,0.027451,0.027451,0.035294,0.058824,0.239216,0.454902,0.541176,0.517647,0.4,0.239216,0.129412,0.121569,0.086275,0.094118,0.086275,0.078431,0.070588,0.058824,0.070588,0.058824,0.062745,0.05098,0.062745,0.062745,0.070588,0.082353,0.078431,0.066667,0.054902,0.043137,0.027451,0.023529,0.031373,0.043137,0.098039,0.152941,0.419608,0.580392,0.796078,0.709804,0.427451,0.227451,0.137255,0.070588,0.05098,0.047059,0.047059,0.054902,0.058824,0.066667,0.07451,0.066667,0.062745,0.062745,0.062745,0.066667,0.066667,0.07451,0.078431,0.047059,0.031373,0.023529,0.023529,0.027451,0.039216,0.129412,0.227451,0.47451,0.733333,0.815686,0.854902,0.701961,0.552941,0.317647,0.145098,0.054902,0.027451,0.035294,0.043137,0.05098,0.062745,0.066667,0.066667,0.066667,0.062745,0.066667,0.066667,0.066667,0.070588,0.07451,0.062745,0.058824,0.043137,0.031373,0.031373,0.047059,0.058824,0.137255,0.494118,0.803922,0.913725,0.917647,0.890196,0.807843,0.486275,0.184314,0.039216,0.031373,0.027451,0.031373,0.035294,0.047059,0.05098,0.062745,0.066667,0.062745,0.062745,0.066667,0.066667,0.062745,0.058824,0.066667,0.054902,0.05098,0.05098,0.031373,0.027451,0.082353,0.211765,0.27451,0.537255,0.780392,0.929412,0.956863,0.909804,0.827451,0.541176,0.25098,0.117647,0.054902,0.031373,0.035294,0.039216,0.047059,0.05098,0.062745,0.062745,0.058824,0.066667,0.070588,0.070588,0.070588,0.066667,0.054902,0.054902,0.054902,0.058824,0.058824,0.027451,0.035294,0.203922,0.576471,0.780392,0.831373,0.956863,0.972549,0.933333,0.878431,0.678431,0.505882,0.14902,0.058824,0.031373,0.035294,0.039216,0.039216,0.05098,0.062745,0.062745,0.062745,0.070588,0.078431,0.086275,0.078431,0.070588,0.058824,0.058824,0.054902,0.066667,0.113725,0.066667,0.07451,0.086275,0.282353,0.666667,0.858824,0.92549,0.945098,0.937255,0.745098,0.545098,0.203922,0.113725,0.031373,0.031373,0.027451,0.027451,0.031373,0.039216,0.043137,0.054902,0.062745,0.058824,0.070588,0.086275,0.094118,0.086275,0.082353,0.058824,0.062745,0.094118,0.121569,0.172549,0.156863,0.117647,0.176471,0.403922,0.611765,0.780392,0.909804,0.862745,0.85098,0.65098,0.286275,0.101961,0.043137,0.031373,0.023529,0.035294,0.043137,0.05098,0.05098,0.054902,0.066667,0.066667,0.070588,0.07451,0.094118,0.121569,0.109804,0.090196,0.117647,0.133333,0.192157,0.258824,0.282353,0.258824,0.231373,0.286275,0.517647,0.803922,0.92549,0.945098,0.929412,0.803922,0.423529,0.145098,0.027451,0.023529,0.031373,0.043137,0.05098,0.054902,0.058824,0.066667,0.066667,0.062745,0.062745,0.070588,0.082353,0.121569,0.176471,0.133333,0.192157,0.219608,0.270588,0.32549,0.352941,0.32549,0.356863,0.435294,0.682353,0.847059,0.941176,0.92549,0.901961,0.647059,0.14902,0.066667,0.027451,0.031373,0.039216,0.031373,0.043137,0.047059,0.058824,0.058824,0.062745,0.062745,0.058824,0.070588,0.082353,0.098039,0.160784,0.235294,0.223529,0.290196,0.329412,0.345098,0.329412,0.352941,0.458824,0.568627,0.733333,0.87451,0.901961,0.882353,0.858824,0.741176,0.607843,0.384314,0.164706,0.066667,0.054902,0.043137,0.047059,0.070588,0.062745,0.070588,0.062745,0.062745,0.054902,0.07451,0.094118,0.14902,0.207843,0.231373,0.266667,0.301961,0.286275,0.294118,0.270588,0.262745,0.447059,0.709804,0.792157,0.839216,0.85098,0.819608,0.819608,0.776471,0.741176,0.572549,0.258824,0.121569,0.101961,0.086275,0.105882,0.109804,0.078431,0.07451,0.066667,0.058824,0.058824,0.062745,0.090196,0.129412,0.180392,0.231373,0.254902,0.262745,0.243137,0.184314,0.164706,0.266667,0.443137,0.654902,0.768627,0.788235,0.796078,0.741176,0.772549,0.709804,0.701961,0.545098,0.298039,0.298039,0.290196,0.215686,0.152941,0.101961,0.098039,0.086275,0.066667,0.066667,0.054902,0.062745,0.078431,0.078431,0.145098,0.203922,0.207843,0.121569,0.14902,0.121569,0.082353,0.188235,0.411765,0.580392,0.698039,0.729412,0.701961,0.690196,0.690196,0.67451,0.631373,0.576471,0.486275,0.462745,0.396078,0.235294,0.152941,0.152941,0.113725,0.070588,0.070588,0.062745,0.05098,0.058824,0.066667,0.094118,0.101961,0.137255,0.152941,0.137255,0.086275,0.078431,0.094118,0.141176,0.341176,0.529412,0.611765,0.619608,0.662745,0.654902,0.584314,0.6,0.596078,0.529412,0.470588,0.462745,0.396078,0.270588,0.282353,0.211765,0.137255,0.078431,0.058824,0.062745,0.05098,0.05098,0.066667,0.070588,0.078431,0.07451,0.101961,0.082353,0.066667,0.062745,0.070588,0.156863,0.278431,0.329412,0.505882,0.568627,0.576471,0.576471,0.545098,0.545098,0.513726,0.501961,0.466667,0.407843,0.360784,0.282353,0.227451,0.129412,0.098039,0.066667,0.066667,0.05098,0.047059,0.043137,0.054902,0.054902,0.062745,0.066667,0.070588,0.062745,0.058824,0.058824,0.066667,0.101961,0.152941,0.301961,0.388235,0.501961,0.368627,0.376471,0.47451,0.439216,0.439216,0.443137,0.380392,0.368627,0.32549,0.239216,0.164706,0.098039,0.058824,0.058824,0.05098,0.054902,0.043137,0.05098,0.058824,0.058824,0.058824,0.066667,0.070588,0.066667,0.062745,0.062745,0.078431,0.101961,0.156863,0.262745,0.305882,0.321569,0.192157,0.258824,0.270588,0.243137,0.376471,0.380392,0.341176,0.266667,0.227451,0.203922,0.121569,0.094118,0.062745,0.05098,0.05098,0.035294,0.035294,0.047059,0.05098,0.058824,0.058824,0.062745,0.062745,0.066667,0.066667,0.062745,0.07451,0.098039,0.133333,0.129412,0.192157,0.192157,0.172549,0.090196,0.098039,0.223529,0.290196,0.266667,0.27451,0.2,0.133333,0.117647,0.105882,0.066667,0.054902,0.047059,0.047059,0.047059,0.023529,0.043137,0.043137,0.047059,0.054902,0.058824,0.058824,0.054902,0.062745,0.066667,0.070588,0.082353,0.086275,0.070588,0.121569,0.160784,0.098039,0.066667,0.113725,0.164706,0.184314,0.14902,0.117647,0.113725,0.090196,0.054902,0.082353,0.062745,0.043137,0.047059,0.043137,0.035294,0.035294,0.035294,0.043137,0.043137,0.05098,0.05098,0.054902,0.062745,0.062745,0.062745,0.066667,0.062745,0.054902,0.078431,0.082353,0.090196,0.098039,0.054902,0.07451,0.098039,0.098039,0.086275,0.078431,0.066667,0.062745,0.047059,0.062745,0.062745,0.054902,0.047059,0.039216,0.031373,0.023529,0.031373,0.031373,0.043137,0.047059,0.05098,0.054902,0.062745,0.058824,0.062745,0.058824,0.062745,0.058824,0.066667,0.066667,0.062745,0.078431,0.062745,0.066667,0.078431,0.078431,0.062745,0.062745,0.062745,0.05098,0.043137,0.054902,0.05098,0.047059,0.039216,0.039216,0.031373],xDimension=32,xSpacing=0.08,zDimension=32,zSpacing=0.08))])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for Mountain32.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python Mountain32.py load and self-test diagnostics complete.")
