package Vrml2Sourcebook.Siggraph98Course;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> High-resolution mountain. </p>
 <p> Related links: Catalog page <a href="../../../Siggraph98Course/Mountain128Index.html" target="_blank">Mountain128</a>,  source <a href="../../../Siggraph98Course/Mountain128.java">Mountain128.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Siggraph98Course/Mountain128.x3d">Mountain128.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> High-resolution mountain. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> John L. Moreland </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 1 July 1998 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 2 February 2014 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> originals/mount128.wrl </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.siggraph.org/s98" target="_blank">http://www.siggraph.org/s98</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.siggraph.org/s98/conference/courses/18.html" target="_blank">http://www.siggraph.org/s98/conference/courses/18.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0201.htm" target="_blank">http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0201.htm</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm" target="_blank">http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">https://www.web3d.org/x3d/content/examples/X3dResources.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Mountain128.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Mountain128.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Siggraph98Course/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author John L. Moreland
 */

public class Mountain128
{
	/** Default constructor to create this object. */
	public Mountain128 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERACTIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("Mountain128.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("High-resolution mountain."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("John L. Moreland"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("1 July 1998"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("2 February 2014"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("originals/mount128.wrl"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.siggraph.org/s98"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.siggraph.org/s98/conference/courses/18.html"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0201.htm"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/x3d/content/examples/X3dResources.html"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Mountain128.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setInfo(new String[] {"copyright (c) 1997, John L. Moreland"}).setTitle("High-res Mountain"))
    .addChild(new Viewpoint().setDescription("Entry view").setOrientation(1.0,0.0,0.0,-0.2).setPosition(1.2,0.9,4.0))
    .addChild(new NavigationInfo())
    .addChild(new Shape()
      .setAppearance(new Appearance()
        .setMaterial(new Material()))
      .setGeometry(new ElevationGrid().setXDimension(128).setXSpacing(0.02).setZDimension(128).setZSpacing(0.02).setHeight(getElevationGrid_4_24_height()))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getElevationGrid_4_24_height_1()
		{
			double[] value = {0.019608,0.015686,0.019608,0.023529,0.027451,0.031373,0.031373,0.031373,0.031373,0.027451,0.035294,0.035294,0.035294,0.031373,0.031373,0.039216,0.043137,0.043137,0.039216,0.043137,0.043137,0.043137,0.047059,0.05098,0.05098,0.05098,0.047059,0.047059,0.047059,0.05098,0.05098,0.054902,0.054902,0.058824,0.066667,0.062745,0.054902,0.05098,0.054902,0.054902,0.054902,0.058824,0.062745,0.058824,0.054902,0.058824,0.062745,0.066667,0.066667,0.066667,0.058824,0.062745,0.062745,0.058824,0.058824,0.062745,0.062745,0.062745,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.066667,0.062745,0.062745,0.062745,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.058824,0.054902,0.054902,0.058824,0.062745,0.058824,0.054902,0.05098,0.054902,0.054902,0.054902,0.05098,0.054902,0.058824,0.058824,0.054902,0.047059,0.047059,0.047059,0.05098,0.05098,0.05098,0.047059,0.047059,0.047059,0.043137,0.043137,0.043137,0.039216,0.039216,0.035294,0.035294,0.035294,0.035294,0.031373,0.027451,0.031373,0.035294,0.031373,0.031373,0.031373,0.031373,0.023529,0.019608,0.019608,0.019608,0.015686,0.015686,0.019608,0.019608,0.015686,0.019608,0.027451,0.031373,0.031373,0.035294,0.035294,0.031373,0.035294,0.039216,0.039216,0.035294,0.035294,0.039216,0.043137,0.043137,0.039216,0.047059,0.047059,0.047059,0.047059,0.05098,0.054902,0.054902,0.05098,0.047059,0.047059,0.05098,0.05098,0.054902,0.058824,0.062745,0.066667,0.062745,0.054902,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.062745,0.066667,0.066667,0.066667,0.066667,0.062745,0.066667,0.062745,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.066667,0.066667,0.062745,0.054902,0.058824,0.062745,0.062745,0.062745,0.058824,0.058824,0.058824,0.058824,0.054902,0.054902,0.058824,0.058824,0.058824,0.058824,0.054902,0.047059,0.05098,0.054902,0.054902,0.054902,0.05098,0.05098,0.047059,0.039216,0.039216,0.039216,0.039216,0.039216,0.043137,0.039216,0.039216,0.035294,0.027451,0.027451,0.035294,0.035294,0.031373,0.031373,0.027451,0.027451,0.023529,0.023529,0.023529,0.023529,0.019608,0.019608,0.019608,0.023529,0.023529,0.019608,0.023529,0.031373,0.031373,0.035294,0.039216,0.035294,0.035294,0.039216,0.039216,0.035294,0.039216,0.043137,0.043137,0.043137,0.043137,0.047059,0.047059,0.047059,0.047059,0.05098,0.054902,0.054902,0.054902,0.05098,0.047059,0.05098,0.054902,0.054902,0.058824,0.066667,0.066667,0.058824,0.054902,0.058824,0.062745,0.062745,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.066667,0.066667,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.058824,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.058824,0.058824,0.062745,0.062745,0.062745,0.058824,0.05098,0.054902,0.054902,0.058824,0.058824,0.058824,0.054902,0.047059,0.039216,0.039216,0.043137,0.039216,0.043137,0.047059,0.043137,0.039216,0.035294,0.031373,0.031373,0.035294,0.035294,0.035294,0.027451,0.023529,0.019608,0.023529,0.027451,0.027451,0.023529,0.019608,0.023529,0.019608,0.027451,0.031373,0.027451,0.027451,0.031373,0.031373,0.035294,0.039216,0.039216,0.035294,0.039216,0.039216,0.035294,0.043137,0.047059,0.047059,0.043137,0.043137,0.043137,0.047059,0.05098,0.047059,0.05098,0.054902,0.054902,0.058824,0.054902,0.047059,0.05098,0.054902,0.054902,0.062745,0.066667,0.062745,0.054902,0.054902,0.062745,0.066667,0.066667,0.062745,0.062745,0.062745,0.058824,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.070588,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.058824,0.062745,0.062745,0.062745,0.062745,0.066667,0.070588,0.066667,0.066667,0.066667,0.066667,0.070588,0.070588,0.070588,0.070588,0.070588,0.066667,0.062745,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.054902,0.054902,0.058824,0.062745,0.062745,0.058824,0.047059,0.043137,0.047059,0.047059,0.043137,0.047059,0.047059,0.039216,0.035294,0.039216,0.039216,0.035294,0.035294,0.035294,0.031373,0.027451,0.023529,0.019608,0.023529,0.027451,0.027451,0.023529,0.019608,0.023529,0.019608,0.027451,0.031373,0.031373,0.027451,0.027451,0.031373,0.035294,0.039216,0.039216,0.035294,0.039216,0.039216,0.035294,0.039216,0.047059,0.047059,0.047059,0.047059,0.047059,0.047059,0.05098,0.05098,0.05098,0.05098,0.054902,0.058824,0.054902,0.047059,0.05098,0.054902,0.054902,0.058824,0.062745,0.058824,0.054902,0.058824,0.062745,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.070588,0.070588,0.070588,0.066667,0.066667,0.066667,0.066667,0.062745,0.066667,0.070588,0.070588,0.070588,0.070588,0.070588,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.066667,0.062745,0.066667,0.070588,0.07451,0.07451,0.07451,0.07451,0.070588,0.07451,0.07451,0.07451,0.078431,0.07451,0.062745,0.062745,0.07451,0.07451,0.070588,0.070588,0.062745,0.062745,0.058824,0.058824,0.062745,0.066667,0.066667,0.062745,0.054902,0.047059,0.05098,0.05098,0.047059,0.05098,0.043137,0.039216,0.043137,0.043137,0.043137,0.039216,0.039216,0.035294,0.031373,0.031373,0.031373,0.027451,0.027451,0.027451,0.027451,0.023529,0.023529,0.027451,0.023529,0.027451,0.031373,0.031373,0.027451,0.027451,0.031373,0.035294,0.039216,0.039216,0.039216,0.043137,0.039216,0.031373,0.039216,0.047059,0.05098,0.05098,0.05098,0.05098,0.047059,0.054902,0.054902,0.054902,0.05098,0.05098,0.054902,0.054902,0.047059,0.05098,0.054902,0.054902,0.054902,0.062745,0.058824,0.058824,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.062745,0.066667,0.066667,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.066667,0.062745,0.066667,0.070588,0.070588,0.070588,0.070588,0.070588,0.066667,0.070588,0.070588,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.066667,0.066667,0.066667,0.070588,0.07451,0.078431,0.078431,0.078431,0.078431,0.07451,0.082353,0.086275,0.086275,0.086275,0.078431,0.066667,0.066667,0.082353,0.086275,0.078431,0.070588,0.062745,0.066667,0.066667,0.062745,0.066667,0.070588,0.066667,0.066667,0.058824,0.05098,0.054902,0.054902,0.054902,0.047059,0.043137,0.047059,0.047059,0.047059,0.047059,0.047059,0.039216,0.031373,0.035294,0.039216,0.035294,0.035294,0.031373,0.027451,0.031373,0.027451,0.023529,0.027451,0.027451,0.023529,0.027451,0.031373,0.031373,0.031373,0.031373,0.031373,0.035294,0.043137,0.043137,0.047059,0.043137,0.035294,0.039216,0.047059,0.054902,0.054902,0.054902,0.054902,0.05098,0.054902,0.058824,0.054902,0.05098,0.054902,0.058824,0.054902,0.047059,0.047059,0.054902,0.054902,0.058824,0.062745,0.062745,0.058824,0.062745,0.066667,0.066667,0.066667,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.066667,0.070588,0.070588,0.070588,0.070588,0.066667,0.070588,0.070588,0.070588,0.070588,0.066667,0.066667,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.070588,0.07451,0.078431,0.082353,0.086275,0.090196,0.090196,0.086275,0.082353,0.090196,0.101961,0.101961,0.098039,0.082353,0.07451,0.078431,0.086275,0.090196,0.082353,0.070588,0.062745,0.07451,0.07451,0.070588,0.07451,0.078431,0.07451,0.07451,0.062745,0.054902,0.058824,0.058824,0.054902,0.05098,0.054902,0.058824,0.054902,0.054902,0.05098,0.043137,0.035294,0.035294,0.039216,0.043137,0.039216,0.039216,0.035294,0.031373,0.031373,0.031373,0.027451,0.027451,0.031373,0.031373,0.027451,0.031373,0.035294,0.035294,0.039216,0.035294,0.035294,0.039216,0.047059,0.047059,0.047059,0.043137,0.039216,0.043137,0.047059,0.05098,0.054902,0.054902,0.054902,0.054902,0.054902,0.05098,0.05098,0.054902,0.062745,0.058824,0.047059,0.05098,0.054902,0.054902,0.058824,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.066667,0.066667,0.070588,0.07451,0.07451,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.066667,0.070588,0.070588,0.070588,0.066667,0.066667,0.070588,0.070588,0.070588,0.070588,0.066667,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.07451,0.078431,0.086275,0.090196,0.094118,0.101961,0.109804,0.101961,0.094118,0.101961,0.117647,0.12549,0.109804,0.094118,0.098039,0.101961,0.094118,0.086275,0.086275,0.078431,0.070588,0.082353,0.090196,0.082353,0.086275,0.090196,0.082353,0.078431};
			return value;
		}
		private double[] getElevationGrid_4_24_height_2()
		{
			double[] value = {0.070588,0.062745,0.062745,0.058824,0.054902,0.062745,0.066667,0.066667,0.062745,0.058824,0.05098,0.043137,0.039216,0.039216,0.043137,0.043137,0.039216,0.039216,0.035294,0.031373,0.035294,0.031373,0.027451,0.027451,0.035294,0.035294,0.031373,0.035294,0.039216,0.039216,0.043137,0.039216,0.035294,0.035294,0.043137,0.047059,0.05098,0.047059,0.039216,0.039216,0.039216,0.039216,0.047059,0.054902,0.058824,0.058824,0.054902,0.054902,0.054902,0.058824,0.062745,0.058824,0.05098,0.054902,0.058824,0.058824,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.070588,0.070588,0.07451,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.066667,0.066667,0.070588,0.070588,0.066667,0.066667,0.066667,0.066667,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.07451,0.078431,0.086275,0.090196,0.098039,0.113725,0.12549,0.12549,0.121569,0.121569,0.133333,0.145098,0.129412,0.105882,0.113725,0.12549,0.113725,0.101961,0.101961,0.094118,0.086275,0.098039,0.101961,0.098039,0.101961,0.101961,0.094118,0.086275,0.078431,0.07451,0.062745,0.054902,0.066667,0.078431,0.078431,0.07451,0.066667,0.058824,0.05098,0.047059,0.047059,0.043137,0.043137,0.043137,0.043137,0.039216,0.035294,0.035294,0.035294,0.035294,0.031373,0.031373,0.035294,0.039216,0.039216,0.039216,0.043137,0.043137,0.043137,0.043137,0.043137,0.039216,0.039216,0.043137,0.05098,0.05098,0.047059,0.043137,0.043137,0.039216,0.039216,0.05098,0.058824,0.058824,0.054902,0.054902,0.058824,0.058824,0.062745,0.058824,0.054902,0.054902,0.058824,0.062745,0.062745,0.066667,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.070588,0.070588,0.066667,0.066667,0.066667,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.066667,0.070588,0.070588,0.070588,0.070588,0.07451,0.070588,0.062745,0.066667,0.070588,0.070588,0.066667,0.066667,0.066667,0.066667,0.070588,0.070588,0.066667,0.066667,0.070588,0.07451,0.07451,0.07451,0.078431,0.082353,0.086275,0.094118,0.109804,0.133333,0.14902,0.152941,0.14902,0.14902,0.160784,0.152941,0.121569,0.12549,0.14902,0.141176,0.12549,0.121569,0.121569,0.121569,0.12549,0.121569,0.121569,0.121569,0.113725,0.094118,0.090196,0.090196,0.078431,0.062745,0.062745,0.078431,0.090196,0.082353,0.078431,0.066667,0.058824,0.054902,0.05098,0.047059,0.047059,0.047059,0.043137,0.039216,0.039216,0.039216,0.039216,0.035294,0.035294,0.035294,0.031373,0.039216,0.039216,0.039216,0.039216,0.043137,0.043137,0.043137,0.043137,0.047059,0.047059,0.043137,0.043137,0.047059,0.05098,0.05098,0.05098,0.047059,0.047059,0.043137,0.05098,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.062745,0.058824,0.058824,0.058824,0.062745,0.066667,0.066667,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.066667,0.070588,0.070588,0.066667,0.062745,0.062745,0.066667,0.066667,0.066667,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.07451,0.07451,0.066667,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.066667,0.070588,0.070588,0.066667,0.066667,0.070588,0.07451,0.078431,0.082353,0.086275,0.090196,0.098039,0.105882,0.117647,0.145098,0.168627,0.176471,0.176471,0.176471,0.180392,0.176471,0.152941,0.152941,0.180392,0.176471,0.14902,0.14902,0.152941,0.152941,0.14902,0.145098,0.14902,0.137255,0.113725,0.098039,0.094118,0.090196,0.082353,0.078431,0.082353,0.090196,0.094118,0.082353,0.07451,0.066667,0.058824,0.054902,0.05098,0.05098,0.047059,0.047059,0.043137,0.039216,0.039216,0.039216,0.039216,0.039216,0.039216,0.039216,0.031373,0.035294,0.035294,0.039216,0.043137,0.043137,0.043137,0.043137,0.047059,0.047059,0.047059,0.047059,0.043137,0.047059,0.05098,0.05098,0.054902,0.054902,0.05098,0.05098,0.054902,0.062745,0.062745,0.058824,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.062745,0.058824,0.062745,0.066667,0.066667,0.062745,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.058824,0.062745,0.070588,0.070588,0.066667,0.062745,0.062745,0.062745,0.062745,0.066667,0.070588,0.07451,0.070588,0.070588,0.070588,0.070588,0.070588,0.07451,0.070588,0.066667,0.058824,0.062745,0.066667,0.062745,0.062745,0.062745,0.066667,0.070588,0.070588,0.070588,0.066667,0.070588,0.07451,0.07451,0.078431,0.086275,0.090196,0.098039,0.105882,0.113725,0.133333,0.156863,0.172549,0.180392,0.188235,0.203922,0.207843,0.203922,0.192157,0.184314,0.2,0.196078,0.168627,0.172549,0.180392,0.176471,0.172549,0.168627,0.164706,0.141176,0.121569,0.117647,0.109804,0.098039,0.098039,0.101961,0.105882,0.101961,0.090196,0.078431,0.070588,0.062745,0.058824,0.054902,0.054902,0.05098,0.05098,0.047059,0.043137,0.043137,0.043137,0.039216,0.039216,0.035294,0.035294,0.035294,0.031373,0.031373,0.035294,0.035294,0.039216,0.043137,0.047059,0.047059,0.047059,0.047059,0.043137,0.047059,0.047059,0.05098,0.05098,0.054902,0.058824,0.058824,0.058824,0.054902,0.058824,0.066667,0.062745,0.058824,0.062745,0.066667,0.066667,0.062745,0.062745,0.062745,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.058824,0.058824,0.062745,0.066667,0.070588,0.066667,0.062745,0.062745,0.058824,0.062745,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.062745,0.058824,0.058824,0.062745,0.062745,0.062745,0.062745,0.066667,0.070588,0.07451,0.066667,0.066667,0.070588,0.07451,0.078431,0.078431,0.082353,0.086275,0.090196,0.098039,0.113725,0.129412,0.14902,0.160784,0.160784,0.176471,0.207843,0.231373,0.227451,0.219608,0.211765,0.211765,0.196078,0.180392,0.192157,0.2,0.196078,0.196078,0.184314,0.164706,0.145098,0.141176,0.145098,0.133333,0.12549,0.12549,0.129412,0.121569,0.105882,0.094118,0.082353,0.070588,0.062745,0.058824,0.054902,0.054902,0.05098,0.05098,0.047059,0.047059,0.047059,0.043137,0.039216,0.035294,0.031373,0.031373,0.031373,0.031373,0.035294,0.039216,0.039216,0.039216,0.043137,0.047059,0.047059,0.047059,0.047059,0.047059,0.047059,0.05098,0.05098,0.054902,0.054902,0.058824,0.062745,0.062745,0.062745,0.066667,0.066667,0.062745,0.058824,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.062745,0.070588,0.070588,0.066667,0.062745,0.066667,0.070588,0.066667,0.070588,0.066667,0.062745,0.058824,0.058824,0.058824,0.062745,0.058824,0.062745,0.066667,0.070588,0.070588,0.070588,0.066667,0.062745,0.066667,0.070588,0.078431,0.082353,0.086275,0.090196,0.094118,0.109804,0.12549,0.129412,0.137255,0.145098,0.14902,0.164706,0.203922,0.235294,0.247059,0.25098,0.243137,0.227451,0.203922,0.2,0.211765,0.211765,0.211765,0.207843,0.184314,0.164706,0.164706,0.168627,0.160784,0.152941,0.152941,0.152941,0.14902,0.129412,0.113725,0.098039,0.090196,0.07451,0.062745,0.058824,0.054902,0.05098,0.05098,0.05098,0.05098,0.05098,0.047059,0.043137,0.043137,0.039216,0.039216,0.039216,0.039216,0.035294,0.035294,0.039216,0.043137,0.039216,0.039216,0.043137,0.047059,0.05098,0.05098,0.047059,0.047059,0.047059,0.05098,0.054902,0.058824,0.058824,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.066667,0.066667,0.062745,0.066667,0.066667,0.062745,0.062745,0.066667,0.066667,0.070588,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.062745,0.066667,0.062745,0.058824,0.062745,0.066667,0.070588,0.062745,0.058824,0.062745,0.066667,0.066667,0.066667,0.062745,0.054902,0.054902,0.058824,0.058824,0.058824,0.058824,0.062745,0.066667,0.070588,0.070588,0.066667,0.062745,0.062745,0.066667,0.070588,0.078431,0.082353,0.086275,0.094118,0.101961,0.117647,0.137255,0.14902,0.152941,0.160784,0.176471,0.196078,0.215686,0.239216,0.258824,0.270588,0.266667,0.247059,0.231373,0.235294,0.231373,0.223529,0.219608,0.207843,0.188235,0.188235,0.192157,0.184314,0.176471,0.172549,0.172549,0.172549,0.164706,0.145098,0.121569,0.101961,0.090196,0.07451,0.066667,0.058824,0.054902,0.054902,0.054902,0.054902,0.05098,0.05098,0.047059,0.047059,0.047059,0.047059,0.043137,0.039216,0.035294,0.031373,0.035294,0.035294,0.039216,0.043137,0.043137,0.043137,0.043137,0.05098,0.05098,0.05098,0.047059,0.047059,0.047059,0.05098,0.054902,0.058824,0.058824,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.070588,0.070588,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.066667,0.070588,0.070588,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.062745,0.054902,0.054902,0.058824,0.058824,0.058824,0.062745,0.066667,0.062745,0.058824,0.058824,0.062745,0.062745,0.062745,0.058824,0.05098,0.054902,0.058824,0.054902,0.054902,0.058824,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.066667,0.070588,0.070588,0.07451,0.07451,0.078431,0.086275,0.094118,0.109804};
			return value;
		}
		private double[] getElevationGrid_4_24_height_3()
		{
			double[] value = {0.133333,0.164706,0.184314,0.196078,0.219608,0.243137,0.243137,0.243137,0.262745,0.278431,0.27451,0.258824,0.258824,0.258824,0.247059,0.231373,0.219608,0.207843,0.207843,0.211765,0.207843,0.2,0.192157,0.188235,0.180392,0.172549,0.164706,0.14902,0.129412,0.109804,0.090196,0.07451,0.066667,0.058824,0.058824,0.058824,0.058824,0.054902,0.054902,0.05098,0.05098,0.047059,0.047059,0.047059,0.043137,0.035294,0.027451,0.019608,0.039216,0.039216,0.043137,0.047059,0.047059,0.043137,0.043137,0.047059,0.05098,0.054902,0.05098,0.047059,0.047059,0.05098,0.054902,0.054902,0.058824,0.066667,0.066667,0.070588,0.070588,0.070588,0.070588,0.070588,0.07451,0.07451,0.070588,0.066667,0.066667,0.066667,0.062745,0.066667,0.066667,0.070588,0.070588,0.070588,0.066667,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.058824,0.05098,0.047059,0.047059,0.054902,0.058824,0.062745,0.066667,0.062745,0.058824,0.058824,0.058824,0.062745,0.062745,0.054902,0.05098,0.054902,0.058824,0.054902,0.054902,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.070588,0.070588,0.070588,0.082353,0.090196,0.101961,0.117647,0.145098,0.184314,0.211765,0.227451,0.247059,0.266667,0.270588,0.262745,0.27451,0.286275,0.282353,0.270588,0.270588,0.266667,0.25098,0.235294,0.227451,0.227451,0.231373,0.227451,0.219608,0.215686,0.207843,0.196078,0.168627,0.145098,0.141176,0.133333,0.121569,0.121569,0.105882,0.086275,0.07451,0.066667,0.062745,0.062745,0.058824,0.054902,0.054902,0.05098,0.05098,0.05098,0.047059,0.043137,0.043137,0.039216,0.031373,0.023529,0.043137,0.043137,0.047059,0.047059,0.047059,0.047059,0.043137,0.047059,0.05098,0.054902,0.054902,0.05098,0.05098,0.05098,0.054902,0.054902,0.062745,0.066667,0.066667,0.070588,0.07451,0.07451,0.070588,0.070588,0.07451,0.07451,0.070588,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.066667,0.070588,0.070588,0.066667,0.062745,0.062745,0.062745,0.062745,0.062745,0.058824,0.058824,0.058824,0.054902,0.05098,0.047059,0.054902,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.054902,0.058824,0.054902,0.047059,0.047059,0.054902,0.058824,0.054902,0.054902,0.054902,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.070588,0.082353,0.094118,0.109804,0.129412,0.160784,0.192157,0.215686,0.239216,0.254902,0.270588,0.27451,0.282353,0.290196,0.294118,0.290196,0.286275,0.282353,0.27451,0.258824,0.247059,0.25098,0.25098,0.243137,0.235294,0.231373,0.219608,0.207843,0.188235,0.14902,0.105882,0.094118,0.098039,0.098039,0.105882,0.105882,0.098039,0.086275,0.07451,0.066667,0.062745,0.058824,0.058824,0.054902,0.05098,0.05098,0.047059,0.047059,0.043137,0.043137,0.043137,0.035294,0.027451,0.047059,0.047059,0.047059,0.047059,0.047059,0.047059,0.05098,0.05098,0.05098,0.054902,0.054902,0.058824,0.058824,0.054902,0.054902,0.054902,0.058824,0.062745,0.066667,0.070588,0.07451,0.07451,0.070588,0.070588,0.070588,0.070588,0.07451,0.070588,0.070588,0.066667,0.066667,0.062745,0.058824,0.062745,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.058824,0.058824,0.058824,0.058824,0.054902,0.05098,0.05098,0.054902,0.054902,0.054902,0.058824,0.058824,0.058824,0.054902,0.054902,0.05098,0.047059,0.05098,0.054902,0.058824,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.058824,0.062745,0.058824,0.058824,0.062745,0.062745,0.066667,0.070588,0.07451,0.082353,0.094118,0.109804,0.137255,0.160784,0.188235,0.219608,0.239216,0.262745,0.282353,0.298039,0.305882,0.301961,0.301961,0.298039,0.294118,0.286275,0.27451,0.270588,0.270588,0.262745,0.254902,0.247059,0.239216,0.223529,0.203922,0.176471,0.141176,0.105882,0.090196,0.086275,0.082353,0.082353,0.086275,0.090196,0.086275,0.07451,0.066667,0.062745,0.058824,0.054902,0.054902,0.05098,0.05098,0.047059,0.043137,0.047059,0.047059,0.043137,0.031373,0.031373,0.047059,0.047059,0.05098,0.05098,0.05098,0.05098,0.05098,0.054902,0.054902,0.054902,0.058824,0.058824,0.062745,0.062745,0.058824,0.058824,0.058824,0.062745,0.066667,0.070588,0.07451,0.07451,0.07451,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.066667,0.066667,0.062745,0.058824,0.054902,0.058824,0.062745,0.062745,0.066667,0.066667,0.062745,0.058824,0.058824,0.058824,0.058824,0.054902,0.058824,0.058824,0.05098,0.047059,0.047059,0.05098,0.054902,0.054902,0.058824,0.058824,0.05098,0.047059,0.043137,0.047059,0.054902,0.058824,0.058824,0.058824,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.058824,0.054902,0.054902,0.054902,0.062745,0.070588,0.07451,0.07451,0.078431,0.090196,0.105882,0.117647,0.133333,0.176471,0.215686,0.235294,0.266667,0.294118,0.313726,0.321569,0.317647,0.313726,0.309804,0.301961,0.294118,0.294118,0.290196,0.282353,0.27451,0.266667,0.258824,0.247059,0.227451,0.207843,0.188235,0.172549,0.156863,0.137255,0.121569,0.105882,0.090196,0.07451,0.07451,0.078431,0.07451,0.062745,0.058824,0.054902,0.054902,0.05098,0.05098,0.05098,0.047059,0.047059,0.047059,0.047059,0.043137,0.035294,0.035294,0.047059,0.047059,0.05098,0.05098,0.05098,0.05098,0.05098,0.054902,0.054902,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.066667,0.062745,0.062745,0.066667,0.070588,0.07451,0.07451,0.07451,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.066667,0.062745,0.058824,0.058824,0.054902,0.054902,0.058824,0.062745,0.062745,0.062745,0.062745,0.058824,0.058824,0.054902,0.05098,0.054902,0.058824,0.054902,0.047059,0.043137,0.043137,0.05098,0.054902,0.054902,0.054902,0.05098,0.039216,0.043137,0.05098,0.054902,0.058824,0.058824,0.058824,0.058824,0.054902,0.054902,0.054902,0.054902,0.05098,0.054902,0.054902,0.054902,0.058824,0.062745,0.070588,0.082353,0.086275,0.090196,0.105882,0.121569,0.129412,0.145098,0.184314,0.231373,0.254902,0.278431,0.305882,0.32549,0.333333,0.329412,0.321569,0.317647,0.305882,0.305882,0.305882,0.298039,0.294118,0.290196,0.282353,0.270588,0.25098,0.231373,0.219608,0.219608,0.211765,0.196078,0.176471,0.152941,0.129412,0.109804,0.086275,0.070588,0.070588,0.070588,0.066667,0.062745,0.058824,0.058824,0.054902,0.05098,0.05098,0.05098,0.05098,0.047059,0.047059,0.047059,0.043137,0.043137,0.043137,0.047059,0.05098,0.054902,0.054902,0.054902,0.054902,0.05098,0.054902,0.054902,0.054902,0.058824,0.058824,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.070588,0.07451,0.078431,0.07451,0.07451,0.070588,0.070588,0.070588,0.070588,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.058824,0.054902,0.054902,0.054902,0.058824,0.062745,0.062745,0.058824,0.054902,0.05098,0.047059,0.054902,0.058824,0.05098,0.05098,0.047059,0.043137,0.047059,0.05098,0.054902,0.054902,0.047059,0.039216,0.043137,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.058824,0.062745,0.066667,0.082353,0.101961,0.113725,0.121569,0.141176,0.164706,0.180392,0.2,0.239216,0.278431,0.298039,0.313726,0.329412,0.337255,0.333333,0.32549,0.317647,0.313726,0.321569,0.313726,0.305882,0.305882,0.301961,0.290196,0.270588,0.25098,0.235294,0.223529,0.215686,0.203922,0.184314,0.164706,0.141176,0.117647,0.101961,0.082353,0.062745,0.058824,0.062745,0.066667,0.066667,0.062745,0.058824,0.054902,0.054902,0.054902,0.054902,0.05098,0.05098,0.05098,0.05098,0.047059,0.039216,0.039216,0.047059,0.05098,0.054902,0.054902,0.058824,0.058824,0.054902,0.05098,0.05098,0.054902,0.058824,0.062745,0.062745,0.062745,0.066667,0.070588,0.070588,0.066667,0.070588,0.07451,0.078431,0.078431,0.07451,0.070588,0.070588,0.070588,0.070588,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.058824,0.058824,0.054902,0.054902,0.058824,0.062745,0.062745,0.058824,0.054902,0.047059,0.043137,0.05098,0.054902,0.05098,0.05098,0.054902,0.047059,0.043137,0.047059,0.05098,0.05098,0.047059,0.039216,0.043137,0.054902,0.054902,0.047059,0.043137,0.043137,0.043137,0.047059,0.054902,0.058824,0.058824,0.054902,0.054902,0.054902,0.054902,0.058824,0.062745,0.066667,0.082353,0.105882,0.129412,0.145098,0.160784,0.188235,0.219608,0.235294,0.258824,0.290196,0.317647,0.329412,0.333333,0.341176,0.345098,0.337255,0.329412,0.329412,0.333333,0.32549,0.317647,0.313726,0.309804,0.290196,0.27451,0.262745,0.239216,0.211765,0.192157,0.176471,0.160784,0.141176,0.113725,0.090196,0.082353,0.07451,0.062745,0.058824,0.054902,0.058824,0.058824,0.058824,0.058824,0.054902,0.054902,0.054902,0.054902,0.054902,0.05098,0.05098,0.05098,0.043137,0.039216,0.035294,0.043137,0.047059,0.05098,0.05098,0.054902,0.058824,0.058824,0.054902,0.05098,0.05098,0.054902,0.058824,0.062745,0.066667,0.066667,0.070588,0.070588,0.070588,0.07451,0.078431,0.078431,0.078431,0.07451,0.07451,0.070588,0.070588,0.070588,0.066667,0.062745,0.062745,0.066667,0.066667,0.058824,0.058824,0.054902,0.054902,0.054902,0.054902,0.058824,0.058824,0.058824,0.058824,0.05098,0.043137,0.047059,0.05098,0.047059,0.05098,0.05098,0.05098,0.043137,0.039216,0.043137,0.047059,0.043137};
			return value;
		}
		private double[] getElevationGrid_4_24_height_4()
		{
			double[] value = {0.039216,0.043137,0.05098,0.047059,0.039216,0.039216,0.039216,0.039216,0.047059,0.054902,0.062745,0.062745,0.062745,0.058824,0.058824,0.058824,0.058824,0.062745,0.070588,0.082353,0.101961,0.133333,0.164706,0.184314,0.203922,0.235294,0.258824,0.27451,0.294118,0.32549,0.337255,0.341176,0.34902,0.352941,0.352941,0.34902,0.34902,0.34902,0.337255,0.329412,0.321569,0.309804,0.294118,0.290196,0.286275,0.262745,0.235294,0.215686,0.196078,0.176471,0.152941,0.117647,0.098039,0.094118,0.090196,0.078431,0.066667,0.058824,0.054902,0.054902,0.054902,0.058824,0.058824,0.058824,0.054902,0.054902,0.054902,0.054902,0.05098,0.047059,0.039216,0.035294,0.035294,0.039216,0.043137,0.047059,0.05098,0.05098,0.054902,0.058824,0.058824,0.054902,0.05098,0.05098,0.05098,0.058824,0.062745,0.066667,0.070588,0.070588,0.07451,0.078431,0.078431,0.082353,0.078431,0.078431,0.07451,0.070588,0.070588,0.070588,0.066667,0.062745,0.058824,0.062745,0.062745,0.062745,0.058824,0.054902,0.054902,0.054902,0.054902,0.058824,0.058824,0.054902,0.058824,0.054902,0.047059,0.043137,0.043137,0.043137,0.047059,0.047059,0.047059,0.043137,0.039216,0.039216,0.039216,0.039216,0.039216,0.043137,0.047059,0.035294,0.035294,0.043137,0.047059,0.05098,0.054902,0.058824,0.062745,0.066667,0.066667,0.062745,0.058824,0.058824,0.058824,0.062745,0.070588,0.078431,0.090196,0.113725,0.14902,0.188235,0.211765,0.227451,0.254902,0.282353,0.301961,0.32549,0.337255,0.34902,0.356863,0.360784,0.360784,0.364706,0.364706,0.360784,0.34902,0.337255,0.32549,0.313726,0.309804,0.309804,0.298039,0.282353,0.262745,0.247059,0.223529,0.196078,0.168627,0.145098,0.121569,0.109804,0.098039,0.086275,0.07451,0.066667,0.062745,0.058824,0.058824,0.062745,0.058824,0.054902,0.05098,0.05098,0.05098,0.05098,0.047059,0.043137,0.039216,0.039216,0.043137,0.043137,0.047059,0.05098,0.05098,0.05098,0.05098,0.054902,0.062745,0.062745,0.058824,0.054902,0.054902,0.058824,0.062745,0.066667,0.070588,0.07451,0.078431,0.078431,0.078431,0.082353,0.078431,0.078431,0.07451,0.070588,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.058824,0.062745,0.062745,0.058824,0.054902,0.05098,0.05098,0.054902,0.054902,0.05098,0.054902,0.054902,0.05098,0.043137,0.039216,0.043137,0.043137,0.047059,0.047059,0.043137,0.043137,0.039216,0.035294,0.039216,0.043137,0.047059,0.043137,0.035294,0.039216,0.05098,0.054902,0.058824,0.058824,0.062745,0.062745,0.070588,0.070588,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.070588,0.082353,0.101961,0.12549,0.160784,0.184314,0.203922,0.231373,0.266667,0.298039,0.32549,0.345098,0.356863,0.368627,0.368627,0.376471,0.380392,0.376471,0.368627,0.352941,0.341176,0.329412,0.321569,0.321569,0.321569,0.305882,0.290196,0.270588,0.239216,0.215686,0.196078,0.180392,0.156863,0.129412,0.105882,0.090196,0.082353,0.07451,0.070588,0.062745,0.062745,0.062745,0.062745,0.054902,0.047059,0.043137,0.043137,0.043137,0.043137,0.043137,0.039216,0.039216,0.043137,0.047059,0.05098,0.054902,0.054902,0.054902,0.054902,0.05098,0.054902,0.062745,0.066667,0.066667,0.062745,0.058824,0.058824,0.066667,0.066667,0.070588,0.07451,0.078431,0.078431,0.078431,0.082353,0.078431,0.078431,0.078431,0.07451,0.066667,0.062745,0.062745,0.062745,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.054902,0.05098,0.047059,0.05098,0.05098,0.047059,0.05098,0.05098,0.05098,0.047059,0.039216,0.039216,0.039216,0.043137,0.043137,0.043137,0.043137,0.039216,0.035294,0.043137,0.047059,0.047059,0.039216,0.035294,0.043137,0.054902,0.058824,0.062745,0.066667,0.070588,0.070588,0.078431,0.078431,0.070588,0.070588,0.07451,0.078431,0.082353,0.086275,0.098039,0.109804,0.12549,0.141176,0.152941,0.156863,0.168627,0.207843,0.247059,0.282353,0.313726,0.337255,0.356863,0.372549,0.384314,0.396078,0.392157,0.380392,0.372549,0.356863,0.345098,0.333333,0.333333,0.333333,0.329412,0.313726,0.301961,0.27451,0.239216,0.207843,0.188235,0.164706,0.141176,0.113725,0.090196,0.07451,0.070588,0.066667,0.062745,0.058824,0.058824,0.058824,0.058824,0.054902,0.047059,0.043137,0.047059,0.05098,0.047059,0.043137,0.039216,0.043137,0.047059,0.05098,0.05098,0.054902,0.058824,0.058824,0.058824,0.054902,0.054902,0.058824,0.066667,0.066667,0.066667,0.062745,0.062745,0.066667,0.066667,0.070588,0.07451,0.07451,0.078431,0.078431,0.082353,0.082353,0.082353,0.078431,0.07451,0.070588,0.062745,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.054902,0.054902,0.054902,0.05098,0.047059,0.043137,0.047059,0.047059,0.047059,0.05098,0.05098,0.047059,0.039216,0.039216,0.039216,0.039216,0.043137,0.043137,0.039216,0.035294,0.035294,0.043137,0.047059,0.043137,0.035294,0.035294,0.047059,0.054902,0.058824,0.066667,0.07451,0.07451,0.07451,0.086275,0.098039,0.090196,0.082353,0.078431,0.078431,0.094118,0.113725,0.133333,0.14902,0.160784,0.180392,0.192157,0.180392,0.184314,0.227451,0.270588,0.290196,0.309804,0.333333,0.34902,0.368627,0.396078,0.403922,0.392157,0.380392,0.372549,0.364706,0.352941,0.34902,0.345098,0.341176,0.329412,0.321569,0.309804,0.286275,0.258824,0.219608,0.176471,0.137255,0.113725,0.094118,0.07451,0.070588,0.070588,0.062745,0.058824,0.054902,0.05098,0.054902,0.054902,0.054902,0.05098,0.05098,0.054902,0.05098,0.047059,0.039216,0.043137,0.05098,0.05098,0.047059,0.047059,0.05098,0.054902,0.058824,0.062745,0.062745,0.058824,0.058824,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.070588,0.07451,0.07451,0.07451,0.078431,0.082353,0.082353,0.082353,0.078431,0.078431,0.070588,0.066667,0.062745,0.062745,0.058824,0.058824,0.058824,0.058824,0.054902,0.05098,0.05098,0.05098,0.043137,0.039216,0.039216,0.039216,0.043137,0.047059,0.047059,0.043137,0.039216,0.035294,0.039216,0.039216,0.039216,0.039216,0.039216,0.035294,0.035294,0.039216,0.043137,0.039216,0.039216,0.047059,0.05098,0.05098,0.058824,0.070588,0.082353,0.086275,0.082353,0.094118,0.117647,0.113725,0.094118,0.078431,0.07451,0.086275,0.109804,0.137255,0.152941,0.160784,0.184314,0.211765,0.219608,0.231373,0.270588,0.309804,0.32549,0.341176,0.356863,0.368627,0.384314,0.403922,0.396078,0.380392,0.372549,0.368627,0.368627,0.360784,0.356863,0.356863,0.345098,0.329412,0.317647,0.309804,0.301961,0.282353,0.247059,0.192157,0.152941,0.129412,0.105882,0.086275,0.082353,0.078431,0.066667,0.062745,0.058824,0.054902,0.054902,0.058824,0.058824,0.058824,0.054902,0.05098,0.043137,0.043137,0.043137,0.05098,0.05098,0.05098,0.043137,0.043137,0.043137,0.047059,0.054902,0.058824,0.062745,0.062745,0.058824,0.062745,0.062745,0.062745,0.066667,0.070588,0.070588,0.070588,0.070588,0.070588,0.07451,0.07451,0.078431,0.082353,0.082353,0.078431,0.078431,0.07451,0.07451,0.070588,0.066667,0.062745,0.062745,0.058824,0.058824,0.054902,0.05098,0.047059,0.047059,0.05098,0.047059,0.043137,0.035294,0.035294,0.043137,0.043137,0.043137,0.043137,0.039216,0.035294,0.035294,0.035294,0.035294,0.035294,0.035294,0.035294,0.035294,0.039216,0.039216,0.035294,0.043137,0.05098,0.05098,0.054902,0.058824,0.070588,0.082353,0.098039,0.101961,0.113725,0.137255,0.129412,0.101961,0.082353,0.078431,0.082353,0.090196,0.109804,0.121569,0.129412,0.14902,0.180392,0.211765,0.239216,0.27451,0.309804,0.329412,0.341176,0.352941,0.364706,0.388235,0.407843,0.388235,0.364706,0.364706,0.364706,0.360784,0.356863,0.360784,0.356863,0.341176,0.32549,0.313726,0.301961,0.305882,0.298039,0.266667,0.227451,0.192157,0.156863,0.121569,0.109804,0.101961,0.090196,0.078431,0.070588,0.062745,0.058824,0.058824,0.062745,0.062745,0.058824,0.054902,0.047059,0.047059,0.05098,0.054902,0.054902,0.05098,0.05098,0.05098,0.05098,0.047059,0.043137,0.047059,0.054902,0.058824,0.062745,0.066667,0.066667,0.066667,0.066667,0.070588,0.070588,0.070588,0.07451,0.07451,0.07451,0.07451,0.078431,0.082353,0.082353,0.082353,0.082353,0.078431,0.07451,0.07451,0.070588,0.066667,0.062745,0.062745,0.058824,0.058824,0.054902,0.05098,0.047059,0.047059,0.05098,0.05098,0.047059,0.039216,0.031373,0.039216,0.043137,0.043137,0.039216,0.039216,0.039216,0.031373,0.031373,0.035294,0.035294,0.031373,0.031373,0.031373,0.035294,0.035294,0.035294,0.039216,0.043137,0.043137,0.047059,0.058824,0.07451,0.086275,0.105882,0.121569,0.145098,0.164706,0.145098,0.109804,0.090196,0.086275,0.094118,0.098039,0.098039,0.101961,0.113725,0.137255,0.164706,0.192157,0.219608,0.258824,0.294118,0.305882,0.305882,0.317647,0.345098,0.380392,0.392157,0.368627,0.352941,0.352941,0.34902,0.345098,0.352941,0.364706,0.352941,0.333333,0.317647,0.301961,0.286275,0.290196,0.294118,0.286275,0.254902,0.215686,0.172549,0.137255,0.12549,0.113725,0.098039,0.086275,0.07451,0.062745,0.054902,0.05098,0.054902,0.054902,0.05098,0.05098,0.05098,0.054902,0.058824,0.058824,0.054902,0.05098,0.05098,0.054902,0.058824,0.05098,0.043137,0.047059,0.058824,0.062745,0.066667,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.07451,0.07451,0.078431,0.078431,0.082353,0.082353,0.082353,0.082353,0.082353,0.078431,0.070588,0.066667,0.062745,0.058824,0.058824,0.062745,0.058824};
			return value;
		}
		private double[] getElevationGrid_4_24_height_5()
		{
			double[] value = {0.058824,0.054902,0.054902,0.047059,0.043137,0.047059,0.047059,0.05098,0.047059,0.035294,0.035294,0.035294,0.039216,0.039216,0.039216,0.039216,0.031373,0.027451,0.031373,0.035294,0.031373,0.027451,0.031373,0.031373,0.031373,0.035294,0.035294,0.035294,0.043137,0.05098,0.058824,0.070588,0.090196,0.105882,0.133333,0.180392,0.2,0.172549,0.129412,0.105882,0.109804,0.117647,0.121569,0.117647,0.121569,0.137255,0.164706,0.192157,0.215686,0.231373,0.258824,0.282353,0.290196,0.290196,0.313726,0.352941,0.384314,0.372549,0.345098,0.341176,0.345098,0.333333,0.32549,0.341176,0.34902,0.341176,0.32549,0.301961,0.282353,0.266667,0.266667,0.27451,0.27451,0.258824,0.227451,0.188235,0.156863,0.129412,0.109804,0.094118,0.082353,0.07451,0.062745,0.047059,0.043137,0.047059,0.047059,0.05098,0.054902,0.058824,0.058824,0.058824,0.058824,0.054902,0.047059,0.043137,0.054902,0.054902,0.054902,0.047059,0.05098,0.058824,0.066667,0.070588,0.070588,0.070588,0.070588,0.066667,0.066667,0.066667,0.070588,0.07451,0.07451,0.07451,0.078431,0.082353,0.086275,0.082353,0.078431,0.078431,0.078431,0.070588,0.062745,0.058824,0.058824,0.058824,0.058824,0.058824,0.054902,0.054902,0.054902,0.047059,0.043137,0.043137,0.047059,0.047059,0.047059,0.043137,0.035294,0.031373,0.035294,0.035294,0.035294,0.035294,0.035294,0.031373,0.031373,0.031373,0.031373,0.027451,0.027451,0.027451,0.027451,0.031373,0.031373,0.035294,0.05098,0.066667,0.070588,0.070588,0.086275,0.117647,0.14902,0.2,0.235294,0.215686,0.168627,0.137255,0.129412,0.137255,0.141176,0.145098,0.160784,0.168627,0.180392,0.203922,0.231373,0.247059,0.258824,0.27451,0.286275,0.298039,0.32549,0.356863,0.372549,0.345098,0.317647,0.321569,0.329412,0.32549,0.313726,0.309804,0.321569,0.317647,0.294118,0.266667,0.254902,0.243137,0.243137,0.239216,0.231373,0.235294,0.231373,0.207843,0.172549,0.137255,0.109804,0.094118,0.082353,0.07451,0.062745,0.05098,0.05098,0.054902,0.054902,0.058824,0.058824,0.062745,0.062745,0.058824,0.058824,0.054902,0.047059,0.043137,0.05098,0.054902,0.054902,0.054902,0.054902,0.058824,0.062745,0.066667,0.066667,0.070588,0.070588,0.066667,0.070588,0.070588,0.070588,0.070588,0.07451,0.07451,0.082353,0.086275,0.086275,0.082353,0.082353,0.078431,0.07451,0.070588,0.070588,0.066667,0.066667,0.062745,0.054902,0.054902,0.054902,0.05098,0.05098,0.05098,0.043137,0.039216,0.039216,0.043137,0.043137,0.043137,0.035294,0.031373,0.027451,0.031373,0.031373,0.031373,0.031373,0.027451,0.027451,0.027451,0.027451,0.027451,0.027451,0.027451,0.027451,0.031373,0.035294,0.043137,0.058824,0.078431,0.090196,0.086275,0.086275,0.121569,0.168627,0.215686,0.258824,0.262745,0.223529,0.184314,0.152941,0.152941,0.160784,0.164706,0.192157,0.207843,0.207843,0.211765,0.223529,0.243137,0.262745,0.27451,0.286275,0.301961,0.321569,0.337255,0.341176,0.321569,0.298039,0.298039,0.305882,0.305882,0.286275,0.270588,0.278431,0.278431,0.243137,0.211765,0.203922,0.203922,0.207843,0.192157,0.188235,0.215686,0.223529,0.203922,0.176471,0.145098,0.117647,0.098039,0.086275,0.078431,0.066667,0.058824,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.058824,0.058824,0.05098,0.047059,0.05098,0.054902,0.054902,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.066667,0.070588,0.070588,0.070588,0.07451,0.07451,0.07451,0.07451,0.078431,0.078431,0.086275,0.086275,0.086275,0.086275,0.082353,0.078431,0.07451,0.070588,0.070588,0.070588,0.066667,0.062745,0.054902,0.047059,0.047059,0.047059,0.047059,0.047059,0.043137,0.039216,0.039216,0.039216,0.043137,0.039216,0.035294,0.031373,0.027451,0.027451,0.031373,0.031373,0.027451,0.027451,0.027451,0.027451,0.027451,0.027451,0.027451,0.027451,0.031373,0.039216,0.043137,0.05098,0.066667,0.086275,0.109804,0.117647,0.101961,0.113725,0.156863,0.203922,0.25098,0.294118,0.298039,0.254902,0.2,0.188235,0.188235,0.188235,0.215686,0.239216,0.239216,0.235294,0.231373,0.247059,0.266667,0.27451,0.282353,0.290196,0.290196,0.290196,0.298039,0.294118,0.27451,0.270588,0.270588,0.258824,0.239216,0.227451,0.231373,0.243137,0.223529,0.176471,0.14902,0.168627,0.172549,0.145098,0.164706,0.207843,0.203922,0.184314,0.172549,0.14902,0.121569,0.101961,0.086275,0.07451,0.066667,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.058824,0.058824,0.054902,0.047059,0.047059,0.054902,0.058824,0.054902,0.054902,0.058824,0.062745,0.062745,0.062745,0.066667,0.070588,0.07451,0.07451,0.07451,0.07451,0.078431,0.078431,0.078431,0.082353,0.082353,0.086275,0.086275,0.086275,0.086275,0.086275,0.082353,0.07451,0.070588,0.066667,0.066667,0.062745,0.058824,0.054902,0.047059,0.039216,0.035294,0.043137,0.043137,0.039216,0.039216,0.039216,0.035294,0.039216,0.035294,0.035294,0.031373,0.031373,0.027451,0.027451,0.031373,0.027451,0.027451,0.027451,0.027451,0.023529,0.027451,0.027451,0.027451,0.035294,0.043137,0.054902,0.066667,0.078431,0.098039,0.137255,0.156863,0.152941,0.133333,0.14902,0.180392,0.219608,0.298039,0.360784,0.317647,0.25098,0.235294,0.223529,0.207843,0.239216,0.258824,0.254902,0.25098,0.247059,0.25098,0.262745,0.266667,0.270588,0.270588,0.247059,0.235294,0.258824,0.266667,0.25098,0.231373,0.211765,0.188235,0.184314,0.192157,0.188235,0.207843,0.219608,0.176471,0.133333,0.145098,0.145098,0.117647,0.145098,0.192157,0.180392,0.156863,0.14902,0.145098,0.12549,0.101961,0.086275,0.07451,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.058824,0.054902,0.05098,0.047059,0.054902,0.058824,0.058824,0.058824,0.054902,0.058824,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.070588,0.07451,0.078431,0.078431,0.078431,0.082353,0.082353,0.086275,0.082353,0.082353,0.086275,0.086275,0.082353,0.082353,0.078431,0.07451,0.070588,0.066667,0.062745,0.058824,0.054902,0.047059,0.039216,0.031373,0.035294,0.039216,0.039216,0.035294,0.039216,0.035294,0.035294,0.031373,0.031373,0.031373,0.035294,0.031373,0.027451,0.027451,0.027451,0.027451,0.023529,0.027451,0.027451,0.027451,0.027451,0.031373,0.035294,0.047059,0.062745,0.090196,0.098039,0.109804,0.156863,0.192157,0.203922,0.207843,0.207843,0.219608,0.243137,0.309804,0.388235,0.360784,0.305882,0.294118,0.262745,0.235294,0.270588,0.290196,0.282353,0.270588,0.258824,0.247059,0.25098,0.254902,0.254902,0.243137,0.207843,0.207843,0.239216,0.239216,0.215686,0.192157,0.160784,0.133333,0.137255,0.160784,0.152941,0.168627,0.196078,0.176471,0.141176,0.121569,0.113725,0.105882,0.129412,0.160784,0.152941,0.129412,0.117647,0.12549,0.117647,0.105882,0.090196,0.078431,0.070588,0.066667,0.062745,0.058824,0.058824,0.058824,0.058824,0.058824,0.054902,0.05098,0.05098,0.054902,0.058824,0.054902,0.062745,0.058824,0.054902,0.054902,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.066667,0.07451,0.078431,0.078431,0.078431,0.078431,0.082353,0.086275,0.082353,0.082353,0.082353,0.086275,0.082353,0.078431,0.078431,0.078431,0.070588,0.066667,0.062745,0.058824,0.054902,0.05098,0.047059,0.039216,0.035294,0.035294,0.035294,0.035294,0.035294,0.035294,0.031373,0.031373,0.027451,0.027451,0.031373,0.031373,0.027451,0.027451,0.027451,0.027451,0.027451,0.027451,0.027451,0.027451,0.027451,0.031373,0.035294,0.047059,0.07451,0.105882,0.12549,0.129412,0.164706,0.227451,0.27451,0.301961,0.305882,0.301961,0.317647,0.364706,0.423529,0.411765,0.372549,0.345098,0.294118,0.262745,0.301961,0.329412,0.309804,0.286275,0.262745,0.239216,0.227451,0.231373,0.227451,0.207843,0.180392,0.196078,0.227451,0.215686,0.188235,0.164706,0.145098,0.113725,0.113725,0.133333,0.12549,0.129412,0.14902,0.152941,0.137255,0.101961,0.086275,0.105882,0.121569,0.133333,0.12549,0.105882,0.094118,0.094118,0.098039,0.094118,0.090196,0.086275,0.078431,0.07451,0.066667,0.062745,0.062745,0.062745,0.058824,0.054902,0.047059,0.047059,0.054902,0.058824,0.058824,0.058824,0.058824,0.062745,0.058824,0.054902,0.054902,0.054902,0.058824,0.062745,0.062745,0.066667,0.066667,0.07451,0.078431,0.082353,0.078431,0.078431,0.082353,0.082353,0.082353,0.078431,0.082353,0.082353,0.082353,0.078431,0.07451,0.07451,0.070588,0.066667,0.062745,0.058824,0.058824,0.054902,0.05098,0.043137,0.035294,0.027451,0.027451,0.031373,0.035294,0.031373,0.031373,0.027451,0.027451,0.027451,0.027451,0.027451,0.027451,0.023529,0.027451,0.027451,0.027451,0.027451,0.027451,0.027451,0.031373,0.035294,0.035294,0.05098,0.090196,0.137255,0.168627,0.184314,0.203922,0.278431,0.368627,0.392157,0.392157,0.388235,0.388235,0.443137,0.501961,0.486275,0.439216,0.384314,0.317647,0.294118,0.329412,0.337255,0.309804,0.286275,0.262745,0.227451,0.2,0.188235,0.196078,0.188235,0.160784,0.176471,0.203922,0.196078,0.168627,0.137255,0.117647,0.101961,0.101961,0.121569,0.105882,0.098039,0.113725,0.121569,0.121569,0.094118,0.07451,0.098039,0.109804,0.105882,0.101961,0.086275,0.078431,0.078431,0.078431,0.082353,0.082353,0.082353,0.082353,0.078431,0.07451,0.070588,0.066667,0.062745,0.058824,0.05098,0.047059,0.054902,0.062745,0.062745,0.062745,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.066667};
			return value;
		}
		private double[] getElevationGrid_4_24_height_6()
		{
			double[] value = {0.066667,0.070588,0.070588,0.070588,0.07451,0.082353,0.082353,0.078431,0.078431,0.086275,0.086275,0.082353,0.078431,0.078431,0.082353,0.078431,0.07451,0.066667,0.062745,0.058824,0.058824,0.054902,0.054902,0.05098,0.043137,0.039216,0.035294,0.027451,0.027451,0.027451,0.031373,0.027451,0.027451,0.027451,0.027451,0.027451,0.027451,0.027451,0.023529,0.023529,0.027451,0.027451,0.031373,0.031373,0.031373,0.031373,0.035294,0.039216,0.047059,0.062745,0.094118,0.160784,0.223529,0.258824,0.282353,0.337255,0.419608,0.462745,0.466667,0.462745,0.462745,0.517647,0.576471,0.54902,0.486275,0.415686,0.364706,0.364706,0.364706,0.333333,0.294118,0.270588,0.25098,0.215686,0.172549,0.14902,0.164706,0.168627,0.145098,0.145098,0.164706,0.168627,0.152941,0.117647,0.090196,0.078431,0.094118,0.113725,0.101961,0.082353,0.090196,0.098039,0.101961,0.086275,0.062745,0.078431,0.094118,0.086275,0.078431,0.07451,0.07451,0.07451,0.070588,0.066667,0.070588,0.07451,0.07451,0.07451,0.07451,0.066667,0.062745,0.058824,0.054902,0.05098,0.054902,0.058824,0.062745,0.062745,0.062745,0.058824,0.054902,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.070588,0.070588,0.070588,0.070588,0.078431,0.082353,0.078431,0.082353,0.086275,0.086275,0.082353,0.078431,0.070588,0.07451,0.07451,0.07451,0.066667,0.054902,0.047059,0.047059,0.047059,0.047059,0.043137,0.035294,0.031373,0.031373,0.027451,0.031373,0.031373,0.027451,0.027451,0.023529,0.027451,0.027451,0.027451,0.027451,0.027451,0.023529,0.027451,0.027451,0.027451,0.031373,0.035294,0.035294,0.039216,0.047059,0.05098,0.058824,0.086275,0.105882,0.152941,0.239216,0.321569,0.372549,0.411765,0.454902,0.505882,0.541176,0.537255,0.541176,0.592157,0.631373,0.596078,0.517647,0.458824,0.45098,0.443137,0.4,0.345098,0.298039,0.262745,0.239216,0.207843,0.156863,0.121569,0.129412,0.141176,0.117647,0.105882,0.121569,0.133333,0.133333,0.113725,0.086275,0.070588,0.086275,0.101961,0.094118,0.07451,0.07451,0.082353,0.086275,0.07451,0.054902,0.062745,0.078431,0.070588,0.062745,0.066667,0.070588,0.07451,0.062745,0.054902,0.058824,0.070588,0.070588,0.070588,0.070588,0.066667,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.058824,0.054902,0.054902,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.070588,0.070588,0.070588,0.070588,0.078431,0.082353,0.082353,0.082353,0.086275,0.086275,0.086275,0.078431,0.070588,0.066667,0.070588,0.070588,0.062745,0.054902,0.047059,0.043137,0.039216,0.039216,0.035294,0.035294,0.031373,0.031373,0.031373,0.035294,0.031373,0.027451,0.023529,0.023529,0.027451,0.027451,0.027451,0.027451,0.027451,0.027451,0.027451,0.031373,0.031373,0.031373,0.035294,0.039216,0.047059,0.062745,0.062745,0.066667,0.101961,0.145098,0.176471,0.235294,0.337255,0.443137,0.513726,0.537255,0.560784,0.603922,0.623529,0.627451,0.654902,0.670588,0.623529,0.560784,0.541176,0.533333,0.490196,0.423529,0.364706,0.309804,0.254902,0.211765,0.180392,0.145098,0.113725,0.105882,0.105882,0.090196,0.082353,0.094118,0.105882,0.113725,0.101961,0.082353,0.066667,0.07451,0.086275,0.082353,0.066667,0.070588,0.07451,0.07451,0.062745,0.05098,0.054902,0.066667,0.058824,0.05098,0.058824,0.062745,0.058824,0.047059,0.039216,0.05098,0.062745,0.066667,0.066667,0.066667,0.062745,0.058824,0.062745,0.062745,0.062745,0.066667,0.066667,0.062745,0.054902,0.05098,0.047059,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.070588,0.070588,0.070588,0.078431,0.082353,0.082353,0.082353,0.082353,0.086275,0.086275,0.082353,0.078431,0.070588,0.066667,0.066667,0.062745,0.058824,0.054902,0.047059,0.047059,0.043137,0.035294,0.031373,0.031373,0.031373,0.035294,0.035294,0.031373,0.027451,0.023529,0.023529,0.023529,0.027451,0.031373,0.027451,0.027451,0.027451,0.031373,0.035294,0.039216,0.035294,0.039216,0.047059,0.066667,0.090196,0.086275,0.07451,0.109804,0.176471,0.247059,0.294118,0.341176,0.447059,0.568627,0.627451,0.631373,0.658824,0.698039,0.705882,0.709804,0.701961,0.658824,0.631373,0.619608,0.580392,0.513726,0.443137,0.376471,0.301961,0.239216,0.192157,0.156863,0.145098,0.137255,0.121569,0.098039,0.078431,0.070588,0.07451,0.086275,0.094118,0.082353,0.066667,0.062745,0.066667,0.07451,0.070588,0.062745,0.062745,0.066667,0.066667,0.054902,0.047059,0.054902,0.066667,0.058824,0.05098,0.05098,0.047059,0.043137,0.043137,0.043137,0.05098,0.058824,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.054902,0.047059,0.054902,0.054902,0.054902,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.070588,0.070588,0.070588,0.07451,0.082353,0.086275,0.082353,0.078431,0.078431,0.086275,0.086275,0.082353,0.078431,0.070588,0.062745,0.062745,0.058824,0.054902,0.054902,0.05098,0.047059,0.043137,0.035294,0.035294,0.031373,0.031373,0.031373,0.027451,0.023529,0.023529,0.023529,0.023529,0.027451,0.031373,0.031373,0.027451,0.031373,0.031373,0.043137,0.054902,0.054902,0.054902,0.066667,0.090196,0.121569,0.121569,0.101961,0.133333,0.203922,0.286275,0.372549,0.415686,0.439216,0.52549,0.627451,0.682353,0.713726,0.741176,0.760784,0.760784,0.741176,0.709804,0.682353,0.643137,0.584314,0.509804,0.439216,0.364706,0.290196,0.239216,0.203922,0.176471,0.168627,0.160784,0.141176,0.113725,0.094118,0.07451,0.070588,0.078431,0.078431,0.066667,0.058824,0.058824,0.054902,0.058824,0.058824,0.054902,0.058824,0.062745,0.054902,0.047059,0.047059,0.054902,0.062745,0.058824,0.047059,0.043137,0.05098,0.054902,0.054902,0.054902,0.058824,0.062745,0.066667,0.066667,0.07451,0.070588,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.058824,0.05098,0.05098,0.054902,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.070588,0.070588,0.070588,0.07451,0.078431,0.082353,0.082353,0.078431,0.07451,0.07451,0.078431,0.078431,0.078431,0.07451,0.066667,0.058824,0.058824,0.058824,0.054902,0.05098,0.05098,0.047059,0.043137,0.039216,0.035294,0.031373,0.027451,0.027451,0.023529,0.023529,0.023529,0.023529,0.027451,0.031373,0.031373,0.035294,0.035294,0.035294,0.043137,0.062745,0.078431,0.086275,0.098039,0.121569,0.160784,0.160784,0.152941,0.211765,0.290196,0.34902,0.419608,0.494118,0.517647,0.509804,0.580392,0.701961,0.772549,0.784314,0.796078,0.796078,0.780392,0.756863,0.709804,0.647059,0.576471,0.501961,0.427451,0.356863,0.301961,0.262745,0.227451,0.207843,0.192157,0.164706,0.137255,0.117647,0.101961,0.082353,0.070588,0.070588,0.066667,0.058824,0.05098,0.05098,0.043137,0.043137,0.047059,0.054902,0.054902,0.05098,0.047059,0.05098,0.05098,0.054902,0.054902,0.05098,0.043137,0.047059,0.058824,0.062745,0.062745,0.062745,0.066667,0.066667,0.070588,0.070588,0.07451,0.070588,0.062745,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.058824,0.05098,0.058824,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.070588,0.070588,0.07451,0.07451,0.07451,0.078431,0.082353,0.082353,0.07451,0.070588,0.070588,0.070588,0.070588,0.07451,0.070588,0.062745,0.062745,0.062745,0.058824,0.05098,0.043137,0.039216,0.039216,0.039216,0.035294,0.031373,0.027451,0.023529,0.023529,0.023529,0.023529,0.023529,0.027451,0.031373,0.035294,0.039216,0.043137,0.043137,0.047059,0.058824,0.086275,0.12549,0.145098,0.172549,0.215686,0.219608,0.215686,0.305882,0.419608,0.490196,0.505882,0.545098,0.619608,0.603922,0.592157,0.713726,0.807843,0.823529,0.823529,0.815686,0.803922,0.780392,0.733333,0.662745,0.596078,0.533333,0.458824,0.388235,0.341176,0.290196,0.247059,0.231373,0.207843,0.172549,0.137255,0.109804,0.090196,0.078431,0.062745,0.054902,0.058824,0.054902,0.047059,0.039216,0.035294,0.035294,0.043137,0.05098,0.047059,0.043137,0.047059,0.05098,0.05098,0.05098,0.047059,0.043137,0.047059,0.054902,0.058824,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.070588,0.070588,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.054902,0.05098,0.058824,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.070588,0.070588,0.070588,0.070588,0.07451,0.07451,0.07451,0.082353,0.086275,0.082353,0.07451,0.066667,0.062745,0.062745,0.062745,0.066667,0.062745,0.058824,0.054902,0.05098,0.047059,0.039216,0.035294,0.031373,0.035294,0.035294,0.031373,0.027451,0.023529,0.023529,0.023529,0.023529,0.023529,0.023529,0.031373,0.035294,0.043137,0.05098,0.058824,0.066667,0.07451,0.094118,0.145098,0.203922,0.247059,0.298039,0.305882,0.298039,0.380392,0.505882,0.6,0.619608,0.627451,0.682353,0.67451,0.658824,0.752941,0.831373,0.847059,0.843137,0.827451,0.796078,0.764706,0.737255,0.682353,0.611765,0.560784,0.505882,0.45098,0.388235,0.321569,0.278431,0.247059,0.211765,0.176471,0.145098,0.109804,0.082353,0.066667,0.054902,0.043137,0.047059,0.047059,0.043137,0.031373,0.031373,0.039216,0.043137,0.043137,0.043137,0.043137,0.043137,0.043137,0.043137,0.043137,0.043137,0.047059,0.054902,0.054902,0.058824,0.058824,0.062745,0.062745};
			return value;
		}
		private double[] getElevationGrid_4_24_height_7()
		{
			double[] value = {0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.058824,0.054902,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.070588,0.070588,0.070588,0.066667,0.066667,0.070588,0.07451,0.07451,0.078431,0.086275,0.086275,0.078431,0.070588,0.070588,0.062745,0.054902,0.054902,0.05098,0.047059,0.039216,0.039216,0.039216,0.035294,0.031373,0.027451,0.031373,0.031373,0.027451,0.027451,0.023529,0.023529,0.023529,0.027451,0.027451,0.027451,0.031373,0.035294,0.047059,0.054902,0.07451,0.098039,0.117647,0.133333,0.160784,0.219608,0.27451,0.345098,0.388235,0.4,0.470588,0.576471,0.65098,0.690196,0.713726,0.72549,0.713726,0.737255,0.807843,0.854902,0.862745,0.854902,0.827451,0.784314,0.741176,0.721569,0.694118,0.635294,0.580392,0.537255,0.494118,0.431373,0.360784,0.298039,0.25098,0.211765,0.180392,0.145098,0.113725,0.090196,0.066667,0.047059,0.035294,0.035294,0.035294,0.035294,0.031373,0.031373,0.035294,0.035294,0.039216,0.039216,0.047059,0.043137,0.039216,0.039216,0.039216,0.047059,0.05098,0.054902,0.054902,0.058824,0.058824,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.070588,0.070588,0.066667,0.066667,0.070588,0.070588,0.070588,0.07451,0.078431,0.082353,0.082353,0.078431,0.07451,0.066667,0.054902,0.047059,0.043137,0.035294,0.031373,0.031373,0.035294,0.031373,0.027451,0.023529,0.023529,0.023529,0.023529,0.023529,0.023529,0.023529,0.023529,0.027451,0.031373,0.031373,0.031373,0.039216,0.05098,0.070588,0.098039,0.129412,0.164706,0.192157,0.207843,0.227451,0.27451,0.352941,0.427451,0.47451,0.560784,0.654902,0.709804,0.733333,0.768627,0.792157,0.796078,0.815686,0.831373,0.858824,0.87451,0.854902,0.823529,0.788235,0.74902,0.701961,0.682353,0.670588,0.627451,0.552941,0.486275,0.439216,0.384314,0.317647,0.258824,0.223529,0.188235,0.145098,0.113725,0.098039,0.07451,0.054902,0.043137,0.039216,0.031373,0.027451,0.027451,0.027451,0.031373,0.035294,0.039216,0.043137,0.043137,0.043137,0.039216,0.039216,0.043137,0.05098,0.05098,0.054902,0.058824,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.058824,0.062745,0.062745,0.062745,0.058824,0.062745,0.062745,0.062745,0.062745,0.066667,0.070588,0.066667,0.066667,0.066667,0.07451,0.07451,0.070588,0.070588,0.078431,0.078431,0.078431,0.070588,0.066667,0.062745,0.058824,0.054902,0.047059,0.039216,0.039216,0.035294,0.035294,0.031373,0.027451,0.023529,0.023529,0.023529,0.023529,0.023529,0.023529,0.023529,0.027451,0.031373,0.035294,0.039216,0.039216,0.054902,0.082353,0.121569,0.156863,0.2,0.25098,0.278431,0.301961,0.364706,0.431373,0.466667,0.521569,0.635294,0.741176,0.780392,0.780392,0.8,0.839216,0.862745,0.862745,0.854902,0.866667,0.878431,0.854902,0.827451,0.803922,0.764706,0.709804,0.658824,0.627451,0.588235,0.513726,0.454902,0.423529,0.384314,0.309804,0.235294,0.203922,0.176471,0.129412,0.098039,0.086275,0.070588,0.058824,0.05098,0.043137,0.035294,0.027451,0.027451,0.027451,0.031373,0.035294,0.039216,0.043137,0.043137,0.039216,0.039216,0.043137,0.047059,0.05098,0.05098,0.054902,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.07451,0.07451,0.070588,0.070588,0.070588,0.07451,0.07451,0.070588,0.066667,0.062745,0.062745,0.062745,0.054902,0.05098,0.047059,0.043137,0.039216,0.035294,0.031373,0.027451,0.027451,0.023529,0.023529,0.027451,0.027451,0.027451,0.031373,0.035294,0.039216,0.047059,0.05098,0.058824,0.082353,0.129412,0.180392,0.227451,0.294118,0.34902,0.384314,0.466667,0.552941,0.588235,0.623529,0.705882,0.792157,0.835294,0.835294,0.827451,0.847059,0.878431,0.890196,0.890196,0.886275,0.882353,0.862745,0.843137,0.815686,0.780392,0.733333,0.662745,0.580392,0.505882,0.419608,0.368627,0.368627,0.337255,0.266667,0.203922,0.160784,0.133333,0.094118,0.066667,0.062745,0.058824,0.05098,0.043137,0.039216,0.031373,0.031373,0.031373,0.031373,0.031373,0.035294,0.039216,0.039216,0.035294,0.035294,0.039216,0.047059,0.047059,0.047059,0.05098,0.054902,0.054902,0.05098,0.05098,0.054902,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.066667,0.066667,0.070588,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.070588,0.070588,0.066667,0.066667,0.070588,0.07451,0.070588,0.066667,0.066667,0.066667,0.066667,0.070588,0.066667,0.058824,0.054902,0.058824,0.058824,0.05098,0.047059,0.043137,0.039216,0.035294,0.031373,0.031373,0.027451,0.027451,0.027451,0.031373,0.031373,0.031373,0.035294,0.039216,0.047059,0.054902,0.062745,0.062745,0.07451,0.109804,0.168627,0.219608,0.294118,0.376471,0.435294,0.517647,0.627451,0.709804,0.745098,0.764706,0.815686,0.870588,0.882353,0.87451,0.870588,0.890196,0.909804,0.909804,0.901961,0.886275,0.87451,0.854902,0.831373,0.803922,0.764706,0.709804,0.635294,0.529412,0.411765,0.333333,0.313726,0.290196,0.243137,0.180392,0.121569,0.082353,0.058824,0.047059,0.047059,0.047059,0.039216,0.035294,0.031373,0.031373,0.031373,0.031373,0.031373,0.031373,0.035294,0.035294,0.035294,0.031373,0.035294,0.043137,0.047059,0.047059,0.047059,0.05098,0.05098,0.05098,0.047059,0.047059,0.054902,0.058824,0.062745,0.066667,0.066667,0.062745,0.062745,0.066667,0.070588,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.058824,0.066667,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.070588,0.070588,0.070588,0.066667,0.066667,0.07451,0.07451,0.070588,0.066667,0.062745,0.062745,0.066667,0.062745,0.058824,0.058824,0.054902,0.05098,0.047059,0.043137,0.039216,0.039216,0.035294,0.031373,0.031373,0.031373,0.031373,0.031373,0.031373,0.035294,0.043137,0.047059,0.054902,0.054902,0.054902,0.058824,0.062745,0.070588,0.090196,0.137255,0.207843,0.294118,0.403922,0.494118,0.572549,0.654902,0.745098,0.803922,0.819608,0.854902,0.894118,0.913725,0.913725,0.905882,0.905882,0.917647,0.921569,0.913725,0.901961,0.890196,0.87451,0.858824,0.839216,0.807843,0.760784,0.690196,0.592157,0.486275,0.4,0.333333,0.262745,0.184314,0.117647,0.082353,0.054902,0.039216,0.031373,0.035294,0.035294,0.031373,0.027451,0.027451,0.027451,0.027451,0.027451,0.027451,0.027451,0.031373,0.031373,0.027451,0.031373,0.035294,0.039216,0.043137,0.043137,0.047059,0.05098,0.05098,0.047059,0.05098,0.054902,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.070588,0.066667,0.066667,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.058824,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.070588,0.070588,0.070588,0.066667,0.066667,0.070588,0.070588,0.066667,0.062745,0.058824,0.062745,0.066667,0.062745,0.062745,0.062745,0.054902,0.047059,0.043137,0.043137,0.039216,0.039216,0.035294,0.031373,0.031373,0.031373,0.031373,0.035294,0.035294,0.039216,0.047059,0.058824,0.070588,0.07451,0.070588,0.070588,0.070588,0.086275,0.105882,0.14902,0.231373,0.32549,0.423529,0.505882,0.584314,0.67451,0.756863,0.803922,0.843137,0.890196,0.913725,0.92549,0.929412,0.929412,0.92549,0.929412,0.929412,0.92549,0.917647,0.905882,0.898039,0.890196,0.87451,0.835294,0.764706,0.694118,0.639216,0.572549,0.494118,0.376471,0.231373,0.141176,0.109804,0.094118,0.062745,0.039216,0.031373,0.031373,0.031373,0.027451,0.027451,0.023529,0.023529,0.023529,0.023529,0.023529,0.027451,0.027451,0.027451,0.027451,0.031373,0.035294,0.035294,0.039216,0.047059,0.047059,0.047059,0.05098,0.05098,0.054902,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.058824,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.070588,0.066667,0.062745,0.058824,0.054902,0.058824,0.062745,0.058824,0.058824,0.058824,0.058824,0.05098,0.05098,0.047059,0.047059,0.039216,0.035294,0.031373,0.031373,0.031373,0.031373,0.031373,0.035294,0.043137,0.054902,0.066667,0.086275,0.098039,0.105882,0.105882,0.098039,0.105882,0.137255,0.172549,0.243137,0.32549,0.384314,0.443137,0.521569,0.623529,0.705882,0.768627,0.839216,0.890196,0.917647,0.929412,0.937255,0.941176,0.941176,0.941176,0.941176,0.937255,0.92549,0.917647,0.905882,0.890196,0.862745,0.815686,0.721569,0.643137,0.615686,0.572549,0.501961,0.388235,0.254902,0.2,0.176471,0.121569,0.07451,0.058824,0.047059,0.035294,0.035294};
			return value;
		}
		private double[] getElevationGrid_4_24_height_8()
		{
			double[] value = {0.035294,0.031373,0.027451,0.023529,0.023529,0.027451,0.027451,0.027451,0.031373,0.031373,0.035294,0.035294,0.039216,0.039216,0.043137,0.047059,0.047059,0.047059,0.047059,0.05098,0.054902,0.054902,0.058824,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.058824,0.058824,0.054902,0.05098,0.047059,0.043137,0.039216,0.031373,0.031373,0.031373,0.027451,0.027451,0.031373,0.047059,0.062745,0.07451,0.101961,0.12549,0.152941,0.168627,0.152941,0.145098,0.176471,0.215686,0.266667,0.333333,0.388235,0.45098,0.517647,0.572549,0.647059,0.74902,0.839216,0.882353,0.909804,0.929412,0.941176,0.94902,0.94902,0.94902,0.94902,0.941176,0.929412,0.913725,0.890196,0.866667,0.835294,0.788235,0.709804,0.635294,0.572549,0.494118,0.407843,0.345098,0.305882,0.266667,0.2,0.129412,0.098039,0.090196,0.070588,0.047059,0.047059,0.047059,0.039216,0.031373,0.027451,0.027451,0.027451,0.031373,0.031373,0.035294,0.035294,0.035294,0.039216,0.039216,0.043137,0.043137,0.043137,0.043137,0.043137,0.047059,0.047059,0.047059,0.05098,0.058824,0.062745,0.066667,0.066667,0.062745,0.062745,0.062745,0.058824,0.058824,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.058824,0.058824,0.062745,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.054902,0.054902,0.05098,0.05098,0.05098,0.054902,0.054902,0.05098,0.05098,0.047059,0.043137,0.039216,0.031373,0.027451,0.027451,0.027451,0.027451,0.031373,0.047059,0.062745,0.082353,0.113725,0.145098,0.176471,0.211765,0.223529,0.211765,0.231373,0.27451,0.309804,0.360784,0.443137,0.537255,0.619608,0.654902,0.694118,0.780392,0.858824,0.894118,0.917647,0.929412,0.945098,0.952941,0.956863,0.956863,0.94902,0.941176,0.929412,0.909804,0.894118,0.882353,0.862745,0.827451,0.784314,0.72549,0.647059,0.541176,0.415686,0.317647,0.286275,0.25098,0.2,0.172549,0.14902,0.117647,0.082353,0.058824,0.054902,0.054902,0.043137,0.039216,0.035294,0.031373,0.031373,0.035294,0.035294,0.035294,0.035294,0.035294,0.035294,0.039216,0.039216,0.043137,0.043137,0.047059,0.047059,0.05098,0.05098,0.05098,0.054902,0.062745,0.062745,0.062745,0.062745,0.058824,0.062745,0.062745,0.058824,0.058824,0.058824,0.058824,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.058824,0.058824,0.058824,0.058824,0.062745,0.066667,0.066667,0.062745,0.062745,0.058824,0.054902,0.054902,0.05098,0.05098,0.05098,0.05098,0.05098,0.05098,0.05098,0.05098,0.047059,0.043137,0.031373,0.027451,0.023529,0.027451,0.023529,0.027451,0.039216,0.054902,0.07451,0.098039,0.117647,0.145098,0.203922,0.27451,0.290196,0.298039,0.333333,0.380392,0.431373,0.498039,0.576471,0.666667,0.741176,0.780392,0.835294,0.886275,0.913725,0.92549,0.937255,0.94902,0.960784,0.960784,0.960784,0.956863,0.952941,0.945098,0.933333,0.921569,0.909804,0.894118,0.870588,0.835294,0.780392,0.709804,0.639216,0.52549,0.388235,0.305882,0.27451,0.266667,0.247059,0.192157,0.145098,0.113725,0.086275,0.070588,0.058824,0.05098,0.043137,0.039216,0.035294,0.035294,0.035294,0.035294,0.035294,0.035294,0.035294,0.039216,0.039216,0.039216,0.043137,0.043137,0.047059,0.05098,0.05098,0.054902,0.054902,0.058824,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.062745,0.062745,0.066667,0.066667,0.070588,0.070588,0.070588,0.066667,0.066667,0.066667,0.070588,0.062745,0.058824,0.058824,0.062745,0.066667,0.062745,0.058824,0.058824,0.054902,0.054902,0.05098,0.05098,0.05098,0.05098,0.05098,0.054902,0.054902,0.054902,0.05098,0.043137,0.035294,0.031373,0.031373,0.027451,0.023529,0.023529,0.027451,0.043137,0.058824,0.070588,0.086275,0.121569,0.2,0.301961,0.368627,0.376471,0.4,0.45098,0.509804,0.560784,0.607843,0.662745,0.745098,0.819608,0.866667,0.882353,0.901961,0.921569,0.941176,0.956863,0.964706,0.964706,0.964706,0.960784,0.960784,0.956863,0.94902,0.937255,0.921569,0.905882,0.878431,0.847059,0.792157,0.72549,0.666667,0.611765,0.541176,0.470588,0.415686,0.376471,0.309804,0.227451,0.180392,0.152941,0.113725,0.086275,0.066667,0.05098,0.043137,0.039216,0.039216,0.035294,0.035294,0.031373,0.035294,0.039216,0.039216,0.043137,0.043137,0.043137,0.043137,0.043137,0.047059,0.047059,0.05098,0.05098,0.054902,0.054902,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.062745,0.062745,0.066667,0.070588,0.070588,0.070588,0.07451,0.07451,0.07451,0.07451,0.07451,0.070588,0.062745,0.058824,0.058824,0.062745,0.062745,0.058824,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.058824,0.058824,0.054902,0.047059,0.043137,0.043137,0.039216,0.031373,0.023529,0.023529,0.027451,0.031373,0.043137,0.062745,0.090196,0.129412,0.207843,0.313726,0.403922,0.458824,0.486275,0.509804,0.564706,0.631373,0.686275,0.721569,0.756863,0.811765,0.843137,0.858824,0.894118,0.92549,0.945098,0.960784,0.968627,0.968627,0.968627,0.968627,0.964706,0.956863,0.941176,0.913725,0.901961,0.901961,0.886275,0.843137,0.784314,0.733333,0.698039,0.67451,0.647059,0.592157,0.513726,0.427451,0.321569,0.227451,0.180392,0.14902,0.121569,0.090196,0.066667,0.05098,0.035294,0.035294,0.035294,0.035294,0.031373,0.031373,0.035294,0.039216,0.039216,0.043137,0.043137,0.043137,0.047059,0.047059,0.043137,0.043137,0.047059,0.05098,0.05098,0.054902,0.058824,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.066667,0.066667,0.062745,0.062745,0.058824,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.058824,0.058824,0.058824,0.054902,0.05098,0.058824,0.058824,0.047059,0.035294,0.027451,0.023529,0.023529,0.023529,0.035294,0.054902,0.090196,0.133333,0.203922,0.294118,0.388235,0.498039,0.576471,0.603922,0.643137,0.717647,0.780392,0.811765,0.807843,0.807843,0.831373,0.866667,0.909804,0.941176,0.956863,0.964706,0.968627,0.972549,0.972549,0.972549,0.968627,0.960784,0.933333,0.898039,0.862745,0.862745,0.878431,0.854902,0.784314,0.713726,0.678431,0.654902,0.611765,0.568627,0.505882,0.403922,0.282353,0.196078,0.14902,0.117647,0.098039,0.07451,0.058824,0.047059,0.031373,0.027451,0.031373,0.031373,0.031373,0.031373,0.035294,0.039216,0.039216,0.039216,0.039216,0.043137,0.047059,0.043137,0.039216,0.039216,0.043137,0.047059,0.05098,0.054902,0.05098,0.054902,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.070588,0.070588,0.066667,0.066667,0.062745,0.070588,0.07451,0.07451,0.07451,0.07451,0.07451,0.07451,0.070588,0.070588,0.066667,0.062745,0.062745,0.058824,0.058824,0.058824,0.058824,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.058824,0.062745,0.062745,0.062745,0.058824,0.062745,0.066667,0.062745,0.05098,0.035294,0.027451,0.027451,0.027451,0.027451,0.031373,0.043137,0.070588,0.113725,0.176471,0.235294,0.313726,0.45098,0.584314,0.647059,0.686275,0.760784,0.831373,0.862745,0.862745,0.85098,0.862745,0.901961,0.933333,0.952941,0.960784,0.964706,0.968627,0.972549,0.972549,0.968627,0.968627,0.960784,0.945098,0.921569,0.866667,0.815686,0.815686,0.831373,0.807843,0.709804,0.6,0.556863,0.521569,0.482353,0.45098,0.380392,0.278431,0.211765,0.168627,0.121569,0.078431,0.054902,0.047059,0.039216,0.027451,0.023529,0.027451,0.027451,0.027451,0.031373,0.035294,0.035294,0.031373,0.031373,0.035294,0.039216,0.039216,0.039216,0.039216,0.039216,0.039216,0.043137,0.047059,0.047059,0.047059,0.054902,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.07451,0.07451,0.078431,0.078431,0.07451,0.078431,0.078431,0.07451,0.070588,0.070588,0.066667,0.062745,0.062745,0.062745,0.058824,0.062745,0.058824,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.058824,0.062745,0.066667,0.066667,0.070588,0.07451,0.082353,0.07451,0.058824,0.043137,0.035294,0.031373,0.031373,0.039216,0.035294,0.031373,0.047059,0.07451,0.109804,0.137255,0.207843,0.352941,0.486275,0.545098,0.580392,0.67451,0.776471,0.839216,0.870588,0.878431,0.890196,0.913725,0.937255,0.945098,0.94902,0.960784,0.964706,0.964706};
			return value;
		}
		private double[] getElevationGrid_4_24_height_9()
		{
			double[] value = {0.964706,0.964706,0.964706,0.960784,0.952941,0.941176,0.898039,0.815686,0.745098,0.737255,0.756863,0.701961,0.552941,0.462745,0.45098,0.403922,0.368627,0.356863,0.309804,0.243137,0.188235,0.133333,0.082353,0.05098,0.035294,0.027451,0.023529,0.023529,0.023529,0.023529,0.027451,0.031373,0.031373,0.031373,0.027451,0.031373,0.035294,0.035294,0.035294,0.031373,0.035294,0.035294,0.031373,0.031373,0.035294,0.035294,0.039216,0.047059,0.05098,0.05098,0.05098,0.054902,0.054902,0.058824,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.07451,0.078431,0.078431,0.078431,0.082353,0.082353,0.078431,0.078431,0.07451,0.070588,0.070588,0.070588,0.070588,0.066667,0.066667,0.066667,0.062745,0.058824,0.058824,0.058824,0.058824,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.058824,0.066667,0.07451,0.082353,0.090196,0.098039,0.094118,0.070588,0.054902,0.047059,0.039216,0.043137,0.058824,0.047059,0.035294,0.031373,0.047059,0.070588,0.082353,0.137255,0.27451,0.364706,0.388235,0.454902,0.572549,0.705882,0.788235,0.827451,0.862745,0.894118,0.901961,0.901961,0.917647,0.937255,0.94902,0.952941,0.956863,0.956863,0.960784,0.956863,0.952941,0.94902,0.937255,0.913725,0.854902,0.741176,0.639216,0.647059,0.678431,0.564706,0.411765,0.372549,0.32549,0.266667,0.27451,0.27451,0.231373,0.164706,0.109804,0.07451,0.047059,0.031373,0.023529,0.023529,0.027451,0.027451,0.023529,0.023529,0.027451,0.027451,0.027451,0.027451,0.031373,0.031373,0.031373,0.027451,0.027451,0.031373,0.035294,0.031373,0.031373,0.031373,0.031373,0.035294,0.035294,0.039216,0.039216,0.039216,0.043137,0.047059,0.054902,0.058824,0.062745,0.062745,0.062745,0.062745,0.066667,0.062745,0.054902,0.054902,0.054902,0.078431,0.082353,0.082353,0.082353,0.086275,0.086275,0.086275,0.082353,0.078431,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.066667,0.058824,0.058824,0.058824,0.062745,0.058824,0.054902,0.05098,0.05098,0.054902,0.054902,0.058824,0.058824,0.066667,0.078431,0.090196,0.101961,0.113725,0.109804,0.090196,0.07451,0.066667,0.054902,0.062745,0.082353,0.07451,0.05098,0.039216,0.05098,0.086275,0.113725,0.145098,0.219608,0.282353,0.329412,0.419608,0.545098,0.666667,0.729412,0.764706,0.827451,0.858824,0.85098,0.854902,0.894118,0.92549,0.929412,0.929412,0.937255,0.945098,0.952941,0.945098,0.937255,0.937255,0.933333,0.917647,0.87451,0.745098,0.580392,0.541176,0.592157,0.545098,0.411765,0.317647,0.262745,0.203922,0.180392,0.184314,0.168627,0.113725,0.066667,0.05098,0.039216,0.031373,0.027451,0.027451,0.031373,0.031373,0.027451,0.023529,0.023529,0.027451,0.027451,0.031373,0.031373,0.027451,0.027451,0.027451,0.031373,0.031373,0.035294,0.035294,0.039216,0.039216,0.043137,0.043137,0.043137,0.043137,0.047059,0.047059,0.047059,0.054902,0.054902,0.054902,0.058824,0.062745,0.062745,0.062745,0.062745,0.058824,0.05098,0.05098,0.047059,0.078431,0.082353,0.086275,0.086275,0.086275,0.090196,0.086275,0.082353,0.07451,0.070588,0.07451,0.078431,0.07451,0.07451,0.070588,0.062745,0.058824,0.058824,0.062745,0.062745,0.062745,0.054902,0.054902,0.05098,0.054902,0.058824,0.062745,0.066667,0.070588,0.078431,0.090196,0.105882,0.121569,0.12549,0.113725,0.101961,0.086275,0.07451,0.090196,0.105882,0.101961,0.078431,0.058824,0.054902,0.086275,0.137255,0.180392,0.231373,0.278431,0.313726,0.380392,0.501961,0.6,0.654902,0.721569,0.776471,0.776471,0.780392,0.827451,0.87451,0.901961,0.905882,0.901961,0.917647,0.937255,0.945098,0.937255,0.92549,0.92549,0.921569,0.909804,0.866667,0.737255,0.588235,0.529412,0.52549,0.509804,0.466667,0.4,0.341176,0.270588,0.203922,0.164706,0.129412,0.086275,0.062745,0.054902,0.047059,0.035294,0.027451,0.031373,0.031373,0.031373,0.027451,0.023529,0.023529,0.027451,0.031373,0.035294,0.031373,0.027451,0.027451,0.027451,0.027451,0.031373,0.035294,0.035294,0.035294,0.039216,0.047059,0.05098,0.054902,0.054902,0.058824,0.058824,0.058824,0.062745,0.062745,0.058824,0.058824,0.062745,0.062745,0.066667,0.062745,0.058824,0.058824,0.058824,0.058824,0.07451,0.078431,0.082353,0.086275,0.090196,0.094118,0.090196,0.086275,0.078431,0.07451,0.078431,0.082353,0.082353,0.078431,0.070588,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.058824,0.054902,0.054902,0.054902,0.058824,0.066667,0.07451,0.07451,0.07451,0.082353,0.101961,0.121569,0.133333,0.137255,0.12549,0.105882,0.098039,0.121569,0.129412,0.117647,0.105882,0.098039,0.078431,0.070588,0.105882,0.172549,0.227451,0.258824,0.270588,0.32549,0.431373,0.521569,0.603922,0.666667,0.67451,0.686275,0.745098,0.811765,0.85098,0.87451,0.878431,0.878431,0.901961,0.929412,0.933333,0.92549,0.901961,0.878431,0.87451,0.862745,0.819608,0.737255,0.670588,0.635294,0.584314,0.541176,0.52549,0.486275,0.447059,0.380392,0.294118,0.231373,0.168627,0.117647,0.090196,0.070588,0.054902,0.039216,0.031373,0.027451,0.031373,0.031373,0.027451,0.023529,0.023529,0.027451,0.027451,0.031373,0.031373,0.035294,0.035294,0.035294,0.031373,0.039216,0.043137,0.043137,0.039216,0.039216,0.05098,0.054902,0.058824,0.058824,0.058824,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.07451,0.07451,0.078431,0.082353,0.090196,0.094118,0.094118,0.094118,0.086275,0.07451,0.082353,0.086275,0.086275,0.078431,0.070588,0.07451,0.078431,0.07451,0.066667,0.058824,0.058824,0.058824,0.058824,0.058824,0.054902,0.058824,0.066667,0.078431,0.082353,0.082353,0.090196,0.105882,0.117647,0.137255,0.152941,0.145098,0.133333,0.141176,0.156863,0.14902,0.133333,0.133333,0.145098,0.12549,0.078431,0.078431,0.121569,0.172549,0.215686,0.262745,0.313726,0.384314,0.466667,0.533333,0.556863,0.572549,0.643137,0.717647,0.760784,0.792157,0.823529,0.839216,0.854902,0.894118,0.917647,0.92549,0.909804,0.870588,0.839216,0.831373,0.823529,0.807843,0.792157,0.760784,0.709804,0.647059,0.596078,0.533333,0.447059,0.403922,0.368627,0.313726,0.243137,0.180392,0.141176,0.109804,0.07451,0.054902,0.039216,0.031373,0.031373,0.031373,0.031373,0.027451,0.023529,0.023529,0.027451,0.027451,0.027451,0.031373,0.039216,0.039216,0.039216,0.039216,0.043137,0.05098,0.05098,0.047059,0.043137,0.047059,0.054902,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.070588,0.070588,0.070588,0.078431,0.086275,0.090196,0.098039,0.098039,0.094118,0.082353,0.086275,0.090196,0.086275,0.07451,0.078431,0.082353,0.082353,0.078431,0.066667,0.058824,0.058824,0.058824,0.066667,0.066667,0.062745,0.062745,0.066667,0.078431,0.094118,0.101961,0.105882,0.113725,0.121569,0.137255,0.160784,0.168627,0.172549,0.184314,0.188235,0.176471,0.156863,0.152941,0.180392,0.168627,0.117647,0.101961,0.101961,0.117647,0.176471,0.239216,0.286275,0.34902,0.403922,0.407843,0.427451,0.509804,0.611765,0.666667,0.698039,0.737255,0.780392,0.811765,0.85098,0.890196,0.909804,0.921569,0.917647,0.886275,0.862745,0.870588,0.87451,0.862745,0.85098,0.807843,0.752941,0.709804,0.65098,0.556863,0.447059,0.352941,0.286275,0.235294,0.168627,0.117647,0.101961,0.082353,0.058824,0.05098,0.043137,0.039216,0.035294,0.031373,0.031373,0.027451,0.023529,0.023529,0.023529,0.023529,0.023529,0.027451,0.035294,0.039216,0.039216,0.043137,0.043137,0.047059,0.05098,0.05098,0.05098,0.047059,0.047059,0.05098,0.05098,0.05098,0.054902,0.054902,0.054902,0.058824,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.058824,0.062745,0.066667,0.070588,0.07451,0.078431,0.090196,0.094118,0.101961,0.098039,0.094118,0.098039,0.098039,0.086275,0.086275,0.090196,0.086275,0.082353,0.078431,0.066667,0.062745,0.066667,0.066667,0.07451,0.082353,0.078431,0.07451,0.070588,0.082353,0.101961,0.121569,0.12549,0.133333,0.141176,0.145098,0.160784,0.184314,0.203922,0.219608,0.223529,0.211765,0.180392,0.168627,0.203922,0.203922,0.160784,0.160784,0.137255,0.098039,0.12549,0.192157,0.258824,0.32549,0.341176,0.317647,0.364706,0.466667,0.54902,0.615686,0.662745,0.701961,0.74902,0.796078,0.839216,0.878431,0.901961,0.917647,0.92549,0.921569,0.909804,0.917647,0.92549,0.905882,0.870588,0.839216,0.815686,0.780392,0.694118,0.580392,0.47451,0.352941,0.243137,0.172549,0.113725,0.078431,0.070588,0.054902,0.039216,0.039216,0.039216,0.039216,0.035294,0.031373,0.031373,0.027451,0.023529,0.027451,0.027451,0.027451,0.027451,0.027451,0.031373,0.035294,0.039216,0.043137,0.039216,0.039216,0.043137,0.047059,0.05098,0.047059,0.043137,0.043137,0.047059,0.047059,0.05098,0.05098,0.05098,0.054902,0.058824,0.066667,0.066667,0.070588,0.070588,0.070588,0.066667,0.062745,0.062745,0.062745,0.066667,0.070588,0.070588,0.07451,0.082353,0.086275,0.094118,0.098039,0.101961,0.101961,0.105882,0.101961,0.098039,0.098039,0.094118,0.090196,0.086275,0.078431,0.066667,0.066667,0.070588,0.070588,0.078431,0.094118,0.098039,0.098039,0.086275,0.086275,0.105882,0.133333,0.145098,0.156863,0.168627,0.164706,0.164706,0.192157,0.227451,0.25098,0.254902,0.239216};
			return value;
		}
		private double[] getElevationGrid_4_24_height_10()
		{
			double[] value = {0.207843,0.192157,0.223529,0.227451,0.2,0.2,0.168627,0.109804,0.12549,0.192157,0.243137,0.282353,0.278431,0.270588,0.337255,0.411765,0.466667,0.541176,0.607843,0.666667,0.729412,0.780392,0.823529,0.862745,0.898039,0.917647,0.929412,0.933333,0.937255,0.937255,0.929412,0.909804,0.886275,0.87451,0.862745,0.807843,0.717647,0.6,0.478431,0.380392,0.309804,0.243137,0.180392,0.137255,0.101961,0.066667,0.047059,0.035294,0.031373,0.031373,0.031373,0.031373,0.027451,0.023529,0.023529,0.027451,0.031373,0.031373,0.035294,0.035294,0.035294,0.039216,0.039216,0.039216,0.035294,0.039216,0.043137,0.047059,0.047059,0.05098,0.047059,0.05098,0.05098,0.054902,0.058824,0.054902,0.05098,0.05098,0.058824,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.070588,0.07451,0.070588,0.07451,0.078431,0.082353,0.086275,0.094118,0.098039,0.105882,0.113725,0.113725,0.109804,0.105882,0.098039,0.101961,0.098039,0.086275,0.078431,0.070588,0.078431,0.078431,0.082353,0.098039,0.113725,0.121569,0.113725,0.101961,0.109804,0.129412,0.152941,0.172549,0.188235,0.192157,0.192157,0.211765,0.247059,0.27451,0.282353,0.266667,0.247059,0.231373,0.231373,0.243137,0.235294,0.219608,0.180392,0.152941,0.180392,0.2,0.211765,0.239216,0.254902,0.278431,0.337255,0.4,0.458824,0.513726,0.580392,0.686275,0.772549,0.815686,0.85098,0.882353,0.909804,0.929412,0.937255,0.937255,0.941176,0.945098,0.937255,0.917647,0.913725,0.905882,0.882353,0.831373,0.772549,0.670588,0.54902,0.47451,0.419608,0.34902,0.266667,0.196078,0.145098,0.098039,0.066667,0.043137,0.027451,0.023529,0.027451,0.027451,0.023529,0.023529,0.023529,0.027451,0.027451,0.031373,0.035294,0.039216,0.043137,0.043137,0.047059,0.043137,0.039216,0.039216,0.047059,0.05098,0.05098,0.054902,0.054902,0.058824,0.058824,0.062745,0.062745,0.062745,0.058824,0.058824,0.058824,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.070588,0.070588,0.070588,0.070588,0.07451,0.078431,0.082353,0.086275,0.094118,0.105882,0.113725,0.121569,0.121569,0.113725,0.105882,0.113725,0.109804,0.098039,0.082353,0.078431,0.090196,0.098039,0.098039,0.101961,0.117647,0.141176,0.145098,0.133333,0.133333,0.133333,0.145098,0.168627,0.192157,0.207843,0.219608,0.235294,0.258824,0.286275,0.301961,0.294118,0.282353,0.270588,0.25098,0.254902,0.258824,0.231373,0.203922,0.219608,0.231373,0.207843,0.203922,0.239216,0.286275,0.337255,0.396078,0.454902,0.517647,0.568627,0.627451,0.72549,0.803922,0.847059,0.882353,0.909804,0.92549,0.937255,0.945098,0.945098,0.945098,0.945098,0.941176,0.933333,0.929412,0.917647,0.894118,0.854902,0.803922,0.717647,0.6,0.494118,0.423529,0.34902,0.262745,0.184314,0.145098,0.109804,0.070588,0.043137,0.027451,0.023529,0.023529,0.023529,0.023529,0.023529,0.027451,0.027451,0.031373,0.031373,0.035294,0.039216,0.043137,0.043137,0.047059,0.05098,0.05098,0.05098,0.05098,0.05098,0.054902,0.054902,0.054902,0.058824,0.058824,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.066667,0.066667,0.058824,0.070588,0.066667,0.070588,0.07451,0.07451,0.078431,0.082353,0.082353,0.090196,0.098039,0.105882,0.117647,0.12549,0.121569,0.117647,0.12549,0.121569,0.105882,0.086275,0.082353,0.101961,0.117647,0.121569,0.121569,0.12549,0.14902,0.168627,0.172549,0.164706,0.164706,0.156863,0.164706,0.184314,0.211765,0.243137,0.258824,0.270588,0.294118,0.313726,0.317647,0.309804,0.298039,0.282353,0.278431,0.270588,0.25098,0.258824,0.282353,0.270588,0.235294,0.227451,0.254902,0.294118,0.34902,0.419608,0.470588,0.517647,0.572549,0.639216,0.705882,0.768627,0.827451,0.878431,0.921569,0.937255,0.945098,0.94902,0.94902,0.94902,0.945098,0.941176,0.937255,0.929412,0.917647,0.894118,0.85098,0.784314,0.698039,0.584314,0.454902,0.352941,0.282353,0.207843,0.137255,0.105882,0.082353,0.054902,0.031373,0.023529,0.019608,0.019608,0.023529,0.023529,0.027451,0.027451,0.031373,0.031373,0.031373,0.031373,0.031373,0.035294,0.035294,0.039216,0.05098,0.054902,0.058824,0.054902,0.054902,0.054902,0.054902,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.058824,0.058824,0.062745,0.066667,0.062745,0.066667,0.066667,0.070588,0.07451,0.07451,0.07451,0.078431,0.078431,0.082353,0.090196,0.098039,0.113725,0.12549,0.133333,0.137255,0.137255,0.133333,0.129412,0.109804,0.090196,0.109804,0.133333,0.145098,0.14902,0.145098,0.141176,0.160784,0.184314,0.196078,0.207843,0.203922,0.196078,0.203922,0.227451,0.266667,0.286275,0.282353,0.298039,0.32549,0.333333,0.329412,0.321569,0.309804,0.290196,0.278431,0.290196,0.305882,0.309804,0.286275,0.262745,0.278431,0.301961,0.313726,0.352941,0.439216,0.509804,0.541176,0.584314,0.643137,0.705882,0.776471,0.835294,0.878431,0.921569,0.94902,0.94902,0.945098,0.945098,0.945098,0.941176,0.937255,0.929412,0.917647,0.898039,0.866667,0.796078,0.705882,0.635294,0.576471,0.470588,0.309804,0.180392,0.117647,0.086275,0.062745,0.047059,0.035294,0.027451,0.023529,0.023529,0.023529,0.023529,0.027451,0.031373,0.031373,0.035294,0.031373,0.027451,0.027451,0.031373,0.035294,0.039216,0.039216,0.047059,0.05098,0.054902,0.054902,0.054902,0.054902,0.054902,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.066667,0.070588,0.070588,0.07451,0.07451,0.078431,0.082353,0.082353,0.090196,0.101961,0.117647,0.129412,0.141176,0.156863,0.160784,0.156863,0.152941,0.133333,0.101961,0.109804,0.141176,0.160784,0.172549,0.168627,0.152941,0.152941,0.172549,0.215686,0.247059,0.254902,0.247059,0.235294,0.25098,0.282353,0.309804,0.305882,0.309804,0.333333,0.345098,0.345098,0.337255,0.321569,0.298039,0.301961,0.32549,0.333333,0.32549,0.305882,0.298039,0.329412,0.364706,0.380392,0.392157,0.454902,0.564706,0.639216,0.670588,0.694118,0.74902,0.815686,0.858824,0.894118,0.929412,0.94902,0.945098,0.941176,0.937255,0.937255,0.937255,0.933333,0.921569,0.905882,0.882353,0.835294,0.74902,0.623529,0.509804,0.458824,0.372549,0.215686,0.098039,0.07451,0.070588,0.047059,0.031373,0.027451,0.027451,0.023529,0.027451,0.027451,0.027451,0.027451,0.035294,0.035294,0.035294,0.035294,0.031373,0.027451,0.031373,0.035294,0.043137,0.043137,0.043137,0.047059,0.05098,0.05098,0.05098,0.05098,0.054902,0.054902,0.054902,0.058824,0.066667,0.066667,0.058824,0.062745,0.062745,0.062745,0.066667,0.066667,0.062745,0.062745,0.058824,0.058824,0.054902,0.058824,0.058824,0.062745,0.066667,0.070588,0.070588,0.070588,0.07451,0.078431,0.078431,0.082353,0.090196,0.101961,0.113725,0.121569,0.133333,0.156863,0.172549,0.176471,0.172549,0.156863,0.129412,0.133333,0.152941,0.168627,0.184314,0.192157,0.192157,0.176471,0.176471,0.219608,0.258824,0.278431,0.282353,0.270588,0.266667,0.294118,0.32549,0.32549,0.32549,0.341176,0.352941,0.352941,0.352941,0.333333,0.317647,0.32549,0.341176,0.345098,0.352941,0.356863,0.356863,0.360784,0.392157,0.435294,0.45098,0.466667,0.560784,0.682353,0.741176,0.756863,0.796078,0.847059,0.886275,0.917647,0.937255,0.941176,0.941176,0.937255,0.933333,0.92549,0.92549,0.92549,0.913725,0.901961,0.886275,0.847059,0.784314,0.647059,0.466667,0.364706,0.266667,0.14902,0.121569,0.141176,0.113725,0.066667,0.047059,0.039216,0.027451,0.027451,0.031373,0.039216,0.039216,0.031373,0.035294,0.039216,0.039216,0.039216,0.035294,0.031373,0.031373,0.031373,0.035294,0.039216,0.043137,0.043137,0.047059,0.043137,0.039216,0.047059,0.054902,0.058824,0.058824,0.058824,0.062745,0.062745,0.058824,0.058824,0.062745,0.066667,0.066667,0.062745,0.058824,0.058824,0.058824,0.062745,0.062745,0.058824,0.058824,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.070588,0.07451,0.078431,0.086275,0.094118,0.101961,0.105882,0.121569,0.145098,0.168627,0.188235,0.192157,0.180392,0.168627,0.180392,0.184314,0.168627,0.176471,0.2,0.219608,0.211765,0.203922,0.223529,0.25098,0.282353,0.305882,0.301961,0.290196,0.309804,0.329412,0.333333,0.333333,0.34902,0.360784,0.360784,0.356863,0.345098,0.333333,0.341176,0.352941,0.356863,0.380392,0.407843,0.411765,0.403922,0.4,0.435294,0.47451,0.490196,0.556863,0.670588,0.764706,0.811765,0.843137,0.878431,0.905882,0.921569,0.929412,0.933333,0.933333,0.929412,0.921569,0.913725,0.913725,0.913725,0.905882,0.894118,0.886275,0.870588,0.831373,0.733333,0.603922,0.498039,0.345098,0.239216,0.258824,0.243137,0.156863,0.109804,0.098039,0.070588,0.05098,0.043137,0.047059,0.054902,0.047059,0.035294,0.035294,0.039216,0.043137,0.039216,0.035294,0.031373,0.035294,0.031373,0.031373,0.035294,0.039216,0.039216,0.039216,0.035294,0.035294,0.043137,0.058824,0.066667,0.066667,0.058824,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.058824,0.058824,0.062745,0.062745,0.062745,0.066667,0.062745,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.070588,0.07451,0.078431,0.082353,0.086275,0.094118,0.105882,0.117647,0.133333,0.156863};
			return value;
		}
		private double[] getElevationGrid_4_24_height_11()
		{
			double[] value = {0.180392,0.2,0.2,0.2,0.211765,0.207843,0.184314,0.176471,0.196078,0.231373,0.247059,0.25098,0.25098,0.262745,0.294118,0.317647,0.317647,0.317647,0.329412,0.333333,0.333333,0.341176,0.34902,0.352941,0.352941,0.352941,0.34902,0.341176,0.345098,0.356863,0.368627,0.4,0.435294,0.454902,0.454902,0.45098,0.47451,0.509804,0.521569,0.572549,0.67451,0.772549,0.835294,0.870588,0.886275,0.901961,0.913725,0.917647,0.921569,0.921569,0.917647,0.909804,0.901961,0.901961,0.901961,0.894118,0.878431,0.87451,0.870588,0.839216,0.760784,0.666667,0.545098,0.392157,0.360784,0.403922,0.337255,0.235294,0.192157,0.145098,0.109804,0.101961,0.082353,0.07451,0.066667,0.05098,0.043137,0.043137,0.043137,0.043137,0.039216,0.035294,0.035294,0.039216,0.039216,0.035294,0.043137,0.047059,0.047059,0.047059,0.043137,0.043137,0.047059,0.062745,0.07451,0.070588,0.062745,0.058824,0.062745,0.058824,0.062745,0.062745,0.062745,0.058824,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.070588,0.070588,0.07451,0.078431,0.078431,0.082353,0.090196,0.101961,0.117647,0.129412,0.14902,0.168627,0.188235,0.203922,0.219608,0.231373,0.219608,0.203922,0.2,0.203922,0.231373,0.266667,0.282353,0.278431,0.278431,0.301961,0.321569,0.32549,0.333333,0.345098,0.341176,0.341176,0.345098,0.345098,0.341176,0.337255,0.341176,0.345098,0.34902,0.352941,0.360784,0.376471,0.411765,0.454902,0.486275,0.505882,0.52549,0.556863,0.603922,0.619608,0.635294,0.709804,0.792157,0.835294,0.862745,0.882353,0.894118,0.905882,0.909804,0.909804,0.913725,0.901961,0.890196,0.894118,0.894118,0.890196,0.882353,0.870588,0.858824,0.858824,0.831373,0.729412,0.6,0.505882,0.45098,0.470588,0.501961,0.458824,0.384314,0.298039,0.196078,0.160784,0.156863,0.12549,0.105882,0.086275,0.054902,0.054902,0.058824,0.054902,0.047059,0.043137,0.043137,0.043137,0.043137,0.043137,0.039216,0.043137,0.05098,0.05098,0.054902,0.054902,0.054902,0.058824,0.066667,0.078431,0.07451,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.058824,0.062745,0.066667,0.070588,0.070588,0.070588,0.07451,0.078431,0.082353,0.086275,0.090196,0.090196,0.098039,0.113725,0.133333,0.14902,0.160784,0.176471,0.196078,0.219608,0.235294,0.231373,0.219608,0.227451,0.223529,0.239216,0.270588,0.290196,0.290196,0.286275,0.305882,0.32549,0.329412,0.333333,0.341176,0.345098,0.345098,0.341176,0.337255,0.329412,0.329412,0.333333,0.337255,0.345098,0.352941,0.364706,0.380392,0.411765,0.458824,0.509804,0.533333,0.54902,0.568627,0.623529,0.694118,0.717647,0.733333,0.784314,0.827451,0.85098,0.87451,0.890196,0.894118,0.898039,0.901961,0.901961,0.890196,0.87451,0.882353,0.890196,0.882353,0.870588,0.858824,0.85098,0.839216,0.819608,0.741176,0.647059,0.627451,0.635294,0.607843,0.580392,0.564706,0.505882,0.384314,0.270588,0.235294,0.207843,0.164706,0.129412,0.086275,0.058824,0.066667,0.07451,0.062745,0.054902,0.054902,0.058824,0.054902,0.047059,0.043137,0.039216,0.035294,0.043137,0.047059,0.058824,0.062745,0.066667,0.070588,0.078431,0.082353,0.07451,0.062745,0.062745,0.066667,0.066667,0.070588,0.070588,0.066667,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.058824,0.058824,0.062745,0.066667,0.070588,0.070588,0.07451,0.078431,0.086275,0.090196,0.098039,0.101961,0.105882,0.101961,0.109804,0.133333,0.14902,0.160784,0.176471,0.192157,0.211765,0.235294,0.239216,0.235294,0.243137,0.25098,0.262745,0.278431,0.294118,0.301961,0.305882,0.317647,0.329412,0.329412,0.32549,0.329412,0.333333,0.333333,0.337255,0.333333,0.329412,0.32549,0.321569,0.32549,0.337255,0.345098,0.352941,0.372549,0.411765,0.47451,0.545098,0.580392,0.588235,0.584314,0.615686,0.701961,0.764706,0.772549,0.780392,0.807843,0.843137,0.870588,0.882353,0.882353,0.890196,0.894118,0.890196,0.87451,0.858824,0.866667,0.878431,0.87451,0.862745,0.85098,0.847059,0.831373,0.815686,0.780392,0.745098,0.74902,0.745098,0.690196,0.647059,0.623529,0.54902,0.443137,0.388235,0.34902,0.266667,0.180392,0.117647,0.070588,0.066667,0.082353,0.07451,0.062745,0.066667,0.070588,0.070588,0.058824,0.054902,0.05098,0.043137,0.047059,0.05098,0.054902,0.062745,0.07451,0.07451,0.078431,0.086275,0.086275,0.070588,0.062745,0.066667,0.070588,0.066667,0.066667,0.070588,0.070588,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.058824,0.062745,0.066667,0.070588,0.070588,0.07451,0.082353,0.086275,0.094118,0.101961,0.109804,0.117647,0.121569,0.117647,0.12549,0.14902,0.172549,0.192157,0.203922,0.211765,0.235294,0.25098,0.25098,0.254902,0.262745,0.27451,0.290196,0.301961,0.309804,0.317647,0.32549,0.32549,0.317647,0.313726,0.321569,0.321569,0.317647,0.321569,0.329412,0.32549,0.313726,0.309804,0.317647,0.321569,0.317647,0.32549,0.360784,0.411765,0.482353,0.564706,0.631373,0.662745,0.654902,0.67451,0.721569,0.776471,0.807843,0.807843,0.811765,0.839216,0.862745,0.870588,0.870588,0.87451,0.878431,0.878431,0.862745,0.843137,0.854902,0.866667,0.862745,0.854902,0.847059,0.839216,0.827451,0.807843,0.788235,0.784314,0.780392,0.756863,0.713726,0.686275,0.643137,0.564706,0.509804,0.478431,0.407843,0.282353,0.176471,0.113725,0.094118,0.101961,0.101961,0.078431,0.070588,0.082353,0.082353,0.078431,0.066667,0.066667,0.062745,0.05098,0.062745,0.07451,0.070588,0.07451,0.082353,0.086275,0.090196,0.094118,0.086275,0.066667,0.066667,0.07451,0.07451,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.058824,0.058824,0.062745,0.070588,0.07451,0.078431,0.082353,0.086275,0.094118,0.101961,0.109804,0.121569,0.137255,0.145098,0.145098,0.164706,0.192157,0.207843,0.215686,0.219608,0.231373,0.25098,0.254902,0.258824,0.266667,0.278431,0.294118,0.301961,0.305882,0.309804,0.313726,0.309804,0.301961,0.298039,0.309804,0.313726,0.305882,0.305882,0.305882,0.294118,0.290196,0.294118,0.298039,0.290196,0.278431,0.305882,0.352941,0.4,0.458824,0.537255,0.623529,0.694118,0.713726,0.737255,0.760784,0.780392,0.803922,0.819608,0.831373,0.843137,0.854902,0.858824,0.858824,0.862745,0.866667,0.866667,0.85098,0.831373,0.839216,0.85098,0.85098,0.843137,0.835294,0.823529,0.811765,0.796078,0.780392,0.780392,0.784314,0.760784,0.737255,0.709804,0.658824,0.607843,0.560784,0.498039,0.4,0.290196,0.215686,0.176471,0.156863,0.145098,0.117647,0.086275,0.094118,0.101961,0.090196,0.082353,0.086275,0.090196,0.07451,0.058824,0.07451,0.090196,0.090196,0.086275,0.094118,0.101961,0.101961,0.098039,0.082353,0.066667,0.070588,0.078431,0.07451,0.07451,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.066667,0.062745,0.062745,0.062745,0.058824,0.058824,0.054902,0.058824,0.062745,0.070588,0.07451,0.078431,0.086275,0.090196,0.094118,0.101961,0.113725,0.129412,0.14902,0.164706,0.172549,0.188235,0.207843,0.219608,0.227451,0.227451,0.231373,0.243137,0.25098,0.258824,0.266667,0.278431,0.290196,0.298039,0.301961,0.301961,0.294118,0.294118,0.286275,0.27451,0.282353,0.290196,0.294118,0.282353,0.270588,0.266667,0.270588,0.27451,0.278431,0.266667,0.262745,0.313726,0.368627,0.4,0.447059,0.513726,0.588235,0.658824,0.709804,0.752941,0.776471,0.780392,0.792157,0.811765,0.831373,0.839216,0.839216,0.839216,0.843137,0.85098,0.85098,0.85098,0.839216,0.823529,0.819608,0.831373,0.831373,0.827451,0.819608,0.807843,0.792157,0.780392,0.776471,0.768627,0.768627,0.760784,0.741176,0.717647,0.690196,0.639216,0.572549,0.494118,0.407843,0.32549,0.258824,0.219608,0.184314,0.152941,0.121569,0.109804,0.121569,0.117647,0.101961,0.094118,0.105882,0.109804,0.086275,0.066667,0.086275,0.105882,0.105882,0.101961,0.109804,0.117647,0.109804,0.090196,0.078431,0.07451,0.078431,0.078431,0.078431,0.07451,0.07451,0.070588,0.066667,0.066667,0.066667,0.070588,0.066667,0.062745,0.058824,0.058824,0.054902,0.054902,0.058824,0.062745,0.066667,0.070588,0.07451,0.078431,0.082353,0.082353,0.090196,0.101961,0.121569,0.141176,0.156863,0.172549,0.180392,0.192157,0.207843,0.219608,0.227451,0.231373,0.231373,0.235294,0.247059,0.258824,0.266667,0.278431,0.286275,0.290196,0.286275,0.282353,0.278431,0.282353,0.27451,0.254902,0.247059,0.254902,0.270588,0.258824,0.235294,0.247059,0.258824,0.25098,0.247059,0.243137,0.239216,0.294118,0.341176,0.364706,0.407843,0.454902,0.501961,0.556863,0.627451,0.694118,0.733333,0.756863,0.788235,0.807843,0.819608,0.827451,0.823529,0.819608,0.831373,0.835294,0.835294,0.831373,0.827451,0.819608,0.803922,0.8,0.807843,0.811765,0.807843,0.8,0.780392,0.764706,0.768627,0.764706,0.752941,0.74902,0.733333,0.717647,0.690196,0.643137,0.576471,0.505882,0.431373,0.356863,0.278431,0.215686,0.164706,0.129412,0.133333,0.14902,0.145098,0.137255,0.133333,0.129412,0.141176,0.137255,0.098039,0.078431,0.101961,0.113725,0.113725,0.121569,0.129412,0.12549,0.105882,0.086275,0.086275,0.086275,0.082353,0.082353,0.078431,0.07451,0.070588,0.070588,0.070588,0.070588};
			return value;
		}
		private double[] getElevationGrid_4_24_height_12()
		{
			double[] value = {0.070588,0.066667,0.066667,0.062745,0.058824,0.058824,0.054902,0.054902,0.058824,0.062745,0.062745,0.066667,0.070588,0.07451,0.07451,0.078431,0.086275,0.101961,0.117647,0.137255,0.152941,0.164706,0.176471,0.188235,0.2,0.215686,0.223529,0.223529,0.223529,0.235294,0.243137,0.254902,0.266667,0.27451,0.278431,0.282353,0.278431,0.262745,0.258824,0.27451,0.27451,0.25098,0.235294,0.227451,0.239216,0.231373,0.207843,0.227451,0.243137,0.223529,0.207843,0.215686,0.235294,0.262745,0.298039,0.329412,0.368627,0.388235,0.415686,0.47451,0.560784,0.639216,0.694118,0.741176,0.784314,0.8,0.8,0.811765,0.811765,0.807843,0.815686,0.823529,0.819608,0.811765,0.807843,0.807843,0.796078,0.772549,0.784314,0.796078,0.792157,0.788235,0.768627,0.745098,0.756863,0.764706,0.74902,0.737255,0.72549,0.713726,0.686275,0.647059,0.6,0.537255,0.470588,0.396078,0.321569,0.239216,0.172549,0.160784,0.192157,0.203922,0.180392,0.172549,0.176471,0.172549,0.176471,0.156863,0.105882,0.094118,0.129412,0.133333,0.121569,0.137255,0.141176,0.12549,0.101961,0.086275,0.094118,0.094118,0.086275,0.082353,0.078431,0.07451,0.07451,0.07451,0.07451,0.07451,0.070588,0.066667,0.066667,0.066667,0.062745,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.062745,0.066667,0.070588,0.07451,0.082353,0.086275,0.098039,0.109804,0.12549,0.141176,0.14902,0.156863,0.172549,0.192157,0.207843,0.211765,0.215686,0.227451,0.235294,0.243137,0.25098,0.258824,0.258824,0.262745,0.27451,0.27451,0.254902,0.235294,0.25098,0.262745,0.243137,0.227451,0.215686,0.207843,0.196078,0.180392,0.2,0.211765,0.192157,0.188235,0.223529,0.266667,0.298039,0.337255,0.372549,0.411765,0.447059,0.466667,0.509804,0.603922,0.682353,0.72549,0.756863,0.784314,0.788235,0.784314,0.792157,0.803922,0.8,0.8,0.807843,0.807843,0.796078,0.780392,0.784314,0.776471,0.756863,0.772549,0.788235,0.780392,0.772549,0.74902,0.72549,0.733333,0.74902,0.741176,0.72549,0.709804,0.694118,0.67451,0.639216,0.588235,0.529412,0.458824,0.392157,0.329412,0.262745,0.223529,0.243137,0.262745,0.235294,0.211765,0.223529,0.235294,0.211765,0.188235,0.164706,0.137255,0.141176,0.160784,0.152941,0.141176,0.145098,0.137255,0.117647,0.098039,0.094118,0.098039,0.098039,0.090196,0.086275,0.078431,0.07451,0.078431,0.082353,0.078431,0.07451,0.070588,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.066667,0.078431,0.082353,0.090196,0.098039,0.109804,0.121569,0.129412,0.133333,0.137255,0.156863,0.180392,0.188235,0.196078,0.211765,0.231373,0.235294,0.239216,0.247059,0.254902,0.247059,0.243137,0.258824,0.262745,0.239216,0.207843,0.223529,0.243137,0.235294,0.211765,0.192157,0.184314,0.168627,0.152941,0.168627,0.164706,0.156863,0.184314,0.227451,0.266667,0.309804,0.341176,0.376471,0.443137,0.521569,0.560784,0.584314,0.654902,0.72549,0.756863,0.760784,0.768627,0.768627,0.768627,0.776471,0.788235,0.792157,0.788235,0.792157,0.796078,0.788235,0.764706,0.74902,0.741176,0.737255,0.760784,0.776471,0.772549,0.760784,0.741176,0.717647,0.709804,0.717647,0.72549,0.717647,0.701961,0.678431,0.647059,0.603922,0.545098,0.482353,0.419608,0.356863,0.298039,0.278431,0.301961,0.321569,0.298039,0.258824,0.254902,0.286275,0.290196,0.254902,0.215686,0.207843,0.215686,0.203922,0.176471,0.160784,0.152941,0.145098,0.12549,0.109804,0.101961,0.101961,0.109804,0.105882,0.098039,0.090196,0.082353,0.086275,0.086275,0.086275,0.082353,0.07451,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.058824,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.07451,0.082353,0.090196,0.098039,0.109804,0.113725,0.12549,0.121569,0.117647,0.137255,0.160784,0.172549,0.192157,0.215686,0.227451,0.227451,0.231373,0.243137,0.247059,0.235294,0.223529,0.227451,0.231373,0.215686,0.188235,0.192157,0.219608,0.223529,0.196078,0.164706,0.160784,0.14902,0.129412,0.133333,0.137255,0.145098,0.172549,0.203922,0.239216,0.270588,0.301961,0.34902,0.419608,0.494118,0.545098,0.580392,0.631373,0.698039,0.733333,0.745098,0.752941,0.752941,0.752941,0.764706,0.776471,0.780392,0.776471,0.776471,0.780392,0.776471,0.756863,0.72549,0.701961,0.713726,0.741176,0.756863,0.752941,0.74902,0.741176,0.72549,0.709804,0.698039,0.698039,0.701961,0.694118,0.670588,0.639216,0.592157,0.541176,0.490196,0.443137,0.388235,0.337255,0.341176,0.372549,0.368627,0.32549,0.298039,0.321569,0.345098,0.32549,0.286275,0.262745,0.27451,0.282353,0.239216,0.192157,0.172549,0.152941,0.133333,0.113725,0.105882,0.109804,0.117647,0.117647,0.113725,0.101961,0.094118,0.090196,0.090196,0.090196,0.082353,0.078431,0.07451,0.070588,0.066667,0.066667,0.062745,0.062745,0.058824,0.058824,0.054902,0.062745,0.062745,0.066667,0.066667,0.066667,0.070588,0.078431,0.082353,0.090196,0.094118,0.098039,0.105882,0.117647,0.109804,0.094118,0.105882,0.137255,0.168627,0.192157,0.207843,0.215686,0.215686,0.219608,0.235294,0.247059,0.231373,0.207843,0.196078,0.192157,0.192157,0.180392,0.168627,0.180392,0.2,0.180392,0.145098,0.137255,0.141176,0.117647,0.105882,0.121569,0.137255,0.14902,0.180392,0.211765,0.254902,0.313726,0.372549,0.415686,0.462745,0.517647,0.568627,0.619608,0.670588,0.705882,0.729412,0.737255,0.737255,0.745098,0.752941,0.760784,0.764706,0.760784,0.756863,0.756863,0.764706,0.752941,0.721569,0.694118,0.709804,0.733333,0.741176,0.733333,0.72549,0.72549,0.721569,0.709804,0.694118,0.678431,0.678431,0.670588,0.65098,0.627451,0.592157,0.545098,0.513726,0.482353,0.443137,0.411765,0.407843,0.411765,0.396078,0.368627,0.356863,0.372549,0.372549,0.34902,0.329412,0.321569,0.317647,0.290196,0.247059,0.215686,0.188235,0.14902,0.117647,0.109804,0.117647,0.12549,0.12549,0.121569,0.113725,0.105882,0.098039,0.090196,0.082353,0.082353,0.078431,0.07451,0.07451,0.070588,0.066667,0.066667,0.062745,0.062745,0.062745,0.058824,0.054902,0.058824,0.058824,0.062745,0.066667,0.066667,0.070588,0.078431,0.082353,0.086275,0.086275,0.086275,0.086275,0.098039,0.090196,0.078431,0.098039,0.137255,0.164706,0.180392,0.196078,0.207843,0.2,0.2,0.215686,0.231373,0.219608,0.2,0.172549,0.152941,0.164706,0.188235,0.176471,0.156863,0.160784,0.160784,0.137255,0.12549,0.12549,0.109804,0.090196,0.098039,0.109804,0.109804,0.141176,0.188235,0.25098,0.329412,0.388235,0.431373,0.47451,0.52549,0.580392,0.623529,0.662745,0.690196,0.705882,0.713726,0.72549,0.733333,0.741176,0.745098,0.745098,0.741176,0.729412,0.729412,0.741176,0.745098,0.721569,0.698039,0.709804,0.721569,0.721569,0.713726,0.705882,0.701961,0.698039,0.694118,0.686275,0.670588,0.654902,0.647059,0.627451,0.607843,0.584314,0.552941,0.533333,0.498039,0.466667,0.458824,0.45098,0.443137,0.435294,0.423529,0.407843,0.392157,0.384314,0.380392,0.376471,0.364706,0.317647,0.262745,0.223529,0.2,0.176471,0.14902,0.12549,0.121569,0.137255,0.141176,0.137255,0.12549,0.117647,0.109804,0.101961,0.086275,0.078431,0.07451,0.078431,0.078431,0.07451,0.070588,0.066667,0.062745,0.062745,0.062745,0.062745,0.062745,0.058824,0.054902,0.054902,0.058824,0.058824,0.062745,0.070588,0.07451,0.078431,0.078431,0.078431,0.070588,0.070588,0.078431,0.078431,0.090196,0.121569,0.145098,0.152941,0.164706,0.184314,0.203922,0.196078,0.180392,0.196078,0.207843,0.196078,0.192157,0.164706,0.121569,0.12549,0.168627,0.176471,0.14902,0.129412,0.137255,0.141176,0.121569,0.105882,0.090196,0.078431,0.082353,0.094118,0.105882,0.137255,0.188235,0.247059,0.305882,0.364706,0.411765,0.443137,0.490196,0.541176,0.580392,0.615686,0.647059,0.67451,0.698039,0.713726,0.717647,0.72549,0.729412,0.721569,0.709804,0.694118,0.701961,0.72549,0.72549,0.709804,0.690196,0.698039,0.709804,0.705882,0.690196,0.678431,0.682353,0.682353,0.67451,0.666667,0.658824,0.647059,0.631373,0.623529,0.611765,0.596078,0.576471,0.552941,0.521569,0.494118,0.486275,0.482353,0.478431,0.47451,0.462745,0.439216,0.411765,0.396078,0.396078,0.388235,0.345098,0.286275,0.235294,0.192157,0.168627,0.160784,0.152941,0.14902,0.14902,0.156863,0.152941,0.141176,0.12549,0.121569,0.113725,0.101961,0.086275,0.07451,0.070588,0.07451,0.07451,0.07451,0.070588,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.058824,0.05098,0.054902,0.054902,0.054902,0.058824,0.066667,0.070588,0.07451,0.070588,0.070588,0.07451,0.078431,0.090196,0.101961,0.121569,0.133333,0.137255,0.141176,0.152941,0.172549,0.196078,0.184314,0.168627,0.184314,0.2,0.184314,0.180392,0.168627,0.12549,0.105882,0.141176,0.156863,0.133333,0.109804,0.113725,0.133333,0.113725,0.086275,0.07451,0.07451,0.090196,0.105882,0.133333,0.164706,0.188235,0.219608,0.254902,0.301961,0.337255,0.368627,0.431373,0.490196,0.521569,0.564706,0.615686,0.658824,0.686275,0.694118,0.698039,0.709804,0.713726,0.705882,0.682353,0.666667,0.690196,0.709804,0.705882,0.694118,0.686275,0.690196,0.698039,0.690196,0.670588,0.65098,0.662745,0.670588,0.658824,0.643137,0.635294,0.639216,0.627451,0.611765,0.603922,0.6,0.584314,0.552941,0.529412,0.513726,0.501961,0.498039,0.501961,0.498039,0.47451,0.447059,0.427451,0.407843};
			return value;
		}
		private double[] getElevationGrid_4_24_height_13()
		{
			double[] value = {0.396078,0.364706,0.290196,0.235294,0.203922,0.176471,0.180392,0.188235,0.180392,0.176471,0.180392,0.176471,0.164706,0.145098,0.133333,0.12549,0.113725,0.101961,0.086275,0.078431,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.066667,0.066667,0.062745,0.062745,0.058824,0.058824,0.05098,0.05098,0.05098,0.05098,0.054902,0.058824,0.062745,0.062745,0.058824,0.062745,0.070588,0.078431,0.098039,0.117647,0.12549,0.12549,0.121569,0.129412,0.141176,0.160784,0.180392,0.168627,0.152941,0.172549,0.188235,0.176471,0.168627,0.168627,0.145098,0.113725,0.117647,0.129412,0.113725,0.094118,0.101961,0.121569,0.105882,0.078431,0.070588,0.078431,0.090196,0.109804,0.133333,0.145098,0.152941,0.172549,0.207843,0.25098,0.286275,0.333333,0.403922,0.458824,0.494118,0.54902,0.615686,0.65098,0.670588,0.678431,0.678431,0.690196,0.698039,0.690196,0.666667,0.662745,0.682353,0.694118,0.686275,0.678431,0.682353,0.682353,0.678431,0.678431,0.658824,0.635294,0.647059,0.65098,0.643137,0.627451,0.611765,0.623529,0.619608,0.588235,0.568627,0.580392,0.568627,0.533333,0.509804,0.501961,0.498039,0.498039,0.501961,0.498039,0.470588,0.447059,0.431373,0.427451,0.407843,0.356863,0.286275,0.227451,0.184314,0.180392,0.211765,0.231373,0.219608,0.207843,0.203922,0.192157,0.176471,0.160784,0.14902,0.137255,0.121569,0.105882,0.094118,0.086275,0.078431,0.070588,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.058824,0.058824,0.05098,0.05098,0.047059,0.047059,0.05098,0.05098,0.054902,0.054902,0.054902,0.058824,0.062745,0.07451,0.094118,0.109804,0.113725,0.109804,0.109804,0.117647,0.129412,0.14902,0.164706,0.14902,0.137255,0.152941,0.168627,0.160784,0.156863,0.156863,0.14902,0.12549,0.109804,0.105882,0.094118,0.082353,0.090196,0.101961,0.094118,0.082353,0.07451,0.082353,0.094118,0.101961,0.101961,0.105882,0.129412,0.160784,0.203922,0.254902,0.305882,0.356863,0.4,0.447059,0.501961,0.556863,0.6,0.623529,0.647059,0.654902,0.658824,0.670588,0.666667,0.654902,0.647059,0.658824,0.67451,0.67451,0.670588,0.666667,0.670588,0.666667,0.65098,0.643137,0.627451,0.607843,0.627451,0.631373,0.615686,0.603922,0.592157,0.603922,0.607843,0.572549,0.54902,0.552941,0.54902,0.52549,0.501961,0.482353,0.478431,0.490196,0.494118,0.490196,0.466667,0.447059,0.443137,0.435294,0.411765,0.364706,0.317647,0.266667,0.215686,0.219608,0.254902,0.262745,0.25098,0.235294,0.227451,0.215686,0.2,0.184314,0.168627,0.14902,0.133333,0.113725,0.098039,0.090196,0.082353,0.070588,0.066667,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.058824,0.058824,0.05098,0.05098,0.05098,0.054902,0.058824,0.058824,0.058824,0.062745,0.066667,0.066667,0.070588,0.082353,0.094118,0.098039,0.098039,0.098039,0.101961,0.109804,0.121569,0.133333,0.137255,0.133333,0.12549,0.145098,0.152941,0.141176,0.141176,0.141176,0.137255,0.129412,0.109804,0.098039,0.086275,0.078431,0.078431,0.078431,0.078431,0.07451,0.07451,0.082353,0.094118,0.094118,0.082353,0.094118,0.141176,0.184314,0.227451,0.286275,0.341176,0.376471,0.415686,0.47451,0.529412,0.556863,0.568627,0.588235,0.611765,0.627451,0.647059,0.643137,0.619608,0.615686,0.635294,0.654902,0.662745,0.658824,0.662745,0.658824,0.654902,0.647059,0.631373,0.611765,0.584314,0.568627,0.596078,0.615686,0.6,0.580392,0.576471,0.588235,0.596078,0.576471,0.54902,0.533333,0.529412,0.529412,0.517647,0.490196,0.470588,0.47451,0.482353,0.482353,0.462745,0.447059,0.439216,0.427451,0.396078,0.360784,0.329412,0.298039,0.270588,0.282353,0.298039,0.294118,0.282353,0.262745,0.247059,0.231373,0.211765,0.192157,0.172549,0.152941,0.137255,0.117647,0.098039,0.086275,0.078431,0.070588,0.066667,0.062745,0.058824,0.058824,0.058824,0.062745,0.062745,0.058824,0.058824,0.058824,0.054902,0.054902,0.054902,0.058824,0.058824,0.058824,0.058824,0.062745,0.070588,0.07451,0.078431,0.082353,0.090196,0.086275,0.082353,0.090196,0.098039,0.105882,0.109804,0.113725,0.117647,0.113725,0.121569,0.137255,0.141176,0.133333,0.121569,0.121569,0.121569,0.117647,0.105882,0.098039,0.090196,0.082353,0.07451,0.070588,0.070588,0.070588,0.07451,0.082353,0.086275,0.082353,0.082353,0.117647,0.176471,0.219608,0.266667,0.313726,0.341176,0.372549,0.439216,0.501961,0.52549,0.517647,0.52549,0.54902,0.580392,0.607843,0.619608,0.603922,0.592157,0.611765,0.635294,0.639216,0.643137,0.643137,0.643137,0.647059,0.639216,0.631373,0.619608,0.607843,0.576471,0.54902,0.576471,0.603922,0.596078,0.576471,0.568627,0.576471,0.580392,0.568627,0.552941,0.529412,0.513726,0.509804,0.513726,0.501961,0.478431,0.458824,0.462745,0.470588,0.462745,0.443137,0.427451,0.411765,0.388235,0.368627,0.352941,0.341176,0.329412,0.321569,0.317647,0.305882,0.290196,0.270588,0.239216,0.211765,0.192157,0.176471,0.152941,0.137255,0.12549,0.105882,0.090196,0.082353,0.07451,0.07451,0.070588,0.066667,0.058824,0.054902,0.054902,0.058824,0.058824,0.054902,0.054902,0.054902,0.054902,0.058824,0.058824,0.058824,0.054902,0.054902,0.054902,0.058824,0.066667,0.070588,0.07451,0.078431,0.082353,0.078431,0.07451,0.082353,0.094118,0.094118,0.094118,0.098039,0.098039,0.101961,0.117647,0.12549,0.129412,0.121569,0.113725,0.105882,0.105882,0.105882,0.098039,0.086275,0.078431,0.07451,0.070588,0.066667,0.066667,0.070588,0.070588,0.07451,0.07451,0.07451,0.090196,0.129412,0.168627,0.203922,0.239216,0.262745,0.282353,0.360784,0.447059,0.482353,0.482353,0.470588,0.478431,0.517647,0.568627,0.584314,0.564706,0.564706,0.596078,0.619608,0.619608,0.619608,0.623529,0.623529,0.627451,0.631373,0.627451,0.619608,0.603922,0.603922,0.576471,0.541176,0.568627,0.588235,0.576471,0.564706,0.560784,0.560784,0.556863,0.54902,0.541176,0.533333,0.509804,0.486275,0.486275,0.494118,0.486275,0.462745,0.447059,0.447059,0.45098,0.435294,0.419608,0.407843,0.388235,0.372549,0.364706,0.352941,0.345098,0.333333,0.313726,0.290196,0.27451,0.25098,0.219608,0.184314,0.164706,0.152941,0.137255,0.121569,0.105882,0.094118,0.082353,0.078431,0.07451,0.07451,0.070588,0.066667,0.062745,0.054902,0.054902,0.054902,0.054902,0.054902,0.05098,0.05098,0.054902,0.054902,0.054902,0.054902,0.05098,0.054902,0.058824,0.058824,0.062745,0.066667,0.070588,0.07451,0.078431,0.07451,0.070588,0.078431,0.082353,0.086275,0.086275,0.086275,0.086275,0.098039,0.113725,0.117647,0.113725,0.113725,0.101961,0.094118,0.094118,0.094118,0.090196,0.078431,0.066667,0.062745,0.062745,0.062745,0.066667,0.066667,0.062745,0.062745,0.070588,0.082353,0.105882,0.121569,0.137255,0.156863,0.184314,0.2,0.25098,0.34902,0.415686,0.419608,0.415686,0.423529,0.447059,0.501961,0.54902,0.545098,0.537255,0.564706,0.596078,0.596078,0.592157,0.596078,0.603922,0.607843,0.607843,0.607843,0.607843,0.6,0.588235,0.580392,0.552941,0.52549,0.556863,0.576471,0.556863,0.545098,0.54902,0.545098,0.533333,0.52549,0.521569,0.521569,0.509804,0.478431,0.462745,0.478431,0.482353,0.466667,0.443137,0.423529,0.431373,0.427451,0.407843,0.4,0.388235,0.364706,0.341176,0.321569,0.305882,0.298039,0.282353,0.262745,0.247059,0.227451,0.2,0.168627,0.14902,0.137255,0.129412,0.117647,0.101961,0.090196,0.082353,0.07451,0.07451,0.07451,0.070588,0.066667,0.062745,0.058824,0.054902,0.05098,0.05098,0.05098,0.05098,0.05098,0.05098,0.05098,0.05098,0.05098,0.05098,0.058824,0.062745,0.062745,0.066667,0.066667,0.066667,0.070588,0.070588,0.070588,0.066667,0.070588,0.078431,0.078431,0.078431,0.07451,0.07451,0.090196,0.101961,0.105882,0.101961,0.098039,0.094118,0.086275,0.082353,0.086275,0.082353,0.07451,0.066667,0.062745,0.058824,0.062745,0.062745,0.062745,0.058824,0.062745,0.070588,0.090196,0.109804,0.129412,0.156863,0.180392,0.203922,0.231373,0.278431,0.337255,0.356863,0.333333,0.329412,0.372549,0.435294,0.490196,0.505882,0.513726,0.545098,0.576471,0.568627,0.54902,0.560784,0.576471,0.576471,0.576471,0.580392,0.576471,0.576471,0.576471,0.576471,0.572549,0.545098,0.521569,0.537255,0.556863,0.545098,0.529412,0.529412,0.529412,0.513726,0.501961,0.505882,0.505882,0.501961,0.478431,0.454902,0.458824,0.466667,0.458824,0.435294,0.407843,0.407843,0.407843,0.388235,0.372549,0.360784,0.341176,0.321569,0.305882,0.282353,0.266667,0.254902,0.239216,0.227451,0.207843,0.184314,0.156863,0.129412,0.113725,0.113725,0.109804,0.098039,0.086275,0.082353,0.07451,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.054902,0.05098,0.054902,0.05098,0.05098,0.05098,0.05098,0.05098,0.05098,0.054902,0.058824,0.062745,0.062745,0.066667,0.066667,0.062745,0.062745,0.066667,0.066667,0.062745,0.066667,0.07451,0.07451,0.070588,0.070588,0.07451,0.082353,0.094118,0.098039,0.094118,0.090196,0.086275,0.078431,0.07451,0.07451,0.07451,0.070588,0.066667,0.062745,0.058824,0.058824,0.058824,0.058824,0.058824,0.062745,0.070588,0.082353,0.098039,0.129412,0.160784,0.192157,0.223529,0.239216,0.254902,0.27451,0.27451,0.262745,0.290196,0.356863,0.427451,0.458824,0.47451,0.513726,0.556863,0.564706,0.541176,0.509804,0.521569,0.552941,0.545098,0.533333,0.541176,0.541176,0.54902,0.556863,0.556863,0.560784};
			return value;
		}
		private double[] getElevationGrid_4_24_height_14()
		{
			double[] value = {0.552941,0.529412,0.513726,0.517647,0.529412,0.521569,0.509804,0.509804,0.498039,0.482353,0.490196,0.490196,0.482353,0.47451,0.454902,0.439216,0.439216,0.443137,0.427451,0.4,0.388235,0.384314,0.368627,0.352941,0.337255,0.313726,0.294118,0.290196,0.290196,0.27451,0.254902,0.231373,0.203922,0.188235,0.172549,0.14902,0.117647,0.098039,0.094118,0.094118,0.090196,0.082353,0.078431,0.07451,0.070588,0.062745,0.062745,0.062745,0.062745,0.058824,0.058824,0.054902,0.05098,0.05098,0.05098,0.047059,0.047059,0.05098,0.05098,0.054902,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.058824,0.062745,0.062745,0.062745,0.062745,0.066667,0.070588,0.066667,0.066667,0.070588,0.078431,0.082353,0.086275,0.090196,0.090196,0.086275,0.082353,0.07451,0.070588,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.054902,0.054902,0.058824,0.058824,0.058824,0.066667,0.070588,0.078431,0.101961,0.12549,0.152941,0.184314,0.184314,0.172549,0.184314,0.223529,0.278431,0.329412,0.376471,0.407843,0.427451,0.466667,0.513726,0.533333,0.537255,0.537255,0.505882,0.478431,0.494118,0.501961,0.498039,0.501961,0.498039,0.513726,0.533333,0.533333,0.541176,0.541176,0.52549,0.498039,0.478431,0.498039,0.509804,0.494118,0.486275,0.47451,0.458824,0.470588,0.482353,0.470588,0.454902,0.443137,0.431373,0.419608,0.419608,0.419608,0.407843,0.388235,0.372549,0.364706,0.352941,0.341176,0.317647,0.286275,0.27451,0.27451,0.262745,0.243137,0.211765,0.180392,0.156863,0.141176,0.117647,0.094118,0.082353,0.078431,0.07451,0.082353,0.078431,0.07451,0.070588,0.070588,0.062745,0.058824,0.058824,0.058824,0.058824,0.054902,0.054902,0.05098,0.05098,0.05098,0.047059,0.047059,0.05098,0.05098,0.05098,0.05098,0.05098,0.05098,0.054902,0.058824,0.054902,0.054902,0.058824,0.058824,0.058824,0.062745,0.066667,0.066667,0.062745,0.066667,0.070588,0.07451,0.078431,0.082353,0.082353,0.078431,0.078431,0.07451,0.070588,0.066667,0.062745,0.062745,0.062745,0.062745,0.062745,0.058824,0.054902,0.054902,0.054902,0.058824,0.062745,0.062745,0.062745,0.066667,0.078431,0.094118,0.117647,0.137255,0.133333,0.12549,0.14902,0.207843,0.282353,0.329412,0.356863,0.384314,0.419608,0.443137,0.458824,0.478431,0.498039,0.52549,0.521569,0.47451,0.435294,0.431373,0.45098,0.454902,0.431373,0.454902,0.490196,0.501961,0.513726,0.513726,0.498039,0.462745,0.435294,0.466667,0.486275,0.478431,0.470588,0.45098,0.435294,0.45098,0.466667,0.458824,0.439216,0.419608,0.415686,0.403922,0.392157,0.392157,0.396078,0.384314,0.364706,0.360784,0.352941,0.337255,0.313726,0.282353,0.258824,0.247059,0.235294,0.211765,0.184314,0.156863,0.133333,0.113725,0.094118,0.078431,0.070588,0.066667,0.062745,0.070588,0.07451,0.070588,0.066667,0.066667,0.062745,0.058824,0.054902,0.054902,0.058824,0.058824,0.054902,0.05098,0.05098,0.05098,0.047059,0.047059,0.043137,0.039216,0.043137,0.043137,0.043137,0.047059,0.05098,0.054902,0.05098,0.054902,0.054902,0.054902,0.058824,0.062745,0.062745,0.062745,0.058824,0.062745,0.066667,0.066667,0.070588,0.07451,0.07451,0.070588,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.062745,0.066667,0.066667,0.070588,0.078431,0.090196,0.101961,0.117647,0.117647,0.129412,0.152941,0.176471,0.211765,0.258824,0.301961,0.34902,0.392157,0.407843,0.388235,0.392157,0.423529,0.462745,0.501961,0.505882,0.47451,0.419608,0.368627,0.376471,0.380392,0.345098,0.376471,0.435294,0.458824,0.47451,0.47451,0.435294,0.384314,0.384314,0.439216,0.462745,0.45098,0.454902,0.439216,0.423529,0.435294,0.447059,0.443137,0.431373,0.411765,0.392157,0.380392,0.372549,0.364706,0.368627,0.368627,0.356863,0.341176,0.337255,0.32549,0.294118,0.258824,0.235294,0.239216,0.231373,0.203922,0.184314,0.164706,0.141176,0.121569,0.109804,0.098039,0.086275,0.07451,0.062745,0.058824,0.062745,0.062745,0.062745,0.058824,0.062745,0.062745,0.054902,0.05098,0.05098,0.054902,0.054902,0.054902,0.05098,0.047059,0.047059,0.043137,0.031373,0.031373,0.039216,0.047059,0.047059,0.05098,0.054902,0.054902,0.054902,0.054902,0.058824,0.058824,0.062745,0.062745,0.062745,0.062745,0.058824,0.062745,0.062745,0.062745,0.066667,0.07451,0.07451,0.070588,0.066667,0.062745,0.062745,0.062745,0.062745,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.066667,0.070588,0.078431,0.086275,0.094118,0.105882,0.12549,0.137255,0.145098,0.164706,0.192157,0.211765,0.231373,0.270588,0.32549,0.376471,0.388235,0.356863,0.34902,0.376471,0.407843,0.45098,0.47451,0.458824,0.431373,0.4,0.337255,0.305882,0.301961,0.282353,0.341176,0.403922,0.415686,0.431373,0.427451,0.368627,0.298039,0.317647,0.4,0.427451,0.423529,0.435294,0.427451,0.411765,0.427451,0.435294,0.427451,0.415686,0.403922,0.380392,0.352941,0.34902,0.34902,0.341176,0.337255,0.329412,0.305882,0.305882,0.309804,0.290196,0.25098,0.215686,0.211765,0.207843,0.180392,0.176471,0.172549,0.152941,0.129412,0.117647,0.105882,0.098039,0.082353,0.070588,0.054902,0.05098,0.054902,0.058824,0.054902,0.058824,0.062745,0.058824,0.05098,0.047059,0.047059,0.05098,0.05098,0.05098,0.047059,0.047059,0.035294,0.035294,0.039216,0.047059,0.05098,0.054902,0.058824,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.062745,0.058824,0.062745,0.062745,0.062745,0.062745,0.066667,0.070588,0.07451,0.07451,0.07451,0.066667,0.058824,0.058824,0.062745,0.062745,0.058824,0.058824,0.058824,0.062745,0.058824,0.058824,0.062745,0.066667,0.070588,0.078431,0.086275,0.094118,0.101961,0.105882,0.12549,0.145098,0.160784,0.172549,0.188235,0.211765,0.247059,0.286275,0.337255,0.368627,0.341176,0.309804,0.333333,0.368627,0.4,0.435294,0.443137,0.415686,0.376471,0.341176,0.286275,0.235294,0.219608,0.231373,0.301961,0.364706,0.384314,0.392157,0.380392,0.345098,0.270588,0.266667,0.345098,0.380392,0.388235,0.407843,0.411765,0.4,0.411765,0.423529,0.415686,0.4,0.384314,0.372549,0.34902,0.32549,0.317647,0.317647,0.305882,0.282353,0.262745,0.27451,0.294118,0.282353,0.25098,0.207843,0.184314,0.172549,0.156863,0.14902,0.145098,0.141176,0.12549,0.109804,0.098039,0.090196,0.082353,0.07451,0.066667,0.058824,0.054902,0.05098,0.054902,0.058824,0.058824,0.058824,0.054902,0.047059,0.043137,0.047059,0.05098,0.05098,0.047059,0.047059,0.039216,0.047059,0.047059,0.05098,0.05098,0.054902,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.058824,0.058824,0.062745,0.062745,0.066667,0.070588,0.070588,0.07451,0.07451,0.07451,0.066667,0.062745,0.062745,0.062745,0.062745,0.058824,0.058824,0.062745,0.062745,0.058824,0.058824,0.062745,0.066667,0.07451,0.078431,0.086275,0.090196,0.094118,0.098039,0.109804,0.129412,0.141176,0.152941,0.168627,0.203922,0.25098,0.286275,0.313726,0.313726,0.286275,0.290196,0.321569,0.352941,0.392157,0.407843,0.392157,0.384314,0.34902,0.282353,0.219608,0.164706,0.14902,0.196078,0.270588,0.32549,0.352941,0.345098,0.333333,0.333333,0.294118,0.247059,0.278431,0.32549,0.352941,0.388235,0.396078,0.388235,0.4,0.411765,0.403922,0.388235,0.372549,0.360784,0.34902,0.321569,0.294118,0.290196,0.290196,0.25098,0.227451,0.25098,0.262745,0.25098,0.239216,0.219608,0.196078,0.180392,0.160784,0.141176,0.12549,0.117647,0.113725,0.105882,0.094118,0.086275,0.082353,0.07451,0.066667,0.062745,0.05098,0.047059,0.054902,0.058824,0.058824,0.054902,0.054902,0.05098,0.043137,0.039216,0.043137,0.043137,0.043137,0.039216,0.043137,0.047059,0.047059,0.05098,0.05098,0.054902,0.054902,0.058824,0.058824,0.058824,0.054902,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.066667,0.070588,0.070588,0.07451,0.070588,0.070588,0.066667,0.066667,0.066667,0.062745,0.062745,0.058824,0.062745,0.062745,0.062745,0.058824,0.062745,0.066667,0.070588,0.078431,0.078431,0.078431,0.082353,0.090196,0.101961,0.105882,0.117647,0.133333,0.156863,0.196078,0.235294,0.262745,0.262745,0.243137,0.243137,0.270588,0.305882,0.345098,0.376471,0.356863,0.321569,0.32549,0.317647,0.258824,0.192157,0.137255,0.129412,0.192157,0.258824,0.286275,0.305882,0.290196,0.270588,0.294118,0.282353,0.231373,0.243137,0.294118,0.341176,0.372549,0.376471,0.384314,0.392157,0.388235,0.380392,0.364706,0.356863,0.34902,0.341176,0.329412,0.294118,0.266667,0.266667,0.247059,0.215686,0.223529,0.227451,0.211765,0.211765,0.215686,0.203922,0.188235,0.164706,0.141176,0.121569,0.105882,0.098039,0.098039,0.094118,0.086275,0.078431,0.070588,0.062745,0.054902,0.047059,0.043137,0.05098,0.058824,0.054902,0.05098,0.05098,0.054902,0.047059,0.039216,0.035294,0.035294,0.031373,0.031373,0.039216,0.043137,0.043137,0.047059,0.05098,0.05098,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.066667,0.070588,0.070588,0.070588,0.070588,0.066667,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.062745,0.058824,0.062745,0.066667,0.066667,0.070588,0.070588,0.07451,0.082353,0.094118,0.098039,0.105882,0.117647,0.137255};
			return value;
		}
		private double[] getElevationGrid_4_24_height_15()
		{
			double[] value = {0.160784,0.184314,0.207843,0.219608,0.207843,0.2,0.215686,0.247059,0.286275,0.32549,0.341176,0.305882,0.266667,0.266667,0.270588,0.243137,0.192157,0.137255,0.121569,0.176471,0.223529,0.239216,0.254902,0.239216,0.219608,0.247059,0.247059,0.215686,0.25098,0.305882,0.337255,0.356863,0.360784,0.372549,0.372549,0.360784,0.345098,0.329412,0.329412,0.333333,0.32549,0.313726,0.298039,0.262745,0.235294,0.231373,0.215686,0.196078,0.188235,0.184314,0.184314,0.188235,0.188235,0.176471,0.152941,0.129412,0.113725,0.098039,0.082353,0.078431,0.086275,0.082353,0.07451,0.066667,0.062745,0.058824,0.05098,0.043137,0.047059,0.05098,0.05098,0.05098,0.05098,0.05098,0.047059,0.039216,0.031373,0.031373,0.035294,0.035294,0.039216,0.043137,0.043137,0.047059,0.05098,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.05098,0.054902,0.054902,0.054902,0.054902,0.058824,0.058824,0.058824,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.058824,0.062745,0.066667,0.066667,0.066667,0.066667,0.07451,0.082353,0.090196,0.098039,0.109804,0.129412,0.145098,0.160784,0.172549,0.180392,0.176471,0.172549,0.184314,0.207843,0.235294,0.262745,0.290196,0.305882,0.270588,0.235294,0.227451,0.227451,0.223529,0.203922,0.152941,0.113725,0.133333,0.164706,0.188235,0.207843,0.196078,0.180392,0.207843,0.203922,0.196078,0.25098,0.294118,0.317647,0.337255,0.345098,0.352941,0.34902,0.337255,0.313726,0.290196,0.298039,0.309804,0.313726,0.298039,0.282353,0.262745,0.227451,0.2,0.196078,0.184314,0.164706,0.156863,0.156863,0.160784,0.172549,0.164706,0.145098,0.12549,0.109804,0.094118,0.07451,0.066667,0.070588,0.07451,0.070588,0.066667,0.062745,0.062745,0.058824,0.054902,0.047059,0.043137,0.05098,0.05098,0.05098,0.047059,0.047059,0.043137,0.043137,0.043137,0.043137,0.043137,0.039216,0.039216,0.043137,0.047059,0.05098,0.05098,0.05098,0.054902,0.054902,0.05098,0.05098,0.05098,0.054902,0.054902,0.054902,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.066667,0.066667,0.062745,0.062745,0.066667,0.066667,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.058824,0.062745,0.066667,0.066667,0.066667,0.070588,0.078431,0.082353,0.086275,0.098039,0.109804,0.12549,0.137255,0.152941,0.152941,0.141176,0.137255,0.14902,0.164706,0.188235,0.211765,0.227451,0.25098,0.270588,0.243137,0.207843,0.203922,0.2,0.196078,0.192157,0.160784,0.117647,0.098039,0.113725,0.141176,0.168627,0.156863,0.137255,0.152941,0.156863,0.176471,0.231373,0.266667,0.294118,0.313726,0.321569,0.321569,0.32549,0.317647,0.282353,0.25098,0.266667,0.286275,0.298039,0.290196,0.258824,0.243137,0.223529,0.192157,0.164706,0.160784,0.152941,0.133333,0.12549,0.141176,0.14902,0.14902,0.141176,0.12549,0.105882,0.090196,0.07451,0.062745,0.062745,0.066667,0.066667,0.062745,0.058824,0.054902,0.058824,0.054902,0.047059,0.039216,0.043137,0.05098,0.05098,0.05098,0.047059,0.047059,0.047059,0.047059,0.043137,0.039216,0.035294,0.039216,0.043137,0.047059,0.047059,0.047059,0.05098,0.05098,0.05098,0.05098,0.05098,0.054902,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.066667,0.066667,0.070588,0.07451,0.078431,0.078431,0.086275,0.098039,0.109804,0.121569,0.129412,0.133333,0.12549,0.113725,0.117647,0.129412,0.137255,0.156863,0.176471,0.192157,0.223529,0.247059,0.223529,0.192157,0.180392,0.180392,0.176471,0.172549,0.156863,0.129412,0.101961,0.090196,0.113725,0.141176,0.129412,0.098039,0.101961,0.133333,0.184314,0.223529,0.254902,0.278431,0.286275,0.290196,0.294118,0.294118,0.294118,0.266667,0.231373,0.223529,0.247059,0.27451,0.270588,0.25098,0.223529,0.2,0.184314,0.156863,0.133333,0.133333,0.121569,0.109804,0.113725,0.117647,0.12549,0.133333,0.12549,0.105882,0.090196,0.078431,0.07451,0.066667,0.058824,0.058824,0.062745,0.054902,0.05098,0.054902,0.054902,0.047059,0.043137,0.039216,0.043137,0.047059,0.047059,0.047059,0.047059,0.047059,0.043137,0.039216,0.039216,0.035294,0.035294,0.031373,0.035294,0.035294,0.035294,0.035294,0.039216,0.043137,0.047059,0.05098,0.054902,0.054902,0.058824,0.058824,0.058824,0.054902,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.062745,0.062745,0.058824,0.058824,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.070588,0.07451,0.07451,0.078431,0.086275,0.098039,0.109804,0.113725,0.117647,0.109804,0.105882,0.105882,0.105882,0.105882,0.12549,0.137255,0.145098,0.168627,0.203922,0.223529,0.211765,0.180392,0.160784,0.160784,0.160784,0.156863,0.145098,0.133333,0.105882,0.086275,0.098039,0.113725,0.105882,0.094118,0.109804,0.14902,0.196078,0.223529,0.239216,0.25098,0.258824,0.266667,0.266667,0.258824,0.262745,0.254902,0.223529,0.188235,0.2,0.239216,0.243137,0.235294,0.215686,0.180392,0.164706,0.14902,0.129412,0.109804,0.105882,0.101961,0.090196,0.086275,0.101961,0.117647,0.113725,0.098039,0.086275,0.078431,0.07451,0.070588,0.058824,0.054902,0.054902,0.054902,0.047059,0.047059,0.05098,0.05098,0.047059,0.043137,0.039216,0.039216,0.043137,0.043137,0.043137,0.043137,0.043137,0.043137,0.039216,0.023529,0.023529,0.023529,0.027451,0.027451,0.027451,0.027451,0.035294,0.043137,0.047059,0.05098,0.05098,0.054902,0.054902,0.054902,0.054902,0.054902,0.058824,0.062745,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.054902,0.054902,0.058824,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.070588,0.070588,0.070588,0.078431,0.086275,0.098039,0.101961,0.098039,0.094118,0.090196,0.098039,0.098039,0.086275,0.098039,0.113725,0.109804,0.117647,0.145098,0.176471,0.203922,0.203922,0.176471,0.14902,0.141176,0.137255,0.137255,0.133333,0.121569,0.098039,0.078431,0.082353,0.086275,0.090196,0.109804,0.141176,0.172549,0.2,0.211765,0.215686,0.223529,0.235294,0.243137,0.235294,0.223529,0.223529,0.223529,0.207843,0.172549,0.160784,0.188235,0.203922,0.203922,0.188235,0.164706,0.145098,0.133333,0.12549,0.105882,0.090196,0.082353,0.07451,0.062745,0.078431,0.101961,0.101961,0.090196,0.078431,0.07451,0.070588,0.066667,0.058824,0.05098,0.05098,0.05098,0.047059,0.047059,0.05098,0.05098,0.05098,0.047059,0.043137,0.039216,0.039216,0.039216,0.039216,0.039216,0.043137,0.043137,0.043137,0.015686,0.019608,0.031373,0.035294,0.035294,0.039216,0.035294,0.039216,0.043137,0.047059,0.047059,0.05098,0.054902,0.054902,0.054902,0.054902,0.054902,0.058824,0.062745,0.058824,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.058824,0.054902,0.058824,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.070588,0.070588,0.078431,0.082353,0.090196,0.090196,0.082353,0.078431,0.086275,0.094118,0.086275,0.07451,0.086275,0.098039,0.090196,0.105882,0.129412,0.152941,0.184314,0.192157,0.168627,0.145098,0.129412,0.117647,0.117647,0.117647,0.109804,0.090196,0.070588,0.070588,0.07451,0.090196,0.117647,0.145098,0.164706,0.184314,0.188235,0.188235,0.2,0.211765,0.215686,0.203922,0.188235,0.188235,0.188235,0.184314,0.176471,0.14902,0.133333,0.141176,0.152941,0.145098,0.137255,0.129412,0.117647,0.109804,0.101961,0.086275,0.070588,0.058824,0.054902,0.07451,0.094118,0.094118,0.082353,0.078431,0.07451,0.070588,0.062745,0.054902,0.047059,0.043137,0.043137,0.043137,0.043137,0.047059,0.05098,0.047059,0.047059,0.043137,0.039216,0.039216,0.039216,0.035294,0.035294,0.039216,0.039216,0.039216,0.023529,0.027451,0.035294,0.043137,0.043137,0.043137,0.039216,0.039216,0.043137,0.047059,0.047059,0.043137,0.047059,0.05098,0.05098,0.05098,0.054902,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.058824,0.062745,0.062745,0.058824,0.054902,0.058824,0.062745,0.066667,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.070588,0.070588,0.07451,0.078431,0.082353,0.082353,0.070588,0.078431,0.086275,0.090196,0.082353,0.066667,0.070588,0.082353,0.094118,0.113725,0.121569,0.133333,0.160784,0.180392,0.160784,0.137255,0.121569,0.105882,0.098039,0.098039,0.094118,0.078431,0.066667,0.070588,0.082353,0.094118,0.113725,0.129412,0.145098,0.156863,0.164706,0.164706,0.176471,0.188235,0.184314,0.172549,0.160784,0.156863,0.14902,0.14902,0.152941,0.145098,0.117647,0.101961,0.109804,0.117647,0.113725,0.109804,0.101961,0.094118,0.090196,0.082353,0.070588,0.058824,0.054902,0.07451,0.090196,0.090196,0.082353,0.078431,0.07451,0.070588,0.062745,0.054902,0.05098,0.043137,0.043137,0.043137,0.043137,0.043137,0.047059,0.047059,0.047059,0.043137,0.043137,0.039216,0.039216,0.035294,0.035294,0.039216,0.039216,0.039216,0.031373,0.031373,0.035294,0.039216,0.043137,0.039216,0.039216,0.039216,0.047059,0.047059,0.043137,0.039216,0.043137,0.047059,0.047059,0.05098,0.054902,0.058824,0.058824,0.058824,0.058824,0.058824,0.062745,0.058824};
			return value;
		}
		private double[] getElevationGrid_4_24_height_16()
		{
			double[] value = {0.058824,0.062745,0.062745,0.058824,0.054902,0.058824,0.066667,0.066667,0.062745,0.058824,0.062745,0.066667,0.066667,0.062745,0.062745,0.066667,0.070588,0.070588,0.07451,0.078431,0.078431,0.07451,0.070588,0.078431,0.086275,0.082353,0.07451,0.066667,0.07451,0.090196,0.105882,0.117647,0.109804,0.101961,0.129412,0.160784,0.152941,0.129412,0.113725,0.098039,0.086275,0.082353,0.082353,0.07451,0.066667,0.070588,0.082353,0.098039,0.101961,0.105882,0.121569,0.133333,0.141176,0.145098,0.152941,0.164706,0.160784,0.14902,0.133333,0.129412,0.12549,0.113725,0.113725,0.121569,0.12549,0.109804,0.090196,0.094118,0.098039,0.090196,0.086275,0.082353,0.078431,0.07451,0.07451,0.066667,0.054902,0.070588,0.082353,0.078431,0.078431,0.078431,0.07451,0.070588,0.062745,0.054902,0.05098,0.047059,0.047059,0.05098,0.047059,0.043137,0.043137,0.047059,0.047059,0.047059,0.043137,0.043137,0.039216,0.039216,0.035294,0.035294,0.035294,0.035294,0.031373,0.035294,0.035294,0.039216,0.039216,0.039216,0.035294,0.039216,0.043137,0.047059,0.043137,0.035294,0.039216,0.047059,0.05098,0.05098,0.05098,0.054902,0.058824,0.058824,0.058824,0.058824,0.058824,0.054902,0.058824,0.062745,0.062745,0.058824,0.054902,0.058824,0.066667,0.066667,0.062745,0.062745,0.062745,0.066667,0.066667,0.062745,0.062745,0.066667,0.070588,0.070588,0.07451,0.07451,0.07451,0.070588,0.066667,0.070588,0.07451,0.07451,0.070588,0.066667,0.078431,0.098039,0.109804,0.109804,0.098039,0.086275,0.105882,0.133333,0.129412,0.121569,0.113725,0.105882,0.094118,0.082353,0.07451,0.070588,0.066667,0.066667,0.078431,0.090196,0.090196,0.086275,0.094118,0.109804,0.121569,0.129412,0.137255,0.141176,0.133333,0.129412,0.117647,0.109804,0.109804,0.098039,0.082353,0.094118,0.113725,0.113725,0.094118,0.07451,0.078431,0.082353,0.07451,0.070588,0.070588,0.066667,0.066667,0.058824,0.05098,0.058824,0.070588,0.070588,0.07451,0.07451,0.070588,0.066667,0.058824,0.054902,0.05098,0.05098,0.05098,0.05098,0.047059,0.043137,0.039216,0.043137,0.043137,0.043137,0.043137,0.043137,0.043137,0.039216,0.035294,0.031373,0.031373,0.035294,0.031373,0.035294,0.035294,0.035294,0.035294,0.035294,0.035294,0.039216,0.043137,0.047059,0.039216,0.035294,0.043137,0.05098,0.05098,0.05098,0.05098,0.054902,0.054902,0.054902,0.054902,0.058824,0.054902,0.054902,0.058824,0.058824,0.054902,0.054902,0.058824,0.062745,0.066667,0.062745,0.062745,0.062745,0.062745,0.062745,0.066667,0.062745,0.062745,0.062745,0.070588,0.070588,0.070588,0.070588,0.070588,0.070588,0.066667,0.062745,0.062745,0.066667,0.066667,0.070588,0.082353,0.098039,0.101961,0.101961,0.090196,0.078431,0.086275,0.105882,0.105882,0.105882,0.105882,0.109804,0.101961,0.090196,0.070588,0.058824,0.058824,0.062745,0.070588,0.082353,0.082353,0.07451,0.082353,0.094118,0.105882,0.117647,0.12549,0.117647,0.113725,0.109804,0.105882,0.098039,0.094118,0.082353,0.066667,0.070588,0.090196,0.098039,0.094118,0.078431,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.058824,0.05098,0.043137,0.054902,0.066667,0.066667,0.070588,0.070588,0.070588,0.066667,0.062745,0.058824,0.054902,0.054902,0.054902,0.05098,0.05098,0.047059,0.043137,0.043137,0.043137,0.039216,0.039216,0.039216,0.039216,0.039216,0.035294,0.027451,0.027451,0.027451,0.035294,0.035294,0.035294,0.035294,0.035294,0.039216,0.039216,0.039216,0.043137,0.039216,0.031373,0.031373,0.043137,0.047059,0.05098,0.05098,0.05098,0.054902,0.05098,0.047059,0.05098,0.054902,0.05098,0.05098,0.054902,0.058824,0.054902,0.054902,0.062745,0.062745,0.062745,0.062745,0.062745,0.058824,0.058824,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.062745,0.066667,0.062745,0.054902,0.054902,0.058824,0.058824,0.070588,0.078431,0.090196,0.094118,0.090196,0.082353,0.07451,0.078431,0.086275,0.090196,0.090196,0.094118,0.101961,0.098039,0.086275,0.070588,0.058824,0.054902,0.058824,0.066667,0.07451,0.07451,0.070588,0.07451,0.086275,0.098039,0.105882,0.109804,0.105882,0.098039,0.094118,0.094118,0.090196,0.086275,0.070588,0.058824,0.062745,0.078431,0.082353,0.082353,0.078431,0.066667,0.058824,0.062745,0.062745,0.062745,0.058824,0.054902,0.05098,0.047059,0.054902,0.066667,0.066667,0.062745,0.066667,0.066667,0.066667,0.062745,0.058824,0.058824,0.054902,0.054902,0.05098,0.05098,0.047059,0.047059,0.043137,0.043137,0.039216,0.039216,0.035294,0.039216,0.039216,0.031373,0.027451,0.023529,0.019608,0.035294,0.035294,0.035294,0.035294,0.039216,0.039216,0.039216,0.039216,0.039216,0.031373,0.027451,0.031373,0.039216,0.043137,0.047059,0.05098,0.05098,0.047059,0.043137,0.043137,0.047059,0.05098,0.05098,0.054902,0.058824,0.054902,0.054902,0.058824,0.062745,0.062745,0.062745,0.062745,0.058824,0.058824,0.058824,0.058824,0.062745,0.066667,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.058824,0.054902,0.054902,0.054902,0.054902,0.058824,0.058824,0.062745,0.07451,0.082353,0.086275,0.082353,0.07451,0.07451,0.07451,0.07451,0.07451,0.086275,0.094118,0.094118,0.090196,0.082353,0.070588,0.062745,0.058824,0.054902,0.062745,0.070588,0.066667,0.066667,0.070588,0.078431,0.086275,0.094118,0.098039,0.094118,0.086275,0.078431,0.078431,0.078431,0.078431,0.070588,0.058824,0.058824,0.070588,0.07451,0.07451,0.07451,0.070588,0.062745,0.054902,0.058824,0.058824,0.054902,0.05098,0.05098,0.047059,0.054902,0.062745,0.062745,0.058824,0.062745,0.062745,0.062745,0.058824,0.058824,0.054902,0.054902,0.05098,0.05098,0.047059,0.047059,0.047059,0.043137,0.043137,0.039216,0.035294,0.031373,0.035294,0.035294,0.035294,0.031373,0.023529,0.015686,0.031373,0.031373,0.031373,0.035294,0.035294,0.035294,0.039216,0.039216,0.035294,0.031373,0.031373,0.031373,0.035294,0.043137,0.047059,0.047059,0.047059,0.043137,0.043137,0.047059,0.047059,0.047059,0.05098,0.054902,0.058824,0.054902,0.054902,0.058824,0.062745,0.062745,0.062745,0.062745,0.058824,0.058824,0.054902,0.058824,0.062745,0.066667,0.066667,0.062745,0.058824,0.058824,0.062745,0.066667,0.058824,0.054902,0.054902,0.058824,0.058824,0.058824,0.058824,0.062745,0.07451,0.078431,0.078431,0.07451,0.070588,0.070588,0.07451,0.070588,0.070588,0.078431,0.090196,0.086275,0.082353,0.078431,0.07451,0.070588,0.062745,0.054902,0.062745,0.066667,0.066667,0.062745,0.066667,0.07451,0.082353,0.090196,0.090196,0.086275,0.082353,0.07451,0.070588,0.070588,0.070588,0.066667,0.058824,0.062745,0.066667,0.066667,0.070588,0.070588,0.066667,0.066667,0.058824,0.054902,0.054902,0.054902,0.05098,0.05098,0.047059,0.054902,0.058824,0.058824,0.058824,0.058824,0.062745,0.058824,0.054902,0.054902,0.054902,0.05098,0.05098,0.047059,0.047059,0.043137,0.043137,0.043137,0.039216,0.035294,0.031373,0.031373,0.031373,0.031373,0.031373,0.031373,0.031373,0.023529,0.027451,0.027451,0.027451,0.031373,0.031373,0.035294,0.039216,0.039216,0.031373,0.027451,0.027451,0.031373,0.039216,0.047059,0.047059,0.043137,0.047059,0.047059,0.05098,0.05098,0.05098,0.05098,0.054902,0.054902,0.054902,0.054902,0.054902,0.058824,0.062745,0.062745,0.062745,0.062745,0.058824,0.054902,0.05098,0.054902,0.062745,0.066667,0.066667,0.062745,0.058824,0.058824,0.062745,0.062745,0.062745,0.058824,0.054902,0.058824,0.058824,0.054902,0.054902,0.058824,0.070588,0.078431,0.07451,0.066667,0.066667,0.070588,0.070588,0.070588,0.066667,0.07451,0.082353,0.082353,0.078431,0.07451,0.070588,0.070588,0.062745,0.054902,0.058824,0.066667,0.066667,0.062745,0.070588,0.07451,0.082353,0.086275,0.086275,0.082353,0.078431,0.07451,0.066667,0.062745,0.066667,0.062745,0.058824,0.058824,0.062745,0.062745,0.066667,0.066667,0.062745,0.066667,0.062745,0.054902,0.05098,0.05098,0.05098,0.047059,0.043137,0.05098,0.058824,0.058824,0.054902,0.058824,0.058824,0.058824,0.054902,0.05098,0.05098,0.05098,0.047059,0.047059,0.043137,0.043137,0.043137,0.043137,0.039216,0.039216,0.035294,0.035294,0.035294,0.031373,0.031373,0.031373,0.031373,0.031373,0.023529,0.023529,0.023529,0.027451,0.031373,0.035294,0.035294,0.035294,0.031373,0.027451,0.027451,0.031373,0.043137,0.047059,0.043137,0.043137,0.047059,0.05098,0.05098,0.05098,0.05098,0.054902,0.054902,0.054902,0.054902,0.05098,0.054902,0.058824,0.062745,0.062745,0.062745,0.058824,0.058824,0.05098,0.05098,0.054902,0.062745,0.062745,0.062745,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.058824,0.054902,0.058824,0.058824,0.054902,0.058824,0.058824,0.066667,0.070588,0.070588,0.062745,0.066667,0.066667,0.066667,0.066667,0.062745,0.066667,0.07451,0.078431,0.078431,0.070588,0.066667,0.066667,0.062745,0.054902,0.058824,0.066667,0.066667,0.062745,0.066667,0.07451,0.078431,0.078431,0.078431,0.078431,0.078431,0.07451,0.066667,0.062745,0.062745,0.058824,0.054902,0.058824,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.062745,0.058824,0.05098,0.047059,0.047059,0.047059,0.043137,0.047059,0.054902,0.054902,0.054902,0.054902,0.058824,0.054902,0.05098,0.047059,0.047059,0.047059,0.047059,0.043137,0.039216,0.039216,0.039216,0.039216,0.039216,0.039216,0.039216,0.035294,0.035294,0.035294,0.031373,0.031373,0.031373,0.031373};
			return value;
		}
		private double[] getElevationGrid_4_24_height_17()
		{
			double[] value = {0.019608,0.023529,0.027451,0.027451,0.031373,0.035294,0.031373,0.027451,0.027451,0.027451,0.035294,0.039216,0.043137,0.047059,0.043137,0.039216,0.043137,0.047059,0.05098,0.05098,0.05098,0.05098,0.054902,0.05098,0.05098,0.05098,0.054902,0.058824,0.062745,0.062745,0.058824,0.058824,0.054902,0.05098,0.05098,0.058824,0.062745,0.062745,0.058824,0.058824,0.058824,0.062745,0.062745,0.062745,0.062745,0.058824,0.054902,0.054902,0.058824,0.058824,0.062745,0.066667,0.066667,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.058824,0.062745,0.066667,0.070588,0.07451,0.07451,0.070588,0.066667,0.062745,0.058824,0.054902,0.058824,0.066667,0.066667,0.062745,0.062745,0.070588,0.070588,0.070588,0.07451,0.07451,0.07451,0.070588,0.070588,0.062745,0.058824,0.054902,0.054902,0.058824,0.062745,0.062745,0.062745,0.058824,0.058824,0.058824,0.062745,0.058824,0.054902,0.047059,0.047059,0.043137,0.043137,0.047059,0.054902,0.054902,0.054902,0.054902,0.054902,0.054902,0.05098,0.047059,0.047059,0.047059,0.043137,0.039216,0.035294,0.035294,0.035294,0.035294,0.035294,0.035294,0.035294,0.035294,0.031373,0.031373,0.031373,0.031373,0.027451,0.027451,0.019608,0.023529,0.027451,0.027451,0.031373,0.031373,0.027451,0.031373,0.031373,0.035294,0.039216,0.043137,0.043137,0.043137,0.043137,0.039216,0.043137,0.047059,0.047059,0.047059,0.047059,0.05098,0.05098,0.05098,0.05098,0.05098,0.054902,0.058824,0.058824,0.058824,0.058824,0.054902,0.05098,0.05098,0.054902,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.062745,0.062745,0.058824,0.054902,0.054902,0.058824,0.062745,0.062745,0.062745,0.062745,0.058824,0.058824,0.062745,0.062745,0.058824,0.058824,0.058824,0.058824,0.062745,0.066667,0.066667,0.070588,0.066667,0.066667,0.062745,0.054902,0.05098,0.058824,0.062745,0.066667,0.062745,0.062745,0.066667,0.066667,0.066667,0.070588,0.070588,0.070588,0.070588,0.070588,0.066667,0.062745,0.058824,0.054902,0.058824,0.062745,0.062745,0.058824,0.054902,0.054902,0.058824,0.058824,0.054902,0.05098,0.05098,0.047059,0.043137,0.039216,0.047059,0.05098,0.05098,0.05098,0.05098,0.05098,0.05098,0.05098,0.047059,0.043137,0.043137,0.043137,0.039216,0.035294,0.031373,0.031373,0.035294,0.035294,0.035294,0.035294,0.031373,0.031373,0.031373,0.027451,0.027451,0.027451,0.023529,0.023529,0.023529,0.027451,0.027451,0.027451,0.027451,0.027451,0.031373,0.035294,0.039216,0.039216,0.039216,0.039216,0.039216,0.039216,0.039216,0.043137,0.047059,0.047059,0.047059,0.047059,0.05098,0.05098,0.05098,0.047059,0.05098,0.054902,0.054902,0.054902,0.054902,0.054902,0.05098,0.05098,0.054902,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.058824,0.062745,0.058824,0.054902,0.054902,0.062745,0.062745,0.062745,0.062745,0.054902,0.054902,0.062745,0.062745,0.062745,0.054902,0.054902,0.058824,0.058824,0.058824,0.062745,0.066667,0.066667,0.066667,0.062745,0.062745,0.058824,0.054902,0.058824,0.062745,0.066667,0.066667,0.062745,0.062745,0.062745,0.062745,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.066667,0.058824,0.054902,0.054902,0.058824,0.058824,0.058824,0.054902,0.05098,0.054902,0.054902,0.054902,0.054902,0.05098,0.05098,0.047059,0.039216,0.047059,0.05098,0.05098,0.05098,0.05098,0.05098,0.047059,0.047059,0.047059,0.043137,0.043137,0.043137,0.039216,0.039216,0.031373,0.027451,0.031373,0.035294,0.031373,0.031373,0.031373,0.027451,0.027451,0.023529,0.023529,0.019608,0.023529};
			return value;
		}

		/** Large attribute array: ElevationGrid height field, scene-graph level=4, element #24, 16384 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFFloat getElevationGrid_4_24_height()
		{
			MFFloat ElevationGrid_4_24_height = new MFFloat()/*2.finalize*/
				.append(new MFFloat(getElevationGrid_4_24_height_1()))
				.append(new MFFloat(getElevationGrid_4_24_height_2()))
				.append(new MFFloat(getElevationGrid_4_24_height_3()))
				.append(new MFFloat(getElevationGrid_4_24_height_4()))
				.append(new MFFloat(getElevationGrid_4_24_height_5()))
				.append(new MFFloat(getElevationGrid_4_24_height_6()))
				.append(new MFFloat(getElevationGrid_4_24_height_7()))
				.append(new MFFloat(getElevationGrid_4_24_height_8()))
				.append(new MFFloat(getElevationGrid_4_24_height_9()))
				.append(new MFFloat(getElevationGrid_4_24_height_10()))
				.append(new MFFloat(getElevationGrid_4_24_height_11()))
				.append(new MFFloat(getElevationGrid_4_24_height_12()))
				.append(new MFFloat(getElevationGrid_4_24_height_13()))
				.append(new MFFloat(getElevationGrid_4_24_height_14()))
				.append(new MFFloat(getElevationGrid_4_24_height_15()))
				.append(new MFFloat(getElevationGrid_4_24_height_16()))
				.append(new MFFloat(getElevationGrid_4_24_height_17()));
			return ElevationGrid_4_24_height;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return Mountain128 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new Mountain128().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Vrml2Sourcebook.Siggraph98Course.Mountain128\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Vrml2Sourcebook.Siggraph98Course.Mountain128 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Siggraph98Course/Mountain128_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Siggraph98Course/Mountain128_JavaExport.x3d"; 
                String filenameX3DV = "Siggraph98Course/Mountain128_JavaExport.x3dv"; 
                String filenameJSON = "Siggraph98Course/Mountain128_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
