package Vrml2Sourcebook.Siggraph98Course;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Colored terrain scene illustrates the use of a highly detailed ElevationGrid to build a color-mapped terrain. </p>
 <p> Related links: Catalog page <a href="../../../Siggraph98Course/LandIndex.html" target="_blank">Land</a>,  source <a href="../../../Siggraph98Course/Land.java">Land.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Siggraph98Course/Land.x3d">Land.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Colored terrain scene illustrates the use of a highly detailed ElevationGrid to build a color-mapped terrain. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> David R. Nadeau </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 1 July 1998 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 2 February 2014 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> originals/land.wrl </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.siggraph.org/s98" target="_blank">http://www.siggraph.org/s98</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.siggraph.org/s98/conference/courses/18.html" target="_blank">http://www.siggraph.org/s98/conference/courses/18.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0254.htm" target="_blank">http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0254.htm</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm" target="_blank">http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">https://www.web3d.org/x3d/content/examples/X3dResources.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Land.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Land.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Siggraph98Course/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author David R. Nadeau
 */

public class Land
{
	/** Default constructor to create this object. */
	public Land ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERACTIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("Land.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Colored terrain scene illustrates the use of a highly detailed ElevationGrid to build a color-mapped terrain."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("David R. Nadeau"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("1 July 1998"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("2 February 2014"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("originals/land.wrl"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.siggraph.org/s98"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.siggraph.org/s98/conference/courses/18.html"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0254.htm"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/x3d/content/examples/X3dResources.html"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/Land.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setInfo(new String[] {"Copyright (c) 1997, David R. Nadeau"}).setTitle("Colored terrain"))
    .addChild(new Viewpoint().setDescription("Entry view").setOrientation(1.0,0.0,0.0,-0.5).setPosition(0.0,2.0,10.0))
    .addChild(new NavigationInfo())
    .addChild(new Transform().setTranslation(-3.95,0.0,-5.75)
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material()))
        .setGeometry(new ElevationGrid().setCreaseAngle(0.785).setSolid(false).setXDimension(80).setXSpacing(0.1).setZDimension(116).setZSpacing(0.1).setHeight(getElevationGrid_5_24_height())
          .setColor(new Color().setColor(getColor_6_24_color()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getElevationGrid_5_24_height_1()
		{
			double[] value = {-1.682,-1.734,-1.832,-1.862,-1.863,-1.979,-1.807,-1.878,-1.901,-1.874,-1.961,-1.976,-1.993,-1.928,-1.931,-1.988,-1.961,-1.867,-1.869,-1.874,-1.867,-1.877,-1.806,-1.784,-1.806,-1.807,-1.746,-1.745,-1.745,-1.746,-1.746,-1.684,-1.634,-1.567,-1.462,-1.423,-1.432,-1.56,-1.638,-1.725,-1.79,-1.865,-1.822,-1.869,-1.869,-1.869,-1.869,-1.868,-1.868,-1.868,-1.869,-1.868,-1.868,-1.79,-1.643,-1.748,-1.728,-1.78,-1.806,-1.806,-1.771,-1.745,-1.705,-1.685,-1.643,-1.685,-1.686,-1.687,-1.687,-1.683,-1.624,-1.622,-1.622,-1.622,-1.617,-1.649,-1.676,-1.688,-1.714,-1.734,-1.711,-1.772,-1.78,-1.816,-1.803,-1.89,-1.782,-1.863,-1.844,-1.811,-1.928,-1.989,-1.993,-1.876,-1.929,-1.989,-1.989,-1.88,-1.788,-1.796,-1.859,-1.888,-1.807,-1.747,-1.796,-1.746,-1.774,-1.745,-1.704,-1.694,-1.745,-1.684,-1.669,-1.618,-1.556,-1.525,-1.53,-1.632,-1.685,-1.715,-1.758,-1.749,-1.716,-1.867,-1.867,-1.867,-1.867,-1.867,-1.867,-1.867,-1.867,-1.867,-1.867,-1.854,-1.798,-1.81,-1.822,-1.863,-1.811,-1.806,-1.798,-1.756,-1.745,-1.686,-1.638,-1.673,-1.623,-1.636,-1.686,-1.677,-1.676,-1.64,-1.613,-1.547,-1.563,-1.612,-1.657,-1.683,-1.701,-1.732,-1.759,-1.717,-1.758,-1.83,-1.754,-1.838,-1.748,-1.801,-1.775,-1.905,-1.975,-1.929,-1.989,-1.928,-1.923,-1.984,-1.938,-1.82,-1.823,-1.758,-1.806,-1.806,-1.855,-1.745,-1.75,-1.747,-1.745,-1.741,-1.689,-1.684,-1.745,-1.745,-1.685,-1.632,-1.599,-1.566,-1.572,-1.624,-1.702,-1.684,-1.723,-1.635,-1.625,-1.897,-1.894,-1.894,-1.892,-1.89,-1.889,-1.889,-1.888,-1.885,-1.877,-1.87,-1.858,-1.849,-1.867,-1.821,-1.759,-1.794,-1.792,-1.768,-1.746,-1.694,-1.688,-1.657,-1.683,-1.65,-1.664,-1.628,-1.625,-1.628,-1.579,-1.525,-1.394,-1.577,-1.627,-1.67,-1.687,-1.718,-1.745,-1.684,-1.7,-1.701,-1.729,-1.762,-1.837,-1.745,-1.829,-1.818,-1.878,-1.906,-1.985,-1.922,-1.925,-1.904,-1.868,-1.757,-1.905,-1.745,-1.776,-1.801,-1.806,-1.803,-1.745,-1.742,-1.718,-1.686,-1.678,-1.684,-1.687,-1.678,-1.698,-1.664,-1.624,-1.623,-1.623,-1.64,-1.667,-1.679,-1.752,-1.716,-1.85,-1.889,-1.898,-1.918,-1.916,-1.914,-1.911,-1.909,-1.907,-1.905,-1.903,-1.9,-1.898,-1.867,-1.866,-1.831,-1.779,-1.724,-1.73,-1.737,-1.744,-1.745,-1.633,-1.685,-1.627,-1.684,-1.649,-1.625,-1.617,-1.613,-1.58,-1.471,-1.458,-1.596,-1.633,-1.665,-1.684,-1.706,-1.644,-1.57,-1.578,-1.675,-1.68,-1.727,-1.829,-1.731,-1.791,-1.776,-1.806,-1.849,-1.947,-1.845,-1.918,-1.752,-1.772,-1.745,-1.849,-1.745,-1.752,-1.749,-1.805,-1.805,-1.806,-1.745,-1.686,-1.672,-1.638,-1.67,-1.608,-1.693,-1.744,-1.681,-1.684,-1.663,-1.645,-1.663,-1.62,-1.623,-1.807,-1.812,-1.865,-1.845,-1.79,-1.899,-1.914,-1.913,-1.912,-1.91,-1.906,-1.905,-1.902,-1.898,-1.897,-1.871,-1.863,-1.841,-1.808,-1.738,-1.701,-1.627,-1.626,-1.686,-1.681,-1.684,-1.684,-1.675,-1.624,-1.623,-1.605,-1.563,-1.563,-1.53,-1.499,-1.591,-1.64,-1.669,-1.693,-1.691,-1.636,-1.602,-1.55,-1.582,-1.625,-1.657,-1.709,-1.687,-1.686,-1.701,-1.744,-1.796,-1.874,-1.818,-1.754,-1.687,-1.728,-1.688,-1.79,-1.808,-1.747,-1.748,-1.748,-1.752,-1.754,-1.757,-1.7,-1.687,-1.649,-1.612,-1.651,-1.687,-1.704,-1.712,-1.693,-1.672,-1.628,-1.632,-1.623,-1.619,-1.751,-1.693,-1.739,-1.671,-1.791,-1.871,-1.891,-1.907,-1.92,-1.919,-1.912,-1.908,-1.902,-1.895,-1.891,-1.881,-1.861,-1.835,-1.808,-1.775,-1.702,-1.668,-1.592,-1.59,-1.649,-1.628,-1.624,-1.671,-1.656,-1.639,-1.615,-1.566,-1.563,-1.513,-1.492,-1.585,-1.643,-1.664,-1.713,-1.685,-1.576,-1.562,-1.394,-1.428,-1.632,-1.853,-1.618,-1.601,-1.624,-1.757,-1.658,-1.684,-1.744,-1.713,-1.816,-1.728,-1.667,-1.684,-1.799,-1.85,-1.693,-1.733,-1.739,-1.737,-1.745,-1.798,-1.72,-1.698,-1.628,-1.61,-1.605,-1.648,-1.677,-1.684,-1.713,-1.684,-1.647,-1.642,-1.629,-1.623,-1.684,-1.703,-1.763,-1.808,-1.863,-1.872,-1.9,-1.916,-1.931,-1.928,-1.922,-1.913,-1.905,-1.896,-1.887,-1.884,-1.867,-1.844,-1.81,-1.761,-1.701,-1.624,-1.469,-1.46,-1.568,-1.624,-1.62,-1.598,-1.563,-1.613,-1.579,-1.563,-1.51,-1.424,-1.541,-1.568,-1.63,-1.68,-1.724,-1.686,-1.464,-1.441,-1.467,-1.546,-1.65,-1.604,-1.592,-1.601,-1.628,-1.624,-1.618,-1.667,-1.683,-1.655,-1.644,-1.743,-1.607,-1.666,-1.699,-1.704,-1.684,-1.681,-1.609,-1.685,-1.685,-1.696,-1.741,-1.684,-1.64,-1.61,-1.667,-1.679,-1.685,-1.687,-1.711,-1.684,-1.685,-1.684,-1.638,-1.623,-1.629,-1.735,-1.747,-1.803,-1.778,-1.869,-1.887,-1.913,-1.933,-1.934,-1.929,-1.922,-1.915,-1.908,-1.902,-1.891,-1.87,-1.842,-1.807,-1.752,-1.691,-1.626,-1.398,-1.373,-1.365,-1.558,-1.567,-1.564,-1.56,-1.559,-1.556,-1.492,-1.445,-1.331,-1.329,-1.435,-1.62,-1.684,-1.718,-1.687,-1.51,-1.499,-1.562,-1.683,-1.646,-1.563,-1.488,-1.677,-1.623,-1.591,-1.563,-1.62,-1.628,-1.706,-1.665,-1.785,-1.62,-1.624,-1.567,-1.662,-1.702,-1.622,-1.684,-1.684,-1.708,-1.745,-1.799,-1.699,-1.685,-1.676,-1.674,-1.684,-1.69,-1.697,-1.704,-1.698,-1.691,-1.685,-1.65,-1.623,-1.685,-1.716,-1.706,-1.571,-1.644,-1.772,-1.871,-1.908,-1.933,-1.934,-1.934,-1.93,-1.923,-1.914,-1.903,-1.892,-1.873,-1.821,-1.808,-1.754,-1.653,-1.418,-1.311,-1.359,-1.391,-1.505,-1.502,-1.493,-1.56,-1.522,-1.503,-1.462,-1.417,-1.383,-1.368,-1.392,-1.617,-1.683,-1.727,-1.684,-1.6,-1.39,-1.419,-1.553,-1.589,-1.575,-1.518,-1.41,-1.562,-1.503,-1.524,-1.526,-1.62,-1.623,-1.623,-1.732,-1.727,-1.618,-1.665,-1.664,-1.626,-1.619,-1.681,-1.714,-1.746,-1.768,-1.793,-1.788,-1.755,-1.711,-1.687,-1.684,-1.684,-1.685,-1.685,-1.684,-1.684,-1.656,-1.623,-1.623,-1.709,-1.684,-1.637,-1.537,-1.519,-1.783,-1.812,-1.822,-1.895,-1.932,-1.934,-1.934,-1.928,-1.924,-1.909,-1.893,-1.874,-1.85,-1.808,-1.747,-1.662,-1.413,-1.492,-1.557,-1.506,-1.561,-1.515,-1.572,-1.601,-1.541,-1.455,-1.468,-1.39,-1.304,-1.226,-1.531,-1.669,-1.685,-1.741,-1.753,-1.534,-1.412,-1.336,-1.431,-1.456,-1.438,-1.498,-1.395,-1.495,-1.401,-1.479,-1.517,-1.574,-1.566,-1.617,-1.736,-1.712,-1.684,-1.683,-1.661,-1.587,-1.646,-1.684,-1.724,-1.747,-1.763,-1.766,-1.75,-1.775,-1.746,-1.732,-1.687,-1.683,-1.684,-1.684,-1.683,-1.682,-1.633,-1.619,-1.684,-1.624,-1.608,-1.582,-1.485,-1.429,-1.641,-1.794,-1.715,-1.793,-1.899,-1.934,-1.934,-1.928,-1.918,-1.907,-1.893,-1.875,-1.852,-1.82,-1.762,-1.698,-1.654,-1.509,-1.559,-1.613,-1.612,-1.602,-1.645,-1.552,-1.466,-1.432,-1.27,-1.383,-1.498,-1.56,-1.564,-1.644,-1.686,-1.745,-1.781,-1.654,-1.355,-1.199,-1.433,-1.582,-1.285,-1.425,-1.43,-1.445,-1.389,-1.444,-1.481,-1.502,-1.595,-1.565,-1.636,-1.673,-1.625,-1.63,-1.652,-1.623,-1.625,-1.674,-1.726,-1.75,-1.745,-1.772,-1.745,-1.747,-1.756,-1.749,-1.694,-1.684,-1.67,-1.657,-1.637,-1.653,-1.624,-1.603,-1.623,-1.619,-1.606,-1.462,-1.432,-1.399,-1.588,-1.727,-1.684,-1.752,-1.867,-1.871,-1.933,-1.927,-1.915,-1.904,-1.893,-1.874,-1.853,-1.816,-1.777,-1.745,-1.7,-1.641,-1.628,-1.483,-1.58,-1.677,-1.628,-1.504,-1.441,-1.352,-1.318,-1.197,-1.354,-1.551,-1.653,-1.721,-1.745,-1.745,-1.763,-1.587,-1.453,-1.42,-1.174,-1.496,-1.335,-1.133,-1.218,-1.475,-1.42,-1.387,-1.407,-1.482,-1.501,-1.627,-1.608,-1.6,-1.569,-1.665,-1.623,-1.617,-1.627,-1.68,-1.685,-1.697,-1.699,-1.688,-1.692,-1.701,-1.725,-1.747,-1.755,-1.72,-1.685,-1.668,-1.635,-1.627,-1.621,-1.562,-1.571};
			return value;
		}
		private double[] getElevationGrid_5_24_height_2()
		{
			double[] value = {-1.549,-1.571,-1.415,-1.387,-1.219,-1.538,-1.701,-1.809,-1.86,-1.888,-1.914,-1.928,-1.92,-1.911,-1.901,-1.889,-1.876,-1.858,-1.808,-1.805,-1.753,-1.702,-1.684,-1.684,-1.647,-1.681,-1.687,-1.652,-1.575,-1.445,-1.35,-1.289,-1.303,-1.227,-1.53,-1.674,-1.719,-1.745,-1.748,-1.759,-1.5,-1.268,-1.32,-1.158,-1.274,-1.383,-1.262,-1.252,-1.254,-1.253,-1.177,-1.294,-1.503,-1.468,-1.589,-1.574,-1.506,-1.555,-1.609,-1.577,-1.541,-1.616,-1.639,-1.685,-1.684,-1.629,-1.655,-1.684,-1.594,-1.685,-1.692,-1.698,-1.707,-1.721,-1.692,-1.649,-1.623,-1.606,-1.5,-1.538,-1.502,-1.345,-1.284,-1.43,-1.362,-1.439,-1.743,-1.807,-1.846,-1.874,-1.891,-1.901,-1.908,-1.887,-1.885,-1.88,-1.871,-1.853,-1.809,-1.806,-1.754,-1.729,-1.689,-1.686,-1.689,-1.712,-1.69,-1.684,-1.637,-1.584,-1.504,-1.473,-1.433,-1.28,-1.549,-1.682,-1.734,-1.745,-1.769,-1.771,-1.239,-1.102,-1.077,-1.18,-1.328,-1.28,-1.41,-1.564,-1.119,-1.254,-1.371,-1.505,-1.478,-1.548,-1.487,-1.559,-1.445,-1.556,-1.533,-1.504,-1.457,-1.623,-1.684,-1.626,-1.644,-1.637,-1.626,-1.682,-1.636,-1.684,-1.684,-1.685,-1.684,-1.684,-1.685,-1.69,-1.676,-1.637,-1.523,-1.572,-1.519,-1.35,-1.561,-1.504,-1.446,-1.685,-1.8,-1.751,-1.815,-1.867,-1.841,-1.869,-1.868,-1.867,-1.868,-1.878,-1.87,-1.833,-1.777,-1.745,-1.747,-1.686,-1.684,-1.744,-1.713,-1.633,-1.678,-1.631,-1.639,-1.62,-1.565,-1.521,-1.449,-1.352,-1.604,-1.684,-1.745,-1.758,-1.798,-1.841,-1.439,-1.461,-1.384,-1.338,-1.586,-1.359,-1.521,-1.626,-1.436,-1.285,-1.185,-1.33,-1.336,-1.387,-1.571,-1.477,-1.444,-1.448,-1.58,-1.512,-1.617,-1.643,-1.684,-1.649,-1.638,-1.591,-1.623,-1.623,-1.623,-1.623,-1.627,-1.632,-1.657,-1.668,-1.667,-1.667,-1.667,-1.662,-1.669,-1.664,-1.599,-1.559,-1.619,-1.606,-1.613,-1.741,-1.806,-1.761,-1.86,-1.822,-1.808,-1.867,-1.867,-1.81,-1.838,-1.867,-1.861,-1.826,-1.783,-1.745,-1.745,-1.732,-1.735,-1.767,-1.716,-1.647,-1.61,-1.517,-1.564,-1.633,-1.53,-1.493,-1.467,-1.491,-1.642,-1.725,-1.745,-1.716,-1.814,-1.806,-1.642,-1.639,-1.449,-1.644,-1.532,-1.734,-1.703,-1.73,-1.678,-1.58,-1.57,-1.424,-1.4,-1.493,-1.563,-1.575,-1.561,-1.422,-1.548,-1.623,-1.63,-1.621,-1.702,-1.695,-1.611,-1.563,-1.562,-1.564,-1.568,-1.595,-1.58,-1.572,-1.664,-1.625,-1.624,-1.623,-1.625,-1.644,-1.684,-1.685,-1.641,-1.625,-1.623,-1.682,-1.656,-1.731,-1.815,-1.867,-1.867,-1.867,-1.862,-1.867,-1.867,-1.867,-1.867,-1.867,-1.86,-1.834,-1.812,-1.756,-1.774,-1.746,-1.7,-1.771,-1.737,-1.694,-1.685,-1.513,-1.467,-1.492,-1.562,-1.502,-1.403,-1.522,-1.521,-1.726,-1.747,-1.806,-1.809,-1.867,-1.6,-1.598,-1.538,-1.908,-1.598,-1.738,-1.697,-1.649,-1.805,-1.702,-1.707,-1.593,-1.509,-1.533,-1.616,-1.703,-1.63,-1.625,-1.484,-1.684,-1.682,-1.684,-1.683,-1.748,-1.685,-1.598,-1.546,-1.547,-1.638,-1.57,-1.501,-1.557,-1.636,-1.697,-1.623,-1.623,-1.623,-1.623,-1.624,-1.704,-1.657,-1.633,-1.73,-1.69,-1.715,-1.745,-1.822,-1.87,-1.885,-1.89,-1.89,-1.892,-1.903,-1.891,-1.882,-1.867,-1.867,-1.85,-1.836,-1.788,-1.803,-1.805,-1.768,-1.788,-1.746,-1.745,-1.705,-1.636,-1.605,-1.534,-1.481,-1.501,-1.412,-1.377,-1.559,-1.685,-1.744,-1.806,-1.862,-1.872,-1.689,-1.673,-1.696,-1.942,-1.846,-1.792,-1.874,-1.852,-1.812,-1.629,-1.775,-1.6,-1.641,-1.798,-1.724,-1.719,-1.685,-1.714,-1.692,-1.736,-1.67,-1.685,-1.744,-1.755,-1.745,-1.696,-1.671,-1.712,-1.639,-1.539,-1.439,-1.513,-1.717,-1.743,-1.682,-1.651,-1.632,-1.592,-1.672,-1.721,-1.725,-1.71,-1.737,-1.758,-1.79,-1.806,-1.756,-1.875,-1.896,-1.903,-1.903,-1.903,-1.903,-1.903,-1.902,-1.882,-1.867,-1.863,-1.852,-1.84,-1.831,-1.823,-1.816,-1.809,-1.787,-1.764,-1.738,-1.694,-1.658,-1.562,-1.389,-1.499,-1.44,-1.501,-1.52,-1.655,-1.75,-1.765,-1.81,-1.868,-1.649,-1.915,-1.922,-2.004,-1.975,-2.009,-1.903,-1.897,-1.649,-1.771,-1.757,-1.741,-1.595,-1.846,-1.792,-1.741,-1.817,-1.728,-1.725,-1.822,-1.746,-1.746,-1.745,-1.782,-1.794,-1.746,-1.745,-1.731,-1.712,-1.633,-1.456,-1.506,-1.648,-1.758,-1.672,-1.616,-1.699,-1.594,-1.597,-1.725,-1.748,-1.776,-1.795,-1.796,-1.806,-1.806,-1.77,-1.875,-1.898,-1.905,-1.908,-1.91,-1.912,-1.914,-1.915,-1.909,-1.871,-1.869,-1.864,-1.853,-1.842,-1.836,-1.829,-1.817,-1.807,-1.795,-1.761,-1.733,-1.688,-1.623,-1.501,-1.405,-1.42,-1.488,-1.548,-1.622,-1.597,-1.748,-1.823,-1.868,-1.654,-1.825,-1.746,-2.025,-2.055,-2.028,-1.926,-1.947,-1.886,-1.795,-1.906,-1.755,-1.796,-1.792,-1.815,-1.802,-1.908,-1.794,-1.76,-1.783,-1.863,-1.84,-1.816,-1.808,-1.808,-1.806,-1.806,-1.806,-1.78,-1.684,-1.722,-1.598,-1.669,-1.685,-1.594,-1.562,-1.743,-1.626,-1.682,-1.685,-1.729,-1.731,-1.795,-1.816,-1.814,-1.837,-1.854,-1.868,-1.885,-1.904,-1.907,-1.909,-1.912,-1.915,-1.918,-1.917,-1.908,-1.868,-1.862,-1.856,-1.85,-1.843,-1.837,-1.827,-1.816,-1.806,-1.782,-1.746,-1.689,-1.561,-1.589,-1.55,-1.431,-1.467,-1.57,-1.653,-1.616,-1.625,-1.799,-1.813,-1.834,-1.962,-1.867,-1.992,-2.111,-2.036,-2.024,-1.933,-1.96,-1.883,-1.928,-1.845,-1.874,-1.982,-1.829,-1.844,-1.904,-1.856,-1.866,-1.927,-1.928,-1.867,-1.883,-1.849,-1.866,-1.863,-1.867,-1.815,-1.807,-1.793,-1.804,-1.749,-1.731,-1.762,-1.699,-1.723,-1.796,-1.654,-1.633,-1.68,-1.715,-1.74,-1.747,-1.805,-1.809,-1.817,-1.841,-1.86,-1.867,-1.874,-1.886,-1.896,-1.903,-1.905,-1.912,-1.911,-1.906,-1.867,-1.861,-1.855,-1.85,-1.844,-1.838,-1.836,-1.836,-1.829,-1.806,-1.786,-1.76,-1.701,-1.491,-1.65,-1.539,-1.566,-1.528,-1.708,-1.715,-1.679,-1.518,-1.54,-1.795,-1.979,-1.919,-2.042,-1.922,-2.033,-1.964,-2.05,-2.037,-2.046,-1.898,-1.896,-1.95,-1.985,-1.814,-1.96,-1.983,-1.907,-1.914,-1.959,-1.936,-1.928,-1.909,-1.844,-1.902,-1.867,-1.88,-1.867,-1.867,-1.864,-1.867,-1.833,-1.867,-1.87,-1.815,-1.833,-1.854,-1.81,-1.628,-1.654,-1.788,-1.803,-1.806,-1.806,-1.806,-1.807,-1.829,-1.846,-1.867,-1.867,-1.868,-1.867,-1.867,-1.867,-1.88,-1.882,-1.904,-1.878,-1.865,-1.861,-1.857,-1.854,-1.851,-1.847,-1.843,-1.84,-1.833,-1.818,-1.796,-1.775,-1.734,-1.637,-1.671,-1.649,-1.669,-1.736,-1.745,-1.73,-1.693,-1.594,-1.972,-1.979,-2.005,-1.996,-2.112,-1.957,-2.104,-2.048,-2.055,-1.918,-2.017,-1.982,-1.896,-1.911,-1.835,-2.035,-2.045,-1.988,-2.005,-1.945,-1.956,-1.943,-1.868,-1.867,-1.897,-1.928,-1.938,-1.921,-1.922,-1.928,-1.926,-1.924,-1.967,-1.878,-1.896,-1.906,-1.91,-1.867,-1.816,-1.808,-1.826,-1.809,-1.806,-1.805,-1.806,-1.805,-1.775,-1.785,-1.817,-1.81,-1.826,-1.831,-1.837,-1.843,-1.849,-1.857,-1.869,-1.869,-1.867,-1.866,-1.863,-1.859,-1.856,-1.852,-1.848,-1.845,-1.841,-1.837,-1.832,-1.804,-1.78,-1.759,-1.746,-1.704,-1.684,-1.674,-1.748,-1.767,-1.775,-1.751,-2.002,-2.072,-1.949,-2.022,-2.096,-2.178,-1.845,-1.955,-1.913,-1.867,-2.065,-1.981,-1.915,-1.976,-1.951,-2.074,-1.998,-2.005,-2.04,-2.052,-1.962,-1.928,-1.876,-1.886,-1.923,-1.946,-1.93,-1.933,-1.949,-1.984,-1.952,-1.989,-1.939,-1.928,-1.93,-1.94,-1.933,-1.922,-1.872,-1.861,-1.867,-1.806,-1.805,-1.78,-1.762,-1.745,-1.694,-1.676,-1.625,-1.739,-1.793,-1.805,-1.807,-1.807,-1.819,-1.847,-1.868,-1.872,-1.873,-1.871,-1.864,-1.861,-1.858,-1.856,-1.859,-1.86,-1.86,-1.854,-1.845,-1.829,-1.811,-1.803,-1.752,-1.661,-1.576,-1.627,-1.709,-1.802,-1.806,-1.83};
			return value;
		}
		private double[] getElevationGrid_5_24_height_3()
		{
			double[] value = {-2.105,-2.073,-2.019,-2.089,-2.179,-2.172,-2.139,-2.144,-2.031,-2.023,-2.111,-2.1,-2.124,-2.051,-2.072,-2.105,-2.047,-2.092,-2.043,-1.992,-1.918,-1.885,-1.877,-1.868,-1.923,-1.975,-1.99,-1.985,-1.989,-1.989,-2.026,-2.049,-2.002,-2.024,-1.995,-1.983,-1.932,-1.932,-1.912,-1.89,-1.867,-1.828,-1.806,-1.749,-1.743,-1.691,-1.626,-1.514,-1.583,-1.668,-1.705,-1.765,-1.778,-1.804,-1.806,-1.806,-1.829,-1.863,-1.872,-1.867,-1.866,-1.863,-1.859,-1.857,-1.853,-1.85,-1.847,-1.843,-1.84,-1.837,-1.836,-1.829,-1.807,-1.636,-1.684,-1.733,-1.723,-1.806,-1.867,-1.887,-2.158,-2.17,-2.05,-2.09,-2.228,-2.224,-2.172,-2.129,-2.031,-2.048,-2.131,-2.079,-2.152,-2.099,-2.112,-2.112,-2.115,-2.052,-1.993,-1.933,-1.868,-1.81,-1.788,-1.794,-1.847,-1.901,-1.99,-2.044,-2.03,-2.05,-2.064,-2.077,-2.049,-1.987,-1.976,-1.932,-1.928,-1.928,-1.922,-1.867,-1.867,-1.831,-1.805,-1.745,-1.685,-1.643,-1.524,-1.563,-1.52,-1.623,-1.698,-1.754,-1.76,-1.78,-1.797,-1.806,-1.815,-1.831,-1.855,-1.872,-1.868,-1.866,-1.864,-1.862,-1.86,-1.857,-1.853,-1.85,-1.847,-1.843,-1.84,-1.837,-1.755,-1.745,-1.678,-1.692,-1.733,-1.806,-1.814,-1.927,-2.149,-2.079,-2.097,-2.109,-2.26,-2.214,-2.125,-2.075,-2.054,-2.111,-2.068,-2.163,-2.178,-2.098,-2.12,-2.034,-2.053,-2.036,-1.932,-1.868,-1.76,-1.717,-1.669,-1.724,-1.802,-1.869,-1.949,-2.044,-2.063,-2.104,-2.114,-2.051,-2.04,-1.969,-1.928,-1.933,-1.929,-1.895,-1.87,-1.878,-1.848,-1.806,-1.753,-1.746,-1.704,-1.615,-1.504,-1.441,-1.62,-1.684,-1.705,-1.744,-1.747,-1.755,-1.766,-1.806,-1.808,-1.813,-1.851,-1.871,-1.873,-1.871,-1.869,-1.868,-1.866,-1.862,-1.858,-1.854,-1.852,-1.847,-1.843,-1.838,-1.798,-1.747,-1.665,-1.701,-1.744,-1.747,-1.863,-1.932,-2.055,-2.113,-2.133,-2.127,-2.234,-2.198,-2.215,-2.127,-1.994,-2.032,-2.129,-2.119,-2.051,-2.021,-2.051,-1.946,-1.936,-1.989,-1.916,-1.748,-1.782,-1.679,-1.599,-1.641,-1.753,-1.889,-1.982,-2.032,-2.108,-2.13,-2.094,-2.05,-1.989,-1.996,-1.933,-1.928,-1.927,-1.908,-1.857,-1.833,-1.811,-1.829,-1.745,-1.732,-1.625,-1.563,-1.523,-1.524,-1.606,-1.628,-1.695,-1.662,-1.678,-1.702,-1.734,-1.75,-1.788,-1.813,-1.851,-1.869,-1.873,-1.873,-1.873,-1.873,-1.87,-1.867,-1.86,-1.853,-1.845,-1.837,-1.838,-1.753,-1.642,-1.557,-1.683,-1.685,-1.725,-1.766,-1.933,-1.979,-2.112,-2.149,-2.169,-2.172,-2.229,-2.251,-2.138,-2.07,-1.949,-1.978,-2.06,-2.243,-2.168,-2.059,-1.918,-1.77,-1.791,-1.902,-1.828,-1.807,-1.851,-1.729,-1.787,-1.832,-1.957,-1.942,-1.948,-2.011,-2.057,-2.127,-2.054,-1.994,-1.99,-1.933,-1.984,-1.901,-1.872,-1.867,-1.869,-1.808,-1.785,-1.779,-1.745,-1.667,-1.623,-1.509,-1.467,-1.47,-1.503,-1.563,-1.614,-1.563,-1.628,-1.677,-1.686,-1.746,-1.792,-1.819,-1.852,-1.871,-1.873,-1.873,-1.873,-1.873,-1.868,-1.867,-1.848,-1.847,-1.842,-1.837,-1.79,-1.663,-1.528,-1.625,-1.632,-1.645,-1.792,-1.783,-1.972,-1.989,-2.209,-2.176,-2.172,-2.173,-2.226,-2.295,-2.166,-2.116,-2.006,-2.047,-2.028,-2.228,-2.181,-1.987,-1.822,-1.928,-2.038,-1.998,-1.989,-1.984,-1.829,-1.802,-1.665,-1.935,-2.009,-2.05,-1.929,-1.944,-1.952,-2.082,-1.989,-1.975,-1.93,-1.929,-1.868,-1.914,-1.867,-1.83,-1.808,-1.8,-1.745,-1.745,-1.728,-1.649,-1.592,-1.602,-1.519,-1.438,-1.486,-1.519,-1.534,-1.568,-1.655,-1.687,-1.711,-1.748,-1.797,-1.821,-1.852,-1.87,-1.873,-1.871,-1.868,-1.86,-1.848,-1.833,-1.828,-1.838,-1.836,-1.827,-1.79,-1.718,-1.639,-1.591,-1.663,-1.789,-1.867,-1.916,-1.985,-2.007,-2.286,-2.177,-2.176,-2.233,-2.241,-2.323,-2.199,-2.172,-2.16,-2.111,-2.202,-2.222,-2.218,-1.873,-2.057,-2.11,-2.109,-2.104,-2.053,-1.965,-2.039,-1.966,-1.983,-2.05,-2.105,-2.11,-2.036,-2.033,-2.044,-2.058,-1.918,-1.906,-1.867,-1.867,-1.858,-1.807,-1.899,-1.848,-1.754,-1.795,-1.77,-1.731,-1.684,-1.651,-1.585,-1.57,-1.552,-1.441,-1.481,-1.528,-1.557,-1.608,-1.655,-1.721,-1.745,-1.77,-1.804,-1.823,-1.852,-1.868,-1.871,-1.867,-1.846,-1.833,-1.822,-1.785,-1.739,-1.83,-1.792,-1.776,-1.761,-1.725,-1.62,-1.496,-1.715,-1.794,-1.922,-1.973,-2.015,-2.05,-2.247,-2.136,-2.177,-2.288,-2.235,-2.352,-2.233,-2.233,-2.228,-2.184,-2.25,-2.248,-2.208,-2.13,-2.141,-2.172,-2.121,-2.113,-2.111,-2.108,-2.067,-1.989,-1.968,-2.103,-2.099,-2.148,-2.18,-2.183,-2.146,-1.966,-1.935,-1.861,-1.81,-1.806,-1.806,-1.806,-1.78,-1.857,-1.748,-1.723,-1.703,-1.687,-1.672,-1.617,-1.585,-1.502,-1.484,-1.425,-1.47,-1.502,-1.562,-1.635,-1.684,-1.741,-1.785,-1.798,-1.81,-1.828,-1.852,-1.867,-1.867,-1.838,-1.824,-1.81,-1.781,-1.653,-1.68,-1.745,-1.745,-1.712,-1.715,-1.671,-1.507,-1.399,-1.783,-1.85,-1.942,-1.993,-2.038,-2.05,-2.234,-2.191,-2.173,-2.294,-2.231,-2.247,-2.294,-2.294,-2.249,-2.22,-2.301,-2.234,-2.219,-2.173,-2.172,-2.153,-2.057,-2.086,-2.086,-2.154,-2.088,-2.085,-2.141,-2.131,-2.215,-2.236,-2.166,-2.025,-2.104,-1.933,-1.888,-1.807,-1.741,-1.744,-1.739,-1.745,-1.744,-1.865,-1.713,-1.721,-1.684,-1.624,-1.46,-1.527,-1.604,-1.476,-1.476,-1.396,-1.396,-1.483,-1.56,-1.625,-1.685,-1.751,-1.792,-1.815,-1.83,-1.845,-1.86,-1.867,-1.846,-1.813,-1.806,-1.773,-1.749,-1.676,-1.739,-1.745,-1.745,-1.695,-1.598,-1.537,-1.612,-1.7,-1.691,-1.927,-1.967,-2.023,-2.051,-2.082,-2.234,-2.145,-2.148,-2.266,-2.079,-2.291,-2.393,-2.355,-2.294,-2.273,-2.319,-2.233,-2.234,-2.233,-2.178,-2.112,-2.166,-2.092,-2.105,-2.173,-2.123,-2.114,-2.178,-2.214,-2.173,-2.169,-2.106,-1.989,-1.928,-1.942,-1.896,-1.81,-1.693,-1.68,-1.624,-1.63,-1.581,-1.684,-1.727,-1.68,-1.627,-1.563,-1.55,-1.54,-1.531,-1.481,-1.492,-1.329,-1.295,-1.304,-1.502,-1.625,-1.704,-1.759,-1.794,-1.812,-1.811,-1.81,-1.809,-1.809,-1.808,-1.808,-1.762,-1.748,-1.617,-1.668,-1.684,-1.687,-1.699,-1.622,-1.58,-1.619,-1.426,-1.796,-1.791,-1.963,-1.997,-2.044,-2.052,-2.111,-2.299,-2.287,-2.355,-2.247,-2.285,-2.355,-2.326,-2.355,-2.357,-2.311,-2.35,-2.294,-2.294,-2.233,-2.23,-2.208,-2.164,-2.167,-2.146,-2.172,-2.224,-2.309,-2.253,-2.172,-2.156,-2.094,-2.026,-2.047,-1.952,-1.98,-1.814,-1.726,-1.639,-1.683,-1.565,-1.533,-1.58,-1.662,-1.759,-1.585,-1.597,-1.546,-1.373,-1.439,-1.404,-1.424,-1.31,-1.204,-1.222,-1.391,-1.531,-1.642,-1.714,-1.762,-1.806,-1.812,-1.811,-1.81,-1.809,-1.808,-1.807,-1.807,-1.788,-1.722,-1.651,-1.624,-1.667,-1.627,-1.631,-1.573,-1.655,-1.743,-1.741,-1.821,-1.874,-1.987,-2.013,-2.05,-2.083,-2.111,-2.357,-2.362,-2.407,-2.333,-2.352,-2.396,-2.363,-2.413,-2.356,-2.35,-2.388,-2.351,-2.298,-2.294,-2.292,-2.248,-2.249,-2.234,-2.233,-2.242,-2.355,-2.239,-2.229,-2.12,-2.092,-2.027,-1.964,-1.926,-1.815,-1.793,-1.744,-1.777,-1.646,-1.582,-1.556,-1.41,-1.474,-1.612,-1.729,-1.563,-1.502,-1.468,-1.431,-1.283,-1.283,-1.211,-1.245,-1.077,-1.085,-1.278,-1.55,-1.645,-1.74,-1.768,-1.807,-1.813,-1.811,-1.81,-1.809,-1.807,-1.807,-1.806,-1.783,-1.749,-1.699,-1.617,-1.62,-1.602,-1.655,-1.687,-1.742,-1.793,-1.806,-1.863,-1.923,-1.943,-2.002,-2.046,-2.1,-2.111,-2.414,-2.416,-2.411,-2.422,-2.417,-2.416,-2.416,-2.413,-2.416,-2.374,-2.419,-2.355,-2.331,-2.309,-2.3,-2.294,-2.294,-2.293,-2.294,-2.372,-2.275,-2.191,-2.133,-2.152,-2.052,-1.987,-1.923,-1.758,-1.594,-1.479,-1.377,-1.662,-1.72,-1.294,-1.331,-1.236,-1.427,-1.565,-1.646,-1.638};
			return value;
		}
		private double[] getElevationGrid_5_24_height_4()
		{
			double[] value = {-1.562,-1.542,-1.087,-1.135,-1.117,-1.211,-1.343,-1.335,-1.457,-1.203,-1.422,-1.685,-1.745,-1.76,-1.795,-1.803,-1.808,-1.782,-1.804,-1.806,-1.697,-1.713,-1.753,-1.747,-1.683,-1.624,-1.652,-1.528,-1.657,-1.686,-1.755,-1.806,-1.811,-1.898,-1.928,-1.928,-1.995,-2.051,-2.101,-2.134,-2.417,-2.437,-2.459,-2.475,-2.476,-2.476,-2.476,-2.452,-2.416,-2.416,-2.419,-2.373,-2.355,-2.353,-2.354,-2.354,-2.355,-2.353,-2.381,-2.325,-2.238,-2.172,-2.112,-2.051,-2.028,-1.875,-1.806,-1.521,-1.101,-1.133,-1.492,-1.184,-1.537,-1.473,-1.111,-1.157,-1.304,-1.602,-1.737,-1.699,-1.631,-1.362,-1.326,-1.403,-1.311,-1.365,-1.526,-1.61,-1.629,-1.546,-1.654,-1.691,-1.783,-1.807,-1.823,-1.834,-1.755,-1.745,-1.805,-1.806,-1.71,-1.738,-1.745,-1.745,-1.696,-1.675,-1.687,-1.685,-1.744,-1.789,-1.813,-1.866,-1.867,-1.928,-1.963,-1.991,-2.05,-2.063,-2.111,-2.164,-2.47,-2.473,-2.475,-2.482,-2.505,-2.528,-2.474,-2.45,-2.424,-2.416,-2.421,-2.409,-2.392,-2.374,-2.357,-2.355,-2.357,-2.425,-2.355,-2.294,-2.245,-2.205,-2.137,-1.984,-1.901,-1.859,-1.868,-1.496,-1.019,-1.249,-1.437,-1.009,-1.393,-1.225,-0.994,-1.06,-1.375,-1.636,-1.685,-1.775,-1.866,-1.665,-1.633,-1.491,-1.387,-1.619,-1.678,-1.615,-1.646,-1.745,-1.753,-1.747,-1.818,-1.857,-1.867,-1.867,-1.837,-1.82,-1.806,-1.806,-1.804,-1.748,-1.745,-1.734,-1.684,-1.713,-1.742,-1.745,-1.745,-1.745,-1.861,-1.867,-1.908,-1.929,-1.989,-2.007,-2.013,-2.101,-2.111,-2.113,-2.482,-2.477,-2.494,-2.537,-2.543,-2.477,-2.474,-2.475,-2.476,-2.476,-2.44,-2.416,-2.413,-2.415,-2.415,-2.415,-2.417,-2.394,-2.346,-2.294,-2.234,-2.223,-2.165,-2.101,-2.004,-1.806,-1.794,-1.717,-1.328,-1.507,-1.304,-1.199,-1.245,-0.979,-1.306,-1.378,-1.656,-1.585,-1.731,-1.862,-1.79,-1.824,-1.807,-1.723,-1.571,-1.649,-1.795,-1.773,-1.856,-1.819,-1.819,-1.843,-1.866,-1.874,-1.884,-1.868,-1.865,-1.842,-1.807,-1.806,-1.785,-1.796,-1.754,-1.747,-1.746,-1.75,-1.775,-1.764,-1.776,-1.758,-1.747,-1.778,-1.891,-1.933,-1.988,-2.024,-2.05,-2.088,-2.101,-2.167,-2.534,-2.536,-2.537,-2.57,-2.518,-2.481,-2.476,-2.476,-2.476,-2.492,-2.47,-2.448,-2.427,-2.416,-2.416,-2.416,-2.419,-2.367,-2.282,-2.294,-2.258,-2.224,-2.155,-2.06,-1.851,-1.792,-1.729,-1.618,-1.691,-1.747,-1.717,-1.472,-1.618,-1.266,-1.62,-1.586,-1.832,-1.648,-1.902,-1.987,-1.811,-1.923,-1.89,-1.865,-1.824,-1.753,-1.696,-1.756,-1.85,-1.962,-1.916,-1.91,-1.911,-1.926,-1.928,-1.916,-1.853,-1.867,-1.845,-1.809,-1.824,-1.807,-1.808,-1.8,-1.806,-1.806,-1.806,-1.806,-1.806,-1.806,-1.798,-1.77,-1.811,-1.896,-1.959,-1.99,-2.018,-2.05,-2.105,-2.112,-2.539,-2.565,-2.6,-2.536,-2.519,-2.504,-2.487,-2.478,-2.476,-2.515,-2.476,-2.465,-2.449,-2.432,-2.417,-2.479,-2.415,-2.375,-2.305,-2.296,-2.266,-2.154,-2.166,-2.05,-1.961,-1.925,-1.823,-1.812,-1.794,-1.596,-1.85,-1.831,-1.657,-1.453,-1.717,-1.829,-1.858,-1.88,-1.872,-1.955,-1.87,-1.929,-1.934,-1.931,-1.931,-1.882,-1.863,-1.905,-1.969,-1.975,-1.934,-1.937,-1.941,-1.947,-1.951,-1.92,-1.83,-1.851,-1.867,-1.867,-1.867,-1.867,-1.863,-1.848,-1.842,-1.843,-1.867,-1.848,-1.859,-1.833,-1.813,-1.806,-1.867,-1.917,-1.935,-1.989,-2.05,-2.111,-2.082,-2.111,-2.598,-2.615,-2.541,-2.537,-2.536,-2.521,-2.503,-2.478,-2.477,-2.531,-2.479,-2.478,-2.477,-2.477,-2.481,-2.43,-2.399,-2.376,-2.354,-2.317,-2.288,-2.235,-2.098,-2.063,-2.034,-2.018,-1.978,-1.867,-1.91,-1.832,-1.887,-1.795,-1.736,-1.553,-1.826,-1.886,-1.766,-1.967,-1.966,-1.982,-1.863,-1.989,-1.997,-1.997,-2.003,-2.001,-1.984,-1.959,-2.048,-1.989,-1.988,-1.989,-1.989,-1.989,-1.939,-1.928,-1.867,-1.867,-1.868,-1.877,-1.882,-1.889,-1.898,-1.885,-1.868,-1.867,-1.889,-1.873,-1.886,-1.834,-1.805,-1.808,-1.867,-1.901,-1.947,-1.989,-1.99,-2.097,-2.139,-2.134,-2.634,-2.598,-2.577,-2.545,-2.537,-2.529,-2.508,-2.485,-2.503,-2.525,-2.477,-2.477,-2.477,-2.477,-2.519,-2.45,-2.416,-2.369,-2.359,-2.336,-2.294,-2.238,-2.174,-2.11,-2.05,-2.106,-2.036,-1.981,-1.974,-1.98,-2.062,-1.796,-1.564,-1.519,-1.825,-1.874,-2.021,-2.03,-2.048,-2.028,-2.009,-2.061,-2.052,-2.056,-2.056,-2.062,-2.053,-2.035,-2.05,-2.03,-2.015,-2.032,-1.99,-1.954,-1.928,-1.918,-1.888,-1.895,-1.917,-1.916,-1.928,-1.928,-1.928,-1.928,-1.928,-1.924,-1.927,-1.928,-1.869,-1.806,-1.746,-1.762,-1.759,-1.868,-1.928,-1.989,-2.001,-2.106,-2.155,-2.137,-2.639,-2.598,-2.598,-2.564,-2.562,-2.537,-2.537,-2.536,-2.541,-2.52,-2.476,-2.476,-2.476,-2.476,-2.513,-2.461,-2.432,-2.39,-2.369,-2.355,-2.305,-2.217,-2.118,-2.151,-2.136,-2.14,-2.11,-2.071,-2.059,-2.117,-2.121,-1.651,-1.774,-1.844,-1.801,-1.804,-1.928,-2.071,-2.114,-2.078,-2.096,-2.111,-2.111,-2.109,-2.111,-2.111,-2.111,-2.111,-2.065,-2.05,-2.051,-2.014,-1.92,-1.928,-1.928,-1.896,-1.869,-1.911,-1.933,-1.931,-1.93,-1.928,-1.928,-1.928,-1.94,-1.929,-1.958,-1.892,-1.859,-1.807,-1.746,-1.685,-1.746,-1.821,-1.9,-1.879,-1.929,-2.107,-2.118,-2.172,-2.604,-2.649,-2.598,-2.598,-2.532,-2.503,-2.494,-2.492,-2.55,-2.532,-2.508,-2.483,-2.476,-2.485,-2.477,-2.463,-2.444,-2.424,-2.403,-2.377,-2.363,-2.351,-2.149,-2.235,-2.196,-2.179,-2.085,-2.117,-2.136,-2.153,-1.987,-1.973,-2.025,-2.035,-2.042,-1.823,-2.049,-2.112,-2.172,-2.147,-2.136,-2.145,-2.147,-2.144,-2.149,-2.119,-2.13,-2.066,-2.121,-2.103,-1.929,-1.823,-1.824,-1.877,-1.883,-1.867,-1.867,-1.889,-1.925,-1.942,-1.973,-1.949,-1.928,-1.888,-1.989,-1.99,-1.953,-1.882,-1.863,-1.791,-1.65,-1.597,-1.673,-1.682,-1.796,-1.839,-1.984,-2.117,-2.172,-2.187,-2.685,-2.695,-2.653,-2.589,-2.46,-2.5,-2.572,-2.606,-2.538,-2.532,-2.517,-2.502,-2.498,-2.541,-2.476,-2.474,-2.462,-2.441,-2.42,-2.416,-2.416,-2.383,-2.288,-2.27,-2.259,-2.233,-2.233,-2.188,-2.191,-2.202,-2.037,-2.212,-2.174,-2.167,-2.112,-2.081,-2.111,-2.155,-2.205,-2.172,-2.187,-2.173,-2.172,-2.172,-2.172,-2.172,-2.174,-2.136,-2.096,-2.061,-1.989,-1.869,-1.864,-1.821,-1.866,-1.806,-1.841,-1.838,-1.899,-1.928,-1.982,-1.985,-1.928,-1.951,-1.956,-1.994,-1.935,-1.926,-1.914,-1.798,-1.633,-1.565,-1.553,-1.697,-1.865,-1.966,-2.102,-2.171,-2.172,-2.233,-2.719,-2.719,-2.676,-2.617,-2.564,-2.605,-2.633,-2.582,-2.538,-2.537,-2.53,-2.531,-2.533,-2.569,-2.522,-2.478,-2.476,-2.472,-2.463,-2.454,-2.44,-2.192,-2.306,-2.299,-2.294,-2.294,-2.238,-2.233,-2.234,-2.212,-2.23,-2.264,-2.238,-2.221,-2.179,-2.134,-2.117,-2.156,-2.223,-2.126,-2.23,-2.175,-2.22,-2.212,-2.211,-2.222,-2.174,-2.072,-2.051,-2.05,-1.989,-1.937,-1.865,-1.785,-1.806,-1.806,-1.806,-1.807,-1.864,-1.928,-1.954,-2.007,-1.99,-1.991,-2.022,-1.988,-1.901,-1.934,-1.941,-1.927,-1.85,-1.747,-1.762,-1.702,-1.997,-2.082,-2.167,-2.172,-2.219,-2.234,-2.693,-2.694,-2.691,-2.659,-2.62,-2.662,-2.629,-2.586,-2.552,-2.537,-2.537,-2.537,-2.537,-2.583,-2.536,-2.526,-2.515,-2.503,-2.491,-2.48,-2.477,-2.359,-2.356,-2.371,-2.333,-2.295,-2.294,-2.243,-2.175,-2.29,-2.317,-2.298,-2.29,-2.261,-2.248,-2.231,-2.171,-2.179,-2.221,-2.253,-2.25,-2.241,-2.239,-2.248,-2.256,-2.212,-2.17,-2.112,-2.08,-2.029,-1.989,-1.937,-1.861,-1.699,-1.749,-1.688,-1.746,-1.778,-1.857,-1.899,-1.944,-2.005,-1.993,-2.05,-2.05,-2.019,-1.993,-1.98,-1.98,-1.977,-1.913,-1.905,-1.988,-2.011,-2.116,-2.172,-2.172,-2.233,-2.233,-2.279};
			return value;
		}
		private double[] getElevationGrid_5_24_height_5()
		{
			double[] value = {-2.61,-2.633,-2.698,-2.665,-2.66,-2.658,-2.629,-2.602,-2.586,-2.575,-2.553,-2.537,-2.562,-2.613,-2.537,-2.537,-2.537,-2.531,-2.53,-2.522,-2.507,-2.468,-2.388,-2.415,-2.404,-2.378,-2.352,-2.312,-2.367,-2.355,-2.355,-2.349,-2.323,-2.314,-2.303,-2.296,-2.285,-2.285,-2.294,-2.294,-2.293,-2.293,-2.294,-2.298,-2.239,-2.207,-2.169,-2.115,-2.054,-2.009,-1.946,-1.908,-1.844,-1.766,-1.684,-1.673,-1.685,-1.63,-1.808,-1.8,-1.775,-1.981,-1.996,-2.019,-2.065,-2.002,-1.988,-1.989,-1.936,-2.037,-2.065,-2.062,-2.05,-2.091,-2.172,-2.172,-2.208,-2.257,-2.256,-2.282,-2.478,-2.5,-2.658,-2.674,-2.688,-2.659,-2.628,-2.611,-2.615,-2.598,-2.587,-2.579,-2.598,-2.635,-2.555,-2.538,-2.537,-2.537,-2.537,-2.537,-2.529,-2.477,-2.473,-2.462,-2.423,-2.416,-2.399,-2.36,-2.405,-2.356,-2.366,-2.363,-2.357,-2.351,-2.348,-2.335,-2.322,-2.314,-2.327,-2.319,-2.322,-2.339,-2.319,-2.291,-2.248,-2.208,-2.17,-2.097,-2.026,-1.986,-1.885,-1.842,-1.808,-1.73,-1.6,-1.555,-1.58,-1.715,-1.738,-1.827,-1.919,-1.957,-2.011,-2.049,-2.079,-2.0,-1.967,-2.02,-1.986,-2.065,-2.078,-2.111,-2.111,-2.112,-2.166,-2.232,-2.233,-2.295,-2.292,-2.23,-2.432,-2.477,-2.554,-2.653,-2.664,-2.635,-2.629,-2.634,-2.671,-2.598,-2.6,-2.598,-2.603,-2.645,-2.598,-2.598,-2.567,-2.565,-2.568,-2.572,-2.537,-2.512,-2.491,-2.477,-2.455,-2.419,-2.366,-2.414,-2.411,-2.389,-2.408,-2.404,-2.393,-2.384,-2.375,-2.363,-2.355,-2.352,-2.354,-2.353,-2.368,-2.355,-2.336,-2.301,-2.242,-2.19,-2.138,-2.06,-1.913,-1.812,-1.662,-1.652,-1.703,-1.585,-1.551,-1.444,-1.415,-1.581,-1.673,-1.806,-1.828,-1.861,-2.0,-1.943,-2.085,-2.045,-2.062,-2.09,-2.117,-2.14,-2.132,-2.14,-2.164,-2.163,-2.172,-2.231,-2.244,-2.301,-2.258,-2.144,-2.48,-2.544,-2.599,-2.602,-2.659,-2.671,-2.672,-2.672,-2.672,-2.667,-2.66,-2.639,-2.628,-2.672,-2.665,-2.671,-2.598,-2.598,-2.597,-2.598,-2.577,-2.537,-2.537,-2.534,-2.502,-2.474,-2.456,-2.476,-2.426,-2.416,-2.42,-2.42,-2.418,-2.417,-2.411,-2.397,-2.395,-2.393,-2.39,-2.402,-2.383,-2.365,-2.333,-2.297,-2.238,-2.13,-2.05,-1.951,-1.836,-1.596,-1.384,-1.323,-1.394,-1.201,-1.211,-1.23,-1.048,-1.265,-1.551,-1.607,-1.476,-1.667,-1.919,-2.063,-2.119,-2.024,-2.119,-2.145,-2.163,-2.171,-2.167,-2.172,-2.174,-2.203,-2.228,-2.233,-2.293,-2.314,-2.275,-2.17,-2.537,-2.55,-2.538,-2.62,-2.662,-2.672,-2.672,-2.672,-2.672,-2.672,-2.672,-2.672,-2.672,-2.672,-2.672,-2.672,-2.663,-2.665,-2.603,-2.619,-2.611,-2.593,-2.592,-2.573,-2.537,-2.537,-2.489,-2.473,-2.457,-2.431,-2.472,-2.462,-2.456,-2.446,-2.431,-2.416,-2.412,-2.412,-2.416,-2.419,-2.389,-2.355,-2.278,-2.153,-1.987,-1.981,-1.803,-1.681,-1.518,-1.402,-1.643,-1.663,-1.469,-0.917,-0.885,-1.297,-1.359,-1.314,-1.156,-1.433,-1.536,-1.729,-1.787,-2.103,-2.139,-2.161,-2.161,-2.171,-2.191,-2.197,-2.201,-2.215,-2.219,-2.233,-2.234,-2.289,-2.296,-2.305,-2.185,-2.112,-2.537,-2.539,-2.586,-2.564,-2.578,-2.669,-2.672,-2.672,-2.672,-2.672,-2.672,-2.672,-2.672,-2.672,-2.672,-2.643,-2.629,-2.672,-2.672,-2.672,-2.672,-2.646,-2.611,-2.6,-2.598,-2.544,-2.535,-2.48,-2.476,-2.478,-2.481,-2.479,-2.477,-2.476,-2.466,-2.462,-2.451,-2.438,-2.438,-2.412,-2.359,-2.311,-2.083,-1.91,-2.063,-2.12,-1.928,-1.803,-1.715,-1.851,-1.784,-1.416,-1.3,-1.226,-1.131,-1.377,-1.662,-1.526,-1.592,-1.766,-1.775,-1.991,-2.096,-2.133,-2.153,-2.182,-2.169,-2.174,-2.202,-2.232,-2.233,-2.233,-2.233,-2.24,-2.238,-2.303,-2.32,-2.243,-2.171,-2.135,-2.537,-2.515,-2.538,-2.538,-2.507,-2.533,-2.671,-2.62,-2.645,-2.654,-2.672,-2.672,-2.672,-2.66,-2.601,-2.577,-2.581,-2.598,-2.599,-2.61,-2.649,-2.672,-2.672,-2.672,-2.6,-2.597,-2.537,-2.537,-2.518,-2.526,-2.533,-2.52,-2.515,-2.498,-2.481,-2.475,-2.475,-2.481,-2.451,-2.423,-2.319,-2.294,-2.276,-2.258,-2.232,-2.085,-2.077,-1.985,-2.013,-1.73,-1.392,-1.389,-1.304,-1.344,-1.477,-1.634,-1.671,-1.424,-1.702,-1.837,-1.99,-2.096,-2.154,-2.16,-2.163,-2.17,-2.177,-2.203,-2.217,-2.232,-2.263,-2.259,-2.284,-2.29,-2.295,-2.337,-2.312,-2.234,-2.172,-2.118,-2.479,-2.481,-2.5,-2.519,-2.522,-2.598,-2.637,-2.607,-2.559,-2.562,-2.605,-2.572,-2.6,-2.54,-2.536,-2.518,-2.503,-2.534,-2.528,-2.521,-2.536,-2.567,-2.604,-2.672,-2.662,-2.598,-2.598,-2.564,-2.565,-2.558,-2.545,-2.538,-2.537,-2.526,-2.512,-2.497,-2.499,-2.476,-2.468,-2.433,-2.36,-2.355,-2.301,-2.294,-2.233,-2.176,-2.131,-2.09,-1.99,-1.71,-1.546,-1.682,-1.334,-1.614,-1.614,-1.692,-1.925,-1.855,-1.948,-2.01,-2.083,-2.152,-2.181,-2.178,-2.173,-2.173,-2.188,-2.24,-2.231,-2.25,-2.274,-2.293,-2.294,-2.3,-2.331,-2.364,-2.289,-2.182,-2.148,-2.1,-2.494,-2.507,-2.507,-2.511,-2.556,-2.599,-2.617,-2.568,-2.486,-2.525,-2.539,-2.538,-2.49,-2.449,-2.419,-2.416,-2.388,-2.263,-2.343,-2.243,-2.188,-2.397,-2.499,-2.581,-2.672,-2.672,-2.631,-2.599,-2.598,-2.598,-2.593,-2.582,-2.565,-2.545,-2.537,-2.533,-2.513,-2.492,-2.476,-2.451,-2.414,-2.381,-2.351,-2.296,-2.257,-2.216,-2.171,-2.125,-2.021,-1.836,-1.817,-1.543,-1.551,-1.604,-1.616,-1.527,-1.624,-1.974,-2.038,-2.079,-2.134,-2.18,-2.202,-2.206,-2.213,-2.205,-2.202,-2.219,-2.262,-2.299,-2.311,-2.306,-2.352,-2.344,-2.355,-2.318,-2.226,-2.168,-2.113,-2.017,-2.506,-2.507,-2.514,-2.532,-2.553,-2.586,-2.545,-2.537,-2.44,-2.436,-2.465,-2.49,-2.351,-2.206,-2.238,-2.313,-2.273,-2.158,-1.995,-2.16,-2.163,-2.184,-2.243,-2.337,-2.575,-2.648,-2.672,-2.672,-2.665,-2.6,-2.598,-2.598,-2.584,-2.539,-2.539,-2.533,-2.519,-2.503,-2.485,-2.463,-2.424,-2.397,-2.361,-2.318,-2.278,-2.235,-2.204,-2.172,-2.076,-1.912,-1.846,-1.747,-1.706,-1.738,-1.642,-1.857,-1.857,-2.053,-2.075,-2.114,-2.167,-2.195,-2.219,-2.22,-2.217,-2.218,-2.221,-2.228,-2.236,-2.255,-2.276,-2.294,-2.346,-2.365,-2.358,-2.279,-2.175,-2.071,-1.97,-1.746,-2.535,-2.536,-2.537,-2.54,-2.538,-2.554,-2.543,-2.482,-2.477,-2.476,-2.462,-2.434,-2.383,-2.343,-2.356,-2.416,-2.326,-2.176,-2.3,-2.343,-2.411,-2.48,-2.494,-2.529,-2.59,-2.626,-2.659,-2.672,-2.672,-2.672,-2.651,-2.6,-2.593,-2.58,-2.567,-2.537,-2.537,-2.528,-2.499,-2.476,-2.437,-2.409,-2.368,-2.334,-2.296,-2.275,-2.236,-2.173,-2.113,-2.04,-1.961,-1.919,-1.866,-1.716,-1.925,-1.85,-2.031,-2.101,-2.114,-2.141,-2.172,-2.205,-2.227,-2.217,-2.21,-2.204,-2.21,-2.221,-2.234,-2.246,-2.26,-2.275,-2.294,-2.35,-2.409,-2.312,-2.206,-2.121,-2.084,-1.677,-2.537,-2.55,-2.553,-2.555,-2.542,-2.538,-2.537,-2.511,-2.491,-2.485,-2.479,-2.462,-2.451,-2.444,-2.453,-2.476,-2.481,-2.483,-2.488,-2.516,-2.534,-2.546,-2.565,-2.588,-2.599,-2.616,-2.647,-2.672,-2.672,-2.672,-2.672,-2.638,-2.598,-2.598,-2.579,-2.553,-2.542,-2.537,-2.513,-2.479,-2.452,-2.417,-2.387,-2.355,-2.331,-2.297,-2.251,-2.208,-2.172,-2.123,-2.058,-2.05,-1.935,-1.972,-1.927,-2.05,-2.079,-2.121,-2.149,-2.169,-2.187,-2.22,-2.209,-2.19,-2.175,-2.172,-2.173,-2.215,-2.232,-2.233,-2.234,-2.267,-2.293,-2.355,-2.355,-2.421,-2.294,-2.227,-2.074,-1.944,-2.551,-2.567,-2.568,-2.543,-2.552,-2.552,-2.542,-2.538,-2.528,-2.513,-2.49,-2.485,-2.479,-2.485,-2.505,-2.519,-2.537,-2.539,-2.551,-2.563,-2.56,-2.57,-2.582,-2.591,-2.599,-2.602,-2.638,-2.672,-2.672,-2.672,-2.672,-2.672,-2.628,-2.598,-2.598,-2.591,-2.57,-2.548,-2.527,-2.494};
			return value;
		}
		private double[] getElevationGrid_5_24_height_6()
		{
			double[] value = {-2.468,-2.435,-2.41,-2.384,-2.356,-2.316,-2.279,-2.239,-2.221,-2.173,-2.172,-2.128,-2.086,-1.995,-2.105,-2.111,-2.133,-2.154,-2.176,-2.196,-2.211,-2.217,-2.175,-2.153,-2.133,-2.136,-2.173,-2.233,-2.246,-2.294,-2.266,-2.294,-2.349,-2.396,-2.401,-2.428,-2.366,-2.292,-2.168,-2.134,-2.572,-2.564,-2.551,-2.543,-2.545,-2.546,-2.537,-2.538,-2.54,-2.54,-2.527,-2.532,-2.535,-2.538,-2.543,-2.554,-2.564,-2.595,-2.596,-2.598,-2.565,-2.57,-2.572,-2.575,-2.584,-2.597,-2.623,-2.672,-2.672,-2.639,-2.648,-2.672,-2.666,-2.606,-2.61,-2.606,-2.598,-2.566,-2.537,-2.512,-2.477,-2.452,-2.424,-2.409,-2.374,-2.343,-2.304,-2.28,-2.276,-2.262,-2.233,-2.192,-2.201,-2.144,-2.182,-2.173,-2.172,-2.172,-2.189,-2.233,-2.232,-2.111,-2.113,-2.113,-2.074,-2.087,-2.112,-2.107,-2.244,-2.3,-2.292,-2.299,-2.283,-2.337,-2.414,-2.446,-2.359,-2.234,-2.243,-2.192,-2.57,-2.544,-2.536,-2.537,-2.538,-2.531,-2.532,-2.538,-2.539,-2.541,-2.537,-2.537,-2.551,-2.564,-2.568,-2.579,-2.598,-2.606,-2.608,-2.577,-2.568,-2.568,-2.568,-2.568,-2.568,-2.575,-2.599,-2.634,-2.645,-2.636,-2.654,-2.672,-2.672,-2.658,-2.652,-2.642,-2.598,-2.595,-2.538,-2.531,-2.49,-2.472,-2.417,-2.416,-2.361,-2.332,-2.297,-2.292,-2.298,-2.295,-2.233,-2.255,-2.236,-2.221,-2.234,-2.24,-2.239,-2.207,-2.214,-2.115,-2.238,-2.173,-2.172,-2.181,-2.156,-2.172,-2.123,-2.19,-2.29,-2.33,-2.282,-2.293,-2.354,-2.352,-2.442,-2.458,-2.408,-2.307,-2.295,-2.248,-2.556,-2.541,-2.53,-2.536,-2.532,-2.527,-2.523,-2.527,-2.531,-2.537,-2.533,-2.552,-2.572,-2.584,-2.588,-2.592,-2.6,-2.608,-2.598,-2.57,-2.562,-2.562,-2.562,-2.562,-2.56,-2.556,-2.569,-2.599,-2.61,-2.615,-2.64,-2.661,-2.672,-2.672,-2.637,-2.612,-2.647,-2.598,-2.561,-2.533,-2.495,-2.475,-2.434,-2.379,-2.285,-2.189,-2.233,-2.237,-2.276,-2.305,-2.164,-2.285,-2.262,-2.249,-2.288,-2.294,-2.293,-2.241,-2.094,-2.145,-2.233,-2.178,-2.239,-2.225,-2.197,-1.955,-2.008,-2.234,-2.348,-2.403,-2.354,-2.356,-2.401,-2.389,-2.474,-2.457,-2.419,-2.36,-2.323,-2.307,-2.548,-2.54,-2.536,-2.528,-2.523,-2.52,-2.518,-2.517,-2.517,-2.521,-2.535,-2.545,-2.558,-2.571,-2.578,-2.582,-2.588,-2.596,-2.6,-2.568,-2.565,-2.566,-2.562,-2.559,-2.556,-2.553,-2.558,-2.574,-2.575,-2.588,-2.603,-2.627,-2.644,-2.663,-2.558,-2.539,-2.659,-2.623,-2.588,-2.544,-2.509,-2.482,-2.42,-2.362,-2.235,-2.133,-2.207,-2.215,-2.303,-2.265,-2.172,-2.181,-2.293,-2.167,-2.296,-2.355,-2.173,-2.223,-1.965,-2.117,-2.262,-2.406,-2.402,-2.338,-2.257,-2.131,-2.111,-2.281,-2.414,-2.422,-2.364,-2.355,-2.434,-2.474,-2.493,-2.434,-2.416,-2.358,-2.342,-2.314,-2.538,-2.532,-2.526,-2.518,-2.515,-2.511,-2.508,-2.507,-2.507,-2.511,-2.516,-2.53,-2.544,-2.552,-2.566,-2.571,-2.575,-2.578,-2.587,-2.575,-2.566,-2.568,-2.563,-2.558,-2.555,-2.552,-2.551,-2.552,-2.553,-2.558,-2.579,-2.589,-2.588,-2.575,-2.569,-2.602,-2.635,-2.638,-2.598,-2.572,-2.539,-2.51,-2.476,-2.422,-2.297,-2.181,-2.294,-2.341,-2.255,-2.356,-2.3,-2.281,-2.34,-2.342,-2.394,-2.392,-2.305,-2.335,-2.18,-1.894,-2.278,-2.473,-2.476,-2.417,-2.373,-2.348,-2.348,-2.376,-2.475,-2.434,-2.461,-2.471,-2.45,-2.484,-2.489,-2.442,-2.416,-2.413,-2.392,-2.385,-2.538,-2.526,-2.517,-2.51,-2.508,-2.497,-2.487,-2.489,-2.49,-2.493,-2.499,-2.515,-2.532,-2.538,-2.545,-2.559,-2.561,-2.563,-2.57,-2.568,-2.558,-2.564,-2.566,-2.56,-2.554,-2.546,-2.545,-2.543,-2.544,-2.549,-2.556,-2.56,-2.561,-2.562,-2.567,-2.6,-2.62,-2.645,-2.619,-2.597,-2.564,-2.534,-2.49,-2.45,-2.391,-2.261,-2.313,-2.4,-2.356,-2.396,-2.404,-2.414,-2.417,-2.422,-2.42,-2.419,-2.319,-2.338,-2.338,-2.349,-2.469,-2.482,-2.482,-2.469,-2.469,-2.468,-2.464,-2.474,-2.482,-2.472,-2.499,-2.478,-2.452,-2.485,-2.477,-2.422,-2.421,-2.419,-2.416,-2.421,-2.529,-2.517,-2.51,-2.498,-2.481,-2.478,-2.477,-2.476,-2.474,-2.475,-2.484,-2.498,-2.51,-2.52,-2.532,-2.539,-2.547,-2.551,-2.559,-2.556,-2.542,-2.558,-2.568,-2.562,-2.553,-2.543,-2.539,-2.538,-2.538,-2.541,-2.551,-2.553,-2.553,-2.553,-2.553,-2.579,-2.607,-2.627,-2.64,-2.631,-2.587,-2.548,-2.523,-2.483,-2.467,-2.402,-2.439,-2.426,-2.434,-2.449,-2.463,-2.467,-2.462,-2.473,-2.473,-2.468,-2.475,-2.504,-2.52,-2.537,-2.529,-2.537,-2.531,-2.515,-2.523,-2.544,-2.546,-2.542,-2.54,-2.547,-2.548,-2.505,-2.499,-2.528,-2.5,-2.47,-2.45,-2.453,-2.449,-2.453,-2.514,-2.505,-2.493,-2.479,-2.472,-2.463,-2.46,-2.457,-2.457,-2.463,-2.472,-2.48,-2.489,-2.5,-2.509,-2.518,-2.526,-2.535,-2.537,-2.538,-2.53,-2.548,-2.564,-2.564,-2.553,-2.541,-2.528,-2.52,-2.523,-2.535,-2.542,-2.556,-2.555,-2.554,-2.553,-2.555,-2.587,-2.612,-2.624,-2.635,-2.616,-2.592,-2.568,-2.545,-2.531,-2.529,-2.515,-2.489,-2.503,-2.49,-2.499,-2.504,-2.501,-2.514,-2.505,-2.518,-2.517,-2.543,-2.55,-2.577,-2.587,-2.54,-2.538,-2.564,-2.578,-2.589,-2.587,-2.571,-2.57,-2.575,-2.574,-2.563,-2.526,-2.537,-2.512,-2.484,-2.467,-2.471,-2.479,-2.481,-2.493,-2.479,-2.473,-2.463,-2.454,-2.446,-2.442,-2.436,-2.432,-2.438,-2.448,-2.458,-2.469,-2.481,-2.493,-2.504,-2.516,-2.528,-2.535,-2.537,-2.537,-2.55,-2.554,-2.553,-2.542,-2.538,-2.521,-2.509,-2.515,-2.523,-2.538,-2.555,-2.555,-2.554,-2.552,-2.545,-2.569,-2.598,-2.608,-2.621,-2.634,-2.621,-2.607,-2.599,-2.595,-2.597,-2.565,-2.542,-2.54,-2.537,-2.538,-2.537,-2.536,-2.547,-2.56,-2.553,-2.554,-2.571,-2.584,-2.591,-2.596,-2.595,-2.595,-2.594,-2.591,-2.59,-2.588,-2.585,-2.583,-2.581,-2.575,-2.571,-2.542,-2.517,-2.496,-2.477,-2.471,-2.475,-2.497,-2.503,-2.471,-2.459,-2.449,-2.442,-2.436,-2.429,-2.424,-2.415,-2.412,-2.415,-2.419,-2.43,-2.443,-2.462,-2.477,-2.49,-2.502,-2.518,-2.532,-2.539,-2.55,-2.559,-2.559,-2.555,-2.538,-2.526,-2.514,-2.498,-2.509,-2.527,-2.54,-2.555,-2.555,-2.555,-2.55,-2.537,-2.538,-2.546,-2.576,-2.605,-2.618,-2.629,-2.629,-2.626,-2.626,-2.626,-2.616,-2.597,-2.597,-2.588,-2.577,-2.572,-2.586,-2.599,-2.603,-2.6,-2.599,-2.602,-2.601,-2.6,-2.6,-2.598,-2.596,-2.592,-2.59,-2.588,-2.587,-2.555,-2.577,-2.523,-2.574,-2.568,-2.55,-2.508,-2.502,-2.534,-2.53,-2.51,-2.507,-2.527,-2.446,-2.436,-2.426,-2.421,-2.418,-2.407,-2.398,-2.386,-2.378,-2.381,-2.39,-2.404,-2.417,-2.435,-2.456,-2.478,-2.488,-2.504,-2.521,-2.536,-2.551,-2.555,-2.554,-2.553,-2.538,-2.519,-2.504,-2.482,-2.515,-2.524,-2.539,-2.547,-2.553,-2.553,-2.538,-2.528,-2.501,-2.472,-2.471,-2.562,-2.603,-2.609,-2.627,-2.623,-2.624,-2.626,-2.626,-2.619,-2.611,-2.609,-2.61,-2.607,-2.607,-2.61,-2.611,-2.605,-2.606,-2.604,-2.593,-2.599,-2.586,-2.57,-2.547,-2.538,-2.542,-2.54,-2.522,-2.536,-2.514,-2.565,-2.574,-2.572,-2.519,-2.551,-2.568,-2.563,-2.562,-2.551,-2.54,-2.553,-2.421,-2.415,-2.4,-2.39,-2.381,-2.373,-2.365,-2.357,-2.346,-2.349,-2.354,-2.365,-2.386,-2.409,-2.429,-2.453,-2.474,-2.491,-2.508,-2.527,-2.546,-2.554,-2.553,-2.547,-2.537,-2.521,-2.508,-2.507,-2.516,-2.523,-2.534,-2.554,-2.55,-2.545,-2.539,-2.531,-2.51,-2.489,-2.477,-2.532,-2.539,-2.57,-2.612,-2.621,-2.625,-2.624,-2.625,-2.622,-2.621,-2.618,-2.617,-2.616,-2.611,-2.603,-2.597,-2.582,-2.568,-2.557,-2.544,-2.538,-2.539,-2.538,-2.538,-2.492,-2.482,-2.484,-2.469,-2.502,-2.477,-2.475,-2.514,-2.554,-2.538,-2.568,-2.568,-2.556,-2.562,-2.562,-2.562,-2.561};
			return value;
		}
		private double[] getElevationGrid_5_24_height_7()
		{
			double[] value = {-2.392,-2.381,-2.367,-2.354,-2.34,-2.333,-2.327,-2.312,-2.305,-2.304,-2.309,-2.329,-2.353,-2.376,-2.402,-2.428,-2.454,-2.479,-2.496,-2.52,-2.541,-2.553,-2.55,-2.538,-2.537,-2.525,-2.507,-2.511,-2.52,-2.537,-2.538,-2.545,-2.551,-2.548,-2.542,-2.535,-2.527,-2.519,-2.517,-2.528,-2.535,-2.555,-2.56,-2.598,-2.603,-2.609,-2.61,-2.606,-2.605,-2.602,-2.603,-2.602,-2.592,-2.555,-2.543,-2.541,-2.536,-2.538,-2.538,-2.538,-2.538,-2.496,-2.477,-2.479,-2.477,-2.453,-2.444,-2.488,-2.44,-2.46,-2.428,-2.478,-2.538,-2.538,-2.538,-2.538,-2.539,-2.562,-2.562,-2.561,-2.36,-2.348,-2.331,-2.314,-2.293,-2.287,-2.289,-2.267,-2.257,-2.261,-2.267,-2.286,-2.306,-2.338,-2.367,-2.403,-2.433,-2.46,-2.483,-2.51,-2.535,-2.555,-2.559,-2.544,-2.54,-2.533,-2.52,-2.524,-2.527,-2.536,-2.539,-2.55,-2.551,-2.55,-2.544,-2.539,-2.538,-2.538,-2.539,-2.535,-2.537,-2.549,-2.543,-2.538,-2.541,-2.55,-2.564,-2.563,-2.553,-2.58,-2.538,-2.54,-2.54,-2.538,-2.532,-2.477,-2.476,-2.479,-2.482,-2.477,-2.457,-2.474,-2.452,-2.472,-2.431,-2.417,-2.444,-2.459,-2.416,-2.416,-2.416,-2.416,-2.467,-2.496,-2.521,-2.519,-2.531,-2.548,-2.562,-2.561,-2.313,-2.307,-2.29,-2.263,-2.244,-2.233,-2.234,-2.213,-2.208,-2.217,-2.216,-2.214,-2.247,-2.302,-2.34,-2.376,-2.414,-2.442,-2.475,-2.502,-2.532,-2.556,-2.567,-2.553,-2.546,-2.54,-2.533,-2.532,-2.535,-2.537,-2.544,-2.553,-2.552,-2.551,-2.548,-2.543,-2.539,-2.538,-2.537,-2.537,-2.54,-2.545,-2.537,-2.532,-2.534,-2.538,-2.537,-2.537,-2.537,-2.561,-2.539,-2.515,-2.526,-2.513,-2.478,-2.461,-2.475,-2.473,-2.475,-2.403,-2.416,-2.418,-2.413,-2.44,-2.417,-2.439,-2.45,-2.46,-2.445,-2.426,-2.416,-2.416,-2.419,-2.471,-2.477,-2.478,-2.499,-2.521,-2.538,-2.559,-2.265,-2.256,-2.236,-2.203,-2.179,-2.142,-2.106,-2.08,-2.127,-2.136,-2.145,-2.07,-2.179,-2.256,-2.305,-2.352,-2.392,-2.423,-2.463,-2.493,-2.526,-2.555,-2.568,-2.562,-2.555,-2.552,-2.54,-2.539,-2.538,-2.551,-2.554,-2.553,-2.552,-2.552,-2.551,-2.548,-2.542,-2.537,-2.533,-2.531,-2.545,-2.546,-2.539,-2.522,-2.528,-2.521,-2.522,-2.527,-2.536,-2.538,-2.519,-2.493,-2.48,-2.475,-2.455,-2.42,-2.421,-2.416,-2.416,-2.416,-2.414,-2.416,-2.363,-2.398,-2.424,-2.42,-2.445,-2.448,-2.447,-2.429,-2.417,-2.427,-2.418,-2.478,-2.452,-2.475,-2.478,-2.496,-2.51,-2.525,-2.145,-2.171,-2.122,-2.1,-2.057,-2.031,-2.002,-2.041,-1.976,-2.051,-2.035,-1.928,-2.13,-2.182,-2.269,-2.334,-2.377,-2.417,-2.453,-2.485,-2.522,-2.554,-2.572,-2.566,-2.563,-2.56,-2.55,-2.549,-2.55,-2.558,-2.557,-2.553,-2.553,-2.553,-2.552,-2.549,-2.545,-2.539,-2.532,-2.536,-2.542,-2.54,-2.529,-2.508,-2.505,-2.491,-2.489,-2.494,-2.537,-2.518,-2.498,-2.457,-2.428,-2.417,-2.416,-2.39,-2.365,-2.355,-2.411,-2.41,-2.373,-2.356,-2.357,-2.355,-2.406,-2.416,-2.412,-2.415,-2.418,-2.412,-2.375,-2.416,-2.416,-2.416,-2.416,-2.431,-2.462,-2.477,-2.481,-2.484,-2.113,-1.894,-1.965,-1.987,-1.883,-1.978,-1.896,-1.939,-1.87,-2.046,-1.773,-2.023,-2.14,-2.106,-2.234,-2.318,-2.361,-2.4,-2.441,-2.48,-2.515,-2.55,-2.571,-2.569,-2.568,-2.569,-2.562,-2.561,-2.56,-2.563,-2.559,-2.553,-2.554,-2.553,-2.551,-2.546,-2.541,-2.537,-2.537,-2.538,-2.538,-2.527,-2.51,-2.482,-2.467,-2.457,-2.457,-2.477,-2.478,-2.468,-2.4,-2.384,-2.397,-2.308,-2.352,-2.308,-2.354,-2.255,-2.308,-2.32,-2.324,-2.288,-2.312,-2.313,-2.355,-2.355,-2.374,-2.363,-2.355,-2.363,-2.4,-2.416,-2.416,-2.414,-2.437,-2.416,-2.43,-2.449,-2.476,-2.477,-2.018,-2.172,-2.172,-2.096,-1.771,-1.791,-1.779,-1.805,-1.972,-2.022,-2.035,-2.128,-2.185,-2.207,-2.269,-2.307,-2.356,-2.396,-2.437,-2.477,-2.51,-2.542,-2.566,-2.572,-2.57,-2.568,-2.568,-2.565,-2.565,-2.563,-2.561,-2.558,-2.556,-2.554,-2.553,-2.548,-2.542,-2.537,-2.536,-2.533,-2.533,-2.507,-2.482,-2.453,-2.43,-2.416,-2.419,-2.451,-2.475,-2.475,-2.419,-2.356,-2.355,-2.353,-2.295,-2.296,-2.351,-2.294,-2.285,-2.199,-2.249,-2.227,-2.243,-2.32,-2.349,-2.331,-2.355,-2.355,-2.321,-2.354,-2.364,-2.411,-2.416,-2.386,-2.429,-2.411,-2.416,-2.436,-2.448,-2.464,-2.191,-2.233,-2.236,-2.195,-2.111,-2.003,-1.823,-2.029,-2.004,-1.99,-2.049,-2.096,-2.124,-2.155,-2.233,-2.292,-2.347,-2.394,-2.437,-2.477,-2.509,-2.539,-2.558,-2.571,-2.573,-2.571,-2.568,-2.569,-2.566,-2.562,-2.561,-2.559,-2.557,-2.555,-2.554,-2.553,-2.547,-2.54,-2.537,-2.533,-2.531,-2.514,-2.477,-2.43,-2.379,-2.379,-2.366,-2.416,-2.45,-2.465,-2.445,-2.412,-2.373,-2.32,-2.252,-2.263,-2.297,-2.283,-2.272,-2.232,-2.233,-2.233,-2.219,-2.295,-2.295,-2.295,-2.307,-2.336,-2.298,-2.355,-2.376,-2.355,-2.365,-2.397,-2.386,-2.396,-2.407,-2.419,-2.441,-2.453,-2.283,-2.294,-2.301,-2.108,-2.148,-2.138,-2.091,-2.032,-1.895,-1.817,-2.003,-2.05,-1.96,-2.03,-2.19,-2.289,-2.342,-2.389,-2.435,-2.477,-2.502,-2.528,-2.55,-2.569,-2.573,-2.571,-2.568,-2.569,-2.566,-2.562,-2.56,-2.559,-2.559,-2.557,-2.555,-2.552,-2.546,-2.54,-2.538,-2.538,-2.537,-2.51,-2.472,-2.417,-2.416,-2.409,-2.422,-2.443,-2.446,-2.446,-2.429,-2.416,-2.385,-2.351,-2.293,-2.267,-2.249,-2.238,-2.245,-2.233,-2.173,-2.177,-2.233,-2.248,-2.294,-2.241,-2.292,-2.291,-2.294,-2.348,-2.354,-2.352,-2.359,-2.356,-2.385,-2.397,-2.408,-2.418,-2.436,-2.446,-2.352,-2.201,-2.266,-2.016,-2.099,-2.128,-2.114,-1.836,-1.93,-2.141,-2.059,-2.083,-2.115,-2.14,-2.129,-2.22,-2.279,-2.381,-2.429,-2.471,-2.495,-2.522,-2.547,-2.569,-2.57,-2.57,-2.568,-2.568,-2.568,-2.563,-2.558,-2.561,-2.562,-2.561,-2.557,-2.552,-2.544,-2.538,-2.538,-2.538,-2.545,-2.513,-2.482,-2.458,-2.447,-2.424,-2.445,-2.458,-2.458,-2.45,-2.432,-2.411,-2.386,-2.341,-2.306,-2.29,-2.241,-2.281,-2.244,-2.209,-2.158,-2.085,-2.217,-2.199,-2.173,-2.179,-2.193,-2.245,-2.294,-2.294,-2.295,-2.328,-2.341,-2.352,-2.367,-2.384,-2.401,-2.417,-2.428,-2.42,-2.164,-2.41,-2.149,-2.176,-1.85,-2.305,-2.231,-2.258,-2.227,-2.085,-2.027,-2.032,-2.152,-2.212,-2.249,-2.294,-2.347,-2.371,-2.419,-2.454,-2.488,-2.516,-2.544,-2.565,-2.572,-2.571,-2.568,-2.568,-2.568,-2.565,-2.561,-2.559,-2.562,-2.565,-2.564,-2.558,-2.552,-2.547,-2.543,-2.538,-2.538,-2.525,-2.508,-2.48,-2.463,-2.472,-2.477,-2.479,-2.477,-2.455,-2.435,-2.415,-2.392,-2.364,-2.319,-2.226,-2.167,-2.294,-2.255,-2.233,-2.188,-2.172,-2.176,-2.199,-2.174,-2.173,-2.201,-2.233,-2.269,-2.294,-2.293,-2.295,-2.319,-2.33,-2.351,-2.371,-2.389,-2.407,-2.416,-2.445,-2.24,-2.389,-2.238,-2.291,-2.02,-2.321,-2.322,-2.273,-2.019,-1.841,-2.051,-1.869,-1.977,-2.141,-2.2,-2.295,-2.358,-2.392,-2.418,-2.451,-2.482,-2.512,-2.539,-2.558,-2.571,-2.579,-2.576,-2.571,-2.568,-2.567,-2.566,-2.561,-2.565,-2.567,-2.568,-2.562,-2.556,-2.551,-2.548,-2.544,-2.54,-2.538,-2.522,-2.508,-2.497,-2.498,-2.495,-2.488,-2.475,-2.455,-2.438,-2.421,-2.402,-2.379,-2.356,-2.312,-2.311,-2.298,-2.279,-2.239,-2.2,-2.155,-2.072,-2.067,-2.112,-2.157,-2.165,-2.168,-2.241,-2.233,-2.233,-2.187,-2.282,-2.304,-2.331,-2.359,-2.371,-2.392,-2.411,-2.429,-2.08,-2.431,-2.501,-2.452,-2.255,-2.178,-2.361,-2.052,-1.981,-1.993,-2.082,-2.078,-2.054,-2.094,-2.231,-2.276,-2.333,-2.359,-2.408,-2.451,-2.486,-2.514,-2.538,-2.553,-2.567,-2.595,-2.595,-2.574,-2.568,-2.568,-2.568,-2.568,-2.569,-2.57,-2.568,-2.564,-2.557,-2.551,-2.547,-2.543};
			return value;
		}
		private double[] getElevationGrid_5_24_height_8()
		{
			double[] value = {-2.54,-2.536,-2.527,-2.52,-2.513,-2.507,-2.496,-2.487,-2.473,-2.454,-2.439,-2.424,-2.408,-2.388,-2.361,-2.344,-2.316,-2.295,-2.247,-2.21,-2.15,-2.108,-2.087,-1.967,-1.907,-2.062,-2.113,-2.163,-2.232,-2.229,-2.229,-2.177,-2.079,-2.21,-2.304,-2.335,-2.353,-2.369,-2.393,-2.416,-2.125,-2.292,-2.559,-2.447,-2.349,-2.463,-2.453,-2.199,-2.007,-1.949,-2.083,-2.216,-2.16,-2.054,-2.098,-2.249,-2.294,-2.293,-2.389,-2.444,-2.48,-2.507,-2.533,-2.549,-2.562,-2.598,-2.598,-2.596,-2.577,-2.568,-2.573,-2.572,-2.571,-2.57,-2.569,-2.564,-2.558,-2.551,-2.548,-2.545,-2.54,-2.537,-2.53,-2.522,-2.512,-2.505,-2.497,-2.487,-2.474,-2.46,-2.444,-2.431,-2.416,-2.391,-2.359,-2.337,-2.304,-2.294,-2.237,-2.187,-2.146,-2.137,-2.111,-2.026,-1.99,-2.061,-2.113,-2.172,-2.174,-2.185,-2.226,-2.172,-2.136,-2.17,-1.993,-2.229,-2.305,-2.342,-2.373,-2.396,-2.328,-2.449,-2.36,-2.308,-2.327,-2.453,-2.498,-2.41,-2.263,-1.918,-2.28,-1.958,-1.903,-1.964,-2.169,-2.265,-2.329,-2.369,-2.387,-2.431,-2.472,-2.499,-2.525,-2.543,-2.559,-2.58,-2.599,-2.599,-2.586,-2.58,-2.577,-2.574,-2.573,-2.572,-2.569,-2.565,-2.559,-2.553,-2.55,-2.545,-2.541,-2.537,-2.529,-2.52,-2.509,-2.503,-2.497,-2.49,-2.477,-2.464,-2.447,-2.436,-2.423,-2.398,-2.357,-2.336,-2.298,-2.25,-2.236,-2.2,-2.188,-2.112,-2.051,-1.998,-1.989,-1.931,-2.128,-2.111,-2.127,-2.146,-2.176,-2.172,-2.081,-1.967,-2.019,-2.117,-2.191,-2.288,-2.353,-2.372,-2.664,-2.658,-2.673,-2.683,-2.663,-2.624,-2.604,-2.566,-2.397,-2.235,-2.414,-1.878,-1.936,-2.071,-2.166,-2.244,-2.315,-2.357,-2.399,-2.417,-2.472,-2.493,-2.517,-2.538,-2.556,-2.572,-2.599,-2.603,-2.597,-2.578,-2.574,-2.574,-2.573,-2.572,-2.571,-2.567,-2.562,-2.558,-2.551,-2.547,-2.542,-2.536,-2.526,-2.517,-2.508,-2.502,-2.497,-2.493,-2.483,-2.471,-2.458,-2.446,-2.42,-2.371,-2.34,-2.307,-2.248,-2.212,-2.173,-2.145,-2.107,-2.109,-1.991,-1.944,-1.944,-2.087,-2.112,-2.109,-2.11,-2.173,-2.118,-2.161,-2.115,-2.086,-2.006,-1.867,-1.825,-2.086,-2.285,-2.338,-2.724,-2.704,-2.713,-2.724,-2.696,-2.666,-2.644,-2.616,-2.554,-2.451,-2.332,-2.191,-1.754,-1.921,-1.946,-2.231,-2.309,-2.355,-2.413,-2.438,-2.462,-2.486,-2.503,-2.538,-2.549,-2.56,-2.59,-2.599,-2.598,-2.59,-2.587,-2.584,-2.579,-2.574,-2.571,-2.569,-2.565,-2.558,-2.552,-2.546,-2.539,-2.532,-2.523,-2.512,-2.503,-2.497,-2.494,-2.491,-2.486,-2.478,-2.459,-2.437,-2.417,-2.375,-2.33,-2.288,-2.235,-2.202,-2.123,-2.05,-2.037,-2.132,-2.179,-2.141,-2.153,-2.114,-2.129,-2.109,-2.114,-2.151,-2.111,-2.111,-2.05,-2.057,-2.051,-1.956,-1.898,-1.823,-2.165,-2.299,-2.752,-2.737,-2.748,-2.748,-2.728,-2.7,-2.674,-2.654,-2.601,-2.537,-2.435,-2.272,-2.009,-1.64,-2.034,-2.24,-2.301,-2.355,-2.306,-2.399,-2.439,-2.474,-2.474,-2.486,-2.518,-2.532,-2.547,-2.569,-2.589,-2.578,-2.578,-2.577,-2.575,-2.575,-2.573,-2.569,-2.565,-2.557,-2.545,-2.541,-2.534,-2.525,-2.517,-2.508,-2.497,-2.491,-2.492,-2.49,-2.484,-2.477,-2.454,-2.417,-2.4,-2.383,-2.357,-2.332,-2.299,-2.235,-2.235,-2.191,-2.193,-2.233,-2.229,-2.212,-2.075,-2.031,-2.151,-2.14,-2.111,-2.113,-2.109,-2.108,-2.081,-2.05,-1.998,-1.976,-1.923,-1.977,-2.112,-2.16,-2.777,-2.767,-2.766,-2.761,-2.75,-2.727,-2.703,-2.671,-2.632,-2.573,-2.487,-2.317,-1.667,-1.598,-1.848,-2.035,-2.192,-2.393,-2.373,-2.358,-2.428,-2.397,-2.231,-2.198,-2.452,-2.489,-2.518,-2.545,-2.561,-2.566,-2.569,-2.57,-2.569,-2.57,-2.57,-2.566,-2.561,-2.55,-2.539,-2.533,-2.525,-2.518,-2.51,-2.497,-2.488,-2.477,-2.481,-2.481,-2.479,-2.469,-2.436,-2.418,-2.418,-2.402,-2.386,-2.36,-2.338,-2.313,-2.294,-2.261,-2.252,-2.261,-2.234,-2.129,-2.11,-2.135,-2.132,-2.172,-2.145,-2.139,-2.112,-2.103,-2.048,-2.011,-2.0,-1.97,-2.01,-2.003,-2.065,-2.126,-2.785,-2.782,-2.776,-2.771,-2.761,-2.748,-2.732,-2.704,-2.677,-2.63,-2.551,-2.418,-2.122,-1.941,-1.919,-1.757,-2.238,-2.417,-2.407,-2.359,-2.404,-2.376,-2.226,-2.106,-2.352,-2.433,-2.473,-2.511,-2.54,-2.545,-2.551,-2.555,-2.555,-2.556,-2.557,-2.556,-2.553,-2.541,-2.526,-2.516,-2.511,-2.504,-2.497,-2.487,-2.48,-2.473,-2.467,-2.461,-2.455,-2.449,-2.444,-2.429,-2.423,-2.417,-2.394,-2.371,-2.36,-2.339,-2.32,-2.307,-2.298,-2.294,-2.282,-2.152,-2.127,-2.15,-2.215,-2.206,-2.185,-2.172,-2.113,-2.111,-2.078,-2.042,-2.044,-2.051,-2.052,-2.053,-2.13,-2.172,-2.79,-2.788,-2.787,-2.784,-2.775,-2.761,-2.754,-2.737,-2.724,-2.686,-2.619,-2.473,-2.237,-2.205,-2.19,-1.965,-2.329,-2.473,-2.409,-2.416,-2.374,-2.412,-2.38,-2.357,-2.243,-2.342,-2.403,-2.46,-2.504,-2.519,-2.53,-2.532,-2.533,-2.534,-2.538,-2.538,-2.534,-2.524,-2.508,-2.498,-2.491,-2.482,-2.479,-2.478,-2.466,-2.463,-2.459,-2.453,-2.449,-2.447,-2.446,-2.441,-2.429,-2.417,-2.401,-2.385,-2.371,-2.358,-2.343,-2.336,-2.327,-2.314,-2.307,-2.294,-2.253,-2.251,-2.244,-2.239,-2.218,-2.191,-2.161,-2.126,-2.1,-2.082,-2.087,-2.111,-2.111,-2.158,-2.172,-2.173,-2.793,-2.797,-2.797,-2.784,-2.78,-2.775,-2.769,-2.761,-2.748,-2.719,-2.669,-2.617,-2.487,-2.466,-2.266,-2.346,-2.463,-2.477,-2.446,-2.376,-2.355,-2.416,-2.411,-2.3,-2.135,-2.177,-2.075,-2.24,-2.46,-2.492,-2.506,-2.509,-2.506,-2.507,-2.508,-2.506,-2.507,-2.496,-2.485,-2.478,-2.47,-2.465,-2.459,-2.45,-2.433,-2.449,-2.448,-2.443,-2.436,-2.44,-2.437,-2.432,-2.425,-2.417,-2.407,-2.397,-2.385,-2.371,-2.355,-2.325,-2.295,-2.273,-2.246,-2.27,-2.274,-2.254,-2.234,-2.213,-2.185,-2.159,-2.118,-2.101,-2.113,-2.084,-2.111,-2.117,-2.13,-2.157,-2.188,-2.233,-2.794,-2.794,-2.79,-2.782,-2.776,-2.771,-2.77,-2.77,-2.761,-2.746,-2.717,-2.676,-2.615,-2.539,-2.496,-2.099,-2.369,-2.401,-2.38,-2.416,-2.412,-2.43,-2.396,-2.172,-2.043,-1.905,-2.036,-2.22,-2.332,-2.467,-2.47,-2.475,-2.475,-2.474,-2.472,-2.468,-2.469,-2.465,-2.452,-2.456,-2.449,-2.435,-2.422,-2.405,-2.416,-2.417,-2.418,-2.42,-2.411,-2.425,-2.429,-2.422,-2.417,-2.416,-2.409,-2.402,-2.392,-2.377,-2.368,-2.353,-2.334,-2.315,-2.296,-2.251,-2.235,-2.238,-2.234,-2.214,-2.176,-2.137,-2.094,-2.053,-2.051,-2.054,-2.088,-2.112,-2.112,-2.107,-2.106,-2.19,-2.792,-2.788,-2.788,-2.782,-2.778,-2.777,-2.78,-2.777,-2.77,-2.761,-2.741,-2.711,-2.665,-2.618,-2.482,-1.927,-2.201,-2.346,-2.157,-2.389,-2.47,-2.5,-2.367,-2.295,-2.24,-2.262,-2.304,-2.366,-2.417,-2.43,-2.426,-2.435,-2.442,-2.437,-2.429,-2.422,-2.423,-2.42,-2.425,-2.421,-2.408,-2.415,-2.384,-2.391,-2.387,-2.387,-2.395,-2.415,-2.405,-2.415,-2.418,-2.411,-2.402,-2.396,-2.385,-2.371,-2.358,-2.357,-2.348,-2.342,-2.332,-2.316,-2.302,-2.288,-2.251,-2.167,-2.22,-2.207,-2.172,-2.134,-2.088,-1.979,-1.968,-2.049,-2.066,-2.086,-2.102,-2.111,-2.111,-2.112,-2.787,-2.785,-2.784,-2.782,-2.781,-2.782,-2.777,-2.775,-2.771,-2.768,-2.756,-2.733,-2.702,-2.675,-2.617,-2.316,-2.206,-2.563,-2.127,-2.175,-2.458,-2.537,-2.375,-2.414,-2.41,-2.392,-2.416,-2.416,-2.399,-2.329,-2.305,-2.378,-2.414,-2.396,-2.382,-2.369,-2.368,-2.374,-2.381,-2.388,-2.369,-2.384,-2.358,-2.351,-2.315,-2.358,-2.371,-2.393,-2.376,-2.394,-2.404,-2.398,-2.39,-2.378,-2.362,-2.355,-2.351,-2.344,-2.337,-2.329,-2.326,-2.316,-2.291,-2.269,-2.247,-2.215,-2.172,-2.176,-2.172,-2.123,-2.075,-1.943,-1.967,-1.993,-2.052,-2.063,-2.1,-2.111,-2.169,-2.172};
			return value;
		}
		private double[] getElevationGrid_5_24_height_9()
		{
			double[] value = {-2.792,-2.789,-2.787,-2.786,-2.784,-2.781,-2.78,-2.779,-2.768,-2.767,-2.766,-2.756,-2.737,-2.718,-2.71,-2.672,-2.646,-2.612,-2.497,-2.27,-2.541,-2.546,-2.498,-2.481,-2.476,-2.468,-2.476,-2.411,-2.392,-2.304,-2.192,-2.253,-2.364,-2.341,-2.307,-2.3,-2.3,-2.313,-2.33,-2.346,-2.348,-2.361,-2.315,-2.294,-2.294,-2.339,-2.363,-2.366,-2.371,-2.388,-2.389,-2.385,-2.378,-2.371,-2.36,-2.351,-2.343,-2.334,-2.325,-2.317,-2.311,-2.298,-2.293,-2.275,-2.256,-2.237,-2.184,-2.172,-2.147,-2.114,-2.08,-2.05,-1.986,-1.857,-2.015,-2.059,-2.093,-2.111,-2.116,-2.172,-2.795,-2.793,-2.79,-2.787,-2.781,-2.78,-2.781,-2.78,-2.766,-2.764,-2.763,-2.759,-2.756,-2.751,-2.73,-2.706,-2.686,-2.668,-2.66,-2.631,-2.61,-2.599,-2.559,-2.535,-2.522,-2.505,-2.479,-2.417,-2.376,-2.347,-2.403,-2.368,-2.302,-2.249,-2.157,-2.177,-2.177,-2.236,-2.269,-2.268,-2.27,-2.3,-2.296,-2.294,-2.294,-2.323,-2.356,-2.336,-2.355,-2.36,-2.367,-2.36,-2.36,-2.359,-2.355,-2.346,-2.32,-2.299,-2.3,-2.295,-2.293,-2.287,-2.288,-2.28,-2.256,-2.228,-2.188,-2.16,-2.143,-2.113,-2.08,-2.046,-1.993,-1.943,-1.896,-2.037,-2.076,-2.11,-2.112,-2.115,-2.797,-2.793,-2.782,-2.781,-2.775,-2.771,-2.767,-2.768,-2.763,-2.761,-2.759,-2.757,-2.754,-2.752,-2.739,-2.72,-2.706,-2.697,-2.691,-2.669,-2.641,-2.616,-2.596,-2.57,-2.553,-2.535,-2.467,-2.459,-2.461,-2.451,-2.398,-2.303,-2.125,-1.752,-1.844,-1.876,-1.779,-1.874,-2.073,-2.09,-2.004,-2.158,-2.122,-2.145,-2.262,-2.311,-2.311,-2.297,-2.304,-2.311,-2.319,-2.335,-2.346,-2.341,-2.335,-2.326,-2.311,-2.296,-2.294,-2.284,-2.271,-2.259,-2.247,-2.253,-2.263,-2.231,-2.192,-2.149,-2.148,-2.114,-2.067,-2.042,-2.04,-1.989,-1.879,-1.995,-2.053,-2.099,-2.111,-2.111,-2.798,-2.786,-2.773,-2.779,-2.774,-2.77,-2.766,-2.762,-2.757,-2.752,-2.754,-2.754,-2.754,-2.752,-2.745,-2.737,-2.728,-2.717,-2.703,-2.688,-2.665,-2.634,-2.61,-2.59,-2.565,-2.548,-2.523,-2.504,-2.473,-2.421,-2.279,-1.924,-1.471,-1.564,-1.626,-1.626,-1.727,-1.859,-1.856,-1.632,-1.645,-1.744,-1.891,-1.959,-2.072,-2.267,-2.294,-2.294,-2.297,-2.296,-2.294,-2.366,-2.309,-2.307,-2.308,-2.297,-2.296,-2.292,-2.281,-2.27,-2.259,-2.25,-2.237,-2.233,-2.234,-2.243,-2.214,-2.166,-2.177,-2.139,-2.112,-2.11,-2.076,-2.05,-1.948,-1.885,-1.998,-2.062,-2.093,-2.11,-2.794,-2.782,-2.777,-2.776,-2.772,-2.767,-2.763,-2.759,-2.753,-2.751,-2.751,-2.752,-2.754,-2.751,-2.744,-2.738,-2.731,-2.723,-2.708,-2.69,-2.669,-2.647,-2.626,-2.603,-2.58,-2.553,-2.521,-2.489,-2.426,-2.243,-1.843,-1.712,-1.725,-1.864,-1.924,-1.98,-2.082,-2.134,-1.819,-1.684,-1.76,-1.891,-1.954,-2.052,-2.171,-2.22,-2.162,-2.233,-2.294,-2.294,-2.277,-2.303,-2.269,-2.255,-2.29,-2.275,-2.29,-2.261,-2.246,-2.244,-2.243,-2.237,-2.234,-2.236,-2.236,-2.221,-2.204,-2.219,-2.173,-2.179,-2.138,-2.106,-2.053,-1.987,-1.929,-1.872,-1.85,-2.011,-2.053,-2.086,-2.782,-2.779,-2.777,-2.774,-2.77,-2.767,-2.761,-2.756,-2.751,-2.751,-2.751,-2.751,-2.749,-2.744,-2.737,-2.73,-2.725,-2.719,-2.707,-2.69,-2.673,-2.654,-2.631,-2.613,-2.591,-2.553,-2.488,-2.349,-2.063,-2.199,-2.083,-1.892,-2.053,-2.072,-2.214,-2.255,-2.233,-2.024,-2.005,-1.775,-1.861,-1.928,-2.061,-2.164,-2.146,-2.112,-2.177,-2.234,-2.261,-2.255,-2.256,-2.27,-2.264,-2.233,-2.258,-2.233,-2.235,-2.24,-2.209,-2.209,-2.213,-2.208,-2.202,-2.233,-2.214,-2.184,-2.171,-2.173,-2.179,-2.155,-2.112,-2.053,-2.029,-1.991,-1.928,-1.888,-1.852,-1.965,-2.034,-2.054,-2.785,-2.782,-2.78,-2.776,-2.77,-2.767,-2.761,-2.755,-2.751,-2.749,-2.745,-2.741,-2.739,-2.733,-2.726,-2.722,-2.721,-2.712,-2.701,-2.693,-2.676,-2.66,-2.636,-2.611,-2.579,-2.541,-2.342,-2.391,-2.353,-2.188,-2.142,-2.153,-2.203,-2.287,-2.3,-2.309,-2.268,-2.161,-1.952,-1.836,-1.921,-2.011,-2.105,-2.11,-2.112,-2.168,-2.185,-2.232,-2.234,-2.237,-2.235,-2.25,-2.261,-2.233,-2.235,-2.233,-2.235,-2.255,-2.235,-2.188,-2.172,-2.172,-2.173,-2.189,-2.143,-2.118,-2.151,-2.156,-2.173,-2.135,-2.112,-2.05,-2.03,-1.928,-1.929,-1.877,-1.868,-1.89,-2.002,-2.047,-2.783,-2.782,-2.778,-2.774,-2.77,-2.766,-2.758,-2.751,-2.751,-2.749,-2.742,-2.734,-2.727,-2.722,-2.721,-2.716,-2.71,-2.704,-2.695,-2.691,-2.679,-2.666,-2.646,-2.604,-2.569,-2.531,-2.489,-2.412,-2.335,-2.304,-2.286,-2.328,-2.323,-2.359,-2.355,-2.353,-2.294,-2.276,-1.997,-1.829,-1.966,-2.037,-2.064,-2.077,-2.113,-2.158,-2.173,-2.184,-2.2,-2.204,-2.207,-2.226,-2.246,-2.205,-2.19,-2.199,-2.232,-2.233,-2.233,-2.2,-2.157,-2.164,-2.169,-2.172,-2.159,-2.116,-2.052,-2.112,-2.095,-2.113,-2.05,-2.041,-1.979,-1.929,-1.912,-1.882,-1.863,-1.938,-1.985,-2.049,-2.782,-2.78,-2.777,-2.774,-2.77,-2.763,-2.753,-2.751,-2.751,-2.751,-2.741,-2.731,-2.722,-2.721,-2.719,-2.711,-2.704,-2.696,-2.69,-2.683,-2.674,-2.665,-2.644,-2.616,-2.542,-2.543,-2.495,-2.478,-2.461,-2.411,-2.389,-2.392,-2.395,-2.406,-2.357,-2.307,-2.302,-2.215,-1.957,-1.929,-1.989,-2.042,-2.051,-2.095,-2.111,-2.116,-2.116,-2.137,-2.163,-2.172,-2.172,-2.188,-2.211,-2.204,-2.169,-2.171,-2.18,-2.184,-2.174,-2.174,-2.123,-2.125,-2.125,-2.115,-2.102,-2.061,-2.05,-2.052,-2.045,-2.115,-1.987,-1.929,-1.925,-1.928,-1.92,-1.872,-1.865,-1.867,-1.949,-1.881,-2.781,-2.778,-2.774,-2.771,-2.768,-2.76,-2.751,-2.744,-2.741,-2.739,-2.736,-2.73,-2.722,-2.721,-2.718,-2.711,-2.704,-2.697,-2.689,-2.679,-2.67,-2.661,-2.645,-2.625,-2.604,-2.565,-2.543,-2.504,-2.473,-2.471,-2.436,-2.44,-2.43,-2.417,-2.355,-2.347,-2.296,-2.17,-2.075,-2.04,-2.108,-2.099,-2.047,-2.054,-2.05,-2.032,-1.984,-2.061,-2.103,-2.116,-2.137,-2.151,-2.17,-2.184,-2.153,-2.17,-2.172,-2.175,-2.172,-2.172,-2.165,-2.062,-2.114,-2.052,-2.049,-2.051,-2.05,-2.067,-2.048,-2.067,-2.005,-1.979,-1.941,-1.938,-1.929,-1.907,-1.873,-1.868,-1.873,-1.865,-2.781,-2.777,-2.771,-2.768,-2.766,-2.754,-2.747,-2.739,-2.733,-2.732,-2.729,-2.725,-2.72,-2.716,-2.714,-2.708,-2.702,-2.695,-2.688,-2.676,-2.666,-2.659,-2.641,-2.627,-2.608,-2.581,-2.545,-2.535,-2.498,-2.489,-2.481,-2.477,-2.443,-2.367,-2.355,-2.327,-2.281,-2.227,-2.144,-2.172,-2.132,-2.066,-1.975,-1.999,-1.916,-1.934,-1.917,-1.922,-2.001,-2.055,-2.061,-2.033,-2.128,-2.158,-2.085,-2.115,-2.15,-2.161,-2.121,-2.123,-2.052,-2.05,-2.07,-2.061,-2.02,-2.005,-2.05,-2.055,-2.058,-2.051,-2.05,-2.006,-1.985,-1.975,-1.954,-1.93,-1.892,-1.867,-1.852,-1.846,-2.773,-2.772,-2.768,-2.765,-2.758,-2.751,-2.742,-2.735,-2.742,-2.724,-2.721,-2.72,-2.717,-2.709,-2.704,-2.7,-2.695,-2.692,-2.684,-2.674,-2.664,-2.656,-2.642,-2.629,-2.614,-2.597,-2.572,-2.552,-2.537,-2.511,-2.488,-2.471,-2.422,-2.378,-2.304,-2.295,-2.294,-2.24,-2.173,-2.172,-2.12,-2.03,-1.93,-1.986,-1.988,-2.001,-1.928,-1.928,-1.928,-1.928,-1.988,-2.051,-2.111,-2.111,-2.109,-2.109,-2.111,-2.111,-2.111,-2.101,-2.099,-2.058,-2.051,-2.05,-1.994,-1.989,-2.04,-2.026,-2.033,-2.002,-1.996,-1.991,-1.993,-1.988,-1.955,-1.928,-1.919,-1.897,-1.877,-1.869,-2.765,-2.763,-2.763,-2.758,-2.752,-2.748,-2.739,-2.73,-2.723,-2.719,-2.714,-2.709,-2.708,-2.705,-2.698,-2.692,-2.69,-2.687,-2.679,-2.674,-2.661,-2.656,-2.643,-2.631,-2.617,-2.602,-2.584,-2.567,-2.55,-2.526,-2.485,-2.44,-2.376,-2.297,-2.335,-2.356,-2.304,-2.234,-2.239,-2.179};
			return value;
		}
		private double[] getElevationGrid_5_24_height_10()
		{
			double[] value = {-2.109,-1.956,-1.958,-1.997,-2.051,-1.99,-1.987,-1.94,-1.928,-1.929,-1.99,-2.05,-2.051,-2.095,-2.096,-2.05,-2.099,-2.079,-2.087,-2.052,-2.058,-2.054,-2.028,-2.055,-1.989,-2.017,-2.021,-2.005,-2.022,-2.007,-1.989,-1.989,-1.99,-1.98,-1.958,-1.947,-1.927,-1.924,-1.907,-1.91,-2.752,-2.751,-2.756,-2.752,-2.751,-2.742,-2.733,-2.725,-2.72,-2.712,-2.707,-2.702,-2.699,-2.698,-2.694,-2.69,-2.688,-2.683,-2.677,-2.667,-2.66,-2.655,-2.642,-2.633,-2.624,-2.609,-2.592,-2.574,-2.553,-2.531,-2.487,-2.387,-2.356,-2.355,-2.379,-2.271,-2.294,-2.285,-2.204,-2.161,-2.029,-2.021,-2.055,-2.095,-2.089,-2.05,-2.005,-1.952,-1.929,-1.976,-2.013,-2.036,-2.05,-2.055,-2.055,-2.05,-2.05,-2.048,-2.05,-2.051,-2.064,-1.993,-1.991,-1.99,-1.99,-1.993,-2.02,-2.008,-2.02,-1.99,-1.995,-1.991,-1.989,-1.985,-1.96,-1.957,-1.941,-1.936,-1.933,-1.928,-2.751,-2.751,-2.751,-2.751,-2.751,-2.737,-2.727,-2.721,-2.714,-2.705,-2.7,-2.695,-2.691,-2.693,-2.69,-2.682,-2.683,-2.679,-2.676,-2.664,-2.656,-2.65,-2.643,-2.635,-2.629,-2.616,-2.599,-2.583,-2.56,-2.538,-2.493,-2.442,-2.426,-2.436,-2.408,-2.355,-2.353,-2.299,-2.225,-2.063,-2.051,-2.077,-2.121,-2.132,-2.079,-2.056,-2.012,-1.934,-1.963,-1.989,-2.01,-2.021,-2.007,-2.006,-2.049,-2.003,-1.993,-1.991,-1.995,-2.05,-2.067,-2.006,-1.932,-2.011,-2.004,-1.989,-1.991,-2.024,-2.024,-2.02,-1.986,-1.986,-1.993,-1.989,-1.974,-1.958,-1.958,-1.958,-1.958,-1.958,-2.751,-2.74,-2.739,-2.738,-2.736,-2.729,-2.723,-2.72,-2.707,-2.701,-2.693,-2.689,-2.684,-2.685,-2.68,-2.675,-2.678,-2.675,-2.668,-2.661,-2.659,-2.639,-2.635,-2.629,-2.624,-2.613,-2.604,-2.591,-2.569,-2.545,-2.517,-2.491,-2.466,-2.455,-2.417,-2.367,-2.323,-2.272,-2.152,-2.086,-2.111,-2.147,-2.186,-2.111,-2.116,-2.087,-1.991,-1.989,-1.988,-2.009,-2.047,-1.99,-1.93,-1.994,-2.05,-1.993,-1.989,-1.986,-1.989,-2.05,-2.026,-1.971,-1.965,-2.005,-2.02,-2.002,-1.997,-2.02,-2.026,-2.02,-1.995,-1.959,-1.969,-1.989,-1.972,-1.958,-1.958,-1.958,-1.958,-1.961};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getColor_6_24_color_1()
		{
			double[] value = {0.145844,0.416623,0.583377,0.139049,0.443806,0.556194,0.126242,0.495034,0.504966,0.122321,0.510716,0.489284,0.12219,0.511239,0.488761,0.107031,0.571877,0.428123,0.129509,0.481965,0.518035,0.12023,0.51908,0.48092,0.117224,0.531103,0.468897,0.120753,0.516989,0.483011,0.109383,0.562467,0.437533,0.107423,0.570308,0.429692,0.105201,0.579195,0.420805,0.113696,0.545217,0.454783,0.113304,0.546785,0.453215,0.105855,0.576581,0.423419,0.109383,0.562467,0.437533,0.121668,0.51333,0.48667,0.121406,0.514375,0.485625,0.120753,0.516989,0.483011,0.121668,0.51333,0.48667,0.120361,0.518557,0.481443,0.129639,0.481443,0.518557,0.132514,0.469942,0.530058,0.129639,0.481443,0.518557,0.129509,0.481965,0.518035,0.13748,0.450078,0.549922,0.137611,0.449556,0.550444,0.137611,0.449556,0.550444,0.13748,0.450078,0.549922,0.13748,0.450078,0.549922,0.145583,0.417669,0.582331,0.152117,0.391532,0.608468,0.160873,0.356508,0.643492,0.174595,0.30162,0.69838,1.0,1.0,1.0,1.0,1.0,1.0,0.161788,0.352849,0.647151,0.151594,0.393623,0.606377,0.140225,0.439101,0.560899,0.13173,0.473079,0.526921,0.121929,0.512284,0.487716,0.127548,0.489807,0.510193,0.121406,0.514375,0.485625,0.121406,0.514375,0.485625,0.121406,0.514375,0.485625,0.121406,0.514375,0.485625,0.121537,0.513853,0.486147,0.121537,0.513853,0.486147,0.121537,0.513853,0.486147,0.121406,0.514375,0.485625,0.121537,0.513853,0.486147,0.121537,0.513853,0.486147,0.13173,0.473079,0.526921,0.150941,0.396236,0.603764,0.137219,0.451124,0.548876,0.139833,0.440669,0.559331,0.133037,0.467852,0.532148,0.129639,0.481443,0.518557,0.129639,0.481443,0.518557,0.134213,0.463147,0.536853,0.137611,0.449556,0.550444,0.142838,0.428646,0.571354,0.145452,0.418191,0.581809,0.150941,0.396236,0.603764,0.145452,0.418191,0.581809,0.145321,0.418714,0.581286,0.145191,0.419237,0.580763,0.145191,0.419237,0.580763,0.145714,0.417146,0.582854,0.153424,0.386304,0.613696,0.153685,0.385259,0.614741,0.153685,0.385259,0.614741,0.153685,0.385259,0.614741,0.154339,0.382645,0.617355,0.150157,0.399373,0.600627,0.146628,0.413487,0.586513,0.14506,0.41976,0.58024,0.141662,0.433351,0.566649,0.139049,0.443806,0.556194,0.142054,0.431783,0.568217,0.134083,0.46367,0.53633,0.133037,0.467852,0.532148,0.128332,0.48667,0.51333,0.130031,0.479875,0.520125,0.118662,0.525353,0.474647,0.132776,0.468897,0.531103,0.12219,0.511239,0.488761,0.124673,0.501307,0.498693,0.128986,0.484056,0.515944,0.113696,0.545217,0.454783,0.105724,0.577104,0.422896,0.105201,0.579195,0.420805,0.120491,0.518035,0.481965,0.113565,0.54574,0.45426,0.105724,0.577104,0.422896,0.105724,0.577104,0.422896,0.119969,0.520125,0.479875,0.131992,0.472033,0.527967,0.130946,0.476215,0.523785};
			return value;
		}
		private double[] getColor_6_24_color_2()
		{
			double[] value = {0.122713,0.509148,0.490852,0.118923,0.524307,0.475693,0.129509,0.481965,0.518035,0.13735,0.450601,0.549399,0.130946,0.476215,0.523785,0.13748,0.450078,0.549922,0.133821,0.464715,0.535285,0.137611,0.449556,0.550444,0.142969,0.428123,0.571877,0.144276,0.422896,0.577104,0.137611,0.449556,0.550444,0.145583,0.417669,0.582331,0.147543,0.409827,0.590173,0.154208,0.383168,0.616832,0.162311,0.350758,0.649242,0.166362,0.334553,0.665447,0.165708,0.337167,0.662833,0.152378,0.390486,0.609514,0.145452,0.418191,0.581809,0.141532,0.433873,0.566127,0.135912,0.456351,0.543649,0.137088,0.451647,0.548353,0.141401,0.434396,0.565604,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.123366,0.506534,0.493466,0.130685,0.477261,0.522739,0.129117,0.483534,0.516466,0.127548,0.489807,0.510193,0.12219,0.511239,0.488761,0.128986,0.484056,0.515944,0.129639,0.481443,0.518557,0.130685,0.477261,0.522739,0.136174,0.455306,0.544694,0.137611,0.449556,0.550444,0.145321,0.418714,0.581286,0.151594,0.393623,0.606377,0.14702,0.411918,0.588082,0.153555,0.385781,0.614219,0.151856,0.392577,0.607423,0.145321,0.418714,0.581286,0.146498,0.414009,0.585991,0.146628,0.413487,0.586513,0.151333,0.394668,0.605332,0.154861,0.380554,0.619446,0.163487,0.346053,0.653947,0.161396,0.354417,0.645583,0.154992,0.380031,0.619969,0.149111,0.403555,0.596445,0.145714,0.417146,0.582854,0.143361,0.426555,0.573445,0.13931,0.44276,0.55724,0.135781,0.456874,0.543126,0.14127,0.434919,0.565081,0.135912,0.456351,0.543649,0.126503,0.493988,0.506012,0.136435,0.45426,0.54574,0.125457,0.49817,0.50183,0.137219,0.451124,0.548876,0.130293,0.478829,0.521171,0.133691,0.465238,0.534762,0.116702,0.533194,0.466806,0.107554,0.569786,0.430214,0.113565,0.54574,0.45426,0.105724,0.577104,0.422896,0.113696,0.545217,0.454783,0.114349,0.542603,0.457397,0.106377,0.57449,0.42551,0.112389,0.550444,0.449556,0.12781,0.488761,0.511239,0.127418,0.490329,0.509671,0.135912,0.456351,0.543649,0.129639,0.481443,0.518557,0.129639,0.481443,0.518557,0.123236,0.507057,0.492943,0.137611,0.449556,0.550444,0.136958,0.452169,0.547831,0.13735,0.450601,0.549399,0.137611,0.449556,0.550444,0.138134,0.447465,0.552535,0.144929,0.420282,0.579718,0.145583,0.417669,0.582331,0.137611,0.449556,0.550444,0.137611,0.449556,0.550444,0.145452,0.418191,0.581809,0.152378,0.390486,0.609514,0.156691,0.373236,0.626764,0.161004,0.355985,0.644015,0.16022,0.359122,0.640878,0.153424,0.386304,0.613696,0.143231,0.427078,0.572922,0.145583,0.417669,0.582331};
			return value;
		}
		private double[] getColor_6_24_color_3()
		{
			double[] value = {0.140486,0.438055,0.561945,0.151986,0.392054,0.607946,0.153293,0.386827,0.613173,0.117747,0.529012,0.470988,0.118139,0.527444,0.472556,0.118139,0.527444,0.472556,0.1184,0.526398,0.473602,0.118662,0.525353,0.474647,0.118792,0.52483,0.47517,0.118792,0.52483,0.47517,0.118923,0.524307,0.475693,0.119315,0.522739,0.477261,0.120361,0.518557,0.481443,0.121275,0.514898,0.485102,0.122844,0.508625,0.491375,0.12402,0.503921,0.496079,0.121668,0.51333,0.48667,0.127679,0.489284,0.510716,0.135781,0.456874,0.543126,0.131208,0.47517,0.52483,0.131469,0.474124,0.525876,0.134605,0.461579,0.538421,0.13748,0.450078,0.549922,0.144276,0.422896,0.577104,0.14506,0.41976,0.58024,0.149111,0.403555,0.596445,0.145714,0.417146,0.582854,0.150026,0.399895,0.600105,0.148197,0.407214,0.592786,0.152901,0.388395,0.611605,0.153293,0.386827,0.613173,0.152901,0.388395,0.611605,0.159305,0.362781,0.637219,0.166362,0.334553,0.665447,1.0,1.0,1.0,0.159566,0.361735,0.638265,0.153032,0.387872,0.612128,0.147412,0.41035,0.58965,0.145191,0.419237,0.580763,0.14114,0.435442,0.564558,0.137611,0.449556,0.550444,0.145583,0.417669,0.582331,0.143492,0.426032,0.573968,0.143361,0.426555,0.573445,0.139702,0.441192,0.558808,0.135389,0.458442,0.541558,0.125588,0.497648,0.502352,0.137611,0.449556,0.550444,0.126634,0.493466,0.506534,0.128071,0.487716,0.512284,0.12023,0.51908,0.48092,0.116571,0.533717,0.466283,0.106247,0.575013,0.424987,0.11448,0.542081,0.457919,0.114088,0.543649,0.456351,0.116832,0.532671,0.467329,0.121537,0.513853,0.486147,0.136043,0.455829,0.544171,0.116702,0.533194,0.466806,0.137611,0.449556,0.550444,0.13356,0.465761,0.534239,0.130293,0.478829,0.521171,0.129639,0.481443,0.518557,0.130031,0.479875,0.520125,0.137611,0.449556,0.550444,0.138003,0.447987,0.552013,0.14114,0.435442,0.564558,0.145321,0.418714,0.581286,0.146367,0.414532,0.585468,0.145583,0.417669,0.582331,0.145191,0.419237,0.580763,0.146367,0.414532,0.585468,0.143753,0.424987,0.575013,0.148197,0.407214,0.592786,0.153424,0.386304,0.613696,0.153555,0.385781,0.614219,0.153555,0.385781,0.614219,0.151333,0.394668,0.605332,0.147804,0.408782,0.591218,0.146236,0.415055,0.584945,0.136696,0.453215,0.546785,0.141401,0.434396,0.565604,0.123889,0.504443,0.495557,0.118792,0.52483,0.47517,0.117616,0.529535,0.470465,0.115003,0.53999,0.46001,0.115264,0.538944,0.461056,0.115525,0.537899,0.462101,0.115917,0.53633,0.46367,0.116179,0.535285,0.464715,0.11644,0.534239,0.465761,0.116702,0.533194,0.466806,0.116963,0.532148,0.467852,0.117355,0.53058,0.46942,0.117616,0.529535,0.470465,0.121668,0.51333,0.48667,0.121798,0.512807,0.487193,0.126372,0.494511,0.505489,0.133168,0.467329,0.532671,0.140355,0.438578,0.561422};
			return value;
		}
		private double[] getColor_6_24_color_4()
		{
			double[] value = {0.139571,0.441715,0.558285,0.138657,0.445374,0.554626,0.137742,0.449033,0.550967,0.137611,0.449556,0.550444,0.152248,0.391009,0.608991,0.145452,0.418191,0.581809,0.153032,0.387872,0.612128,0.145583,0.417669,0.582331,0.150157,0.399373,0.600627,0.153293,0.386827,0.613173,0.154339,0.382645,0.617355,0.154861,0.380554,0.619446,0.159174,0.363304,0.636696,0.173419,0.306325,0.693675,1.0,1.0,1.0,0.157083,0.371668,0.628332,0.152248,0.391009,0.608991,0.148066,0.407737,0.592263,0.145583,0.417669,0.582331,0.142708,0.429169,0.570831,0.15081,0.396759,0.603241,0.160481,0.358076,0.641924,0.159435,0.362258,0.637742,0.146759,0.412964,0.587036,0.146106,0.415578,0.584422,0.139963,0.440146,0.559854,0.126634,0.493466,0.506534,0.139441,0.442237,0.557763,0.1316,0.473602,0.526398,0.13356,0.465761,0.534239,0.129639,0.481443,0.518557,0.12402,0.503921,0.496079,0.111213,0.555149,0.444851,0.124543,0.50183,0.49817,0.115003,0.53999,0.46001,0.136696,0.453215,0.546785,0.134083,0.46367,0.53633,0.137611,0.449556,0.550444,0.12402,0.503921,0.496079,0.137611,0.449556,0.550444,0.136696,0.453215,0.546785,0.137088,0.451647,0.548353,0.12977,0.48092,0.51908,0.12977,0.48092,0.51908,0.129639,0.481443,0.518557,0.137611,0.449556,0.550444,0.145321,0.418714,0.581286,0.147151,0.411396,0.588604,0.151594,0.393623,0.606377,0.147412,0.41035,0.58965,0.155515,0.37794,0.62206,0.144407,0.422373,0.577627,0.137742,0.449033,0.550967,0.145975,0.4161,0.5839,0.145583,0.417669,0.582331,0.148327,0.406691,0.593309,0.15068,0.397282,0.602718,0.148327,0.406691,0.593309,0.153947,0.384213,0.615787,0.153555,0.385781,0.614219,0.129509,0.481965,0.518035,0.128855,0.484579,0.515421,0.121929,0.512284,0.487716,0.124543,0.50183,0.49817,0.13173,0.473079,0.526921,0.117486,0.530058,0.469942,0.115525,0.537899,0.462101,0.115656,0.537376,0.462624,0.115787,0.536853,0.463147,0.116048,0.535808,0.464192,0.116571,0.533717,0.466283,0.116702,0.533194,0.466806,0.117094,0.531626,0.468374,0.117616,0.529535,0.470465,0.117747,0.529012,0.470988,0.121145,0.515421,0.484579,0.12219,0.511239,0.488761,0.125065,0.499739,0.500261,0.129378,0.482488,0.517512,0.138526,0.445896,0.554104,0.143361,0.426555,0.573445,0.153032,0.387872,0.612128,0.153163,0.38735,0.61265,0.145321,0.418714,0.581286,0.145975,0.4161,0.5839,0.145583,0.417669,0.582331,0.145583,0.417669,0.582331,0.146759,0.412964,0.587036,0.153424,0.386304,0.613696,0.153555,0.385781,0.614219,0.155907,0.376372,0.623628,0.161396,0.354417,0.645583,0.161396,0.354417,0.645583,0.165708,0.337167,0.662833,0.16976,0.320962,0.679038,0.157737,0.369054,0.630946,0.151333,0.394668,0.605332,0.147543,0.409827,0.590173,0.144407,0.422373,0.577627,0.144668,0.421328,0.578672};
			return value;
		}
		private double[] getColor_6_24_color_5()
		{
			double[] value = {0.151856,0.392577,0.607423,0.156299,0.374804,0.625196,0.163095,0.347622,0.652378,0.158913,0.364349,0.635651,0.153293,0.386827,0.613173,0.149111,0.403555,0.596445,0.142316,0.430737,0.569263,0.145191,0.419237,0.580763,0.145321,0.418714,0.581286,0.143361,0.426555,0.573445,0.137742,0.449033,0.550967,0.130946,0.476215,0.523785,0.120753,0.516989,0.483011,0.128071,0.487716,0.512284,0.136435,0.45426,0.54574,0.145191,0.419237,0.580763,0.139833,0.440669,0.559331,0.14506,0.41976,0.58024,0.13173,0.473079,0.526921,0.129378,0.482488,0.517512,0.13735,0.450601,0.549399,0.137219,0.451124,0.548876,0.137219,0.451124,0.548876,0.136696,0.453215,0.546785,0.136435,0.45426,0.54574,0.136043,0.455829,0.544171,0.143492,0.426032,0.573968,0.145191,0.419237,0.580763,0.150157,0.399373,0.600627,0.154992,0.380031,0.619969,0.149895,0.400418,0.599582,0.145191,0.419237,0.580763,0.142969,0.428123,0.571877,0.141924,0.432305,0.567695,0.144407,0.422373,0.577627,0.147151,0.411396,0.588604,0.152901,0.388395,0.611605,0.152378,0.390486,0.609514,0.153555,0.385781,0.614219,0.154077,0.383691,0.616309,0.136827,0.452692,0.547308,0.144407,0.422373,0.577627,0.138395,0.446419,0.553581,0.147282,0.410873,0.589127,0.1316,0.473602,0.526398,0.121145,0.515421,0.484579,0.118531,0.525876,0.474124,0.11644,0.534239,0.465761,0.114741,0.541035,0.458965,0.114872,0.540512,0.459488,0.115787,0.536853,0.463147,0.116309,0.534762,0.465238,0.117094,0.531626,0.468374,0.118008,0.527967,0.472033,0.118531,0.525876,0.474124,0.119838,0.520648,0.479352,0.122452,0.510193,0.489807,0.125849,0.496602,0.503398,0.129378,0.482488,0.517512,0.133691,0.465238,0.534762,0.143231,0.427078,0.572922,0.147674,0.409305,0.590695,0.157606,0.369577,0.630423,0.157867,0.368531,0.631469,0.150157,0.399373,0.600627,0.152901,0.388395,0.611605,0.153424,0.386304,0.613696,0.147282,0.410873,0.589127,0.149242,0.403032,0.596968,0.151464,0.394145,0.605855,0.1546,0.3816,0.6184,0.161004,0.355985,0.644015,0.161396,0.354417,0.645583,0.16793,0.32828,0.67172,0.170674,0.317303,0.682697,0.158521,0.365917,0.634083,0.150941,0.396236,0.603764,0.148197,0.407214,0.592786,0.141793,0.432828,0.567172,0.145452,0.418191,0.581809,0.159697,0.361213,0.638787,0.161526,0.353894,0.646106,1.0,1.0,1.0,1.0,1.0,1.0,0.152378,0.390486,0.609514,0.123497,0.506012,0.493988,0.154208,0.383168,0.616832,0.15643,0.374281,0.625719,0.153424,0.386304,0.613696,0.136043,0.455829,0.544171,0.148981,0.404077,0.595923,0.145583,0.417669,0.582331,0.137742,0.449033,0.550967,0.141793,0.432828,0.567172,0.128332,0.48667,0.51333,0.139833,0.440669,0.559331,0.147804,0.408782,0.591218,0.145583,0.417669,0.582331,0.130554,0.477784,0.522216,0.123889,0.504443,0.495557};
			return value;
		}
		private double[] getColor_6_24_color_6()
		{
			double[] value = {0.144407,0.422373,0.577627,0.139179,0.443283,0.556717,0.138395,0.446419,0.553581,0.138657,0.445374,0.554626,0.137611,0.449556,0.550444,0.130685,0.477261,0.522739,0.140878,0.436487,0.563513,0.143753,0.424987,0.575013,0.152901,0.388395,0.611605,0.155254,0.378986,0.621014,0.155907,0.376372,0.623628,0.150288,0.39885,0.60115,0.146498,0.414009,0.585991,0.145583,0.417669,0.582331,0.141793,0.432828,0.567172,0.145583,0.417669,0.582331,0.150418,0.398327,0.601673,0.151072,0.395714,0.604286,0.152771,0.388918,0.611082,0.153555,0.385781,0.614219,0.145583,0.417669,0.582331,0.1431,0.427601,0.572399,0.135259,0.458965,0.541035,0.129378,0.482488,0.517512,0.12219,0.511239,0.488761,0.121014,0.515944,0.484056,0.117355,0.53058,0.46942,0.115264,0.538944,0.461056,0.113304,0.546785,0.453215,0.113696,0.545217,0.454783,0.11448,0.542081,0.457919,0.115656,0.537376,0.462624,0.116702,0.533194,0.466806,0.117878,0.528489,0.471511,0.119054,0.523785,0.476215,0.119446,0.522216,0.477784,0.121668,0.51333,0.48667,0.124673,0.501307,0.498693,0.129117,0.483534,0.516466,0.13552,0.457919,0.542081,0.143361,0.426555,0.573445,0.153424,0.386304,0.613696,0.17368,0.30528,0.69472,0.174856,0.300575,0.699425,0.160742,0.357031,0.642969,0.153424,0.386304,0.613696,0.153947,0.384213,0.615787,0.156822,0.372713,0.627287,0.161396,0.354417,0.645583,0.154861,0.380554,0.619446,0.159305,0.362781,0.637219,0.161396,0.354417,0.645583,0.168322,0.326712,0.673288,1.0,1.0,1.0,0.164271,0.342917,0.657083,0.160742,0.357031,0.642969,0.15264,0.389441,0.610559,0.146106,0.415578,0.584422,0.140355,0.438578,0.561422,0.145321,0.418714,0.581286,0.174334,0.302666,0.697334,1.0,1.0,1.0,0.173941,0.304234,0.695766,0.163617,0.345531,0.654469,0.150026,0.399895,0.600105,0.156038,0.375849,0.624151,0.157606,0.369577,0.630423,0.15643,0.374281,0.625719,0.152901,0.388395,0.611605,0.153424,0.386304,0.613696,0.154208,0.383168,0.616832,0.147804,0.408782,0.591218,0.145714,0.417146,0.582854,0.149373,0.402509,0.597491,0.15081,0.396759,0.603241,0.137872,0.44851,0.55149,0.155646,0.377418,0.622582,0.147935,0.408259,0.591741,0.143623,0.42551,0.57449,0.142969,0.428123,0.571877,0.145583,0.417669,0.582331,0.145975,0.4161,0.5839,0.155384,0.378463,0.621537,0.145452,0.418191,0.581809,0.145452,0.418191,0.581809,0.144015,0.423941,0.576059,0.138134,0.447465,0.552535,0.145583,0.417669,0.582331,0.151333,0.394668,0.605332,0.155254,0.378986,0.621014,0.147804,0.408782,0.591218,0.146236,0.415055,0.584945,0.145452,0.418191,0.581809,0.145191,0.419237,0.580763,0.142054,0.431783,0.568217,0.145583,0.417669,0.582331,0.145452,0.418191,0.581809,0.145583,0.417669,0.582331,0.151594,0.393623,0.606377,0.153555,0.385781,0.614219};
			return value;
		}
		private double[] getColor_6_24_color_7()
		{
			double[] value = {0.152771,0.388918,0.611082,0.138918,0.444328,0.555672,0.13735,0.450601,0.549399,0.130031,0.479875,0.520125,0.133298,0.466806,0.533194,0.121406,0.514375,0.485625,0.119054,0.523785,0.476215,0.115656,0.537376,0.462624,0.113042,0.547831,0.452169,0.112912,0.548353,0.451647,0.113565,0.54574,0.45426,0.11448,0.542081,0.457919,0.115395,0.538421,0.461579,0.116309,0.534762,0.465238,0.117094,0.531626,0.468374,0.118531,0.525876,0.474124,0.121275,0.514898,0.485102,0.124935,0.500261,0.499739,0.129509,0.481965,0.518035,0.136696,0.453215,0.546785,0.144668,0.421328,0.578672,0.153163,0.38735,0.61265,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.162049,0.351803,0.648197,0.160873,0.356508,0.643492,0.161265,0.35494,0.64506,0.161788,0.352849,0.647151,0.161918,0.352326,0.647674,0.162311,0.350758,0.649242,0.170674,0.317303,0.682697,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.153947,0.384213,0.615787,0.145583,0.417669,0.582331,0.14114,0.435442,0.564558,0.145191,0.419237,0.580763,0.168322,0.326712,0.673288,0.16976,0.320962,0.679038,0.161526,0.353894,0.646106,0.145714,0.417146,0.582854,0.150549,0.397804,0.602196,0.161396,0.354417,0.645583,0.171197,0.315212,0.684788,0.146498,0.414009,0.585991,0.153555,0.385781,0.614219,0.157737,0.369054,0.630946,0.161396,0.354417,0.645583,0.153947,0.384213,0.615787,0.152901,0.388395,0.611605,0.142708,0.429169,0.570831,0.148066,0.407737,0.592263,0.132384,0.470465,0.529535,0.153947,0.384213,0.615787,0.153424,0.386304,0.613696,0.160873,0.356508,0.643492,0.148458,0.406168,0.593832,0.143231,0.427078,0.572922,0.153685,0.385259,0.614741,0.145583,0.417669,0.582331,0.145583,0.417669,0.582331,0.142446,0.430214,0.569786,0.137611,0.449556,0.550444,0.130554,0.477784,0.522216,0.143623,0.42551,0.57449,0.145452,0.418191,0.581809,0.146628,0.413487,0.586513,0.14689,0.412441,0.587559,0.145583,0.417669,0.582331,0.144799,0.420805,0.579195,0.143884,0.424464,0.575536,0.142969,0.428123,0.571877,0.143753,0.424987,0.575013,0.144668,0.421328,0.578672,0.145452,0.418191,0.581809,0.150026,0.399895,0.600105,0.153555,0.385781,0.614219,0.145452,0.418191,0.581809,0.141401,0.434396,0.565604,0.142708,0.429169,0.570831,0.16035,0.358599,0.641401,0.15081,0.396759,0.603241,0.134083,0.46367,0.53633,0.121145,0.515421,0.484579,0.116309,0.534762,0.465238,0.113042,0.547831,0.452169,0.112912,0.548353,0.451647,0.112912,0.548353,0.451647,0.113434,0.546262,0.453738,0.114349,0.542603,0.457397,0.115525,0.537899,0.462101,0.116963,0.532148,0.467852,0.1184,0.526398,0.473602,0.120883,0.516466,0.483534,0.127679,0.489284,0.510716,0.129378,0.482488,0.517512,0.136435,0.45426,0.54574};
			return value;
		}
		private double[] getColor_6_24_color_8()
		{
			double[] value = {0.149634,0.401464,0.598536,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.168975,0.324098,0.675902,0.169367,0.32253,0.67747,0.170544,0.317825,0.682175,0.161788,0.352849,0.647151,0.166754,0.332985,0.667015,0.169237,0.323053,0.676947,0.174595,0.30162,0.69838,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.154339,0.382645,0.617355,0.145714,0.417146,0.582854,0.139963,0.440146,0.559854,0.145583,0.417669,0.582331,0.15656,0.373758,0.626242,1.0,1.0,1.0,1.0,1.0,1.0,0.162703,0.34919,0.65081,0.157998,0.368008,0.631992,0.159827,0.36069,0.63931,0.167277,0.330894,0.669106,1.0,1.0,1.0,0.161526,0.353894,0.646106,0.169237,0.323053,0.676947,0.166492,0.33403,0.66597,0.166231,0.335076,0.664924,0.153947,0.384213,0.615787,0.153555,0.385781,0.614219,0.153555,0.385781,0.614219,0.13931,0.44276,0.55724,0.139963,0.440146,0.559854,0.154208,0.383168,0.616832,0.148066,0.407737,0.592263,0.148197,0.407214,0.592786,0.153163,0.38735,0.61265,0.154077,0.383691,0.616309,0.145975,0.4161,0.5839,0.141662,0.433351,0.566649,0.13748,0.450078,0.549922,0.134605,0.461579,0.538421,0.131338,0.474647,0.525353,0.131992,0.472033,0.527967,0.136304,0.454783,0.545217,0.142054,0.431783,0.568217,0.145191,0.419237,0.580763,0.145583,0.417669,0.582331,0.145583,0.417669,0.582331,0.145452,0.418191,0.581809,0.145452,0.418191,0.581809,0.145583,0.417669,0.582331,0.145583,0.417669,0.582331,0.149242,0.403032,0.596968,0.153555,0.385781,0.614219,0.153555,0.385781,0.614219,0.142316,0.430737,0.569263,0.145583,0.417669,0.582331,0.151725,0.3931,0.6069,0.164794,0.340826,0.659174,0.167146,0.331417,0.668583,0.132645,0.46942,0.53058,0.128855,0.484579,0.515421,0.127548,0.489807,0.510193,0.118008,0.527967,0.472033,0.113173,0.547308,0.452692,0.112912,0.548353,0.451647,0.112912,0.548353,0.451647,0.113696,0.545217,0.454783,0.114219,0.543126,0.456874,0.116179,0.535285,0.464715,0.11827,0.526921,0.473079,0.120753,0.516989,0.483011,0.123889,0.504443,0.495557,0.129378,0.482488,0.517512,0.13735,0.450601,0.549399,0.148458,0.406168,0.593832,1.0,1.0,1.0,0.170674,0.317303,0.682697,0.16218,0.351281,0.648719,0.168845,0.324621,0.675379,0.161657,0.353372,0.646628,0.167669,0.329326,0.670674,0.16022,0.359122,0.640878,0.15643,0.374281,0.625719,0.164271,0.342917,0.657083,1.0,1.0,1.0,0.173811,0.304757,0.695243,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.165578,0.337689,0.662311,0.147543,0.409827,0.590173,0.145452,0.418191,0.581809,0.138134,0.447465,0.552535,0.136566,0.453738,0.546262};
			return value;
		}
		private double[] getColor_6_24_color_9()
		{
			double[] value = {0.165186,0.339258,0.660742,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.16989,0.320439,0.679561,1.0,1.0,1.0,0.170282,0.318871,0.681129,1.0,1.0,1.0,0.172373,0.310507,0.689493,0.167407,0.330371,0.669629,0.159958,0.360167,0.639833,0.161004,0.355985,0.644015,0.154339,0.382645,0.617355,0.138787,0.444851,0.555149,0.141924,0.432305,0.567695,0.145583,0.417669,0.582331,0.145714,0.417146,0.582854,0.148589,0.405646,0.594354,0.158259,0.366963,0.633037,0.150549,0.397804,0.602196,0.145583,0.417669,0.582331,0.140355,0.438578,0.561422,0.13735,0.450601,0.549399,0.135259,0.458965,0.541035,0.134867,0.460533,0.539467,0.136958,0.452169,0.547831,0.133691,0.465238,0.534762,0.13748,0.450078,0.549922,0.13931,0.44276,0.55724,0.145191,0.419237,0.580763,0.145714,0.417146,0.582854,0.145583,0.417669,0.582331,0.145583,0.417669,0.582331,0.145714,0.417146,0.582854,0.145844,0.416623,0.583377,0.152248,0.391009,0.608991,0.154077,0.383691,0.616309,0.145583,0.417669,0.582331,0.153424,0.386304,0.613696,0.155515,0.37794,0.62206,0.158913,0.364349,0.635651,0.171589,0.313643,0.686357,1.0,1.0,1.0,0.151202,0.395191,0.604809,0.131208,0.47517,0.52483,0.141532,0.433873,0.566127,0.131338,0.474647,0.525353,0.117486,0.530058,0.469942,0.112912,0.548353,0.451647,0.112912,0.548353,0.451647,0.113696,0.545217,0.454783,0.115003,0.53999,0.46001,0.11644,0.534239,0.465761,0.11827,0.526921,0.473079,0.120622,0.517512,0.482488,0.123628,0.505489,0.494511,0.12781,0.488761,0.511239,0.135389,0.458442,0.541558,0.143753,0.424987,0.575013,0.149503,0.401986,0.598014,0.168453,0.326189,0.673811,0.161918,0.352326,0.647674,0.154861,0.380554,0.619446,0.154992,0.380031,0.619969,0.156299,0.374804,0.625196,0.15068,0.397282,0.602718,0.162833,0.348667,0.651333,0.174072,0.303711,0.696289,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.16989,0.320439,0.679561,0.161788,0.352849,0.647151,0.161265,0.35494,0.64506,0.15081,0.396759,0.603241,0.145321,0.418714,0.581286,0.137611,0.449556,0.550444,0.132906,0.468374,0.531626,0.149503,0.401986,0.598014,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.158913,0.364349,0.635651,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.172112,0.311553,0.688447,0.169367,0.32253,0.67747,0.157214,0.371145,0.628855,0.161134,0.355463,0.644537,0.151856,0.392577,0.607423,0.14702,0.411918,0.588082,0.153293,0.386827,0.613173,0.15264,0.389441,0.610559,0.149765,0.400941,0.599059};
			return value;
		}
		private double[] getColor_6_24_color_10()
		{
			double[] value = {0.153555,0.385781,0.614219,0.153293,0.386827,0.613173,0.14689,0.412441,0.587559,0.140094,0.439624,0.560376,0.136958,0.452169,0.547831,0.137611,0.449556,0.550444,0.134083,0.46367,0.53633,0.137611,0.449556,0.550444,0.13735,0.450601,0.549399,0.136174,0.455306,0.544694,0.137088,0.451647,0.548353,0.144276,0.422896,0.577104,0.145583,0.417669,0.582331,0.147412,0.41035,0.58965,0.149111,0.403555,0.596445,0.151725,0.3931,0.6069,0.149634,0.401464,0.598536,0.153424,0.386304,0.613696,0.156168,0.375327,0.624673,0.153555,0.385781,0.614219,0.154077,0.383691,0.616309,0.155776,0.376895,0.623105,0.174595,0.30162,0.69838,1.0,1.0,1.0,1.0,1.0,1.0,0.158129,0.367486,0.632514,0.139963,0.440146,0.559854,0.145583,0.417669,0.582331,0.136696,0.453215,0.546785,0.121668,0.51333,0.48667,0.121145,0.515421,0.484579,0.113042,0.547831,0.452169,0.113826,0.544694,0.455306,0.115395,0.538421,0.461579,0.116832,0.532671,0.467329,0.11827,0.526921,0.473079,0.120753,0.516989,0.483011,0.123497,0.506012,0.493988,0.128332,0.48667,0.51333,0.133429,0.466283,0.533717,0.137611,0.449556,0.550444,0.143492,0.426032,0.573968,0.151202,0.395191,0.604809,0.152901,0.388395,0.611605,0.17185,0.312598,0.687402,0.159174,0.363304,0.636696,0.146498,0.414009,0.585991,0.152901,0.388395,0.611605,0.169106,0.323576,0.676424,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.162964,0.348144,0.651856,0.149634,0.401464,0.598536,0.140748,0.43701,0.56299,0.137611,0.449556,0.550444,0.137611,0.449556,0.550444,0.135259,0.458965,0.541035,0.158259,0.366963,0.633037,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.170152,0.319394,0.680606,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.172896,0.308416,0.691584,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.171981,0.312075,0.687925,0.169498,0.322007,0.677993,0.153032,0.387872,0.612128,0.155515,0.37794,0.62206,0.15656,0.373758,0.626242,0.160612,0.357554,0.642446,0.148066,0.407737,0.592263,0.153555,0.385781,0.614219,0.154339,0.382645,0.617355,0.153032,0.387872,0.612128,0.146106,0.415578,0.584422,0.145452,0.418191,0.581809,0.143884,0.424464,0.575536,0.143623,0.42551,0.57449,0.14506,0.41976,0.58024,0.144537,0.42185,0.57815,0.143361,0.426555,0.573445,0.140225,0.439101,0.560899,0.13735,0.450601,0.549399,0.136304,0.454783,0.545217,0.140878,0.436487,0.563513,0.145452,0.418191,0.581809,0.147674,0.409305,0.590695,0.151986,0.392054,0.607946,0.153032,0.387872,0.612128,0.153816,0.384736,0.615264,0.161526,0.353894,0.646106,0.16035,0.358599,0.641401};
			return value;
		}
		private double[] getColor_6_24_color_11()
		{
			double[] value = {0.163225,0.347099,0.652901,0.16035,0.358599,0.641401,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.164663,0.341349,0.658651,0.143361,0.426555,0.573445,0.129247,0.483011,0.516989,0.122582,0.509671,0.490329,0.118923,0.524307,0.475693,0.115525,0.537899,0.462101,0.113696,0.545217,0.454783,0.114741,0.541035,0.458965,0.115917,0.53633,0.46367,0.117224,0.531103,0.468897,0.118792,0.52483,0.47517,0.120491,0.518035,0.481965,0.122844,0.508625,0.491375,0.129378,0.482488,0.517512,0.12977,0.48092,0.51908,0.136566,0.453738,0.546262,0.143231,0.427078,0.572922,0.145583,0.417669,0.582331,0.145583,0.417669,0.582331,0.150418,0.398327,0.601673,0.145975,0.4161,0.5839,0.145191,0.419237,0.580763,0.149765,0.400941,0.599059,0.159827,0.36069,0.63931,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.165708,0.337167,0.662833,0.14689,0.412441,0.587559,0.141009,0.435964,0.564036,0.137611,0.449556,0.550444,0.137219,0.451124,0.548876,0.135781,0.456874,0.543126,0.169629,0.321485,0.678515,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.169237,0.323053,0.676947,0.173811,0.304757,0.695243,0.157998,0.368008,0.631992,0.159958,0.360167,0.639833,0.168845,0.324621,0.675379,0.162441,0.350235,0.649765,0.155384,0.378463,0.621537,0.159566,0.361735,0.638265,0.164271,0.342917,0.657083,0.154469,0.382122,0.617878,0.151464,0.394145,0.605855,0.145452,0.418191,0.581809,0.145583,0.417669,0.582331,0.152771,0.388918,0.611082,0.149373,0.402509,0.597491,0.145583,0.417669,0.582331,0.157344,0.370622,0.629378,0.145452,0.418191,0.581809,0.144537,0.42185,0.57815,0.143753,0.424987,0.575013,0.142577,0.429692,0.570308,0.140748,0.43701,0.56299,0.144537,0.42185,0.57815,0.150157,0.399373,0.600627,0.153555,0.385781,0.614219,0.155776,0.376895,0.623105,0.169629,0.321485,0.678515,0.164663,0.341349,0.658651,0.169367,0.32253,0.67747,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.137872,0.44851,0.55149,0.129509,0.481965,0.518035,0.124412,0.502352,0.497648,0.120753,0.516989,0.483011,0.118531,0.525876,0.474124,0.117224,0.531103,0.468897,0.116309,0.534762,0.465238,0.119054,0.523785,0.476215,0.119315,0.522739,0.477261,0.119969,0.520125,0.479875,0.121145,0.515421,0.484579,0.123497,0.506012,0.493988,0.129247,0.483011,0.516989,0.129639,0.481443,0.518557};
			return value;
		}
		private double[] getColor_6_24_color_12()
		{
			double[] value = {0.136435,0.45426,0.54574,0.139702,0.441192,0.558808,0.144929,0.420282,0.579718,0.145321,0.418714,0.581286,0.144929,0.420282,0.579718,0.141924,0.432305,0.567695,0.144799,0.420805,0.579195,0.145583,0.417669,0.582331,0.151725,0.3931,0.6069,0.158651,0.365395,0.634605,0.169106,0.323576,0.676424,0.173157,0.307371,0.692629,1.0,1.0,1.0,1.0,1.0,1.0,0.163225,0.347099,0.652901,0.145844,0.416623,0.583377,0.139049,0.443806,0.556194,0.137611,0.449556,0.550444,0.134475,0.462101,0.537899,0.134213,0.463147,0.536853,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.161265,0.35494,0.64506,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.168975,0.324098,0.675902,0.172504,0.309984,0.690016,0.163356,0.346576,0.653424,0.171328,0.314689,0.685311,0.161918,0.352326,0.647674,1.0,1.0,1.0,0.162311,0.350758,0.649242,0.165316,0.338735,0.661265,0.169106,0.323576,0.676424,1.0,1.0,1.0,0.153555,0.385781,0.614219,0.145583,0.417669,0.582331,0.153163,0.38735,0.61265,0.15081,0.396759,0.603241,0.151725,0.3931,0.6069,0.153163,0.38735,0.61265,0.145844,0.416623,0.583377,0.151856,0.392577,0.607423,0.145583,0.417669,0.582331,0.145583,0.417669,0.582331,0.145452,0.418191,0.581809,0.145583,0.417669,0.582331,0.145583,0.417669,0.582331,0.145452,0.418191,0.581809,0.144799,0.420805,0.579195,0.146628,0.413487,0.586513,0.151725,0.3931,0.6069,0.166623,0.333508,0.666492,0.16022,0.359122,0.640878,0.167146,0.331417,0.668583,1.0,1.0,1.0,0.161657,0.353372,0.646628,0.169106,0.323576,0.676424,1.0,1.0,1.0,0.145452,0.418191,0.581809,0.130423,0.478306,0.521694,0.136827,0.452692,0.547308,0.128463,0.486147,0.513853,0.121668,0.51333,0.48667,0.125065,0.499739,0.500261,0.121406,0.514375,0.485625,0.121537,0.513853,0.486147,0.121668,0.51333,0.48667,0.121537,0.513853,0.486147,0.12023,0.51908,0.48092,0.121275,0.514898,0.485102,0.126111,0.495557,0.504443,0.133429,0.466283,0.533717,0.137611,0.449556,0.550444,0.13735,0.450601,0.549399,0.145321,0.418714,0.581286,0.145583,0.417669,0.582331,0.137742,0.449033,0.550967,0.141793,0.432828,0.567172,0.152248,0.391009,0.608991,0.146367,0.414532,0.585468,0.152509,0.389963,0.610037,0.151464,0.394145,0.605855,0.153947,0.384213,0.615787,0.161134,0.355463,0.644537,0.166884,0.332462,0.667538,1.0,1.0,1.0,1.0,1.0,1.0,0.156038,0.375849,0.624151,0.145583,0.417669,0.582331,0.137611,0.449556,0.550444,0.135912,0.456351,0.543649,0.130685,0.477261,0.522739,0.125065,0.499739,0.500261};
			return value;
		}
		private double[] getColor_6_24_color_13()
		{
			double[] value = {1.0,1.0,1.0,0.174726,0.301098,0.698902,1.0,1.0,1.0,1.0,1.0,1.0,0.15839,0.36644,0.63356,1.0,1.0,1.0,0.166884,0.332462,0.667538,0.153163,0.38735,0.61265,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.16035,0.358599,0.641401,0.172635,0.309462,0.690538,1.0,1.0,1.0,1.0,1.0,1.0,0.159174,0.363304,0.636696,0.168061,0.327757,0.672243,0.154339,0.382645,0.617355,0.150941,0.396236,0.603764,0.145583,0.417669,0.582331,0.150157,0.399373,0.600627,0.151594,0.393623,0.606377,0.157737,0.369054,0.630946,0.153555,0.385781,0.614219,0.153555,0.385781,0.614219,0.153555,0.385781,0.614219,0.153555,0.385781,0.614219,0.153032,0.387872,0.612128,0.152378,0.390486,0.609514,0.149111,0.403555,0.596445,0.147674,0.409305,0.590695,0.147804,0.408782,0.591218,0.147804,0.408782,0.591218,0.147804,0.408782,0.591218,0.148458,0.406168,0.593832,0.147543,0.409827,0.590173,0.148197,0.407214,0.592786,0.156691,0.373236,0.626764,0.161918,0.352326,0.647674,0.154077,0.383691,0.616309,0.155776,0.376895,0.623105,0.154861,0.380554,0.619446,0.138134,0.447465,0.552535,0.129639,0.481443,0.518557,0.13552,0.457919,0.542081,0.122582,0.509671,0.490329,0.127548,0.489807,0.510193,0.129378,0.482488,0.517512,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.129117,0.483534,0.516466,0.125457,0.49817,0.50183,0.121668,0.51333,0.48667,0.122452,0.510193,0.489807,0.127026,0.491898,0.508102,0.132645,0.46942,0.53058,0.137611,0.449556,0.550444,0.137611,0.449556,0.550444,0.13931,0.44276,0.55724,0.138918,0.444328,0.555672,0.134736,0.461056,0.538944,0.141401,0.434396,0.565604,0.150418,0.398327,0.601673,0.155254,0.378986,0.621014,0.167407,0.330371,0.669629,0.161265,0.35494,0.64506,0.152248,0.391009,0.608991,0.165708,0.337167,0.662833,0.170544,0.317825,0.682175,0.173941,0.304234,0.695766,0.170805,0.31678,0.68322,0.151072,0.395714,0.604286,0.140225,0.439101,0.560899,0.137611,0.449556,0.550444,0.141401,0.434396,0.565604,0.128594,0.485625,0.514375,0.129639,0.481443,0.518557,0.151072,0.395714,0.604286,0.151464,0.394145,0.605855,1.0,1.0,1.0,0.15081,0.396759,0.603241,0.165447,0.338212,0.661788,0.139049,0.443806,0.556194,0.1431,0.427601,0.572399,0.139571,0.441715,0.558285,0.146367,0.414532,0.585468,0.159174,0.363304,0.636696,0.160481,0.358076,0.641924,1.0,1.0,1.0,1.0,1.0,1.0,0.170544,0.317825,0.682175,0.161396,0.354417,0.645583,0.159827,0.36069,0.63931,0.161657,0.353372,0.646628,1.0,1.0,1.0,0.163356,0.346576,0.653424,0.153555,0.385781,0.614219};
			return value;
		}
		private double[] getColor_6_24_color_14()
		{
			double[] value = {0.15264,0.389441,0.610559,0.153816,0.384736,0.615264,0.143231,0.427078,0.572922,0.144145,0.423419,0.576581,0.155123,0.379509,0.620491,0.161396,0.354417,0.645583,0.161526,0.353894,0.646106,0.161265,0.35494,0.64506,0.160742,0.357031,0.642969,0.157214,0.371145,0.628855,0.159174,0.363304,0.636696,0.16022,0.359122,0.640878,0.148197,0.407214,0.592786,0.153293,0.386827,0.613173,0.153424,0.386304,0.613696,0.153555,0.385781,0.614219,0.153293,0.386827,0.613173,0.15081,0.396759,0.603241,0.145583,0.417669,0.582331,0.145452,0.418191,0.581809,0.151202,0.395191,0.604809,0.153293,0.386827,0.613173,0.153555,0.385781,0.614219,0.145844,0.416623,0.583377,0.149242,0.403032,0.596968,0.139441,0.442237,0.557763,0.128463,0.486147,0.513853,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.122321,0.510716,0.489284,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.122582,0.509671,0.490329,0.12598,0.496079,0.503921,0.128855,0.484579,0.515421,0.136174,0.455306,0.544694,0.133821,0.464715,0.535285,0.13748,0.450078,0.549922,0.143492,0.426032,0.573968,0.134213,0.463147,0.536853,0.138657,0.445374,0.554626,0.144276,0.422896,0.577104,0.145452,0.418191,0.581809,0.16793,0.32828,0.67172,0.173941,0.304234,0.695766,0.170674,0.317303,0.682697,0.161526,0.353894,0.646106,0.169367,0.32253,0.67747,1.0,1.0,1.0,0.166754,0.332985,0.667015,0.166884,0.332462,0.667538,0.140094,0.439624,0.560376,0.13735,0.450601,0.549399,0.129639,0.481443,0.518557,0.129247,0.483011,0.516989,0.121668,0.51333,0.48667,0.15656,0.373758,0.626242,0.156822,0.372713,0.627287,0.164663,0.341349,0.658651,0.116309,0.534762,0.465238,0.156822,0.372713,0.627287,0.138526,0.445896,0.554104,0.143884,0.424464,0.575536,0.150157,0.399373,0.600627,0.12977,0.48092,0.51908,0.143231,0.427078,0.572922,0.142577,0.429692,0.570308,0.157475,0.370099,0.629901,0.168453,0.326189,0.673811,0.165316,0.338735,0.661265,0.154469,0.382122,0.617878,0.1431,0.427601,0.572399,0.15264,0.389441,0.610559,0.153293,0.386827,0.613173,0.17172,0.313121,0.686879,0.145583,0.417669,0.582331,0.145844,0.416623,0.583377,0.145583,0.417669,0.582331,0.145714,0.417146,0.582854,0.137219,0.451124,0.548876,0.145452,0.418191,0.581809,0.156822,0.372713,0.627287,0.163617,0.345531,0.654469,0.163487,0.346053,0.653947,0.151594,0.393623,0.606377,0.160481,0.358076,0.641924,0.169498,0.322007,0.677993,0.16218,0.351281,0.648719,0.151856,0.392577,0.607423,0.143884,0.424464,0.575536,0.153555,0.385781,0.614219,0.153555,0.385781,0.614219,0.153555,0.385781,0.614219,0.153555,0.385781,0.614219,0.153424,0.386304,0.613696,0.142969,0.428123,0.571877};
			return value;
		}
		private double[] getColor_6_24_color_15()
		{
			double[] value = {0.149111,0.403555,0.596445,0.152248,0.391009,0.608991,0.139571,0.441715,0.558285,0.144799,0.420805,0.579195,0.141532,0.433873,0.566127,0.137611,0.449556,0.550444,0.127548,0.489807,0.510193,0.121275,0.514898,0.485102,0.119315,0.522739,0.477261,0.118662,0.525353,0.474647,0.118662,0.525353,0.474647,0.1184,0.526398,0.473602,0.116963,0.532148,0.467852,0.118531,0.525876,0.474124,0.119707,0.521171,0.478829,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.123889,0.504443,0.495557,0.125719,0.497125,0.502875,0.131992,0.472033,0.527967,0.130031,0.479875,0.520125,0.12977,0.48092,0.51908,0.134605,0.461579,0.538421,0.131992,0.472033,0.527967,0.13748,0.450078,0.549922,0.137611,0.449556,0.550444,0.142838,0.428646,0.571354,0.151856,0.392577,0.607423,0.155907,0.376372,0.623628,0.165186,0.339258,0.660742,0.172112,0.311553,0.688447,0.169498,0.322007,0.677993,1.0,1.0,1.0,1.0,1.0,1.0,0.161918,0.352326,0.647674,0.145452,0.418191,0.581809,0.137742,0.449033,0.550967,0.129639,0.481443,0.518557,0.122321,0.510716,0.489284,0.121014,0.515944,0.484056,0.144929,0.420282,0.579718,0.14702,0.411918,0.588082,0.144015,0.423941,0.576059,0.111866,0.552535,0.447465,0.124412,0.502352,0.497648,0.131469,0.474124,0.525876,0.120753,0.516989,0.483011,0.123628,0.505489,0.494511,0.128855,0.484579,0.515421,0.152771,0.388918,0.611082,0.133691,0.465238,0.534762,0.15656,0.373758,0.626242,0.151202,0.395191,0.604809,0.130685,0.477261,0.522739,0.140355,0.438578,0.561422,0.141009,0.435964,0.564036,0.145452,0.418191,0.581809,0.141662,0.433351,0.566649,0.144537,0.42185,0.57815,0.138787,0.444851,0.555149,0.147412,0.41035,0.58965,0.145452,0.418191,0.581809,0.137742,0.449033,0.550967,0.136304,0.454783,0.545217,0.137611,0.449556,0.550444,0.144015,0.423941,0.576059,0.147282,0.410873,0.589127,0.141924,0.432305,0.567695,0.151464,0.394145,0.605855,0.164532,0.341871,0.658129,1.0,1.0,1.0,0.16793,0.32828,0.67172,0.14127,0.434919,0.565081,0.137872,0.44851,0.55149,0.145844,0.416623,0.583377,0.149895,0.400418,0.599582,0.152378,0.390486,0.609514,0.157606,0.369577,0.630423,0.147151,0.411396,0.588604,0.140748,0.43701,0.56299,0.140225,0.439101,0.560899,0.142185,0.43126,0.56874,0.138657,0.445374,0.554626,0.135912,0.456351,0.543649,0.13173,0.473079,0.526921,0.129639,0.481443,0.518557,0.136174,0.455306,0.544694,0.120622,0.517512,0.482488,0.117878,0.528489,0.471511,0.116963,0.532148,0.467852,0.116963,0.532148,0.467852,0.116963,0.532148,0.467852,0.116963,0.532148,0.467852,0.116963,0.532148,0.467852,0.117094,0.531626,0.468374,0.119707,0.521171,0.478829,0.121668,0.51333,0.48667,0.12219,0.511239,0.488761,0.123628,0.505489,0.494511,0.125196,0.499216,0.500784};
			return value;
		}
		private double[] getColor_6_24_color_16()
		{
			double[] value = {0.126372,0.494511,0.505489,0.127418,0.490329,0.509671,0.128332,0.48667,0.51333,0.129247,0.483011,0.516989,0.132122,0.471511,0.528489,0.135128,0.459488,0.540512,0.138526,0.445896,0.554104,0.144276,0.422896,0.577104,0.148981,0.404077,0.595923,0.161526,0.353894,0.646106,1.0,1.0,1.0,0.16976,0.320962,0.679038,1.0,1.0,1.0,0.169498,0.322007,0.677993,0.167015,0.331939,0.668061,0.149373,0.402509,0.597491,0.136958,0.452169,0.547831,0.134997,0.46001,0.53999,0.129117,0.483534,0.516466,0.121537,0.513853,0.486147,0.150157,0.399373,0.600627,0.115395,0.538421,0.461579,0.11448,0.542081,0.457919,0.103764,0.584945,0.415055,0.107554,0.569786,0.430214,0.10311,0.587559,0.412441,0.116963,0.532148,0.467852,0.117747,0.529012,0.470988,0.150157,0.399373,0.600627,0.134213,0.463147,0.536853,0.136043,0.455829,0.544171,0.138134,0.447465,0.552535,0.157214,0.371145,0.628855,0.124412,0.502352,0.497648,0.131469,0.474124,0.525876,0.138134,0.447465,0.552535,0.128202,0.487193,0.512807,0.139833,0.440669,0.559331,0.140225,0.439101,0.560899,0.127548,0.489807,0.510193,0.13748,0.450078,0.549922,0.13748,0.450078,0.549922,0.137611,0.449556,0.550444,0.132776,0.468897,0.531103,0.131208,0.47517,0.52483,0.13748,0.450078,0.549922,0.137611,0.449556,0.550444,0.139441,0.442237,0.557763,0.141924,0.432305,0.567695,0.152248,0.391009,0.608991,1.0,1.0,1.0,0.168845,0.324621,0.675379,0.150288,0.39885,0.60115,0.135912,0.456351,0.543649,0.147151,0.411396,0.588604,0.154469,0.382122,0.617878,0.143623,0.42551,0.57449,0.157344,0.370622,0.629378,0.156952,0.37219,0.62781,0.140225,0.439101,0.560899,0.137219,0.451124,0.548876,0.13356,0.465761,0.534239,0.131077,0.475693,0.524307,0.130946,0.476215,0.523785,0.129639,0.481443,0.518557,0.129639,0.481443,0.518557,0.134344,0.462624,0.537376,0.120622,0.517512,0.482488,0.117616,0.529535,0.470465,0.116702,0.533194,0.466806,0.116309,0.534762,0.465238,0.116048,0.535808,0.464192,0.115787,0.536853,0.463147,0.115525,0.537899,0.462101,0.115395,0.538421,0.461579,0.116179,0.535285,0.464715,0.121145,0.515421,0.484579,0.121406,0.514375,0.485625,0.12206,0.511762,0.488238,0.123497,0.506012,0.493988,0.124935,0.500261,0.499739,0.125719,0.497125,0.502875,0.126634,0.493466,0.506534,0.128202,0.487193,0.512807,0.129509,0.481965,0.518035,0.131077,0.475693,0.524307,0.13552,0.457919,0.542081,0.139179,0.443283,0.556717,0.14506,0.41976,0.58024,0.153555,0.385781,0.614219,0.169498,0.322007,0.677993,1.0,1.0,1.0,1.0,1.0,1.0,0.171197,0.315212,0.684788,0.163356,0.346576,0.653424,0.153685,0.385259,0.614741,0.156952,0.37219,0.62781,0.137219,0.451124,0.548876,0.127418,0.490329,0.509671,0.121537,0.513853,0.486147};
			return value;
		}
		private double[] getColor_6_24_color_17()
		{
			double[] value = {0.149503,0.401986,0.598014,0.127156,0.491375,0.508625,0.13748,0.450078,0.549922,0.101019,0.595923,0.404077,0.097099,0.611605,0.388395,0.100627,0.597491,0.402509,0.113957,0.544171,0.455829,0.111213,0.555149,0.444851,0.119185,0.523262,0.476738,0.131077,0.475693,0.524307,0.116571,0.533717,0.466283,0.136304,0.454783,0.545217,0.130946,0.476215,0.523785,0.131469,0.474124,0.525876,0.128463,0.486147,0.513853,0.130162,0.479352,0.520648,0.116309,0.534762,0.465238,0.131208,0.47517,0.52483,0.135651,0.457397,0.542603,0.132645,0.46942,0.53058,0.12219,0.511239,0.488761,0.125196,0.499216,0.500784,0.128332,0.48667,0.51333,0.129378,0.482488,0.517512,0.129378,0.482488,0.517512,0.129639,0.481443,0.518557,0.129639,0.481443,0.518557,0.129639,0.481443,0.518557,0.133037,0.467852,0.532148,0.145583,0.417669,0.582331,0.140617,0.437533,0.562467,0.156822,0.372713,0.627287,0.147543,0.409827,0.590173,0.145452,0.418191,0.581809,0.157344,0.370622,0.629378,0.161526,0.353894,0.646106,0.137872,0.44851,0.55149,0.153163,0.38735,0.61265,0.145844,0.416623,0.583377,0.145452,0.418191,0.581809,0.139702,0.441192,0.558808,0.139441,0.442237,0.557763,0.131077,0.475693,0.524307,0.128332,0.48667,0.51333,0.128594,0.485625,0.514375,0.125588,0.497648,0.502352,0.123366,0.506534,0.493466,0.121537,0.513853,0.486147,0.119315,0.522739,0.477261,0.116832,0.532671,0.467329,0.11644,0.534239,0.465761,0.116179,0.535285,0.464715,0.115787,0.536853,0.463147,0.115395,0.538421,0.461579,0.115003,0.53999,0.46001,0.115133,0.539467,0.460533,0.116309,0.534762,0.465238,0.121537,0.513853,0.486147,0.122321,0.510716,0.489284,0.123105,0.50758,0.49242,0.123889,0.504443,0.495557,0.124804,0.500784,0.499216,0.125588,0.497648,0.502352,0.126895,0.49242,0.50758,0.128332,0.48667,0.51333,0.129639,0.481443,0.518557,0.132776,0.468897,0.531103,0.13748,0.450078,0.549922,0.144929,0.420282,0.579718,0.161657,0.353372,0.646628,0.157998,0.368008,0.631992,0.163095,0.347622,0.652378,1.0,1.0,1.0,0.173941,0.304234,0.695766,0.160481,0.358076,0.641924,0.149634,0.401464,0.598536,0.154469,0.382122,0.617878,0.153293,0.386827,0.613173,0.130554,0.477784,0.522216,0.128725,0.485102,0.514898,0.12598,0.496079,0.503921,0.109252,0.56299,0.43701,0.121668,0.51333,0.48667,0.105332,0.578672,0.421328,0.08978,0.640878,0.359122,0.099582,0.601673,0.398327,0.10115,0.5954,0.4046,0.113042,0.547831,0.452169,0.109514,0.561945,0.438055,0.119577,0.521694,0.478306,0.113696,0.545217,0.454783,0.124543,0.50183,0.49817,0.120753,0.516989,0.483011,0.106639,0.573445,0.426555,0.126634,0.493466,0.506534,0.124673,0.501307,0.498693,0.116832,0.532671,0.467329,0.123105,0.50758,0.49242,0.121798,0.512807,0.487193,0.113826,0.544694,0.455306};
			return value;
		}
		private double[] getColor_6_24_color_18()
		{
			double[] value = {0.113696,0.545217,0.454783,0.121668,0.51333,0.48667,0.119577,0.521694,0.478306,0.12402,0.503921,0.496079,0.121798,0.512807,0.487193,0.12219,0.511239,0.488761,0.121668,0.51333,0.48667,0.128463,0.486147,0.513853,0.129509,0.481965,0.518035,0.131338,0.474647,0.525353,0.129901,0.480397,0.519603,0.137088,0.451647,0.548353,0.139441,0.442237,0.557763,0.135389,0.458442,0.541558,0.143623,0.42551,0.57449,0.140486,0.438055,0.561945,0.130946,0.476215,0.523785,0.149503,0.401986,0.598014,0.152248,0.391009,0.608991,0.146106,0.415578,0.584422,0.141532,0.433873,0.566127,0.138265,0.446942,0.553058,0.13735,0.450601,0.549399,0.12977,0.48092,0.51908,0.129247,0.483011,0.516989,0.128202,0.487193,0.512807,0.125065,0.499739,0.500261,0.122582,0.509671,0.490329,0.121668,0.51333,0.48667,0.120753,0.516989,0.483011,0.119185,0.523262,0.476738,0.117878,0.528489,0.471511,0.116963,0.532148,0.467852,0.116702,0.533194,0.466806,0.115787,0.536853,0.463147,0.115917,0.53633,0.46367,0.116571,0.533717,0.466283,0.121668,0.51333,0.48667,0.122452,0.510193,0.489807,0.123236,0.507057,0.492943,0.123889,0.504443,0.495557,0.124673,0.501307,0.498693,0.125457,0.49817,0.50183,0.125719,0.497125,0.502875,0.125719,0.497125,0.502875,0.126634,0.493466,0.506534,0.129639,0.481443,0.518557,0.132253,0.470988,0.529012,0.135651,0.457397,0.542603,0.143361,0.426555,0.573445,0.170805,0.31678,0.68322,0.150026,0.399895,0.600105,0.164532,0.341871,0.658129,0.161004,0.355985,0.644015,0.16597,0.336121,0.663879,0.142446,0.430214,0.569786,0.141532,0.433873,0.566127,0.146236,0.415055,0.584945,0.167277,0.330894,0.669106,0.164401,0.342394,0.657606,0.131077,0.475693,0.524307,0.107031,0.571877,0.428123,0.114872,0.540512,0.459488,0.098798,0.604809,0.395191,0.11448,0.542081,0.457919,0.099974,0.600105,0.399895,0.108991,0.564036,0.435964,0.097752,0.608991,0.391009,0.099451,0.602196,0.397804,0.098275,0.6069,0.3931,0.117616,0.529535,0.470465,0.117878,0.528489,0.471511,0.110821,0.556717,0.443283,0.106247,0.575013,0.424987,0.128594,0.485625,0.514375,0.109514,0.561945,0.438055,0.106508,0.573968,0.426032,0.11644,0.534239,0.465761,0.115525,0.537899,0.462101,0.109645,0.561422,0.438578,0.11265,0.549399,0.450601,0.113696,0.545217,0.454783,0.116179,0.535285,0.464715,0.124673,0.501307,0.498693,0.117094,0.531626,0.468374,0.121668,0.51333,0.48667,0.119969,0.520125,0.479875,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.12206,0.511762,0.488238,0.121668,0.51333,0.48667,0.126111,0.495557,0.504443,0.121668,0.51333,0.48667,0.121275,0.514898,0.485102,0.128463,0.486147,0.513853,0.126111,0.495557,0.504443,0.123366,0.506534,0.493466,0.129117,0.483534,0.516466,0.152901,0.388395,0.611605,0.149503,0.401986,0.598014};
			return value;
		}
		private double[] getColor_6_24_color_19()
		{
			double[] value = {0.131992,0.472033,0.527967,0.130031,0.479875,0.520125,0.129639,0.481443,0.518557,0.129639,0.481443,0.518557,0.129639,0.481443,0.518557,0.129509,0.481965,0.518035,0.126634,0.493466,0.506534,0.124412,0.502352,0.497648,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.121537,0.513853,0.486147,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.119969,0.520125,0.479875,0.119707,0.521171,0.478829,0.116832,0.532671,0.467329,0.12023,0.51908,0.48092,0.121929,0.512284,0.487716,0.122452,0.510193,0.489807,0.122974,0.508102,0.491898,0.123366,0.506534,0.493466,0.123758,0.504966,0.495034,0.124281,0.502875,0.497125,0.124804,0.500784,0.499216,0.125196,0.499216,0.500784,0.126111,0.495557,0.504443,0.128071,0.487716,0.512284,0.130946,0.476215,0.523785,0.133691,0.465238,0.534762,0.139049,0.443806,0.556194,0.151725,0.3931,0.6069,0.147282,0.410873,0.589127,0.150157,0.399373,0.600627,0.147543,0.409827,0.590173,0.138787,0.444851,0.555149,0.137611,0.449556,0.550444,0.139571,0.441715,0.558285,0.144407,0.422373,0.577627,0.157344,0.370622,0.629378,0.107946,0.568217,0.431783,0.107031,0.571877,0.428123,0.103633,0.585468,0.414532,0.104809,0.580763,0.419237,0.08965,0.641401,0.358599,0.109906,0.560376,0.439624,0.090695,0.637219,0.362781,0.098014,0.607946,0.392054,0.097099,0.611605,0.388395,0.115003,0.53999,0.46001,0.102065,0.591741,0.408259,0.106639,0.573445,0.426555,0.117878,0.528489,0.471511,0.115917,0.53633,0.46367,0.125849,0.496602,0.503398,0.099712,0.60115,0.39885,0.098406,0.606377,0.393623,0.105855,0.576581,0.423419,0.103633,0.585468,0.414532,0.111474,0.554104,0.445896,0.110037,0.559854,0.440146,0.111735,0.553058,0.446942,0.121537,0.513853,0.486147,0.121668,0.51333,0.48667,0.117747,0.529012,0.470988,0.113696,0.545217,0.454783,0.112389,0.550444,0.449556,0.114611,0.541558,0.458442,0.11448,0.542081,0.457919,0.113696,0.545217,0.454783,0.113957,0.544171,0.455829,0.114219,0.543126,0.456874,0.108599,0.565604,0.434396,0.12023,0.51908,0.48092,0.117878,0.528489,0.471511,0.116571,0.533717,0.466283,0.116048,0.535808,0.464192,0.121668,0.51333,0.48667,0.128332,0.48667,0.51333,0.129378,0.482488,0.517512,0.127026,0.491898,0.508102,0.129247,0.483011,0.516989,0.129639,0.481443,0.518557,0.12977,0.48092,0.51908,0.129639,0.481443,0.518557,0.12977,0.48092,0.51908,0.133691,0.465238,0.534762,0.132384,0.470465,0.529535,0.128202,0.487193,0.512807,0.129117,0.483534,0.516466,0.127026,0.491898,0.508102,0.126372,0.494511,0.505489,0.125588,0.497648,0.502352,0.124804,0.500784,0.499216,0.12402,0.503921,0.496079,0.122974,0.508102,0.491898,0.121406,0.514375,0.485625,0.121406,0.514375,0.485625,0.121668,0.51333,0.48667,0.121798,0.512807,0.487193};
			return value;
		}
		private double[] getColor_6_24_color_20()
		{
			double[] value = {0.12219,0.511239,0.488761,0.122713,0.509148,0.490852,0.123105,0.50758,0.49242,0.123628,0.505489,0.494511,0.124151,0.503398,0.496602,0.124543,0.50183,0.49817,0.125065,0.499739,0.500261,0.125588,0.497648,0.502352,0.126242,0.495034,0.504966,0.129901,0.480397,0.519603,0.133037,0.467852,0.532148,0.135781,0.456874,0.543126,0.13748,0.450078,0.549922,0.142969,0.428123,0.571877,0.145583,0.417669,0.582331,0.14689,0.412441,0.587559,0.137219,0.451124,0.548876,0.134736,0.461056,0.538944,0.133691,0.465238,0.534762,0.136827,0.452692,0.547308,0.104025,0.5839,0.4161,0.094877,0.620491,0.379509,0.110951,0.556194,0.443806,0.101411,0.594354,0.405646,0.091741,0.633037,0.366963,0.081025,0.675902,0.324098,0.124543,0.50183,0.49817,0.110167,0.559331,0.440669,0.115656,0.537376,0.462624,0.121668,0.51333,0.48667,0.095792,0.616832,0.383168,0.106769,0.572922,0.427078,0.115395,0.538421,0.461579,0.107423,0.570308,0.429692,0.11069,0.55724,0.44276,0.094616,0.621537,0.378463,0.104548,0.581809,0.418191,0.103633,0.585468,0.414532,0.099059,0.603764,0.396236,0.097491,0.610037,0.389963,0.109252,0.56299,0.43701,0.113696,0.545217,0.454783,0.120491,0.518035,0.481965,0.119185,0.523262,0.476738,0.114349,0.542603,0.457397,0.111343,0.554626,0.445374,0.113434,0.546262,0.453738,0.113042,0.547831,0.452169,0.110951,0.556194,0.443806,0.106377,0.57449,0.42551,0.110559,0.557763,0.442237,0.105724,0.577104,0.422896,0.112258,0.550967,0.449033,0.113696,0.545217,0.454783,0.113434,0.546262,0.453738,0.112128,0.55149,0.44851,0.113042,0.547831,0.452169,0.11448,0.542081,0.457919,0.121014,0.515944,0.484056,0.122452,0.510193,0.489807,0.121668,0.51333,0.48667,0.129639,0.481443,0.518557,0.12977,0.48092,0.51908,0.133037,0.467852,0.532148,0.135389,0.458442,0.541558,0.137611,0.449556,0.550444,0.144276,0.422896,0.577104,0.146628,0.413487,0.586513,0.153293,0.386827,0.613173,0.138395,0.446419,0.553581,0.131338,0.474647,0.525353,0.12977,0.48092,0.51908,0.129509,0.481965,0.518035,0.129509,0.481965,0.518035,0.12794,0.488238,0.511762,0.124281,0.502875,0.497125,0.121537,0.513853,0.486147,0.121014,0.515944,0.484056,0.120883,0.516466,0.483534,0.121145,0.515421,0.484579,0.12206,0.511762,0.488238,0.122452,0.510193,0.489807,0.122844,0.508625,0.491375,0.123105,0.50758,0.49242,0.122713,0.509148,0.490852,0.122582,0.509671,0.490329,0.122582,0.509671,0.490329,0.123366,0.506534,0.493466,0.124543,0.50183,0.49817,0.126634,0.493466,0.506534,0.128986,0.484056,0.515944,0.130031,0.479875,0.520125,0.136696,0.453215,0.546785,0.148589,0.405646,0.594354,0.159697,0.361213,0.638787,0.153032,0.387872,0.612128,0.142316,0.430737,0.569263,0.130162,0.479352,0.520648,0.129639,0.481443,0.518557,0.126503,0.493988,0.506012};
			return value;
		}
		private double[] getColor_6_24_color_21()
		{
			double[] value = {0.090565,0.637742,0.362258,0.094746,0.621014,0.378986,0.101803,0.592786,0.407214,0.092656,0.629378,0.370622,0.080894,0.676424,0.323576,0.081809,0.672765,0.327235,0.086121,0.655515,0.344485,0.085468,0.658129,0.341871,0.100235,0.599059,0.400941,0.101281,0.594877,0.405123,0.08978,0.640878,0.359122,0.091218,0.635128,0.364872,0.088082,0.647674,0.352326,0.097622,0.609514,0.390486,0.094877,0.620491,0.379509,0.090565,0.637742,0.362258,0.098144,0.607423,0.392577,0.092263,0.630946,0.369054,0.098667,0.605332,0.394668,0.105332,0.578672,0.421328,0.115003,0.53999,0.46001,0.119315,0.522739,0.477261,0.120361,0.518557,0.481443,0.121537,0.513853,0.486147,0.114349,0.542603,0.457397,0.107554,0.569786,0.430214,0.105593,0.577627,0.422373,0.106247,0.575013,0.424987,0.105724,0.577104,0.422896,0.105724,0.577104,0.422896,0.100889,0.596445,0.403555,0.097883,0.608468,0.391532,0.104025,0.5839,0.4161,0.10115,0.5954,0.4046,0.10494,0.58024,0.41976,0.106508,0.573968,0.426032,0.113173,0.547308,0.452692,0.113173,0.547308,0.452692,0.115787,0.536853,0.463147,0.118662,0.525353,0.474647,0.121668,0.51333,0.48667,0.126764,0.492943,0.507057,0.129639,0.481443,0.518557,0.137088,0.451647,0.548353,0.137872,0.44851,0.55149,0.144668,0.421328,0.578672,0.153163,0.38735,0.61265,0.167799,0.328803,0.671197,0.158782,0.364872,0.635128,0.147674,0.409305,0.590695,0.142838,0.428646,0.571354,0.134997,0.46001,0.53999,0.133298,0.466806,0.533194,0.129901,0.480397,0.519603,0.129639,0.481443,0.518557,0.129639,0.481443,0.518557,0.126634,0.493466,0.506534,0.12219,0.511239,0.488761,0.121014,0.515944,0.484056,0.121668,0.51333,0.48667,0.121798,0.512807,0.487193,0.12219,0.511239,0.488761,0.122713,0.509148,0.490852,0.122974,0.508102,0.491898,0.123497,0.506012,0.493988,0.123889,0.504443,0.495557,0.124281,0.502875,0.497125,0.124804,0.500784,0.499216,0.125196,0.499216,0.500784,0.125588,0.497648,0.502352,0.125719,0.497125,0.502875,0.126634,0.493466,0.506534,0.129509,0.481965,0.518035,0.151856,0.392577,0.607423,0.145583,0.417669,0.582331,0.139179,0.443283,0.556717,0.140486,0.438055,0.561945,0.129639,0.481443,0.518557,0.121668,0.51333,0.48667,0.119054,0.523785,0.476215,0.083638,0.665447,0.334553,0.08207,0.67172,0.32828,0.097752,0.608991,0.391009,0.092525,0.629901,0.370099,0.07449,0.702039,0.297961,0.075013,0.699948,0.300052,0.081809,0.672765,0.327235,0.087428,0.650288,0.349712,0.100235,0.599059,0.400941,0.098014,0.607946,0.392054,0.087167,0.651333,0.348667,0.093962,0.624151,0.375849,0.084422,0.662311,0.337689,0.091349,0.634605,0.365395,0.08965,0.641401,0.358599,0.08965,0.641401,0.358599,0.089258,0.642969,0.357031,0.097491,0.610037,0.389963,0.105201,0.579195,0.420805,0.113042,0.547831,0.452169};
			return value;
		}
		private double[] getColor_6_24_color_22()
		{
			double[] value = {0.121537,0.513853,0.486147,0.129117,0.483534,0.516466,0.131992,0.472033,0.527967,0.131208,0.47517,0.52483,0.124281,0.502875,0.497125,0.117224,0.531103,0.468897,0.105593,0.577627,0.422373,0.098536,0.605855,0.394145,0.100366,0.598536,0.401464,0.097752,0.608991,0.391009,0.095923,0.616309,0.383691,0.094224,0.623105,0.376895,0.097883,0.608468,0.391532,0.105985,0.576059,0.423941,0.107423,0.570308,0.429692,0.113173,0.547308,0.452692,0.113696,0.545217,0.454783,0.113696,0.545217,0.454783,0.11448,0.542081,0.457919,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.126372,0.494511,0.505489,0.12977,0.48092,0.51908,0.137611,0.449556,0.550444,0.145452,0.418191,0.581809,0.150941,0.396236,0.603764,0.166492,0.33403,0.66597,0.161396,0.354417,0.645583,0.167015,0.331939,0.668061,0.153555,0.385781,0.614219,0.143753,0.424987,0.575013,0.136435,0.45426,0.54574,0.135651,0.457397,0.542603,0.133037,0.467852,0.532148,0.130815,0.476738,0.523262,0.129639,0.481443,0.518557,0.128463,0.486147,0.513853,0.126372,0.494511,0.505489,0.123236,0.507057,0.492943,0.121014,0.515944,0.484056,0.121537,0.513853,0.486147,0.121798,0.512807,0.487193,0.12206,0.511762,0.488238,0.122321,0.510716,0.489284,0.122582,0.509671,0.490329,0.122974,0.508102,0.491898,0.123497,0.506012,0.493988,0.123889,0.504443,0.495557,0.124281,0.502875,0.497125,0.124804,0.500784,0.499216,0.125196,0.499216,0.500784,0.125588,0.497648,0.502352,0.136304,0.454783,0.545217,0.137611,0.449556,0.550444,0.146367,0.414532,0.585468,0.144537,0.42185,0.57815,0.139179,0.443283,0.556717,0.129639,0.481443,0.518557,0.128594,0.485625,0.514375,0.113826,0.544694,0.455306,0.084814,0.660742,0.339258,0.093962,0.624151,0.375849,0.09161,0.63356,0.36644,0.090042,0.639833,0.360167,0.070308,0.718766,0.281234,0.07632,0.69472,0.30528,0.087951,0.648197,0.351803,0.094485,0.62206,0.37794,0.097229,0.611082,0.388918,0.08978,0.640878,0.359122,0.0954,0.6184,0.3816,0.082985,0.668061,0.331939,0.081025,0.675902,0.324098,0.091479,0.634083,0.365917,0.088604,0.645583,0.354417,0.099843,0.600627,0.399373,0.09736,0.610559,0.389441,0.099582,0.601673,0.398327,0.113173,0.547308,0.452692,0.121537,0.513853,0.486147,0.135651,0.457397,0.542603,0.14127,0.434919,0.565081,0.147543,0.409827,0.590173,0.140355,0.438578,0.561422,0.130162,0.479352,0.520648,0.121406,0.514375,0.485625,0.110951,0.556194,0.443806,0.098536,0.605855,0.394145,0.096053,0.615787,0.384213,0.090695,0.637219,0.362781,0.089388,0.642446,0.357554,0.097622,0.609514,0.390486,0.099059,0.603764,0.396236,0.108338,0.566649,0.433351,0.113696,0.545217,0.454783,0.113042,0.547831,0.452169,0.113565,0.54574,0.45426,0.118008,0.527967,0.472033,0.121275,0.514898,0.485102,0.12023,0.51908,0.48092};
			return value;
		}
		private double[] getColor_6_24_color_23()
		{
			double[] value = {0.124151,0.503398,0.496602,0.129639,0.481443,0.518557,0.136566,0.453738,0.546262,0.13748,0.450078,0.549922,0.142969,0.428123,0.571877,0.1546,0.3816,0.6184,0.169106,0.323576,0.676424,1.0,1.0,1.0,0.153947,0.384213,0.615787,0.145583,0.417669,0.582331,0.142838,0.428646,0.571354,0.137742,0.449033,0.550967,0.13735,0.450601,0.549399,0.136304,0.454783,0.545217,0.134867,0.460533,0.539467,0.129639,0.481443,0.518557,0.129378,0.482488,0.517512,0.128725,0.485102,0.514898,0.123758,0.504966,0.495034,0.121145,0.515421,0.484579,0.120883,0.516466,0.483534,0.121145,0.515421,0.484579,0.121406,0.514375,0.485625,0.121537,0.513853,0.486147,0.121798,0.512807,0.487193,0.122321,0.510716,0.489284,0.122844,0.508625,0.491375,0.123366,0.506534,0.493466,0.123628,0.505489,0.494511,0.124281,0.502875,0.497125,0.124804,0.500784,0.499216,0.125457,0.49817,0.50183,0.130685,0.477261,0.522739,0.13735,0.450601,0.549399,0.148066,0.407737,0.592263,0.143361,0.426555,0.573445,0.137742,0.449033,0.550967,0.13735,0.450601,0.549399,0.12219,0.511239,0.488761,0.113173,0.547308,0.452692,0.097099,0.611605,0.388395,0.089519,0.641924,0.358076,0.086905,0.652378,0.347622,0.087689,0.649242,0.350758,0.073706,0.705175,0.294825,0.078411,0.686357,0.313643,0.076189,0.695243,0.304757,0.087689,0.649242,0.350758,0.105071,0.579718,0.420282,0.100105,0.599582,0.400418,0.087428,0.650288,0.349712,0.088735,0.64506,0.35494,0.097622,0.609514,0.390486,0.101542,0.593832,0.406168,0.097622,0.609514,0.390486,0.111343,0.554626,0.445374,0.11265,0.549399,0.450601,0.105724,0.577104,0.422896,0.115264,0.538944,0.461056,0.137219,0.451124,0.548876,0.132776,0.468897,0.531103,0.146236,0.415055,0.584945,0.156691,0.373236,0.626764,0.151202,0.395191,0.604809,0.136566,0.453738,0.546262,0.118792,0.52483,0.47517,0.106639,0.573445,0.426555,0.100105,0.599582,0.400418,0.090173,0.63931,0.36069,0.087297,0.65081,0.34919,0.092002,0.631992,0.368008,0.097752,0.608991,0.391009,0.105724,0.577104,0.422896,0.104809,0.580763,0.419237,0.113042,0.547831,0.452169,0.113696,0.545217,0.454783,0.113826,0.544694,0.455306,0.116309,0.534762,0.465238,0.122974,0.508102,0.491898,0.126111,0.495557,0.504443,0.128986,0.484056,0.515944,0.126634,0.493466,0.506534,0.137611,0.449556,0.550444,0.13931,0.44276,0.55724,0.153293,0.386827,0.613173,0.161396,0.354417,0.645583,0.166623,0.333508,0.666492,0.166492,0.33403,0.66597,0.155776,0.376895,0.623105,0.152901,0.388395,0.611605,0.144145,0.423419,0.576581,0.148458,0.406168,0.593832,0.146367,0.414532,0.585468,0.143231,0.427078,0.572922,0.139049,0.443806,0.556194,0.136958,0.452169,0.547831,0.131992,0.472033,0.527967,0.128725,0.485102,0.514898,0.123758,0.504966,0.495034,0.121406,0.514375,0.485625};
			return value;
		}
		private double[] getColor_6_24_color_24()
		{
			double[] value = {0.120883,0.516466,0.483534,0.120883,0.516466,0.483534,0.120883,0.516466,0.483534,0.120883,0.516466,0.483534,0.121275,0.514898,0.485102,0.121668,0.51333,0.48667,0.122582,0.509671,0.490329,0.123497,0.506012,0.493988,0.124543,0.50183,0.49817,0.125588,0.497648,0.502352,0.125457,0.49817,0.50183,0.136566,0.453738,0.546262,0.151072,0.395714,0.604286,0.16218,0.351281,0.648719,0.145714,0.417146,0.582854,0.145452,0.418191,0.581809,0.140225,0.439101,0.560899,0.134867,0.460533,0.539467,0.113042,0.547831,0.452169,0.107031,0.571877,0.428123,0.08965,0.641401,0.358599,0.084814,0.660742,0.339258,0.082201,0.671197,0.328803,0.081809,0.672765,0.327235,0.07436,0.702561,0.297439,0.071485,0.714062,0.285938,0.086252,0.654992,0.345008,0.095139,0.619446,0.380554,0.110951,0.556194,0.443806,0.107162,0.571354,0.428646,0.096445,0.614219,0.385781,0.07253,0.70988,0.29012,0.082331,0.670674,0.329326,0.096576,0.613696,0.386304,0.115003,0.53999,0.46001,0.134344,0.462624,0.537376,0.1316,0.473602,0.526398,0.117094,0.531626,0.468374,0.126764,0.492943,0.507057,0.129509,0.481965,0.518035,0.123758,0.504966,0.495034,0.139702,0.441192,0.558808,0.132122,0.471511,0.528489,0.126242,0.495034,0.504966,0.109906,0.560376,0.439624,0.111866,0.552535,0.447465,0.111082,0.555672,0.444328,0.102849,0.588604,0.411396,0.096837,0.61265,0.38735,0.087689,0.649242,0.350758,0.097229,0.611082,0.388918,0.105071,0.579718,0.420282,0.105593,0.577627,0.422373,0.113042,0.547831,0.452169,0.106377,0.57449,0.42551,0.117224,0.531103,0.468897,0.121014,0.515944,0.484056,0.121668,0.51333,0.48667,0.121406,0.514375,0.485625,0.129378,0.482488,0.517512,0.132384,0.470465,0.529535,0.133168,0.467329,0.532671,0.137611,0.449556,0.550444,0.147804,0.408782,0.591218,0.153555,0.385781,0.614219,0.168453,0.326189,0.673811,0.173941,0.304234,0.695766,0.173549,0.305802,0.694198,0.169237,0.323053,0.676947,0.161396,0.354417,0.645583,0.154731,0.381077,0.618923,0.161396,0.354417,0.645583,0.152901,0.388395,0.611605,0.146498,0.414009,0.585991,0.145321,0.418714,0.581286,0.13748,0.450078,0.549922,0.131469,0.474124,0.525876,0.12794,0.488238,0.511762,0.123628,0.505489,0.494511,0.121145,0.515421,0.484579,0.120883,0.516466,0.483534,0.120883,0.516466,0.483534,0.120883,0.516466,0.483534,0.120883,0.516466,0.483534,0.121537,0.513853,0.486147,0.121668,0.51333,0.48667,0.124151,0.503398,0.496602,0.124281,0.502875,0.497125,0.124935,0.500261,0.499739,0.125588,0.497648,0.502352,0.13173,0.473079,0.526921,0.148327,0.406691,0.593309,0.16597,0.336121,0.663879,0.153293,0.386827,0.613173,0.152378,0.390486,0.609514,0.15068,0.397282,0.602718,0.131469,0.474124,0.525876,0.132645,0.46942,0.53058,0.107946,0.568217,0.431783,0.105724,0.577104,0.422896};
			return value;
		}
		private double[] getColor_6_24_color_25()
		{
			double[] value = {0.076973,0.692107,0.307893,0.081286,0.674856,0.325144,0.081809,0.672765,0.327235,0.081678,0.673288,0.326712,0.074752,0.700993,0.299007,0.065734,0.737062,0.262938,0.082593,0.669629,0.330371,0.089127,0.643492,0.356508,0.103502,0.585991,0.414009,0.098144,0.607423,0.392577,0.100627,0.597491,0.402509,0.07449,0.702039,0.297961,0.080633,0.67747,0.32253,0.105985,0.576059,0.423941,0.127548,0.489807,0.510193,0.113696,0.545217,0.454783,0.09932,0.602718,0.397282,0.104548,0.581809,0.418191,0.105724,0.577104,0.422896,0.106377,0.57449,0.42551,0.126634,0.493466,0.506534,0.130162,0.479352,0.520648,0.148066,0.407737,0.592263,0.112781,0.548876,0.451124,0.10311,0.587559,0.412441,0.097752,0.608991,0.391009,0.113565,0.54574,0.45426,0.111605,0.553581,0.446419,0.110559,0.557763,0.442237,0.09357,0.625719,0.374281,0.105724,0.577104,0.422896,0.107554,0.569786,0.430214,0.113434,0.546262,0.453738,0.113565,0.54574,0.45426,0.121537,0.513853,0.486147,0.115525,0.537899,0.462101,0.121668,0.51333,0.48667,0.126503,0.493988,0.506012,0.129378,0.482488,0.517512,0.130423,0.478306,0.521694,0.137611,0.449556,0.550444,0.137611,0.449556,0.550444,0.139833,0.440669,0.559331,0.150157,0.399373,0.600627,0.157606,0.369577,0.630423,0.156299,0.374804,0.625196,0.167146,0.331417,0.668583,1.0,1.0,1.0,0.171458,0.314166,0.685834,0.167146,0.331417,0.668583,0.165186,0.339258,0.660742,0.160742,0.357031,0.642969,0.149373,0.402509,0.597491,0.145191,0.419237,0.580763,0.142054,0.431783,0.568217,0.137219,0.451124,0.548876,0.130815,0.476738,0.523262,0.127679,0.489284,0.510716,0.123628,0.505489,0.494511,0.121275,0.514898,0.485102,0.120883,0.516466,0.483534,0.121145,0.515421,0.484579,0.121537,0.513853,0.486147,0.122582,0.509671,0.490329,0.124151,0.503398,0.496602,0.126111,0.495557,0.504443,0.126764,0.492943,0.507057,0.125457,0.49817,0.50183,0.125719,0.497125,0.502875,0.126895,0.49242,0.50758,0.13173,0.473079,0.526921,0.14114,0.435442,0.564558,0.151464,0.394145,0.605855,0.157737,0.369054,0.630946,0.148327,0.406691,0.593309,0.131861,0.472556,0.527444,0.121668,0.51333,0.48667,0.115264,0.538944,0.461056,0.106247,0.575013,0.424987,0.103372,0.586513,0.413487,0.066911,0.732358,0.267642,0.081155,0.675379,0.324621,0.081286,0.674856,0.325144,0.073837,0.704652,0.295348,0.072791,0.708834,0.291166,0.062075,0.751699,0.248301,0.07828,0.686879,0.313121,0.081809,0.672765,0.327235,0.083377,0.666492,0.333508,0.08978,0.640878,0.359122,0.077888,0.688447,0.311553,0.075274,0.698902,0.301098,0.075797,0.696811,0.303189,0.120883,0.516466,0.483534,0.096837,0.61265,0.38735,0.089911,0.640355,0.359645,0.090042,0.639833,0.360167,0.090695,0.637219,0.362781,0.09736,0.610559,0.389441,0.10886,0.564558,0.435442};
			return value;
		}
		private double[] getColor_6_24_color_26()
		{
			double[] value = {0.09919,0.603241,0.396759,0.10873,0.565081,0.434919,0.106508,0.573968,0.426032,0.097752,0.608991,0.391009,0.090565,0.637742,0.362258,0.089911,0.640355,0.359645,0.099582,0.601673,0.398327,0.099974,0.600105,0.399895,0.098536,0.605855,0.394145,0.096707,0.613173,0.386827,0.115003,0.53999,0.46001,0.116571,0.533717,0.466283,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.122844,0.508625,0.491375,0.129509,0.481965,0.518035,0.117486,0.530058,0.469942,0.124151,0.503398,0.496602,0.136435,0.45426,0.54574,0.131077,0.475693,0.524307,0.134344,0.462624,0.537376,0.139441,0.442237,0.557763,0.145583,0.417669,0.582331,0.149895,0.400418,0.599582,0.158521,0.365917,0.634083,0.160481,0.358076,0.641924,0.162833,0.348667,0.651333,1.0,1.0,1.0,0.172112,0.311553,0.688447,0.16597,0.336121,0.663879,0.16218,0.351281,0.648719,0.155515,0.37794,0.62206,0.149373,0.402509,0.597491,0.140748,0.43701,0.56299,0.137611,0.449556,0.550444,0.134344,0.462624,0.537376,0.129901,0.480397,0.519603,0.127418,0.490329,0.509671,0.123628,0.505489,0.494511,0.121537,0.513853,0.486147,0.121145,0.515421,0.484579,0.121668,0.51333,0.48667,0.124412,0.502352,0.497648,0.126111,0.495557,0.504443,0.127548,0.489807,0.510193,0.132384,0.470465,0.529535,0.138395,0.446419,0.553581,0.126503,0.493988,0.506012,0.131469,0.474124,0.525876,0.13356,0.465761,0.534239,0.13552,0.457919,0.542081,0.140225,0.439101,0.560899,0.153947,0.384213,0.615787,0.170152,0.319394,0.680606,0.141532,0.433873,0.566127,0.131208,0.47517,0.52483,0.11448,0.542081,0.457919,0.107815,0.56874,0.43126,0.102326,0.590695,0.409305,0.097752,0.608991,0.391009,0.072007,0.711971,0.288029,0.086513,0.653947,0.346053,0.081155,0.675379,0.324621,0.066649,0.733403,0.266597,0.073576,0.705698,0.294302,0.058285,0.766858,0.233142,0.073837,0.704652,0.295348,0.073837,0.704652,0.295348,0.07449,0.702039,0.297961,0.08024,0.679038,0.320962,0.071615,0.713539,0.286461,0.071877,0.712493,0.287507,0.077104,0.691584,0.308416,0.087297,0.65081,0.34919,0.08586,0.65656,0.34344,0.081809,0.672765,0.327235,0.088474,0.646106,0.353894,0.089519,0.641924,0.358076,0.08978,0.640878,0.359122,0.090173,0.63931,0.36069,0.095531,0.617878,0.382122,0.105724,0.577104,0.422896,0.108468,0.566127,0.433873,0.090826,0.636696,0.363304,0.091349,0.634605,0.365395,0.084945,0.66022,0.33978,0.080763,0.676947,0.323053,0.080371,0.678515,0.321485,0.085206,0.659174,0.340826,0.10873,0.565081,0.434919,0.112781,0.548876,0.451124,0.122452,0.510193,0.489807,0.129117,0.483534,0.516466,0.129639,0.481443,0.518557,0.129639,0.481443,0.518557,0.129639,0.481443,0.518557,0.133037,0.467852,0.532148,0.122974,0.508102,0.491898,0.137219,0.451124,0.548876,0.140486,0.438055,0.561945};
			return value;
		}
		private double[] getColor_6_24_color_27()
		{
			double[] value = {0.1431,0.427601,0.572399,0.145191,0.419237,0.580763,0.147151,0.411396,0.588604,0.154339,0.382645,0.617355,0.158521,0.365917,0.634083,0.169367,0.32253,0.67747,0.17172,0.313121,0.686879,1.0,1.0,1.0,0.173549,0.305802,0.694198,0.169367,0.32253,0.67747,0.161526,0.353894,0.646106,0.151986,0.392054,0.607946,0.145583,0.417669,0.582331,0.138134,0.447465,0.552535,0.132384,0.470465,0.529535,0.130685,0.477261,0.522739,0.129117,0.483534,0.516466,0.126764,0.492943,0.507057,0.123628,0.505489,0.494511,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.125457,0.49817,0.50183,0.127287,0.490852,0.509148,0.129117,0.483534,0.516466,0.132906,0.468374,0.531626,0.149634,0.401464,0.598536,0.146106,0.415578,0.584422,0.137611,0.449556,0.550444,0.137611,0.449556,0.550444,0.141924,0.432305,0.567695,0.141532,0.433873,0.566127,0.147282,0.410873,0.589127,0.168714,0.325144,0.674856,1.0,1.0,1.0,0.132645,0.46942,0.53058,0.123889,0.504443,0.495557,0.111866,0.552535,0.447465,0.105201,0.579195,0.420805,0.09932,0.602718,0.397282,0.097752,0.608991,0.391009,0.073706,0.705175,0.294825,0.079326,0.682697,0.317303,0.081678,0.673288,0.326712,0.065865,0.736539,0.263461,0.074098,0.703607,0.296393,0.072007,0.711971,0.288029,0.065865,0.736539,0.263461,0.065865,0.736539,0.263461,0.071746,0.713016,0.286984,0.075536,0.697857,0.302143,0.06495,0.740199,0.259801,0.073706,0.705175,0.294825,0.075666,0.697334,0.302666,0.081678,0.673288,0.326712,0.081809,0.672765,0.327235,0.084292,0.662833,0.337167,0.096837,0.61265,0.38735,0.093048,0.62781,0.37219,0.093048,0.62781,0.37219,0.084161,0.663356,0.336644,0.092786,0.628855,0.371145,0.093178,0.627287,0.372713,0.08586,0.65656,0.34344,0.087167,0.651333,0.348667,0.076189,0.695243,0.304757,0.073445,0.706221,0.293779,0.082593,0.669629,0.330371,0.101019,0.595923,0.404077,0.090695,0.637219,0.362781,0.113042,0.547831,0.452169,0.118923,0.524307,0.475693,0.129509,0.481965,0.518035,0.138134,0.447465,0.552535,0.137742,0.449033,0.550967,0.138395,0.446419,0.553581,0.137611,0.449556,0.550444,0.137742,0.449033,0.550967,0.121929,0.512284,0.487716,0.141793,0.432828,0.567172,0.140748,0.43701,0.56299,0.145583,0.417669,0.582331,0.153424,0.386304,0.613696,0.174856,0.300575,0.699425,0.1661,0.335599,0.664401,0.156038,0.375849,0.624151,0.172765,0.308939,0.691061,0.172765,0.308939,0.691061,1.0,1.0,1.0,1.0,1.0,1.0,0.17185,0.312598,0.687402,0.161788,0.352849,0.647151,0.153293,0.386827,0.613173,0.145452,0.418191,0.581809,0.136827,0.452692,0.547308,0.131469,0.474124,0.525876,0.128463,0.486147,0.513853,0.126503,0.493988,0.506012,0.124543,0.50183,0.49817,0.122582,0.509671,0.490329,0.121668,0.51333,0.48667};
			return value;
		}
		private double[] getColor_6_24_color_28()
		{
			double[] value = {0.124412,0.502352,0.497648,0.128725,0.485102,0.514898,0.129639,0.481443,0.518557,0.133952,0.464192,0.535808,0.137088,0.451647,0.548353,0.146628,0.413487,0.586513,0.138395,0.446419,0.553581,0.137611,0.449556,0.550444,0.137611,0.449556,0.550444,0.144145,0.423419,0.576581,0.156822,0.372713,0.627287,0.164794,0.340826,0.659174,0.154992,0.380031,0.619969,0.143492,0.426032,0.573968,0.144668,0.421328,0.578672,0.113826,0.544694,0.455306,0.108599,0.565604,0.434396,0.101281,0.594877,0.405123,0.097622,0.609514,0.390486,0.09357,0.625719,0.374281,0.073706,0.705175,0.294825,0.085337,0.658651,0.341349,0.084945,0.66022,0.33978,0.069524,0.721903,0.278097,0.093962,0.624151,0.375849,0.066257,0.734971,0.265029,0.052927,0.788291,0.211709,0.057893,0.768427,0.231573,0.065865,0.736539,0.263461,0.06861,0.725562,0.274438,0.062598,0.749608,0.250392,0.073837,0.704652,0.295348,0.073706,0.705175,0.294825,0.073837,0.704652,0.295348,0.081025,0.675902,0.324098,0.08965,0.641401,0.358599,0.082593,0.669629,0.330371,0.092263,0.630946,0.369054,0.090565,0.637742,0.362258,0.081678,0.673288,0.326712,0.088212,0.647151,0.352849,0.089388,0.642446,0.357554,0.081025,0.675902,0.324098,0.07632,0.69472,0.30528,0.081678,0.673288,0.326712,0.082201,0.671197,0.328803,0.090434,0.638265,0.361735,0.105724,0.577104,0.422896,0.113696,0.545217,0.454783,0.111866,0.552535,0.447465,0.117878,0.528489,0.471511,0.129117,0.483534,0.516466,0.144407,0.422373,0.577627,0.146106,0.415578,0.584422,0.153424,0.386304,0.613696,0.15264,0.389441,0.610559,0.159043,0.363826,0.636174,0.145583,0.417669,0.582331,0.139963,0.440146,0.559854,0.146106,0.415578,0.584422,0.153032,0.387872,0.612128,0.161396,0.354417,0.645583,0.163095,0.347622,0.652378,0.164401,0.342394,0.657606,0.165578,0.337689,0.662311,0.172112,0.311553,0.688447,0.170674,0.317303,0.682697,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.169367,0.32253,0.67747,0.153293,0.386827,0.613173,0.142969,0.428123,0.571877,0.135781,0.456874,0.543126,0.131208,0.47517,0.52483,0.128855,0.484579,0.515421,0.128986,0.484056,0.515944,0.129117,0.483534,0.516466,0.129247,0.483011,0.516989,0.129247,0.483011,0.516989,0.129378,0.482488,0.517512,0.129378,0.482488,0.517512,0.135389,0.458442,0.541558,0.137219,0.451124,0.548876,0.154339,0.382645,0.617355,0.147674,0.409305,0.590695,0.145583,0.417669,0.582331,0.145191,0.419237,0.580763,0.143623,0.42551,0.57449,0.153685,0.385259,0.614741,0.159174,0.363304,0.636696,0.154077,0.383691,0.616309,1.0,1.0,1.0,0.130946,0.476215,0.523785,0.1316,0.473602,0.526398,0.109122,0.563513,0.436487,0.104679,0.581286,0.418714,0.098536,0.605855,0.394145,0.097491,0.610037,0.389963,0.08978,0.640878,0.359122};
			return value;
		}
		private double[] getColor_6_24_color_29()
		{
			double[] value = {0.065212,0.739153,0.260847,0.06678,0.73288,0.26712,0.057893,0.768427,0.231573,0.072007,0.711971,0.288029,0.067041,0.731835,0.268165,0.057893,0.768427,0.231573,0.061683,0.753267,0.246733,0.057893,0.768427,0.231573,0.057632,0.769472,0.230528,0.063643,0.745426,0.254574,0.058547,0.765813,0.234187,0.065865,0.736539,0.263461,0.065865,0.736539,0.263461,0.073837,0.704652,0.295348,0.074229,0.703084,0.296916,0.077104,0.691584,0.308416,0.082854,0.668583,0.331417,0.082462,0.670152,0.329848,0.085206,0.659174,0.340826,0.081809,0.672765,0.327235,0.075013,0.699948,0.300052,0.063905,0.744381,0.255619,0.071223,0.715107,0.284893,0.081809,0.672765,0.327235,0.0839,0.664401,0.335599,0.092002,0.631992,0.368008,0.100889,0.596445,0.403555,0.098144,0.607423,0.392577,0.110559,0.557763,0.442237,0.1069,0.572399,0.427601,0.128594,0.485625,0.514375,0.140094,0.439624,0.560376,0.151464,0.394145,0.605855,0.145714,0.417146,0.582854,0.161134,0.355463,0.644537,0.165316,0.338735,0.661265,0.159174,0.363304,0.636696,0.148458,0.406168,0.593832,0.135781,0.456874,0.543126,0.158521,0.365917,0.634083,0.156952,0.37219,0.62781,0.163617,0.345531,0.654469,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.165578,0.337689,0.662311,0.151072,0.395714,0.604286,0.141662,0.433351,0.566649,0.135389,0.458442,0.541558,0.129639,0.481443,0.518557,0.128855,0.484579,0.515421,0.128986,0.484056,0.515944,0.129117,0.483534,0.516466,0.129247,0.483011,0.516989,0.129378,0.482488,0.517512,0.129509,0.481965,0.518035,0.129509,0.481965,0.518035,0.131992,0.472033,0.527967,0.140617,0.437533,0.562467,0.149895,0.400418,0.599582,0.153424,0.386304,0.613696,0.147804,0.408782,0.591218,0.153032,0.387872,0.612128,0.152509,0.389963,0.610037,0.160089,0.359645,0.640355,0.149373,0.402509,0.597491,0.137872,0.44851,0.55149,0.138134,0.447465,0.552535,0.127679,0.489284,0.510716,0.120753,0.516989,0.483011,0.105985,0.576059,0.423941,0.102588,0.58965,0.41035,0.097752,0.608991,0.391009,0.09344,0.626242,0.373758,0.08978,0.640878,0.359122,0.057632,0.769472,0.230528,0.056979,0.772086,0.227914,0.051098,0.795609,0.204391,0.060768,0.756926,0.243074,0.058285,0.766858,0.233142,0.052535,0.789859,0.210141,0.056848,0.772608,0.227392,0.050314,0.798745,0.201255,0.057763,0.768949,0.231051,0.058547,0.765813,0.234187,0.053581,0.785677,0.214323,0.058416,0.766336,0.233664,0.065342,0.73863,0.26137,0.065865,0.736539,0.263461,0.066127,0.735494,0.264506,0.071877,0.712493,0.287507,0.071746,0.713016,0.286984,0.073706,0.705175,0.294825,0.073837,0.704652,0.295348,0.072661,0.709357,0.290643};
			return value;
		}
		private double[] getColor_6_24_color_30()
		{
			double[] value = {0.057893,0.768427,0.231573,0.073053,0.707789,0.292211,0.07436,0.702561,0.297439,0.088604,0.645583,0.354417,0.092263,0.630946,0.369054,0.100758,0.596968,0.403032,0.108991,0.564036,0.435964,0.113957,0.544171,0.455829,0.128463,0.486147,0.513853,0.131338,0.474647,0.525353,0.137742,0.449033,0.550967,0.133429,0.466283,0.533717,0.150549,0.397804,0.602196,0.158913,0.364349,0.635651,0.162311,0.350758,0.649242,1.0,1.0,1.0,0.173027,0.307893,0.692107,0.154992,0.380031,0.619969,0.139702,0.441192,0.558808,0.161396,0.354417,0.645583,0.169367,0.32253,0.67747,0.173811,0.304757,0.695243,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.163095,0.347622,0.652378,0.15068,0.397282,0.602718,0.138265,0.446942,0.553058,0.134605,0.461579,0.538421,0.129509,0.481965,0.518035,0.128725,0.485102,0.514898,0.128986,0.484056,0.515944,0.129117,0.483534,0.516466,0.129247,0.483011,0.516989,0.129509,0.481965,0.518035,0.129509,0.481965,0.518035,0.129639,0.481443,0.518557,0.132645,0.46942,0.53058,0.137088,0.451647,0.548353,0.143623,0.42551,0.57449,0.154339,0.382645,0.617355,0.153947,0.384213,0.615787,0.156299,0.374804,0.625196,0.149373,0.402509,0.597491,0.145191,0.419237,0.580763,0.138003,0.447987,0.552013,0.131338,0.474647,0.525353,0.129639,0.481443,0.518557,0.12219,0.511239,0.488761,0.114349,0.542603,0.457397,0.111735,0.553058,0.446942,0.104025,0.5839,0.4161,0.098275,0.6069,0.3931,0.091218,0.635128,0.364872,0.08978,0.640878,0.359122,0.050183,0.799268,0.200732,0.049922,0.800314,0.199686,0.050575,0.7977,0.2023,0.049137,0.80345,0.19655,0.049791,0.800836,0.199164,0.049922,0.800314,0.199686,0.049922,0.800314,0.199686,0.050314,0.798745,0.201255,0.049922,0.800314,0.199686,0.05541,0.778359,0.221641,0.04953,0.801882,0.198118,0.057893,0.768427,0.231573,0.06103,0.755881,0.244119,0.063905,0.744381,0.255619,0.065081,0.739676,0.260324,0.065865,0.736539,0.263461,0.065865,0.736539,0.263461,0.065996,0.736017,0.263983,0.065865,0.736539,0.263461,0.055672,0.777313,0.222687,0.068348,0.726607,0.273393,0.079326,0.682697,0.317303,0.086905,0.652378,0.347622,0.084422,0.662311,0.337689,0.097491,0.610037,0.389963,0.105985,0.576059,0.423941,0.114349,0.542603,0.457397,0.135912,0.456351,0.543649,0.157344,0.370622,0.629378,0.172373,0.310507,0.689493,1.0,1.0,1.0,0.148458,0.406168,0.593832,0.140878,0.436487,0.563513,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.161134,0.355463,0.644537,0.150549,0.397804,0.602196,0.151594,0.393623,0.606377};
			return value;
		}
		private double[] getColor_6_24_color_31()
		{
			double[] value = {0.161526,0.353894,0.646106,0.16414,0.34344,0.65656,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.145452,0.418191,0.581809,0.137611,0.449556,0.550444,0.135651,0.457397,0.542603,0.131077,0.475693,0.524307,0.130031,0.479875,0.520125,0.129378,0.482488,0.517512,0.132776,0.468897,0.531103,0.129901,0.480397,0.519603,0.129639,0.481443,0.518557,0.143884,0.424464,0.575536,0.141793,0.432828,0.567172,0.136566,0.453738,0.546262,0.13735,0.450601,0.549399,0.145714,0.417146,0.582854,0.153424,0.386304,0.613696,0.149765,0.400941,0.599059,0.16597,0.336121,0.663879,0.149111,0.403555,0.596445,0.145321,0.418714,0.581286,0.136304,0.454783,0.545217,0.129639,0.481443,0.518557,0.128986,0.484056,0.515944,0.117616,0.529535,0.470465,0.113696,0.545217,0.454783,0.113696,0.545217,0.454783,0.10494,0.58024,0.41976,0.097622,0.609514,0.390486,0.091087,0.635651,0.364349,0.086775,0.652901,0.347099,0.049791,0.800836,0.199164,0.047177,0.811291,0.188709,0.044302,0.822791,0.177209,0.042211,0.831155,0.168845,0.042081,0.831678,0.168322,0.042081,0.831678,0.168322,0.042081,0.831678,0.168322,0.045217,0.819132,0.180868,0.049922,0.800314,0.199686,0.049922,0.800314,0.199686,0.04953,0.801882,0.198118,0.055541,0.777836,0.222164,0.057893,0.768427,0.231573,0.058155,0.767381,0.232619,0.058024,0.767904,0.232096,0.058024,0.767904,0.232096,0.057893,0.768427,0.231573,0.058155,0.767381,0.232619,0.054496,0.782018,0.217982,0.061814,0.752744,0.247256,0.073183,0.707266,0.292734,0.081809,0.672765,0.327235,0.08965,0.641401,0.358599,0.097622,0.609514,0.390486,0.100627,0.597491,0.402509,0.120622,0.517512,0.482488,0.129639,0.481443,0.518557,0.166884,0.332462,0.667538,1.0,1.0,1.0,1.0,1.0,1.0,0.170674,0.317303,0.682697,1.0,1.0,1.0,0.164794,0.340826,0.659174,0.173157,0.307371,0.692629,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.156299,0.374804,0.625196,0.138657,0.445374,0.554626,0.143623,0.42551,0.57449,0.152509,0.389963,0.610037,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.166231,0.335076,0.664924,0.155254,0.378986,0.621014,0.152771,0.388918,0.611082,0.163617,0.345531,0.654469,0.149503,0.401986,0.598014,0.144668,0.421328,0.578672,0.132645,0.46942,0.53058,0.129509,0.481965,0.518035,0.127418,0.490329,0.509671,0.12598,0.496079,0.503921,0.136304,0.454783,0.545217,0.137611,0.449556,0.550444,0.12977,0.48092,0.51908,0.129639,0.481443,0.518557};
			return value;
		}
		private double[] getColor_6_24_color_32()
		{
			double[] value = {0.142185,0.43126,0.56874,0.138526,0.445896,0.554104,0.137611,0.449556,0.550444,0.137611,0.449556,0.550444,0.144015,0.423941,0.576059,0.146759,0.412964,0.587036,0.145191,0.419237,0.580763,0.145452,0.418191,0.581809,0.137742,0.449033,0.550967,0.131861,0.472556,0.527444,0.128725,0.485102,0.514898,0.121798,0.512807,0.487193,0.121668,0.51333,0.48667,0.113696,0.545217,0.454783,0.109122,0.563513,0.436487,0.105463,0.57815,0.42185,0.097752,0.608991,0.391009,0.096053,0.615787,0.384213,0.08978,0.640878,0.359122,0.082854,0.668583,0.331417,0.042865,0.828542,0.171458,0.042473,0.83011,0.16989,0.042211,0.831155,0.168845,0.041296,0.834814,0.165186,0.038291,0.846837,0.153163,0.035285,0.85886,0.14114,0.042342,0.830633,0.169367,0.045478,0.818087,0.181913,0.048876,0.804496,0.195504,0.049922,0.800314,0.199686,0.049268,0.802927,0.197073,0.050836,0.796654,0.203346,0.053058,0.787768,0.212232,0.05541,0.778359,0.221641,0.057632,0.769472,0.230528,0.057893,0.768427,0.231573,0.057632,0.769472,0.230528,0.048745,0.805018,0.194982,0.057893,0.768427,0.231573,0.065865,0.736539,0.263461,0.072269,0.710925,0.289075,0.077496,0.690016,0.309984,0.086383,0.654469,0.345531,0.106377,0.57449,0.42551,0.117224,0.531103,0.468897,0.122713,0.509148,0.490852,0.121537,0.513853,0.486147,0.170152,0.319394,0.680606,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.151856,0.392577,0.607423,0.145452,0.418191,0.581809,0.133691,0.465238,0.534762,0.121798,0.512807,0.487193,0.148066,0.407737,0.592263,0.152248,0.391009,0.608991,0.170805,0.31678,0.68322,1.0,1.0,1.0,0.154077,0.383691,0.616309,0.146367,0.414532,0.585468,0.1546,0.3816,0.6184,0.150549,0.397804,0.602196,0.137611,0.449556,0.550444,0.136566,0.453738,0.546262,0.13735,0.450601,0.549399,0.128071,0.487716,0.512284,0.122974,0.508102,0.491898,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.125588,0.497648,0.502352,0.12781,0.488761,0.511239,0.129639,0.481443,0.518557,0.129639,0.481443,0.518557,0.129901,0.480397,0.519603,0.137219,0.451124,0.548876,0.137611,0.449556,0.550444,0.139049,0.443806,0.556194,0.145583,0.417669,0.582331,0.141793,0.432828,0.567172,0.138003,0.447987,0.552013,0.137611,0.449556,0.550444,0.137611,0.449556,0.550444,0.137611,0.449556,0.550444,0.122452,0.510193,0.489807,0.121668,0.51333,0.48667,0.116309,0.534762,0.465238,0.113565,0.54574,0.45426,0.105724,0.577104,0.422896,0.103372,0.586513,0.413487,0.102588,0.58965,0.41035,0.091087,0.635651,0.364349,0.08978,0.640878,0.359122,0.089519,0.641924,0.358076};
			return value;
		}
		private double[] getColor_6_24_color_33()
		{
			double[] value = {0.041296,0.834814,0.165186,0.04195,0.832201,0.167799,0.039728,0.841087,0.158913,0.034109,0.863565,0.136435,0.033325,0.866702,0.133298,0.04195,0.832201,0.167799,0.042342,0.830633,0.169367,0.042211,0.831155,0.168845,0.042081,0.831678,0.168322,0.042081,0.831678,0.168322,0.046785,0.812859,0.187141,0.049922,0.800314,0.199686,0.050314,0.798745,0.201255,0.050052,0.799791,0.200209,0.050052,0.799791,0.200209,0.050052,0.799791,0.200209,0.049791,0.800836,0.199164,0.052797,0.788813,0.211187,0.05907,0.763722,0.236278,0.065865,0.736539,0.263461,0.073706,0.705175,0.294825,0.075144,0.699425,0.300575,0.082723,0.669106,0.330894,0.091087,0.635651,0.364349,0.103764,0.584945,0.415055,0.129639,0.481443,0.518557,0.131208,0.47517,0.52483,0.14127,0.434919,0.565081,1.0,1.0,1.0,0.168714,0.325144,0.674856,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.149242,0.403032,0.596968,0.158521,0.365917,0.634083,0.139441,0.442237,0.557763,0.122321,0.510716,0.489284,0.13173,0.473079,0.526921,0.127287,0.490852,0.509148,0.129509,0.481965,0.518035,0.140486,0.438055,0.561945,0.16035,0.358599,0.641401,0.150157,0.399373,0.600627,0.131077,0.475693,0.524307,0.133952,0.464192,0.535808,0.123105,0.50758,0.49242,0.12794,0.488238,0.511762,0.12794,0.488238,0.511762,0.124804,0.500784,0.499216,0.121798,0.512807,0.487193,0.120753,0.516989,0.483011,0.119446,0.522216,0.477784,0.121537,0.513853,0.486147,0.121929,0.512284,0.487716,0.124935,0.500261,0.499739,0.129509,0.481965,0.518035,0.129639,0.481443,0.518557,0.132384,0.470465,0.529535,0.130946,0.476215,0.523785,0.136435,0.45426,0.54574,0.13735,0.450601,0.549399,0.13748,0.450078,0.549922,0.136958,0.452169,0.547831,0.133691,0.465238,0.534762,0.135128,0.459488,0.540512,0.13356,0.465761,0.534239,0.135912,0.456351,0.543649,0.13735,0.450601,0.549399,0.133298,0.466806,0.533194,0.118531,0.525876,0.474124,0.113042,0.547831,0.452169,0.105855,0.576581,0.423419,0.10115,0.5954,0.4046,0.097752,0.608991,0.391009,0.092786,0.628855,0.371145,0.091087,0.635651,0.364349,0.082462,0.670152,0.329848,0.034501,0.861997,0.138003,0.034239,0.863042,0.136958,0.034109,0.863565,0.136435,0.029796,0.880815,0.119185,0.036592,0.853633,0.146367,0.041427,0.834292,0.165708,0.042081,0.831678,0.168322,0.042081,0.831678,0.168322,0.042081,0.831678,0.168322,0.03999,0.840042,0.159958,0.042865,0.828542,0.171458,0.04574,0.817041,0.182959,0.048484,0.806064,0.193936,0.049922,0.800314,0.199686,0.049922,0.800314,0.199686,0.049922,0.800314,0.199686,0.04953,0.801882,0.198118,0.056325,0.774699,0.225301,0.067433,0.730267,0.269733,0.065865,0.736539,0.263461};
			return value;
		}
		private double[] getColor_6_24_color_34()
		{
			double[] value = {0.07057,0.717721,0.282279,0.075013,0.699948,0.300052,0.08403,0.663879,0.336121,0.096445,0.614219,0.385781,0.123758,0.504966,0.495034,0.131469,0.474124,0.525876,0.139702,0.441192,0.558808,0.154208,0.383168,0.616832,0.144668,0.421328,0.578672,0.13735,0.450601,0.549399,0.14127,0.434919,0.565081,0.173288,0.306848,0.693152,0.154208,0.383168,0.616832,1.0,1.0,1.0,0.153947,0.384213,0.615787,0.15839,0.36644,0.63356,0.126242,0.495034,0.504966,0.150288,0.39885,0.60115,0.117094,0.531626,0.468374,0.105985,0.576059,0.423941,0.128986,0.484056,0.515944,0.114349,0.542603,0.457397,0.118662,0.525353,0.474647,0.121929,0.512284,0.487716,0.127287,0.490852,0.509148,0.136566,0.453738,0.546262,0.144015,0.423941,0.576059,0.136174,0.455306,0.544694,0.123889,0.504443,0.495557,0.109252,0.56299,0.43701,0.115264,0.538944,0.461056,0.116048,0.535808,0.464192,0.115917,0.53633,0.46367,0.113957,0.544171,0.455829,0.113696,0.545217,0.454783,0.115264,0.538944,0.461056,0.123497,0.506012,0.493988,0.121668,0.51333,0.48667,0.124543,0.50183,0.49817,0.129247,0.483011,0.516989,0.127287,0.490852,0.509148,0.129509,0.481965,0.518035,0.129378,0.482488,0.517512,0.130423,0.478306,0.521694,0.129639,0.481443,0.518557,0.129639,0.481443,0.518557,0.129639,0.481443,0.518557,0.129639,0.481443,0.518557,0.129639,0.481443,0.518557,0.129639,0.481443,0.518557,0.130685,0.477261,0.522739,0.134344,0.462624,0.537376,0.128986,0.484056,0.515944,0.117878,0.528489,0.471511,0.109645,0.561422,0.438578,0.105593,0.577627,0.422373,0.101934,0.592263,0.407737,0.097752,0.608991,0.391009,0.090565,0.637742,0.362258,0.08965,0.641401,0.358599,0.033847,0.864611,0.135389,0.03045,0.878202,0.121798,0.025876,0.896498,0.103502,0.034239,0.863042,0.136958,0.036461,0.854156,0.145844,0.038421,0.846315,0.153685,0.040643,0.837428,0.162572,0.041819,0.832723,0.167277,0.042081,0.831678,0.168322,0.036984,0.852065,0.147935,0.042081,0.831678,0.168322,0.043518,0.825928,0.174072,0.045609,0.817564,0.182436,0.047831,0.808677,0.191323,0.049791,0.800836,0.199164,0.041688,0.833246,0.166754,0.050052,0.799791,0.200209,0.05528,0.778881,0.221119,0.064428,0.74229,0.25771,0.065604,0.737585,0.262415,0.069524,0.721903,0.278097,0.084161,0.663356,0.336644,0.082593,0.669629,0.330371,0.097752,0.608991,0.391009,0.109383,0.562467,0.437533,0.114088,0.543649,0.456351,0.127418,0.490329,0.509671,0.128855,0.484579,0.515421,0.131208,0.47517,0.52483,0.157083,0.371668,0.628332,0.123889,0.504443,0.495557,0.126372,0.494511,0.505489,0.149111,0.403555,0.596445,1.0,1.0,1.0,0.14127,0.434919,0.565081,0.126634,0.493466,0.506534,0.122844,0.508625,0.491375,0.119969,0.520125,0.479875,0.121014,0.515944,0.484056,0.110167,0.559331,0.440669};
			return value;
		}
		private double[] getColor_6_24_color_35()
		{
			double[] value = {0.121275,0.514898,0.485102,0.113565,0.54574,0.45426,0.112912,0.548353,0.451647,0.113304,0.546785,0.453215,0.113304,0.546785,0.453215,0.119707,0.521171,0.478829,0.12219,0.511239,0.488761,0.116702,0.533194,0.466806,0.108338,0.566649,0.433351,0.107554,0.569786,0.430214,0.112912,0.548353,0.451647,0.11252,0.549922,0.450078,0.111997,0.552013,0.447987,0.111213,0.555149,0.444851,0.11069,0.55724,0.44276,0.114741,0.541035,0.458965,0.126503,0.493988,0.506012,0.123758,0.504966,0.495034,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.12219,0.511239,0.488761,0.124151,0.503398,0.496602,0.124935,0.500261,0.499739,0.124804,0.500784,0.499216,0.121668,0.51333,0.48667,0.124151,0.503398,0.496602,0.122713,0.509148,0.490852,0.126111,0.495557,0.504443,0.128725,0.485102,0.514898,0.129639,0.481443,0.518557,0.121668,0.51333,0.48667,0.115133,0.539467,0.460533,0.112781,0.548876,0.451124,0.105724,0.577104,0.422896,0.097752,0.608991,0.391009,0.08978,0.640878,0.359122,0.09357,0.625719,0.374281,0.08978,0.640878,0.359122,0.026137,0.895452,0.104548,0.023915,0.904339,0.095661,0.033586,0.865656,0.134344,0.034109,0.863565,0.136435,0.034239,0.863042,0.136958,0.0362,0.855201,0.144799,0.038552,0.845792,0.154208,0.041819,0.832723,0.167277,0.04195,0.832201,0.167799,0.034893,0.860429,0.139571,0.041688,0.833246,0.166754,0.041819,0.832723,0.167277,0.04195,0.832201,0.167799,0.04195,0.832201,0.167799,0.041427,0.834292,0.165708,0.048092,0.807632,0.192368,0.052143,0.791427,0.208573,0.055149,0.779404,0.220596,0.058024,0.767904,0.232096,0.062859,0.748562,0.251438,0.066649,0.733403,0.266597,0.073576,0.705698,0.294302,0.091479,0.634083,0.365917,0.096053,0.615787,0.384213,0.099843,0.600627,0.399373,0.101934,0.592263,0.407737,0.107162,0.571354,0.428646,0.121668,0.51333,0.48667,0.116048,0.535808,0.464192,0.126242,0.495034,0.504966,0.119054,0.523785,0.476215,0.131077,0.475693,0.524307,0.138787,0.444851,0.555149,0.162703,0.34919,0.65081,0.127026,0.491898,0.508102,0.119185,0.523262,0.476738,0.134867,0.460533,0.539467,0.108599,0.565604,0.434396,0.10873,0.565081,0.434919,0.106639,0.573445,0.426555,0.12219,0.511239,0.488761,0.105724,0.577104,0.422896,0.104679,0.581286,0.418714,0.104679,0.581286,0.418714,0.103894,0.584422,0.415578,0.104156,0.583377,0.416623,0.106377,0.57449,0.42551,0.109645,0.561422,0.438578,0.098014,0.607946,0.392054,0.105724,0.577104,0.422896,0.105855,0.576581,0.423419,0.105724,0.577104,0.422896,0.105724,0.577104,0.422896,0.105724,0.577104,0.422896,0.112258,0.550967,0.449033,0.113696,0.545217,0.454783,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.121537,0.513853,0.486147,0.120361,0.518557,0.481443};
			return value;
		}
		private double[] getColor_6_24_color_36()
		{
			double[] value = {0.119707,0.521171,0.478829,0.118792,0.52483,0.47517,0.117616,0.529535,0.470465,0.119315,0.522739,0.477261,0.121537,0.513853,0.486147,0.121668,0.51333,0.48667,0.118792,0.52483,0.47517,0.120883,0.516466,0.483534,0.119185,0.523262,0.476738,0.12598,0.496079,0.503921,0.12977,0.48092,0.51908,0.129378,0.482488,0.517512,0.121668,0.51333,0.48667,0.117224,0.531103,0.468897,0.111213,0.555149,0.444851,0.105724,0.577104,0.422896,0.105593,0.577627,0.422373,0.09161,0.63356,0.36644,0.086121,0.655515,0.344485,0.086775,0.652901,0.347099,0.0,0.0,1.0,0.026137,0.895452,0.104548,0.028881,0.884475,0.115525,0.033063,0.867747,0.132253,0.034109,0.863565,0.136435,0.035154,0.859383,0.140617,0.037899,0.848406,0.151594,0.040904,0.836383,0.163617,0.038552,0.845792,0.154208,0.035677,0.857292,0.142708,0.04195,0.832201,0.167799,0.04195,0.832201,0.167799,0.04195,0.832201,0.167799,0.04195,0.832201,0.167799,0.036461,0.854156,0.145844,0.045478,0.818087,0.181913,0.049922,0.800314,0.199686,0.056064,0.775745,0.224255,0.057371,0.770518,0.229482,0.060376,0.758495,0.241505,0.065865,0.736539,0.263461,0.073183,0.707266,0.292734,0.081547,0.673811,0.326189,0.089911,0.640355,0.359645,0.097752,0.608991,0.391009,0.090434,0.638265,0.361735,0.099582,0.601673,0.398327,0.106769,0.572922,0.427078,0.107684,0.569263,0.430737,0.1069,0.572399,0.427601,0.096184,0.615264,0.384736,0.130946,0.476215,0.523785,0.161265,0.35494,0.64506,0.167146,0.331417,0.668583,0.127156,0.491375,0.508625,0.120753,0.516989,0.483011,0.101542,0.593832,0.406168,0.100366,0.598536,0.401464,0.098014,0.607946,0.392054,0.100627,0.597491,0.402509,0.10311,0.587559,0.412441,0.096315,0.614741,0.385259,0.097491,0.610037,0.389963,0.096968,0.612128,0.387872,0.096968,0.612128,0.387872,0.096184,0.615264,0.384736,0.09736,0.610559,0.389441,0.099712,0.60115,0.39885,0.097752,0.608991,0.391009,0.100366,0.598536,0.401464,0.102326,0.590695,0.409305,0.100105,0.599582,0.400418,0.105593,0.577627,0.422373,0.110298,0.558808,0.441192,0.113696,0.545217,0.454783,0.115003,0.53999,0.46001,0.118923,0.524307,0.475693,0.118008,0.527967,0.472033,0.115133,0.539467,0.460533,0.115264,0.538944,0.461056,0.113696,0.545217,0.454783,0.113696,0.545217,0.454783,0.113696,0.545217,0.454783,0.113696,0.545217,0.454783,0.113696,0.545217,0.454783,0.114219,0.543126,0.456874,0.113826,0.544694,0.455306,0.113696,0.545217,0.454783,0.121406,0.514375,0.485625,0.129639,0.481443,0.518557,0.13748,0.450078,0.549922,0.135389,0.458442,0.541558,0.135781,0.456874,0.543126,0.121537,0.513853,0.486147,0.113696,0.545217,0.454783,0.105724,0.577104,0.422896,0.104156,0.583377,0.416623,0.090434,0.638265,0.361735,0.08403,0.663879,0.336121,0.086383,0.654469,0.345531};
			return value;
		}
		private double[] getColor_6_24_color_37()
		{
			double[] value = {0.0,0.0,1.0,0.026137,0.895452,0.104548,0.026137,0.895452,0.104548,0.03058,0.877679,0.122321,0.030842,0.876634,0.123366,0.034109,0.863565,0.136435,0.034109,0.863565,0.136435,0.034239,0.863042,0.136958,0.033586,0.865656,0.134344,0.03633,0.854679,0.145321,0.042081,0.831678,0.168322,0.042081,0.831678,0.168322,0.042081,0.831678,0.168322,0.042081,0.831678,0.168322,0.037245,0.851019,0.148981,0.044041,0.823837,0.176163,0.047831,0.808677,0.191323,0.053319,0.786722,0.213278,0.056064,0.775745,0.224255,0.057893,0.768427,0.231573,0.064428,0.74229,0.25771,0.075928,0.696289,0.303711,0.088866,0.644537,0.355463,0.084553,0.661788,0.338212,0.086513,0.653947,0.346053,0.085991,0.656038,0.343962,0.089911,0.640355,0.359645,0.095008,0.619969,0.380031,0.096576,0.613696,0.386304,0.088996,0.644015,0.355985,0.088474,0.646106,0.353894,0.149895,0.400418,0.599582,0.133821,0.464715,0.535285,0.124673,0.501307,0.498693,0.130293,0.478829,0.521171,0.129901,0.480397,0.519603,0.113696,0.545217,0.454783,0.095008,0.619969,0.380031,0.089388,0.642446,0.357554,0.094093,0.623628,0.376372,0.091741,0.633037,0.366963,0.08978,0.640878,0.359122,0.08978,0.640878,0.359122,0.090042,0.639833,0.360167,0.08978,0.640878,0.359122,0.08978,0.640878,0.359122,0.08978,0.640878,0.359122,0.08978,0.640878,0.359122,0.095792,0.616832,0.383168,0.097752,0.608991,0.391009,0.097622,0.609514,0.390486,0.102457,0.590173,0.409827,0.114741,0.541035,0.458965,0.113696,0.545217,0.454783,0.113696,0.545217,0.454783,0.117878,0.528489,0.471511,0.121406,0.514375,0.485625,0.115917,0.53633,0.46367,0.113042,0.547831,0.452169,0.113304,0.546785,0.453215,0.113434,0.546262,0.453738,0.113696,0.545217,0.454783,0.113696,0.545217,0.454783,0.113696,0.545217,0.454783,0.112128,0.55149,0.44851,0.113565,0.54574,0.45426,0.109775,0.560899,0.439101,0.1184,0.526398,0.473602,0.122713,0.509148,0.490852,0.129509,0.481965,0.518035,0.13748,0.450078,0.549922,0.145452,0.418191,0.581809,0.13748,0.450078,0.549922,0.127679,0.489284,0.510716,0.117355,0.53058,0.46942,0.120099,0.519603,0.480397,0.113565,0.54574,0.45426,0.090303,0.638787,0.361213,0.088866,0.644537,0.355463,0.081809,0.672765,0.327235,0.025353,0.898589,0.101411,0.0,0.0,1.0,0.026137,0.895452,0.104548,0.026137,0.895452,0.104548,0.034762,0.860951,0.139049,0.038552,0.845792,0.154208,0.039728,0.841087,0.158913,0.03999,0.840042,0.159958,0.03241,0.870361,0.129639,0.034762,0.860951,0.139049,0.037899,0.848406,0.151594,0.041166,0.835337,0.164663,0.042081,0.831678,0.168322,0.040904,0.836383,0.163617,0.04195,0.832201,0.167799,0.043779,0.824882,0.175118,0.046262,0.81495,0.18505,0.048876,0.804496,0.195504,0.05162,0.793518,0.206482,0.055018,0.779927,0.220073};
			return value;
		}
		private double[] getColor_6_24_color_38()
		{
			double[] value = {0.056848,0.772608,0.227392,0.058416,0.766336,0.233664,0.084814,0.660742,0.339258,0.073576,0.705698,0.294302,0.078672,0.685311,0.314689,0.080894,0.676424,0.323576,0.093178,0.627287,0.372713,0.088996,0.644015,0.355985,0.086513,0.653947,0.346053,0.084292,0.662833,0.337167,0.105985,0.576059,0.423941,0.107815,0.56874,0.43126,0.101019,0.595923,0.404077,0.099712,0.60115,0.39885,0.098798,0.604809,0.395191,0.127418,0.490329,0.509671,0.097883,0.608468,0.391532,0.08965,0.641401,0.358599,0.081809,0.672765,0.327235,0.085076,0.659697,0.340303,0.086513,0.653947,0.346053,0.085337,0.658651,0.341349,0.085076,0.659697,0.340303,0.085468,0.658129,0.341871,0.084814,0.660742,0.339258,0.088735,0.64506,0.35494,0.087297,0.65081,0.34919,0.095661,0.617355,0.382645,0.088474,0.646106,0.353894,0.090826,0.636696,0.363304,0.113565,0.54574,0.45426,0.127418,0.490329,0.509671,0.127287,0.490852,0.509148,0.120361,0.518557,0.481443,0.119577,0.521694,0.478306,0.121668,0.51333,0.48667,0.121668,0.51333,0.48667,0.118792,0.52483,0.47517,0.114088,0.543649,0.456351,0.111866,0.552535,0.447465,0.107815,0.56874,0.43126,0.110951,0.556194,0.443806,0.113696,0.545217,0.454783,0.118923,0.524307,0.475693,0.105724,0.577104,0.422896,0.105593,0.577627,0.422373,0.110429,0.558285,0.441715,0.119707,0.521171,0.478829,0.12219,0.511239,0.488761,0.1316,0.473602,0.526398,0.150026,0.399895,0.600105,0.156952,0.37219,0.62781,0.14702,0.411918,0.588082,0.145844,0.416623,0.583377,0.130946,0.476215,0.523785,0.125327,0.498693,0.501307,0.106377,0.57449,0.42551,0.088996,0.644015,0.355985,0.081809,0.672765,0.327235,0.079848,0.680606,0.319394,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.027313,0.890748,0.109252,0.044171,0.823314,0.176686,0.038944,0.844224,0.155776,0.029535,0.881861,0.118139,0.025091,0.899634,0.100366,0.033978,0.864088,0.135912,0.034762,0.860951,0.139049,0.036722,0.85311,0.14689,0.038683,0.845269,0.154731,0.039205,0.843178,0.156822,0.033586,0.865656,0.134344,0.042081,0.831678,0.168322,0.042342,0.830633,0.169367,0.04391,0.82436,0.17564,0.046654,0.813382,0.186618,0.049399,0.802405,0.197595,0.049922,0.800314,0.199686,0.049922,0.800314,0.199686,0.054234,0.783063,0.216937,0.066649,0.733403,0.266597,0.069002,0.723994,0.276006,0.070439,0.718244,0.281756,0.073837,0.704652,0.295348,0.073837,0.704652,0.295348,0.079718,0.681129,0.318871,0.079326,0.682697,0.317303,0.077888,0.688447,0.311553,0.099451,0.602196,0.397804,0.076581,0.693675,0.306325,0.081547,0.673811,0.326189,0.082462,0.670152,0.329848,0.08965,0.641401,0.358599,0.093701,0.625196,0.374804,0.08978,0.640878,0.359122,0.08403,0.663879,0.336121,0.077496,0.690016,0.309984,0.081809,0.672765,0.327235};
			return value;
		}
		private double[] getColor_6_24_color_39()
		{
			double[] value = {0.079848,0.680606,0.319394,0.081678,0.673288,0.326712,0.081809,0.672765,0.327235,0.081809,0.672765,0.327235,0.081809,0.672765,0.327235,0.081809,0.672765,0.327235,0.081547,0.673811,0.326189,0.086513,0.653947,0.346053,0.091741,0.633037,0.366963,0.096315,0.614741,0.385259,0.105724,0.577104,0.422896,0.121406,0.514375,0.485625,0.12206,0.511762,0.488238,0.127679,0.489284,0.510716,0.121798,0.512807,0.487193,0.129639,0.481443,0.518557,0.125065,0.499739,0.500261,0.125457,0.49817,0.50183,0.117486,0.530058,0.469942,0.113696,0.545217,0.454783,0.106639,0.573445,0.426555,0.106247,0.575013,0.424987,0.113696,0.545217,0.454783,0.11069,0.55724,0.44276,0.110037,0.559854,0.440146,0.105071,0.579718,0.420282,0.112781,0.548876,0.451124,0.113957,0.544171,0.455829,0.115525,0.537899,0.462101,0.130685,0.477261,0.522739,0.152248,0.391009,0.608991,0.161134,0.355463,0.644537,0.162703,0.34919,0.65081,0.143884,0.424464,0.575536,0.121929,0.512284,0.487716,0.10873,0.565081,0.434919,0.090957,0.636174,0.363826,0.081939,0.672243,0.327757,0.081809,0.672765,0.327235,0.073837,0.704652,0.295348,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.023654,0.905384,0.094616,0.03058,0.877679,0.122321,0.025222,0.899111,0.100889,0.0,0.0,1.0,0.028228,0.887088,0.112912,0.033978,0.864088,0.135912,0.034109,0.863565,0.136435,0.035024,0.859906,0.140094,0.034893,0.860429,0.139571,0.034631,0.861474,0.138526,0.029927,0.880293,0.119707,0.036069,0.855724,0.144276,0.041819,0.832723,0.167277,0.042081,0.831678,0.168322,0.042603,0.829587,0.170413,0.043779,0.824882,0.175118,0.044956,0.820178,0.179822,0.046785,0.812859,0.187141,0.079195,0.68322,0.31678,0.064297,0.742812,0.257188,0.065212,0.739153,0.260847,0.065865,0.736539,0.263461,0.065865,0.736539,0.263461,0.073183,0.707266,0.292734,0.073837,0.704652,0.295348,0.073706,0.705175,0.294825,0.076581,0.693675,0.306325,0.074229,0.703084,0.296916,0.069786,0.720857,0.279143,0.073183,0.707266,0.292734,0.075405,0.69838,0.30162,0.080894,0.676424,0.323576,0.086775,0.652901,0.347099,0.088996,0.644015,0.355985,0.0839,0.664401,0.335599,0.075144,0.699425,0.300575,0.08782,0.648719,0.351281,0.074229,0.703084,0.296916,0.081417,0.674334,0.325666,0.075536,0.697857,0.302143,0.076581,0.693675,0.306325,0.076712,0.693152,0.306848,0.075274,0.698902,0.301098,0.081547,0.673811,0.326189,0.094877,0.620491,0.379509,0.097622,0.609514,0.390486,0.097752,0.608991,0.391009,0.105724,0.577104,0.422896,0.11252,0.549922,0.450078,0.121929,0.512284,0.487716,0.132384,0.470465,0.529535,0.129639,0.481443,0.518557,0.129639,0.481443,0.518557,0.129639,0.481443,0.518557,0.129509,0.481965,0.518035,0.12206,0.511762,0.488238,0.113696,0.545217,0.454783};
			return value;
		}
		private double[] getColor_6_24_color_40()
		{
			double[] value = {0.110298,0.558808,0.441192,0.103372,0.586513,0.413487,0.105593,0.577627,0.422373,0.105463,0.57815,0.42185,0.101411,0.594354,0.405646,0.105855,0.576581,0.423419,0.117224,0.531103,0.468897,0.112912,0.548353,0.451647,0.111997,0.552013,0.447987,0.113826,0.544694,0.455306,0.123889,0.504443,0.495557,0.13735,0.450601,0.549399,0.135389,0.458442,0.541558,0.143231,0.427078,0.572922,0.104679,0.581286,0.418714,0.09357,0.625719,0.374281,0.082462,0.670152,0.329848,0.081809,0.672765,0.327235,0.075666,0.697334,0.302666,0.073706,0.705175,0.294825,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.023262,0.906952,0.093048,0.0,0.0,1.0,0.0,0.0,1.0,0.027705,0.889179,0.110821,0.032148,0.871406,0.128594,0.034109,0.863565,0.136435,0.034109,0.863565,0.136435,0.034109,0.863565,0.136435,0.034109,0.863565,0.136435,0.028097,0.887611,0.112389,0.034239,0.863042,0.136958,0.035546,0.857815,0.142185,0.036984,0.852065,0.147935,0.038552,0.845792,0.154208,0.04012,0.839519,0.160481,0.041558,0.833769,0.166231,0.04195,0.832201,0.167799,0.057371,0.770518,0.229482,0.057763,0.768949,0.231051,0.055802,0.77679,0.22321,0.060768,0.756926,0.243074,0.065734,0.737062,0.262938,0.065865,0.736539,0.263461,0.07253,0.70988,0.29012,0.081417,0.674334,0.325666,0.066388,0.734449,0.265551,0.062859,0.748562,0.251438,0.065342,0.73863,0.26137,0.066388,0.734449,0.265551,0.070178,0.719289,0.280711,0.071877,0.712493,0.287507,0.074098,0.703607,0.296393,0.081939,0.672243,0.327757,0.080894,0.676424,0.323576,0.075405,0.69838,0.30162,0.071223,0.715107,0.284893,0.071615,0.713539,0.286461,0.072791,0.708834,0.291166,0.073053,0.707789,0.292211,0.071877,0.712493,0.287507,0.070831,0.716675,0.283325,0.076581,0.693675,0.306325,0.08207,0.67172,0.32828,0.08965,0.641401,0.358599,0.093832,0.624673,0.375327,0.100497,0.598014,0.401986,0.105724,0.577104,0.422896,0.11252,0.549922,0.450078,0.122452,0.510193,0.489807,0.143623,0.42551,0.57449,0.137088,0.451647,0.548353,0.14506,0.41976,0.58024,0.13748,0.450078,0.549922,0.133298,0.466806,0.533194,0.122974,0.508102,0.491898,0.117486,0.530058,0.469942,0.111605,0.553581,0.446419,0.103633,0.585468,0.414532,0.105201,0.579195,0.420805,0.097752,0.608991,0.391009,0.097752,0.608991,0.391009,0.101803,0.592786,0.407214,0.105201,0.579195,0.420805,0.1069,0.572399,0.427601,0.1069,0.572399,0.427601,0.107292,0.570831,0.429169,0.115656,0.537376,0.462624,0.116702,0.533194,0.466806,0.105855,0.576581,0.423419,0.102849,0.588604,0.411396,0.089127,0.643492,0.356508,0.081809,0.672765,0.327235,0.081809,0.672765,0.327235,0.073837,0.704652,0.295348,0.073837,0.704652,0.295348,0.067825,0.728698,0.271302};
			return value;
		}
		private double[] getColor_6_24_color_41()
		{
			double[] value = {0.024569,0.901725,0.098275,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.025614,0.897543,0.102457,0.027705,0.889179,0.110821,0.029143,0.883429,0.116571,0.032018,0.871929,0.128071,0.034109,0.863565,0.136435,0.030842,0.876634,0.123366,0.024177,0.903293,0.096707,0.034109,0.863565,0.136435,0.034109,0.863565,0.136435,0.034109,0.863565,0.136435,0.034893,0.860429,0.139571,0.035024,0.859906,0.140094,0.036069,0.855724,0.144276,0.038029,0.847883,0.152117,0.043126,0.827496,0.172504,0.053581,0.785677,0.214323,0.050052,0.799791,0.200209,0.05149,0.794041,0.205959,0.054888,0.78045,0.21955,0.058285,0.766858,0.233142,0.063513,0.745949,0.254051,0.056325,0.774699,0.225301,0.057893,0.768427,0.231573,0.057893,0.768427,0.231573,0.058677,0.76529,0.23471,0.062075,0.751699,0.248301,0.063251,0.746994,0.253006,0.064689,0.741244,0.258756,0.065604,0.737585,0.262415,0.067041,0.731835,0.268165,0.067041,0.731835,0.268165,0.065865,0.736539,0.263461,0.065865,0.736539,0.263461,0.065996,0.736017,0.263983,0.065996,0.736017,0.263983,0.065865,0.736539,0.263461,0.065342,0.73863,0.26137,0.073053,0.707789,0.292211,0.077235,0.691061,0.308939,0.082201,0.671197,0.328803,0.089258,0.642969,0.357031,0.097229,0.611082,0.388918,0.10311,0.587559,0.412441,0.111343,0.554626,0.445374,0.116309,0.534762,0.465238,0.124673,0.501307,0.498693,0.134867,0.460533,0.539467,0.145583,0.417669,0.582331,0.14702,0.411918,0.588082,0.145452,0.418191,0.581809,0.15264,0.389441,0.610559,0.129378,0.482488,0.517512,0.130423,0.478306,0.521694,0.133691,0.465238,0.534762,0.106769,0.572922,0.427078,0.104809,0.580763,0.419237,0.101803,0.592786,0.407214,0.095792,0.616832,0.383168,0.104025,0.5839,0.4161,0.105855,0.576581,0.423419,0.105724,0.577104,0.422896,0.11265,0.549399,0.450601,0.099451,0.602196,0.397804,0.095792,0.616832,0.383168,0.096184,0.615264,0.384736,0.097752,0.608991,0.391009,0.092394,0.630423,0.369577,0.081809,0.672765,0.327235,0.081809,0.672765,0.327235,0.077104,0.691584,0.308416,0.0707,0.717198,0.282802,0.070831,0.716675,0.283325,0.067433,0.730267,0.269733,0.041819,0.832723,0.167277,0.038944,0.844224,0.155776,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.024438,0.902248,0.097752,0.023915,0.904339,0.095661,0.026137,0.895452,0.104548,0.027574,0.889702,0.110298,0.02862,0.88552,0.11448,0.026137,0.895452,0.104548,0.0,0.0,1.0,0.031756,0.872974,0.127026,0.033978,0.864088,0.135912,0.034109,0.863565,0.136435,0.034109,0.863565,0.136435,0.034109,0.863565,0.136435,0.034109,0.863565,0.136435};
			return value;
		}
		private double[] getColor_6_24_color_42()
		{
			double[] value = {0.035154,0.859383,0.140617,0.04195,0.832201,0.167799,0.042473,0.83011,0.16989,0.04391,0.82436,0.17564,0.049007,0.803973,0.196027,0.049922,0.800314,0.199686,0.052143,0.791427,0.208573,0.05724,0.77104,0.22896,0.051359,0.794564,0.205436,0.057763,0.768949,0.231051,0.056456,0.774177,0.225823,0.056848,0.772608,0.227392,0.057632,0.769472,0.230528,0.058416,0.766336,0.233664,0.058808,0.764767,0.235233,0.060507,0.757972,0.242028,0.062206,0.751176,0.248824,0.063251,0.746994,0.253006,0.061553,0.75379,0.24621,0.062598,0.749608,0.250392,0.062206,0.751176,0.248824,0.059984,0.760063,0.239937,0.062598,0.749608,0.250392,0.066257,0.734971,0.265029,0.071877,0.712493,0.287507,0.077104,0.691584,0.308416,0.08207,0.67172,0.32828,0.09161,0.63356,0.36644,0.100889,0.596445,0.403555,0.106116,0.575536,0.424464,0.119315,0.522739,0.477261,0.124935,0.500261,0.499739,0.129378,0.482488,0.517512,0.139571,0.441715,0.558285,0.15656,0.373758,0.626242,0.162441,0.350235,0.649765,0.159174,0.363304,0.636696,0.141532,0.433873,0.566127,0.138526,0.445896,0.554104,0.126895,0.49242,0.50758,0.114872,0.540512,0.459488,0.109906,0.560376,0.439624,0.102849,0.588604,0.411396,0.097883,0.608468,0.391532,0.093962,0.624151,0.375849,0.104286,0.582854,0.417146,0.108599,0.565604,0.434396,0.101673,0.593309,0.406691,0.106116,0.575536,0.424464,0.095792,0.616832,0.383168,0.094093,0.623628,0.376372,0.08978,0.640878,0.359122,0.08978,0.640878,0.359122,0.08965,0.641401,0.358599,0.082593,0.669629,0.330371,0.073968,0.70413,0.29587,0.073837,0.704652,0.295348,0.065734,0.737062,0.262938,0.066127,0.735494,0.264506,0.074229,0.703084,0.296916,0.047831,0.808677,0.191323,0.04195,0.832201,0.167799,0.031887,0.872452,0.127548,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.026137,0.895452,0.104548,0.025876,0.896498,0.103502,0.026137,0.895452,0.104548,0.025484,0.898066,0.101934,0.0,0.0,1.0,0.026137,0.895452,0.104548,0.026137,0.895452,0.104548,0.030188,0.879247,0.120753,0.03045,0.878202,0.121798,0.030058,0.87977,0.12023,0.029535,0.881861,0.118139,0.034109,0.863565,0.136435,0.037376,0.850497,0.149503,0.04012,0.839519,0.160481,0.04195,0.832201,0.167799,0.044825,0.8207,0.1793,0.04953,0.801882,0.198118,0.056456,0.774177,0.225823,0.050183,0.799268,0.200732,0.050575,0.7977,0.2023,0.05345,0.7862,0.2138,0.050967,0.796132,0.203868,0.05149,0.794041,0.205959,0.052927,0.788291,0.211709,0.054104,0.783586,0.216414,0.05528,0.778881,0.221119,0.056848,0.772608,0.227392,0.057893,0.768427,0.231573,0.058285,0.766858,0.233142,0.058024,0.767904,0.232096,0.058155,0.767381,0.232619};
			return value;
		}
		private double[] getColor_6_24_color_43()
		{
			double[] value = {0.056194,0.775222,0.224778,0.057893,0.768427,0.231573,0.060376,0.758495,0.241505,0.06495,0.740199,0.259801,0.072661,0.709357,0.290643,0.079456,0.682175,0.317825,0.086252,0.654992,0.345008,0.096445,0.614219,0.385781,0.115656,0.537376,0.462624,0.128855,0.484579,0.515421,0.148458,0.406168,0.593832,0.149765,0.400941,0.599059,0.1431,0.427601,0.572399,0.158521,0.365917,0.634083,0.162964,0.348144,0.651856,1.0,1.0,1.0,1.0,1.0,1.0,0.159043,0.363826,0.636174,0.14702,0.411918,0.588082,0.129639,0.481443,0.518557,0.126764,0.492943,0.507057,0.122452,0.510193,0.489807,0.104286,0.582854,0.417146,0.111735,0.553058,0.446942,0.093178,0.627287,0.372713,0.098406,0.606377,0.393623,0.096184,0.615264,0.384736,0.092525,0.629901,0.370099,0.088996,0.644015,0.355985,0.085991,0.656038,0.343962,0.087036,0.651856,0.348144,0.085991,0.656038,0.343962,0.082854,0.668583,0.331417,0.082985,0.668061,0.331939,0.081809,0.672765,0.327235,0.074098,0.703607,0.296393,0.072399,0.710403,0.289597,0.06495,0.740199,0.259801,0.07057,0.717721,0.282279,0.085468,0.658129,0.341871,0.041558,0.833769,0.166231,0.033194,0.867224,0.132776,0.026006,0.895975,0.104025,0.025614,0.897543,0.102457,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.026137,0.895452,0.104548,0.026137,0.895452,0.104548,0.026268,0.894929,0.105071,0.026137,0.895452,0.104548,0.028881,0.884475,0.115525,0.034109,0.863565,0.136435,0.034109,0.863565,0.136435,0.034501,0.861997,0.138003,0.038683,0.845269,0.154731,0.042342,0.830633,0.169367,0.044694,0.821223,0.178777,0.042081,0.831678,0.168322,0.048615,0.805541,0.194459,0.049922,0.800314,0.199686,0.049399,0.802405,0.197595,0.049399,0.802405,0.197595,0.04966,0.801359,0.198641,0.049791,0.800836,0.199164,0.050575,0.7977,0.2023,0.052405,0.790382,0.209618,0.052666,0.789336,0.210664,0.052927,0.788291,0.211709,0.053319,0.786722,0.213278,0.051751,0.792995,0.207005,0.054234,0.783063,0.216937,0.056587,0.773654,0.226346,0.060768,0.756926,0.243074,0.065473,0.738108,0.261892,0.073183,0.707266,0.292734,0.087297,0.65081,0.34919,0.097752,0.608991,0.391009,0.11069,0.55724,0.44276,0.125719,0.497125,0.502875,0.157083,0.371668,0.628332,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.162964,0.348144,0.651856,0.155646,0.377418,0.622582};
			return value;
		}
		private double[] getColor_6_24_color_44()
		{
			double[] value = {0.172765,0.308939,0.691061,0.147804,0.408782,0.591218,0.114872,0.540512,0.459488,0.096053,0.615787,0.384213,0.088735,0.64506,0.35494,0.10115,0.5954,0.4046,0.088735,0.64506,0.35494,0.085337,0.658651,0.341349,0.082985,0.668061,0.331939,0.081939,0.672243,0.327757,0.082462,0.670152,0.329848,0.081809,0.672765,0.327235,0.081547,0.673811,0.326189,0.077757,0.68897,0.31103,0.07449,0.702039,0.297961,0.073837,0.704652,0.295348,0.065996,0.736017,0.263983,0.063251,0.746994,0.253006,0.068348,0.726607,0.273393,0.08207,0.67172,0.32828,0.034109,0.863565,0.136435,0.03241,0.870361,0.129639,0.033978,0.864088,0.135912,0.023262,0.906952,0.093048,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.025484,0.898066,0.101934,0.023393,0.90643,0.09357,0.024438,0.902248,0.097752,0.02679,0.892838,0.107162,0.026921,0.892316,0.107684,0.029404,0.882384,0.117616,0.034109,0.863565,0.136435,0.034109,0.863565,0.136435,0.040382,0.838474,0.161526,0.042473,0.83011,0.16989,0.044564,0.821746,0.178254,0.047961,0.808155,0.191845,0.042603,0.829587,0.170413,0.04391,0.82436,0.17564,0.044694,0.821223,0.178777,0.046001,0.815996,0.184004,0.047961,0.808155,0.191845,0.049922,0.800314,0.199686,0.050444,0.798223,0.201777,0.050444,0.798223,0.201777,0.049922,0.800314,0.199686,0.04953,0.801882,0.198118,0.05345,0.7862,0.2138,0.057893,0.768427,0.231573,0.067956,0.728176,0.271824,0.084292,0.662833,0.337167,0.105985,0.576059,0.423941,0.106769,0.572922,0.427078,0.130031,0.479875,0.520125,0.145975,0.4161,0.5839,0.167277,0.330894,0.669106,1.0,1.0,1.0,0.150941,0.396236,0.603764,0.148327,0.406691,0.593309,0.17368,0.30528,0.69472,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.164924,0.340303,0.659697,0.139702,0.441192,0.558808,0.132122,0.471511,0.528489,0.090826,0.636696,0.363304,0.086121,0.655515,0.344485,0.083246,0.667015,0.332985,0.083246,0.667015,0.332985,0.081939,0.672243,0.327757,0.079326,0.682697,0.317303,0.078542,0.685834,0.314166,0.078019,0.687925,0.312075,0.076189,0.695243,0.304757,0.075666,0.697334,0.302666,0.073837,0.704652,0.295348,0.073706,0.705175,0.294825,0.066519,0.733926,0.266074,0.065604,0.737585,0.262415,0.064428,0.74229,0.25771,0.08011,0.679561,0.320439,0.08965,0.641401,0.358599};
			return value;
		}
		private double[] getColor_6_24_color_45()
		{
			double[] value = {0.034109,0.863565,0.136435,0.033847,0.864611,0.135389,0.027705,0.889179,0.110821,0.03058,0.877679,0.122321,0.028751,0.884997,0.115003,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.024438,0.902248,0.097752,0.025876,0.896498,0.103502,0.026137,0.895452,0.104548,0.033194,0.867224,0.132776,0.03437,0.86252,0.13748,0.041558,0.833769,0.166231,0.042081,0.831678,0.168322,0.041819,0.832723,0.167277,0.041427,0.834292,0.165708,0.041688,0.833246,0.166754,0.04195,0.832201,0.167799,0.042081,0.831678,0.168322,0.043387,0.826451,0.173549,0.04391,0.82436,0.17564,0.045348,0.81861,0.18139,0.047047,0.811814,0.188186,0.047047,0.811814,0.188186,0.050444,0.798223,0.201777,0.057371,0.770518,0.229482,0.063643,0.745426,0.254574,0.09344,0.626242,0.373758,0.116048,0.535808,0.464192,0.096053,0.615787,0.384213,0.088604,0.645583,0.354417,0.113696,0.545217,0.454783,0.130031,0.479875,0.520125,0.141532,0.433873,0.566127,0.123758,0.504966,0.495034,0.132514,0.469942,0.530058,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.148458,0.406168,0.593832,0.166231,0.335076,0.664924,0.157606,0.369577,0.630423,0.134867,0.460533,0.539467,0.133691,0.465238,0.534762,0.105463,0.57815,0.42185,0.091741,0.633037,0.366963,0.086905,0.652378,0.347622,0.084292,0.662833,0.337167,0.080502,0.677993,0.322007,0.082201,0.671197,0.328803,0.081547,0.673811,0.326189,0.077888,0.688447,0.311553,0.073968,0.70413,0.29587,0.073837,0.704652,0.295348,0.073837,0.704652,0.295348,0.073837,0.704652,0.295348,0.072922,0.708312,0.291688,0.073183,0.707266,0.292734,0.064689,0.741244,0.258756,0.062467,0.750131,0.249869,0.07253,0.70988,0.29012,0.081939,0.672243,0.327757,0.086644,0.653424,0.346576,0.034109,0.863565,0.136435,0.036984,0.852065,0.147935,0.033978,0.864088,0.135912,0.033978,0.864088,0.135912,0.038029,0.847883,0.152117,0.034631,0.861474,0.138526,0.0,0.0,1.0,0.023262,0.906952,0.093048,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.025745,0.89702,0.10298,0.028881,0.884475,0.115525,0.028359,0.886566,0.113434,0.026137,0.895452,0.104548,0.026006,0.895975,0.104025,0.024569,0.901725,0.098275};
			return value;
		}
		private double[] getColor_6_24_color_46()
		{
			double[] value = {0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.025876,0.896498,0.103502,0.026268,0.894929,0.105071,0.034109,0.863565,0.136435,0.034109,0.863565,0.136435,0.036592,0.853633,0.146367,0.035546,0.857815,0.142185,0.034631,0.861474,0.138526,0.03633,0.854679,0.145321,0.036984,0.852065,0.147935,0.039205,0.843178,0.156822,0.041427,0.834292,0.165708,0.042211,0.831155,0.168845,0.042211,0.831155,0.168845,0.041427,0.834292,0.165708,0.045348,0.81861,0.18139,0.049007,0.803973,0.196027,0.062598,0.749608,0.250392,0.065865,0.736539,0.263461,0.068217,0.72713,0.27287,0.07057,0.717721,0.282279,0.073968,0.70413,0.29587,0.093178,0.627287,0.372713,0.094224,0.623105,0.376895,0.106247,0.575013,0.424987,0.102588,0.58965,0.41035,0.139571,0.441715,0.558285,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.172635,0.309462,0.690538,0.152117,0.391532,0.608468,0.147282,0.410873,0.589127,1.0,1.0,1.0,0.143231,0.427078,0.572922,0.125588,0.497648,0.502352,0.105593,0.577627,0.422373,0.091741,0.633037,0.366963,0.084161,0.663356,0.336644,0.083377,0.666492,0.333508,0.082985,0.668061,0.331939,0.08207,0.67172,0.32828,0.081155,0.675379,0.324621,0.077757,0.68897,0.31103,0.075928,0.696289,0.303711,0.073968,0.70413,0.29587,0.069916,0.720335,0.279665,0.070439,0.718244,0.281756,0.067172,0.731312,0.268688,0.066388,0.734449,0.265551,0.065734,0.737062,0.262938,0.060246,0.759017,0.240983,0.063513,0.745949,0.254051,0.073706,0.705175,0.294825,0.081809,0.672765,0.327235,0.088866,0.644537,0.355463,0.041688,0.833246,0.166754,0.041427,0.834292,0.165708,0.038944,0.844224,0.155776,0.036461,0.854156,0.145844,0.036069,0.855724,0.144276,0.026137,0.895452,0.104548,0.0,0.0,1.0,0.024961,0.900157,0.099843,0.031234,0.875065,0.124935,0.030842,0.876634,0.123366,0.025222,0.899111,0.100889,0.029535,0.881861,0.118139,0.025876,0.896498,0.103502,0.033717,0.865133,0.134867,0.034239,0.863042,0.136958,0.036592,0.853633,0.146367,0.038552,0.845792,0.154208,0.034501,0.861997,0.138003,0.035285,0.85886,0.14114,0.0362,0.855201,0.144799,0.034239,0.863042,0.136958,0.030188,0.879247,0.120753,0.025353,0.898589,0.101411,0.0,0.0,1.0,0.0,0.0,1.0,0.026137,0.895452,0.104548,0.026137,0.895452,0.104548,0.03058,0.877679,0.122321,0.03045,0.878202,0.121798,0.031364,0.874543,0.125457,0.033063,0.867747,0.132253,0.033978,0.864088,0.135912,0.034109,0.863565,0.136435,0.035546,0.857815,0.142185,0.037376,0.850497,0.149503,0.039336,0.842656,0.157344,0.039075,0.843701,0.156299,0.042081,0.831678,0.168322,0.043126,0.827496,0.172504,0.0477,0.8092,0.1908};
			return value;
		}
		private double[] getColor_6_24_color_47()
		{
			double[] value = {0.05724,0.77104,0.22896,0.057893,0.768427,0.231573,0.06495,0.740199,0.259801,0.065865,0.736539,0.263461,0.073837,0.704652,0.295348,0.081286,0.674856,0.325144,0.087167,0.651333,0.348667,0.092525,0.629901,0.370099,0.105593,0.577627,0.422373,0.142185,0.43126,0.56874,0.163617,0.345531,0.654469,0.145844,0.416623,0.583377,1.0,1.0,1.0,0.154731,0.381077,0.618923,0.154731,0.381077,0.618923,0.144537,0.42185,0.57815,0.114088,0.543649,0.456351,0.123236,0.507057,0.492943,0.111082,0.555672,0.444328,0.10298,0.588082,0.411918,0.09344,0.626242,0.373758,0.084422,0.662311,0.337689,0.080633,0.67747,0.32253,0.081025,0.675902,0.324098,0.081678,0.673288,0.326712,0.081678,0.673288,0.326712,0.079718,0.681129,0.318871,0.072922,0.708312,0.291688,0.074098,0.703607,0.296393,0.071615,0.713539,0.286461,0.068479,0.726085,0.273915,0.065996,0.736017,0.263983,0.065865,0.736539,0.263461,0.065081,0.739676,0.260324,0.06103,0.755881,0.244119,0.056717,0.773131,0.226869,0.066519,0.733926,0.266074,0.080502,0.677993,0.322007,0.084945,0.66022,0.33978,0.091218,0.635128,0.364872,0.039728,0.841087,0.158913,0.038029,0.847883,0.152117,0.038029,0.847883,0.152117,0.037507,0.849974,0.150026,0.031626,0.873497,0.126503,0.026006,0.895975,0.104025,0.023654,0.905384,0.094616,0.030058,0.87977,0.12023,0.040774,0.836905,0.163095,0.035677,0.857292,0.142708,0.033847,0.864611,0.135389,0.033978,0.864088,0.135912,0.040251,0.838996,0.161004,0.045609,0.817564,0.182436,0.04953,0.801882,0.198118,0.049922,0.800314,0.199686,0.053581,0.785677,0.214323,0.069916,0.720335,0.279665,0.059462,0.762154,0.237846,0.07253,0.70988,0.29012,0.079718,0.681129,0.318871,0.052405,0.790382,0.209618,0.039075,0.843701,0.156299,0.028359,0.886566,0.113434,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.026006,0.895975,0.104025,0.026137,0.895452,0.104548,0.026137,0.895452,0.104548,0.02679,0.892838,0.107162,0.028228,0.887088,0.112912,0.03045,0.878202,0.121798,0.033063,0.867747,0.132253,0.034109,0.863565,0.136435,0.034631,0.861474,0.138526,0.037245,0.851019,0.148981,0.03999,0.840042,0.159958,0.042081,0.831678,0.168322,0.045348,0.81861,0.18139,0.050183,0.799268,0.200732,0.054496,0.782018,0.217982,0.058416,0.766336,0.233664,0.065604,0.737585,0.262415,0.0707,0.717198,0.282802,0.076059,0.695766,0.304234,0.081939,0.672243,0.327757,0.087951,0.648197,0.351803,0.101542,0.593832,0.406168,0.125719,0.497125,0.502875,0.128202,0.487193,0.512807,0.164009,0.343962,0.656038,0.162964,0.348144,0.651856,0.156038,0.375849,0.624151,0.154469,0.382122,0.617878,0.1661,0.335599,0.664401,0.153424,0.386304,0.613696,0.107684,0.569263,0.430737,0.09932,0.602718,0.397282,0.093962,0.624151,0.375849};
			return value;
		}
		private double[] getColor_6_24_color_48()
		{
			double[] value = {0.086775,0.652901,0.347099,0.080763,0.676947,0.323053,0.077888,0.688447,0.311553,0.077365,0.690538,0.309462,0.076451,0.694198,0.305802,0.077496,0.690016,0.309984,0.077888,0.688447,0.311553,0.075666,0.697334,0.302666,0.070047,0.719812,0.280188,0.065212,0.739153,0.260847,0.063643,0.745426,0.254574,0.064297,0.742812,0.257188,0.058285,0.766858,0.233142,0.059331,0.762676,0.237324,0.057893,0.768427,0.231573,0.062729,0.749085,0.250915,0.074752,0.700993,0.299007,0.082331,0.670674,0.329326,0.089519,0.641924,0.358076,0.102065,0.591741,0.408259,0.03816,0.84736,0.15264,0.038029,0.847883,0.152117,0.037114,0.851542,0.148458,0.034762,0.860951,0.139049,0.032018,0.871929,0.128071,0.027705,0.889179,0.110821,0.033063,0.867747,0.132253,0.034109,0.863565,0.136435,0.046785,0.812859,0.187141,0.047308,0.810768,0.189232,0.043518,0.825928,0.174072,0.040251,0.838996,0.161004,0.058416,0.766336,0.233664,0.077365,0.690538,0.309462,0.073183,0.707266,0.292734,0.063382,0.746472,0.253528,0.06861,0.725562,0.274438,0.083638,0.665447,0.334553,0.10494,0.58024,0.41976,0.083377,0.666492,0.333508,0.082985,0.668061,0.331939,0.08024,0.679038,0.320962,0.07253,0.70988,0.29012,0.060246,0.759017,0.240983,0.029143,0.883429,0.116571,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.025876,0.896498,0.103502,0.026137,0.895452,0.104548,0.026137,0.895452,0.104548,0.027967,0.888134,0.111866,0.033847,0.864611,0.135389,0.033847,0.864611,0.135389,0.034631,0.861474,0.138526,0.036461,0.854156,0.145844,0.038552,0.845792,0.154208,0.040904,0.836383,0.163617,0.043779,0.824882,0.175118,0.048876,0.804496,0.195504,0.052405,0.790382,0.209618,0.057109,0.771563,0.228437,0.062729,0.749085,0.250915,0.067956,0.728176,0.271824,0.073576,0.705698,0.294302,0.077627,0.689493,0.310507,0.081809,0.672765,0.327235,0.094354,0.622582,0.377418,0.115787,0.536853,0.463147,0.124412,0.502352,0.497648,0.13735,0.450601,0.549399,0.142708,0.429169,0.570831,0.138526,0.445896,0.554104,0.151072,0.395714,0.604286,0.122974,0.508102,0.491898,0.122974,0.508102,0.491898,0.09736,0.610559,0.389441,0.094485,0.62206,0.37794,0.089388,0.642446,0.357554,0.082462,0.670152,0.329848,0.078803,0.684788,0.315212,0.075666,0.697334,0.302666,0.075536,0.697857,0.302143,0.075928,0.696289,0.303711,0.075797,0.696811,0.303189,0.075405,0.69838,0.30162,0.07449,0.702039,0.297961,0.073445,0.706221,0.293779,0.070962,0.716153,0.283847,0.068217,0.72713,0.27287,0.065865,0.736539,0.263461,0.05907,0.763722,0.236278,0.056587,0.773654,0.226346,0.057501,0.769995,0.230005,0.067825,0.728698,0.271302,0.081417,0.674334,0.325666,0.095008,0.619969,0.380031,0.108207,0.567172,0.432828,0.13748,0.450078,0.549922};
			return value;
		}
		private double[] getColor_6_24_color_49()
		{
			double[] value = {0.03437,0.86252,0.13748,0.034239,0.863042,0.136958,0.034109,0.863565,0.136435,0.033717,0.865133,0.134867,0.033978,0.864088,0.135912,0.031887,0.872452,0.127548,0.033325,0.866702,0.133298,0.041296,0.834814,0.165186,0.04195,0.832201,0.167799,0.042081,0.831678,0.168322,0.04391,0.82436,0.17564,0.047569,0.809723,0.190277,0.054234,0.783063,0.216937,0.059462,0.762154,0.237846,0.057763,0.768949,0.231051,0.049922,0.800314,0.199686,0.061683,0.753267,0.246733,0.081286,0.674856,0.325144,0.065081,0.739676,0.260324,0.059462,0.762154,0.237846,0.050575,0.7977,0.2023,0.041558,0.833769,0.166231,0.039728,0.841087,0.158913,0.035154,0.859383,0.140617,0.027182,0.89127,0.10873,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.025876,0.896498,0.103502,0.02679,0.892838,0.107162,0.028489,0.886043,0.113957,0.030188,0.879247,0.120753,0.034109,0.863565,0.136435,0.034109,0.863565,0.136435,0.035285,0.85886,0.14114,0.039075,0.843701,0.156299,0.042081,0.831678,0.168322,0.047177,0.811291,0.188709,0.050836,0.796654,0.203346,0.056194,0.775222,0.224778,0.060638,0.757449,0.242551,0.065604,0.737585,0.262415,0.068348,0.726607,0.273393,0.073445,0.706221,0.293779,0.081678,0.673288,0.326712,0.089519,0.641924,0.358076,0.099059,0.603764,0.396236,0.109383,0.562467,0.437533,0.114872,0.540512,0.459488,0.121798,0.512807,0.487193,0.141401,0.434396,0.565604,0.114088,0.543649,0.456351,0.123889,0.504443,0.495557,0.100235,0.599059,0.400941,0.091087,0.635651,0.364349,0.089388,0.642446,0.357554,0.08586,0.65656,0.34344,0.081809,0.672765,0.327235,0.077496,0.690016,0.309984,0.074621,0.701516,0.298484,0.075928,0.696289,0.303711,0.076843,0.692629,0.307371,0.077627,0.689493,0.310507,0.076843,0.692629,0.307371,0.075405,0.69838,0.30162,0.073706,0.705175,0.294825,0.072138,0.711448,0.288552,0.070308,0.718766,0.281234,0.068348,0.726607,0.273393,0.065865,0.736539,0.263461,0.058547,0.765813,0.234187,0.050836,0.796654,0.203346,0.063513,0.745949,0.254051,0.077365,0.690538,0.309462,0.088474,0.646106,0.353894,0.093309,0.626764,0.373236,0.146498,0.414009,0.585991,0.034109,0.863565,0.136435,0.03241,0.870361,0.129639,0.032018,0.871929,0.128071,0.031756,0.872974,0.127026,0.033455,0.866179,0.133821,0.033978,0.864088,0.135912,0.034109,0.863565,0.136435,0.037507,0.849974,0.150026,0.04012,0.839519,0.160481,0.040904,0.836383,0.163617,0.041688,0.833246,0.166754,0.04391,0.82436,0.17564,0.045348,0.81861,0.18139,0.046262,0.81495,0.18505,0.045086,0.819655,0.180345,0.042081,0.831678,0.168322,0.041427,0.834292,0.165708,0.041166,0.835337,0.164663,0.040512,0.837951,0.162049,0.036853,0.852588,0.147412};
			return value;
		}
		private double[] getColor_6_24_color_50()
		{
			double[] value = {0.034501,0.861997,0.138003,0.032933,0.86827,0.13173,0.03045,0.878202,0.121798,0.027444,0.890225,0.109775,0.026006,0.895975,0.104025,0.023785,0.904861,0.095139,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.026137,0.895452,0.104548,0.026137,0.895452,0.104548,0.02862,0.88552,0.11448,0.032018,0.871929,0.128071,0.033455,0.866179,0.133821,0.034109,0.863565,0.136435,0.037245,0.851019,0.148981,0.041688,0.833246,0.166754,0.045217,0.819132,0.180868,0.049791,0.800836,0.199164,0.053711,0.785154,0.214846,0.057893,0.768427,0.231573,0.06103,0.755881,0.244119,0.065473,0.738108,0.261892,0.071485,0.714062,0.285938,0.077104,0.691584,0.308416,0.081809,0.672765,0.327235,0.088212,0.647151,0.352849,0.096707,0.613173,0.386827,0.097752,0.608991,0.391009,0.112781,0.548876,0.451124,0.107946,0.568217,0.431783,0.113826,0.544694,0.455306,0.097752,0.608991,0.391009,0.093962,0.624151,0.375849,0.088474,0.646106,0.353894,0.084814,0.660742,0.339258,0.082201,0.671197,0.328803,0.079848,0.680606,0.319394,0.075536,0.697857,0.302143,0.076973,0.692107,0.307893,0.079456,0.682175,0.317825,0.081417,0.674334,0.325666,0.081809,0.672765,0.327235,0.081678,0.673288,0.326712,0.076189,0.695243,0.304757,0.073968,0.70413,0.29587,0.073837,0.704652,0.295348,0.073706,0.705175,0.294825,0.069394,0.722426,0.277574,0.065996,0.736017,0.263983,0.057893,0.768427,0.231573,0.057893,0.768427,0.231573,0.049268,0.802927,0.197073,0.065865,0.736539,0.263461,0.074621,0.701516,0.298484,0.094616,0.621537,0.378463,0.111605,0.553581,0.446419,0.032279,0.870883,0.129117,0.030188,0.879247,0.120753,0.030058,0.87977,0.12023,0.033325,0.866702,0.133298,0.032148,0.871406,0.128594,0.032148,0.871406,0.128594,0.033455,0.866179,0.133821,0.033978,0.864088,0.135912,0.035285,0.85886,0.14114,0.037245,0.851019,0.148981,0.040251,0.838996,0.161004,0.040904,0.836383,0.163617,0.041688,0.833246,0.166754,0.040904,0.836383,0.163617,0.038291,0.846837,0.153163,0.036461,0.854156,0.145844,0.034109,0.863565,0.136435,0.033847,0.864611,0.135389,0.032279,0.870883,0.129117,0.030711,0.877156,0.122844,0.031103,0.875588,0.124412,0.029796,0.880815,0.119185,0.028228,0.887088,0.112912,0.027052,0.891793,0.108207,0.026006,0.895975,0.104025,0.025614,0.897543,0.102457,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.026137,0.895452,0.104548,0.026137,0.895452,0.104548,0.027052,0.891793,0.108207,0.029796,0.880815,0.119185,0.032671,0.869315,0.130685,0.035416,0.858338,0.141662,0.039728,0.841087,0.158913};
			return value;
		}
		private double[] getColor_6_24_color_51()
		{
			double[] value = {0.043126,0.827496,0.172504,0.047439,0.810246,0.189754,0.050706,0.797177,0.202823,0.054104,0.783586,0.216414,0.057763,0.768949,0.231051,0.06299,0.74804,0.25196,0.067825,0.728698,0.271302,0.073053,0.707789,0.292211,0.075405,0.69838,0.30162,0.081678,0.673288,0.326712,0.081809,0.672765,0.327235,0.087559,0.649765,0.350235,0.093048,0.62781,0.37219,0.10494,0.58024,0.41976,0.090565,0.637742,0.362258,0.08978,0.640878,0.359122,0.086905,0.652378,0.347622,0.084161,0.663356,0.336644,0.081286,0.674856,0.325144,0.078672,0.685311,0.314689,0.076712,0.693152,0.306848,0.075928,0.696289,0.303711,0.081417,0.674334,0.325666,0.084292,0.662833,0.337167,0.086905,0.652378,0.347622,0.086513,0.653947,0.346053,0.081678,0.673288,0.326712,0.073837,0.704652,0.295348,0.072138,0.711448,0.288552,0.065865,0.736539,0.263461,0.069524,0.721903,0.278097,0.065865,0.736539,0.263461,0.058677,0.76529,0.23471,0.052535,0.789859,0.210141,0.051882,0.792473,0.207527,0.048353,0.806587,0.193413,0.056456,0.774177,0.225823,0.066127,0.735494,0.264506,0.082331,0.670674,0.329326,0.086775,0.652901,0.347099,0.029535,0.881861,0.118139,0.03058,0.877679,0.122321,0.032279,0.870883,0.129117,0.033325,0.866702,0.133298,0.033063,0.867747,0.132253,0.032933,0.86827,0.13173,0.034109,0.863565,0.136435,0.033978,0.864088,0.135912,0.033717,0.865133,0.134867,0.033717,0.865133,0.134867,0.035416,0.858338,0.141662,0.034762,0.860951,0.139049,0.03437,0.86252,0.13748,0.033978,0.864088,0.135912,0.033325,0.866702,0.133298,0.031887,0.872452,0.127548,0.03058,0.877679,0.122321,0.026529,0.893884,0.106116,0.026398,0.894407,0.105593,0.026137,0.895452,0.104548,0.03045,0.878202,0.121798,0.029796,0.880815,0.119185,0.029535,0.881861,0.118139,0.029143,0.883429,0.116571,0.027967,0.888134,0.111866,0.026268,0.894929,0.105071,0.02287,0.908521,0.091479,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.025091,0.899634,0.100366,0.024569,0.901725,0.098275,0.025091,0.899634,0.100366,0.026137,0.895452,0.104548,0.030319,0.878725,0.121275,0.034109,0.863565,0.136435,0.037376,0.850497,0.149503,0.04195,0.832201,0.167799,0.045217,0.819132,0.180868,0.048876,0.804496,0.195504,0.050836,0.796654,0.203346,0.05541,0.778359,0.221641,0.059462,0.762154,0.237846,0.064558,0.741767,0.258233,0.067695,0.729221,0.270779,0.068217,0.72713,0.27287,0.070047,0.719812,0.280188,0.073837,0.704652,0.295348,0.079195,0.68322,0.31678,0.078019,0.687925,0.312075,0.085468,0.658129,0.341871,0.080502,0.677993,0.322007,0.081678,0.673288,0.326712,0.081809,0.672765,0.327235,0.081809,0.672765,0.327235,0.079587,0.681652,0.318348,0.073837,0.704652,0.295348};
			return value;
		}
		private double[] getColor_6_24_color_52()
		{
			double[] value = {0.073968,0.70413,0.29587,0.08978,0.640878,0.359122,0.089519,0.641924,0.358076,0.089519,0.641924,0.358076,0.094616,0.621537,0.378463,0.092917,0.628332,0.371668,0.08965,0.641401,0.358599,0.090303,0.638787,0.361213,0.072399,0.710403,0.289597,0.065081,0.739676,0.260324,0.066127,0.735494,0.264506,0.065212,0.739153,0.260847,0.067303,0.730789,0.269211,0.060246,0.759017,0.240983,0.050183,0.799268,0.200732,0.046001,0.815996,0.184004,0.057371,0.770518,0.229482,0.073706,0.705175,0.294825,0.07253,0.70988,0.29012,0.079195,0.68322,0.31678,0.029796,0.880815,0.119185,0.033194,0.867224,0.132776,0.034239,0.863042,0.136958,0.034109,0.863565,0.136435,0.033978,0.864088,0.135912,0.034893,0.860429,0.139571,0.034762,0.860951,0.139049,0.033978,0.864088,0.135912,0.033847,0.864611,0.135389,0.033586,0.865656,0.134344,0.034109,0.863565,0.136435,0.034109,0.863565,0.136435,0.032279,0.870883,0.129117,0.03058,0.877679,0.122321,0.030058,0.87977,0.12023,0.02862,0.88552,0.11448,0.026137,0.895452,0.104548,0.025091,0.899634,0.100366,0.02483,0.90068,0.09932,0.028881,0.884475,0.115525,0.030058,0.87977,0.12023,0.030058,0.87977,0.12023,0.030058,0.87977,0.12023,0.030058,0.87977,0.12023,0.030058,0.87977,0.12023,0.029143,0.883429,0.116571,0.026006,0.895975,0.104025,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.026137,0.895452,0.104548,0.026529,0.893884,0.106116,0.033978,0.864088,0.135912,0.034893,0.860429,0.139571,0.040251,0.838996,0.161004,0.042603,0.829587,0.170413,0.049791,0.800836,0.199164,0.049922,0.800314,0.199686,0.057109,0.771563,0.228437,0.060899,0.756404,0.243596,0.065473,0.738108,0.261892,0.066127,0.735494,0.264506,0.065342,0.73863,0.26137,0.065734,0.737062,0.262938,0.073837,0.704652,0.295348,0.070962,0.716153,0.283847,0.073445,0.706221,0.293779,0.075405,0.69838,0.30162,0.073706,0.705175,0.294825,0.072922,0.708312,0.291688,0.073053,0.707789,0.292211,0.077235,0.691061,0.308939,0.07632,0.69472,0.30528,0.089258,0.642969,0.357031,0.073183,0.707266,0.292734,0.081678,0.673288,0.326712,0.081809,0.672765,0.327235,0.080633,0.67747,0.32253,0.0839,0.664401,0.335599,0.081809,0.672765,0.327235,0.088212,0.647151,0.352849,0.079456,0.682175,0.317825,0.066388,0.734449,0.265551,0.06116,0.755358,0.244642,0.067433,0.730267,0.269733,0.065996,0.736017,0.263983,0.058024,0.767904,0.232096,0.058285,0.766858,0.233142,0.046524,0.813905,0.186095,0.044433,0.822269,0.177731,0.050967,0.796132,0.203868,0.064166,0.743335,0.256665,0.065734,0.737062,0.262938,0.071877,0.712493,0.287507};
			return value;
		}
		private double[] getColor_6_24_color_53()
		{
			double[] value = {0.031626,0.873497,0.126503,0.033586,0.865656,0.134344,0.035024,0.859906,0.140094,0.034239,0.863042,0.136958,0.034762,0.860951,0.139049,0.035416,0.858338,0.141662,0.035938,0.856247,0.143753,0.035416,0.858338,0.141662,0.034893,0.860429,0.139571,0.034109,0.863565,0.136435,0.034631,0.861474,0.138526,0.032148,0.871406,0.128594,0.029535,0.881861,0.118139,0.027967,0.888134,0.111866,0.027444,0.890225,0.109775,0.026921,0.892316,0.107684,0.025876,0.896498,0.103502,0.02483,0.90068,0.09932,0.026137,0.895452,0.104548,0.029796,0.880815,0.119185,0.030842,0.876634,0.123366,0.030842,0.876634,0.123366,0.030842,0.876634,0.123366,0.030842,0.876634,0.123366,0.031103,0.875588,0.124412,0.031626,0.873497,0.126503,0.029927,0.880293,0.119707,0.026006,0.895975,0.104025,0.024569,0.901725,0.098275,0.023915,0.904339,0.095661,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.024307,0.902771,0.097229,0.0,0.0,1.0,0.026137,0.895452,0.104548,0.030972,0.876111,0.123889,0.034631,0.861474,0.138526,0.039597,0.84161,0.15839,0.042211,0.831155,0.168845,0.047569,0.809723,0.190277,0.054757,0.780972,0.219028,0.067041,0.731835,0.268165,0.079587,0.681652,0.318348,0.073837,0.704652,0.295348,0.073314,0.706743,0.293257,0.068217,0.72713,0.27287,0.064428,0.74229,0.25771,0.082854,0.668583,0.331417,0.067041,0.731835,0.268165,0.070047,0.719812,0.280188,0.071746,0.713016,0.286984,0.066649,0.733403,0.266597,0.065865,0.736539,0.263461,0.065996,0.736017,0.263983,0.072791,0.708834,0.291166,0.092002,0.631992,0.368008,0.085337,0.658651,0.341349,0.073837,0.704652,0.295348,0.081025,0.675902,0.324098,0.073053,0.707789,0.292211,0.074882,0.70047,0.29953,0.078542,0.685834,0.314166,0.110167,0.559331,0.440669,0.103241,0.587036,0.412964,0.073706,0.705175,0.294825,0.058808,0.764767,0.235233,0.05162,0.793518,0.206482,0.058024,0.767904,0.232096,0.057763,0.768949,0.231051,0.051882,0.792473,0.207527,0.05345,0.7862,0.2138,0.042342,0.830633,0.169367,0.044564,0.821746,0.178254,0.04953,0.801882,0.198118,0.05724,0.77104,0.22896,0.062075,0.751699,0.248301,0.064166,0.743335,0.256665,0.032671,0.869315,0.130685,0.033717,0.865133,0.134867,0.034239,0.863042,0.136958,0.035285,0.85886,0.14114,0.035938,0.856247,0.143753,0.03633,0.854679,0.145321,0.036592,0.853633,0.146367,0.036722,0.85311,0.14689,0.036722,0.85311,0.14689,0.0362,0.855201,0.144799,0.03437,0.86252,0.13748,0.033063,0.867747,0.132253,0.031364,0.874543,0.125457,0.029665,0.881338,0.118662,0.028751,0.884997,0.115003,0.028228,0.887088,0.112912,0.027444,0.890225,0.109775,0.026398,0.894407,0.105593,0.025876,0.896498,0.103502,0.030058,0.87977,0.12023};
			return value;
		}
		private double[] getColor_6_24_color_54()
		{
			double[] value = {0.03045,0.878202,0.121798,0.030319,0.878725,0.121275,0.030842,0.876634,0.123366,0.031234,0.875065,0.124935,0.031626,0.873497,0.126503,0.032018,0.871929,0.128071,0.031364,0.874543,0.125457,0.029273,0.882906,0.117094,0.029143,0.883429,0.116571,0.027444,0.890225,0.109775,0.025484,0.898066,0.101934,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.031364,0.874543,0.125457,0.033847,0.864611,0.135389,0.0,0.0,1.0,0.02287,0.908521,0.091479,0.027444,0.890225,0.109775,0.033194,0.867224,0.132776,0.037768,0.848928,0.151072,0.041296,0.834814,0.165186,0.049399,0.802405,0.197595,0.056979,0.772086,0.227914,0.073576,0.705698,0.294302,0.086905,0.652378,0.347622,0.077235,0.691061,0.308939,0.076189,0.695243,0.304757,0.064689,0.741244,0.258756,0.069655,0.72138,0.27862,0.081809,0.672765,0.327235,0.080633,0.67747,0.32253,0.065996,0.736017,0.263983,0.082462,0.670152,0.329848,0.065604,0.737585,0.262415,0.057893,0.768427,0.231573,0.081678,0.673288,0.326712,0.075144,0.699425,0.300575,0.10886,0.564558,0.435442,0.088996,0.644015,0.355985,0.070047,0.719812,0.280188,0.051228,0.795086,0.204914,0.051751,0.792995,0.207005,0.060115,0.75954,0.24046,0.0707,0.717198,0.282802,0.087167,0.651333,0.348667,0.08978,0.640878,0.359122,0.067564,0.729744,0.270256,0.050183,0.799268,0.200732,0.049137,0.80345,0.19655,0.056717,0.773131,0.226869,0.057893,0.768427,0.231573,0.047569,0.809723,0.190277,0.042342,0.830633,0.169367,0.039859,0.840565,0.159435,0.047569,0.809723,0.190277,0.049922,0.800314,0.199686,0.057501,0.769995,0.230005,0.059592,0.761631,0.238369,0.063251,0.746994,0.253006,0.033978,0.864088,0.135912,0.034762,0.860951,0.139049,0.035546,0.857815,0.142185,0.036592,0.853633,0.146367,0.036984,0.852065,0.147935,0.037507,0.849974,0.150026,0.037899,0.848406,0.151594,0.038029,0.847883,0.152117,0.038029,0.847883,0.152117,0.037507,0.849974,0.150026,0.036853,0.852588,0.147412,0.035024,0.859906,0.140094,0.033194,0.867224,0.132776,0.032148,0.871406,0.128594,0.030319,0.878725,0.121275,0.029665,0.881338,0.118662,0.029143,0.883429,0.116571,0.028751,0.884997,0.115003,0.027574,0.889702,0.110298,0.029143,0.883429,0.116571,0.030319,0.878725,0.121275,0.030058,0.87977,0.12023,0.030711,0.877156,0.122844,0.031364,0.874543,0.125457,0.031756,0.872974,0.127026,0.032148,0.871406,0.128594,0.032279,0.870883,0.129117,0.032148,0.871406,0.128594,0.032018,0.871929,0.128071,0.031364,0.874543,0.125457,0.02862,0.88552,0.11448,0.027313,0.890748,0.109252,0.027444,0.890225,0.109775,0.029143,0.883429,0.116571,0.029927,0.880293,0.119707,0.025614,0.897543,0.102457,0.0,0.0,1.0,0.0,0.0,1.0,0.026137,0.895452,0.104548,0.029535,0.881861,0.118139};
			return value;
		}
		private double[] getColor_6_24_color_55()
		{
			double[] value = {0.033847,0.864611,0.135389,0.037637,0.849451,0.150549,0.042081,0.831678,0.168322,0.049137,0.80345,0.19655,0.065473,0.738108,0.261892,0.080633,0.67747,0.32253,0.065865,0.736539,0.263461,0.059723,0.761108,0.238892,0.070962,0.716153,0.283847,0.057763,0.768949,0.231051,0.065081,0.739676,0.260324,0.067564,0.729744,0.270256,0.059854,0.760585,0.239415,0.059592,0.761631,0.238369,0.052797,0.788813,0.211187,0.053058,0.787768,0.212232,0.064428,0.74229,0.25771,0.060507,0.757972,0.242028,0.080763,0.676947,0.323053,0.118139,0.527444,0.472556,0.067956,0.728176,0.271824,0.042473,0.83011,0.16989,0.042081,0.831678,0.168322,0.049791,0.800836,0.199164,0.055541,0.777836,0.222164,0.058808,0.764767,0.235233,0.058808,0.764767,0.235233,0.055149,0.779404,0.220596,0.042211,0.831155,0.168845,0.047569,0.809723,0.190277,0.044041,0.823837,0.176163,0.042734,0.829064,0.170936,0.045478,0.818087,0.181913,0.041035,0.83586,0.16414,0.040382,0.838474,0.161526,0.046524,0.813905,0.186095,0.049922,0.800314,0.199686,0.050314,0.798745,0.201255,0.053058,0.787768,0.212232,0.053973,0.784109,0.215891,0.033978,0.864088,0.135912,0.035546,0.857815,0.142185,0.036722,0.85311,0.14689,0.037637,0.849451,0.150549,0.037899,0.848406,0.151594,0.039336,0.842656,0.157344,0.040643,0.837428,0.162572,0.040382,0.838474,0.161526,0.040251,0.838996,0.161004,0.039859,0.840565,0.159435,0.039075,0.843701,0.156299,0.036984,0.852065,0.147935,0.034762,0.860951,0.139049,0.033978,0.864088,0.135912,0.033063,0.867747,0.132253,0.031234,0.875065,0.124935,0.030972,0.876111,0.123889,0.030711,0.877156,0.122844,0.029796,0.880815,0.119185,0.030058,0.87977,0.12023,0.031364,0.874543,0.125457,0.03058,0.877679,0.122321,0.030319,0.878725,0.121275,0.031103,0.875588,0.124412,0.031887,0.872452,0.127548,0.032933,0.86827,0.13173,0.033063,0.867747,0.132253,0.033325,0.866702,0.133298,0.033194,0.867224,0.132776,0.032541,0.869838,0.130162,0.031626,0.873497,0.126503,0.031103,0.875588,0.124412,0.030972,0.876111,0.123889,0.030842,0.876634,0.123366,0.030188,0.879247,0.120753,0.025876,0.896498,0.103502,0.023262,0.906952,0.093048,0.0,0.0,1.0,0.023393,0.90643,0.09357,0.026268,0.894929,0.105071,0.03058,0.877679,0.122321,0.034501,0.861997,0.138003,0.040251,0.838996,0.161004,0.045478,0.818087,0.181913,0.053189,0.787245,0.212755,0.070178,0.719289,0.280711,0.063382,0.746472,0.253528,0.052013,0.79195,0.20805,0.057763,0.768949,0.231051,0.052535,0.789859,0.210141,0.05149,0.794041,0.205959,0.050183,0.799268,0.200732,0.049791,0.800836,0.199164,0.049137,0.80345,0.19655,0.049399,0.802405,0.197595,0.04953,0.801882,0.198118,0.062598,0.749608,0.250392,0.060115,0.75954,0.24046,0.060115,0.75954,0.24046,0.058677,0.76529,0.23471};
			return value;
		}
		private double[] getColor_6_24_color_56()
		{
			double[] value = {0.042995,0.828019,0.171981,0.041296,0.834814,0.165186,0.041296,0.834814,0.165186,0.042995,0.828019,0.171981,0.042995,0.828019,0.171981,0.043126,0.827496,0.172504,0.043649,0.825405,0.174595,0.042342,0.830633,0.169367,0.041296,0.834814,0.165186,0.042603,0.829587,0.170413,0.039075,0.843701,0.156299,0.041819,0.832723,0.167277,0.045217,0.819132,0.180868,0.040904,0.836383,0.163617,0.04195,0.832201,0.167799,0.049137,0.80345,0.19655,0.049268,0.802927,0.197073,0.04953,0.801882,0.198118,0.049922,0.800314,0.199686,0.049268,0.802927,0.197073,0.035154,0.859383,0.140617,0.036722,0.85311,0.14689,0.037637,0.849451,0.150549,0.039205,0.843178,0.156822,0.041427,0.834292,0.165708,0.041819,0.832723,0.167277,0.04195,0.832201,0.167799,0.042081,0.831678,0.168322,0.042342,0.830633,0.169367,0.042211,0.831155,0.168845,0.041035,0.83586,0.16414,0.039205,0.843178,0.156822,0.037637,0.849451,0.150549,0.03633,0.854679,0.145321,0.034762,0.860951,0.139049,0.033847,0.864611,0.135389,0.032802,0.868792,0.131208,0.032279,0.870883,0.129117,0.031234,0.875065,0.124935,0.031626,0.873497,0.126503,0.033455,0.866179,0.133821,0.031364,0.874543,0.125457,0.030058,0.87977,0.12023,0.030842,0.876634,0.123366,0.032018,0.871929,0.128071,0.033325,0.866702,0.133298,0.033847,0.864611,0.135389,0.033978,0.864088,0.135912,0.033978,0.864088,0.135912,0.033586,0.865656,0.134344,0.032279,0.870883,0.129117,0.032018,0.871929,0.128071,0.032018,0.871929,0.128071,0.032018,0.871929,0.128071,0.032018,0.871929,0.128071,0.02862,0.88552,0.11448,0.024961,0.900157,0.099843,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.027574,0.889702,0.110298,0.032671,0.869315,0.130685,0.035938,0.856247,0.143753,0.041166,0.835337,0.164663,0.043257,0.826973,0.173027,0.051751,0.792995,0.207005,0.046916,0.812337,0.187663,0.048615,0.805541,0.194459,0.047569,0.809723,0.190277,0.045609,0.817564,0.182436,0.043779,0.824882,0.175118,0.043257,0.826973,0.173027,0.04391,0.82436,0.17564,0.042473,0.83011,0.16989,0.042473,0.83011,0.16989,0.043126,0.827496,0.172504,0.042211,0.831155,0.168845,0.038421,0.846315,0.153685,0.03633,0.854679,0.145321,0.034109,0.863565,0.136435,0.035154,0.859383,0.140617,0.034109,0.863565,0.136435,0.034893,0.860429,0.139571,0.036984,0.852065,0.147935,0.035938,0.856247,0.143753,0.033194,0.867224,0.132776,0.032933,0.86827,0.13173,0.033455,0.866179,0.133821,0.033717,0.865133,0.134867,0.032802,0.868792,0.131208,0.032671,0.869315,0.130685,0.038291,0.846837,0.153163,0.039075,0.843701,0.156299,0.035285,0.85886,0.14114,0.038944,0.844224,0.155776,0.042865,0.828542,0.171458,0.045478,0.818087,0.181913,0.045086,0.819655,0.180345,0.045609,0.817564,0.182436,0.045086,0.819655,0.180345};
			return value;
		}
		private double[] getColor_6_24_color_57()
		{
			double[] value = {0.037114,0.851542,0.148458,0.038291,0.846837,0.153163,0.039859,0.840565,0.159435,0.041688,0.833246,0.166754,0.042603,0.829587,0.170413,0.043779,0.824882,0.175118,0.044171,0.823314,0.176686,0.044564,0.821746,0.178254,0.044564,0.821746,0.178254,0.043779,0.824882,0.175118,0.042603,0.829587,0.170413,0.041558,0.833769,0.166231,0.040382,0.838474,0.161526,0.038944,0.844224,0.155776,0.037768,0.848928,0.151072,0.036592,0.853633,0.146367,0.035546,0.857815,0.142185,0.03437,0.86252,0.13748,0.034109,0.863565,0.136435,0.033978,0.864088,0.135912,0.035024,0.859906,0.140094,0.032671,0.869315,0.130685,0.03058,0.877679,0.122321,0.03058,0.877679,0.122321,0.032018,0.871929,0.128071,0.033586,0.865656,0.134344,0.035285,0.85886,0.14114,0.03633,0.854679,0.145321,0.035938,0.856247,0.143753,0.03437,0.86252,0.13748,0.033455,0.866179,0.133821,0.031626,0.873497,0.126503,0.031756,0.872974,0.127026,0.031887,0.872452,0.127548,0.032018,0.871929,0.128071,0.031756,0.872974,0.127026,0.027574,0.889702,0.110298,0.024307,0.902771,0.097229,0.022739,0.909043,0.090957,0.0,0.0,1.0,0.023785,0.904861,0.095139,0.026921,0.892316,0.107684,0.030058,0.87977,0.12023,0.033063,0.867747,0.132253,0.034893,0.860429,0.139571,0.035154,0.859383,0.140617,0.036984,0.852065,0.147935,0.040382,0.838474,0.161526,0.038552,0.845792,0.154208,0.040251,0.838996,0.161004,0.039075,0.843701,0.156299,0.038421,0.846315,0.153685,0.038813,0.844746,0.155254,0.037114,0.851542,0.148458,0.038291,0.846837,0.153163,0.036592,0.853633,0.146367,0.036722,0.85311,0.14689,0.033325,0.866702,0.133298,0.03241,0.870361,0.129639,0.028881,0.884475,0.115525,0.027574,0.889702,0.110298,0.033717,0.865133,0.134867,0.033978,0.864088,0.135912,0.03058,0.877679,0.122321,0.028751,0.884997,0.115003,0.027313,0.890748,0.109252,0.027574,0.889702,0.110298,0.029665,0.881338,0.118662,0.029796,0.880815,0.119185,0.029143,0.883429,0.116571,0.029273,0.882906,0.117094,0.030711,0.877156,0.122844,0.035546,0.857815,0.142185,0.034109,0.863565,0.136435,0.037376,0.850497,0.149503,0.041035,0.83586,0.16414,0.043257,0.826973,0.173027,0.042734,0.829064,0.170936,0.041688,0.833246,0.166754,0.041427,0.834292,0.165708,0.039859,0.840565,0.159435,0.041688,0.833246,0.166754,0.042473,0.83011,0.16989,0.043779,0.824882,0.175118,0.044956,0.820178,0.179822,0.046001,0.815996,0.184004,0.046524,0.813905,0.186095,0.047308,0.810768,0.189232,0.047831,0.808677,0.191323,0.047047,0.811814,0.188186,0.04574,0.817041,0.182959,0.044433,0.822269,0.177731,0.042995,0.828019,0.171981,0.041427,0.834292,0.165708,0.039859,0.840565,0.159435,0.038421,0.846315,0.153685,0.036853,0.852588,0.147412,0.035285,0.85886,0.14114,0.03437,0.86252,0.13748,0.034109,0.863565,0.136435};
			return value;
		}
		private double[] getColor_6_24_color_58()
		{
			double[] value = {0.034109,0.863565,0.136435,0.03241,0.870361,0.129639,0.031887,0.872452,0.127548,0.032018,0.871929,0.128071,0.033455,0.866179,0.133821,0.033978,0.864088,0.135912,0.0362,0.855201,0.144799,0.037768,0.848928,0.151072,0.036984,0.852065,0.147935,0.035938,0.856247,0.143753,0.033978,0.864088,0.135912,0.031756,0.872974,0.127026,0.031756,0.872974,0.127026,0.031887,0.872452,0.127548,0.032148,0.871406,0.128594,0.033063,0.867747,0.132253,0.029927,0.880293,0.119707,0.026137,0.895452,0.104548,0.02483,0.90068,0.09932,0.023131,0.907475,0.092525,0.0,0.0,1.0,0.023131,0.907475,0.092525,0.024961,0.900157,0.099843,0.026006,0.895975,0.104025,0.026529,0.893884,0.106116,0.026268,0.894929,0.105071,0.03045,0.878202,0.121798,0.033455,0.866179,0.133821,0.033717,0.865133,0.134867,0.034109,0.863565,0.136435,0.033978,0.864088,0.135912,0.034109,0.863565,0.136435,0.034239,0.863042,0.136958,0.032802,0.868792,0.131208,0.031103,0.875588,0.124412,0.032018,0.871929,0.128071,0.031887,0.872452,0.127548,0.029665,0.881338,0.118662,0.027967,0.888134,0.111866,0.027052,0.891793,0.108207,0.026398,0.894407,0.105593,0.026529,0.893884,0.106116,0.026529,0.893884,0.106116,0.02666,0.893361,0.106639,0.027052,0.891793,0.108207,0.027182,0.89127,0.10873,0.027444,0.890225,0.109775,0.027836,0.888657,0.111343,0.028097,0.887611,0.112389,0.028359,0.886566,0.113434,0.029143,0.883429,0.116571,0.029665,0.881338,0.118662,0.033455,0.866179,0.133821,0.036722,0.85311,0.14689,0.039467,0.842133,0.157867,0.04195,0.832201,0.167799,0.042734,0.829064,0.170936,0.042211,0.831155,0.168845,0.039336,0.842656,0.157344,0.038552,0.845792,0.154208,0.042734,0.829064,0.170936,0.044302,0.822791,0.177209,0.045609,0.817564,0.182436,0.046524,0.813905,0.186095,0.047308,0.810768,0.189232,0.048223,0.807109,0.192891,0.048876,0.804496,0.195504,0.050052,0.799791,0.200209,0.050444,0.798223,0.201777,0.050052,0.799791,0.200209,0.04953,0.801882,0.198118,0.048092,0.807632,0.192368,0.046393,0.814428,0.185572,0.04391,0.82436,0.17564,0.04195,0.832201,0.167799,0.040251,0.838996,0.161004,0.038683,0.845269,0.154731,0.036592,0.853633,0.146367,0.034762,0.860951,0.139049,0.033847,0.864611,0.135389,0.03241,0.870361,0.129639,0.031234,0.875065,0.124935,0.031234,0.875065,0.124935,0.031756,0.872974,0.127026,0.033978,0.864088,0.135912,0.035546,0.857815,0.142185,0.037114,0.851542,0.148458,0.039205,0.843178,0.156822,0.037768,0.848928,0.151072,0.035416,0.858338,0.141662,0.033717,0.865133,0.134867,0.031756,0.872974,0.127026,0.031756,0.872974,0.127026,0.031756,0.872974,0.127026,0.03241,0.870361,0.129639,0.034109,0.863565,0.136435,0.033978,0.864088,0.135912,0.032933,0.86827,0.13173,0.029012,0.883952,0.116048,0.025222,0.899111,0.100889};
			return value;
		}
		private double[] getColor_6_24_color_59()
		{
			double[] value = {0.023523,0.905907,0.094093,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.023785,0.904861,0.095139,0.026268,0.894929,0.105071,0.026268,0.894929,0.105071,0.027444,0.890225,0.109775,0.028881,0.884475,0.115525,0.029535,0.881861,0.118139,0.027705,0.889179,0.110821,0.026006,0.895975,0.104025,0.025484,0.898066,0.101934,0.025876,0.896498,0.103502,0.026006,0.895975,0.104025,0.025614,0.897543,0.102457,0.025745,0.89702,0.10298,0.025876,0.896498,0.103502,0.025876,0.896498,0.103502,0.026137,0.895452,0.104548,0.026398,0.894407,0.105593,0.026921,0.892316,0.107684,0.027182,0.89127,0.10873,0.027444,0.890225,0.109775,0.027574,0.889702,0.110298,0.031756,0.872974,0.127026,0.028881,0.884475,0.115525,0.035938,0.856247,0.143753,0.029273,0.882906,0.117094,0.030058,0.87977,0.12023,0.03241,0.870361,0.129639,0.037899,0.848406,0.151594,0.038683,0.845269,0.154731,0.034501,0.861997,0.138003,0.035024,0.859906,0.140094,0.037637,0.849451,0.150549,0.038029,0.847883,0.152117,0.035416,0.858338,0.141662,0.046001,0.815996,0.184004,0.047308,0.810768,0.189232,0.048615,0.805541,0.194459,0.049268,0.802927,0.197073,0.04966,0.801359,0.198641,0.051098,0.795609,0.204391,0.052274,0.790904,0.209096,0.053842,0.784631,0.215369,0.054888,0.78045,0.21955,0.054496,0.782018,0.217982,0.053319,0.786722,0.213278,0.05149,0.794041,0.205959,0.049791,0.800836,0.199164,0.047439,0.810246,0.189754,0.044694,0.821223,0.178777,0.041819,0.832723,0.167277,0.040512,0.837951,0.162049,0.038421,0.846315,0.153685,0.0362,0.855201,0.144799,0.034239,0.863042,0.136958,0.032279,0.870883,0.129117,0.031756,0.872974,0.127026,0.031887,0.872452,0.127548,0.032018,0.871929,0.128071,0.033978,0.864088,0.135912,0.036461,0.854156,0.145844,0.038421,0.846315,0.153685,0.041296,0.834814,0.165186,0.036984,0.852065,0.147935,0.035808,0.856769,0.143231,0.033847,0.864611,0.135389,0.032802,0.868792,0.131208,0.032018,0.871929,0.128071,0.032018,0.871929,0.128071,0.033978,0.864088,0.135912,0.035285,0.85886,0.14114,0.038813,0.844746,0.155254,0.042603,0.829587,0.170413,0.042734,0.829064,0.170936,0.030842,0.876634,0.123366,0.025484,0.898066,0.101934,0.024699,0.901202,0.098798,0.0,0.0,1.0,0.02287,0.908521,0.091479,0.022739,0.909043,0.090957,0.0,0.0,1.0,0.0,0.0,1.0,0.023393,0.90643,0.09357,0.024438,0.902248,0.097752,0.024699,0.901202,0.098798,0.024569,0.901725,0.098275,0.024961,0.900157,0.099843,0.024961,0.900157,0.099843,0.024569,0.901725,0.098275,0.024438,0.902248,0.097752,0.025222,0.899111,0.100889,0.025091,0.899634,0.100366,0.025353,0.898589,0.101411,0.02679,0.892838,0.107162,0.026006,0.895975,0.104025};
			return value;
		}
		private double[] getColor_6_24_color_60()
		{
			double[] value = {0.027705,0.889179,0.110821,0.029796,0.880815,0.119185,0.032802,0.868792,0.131208,0.033978,0.864088,0.135912,0.033455,0.866179,0.133821,0.033717,0.865133,0.134867,0.036069,0.855724,0.144276,0.034239,0.863042,0.136958,0.037114,0.851542,0.148458,0.03045,0.878202,0.121798,0.029273,0.882906,0.117094,0.029535,0.881861,0.118139,0.036461,0.854156,0.145844,0.032279,0.870883,0.129117,0.030058,0.87977,0.12023,0.030711,0.877156,0.122844,0.030842,0.876634,0.123366,0.032279,0.870883,0.129117,0.033717,0.865133,0.134867,0.032018,0.871929,0.128071,0.049268,0.802927,0.197073,0.050052,0.799791,0.200209,0.052013,0.79195,0.20805,0.053319,0.786722,0.213278,0.054496,0.782018,0.217982,0.055541,0.777836,0.222164,0.056587,0.773654,0.226346,0.057632,0.769472,0.230528,0.05907,0.763722,0.236278,0.058677,0.76529,0.23471,0.058024,0.767904,0.232096,0.056587,0.773654,0.226346,0.053842,0.784631,0.215369,0.050836,0.796654,0.203346,0.048223,0.807109,0.192891,0.045086,0.819655,0.180345,0.042342,0.830633,0.169367,0.04012,0.839519,0.160481,0.037899,0.848406,0.151594,0.035416,0.858338,0.141662,0.032933,0.86827,0.13173,0.031887,0.872452,0.127548,0.032018,0.871929,0.128071,0.032802,0.868792,0.131208,0.034109,0.863565,0.136435,0.0362,0.855201,0.144799,0.037899,0.848406,0.151594,0.038029,0.847883,0.152117,0.036853,0.852588,0.147412,0.035938,0.856247,0.143753,0.034501,0.861997,0.138003,0.031887,0.872452,0.127548,0.03241,0.870361,0.129639,0.033063,0.867747,0.132253,0.033847,0.864611,0.135389,0.034893,0.860429,0.139571,0.037637,0.849451,0.150549,0.040382,0.838474,0.161526,0.04195,0.832201,0.167799,0.034762,0.860951,0.139049,0.033847,0.864611,0.135389,0.029796,0.880815,0.119185,0.024307,0.902771,0.097229,0.023131,0.907475,0.092525,0.022608,0.909566,0.090434,0.022739,0.909043,0.090957,0.022608,0.909566,0.090434,0.023001,0.907998,0.092002,0.023131,0.907475,0.092525,0.023523,0.905907,0.094093,0.023654,0.905384,0.094616,0.023785,0.904861,0.095139,0.024438,0.902248,0.097752,0.025484,0.898066,0.101934,0.026268,0.894929,0.105071,0.028228,0.887088,0.112912,0.030058,0.87977,0.12023,0.031495,0.87402,0.12598,0.033194,0.867224,0.132776,0.033978,0.864088,0.135912,0.033847,0.864611,0.135389,0.033978,0.864088,0.135912,0.033978,0.864088,0.135912,0.03999,0.840042,0.159958,0.041296,0.834814,0.165186,0.041035,0.83586,0.16414,0.042995,0.828019,0.171981,0.038683,0.845269,0.154731,0.04195,0.832201,0.167799,0.042211,0.831155,0.168845,0.037114,0.851542,0.148458,0.031887,0.872452,0.127548,0.033978,0.864088,0.135912,0.030058,0.87977,0.12023,0.030058,0.87977,0.12023,0.031626,0.873497,0.126503,0.030842,0.876634,0.123366,0.030842,0.876634,0.123366,0.030842,0.876634,0.123366,0.030972,0.876111,0.123889};
			return value;
		}
		private double[] getColor_6_24_color_61()
		{
			double[] value = {0.053058,0.787768,0.212232,0.054496,0.782018,0.217982,0.056325,0.774699,0.225301,0.058024,0.767904,0.232096,0.059854,0.760585,0.239415,0.060768,0.756926,0.243074,0.061553,0.75379,0.24621,0.063513,0.745949,0.254051,0.064428,0.74229,0.25771,0.064558,0.741767,0.258233,0.063905,0.744381,0.255619,0.061291,0.754835,0.245165,0.058155,0.767381,0.232619,0.055149,0.779404,0.220596,0.051751,0.792995,0.207005,0.048353,0.806587,0.193413,0.044956,0.820178,0.179822,0.041688,0.833246,0.166754,0.039467,0.842133,0.157867,0.03633,0.854679,0.145321,0.033586,0.865656,0.134344,0.032018,0.871929,0.128071,0.03241,0.870361,0.129639,0.033978,0.864088,0.135912,0.034109,0.863565,0.136435,0.035677,0.857292,0.142708,0.038029,0.847883,0.152117,0.037507,0.849974,0.150026,0.03633,0.854679,0.145321,0.034109,0.863565,0.136435,0.033978,0.864088,0.135912,0.033063,0.867747,0.132253,0.032279,0.870883,0.129117,0.032671,0.869315,0.130685,0.033455,0.866179,0.133821,0.03437,0.86252,0.13748,0.035416,0.858338,0.141662,0.036461,0.854156,0.145844,0.036722,0.85311,0.14689,0.035285,0.85886,0.14114,0.03437,0.86252,0.13748,0.031756,0.872974,0.127026,0.031103,0.875588,0.124412,0.026137,0.895452,0.104548,0.025484,0.898066,0.101934,0.024699,0.901202,0.098798,0.024569,0.901725,0.098275,0.025091,0.899634,0.100366,0.025222,0.899111,0.100889,0.025614,0.897543,0.102457,0.025484,0.898066,0.101934,0.025614,0.897543,0.102457,0.026921,0.892316,0.107684,0.031756,0.872974,0.127026,0.033325,0.866702,0.133298,0.033586,0.865656,0.134344,0.034239,0.863042,0.136958,0.033978,0.864088,0.135912,0.033978,0.864088,0.135912,0.033978,0.864088,0.135912,0.033978,0.864088,0.135912,0.039467,0.842133,0.157867,0.04195,0.832201,0.167799,0.041688,0.833246,0.166754,0.04195,0.832201,0.167799,0.045086,0.819655,0.180345,0.046262,0.81495,0.18505,0.040512,0.837951,0.162049,0.046785,0.812859,0.187141,0.044171,0.823314,0.176686,0.048353,0.806587,0.193413,0.041819,0.832723,0.167277,0.033978,0.864088,0.135912,0.033978,0.864088,0.135912,0.033978,0.864088,0.135912,0.033978,0.864088,0.135912,0.033847,0.864611,0.135389,0.030842,0.876634,0.123366,0.030842,0.876634,0.123366,0.030972,0.876111,0.123889,0.05724,0.77104,0.22896,0.058808,0.764767,0.235233,0.06103,0.755881,0.244119,0.063251,0.746994,0.253006,0.065996,0.736017,0.263983,0.06678,0.73288,0.26712,0.066519,0.733926,0.266074,0.069394,0.722426,0.277574,0.0707,0.717198,0.282802,0.070178,0.719289,0.280711,0.069394,0.722426,0.277574,0.066911,0.732358,0.267642,0.064297,0.742812,0.257188,0.060115,0.75954,0.24046,0.056325,0.774699,0.225301,0.05162,0.793518,0.206482,0.0477,0.8092,0.1908,0.044171,0.823314,0.176686,0.041166,0.835337,0.164663,0.037637,0.849451,0.150549};
			return value;
		}
		private double[] getColor_6_24_color_62()
		{
			double[] value = {0.03437,0.86252,0.13748,0.031756,0.872974,0.127026,0.031234,0.875065,0.124935,0.033194,0.867224,0.132776,0.033717,0.865133,0.134867,0.034631,0.861474,0.138526,0.03633,0.854679,0.145321,0.035808,0.856769,0.143231,0.035416,0.858338,0.141662,0.034239,0.863042,0.136958,0.033847,0.864611,0.135389,0.03241,0.870361,0.129639,0.032279,0.870883,0.129117,0.03241,0.870361,0.129639,0.033194,0.867224,0.132776,0.033847,0.864611,0.135389,0.033978,0.864088,0.135912,0.033978,0.864088,0.135912,0.033847,0.864611,0.135389,0.03437,0.86252,0.13748,0.034109,0.863565,0.136435,0.032541,0.869838,0.130162,0.033325,0.866702,0.133298,0.033978,0.864088,0.135912,0.033586,0.865656,0.134344,0.03241,0.870361,0.129639,0.03058,0.877679,0.122321,0.030711,0.877156,0.122844,0.032018,0.871929,0.128071,0.028489,0.886043,0.113957,0.033978,0.864088,0.135912,0.033717,0.865133,0.134867,0.033717,0.865133,0.134867,0.033978,0.864088,0.135912,0.034762,0.860951,0.139049,0.04195,0.832201,0.167799,0.042081,0.831678,0.168322,0.041688,0.833246,0.166754,0.041296,0.834814,0.165186,0.04195,0.832201,0.167799,0.044564,0.821746,0.178254,0.042342,0.830633,0.169367,0.045217,0.819132,0.180868,0.042603,0.829587,0.170413,0.047961,0.808155,0.191845,0.049791,0.800836,0.199164,0.046262,0.81495,0.18505,0.044302,0.822791,0.177209,0.049922,0.800314,0.199686,0.049922,0.800314,0.199686,0.049922,0.800314,0.199686,0.049922,0.800314,0.199686,0.043257,0.826973,0.173027,0.039467,0.842133,0.157867,0.0362,0.855201,0.144799,0.036461,0.854156,0.145844,0.034893,0.860429,0.139571,0.032671,0.869315,0.130685,0.030842,0.876634,0.123366,0.030972,0.876111,0.123889,0.063382,0.746472,0.253528,0.064166,0.743335,0.256665,0.066388,0.734449,0.265551,0.069916,0.720335,0.279665,0.072399,0.710403,0.289597,0.073837,0.704652,0.295348,0.073706,0.705175,0.294825,0.076451,0.694198,0.305802,0.077104,0.691584,0.308416,0.075928,0.696289,0.303711,0.076059,0.695766,0.304234,0.07632,0.69472,0.30528,0.072007,0.711971,0.288029,0.06482,0.740721,0.259279,0.059854,0.760585,0.239415,0.055149,0.779404,0.220596,0.050183,0.799268,0.200732,0.046524,0.813905,0.186095,0.042211,0.831155,0.168845,0.038683,0.845269,0.154731,0.034762,0.860951,0.139049,0.031626,0.873497,0.126503,0.030188,0.879247,0.120753,0.032018,0.871929,0.128071,0.032933,0.86827,0.13173,0.033717,0.865133,0.134867,0.034631,0.861474,0.138526,0.034762,0.860951,0.139049,0.03437,0.86252,0.13748,0.034109,0.863565,0.136435,0.033194,0.867224,0.132776,0.032018,0.871929,0.128071,0.032148,0.871406,0.128594,0.032279,0.870883,0.129117,0.032671,0.869315,0.130685,0.033325,0.866702,0.133298,0.033847,0.864611,0.135389,0.033978,0.864088,0.135912,0.034109,0.863565,0.136435,0.034109,0.863565,0.136435};
			return value;
		}
		private double[] getColor_6_24_color_63()
		{
			double[] value = {0.033717,0.865133,0.134867,0.033063,0.867747,0.132253,0.034109,0.863565,0.136435,0.034762,0.860951,0.139049,0.034501,0.861997,0.138003,0.033978,0.864088,0.135912,0.034109,0.863565,0.136435,0.034109,0.863565,0.136435,0.034109,0.863565,0.136435,0.030972,0.876111,0.123889,0.033847,0.864611,0.135389,0.036984,0.852065,0.147935,0.035546,0.857815,0.142185,0.037245,0.851019,0.148981,0.041819,0.832723,0.167277,0.044041,0.823837,0.176163,0.042211,0.831155,0.168845,0.042473,0.83011,0.16989,0.042211,0.831155,0.168845,0.05162,0.793518,0.206482,0.049922,0.800314,0.199686,0.04966,0.801359,0.198641,0.050314,0.798745,0.201255,0.046785,0.812859,0.187141,0.049791,0.800836,0.199164,0.046916,0.812337,0.187663,0.045478,0.818087,0.181913,0.044171,0.823314,0.176686,0.046132,0.815473,0.184527,0.048615,0.805541,0.194459,0.049922,0.800314,0.199686,0.049922,0.800314,0.199686,0.04953,0.801882,0.198118,0.042734,0.829064,0.170936,0.04195,0.832201,0.167799,0.041819,0.832723,0.167277,0.039075,0.843701,0.156299,0.0362,0.855201,0.144799,0.033978,0.864088,0.135912,0.031234,0.875065,0.124935,0.069655,0.72138,0.27862,0.070831,0.716675,0.283325,0.073445,0.706221,0.293779,0.077757,0.68897,0.31103,0.080894,0.676424,0.323576,0.085729,0.657083,0.342917,0.090434,0.638265,0.361735,0.093832,0.624673,0.375327,0.087689,0.649242,0.350758,0.086513,0.653947,0.346053,0.085337,0.658651,0.341349,0.095139,0.619446,0.380554,0.080894,0.676424,0.323576,0.070831,0.716675,0.283325,0.064428,0.74229,0.25771,0.058285,0.766858,0.233142,0.053058,0.787768,0.212232,0.049007,0.803973,0.196027,0.043779,0.824882,0.175118,0.039859,0.840565,0.159435,0.035546,0.857815,0.142185,0.031756,0.872974,0.127026,0.030058,0.87977,0.12023,0.030842,0.876634,0.123366,0.031756,0.872974,0.127026,0.032148,0.871406,0.128594,0.033717,0.865133,0.134867,0.033847,0.864611,0.135389,0.033978,0.864088,0.135912,0.032279,0.870883,0.129117,0.031887,0.872452,0.127548,0.032018,0.871929,0.128071,0.032148,0.871406,0.128594,0.032148,0.871406,0.128594,0.032279,0.870883,0.129117,0.032671,0.869315,0.130685,0.033455,0.866179,0.133821,0.034109,0.863565,0.136435,0.034631,0.861474,0.138526,0.034893,0.860429,0.139571,0.033063,0.867747,0.132253,0.032933,0.86827,0.13173,0.033847,0.864611,0.135389,0.036069,0.855724,0.144276,0.035285,0.85886,0.14114,0.0362,0.855201,0.144799,0.036069,0.855724,0.144276,0.035416,0.858338,0.141662,0.034239,0.863042,0.136958,0.033978,0.864088,0.135912,0.036461,0.854156,0.145844,0.039859,0.840565,0.159435,0.041558,0.833769,0.166231,0.042211,0.831155,0.168845,0.044825,0.8207,0.1793,0.049399,0.802405,0.197595,0.049268,0.802927,0.197073,0.049922,0.800314,0.199686,0.049922,0.800314,0.199686,0.049922,0.800314,0.199686};
			return value;
		}
		private double[] getColor_6_24_color_64()
		{
			double[] value = {0.050183,0.799268,0.200732,0.049922,0.800314,0.199686,0.056848,0.772608,0.227392,0.052274,0.790904,0.209096,0.048876,0.804496,0.195504,0.049399,0.802405,0.197595,0.046132,0.815473,0.184527,0.04574,0.817041,0.182959,0.04587,0.816519,0.183481,0.048223,0.807109,0.192891,0.049791,0.800836,0.199164,0.048484,0.806064,0.193936,0.04966,0.801359,0.198641,0.041819,0.832723,0.167277,0.045217,0.819132,0.180868,0.042211,0.831155,0.168845,0.041819,0.832723,0.167277,0.039467,0.842133,0.157867,0.037637,0.849451,0.150549,0.035677,0.857292,0.142708,0.085337,0.658651,0.341349,0.081939,0.672243,0.327757,0.088343,0.646628,0.353372,0.091218,0.635128,0.364872,0.096837,0.61265,0.38735,0.100235,0.599059,0.400941,0.104025,0.5839,0.4161,0.098928,0.604286,0.395714,0.107423,0.570308,0.429692,0.097622,0.609514,0.390486,0.099712,0.60115,0.39885,0.113696,0.545217,0.454783,0.087297,0.65081,0.34919,0.080502,0.677993,0.322007,0.069132,0.723471,0.276529,0.060638,0.757449,0.242551,0.055018,0.779927,0.220073,0.049791,0.800836,0.199164,0.045086,0.819655,0.180345,0.040904,0.836383,0.163617,0.036069,0.855724,0.144276,0.031887,0.872452,0.127548,0.029535,0.881861,0.118139,0.030319,0.878725,0.121275,0.030711,0.877156,0.122844,0.031103,0.875588,0.124412,0.03241,0.870361,0.129639,0.032541,0.869838,0.130162,0.03241,0.870361,0.129639,0.031364,0.874543,0.125457,0.031495,0.87402,0.12598,0.032018,0.871929,0.128071,0.032018,0.871929,0.128071,0.032018,0.871929,0.128071,0.032148,0.871406,0.128594,0.032541,0.869838,0.130162,0.033063,0.867747,0.132253,0.033847,0.864611,0.135389,0.034762,0.860951,0.139049,0.034239,0.863042,0.136958,0.033455,0.866179,0.133821,0.033717,0.865133,0.134867,0.035154,0.859383,0.140617,0.037899,0.848406,0.151594,0.038291,0.846837,0.153163,0.04012,0.839519,0.160481,0.040382,0.838474,0.161526,0.039728,0.841087,0.158913,0.034109,0.863565,0.136435,0.036592,0.853633,0.146367,0.039205,0.843178,0.156822,0.044564,0.821746,0.178254,0.048353,0.806587,0.193413,0.049791,0.800836,0.199164,0.049922,0.800314,0.199686,0.053319,0.786722,0.213278,0.056587,0.773654,0.226346,0.057893,0.768427,0.231573,0.050575,0.7977,0.2023,0.050706,0.797177,0.202823,0.055541,0.777836,0.222164,0.057763,0.768949,0.231051,0.057632,0.769472,0.230528,0.057893,0.768427,0.231573,0.051228,0.795086,0.204914,0.049922,0.800314,0.199686,0.050444,0.798223,0.201777,0.050052,0.799791,0.200209,0.04966,0.801359,0.198641,0.050444,0.798223,0.201777,0.05528,0.778881,0.221119,0.049922,0.800314,0.199686,0.049922,0.800314,0.199686,0.049922,0.800314,0.199686,0.049922,0.800314,0.199686,0.047961,0.808155,0.191845,0.04391,0.82436,0.17564,0.04195,0.832201,0.167799,0.041427,0.834292,0.165708,0.041035,0.83586,0.16414};
			return value;
		}
		private double[] getColor_6_24_color_65()
		{
			double[] value = {0.089519,0.641924,0.358076,0.118139,0.527444,0.472556,0.10886,0.564558,0.435442,0.105985,0.576059,0.423941,0.119577,0.521694,0.478306,0.107162,0.571354,0.428646,0.117878,0.528489,0.471511,0.112258,0.550967,0.449033,0.121275,0.514898,0.485102,0.098275,0.6069,0.3931,0.133952,0.464192,0.535808,0.101281,0.594877,0.405123,0.085991,0.656038,0.343962,0.090434,0.638265,0.361735,0.073706,0.705175,0.294825,0.062729,0.749085,0.250915,0.057109,0.771563,0.228437,0.052013,0.79195,0.20805,0.046654,0.813382,0.186618,0.041558,0.833769,0.166231,0.036984,0.852065,0.147935,0.03241,0.870361,0.129639,0.029665,0.881338,0.118662,0.029927,0.880293,0.119707,0.030058,0.87977,0.12023,0.029927,0.880293,0.119707,0.030842,0.876634,0.123366,0.030972,0.876111,0.123889,0.031103,0.875588,0.124412,0.030711,0.877156,0.122844,0.031234,0.875065,0.124935,0.032018,0.871929,0.128071,0.031887,0.872452,0.127548,0.032018,0.871929,0.128071,0.032279,0.870883,0.129117,0.032933,0.86827,0.13173,0.033586,0.865656,0.134344,0.034109,0.863565,0.136435,0.034109,0.863565,0.136435,0.033978,0.864088,0.135912,0.033978,0.864088,0.135912,0.035416,0.858338,0.141662,0.037637,0.849451,0.150549,0.041296,0.834814,0.165186,0.043257,0.826973,0.173027,0.044564,0.821746,0.178254,0.044564,0.821746,0.178254,0.04195,0.832201,0.167799,0.041819,0.832723,0.167277,0.043126,0.827496,0.172504,0.052013,0.79195,0.20805,0.054104,0.783586,0.216414,0.052405,0.790382,0.209618,0.064036,0.743858,0.256142,0.058285,0.766858,0.233142,0.064036,0.743858,0.256142,0.058024,0.767904,0.232096,0.070962,0.716153,0.283847,0.064036,0.743858,0.256142,0.062467,0.750131,0.249869,0.061945,0.752222,0.247778,0.066649,0.733403,0.266597,0.063513,0.745949,0.254051,0.063382,0.746472,0.253528,0.057893,0.768427,0.231573,0.057893,0.768427,0.231573,0.05541,0.778359,0.221641,0.056848,0.772608,0.227392,0.057893,0.768427,0.231573,0.056848,0.772608,0.227392,0.052013,0.79195,0.20805,0.049922,0.800314,0.199686,0.049922,0.800314,0.199686,0.050183,0.799268,0.200732,0.047177,0.811291,0.188709,0.049922,0.800314,0.199686,0.048092,0.807632,0.192368,0.045609,0.817564,0.182436,0.042081,0.831678,0.168322,0.04195,0.832201,0.167799,0.101934,0.592263,0.407737,0.081809,0.672765,0.327235,0.081809,0.672765,0.327235,0.091741,0.633037,0.366963,0.134213,0.463147,0.536853,0.1316,0.473602,0.526398,0.133168,0.467329,0.532671,0.12977,0.48092,0.51908,0.107946,0.568217,0.431783,0.101411,0.594354,0.405646,0.099712,0.60115,0.39885,0.087559,0.649765,0.350235,0.08011,0.679561,0.320439,0.077235,0.691061,0.308939,0.069132,0.723471,0.276529,0.064166,0.743335,0.256665,0.057763,0.768949,0.231051,0.052535,0.789859,0.210141,0.047177,0.811291,0.188709,0.04195,0.832201,0.167799};
			return value;
		}
		private double[] getColor_6_24_color_66()
		{
			double[] value = {0.037637,0.849451,0.150549,0.033455,0.866179,0.133821,0.030319,0.878725,0.121275,0.029535,0.881861,0.118139,0.029796,0.880815,0.119185,0.030058,0.87977,0.12023,0.030058,0.87977,0.12023,0.03045,0.878202,0.121798,0.03045,0.878202,0.121798,0.030711,0.877156,0.122844,0.030972,0.876111,0.123889,0.031364,0.874543,0.125457,0.031626,0.873497,0.126503,0.031887,0.872452,0.127548,0.032018,0.871929,0.128071,0.032671,0.869315,0.130685,0.033455,0.866179,0.133821,0.034109,0.863565,0.136435,0.034239,0.863042,0.136958,0.034631,0.861474,0.138526,0.034631,0.861474,0.138526,0.038029,0.847883,0.152117,0.041296,0.834814,0.165186,0.045086,0.819655,0.180345,0.048092,0.807632,0.192368,0.049922,0.800314,0.199686,0.04953,0.801882,0.198118,0.045348,0.81861,0.18139,0.042211,0.831155,0.168845,0.042211,0.831155,0.168845,0.04953,0.801882,0.198118,0.057763,0.768949,0.231051,0.057893,0.768427,0.231573,0.058155,0.767381,0.232619,0.065734,0.737062,0.262938,0.065604,0.737585,0.262415,0.058416,0.766336,0.233664,0.065865,0.736539,0.263461,0.067041,0.731835,0.268165,0.07828,0.686879,0.313121,0.071746,0.713016,0.286984,0.074621,0.701516,0.298484,0.07253,0.70988,0.29012,0.062467,0.750131,0.249869,0.058677,0.76529,0.23471,0.06103,0.755881,0.244119,0.057893,0.768427,0.231573,0.057893,0.768427,0.231573,0.062337,0.750653,0.249347,0.058024,0.767904,0.232096,0.056717,0.773131,0.226869,0.050575,0.7977,0.2023,0.049922,0.800314,0.199686,0.053842,0.784631,0.215369,0.048223,0.807109,0.192891,0.050575,0.7977,0.2023,0.049922,0.800314,0.199686,0.047308,0.810768,0.189232,0.04574,0.817041,0.182959,0.043649,0.825405,0.174595,0.079326,0.682697,0.317303,0.073837,0.704652,0.295348,0.073445,0.706221,0.293779,0.078803,0.684788,0.315212,0.08978,0.640878,0.359122,0.103894,0.584422,0.415578,0.127418,0.490329,0.509671,0.100497,0.598014,0.401986,0.103764,0.584945,0.415055,0.105593,0.577627,0.422373,0.097883,0.608468,0.391532,0.091741,0.633037,0.366963,0.088082,0.647674,0.352326,0.08403,0.663879,0.336121,0.073837,0.704652,0.295348,0.066127,0.735494,0.264506,0.058939,0.764245,0.235755,0.052797,0.788813,0.211187,0.047177,0.811291,0.188709,0.04195,0.832201,0.167799,0.037768,0.848928,0.151072,0.033847,0.864611,0.135389,0.031364,0.874543,0.125457,0.029665,0.881338,0.118662,0.029404,0.882384,0.117616,0.029665,0.881338,0.118662,0.030058,0.87977,0.12023,0.029927,0.880293,0.119707,0.030319,0.878725,0.121275,0.030842,0.876634,0.123366,0.030972,0.876111,0.123889,0.031234,0.875065,0.124935,0.031495,0.87402,0.12598,0.031756,0.872974,0.127026,0.031887,0.872452,0.127548,0.032018,0.871929,0.128071,0.032802,0.868792,0.131208,0.033717,0.865133,0.134867,0.034109,0.863565,0.136435,0.034631,0.861474,0.138526};
			return value;
		}
		private double[] getColor_6_24_color_67()
		{
			double[] value = {0.034893,0.860429,0.139571,0.037114,0.851542,0.148458,0.04195,0.832201,0.167799,0.048092,0.807632,0.192368,0.054757,0.780972,0.219028,0.054757,0.780972,0.219028,0.056456,0.774177,0.225823,0.049922,0.800314,0.199686,0.045478,0.818087,0.181913,0.043518,0.825928,0.174072,0.046132,0.815473,0.184527,0.050444,0.798223,0.201777,0.055541,0.777836,0.222164,0.062467,0.750131,0.249869,0.071354,0.714584,0.285416,0.069916,0.720335,0.279665,0.065473,0.738108,0.261892,0.067303,0.730789,0.269211,0.06874,0.725039,0.274961,0.073968,0.70413,0.29587,0.073837,0.704652,0.295348,0.073837,0.704652,0.295348,0.075666,0.697334,0.302666,0.065734,0.737062,0.262938,0.065734,0.737062,0.262938,0.065734,0.737062,0.262938,0.064166,0.743335,0.256665,0.060376,0.758495,0.241505,0.065342,0.73863,0.26137,0.057893,0.768427,0.231573,0.055149,0.779404,0.220596,0.057893,0.768427,0.231573,0.056587,0.773654,0.226346,0.052405,0.790382,0.209618,0.053842,0.784631,0.215369,0.052535,0.789859,0.210141,0.051098,0.795609,0.204391,0.04953,0.801882,0.198118,0.046654,0.813382,0.186618,0.045086,0.819655,0.180345,0.067303,0.730789,0.269211,0.065865,0.736539,0.263461,0.06495,0.740199,0.259801,0.090173,0.63931,0.36069,0.084945,0.66022,0.33978,0.086252,0.654992,0.345008,0.092394,0.630423,0.369577,0.100105,0.599582,0.400418,0.118008,0.527967,0.472033,0.128202,0.487193,0.512807,0.103894,0.584422,0.415578,0.097752,0.608991,0.391009,0.109514,0.561945,0.438055,0.100366,0.598536,0.401464,0.079456,0.682175,0.317825,0.066519,0.733926,0.266074,0.059592,0.761631,0.238369,0.05345,0.7862,0.2138,0.047439,0.810246,0.189754,0.04195,0.832201,0.167799,0.038683,0.845269,0.154731,0.035285,0.85886,0.14114,0.03241,0.870361,0.129639,0.029927,0.880293,0.119707,0.029404,0.882384,0.117616,0.029665,0.881338,0.118662,0.030058,0.87977,0.12023,0.029927,0.880293,0.119707,0.030319,0.878725,0.121275,0.030842,0.876634,0.123366,0.031103,0.875588,0.124412,0.031234,0.875065,0.124935,0.031234,0.875065,0.124935,0.031495,0.87402,0.12598,0.031756,0.872974,0.127026,0.032148,0.871406,0.128594,0.032933,0.86827,0.13173,0.033717,0.865133,0.134867,0.033978,0.864088,0.135912,0.033978,0.864088,0.135912,0.034109,0.863565,0.136435,0.037637,0.849451,0.150549,0.042603,0.829587,0.170413,0.049791,0.800836,0.199164,0.049922,0.800314,0.199686,0.050836,0.796654,0.203346,0.049137,0.80345,0.19655,0.046393,0.814428,0.185572,0.046001,0.815996,0.184004,0.046001,0.815996,0.184004,0.048223,0.807109,0.192891,0.049922,0.800314,0.199686,0.053973,0.784109,0.215891,0.058416,0.766336,0.233664,0.065996,0.736017,0.263983,0.069394,0.722426,0.277574,0.071746,0.713016,0.286984,0.073183,0.707266,0.292734,0.072269,0.710925,0.289075,0.073837,0.704652,0.295348};
			return value;
		}
		private double[] getColor_6_24_color_68()
		{
			double[] value = {0.081678,0.673288,0.326712,0.081155,0.675379,0.324621,0.073837,0.704652,0.295348,0.071877,0.712493,0.287507,0.065865,0.736539,0.263461,0.072791,0.708834,0.291166,0.066127,0.735494,0.264506,0.066257,0.734971,0.265029,0.065865,0.736539,0.263461,0.058808,0.764767,0.235233,0.058024,0.767904,0.232096,0.058285,0.766858,0.233142,0.057371,0.770518,0.229482,0.057763,0.768949,0.231051,0.053973,0.784109,0.215891,0.052405,0.790382,0.209618,0.050967,0.796132,0.203868,0.04966,0.801359,0.198641,0.047308,0.810768,0.189232,0.046001,0.815996,0.184004,0.058285,0.766858,0.233142,0.078019,0.687925,0.312075,0.069524,0.721903,0.278097,0.102196,0.591218,0.408782,0.091349,0.634605,0.365395,0.087559,0.649765,0.350235,0.089388,0.642446,0.357554,0.125719,0.497125,0.502875,0.113434,0.546262,0.453738,0.08586,0.65656,0.34344,0.096576,0.613696,0.386304,0.09344,0.626242,0.373758,0.089258,0.642969,0.357031,0.085991,0.656038,0.343962,0.087428,0.650288,0.349712,0.075536,0.697857,0.302143,0.067825,0.728698,0.271302,0.054496,0.782018,0.217982,0.048223,0.807109,0.192891,0.042734,0.829064,0.170936,0.039597,0.84161,0.15839,0.036069,0.855724,0.144276,0.032802,0.868792,0.131208,0.029927,0.880293,0.119707,0.029796,0.880815,0.119185,0.029796,0.880815,0.119185,0.030058,0.87977,0.12023,0.030058,0.87977,0.12023,0.030058,0.87977,0.12023,0.030711,0.877156,0.122844,0.031364,0.874543,0.125457,0.030972,0.876111,0.123889,0.030842,0.876634,0.123366,0.030972,0.876111,0.123889,0.031495,0.87402,0.12598,0.032148,0.871406,0.128594,0.033194,0.867224,0.132776,0.033978,0.864088,0.135912,0.033978,0.864088,0.135912,0.033978,0.864088,0.135912,0.033063,0.867747,0.132253,0.037245,0.851019,0.148981,0.041296,0.834814,0.165186,0.044433,0.822269,0.177731,0.04587,0.816519,0.183481,0.048876,0.804496,0.195504,0.046132,0.815473,0.184527,0.044433,0.822269,0.177731,0.044433,0.822269,0.177731,0.045478,0.818087,0.181913,0.047831,0.808677,0.191323,0.050575,0.7977,0.2023,0.053842,0.784631,0.215369,0.059723,0.761108,0.238892,0.064297,0.742812,0.257188,0.066388,0.734449,0.265551,0.072791,0.708834,0.291166,0.067564,0.729744,0.270256,0.072399,0.710403,0.289597,0.076973,0.692107,0.307893,0.083638,0.665447,0.334553,0.093178,0.627287,0.372713,0.075928,0.696289,0.303711,0.07828,0.686879,0.313121,0.081678,0.673288,0.326712,0.080894,0.676424,0.323576,0.079064,0.683743,0.316257,0.072269,0.710925,0.289075,0.065865,0.736539,0.263461,0.065865,0.736539,0.263461,0.065734,0.737062,0.262938,0.061422,0.754313,0.245687,0.059723,0.761108,0.238892,0.058285,0.766858,0.233142,0.056325,0.774699,0.225301,0.054104,0.783586,0.216414,0.051882,0.792473,0.207527,0.049791,0.800836,0.199164,0.048353,0.806587,0.193413,0.049399,0.802405,0.197595};
			return value;
		}
		private double[] getColor_6_24_color_69()
		{
			double[] value = {0.082854,0.668583,0.331417,0.050706,0.797177,0.202823,0.084814,0.660742,0.339258,0.081286,0.674856,0.325144,0.123889,0.504443,0.495557,0.064428,0.74229,0.25771,0.074098,0.703607,0.296393,0.07057,0.717721,0.282279,0.074621,0.701516,0.298484,0.093178,0.627287,0.372713,0.100758,0.596968,0.403032,0.100105,0.599582,0.400418,0.084422,0.662311,0.337689,0.076581,0.693675,0.306325,0.071746,0.713016,0.286984,0.065865,0.736539,0.263461,0.058939,0.764245,0.235755,0.055802,0.77679,0.22321,0.04953,0.801882,0.198118,0.044956,0.820178,0.179822,0.040512,0.837951,0.162049,0.036853,0.852588,0.147412,0.033194,0.867224,0.132776,0.03045,0.878202,0.121798,0.029535,0.881861,0.118139,0.029665,0.881338,0.118662,0.030058,0.87977,0.12023,0.030058,0.87977,0.12023,0.030058,0.87977,0.12023,0.03045,0.878202,0.121798,0.030972,0.876111,0.123889,0.031234,0.875065,0.124935,0.030842,0.876634,0.123366,0.03045,0.878202,0.121798,0.03058,0.877679,0.122321,0.031364,0.874543,0.125457,0.032148,0.871406,0.128594,0.032802,0.868792,0.131208,0.033325,0.866702,0.133298,0.033978,0.864088,0.135912,0.033978,0.864088,0.135912,0.035677,0.857292,0.142708,0.037899,0.848406,0.151594,0.041558,0.833769,0.166231,0.043779,0.824882,0.175118,0.042603,0.829587,0.170413,0.04195,0.832201,0.167799,0.041688,0.833246,0.166754,0.04195,0.832201,0.167799,0.044825,0.8207,0.1793,0.047439,0.810246,0.189754,0.050052,0.799791,0.200209,0.053058,0.787768,0.212232,0.056717,0.773131,0.226869,0.062598,0.749608,0.250392,0.074752,0.700993,0.299007,0.082462,0.670152,0.329848,0.065865,0.736539,0.263461,0.070962,0.716153,0.283847,0.073837,0.704652,0.295348,0.079718,0.681129,0.318871,0.081809,0.672765,0.327235,0.081286,0.674856,0.325144,0.07828,0.686879,0.313121,0.081547,0.673811,0.326189,0.081678,0.673288,0.326712,0.078019,0.687925,0.312075,0.073837,0.704652,0.295348,0.069132,0.723471,0.276529,0.065865,0.736539,0.263461,0.065996,0.736017,0.263983,0.065734,0.737062,0.262938,0.062598,0.749608,0.250392,0.06116,0.755358,0.244642,0.058416,0.766336,0.233664,0.055802,0.77679,0.22321,0.05345,0.7862,0.2138,0.051098,0.795609,0.204391,0.049922,0.800314,0.199686,0.046132,0.815473,0.184527,0.072922,0.708312,0.291688,0.05345,0.7862,0.2138,0.073183,0.707266,0.292734,0.066257,0.734971,0.265029,0.101673,0.593309,0.406691,0.062337,0.750653,0.249347,0.062206,0.751176,0.248824,0.06861,0.725562,0.274438,0.101803,0.592786,0.407214,0.125065,0.499739,0.500261,0.097622,0.609514,0.390486,0.121406,0.514375,0.485625,0.107292,0.570831,0.429169,0.08586,0.65656,0.34344,0.07815,0.687402,0.312598,0.065734,0.737062,0.262938,0.057501,0.769995,0.230005,0.053058,0.787768,0.212232,0.04966,0.801359,0.198641,0.045348,0.81861,0.18139};
			return value;
		}
		private double[] getColor_6_24_color_70()
		{
			double[] value = {0.041296,0.834814,0.165186,0.037376,0.850497,0.149503,0.033847,0.864611,0.135389,0.031364,0.874543,0.125457,0.029665,0.881338,0.118662,0.02862,0.88552,0.11448,0.029012,0.883952,0.116048,0.029665,0.881338,0.118662,0.030058,0.87977,0.12023,0.030188,0.879247,0.120753,0.030319,0.878725,0.121275,0.030972,0.876111,0.123889,0.03045,0.878202,0.121798,0.030188,0.879247,0.120753,0.030058,0.87977,0.12023,0.030842,0.876634,0.123366,0.031626,0.873497,0.126503,0.032279,0.870883,0.129117,0.032671,0.869315,0.130685,0.033194,0.867224,0.132776,0.033717,0.865133,0.134867,0.033978,0.864088,0.135912,0.036069,0.855724,0.144276,0.037899,0.848406,0.151594,0.039336,0.842656,0.157344,0.039205,0.843178,0.156822,0.039597,0.84161,0.15839,0.040512,0.837951,0.162049,0.042211,0.831155,0.168845,0.044825,0.8207,0.1793,0.047047,0.811814,0.188186,0.049268,0.802927,0.197073,0.051751,0.792995,0.207005,0.054757,0.780972,0.219028,0.057763,0.768949,0.231051,0.063513,0.745949,0.254051,0.063643,0.745426,0.254574,0.065342,0.73863,0.26137,0.067825,0.728698,0.271302,0.073053,0.707789,0.292211,0.07815,0.687402,0.312598,0.08403,0.663879,0.336121,0.094877,0.620491,0.379509,0.095531,0.617878,0.382122,0.08965,0.641401,0.358599,0.083769,0.664924,0.335076,0.082723,0.669106,0.330894,0.082331,0.670674,0.329326,0.072791,0.708834,0.291166,0.073837,0.704652,0.295348,0.073837,0.704652,0.295348,0.079848,0.680606,0.319394,0.067433,0.730267,0.269733,0.064558,0.741767,0.258233,0.06103,0.755881,0.244119,0.057371,0.770518,0.229482,0.055802,0.77679,0.22321,0.053058,0.787768,0.212232,0.050575,0.7977,0.2023,0.048223,0.807109,0.192891,0.093832,0.624673,0.375327,0.047961,0.808155,0.191845,0.038813,0.844746,0.155254,0.045217,0.819132,0.180868,0.070962,0.716153,0.283847,0.081025,0.675902,0.324098,0.057109,0.771563,0.228437,0.097491,0.610037,0.389963,0.106769,0.572922,0.427078,0.105201,0.579195,0.420805,0.09357,0.625719,0.374281,0.094093,0.623628,0.376372,0.097229,0.611082,0.388918,0.092002,0.631992,0.368008,0.074098,0.703607,0.296393,0.068217,0.72713,0.27287,0.060768,0.756926,0.243074,0.057371,0.770518,0.229482,0.050967,0.796132,0.203868,0.045348,0.81861,0.18139,0.040774,0.836905,0.163095,0.037114,0.851542,0.148458,0.033978,0.864088,0.135912,0.032018,0.871929,0.128071,0.030188,0.879247,0.120753,0.026529,0.893884,0.106116,0.026529,0.893884,0.106116,0.029273,0.882906,0.117094,0.030058,0.87977,0.12023,0.030058,0.87977,0.12023,0.030058,0.87977,0.12023,0.030058,0.87977,0.12023,0.029927,0.880293,0.119707,0.029796,0.880815,0.119185,0.030058,0.87977,0.12023,0.03058,0.877679,0.122321,0.031495,0.87402,0.12598,0.032279,0.870883,0.129117,0.032802,0.868792,0.131208,0.033325,0.866702,0.133298};
			return value;
		}
		private double[] getColor_6_24_color_71()
		{
			double[] value = {0.033717,0.865133,0.134867,0.034239,0.863042,0.136958,0.035416,0.858338,0.141662,0.03633,0.854679,0.145321,0.037245,0.851019,0.148981,0.038029,0.847883,0.152117,0.039467,0.842133,0.157867,0.040643,0.837428,0.162572,0.042473,0.83011,0.16989,0.044956,0.820178,0.179822,0.046916,0.812337,0.187663,0.048876,0.804496,0.195504,0.050967,0.796132,0.203868,0.053581,0.785677,0.214323,0.057109,0.771563,0.228437,0.059331,0.762676,0.237324,0.06299,0.74804,0.25196,0.065734,0.737062,0.262938,0.072007,0.711971,0.288029,0.076843,0.692629,0.307371,0.084684,0.661265,0.338735,0.090173,0.63931,0.36069,0.092917,0.628332,0.371668,0.108599,0.565604,0.434396,0.11644,0.534239,0.465761,0.096184,0.615264,0.384736,0.089519,0.641924,0.358076,0.082985,0.668061,0.331939,0.073968,0.70413,0.29587,0.07436,0.702561,0.297439,0.07436,0.702561,0.297439,0.081155,0.675379,0.324621,0.093962,0.624151,0.375849,0.076843,0.692629,0.307371,0.064558,0.741767,0.258233,0.060507,0.757972,0.242028,0.058155,0.767381,0.232619,0.056064,0.775745,0.224255,0.052927,0.788291,0.211709,0.049922,0.800314,0.199686,0.087951,0.648197,0.351803,0.066127,0.735494,0.264506,0.031234,0.875065,0.124935,0.04587,0.816519,0.183481,0.058677,0.76529,0.23471,0.043779,0.824882,0.175118,0.045086,0.819655,0.180345,0.07828,0.686879,0.313121,0.103372,0.586513,0.413487,0.110951,0.556194,0.443806,0.09344,0.626242,0.373758,0.076059,0.695766,0.304234,0.083377,0.666492,0.333508,0.097229,0.611082,0.388918,0.091479,0.634083,0.365917,0.071746,0.713016,0.286984,0.065865,0.736539,0.263461,0.065996,0.736017,0.263983,0.05345,0.7862,0.2138,0.046262,0.81495,0.18505,0.041558,0.833769,0.166231,0.038029,0.847883,0.152117,0.034631,0.861474,0.138526,0.032541,0.869838,0.130162,0.030842,0.876634,0.123366,0.026137,0.895452,0.104548,0.026137,0.895452,0.104548,0.026398,0.894407,0.105593,0.028881,0.884475,0.115525,0.030058,0.87977,0.12023,0.029404,0.882384,0.117616,0.029535,0.881861,0.118139,0.029665,0.881338,0.118662,0.029796,0.880815,0.119185,0.029927,0.880293,0.119707,0.03058,0.877679,0.122321,0.031364,0.874543,0.125457,0.032279,0.870883,0.129117,0.032671,0.869315,0.130685,0.033063,0.867747,0.132253,0.033717,0.865133,0.134867,0.034109,0.863565,0.136435,0.035024,0.859906,0.140094,0.036069,0.855724,0.144276,0.037376,0.850497,0.149503,0.038291,0.846837,0.153163,0.039336,0.842656,0.157344,0.040643,0.837428,0.162572,0.042342,0.830633,0.169367,0.044171,0.823314,0.176686,0.046262,0.81495,0.18505,0.047961,0.808155,0.191845,0.049922,0.800314,0.199686,0.053189,0.787245,0.212755,0.057371,0.770518,0.229482,0.060246,0.759017,0.240983,0.064558,0.741767,0.258233,0.065865,0.736539,0.263461,0.073314,0.706743,0.293257,0.079848,0.680606,0.319394};
			return value;
		}
		private double[] getColor_6_24_color_72()
		{
			double[] value = {0.085206,0.659174,0.340826,0.086383,0.654469,0.345531,0.08978,0.640878,0.359122,0.100889,0.596445,0.403555,0.105593,0.577627,0.422373,0.096315,0.614741,0.385259,0.089519,0.641924,0.358076,0.081809,0.672765,0.327235,0.081547,0.673811,0.326189,0.08011,0.679561,0.320439,0.074752,0.700993,0.299007,0.081809,0.672765,0.327235,0.086513,0.653947,0.346053,0.08207,0.67172,0.32828,0.105201,0.579195,0.420805,0.07436,0.702561,0.297439,0.064428,0.74229,0.25771,0.059592,0.761631,0.238369,0.055541,0.777836,0.222164,0.052535,0.789859,0.210141,0.061422,0.754313,0.245687,0.045609,0.817564,0.182436,0.05724,0.77104,0.22896,0.064036,0.743858,0.256142,0.061553,0.75379,0.24621,0.045086,0.819655,0.180345,0.039205,0.843178,0.156822,0.050706,0.797177,0.202823,0.069916,0.720335,0.279665,0.115003,0.53999,0.46001,0.067695,0.729221,0.270779,0.109775,0.560899,0.439101,0.116963,0.532148,0.467852,0.108991,0.564036,0.435964,0.082201,0.671197,0.328803,0.069655,0.72138,0.27862,0.061291,0.754835,0.245165,0.056064,0.775745,0.224255,0.053711,0.785154,0.214846,0.047961,0.808155,0.191845,0.042603,0.829587,0.170413,0.039075,0.843701,0.156299,0.035677,0.857292,0.142708,0.033325,0.866702,0.133298,0.031234,0.875065,0.124935,0.028489,0.886043,0.113957,0.026006,0.895975,0.104025,0.026006,0.895975,0.104025,0.027705,0.889179,0.110821,0.028489,0.886043,0.113957,0.028881,0.884475,0.115525,0.029273,0.882906,0.117094,0.029404,0.882384,0.117616,0.029535,0.881861,0.118139,0.029927,0.880293,0.119707,0.03045,0.878202,0.121798,0.031234,0.875065,0.124935,0.032018,0.871929,0.128071,0.03241,0.870361,0.129639,0.033063,0.867747,0.132253,0.033586,0.865656,0.134344,0.034109,0.863565,0.136435,0.035154,0.859383,0.140617,0.03633,0.854679,0.145321,0.037768,0.848928,0.151072,0.038552,0.845792,0.154208,0.039336,0.842656,0.157344,0.040251,0.838996,0.161004,0.04195,0.832201,0.167799,0.043649,0.825405,0.174595,0.04587,0.816519,0.183481,0.047308,0.810768,0.189232,0.049007,0.803973,0.196027,0.052274,0.790904,0.209096,0.057632,0.769472,0.230528,0.060376,0.758495,0.241505,0.065342,0.73863,0.26137,0.071615,0.713539,0.286461,0.073445,0.706221,0.293779,0.07815,0.687402,0.312598,0.079718,0.681129,0.318871,0.08965,0.641401,0.358599,0.097622,0.609514,0.390486,0.104548,0.581809,0.418191,0.105724,0.577104,0.422896,0.113304,0.546785,0.453215,0.087559,0.649765,0.350235,0.08978,0.640878,0.359122,0.087689,0.649242,0.350758,0.085206,0.659174,0.340826,0.081286,0.674856,0.325144,0.081809,0.672765,0.327235,0.093701,0.625196,0.374804,0.108599,0.565604,0.434396,0.101803,0.592786,0.407214,0.088996,0.644015,0.355985,0.079326,0.682697,0.317303,0.066649,0.733403,0.266597,0.058155,0.767381,0.232619,0.055672,0.777313,0.222687};
			return value;
		}
		private double[] getColor_6_24_color_73()
		{
			double[] value = {0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.022739,0.909043,0.090957,0.025353,0.898589,0.101411,0.030319,0.878725,0.121275,0.052405,0.790382,0.209618,0.073576,0.705698,0.294302,0.050183,0.799268,0.200732,0.12023,0.51908,0.48092,0.11265,0.549399,0.450601,0.095008,0.619969,0.380031,0.082593,0.669629,0.330371,0.072399,0.710403,0.289597,0.063121,0.747517,0.252483,0.057632,0.769472,0.230528,0.052143,0.791427,0.208573,0.049791,0.800836,0.199164,0.042603,0.829587,0.170413,0.039859,0.840565,0.159435,0.036722,0.85311,0.14689,0.033978,0.864088,0.135912,0.031626,0.873497,0.126503,0.029535,0.881861,0.118139,0.026006,0.895975,0.104025,0.025484,0.898066,0.101934,0.026268,0.894929,0.105071,0.028751,0.884997,0.115003,0.029273,0.882906,0.117094,0.029273,0.882906,0.117094,0.029404,0.882384,0.117616,0.029535,0.881861,0.118139,0.029665,0.881338,0.118662,0.030188,0.879247,0.120753,0.030842,0.876634,0.123366,0.031364,0.874543,0.125457,0.032279,0.870883,0.129117,0.032802,0.868792,0.131208,0.033455,0.866179,0.133821,0.034239,0.863042,0.136958,0.035546,0.857815,0.142185,0.036722,0.85311,0.14689,0.037899,0.848406,0.151594,0.038683,0.845269,0.154731,0.039336,0.842656,0.157344,0.039859,0.840565,0.159435,0.041166,0.835337,0.164663,0.042734,0.829064,0.170936,0.044433,0.822269,0.177731,0.046001,0.815996,0.184004,0.049399,0.802405,0.197595,0.055802,0.77679,0.22321,0.059854,0.760585,0.239415,0.064166,0.743335,0.256665,0.071877,0.712493,0.287507,0.076581,0.693675,0.306325,0.081678,0.673288,0.326712,0.085337,0.658651,0.341349,0.090303,0.638787,0.361213,0.090042,0.639833,0.360167,0.105463,0.57815,0.42185,0.111605,0.553581,0.446419,0.111605,0.553581,0.446419,0.092917,0.628332,0.371668,0.08965,0.641401,0.358599,0.090042,0.639833,0.360167,0.089911,0.640355,0.359645,0.081678,0.673288,0.326712,0.088866,0.644537,0.355463,0.083246,0.667015,0.332985,0.089258,0.642969,0.357031,0.093048,0.62781,0.37219,0.103502,0.585991,0.414009,0.121668,0.51333,0.48667,0.127156,0.491375,0.508625,0.093048,0.62781,0.37219,0.067041,0.731835,0.268165,0.060115,0.75954,0.24046,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.023785,0.904861,0.095139,0.031887,0.872452,0.127548,0.045348,0.81861,0.18139,0.060899,0.756404,0.243596,0.079326,0.682697,0.317303,0.136435,0.45426,0.54574,0.114611,0.541558,0.458442,0.111343,0.554626,0.445374,0.074098,0.703607,0.296393,0.063905,0.744381,0.255619,0.057893,0.768427,0.231573,0.050314,0.798745,0.201255,0.047047,0.811814,0.188186};
			return value;
		}
		private double[] getColor_6_24_color_74()
		{
			double[] value = {0.04391,0.82436,0.17564,0.040774,0.836905,0.163095,0.038552,0.845792,0.154208,0.033978,0.864088,0.135912,0.032541,0.869838,0.130162,0.031103,0.875588,0.124412,0.027182,0.89127,0.10873,0.026006,0.895975,0.104025,0.026137,0.895452,0.104548,0.027182,0.89127,0.10873,0.027574,0.889702,0.110298,0.027967,0.888134,0.111866,0.02862,0.88552,0.11448,0.029273,0.882906,0.117094,0.029665,0.881338,0.118662,0.029927,0.880293,0.119707,0.03045,0.878202,0.121798,0.031364,0.874543,0.125457,0.032148,0.871406,0.128594,0.032933,0.86827,0.13173,0.033847,0.864611,0.135389,0.034762,0.860951,0.139049,0.035938,0.856247,0.143753,0.037376,0.850497,0.149503,0.038552,0.845792,0.154208,0.039336,0.842656,0.157344,0.039728,0.841087,0.158913,0.04012,0.839519,0.160481,0.040774,0.836905,0.163095,0.041819,0.832723,0.167277,0.044302,0.822791,0.177209,0.047177,0.811291,0.188709,0.049791,0.800836,0.199164,0.05528,0.778881,0.221119,0.06116,0.755358,0.244642,0.066649,0.733403,0.266597,0.073576,0.705698,0.294302,0.077888,0.688447,0.311553,0.088212,0.647151,0.352849,0.097752,0.608991,0.391009,0.099451,0.602196,0.397804,0.087036,0.651856,0.348144,0.080894,0.676424,0.323576,0.08586,0.65656,0.34344,0.084292,0.662833,0.337167,0.089388,0.642446,0.357554,0.087428,0.650288,0.349712,0.090042,0.639833,0.360167,0.089388,0.642446,0.357554,0.084553,0.661788,0.338212,0.08978,0.640878,0.359122,0.08978,0.640878,0.359122,0.097752,0.608991,0.391009,0.096837,0.61265,0.38735,0.097622,0.609514,0.390486,0.110037,0.559854,0.440146,0.117616,0.529535,0.470465,0.127418,0.490329,0.509671,0.082723,0.669106,0.330894,0.065212,0.739153,0.260847,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.025745,0.89702,0.10298,0.034109,0.863565,0.136435,0.047439,0.810246,0.189754,0.06874,0.725039,0.274961,0.10311,0.587559,0.412441,0.151333,0.394668,0.605332,0.099843,0.600627,0.399373,0.072922,0.708312,0.291688,0.06495,0.740199,0.259801,0.057893,0.768427,0.231573,0.064297,0.742812,0.257188,0.052143,0.791427,0.208573,0.046916,0.812337,0.187663,0.042342,0.830633,0.169367,0.042342,0.830633,0.169367,0.040774,0.836905,0.163095,0.036592,0.853633,0.146367,0.034762,0.860951,0.139049,0.032802,0.868792,0.131208,0.029927,0.880293,0.119707,0.027313,0.890748,0.109252,0.028751,0.884997,0.115003,0.028751,0.884997,0.115003,0.028881,0.884475,0.115525,0.029143,0.883429,0.116571,0.029143,0.883429,0.116571,0.029404,0.882384,0.117616,0.029927,0.880293,0.119707,0.03045,0.878202,0.121798,0.031495,0.87402,0.12598,0.033063,0.867747,0.132253,0.033586,0.865656,0.134344};
			return value;
		}
		private double[] getColor_6_24_color_75()
		{
			double[] value = {0.034501,0.861997,0.138003,0.035677,0.857292,0.142708,0.036722,0.85311,0.14689,0.037899,0.848406,0.151594,0.039336,0.842656,0.157344,0.04012,0.839519,0.160481,0.03999,0.840042,0.159958,0.040251,0.838996,0.161004,0.041035,0.83586,0.16414,0.04195,0.832201,0.167799,0.044956,0.820178,0.179822,0.049791,0.800836,0.199164,0.052013,0.79195,0.20805,0.054234,0.783063,0.216937,0.057632,0.769472,0.230528,0.060899,0.756404,0.243596,0.065212,0.739153,0.260847,0.073576,0.705698,0.294302,0.073576,0.705698,0.294302,0.079326,0.682697,0.317303,0.079064,0.683743,0.316257,0.073837,0.704652,0.295348,0.07436,0.702561,0.297439,0.076581,0.693675,0.306325,0.094485,0.62206,0.37794,0.100235,0.599059,0.400941,0.084553,0.661788,0.338212,0.085991,0.656038,0.343962,0.08978,0.640878,0.359122,0.089519,0.641924,0.358076,0.090042,0.639833,0.360167,0.090173,0.63931,0.36069,0.093701,0.625196,0.374804,0.097752,0.608991,0.391009,0.104548,0.581809,0.418191,0.107423,0.570308,0.429692,0.114349,0.542603,0.457397,0.107292,0.570831,0.429169,0.08965,0.641401,0.358599,0.083377,0.666492,0.333508,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.029404,0.882384,0.117616,0.040643,0.837428,0.162572,0.062859,0.748562,0.251438,0.147804,0.408782,0.591218,0.156822,0.372713,0.627287,0.124151,0.503398,0.496602,0.099712,0.60115,0.39885,0.079195,0.68322,0.31678,0.052927,0.788291,0.211709,0.055541,0.777836,0.222164,0.057501,0.769995,0.230005,0.048353,0.806587,0.193413,0.052405,0.790382,0.209618,0.074098,0.703607,0.296393,0.078411,0.686357,0.313643,0.045217,0.819132,0.180868,0.040382,0.838474,0.161526,0.036592,0.853633,0.146367,0.033063,0.867747,0.132253,0.030972,0.876111,0.123889,0.030319,0.878725,0.121275,0.029927,0.880293,0.119707,0.029796,0.880815,0.119185,0.029927,0.880293,0.119707,0.029796,0.880815,0.119185,0.029796,0.880815,0.119185,0.030319,0.878725,0.121275,0.030972,0.876111,0.123889,0.03241,0.870361,0.129639,0.033847,0.864611,0.135389,0.034631,0.861474,0.138526,0.035677,0.857292,0.142708,0.036592,0.853633,0.146367,0.037637,0.849451,0.150549,0.039336,0.842656,0.157344,0.040512,0.837951,0.162049,0.04195,0.832201,0.167799,0.041427,0.834292,0.165708,0.041427,0.834292,0.165708,0.041688,0.833246,0.166754,0.042995,0.828019,0.171981,0.047308,0.810768,0.189232,0.04966,0.801359,0.198641,0.04966,0.801359,0.198641,0.051751,0.792995,0.207005,0.053842,0.784631,0.215369,0.05724,0.77104,0.22896,0.060115,0.75954,0.24046,0.063382,0.746472,0.253528,0.065865,0.736539,0.263461,0.070178,0.719289,0.280711};
			return value;
		}
		private double[] getColor_6_24_color_76()
		{
			double[] value = {0.071354,0.714584,0.285416,0.070178,0.719289,0.280711,0.073706,0.705175,0.294825,0.087428,0.650288,0.349712,0.089911,0.640355,0.359645,0.086644,0.653424,0.346576,0.087036,0.651856,0.348144,0.081809,0.672765,0.327235,0.085337,0.658651,0.341349,0.086121,0.655515,0.344485,0.08965,0.641401,0.358599,0.090826,0.636696,0.363304,0.098014,0.607946,0.392054,0.102849,0.588604,0.411396,0.104286,0.582854,0.417146,0.108207,0.567172,0.432828,0.10298,0.588082,0.411918,0.103894,0.584422,0.415578,0.095792,0.616832,0.383168,0.08782,0.648719,0.351281,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.032279,0.870883,0.129117,0.04966,0.801359,0.198641,0.088343,0.646628,0.353372,0.111997,0.552013,0.447987,0.114872,0.540512,0.459488,0.136043,0.455829,0.544171,0.073183,0.707266,0.292734,0.049791,0.800836,0.199164,0.051098,0.795609,0.204391,0.057371,0.770518,0.229482,0.05149,0.794041,0.205959,0.055149,0.779404,0.220596,0.074752,0.700993,0.299007,0.090434,0.638265,0.361735,0.058285,0.766858,0.233142,0.0477,0.8092,0.1908,0.042473,0.83011,0.16989,0.037507,0.849974,0.150026,0.033717,0.865133,0.134867,0.033063,0.867747,0.132253,0.032279,0.870883,0.129117,0.031756,0.872974,0.127026,0.031756,0.872974,0.127026,0.031626,0.873497,0.126503,0.031495,0.87402,0.12598,0.031626,0.873497,0.126503,0.032018,0.871929,0.128071,0.033586,0.865656,0.134344,0.035546,0.857815,0.142185,0.036853,0.852588,0.147412,0.037507,0.849974,0.150026,0.038421,0.846315,0.153685,0.039336,0.842656,0.157344,0.040643,0.837428,0.162572,0.041558,0.833769,0.166231,0.042473,0.83011,0.16989,0.043257,0.826973,0.173027,0.044041,0.823837,0.176163,0.044825,0.8207,0.1793,0.045609,0.817564,0.182436,0.046262,0.81495,0.18505,0.048223,0.807109,0.192891,0.049007,0.803973,0.196027,0.049791,0.800836,0.199164,0.052797,0.788813,0.211187,0.055802,0.77679,0.22321,0.05724,0.77104,0.22896,0.059984,0.760063,0.239937,0.062467,0.750131,0.249869,0.064166,0.743335,0.256665,0.065342,0.73863,0.26137,0.065865,0.736539,0.263461,0.067433,0.730267,0.269733,0.084422,0.662311,0.337689,0.087689,0.649242,0.350758,0.084684,0.661265,0.338735,0.076189,0.695243,0.304757,0.077365,0.690538,0.309462,0.08011,0.679561,0.320439,0.081809,0.672765,0.327235,0.089519,0.641924,0.358076,0.08978,0.640878,0.359122,0.094093,0.623628,0.376372,0.098798,0.604809,0.395191,0.098536,0.605855,0.394145,0.097622,0.609514,0.390486,0.097491,0.610037,0.389963,0.09736,0.610559,0.389441,0.087297,0.65081,0.34919,0.081809,0.672765,0.327235};
			return value;
		}
		private double[] getColor_6_24_color_77()
		{
			double[] value = {0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.023393,0.90643,0.09357,0.042473,0.83011,0.16989,0.073314,0.706743,0.293257,0.077496,0.690016,0.309984,0.079456,0.682175,0.317825,0.10886,0.564558,0.435442,0.061291,0.754835,0.245165,0.042473,0.83011,0.16989,0.050836,0.796654,0.203346,0.049922,0.800314,0.199686,0.05541,0.778359,0.221641,0.050444,0.798223,0.201777,0.054626,0.781495,0.218505,0.057632,0.769472,0.230528,0.07253,0.70988,0.29012,0.059592,0.761631,0.238369,0.05162,0.793518,0.206482,0.044171,0.823314,0.176686,0.038421,0.846315,0.153685,0.036461,0.854156,0.145844,0.035024,0.859906,0.140094,0.034762,0.860951,0.139049,0.034631,0.861474,0.138526,0.034501,0.861997,0.138003,0.033978,0.864088,0.135912,0.033978,0.864088,0.135912,0.034501,0.861997,0.138003,0.035808,0.856769,0.143231,0.037899,0.848406,0.151594,0.039205,0.843178,0.156822,0.04012,0.839519,0.160481,0.041296,0.834814,0.165186,0.041688,0.833246,0.166754,0.041819,0.832723,0.167277,0.043387,0.826451,0.173549,0.043779,0.824882,0.175118,0.044302,0.822791,0.177209,0.045086,0.819655,0.180345,0.045609,0.817564,0.182436,0.04587,0.816519,0.183481,0.046001,0.815996,0.184004,0.046654,0.813382,0.186618,0.048223,0.807109,0.192891,0.049791,0.800836,0.199164,0.051882,0.792473,0.207527,0.053973,0.784109,0.215891,0.055802,0.77679,0.22321,0.057501,0.769995,0.230005,0.059462,0.762154,0.237846,0.060376,0.758495,0.241505,0.061553,0.75379,0.24621,0.063251,0.746994,0.253006,0.064166,0.743335,0.256665,0.065865,0.736539,0.263461,0.071223,0.715107,0.284893,0.071485,0.714062,0.285938,0.072399,0.710403,0.289597,0.073053,0.707789,0.292211,0.075797,0.696811,0.303189,0.079326,0.682697,0.317303,0.083246,0.667015,0.332985,0.08782,0.648719,0.351281,0.091218,0.635128,0.364872,0.09357,0.625719,0.374281,0.092917,0.628332,0.371668,0.08978,0.640878,0.359122,0.08978,0.640878,0.359122,0.083638,0.665447,0.334553,0.081809,0.672765,0.327235,0.081678,0.673288,0.326712,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.023654,0.905384,0.094616,0.040643,0.837428,0.162572,0.043387,0.826451,0.173549,0.069524,0.721903,0.278097,0.05907,0.763722,0.236278,0.043779,0.824882,0.175118,0.04195,0.832201,0.167799,0.046001,0.815996,0.184004,0.055149,0.779404,0.220596};
			return value;
		}
		private double[] getColor_6_24_color_78()
		{
			double[] value = {0.057893,0.768427,0.231573,0.049922,0.800314,0.199686,0.050575,0.7977,0.2023,0.065081,0.739676,0.260324,0.086644,0.653424,0.346576,0.081155,0.675379,0.324621,0.094485,0.62206,0.37794,0.072922,0.708312,0.291688,0.044171,0.823314,0.176686,0.03999,0.840042,0.159958,0.03816,0.84736,0.15264,0.037768,0.848928,0.151072,0.03816,0.84736,0.15264,0.038029,0.847883,0.152117,0.037899,0.848406,0.151594,0.03816,0.84736,0.15264,0.038029,0.847883,0.152117,0.039467,0.842133,0.157867,0.040904,0.836383,0.163617,0.041819,0.832723,0.167277,0.042865,0.828542,0.171458,0.043518,0.825928,0.174072,0.044302,0.822791,0.177209,0.045478,0.818087,0.181913,0.0477,0.8092,0.1908,0.045609,0.817564,0.182436,0.04574,0.817041,0.182959,0.046393,0.814428,0.185572,0.047308,0.810768,0.189232,0.046785,0.812859,0.187141,0.047177,0.811291,0.188709,0.047831,0.808677,0.191323,0.048745,0.805018,0.194982,0.049791,0.800836,0.199164,0.051098,0.795609,0.204391,0.052405,0.790382,0.209618,0.053973,0.784109,0.215891,0.055802,0.77679,0.22321,0.057893,0.768427,0.231573,0.061814,0.752744,0.247256,0.065734,0.737062,0.262938,0.06861,0.725562,0.274438,0.072138,0.711448,0.288552,0.069002,0.723994,0.276006,0.068479,0.726085,0.273915,0.071093,0.71563,0.28437,0.073706,0.705175,0.294825,0.076451,0.694198,0.305802,0.08011,0.679561,0.320439,0.083508,0.66597,0.33403,0.088866,0.644537,0.355463,0.091087,0.635651,0.364349,0.089519,0.641924,0.358076,0.093309,0.626764,0.373236,0.08978,0.640878,0.359122,0.088996,0.644015,0.355985,0.087297,0.65081,0.34919,0.083769,0.664924,0.335076,0.079718,0.681129,0.318871,0.073837,0.704652,0.295348,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.023915,0.904339,0.095661,0.033847,0.864611,0.135389,0.039467,0.842133,0.157867,0.091349,0.634605,0.365395,0.056064,0.775745,0.224255,0.051882,0.792473,0.207527,0.054626,0.781495,0.218505,0.049922,0.800314,0.199686,0.050444,0.798223,0.201777,0.048092,0.807632,0.192368,0.052535,0.789859,0.210141,0.081809,0.672765,0.327235,0.098667,0.605332,0.394668,0.116702,0.533194,0.466806,0.099582,0.601673,0.398327,0.075536,0.697857,0.302143,0.060899,0.756404,0.243596,0.043257,0.826973,0.173027,0.042865,0.828542,0.171458,0.042211,0.831155,0.168845,0.042211,0.831155,0.168845,0.042342,0.830633,0.169367,0.042603,0.829587,0.170413,0.043126,0.827496,0.172504,0.042995,0.828019,0.171981,0.043518,0.825928,0.174072,0.045217,0.819132,0.180868,0.044694,0.821223,0.178777};
			return value;
		}
		private double[] getColor_6_24_color_79()
		{
			double[] value = {0.045609,0.817564,0.182436,0.047439,0.810246,0.189754,0.049137,0.80345,0.19655,0.051359,0.794564,0.205436,0.049922,0.800314,0.199686,0.049791,0.800836,0.199164,0.04966,0.801359,0.198641,0.049399,0.802405,0.197595,0.050575,0.7977,0.2023,0.048745,0.805018,0.194982,0.048223,0.807109,0.192891,0.049137,0.80345,0.19655,0.049791,0.800836,0.199164,0.049922,0.800314,0.199686,0.050836,0.796654,0.203346,0.051751,0.792995,0.207005,0.053058,0.787768,0.212232,0.055018,0.779927,0.220073,0.056194,0.775222,0.224778,0.058155,0.767381,0.232619,0.060638,0.757449,0.242551,0.063121,0.747517,0.252483,0.065604,0.737585,0.262415,0.071485,0.714062,0.285938,0.073576,0.705698,0.294302,0.073183,0.707266,0.292734,0.073706,0.705175,0.294825,0.07632,0.69472,0.30528,0.081286,0.674856,0.325144,0.086383,0.654469,0.345531,0.092002,0.631992,0.368008,0.09736,0.610559,0.389441,0.097622,0.609514,0.390486,0.097229,0.611082,0.388918,0.092786,0.628855,0.371145,0.08965,0.641401,0.358599,0.08965,0.641401,0.358599,0.090303,0.638787,0.361213,0.090434,0.638265,0.361735,0.079456,0.682175,0.317825,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.023523,0.905907,0.094093,0.041296,0.834814,0.165186,0.113826,0.544694,0.455306,0.078019,0.687925,0.312075,0.05907,0.763722,0.236278,0.083769,0.664924,0.335076,0.05345,0.7862,0.2138,0.042865,0.828542,0.171458,0.038944,0.844224,0.155776,0.056325,0.774699,0.225301,0.065734,0.737062,0.262938,0.072922,0.708312,0.291688,0.070047,0.719812,0.280188,0.064558,0.741767,0.258233,0.056456,0.774177,0.225823,0.049791,0.800836,0.199164,0.048092,0.807632,0.192368,0.048615,0.805541,0.194459,0.047439,0.810246,0.189754,0.046524,0.813905,0.186095,0.047177,0.811291,0.188709,0.048223,0.807109,0.192891,0.049137,0.80345,0.19655,0.049007,0.803973,0.196027,0.049399,0.802405,0.197595,0.048745,0.805018,0.194982,0.049268,0.802927,0.197073,0.050967,0.796132,0.203868,0.050052,0.799791,0.200209,0.054104,0.783586,0.216414,0.053189,0.787245,0.212755,0.053711,0.785154,0.214846,0.053711,0.785154,0.214846,0.052666,0.789336,0.210664,0.050052,0.799791,0.200209,0.051359,0.794564,0.205436,0.050052,0.799791,0.200209,0.04966,0.801359,0.198641,0.050575,0.7977,0.2023,0.051751,0.792995,0.207005,0.052535,0.789859,0.210141,0.053973,0.784109,0.215891,0.055802,0.77679,0.22321,0.057501,0.769995,0.230005,0.057632,0.769472,0.230528,0.058808,0.764767,0.235233,0.059592,0.761631,0.238369};
			return value;
		}
		private double[] getColor_6_24_color_80()
		{
			double[] value = {0.060899,0.756404,0.243596,0.06299,0.74804,0.25196,0.06482,0.740721,0.259279,0.066649,0.733403,0.266597,0.071485,0.714062,0.285938,0.082462,0.670152,0.329848,0.075536,0.697857,0.302143,0.077235,0.691061,0.308939,0.081809,0.672765,0.327235,0.086775,0.652901,0.347099,0.092786,0.628855,0.371145,0.107031,0.571877,0.428123,0.108468,0.566127,0.433873,0.097883,0.608468,0.391532,0.095661,0.617355,0.382645,0.093048,0.62781,0.37219,0.090957,0.636174,0.363826,0.08978,0.640878,0.359122,0.08978,0.640878,0.359122,0.08965,0.641401,0.358599,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.023654,0.905384,0.094616,0.06299,0.74804,0.25196,0.077365,0.690538,0.309462,0.030711,0.877156,0.122844,0.087689,0.649242,0.350758,0.081417,0.674334,0.325666,0.044433,0.822269,0.177731,0.034109,0.863565,0.136435,0.05528,0.778881,0.221119,0.050183,0.799268,0.200732,0.050706,0.797177,0.202823,0.053058,0.787768,0.212232,0.049922,0.800314,0.199686,0.049922,0.800314,0.199686,0.052143,0.791427,0.208573,0.061291,0.754835,0.245165,0.064428,0.74229,0.25771,0.054888,0.78045,0.21955,0.050183,0.799268,0.200732,0.052535,0.789859,0.210141,0.054365,0.782541,0.217459,0.056064,0.775745,0.224255,0.056194,0.775222,0.224778,0.05541,0.778359,0.221641,0.054496,0.782018,0.217982,0.053581,0.785677,0.214323,0.056064,0.775745,0.224255,0.054104,0.783586,0.216414,0.057501,0.769995,0.230005,0.058416,0.766336,0.233664,0.063121,0.747517,0.252483,0.057501,0.769995,0.230005,0.055802,0.77679,0.22321,0.052927,0.788291,0.211709,0.055149,0.779404,0.220596,0.052797,0.788813,0.211187,0.05149,0.794041,0.205959,0.052274,0.790904,0.209096,0.053319,0.786722,0.213278,0.054888,0.78045,0.21955,0.056979,0.772086,0.227914,0.057893,0.768427,0.231573,0.058416,0.766336,0.233664,0.059331,0.762676,0.237324,0.060246,0.759017,0.240983,0.061291,0.754835,0.245165,0.061683,0.753267,0.246733,0.06299,0.74804,0.25196,0.066257,0.734971,0.265029,0.069132,0.723471,0.276529,0.072007,0.711971,0.288029,0.076189,0.695243,0.304757,0.081809,0.672765,0.327235,0.081286,0.674856,0.325144,0.081809,0.672765,0.327235,0.088212,0.647151,0.352849,0.094485,0.62206,0.37794,0.111735,0.553058,0.446942,0.108599,0.565604,0.434396,0.105201,0.579195,0.420805,0.097491,0.610037,0.389963,0.096053,0.615787,0.384213,0.091218,0.635128,0.364872,0.08978,0.640878,0.359122,0.082201,0.671197,0.328803,0.081809,0.672765,0.327235};
			return value;
		}
		private double[] getColor_6_24_color_81()
		{
			double[] value = {0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.024307,0.902771,0.097229,0.039336,0.842656,0.157344,0.069002,0.723994,0.276006,0.033586,0.865656,0.134344,0.032933,0.86827,0.13173,0.039205,0.843178,0.156822,0.041427,0.834292,0.165708,0.042081,0.831678,0.168322,0.043126,0.827496,0.172504,0.042081,0.831678,0.168322,0.050575,0.7977,0.2023,0.053058,0.787768,0.212232,0.064558,0.741767,0.258233,0.079195,0.68322,0.31678,0.071223,0.715107,0.284893,0.056717,0.773131,0.226869,0.059723,0.761108,0.238892,0.064166,0.743335,0.256665,0.065081,0.739676,0.260324,0.065081,0.739676,0.260324,0.063382,0.746472,0.253528,0.06116,0.755358,0.244642,0.05907,0.763722,0.236278,0.058808,0.764767,0.235233,0.057109,0.771563,0.228437,0.063121,0.747517,0.252483,0.065865,0.736539,0.263461,0.065865,0.736539,0.263461,0.059984,0.760063,0.239937,0.056848,0.772608,0.227392,0.056456,0.774177,0.225823,0.055802,0.77679,0.22321,0.053581,0.785677,0.214323,0.05345,0.7862,0.2138,0.053973,0.784109,0.215891,0.054888,0.78045,0.21955,0.055802,0.77679,0.22321,0.05724,0.77104,0.22896,0.058416,0.766336,0.233664,0.059462,0.762154,0.237846,0.060638,0.757449,0.242551,0.061814,0.752744,0.247256,0.062859,0.748562,0.251438,0.063643,0.745426,0.254574,0.065342,0.73863,0.26137,0.065996,0.736017,0.263983,0.068348,0.726607,0.273393,0.070831,0.716675,0.283325,0.073314,0.706743,0.293257,0.08024,0.679038,0.320962,0.081809,0.672765,0.327235,0.085076,0.659697,0.340303,0.089388,0.642446,0.357554,0.093832,0.624673,0.375327,0.097752,0.608991,0.391009,0.106116,0.575536,0.424464,0.122974,0.508102,0.491898,0.102326,0.590695,0.409305,0.096576,0.613696,0.386304,0.092133,0.631469,0.368531,0.08978,0.640878,0.359122,0.089127,0.643492,0.356508,0.081809,0.672765,0.327235,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0};
			return value;
		}
		private double[] getColor_6_24_color_82()
		{
			double[] value = {0.024569,0.901725,0.098275,0.026006,0.895975,0.104025,0.031234,0.875065,0.124935,0.03437,0.86252,0.13748,0.036069,0.855724,0.144276,0.038291,0.846837,0.153163,0.041688,0.833246,0.166754,0.049791,0.800836,0.199164,0.055149,0.779404,0.220596,0.058939,0.764245,0.235755,0.05162,0.793518,0.206482,0.056194,0.775222,0.224778,0.06482,0.740721,0.259279,0.071746,0.713016,0.286984,0.083769,0.664924,0.335076,0.081155,0.675379,0.324621,0.081155,0.675379,0.324621,0.073445,0.706221,0.293779,0.069132,0.723471,0.276529,0.069263,0.722948,0.277052,0.069002,0.723994,0.276006,0.065081,0.739676,0.260324,0.065604,0.737585,0.262415,0.065865,0.736539,0.263461,0.065865,0.736539,0.263461,0.062075,0.751699,0.248301,0.057763,0.768949,0.231051,0.060376,0.758495,0.241505,0.057893,0.768427,0.231573,0.05724,0.77104,0.22896,0.056325,0.774699,0.225301,0.05724,0.77104,0.22896,0.05724,0.77104,0.22896,0.057371,0.770518,0.229482,0.057893,0.768427,0.231573,0.05907,0.763722,0.236278,0.062467,0.750131,0.249869,0.065212,0.739153,0.260847,0.065081,0.739676,0.260324,0.065734,0.737062,0.262938,0.065996,0.736017,0.263983,0.06678,0.73288,0.26712,0.066649,0.733403,0.266597,0.067695,0.729221,0.270779,0.070831,0.716675,0.283325,0.07449,0.702039,0.297961,0.079718,0.681129,0.318871,0.083377,0.666492,0.333508,0.085599,0.657606,0.342394,0.089519,0.641924,0.358076,0.093832,0.624673,0.375327,0.098275,0.6069,0.3931,0.105201,0.579195,0.420805,0.111735,0.553058,0.446942,0.117878,0.528489,0.471511,0.099451,0.602196,0.397804,0.094354,0.622582,0.377418,0.089911,0.640355,0.359645,0.08965,0.641401,0.358599,0.089258,0.642969,0.357031,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.023785,0.904861,0.095139,0.026398,0.894407,0.105593,0.029796,0.880815,0.119185,0.032018,0.871929,0.128071,0.03437,0.86252,0.13748,0.043257,0.826973,0.173027,0.044302,0.822791,0.177209,0.044041,0.823837,0.176163,0.045348,0.81861,0.18139,0.052274,0.790904,0.209096,0.064689,0.741244,0.258756,0.087951,0.648197,0.351803,0.136696,0.453215,0.546785,0.124673,0.501307,0.498693,0.120491,0.518035,0.481965,0.133168,0.467329,0.532671,0.120753,0.516989,0.483011,0.094746,0.621014,0.378986,0.092525,0.629901,0.370099};
			return value;
		}
		private double[] getColor_6_24_color_83()
		{
			double[] value = {0.103764,0.584945,0.415055,0.083638,0.665447,0.334553,0.088343,0.646628,0.353372,0.085337,0.658651,0.341349,0.070047,0.719812,0.280188,0.063643,0.745426,0.254574,0.063643,0.745426,0.254574,0.065473,0.738108,0.261892,0.064558,0.741767,0.258233,0.063643,0.745426,0.254574,0.062598,0.749608,0.250392,0.060507,0.757972,0.242028,0.05907,0.763722,0.236278,0.059723,0.761108,0.238892,0.060507,0.757972,0.242028,0.061683,0.753267,0.246733,0.063643,0.745426,0.254574,0.065604,0.737585,0.262415,0.065865,0.736539,0.263461,0.067172,0.731312,0.268688,0.068871,0.724516,0.275484,0.070439,0.718244,0.281756,0.072007,0.711971,0.288029,0.071223,0.715107,0.284893,0.069916,0.720335,0.279665,0.074098,0.703607,0.296393,0.079195,0.68322,0.31678,0.084814,0.660742,0.339258,0.084945,0.66022,0.33978,0.089388,0.642446,0.357554,0.095531,0.617878,0.382122,0.098798,0.604809,0.395191,0.099059,0.603764,0.396236,0.105724,0.577104,0.422896,0.120099,0.519603,0.480397,0.10494,0.58024,0.41976,0.09736,0.610559,0.389441,0.091349,0.634605,0.365395,0.08978,0.640878,0.359122,0.08978,0.640878,0.359122,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.024569,0.901725,0.098275,0.027182,0.89127,0.10873,0.03045,0.878202,0.121798,0.032671,0.869315,0.130685,0.035938,0.856247,0.143753,0.038421,0.846315,0.153685,0.042473,0.83011,0.16989,0.049268,0.802927,0.197073,0.067825,0.728698,0.271302,0.114219,0.543126,0.456874,0.173419,0.306325,0.693675,0.161265,0.35494,0.64506,0.153163,0.38735,0.61265,0.153163,0.38735,0.61265,0.139963,0.440146,0.559854,0.122713,0.509148,0.490852,0.123105,0.50758,0.49242,0.152378,0.390486,0.609514,0.15068,0.397282,0.602718,0.137742,0.449033,0.550967,0.118531,0.525876,0.474124,0.109645,0.561422,0.438578,0.094877,0.620491,0.379509,0.069394,0.722426,0.277574,0.065865,0.736539,0.263461,0.065865,0.736539,0.263461,0.065473,0.738108,0.261892,0.065604,0.737585,0.262415,0.065865,0.736539,0.263461,0.056456,0.774177,0.225823,0.063905,0.744381,0.255619,0.064166,0.743335,0.256665,0.064036,0.743858,0.256142,0.065473,0.738108,0.261892,0.065604,0.737585,0.262415,0.066127,0.735494,0.264506,0.067564,0.729744,0.270256,0.069002,0.723994,0.276006};
			return value;
		}
		private double[] getColor_6_24_color_84()
		{
			double[] value = {0.070439,0.718244,0.281756,0.071615,0.713539,0.286461,0.073314,0.706743,0.293257,0.073837,0.704652,0.295348,0.073706,0.705175,0.294825,0.07253,0.70988,0.29012,0.07632,0.69472,0.30528,0.082593,0.669629,0.330371,0.081155,0.675379,0.324621,0.086121,0.655515,0.344485,0.08965,0.641401,0.358599,0.089911,0.640355,0.359645,0.094354,0.622582,0.377418,0.097752,0.608991,0.391009,0.111082,0.555672,0.444328,0.119315,0.522739,0.477261,0.104548,0.581809,0.418191,0.096184,0.615264,0.384736,0.092133,0.631469,0.368531,0.089911,0.640355,0.359645,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.025484,0.898066,0.101934,0.028489,0.886043,0.113957,0.032018,0.871929,0.128071,0.0362,0.855201,0.144799,0.040382,0.838474,0.161526,0.048615,0.805541,0.194459,0.07253,0.70988,0.29012,0.124804,0.500784,0.499216,0.141924,0.432305,0.567695,0.140225,0.439101,0.560899,0.12206,0.511762,0.488238,0.114219,0.543126,0.456874,0.1069,0.572399,0.427601,0.09357,0.625719,0.374281,0.086775,0.652901,0.347099,0.12794,0.488238,0.511762,0.145583,0.417669,0.582331,0.135651,0.457397,0.542603,0.118531,0.525876,0.474124,0.110298,0.558808,0.441192,0.097491,0.610037,0.389963,0.081939,0.672243,0.327757,0.075536,0.697857,0.302143,0.083116,0.667538,0.332462,0.073837,0.704652,0.295348,0.065865,0.736539,0.263461,0.065865,0.736539,0.263461,0.068087,0.727653,0.272347,0.064689,0.741244,0.258756,0.069132,0.723471,0.276529,0.070962,0.716153,0.283847,0.066388,0.734449,0.265551,0.068348,0.726607,0.273393,0.066388,0.734449,0.265551,0.070178,0.719289,0.280711,0.072138,0.711448,0.288552,0.072399,0.710403,0.289597,0.07253,0.70988,0.29012,0.073314,0.706743,0.293257,0.073706,0.705175,0.294825,0.073445,0.706221,0.293779,0.073445,0.706221,0.293779,0.075405,0.69838,0.30162,0.077627,0.689493,0.310507,0.075666,0.697334,0.302666,0.081678,0.673288,0.326712,0.080894,0.676424,0.323576,0.086252,0.654992,0.345008,0.090434,0.638265,0.361735,0.09736,0.610559,0.389441,0.105985,0.576059,0.423941,0.113565,0.54574,0.45426,0.121014,0.515944,0.484056,0.123889,0.504443,0.495557,0.102849,0.588604,0.411396,0.09736,0.610559,0.389441,0.093048,0.62781,0.37219};
			return value;
		}
		private double[] getColor_6_24_color_85()
		{
			double[] value = {0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.024177,0.903293,0.096707,0.027052,0.891793,0.108207,0.032018,0.871929,0.128071,0.040512,0.837951,0.162049,0.058677,0.76529,0.23471,0.096053,0.615787,0.384213,0.07828,0.686879,0.313121,0.09344,0.626242,0.373758,0.1184,0.526398,0.473602,0.09736,0.610559,0.389441,0.094877,0.620491,0.379509,0.07632,0.69472,0.30528,0.070962,0.716153,0.283847,0.073837,0.704652,0.295348,0.10115,0.5954,0.4046,0.103633,0.585468,0.414532,0.133691,0.465238,0.534762,0.122452,0.510193,0.489807,0.113696,0.545217,0.454783,0.096315,0.614741,0.385259,0.082854,0.668583,0.331417,0.085206,0.659174,0.340826,0.08965,0.641401,0.358599,0.081155,0.675379,0.324621,0.073706,0.705175,0.294825,0.070178,0.719289,0.280711,0.070962,0.716153,0.283847,0.070831,0.716675,0.283325,0.069002,0.723994,0.276006,0.069786,0.720857,0.279143,0.073837,0.704652,0.295348,0.07057,0.717721,0.282279,0.073837,0.704652,0.295348,0.073576,0.705698,0.294302,0.072922,0.708312,0.291688,0.076973,0.692107,0.307893,0.076973,0.692107,0.307893,0.076451,0.694198,0.305802,0.077104,0.691584,0.308416,0.077888,0.688447,0.311553,0.073837,0.704652,0.295348,0.07632,0.69472,0.30528,0.08024,0.679038,0.320962,0.081939,0.672243,0.327757,0.081678,0.673288,0.326712,0.080894,0.676424,0.323576,0.08403,0.663879,0.336121,0.08965,0.641401,0.358599,0.09736,0.610559,0.389441,0.100497,0.598014,0.401986,0.105463,0.57815,0.42185,0.113696,0.545217,0.454783,0.118923,0.524307,0.475693,0.123628,0.505489,0.494511,0.10886,0.564558,0.435442,0.099843,0.600627,0.399373,0.097229,0.611082,0.388918,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0};
			return value;
		}
		private double[] getColor_6_24_color_86()
		{
			double[] value = {0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.024438,0.902248,0.097752,0.02862,0.88552,0.11448,0.033586,0.865656,0.134344,0.059592,0.761631,0.238369,0.053189,0.787245,0.212755,0.058155,0.767381,0.232619,0.079718,0.681129,0.318871,0.085729,0.657083,0.342917,0.084292,0.662833,0.337167,0.077757,0.68897,0.31103,0.06678,0.73288,0.26712,0.065081,0.739676,0.260324,0.063905,0.744381,0.255619,0.069263,0.722948,0.277052,0.083246,0.667015,0.332985,0.110559,0.557763,0.442237,0.125719,0.497125,0.502875,0.114611,0.541558,0.458442,0.102849,0.588604,0.411396,0.090565,0.637742,0.362258,0.089911,0.640355,0.359645,0.08965,0.641401,0.358599,0.082331,0.670674,0.329326,0.08011,0.679561,0.320439,0.073968,0.70413,0.29587,0.073706,0.705175,0.294825,0.073314,0.706743,0.293257,0.073576,0.705698,0.294302,0.071615,0.713539,0.286461,0.070178,0.719289,0.280711,0.073837,0.704652,0.295348,0.073576,0.705698,0.294302,0.073837,0.704652,0.295348,0.073576,0.705698,0.294302,0.070962,0.716153,0.283847,0.073576,0.705698,0.294302,0.079718,0.681129,0.318871,0.081809,0.672765,0.327235,0.081809,0.672765,0.327235,0.081678,0.673288,0.326712,0.079587,0.681652,0.318348,0.085599,0.657606,0.342394,0.088866,0.644537,0.355463,0.084553,0.661788,0.338212,0.0839,0.664401,0.335599,0.081678,0.673288,0.326712,0.086644,0.653424,0.346576,0.08965,0.641401,0.358599,0.097752,0.608991,0.391009,0.100366,0.598536,0.401464,0.113696,0.545217,0.454783,0.113565,0.54574,0.45426,0.120361,0.518557,0.481443,0.121537,0.513853,0.486147,0.118662,0.525353,0.474647,0.104025,0.5839,0.4161,0.098144,0.607423,0.392577,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.025353,0.898589,0.101411,0.029927,0.880293,0.119707,0.034893,0.860429,0.139571,0.040382,0.838474,0.161526,0.050444,0.798223,0.201777,0.060507,0.757972,0.242028,0.064558,0.741767,0.258233,0.066911,0.732358,0.267642,0.061422,0.754313,0.245687,0.062075,0.751699,0.248301,0.057371,0.770518,0.229482,0.057893,0.768427,0.231573,0.058155,0.767381,0.232619,0.065865,0.736539,0.263461,0.068217,0.72713,0.27287,0.104679,0.581286,0.418714,0.126634,0.493466,0.506534};
			return value;
		}
		private double[] getColor_6_24_color_87()
		{
			double[] value = {0.10873,0.565081,0.434919,0.099451,0.602196,0.397804,0.095923,0.616309,0.383691,0.094224,0.623105,0.376895,0.089519,0.641924,0.358076,0.083638,0.665447,0.334553,0.081678,0.673288,0.326712,0.08024,0.679038,0.320962,0.07815,0.687402,0.312598,0.077627,0.689493,0.310507,0.077235,0.691061,0.308939,0.074752,0.700993,0.299007,0.072138,0.711448,0.288552,0.077496,0.690016,0.309984,0.079456,0.682175,0.317825,0.07828,0.686879,0.313121,0.073968,0.70413,0.29587,0.073837,0.704652,0.295348,0.073837,0.704652,0.295348,0.07815,0.687402,0.312598,0.083769,0.664924,0.335076,0.082854,0.668583,0.331417,0.082201,0.671197,0.328803,0.081809,0.672765,0.327235,0.083508,0.66597,0.33403,0.089127,0.643492,0.356508,0.097491,0.610037,0.389963,0.08965,0.641401,0.358599,0.091871,0.632514,0.367486,0.089519,0.641924,0.358076,0.097752,0.608991,0.391009,0.098928,0.604286,0.395714,0.107031,0.571877,0.428123,0.113565,0.54574,0.45426,0.115787,0.536853,0.463147,0.119707,0.521171,0.478829,0.12219,0.511239,0.488761,0.112389,0.550444,0.449556,0.106247,0.575013,0.424987,0.097883,0.608468,0.391532,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.023785,0.904861,0.095139,0.033455,0.866179,0.133821,0.033325,0.866702,0.133298,0.039597,0.84161,0.15839,0.041819,0.832723,0.167277,0.044041,0.823837,0.176163,0.050575,0.7977,0.2023,0.05345,0.7862,0.2138,0.053058,0.787768,0.212232,0.052666,0.789336,0.210664,0.051228,0.795086,0.204914,0.057632,0.769472,0.230528,0.064166,0.743335,0.256665,0.06482,0.740721,0.259279,0.076189,0.695243,0.304757,0.109906,0.560376,0.439624,0.113565,0.54574,0.45426,0.105724,0.577104,0.422896,0.098798,0.604809,0.395191,0.097622,0.609514,0.390486,0.091871,0.632514,0.367486,0.08978,0.640878,0.359122,0.089127,0.643492,0.356508,0.089127,0.643492,0.356508,0.086383,0.654469,0.345531,0.082985,0.668061,0.331939,0.081809,0.672765,0.327235,0.081809,0.672765,0.327235,0.079718,0.681129,0.318871,0.076712,0.693152,0.306848,0.077627,0.689493,0.310507,0.082201,0.671197,0.328803,0.081939,0.672243,0.327757,0.080763,0.676947,0.323053,0.08024,0.679038,0.320962,0.081547,0.673811,0.326189,0.081547,0.673811,0.326189};
			return value;
		}
		private double[] getColor_6_24_color_88()
		{
			double[] value = {0.088212,0.647151,0.352849,0.087951,0.648197,0.351803,0.087951,0.648197,0.351803,0.089258,0.642969,0.357031,0.090957,0.636174,0.363826,0.096315,0.614741,0.385259,0.097752,0.608991,0.391009,0.097491,0.610037,0.389963,0.098406,0.606377,0.393623,0.089258,0.642969,0.357031,0.105985,0.576059,0.423941,0.113565,0.54574,0.45426,0.114088,0.543649,0.456351,0.113696,0.545217,0.454783,0.114741,0.541035,0.458965,0.121014,0.515944,0.484056,0.121929,0.512284,0.487716,0.121668,0.51333,0.48667,0.110951,0.556194,0.443806,0.119838,0.520648,0.479352,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.022608,0.909566,0.090434,0.025353,0.898589,0.101411,0.03045,0.878202,0.121798,0.033325,0.866702,0.133298,0.038421,0.846315,0.153685,0.042473,0.83011,0.16989,0.042734,0.829064,0.170936,0.047308,0.810768,0.189232,0.046785,0.812859,0.187141,0.048092,0.807632,0.192368,0.049791,0.800836,0.199164,0.057893,0.768427,0.231573,0.058939,0.764245,0.235755,0.065604,0.737585,0.262415,0.08207,0.67172,0.32828,0.094485,0.62206,0.37794,0.099059,0.603764,0.396236,0.090173,0.63931,0.36069,0.091349,0.634605,0.365395,0.098144,0.607423,0.392577,0.097229,0.611082,0.388918,0.097752,0.608991,0.391009,0.100105,0.599582,0.400418,0.106377,0.57449,0.42551,0.096315,0.614741,0.385259,0.090826,0.636696,0.363304,0.089127,0.643492,0.356508,0.086383,0.654469,0.345531,0.084553,0.661788,0.338212,0.08207,0.67172,0.32828,0.08024,0.679038,0.320962,0.084292,0.662833,0.337167,0.08207,0.67172,0.32828,0.081809,0.672765,0.327235,0.081417,0.674334,0.325666,0.081809,0.672765,0.327235,0.081809,0.672765,0.327235,0.082723,0.669106,0.330894,0.096184,0.615264,0.384736,0.089388,0.642446,0.357554,0.097491,0.610037,0.389963,0.097883,0.608468,0.391532,0.097622,0.609514,0.390486,0.097752,0.608991,0.391009,0.095531,0.617878,0.382122,0.098014,0.607946,0.392054,0.095531,0.617878,0.382122,0.103633,0.585468,0.414532,0.107031,0.571877,0.428123,0.111997,0.552013,0.447987,0.112389,0.550444,0.449556,0.113565,0.54574,0.45426,0.11644,0.534239,0.465761,0.120883,0.516466,0.483534,0.121537,0.513853,0.486147,0.120883,0.516466,0.483534,0.121929,0.512284,0.487716};
			return value;
		}
		private double[] getColor_6_24_color_89()
		{
			double[] value = {0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.02483,0.90068,0.09932,0.028359,0.886566,0.113434,0.033063,0.867747,0.132253,0.03437,0.86252,0.13748,0.039205,0.843178,0.156822,0.040382,0.838474,0.161526,0.041427,0.834292,0.165708,0.04195,0.832201,0.167799,0.046393,0.814428,0.185572,0.056325,0.774699,0.225301,0.057893,0.768427,0.231573,0.061553,0.75379,0.24621,0.067564,0.729744,0.270256,0.074621,0.701516,0.298484,0.085468,0.658129,0.341871,0.081809,0.672765,0.327235,0.087036,0.651856,0.348144,0.095661,0.617355,0.382645,0.107554,0.569786,0.430214,0.104417,0.582331,0.417669,0.115264,0.538944,0.461056,0.112912,0.548353,0.451647,0.115133,0.539467,0.460533,0.11448,0.542081,0.457919,0.104156,0.583377,0.416623,0.097099,0.611605,0.388395,0.096315,0.614741,0.385259,0.099974,0.600105,0.399895,0.087559,0.649765,0.350235,0.083638,0.665447,0.334553,0.093178,0.627287,0.372713,0.089258,0.642969,0.357031,0.084684,0.661265,0.338735,0.083246,0.667015,0.332985,0.088474,0.646106,0.353894,0.088212,0.647151,0.352849,0.097491,0.610037,0.389963,0.097752,0.608991,0.391009,0.095139,0.619446,0.380554,0.096315,0.614741,0.385259,0.101673,0.593309,0.406691,0.103633,0.585468,0.414532,0.097752,0.608991,0.391009,0.097099,0.611605,0.388395,0.096707,0.613173,0.386827,0.097622,0.609514,0.390486,0.097752,0.608991,0.391009,0.103502,0.585991,0.414009,0.106247,0.575013,0.424987,0.107554,0.569786,0.430214,0.110298,0.558808,0.441192,0.113434,0.546262,0.453738,0.1184,0.526398,0.473602,0.121668,0.51333,0.48667,0.123628,0.505489,0.494511,0.124412,0.502352,0.497648,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0};
			return value;
		}
		private double[] getColor_6_24_color_90()
		{
			double[] value = {0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.024046,0.903816,0.096184,0.026268,0.894929,0.105071,0.029535,0.881861,0.118139,0.032148,0.871406,0.128594,0.034109,0.863565,0.136435,0.037507,0.849974,0.150026,0.040512,0.837951,0.162049,0.042734,0.829064,0.170936,0.049137,0.80345,0.19655,0.054888,0.78045,0.21955,0.064558,0.741767,0.258233,0.065734,0.737062,0.262938,0.065865,0.736539,0.263461,0.072922,0.708312,0.291688,0.081678,0.673288,0.326712,0.081809,0.672765,0.327235,0.088604,0.645583,0.354417,0.100366,0.598536,0.401464,0.113434,0.546262,0.453738,0.106116,0.575536,0.424464,0.105855,0.576581,0.423419,0.104156,0.583377,0.416623,0.113696,0.545217,0.454783,0.113696,0.545217,0.454783,0.113696,0.545217,0.454783,0.113696,0.545217,0.454783,0.105855,0.576581,0.423419,0.097622,0.609514,0.390486,0.08978,0.640878,0.359122,0.08978,0.640878,0.359122,0.090042,0.639833,0.360167,0.090042,0.639833,0.360167,0.08978,0.640878,0.359122,0.08978,0.640878,0.359122,0.08978,0.640878,0.359122,0.091087,0.635651,0.364349,0.091349,0.634605,0.365395,0.096707,0.613173,0.386827,0.097622,0.609514,0.390486,0.097752,0.608991,0.391009,0.105071,0.579718,0.420282,0.105724,0.577104,0.422896,0.099059,0.603764,0.396236,0.100889,0.596445,0.403555,0.099974,0.600105,0.399895,0.104025,0.5839,0.4161,0.104809,0.580763,0.419237,0.105463,0.57815,0.42185,0.105201,0.579195,0.420805,0.105855,0.576581,0.423419,0.110167,0.559331,0.440669,0.113696,0.545217,0.454783,0.114872,0.540512,0.459488,0.117747,0.529012,0.470988,0.120361,0.518557,0.481443,0.121406,0.514375,0.485625,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.023654,0.905384,0.094616,0.025614,0.897543,0.102457,0.027967,0.888134,0.111866,0.030188,0.879247,0.120753,0.03241,0.870361,0.129639,0.035546,0.857815,0.142185,0.040904,0.836383,0.163617,0.046785,0.812859,0.187141,0.055149,0.779404,0.220596,0.065473,0.738108,0.261892,0.060507,0.757972,0.242028,0.057763,0.768949,0.231051,0.064558,0.741767,0.258233,0.073706,0.705175,0.294825,0.073053,0.707789,0.292211,0.080894,0.676424,0.323576};
			return value;
		}
		private double[] getColor_6_24_color_91()
		{
			double[] value = {0.090042,0.639833,0.360167,0.110037,0.559854,0.440146,0.109775,0.560899,0.439101,0.104679,0.581286,0.418714,0.097622,0.609514,0.390486,0.105593,0.577627,0.422373,0.105985,0.576059,0.423941,0.112128,0.55149,0.44851,0.113696,0.545217,0.454783,0.113565,0.54574,0.45426,0.105593,0.577627,0.422373,0.097752,0.608991,0.391009,0.097622,0.609514,0.390486,0.091871,0.632514,0.367486,0.091741,0.633037,0.366963,0.097752,0.608991,0.391009,0.091349,0.634605,0.365395,0.093962,0.624151,0.375849,0.092917,0.628332,0.371668,0.097491,0.610037,0.389963,0.096707,0.613173,0.386827,0.097229,0.611082,0.388918,0.100627,0.597491,0.402509,0.097099,0.611605,0.388395,0.105724,0.577104,0.422896,0.102065,0.591741,0.408259,0.101542,0.593832,0.406168,0.103633,0.585468,0.414532,0.101411,0.594354,0.405646,0.103372,0.586513,0.413487,0.105724,0.577104,0.422896,0.105724,0.577104,0.422896,0.105593,0.577627,0.422373,0.1069,0.572399,0.427601,0.109775,0.560899,0.439101,0.111213,0.555149,0.444851,0.113826,0.544694,0.455306,0.114219,0.543126,0.456874,0.11644,0.534239,0.465761,0.116048,0.535808,0.464192,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.022739,0.909043,0.090957,0.024699,0.901202,0.098798,0.026921,0.892316,0.107684,0.029273,0.882906,0.117094,0.032018,0.871929,0.128071,0.034893,0.860429,0.139571,0.040643,0.837428,0.162572,0.053711,0.785154,0.214846,0.057763,0.768949,0.231051,0.057893,0.768427,0.231573,0.054757,0.780972,0.219028,0.068871,0.724516,0.275484,0.065865,0.736539,0.263461,0.067041,0.731835,0.268165,0.077627,0.689493,0.310507,0.083246,0.667015,0.332985,0.100497,0.598014,0.401986,0.101542,0.593832,0.406168,0.097099,0.611605,0.388395,0.091871,0.632514,0.367486,0.092656,0.629378,0.370622,0.097752,0.608991,0.391009,0.103633,0.585468,0.414532,0.110559,0.557763,0.442237,0.113565,0.54574,0.45426,0.107423,0.570308,0.429692,0.102588,0.58965,0.41035,0.099582,0.601673,0.398327,0.097752,0.608991,0.391009,0.097099,0.611605,0.388395,0.097099,0.611605,0.388395,0.097752,0.608991,0.391009,0.097752,0.608991,0.391009,0.098014,0.607946,0.392054,0.097752,0.608991,0.391009,0.097622,0.609514,0.390486};
			return value;
		}
		private double[] getColor_6_24_color_92()
		{
			double[] value = {0.095923,0.616309,0.383691,0.105201,0.579195,0.420805,0.105463,0.57815,0.42185,0.105593,0.577627,0.422373,0.105593,0.577627,0.422373,0.105201,0.579195,0.420805,0.101673,0.593309,0.406691,0.103241,0.587036,0.412964,0.101673,0.593309,0.406691,0.105593,0.577627,0.422373,0.10494,0.58024,0.41976,0.105463,0.57815,0.42185,0.105724,0.577104,0.422896,0.106247,0.575013,0.424987,0.109514,0.561945,0.438055,0.109906,0.560376,0.439624,0.111997,0.552013,0.447987,0.11265,0.549399,0.450601,0.113042,0.547831,0.452169,0.113696,0.545217,0.454783,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.023785,0.904861,0.095139,0.026006,0.895975,0.104025,0.028097,0.887611,0.112389,0.031103,0.875588,0.124412,0.033978,0.864088,0.135912,0.039859,0.840565,0.159435,0.046524,0.813905,0.186095,0.048615,0.805541,0.194459,0.047308,0.810768,0.189232,0.050967,0.796132,0.203868,0.057893,0.768427,0.231573,0.058155,0.767381,0.232619,0.065212,0.739153,0.260847,0.074882,0.70047,0.29953,0.096053,0.615787,0.384213,0.097622,0.609514,0.390486,0.094224,0.623105,0.376895,0.088474,0.646106,0.353894,0.087036,0.651856,0.348144,0.093962,0.624151,0.375849,0.096968,0.612128,0.387872,0.102718,0.589127,0.410873,0.112912,0.548353,0.451647,0.109122,0.563513,0.436487,0.105724,0.577104,0.422896,0.10298,0.588082,0.411918,0.101542,0.593832,0.406168,0.103372,0.586513,0.413487,0.103502,0.585991,0.414009,0.097883,0.608468,0.391532,0.103894,0.584422,0.415578,0.105201,0.579195,0.420805,0.105463,0.57815,0.42185,0.10494,0.58024,0.41976,0.097752,0.608991,0.391009,0.095531,0.617878,0.382122,0.103502,0.585991,0.414009,0.113173,0.547308,0.452692,0.102849,0.588604,0.411396,0.103764,0.584945,0.415055,0.105724,0.577104,0.422896,0.105463,0.57815,0.42185,0.10115,0.5954,0.4046,0.10115,0.5954,0.4046,0.101673,0.593309,0.406691,0.106116,0.575536,0.424464,0.106116,0.575536,0.424464,0.105201,0.579195,0.420805,0.105724,0.577104,0.422896,0.107684,0.569263,0.430737,0.109775,0.560899,0.439101,0.109775,0.560899,0.439101,0.109775,0.560899,0.439101,0.109775,0.560899,0.439101,0.109775,0.560899,0.439101};
			return value;
		}
		private double[] getColor_6_24_color_93()
		{
			double[] value = {0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.022739,0.909043,0.090957,0.024177,0.903293,0.096707,0.025353,0.898589,0.101411,0.027052,0.891793,0.108207,0.029927,0.880293,0.119707,0.033063,0.867747,0.132253,0.036722,0.85311,0.14689,0.04012,0.839519,0.160481,0.043387,0.826451,0.173549,0.044825,0.8207,0.1793,0.049791,0.800836,0.199164,0.056325,0.774699,0.225301,0.062075,0.751699,0.248301,0.06874,0.725039,0.274961,0.084422,0.662311,0.337689,0.093048,0.62781,0.37219,0.08978,0.640878,0.359122,0.085076,0.659697,0.340303,0.079979,0.680084,0.319916,0.08978,0.640878,0.359122,0.089127,0.643492,0.356508,0.092917,0.628332,0.371668,0.105463,0.57815,0.42185,0.105724,0.577104,0.422896,0.105855,0.576581,0.423419,0.10311,0.587559,0.412441,0.098144,0.607423,0.392577,0.105593,0.577627,0.422373,0.113434,0.546262,0.453738,0.105071,0.579718,0.420282,0.097752,0.608991,0.391009,0.105201,0.579195,0.420805,0.105724,0.577104,0.422896,0.106116,0.575536,0.424464,0.105724,0.577104,0.422896,0.097752,0.608991,0.391009,0.100889,0.596445,0.403555,0.108076,0.567695,0.432305,0.10886,0.564558,0.435442,0.103633,0.585468,0.414532,0.101673,0.593309,0.406691,0.104025,0.5839,0.4161,0.104679,0.581286,0.418714,0.101673,0.593309,0.406691,0.100889,0.596445,0.403555,0.101673,0.593309,0.406691,0.10494,0.58024,0.41976,0.109645,0.561422,0.438578,0.108338,0.566649,0.433351,0.105724,0.577104,0.422896,0.107946,0.568217,0.431783,0.109775,0.560899,0.439101,0.109775,0.560899,0.439101,0.109775,0.560899,0.439101,0.109775,0.560899,0.439101,0.109383,0.562467,0.437533};
			return value;
		}

		/** Large attribute array: ElevationGrid height field, scene-graph level=5, element #24, 9280 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFFloat getElevationGrid_5_24_height()
		{
			MFFloat ElevationGrid_5_24_height = new MFFloat()/*2.finalize*/
				.append(new MFFloat(getElevationGrid_5_24_height_1()))
				.append(new MFFloat(getElevationGrid_5_24_height_2()))
				.append(new MFFloat(getElevationGrid_5_24_height_3()))
				.append(new MFFloat(getElevationGrid_5_24_height_4()))
				.append(new MFFloat(getElevationGrid_5_24_height_5()))
				.append(new MFFloat(getElevationGrid_5_24_height_6()))
				.append(new MFFloat(getElevationGrid_5_24_height_7()))
				.append(new MFFloat(getElevationGrid_5_24_height_8()))
				.append(new MFFloat(getElevationGrid_5_24_height_9()))
				.append(new MFFloat(getElevationGrid_5_24_height_10()));
			return ElevationGrid_5_24_height;
		}
		/** Large attribute array: Color color field, scene-graph level=6, element #24, 27840 total numbers made up of 9280 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFColor getColor_6_24_color()
		{
			MFColor Color_6_24_color = new MFColor()/*2.finalize*/
				.append(new MFColor(getColor_6_24_color_1()))
				.append(new MFColor(getColor_6_24_color_2()))
				.append(new MFColor(getColor_6_24_color_3()))
				.append(new MFColor(getColor_6_24_color_4()))
				.append(new MFColor(getColor_6_24_color_5()))
				.append(new MFColor(getColor_6_24_color_6()))
				.append(new MFColor(getColor_6_24_color_7()))
				.append(new MFColor(getColor_6_24_color_8()))
				.append(new MFColor(getColor_6_24_color_9()))
				.append(new MFColor(getColor_6_24_color_10()))
				.append(new MFColor(getColor_6_24_color_11()))
				.append(new MFColor(getColor_6_24_color_12()))
				.append(new MFColor(getColor_6_24_color_13()))
				.append(new MFColor(getColor_6_24_color_14()))
				.append(new MFColor(getColor_6_24_color_15()))
				.append(new MFColor(getColor_6_24_color_16()))
				.append(new MFColor(getColor_6_24_color_17()))
				.append(new MFColor(getColor_6_24_color_18()))
				.append(new MFColor(getColor_6_24_color_19()))
				.append(new MFColor(getColor_6_24_color_20()))
				.append(new MFColor(getColor_6_24_color_21()))
				.append(new MFColor(getColor_6_24_color_22()))
				.append(new MFColor(getColor_6_24_color_23()))
				.append(new MFColor(getColor_6_24_color_24()))
				.append(new MFColor(getColor_6_24_color_25()))
				.append(new MFColor(getColor_6_24_color_26()))
				.append(new MFColor(getColor_6_24_color_27()))
				.append(new MFColor(getColor_6_24_color_28()))
				.append(new MFColor(getColor_6_24_color_29()))
				.append(new MFColor(getColor_6_24_color_30()))
				.append(new MFColor(getColor_6_24_color_31()))
				.append(new MFColor(getColor_6_24_color_32()))
				.append(new MFColor(getColor_6_24_color_33()))
				.append(new MFColor(getColor_6_24_color_34()))
				.append(new MFColor(getColor_6_24_color_35()))
				.append(new MFColor(getColor_6_24_color_36()))
				.append(new MFColor(getColor_6_24_color_37()))
				.append(new MFColor(getColor_6_24_color_38()))
				.append(new MFColor(getColor_6_24_color_39()))
				.append(new MFColor(getColor_6_24_color_40()))
				.append(new MFColor(getColor_6_24_color_41()))
				.append(new MFColor(getColor_6_24_color_42()))
				.append(new MFColor(getColor_6_24_color_43()))
				.append(new MFColor(getColor_6_24_color_44()))
				.append(new MFColor(getColor_6_24_color_45()))
				.append(new MFColor(getColor_6_24_color_46()))
				.append(new MFColor(getColor_6_24_color_47()))
				.append(new MFColor(getColor_6_24_color_48()))
				.append(new MFColor(getColor_6_24_color_49()))
				.append(new MFColor(getColor_6_24_color_50()))
				.append(new MFColor(getColor_6_24_color_51()))
				.append(new MFColor(getColor_6_24_color_52()))
				.append(new MFColor(getColor_6_24_color_53()))
				.append(new MFColor(getColor_6_24_color_54()))
				.append(new MFColor(getColor_6_24_color_55()))
				.append(new MFColor(getColor_6_24_color_56()))
				.append(new MFColor(getColor_6_24_color_57()))
				.append(new MFColor(getColor_6_24_color_58()))
				.append(new MFColor(getColor_6_24_color_59()))
				.append(new MFColor(getColor_6_24_color_60()))
				.append(new MFColor(getColor_6_24_color_61()))
				.append(new MFColor(getColor_6_24_color_62()))
				.append(new MFColor(getColor_6_24_color_63()))
				.append(new MFColor(getColor_6_24_color_64()))
				.append(new MFColor(getColor_6_24_color_65()))
				.append(new MFColor(getColor_6_24_color_66()))
				.append(new MFColor(getColor_6_24_color_67()))
				.append(new MFColor(getColor_6_24_color_68()))
				.append(new MFColor(getColor_6_24_color_69()))
				.append(new MFColor(getColor_6_24_color_70()))
				.append(new MFColor(getColor_6_24_color_71()))
				.append(new MFColor(getColor_6_24_color_72()))
				.append(new MFColor(getColor_6_24_color_73()))
				.append(new MFColor(getColor_6_24_color_74()))
				.append(new MFColor(getColor_6_24_color_75()))
				.append(new MFColor(getColor_6_24_color_76()))
				.append(new MFColor(getColor_6_24_color_77()))
				.append(new MFColor(getColor_6_24_color_78()))
				.append(new MFColor(getColor_6_24_color_79()))
				.append(new MFColor(getColor_6_24_color_80()))
				.append(new MFColor(getColor_6_24_color_81()))
				.append(new MFColor(getColor_6_24_color_82()))
				.append(new MFColor(getColor_6_24_color_83()))
				.append(new MFColor(getColor_6_24_color_84()))
				.append(new MFColor(getColor_6_24_color_85()))
				.append(new MFColor(getColor_6_24_color_86()))
				.append(new MFColor(getColor_6_24_color_87()))
				.append(new MFColor(getColor_6_24_color_88()))
				.append(new MFColor(getColor_6_24_color_89()))
				.append(new MFColor(getColor_6_24_color_90()))
				.append(new MFColor(getColor_6_24_color_91()))
				.append(new MFColor(getColor_6_24_color_92()))
				.append(new MFColor(getColor_6_24_color_93()));
			return Color_6_24_color;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return Land model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new Land().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Vrml2Sourcebook.Siggraph98Course.Land\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Vrml2Sourcebook.Siggraph98Course.Land self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Siggraph98Course/Land_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Siggraph98Course/Land_JavaExport.x3d"; 
                String filenameX3DV = "Siggraph98Course/Land_JavaExport.x3dv"; 
                String filenameJSON = "Siggraph98Course/Land_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
