####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python IsoSurface.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.3',
  head=head(
    children=[
    meta(content='IsoSurface.x3d',name='title'),
    meta(content='Nested isosurfaces illustrate the use of IndexedFaceSet nodes to build complex geometry, such as isosurfaces (constant-value contours in 3D).',name='description'),
    meta(content='David R. Nadeau',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='1 July 1998',name='created'),
    meta(content='2 February 2014',name='translated'),
    meta(content='20 October 2019',name='modified'),
    meta(content='originals/isosurf.wrl',name='reference'),
    meta(content='http://www.siggraph.org/s98',name='reference'),
    meta(content='http://www.siggraph.org/s98/conference/courses/18.html',name='reference'),
    meta(content='http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0177.htm',name='reference'),
    meta(content='http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/X3dResources.html',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/IsoSurface.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(info=["Copyright (c) 1997, David R. Nadeau"],title='Nested Isosurfaces'),
    Viewpoint(description='Entry view',position=(0.0,0.0,50.0)),
    NavigationInfo(),
    Shape(
      appearance=Appearance(
        material=Material(diffuseColor=(1.0,0.0,0.0),transparency=0.75)),
      geometry=IndexedFaceSet(ccw=False,coordIndex=[0,1,65,64,-1,1,2,66,65,-1,2,3,67,66,-1,3,4,68,67,-1,4,5,69,68,-1,5,6,70,69,-1,6,7,71,70,-1,7,8,72,71,-1,8,9,73,72,-1,9,10,74,73,-1,10,11,75,74,-1,11,12,76,75,-1,12,13,77,76,-1,13,14,78,77,-1,14,15,79,78,-1,15,16,80,79,-1,16,17,81,80,-1,17,18,82,81,-1,18,19,83,82,-1,19,20,84,83,-1,20,21,85,84,-1,21,22,86,85,-1,22,23,87,86,-1,23,24,88,87,-1,24,25,89,88,-1,25,26,90,89,-1,26,27,91,90,-1,27,28,92,91,-1,28,29,93,92,-1,29,30,94,93,-1,30,31,95,94,-1,31,32,96,95,-1,32,33,97,96,-1,33,34,98,97,-1,34,35,99,98,-1,35,36,100,99,-1,36,37,101,100,-1,37,38,102,101,-1,38,39,103,102,-1,39,40,104,103,-1,40,41,105,104,-1,41,42,106,105,-1,42,43,107,106,-1,43,44,108,107,-1,44,45,109,108,-1,45,46,110,109,-1,46,47,111,110,-1,47,48,112,111,-1,48,49,113,112,-1,49,50,114,113,-1,50,51,115,114,-1,51,52,116,115,-1,52,53,117,116,-1,53,54,118,117,-1,54,55,119,118,-1,55,56,120,119,-1,56,57,121,120,-1,57,58,122,121,-1,58,59,123,122,-1,59,60,124,123,-1,60,61,125,124,-1,61,62,126,125,-1,62,63,127,126,-1,63,0,64,127,-1,64,65,129,128,-1,65,66,130,129,-1,66,67,131,130,-1,67,68,132,131,-1,68,69,133,132,-1,69,70,134,133,-1,70,71,135,134,-1,71,72,136,135,-1,72,73,137,136,-1,73,74,138,137,-1,74,75,139,138,-1,75,76,140,139,-1,76,77,141,140,-1,77,78,142,141,-1,78,79,143,142,-1,79,80,144,143,-1,80,81,145,144,-1,81,82,146,145,-1,82,83,147,146,-1,83,84,148,147,-1,84,85,149,148,-1,85,86,150,149,-1,86,87,151,150,-1,87,88,152,151,-1,88,89,153,152,-1,89,90,154,153,-1,90,91,155,154,-1,91,92,156,155,-1,92,93,157,156,-1,93,94,158,157,-1,94,95,159,158,-1,95,96,160,159,-1,96,97,161,160,-1,97,98,162,161,-1,98,99,163,162,-1,99,100,164,163,-1,100,101,165,164,-1,101,102,166,165,-1,102,103,167,166,-1,103,104,168,167,-1,104,105,169,168,-1,105,106,170,169,-1,106,107,171,170,-1,107,108,172,171,-1,108,109,173,172,-1,109,110,174,173,-1,110,111,175,174,-1,111,112,176,175,-1,112,113,177,176,-1,113,114,178,177,-1,114,115,179,178,-1,115,116,180,179,-1,116,117,181,180,-1,117,118,182,181,-1,118,119,183,182,-1,119,120,184,183,-1,120,121,185,184,-1,121,122,186,185,-1,122,123,187,186,-1,123,124,188,187,-1,124,125,189,188,-1,125,126,190,189,-1,126,127,191,190,-1,127,64,128,191,-1,128,129,193,192,-1,129,130,194,193,-1,130,131,195,194,-1,131,132,196,195,-1,132,133,197,196,-1,133,134,198,197,-1,134,135,199,198,-1,135,136,200,199,-1,136,137,201,200,-1,137,138,202,201,-1,138,139,203,202,-1,139,140,204,203,-1,140,141,205,204,-1,141,142,206,205,-1,142,143,207,206,-1,143,144,208,207,-1,144,145,209,208,-1,145,146,210,209,-1,146,147,211,210,-1,147,148,212,211,-1,148,149,213,212,-1,149,150,214,213,-1,150,151,215,214,-1,151,152,216,215,-1,152,153,217,216,-1,153,154,218,217,-1,154,155,219,218,-1,155,156,220,219,-1,156,157,221,220,-1,157,158,222,221,-1,158,159,223,222,-1,159,160,224,223,-1,160,161,225,224,-1,161,162,226,225,-1,162,163,227,226,-1,163,164,228,227,-1,164,165,229,228,-1,165,166,230,229,-1,166,167,231,230,-1,167,168,232,231,-1,168,169,233,232,-1,169,170,234,233,-1,170,171,235,234,-1,171,172,236,235,-1,172,173,237,236,-1,173,174,238,237,-1,174,175,239,238,-1,175,176,240,239,-1,176,177,241,240,-1,177,178,242,241,-1,178,179,243,242,-1,179,180,244,243,-1,180,181,245,244,-1,181,182,246,245,-1,182,183,247,246,-1,183,184,248,247,-1,184,185,249,248,-1,185,186,250,249,-1,186,187,251,250,-1,187,188,252,251,-1,188,189,253,252,-1,189,190,254,253,-1,190,191,255,254,-1,191,128,192,255,-1,192,193,257,256,-1,193,194,258,257,-1,194,195,259,258,-1,195,196,260,259,-1,196,197,261,260,-1,197,198,262,261,-1,198,199,263,262,-1,199,200,264,263,-1,200,201,265,264,-1,201,202,266,265,-1,202,203,267,266,-1,203,204,268,267,-1,204,205,269,268,-1,205,206,270,269,-1,206,207,271,270,-1,207,208,272,271,-1,208,209,273,272,-1,209,210,274,273,-1,210,211,275,274,-1,211,212,276,275,-1,212,213,277,276,-1,213,214,278,277,-1,214,215,279,278,-1,215,216,280,279,-1,216,217,281,280,-1,217,218,282,281,-1,218,219,283,282,-1,219,220,284,283,-1,220,221,285,284,-1,221,222,286,285,-1,222,223,287,286,-1,223,224,288,287,-1,224,225,289,288,-1,225,226,290,289,-1,226,227,291,290,-1,227,228,292,291,-1,228,229,293,292,-1,229,230,294,293,-1,230,231,295,294,-1,231,232,296,295,-1,232,233,297,296,-1,233,234,298,297,-1,234,235,299,298,-1,235,236,300,299,-1,236,237,301,300,-1,237,238,302,301,-1,238,239,303,302,-1,239,240,304,303,-1,240,241,305,304,-1,241,242,306,305,-1,242,243,307,306,-1,243,244,308,307,-1,244,245,309,308,-1,245,246,310,309,-1,246,247,311,310,-1,247,248,312,311,-1,248,249,313,312,-1,249,250,314,313,-1,250,251,315,314,-1,251,252,316,315,-1,252,253,317,316,-1,253,254,318,317,-1,254,255,319,318,-1,255,192,256,319,-1,256,257,321,320,-1,257,258,322,321,-1,258,259,323,322,-1,259,260,324,323,-1,260,261,325,324,-1,261,262,326,325,-1,262,263,327,326,-1,263,264,328,327,-1,264,265,329,328,-1,265,266,330,329,-1,266,267,331,330,-1,267,268,332,331,-1,268,269,333,332,-1,269,270,334,333,-1,270,271,335,334,-1,271,272,336,335,-1,272,273,337,336,-1,273,274,338,337,-1,274,275,339,338,-1,275,276,340,339,-1,276,277,341,340,-1,277,278,342,341,-1,278,279,343,342,-1,279,280,344,343,-1,280,281,345,344,-1,281,282,346,345,-1,282,283,347,346,-1,283,284,348,347,-1,284,285,349,348,-1,285,286,350,349,-1,286,287,351,350,-1,287,288,352,351,-1,288,289,353,352,-1,289,290,354,353,-1,290,291,355,354,-1,291,292,356,355,-1,292,293,357,356,-1,293,294,358,357,-1,294,295,359,358,-1,295,296,360,359,-1,296,297,361,360,-1,297,298,362,361,-1,298,299,363,362,-1,299,300,364,363,-1,300,301,365,364,-1,301,302,366,365,-1,302,303,367,366,-1,303,304,368,367,-1,304,305,369,368,-1,305,306,370,369,-1,306,307,371,370,-1,307,308,372,371,-1,308,309,373,372,-1,309,310,374,373,-1,310,311,375,374,-1,311,312,376,375,-1,312,313,377,376,-1,313,314,378,377,-1,314,315,379,378,-1,315,316,380,379,-1,316,317,381,380,-1,317,318,382,381,-1,318,319,383,382,-1,319,256,320,383,-1,320,321,385,384,-1,321,322,386,385,-1,322,323,387,386,-1,323,324,388,387,-1,324,325,389,388,-1,325,326,390,389,-1,326,327,391,390,-1,327,328,392,391,-1,328,329,393,392,-1,329,330,394,393,-1,330,331,395,394,-1,331,332,396,395,-1,332,333,397,396,-1,333,334,398,397,-1,334,335,399,398,-1,335,336,400,399,-1,336,337,401,400,-1,337,338,402,401,-1,338,339,403,402,-1,339,340,404,403,-1,340,341,405,404,-1,341,342,406,405,-1,342,343,407,406,-1,343,344,408,407,-1,344,345,409,408,-1,345,346,410,409,-1,346,347,411,410,-1,347,348,412,411,-1,348,349,413,412,-1,349,350,414,413,-1,350,351,415,414,-1,351,352,416,415,-1,352,353,417,416,-1,353,354,418,417,-1,354,355,419,418,-1,355,356,420,419,-1,356,357,421,420,-1,357,358,422,421,-1,358,359,423,422,-1,359,360,424,423,-1,360,361,425,424,-1,361,362,426,425,-1,362,363,427,426,-1,363,364,428,427,-1,364,365,429,428,-1,365,366,430,429,-1,366,367,431,430,-1,367,368,432,431,-1,368,369,433,432,-1,369,370,434,433,-1,370,371,435,434,-1,371,372,436,435,-1,372,373,437,436,-1,373,374,438,437,-1,374,375,439,438,-1,375,376,440,439,-1,376,377,441,440,-1,377,378,442,441,-1,378,379,443,442,-1,379,380,444,443,-1,380,381,445,444,-1,381,382,446,445,-1,382,383,447,446,-1,383,320,384,447,-1,384,385,449,448,-1,385,386,450,449,-1,386,387,451,450,-1,387,388,452,451,-1,388,389,453,452,-1,389,390,454,453,-1,390,391,455,454,-1,391,392,456,455,-1,392,393,457,456,-1,393,394,458,457,-1,394,395,459,458,-1,395,396,460,459,-1,396,397,461,460,-1,397,398,462,461,-1,398,399,463,462,-1,399,400,464,463,-1,400,401,465,464,-1,401,402,466,465,-1,402,403,467,466,-1,403,404,468,467,-1,404,405,469,468,-1,405,406,470,469,-1,406,407,471,470,-1,407,408,472,471,-1,408,409,473,472,-1,409,410,474,473,-1,410,411,475,474,-1,411,412,476,475,-1,412,413,477,476,-1,413,414,478,477,-1,414,415,479,478,-1,415,416,480,479,-1,416,417,481,480,-1,417,418,482,481,-1,418,419,483,482,-1,419,420,484,483,-1,420,421,485,484,-1,421,422,486,485,-1,422,423,487,486,-1,423,424,488,487,-1,424,425,489,488,-1,425,426,490,489,-1,426,427,491,490,-1,427,428,492,491,-1,428,429,493,492,-1,429,430,494,493,-1,430,431,495,494,-1,431,432,496,495,-1,432,433,497,496,-1,433,434,498,497,-1,434,435,499,498,-1,435,436,500,499,-1,436,437,501,500,-1,437,438,502,501,-1,438,439,503,502,-1,439,440,504,503,-1,440,441,505,504,-1,441,442,506,505,-1,442,443,507,506,-1,443,444,508,507,-1,444,445,509,508,-1,445,446,510,509,-1,446,447,511,510,-1,447,384,448,511,-1,448,449,513,512,-1,449,450,514,513,-1,450,451,515,514,-1,451,452,516,515,-1,452,453,517,516,-1,453,454,518,517,-1,454,455,519,518,-1,455,456,520,519,-1,456,457,521,520,-1,457,458,522,521,-1,458,459,523,522,-1,459,460,524,523,-1,460,461,525,524,-1,461,462,526,525,-1,462,463,527,526,-1,463,464,528,527,-1,464,465,529,528,-1,465,466,530,529,-1,466,467,531,530,-1,467,468,532,531,-1,468,469,533,532,-1,469,470,534,533,-1,470,471,535,534,-1,471,472,536,535,-1,472,473,537,536,-1,473,474,538,537,-1,474,475,539,538,-1,475,476,540,539,-1,476,477,541,540,-1,477,478,542,541,-1,478,479,543,542,-1,479,480,544,543,-1,480,481,545,544,-1,481,482,546,545,-1,482,483,547,546,-1,483,484,548,547,-1,484,485,549,548,-1,485,486,550,549,-1,486,487,551,550,-1,487,488,552,551,-1,488,489,553,552,-1,489,490,554,553,-1,490,491,555,554,-1,491,492,556,555,-1,492,493,557,556,-1,493,494,558,557,-1,494,495,559,558,-1,495,496,560,559,-1,496,497,561,560,-1,497,498,562,561,-1,498,499,563,562,-1,499,500,564,563,-1,500,501,565,564,-1,501,502,566,565,-1,502,503,567,566,-1,503,504,568,567,-1,504,505,569,568,-1,505,506,570,569,-1,506,507,571,570,-1,507,508,572,571,-1,508,509,573,572,-1,509,510,574,573,-1,510,511,575,574,-1,511,448,512,575,-1,512,513,577,576,-1,513,514,578,577,-1,514,515,579,578,-1,515,516,580,579,-1,516,517,581,580,-1,517,518,582,581,-1,518,519,583,582,-1,519,520,584,583,-1,520,521,585,584,-1,521,522,586,585,-1,522,523,587,586,-1,523,524,588,587,-1,524,525,589,588,-1,525,526,590,589,-1,526,527,591,590,-1,527,528,592,591,-1,528,529,593,592,-1,529,530,594,593,-1,530,531,595,594,-1,531,532,596,595,-1,532,533,597,596,-1,533,534,598,597,-1,534,535,599,598,-1,535,536,600,599,-1,536,537,601,600,-1,537,538,602,601,-1,538,539,603,602,-1,539,540,604,603,-1,540,541,605,604,-1,541,542,606,605,-1,542,543,607,606,-1,543,544,608,607,-1,544,545,609,608,-1,545,546,610,609,-1,546,547,611,610,-1,547,548,612,611,-1,548,549,613,612,-1,549,550,614,613,-1,550,551,615,614,-1,551,552,616,615,-1,552,553,617,616,-1,553,554,618,617,-1,554,555,619,618,-1,555,556,620,619,-1,556,557,621,620,-1,557,558,622,621,-1,558,559,623,622,-1,559,560,624,623,-1,560,561,625,624,-1,561,562,626,625,-1,562,563,627,626,-1,563,564,628,627,-1,564,565,629,628,-1,565,566,630,629,-1,566,567,631,630,-1,567,568,632,631,-1,568,569,633,632,-1,569,570,634,633,-1,570,571,635,634,-1,571,572,636,635,-1,572,573,637,636,-1,573,574,638,637,-1,574,575,639,638,-1,575,512,576,639,-1,576,577,641,640,-1,577,578,642,641,-1,578,579,643,642,-1,579,580,644,643,-1,580,581,645,644,-1,581,582,646,645,-1,582,583,647,646,-1,583,584,648,647,-1,584,585,649,648,-1,585,586,650,649,-1,586,587,651,650,-1,587,588,652,651,-1,588,589,653,652,-1,589,590,654,653,-1,590,591,655,654,-1,591,592,656,655,-1,592,593,657,656,-1,593,594,658,657,-1,594,595,659,658,-1,595,596,660,659,-1,596,597,661,660,-1,597,598,662,661,-1,598,599,663,662,-1,599,600,664,663,-1,600,601,665,664,-1,601,602,666,665,-1,602,603,667,666,-1,603,604,668,667,-1,604,605,669,668,-1,605,606,670,669,-1,606,607,671,670,-1,607,608,672,671,-1,608,609,673,672,-1,609,610,674,673,-1,610,611,675,674,-1,611,612,676,675,-1,612,613,677,676,-1,613,614,678,677,-1,614,615,679,678,-1,615,616,680,679,-1,616,617,681,680,-1,617,618,682,681,-1,618,619,683,682,-1,619,620,684,683,-1,620,621,685,684,-1,621,622,686,685,-1,622,623,687,686,-1,623,624,688,687,-1,624,625,689,688,-1,625,626,690,689,-1,626,627,691,690,-1,627,628,692,691,-1,628,629,693,692,-1,629,630,694,693,-1,630,631,695,694,-1,631,632,696,695,-1,632,633,697,696,-1,633,634,698,697,-1,634,635,699,698,-1,635,636,700,699,-1,636,637,701,700,-1,637,638,702,701,-1,638,639,703,702,-1,639,576,640,703,-1,640,641,705,704,-1,641,642,706,705,-1,642,643,707,706,-1,643,644,708,707,-1,644,645,709,708,-1,645,646,710,709,-1,646,647,711,710,-1,647,648,712,711,-1,648,649,713,712,-1,649,650,714,713,-1,650,651,715,714,-1,651,652,716,715,-1,652,653,717,716,-1,653,654,718,717,-1,654,655,719,718,-1,655,656,720,719,-1,656,657,721,720,-1,657,658,722,721,-1,658,659,723,722,-1,659,660,724,723,-1,660,661,725,724,-1,661,662,726,725,-1,662,663,727,726,-1,663,664,728,727,-1,664,665,729,728,-1,665,666,730,729,-1,666,667,731,730,-1,667,668,732,731,-1,668,669,733,732,-1,669,670,734,733,-1,670,671,735,734,-1,671,672,736,735,-1,672,673,737,736,-1,673,674,738,737,-1,674,675,739,738,-1,675,676,740,739,-1,676,677,741,740,-1,677,678,742,741,-1,678,679,743,742,-1,679,680,744,743,-1,680,681,745,744,-1,681,682,746,745,-1,682,683,747,746,-1,683,684,748,747,-1,684,685,749,748,-1,685,686,750,749,-1,686,687,751,750,-1,687,688,752,751,-1,688,689,753,752,-1,689,690,754,753,-1,690,691,755,754,-1,691,692,756,755,-1,692,693,757,756,-1,693,694,758,757,-1,694,695,759,758,-1,695,696,760,759,-1,696,697,761,760,-1,697,698,762,761,-1,698,699,763,762,-1,699,700,764,763,-1,700,701,765,764,-1,701,702,766,765,-1,702,703,767,766,-1,703,640,704,767,-1,704,705,769,768,-1,705,706,770,769,-1,706,707,771,770,-1,707,708,772,771,-1,708,709,773,772,-1,709,710,774,773,-1,710,711,775,774,-1,711,712,776,775,-1,712,713,777,776,-1,713,714,778,777,-1,714,715,779,778,-1,715,716,780,779,-1,716,717,781,780,-1,717,718,782,781,-1,718,719,783,782,-1,719,720,784,783,-1,720,721,785,784,-1,721,722,786,785,-1,722,723,787,786,-1,723,724,788,787,-1,724,725,789,788,-1,725,726,790,789,-1,726,727,791,790,-1,727,728,792,791,-1,728,729,793,792,-1,729,730,794,793,-1,730,731,795,794,-1,731,732,796,795,-1,732,733,797,796,-1,733,734,798,797,-1,734,735,799,798,-1,735,736,800,799,-1,736,737,801,800,-1,737,738,802,801,-1,738,739,803,802,-1,739,740,804,803,-1,740,741,805,804,-1,741,742,806,805,-1,742,743,807,806,-1,743,744,808,807,-1,744,745,809,808,-1,745,746,810,809,-1,746,747,811,810,-1,747,748,812,811,-1,748,749,813,812,-1,749,750,814,813,-1,750,751,815,814,-1,751,752,816,815,-1,752,753,817,816,-1,753,754,818,817,-1,754,755,819,818,-1,755,756,820,819,-1,756,757,821,820,-1,757,758,822,821,-1,758,759,823,822,-1,759,760,824,823,-1,760,761,825,824,-1,761,762,826,825,-1,762,763,827,826,-1,763,764,828,827,-1,764,765,829,828,-1,765,766,830,829,-1,766,767,831,830,-1,767,704,768,831,-1,768,769,833,832,-1,769,770,834,833,-1,770,771,835,834,-1,771,772,836,835,-1,772,773,837,836,-1,773,774,838,837,-1,774,775,839,838,-1,775,776,840,839,-1,776,777,841,840,-1,777,778,842,841,-1,778,779,843,842,-1,779,780,844,843,-1,780,781,845,844,-1,781,782,846,845,-1,782,783,847,846,-1,783,784,848,847,-1,784,785,849,848,-1,785,786,850,849,-1,786,787,851,850,-1,787,788,852,851,-1,788,789,853,852,-1,789,790,854,853,-1,790,791,855,854,-1,791,792,856,855,-1,792,793,857,856,-1,793,794,858,857,-1,794,795,859,858,-1,795,796,860,859,-1,796,797,861,860,-1,797,798,862,861,-1,798,799,863,862,-1,799,800,864,863,-1,800,801,865,864,-1,801,802,866,865,-1,802,803,867,866,-1,803,804,868,867,-1,804,805,869,868,-1,805,806,870,869,-1,806,807,871,870,-1,807,808,872,871,-1,808,809,873,872,-1,809,810,874,873,-1,810,811,875,874,-1,811,812,876,875,-1,812,813,877,876,-1,813,814,878,877,-1,814,815,879,878,-1,815,816,880,879,-1,816,817,881,880,-1,817,818,882,881,-1,818,819,883,882,-1,819,820,884,883,-1,820,821,885,884,-1,821,822,886,885,-1,822,823,887,886,-1,823,824,888,887,-1,824,825,889,888,-1,825,826,890,889,-1,826,827,891,890,-1,827,828,892,891,-1,828,829,893,892,-1,829,830,894,893,-1,830,831,895,894,-1,831,768,832,895,-1,832,833,897,896,-1,833,834,898,897,-1,834,835,899,898,-1,835,836,900,899,-1,836,837,901,900,-1,837,838,902,901,-1,838,839,903,902,-1,839,840,904,903,-1,840,841,905,904,-1,841,842,906,905,-1,842,843,907,906,-1,843,844,908,907,-1,844,845,909,908,-1,845,846,910,909,-1,846,847,911,910,-1,847,848,912,911,-1,848,849,913,912,-1,849,850,914,913,-1,850,851,915,914,-1,851,852,916,915,-1,852,853,917,916,-1,853,854,918,917,-1,854,855,919,918,-1,855,856,920,919,-1,856,857,921,920,-1,857,858,922,921,-1,858,859,923,922,-1,859,860,924,923,-1,860,861,925,924,-1,861,862,926,925,-1,862,863,927,926,-1,863,864,928,927,-1,864,865,929,928,-1,865,866,930,929,-1,866,867,931,930,-1,867,868,932,931,-1,868,869,933,932,-1,869,870,934,933,-1,870,871,935,934,-1,871,872,936,935,-1,872,873,937,936,-1,873,874,938,937,-1,874,875,939,938,-1,875,876,940,939,-1,876,877,941,940,-1,877,878,942,941,-1,878,879,943,942,-1,879,880,944,943,-1,880,881,945,944,-1,881,882,946,945,-1,882,883,947,946,-1,883,884,948,947,-1,884,885,949,948,-1,885,886,950,949,-1,886,887,951,950,-1,887,888,952,951,-1,888,889,953,952,-1,889,890,954,953,-1,890,891,955,954,-1,891,892,956,955,-1,892,893,957,956,-1,893,894,958,957,-1,894,895,959,958,-1,895,832,896,959,-1,896,897,961,960,-1,897,898,962,961,-1,898,899,963,962,-1,899,900,964,963,-1,900,901,965,964,-1,901,902,966,965,-1,902,903,967,966,-1,903,904,968,967,-1,904,905,969,968,-1,905,906,970,969,-1,906,907,971,970,-1,907,908,972,971,-1,908,909,973,972,-1,909,910,974,973,-1,910,911,975,974,-1,911,912,976,975,-1,912,913,977,976,-1,913,914,978,977,-1,914,915,979,978,-1,915,916,980,979,-1,916,917,981,980,-1,917,918,982,981,-1,918,919,983,982,-1,919,920,984,983,-1,920,921,985,984,-1,921,922,986,985,-1,922,923,987,986,-1,923,924,988,987,-1,924,925,989,988,-1,925,926,990,989,-1,926,927,991,990,-1,927,928,992,991,-1,928,929,993,992,-1,929,930,994,993,-1,930,931,995,994,-1,931,932,996,995,-1,932,933,997,996,-1,933,934,998,997,-1,934,935,999,998,-1,935,936,1000,999,-1,936,937,1001,1000,-1,937,938,1002,1001,-1,938,939,1003,1002,-1,939,940,1004,1003,-1,940,941,1005,1004,-1,941,942,1006,1005,-1,942,943,1007,1006,-1,943,944,1008,1007,-1,944,945,1009,1008,-1,945,946,1010,1009,-1,946,947,1011,1010,-1,947,948,1012,1011,-1,948,949,1013,1012,-1,949,950,1014,1013,-1,950,951,1015,1014,-1,951,952,1016,1015,-1,952,953,1017,1016,-1,953,954,1018,1017,-1,954,955,1019,1018,-1,955,956,1020,1019,-1,956,957,1021,1020,-1,957,958,1022,1021,-1,958,959,1023,1022,-1,959,896,960,1023,-1,960,961,1025,1024,-1,961,962,1026,1025,-1,962,963,1027,1026,-1,963,964,1028,1027,-1,964,965,1029,1028,-1,965,966,1030,1029,-1,966,967,1031,1030,-1,967,968,1032,1031,-1,968,969,1033,1032,-1,969,970,1034,1033,-1,970,971,1035,1034,-1,971,972,1036,1035,-1,972,973,1037,1036,-1,973,974,1038,1037,-1,974,975,1039,1038,-1,975,976,1040,1039,-1,976,977,1041,1040,-1,977,978,1042,1041,-1,978,979,1043,1042,-1,979,980,1044,1043,-1,980,981,1045,1044,-1,981,982,1046,1045,-1,982,983,1047,1046,-1,983,984,1048,1047,-1,984,985,1049,1048,-1,985,986,1050,1049,-1,986,987,1051,1050,-1,987,988,1052,1051,-1,988,989,1053,1052,-1,989,990,1054,1053,-1,990,991,1055,1054,-1,991,992,1056,1055,-1,992,993,1057,1056,-1,993,994,1058,1057,-1,994,995,1059,1058,-1,995,996,1060,1059,-1,996,997,1061,1060,-1,997,998,1062,1061,-1,998,999,1063,1062,-1,999,1000,1064,1063,-1,1000,1001,1065,1064,-1,1001,1002,1066,1065,-1,1002,1003,1067,1066,-1,1003,1004,1068,1067,-1,1004,1005,1069,1068,-1,1005,1006,1070,1069,-1,1006,1007,1071,1070,-1,1007,1008,1072,1071,-1,1008,1009,1073,1072,-1,1009,1010,1074,1073,-1,1010,1011,1075,1074,-1,1011,1012,1076,1075,-1,1012,1013,1077,1076,-1,1013,1014,1078,1077,-1,1014,1015,1079,1078,-1,1015,1016,1080,1079,-1,1016,1017,1081,1080,-1,1017,1018,1082,1081,-1,1018,1019,1083,1082,-1,1019,1020,1084,1083,-1,1020,1021,1085,1084,-1,1021,1022,1086,1085,-1,1022,1023,1087,1086,-1,1023,960,1024,1087,-1,1024,1025,1089,1088,-1,1025,1026,1090,1089,-1,1026,1027,1091,1090,-1,1027,1028,1092,1091,-1,1028,1029,1093,1092,-1,1029,1030,1094,1093,-1,1030,1031,1095,1094,-1,1031,1032,1096,1095,-1,1032,1033,1097,1096,-1,1033,1034,1098,1097,-1,1034,1035,1099,1098,-1,1035,1036,1100,1099,-1,1036,1037,1101,1100,-1,1037,1038,1102,1101,-1,1038,1039,1103,1102,-1,1039,1040,1104,1103,-1,1040,1041,1105,1104,-1,1041,1042,1106,1105,-1,1042,1043,1107,1106,-1,1043,1044,1108,1107,-1,1044,1045,1109,1108,-1,1045,1046,1110,1109,-1,1046,1047,1111,1110,-1,1047,1048,1112,1111,-1,1048,1049,1113,1112,-1,1049,1050,1114,1113,-1,1050,1051,1115,1114,-1,1051,1052,1116,1115,-1,1052,1053,1117,1116,-1,1053,1054,1118,1117,-1,1054,1055,1119,1118,-1,1055,1056,1120,1119,-1,1056,1057,1121,1120,-1,1057,1058,1122,1121,-1,1058,1059,1123,1122,-1,1059,1060,1124,1123,-1,1060,1061,1125,1124,-1,1061,1062,1126,1125,-1,1062,1063,1127,1126,-1,1063,1064,1128,1127,-1,1064,1065,1129,1128,-1,1065,1066,1130,1129,-1,1066,1067,1131,1130,-1,1067,1068,1132,1131,-1,1068,1069,1133,1132,-1,1069,1070,1134,1133,-1,1070,1071,1135,1134,-1,1071,1072,1136,1135,-1,1072,1073,1137,1136,-1,1073,1074,1138,1137,-1,1074,1075,1139,1138,-1,1075,1076,1140,1139,-1,1076,1077,1141,1140,-1,1077,1078,1142,1141,-1,1078,1079,1143,1142,-1,1079,1080,1144,1143,-1,1080,1081,1145,1144,-1,1081,1082,1146,1145,-1,1082,1083,1147,1146,-1,1083,1084,1148,1147,-1,1084,1085,1149,1148,-1,1085,1086,1150,1149,-1,1086,1087,1151,1150,-1,1087,1024,1088,1151,-1,1088,1089,1153,1152,-1,1089,1090,1154,1153,-1,1090,1091,1155,1154,-1,1091,1092,1156,1155,-1,1092,1093,1157,1156,-1,1093,1094,1158,1157,-1,1094,1095,1159,1158,-1,1095,1096,1160,1159,-1,1096,1097,1161,1160,-1,1097,1098,1162,1161,-1,1098,1099,1163,1162,-1,1099,1100,1164,1163,-1,1100,1101,1165,1164,-1,1101,1102,1166,1165,-1,1102,1103,1167,1166,-1,1103,1104,1168,1167,-1,1104,1105,1169,1168,-1,1105,1106,1170,1169,-1,1106,1107,1171,1170,-1,1107,1108,1172,1171,-1,1108,1109,1173,1172,-1,1109,1110,1174,1173,-1,1110,1111,1175,1174,-1,1111,1112,1176,1175,-1,1112,1113,1177,1176,-1,1113,1114,1178,1177,-1,1114,1115,1179,1178,-1,1115,1116,1180,1179,-1,1116,1117,1181,1180,-1,1117,1118,1182,1181,-1,1118,1119,1183,1182,-1,1119,1120,1184,1183,-1,1120,1121,1185,1184,-1,1121,1122,1186,1185,-1,1122,1123,1187,1186,-1,1123,1124,1188,1187,-1,1124,1125,1189,1188,-1,1125,1126,1190,1189,-1,1126,1127,1191,1190,-1,1127,1128,1192,1191,-1,1128,1129,1193,1192,-1,1129,1130,1194,1193,-1,1130,1131,1195,1194,-1,1131,1132,1196,1195,-1,1132,1133,1197,1196,-1,1133,1134,1198,1197,-1,1134,1135,1199,1198,-1,1135,1136,1200,1199,-1,1136,1137,1201,1200,-1,1137,1138,1202,1201,-1,1138,1139,1203,1202,-1,1139,1140,1204,1203,-1,1140,1141,1205,1204,-1,1141,1142,1206,1205,-1,1142,1143,1207,1206,-1,1143,1144,1208,1207,-1,1144,1145,1209,1208,-1,1145,1146,1210,1209,-1,1146,1147,1211,1210,-1,1147,1148,1212,1211,-1,1148,1149,1213,1212,-1,1149,1150,1214,1213,-1,1150,1151,1215,1214,-1,1151,1088,1152,1215,-1,1152,1153,1217,1216,-1,1153,1154,1218,1217,-1,1154,1155,1219,1218,-1,1155,1156,1220,1219,-1,1156,1157,1221,1220,-1,1157,1158,1222,1221,-1,1158,1159,1223,1222,-1,1159,1160,1224,1223,-1,1160,1161,1225,1224,-1,1161,1162,1226,1225,-1,1162,1163,1227,1226,-1,1163,1164,1228,1227,-1,1164,1165,1229,1228,-1,1165,1166,1230,1229,-1,1166,1167,1231,1230,-1,1167,1168,1232,1231,-1,1168,1169,1233,1232,-1,1169,1170,1234,1233,-1,1170,1171,1235,1234,-1,1171,1172,1236,1235,-1,1172,1173,1237,1236,-1,1173,1174,1238,1237,-1,1174,1175,1239,1238,-1,1175,1176,1240,1239,-1,1176,1177,1241,1240,-1,1177,1178,1242,1241,-1,1178,1179,1243,1242,-1,1179,1180,1244,1243,-1,1180,1181,1245,1244,-1,1181,1182,1246,1245,-1,1182,1183,1247,1246,-1,1183,1184,1248,1247,-1,1184,1185,1249,1248,-1,1185,1186,1250,1249,-1,1186,1187,1251,1250,-1,1187,1188,1252,1251,-1,1188,1189,1253,1252,-1,1189,1190,1254,1253,-1,1190,1191,1255,1254,-1,1191,1192,1256,1255,-1,1192,1193,1257,1256,-1,1193,1194,1258,1257,-1,1194,1195,1259,1258,-1,1195,1196,1260,1259,-1,1196,1197,1261,1260,-1,1197,1198,1262,1261,-1,1198,1199,1263,1262,-1,1199,1200,1264,1263,-1,1200,1201,1265,1264,-1,1201,1202,1266,1265,-1,1202,1203,1267,1266,-1,1203,1204,1268,1267,-1,1204,1205,1269,1268,-1,1205,1206,1270,1269,-1,1206,1207,1271,1270,-1,1207,1208,1272,1271,-1,1208,1209,1273,1272,-1,1209,1210,1274,1273,-1,1210,1211,1275,1274,-1,1211,1212,1276,1275,-1,1212,1213,1277,1276,-1,1213,1214,1278,1277,-1,1214,1215,1279,1278,-1,1215,1152,1216,1279,-1,1216,1217,1281,1280,-1,1217,1218,1282,1281,-1,1218,1219,1283,1282,-1,1219,1220,1284,1283,-1,1220,1221,1285,1284,-1,1221,1222,1286,1285,-1,1222,1223,1287,1286,-1,1223,1224,1288,1287,-1,1224,1225,1289,1288,-1,1225,1226,1290,1289,-1,1226,1227,1291,1290,-1,1227,1228,1292,1291,-1,1228,1229,1293,1292,-1,1229,1230,1294,1293,-1,1230,1231,1295,1294,-1,1231,1232,1296,1295,-1,1232,1233,1297,1296,-1,1233,1234,1298,1297,-1,1234,1235,1299,1298,-1,1235,1236,1300,1299,-1,1236,1237,1301,1300,-1,1237,1238,1302,1301,-1,1238,1239,1303,1302,-1,1239,1240,1304,1303,-1,1240,1241,1305,1304,-1,1241,1242,1306,1305,-1,1242,1243,1307,1306,-1,1243,1244,1308,1307,-1,1244,1245,1309,1308,-1,1245,1246,1310,1309,-1,1246,1247,1311,1310,-1,1247,1248,1312,1311,-1,1248,1249,1313,1312,-1,1249,1250,1314,1313,-1,1250,1251,1315,1314,-1,1251,1252,1316,1315,-1,1252,1253,1317,1316,-1,1253,1254,1318,1317,-1,1254,1255,1319,1318,-1,1255,1256,1320,1319,-1,1256,1257,1321,1320,-1,1257,1258,1322,1321,-1,1258,1259,1323,1322,-1,1259,1260,1324,1323,-1,1260,1261,1325,1324,-1,1261,1262,1326,1325,-1,1262,1263,1327,1326,-1,1263,1264,1328,1327,-1,1264,1265,1329,1328,-1,1265,1266,1330,1329,-1,1266,1267,1331,1330,-1,1267,1268,1332,1331,-1,1268,1269,1333,1332,-1,1269,1270,1334,1333,-1,1270,1271,1335,1334,-1,1271,1272,1336,1335,-1,1272,1273,1337,1336,-1,1273,1274,1338,1337,-1,1274,1275,1339,1338,-1,1275,1276,1340,1339,-1,1276,1277,1341,1340,-1,1277,1278,1342,1341,-1,1278,1279,1343,1342,-1,1279,1216,1280,1343,-1,1280,1281,1345,1344,-1,1281,1282,1346,1345,-1,1282,1283,1347,1346,-1,1283,1284,1348,1347,-1,1284,1285,1349,1348,-1,1285,1286,1350,1349,-1,1286,1287,1351,1350,-1,1287,1288,1352,1351,-1,1288,1289,1353,1352,-1,1289,1290,1354,1353,-1,1290,1291,1355,1354,-1,1291,1292,1356,1355,-1,1292,1293,1357,1356,-1,1293,1294,1358,1357,-1,1294,1295,1359,1358,-1,1295,1296,1360,1359,-1,1296,1297,1361,1360,-1,1297,1298,1362,1361,-1,1298,1299,1363,1362,-1,1299,1300,1364,1363,-1,1300,1301,1365,1364,-1,1301,1302,1366,1365,-1,1302,1303,1367,1366,-1,1303,1304,1368,1367,-1,1304,1305,1369,1368,-1,1305,1306,1370,1369,-1,1306,1307,1371,1370,-1,1307,1308,1372,1371,-1,1308,1309,1373,1372,-1,1309,1310,1374,1373,-1,1310,1311,1375,1374,-1,1311,1312,1376,1375,-1,1312,1313,1377,1376,-1,1313,1314,1378,1377,-1,1314,1315,1379,1378,-1,1315,1316,1380,1379,-1,1316,1317,1381,1380,-1,1317,1318,1382,1381,-1,1318,1319,1383,1382,-1,1319,1320,1384,1383,-1,1320,1321,1385,1384,-1,1321,1322,1386,1385,-1,1322,1323,1387,1386,-1,1323,1324,1388,1387,-1,1324,1325,1389,1388,-1,1325,1326,1390,1389,-1,1326,1327,1391,1390,-1,1327,1328,1392,1391,-1,1328,1329,1393,1392,-1,1329,1330,1394,1393,-1,1330,1331,1395,1394,-1,1331,1332,1396,1395,-1,1332,1333,1397,1396,-1,1333,1334,1398,1397,-1,1334,1335,1399,1398,-1,1335,1336,1400,1399,-1,1336,1337,1401,1400,-1,1337,1338,1402,1401,-1,1338,1339,1403,1402,-1,1339,1340,1404,1403,-1,1340,1341,1405,1404,-1,1341,1342,1406,1405,-1,1342,1343,1407,1406,-1,1343,1280,1344,1407,-1,1344,1345,1409,1408,-1,1345,1346,1410,1409,-1,1346,1347,1411,1410,-1,1347,1348,1412,1411,-1,1348,1349,1413,1412,-1,1349,1350,1414,1413,-1,1350,1351,1415,1414,-1,1351,1352,1416,1415,-1,1352,1353,1417,1416,-1,1353,1354,1418,1417,-1,1354,1355,1419,1418,-1,1355,1356,1420,1419,-1,1356,1357,1421,1420,-1,1357,1358,1422,1421,-1,1358,1359,1423,1422,-1,1359,1360,1424,1423,-1,1360,1361,1425,1424,-1,1361,1362,1426,1425,-1,1362,1363,1427,1426,-1,1363,1364,1428,1427,-1,1364,1365,1429,1428,-1,1365,1366,1430,1429,-1,1366,1367,1431,1430,-1,1367,1368,1432,1431,-1,1368,1369,1433,1432,-1,1369,1370,1434,1433,-1,1370,1371,1435,1434,-1,1371,1372,1436,1435,-1,1372,1373,1437,1436,-1,1373,1374,1438,1437,-1,1374,1375,1439,1438,-1,1375,1376,1440,1439,-1,1376,1377,1441,1440,-1,1377,1378,1442,1441,-1,1378,1379,1443,1442,-1,1379,1380,1444,1443,-1,1380,1381,1445,1444,-1,1381,1382,1446,1445,-1,1382,1383,1447,1446,-1,1383,1384,1448,1447,-1,1384,1385,1449,1448,-1,1385,1386,1450,1449,-1,1386,1387,1451,1450,-1,1387,1388,1452,1451,-1,1388,1389,1453,1452,-1,1389,1390,1454,1453,-1,1390,1391,1455,1454,-1,1391,1392,1456,1455,-1,1392,1393,1457,1456,-1,1393,1394,1458,1457,-1,1394,1395,1459,1458,-1,1395,1396,1460,1459,-1,1396,1397,1461,1460,-1,1397,1398,1462,1461,-1,1398,1399,1463,1462,-1,1399,1400,1464,1463,-1,1400,1401,1465,1464,-1,1401,1402,1466,1465,-1,1402,1403,1467,1466,-1,1403,1404,1468,1467,-1,1404,1405,1469,1468,-1,1405,1406,1470,1469,-1,1406,1407,1471,1470,-1,1407,1344,1408,1471,-1,1408,1409,1473,1472,-1,1409,1410,1474,1473,-1,1410,1411,1475,1474,-1,1411,1412,1476,1475,-1,1412,1413,1477,1476,-1,1413,1414,1478,1477,-1,1414,1415,1479,1478,-1,1415,1416,1480,1479,-1,1416,1417,1481,1480,-1,1417,1418,1482,1481,-1,1418,1419,1483,1482,-1,1419,1420,1484,1483,-1,1420,1421,1485,1484,-1,1421,1422,1486,1485,-1,1422,1423,1487,1486,-1,1423,1424,1488,1487,-1,1424,1425,1489,1488,-1,1425,1426,1490,1489,-1,1426,1427,1491,1490,-1,1427,1428,1492,1491,-1,1428,1429,1493,1492,-1,1429,1430,1494,1493,-1,1430,1431,1495,1494,-1,1431,1432,1496,1495,-1,1432,1433,1497,1496,-1,1433,1434,1498,1497,-1,1434,1435,1499,1498,-1,1435,1436,1500,1499,-1,1436,1437,1501,1500,-1,1437,1438,1502,1501,-1,1438,1439,1503,1502,-1,1439,1440,1504,1503,-1,1440,1441,1505,1504,-1,1441,1442,1506,1505,-1,1442,1443,1507,1506,-1,1443,1444,1508,1507,-1,1444,1445,1509,1508,-1,1445,1446,1510,1509,-1,1446,1447,1511,1510,-1,1447,1448,1512,1511,-1,1448,1449,1513,1512,-1,1449,1450,1514,1513,-1,1450,1451,1515,1514,-1,1451,1452,1516,1515,-1,1452,1453,1517,1516,-1,1453,1454,1518,1517,-1,1454,1455,1519,1518,-1,1455,1456,1520,1519,-1,1456,1457,1521,1520,-1,1457,1458,1522,1521,-1,1458,1459,1523,1522,-1,1459,1460,1524,1523,-1,1460,1461,1525,1524,-1,1461,1462,1526,1525,-1,1462,1463,1527,1526,-1,1463,1464,1528,1527,-1,1464,1465,1529,1528,-1,1465,1466,1530,1529,-1,1466,1467,1531,1530,-1,1467,1468,1532,1531,-1,1468,1469,1533,1532,-1,1469,1470,1534,1533,-1,1470,1471,1535,1534,-1,1471,1408,1472,1535,-1,1472,1473,1537,1536,-1,1473,1474,1538,1537,-1,1474,1475,1539,1538,-1,1475,1476,1540,1539,-1,1476,1477,1541,1540,-1,1477,1478,1542,1541,-1,1478,1479,1543,1542,-1,1479,1480,1544,1543,-1,1480,1481,1545,1544,-1,1481,1482,1546,1545,-1,1482,1483,1547,1546,-1,1483,1484,1548,1547,-1,1484,1485,1549,1548,-1,1485,1486,1550,1549,-1,1486,1487,1551,1550,-1,1487,1488,1552,1551,-1,1488,1489,1553,1552,-1,1489,1490,1554,1553,-1,1490,1491,1555,1554,-1,1491,1492,1556,1555,-1,1492,1493,1557,1556,-1,1493,1494,1558,1557,-1,1494,1495,1559,1558,-1,1495,1496,1560,1559,-1,1496,1497,1561,1560,-1,1497,1498,1562,1561,-1,1498,1499,1563,1562,-1,1499,1500,1564,1563,-1,1500,1501,1565,1564,-1,1501,1502,1566,1565,-1,1502,1503,1567,1566,-1,1503,1504,1568,1567,-1,1504,1505,1569,1568,-1,1505,1506,1570,1569,-1,1506,1507,1571,1570,-1,1507,1508,1572,1571,-1,1508,1509,1573,1572,-1,1509,1510,1574,1573,-1,1510,1511,1575,1574,-1,1511,1512,1576,1575,-1,1512,1513,1577,1576,-1,1513,1514,1578,1577,-1,1514,1515,1579,1578,-1,1515,1516,1580,1579,-1,1516,1517,1581,1580,-1,1517,1518,1582,1581,-1,1518,1519,1583,1582,-1,1519,1520,1584,1583,-1,1520,1521,1585,1584,-1,1521,1522,1586,1585,-1,1522,1523,1587,1586,-1,1523,1524,1588,1587,-1,1524,1525,1589,1588,-1,1525,1526,1590,1589,-1,1526,1527,1591,1590,-1,1527,1528,1592,1591,-1,1528,1529,1593,1592,-1,1529,1530,1594,1593,-1,1530,1531,1595,1594,-1,1531,1532,1596,1595,-1,1532,1533,1597,1596,-1,1533,1534,1598,1597,-1,1534,1535,1599,1598,-1,1535,1472,1536,1599,-1,1536,1537,1601,1600,-1,1537,1538,1602,1601,-1,1538,1539,1603,1602,-1,1539,1540,1604,1603,-1,1540,1541,1605,1604,-1,1541,1542,1606,1605,-1,1542,1543,1607,1606,-1,1543,1544,1608,1607,-1,1544,1545,1609,1608,-1,1545,1546,1610,1609,-1,1546,1547,1611,1610,-1,1547,1548,1612,1611,-1,1548,1549,1613,1612,-1,1549,1550,1614,1613,-1,1550,1551,1615,1614,-1,1551,1552,1616,1615,-1,1552,1553,1617,1616,-1,1553,1554,1618,1617,-1,1554,1555,1619,1618,-1,1555,1556,1620,1619,-1,1556,1557,1621,1620,-1,1557,1558,1622,1621,-1,1558,1559,1623,1622,-1,1559,1560,1624,1623,-1,1560,1561,1625,1624,-1,1561,1562,1626,1625,-1,1562,1563,1627,1626,-1,1563,1564,1628,1627,-1,1564,1565,1629,1628,-1,1565,1566,1630,1629,-1,1566,1567,1631,1630,-1,1567,1568,1632,1631,-1,1568,1569,1633,1632,-1,1569,1570,1634,1633,-1,1570,1571,1635,1634,-1,1571,1572,1636,1635,-1,1572,1573,1637,1636,-1,1573,1574,1638,1637,-1,1574,1575,1639,1638,-1,1575,1576,1640,1639,-1,1576,1577,1641,1640,-1,1577,1578,1642,1641,-1,1578,1579,1643,1642,-1,1579,1580,1644,1643,-1,1580,1581,1645,1644,-1,1581,1582,1646,1645,-1,1582,1583,1647,1646,-1,1583,1584,1648,1647,-1,1584,1585,1649,1648,-1,1585,1586,1650,1649,-1,1586,1587,1651,1650,-1,1587,1588,1652,1651,-1,1588,1589,1653,1652,-1,1589,1590,1654,1653,-1,1590,1591,1655,1654,-1,1591,1592,1656,1655,-1,1592,1593,1657,1656,-1,1593,1594,1658,1657,-1,1594,1595,1659,1658,-1,1595,1596,1660,1659,-1,1596,1597,1661,1660,-1,1597,1598,1662,1661,-1,1598,1599,1663,1662,-1,1599,1536,1600,1663,-1,1600,1601,1665,1664,-1,1601,1602,1666,1665,-1,1602,1603,1667,1666,-1,1603,1604,1668,1667,-1,1604,1605,1669,1668,-1,1605,1606,1670,1669,-1,1606,1607,1671,1670,-1,1607,1608,1672,1671,-1,1608,1609,1673,1672,-1,1609,1610,1674,1673,-1,1610,1611,1675,1674,-1,1611,1612,1676,1675,-1,1612,1613,1677,1676,-1,1613,1614,1678,1677,-1,1614,1615,1679,1678,-1,1615,1616,1680,1679,-1,1616,1617,1681,1680,-1,1617,1618,1682,1681,-1,1618,1619,1683,1682,-1,1619,1620,1684,1683,-1,1620,1621,1685,1684,-1,1621,1622,1686,1685,-1,1622,1623,1687,1686,-1,1623,1624,1688,1687,-1,1624,1625,1689,1688,-1,1625,1626,1690,1689,-1,1626,1627,1691,1690,-1,1627,1628,1692,1691,-1,1628,1629,1693,1692,-1,1629,1630,1694,1693,-1,1630,1631,1695,1694,-1,1631,1632,1696,1695,-1,1632,1633,1697,1696,-1,1633,1634,1698,1697,-1,1634,1635,1699,1698,-1,1635,1636,1700,1699,-1,1636,1637,1701,1700,-1,1637,1638,1702,1701,-1,1638,1639,1703,1702,-1,1639,1640,1704,1703,-1,1640,1641,1705,1704,-1,1641,1642,1706,1705,-1,1642,1643,1707,1706,-1,1643,1644,1708,1707,-1,1644,1645,1709,1708,-1,1645,1646,1710,1709,-1,1646,1647,1711,1710,-1,1647,1648,1712,1711,-1,1648,1649,1713,1712,-1,1649,1650,1714,1713,-1,1650,1651,1715,1714,-1,1651,1652,1716,1715,-1,1652,1653,1717,1716,-1,1653,1654,1718,1717,-1,1654,1655,1719,1718,-1,1655,1656,1720,1719,-1,1656,1657,1721,1720,-1,1657,1658,1722,1721,-1,1658,1659,1723,1722,-1,1659,1660,1724,1723,-1,1660,1661,1725,1724,-1,1661,1662,1726,1725,-1,1662,1663,1727,1726,-1,1663,1600,1664,1727,-1,1664,1665,1729,1728,-1,1665,1666,1730,1729,-1,1666,1667,1731,1730,-1,1667,1668,1732,1731,-1,1668,1669,1733,1732,-1,1669,1670,1734,1733,-1,1670,1671,1735,1734,-1,1671,1672,1736,1735,-1,1672,1673,1737,1736,-1,1673,1674,1738,1737,-1,1674,1675,1739,1738,-1,1675,1676,1740,1739,-1,1676,1677,1741,1740,-1,1677,1678,1742,1741,-1,1678,1679,1743,1742,-1,1679,1680,1744,1743,-1,1680,1681,1745,1744,-1,1681,1682,1746,1745,-1,1682,1683,1747,1746,-1,1683,1684,1748,1747,-1,1684,1685,1749,1748,-1,1685,1686,1750,1749,-1,1686,1687,1751,1750,-1,1687,1688,1752,1751,-1,1688,1689,1753,1752,-1,1689,1690,1754,1753,-1,1690,1691,1755,1754,-1,1691,1692,1756,1755,-1,1692,1693,1757,1756,-1,1693,1694,1758,1757,-1,1694,1695,1759,1758,-1,1695,1696,1760,1759,-1,1696,1697,1761,1760,-1,1697,1698,1762,1761,-1,1698,1699,1763,1762,-1,1699,1700,1764,1763,-1,1700,1701,1765,1764,-1,1701,1702,1766,1765,-1,1702,1703,1767,1766,-1,1703,1704,1768,1767,-1,1704,1705,1769,1768,-1,1705,1706,1770,1769,-1,1706,1707,1771,1770,-1,1707,1708,1772,1771,-1,1708,1709,1773,1772,-1,1709,1710,1774,1773,-1,1710,1711,1775,1774,-1,1711,1712,1776,1775,-1,1712,1713,1777,1776,-1,1713,1714,1778,1777,-1,1714,1715,1779,1778,-1,1715,1716,1780,1779,-1,1716,1717,1781,1780,-1,1717,1718,1782,1781,-1,1718,1719,1783,1782,-1,1719,1720,1784,1783,-1,1720,1721,1785,1784,-1,1721,1722,1786,1785,-1,1722,1723,1787,1786,-1,1723,1724,1788,1787,-1,1724,1725,1789,1788,-1,1725,1726,1790,1789,-1,1726,1727,1791,1790,-1,1727,1664,1728,1791,-1,1728,1729,1793,1792,-1,1729,1730,1794,1793,-1,1730,1731,1795,1794,-1,1731,1732,1796,1795,-1,1732,1733,1797,1796,-1,1733,1734,1798,1797,-1,1734,1735,1799,1798,-1,1735,1736,1800,1799,-1,1736,1737,1801,1800,-1,1737,1738,1802,1801,-1,1738,1739,1803,1802,-1,1739,1740,1804,1803,-1,1740,1741,1805,1804,-1,1741,1742,1806,1805,-1,1742,1743,1807,1806,-1,1743,1744,1808,1807,-1,1744,1745,1809,1808,-1,1745,1746,1810,1809,-1,1746,1747,1811,1810,-1,1747,1748,1812,1811,-1,1748,1749,1813,1812,-1,1749,1750,1814,1813,-1,1750,1751,1815,1814,-1,1751,1752,1816,1815,-1,1752,1753,1817,1816,-1,1753,1754,1818,1817,-1,1754,1755,1819,1818,-1,1755,1756,1820,1819,-1,1756,1757,1821,1820,-1,1757,1758,1822,1821,-1,1758,1759,1823,1822,-1,1759,1760,1824,1823,-1,1760,1761,1825,1824,-1,1761,1762,1826,1825,-1,1762,1763,1827,1826,-1,1763,1764,1828,1827,-1,1764,1765,1829,1828,-1,1765,1766,1830,1829,-1,1766,1767,1831,1830,-1,1767,1768,1832,1831,-1,1768,1769,1833,1832,-1,1769,1770,1834,1833,-1,1770,1771,1835,1834,-1,1771,1772,1836,1835,-1,1772,1773,1837,1836,-1,1773,1774,1838,1837,-1,1774,1775,1839,1838,-1,1775,1776,1840,1839,-1,1776,1777,1841,1840,-1,1777,1778,1842,1841,-1,1778,1779,1843,1842,-1,1779,1780,1844,1843,-1,1780,1781,1845,1844,-1,1781,1782,1846,1845,-1,1782,1783,1847,1846,-1,1783,1784,1848,1847,-1,1784,1785,1849,1848,-1,1785,1786,1850,1849,-1,1786,1787,1851,1850,-1,1787,1788,1852,1851,-1,1788,1789,1853,1852,-1,1789,1790,1854,1853,-1,1790,1791,1855,1854,-1,1791,1728,1792,1855,-1,1792,1793,1857,1856,-1,1793,1794,1858,1857,-1,1794,1795,1859,1858,-1,1795,1796,1860,1859,-1,1796,1797,1861,1860,-1,1797,1798,1862,1861,-1,1798,1799,1863,1862,-1,1799,1800,1864,1863,-1,1800,1801,1865,1864,-1,1801,1802,1866,1865,-1,1802,1803,1867,1866,-1,1803,1804,1868,1867,-1,1804,1805,1869,1868,-1,1805,1806,1870,1869,-1,1806,1807,1871,1870,-1,1807,1808,1872,1871,-1,1808,1809,1873,1872,-1,1809,1810,1874,1873,-1,1810,1811,1875,1874,-1,1811,1812,1876,1875,-1,1812,1813,1877,1876,-1,1813,1814,1878,1877,-1,1814,1815,1879,1878,-1,1815,1816,1880,1879,-1,1816,1817,1881,1880,-1,1817,1818,1882,1881,-1,1818,1819,1883,1882,-1,1819,1820,1884,1883,-1,1820,1821,1885,1884,-1,1821,1822,1886,1885,-1,1822,1823,1887,1886,-1,1823,1824,1888,1887,-1,1824,1825,1889,1888,-1,1825,1826,1890,1889,-1,1826,1827,1891,1890,-1,1827,1828,1892,1891,-1,1828,1829,1893,1892,-1,1829,1830,1894,1893,-1,1830,1831,1895,1894,-1,1831,1832,1896,1895,-1,1832,1833,1897,1896,-1,1833,1834,1898,1897,-1,1834,1835,1899,1898,-1,1835,1836,1900,1899,-1,1836,1837,1901,1900,-1,1837,1838,1902,1901,-1,1838,1839,1903,1902,-1,1839,1840,1904,1903,-1,1840,1841,1905,1904,-1,1841,1842,1906,1905,-1,1842,1843,1907,1906,-1,1843,1844,1908,1907,-1,1844,1845,1909,1908,-1,1845,1846,1910,1909,-1,1846,1847,1911,1910,-1,1847,1848,1912,1911,-1,1848,1849,1913,1912,-1,1849,1850,1914,1913,-1,1850,1851,1915,1914,-1,1851,1852,1916,1915,-1,1852,1853,1917,1916,-1,1853,1854,1918,1917,-1,1854,1855,1919,1918,-1,1855,1792,1856,1919,-1,1856,1857,1921,1920,-1,1857,1858,1922,1921,-1,1858,1859,1923,1922,-1,1859,1860,1924,1923,-1,1860,1861,1925,1924,-1,1861,1862,1926,1925,-1,1862,1863,1927,1926,-1,1863,1864,1928,1927,-1,1864,1865,1929,1928,-1,1865,1866,1930,1929,-1,1866,1867,1931,1930,-1,1867,1868,1932,1931,-1,1868,1869,1933,1932,-1,1869,1870,1934,1933,-1,1870,1871,1935,1934,-1,1871,1872,1936,1935,-1,1872,1873,1937,1936,-1,1873,1874,1938,1937,-1,1874,1875,1939,1938,-1,1875,1876,1940,1939,-1,1876,1877,1941,1940,-1,1877,1878,1942,1941,-1,1878,1879,1943,1942,-1,1879,1880,1944,1943,-1,1880,1881,1945,1944,-1,1881,1882,1946,1945,-1,1882,1883,1947,1946,-1,1883,1884,1948,1947,-1,1884,1885,1949,1948,-1,1885,1886,1950,1949,-1,1886,1887,1951,1950,-1,1887,1888,1952,1951,-1,1888,1889,1953,1952,-1,1889,1890,1954,1953,-1,1890,1891,1955,1954,-1,1891,1892,1956,1955,-1,1892,1893,1957,1956,-1,1893,1894,1958,1957,-1,1894,1895,1959,1958,-1,1895,1896,1960,1959,-1,1896,1897,1961,1960,-1,1897,1898,1962,1961,-1,1898,1899,1963,1962,-1,1899,1900,1964,1963,-1,1900,1901,1965,1964,-1,1901,1902,1966,1965,-1,1902,1903,1967,1966,-1,1903,1904,1968,1967,-1,1904,1905,1969,1968,-1,1905,1906,1970,1969,-1,1906,1907,1971,1970,-1,1907,1908,1972,1971,-1,1908,1909,1973,1972,-1,1909,1910,1974,1973,-1,1910,1911,1975,1974,-1,1911,1912,1976,1975,-1,1912,1913,1977,1976,-1,1913,1914,1978,1977,-1,1914,1915,1979,1978,-1,1915,1916,1980,1979,-1,1916,1917,1981,1980,-1,1917,1918,1982,1981,-1,1918,1919,1983,1982,-1,1919,1856,1920,1983,-1,1920,1921,1985,1984,-1,1921,1922,1986,1985,-1,1922,1923,1987,1986,-1,1923,1924,1988,1987,-1,1924,1925,1989,1988,-1,1925,1926,1990,1989,-1,1926,1927,1991,1990,-1,1927,1928,1992,1991,-1,1928,1929,1993,1992,-1,1929,1930,1994,1993,-1,1930,1931,1995,1994,-1,1931,1932,1996,1995,-1,1932,1933,1997,1996,-1,1933,1934,1998,1997,-1,1934,1935,1999,1998,-1,1935,1936,2000,1999,-1,1936,1937,2001,2000,-1,1937,1938,2002,2001,-1,1938,1939,2003,2002,-1,1939,1940,2004,2003,-1,1940,1941,2005,2004,-1,1941,1942,2006,2005,-1,1942,1943,2007,2006,-1,1943,1944,2008,2007,-1,1944,1945,2009,2008,-1,1945,1946,2010,2009,-1,1946,1947,2011,2010,-1,1947,1948,2012,2011,-1,1948,1949,2013,2012,-1,1949,1950,2014,2013,-1,1950,1951,2015,2014,-1,1951,1952,2016,2015,-1,1952,1953,2017,2016,-1,1953,1954,2018,2017,-1,1954,1955,2019,2018,-1,1955,1956,2020,2019,-1,1956,1957,2021,2020,-1,1957,1958,2022,2021,-1,1958,1959,2023,2022,-1,1959,1960,2024,2023,-1,1960,1961,2025,2024,-1,1961,1962,2026,2025,-1,1962,1963,2027,2026,-1,1963,1964,2028,2027,-1,1964,1965,2029,2028,-1,1965,1966,2030,2029,-1,1966,1967,2031,2030,-1,1967,1968,2032,2031,-1,1968,1969,2033,2032,-1,1969,1970,2034,2033,-1,1970,1971,2035,2034,-1,1971,1972,2036,2035,-1,1972,1973,2037,2036,-1,1973,1974,2038,2037,-1,1974,1975,2039,2038,-1,1975,1976,2040,2039,-1,1976,1977,2041,2040,-1,1977,1978,2042,2041,-1,1978,1979,2043,2042,-1,1979,1980,2044,2043,-1,1980,1981,2045,2044,-1,1981,1982,2046,2045,-1,1982,1983,2047,2046,-1,1983,1920,1984,2047,-1],creaseAngle=1.571,solid=False,
        coord=Coordinate(point=[(0.0,13.0,0.0),(0.0,14.554325,0.0),(0.0,15.730084,0.0),(0.0,16.240911,0.0),(0.0,15.962394,0.0),(0.0,14.962364,0.0),(0.0,13.484387,0.0),(0.0,11.888435,0.0),(0.0,10.563211,0.0),(0.0,9.831484,0.0),(0.0,9.871471,0.0),(0.0,10.673433,0.0),(0.0,12.042046,0.0),(0.0,13.643975,0.0),(0.0,15.08906,0.0),(0.0,16.02534,0.0),(0.0,16.224777,0.0),(0.0,15.638799,0.0),(0.0,14.410122,0.0),(0.0,12.838001,0.0),(0.0,11.305336,0.0),(0.0,10.185417,0.0),(0.0,9.75101,0.0),(0.0,10.107917,0.0),(0.0,11.16921,0.0),(0.0,12.676404,0.0),(0.0,14.262413,0.0),(0.0,15.540952,0.0),(0.0,16.200624,0.0),(0.0,16.080765,0.0),(0.0,15.210561,0.0),(0.0,13.801962,0.0),(0.0,12.198038,0.0),(0.0,10.789439,0.0),(0.0,9.919236,0.0),(0.0,9.799375,0.0),(0.0,10.459048,0.0),(0.0,11.737587,0.0),(0.0,13.323596,0.0),(0.0,14.83079,0.0),(0.0,15.892083,0.0),(0.0,16.24899,0.0),(0.0,15.814583,0.0),(0.0,14.694664,0.0),(0.0,13.161999,0.0),(0.0,11.589878,0.0),(0.0,10.361201,0.0),(0.0,9.775223,0.0),(0.0,9.97466,0.0),(0.0,10.91094,0.0),(0.0,12.356025,0.0),(0.0,13.957954,0.0),(0.0,15.326567,0.0),(0.0,16.128529,0.0),(0.0,16.168516,0.0),(0.0,15.436789,0.0),(0.0,14.111565,0.0),(0.0,12.515613,0.0),(0.0,11.037636,0.0),(0.0,10.037606,0.0),(0.0,9.759088,0.0),(0.0,10.269916,0.0),(0.0,11.445675,0.0),(0.0,13.0,0.0),(1.503019,14.780397,0.0),(1.601213,15.824649,0.160226),(1.611196,16.164694,0.32571),(1.527325,15.71771,0.471117),(1.367396,14.592564,0.576406),(1.166636,13.063294,0.635316),(0.966432,11.502363,0.658902),(0.801578,10.289947,0.672604),(0.690251,9.721338,0.70768),(0.629908,9.935025,0.789879),(0.600209,10.878962,0.929306),(0.571701,12.323248,1.115144),(0.517005,13.916116,1.317308),(0.420552,15.269613,1.494732),(0.283488,16.054085,1.607739),(0.122185,16.078468,1.630449),(-0.038882,15.336826,1.559118),(-0.177147,14.009788,1.4136),(-0.281055,12.420564,1.231381),(-0.354838,10.956221,1.056123),(-0.417126,9.973409,0.924446),(-0.493781,9.711499,0.855255),(-0.607516,10.234281,0.845004),(-0.768041,11.414429,0.870296),(-0.966427,12.964507,0.896714),(-1.175943,14.506986,0.890742),(-1.359373,15.666183,0.830696),(-1.480551,16.159767,0.712996),(-1.516259,15.867524,0.551873),(-1.464449,14.860631,0.372894),(-1.345851,13.384323,0.202854),(-1.198265,11.798166,0.059803),(-1.065248,10.488479,-0.053164),(-0.982842,9.774245,-0.14814),(-0.968645,9.829421,-0.246647),(-1.016785,10.640568,-0.370079),(-1.100363,12.010126,-0.529907),(-1.180481,13.60453,-0.721377),(-1.21878,15.035451,-0.92319),(-1.189305,15.95438,-1.103513),(-1.085842,16.137505,-1.230409),(-0.922482,15.540222,-1.283094),(-0.727491,14.308007,-1.260051),(-0.532876,12.740973,-1.180975),(-0.363407,11.220782,-1.081625),(-0.228945,10.117687,-1.003072),(-0.122656,9.700353,-0.978774),(-0.025531,10.070427,-1.023744),(0.084639,11.137773,-1.129434),(0.223244,12.642432,-1.266078),(0.391587,14.217935,-1.391784),(0.575127,15.480556,-1.465399),(0.747969,16.122776,-1.458968),(0.882093,15.988177,-1.365747),(0.957986,15.109543,-1.201277),(0.972813,13.70087,-0.997376),(0.942988,12.10525,-0.791261),(0.899967,10.711308,-0.613587),(0.880431,9.858548,-0.479457),(0.914061,9.754665,-0.385309),(1.013017,10.42496,-0.312474),(1.166799,11.706179,-0.235874),(1.344368,13.286273,-0.134524),(1.503019,14.780397,0.0),(3.230377,15.719197,0.0),(3.248111,15.884426,0.325023),(3.078326,15.28232,0.622297),(2.760942,14.059527,0.851638),(2.369728,12.513865,0.998924),(1.989203,11.021792,1.083262),(1.688916,9.946711,1.151483),(1.503493,9.550467,1.261581),(1.424807,9.929568,1.460782),(1.408368,10.99168,1.766038),(1.391261,12.478119,2.154094),(1.315069,14.026853,2.565137),(1.145764,15.260676,2.919358),(0.883816,15.879084,3.141269),(0.561387,15.731457,3.183782),(0.228115,14.853753,3.043988),(-0.068959,13.459741,2.765187),(-0.303802,11.888943,2.424278),(-0.481251,10.523937,2.1085),(-0.634687,9.697181,1.88905),(-0.812256,9.610035,1.800144),(-1.05668,10.283726,1.830223),(-1.386066,11.55417,1.9279),(-1.782961,13.111944,2.02034),(-2.196063,14.577639,2.037649),(-2.554575,15.594277,1.935015),(-2.790655,15.914247,1.705333),(-2.862408,15.45962,1.378463),(-2.769439,14.341122,1.007993),(-2.555334,12.831172,0.650668),(-2.295769,11.297528,0.346032),(-2.075838,10.113719,0.103601),(-1.963844,9.568071,-0.098011),(-1.990132,9.79348,-0.299964),(-2.137889,10.735045,-0.544373),(-2.348904,12.163443,-0.854931),(-2.542306,13.730777,-1.22431),(-2.640035,15.055312,-1.613292),(-2.590642,15.814448,-1.962335),(-2.383716,15.823294,-2.211765),(-2.050535,15.079693,-2.323539),(-1.651253,13.764756,-2.296753),(-1.253453,12.198745,-2.171044),(-0.909713,10.763071,-2.01613),(-0.641901,9.807404,-1.910522),(-0.437377,9.564502,-1.916275),(-0.257923,10.093526,-2.058174),(-0.057718,11.265629,-2.314426),(0.196503,12.795337,-2.622156),(0.510664,14.310078,-2.896119),(0.859429,15.440928,-3.054591),(1.194699,15.91246,-3.044044),(1.463479,15.60983,-2.854621),(1.628595,14.606744,-2.521558),(1.684596,13.147512,-2.112417),(1.662711,11.587539,-1.704694),(1.622555,10.306767,-1.361485),(1.632955,9.617138,-1.11333),(1.748232,9.686615,-0.952036),(1.988039,10.498276,-0.838029),(2.327917,11.854437,-0.718067),(2.704164,13.424793,-0.546658),(3.031859,14.826876,-0.303383),(3.230377,15.719197,0.0),(4.833592,15.405772,0.0),(4.579392,14.668469,0.458237),(4.114641,13.379593,0.831793),(3.5537,11.853059,1.096171),(3.024335,10.460664,1.274864),(2.629111,9.541535,1.431737),(2.415941,9.319534,1.647161),(2.367122,9.848729,1.986251),(2.409856,11.000231,2.470703),(2.44401,12.493585,3.064692),(2.377205,13.965074,3.680633),(2.155115,15.056306,4.203707),(1.776883,15.501505,4.527424),(1.290987,15.192239,4.588441),(0.77386,14.203832,4.388777),(0.299579,12.777017,3.997606),(-0.088071,11.259306,3.531532),(-0.390925,10.020346,3.119505),(-0.653614,9.361896,2.863669),(-0.943732,9.444324,2.808875),(-1.322367,10.247556,2.930666),(-1.81599,11.575958,3.145387),(-2.400372,13.105989,3.338714),(-3.00301,14.465,3.402824),(-3.524005,15.321994,3.269799),(-3.868638,15.468244,2.930379),(-3.980522,14.868131,2.432446),(-3.863629,13.667815,1.860626),(-3.585033,12.159642,1.304845),(-3.25666,10.710938,0.829248),(-3.001505,9.674545,0.452404),(-2.91517,9.302883,0.14549),(-3.035373,9.686473,-0.151489),(-3.329544,10.731889,-0.501848),(-3.704701,12.184513,-0.943333),(-4.036391,13.690549,-1.469126),(-4.207192,14.88319,-2.026077),(-4.142181,15.471962,-2.531234),(-3.829927,15.313464,-2.901057),(-3.322599,14.4463,-3.082921),(-2.715824,13.081674,-3.077403),(-2.115748,11.551949,-2.942827),(-1.604795,10.229701,-2.779586),(-1.217767,9.436973,-2.69885),(-0.935989,9.366837,-2.78583),(-0.700704,10.036378,-3.069984),(-0.440166,11.282523,-3.512442),(-0.100136,12.801765,-4.015331),(0.333508,14.224082,-4.450356),(0.8283,15.20306,-4.697524),(1.317162,15.500262,-4.681471),(1.724361,15.043301,-4.393599),(1.995827,13.943474,-3.893005),(2.122476,12.468652,-3.286236),(2.147537,10.978037,-2.692926),(2.154515,9.834679,-2.208915),(2.239334,9.31705,-1.879025),(2.476003,9.551223,-1.68811),(2.887744,10.480163,-1.572582),(3.433999,11.877621,-1.447552),(4.018463,13.403235,-1.239532),(4.516227,14.685433,-0.912975),(4.811494,15.411926,-0.481463),(4.833592,15.405772,0.0),(5.961462,13.891849,0.0),(5.367903,12.571162,0.53714),(4.668234,11.098323,0.943704),(4.031815,9.832051,1.24365),(3.590863,9.080756,1.513676),(3.402205,9.027421,1.852742),(3.433994,9.685035,2.341257),(3.581059,10.893434,3.004865),(3.703005,12.358301,3.796503),(3.671696,13.72286,4.604161),(3.411994,14.654763,5.2828),(2.922347,14.927038,5.700249),(2.269138,14.47337,5.781668),(1.557934,13.404254,5.537225),(0.892735,11.980081,5.062953),(0.338257,10.547716,4.513725),(-0.101166,9.456024,4.056638),(-0.478688,8.970892,3.819836),(-0.87952,9.210478,3.853429),(-1.382647,10.116429,4.115238),(-2.024087,11.468095,4.485837),(-2.775695,12.936268,4.807644),(-3.547981,14.163364,4.934941),(-4.21683,14.850516,4.778249),(-4.665296,14.830363,4.328762),(-4.825952,14.107814,3.655516),(-4.708602,12.85885,2.877367),(-4.402884,11.387666,2.120317),(-4.05374,10.052577,1.475441),(-3.817112,9.178754,0.971956),(-3.810165,8.979023,0.57429),(-4.072573,9.50203,0.203254),(-4.551904,10.620392,-0.227176),(-5.118281,12.061725,-0.771457),(-5.603758,13.474983,-1.426892),(-5.853615,14.515956,-2.130542),(-5.772907,14.931108,-2.780085),(-5.353246,14.619328,-3.271301),(-4.671585,13.65655,-3.538588),(-3.862149,12.277265,-3.583551),(-3.071622,10.817409,-3.480571),(-2.412991,9.632539,-3.356266),(-1.933513,9.011238,-3.348943),(-1.606977,9.104829,-3.561426),(-1.35177,9.890516,-4.02334),(-1.0673,11.17694,-4.676147),(-0.675047,12.650784,-5.386747),(-0.149278,13.953084,-5.985879),(0.473555,14.766654,-6.319151),(1.109827,14.893344,-6.29414),(1.66231,14.302299,-5.908202),(2.059695,13.137471,-5.248017),(2.287158,11.682562,-4.461267),(2.396217,10.291925,-3.710069),(2.489453,9.304259,-3.121675),(2.684783,8.960118,-2.752572),(3.071481,9.343318,-2.577279),(3.673502,10.36053,-2.504551),(4.433554,11.764003,-2.414385),(5.224474,13.211913,-2.2023),(5.885145,14.351612,-1.815327),(6.269635,14.905517,-1.267434),(6.293454,14.738721,-0.629755),(5.961462,13.891849,0.0),(6.468491,11.653989,0.0),(5.670295,10.266933,0.567399),(4.976708,9.147686,1.006063),(4.544798,8.568848,1.401885),(4.435082,8.671398,1.869544),(4.596855,9.430361,2.503314),(4.889081,10.660885,3.333319),(5.129173,12.063268,4.303887),(5.152886,13.29595,5.282993),(4.865226,14.058702,6.1008),(4.265843,14.165752,6.604816),(3.441487,13.591026,6.712868),(2.52959,12.474503,6.44529),(1.666863,11.08812,5.924383),(0.941614,9.76954,5.340156),(0.366667,8.839911,4.892831),(-0.117975,8.525652,4.730652),(-0.614474,8.903303,4.903384),(-1.22038,9.880883,5.346834),(-1.983463,11.220297,5.903476),(-2.875297,12.595322,6.372314),(-3.794028,13.671059,6.57145),(-4.596163,14.185507,6.392874),(-5.146628,14.013368,5.831839),(-5.36938,13.196568,4.982056),(-5.280153,11.934043,3.999561),(-4.988725,10.533291,3.048547),(-4.66847,9.335474,2.248217),(-4.502381,8.632329,1.638733),(-4.623154,8.595111,1.1772),(-5.067431,9.232886,0.763792),(-5.759928,10.390318,0.287466),(-6.533359,11.785508,-0.326066),(-7.178161,13.078647,-1.081934),(-7.506023,13.954782,-1.911268),(-7.406595,14.200525,-2.69578),(-6.879092,13.756023,-3.312796),(-6.028901,12.729538,-3.684185),(-5.031072,11.371077,-3.810889),(-4.07345,10.011503,-3.779609),(-3.298761,8.981949,-3.737951),(-2.764783,8.533171,-3.845579),(-2.435114,8.77447,-4.217741),(-2.202264,9.647078,-4.880717),(-1.933642,10.938464,-5.755192),(-1.523375,12.334103,-6.674342),(-0.931312,13.494077,-7.431697),(-0.195607,14.135866,-7.843607),(0.584979,14.103159,-7.806004),(1.291905,13.403921,-7.326756),(1.835282,12.208457,-6.522979),(2.191641,10.80793,-5.58421),(2.416569,9.543448,-4.713692),(2.62682,8.722984,-4.067112),(2.957599,8.546368,-3.708712),(3.509919,9.056616,-3.598542),(4.306936,10.129454,-3.613948),(5.275543,11.503584,-3.596804),(6.261003,12.844328,-3.40956),(7.071019,13.825138,-2.980685),(7.535266,14.207132,-2.324322),(7.560673,13.897271,-1.528423),(7.163731,12.971026,-0.716839),(6.468491,11.653989,0.0),(6.525465,9.375391,0.0),(5.829711,8.417604,0.583351),(5.463482,8.008385,1.104467),(5.485333,8.247403,1.692001),(5.821325,9.076442,2.453894),(6.292059,10.293585,3.426473),(6.672292,11.602388,4.549091),(6.762933,12.684083,5.674775),(6.451585,13.275217,6.614483),(5.7421,13.231813,7.200366),(4.744627,12.564444,7.34612),(3.631185,11.435652,7.082889),(2.573455,10.120362,6.557056),(1.685081,8.938921,5.989133),(0.988546,8.179079,5.60632),(0.417457,8.025899,5.57057),(-0.147784,8.516689,5.925948),(-0.824947,9.531915,6.58292),(-1.67646,10.824311,7.345051),(-2.677614,12.079105,7.969515),(-3.718769,12.990684,8.241638),(-4.641422,13.337025,8.039178),(-5.295592,13.033777,7.36572),(-5.597854,12.154795,6.343139),(-5.568616,10.914164,5.16692),(-5.334071,9.614046,4.040402),(-5.090442,8.571095,3.110704),(-5.041405,8.039328,2.427813),(-5.329332,8.148261,1.939718),(-5.983714,8.871363,1.523641),(-6.904845,10.032516,1.040738),(-7.889259,11.348915,0.393737),(-8.689401,12.499941,-0.43367),(-9.088471,13.205254,-1.369867),(-8.966145,13.29307,-2.283061),(-8.333847,12.742002,-3.033272),(-7.328373,11.686264,-3.529158),(-6.166541,10.38299,-3.768295),(-5.076387,9.149601,-3.845214),(-4.22793,8.286498,-3.922946),(-3.686169,8.003894,-4.176937),(-3.400963,8.37062,-4.730451),(-3.235576,9.297358,-5.604182),(-3.022491,10.558394,-6.698528),(-2.626073,11.846594,-7.816109),(-1.989919,12.848208,-8.718407),(-1.152728,13.319286,-9.19855),(-0.228097,13.145094,-9.146412),(0.643308,12.368058,-8.584352),(1.350934,11.17743,-7.661529),(1.859316,9.863195,-6.608402),(2.223834,8.745445,-5.666237),(2.570871,8.096415,-5.014669),(3.048999,8.074181,-4.720774),(3.768592,8.684158,-4.725665),(4.751877,9.777782,-4.871859),(5.912299,11.088694,-4.961008),(7.0721,12.297611,-4.821676),(8.01368,13.110095,-4.364017),(8.548296,13.328258,-3.603409),(8.57908,12.898966,-2.646296),(8.136687,11.926775,-1.644867),(7.374724,10.64847,-0.737952),(6.525465,9.375391,0.0),(6.567225,7.649902,0.0),(6.321236,7.400132,0.632535),(6.521593,7.750418,1.318369),(7.06753,8.615447,2.180044),(7.740167,9.784534,3.262754),(8.272813,10.972941,4.505134),(8.434476,11.891222,5.750528),(8.09916,12.315724,6.796002),(7.27875,12.143057,7.462534),(6.110008,11.415275,7.661708),(4.801822,10.309634,7.434675),(3.562167,9.09542,6.948263),(2.530521,8.068365,6.447663),(1.738844,7.478613,6.18022),(1.113539,7.469804,6.315194),(0.516057,8.044082,6.886309),(-0.193939,9.061579,7.776692),(-1.096755,10.274475,8.751895),(-2.175305,11.387363,9.530632),(-3.316264,12.129189,9.870358),(-4.349671,12.319279,9.639861),(-5.112772,11.911333,8.855581),(-5.514763,11.00471,7.670568),(-5.578267,9.820224,6.320945),(-5.441195,8.646365,5.048691),(-5.316473,7.769034,4.027072),(-5.422094,7.401911,3.313373),(-5.904885,7.634412,2.843643),(-6.784271,8.409909,2.469273),(-7.936175,9.539525,2.020798),(-9.123912,10.748133,1.375209),(-10.067106,11.74137,0.502428),(-10.526636,12.277325,-0.525363),(-10.377993,12.225463,-1.564231),(-9.649018,11.598416,-2.456942),(-8.509797,10.548904,-3.097313),(-7.218316,9.332544,-3.476158),(-6.04011,8.245589,-3.691034),(-5.168482,7.552773,-3.914973),(-4.671224,7.422838,-4.334263),(-4.480365,7.887429,-5.07687),(-4.426656,8.833392,-6.157103),(-4.305379,10.030332,-7.457135),(-3.949791,11.186725,-8.753636),(-3.286663,12.020925,-9.782255),(-2.355328,12.329755,-10.319366),(-1.285003,12.037998,-10.25408),(-0.240063,11.216715,-9.626241),(0.645767,10.065933,-8.617157),(1.321663,8.865934,-7.495524),(1.83891,7.908985,-6.535873),(2.32973,7.428159,-5.936056),(2.953216,7.540563,-5.760462),(3.828004,8.218821,-5.926909),(4.9766,9.297739,-6.240459),(6.302589,10.514538,-6.461725),(7.610631,11.572859,-6.386078),(8.664091,12.21494,-5.907077),(9.261559,12.284399,-5.043576),(9.306298,11.764318,-3.922933),(8.844303,10.781366,-2.728106),(8.056845,9.574948,-1.628726),(7.208555,8.438896,-0.721325),(6.567225,7.649902,0.0),(7.093893,6.743249,0.0),(7.510529,7.174944,0.751542),(8.290957,8.040567,1.676053),(9.177327,9.129288,2.83083),(9.864482,10.175943,4.158228),(10.094047,10.925611,5.496925),(9.731338,11.195706,6.634714),(8.800548,10.920444,7.384537),(7.468018,10.166866,7.656581),(5.980932,9.118513,7.499852),(4.583599,8.030718,7.096799),(3.440364,7.16842,6.710677),(2.591071,6.741638,6.601942),(1.95296,6.854318,6.941232),(1.36625,7.479016,7.748389),(0.665373,8.463583,8.878787),(-0.250946,9.568219,10.062633),(-1.376624,10.523885,10.9852),(-2.59791,11.09782,11.382186),(-3.735863,11.150239,11.11923),(-4.615926,10.668375,10.229943),(-5.138801,9.769589,8.900664),(-5.325941,8.672787,7.407933),(-5.321703,7.645102,6.030222),(-5.349479,6.936834,4.963591),(-5.635685,6.720487,4.268866),(-6.327394,7.048753,3.86659),(-7.432492,7.841681,3.579299),(-8.804227,8.906148,3.204476),(-10.17725,9.982895,2.591446),(-11.244758,10.809674,1.694875),(-11.75211,11.185117,0.586523),(-11.576292,11.017782,-0.577749),(-10.764943,10.348424,-1.622554),(-9.52191,9.340071,-2.424576),(-8.144035,8.238314,-2.964186),(-6.929969,7.311492,-3.337297),(-6.090939,6.785341,-3.722096),(-5.692307,6.788007,-4.311755),(-5.644072,7.318842,-5.236934),(-5.741763,8.248557,-6.506209),(-5.742254,9.350713,-7.986989),(-5.447712,10.356872,-9.435714),(-4.768921,11.021979,-10.569016),(-3.747188,11.184041,-11.152938),(-2.529032,10.803587,-11.080414),(-1.3046,9.97328,-10.410459),(-0.233299,8.895346,-9.35499),(0.615746,7.832323,-8.21656),(1.286621,7.043118,-7.296792),(1.914675,6.719948,-6.805158),(2.667895,6.941522,-6.797684),(3.67335,7.653875,-7.165134),(4.956185,8.683508,-7.673675),(6.414577,9.779648,-8.043626),(7.8415,10.67532,-8.039493),(8.987461,11.15238,-7.541375),(9.643487,11.094635,-6.574818),(9.71575,10.516149,-5.290916),(9.265276,9.557818,-3.905641),(8.497528,8.453048,-2.62114),(7.703565,7.470914,-1.557309),(7.171038,6.850623,-0.717571),(7.093893,6.743249,0.0),(8.417352,6.515515,0.0),(9.443854,7.346594,0.945),(10.543584,8.326434,2.131431),(11.377614,9.216387,3.509529),(11.666045,9.7997,4.91765),(11.27115,9.934303,6.137941),(10.233723,9.587412,6.977235),(8.751966,8.843515,7.343771),(7.111557,7.883793,7.291119),(5.591654,6.941993,7.011712),(4.378946,6.247497,6.779934),(3.518251,5.969455,6.862602),(2.914763,6.175584,7.426694),(2.384787,6.815681,8.476036),(1.734972,7.733847,9.839516),(0.84055,8.706455,11.216361),(-0.305865,9.49662,12.264808),(-1.592235,9.911892,12.705731),(-2.831937,9.851129,12.407527),(-3.838478,9.32913,11.42465),(-4.502053,8.473031,9.977574),(-4.839007,7.491341,8.381407),(-4.994753,6.623158,6.947278),(-5.197295,6.079933,5.889251),(-5.676442,5.993973,5.266968),(-6.576588,6.386213,4.981572),(-7.894141,7.161122,4.824009),(-9.462918,8.129964,4.557101),(-10.994764,9.056771,4.001767),(-12.163661,9.715814,3.097249),(-12.706396,9.946577,1.915181),(-12.506574,9.692858,0.624177),(-11.633814,9.01645,-0.580619),(-10.32459,8.082098,-1.556182),(-8.910553,7.11737,-2.268906),(-7.717569,6.357231,-2.808965),(-6.968393,5.986819,-3.355801),(-6.720378,6.09635,-4.106738),(-6.857658,6.659147,-5.194474),(-7.138804,7.538137,-6.623842),(-7.282479,8.519236,-8.252051),(-7.061333,9.363491,-9.821716),(-6.372444,9.865277,-11.037396),(-5.261523,9.902381,-11.660732),(-3.894697,9.465766,-11.591978),(-2.490029,8.661773,-10.90953),(-1.234705,7.68622,-9.852714),(-0.218263,6.776709,-8.752065),(0.594201,6.154758,-7.929058),(1.339694,5.971847,-7.597782),(2.194738,6.272526,-7.800564),(3.296114,6.983562,-8.398361),(4.674796,7.931778,-9.118527),(6.228464,8.886229,-9.643549),(7.744271,9.614451,-9.711009),(8.965525,9.939082,-9.191899),(9.6798,9.781056,-8.122317),(9.79763,9.17886,-6.679911),(9.39328,8.279163,-5.115308),(8.691581,7.301094,-3.663809),(8.003088,6.482867,-2.468626),(7.627767,6.023767,-1.541986),(7.758621,6.035612,-0.776367),(8.417352,6.515515,0.0),(10.477175,6.530473,0.0),(11.778034,7.377968,1.17857),(12.742828,8.103334,2.576018),(13.076982,8.529905,4.033715),(12.645675,8.553785,5.330599),(11.51015,8.169159,6.268094),(9.901672,7.469704,6.750846),(8.143113,6.625779,6.832883),(6.545347,5.842926,6.710613),(5.313392,5.311815,6.662783),(4.493013,5.161802,6.956544),(3.973915,5.429423,7.751409),(3.545825,6.049497,9.034614),(2.98561,6.871001,10.61149),(2.143451,7.693853,12.156117),(0.99723,8.31764,13.307106),(-0.343597,8.590436,13.777796),(-1.684861,8.445799,13.444872),(-2.827082,7.918956,12.386254),(-3.647379,7.138223,10.855872),(-4.152928,6.293754,9.203834),(-4.485145,5.591225,7.768499),(-4.871587,5.201741,6.775965),(-5.541604,5.220164,6.279401),(-6.635411,5.642006,6.156762),(-8.139471,6.364526,6.165409),(-9.87273,7.211749,6.0331),(-11.530994,7.977327,5.553034),(-12.776585,8.474799,4.650297),(-13.344343,8.583002,3.397887),(-13.128652,8.275583,1.978826),(-12.221844,7.627415,0.609967),(-10.890204,6.796365,-0.543508),(-9.494543,5.98484,-1.431072),(-8.380818,5.390492,-2.134018),(-7.776308,5.15808,-2.830345),(-7.724898,5.344209,-3.720115),(-8.081827,5.903545,-4.938702),(-8.568322,6.699859,-6.490251),(-8.866653,7.539203,-8.227052),(-8.723134,8.217149,-9.884513),(-8.024732,8.568579,-11.161722),(-6.82483,8.507898,-11.820953),(-5.311711,8.049888,-11.771962),(-3.733157,7.306098,-11.111179),(-2.305405,6.457685,-10.100641),(-1.13935,5.711285,-9.091798),(-0.209935,5.248689,-8.418125),(0.621355,5.182565,-8.291407),(1.540344,5.529018,-8.735727),(2.695639,6.203668,-9.580869),(4.127682,7.042198,-10.517163),(5.738549,7.840379,-11.193453),(7.314969,8.403809,-11.325788),(8.597811,8.59526,-10.781315),(9.374094,8.368103,-9.610784),(9.558784,7.777663,-8.020772),(9.236289,6.967747,-6.297195),(8.644936,6.135615,-4.707781),(8.1073,5.483938,-3.417514),(7.9282,5.171437,-2.445526),(8.293935,5.274224,-1.676655),(9.20674,5.767264,-0.921273),(10.477175,6.530473,0.0),(12.822136,6.289558,0.0),(13.895004,6.849863,1.390405),(14.259741,7.136231,2.882669),(13.790202,7.078913,4.253714),(12.571062,6.691871,5.299147),(10.866459,6.069371,5.917558),(9.033496,5.363028,6.158933),(7.410013,4.744875,6.217739),(6.214037,4.365469,6.370938),(5.487485,4.317216,6.881089),(5.100984,4.611869,7.897868),(4.815478,5.177662,9.392937),(4.377027,5.876794,11.152482),(3.610474,6.538986,12.832387),(2.479088,7.002956,14.059604),(1.090154,7.155701,14.547098),(-0.353741,6.960019,14.184554),(-1.638463,6.463571,13.074622),(-2.625335,5.787268,11.502344),(-3.308616,5.09583,9.847596),(-3.821443,4.557661,8.469187),(-4.386982,4.303835,7.598476),(-5.231634,4.396174,7.276759),(-6.491345,4.812188,7.355588),(-8.14546,5.450554,7.557882),(-10.003565,6.155793,7.577406),(-11.752655,6.75614,7.181898),(-13.050798,7.105376,6.284933),(-13.636754,7.118442,4.963372),(-13.418572,6.792156,3.416788),(-12.510455,6.205987,1.885648),(-11.204073,5.502701,0.559172),(-9.88241,4.853587,-0.493211),(-8.903573,4.416742,-1.341998),(-8.492234,4.298563,-2.162388),(-8.67394,4.527832,-3.157056),(-9.273218,5.04871,-4.465747),(-9.97517,5.734333,-6.095699),(-10.429202,6.417713,-7.899814),(-10.359985,6.932409,-9.612661),(-9.649039,7.153061,-10.93369),(-8.361155,7.02593,-11.629658),(-6.709138,6.581979,-11.620568),(-4.971544,5.929334,-11.018073),(-3.393752,5.226953,-10.100989),(-2.107567,4.645905,-9.233855),(-1.097039,4.327708,-8.754162),(-0.22108,4.349861,-8.865038),(0.717096,4.706969,-9.568977),(1.880499,5.312055,-10.664839),(3.322674,6.017748,-11.809487),(4.954525,6.652169,-12.623923),(6.56689,7.060803,-12.809194),(7.901798,7.144123,-12.234376),(8.747297,6.881835,-10.968764),(9.021591,6.337823,-9.24938),(8.815078,5.644584,-7.396729),(8.373098,4.970961,-5.708681),(8.022711,4.481019,-4.368936),(8.066689,4.294088,-3.400395),(8.679996,4.455695,-2.677424),(9.84418,4.926481,-1.990044),(11.342974,5.591781,-1.135036),(12.822136,6.289558,0.0),(14.777186,5.472869,0.0),(15.157523,5.641765,1.516739),(14.651861,5.536223,2.961938),(13.370062,5.181947,4.124118),(11.607356,4.665223,4.892911),(9.750431,4.111905,5.309802),(8.157895,3.656755,5.561958),(7.054481,3.410628,5.919413),(6.473109,3.433472,6.636551),(6.262049,3.719721,7.852361),(6.152157,4.199658,9.525403),(5.858949,4.756391,11.428303),(5.183129,5.254324,13.206397),(4.074887,5.572182,14.483009),(2.640899,5.632548,14.977284),(1.093778,5.42072,14.595453),(-0.335786,4.98829,13.464597),(-1.490871,4.440579,11.896869),(-2.349816,3.910986,10.295217),(-3.034295,3.528497,9.031119),(-3.760481,3.38627,8.334083),(-4.750718,3.518946,8.228485),(-6.137876,3.894209,8.537266),(-7.897977,4.420662,8.949496),(-9.837284,4.970085,9.127666),(-11.641178,5.40866,8.81785),(-12.970273,5.629571,7.925969),(-13.572,5.579013,6.535931),(-13.369507,5.269299,4.866102),(-12.496459,4.775863,3.18199),(-11.264095,4.218884,1.697789),(-10.069618,3.734019,0.502554),(-9.275001,3.439359,-0.462896),(-9.095548,3.406671,-1.370933),(-9.534623,3.643917,-2.427813),(-10.38574,4.093313,-3.7801),(-11.300826,4.645406,-5.442191),(-11.901605,5.16573,-7.27292),(-11.897082,5.527557,-9.01169),(-11.168711,5.642761,-10.36305),(-9.796461,5.483283,-11.10074),(-8.019422,5.087966,-11.154336),(-6.146855,4.553091,-10.646666),(-4.451951,4.008931,-9.866536),(-3.08548,3.58802,-9.183465),(-2.038521,3.392873,-8.931345),(-1.165354,3.471021,-9.299302),(-0.256027,3.803429,-10.266373),(0.869486,4.309137,-11.602484),(2.281013,4.864977,-12.936268),(3.901855,5.33557,-13.868016),(5.530335,5.6063,-14.091064),(6.911941,5.611228,-13.48224),(7.836076,5.349155,-12.132619),(8.221928,4.88391,-10.309972),(8.16108,4.328806,-8.367142),(7.899241,3.819044,-6.62825),(7.760847,3.478779,-5.291256),(8.0407,3.390885,-4.378732),(8.899215,3.576769,-3.751334),(10.29768,3.991158,-3.176414),(11.997116,4.533124,-2.425269),(13.62318,5.070669,-1.363205),(14.777186,5.472869,0.0),(15.727215,4.072058,0.0),(15.192477,3.953249,1.520237),(13.875259,3.665226,2.804944),(12.098422,3.278137,3.731869),(10.272062,2.886261,4.330037),(8.768185,2.585043,4.774899),(7.811373,2.447845,5.325704),(7.420513,2.508084,6.226549),(7.418994,2.751088,7.606319),(7.507537,3.117671,9.414153),(7.3729,3.51855,11.415482),(6.794385,3.856088,13.252939),(5.711956,4.048075,14.553826),(4.23414,4.047751,15.049029),(2.58556,3.855196,14.663438),(1.015182,3.517308,13.546657),(-0.30007,3.11638,12.032429),(-1.3207,2.750063,10.538939),(-2.155076,2.507575,9.442007),(-3.011176,2.447976,8.962311),(-4.107473,2.585781,9.103095),(-5.575951,2.887427,9.65783),(-7.39368,3.279447,10.283983),(-9.369682,3.666361,10.617141),(-11.194426,3.953933,10.38691),(-12.536875,4.072123,9.496314),(-13.156532,3.992146,8.039789),(-12.991567,3.73348,6.256409),(-12.191298,3.359126,4.437269),(-11.079648,2.960259,2.821225),(-10.059583,2.634026,1.516238),(-9.488824,2.459885,0.473568),(-9.56737,2.480247,-0.477488),(-10.273939,2.690154,-1.548547),(-11.372419,3.038481,-2.895774),(-12.486237,3.440392,-4.544619),(-13.216068,3.797997,-6.364523),(-13.262167,4.0242,-8.104342),(-12.51158,4.063907,-9.477153),(-11.062817,3.907448,-10.264795),(-9.182021,3.592929,-10.404495),(-7.207693,3.196953,-10.025291),(-5.437945,2.815963,-9.418798),(-4.039122,2.542752,-8.951615),(-3.006117,2.443862,-8.947252),(-2.185847,2.543379,-9.576823),(-1.352877,2.817064,-10.795704),(-0.307954,3.19826,-12.348567),(1.037352,3.594123,-13.842506),(2.621134,3.908239,-14.865189),(4.251244,4.064102,-15.10982),(5.677635,4.023752,-14.466378),(6.690299,3.797014,-13.049911),(7.206448,3.439114,-11.157763),(7.313807,3.03722,-9.171223),(7.252142,2.689216,-7.435253),(7.33701,2.479861,-6.156482),(7.850621,2.460144,-5.352463),(8.937189,2.634869,-4.866933),(10.539757,2.961479,-4.44288),(12.402121,3.360426,-3.825548),(14.137675,3.734544,-2.857993),(15.344144,3.992715,-1.535413),(15.727215,4.072058,0.0),(15.390473,2.357734,0.0),(14.0704,2.166271,1.407956),(12.327173,1.926654,2.491992),(10.586816,1.697244,3.2656),(9.226623,1.533916,3.889348),(8.464073,1.476448,4.609288),(8.299569,1.538837,5.65855),(8.530255,1.705889,7.157734),(8.828174,1.936917,9.05108),(8.854741,2.175651,11.103494),(8.372051,2.363948,12.96247),(7.313769,2.455945,14.266035),(5.793292,2.429236,14.761068),(4.049192,2.290327,14.391683),(2.349834,2.07305,13.326572),(0.892854,1.830324,11.914313),(-0.263843,1.621266,10.579775),(-1.214907,1.496794,9.694729),(-2.160253,1.487225,9.464688),(-3.315726,1.594888,9.868757),(-4.815248,1.793562,10.671686),(-6.641426,2.034858,11.503287),(-8.611706,2.260007,11.978154),(-10.427432,2.414173,11.815717),(-11.770443,2.459806,10.921375),(-12.414254,2.385794,9.403432),(-12.310575,2.210162,7.522836),(-11.619431,1.975686,5.595623),(-10.66992,1.739475,3.883533),(-9.862301,1.559059,2.51125),(-9.542574,1.478381,1.438312),(-9.890724,1.517089,0.493626),(-10.859967,1.665756,-0.541998),(-12.187685,1.888174,-1.836998),(-13.475037,2.13017,-3.431166),(-14.309405,2.332806,-5.208198),(-14.389724,2.446727,-6.929726),(-13.614095,2.444187,-8.319401),(-12.102112,2.325806,-9.166994),(-10.146418,2.120415,-9.4145),(-8.111733,1.878039,-9.191711),(-6.316668,1.65771,-8.78595),(-4.93847,1.513092,-8.553681),(-3.97182,1.479405,-8.802457),(-3.253292,1.564857,-9.68293),(-2.539959,1.748633,-11.128287),(-1.611961,1.985974,-12.863144),(-0.36113,2.219074,-14.480848),(1.166437,2.39116,-15.565024),(2.78881,2.460319,-15.816127),(4.26025,2.409707,-15.141828),(5.369783,2.251651,-13.681985),(6.029369,2.024647,-11.760719),(6.31807,1.783982,-9.782286),(6.464154,1.588273,-8.105792),(6.769252,1.485186,-6.940171),(7.499849,1.499828,-6.293121),(8.783872,1.628633,-5.988743),(10.549539,1.84023,-5.744973),(12.529911,2.083083,-5.2818),(14.334392,2.298044,-4.421574),(15.56533,2.432756,-3.146599),(15.941935,2.454411,-1.595231),(15.390473,2.357734,0.0),(13.954996,0.707717,0.0),(12.294129,0.626601,1.230213),(10.692662,0.55324,2.161568),(9.524782,0.5055,2.938006),(8.994314,0.49501,3.791421),(9.079748,0.524324,4.944567),(9.552069,0.586303,6.51249),(10.05775,0.665851,8.439454),(10.23784,0.743594,10.496339),(9.842672,0.800597,12.34232),(8.804281,0.822976,13.631694),(7.244077,0.805282,14.130095),(5.416062,0.751822,13.799901),(3.608158,0.675619,12.824154),(2.038103,0.595232,11.558659),(0.781334,0.530239,10.426184),(-0.24406,0.49647,9.786512),(-1.231196,0.50215,9.824708),(-2.395245,0.545895,10.494255),(-3.875095,0.617051,11.533633),(-5.663036,0.698288,12.550577),(-7.589765,0.769819,13.145859),(-9.372063,0.814223,13.035746),(-10.707741,0.820684,12.133345),(-11.38484,0.78763,10.563587),(-11.365935,0.723111,8.609361),(-10.81608,0.64284,6.609569),(-10.061874,0.566369,4.845543),(-9.49289,0.512322,3.455129),(-9.437012,0.493863,2.402959),(-10.051016,0.515487,1.514947),(-11.263461,0.571929,0.562136),(-12.789962,0.649441,-0.63832),(-14.216913,0.729144,-2.142855),(-15.126862,0.791627,-3.851772),(-15.22487,0.821671,-5.541399),(-14.424925,0.811959,-6.946678),(-12.86905,0.764856,-7.864113),(-10.874329,0.691834,-8.236984),(-8.827094,0.610679,-8.190347),(-7.060649,0.541157,-8.000688),(-5.757511,0.500199,-8.008209),(-4.907709,0.497782,-8.5004),(-4.334685,0.534494,-9.606649),(-3.776764,0.601394,-11.240968),(-2.993259,0.682187,-13.114327),(-1.856533,0.757197,-14.814778),(-0.397281,0.808154,-15.930477),(1.212212,0.822646,-16.175842),(2.729465,0.797145,-15.479564),(3.940562,0.737861,-14.005589),(4.74906,0.659234,-12.100408),(5.221221,0.580412,-10.184368),(5.569381,0.520595,-8.623088),(6.077635,0.494351,-7.621114),(6.995156,0.508071,-7.17178),(8.43492,0.558415,-7.077738),(10.314819,0.63312,-7.032525),(12.364237,0.713992,-6.733205),(14.1968,0.781333,-5.984453),(15.426998,0.818743,-4.758599),(15.792572,0.81711,-3.192537),(15.241688,0.776831,-1.525161),(13.954996,0.707717,0.0),(12.011633,-0.609161,0.0),(10.595907,-0.540047,1.06028),(9.659203,-0.499769,1.95265),(9.386007,-0.498135,2.8952),(9.730831,-0.535545,4.101889),(10.440217,-0.602886,5.685439),(11.139817,-0.683758,7.594998),(11.456672,-0.758463,9.613289),(11.1357,-0.808807,11.416869),(10.112293,-0.822527,12.680415),(8.518717,-0.796283,13.189553),(6.625032,-0.736466,12.922603),(4.737615,-0.657645,12.071246),(3.092252,-0.579017,10.990518),(1.779593,-0.519733,10.092574),(0.728277,-0.494232,9.718179),(-0.250085,-0.508725,10.028082),(-1.372254,-0.559681,10.95033),(-2.784859,-0.634691,12.201265),(-4.49326,-0.715485,13.37351),(-6.345054,-0.782385,14.062085),(-8.075606,-0.819097,13.98736),(-9.400345,-0.81668,13.075084),(-10.121101,-0.775722,11.468602),(-10.207792,-0.706199,9.471447),(-9.824515,-0.625044,7.441781),(-9.288038,-0.552023,5.675802),(-8.9702,-0.50492,4.31982),(-9.17578,-0.495208,3.339711),(-10.036808,-0.525252,2.555685),(-11.45969,-0.587734,1.72727),(-13.144388,-0.667438,0.656009),(-14.67089,-0.744949,-0.732194),(-15.625588,-0.801391,-2.355178),(-15.726658,-0.823016,-4.004499),(-14.90776,-0.804557,-5.425981),(-13.333251,-0.75051,-6.420955),(-11.341008,-0.674038,-6.930346),(-9.332909,-0.593768,-7.069404),(-7.650046,-0.529248,-7.098206),(-6.47401,-0.496194,-7.335945),(-5.785793,-0.502656,-8.047547),(-5.393549,-0.54706,-9.341901),(-5.016704,-0.618591,-11.118157),(-4.39493,-0.699827,-13.080845),(-3.382873,-0.770983,-14.821337),(-1.997591,-0.814729,-15.940399),(-0.403306,-0.820408,-16.172047),(1.159154,-0.78664,-15.467837),(2.470954,-0.721647,-14.013479),(3.424656,-0.641259,-12.171953),(4.070613,-0.565056,-10.371752),(4.602176,-0.511597,-8.976876),(5.283816,-0.493902,-8.180948),(6.347257,-0.516282,-7.959208),(7.893016,-0.573285,-8.09231),(9.833842,-0.651028,-8.251573),(11.902567,-0.730576,-8.115033),(13.724705,-0.792554,-7.474076),(14.933317,-0.821868,-6.294921),(15.288222,-0.811378,-4.715792),(14.759114,-0.763639,-2.983619),(13.543466,-0.690277,-1.355228),(12.011633,-0.609161,0.0),(10.309704,-1.579389,0.0),(9.630532,-1.482711,0.96368),(9.625276,-1.504366,1.945792),(10.223998,-1.639079,3.153686),(11.152191,-1.854039,4.701043),(12.020911,-2.096892,6.546239),(12.45061,-2.308489,8.488682),(12.187628,-2.437295,10.226634),(11.175558,-2.451937,11.457733),(9.559644,-2.348849,11.987415),(7.625465,-2.15314,11.806529),(5.695325,-1.912476,11.109143),(4.019545,-1.685471,10.241635),(2.700398,-1.527415,9.597785),(1.673979,-1.476803,9.493607),(0.754139,-1.545962,10.06329),(-0.279593,-1.718048,11.21134),(-1.583694,-1.951148,12.637579),(-3.178868,-2.188489,13.927532),(-4.931872,-2.372266,14.67897),(-6.598331,-2.457717,14.623405),(-7.911618,-2.424031,13.703325),(-8.685647,-2.279412,12.081),(-8.89371,-2.059083,10.077798),(-8.693144,-1.816707,8.066059),(-8.384334,-1.611316,6.350886),(-8.315631,-1.492935,5.081576),(-8.765335,-1.490395,4.221163),(-9.840861,-1.604317,3.58178),(-11.43042,-1.806952,2.910543),(-13.225442,-2.048948,1.993415),(-14.808262,-2.271366,0.73905),(-15.777505,-2.420033,-0.787423),(-15.870553,-2.458741,-2.392101),(-15.043156,-2.378063,-3.830458),(-13.480346,-2.197647,-4.906445),(-11.535628,-1.961436,-5.555266),(-9.619152,-1.726961,-5.878141),(-8.072192,-1.551328,-6.114448),(-7.069119,-1.477316,-6.559184),(-6.578011,-1.52295,-7.453793),(-6.390609,-1.677115,-8.888796),(-6.208662,-1.902264,-10.753719),(-5.754903,-2.14356,-12.754175),(-4.869437,-2.342234,-14.493143),(-3.558574,-2.449898,-15.591131),(-1.980748,-2.440328,-15.805993),(-0.37688,-2.315856,-15.112413),(1.027722,-2.106799,-13.714001),(2.112955,-1.864072,-11.983161),(2.911456,-1.646795,-10.34793),(3.596036,-1.507886,-9.162551),(4.410925,-1.481177,-8.603828),(5.571484,-1.573175,-8.626345),(7.169057,-1.761471,-8.989713),(9.116635,-2.000206,-9.346824),(11.157222,-2.231233,-9.362021),(12.934913,-2.398285,-8.818875),(14.106377,-2.460674,-7.681923),(14.455478,-2.403207,-6.093495),(13.971574,-2.239878,-4.30966),(12.863433,-2.010468,-2.600399),(11.502066,-1.770852,-1.150955),(10.309704,-1.579389,0.0),(9.44279,-2.444908,0.0),(9.700786,-2.524251,0.97071),(10.533271,-2.782421,2.129347),(11.649651,-3.15654,3.593441),(12.653804,-3.555487,5.334026),(13.167653,-3.882097,7.170722),(12.945814,-4.056822,8.826306),(11.944333,-4.037105,10.022485),(10.322483,-3.82775,10.583119),(8.379435,-3.479746,10.507479),(6.449445,-3.077852,9.985693),(4.792525,-2.719951,9.348167),(3.518,-2.493214,8.963719),(2.565812,-2.452863,9.119437),(1.749592,-2.608727,9.922427),(0.843604,-2.922843,11.257119),(-0.319552,-3.318706,12.813615),(-1.776854,-3.699902,14.178962),(-3.415006,-3.973587,14.962118),(-5.010194,-4.073103,14.912084),(-6.312976,-3.974214,13.990992),(-7.147057,-3.701003,12.379066),(-7.485138,-3.320013,10.411193),(-7.472615,-2.924037,8.467502),(-7.388102,-2.609518,6.855157),(-7.552249,-2.453059,5.720607),(-8.215168,-2.492766,5.020185),(-9.461323,-2.718969,4.556333),(-11.165831,-3.076574,4.06403),(-13.019261,-3.478484,3.315111),(-14.614938,-3.826812,2.202847),(-15.571347,-4.036719,0.777134),(-15.649893,-4.057081,-0.781054),(-14.829294,-3.88294,-2.235156),(-13.312033,-3.556707,-3.38966),(-11.46077,-3.15784,-4.171379),(-9.685824,-2.783485,-4.664447),(-8.320804,-2.52482,-5.084738),(-7.526954,-2.444842,-5.701446),(-7.256493,-2.563033,-6.733041),(-7.284953,-2.850605,-8.254856),(-7.299151,-3.237519,-10.152501),(-7.009052,-3.629538,-12.140034),(-6.244626,-3.931185,-13.839512),(-5.005134,-4.06899,-14.897025),(-3.445777,-4.009391,-15.096934),(-1.809031,-3.766903,-14.435727),(-0.327436,-3.400586,-13.129753),(0.865775,-2.999658,-11.552968),(1.785166,-2.66177,-10.124178),(2.582916,-2.469214,-9.180228),(3.48368,-2.468891,-8.876271),(4.688439,-2.660878,-9.145139),(6.282992,-2.998416,-9.727975),(8.185705,-3.399295,-10.264549),(10.15563,-3.765878,-10.412053),(11.86083,-4.008882,-9.952418),(12.985061,-4.069121,-8.853065),(13.336657,-3.931923,-7.262756),(12.921499,-3.630705,-5.446868),(11.95335,-3.238829,-3.68712),(10.795688,-2.85174,-2.182395),(9.852452,-2.563716,-0.985887),(9.44279,-2.444908,0.0),(9.604369,-3.557068,0.0),(10.637219,-3.959268,1.064414),(11.901014,-4.496812,2.405842),(13.000671,-5.038779,4.010176),(13.567808,-5.453168,5.719311),(13.371708,-5.639052,7.281844),(12.384139,-5.551158,8.443363),(10.778114,-5.210892,9.043912),(8.86302,-4.70113,9.086806),(6.979723,-4.146027,8.752296),(5.392046,-3.680782,8.34852),(4.211184,-3.418709,8.214218),(3.377247,-3.423637,8.605086),(2.701657,-3.694367,9.60226),(1.9528,-4.164959,11.074877),(0.95255,-4.720799,12.710896),(-0.351822,-5.226507,14.107604),(-1.866339,-5.558916,14.893034),(-3.386885,-5.637063,14.838914),(-4.67972,-5.441917,13.928478),(-5.575869,-5.021006,12.357394),(-6.043922,-4.476846,10.46838),(-6.213157,-3.941971,8.641975),(-6.336469,-3.546654,7.180092),(-6.704234,-3.387176,6.22062),(-7.538248,-3.502379,5.710001),(-8.902954,-3.864206,5.440482),(-10.666197,-4.38453,5.13657),(-12.525428,-4.936624,4.558883),(-14.092988,-5.38602,3.588516),(-15.013685,-5.623266,2.262949),(-15.076246,-5.590578,0.752424),(-14.281629,-5.295918,-0.712766),(-12.845139,-4.811052,-1.936093),(-11.131152,-4.254074,-2.83434),(-9.541661,-3.760637,-3.472881),(-8.395022,-3.450924,-4.04283),(-7.834286,-3.400365,-4.787432),(-7.794152,-3.621276,-5.903841),(-8.035661,-4.059852,-7.456004),(-8.234952,-4.609274,-9.331336),(-8.094702,-5.135728,-11.259045),(-7.44006,-5.510991,-12.886561),(-6.267338,-5.643666,-13.889848),(-4.730905,-5.501439,-14.080824),(-3.07559,-5.11895,-13.475042),(-1.540822,-4.589358,-12.295466),(-0.272063,-4.041647,-10.90938),(0.728258,-3.609217,-9.717926),(1.592913,-3.397389,-9.033861),(2.528625,-3.457755,-8.987268),(3.724453,-3.775612,-9.489753),(5.264176,-4.273545,-10.268156),(7.075964,-4.830278,-10.955736),(8.939602,-5.310215,-11.209907),(10.55099,-5.596465,-10.817396),(11.622874,-5.619308,-9.752749),(11.987092,-5.373182,-8.172661),(11.661977,-4.918032,-6.350774),(10.859668,-4.364713,-4.577734),(9.928289,-3.84799,-3.062472),(9.246269,-3.493714,-1.869174),(9.102875,-3.388171,-0.91088),(9.604369,-3.557068,0.0),(10.520782,-5.16069,0.0),(11.883948,-5.858467,1.189168),(13.035906,-6.523767,2.635265),(13.625862,-6.994553,4.203022),(13.443255,-7.15616,5.666807),(12.477543,-6.969229,6.794908),(10.913726,-6.479287,7.440852),(9.066635,-5.805664,7.60781),(7.277294,-5.112425,7.461041),(5.806774,-4.568412,7.281464),(4.762815,-4.306125,7.37428),(4.082398,-4.389445,7.963011),(3.573601,-4.798079,9.105387),(2.999532,-5.4325,10.660972),(2.172956,-6.138193,12.323447),(1.027323,-6.743279,13.70867),(-0.360875,-7.100387,14.470624),(-1.805506,-7.12254,14.407597),(-3.086721,-6.804343,13.523807),(-4.040656,-6.223295,12.026401),(-4.629097,-5.520914,10.259133),(-4.962321,-4.868269,8.594992),(-5.265126,-4.424318,7.323344),(-5.79664,-4.297186,6.568391),(-6.751585,-4.517839,6.264555),(-8.178196,-5.032534,6.194743),(-9.943129,-5.715915,6.07612),(-11.758024,-6.401538,5.662366),(-13.261228,-6.922416,4.826692),(-14.128858,-7.151685,3.597649),(-14.178624,-7.033506,2.137084),(-13.431491,-6.596661,0.670338),(-12.109828,-5.947547,-0.604376),(-10.571742,-5.244261,-1.593434),(-9.20252,-4.658092,-2.343249),(-8.298414,-4.331806,-3.020376),(-7.980444,-4.344872,-3.843179),(-8.165644,-4.694108,-4.989921),(-8.603834,-5.294455,-6.517151),(-8.96611,-5.999694,-8.319334),(-8.954333,-6.63806,-10.146493),(-8.394647,-7.054074,-11.676243),(-7.284477,-7.146413,-12.617084),(-5.779199,-6.892587,-12.80802),(-4.125791,-6.354418,-12.279794),(-2.568953,-5.66298,-11.255318),(-1.264082,-4.986677,-10.087137),(-0.228214,-4.490229,-9.151108),(0.654264,-4.294547,-8.730549),(1.574368,-4.447292,-8.928683),(2.711733,-4.911262,-9.638072),(4.151099,-5.573454,-10.576828),(5.83381,-6.272586,-11.379267),(7.563629,-6.838379,-11.710788),(9.066586,-7.133032,-11.369139),(10.084847,-7.084779,-10.339483),(10.471699,-6.705373,-8.786799),(10.253328,-6.08722,-6.990601),(9.633795,-5.380877,-5.246285),(8.938882,-4.758377,-3.768055),(8.515656,-4.371335,-2.626732),(8.620345,-4.314017,-1.74264),(9.331918,-4.600385,-0.933799),(10.520782,-5.16069,0.0),(11.587576,-7.222591,0.0),(12.748366,-7.985801,1.275666),(13.333327,-8.47884,2.69539),(13.156275,-8.581627,4.058174),(12.224843,-8.269126,5.153203),(10.732804,-7.617449,5.844774),(8.994464,-6.785317,6.132321),(7.343795,-5.975401,6.162176),(6.032327,-5.384962,6.18464),(5.159336,-5.157804,6.469602),(4.656179,-5.349255,7.209175),(4.327626,-5.912685,8.441346),(3.933476,-6.710866,10.022335),(3.280389,-7.549396,11.659195),(2.291159,-8.224046,12.993811),(1.027546,-8.570499,13.711646),(-0.340155,-8.504375,13.639768),(-1.604263,-8.041779,12.801713),(-2.604464,-7.295379,11.4109),(-3.294171,-6.446966,9.804602),(-3.763236,-5.703176,8.340188),(-4.207545,-5.245166,7.287682),(-4.855427,-5.184486,6.753488),(-5.876799,-5.535915,6.659222),(-7.307954,-6.213861,6.78079),(-9.020208,-7.053205,6.832542),(-10.745823,-7.849519,6.566636),(-12.154755,-8.408855,5.853422),(-12.957775,-8.594984,4.716245),(-13.001631,-8.362572,3.310622),(-12.323763,-7.768225,1.857508),(-11.147118,-6.956699,0.55633),(-9.815478,-6.125649,-0.48987),(-8.689653,-5.477481,-1.309755),(-8.038106,-5.170062,-2.046753),(-7.957499,-5.278265,-2.896293),(-8.34866,-5.775737,-4.020503),(-8.954921,-6.541315,-5.472238),(-9.449059,-7.388538,-7.157384),(-9.539196,-8.111058,-8.85108),(-9.058329,-8.532901,-10.264334),(-8.008572,-8.551324,-11.139245),(-6.54723,-8.161839,-11.340135),(-4.922019,-7.45931,-10.908315),(-3.379949,-6.614841,-10.059908),(-2.082787,-5.834109,-9.125288),(-1.058752,-5.307266,-8.448639),(-0.206493,-5.162628,-8.280097),(0.651671,-5.435424,-8.695947),(1.688052,-6.059211,-9.57342),(2.990417,-6.882063,-10.628574),(4.515334,-7.703567,-11.504883),(6.092259,-8.323642,-11.883391),(7.478135,-8.591263,-11.578418),(8.443755,-8.441249,-10.588134),(8.861074,-7.910138,-9.08481),(8.759467,-7.127285,-7.350065),(8.32908,-6.28336,-5.678671),(7.86759,-5.583906,-4.284461),(7.686468,-5.199279,-3.240118),(8.007494,-5.22316,-2.469985),(8.884434,-5.64973,-1.796027),(10.177072,-6.375096,-1.01837),(11.587576,-7.222591,0.0),(12.142817,-9.39924,0.0),(12.69938,-9.879144,1.270765),(12.524745,-9.890988,2.531932),(11.64365,-9.431888,3.59159),(10.254126,-8.613661,4.322476),(8.663104,-7.635592,4.717675),(7.189979,-6.735896,4.902045),(6.070203,-6.1337,5.093505),(5.390342,-5.975673,5.526444),(5.074784,-6.300304,6.363578),(4.926379,-7.028527,7.627526),(4.704972,-7.982978,9.177387),(4.21536,-8.931193,10.740561),(3.373787,-9.642229,11.991154),(2.230542,-9.942908,12.650032),(0.942263,-9.759998,12.573621),(-0.294316,-9.138047,11.801714),(-1.321822,-8.228536,10.547892),(-2.085039,-7.252982,9.135153),(-2.653442,-6.448989,7.897569),(-3.19461,-6.012374,7.079983),(-3.907641,-6.049479,6.768233),(-4.940536,-6.551265,6.871867),(-6.321894,-7.395519,7.163577),(-7.932866,-8.376618,7.360624),(-9.531521,-9.255608,7.219846),(-10.823427,-9.818406,6.614058),(-11.55568,-9.927937,5.564922),(-11.60267,-9.557525,4.223027),(-11.01384,-8.797386,2.804468),(-10.005939,-7.832657,1.508153),(-8.900798,-6.898305,0.44422),(-8.028037,-6.221898,-0.400663),(-7.624133,-5.968178,-1.149153),(-7.760732,-6.198942,-1.976125),(-8.325475,-6.857984,-3.030225),(-9.061154,-7.784792,-4.363622),(-9.649664,-8.753634,-5.896787),(-9.812591,-9.528542,-7.432749),(-9.395229,-9.920783,-8.717498),(-8.407078,-9.834822,-9.526377),(-7.007116,-9.291598,-9.746305),(-5.441077,-8.423414,-9.424222),(-3.95408,-7.441725,-8.763141),(-2.709661,-6.585626,-8.064897),(-1.743131,-6.063627,-7.637156),(-0.964293,-6.002864,-7.694875),(-0.206714,-6.418136,-8.28897),(0.695913,-7.208301,-9.286318),(1.835264,-8.180909,-10.408298),(3.183739,-9.099074,-11.315681),(4.596711,-9.739172,-11.712228),(5.861518,-9.945301,-11.433313),(6.775897,-9.667258,-10.491141),(7.227402,-8.972762,-9.062876),(7.24431,-8.030962,-7.427224),(6.998038,-7.07124,-5.872051),(6.753885,-6.327343,-4.604721),(6.785234,-5.980452,-3.695042),(7.279662,-6.115055,-3.068635),(8.269124,-6.698368,-2.550687),(9.608928,-7.588322,-1.942487),(11.014147,-8.568161,-1.102132),(12.142817,-9.39924,0.0),(11.750719,-11.169891,0.0),(11.579931,-11.062517,1.158747),(10.767405,-10.442225,2.176678),(9.509871,-9.460092,2.933407),(8.099586,-8.355322,3.414262),(6.833995,-7.39699,3.721595),(5.926663,-6.818505,4.04073),(5.44835,-6.76076,4.571708),(5.316502,-7.237819,5.45074),(5.334846,-8.133492,6.689686),(5.267889,-9.229632,8.156288),(4.923763,-10.259265,9.604155),(4.216815,-10.971618,10.744271),(3.189209,-11.193192,11.335123),(1.985711,-10.870021,11.261529),(0.792514,-10.080817,10.57536),(-0.23651,-9.017794,9.483766),(-1.038609,-7.93986,8.287904),(-1.664289,-7.109553,7.291725),(-2.254569,-6.729099,6.710385),(-2.981625,-6.891161,6.607959),(-3.974594,-7.556267,6.884199),(-5.258169,-8.562427,7.313668),(-6.72745,-9.664583,7.623127),(-8.170006,-10.594298,7.580658),(-9.329346,-11.125133,7.066705),(-9.988997,-11.127799,6.104149),(-10.04844,-10.601648,4.839074),(-9.564108,-9.674826,3.481051),(-8.739976,-8.573069,2.225471),(-7.869191,-7.564716,1.18609),(-7.244895,-6.895358,0.361578),(-7.069078,-6.728023,-0.352803),(-7.389376,-7.103465,-1.113769),(-8.084636,-7.930244,-2.058601),(-8.903917,-9.006992,-3.240761),(-9.545917,-10.071459,-4.597071),(-9.752542,-10.864387,-5.959654),(-9.385968,-11.192653,-7.109594),(-8.464599,-10.976306,-7.854),(-7.147511,-10.268038,-8.099114),(-5.674482,-9.240353,-7.892724),(-4.283505,-8.143551,-7.419249),(-3.13462,-7.244765,-6.947031),(-2.265895,-6.762901,-6.744093),(-1.595411,-6.81532,-6.989953),(-0.966585,-7.389255,-7.713163),(-0.218863,-8.34492,-8.776123),(0.742887,-9.449557,-9.913132),(1.906083,-10.434124,-10.809931),(3.150924,-11.058822,-11.199049),(4.293639,-11.171502,-10.940013),(5.156749,-10.74472,-10.058612),(5.640475,-9.882422,-8.733164),(5.768492,-8.794627,-7.23346),(5.689984,-7.746274,-5.833653),(5.635262,-6.992696,-4.728546),(5.838812,-6.717434,-3.980834),(6.455698,-6.987529,-3.515586),(7.50038,-7.737197,-3.161675),(8.830072,-8.783851,-2.723717),(10.180014,-9.872573,-2.057934),(11.24044,-10.738196,-1.124776),(11.750719,-11.169891,0.0),(10.368459,-12.077809,0.0),(9.642973,-11.288815,0.964925),(8.543047,-10.152763,1.727014),(7.338976,-8.946345,2.263774),(6.299533,-7.963393,2.655476),(5.611725,-7.443312,3.055983),(5.328829,-7.512771,3.633134),(5.362856,-8.154852,4.49997),(5.522529,-9.213173,5.66197),(5.582626,-10.429972,7.000392),(5.360389,-11.50889,8.299505),(4.773023,-12.187148,9.310127),(3.85757,-12.299552,9.828928),(2.747959,-11.818726,9.766827),(1.619188,-10.861778,9.18287),(0.619839,-9.661778,8.271172),(-0.182155,-8.510997,7.30418),(-0.820843,-7.689713,6.55017),(-1.413216,-7.397956,6.191706),(-2.107127,-7.706787,6.271543),(-3.015638,-8.540986,6.683339),(-4.162463,-9.697379,7.209598),(-5.459443,-10.894319,7.593622),(-6.725738,-11.840282,7.621188),(-7.743511,-12.304873,7.184928),(-8.331502,-12.174938,6.310868),(-8.410955,-11.482122,5.139828),(-8.040209,-10.395167,3.87196),(-7.404541,-9.178807,2.695032),(-6.762969,-8.129296,1.722063),(-6.368534,-7.502248,0.959902),(-6.387996,-7.450386,0.318812),(-6.847526,-7.986341,-0.341746),(-7.622615,-8.979578,-1.148924),(-8.475813,-10.188186,-2.158207),(-9.130067,-11.317802,-3.323073),(-9.35364,-12.093299,-4.504475),(-9.028971,-12.3258,-5.517489),(-8.183512,-11.958677,-6.198769),(-6.97354,-11.081347,-6.4705),(-5.627836,-9.907488,-6.377113),(-4.371336,-8.723002,-6.080158),(-3.35507,-7.816379,-5.811153),(-2.615758,-7.408433,-5.797114),(-2.077526,-7.598522,-6.183441),(-1.59324,-8.340348,-6.980439),(-1.009091,-9.453236,-8.052355),(-0.22828,-10.666132,-9.153728),(0.749548,-11.683629,-10.00202),(1.827312,-12.257907,-10.363199),(2.848024,-12.249098,-10.122481),(3.656779,-11.659346,-9.317321),(4.164073,-10.632291,-8.122325),(4.38657,-9.418078,-6.791739),(4.449219,-8.312437,-5.579144),(4.546368,-7.584654,-4.661161),(4.874327,-7.411987,-4.090046),(5.558443,-7.836489,-3.789682),(6.600471,-8.75477,-3.594425),(7.865663,-9.943177,-3.315655),(9.11575,-11.112264,-2.811836),(10.078299,-11.977293,-2.037372),(10.530291,-12.327579,-1.053715),(10.368459,-12.077809,0.0),(8.327509,-11.964459,0.0),(7.404441,-10.691379,0.740926),(6.421789,-9.413074,1.298193),(5.614017,-8.440884,1.731695),(5.138365,-8.011592,2.166003),(5.030522,-8.229755,2.739476),(5.200003,-9.042238,3.545302),(5.465738,-10.251155,4.586299),(5.619016,-11.562067,5.760893),(5.492085,-12.655691,6.886857),(5.009426,-13.265668,7.756109),(4.205214,-13.243434,8.202574),(3.202566,-12.594405,8.160006),(2.16347,-11.476654,7.68943),(1.228257,-10.16242,6.965794),(0.466656,-8.971791,6.22709),(-0.142198,-8.194755,5.701945),(-0.694146,-8.020563,5.539152),(-1.315178,-8.491642,5.762172),(-2.104401,-9.493256,6.263431),(-3.086346,-10.781456,6.840044),(-4.190911,-12.042492,7.25887),(-5.269367,-12.969229,7.329243),(-6.141834,-13.335956,6.959543),(-6.66007,-13.053352,6.179642),(-6.763401,-12.190248,5.123077),(-6.507366,-10.956859,3.976569),(-6.053694,-9.653585,2.915306),(-5.623383,-8.597848,2.046744),(-5.427534,-8.046779,1.38202),(-5.598607,-8.134595,0.843854),(-6.145109,-8.839908,0.30669),(-6.945251,-9.990934,-0.346623),(-7.782233,-11.307333,-1.172983),(-8.409966,-12.468487,-2.14144),(-8.627897,-13.191588,-3.140298),(-8.340662,-13.300521,-4.016651),(-7.583465,-12.768755,-4.634159),(-6.505717,-11.725803,-4.927889),(-5.319385,-10.425686,-4.935668),(-4.230148,-9.185054,-4.793341),(-3.374737,-8.306073,-4.693974),(-2.785065,-8.002824,-4.823874),(-2.390068,-8.349166,-5.296935),(-2.052859,-9.260744,-6.110025),(-1.628638,-10.515538,-7.135527),(-1.021927,-11.807934,-8.154782),(-0.222511,-12.82316,-8.922409),(0.692508,-13.313951,-9.240871),(1.590646,-13.160771,-9.021003),(2.337706,-12.400928,-8.308699),(2.852946,-11.219488,-7.269187),(3.1449,-9.904197,-6.134353),(3.313798,-8.775405,-5.130763),(3.518577,-8.108036,-4.412156),(3.919308,-8.064633,-4.018268),(4.615105,-8.655766,-3.872532),(5.599811,-9.737462,-3.817887),(6.752143,-11.046265,-3.677021),(7.865337,-12.263408,-3.315518),(8.707764,-13.092447,-2.68599),(9.094994,-13.331464,-1.838593),(8.949454,-12.922246,-0.895528),(8.327509,-11.964459,0.0),(6.14936,-11.079023,0.0),(5.391419,-9.761986,0.539493),(4.806997,-8.835741,0.971755),(4.522009,-8.52588,1.394855),(4.55603,-8.907874,1.920528),(4.820266,-9.888684,2.624977),(5.149815,-11.229428,3.511084),(5.358899,-12.603558,4.49665),(5.300329,-13.676396,5.434159),(4.909502,-14.186644,6.156321),(4.218948,-14.010028,6.53221),(3.339829,-13.189564,6.514578),(2.418178,-11.925082,6.161417),(1.582143,-10.524555,5.62327),(0.899162,-9.329091,5.099401),(0.357954,-8.629853,4.776565),(-0.118964,-8.597146,4.770322),(-0.637638,-9.238935,5.08823),(-1.284361,-10.398909,5.627153),(-2.084975,-11.794548,6.205614),(-2.987296,-13.085934,6.620528),(-3.873811,-13.958542,6.709638),(-4.600808,-14.199841,6.399334),(-5.050292,-13.751063,5.722677),(-5.176089,-12.721509,4.802709),(-5.027027,-11.361935,3.807825),(-4.737796,-10.003474,2.895207),(-4.489199,-8.976989,2.161885),(-4.450306,-8.532487,1.619779),(-4.72165,-8.77823,1.20228),(-5.298759,-9.654365,0.798659),(-6.068807,-10.947504,0.302882),(-6.842238,-12.342694,-0.341482),(-7.409489,-13.500126,-1.116801),(-7.604519,-14.137901,-1.936348),(-7.354521,-14.100683,-2.676827),(-6.699821,-13.397538,-3.226464),(-5.777972,-12.199721,-3.530845),(-4.777946,-10.798969,-3.619153),(-3.88016,-9.536444,-3.600262),(-3.202425,-8.719644,-3.628789),(-2.769427,-8.547505,-3.852039),(-2.514897,-9.061953,-4.355929),(-2.314262,-10.13769,-5.128932),(-2.035154,-11.512715,-6.05733),(-1.587356,-12.852129,-6.954661),(-0.954477,-13.829709,-7.616542),(-0.196597,-14.20736,-7.883277),(0.576266,-13.893101,-7.689738),(1.249453,-12.963472,-7.086001),(1.750562,-11.644892,-6.221866),(2.080229,-10.258509,-5.300336),(2.314911,-9.141986,-4.515402),(2.579925,-8.56726,-3.994506),(3.001876,-8.67431,-3.764233),(3.657362,-9.437062,-3.749708),(4.536662,-10.669744,-3.806711),(5.536277,-12.072127,-3.77457),(6.484414,-13.302651,-3.531224),(7.191967,-14.061614,-3.031668),(7.512477,-14.164164,-2.317292),(7.390962,-13.585326,-1.494115),(6.884855,-12.466079,-0.688934),(6.14936,-11.079023,0.0),(4.29179,-10.001054,0.0),(3.908848,-9.154182,0.391139),(3.780321,-8.987387,0.764208),(3.912584,-9.541292,1.206872),(4.223654,-10.68099,1.78042),(4.571074,-12.1289,2.489274),(4.798133,-13.532373,3.271312),(4.782966,-14.549585,4.013385),(4.474415,-14.932785,4.587391),(3.903345,-14.588644,4.89464),(3.166647,-13.600978,4.902928),(2.390485,-12.210341,4.662813),(1.686239,-10.755432,4.296466),(1.114685,-9.590604,3.961827),(0.670632,-8.999559,3.803342),(0.292672,-9.126249,3.905431),(-0.106342,-9.93982,4.264187),(-0.59988,-11.242119,4.786932),(-1.214263,-12.715963,5.320035),(-1.913754,-14.002387,5.695998),(-2.610054,-14.788075,5.784473),(-3.193113,-14.881665,5.530633),(-3.57228,-14.260364,4.968739),(-3.712809,-13.075494,4.207125),(-3.654016,-11.615638,3.390432),(-3.501616,-10.236354,2.652371),(-3.39576,-9.273575,2.075106),(-3.464954,-8.961795,1.668634),(-3.78129,-9.376947,1.376277),(-4.332436,-10.417921,1.103174),(-5.020451,-11.831178,0.756711),(-5.688603,-13.272511,0.283906),(-6.167933,-14.390873,-0.307829),(-6.328567,-14.91388,-0.953878),(-6.119082,-14.714149,-1.55811),(-5.581165,-13.840326,-2.031378),(-4.834977,-12.505238,-2.328402),(-4.040405,-11.034053,-2.46904),(-3.347249,-9.785089,-2.535443),(-2.85087,-9.06254,-2.64522),(-2.567602,-9.042387,-2.909446),(-2.43729,-9.729539,-3.390064),(-2.350931,-10.956636,-4.071932),(-2.192944,-12.424808,-4.860063),(-1.882877,-13.776474,-5.6041),(-1.402043,-14.682425,-6.142753),(-0.79624,-14.922011,-6.353843),(-0.154454,-14.436879,-6.193427),(0.42797,-13.345187,-5.710857),(0.887723,-11.912822,-5.034529),(1.219062,-10.488649,-4.332804),(1.476796,-9.419533,-3.762815),(1.755296,-8.965866,-3.423832),(2.150869,-9.23814,-3.330197),(2.721102,-10.170043,-3.412154),(3.456194,-11.534602,-3.54346),(4.273388,-12.99947,-3.585798),(5.037641,-14.207868,-3.434605),(5.602422,-14.865482,-3.050916),(5.857265,-14.812147,-2.469044),(5.765914,-14.060852,-1.778549),(5.381722,-12.79458,-1.087939),(4.834398,-11.321741,-0.483755),(4.29179,-10.001054,0.0),(2.949849,-9.401849,0.0),(2.933269,-9.395695,0.293518),(3.112887,-10.122188,0.629284),(3.419182,-11.404385,1.054678),(3.738257,-12.93,1.575808),(3.947842,-14.327457,2.14988),(3.954978,-15.256397,2.696459),(3.723128,-15.49057,3.124075),(3.28017,-14.972942,3.362993),(2.70536,-13.829584,3.392414),(2.100401,-12.338969,3.252057),(1.555061,-10.864146,3.03326),(1.11925,-9.76432,2.851802),(0.790909,-9.307359,2.811058),(0.52328,-9.60456,2.967669),(0.248149,-10.583538,3.311321),(-0.09391,-12.005856,3.765691),(-0.527656,-13.525098,4.210594),(-1.031275,-14.771243,4.518311),(-1.542933,-15.440783,4.592307),(-1.983462,-15.370648,4.395803),(-2.286926,-14.577919,3.961072),(-2.427786,-13.255671,3.376845),(-2.434368,-11.725947,2.758475),(-2.383068,-10.361321,2.211164),(-2.374507,-9.494157,1.798619),(-2.499359,-9.335659,1.527326),(-2.805446,-9.924431,1.351032),(-3.277651,-11.117072,1.192968),(-3.838055,-12.623107,0.977289),(-4.366963,-14.075731,0.658214),(-4.738393,-15.121148,0.236483),(-4.858596,-15.504738,-0.242482),(-4.695002,-15.133076,-0.707658),(-4.286096,-14.096682,-1.091374),(-3.729009,-12.647979,-1.357248),(-3.149009,-11.139806,-1.516483),(-2.661018,-9.93949,-1.626114),(-2.335796,-9.339376,-1.769297),(-2.181661,-9.485626,-2.024286),(-2.147183,-10.34262,-2.433054),(-2.143163,-11.701631,-2.980958),(-2.07573,-13.231663,-3.595271),(-1.878862,-14.560065,-4.163986),(-1.53519,-15.363297,-4.569261),(-1.078365,-15.445725,-4.724625),(-0.576897,-14.787274,-4.603531),(-0.105976,-13.548315,-4.24949),(0.282078,-12.030603,-3.764071),(0.577721,-10.603789,-3.276416),(0.817084,-9.615382,-2.904089),(1.066727,-9.306116,-2.717977),(1.395774,-9.751315,-2.722558),(1.845672,-10.842547,-2.85766),(2.408886,-12.314036,-3.020648),(3.024829,-13.807389,-3.101204),(3.59534,-14.958892,-3.016848),(4.01504,-15.488087,-2.737408),(4.206475,-15.266085,-2.290724),(4.147921,-14.346957,-1.748495),(3.883945,-12.954562,-1.198038),(3.514474,-11.428027,-0.710466),(3.165371,-10.139152,-0.316743),(2.949849,-9.401849,0.0),(2.003384,-9.748581,0.0),(2.175895,-10.640903,0.217731),(2.425825,-12.042985,0.490391),(2.673323,-13.613342,0.824611),(2.834747,-14.969502,1.194946),(2.848171,-15.781164,1.551031),(2.691381,-15.85064,1.834953),(2.386739,-15.161011,2.002712),(1.991694,-13.88024,2.041983),(1.578601,-12.320267,1.979503),(1.210963,-10.861034,1.874937),(0.924219,-9.857949,1.802756),(0.717408,-9.555318,1.827927),(0.558086,-10.02685,1.983555),(0.398169,-11.1577,2.25813),(0.194616,-12.672442,2.596971),(-0.072763,-14.20215,2.917709),(-0.392863,-15.374252,3.134969),(-0.727244,-15.903277,3.186266),(-1.024982,-15.660375,3.050704),(-1.242866,-14.704707,2.754474),(-1.363428,-13.269034,2.361526),(-1.403922,-11.703022,1.952737),(-1.412571,-10.388085,1.600637),(-1.452903,-9.644485,1.348097),(-1.581359,-9.65333,1.197833),(-1.825886,-10.412467,1.115776),(-2.173151,-11.737002,1.046534),(-2.569223,-13.304336,0.935121),(-2.93403,-14.732733,0.747096),(-3.185173,-15.674299,0.480088),(-3.263411,-15.899707,0.16287),(-3.151417,-15.354059,-0.157281),(-2.879535,-14.170251,-0.43402),(-2.516586,-12.636607,-0.640801),(-2.148688,-11.126656,-0.782058),(-1.853049,-10.008159,-0.892381),(-1.675266,-9.553531,-1.023734),(-1.617427,-9.873502,-1.225153),(-1.640556,-10.890139,-1.522213),(-1.680145,-12.355835,-1.903836),(-1.669109,-13.913608,-2.32159),(-1.560201,-15.184053,-2.702348),(-1.340323,-15.857743,-2.97046),(-1.032196,-15.770598,-3.072176),(-0.68337,-14.943841,-2.99404),(-0.346984,-13.578835,-2.768865),(-0.061522,-12.008037,-2.466947),(0.163004,-10.614026,-2.175139),(0.347447,-9.736321,-1.970467),(0.533698,-9.588695,-1.896877),(0.766344,-10.207102,-1.952613),(1.072629,-11.440926,-2.09224),(1.448296,-12.98966,-2.242401),(1.854828,-14.476099,-2.325881),(2.229598,-15.538211,-2.285894),(2.505801,-15.917311,-2.102616),(2.635421,-15.521067,-1.7968),(2.607199,-14.445987,-1.419805),(2.453059,-12.953914,-1.034051),(2.240298,-11.408252,-0.69104),(2.051663,-10.185458,-0.414753),(1.959642,-9.583352,-0.196092),(2.003384,-9.748581,0.0),(1.127357,-11.086205,0.0),(1.272937,-12.58033,0.127377),(1.411423,-14.160423,0.285325),(1.500499,-15.441642,0.462843),(1.509769,-16.111938,0.636421),(1.429622,-16.008055,0.778531),(1.273352,-15.155294,0.868157),(1.071997,-13.761352,0.899512),(0.863813,-12.165733,0.885623),(0.682027,-10.75706,0.855235),(0.545008,-9.878425,0.843838),(0.452036,-9.743827,0.88173),(0.385858,-10.386047,0.983149),(0.320825,-11.648668,1.14028),(0.233516,-13.22417,1.324337),(0.111929,-14.72883,1.493587),(-0.040047,-15.796176,1.605815),(-0.204414,-16.166248,1.631189),(-0.356369,-15.748916,1.561355),(-0.474333,-14.64582,1.411781),(-0.548964,-13.125629,1.216629),(-0.587697,-11.558595,1.017921),(-0.612984,-10.32638,0.852608),(-0.654641,-9.729099,0.741798),(-0.738898,-9.912223,0.685597),(-0.877978,-10.831151,0.665043),(-1.063995,-12.262073,0.650194),(-1.269525,-13.856476,0.611371),(-1.45496,-15.226034,0.529562),(-1.580393,-16.037182,0.402417),(-1.618155,-16.092358,0.243898),(-1.561858,-15.378124,0.077949),(-1.428842,-14.068436,-0.071311),(-1.255146,-12.482279,-0.189183),(-1.084589,-11.005972,-0.27617),(-0.955486,-9.999078,-0.347768),(-0.889336,-9.706835,-0.428282),(-0.885103,-10.20042,-0.540875),(-0.920816,-11.359617,-0.697491),(-0.961775,-12.902095,-0.892397),(-0.972442,-14.452174,-1.10191),(-0.927949,-15.632321,-1.290699),(-0.821407,-16.155104,-1.422718),(-0.664714,-15.893194,-1.473157),(-0.482901,-14.910382,-1.437283),(-0.304259,-13.446039,-1.333047),(-0.149924,-11.856815,-1.196363),(-0.026695,-10.529776,-1.070441),(0.074383,-9.788133,-0.992573),(0.173272,-9.812517,-0.982676),(0.29186,-10.596989,-1.037332),(0.443979,-11.950486,-1.13124),(0.628305,-13.543355,-1.225553),(0.826892,-14.98764,-1.280279),(1.010105,-15.931578,-1.266632),(1.146374,-16.145264,-1.175319),(1.213408,-15.576655,-1.01817),(1.206887,-14.364239,-0.822842),(1.143417,-12.803308,-0.622672),(1.056433,-11.274038,-0.445324),(0.986191,-10.148893,-0.3042),(0.967026,-9.701909,-0.195489),(1.016092,-10.041954,-0.101675),(1.127357,-11.086205,0.0),(0.0,-13.0,0.0),(0.0,-14.554325,0.0),(0.0,-15.730084,0.0),(0.0,-16.240911,0.0),(0.0,-15.962394,0.0),(0.0,-14.962364,0.0),(0.0,-13.484387,0.0),(0.0,-11.888435,0.0),(0.0,-10.563211,0.0),(0.0,-9.831484,0.0),(0.0,-9.871471,0.0),(0.0,-10.673433,0.0),(0.0,-12.042046,0.0),(0.0,-13.643975,0.0),(0.0,-15.08906,0.0),(0.0,-16.02534,0.0),(0.0,-16.224777,0.0),(0.0,-15.638799,0.0),(0.0,-14.410122,0.0),(0.0,-12.838001,0.0),(0.0,-11.305336,0.0),(0.0,-10.185417,0.0),(0.0,-9.75101,0.0),(0.0,-10.107917,0.0),(0.0,-11.16921,0.0),(0.0,-12.676404,0.0),(0.0,-14.262413,0.0),(0.0,-15.540952,0.0),(0.0,-16.200624,0.0),(0.0,-16.080765,0.0),(0.0,-15.210561,0.0),(0.0,-13.801962,0.0),(0.0,-12.198038,0.0),(0.0,-10.789439,0.0),(0.0,-9.919236,0.0),(0.0,-9.799375,0.0),(0.0,-10.459048,0.0),(0.0,-11.737587,0.0),(0.0,-13.323596,0.0),(0.0,-14.83079,0.0),(0.0,-15.892083,0.0),(0.0,-16.24899,0.0),(0.0,-15.814583,0.0),(0.0,-14.694664,0.0),(0.0,-13.161999,0.0),(0.0,-11.589878,0.0),(0.0,-10.361201,0.0),(0.0,-9.775223,0.0),(0.0,-9.97466,0.0),(0.0,-10.91094,0.0),(0.0,-12.356025,0.0),(0.0,-13.957954,0.0),(0.0,-15.326567,0.0),(0.0,-16.128529,0.0),(0.0,-16.168516,0.0),(0.0,-15.436789,0.0),(0.0,-14.111565,0.0),(0.0,-12.515613,0.0),(0.0,-11.037636,0.0),(0.0,-10.037606,0.0),(0.0,-9.759088,0.0),(0.0,-10.269916,0.0),(0.0,-11.445675,0.0),(0.0,-13.0,0.0)]))),
    Shape(
      appearance=Appearance(
        material=Material(diffuseColor=(1.0,0.5,0.0),transparency=0.5)),
      geometry=IndexedFaceSet(ccw=False,coordIndex=[0,1,65,64,-1,1,2,66,65,-1,2,3,67,66,-1,3,4,68,67,-1,4,5,69,68,-1,5,6,70,69,-1,6,7,71,70,-1,7,8,72,71,-1,8,9,73,72,-1,9,10,74,73,-1,10,11,75,74,-1,11,12,76,75,-1,12,13,77,76,-1,13,14,78,77,-1,14,15,79,78,-1,15,16,80,79,-1,16,17,81,80,-1,17,18,82,81,-1,18,19,83,82,-1,19,20,84,83,-1,20,21,85,84,-1,21,22,86,85,-1,22,23,87,86,-1,23,24,88,87,-1,24,25,89,88,-1,25,26,90,89,-1,26,27,91,90,-1,27,28,92,91,-1,28,29,93,92,-1,29,30,94,93,-1,30,31,95,94,-1,31,32,96,95,-1,32,33,97,96,-1,33,34,98,97,-1,34,35,99,98,-1,35,36,100,99,-1,36,37,101,100,-1,37,38,102,101,-1,38,39,103,102,-1,39,40,104,103,-1,40,41,105,104,-1,41,42,106,105,-1,42,43,107,106,-1,43,44,108,107,-1,44,45,109,108,-1,45,46,110,109,-1,46,47,111,110,-1,47,48,112,111,-1,48,49,113,112,-1,49,50,114,113,-1,50,51,115,114,-1,51,52,116,115,-1,52,53,117,116,-1,53,54,118,117,-1,54,55,119,118,-1,55,56,120,119,-1,56,57,121,120,-1,57,58,122,121,-1,58,59,123,122,-1,59,60,124,123,-1,60,61,125,124,-1,61,62,126,125,-1,62,63,127,126,-1,63,0,64,127,-1,64,65,129,128,-1,65,66,130,129,-1,66,67,131,130,-1,67,68,132,131,-1,68,69,133,132,-1,69,70,134,133,-1,70,71,135,134,-1,71,72,136,135,-1,72,73,137,136,-1,73,74,138,137,-1,74,75,139,138,-1,75,76,140,139,-1,76,77,141,140,-1,77,78,142,141,-1,78,79,143,142,-1,79,80,144,143,-1,80,81,145,144,-1,81,82,146,145,-1,82,83,147,146,-1,83,84,148,147,-1,84,85,149,148,-1,85,86,150,149,-1,86,87,151,150,-1,87,88,152,151,-1,88,89,153,152,-1,89,90,154,153,-1,90,91,155,154,-1,91,92,156,155,-1,92,93,157,156,-1,93,94,158,157,-1,94,95,159,158,-1,95,96,160,159,-1,96,97,161,160,-1,97,98,162,161,-1,98,99,163,162,-1,99,100,164,163,-1,100,101,165,164,-1,101,102,166,165,-1,102,103,167,166,-1,103,104,168,167,-1,104,105,169,168,-1,105,106,170,169,-1,106,107,171,170,-1,107,108,172,171,-1,108,109,173,172,-1,109,110,174,173,-1,110,111,175,174,-1,111,112,176,175,-1,112,113,177,176,-1,113,114,178,177,-1,114,115,179,178,-1,115,116,180,179,-1,116,117,181,180,-1,117,118,182,181,-1,118,119,183,182,-1,119,120,184,183,-1,120,121,185,184,-1,121,122,186,185,-1,122,123,187,186,-1,123,124,188,187,-1,124,125,189,188,-1,125,126,190,189,-1,126,127,191,190,-1,127,64,128,191,-1,128,129,193,192,-1,129,130,194,193,-1,130,131,195,194,-1,131,132,196,195,-1,132,133,197,196,-1,133,134,198,197,-1,134,135,199,198,-1,135,136,200,199,-1,136,137,201,200,-1,137,138,202,201,-1,138,139,203,202,-1,139,140,204,203,-1,140,141,205,204,-1,141,142,206,205,-1,142,143,207,206,-1,143,144,208,207,-1,144,145,209,208,-1,145,146,210,209,-1,146,147,211,210,-1,147,148,212,211,-1,148,149,213,212,-1,149,150,214,213,-1,150,151,215,214,-1,151,152,216,215,-1,152,153,217,216,-1,153,154,218,217,-1,154,155,219,218,-1,155,156,220,219,-1,156,157,221,220,-1,157,158,222,221,-1,158,159,223,222,-1,159,160,224,223,-1,160,161,225,224,-1,161,162,226,225,-1,162,163,227,226,-1,163,164,228,227,-1,164,165,229,228,-1,165,166,230,229,-1,166,167,231,230,-1,167,168,232,231,-1,168,169,233,232,-1,169,170,234,233,-1,170,171,235,234,-1,171,172,236,235,-1,172,173,237,236,-1,173,174,238,237,-1,174,175,239,238,-1,175,176,240,239,-1,176,177,241,240,-1,177,178,242,241,-1,178,179,243,242,-1,179,180,244,243,-1,180,181,245,244,-1,181,182,246,245,-1,182,183,247,246,-1,183,184,248,247,-1,184,185,249,248,-1,185,186,250,249,-1,186,187,251,250,-1,187,188,252,251,-1,188,189,253,252,-1,189,190,254,253,-1,190,191,255,254,-1,191,128,192,255,-1,192,193,257,256,-1,193,194,258,257,-1,194,195,259,258,-1,195,196,260,259,-1,196,197,261,260,-1,197,198,262,261,-1,198,199,263,262,-1,199,200,264,263,-1,200,201,265,264,-1,201,202,266,265,-1,202,203,267,266,-1,203,204,268,267,-1,204,205,269,268,-1,205,206,270,269,-1,206,207,271,270,-1,207,208,272,271,-1,208,209,273,272,-1,209,210,274,273,-1,210,211,275,274,-1,211,212,276,275,-1,212,213,277,276,-1,213,214,278,277,-1,214,215,279,278,-1,215,216,280,279,-1,216,217,281,280,-1,217,218,282,281,-1,218,219,283,282,-1,219,220,284,283,-1,220,221,285,284,-1,221,222,286,285,-1,222,223,287,286,-1,223,224,288,287,-1,224,225,289,288,-1,225,226,290,289,-1,226,227,291,290,-1,227,228,292,291,-1,228,229,293,292,-1,229,230,294,293,-1,230,231,295,294,-1,231,232,296,295,-1,232,233,297,296,-1,233,234,298,297,-1,234,235,299,298,-1,235,236,300,299,-1,236,237,301,300,-1,237,238,302,301,-1,238,239,303,302,-1,239,240,304,303,-1,240,241,305,304,-1,241,242,306,305,-1,242,243,307,306,-1,243,244,308,307,-1,244,245,309,308,-1,245,246,310,309,-1,246,247,311,310,-1,247,248,312,311,-1,248,249,313,312,-1,249,250,314,313,-1,250,251,315,314,-1,251,252,316,315,-1,252,253,317,316,-1,253,254,318,317,-1,254,255,319,318,-1,255,192,256,319,-1,256,257,321,320,-1,257,258,322,321,-1,258,259,323,322,-1,259,260,324,323,-1,260,261,325,324,-1,261,262,326,325,-1,262,263,327,326,-1,263,264,328,327,-1,264,265,329,328,-1,265,266,330,329,-1,266,267,331,330,-1,267,268,332,331,-1,268,269,333,332,-1,269,270,334,333,-1,270,271,335,334,-1,271,272,336,335,-1,272,273,337,336,-1,273,274,338,337,-1,274,275,339,338,-1,275,276,340,339,-1,276,277,341,340,-1,277,278,342,341,-1,278,279,343,342,-1,279,280,344,343,-1,280,281,345,344,-1,281,282,346,345,-1,282,283,347,346,-1,283,284,348,347,-1,284,285,349,348,-1,285,286,350,349,-1,286,287,351,350,-1,287,288,352,351,-1,288,289,353,352,-1,289,290,354,353,-1,290,291,355,354,-1,291,292,356,355,-1,292,293,357,356,-1,293,294,358,357,-1,294,295,359,358,-1,295,296,360,359,-1,296,297,361,360,-1,297,298,362,361,-1,298,299,363,362,-1,299,300,364,363,-1,300,301,365,364,-1,301,302,366,365,-1,302,303,367,366,-1,303,304,368,367,-1,304,305,369,368,-1,305,306,370,369,-1,306,307,371,370,-1,307,308,372,371,-1,308,309,373,372,-1,309,310,374,373,-1,310,311,375,374,-1,311,312,376,375,-1,312,313,377,376,-1,313,314,378,377,-1,314,315,379,378,-1,315,316,380,379,-1,316,317,381,380,-1,317,318,382,381,-1,318,319,383,382,-1,319,256,320,383,-1,320,321,385,384,-1,321,322,386,385,-1,322,323,387,386,-1,323,324,388,387,-1,324,325,389,388,-1,325,326,390,389,-1,326,327,391,390,-1,327,328,392,391,-1,328,329,393,392,-1,329,330,394,393,-1,330,331,395,394,-1,331,332,396,395,-1,332,333,397,396,-1,333,334,398,397,-1,334,335,399,398,-1,335,336,400,399,-1,336,337,401,400,-1,337,338,402,401,-1,338,339,403,402,-1,339,340,404,403,-1,340,341,405,404,-1,341,342,406,405,-1,342,343,407,406,-1,343,344,408,407,-1,344,345,409,408,-1,345,346,410,409,-1,346,347,411,410,-1,347,348,412,411,-1,348,349,413,412,-1,349,350,414,413,-1,350,351,415,414,-1,351,352,416,415,-1,352,353,417,416,-1,353,354,418,417,-1,354,355,419,418,-1,355,356,420,419,-1,356,357,421,420,-1,357,358,422,421,-1,358,359,423,422,-1,359,360,424,423,-1,360,361,425,424,-1,361,362,426,425,-1,362,363,427,426,-1,363,364,428,427,-1,364,365,429,428,-1,365,366,430,429,-1,366,367,431,430,-1,367,368,432,431,-1,368,369,433,432,-1,369,370,434,433,-1,370,371,435,434,-1,371,372,436,435,-1,372,373,437,436,-1,373,374,438,437,-1,374,375,439,438,-1,375,376,440,439,-1,376,377,441,440,-1,377,378,442,441,-1,378,379,443,442,-1,379,380,444,443,-1,380,381,445,444,-1,381,382,446,445,-1,382,383,447,446,-1,383,320,384,447,-1,384,385,449,448,-1,385,386,450,449,-1,386,387,451,450,-1,387,388,452,451,-1,388,389,453,452,-1,389,390,454,453,-1,390,391,455,454,-1,391,392,456,455,-1,392,393,457,456,-1,393,394,458,457,-1,394,395,459,458,-1,395,396,460,459,-1,396,397,461,460,-1,397,398,462,461,-1,398,399,463,462,-1,399,400,464,463,-1,400,401,465,464,-1,401,402,466,465,-1,402,403,467,466,-1,403,404,468,467,-1,404,405,469,468,-1,405,406,470,469,-1,406,407,471,470,-1,407,408,472,471,-1,408,409,473,472,-1,409,410,474,473,-1,410,411,475,474,-1,411,412,476,475,-1,412,413,477,476,-1,413,414,478,477,-1,414,415,479,478,-1,415,416,480,479,-1,416,417,481,480,-1,417,418,482,481,-1,418,419,483,482,-1,419,420,484,483,-1,420,421,485,484,-1,421,422,486,485,-1,422,423,487,486,-1,423,424,488,487,-1,424,425,489,488,-1,425,426,490,489,-1,426,427,491,490,-1,427,428,492,491,-1,428,429,493,492,-1,429,430,494,493,-1,430,431,495,494,-1,431,432,496,495,-1,432,433,497,496,-1,433,434,498,497,-1,434,435,499,498,-1,435,436,500,499,-1,436,437,501,500,-1,437,438,502,501,-1,438,439,503,502,-1,439,440,504,503,-1,440,441,505,504,-1,441,442,506,505,-1,442,443,507,506,-1,443,444,508,507,-1,444,445,509,508,-1,445,446,510,509,-1,446,447,511,510,-1,447,384,448,511,-1,448,449,513,512,-1,449,450,514,513,-1,450,451,515,514,-1,451,452,516,515,-1,452,453,517,516,-1,453,454,518,517,-1,454,455,519,518,-1,455,456,520,519,-1,456,457,521,520,-1,457,458,522,521,-1,458,459,523,522,-1,459,460,524,523,-1,460,461,525,524,-1,461,462,526,525,-1,462,463,527,526,-1,463,464,528,527,-1,464,465,529,528,-1,465,466,530,529,-1,466,467,531,530,-1,467,468,532,531,-1,468,469,533,532,-1,469,470,534,533,-1,470,471,535,534,-1,471,472,536,535,-1,472,473,537,536,-1,473,474,538,537,-1,474,475,539,538,-1,475,476,540,539,-1,476,477,541,540,-1,477,478,542,541,-1,478,479,543,542,-1,479,480,544,543,-1,480,481,545,544,-1,481,482,546,545,-1,482,483,547,546,-1,483,484,548,547,-1,484,485,549,548,-1,485,486,550,549,-1,486,487,551,550,-1,487,488,552,551,-1,488,489,553,552,-1,489,490,554,553,-1,490,491,555,554,-1,491,492,556,555,-1,492,493,557,556,-1,493,494,558,557,-1,494,495,559,558,-1,495,496,560,559,-1,496,497,561,560,-1,497,498,562,561,-1,498,499,563,562,-1,499,500,564,563,-1,500,501,565,564,-1,501,502,566,565,-1,502,503,567,566,-1,503,504,568,567,-1,504,505,569,568,-1,505,506,570,569,-1,506,507,571,570,-1,507,508,572,571,-1,508,509,573,572,-1,509,510,574,573,-1,510,511,575,574,-1,511,448,512,575,-1,512,513,577,576,-1,513,514,578,577,-1,514,515,579,578,-1,515,516,580,579,-1,516,517,581,580,-1,517,518,582,581,-1,518,519,583,582,-1,519,520,584,583,-1,520,521,585,584,-1,521,522,586,585,-1,522,523,587,586,-1,523,524,588,587,-1,524,525,589,588,-1,525,526,590,589,-1,526,527,591,590,-1,527,528,592,591,-1,528,529,593,592,-1,529,530,594,593,-1,530,531,595,594,-1,531,532,596,595,-1,532,533,597,596,-1,533,534,598,597,-1,534,535,599,598,-1,535,536,600,599,-1,536,537,601,600,-1,537,538,602,601,-1,538,539,603,602,-1,539,540,604,603,-1,540,541,605,604,-1,541,542,606,605,-1,542,543,607,606,-1,543,544,608,607,-1,544,545,609,608,-1,545,546,610,609,-1,546,547,611,610,-1,547,548,612,611,-1,548,549,613,612,-1,549,550,614,613,-1,550,551,615,614,-1,551,552,616,615,-1,552,553,617,616,-1,553,554,618,617,-1,554,555,619,618,-1,555,556,620,619,-1,556,557,621,620,-1,557,558,622,621,-1,558,559,623,622,-1,559,560,624,623,-1,560,561,625,624,-1,561,562,626,625,-1,562,563,627,626,-1,563,564,628,627,-1,564,565,629,628,-1,565,566,630,629,-1,566,567,631,630,-1,567,568,632,631,-1,568,569,633,632,-1,569,570,634,633,-1,570,571,635,634,-1,571,572,636,635,-1,572,573,637,636,-1,573,574,638,637,-1,574,575,639,638,-1,575,512,576,639,-1,576,577,641,640,-1,577,578,642,641,-1,578,579,643,642,-1,579,580,644,643,-1,580,581,645,644,-1,581,582,646,645,-1,582,583,647,646,-1,583,584,648,647,-1,584,585,649,648,-1,585,586,650,649,-1,586,587,651,650,-1,587,588,652,651,-1,588,589,653,652,-1,589,590,654,653,-1,590,591,655,654,-1,591,592,656,655,-1,592,593,657,656,-1,593,594,658,657,-1,594,595,659,658,-1,595,596,660,659,-1,596,597,661,660,-1,597,598,662,661,-1,598,599,663,662,-1,599,600,664,663,-1,600,601,665,664,-1,601,602,666,665,-1,602,603,667,666,-1,603,604,668,667,-1,604,605,669,668,-1,605,606,670,669,-1,606,607,671,670,-1,607,608,672,671,-1,608,609,673,672,-1,609,610,674,673,-1,610,611,675,674,-1,611,612,676,675,-1,612,613,677,676,-1,613,614,678,677,-1,614,615,679,678,-1,615,616,680,679,-1,616,617,681,680,-1,617,618,682,681,-1,618,619,683,682,-1,619,620,684,683,-1,620,621,685,684,-1,621,622,686,685,-1,622,623,687,686,-1,623,624,688,687,-1,624,625,689,688,-1,625,626,690,689,-1,626,627,691,690,-1,627,628,692,691,-1,628,629,693,692,-1,629,630,694,693,-1,630,631,695,694,-1,631,632,696,695,-1,632,633,697,696,-1,633,634,698,697,-1,634,635,699,698,-1,635,636,700,699,-1,636,637,701,700,-1,637,638,702,701,-1,638,639,703,702,-1,639,576,640,703,-1,640,641,705,704,-1,641,642,706,705,-1,642,643,707,706,-1,643,644,708,707,-1,644,645,709,708,-1,645,646,710,709,-1,646,647,711,710,-1,647,648,712,711,-1,648,649,713,712,-1,649,650,714,713,-1,650,651,715,714,-1,651,652,716,715,-1,652,653,717,716,-1,653,654,718,717,-1,654,655,719,718,-1,655,656,720,719,-1,656,657,721,720,-1,657,658,722,721,-1,658,659,723,722,-1,659,660,724,723,-1,660,661,725,724,-1,661,662,726,725,-1,662,663,727,726,-1,663,664,728,727,-1,664,665,729,728,-1,665,666,730,729,-1,666,667,731,730,-1,667,668,732,731,-1,668,669,733,732,-1,669,670,734,733,-1,670,671,735,734,-1,671,672,736,735,-1,672,673,737,736,-1,673,674,738,737,-1,674,675,739,738,-1,675,676,740,739,-1,676,677,741,740,-1,677,678,742,741,-1,678,679,743,742,-1,679,680,744,743,-1,680,681,745,744,-1,681,682,746,745,-1,682,683,747,746,-1,683,684,748,747,-1,684,685,749,748,-1,685,686,750,749,-1,686,687,751,750,-1,687,688,752,751,-1,688,689,753,752,-1,689,690,754,753,-1,690,691,755,754,-1,691,692,756,755,-1,692,693,757,756,-1,693,694,758,757,-1,694,695,759,758,-1,695,696,760,759,-1,696,697,761,760,-1,697,698,762,761,-1,698,699,763,762,-1,699,700,764,763,-1,700,701,765,764,-1,701,702,766,765,-1,702,703,767,766,-1,703,640,704,767,-1,704,705,769,768,-1,705,706,770,769,-1,706,707,771,770,-1,707,708,772,771,-1,708,709,773,772,-1,709,710,774,773,-1,710,711,775,774,-1,711,712,776,775,-1,712,713,777,776,-1,713,714,778,777,-1,714,715,779,778,-1,715,716,780,779,-1,716,717,781,780,-1,717,718,782,781,-1,718,719,783,782,-1,719,720,784,783,-1,720,721,785,784,-1,721,722,786,785,-1,722,723,787,786,-1,723,724,788,787,-1,724,725,789,788,-1,725,726,790,789,-1,726,727,791,790,-1,727,728,792,791,-1,728,729,793,792,-1,729,730,794,793,-1,730,731,795,794,-1,731,732,796,795,-1,732,733,797,796,-1,733,734,798,797,-1,734,735,799,798,-1,735,736,800,799,-1,736,737,801,800,-1,737,738,802,801,-1,738,739,803,802,-1,739,740,804,803,-1,740,741,805,804,-1,741,742,806,805,-1,742,743,807,806,-1,743,744,808,807,-1,744,745,809,808,-1,745,746,810,809,-1,746,747,811,810,-1,747,748,812,811,-1,748,749,813,812,-1,749,750,814,813,-1,750,751,815,814,-1,751,752,816,815,-1,752,753,817,816,-1,753,754,818,817,-1,754,755,819,818,-1,755,756,820,819,-1,756,757,821,820,-1,757,758,822,821,-1,758,759,823,822,-1,759,760,824,823,-1,760,761,825,824,-1,761,762,826,825,-1,762,763,827,826,-1,763,764,828,827,-1,764,765,829,828,-1,765,766,830,829,-1,766,767,831,830,-1,767,704,768,831,-1,768,769,833,832,-1,769,770,834,833,-1,770,771,835,834,-1,771,772,836,835,-1,772,773,837,836,-1,773,774,838,837,-1,774,775,839,838,-1,775,776,840,839,-1,776,777,841,840,-1,777,778,842,841,-1,778,779,843,842,-1,779,780,844,843,-1,780,781,845,844,-1,781,782,846,845,-1,782,783,847,846,-1,783,784,848,847,-1,784,785,849,848,-1,785,786,850,849,-1,786,787,851,850,-1,787,788,852,851,-1,788,789,853,852,-1,789,790,854,853,-1,790,791,855,854,-1,791,792,856,855,-1,792,793,857,856,-1,793,794,858,857,-1,794,795,859,858,-1,795,796,860,859,-1,796,797,861,860,-1,797,798,862,861,-1,798,799,863,862,-1,799,800,864,863,-1,800,801,865,864,-1,801,802,866,865,-1,802,803,867,866,-1,803,804,868,867,-1,804,805,869,868,-1,805,806,870,869,-1,806,807,871,870,-1,807,808,872,871,-1,808,809,873,872,-1,809,810,874,873,-1,810,811,875,874,-1,811,812,876,875,-1,812,813,877,876,-1,813,814,878,877,-1,814,815,879,878,-1,815,816,880,879,-1,816,817,881,880,-1,817,818,882,881,-1,818,819,883,882,-1,819,820,884,883,-1,820,821,885,884,-1,821,822,886,885,-1,822,823,887,886,-1,823,824,888,887,-1,824,825,889,888,-1,825,826,890,889,-1,826,827,891,890,-1,827,828,892,891,-1,828,829,893,892,-1,829,830,894,893,-1,830,831,895,894,-1,831,768,832,895,-1,832,833,897,896,-1,833,834,898,897,-1,834,835,899,898,-1,835,836,900,899,-1,836,837,901,900,-1,837,838,902,901,-1,838,839,903,902,-1,839,840,904,903,-1,840,841,905,904,-1,841,842,906,905,-1,842,843,907,906,-1,843,844,908,907,-1,844,845,909,908,-1,845,846,910,909,-1,846,847,911,910,-1,847,848,912,911,-1,848,849,913,912,-1,849,850,914,913,-1,850,851,915,914,-1,851,852,916,915,-1,852,853,917,916,-1,853,854,918,917,-1,854,855,919,918,-1,855,856,920,919,-1,856,857,921,920,-1,857,858,922,921,-1,858,859,923,922,-1,859,860,924,923,-1,860,861,925,924,-1,861,862,926,925,-1,862,863,927,926,-1,863,864,928,927,-1,864,865,929,928,-1,865,866,930,929,-1,866,867,931,930,-1,867,868,932,931,-1,868,869,933,932,-1,869,870,934,933,-1,870,871,935,934,-1,871,872,936,935,-1,872,873,937,936,-1,873,874,938,937,-1,874,875,939,938,-1,875,876,940,939,-1,876,877,941,940,-1,877,878,942,941,-1,878,879,943,942,-1,879,880,944,943,-1,880,881,945,944,-1,881,882,946,945,-1,882,883,947,946,-1,883,884,948,947,-1,884,885,949,948,-1,885,886,950,949,-1,886,887,951,950,-1,887,888,952,951,-1,888,889,953,952,-1,889,890,954,953,-1,890,891,955,954,-1,891,892,956,955,-1,892,893,957,956,-1,893,894,958,957,-1,894,895,959,958,-1,895,832,896,959,-1,896,897,961,960,-1,897,898,962,961,-1,898,899,963,962,-1,899,900,964,963,-1,900,901,965,964,-1,901,902,966,965,-1,902,903,967,966,-1,903,904,968,967,-1,904,905,969,968,-1,905,906,970,969,-1,906,907,971,970,-1,907,908,972,971,-1,908,909,973,972,-1,909,910,974,973,-1,910,911,975,974,-1,911,912,976,975,-1,912,913,977,976,-1,913,914,978,977,-1,914,915,979,978,-1,915,916,980,979,-1,916,917,981,980,-1,917,918,982,981,-1,918,919,983,982,-1,919,920,984,983,-1,920,921,985,984,-1,921,922,986,985,-1,922,923,987,986,-1,923,924,988,987,-1,924,925,989,988,-1,925,926,990,989,-1,926,927,991,990,-1,927,928,992,991,-1,928,929,993,992,-1,929,930,994,993,-1,930,931,995,994,-1,931,932,996,995,-1,932,933,997,996,-1,933,934,998,997,-1,934,935,999,998,-1,935,936,1000,999,-1,936,937,1001,1000,-1,937,938,1002,1001,-1,938,939,1003,1002,-1,939,940,1004,1003,-1,940,941,1005,1004,-1,941,942,1006,1005,-1,942,943,1007,1006,-1,943,944,1008,1007,-1,944,945,1009,1008,-1,945,946,1010,1009,-1,946,947,1011,1010,-1,947,948,1012,1011,-1,948,949,1013,1012,-1,949,950,1014,1013,-1,950,951,1015,1014,-1,951,952,1016,1015,-1,952,953,1017,1016,-1,953,954,1018,1017,-1,954,955,1019,1018,-1,955,956,1020,1019,-1,956,957,1021,1020,-1,957,958,1022,1021,-1,958,959,1023,1022,-1,959,896,960,1023,-1,960,961,1025,1024,-1,961,962,1026,1025,-1,962,963,1027,1026,-1,963,964,1028,1027,-1,964,965,1029,1028,-1,965,966,1030,1029,-1,966,967,1031,1030,-1,967,968,1032,1031,-1,968,969,1033,1032,-1,969,970,1034,1033,-1,970,971,1035,1034,-1,971,972,1036,1035,-1,972,973,1037,1036,-1,973,974,1038,1037,-1,974,975,1039,1038,-1,975,976,1040,1039,-1,976,977,1041,1040,-1,977,978,1042,1041,-1,978,979,1043,1042,-1,979,980,1044,1043,-1,980,981,1045,1044,-1,981,982,1046,1045,-1,982,983,1047,1046,-1,983,984,1048,1047,-1,984,985,1049,1048,-1,985,986,1050,1049,-1,986,987,1051,1050,-1,987,988,1052,1051,-1,988,989,1053,1052,-1,989,990,1054,1053,-1,990,991,1055,1054,-1,991,992,1056,1055,-1,992,993,1057,1056,-1,993,994,1058,1057,-1,994,995,1059,1058,-1,995,996,1060,1059,-1,996,997,1061,1060,-1,997,998,1062,1061,-1,998,999,1063,1062,-1,999,1000,1064,1063,-1,1000,1001,1065,1064,-1,1001,1002,1066,1065,-1,1002,1003,1067,1066,-1,1003,1004,1068,1067,-1,1004,1005,1069,1068,-1,1005,1006,1070,1069,-1,1006,1007,1071,1070,-1,1007,1008,1072,1071,-1,1008,1009,1073,1072,-1,1009,1010,1074,1073,-1,1010,1011,1075,1074,-1,1011,1012,1076,1075,-1,1012,1013,1077,1076,-1,1013,1014,1078,1077,-1,1014,1015,1079,1078,-1,1015,1016,1080,1079,-1,1016,1017,1081,1080,-1,1017,1018,1082,1081,-1,1018,1019,1083,1082,-1,1019,1020,1084,1083,-1,1020,1021,1085,1084,-1,1021,1022,1086,1085,-1,1022,1023,1087,1086,-1,1023,960,1024,1087,-1,1024,1025,1089,1088,-1,1025,1026,1090,1089,-1,1026,1027,1091,1090,-1,1027,1028,1092,1091,-1,1028,1029,1093,1092,-1,1029,1030,1094,1093,-1,1030,1031,1095,1094,-1,1031,1032,1096,1095,-1,1032,1033,1097,1096,-1,1033,1034,1098,1097,-1,1034,1035,1099,1098,-1,1035,1036,1100,1099,-1,1036,1037,1101,1100,-1,1037,1038,1102,1101,-1,1038,1039,1103,1102,-1,1039,1040,1104,1103,-1,1040,1041,1105,1104,-1,1041,1042,1106,1105,-1,1042,1043,1107,1106,-1,1043,1044,1108,1107,-1,1044,1045,1109,1108,-1,1045,1046,1110,1109,-1,1046,1047,1111,1110,-1,1047,1048,1112,1111,-1,1048,1049,1113,1112,-1,1049,1050,1114,1113,-1,1050,1051,1115,1114,-1,1051,1052,1116,1115,-1,1052,1053,1117,1116,-1,1053,1054,1118,1117,-1,1054,1055,1119,1118,-1,1055,1056,1120,1119,-1,1056,1057,1121,1120,-1,1057,1058,1122,1121,-1,1058,1059,1123,1122,-1,1059,1060,1124,1123,-1,1060,1061,1125,1124,-1,1061,1062,1126,1125,-1,1062,1063,1127,1126,-1,1063,1064,1128,1127,-1,1064,1065,1129,1128,-1,1065,1066,1130,1129,-1,1066,1067,1131,1130,-1,1067,1068,1132,1131,-1,1068,1069,1133,1132,-1,1069,1070,1134,1133,-1,1070,1071,1135,1134,-1,1071,1072,1136,1135,-1,1072,1073,1137,1136,-1,1073,1074,1138,1137,-1,1074,1075,1139,1138,-1,1075,1076,1140,1139,-1,1076,1077,1141,1140,-1,1077,1078,1142,1141,-1,1078,1079,1143,1142,-1,1079,1080,1144,1143,-1,1080,1081,1145,1144,-1,1081,1082,1146,1145,-1,1082,1083,1147,1146,-1,1083,1084,1148,1147,-1,1084,1085,1149,1148,-1,1085,1086,1150,1149,-1,1086,1087,1151,1150,-1,1087,1024,1088,1151,-1,1088,1089,1153,1152,-1,1089,1090,1154,1153,-1,1090,1091,1155,1154,-1,1091,1092,1156,1155,-1,1092,1093,1157,1156,-1,1093,1094,1158,1157,-1,1094,1095,1159,1158,-1,1095,1096,1160,1159,-1,1096,1097,1161,1160,-1,1097,1098,1162,1161,-1,1098,1099,1163,1162,-1,1099,1100,1164,1163,-1,1100,1101,1165,1164,-1,1101,1102,1166,1165,-1,1102,1103,1167,1166,-1,1103,1104,1168,1167,-1,1104,1105,1169,1168,-1,1105,1106,1170,1169,-1,1106,1107,1171,1170,-1,1107,1108,1172,1171,-1,1108,1109,1173,1172,-1,1109,1110,1174,1173,-1,1110,1111,1175,1174,-1,1111,1112,1176,1175,-1,1112,1113,1177,1176,-1,1113,1114,1178,1177,-1,1114,1115,1179,1178,-1,1115,1116,1180,1179,-1,1116,1117,1181,1180,-1,1117,1118,1182,1181,-1,1118,1119,1183,1182,-1,1119,1120,1184,1183,-1,1120,1121,1185,1184,-1,1121,1122,1186,1185,-1,1122,1123,1187,1186,-1,1123,1124,1188,1187,-1,1124,1125,1189,1188,-1,1125,1126,1190,1189,-1,1126,1127,1191,1190,-1,1127,1128,1192,1191,-1,1128,1129,1193,1192,-1,1129,1130,1194,1193,-1,1130,1131,1195,1194,-1,1131,1132,1196,1195,-1,1132,1133,1197,1196,-1,1133,1134,1198,1197,-1,1134,1135,1199,1198,-1,1135,1136,1200,1199,-1,1136,1137,1201,1200,-1,1137,1138,1202,1201,-1,1138,1139,1203,1202,-1,1139,1140,1204,1203,-1,1140,1141,1205,1204,-1,1141,1142,1206,1205,-1,1142,1143,1207,1206,-1,1143,1144,1208,1207,-1,1144,1145,1209,1208,-1,1145,1146,1210,1209,-1,1146,1147,1211,1210,-1,1147,1148,1212,1211,-1,1148,1149,1213,1212,-1,1149,1150,1214,1213,-1,1150,1151,1215,1214,-1,1151,1088,1152,1215,-1,1152,1153,1217,1216,-1,1153,1154,1218,1217,-1,1154,1155,1219,1218,-1,1155,1156,1220,1219,-1,1156,1157,1221,1220,-1,1157,1158,1222,1221,-1,1158,1159,1223,1222,-1,1159,1160,1224,1223,-1,1160,1161,1225,1224,-1,1161,1162,1226,1225,-1,1162,1163,1227,1226,-1,1163,1164,1228,1227,-1,1164,1165,1229,1228,-1,1165,1166,1230,1229,-1,1166,1167,1231,1230,-1,1167,1168,1232,1231,-1,1168,1169,1233,1232,-1,1169,1170,1234,1233,-1,1170,1171,1235,1234,-1,1171,1172,1236,1235,-1,1172,1173,1237,1236,-1,1173,1174,1238,1237,-1,1174,1175,1239,1238,-1,1175,1176,1240,1239,-1,1176,1177,1241,1240,-1,1177,1178,1242,1241,-1,1178,1179,1243,1242,-1,1179,1180,1244,1243,-1,1180,1181,1245,1244,-1,1181,1182,1246,1245,-1,1182,1183,1247,1246,-1,1183,1184,1248,1247,-1,1184,1185,1249,1248,-1,1185,1186,1250,1249,-1,1186,1187,1251,1250,-1,1187,1188,1252,1251,-1,1188,1189,1253,1252,-1,1189,1190,1254,1253,-1,1190,1191,1255,1254,-1,1191,1192,1256,1255,-1,1192,1193,1257,1256,-1,1193,1194,1258,1257,-1,1194,1195,1259,1258,-1,1195,1196,1260,1259,-1,1196,1197,1261,1260,-1,1197,1198,1262,1261,-1,1198,1199,1263,1262,-1,1199,1200,1264,1263,-1,1200,1201,1265,1264,-1,1201,1202,1266,1265,-1,1202,1203,1267,1266,-1,1203,1204,1268,1267,-1,1204,1205,1269,1268,-1,1205,1206,1270,1269,-1,1206,1207,1271,1270,-1,1207,1208,1272,1271,-1,1208,1209,1273,1272,-1,1209,1210,1274,1273,-1,1210,1211,1275,1274,-1,1211,1212,1276,1275,-1,1212,1213,1277,1276,-1,1213,1214,1278,1277,-1,1214,1215,1279,1278,-1,1215,1152,1216,1279,-1,1216,1217,1281,1280,-1,1217,1218,1282,1281,-1,1218,1219,1283,1282,-1,1219,1220,1284,1283,-1,1220,1221,1285,1284,-1,1221,1222,1286,1285,-1,1222,1223,1287,1286,-1,1223,1224,1288,1287,-1,1224,1225,1289,1288,-1,1225,1226,1290,1289,-1,1226,1227,1291,1290,-1,1227,1228,1292,1291,-1,1228,1229,1293,1292,-1,1229,1230,1294,1293,-1,1230,1231,1295,1294,-1,1231,1232,1296,1295,-1,1232,1233,1297,1296,-1,1233,1234,1298,1297,-1,1234,1235,1299,1298,-1,1235,1236,1300,1299,-1,1236,1237,1301,1300,-1,1237,1238,1302,1301,-1,1238,1239,1303,1302,-1,1239,1240,1304,1303,-1,1240,1241,1305,1304,-1,1241,1242,1306,1305,-1,1242,1243,1307,1306,-1,1243,1244,1308,1307,-1,1244,1245,1309,1308,-1,1245,1246,1310,1309,-1,1246,1247,1311,1310,-1,1247,1248,1312,1311,-1,1248,1249,1313,1312,-1,1249,1250,1314,1313,-1,1250,1251,1315,1314,-1,1251,1252,1316,1315,-1,1252,1253,1317,1316,-1,1253,1254,1318,1317,-1,1254,1255,1319,1318,-1,1255,1256,1320,1319,-1,1256,1257,1321,1320,-1,1257,1258,1322,1321,-1,1258,1259,1323,1322,-1,1259,1260,1324,1323,-1,1260,1261,1325,1324,-1,1261,1262,1326,1325,-1,1262,1263,1327,1326,-1,1263,1264,1328,1327,-1,1264,1265,1329,1328,-1,1265,1266,1330,1329,-1,1266,1267,1331,1330,-1,1267,1268,1332,1331,-1,1268,1269,1333,1332,-1,1269,1270,1334,1333,-1,1270,1271,1335,1334,-1,1271,1272,1336,1335,-1,1272,1273,1337,1336,-1,1273,1274,1338,1337,-1,1274,1275,1339,1338,-1,1275,1276,1340,1339,-1,1276,1277,1341,1340,-1,1277,1278,1342,1341,-1,1278,1279,1343,1342,-1,1279,1216,1280,1343,-1,1280,1281,1345,1344,-1,1281,1282,1346,1345,-1,1282,1283,1347,1346,-1,1283,1284,1348,1347,-1,1284,1285,1349,1348,-1,1285,1286,1350,1349,-1,1286,1287,1351,1350,-1,1287,1288,1352,1351,-1,1288,1289,1353,1352,-1,1289,1290,1354,1353,-1,1290,1291,1355,1354,-1,1291,1292,1356,1355,-1,1292,1293,1357,1356,-1,1293,1294,1358,1357,-1,1294,1295,1359,1358,-1,1295,1296,1360,1359,-1,1296,1297,1361,1360,-1,1297,1298,1362,1361,-1,1298,1299,1363,1362,-1,1299,1300,1364,1363,-1,1300,1301,1365,1364,-1,1301,1302,1366,1365,-1,1302,1303,1367,1366,-1,1303,1304,1368,1367,-1,1304,1305,1369,1368,-1,1305,1306,1370,1369,-1,1306,1307,1371,1370,-1,1307,1308,1372,1371,-1,1308,1309,1373,1372,-1,1309,1310,1374,1373,-1,1310,1311,1375,1374,-1,1311,1312,1376,1375,-1,1312,1313,1377,1376,-1,1313,1314,1378,1377,-1,1314,1315,1379,1378,-1,1315,1316,1380,1379,-1,1316,1317,1381,1380,-1,1317,1318,1382,1381,-1,1318,1319,1383,1382,-1,1319,1320,1384,1383,-1,1320,1321,1385,1384,-1,1321,1322,1386,1385,-1,1322,1323,1387,1386,-1,1323,1324,1388,1387,-1,1324,1325,1389,1388,-1,1325,1326,1390,1389,-1,1326,1327,1391,1390,-1,1327,1328,1392,1391,-1,1328,1329,1393,1392,-1,1329,1330,1394,1393,-1,1330,1331,1395,1394,-1,1331,1332,1396,1395,-1,1332,1333,1397,1396,-1,1333,1334,1398,1397,-1,1334,1335,1399,1398,-1,1335,1336,1400,1399,-1,1336,1337,1401,1400,-1,1337,1338,1402,1401,-1,1338,1339,1403,1402,-1,1339,1340,1404,1403,-1,1340,1341,1405,1404,-1,1341,1342,1406,1405,-1,1342,1343,1407,1406,-1,1343,1280,1344,1407,-1,1344,1345,1409,1408,-1,1345,1346,1410,1409,-1,1346,1347,1411,1410,-1,1347,1348,1412,1411,-1,1348,1349,1413,1412,-1,1349,1350,1414,1413,-1,1350,1351,1415,1414,-1,1351,1352,1416,1415,-1,1352,1353,1417,1416,-1,1353,1354,1418,1417,-1,1354,1355,1419,1418,-1,1355,1356,1420,1419,-1,1356,1357,1421,1420,-1,1357,1358,1422,1421,-1,1358,1359,1423,1422,-1,1359,1360,1424,1423,-1,1360,1361,1425,1424,-1,1361,1362,1426,1425,-1,1362,1363,1427,1426,-1,1363,1364,1428,1427,-1,1364,1365,1429,1428,-1,1365,1366,1430,1429,-1,1366,1367,1431,1430,-1,1367,1368,1432,1431,-1,1368,1369,1433,1432,-1,1369,1370,1434,1433,-1,1370,1371,1435,1434,-1,1371,1372,1436,1435,-1,1372,1373,1437,1436,-1,1373,1374,1438,1437,-1,1374,1375,1439,1438,-1,1375,1376,1440,1439,-1,1376,1377,1441,1440,-1,1377,1378,1442,1441,-1,1378,1379,1443,1442,-1,1379,1380,1444,1443,-1,1380,1381,1445,1444,-1,1381,1382,1446,1445,-1,1382,1383,1447,1446,-1,1383,1384,1448,1447,-1,1384,1385,1449,1448,-1,1385,1386,1450,1449,-1,1386,1387,1451,1450,-1,1387,1388,1452,1451,-1,1388,1389,1453,1452,-1,1389,1390,1454,1453,-1,1390,1391,1455,1454,-1,1391,1392,1456,1455,-1,1392,1393,1457,1456,-1,1393,1394,1458,1457,-1,1394,1395,1459,1458,-1,1395,1396,1460,1459,-1,1396,1397,1461,1460,-1,1397,1398,1462,1461,-1,1398,1399,1463,1462,-1,1399,1400,1464,1463,-1,1400,1401,1465,1464,-1,1401,1402,1466,1465,-1,1402,1403,1467,1466,-1,1403,1404,1468,1467,-1,1404,1405,1469,1468,-1,1405,1406,1470,1469,-1,1406,1407,1471,1470,-1,1407,1344,1408,1471,-1,1408,1409,1473,1472,-1,1409,1410,1474,1473,-1,1410,1411,1475,1474,-1,1411,1412,1476,1475,-1,1412,1413,1477,1476,-1,1413,1414,1478,1477,-1,1414,1415,1479,1478,-1,1415,1416,1480,1479,-1,1416,1417,1481,1480,-1,1417,1418,1482,1481,-1,1418,1419,1483,1482,-1,1419,1420,1484,1483,-1,1420,1421,1485,1484,-1,1421,1422,1486,1485,-1,1422,1423,1487,1486,-1,1423,1424,1488,1487,-1,1424,1425,1489,1488,-1,1425,1426,1490,1489,-1,1426,1427,1491,1490,-1,1427,1428,1492,1491,-1,1428,1429,1493,1492,-1,1429,1430,1494,1493,-1,1430,1431,1495,1494,-1,1431,1432,1496,1495,-1,1432,1433,1497,1496,-1,1433,1434,1498,1497,-1,1434,1435,1499,1498,-1,1435,1436,1500,1499,-1,1436,1437,1501,1500,-1,1437,1438,1502,1501,-1,1438,1439,1503,1502,-1,1439,1440,1504,1503,-1,1440,1441,1505,1504,-1,1441,1442,1506,1505,-1,1442,1443,1507,1506,-1,1443,1444,1508,1507,-1,1444,1445,1509,1508,-1,1445,1446,1510,1509,-1,1446,1447,1511,1510,-1,1447,1448,1512,1511,-1,1448,1449,1513,1512,-1,1449,1450,1514,1513,-1,1450,1451,1515,1514,-1,1451,1452,1516,1515,-1,1452,1453,1517,1516,-1,1453,1454,1518,1517,-1,1454,1455,1519,1518,-1,1455,1456,1520,1519,-1,1456,1457,1521,1520,-1,1457,1458,1522,1521,-1,1458,1459,1523,1522,-1,1459,1460,1524,1523,-1,1460,1461,1525,1524,-1,1461,1462,1526,1525,-1,1462,1463,1527,1526,-1,1463,1464,1528,1527,-1,1464,1465,1529,1528,-1,1465,1466,1530,1529,-1,1466,1467,1531,1530,-1,1467,1468,1532,1531,-1,1468,1469,1533,1532,-1,1469,1470,1534,1533,-1,1470,1471,1535,1534,-1,1471,1408,1472,1535,-1,1472,1473,1537,1536,-1,1473,1474,1538,1537,-1,1474,1475,1539,1538,-1,1475,1476,1540,1539,-1,1476,1477,1541,1540,-1,1477,1478,1542,1541,-1,1478,1479,1543,1542,-1,1479,1480,1544,1543,-1,1480,1481,1545,1544,-1,1481,1482,1546,1545,-1,1482,1483,1547,1546,-1,1483,1484,1548,1547,-1,1484,1485,1549,1548,-1,1485,1486,1550,1549,-1,1486,1487,1551,1550,-1,1487,1488,1552,1551,-1,1488,1489,1553,1552,-1,1489,1490,1554,1553,-1,1490,1491,1555,1554,-1,1491,1492,1556,1555,-1,1492,1493,1557,1556,-1,1493,1494,1558,1557,-1,1494,1495,1559,1558,-1,1495,1496,1560,1559,-1,1496,1497,1561,1560,-1,1497,1498,1562,1561,-1,1498,1499,1563,1562,-1,1499,1500,1564,1563,-1,1500,1501,1565,1564,-1,1501,1502,1566,1565,-1,1502,1503,1567,1566,-1,1503,1504,1568,1567,-1,1504,1505,1569,1568,-1,1505,1506,1570,1569,-1,1506,1507,1571,1570,-1,1507,1508,1572,1571,-1,1508,1509,1573,1572,-1,1509,1510,1574,1573,-1,1510,1511,1575,1574,-1,1511,1512,1576,1575,-1,1512,1513,1577,1576,-1,1513,1514,1578,1577,-1,1514,1515,1579,1578,-1,1515,1516,1580,1579,-1,1516,1517,1581,1580,-1,1517,1518,1582,1581,-1,1518,1519,1583,1582,-1,1519,1520,1584,1583,-1,1520,1521,1585,1584,-1,1521,1522,1586,1585,-1,1522,1523,1587,1586,-1,1523,1524,1588,1587,-1,1524,1525,1589,1588,-1,1525,1526,1590,1589,-1,1526,1527,1591,1590,-1,1527,1528,1592,1591,-1,1528,1529,1593,1592,-1,1529,1530,1594,1593,-1,1530,1531,1595,1594,-1,1531,1532,1596,1595,-1,1532,1533,1597,1596,-1,1533,1534,1598,1597,-1,1534,1535,1599,1598,-1,1535,1472,1536,1599,-1,1536,1537,1601,1600,-1,1537,1538,1602,1601,-1,1538,1539,1603,1602,-1,1539,1540,1604,1603,-1,1540,1541,1605,1604,-1,1541,1542,1606,1605,-1,1542,1543,1607,1606,-1,1543,1544,1608,1607,-1,1544,1545,1609,1608,-1,1545,1546,1610,1609,-1,1546,1547,1611,1610,-1,1547,1548,1612,1611,-1,1548,1549,1613,1612,-1,1549,1550,1614,1613,-1,1550,1551,1615,1614,-1,1551,1552,1616,1615,-1,1552,1553,1617,1616,-1,1553,1554,1618,1617,-1,1554,1555,1619,1618,-1,1555,1556,1620,1619,-1,1556,1557,1621,1620,-1,1557,1558,1622,1621,-1,1558,1559,1623,1622,-1,1559,1560,1624,1623,-1,1560,1561,1625,1624,-1,1561,1562,1626,1625,-1,1562,1563,1627,1626,-1,1563,1564,1628,1627,-1,1564,1565,1629,1628,-1,1565,1566,1630,1629,-1,1566,1567,1631,1630,-1,1567,1568,1632,1631,-1,1568,1569,1633,1632,-1,1569,1570,1634,1633,-1,1570,1571,1635,1634,-1,1571,1572,1636,1635,-1,1572,1573,1637,1636,-1,1573,1574,1638,1637,-1,1574,1575,1639,1638,-1,1575,1576,1640,1639,-1,1576,1577,1641,1640,-1,1577,1578,1642,1641,-1,1578,1579,1643,1642,-1,1579,1580,1644,1643,-1,1580,1581,1645,1644,-1,1581,1582,1646,1645,-1,1582,1583,1647,1646,-1,1583,1584,1648,1647,-1,1584,1585,1649,1648,-1,1585,1586,1650,1649,-1,1586,1587,1651,1650,-1,1587,1588,1652,1651,-1,1588,1589,1653,1652,-1,1589,1590,1654,1653,-1,1590,1591,1655,1654,-1,1591,1592,1656,1655,-1,1592,1593,1657,1656,-1,1593,1594,1658,1657,-1,1594,1595,1659,1658,-1,1595,1596,1660,1659,-1,1596,1597,1661,1660,-1,1597,1598,1662,1661,-1,1598,1599,1663,1662,-1,1599,1536,1600,1663,-1,1600,1601,1665,1664,-1,1601,1602,1666,1665,-1,1602,1603,1667,1666,-1,1603,1604,1668,1667,-1,1604,1605,1669,1668,-1,1605,1606,1670,1669,-1,1606,1607,1671,1670,-1,1607,1608,1672,1671,-1,1608,1609,1673,1672,-1,1609,1610,1674,1673,-1,1610,1611,1675,1674,-1,1611,1612,1676,1675,-1,1612,1613,1677,1676,-1,1613,1614,1678,1677,-1,1614,1615,1679,1678,-1,1615,1616,1680,1679,-1,1616,1617,1681,1680,-1,1617,1618,1682,1681,-1,1618,1619,1683,1682,-1,1619,1620,1684,1683,-1,1620,1621,1685,1684,-1,1621,1622,1686,1685,-1,1622,1623,1687,1686,-1,1623,1624,1688,1687,-1,1624,1625,1689,1688,-1,1625,1626,1690,1689,-1,1626,1627,1691,1690,-1,1627,1628,1692,1691,-1,1628,1629,1693,1692,-1,1629,1630,1694,1693,-1,1630,1631,1695,1694,-1,1631,1632,1696,1695,-1,1632,1633,1697,1696,-1,1633,1634,1698,1697,-1,1634,1635,1699,1698,-1,1635,1636,1700,1699,-1,1636,1637,1701,1700,-1,1637,1638,1702,1701,-1,1638,1639,1703,1702,-1,1639,1640,1704,1703,-1,1640,1641,1705,1704,-1,1641,1642,1706,1705,-1,1642,1643,1707,1706,-1,1643,1644,1708,1707,-1,1644,1645,1709,1708,-1,1645,1646,1710,1709,-1,1646,1647,1711,1710,-1,1647,1648,1712,1711,-1,1648,1649,1713,1712,-1,1649,1650,1714,1713,-1,1650,1651,1715,1714,-1,1651,1652,1716,1715,-1,1652,1653,1717,1716,-1,1653,1654,1718,1717,-1,1654,1655,1719,1718,-1,1655,1656,1720,1719,-1,1656,1657,1721,1720,-1,1657,1658,1722,1721,-1,1658,1659,1723,1722,-1,1659,1660,1724,1723,-1,1660,1661,1725,1724,-1,1661,1662,1726,1725,-1,1662,1663,1727,1726,-1,1663,1600,1664,1727,-1,1664,1665,1729,1728,-1,1665,1666,1730,1729,-1,1666,1667,1731,1730,-1,1667,1668,1732,1731,-1,1668,1669,1733,1732,-1,1669,1670,1734,1733,-1,1670,1671,1735,1734,-1,1671,1672,1736,1735,-1,1672,1673,1737,1736,-1,1673,1674,1738,1737,-1,1674,1675,1739,1738,-1,1675,1676,1740,1739,-1,1676,1677,1741,1740,-1,1677,1678,1742,1741,-1,1678,1679,1743,1742,-1,1679,1680,1744,1743,-1,1680,1681,1745,1744,-1,1681,1682,1746,1745,-1,1682,1683,1747,1746,-1,1683,1684,1748,1747,-1,1684,1685,1749,1748,-1,1685,1686,1750,1749,-1,1686,1687,1751,1750,-1,1687,1688,1752,1751,-1,1688,1689,1753,1752,-1,1689,1690,1754,1753,-1,1690,1691,1755,1754,-1,1691,1692,1756,1755,-1,1692,1693,1757,1756,-1,1693,1694,1758,1757,-1,1694,1695,1759,1758,-1,1695,1696,1760,1759,-1,1696,1697,1761,1760,-1,1697,1698,1762,1761,-1,1698,1699,1763,1762,-1,1699,1700,1764,1763,-1,1700,1701,1765,1764,-1,1701,1702,1766,1765,-1,1702,1703,1767,1766,-1,1703,1704,1768,1767,-1,1704,1705,1769,1768,-1,1705,1706,1770,1769,-1,1706,1707,1771,1770,-1,1707,1708,1772,1771,-1,1708,1709,1773,1772,-1,1709,1710,1774,1773,-1,1710,1711,1775,1774,-1,1711,1712,1776,1775,-1,1712,1713,1777,1776,-1,1713,1714,1778,1777,-1,1714,1715,1779,1778,-1,1715,1716,1780,1779,-1,1716,1717,1781,1780,-1,1717,1718,1782,1781,-1,1718,1719,1783,1782,-1,1719,1720,1784,1783,-1,1720,1721,1785,1784,-1,1721,1722,1786,1785,-1,1722,1723,1787,1786,-1,1723,1724,1788,1787,-1,1724,1725,1789,1788,-1,1725,1726,1790,1789,-1,1726,1727,1791,1790,-1,1727,1664,1728,1791,-1,1728,1729,1793,1792,-1,1729,1730,1794,1793,-1,1730,1731,1795,1794,-1,1731,1732,1796,1795,-1,1732,1733,1797,1796,-1,1733,1734,1798,1797,-1,1734,1735,1799,1798,-1,1735,1736,1800,1799,-1,1736,1737,1801,1800,-1,1737,1738,1802,1801,-1,1738,1739,1803,1802,-1,1739,1740,1804,1803,-1,1740,1741,1805,1804,-1,1741,1742,1806,1805,-1,1742,1743,1807,1806,-1,1743,1744,1808,1807,-1,1744,1745,1809,1808,-1,1745,1746,1810,1809,-1,1746,1747,1811,1810,-1,1747,1748,1812,1811,-1,1748,1749,1813,1812,-1,1749,1750,1814,1813,-1,1750,1751,1815,1814,-1,1751,1752,1816,1815,-1,1752,1753,1817,1816,-1,1753,1754,1818,1817,-1,1754,1755,1819,1818,-1,1755,1756,1820,1819,-1,1756,1757,1821,1820,-1,1757,1758,1822,1821,-1,1758,1759,1823,1822,-1,1759,1760,1824,1823,-1,1760,1761,1825,1824,-1,1761,1762,1826,1825,-1,1762,1763,1827,1826,-1,1763,1764,1828,1827,-1,1764,1765,1829,1828,-1,1765,1766,1830,1829,-1,1766,1767,1831,1830,-1,1767,1768,1832,1831,-1,1768,1769,1833,1832,-1,1769,1770,1834,1833,-1,1770,1771,1835,1834,-1,1771,1772,1836,1835,-1,1772,1773,1837,1836,-1,1773,1774,1838,1837,-1,1774,1775,1839,1838,-1,1775,1776,1840,1839,-1,1776,1777,1841,1840,-1,1777,1778,1842,1841,-1,1778,1779,1843,1842,-1,1779,1780,1844,1843,-1,1780,1781,1845,1844,-1,1781,1782,1846,1845,-1,1782,1783,1847,1846,-1,1783,1784,1848,1847,-1,1784,1785,1849,1848,-1,1785,1786,1850,1849,-1,1786,1787,1851,1850,-1,1787,1788,1852,1851,-1,1788,1789,1853,1852,-1,1789,1790,1854,1853,-1,1790,1791,1855,1854,-1,1791,1728,1792,1855,-1,1792,1793,1857,1856,-1,1793,1794,1858,1857,-1,1794,1795,1859,1858,-1,1795,1796,1860,1859,-1,1796,1797,1861,1860,-1,1797,1798,1862,1861,-1,1798,1799,1863,1862,-1,1799,1800,1864,1863,-1,1800,1801,1865,1864,-1,1801,1802,1866,1865,-1,1802,1803,1867,1866,-1,1803,1804,1868,1867,-1,1804,1805,1869,1868,-1,1805,1806,1870,1869,-1,1806,1807,1871,1870,-1,1807,1808,1872,1871,-1,1808,1809,1873,1872,-1,1809,1810,1874,1873,-1,1810,1811,1875,1874,-1,1811,1812,1876,1875,-1,1812,1813,1877,1876,-1,1813,1814,1878,1877,-1,1814,1815,1879,1878,-1,1815,1816,1880,1879,-1,1816,1817,1881,1880,-1,1817,1818,1882,1881,-1,1818,1819,1883,1882,-1,1819,1820,1884,1883,-1,1820,1821,1885,1884,-1,1821,1822,1886,1885,-1,1822,1823,1887,1886,-1,1823,1824,1888,1887,-1,1824,1825,1889,1888,-1,1825,1826,1890,1889,-1,1826,1827,1891,1890,-1,1827,1828,1892,1891,-1,1828,1829,1893,1892,-1,1829,1830,1894,1893,-1,1830,1831,1895,1894,-1,1831,1832,1896,1895,-1,1832,1833,1897,1896,-1,1833,1834,1898,1897,-1,1834,1835,1899,1898,-1,1835,1836,1900,1899,-1,1836,1837,1901,1900,-1,1837,1838,1902,1901,-1,1838,1839,1903,1902,-1,1839,1840,1904,1903,-1,1840,1841,1905,1904,-1,1841,1842,1906,1905,-1,1842,1843,1907,1906,-1,1843,1844,1908,1907,-1,1844,1845,1909,1908,-1,1845,1846,1910,1909,-1,1846,1847,1911,1910,-1,1847,1848,1912,1911,-1,1848,1849,1913,1912,-1,1849,1850,1914,1913,-1,1850,1851,1915,1914,-1,1851,1852,1916,1915,-1,1852,1853,1917,1916,-1,1853,1854,1918,1917,-1,1854,1855,1919,1918,-1,1855,1792,1856,1919,-1,1856,1857,1921,1920,-1,1857,1858,1922,1921,-1,1858,1859,1923,1922,-1,1859,1860,1924,1923,-1,1860,1861,1925,1924,-1,1861,1862,1926,1925,-1,1862,1863,1927,1926,-1,1863,1864,1928,1927,-1,1864,1865,1929,1928,-1,1865,1866,1930,1929,-1,1866,1867,1931,1930,-1,1867,1868,1932,1931,-1,1868,1869,1933,1932,-1,1869,1870,1934,1933,-1,1870,1871,1935,1934,-1,1871,1872,1936,1935,-1,1872,1873,1937,1936,-1,1873,1874,1938,1937,-1,1874,1875,1939,1938,-1,1875,1876,1940,1939,-1,1876,1877,1941,1940,-1,1877,1878,1942,1941,-1,1878,1879,1943,1942,-1,1879,1880,1944,1943,-1,1880,1881,1945,1944,-1,1881,1882,1946,1945,-1,1882,1883,1947,1946,-1,1883,1884,1948,1947,-1,1884,1885,1949,1948,-1,1885,1886,1950,1949,-1,1886,1887,1951,1950,-1,1887,1888,1952,1951,-1,1888,1889,1953,1952,-1,1889,1890,1954,1953,-1,1890,1891,1955,1954,-1,1891,1892,1956,1955,-1,1892,1893,1957,1956,-1,1893,1894,1958,1957,-1,1894,1895,1959,1958,-1,1895,1896,1960,1959,-1,1896,1897,1961,1960,-1,1897,1898,1962,1961,-1,1898,1899,1963,1962,-1,1899,1900,1964,1963,-1,1900,1901,1965,1964,-1,1901,1902,1966,1965,-1,1902,1903,1967,1966,-1,1903,1904,1968,1967,-1,1904,1905,1969,1968,-1,1905,1906,1970,1969,-1,1906,1907,1971,1970,-1,1907,1908,1972,1971,-1,1908,1909,1973,1972,-1,1909,1910,1974,1973,-1,1910,1911,1975,1974,-1,1911,1912,1976,1975,-1,1912,1913,1977,1976,-1,1913,1914,1978,1977,-1,1914,1915,1979,1978,-1,1915,1916,1980,1979,-1,1916,1917,1981,1980,-1,1917,1918,1982,1981,-1,1918,1919,1983,1982,-1,1919,1856,1920,1983,-1,1920,1921,1985,1984,-1,1921,1922,1986,1985,-1,1922,1923,1987,1986,-1,1923,1924,1988,1987,-1,1924,1925,1989,1988,-1,1925,1926,1990,1989,-1,1926,1927,1991,1990,-1,1927,1928,1992,1991,-1,1928,1929,1993,1992,-1,1929,1930,1994,1993,-1,1930,1931,1995,1994,-1,1931,1932,1996,1995,-1,1932,1933,1997,1996,-1,1933,1934,1998,1997,-1,1934,1935,1999,1998,-1,1935,1936,2000,1999,-1,1936,1937,2001,2000,-1,1937,1938,2002,2001,-1,1938,1939,2003,2002,-1,1939,1940,2004,2003,-1,1940,1941,2005,2004,-1,1941,1942,2006,2005,-1,1942,1943,2007,2006,-1,1943,1944,2008,2007,-1,1944,1945,2009,2008,-1,1945,1946,2010,2009,-1,1946,1947,2011,2010,-1,1947,1948,2012,2011,-1,1948,1949,2013,2012,-1,1949,1950,2014,2013,-1,1950,1951,2015,2014,-1,1951,1952,2016,2015,-1,1952,1953,2017,2016,-1,1953,1954,2018,2017,-1,1954,1955,2019,2018,-1,1955,1956,2020,2019,-1,1956,1957,2021,2020,-1,1957,1958,2022,2021,-1,1958,1959,2023,2022,-1,1959,1960,2024,2023,-1,1960,1961,2025,2024,-1,1961,1962,2026,2025,-1,1962,1963,2027,2026,-1,1963,1964,2028,2027,-1,1964,1965,2029,2028,-1,1965,1966,2030,2029,-1,1966,1967,2031,2030,-1,1967,1968,2032,2031,-1,1968,1969,2033,2032,-1,1969,1970,2034,2033,-1,1970,1971,2035,2034,-1,1971,1972,2036,2035,-1,1972,1973,2037,2036,-1,1973,1974,2038,2037,-1,1974,1975,2039,2038,-1,1975,1976,2040,2039,-1,1976,1977,2041,2040,-1,1977,1978,2042,2041,-1,1978,1979,2043,2042,-1,1979,1980,2044,2043,-1,1980,1981,2045,2044,-1,1981,1982,2046,2045,-1,1982,1983,2047,2046,-1,1983,1920,1984,2047,-1],creaseAngle=1.571,solid=False,
        coord=Coordinate(point=[(0.0,7.0,0.0),(0.0,7.679761,0.0),(0.0,8.252767,0.0),(0.0,8.629029,0.0),(0.0,8.749456,0.0),(0.0,8.595135,0.0),(0.0,8.190302,0.0),(0.0,7.598535,0.0),(0.0,6.91277,0.0),(0.0,6.240703,0.0),(0.0,5.687883,0.0),(0.0,5.341127,0.0),(0.0,5.254893,0.0),(0.0,5.442724,0.0),(0.0,5.875122,0.0),(0.0,6.484178,0.0),(0.0,7.174244,0.0),(0.0,7.836944,0.0),(0.0,8.368205,0.0),(0.0,8.684592,0.0),(0.0,8.736419,0.0),(0.0,8.515544,0.0),(0.0,8.056658,0.0),(0.0,7.431825,0.0),(0.0,6.739176,0.0),(0.0,6.087488,0.0),(0.0,5.579108,0.0),(0.0,5.293876,0.0),(0.0,5.276586,0.0),(0.0,5.529955,0.0),(0.0,6.01419,0.0),(0.0,6.653244,0.0),(0.0,7.346756,0.0),(0.0,7.98581,0.0),(0.0,8.470045,0.0),(0.0,8.723414,0.0),(0.0,8.706124,0.0),(0.0,8.420892,0.0),(0.0,7.912512,0.0),(0.0,7.260824,0.0),(0.0,6.568175,0.0),(0.0,5.943342,0.0),(0.0,5.484456,0.0),(0.0,5.263581,0.0),(0.0,5.315408,0.0),(0.0,5.631795,0.0),(0.0,6.163056,0.0),(0.0,6.825756,0.0),(0.0,7.515822,0.0),(0.0,8.124878,0.0),(0.0,8.557276,0.0),(0.0,8.745107,0.0),(0.0,8.658873,0.0),(0.0,8.312117,0.0),(0.0,7.759297,0.0),(0.0,7.08723,0.0),(0.0,6.401465,0.0),(0.0,5.809698,0.0),(0.0,5.404865,0.0),(0.0,5.250544,0.0),(0.0,5.370971,0.0),(0.0,5.747233,0.0),(0.0,6.320239,0.0),(0.0,7.0,0.0),(0.777997,7.650667,0.0),(0.831559,8.218221,0.08321),(0.85608,8.588815,0.17306),(0.845812,8.70425,0.260898),(0.80084,8.546396,0.337582),(0.726958,8.140044,0.39588),(0.63427,7.549011,0.432438),(0.534864,6.866116,0.448804),(0.440124,6.198607,0.451237),(0.358309,5.651315,0.449305),(0.292971,5.31019,0.453609),(0.242575,5.228805,0.47316),(0.201359,5.419942,0.513055),(0.161218,5.853583,0.573003),(0.114101,6.461625,0.647101),(0.054324,7.148578,0.724907),(-0.019791,7.806557,0.793602),(-0.105357,8.332227,0.840729),(-0.195576,8.643034,0.856875),(-0.281448,8.690166,0.837687),(-0.35409,8.466222,0.784743),(-0.407084,8.00637,0.70509),(-0.438252,7.38283,0.609571),(-0.450387,6.693528,0.51035),(-0.450747,6.046715,0.418232),(-0.449397,5.543974,0.340405),(-0.456786,5.264257,0.279136),(-0.48114,5.251495,0.231705),(-0.526301,5.50769,0.191558),(-0.590545,5.992609,0.150371),(-0.666684,6.630096,0.100487),(-0.743449,7.320035,0.037104),(-0.807845,7.954073,-0.040318),(-0.847938,8.432636,-0.127806),(-0.855431,8.680566,-0.217819),(-0.827425,8.658928,-0.301158),(-0.766958,8.371118,-0.369348),(-0.682224,7.862337,-0.416899),(-0.584648,7.212488,-0.442853),(-0.486298,6.523628,-0.451219),(-0.397258,5.903941,-0.450148),(-0.323561,5.450747,-0.450046),(-0.266185,5.235218,-0.461046),(-0.221298,5.291205,-0.490448),(-0.181688,5.609913,-0.540766),(-0.138966,6.14129,-0.60885),(-0.086007,6.801886,-0.686316),(-0.018983,7.487954,-0.761214),(0.061492,8.091751,-0.82055),(0.150421,8.51845,-0.853082),(0.239642,8.70104,-0.851739),(0.319906,8.610845,-0.815108),(0.383293,8.262031,-0.74764),(0.425338,7.709378,-0.658553),(0.446335,7.039678,-0.559686),(0.451449,6.358106,-0.462848),(0.44961,5.771703,-0.377268),(0.451404,5.37256,-0.307762),(0.46648,5.223362,-0.254031),(0.501091,5.34754,-0.211228),(0.556369,5.725594,-0.171617),(0.62776,6.298149,-0.126905),(0.705793,6.975288,-0.070625),(0.777997,7.650667,0.0),(1.664414,8.099133,0.0),(1.73,8.460319,0.173113),(1.726192,8.569662,0.348957),(1.651514,8.40999,0.509424),(1.516153,8.00638,0.639112),(1.339555,7.422216,0.729483),(1.145997,6.749241,0.781327),(0.95922,6.093143,0.804881),(0.797376,5.556962,0.817509),(0.669469,5.224903,0.839488),(0.574106,5.149115,0.88889),(0.500785,5.341501,0.976818),(0.433347,5.771847,1.104151),(0.354692,6.372568,1.260649),(0.251559,7.049322,1.426664),(0.118188,7.695826,1.57711),(-0.042066,8.21055,1.686786),(-0.217526,8.512656,1.735819),(-0.3912,8.5547,1.713958),(-0.545209,8.330078,1.622733),(-0.665529,7.874068,1.474964),(-0.745808,7.258284,1.291777),(-0.789284,6.579433,1.097828),(-0.808282,5.944129,0.915895),(-0.821343,5.452142,0.762095),(-0.848682,5.18074,0.642852),(-0.907035,5.172545,0.554278),(-1.005171,5.428843,0.484065),(-1.141172,5.909385,0.415352),(-1.302185,6.538701,0.331577),(-1.466761,7.217961,0.221079),(-1.609258,7.840486,0.080315),(-1.70532,8.308512,-0.085109),(-1.737147,8.548535,-0.261833),(-1.697332,8.522862,-0.432194),(-1.590376,8.235523,-0.57885),(-1.431544,7.731645,-0.689395),(-1.243335,7.090361,-0.759786),(-1.050444,6.412382,-0.79568),(-0.874377,5.804184,-0.811303),(-0.729027,5.361282,-0.826088),(-0.618194,5.153234,-0.859856),(-0.53562,5.212712,-0.927721),(-0.467437,5.530376,-1.035946),(-0.396391,6.056338,-1.179799),(-0.306751,6.707996,-1.343966),(-0.18866,7.383009,-1.505472),(-0.040861,7.975368,-1.63847),(0.12888,8.392045,-1.719787),(0.30574,8.567601,-1.733938),(0.471681,8.474465,-1.676455),(0.610191,8.127265,-1.554741),(0.710702,7.580527,-1.386276),(0.771566,6.920116,-1.194618),(0.800783,6.249746,-1.00415),(0.81427,5.674699,-0.83483),(0.832042,5.285284,-0.698166),(0.873205,5.142657,-0.595341),(0.950984,5.269218,-0.517878),(1.069001,5.645091,-0.450622),(1.219735,6.211245,-0.376238),(1.385594,6.878768,-0.280104),(1.542388,7.542827,-0.154339),(1.664414,8.099133,0.0),(2.586817,8.244781,0.0),(2.605901,8.347085,0.26076),(2.517885,8.187417,0.509002),(2.335798,7.790852,0.720498),(2.087315,7.219669,0.879877),(1.808551,6.563571,0.984885),(1.536117,5.925597,1.047307),(1.299307,5.40594,1.090248),(1.114252,5.086209,1.142386),(0.981357,5.016619,1.230583),(0.886548,5.208097,1.372645),(0.805943,5.630573,1.572051),(0.712713,6.217698,1.815963),(0.584408,6.877266,2.077108),(0.408929,7.505692,2.319149),(0.187674,8.004284,2.504338),(-0.064882,8.29474,2.601683),(-0.325035,8.331444,2.593721),(-0.566115,8.108631,2.480314),(-0.765561,7.661295,2.278577),(-0.910997,7.059687,2.018977),(-1.003738,6.398289,1.738525),(-1.05879,5.780973,1.472687),(-1.101281,5.304685,1.247903),(-1.160155,5.044227,1.076466),(-1.260639,5.040501,0.954897),(-1.417344,5.294094,0.866121),(-1.629705,5.765179,0.784825),(-1.880952,6.379773,0.68461),(-2.140924,7.041357,0.545146),(-2.372163,7.646029,0.357546),(-2.537865,8.098827,0.12666),(-2.60988,8.328642,-0.130254),(-2.574863,8.29938,-0.388098),(-2.437154,8.015637,-0.620576),(-2.217707,7.521975,-0.807179),(-1.949345,6.895921,-0.938755),(-1.669458,6.235797,-1.020185),(-1.411894,5.645273,-1.069468),(-1.199912,5.217089,-1.113356),(-1.041865,5.018491,-1.180577),(-0.930528,5.080667,-1.294286),(-0.846166,5.393854,-1.465603),(-0.762493,5.908867,-1.689858),(-0.653997,6.544822,-1.946523),(-0.502807,7.201846,-2.202941),(-0.303395,7.776755,-2.421036),(-0.063979,8.179259,-2.565461),(0.19569,8.346148,-2.611299),(0.449546,8.251211,-2.549504),(0.672112,7.909358,-2.388826),(0.845287,7.374277,-2.153757),(0.963312,6.73,-1.87901),(1.034578,6.07771,-1.60184),(1.079799,5.519846,-1.354025),(1.126917,5.144022,-1.155371),(1.203965,5.009258,-1.010247),(1.331613,5.136718,-0.907878),(1.517251,5.506387,-0.826251),(1.752097,6.060208,-0.738571),(2.012106,6.711204,-0.620652),(2.262549,7.357139,-0.457384),(2.465253,7.89657,-0.246686),(2.586817,8.244781,0.0),(3.449728,8.038817,0.0),(3.365223,7.88106,0.336741),(3.15294,7.495842,0.63738),(2.847377,6.943661,0.8783),(2.495694,6.311236,1.052023),(2.147389,5.697887,1.169405),(1.843727,5.199939,1.257032),(1.609356,4.895595,1.35041),(1.448041,4.832649,1.484603),(1.343418,5.020989,1.684593),(1.26448,5.431035,1.957799),(1.174337,5.998391,2.29063),(1.040073,6.633955,2.650062),(0.841239,7.237913,2.989943),(0.57494,7.715415,3.260645),(0.25628,7.99147,3.419821),(-0.085832,8.022726,3.441753),(-0.416437,7.804272,3.323085),(-0.70381,7.370417,3.083595),(-0.927916,6.789296,2.761802),(-1.085841,6.152174,2.406472),(-1.192801,5.559108,2.065991),(-1.278382,5.103239,1.778122),(-1.378915,4.856159,1.5625),(-1.527799,4.856671,1.41759),(-1.746197,5.104696,1.322693),(-2.036408,5.561282,1.244423),(-2.379638,6.154722,1.145973),(-2.738827,6.791818,0.996852),(-3.065963,7.372517,0.78069),(-3.312243,7.805621,0.49924),(-3.438708,8.023111,0.171619),(-3.424873,7.990832,-0.170928),(-3.273302,7.713853,-0.493371),(-3.009054,7.235672,-0.766199),(-2.674133,6.631388,-0.973305),(-2.318232,5.995901,-1.116402),(-1.987974,5.429012,-1.214825),(-1.717139,5.019752,-1.300682),(-1.520161,4.832392,-1.410503),(-1.390329,4.896357,-1.575434),(-1.303023,5.201602,-1.812394),(-1.223072,5.700189,-2.118423),(-1.114371,6.313815,-2.469699),(-0.949349,6.946113,-2.825593),(-0.715973,7.497782,-3.136881),(-0.420594,7.882182,-3.35626),(-0.086005,8.038946,-3.448711),(0.25474,7.943453,-3.399272),(0.567137,7.610701,-3.216391),(0.824391,7.092948,-2.930058),(1.014604,6.471505,-2.585168),(1.144105,5.843968,-2.23166),(1.236042,5.308891,-1.913768),(1.324507,4.950307,-1.660879),(1.445607,4.824529,-1.482108),(1.627672,4.951311,-1.365779),(1.883014,5.310743,-1.283817),(2.20335,5.846376,-1.199881),(2.560092,6.474091,-1.079169),(2.909562,7.095306,-0.897481),(3.201992,7.612461,-0.647297),(3.392243,7.944338,-0.339445),(3.449728,8.038817,0.0),(4.1596,7.494163,0.0),(3.934795,7.124545,0.393736),(3.589159,6.597233,0.725564),(3.179686,5.995039,0.980803),(2.768302,5.412538,1.166937),(2.408605,4.941208,1.311657),(2.134816,4.655072,1.455493),(1.955474,4.599066,1.640837),(1.853273,4.781986,1.900067),(1.790923,5.175105,2.245746),(1.721509,5.716684,2.665418),(1.600758,6.32167,3.122394),(1.398184,6.895052,3.562515),(1.104432,7.34678,3.925385),(0.733078,7.605912,4.15749),(0.316554,7.631752,4.224124),(-0.102679,7.420243,4.117291),(-0.483432,7.0046,3.857697),(-0.796647,6.4501,3.490337),(-1.033039,5.843825,3.074686),(-1.20556,5.28099,2.671796),(-1.345981,4.849987,2.331308),(-1.496414,4.618503,2.081385),(-1.697829,4.622892,1.923874),(-1.978425,4.862465,1.83571),(-2.344779,5.299598,1.776101),(-2.778056,5.865641,1.697635),(-3.236356,6.471696,1.558547),(-3.662784,7.022586,1.333144),(-3.997426,7.431793,1.01787),(-4.190468,7.635054,0.631611),(-4.213348,7.600446,0.210279),(-4.065312,7.333404,-0.202891),(-3.773792,6.875868,-0.568808),(-3.388489,6.299691,-0.862815),(-2.97054,5.69536,-1.081188),(-2.579298,5.157786,-1.242124),(-2.259803,4.771392,-1.380937),(-2.033856,4.59686,-1.540586),(-1.896698,4.661601,-1.759879),(-1.819965,4.955447,-2.062271),(-1.760072,5.43225,-2.44811),(-1.66989,6.017129,-2.892334),(-1.510829,6.618231,-3.348342),(-1.262374,7.141154,-3.757265),(-0.926785,7.503774,-4.060511),(-0.527916,7.649143,-4.212671),(-0.104536,7.55443,-4.191748),(0.300077,7.234511,-4.004253),(0.649583,6.739627,-3.683967),(0.924146,6.147499,-3.284609),(1.125661,5.55112,-2.868136),(1.277267,5.044149,-2.491402),(1.417216,4.706204,-2.194279),(1.588563,4.59036,-1.991995),(1.827238,4.714809,-1.873375),(2.151461,5.060006,-1.80529),(2.5552,5.57174,-1.742106),(3.00741,6.169644,-1.637748),(3.457384,6.759819,-1.457409),(3.845076,7.249578,-1.186049),(4.114035,7.562007,-0.83167),(4.223913,7.648039,-0.422666),(4.1596,7.494163,0.0),(4.650067,6.680934,0.0),(4.282899,6.184139,0.428569),(3.833008,5.618433,0.774859),(3.373816,5.072658,1.040684),(2.971147,4.632526,1.252443),(2.669471,4.36716,1.453717),(2.483327,4.318235,1.693103),(2.395821,4.493433,2.010332),(2.364445,4.865241,2.424145),(2.33266,5.375267,2.925063),(2.244371,5.943413,3.474967),(2.057751,6.480452,4.013792),(1.755086,6.902045,4.471885),(1.346339,7.141981,4.785172),(0.865688,7.162578,4.909563),(0.362047,6.960602,4.831175),(-0.113966,6.567773,4.569884),(-0.523237,6.045783,4.175332),(-0.848213,5.47661,3.716263),(-1.097203,4.949641,3.265659),(-1.301826,4.547636,2.885142),(-1.508182,4.333727,2.612247),(-1.763945,4.34151,2.453498),(-2.10459,4.569761,2.38479),(-2.542236,4.982635,2.35885),(-3.059997,5.51529,2.317857),(-3.613381,6.084075,2.208091),(-4.138601,6.599663,1.993045),(-4.565944,6.981082,1.661868),(-4.835091,7.168432,1.231165),(-4.908773,7.132289,0.739879),(-4.781507,6.878329,0.238635),(-4.481275,6.446437,-0.223651),(-4.063711,5.904441,-0.612506),(-3.600103,5.337458,-0.916699),(-3.162004,4.834533,-1.150875),(-2.80602,4.474649,-1.351308),(-2.562311,4.314324,-1.565796),(-2.429414,4.378737,-1.840209),(-2.376485,4.657773,-2.205056),(-2.352294,5.107609,-2.665473),(-2.298669,5.6576,-3.197254),(-2.165101,6.221371,-3.750065),(-1.920943,6.710383,-4.257247),(-1.562317,7.047838,-4.650001),(-1.112147,7.180739,-4.872633),(-0.613455,7.088216,-4.895255),(-0.117732,6.784797,-4.72089),(0.328629,6.318135,-4.385255),(0.696353,5.761517,-3.949211),(0.9807,5.20236,-3.485613),(1.20238,4.728477,-3.063614),(1.401678,4.41429,-2.734075),(1.627233,4.309142,-2.519449),(1.922254,4.429547,-2.41043),(2.311644,4.756594,-2.370011),(2.793302,5.238922,-2.343859),(3.335909,5.800782,-2.274384),(3.883909,6.353936,-2.115064),(4.368675,6.811512,-1.841551),(4.723295,7.101649,-1.456943),(4.89751,7.178782,-0.990053),(4.869261,7.030796,-0.487243),(4.650067,6.680934,0.0),(4.900852,5.708809,0.0),(4.429464,5.185476,0.443235),(3.93959,4.681903,0.796405),(3.508707,4.277177,1.082293),(3.191821,4.034859,1.345465),(3.010439,3.993004,1.639398),(2.949412,4.158185,2.010875),(2.962258,4.504461,2.485629),(2.983566,4.97745,3.0589),(2.945403,5.502871,3.693418),(2.793729,5.998207,4.325538),(2.500908,6.385667,4.878202),(2.071371,6.604401,5.277768),(1.539223,6.620058,5.470722),(0.95856,6.430179,5.436265),(0.389065,6.064584,5.191717),(-0.11944,5.580688,4.789375),(-0.539544,5.054487,4.30546),(-0.872734,4.568619,3.823697),(-1.148162,4.199388,3.417331),(-1.414002,4.004781,3.133749),(-1.723537,4.015361,2.985254),(-2.119502,4.229466,2.948047),(-2.62063,4.613472,2.969535),(-3.213902,5.107071,2.982065),(-3.854576,5.632744,2.919728),(-4.474224,6.107937,2.734141),(-4.994998,6.458021,2.405464),(-5.346819,6.628016,1.946083),(-5.483409,6.591226,1.396248),(-5.393319,6.353427,0.812912),(-5.103243,5.951965,0.254692),(-4.672761,5.44989,-0.233208),(-4.181643,4.926051,-0.630281),(-3.712647,4.462715,-0.945356),(-3.333806,4.132648,-1.213406),(-3.084302,3.987687,-1.485322),(-2.967169,4.050597,-1.813199),(-2.950427,4.311499,-2.234862),(-2.976243,4.729418,-2.76155),(-2.975796,5.238721,-3.371987),(-2.886206,5.759424,-4.014468),(-2.665448,6.209751,-4.616691),(-2.301711,6.518979,-5.101115),(-1.815057,6.638546,-5.402242),(-1.251171,6.549673,-5.481736),(-0.668902,6.266317,-5.337708),(-0.124839,5.83298,-5.005892),(0.341151,5.317715,-4.552343),(0.715761,4.801443,-4.059283),(1.014958,4.365245,-3.607376),(1.278885,4.077623,-3.258547),(1.560211,3.983749,-3.043305),(1.908857,4.098364,-2.955488),(2.35695,4.403469,-2.955521),(2.907858,4.851147,-2.98128),(3.532179,5.371093,-2.96385),(4.17187,5.881649,-2.844333),(4.751736,6.302635,-2.587657),(5.195639,6.567935,-2.190146),(5.44363,6.635884,-1.679138),(5.465904,6.495812,-1.104956),(5.270208,6.169716,-0.527364),(4.900852,5.708809,0.0),(4.945229,4.700791,0.0),(4.442959,4.244439,0.444585),(3.999705,3.878912,0.808558),(3.680884,3.661616,1.135402),(3.515672,3.626676,1.48198),(3.49191,3.77958,1.901593),(3.560526,4.096313,2.427526),(3.64832,4.527135,3.061304),(3.675945,5.004385,3.76876),(3.576756,5.453113,4.48511),(3.312023,5.802847,5.128015),(2.878958,5.998661,5.615615),(2.3098,6.009805,5.885274),(1.662397,5.834527,5.90851),(1.004793,5.500356,5.698463),(0.397779,5.05977,5.307992),(-0.120172,4.581964,4.818726),(-0.54181,4.141976,4.32354),(-0.891634,3.808905,3.906503),(-1.217918,3.635058,3.624949),(-1.578281,3.647739,3.49783),(-2.022445,3.844955,3.502977),(-2.576592,4.195734,3.583821),(-3.233344,4.644987,3.663824),(-3.950058,5.122161,3.665118),(-4.656077,5.552316,3.526841),(-5.267385,5.867897,3.218832),(-5.705246,6.019343,2.747502),(-5.914403,5.98287,2.152666),(-5.876428,5.764206,1.496322),(-5.614945,5.397691,0.846317),(-5.191348,4.940887,0.259089),(-4.691897,4.465532,-0.234163),(-4.20914,4.04628,-0.634426),(-3.821961,3.748974,-0.973191),(-3.578874,3.620304,-1.302604),(-3.488427,3.680479,-1.679938),(-3.518876,3.920048,-2.15034),(-3.607069,4.301386,-2.732249),(-3.674322,4.764607,-3.409273),(-3.645413,5.236961,-4.130755),(-3.466134,5.644268,-4.821098),(-3.115265,5.92256,-5.395797),(-2.608215,6.028133,-5.780398),(-1.99166,5.944406,-5.927874),(-1.330702,5.684528,-5.830186),(-0.691892,5.289313,-5.521171),(-0.126436,4.820829,-5.069933),(0.342188,4.352649,-4.56618),(0.723094,3.9583,-4.100867),(1.054137,3.699714,-3.746627),(1.390345,3.617501,-3.542541),(1.787546,3.724572,-3.486738),(2.285381,4.004112,-3.538461),(2.894024,4.41222,-3.628991),(3.588107,4.884804,-3.678705),(4.309551,5.347645,-3.616143),(4.978842,5.728056,-3.394517),(5.51219,5.966293,-3.001779),(5.840534,6.024943,-2.461991),(5.925812,5.894794,-1.827871),(5.770559,5.596286,-1.166544),(5.418403,5.176299,-0.542193),(4.945229,4.700791,0.0),(4.863841,3.764893,0.0),(4.424486,3.441911,0.442737),(4.117042,3.251293,0.832278),(3.978758,3.222975,1.227284),(4.001583,3.361406,1.686808),(4.135326,3.644844,2.251979),(4.300366,4.028777,2.93194),(4.406811,4.452908,3.697753),(4.375498,4.850629,4.485977),(4.15587,5.159479,5.211296),(3.736529,5.330954,5.785279),(3.14616,5.338123,6.136811),(2.4448,5.179862,6.229249),(1.707856,4.881024,6.070081),(1.006937,4.488542,5.710622),(0.392357,4.064053,5.235642),(-0.118339,3.674223,4.745229),(-0.543003,3.380273,4.333062),(-0.92807,3.228368,4.06614),(-1.334073,3.242364,3.970668),(-1.817213,3.420063,4.027358),(-2.411679,3.733558,4.177151),(-3.117302,4.133614,4.335903),(-3.895796,4.557405,4.414473),(-4.676764,4.938375,4.339403),(-5.372205,5.216693,4.069287),(-5.896144,5.348651,3.603059),(-6.184707,5.313524,2.978398),(-6.211743,5.11683,2.26089),(-5.996136,4.789458,1.526804),(-5.598897,4.382821,0.843898),(-5.110548,3.960782,0.255057),(-4.631642,3.58962,-0.231156),(-4.250921,3.327625,-0.640723),(-4.026182,3.215942,-1.025192),(-3.972288,3.272113,-1.445795),(-4.059079,3.487314,-1.95475),(-4.219561,3.827749,-2.57852),(-4.366348,4.239954,-3.30738),(-4.412372,4.659193,-4.094083),(-4.290914,5.019625,-4.862197),(-3.970252,5.264646,-5.522284),(-3.459545,5.355775,-5.992108),(-2.80478,5.2787,-6.216031),(-2.075987,5.045528,-6.17886),(-1.349077,4.692875,-5.910691),(-0.686912,4.276126,-5.481427),(-0.124346,3.860731,-4.986103),(0.339053,3.511925,-4.524346),(0.736825,3.284488,-4.178745),(1.124618,3.214139,-3.997129),(1.563168,3.311925,-3.982887),(2.099645,3.56249,-4.095508),(2.752119,3.926483,-4.261113),(3.501222,4.346739,-4.390393),(4.291274,4.757259,-4.399626),(5.040842,5.093571,-4.229769),(5.660338,5.302859,-3.859153),(6.0725,5.352254,-3.306907),(6.230809,5.233998,-2.626506),(6.131339,4.966665,-1.891268),(5.81505,4.592236,-1.175538),(5.359805,4.169517,-0.536329),(4.863841,3.764893,0.0),(4.766107,2.970737,0.0),(4.482829,2.808123,0.448575),(4.381112,2.786008,0.885661),(4.457973,2.907864,1.375103),(4.663606,3.154555,1.965875),(4.913577,3.487339,2.675791),(5.108711,3.853951,3.48306),(5.157909,4.196818,4.328),(4.998514,4.462093,5.124723),(4.609482,4.608114,5.780107),(4.014402,4.611949,6.21551),(3.273886,4.472997,6.385951),(2.469435,4.213079,6.292018),(1.682915,3.873015,5.981437),(0.976805,3.506211,5.539735),(0.380095,3.170272,5.072009),(-0.116711,2.917958,4.679975),(-0.556359,2.788893,4.43964),(-1.0008,2.803347,4.38479),(-1.511969,2.959049,4.500148),(-2.132334,3.231548,4.725738),(-2.870223,3.578047,4.971372),(-3.693797,3.944131,5.137759),(-4.53538,4.272306,5.139211),(-5.305304,4.511033,4.922603),(-5.912037,4.622821,4.478194),(-6.283768,4.590114,3.83993),(-6.38616,4.418048,3.075412),(-6.231874,4.133646,2.268217),(-5.879365,3.781573,1.49707),(-5.42103,3.41712,0.817089),(-4.963341,3.097524,0.24771),(-4.603537,2.872978,-0.229753),(-4.40829,2.778745,-0.664443),(-4.399332,2.829624,-1.120207),(-4.549364,3.017625,-1.655833),(-4.789168,3.313224,-2.306342),(-5.024145,3.669996,-3.070191),(-5.156334,4.031911,-3.905771),(-5.106665,4.342133,-4.738293),(-4.832234,4.55194,-5.475587),(-4.334621,4.628384,-6.029091),(-3.657488,4.55946,-6.334955),(-2.874296,4.35599,-6.370095),(-2.069371,4.049931,-6.15917),(-1.317104,3.689347,-5.770608),(-0.664478,3.330868,-5.302411),(-0.121224,3.030792,-4.860944),(0.340047,2.836245,-4.53761),(0.773869,2.77778,-4.388831),(1.244726,2.864579,-4.424021),(1.807062,3.083011,-4.604319),(2.487636,3.398771,-4.852313),(3.274811,3.762269,-5.070399),(4.117642,4.11642,-5.16336),(4.935236,4.405605,-5.059847),(5.634259,4.584408,-4.727705),(6.130463,4.624748,-4.179679),(6.368982,4.520291,-3.468363),(6.338431,4.28744,-2.671873),(6.075215,3.962765,-1.873956),(5.656831,3.597255,-1.143553),(5.185538,3.248312,-0.518891),(4.766107,2.970737,0.0),(4.76363,2.336672,0.0),(4.706588,2.320221,0.470965),(4.842732,2.423526,0.978979),(5.124121,2.630361,1.580582),(5.463303,2.908244,2.302975),(5.753437,3.213535,3.133155),(5.892523,3.498287,4.017454),(5.806014,3.717782,4.871825),(5.462567,3.837548,5.600493),(4.879355,3.838776,6.118517),(4.115936,3.721274,6.372716),(3.25842,3.503494,6.355783),(2.397982,3.219639,6.109958),(1.609112,2.914287,5.719123),(0.932945,2.635394,5.290994),(0.369711,2.426758,4.933449),(-0.117971,2.321145,4.730506),(-0.59194,2.335142,4.723566),(-1.118926,2.466551,4.902333),(-1.749634,2.694733,5.207522),(-2.50186,2.983854,5.54469),(-3.35204,3.288508,5.805903),(-4.237562,3.560849,5.894089),(-5.069456,3.758108,5.744391),(-5.752508,3.849304,5.337547),(-6.207939,3.820117,4.702331),(-6.393077,3.675129,3.906728),(-6.313114,3.437111,3.040235),(-6.021874,3.143443,2.191783),(-5.611183,2.840245,1.428783),(-5.191129,2.575132,0.782437),(-4.865764,2.389742,0.24284),(-4.709892,2.313188,-0.235061),(-4.752397,2.357493,-0.716309),(-4.970013,2.5157,-1.265521),(-5.292989,2.762962,-1.92649),(-5.621276,3.060447,-2.707064),(-5.847392,3.361436,-3.573267),(-5.880558,3.61866,-4.45435),(-5.666455,3.791722,-5.257702),(-5.198056,3.853443,-5.890114),(-4.515175,3.794129,-6.280226),(-3.693093,3.623097,-6.396625),(-2.823287,3.367206,-6.257048),(-1.991108,3.066644,-5.926232),(-1.255952,2.768612,-5.502687),(-0.638778,2.519916,-5.09733),(-0.119927,2.359613,-4.808904),(0.352362,2.312879,-4.70194),(0.845031,2.387052,-4.792407),(1.419283,2.570485,-5.04443),(2.111033,2.834369,-5.378825),(2.917806,3.137262,-5.691391),(3.795536,3.431595,-5.876639),(4.666283,3.671145,-5.851334),(5.435154,3.81829,-5.572388),(6.012375,3.849921,-5.044982),(6.335159,3.761072,-4.319238),(6.383937,3.565696,-3.476507),(6.188859,3.294475,-2.608823),(5.824731,2.990005,-1.796692),(5.39539,2.700101,-1.090702),(5.011011,2.470294,-0.501427),(4.76363,2.336672,0.0),(4.942123,1.830361,0.0),(5.140356,1.913286,0.51437),(5.498298,2.077538,1.111505),(5.927375,2.297322,1.828353),(6.314998,2.538121,2.661995),(6.549726,2.762119,3.566791),(6.545797,2.934136,4.462849),(6.26132,3.027159,5.253871),(5.705994,3.026578,5.850066),(4.936757,2.932484,6.190497),(4.04267,2.759655,6.259277),(3.122914,2.535233,6.091469),(2.263373,2.294463,5.766981),(1.517544,2.075157,5.393671),(0.896354,1.911757,5.083477),(0.369237,1.829924,4.927127),(-0.124028,1.842511,4.97338),(-0.653863,1.947539,5.217702),(-1.278864,2.128516,5.60307),(-2.026893,2.357018,6.032741),(-2.884168,2.597161,6.391974),(-3.795273,2.811229,6.573606),(-4.674254,2.965606,6.501491),(-5.424213,3.036045,6.146381),(-5.960629,3.011485,5.530656),(-6.232656,2.895782,4.721054),(-6.237054,2.707109,3.811384),(-6.021133,2.475094,2.899625),(-5.673728,2.236176,2.065068),(-5.306114,2.027876,1.351103),(-5.027217,1.882907,0.757731),(-4.918924,1.824037,0.245493),(-5.017281,1.86051,-0.250402),(-5.304064,1.986598,-0.799459),(-5.710702,2.1825,-1.454123),(-6.133666,2.41745,-2.232472),(-6.457693,2.65455,-3.109861),(-6.581389,2.856563,-4.021803),(-6.439238,2.991763,-4.877533),(-6.01493,3.038919,-5.581039),(-5.343064,2.990624,-6.054428),(-4.499076,2.854463,-6.257833),(-3.580063,2.651819,-6.200851),(-2.681343,2.414518,-5.942465),(-1.874519,2.179827,-5.579224),(-1.192398,1.984603,-5.224237),(-0.624307,1.859507,-4.981852),(-0.122795,1.824183,-4.92391),(0.380185,1.88418,-5.073212),(0.951829,2.030075,-5.398092),(1.637329,2.238956,-5.819412),(2.444442,2.478019,-6.228337),(3.337846,2.709719,-6.51071),(4.244847,2.897668,-6.572309),(5.071208,3.012349,-6.359093),(5.723292,3.035753,-5.867801),(6.131103,2.964203,-5.144606),(6.266487,2.808936,-4.272419),(6.151871,2.594337,-3.35013),(5.857161,2.354108,-2.469),(5.485279,2.125976,-1.691985),(5.149562,1.945768,-1.041006),(4.948261,1.841787,-0.495148),(4.942123,1.830361,0.0),(5.338822,1.382317,0.0),(5.770987,1.501674,0.577474),(6.287009,1.660748,1.270946),(6.770685,1.834556,2.08848),(7.102961,1.995802,2.994149),(7.18797,2.119163,3.91436),(6.973446,2.185265,4.754415),(6.460857,2.183727,5.421302),(5.70306,2.11479,5.847059),(4.790309,1.989282,6.006858),(3.82818,1.826912,5.927182),(2.912888,1.653181,5.681797),(2.110016,1.495372,5.376232),(1.441736,1.37827,5.124233),(0.88546,1.320264,5.021691),(0.384005,1.330464,5.124186),(-0.135503,1.407269,5.433503),(-0.738911,1.538616,5.896367),(-1.464358,1.703878,6.415772),(-2.308961,1.877101,6.872274),(-3.226339,2.03108,7.150301),(-4.135738,2.141633,7.163308),(-4.940621,2.191399,6.871986),(-5.552158,2.172562,6.29136),(-5.911798,2.088079,5.485347),(-6.007234,1.95122,4.550303),(-5.877631,1.783476,3.591745),(-5.606543,1.611193,2.699969),(-5.303964,1.461426,1.930485),(-5.081583,1.357697,1.29393),(-5.027048,1.316295,0.757706),(-5.183311,1.343723,0.258688),(-5.538002,1.435673,-0.27639),(-6.025394,1.577704,-0.908182),(-6.540583,1.747512,-1.665437),(-6.962563,1.918428,-2.534166),(-7.18084,2.06361,-3.45811),(-7.119352,2.160257,-4.350545),(-6.752197,2.193192,-5.114591),(-6.107614,2.157243,-5.667037),(-5.259523,2.058054,-5.959764),(-4.308904,1.911203,-5.993321),(-3.359661,1.739753,-5.819103),(-2.494921,1.57063,-5.529312),(-1.759481,1.430393,-5.236829),(-1.152549,1.341068,-5.049649),(-0.632328,1.316682,-5.045858),(-0.131054,1.361064,-5.255106),(0.423483,1.467246,-5.650991),(1.085511,1.61855,-6.156239),(1.873697,1.791216,-6.659516),(2.762975,1.958126,-7.039947),(3.687964,2.093068,-7.19364),(4.55726,2.174849,-7.056019),(5.275159,2.190626,-6.61484),(5.765439,2.137921,-5.911012),(5.991277,2.025012,-5.027278),(5.966216,1.869629,-4.067697),(5.753248,1.696177,-3.133052),(5.451937,1.531895,-2.298184),(5.176426,1.402582,-1.596716),(5.02942,1.328549,-1.016719),(5.078265,1.32142,-0.508157),(5.338822,1.382317,0.0),(5.931087,0.908609,0.0),(6.527574,1.004982,0.653182),(7.101992,1.109994,1.435699),(7.5298,1.207153,2.322636),(7.706532,1.281202,3.248576),(7.570129,1.320511,4.122473),(7.11339,1.318906,4.849828),(6.383804,1.27664,5.356648),(5.471014,1.20035,5.609154),(4.485131,1.102018,5.624176),(3.531234,0.997086,5.467419),(2.686243,0.902033,5.23971),(1.983666,0.831788,5.054298),(1.409735,0.797383,5.010497),(0.911595,0.80422,5.169914),(0.415238,0.851225,5.540967),(-0.151513,0.931018,6.075473),(-0.836888,1.031065,6.678206),(-1.649586,1.135657,7.227311),(-2.553735,1.228365,7.600807),(-3.475749,1.294631,7.703052),(-4.321466,1.324049,7.484999),(-4.999334,1.311997,6.95365),(-5.443856,1.260369,6.168638),(-5.633376,1.177272,5.227009),(-5.597602,1.075757,4.240019),(-5.412732,0.971767,3.307652),(-5.185072,0.881633,2.496999),(-5.026865,0.81951,1.829629),(-5.029989,0.795154,1.280793),(-5.24378,0.812391,0.790373),(-5.662311,0.868514,0.282594),(-6.224256,0.954708,-0.31064),(-6.825487,1.057437,-1.028777),(-7.341521,1.160568,-1.869381),(-7.654627,1.247904,-2.786056),(-7.679271,1.305729,-3.698142),(-7.380024,1.324962,-4.509839),(-6.777868,1.302583,-5.134035),(-5.943612,1.242106,-5.514866),(-4.980226,1.153028,-5.643282),(-3.998488,1.04934,-5.561558),(-3.091907,0.947326,-5.35534),(-2.316945,0.863005,-5.134877),(-1.683179,0.809621,-5.009728),(-1.15558,0.795558,-5.062926),(-0.668026,0.823024,-5.330722),(-0.144464,0.887705,-5.792833),(0.477785,0.979444,-6.375598),(1.228542,1.083834,-6.967409),(2.094103,1.184479,-7.442886),(3.018167,1.265574,-7.690165),(3.914217,1.314384,-7.634962),(4.686335,1.323242,-7.255866),(5.253291,1.290758,-6.587418),(5.569843,1.222033,-5.710477),(5.639836,1.12786,-4.732384),(5.517608,1.023029,-3.761842),(5.297061,0.924004,-2.884626),(5.090772,0.846335,-2.14594),(5.003974,0.802221,-1.543522),(5.10956,0.79859,-1.03292),(5.430077,0.836011,-0.543361),(5.931087,0.908609,0.0),(6.639195,0.336702,0.0),(7.29538,0.371827,0.730013),(7.812866,0.404239,1.579405),(8.080434,0.428846,2.492484),(8.027193,0.441784,3.383746),(7.637183,0.441021,4.158988),(6.951443,0.426677,4.739413),(6.057228,0.401005,5.082618),(5.067149,0.368037,5.195091),(4.093332,0.332949,5.132877),(3.222834,0.301253,4.989923),(2.500142,0.277926,4.876707),(1.920793,0.266632,4.8941),(1.43737,0.269144,5.108715),(0.976088,0.285068,5.535671),(0.459606,0.311903,6.133014),(-0.169813,0.345435,6.809284),(-0.932677,0.380397,7.442587),(-1.804675,0.4113,7.906799),(-2.721061,0.433288,8.098825),(-3.591957,0.442911,7.960594),(-4.324771,0.438655,7.490723),(-4.848086,0.42119,6.743277),(-5.130976,0.393259,5.814103),(-5.192756,0.359247,4.818173),(-5.100481,0.324497,3.863464),(-4.954522,0.294466,3.027645),(-4.865456,0.27387,2.34308),(-4.927705,0.265943,1.793538),(-5.196223,0.271931,1.323121),(-5.671871,0.290894,0.854897),(-6.299109,0.319852,0.314375),(-6.976709,0.354259,-0.348193),(-7.579111,0.388711,-1.142367),(-7.983493,0.417796,-2.032847),(-8.096289,0.436949,-2.946808),(-7.872988,0.443159,-3.791431),(-7.326703,0.435453,-4.477255),(-6.523657,0.415041,-4.941478),(-5.566842,0.385127,-5.165275),(-4.571927,0.350411,-5.180623),(-3.641255,0.316344,-5.064677),(-2.842155,0.288276,-4.922757),(-2.194657,0.270615,-4.86386),(-1.671334,0.266135,-4.974474),(-1.208997,0.27554,-5.29696),(-0.729062,0.297352,-5.817776),(-0.161314,0.328146,-6.468475),(0.535026,0.363086,-7.139421),(1.358266,0.396684,-7.70311),(2.262588,0.423664,-8.041716),(3.168206,0.43979,-8.072457),(3.980847,0.442527,-7.764929),(4.615668,0.431447,-7.146452),(5.019588,0.40829,-6.294364),(5.186317,0.376692,-5.317268),(5.160143,0.341616,-4.329874),(5.027231,0.30857,-3.427508),(4.896294,0.282744,-2.666379),(4.873081,0.268194,-2.054176),(5.034766,0.267206,-1.55302),(5.41037,0.279933,-1.09373),(5.972006,0.304378,-0.597589),(6.639195,0.336702,0.0),(7.342836,-0.372386,0.0),(7.940546,-0.40471,0.794571),(8.294432,-0.429155,1.676756),(8.326082,-0.441883,2.568256),(8.011028,-0.440894,3.376932),(7.383028,-0.426344,4.020583),(6.525265,-0.400519,4.44885),(5.550715,-0.367473,4.657603),(4.576452,-0.332396,4.692004),(3.698066,-0.300798,4.637228),(2.970231,-0.277641,4.598817),(2.397905,-0.266561,4.677287),(1.940004,-0.269299,4.943048),(1.524312,-0.285424,5.417726),(1.069688,-0.312404,6.066502),(0.509853,-0.346003,6.803514),(-0.187268,-0.380942,7.509211),(-1.009516,-0.411736,8.055744),(-1.902298,-0.433549,8.334512),(-2.781756,-0.442953,8.279476),(-3.555972,-0.438473,7.880843),(-4.148861,-0.420813,7.186037),(-4.520667,-0.392745,6.287865),(-4.679785,-0.358677,5.302841),(-4.682712,-0.323961,4.344922),(-4.621874,-0.294048,3.500934),(-4.604036,-0.273635,2.813468),(-4.724387,-0.265929,2.275145),(-5.042522,-0.27214,1.835328),(-5.566175,-0.291292,1.417322),(-6.246753,-0.320378,0.941546),(-6.987941,-0.354829,0.348754),(-7.665541,-0.389236,-0.382571),(-8.153992,-0.418195,-1.229017),(-8.353446,-0.437157,-2.127049),(-8.211106,-0.443145,-2.988598),(-7.731919,-0.435219,-3.723496),(-6.976218,-0.414623,-4.263078),(-6.045051,-0.384591,-4.578948),(-5.056798,-0.349841,-4.692023),(-4.120736,-0.31583,-4.669361),(-3.313836,-0.287898,-4.609265),(-2.666245,-0.270433,-4.618071),(-2.158672,-0.266178,-4.78411),(-1.73203,-0.2758,-5.155125),(-1.306619,-0.297789,-5.724674),(-0.8059,-0.328691,-6.430932),(-0.178769,-0.363653,-7.168401),(0.585273,-0.397185,-7.80992),(1.451866,-0.42402,-8.233941),(2.34953,-0.439944,-8.350727),(3.187417,-0.442456,-8.121406),(3.87861,-0.431162,-7.565508),(4.363065,-0.407835,-6.755345),(4.624321,-0.376139,-5.798716),(4.69562,-0.341052,-4.814181),(4.65363,-0.308083,-3.904859),(4.601053,-0.282411,-3.136945),(4.642138,-0.268067,-2.527974),(4.856916,-0.267305,-2.047362),(5.280414,-0.280243,-1.628792),(5.891936,-0.30485,-1.191081),(6.617172,-0.337261,-0.662148),(7.342836,-0.372386,0.0),(7.907469,-1.21138,0.0),(8.339713,-1.283977,0.834514),(8.454613,-1.321399,1.709137),(8.219774,-1.317768,2.535465),(7.661129,-1.273654,3.229437),(6.856258,-1.195985,3.733719),(5.916344,-1.09696,4.033695),(4.961113,-0.992129,4.162868),(4.092747,-0.897956,4.196086),(3.374908,-0.829231,4.232001),(2.821722,-0.796747,4.36888),(2.39908,-0.805605,4.679579),(2.037625,-0.854414,5.191784),(1.653938,-0.93551,5.878444),(1.174498,-1.036155,6.660909),(0.556372,-1.140545,7.424263),(-0.200541,-1.232284,8.041422),(-1.052711,-1.296965,8.400437),(-1.923789,-1.324431,8.428669),(-2.724216,-1.310368,8.108218),(-3.374675,-1.256984,7.479049),(-3.827371,-1.172663,6.629201),(-4.079682,-1.070648,5.674492),(-4.176551,-0.96696,4.732607),(-4.200767,-0.877883,3.897742),(-4.253295,-0.817406,3.221746),(-4.42829,-0.795027,2.706072),(-4.788838,-0.81426,2.306183),(-5.349363,-0.872085,1.947009),(-6.06911,-0.959421,1.545385),(-6.858504,-1.062552,1.033753),(-7.597098,-1.165281,0.379155),(-8.159043,-1.251475,-0.407201),(-8.440211,-1.307598,-1.272157),(-8.380642,-1.324835,-2.133974),(-7.977125,-1.300479,-2.903436),(-7.283037,-1.238356,-3.507326),(-6.395582,-1.148222,-3.908259),(-5.433561,-1.044232,-4.115762),(-4.511004,-0.942717,-4.1856),(-3.712921,-0.85962,-4.207251),(-3.078836,-0.807992,-4.2824),(-2.597812,-0.79594,-4.499542),(-2.21587,-0.825357,-4.910873),(-1.85366,-0.891624,-5.517139),(-1.429782,-0.984332,-6.264285),(-0.88385,-1.088923,-7.052952),(-0.193492,-1.188971,-7.758783),(0.618919,-1.268764,-8.258894),(1.491445,-1.315769,-8.458404),(2.338306,-1.322606,-8.310833),(3.072127,-1.2882,-7.827651),(3.627054,-1.217956,-7.074831),(3.976824,-1.122903,-6.157327),(4.143068,-1.017971,-5.195243),(4.191575,-0.919639,-4.29741),(4.217145,-0.843349,-3.538605),(4.320562,-0.801083,-2.945709),(4.58319,-0.799478,-2.495872),(5.045368,-0.838787,-2.126801),(5.693949,-0.912836,-1.756351),(6.462181,-1.009995,-1.306358),(7.242216,-1.115007,-0.724693),(7.907469,-1.21138,0.0),(8.214258,-2.126819,0.0),(8.407466,-2.187715,0.841294),(8.254936,-2.180587,1.668771),(7.774528,-2.106553,2.398124),(7.036903,-1.977241,2.966303),(6.149359,-1.812959,3.348762),(5.231864,-1.639506,3.567025),(4.390985,-1.484124,3.684474),(3.697821,-1.371214,3.791188),(3.175048,-1.318509,3.981384),(2.795912,-1.334286,4.328919),(2.495095,-1.416067,4.866863),(2.188521,-1.551009,5.57626),(1.797025,-1.717919,6.387008),(1.267956,-1.890585,7.190938),(0.58934,-2.04189,7.864192),(-0.206833,-2.148071,8.293761),(-1.052912,-2.192454,8.402039),(-1.863295,-2.168067,8.163627),(-2.556994,-2.078742,7.610505),(-3.079286,-1.938506,6.824399),(-3.416879,-1.769382,5.918208),(-3.60262,-1.597933,5.01094),(-3.708358,-1.451082,4.20208),(-3.827497,-1.351893,3.551398),(-4.051403,-1.315943,3.068819),(-4.445367,-1.348878,2.716507),(-5.030063,-1.445526,2.422351),(-5.773166,-1.590708,2.101261),(-6.593399,-1.761623,1.678886),(-7.376309,-1.931431,1.1118),(-7.998231,-2.073463,0.399175),(-8.352921,-2.165413,-0.416877),(-8.374655,-2.192841,-1.262276),(-8.052399,-2.151439,-2.050393),(-7.431765,-2.047709,-2.704941),(-6.604359,-1.897943,-3.180492),(-5.687088,-1.725659,-3.475307),(-4.796366,-1.557916,-3.633106),(-4.023313,-1.421056,-3.733089),(-3.415723,-1.336574,-3.870484),(-2.970903,-1.317736,-4.132275),(-2.640802,-1.367502,-4.574003),(-2.347868,-1.478056,-5.20341),(-2.007514,-1.632035,-5.97506),(-1.551486,-1.805257,-6.797504),(-0.946329,-1.970519,-7.55153),(-0.202385,-2.101867,-8.115364),(0.628818,-2.178671,-8.390996),(1.468008,-2.188872,-8.325487),(2.228987,-2.130866,-7.92229),(2.84148,-2.013763,-7.239974),(3.270172,-1.855954,-6.378706),(3.524993,-1.682223,-5.457756),(3.659897,-1.519853,-4.589366),(3.760199,-1.394345,-3.855142),(3.921405,-1.325409,-3.290449),(4.224634,-1.323871,-2.880306),(4.714637,-1.389973,-2.567455),(5.38588,-1.513334,-2.270339),(6.18027,-1.67458,-1.906361),(6.997347,-1.848387,-1.414544),(7.714744,-2.007461,-0.771977),(8.214258,-2.126819,0.0),(8.186407,-3.031912,0.0),(8.115031,-3.020487,0.812031),(7.718662,-2.916505,1.560361),(7.059987,-2.736298,2.177718),(6.240467,-2.508166,2.630577),(5.377887,-2.267936,2.928641),(4.580813,-2.053337,3.123145),(3.925934,-1.898071,3.29425),(3.443531,-1.826521,3.530478),(3.114297,-1.849924,3.905205),(2.877987,-1.964606,4.455996),(2.651529,-2.152555,5.171999),(2.351948,-2.384255,5.992667),(1.918408,-2.623317,6.818429),(1.327916,-2.832198,7.530986),(0.600912,-2.978094,8.018608),(-0.204509,-3.038091,8.200539),(-1.008143,-3.002767,8.04479),(-1.728975,-2.87767,7.575133),(-2.306742,-2.682447,6.865669),(-2.718252,-2.447755,6.024266),(-2.984202,-2.210454,5.168789),(-3.16462,-2.007811,4.401719),(-3.343898,-1.871649,3.789097),(-3.608964,-1.823354,3.348629),(-4.02594,-1.87051,3.049531),(-4.621066,-2.005711,2.823874),(-5.370704,-2.207724,2.586395),(-6.203117,-2.444823,2.25775),(-7.011859,-2.679773,1.785439),(-7.677831,-2.875675,1.157247),(-8.094929,-3.001764,0.404001),(-8.193286,-3.038237,-0.40891),(-7.954678,-2.979366,-1.198975),(-7.416446,-2.834397,-1.888459),(-6.663055,-2.626098,-2.425154),(-5.807264,-2.38718,-2.796631),(-4.965401,-2.155165,-3.034293),(-4.232522,-1.966491,-3.206011),(-3.663264,-1.850789,-3.399013),(-3.262749,-1.826229,-3.697144),(-2.989442,-1.896668,-4.158061),(-2.768992,-2.051044,-4.796035),(-2.515427,-2.265113,-5.574758),(-2.154368,-2.505256,-6.412152),(-1.642509,-2.733758,-7.1963),(-0.978587,-2.914734,-7.80894),(-0.203275,-3.019763,-8.151069),(0.611859,-3.032349,-8.164693),(1.383391,-2.950517,-7.845601),(2.038193,-2.787117,-7.24417),(2.533017,-2.567811,-6.454023),(2.866462,-2.327041,-5.59124),(3.080165,-2.102619,-4.769028),(3.248748,-1.929789,-4.073801),(3.460829,-1.835696,-3.548213),(3.795717,-1.835115,-3.184985),(4.301503,-1.928137,-2.932715),(4.980032,-2.100155,-2.711981),(5.78263,-2.324152,-2.437583),(6.617891,-2.564951,-2.041349),(7.369926,-2.784735,-1.489863),(7.922935,-2.948987,-0.792809),(8.186407,-3.031912,0.0),(7.805634,-3.828846,0.0),(7.495793,-3.695225,0.750067),(6.924656,-3.465417,1.399849),(6.186115,-3.175513,1.908164),(5.393419,-2.871043,2.273517),(4.654661,-2.599823,2.534793),(4.050054,-2.404446,2.76128),(3.616239,-2.315597,3.034385),(3.341168,-2.347228,3.425531),(3.170524,-2.494373,3.975712),(3.023871,-2.733923,4.681869),(2.816426,-3.028256,5.493642),(2.481035,-3.331149,6.321573),(1.984983,-3.595033,7.055048),(1.337599,-3.778466,7.585901),(0.586941,-3.852639,7.832177),(-0.193434,-3.805905,7.756453),(-0.924131,-3.645602,7.374386),(-1.540972,-3.396906,6.751438),(-2.012035,-3.098874,5.988517),(-2.346289,-2.798312,5.19991),(-2.591539,-2.542421,4.488677),(-2.822053,-2.371389,3.925237),(-3.118847,-2.312076,3.534084),(-3.547468,-2.373796,3.291569),(-4.13881,-2.546858,3.135027),(-4.877846,-2.804082,2.980789),(-5.703239,-3.105071,2.746535),(-6.518256,-3.402556,2.372451),(-7.210575,-3.649818,1.836038),(-7.676478,-3.808025,1.157043),(-7.843746,-3.85233,0.391465),(-7.687875,-3.775776,-0.383686),(-7.237746,-3.590386,-1.090915),(-6.569405,-3.325274,-1.672776),(-5.78937,-3.022075,-2.107158),(-5.011401,-2.728407,-2.413364),(-4.332161,-2.490389,-2.647328),(-3.81143,-2.345401,-2.887046),(-3.461415,-2.316214,-3.211723),(-3.247448,-2.40741,-3.679806),(-3.099666,-2.604669,-4.311373),(-2.932592,-2.87701,-5.079399),(-2.667716,-3.181664,-5.912267),(-2.253508,-3.470785,-6.707227),(-1.677999,-3.698967,-7.351793),(-0.970969,-3.830376,-7.74815),(-0.195389,-3.844373,-7.834851),(0.569591,-3.73876,-7.600668),(1.249685,-3.530124,-7.087314),(1.795154,-3.251231,-6.380355),(2.194086,-2.945879,-5.590439),(2.475812,-2.662024,-4.82925),(2.703471,-2.444245,-4.185792),(2.957453,-2.326742,-3.708529),(3.313755,-2.32797,-3.397426),(3.8226,-2.447736,-3.207542),(4.49269,-2.667231,-3.063064),(5.285162,-2.951984,-2.878146),(6.118975,-3.257274,-2.579364),(6.886725,-3.535157,-2.124273),(7.477315,-3.741992,-1.511572),(7.800216,-3.845297,-0.780529),(7.805634,-3.828846,0.0),(7.114913,-4.434759,0.0),(6.636443,-4.157184,0.664076),(5.988617,-3.808242,1.210625),(5.277964,-3.442731,1.628036),(4.609646,-3.118056,1.943129),(4.065186,-2.885205,2.213782),(3.686097,-2.780748,2.513138),(3.46713,-2.821088,2.909268),(3.36053,-2.999891,3.445381),(3.290052,-3.289076,4.125595),(3.171192,-3.643227,4.909966),(2.932612,-4.006726,5.720271),(2.533562,-4.322485,6.455411),(1.973134,-4.540917,7.012937),(1.289248,-4.627716,7.311689),(0.547823,-4.569251,7.310188),(-0.174978,-4.374704,7.016383),(-0.812852,-4.074628,6.486403),(-1.326672,-3.716149,5.81253),(-1.714575,-3.355565,5.103173),(-2.012214,-3.049506,4.459524),(-2.283022,-2.846037,3.95431),(-2.600849,-2.777112,3.61756),(-3.029268,-2.853556,3.432578),(-3.602739,-3.063363,3.342853),(-4.314413,-3.373585,3.268041),(-5.11382,-3.735501,3.124991),(-5.915261,-4.092273,2.848639),(-6.615142,-4.387871,2.407715),(-7.114295,-4.575872,1.811522),(-7.340028,-4.626751,1.106331),(-7.262714,-4.532518,0.362467),(-6.90291,-4.307972,-0.34451),(-6.327289,-3.988376,-0.953685),(-5.634261,-3.623924,-1.434659),(-4.932633,-3.27185,-1.795331),(-4.318269,-2.987448,-2.079569),(-3.854198,-2.815382,-2.355251),(-3.55871,-2.782675,-2.695618),(-3.4041,-2.894463,-3.158543),(-3.326122,-3.13319,-3.768954),(-3.241673,-3.461365,-4.508892),(-3.070287,-3.827449,-5.317893),(-2.754176,-4.173948,-6.103881),(-2.271977,-4.446447,-6.762196),(-1.642976,-4.60215,-7.198347),(-0.920971,-4.616603,-7.349173),(-0.179491,-4.487538,-7.197352),(0.507775,-4.235224,-6.775789),(1.086313,-3.899286,-6.160785),(1.534946,-3.532481,-5.455521),(1.871189,-3.192417,-4.767711),(2.146362,-2.932499,-4.186633),(2.431601,-2.793547,-3.764855),(2.798213,-2.797383,-3.508848),(3.297252,-2.943404,-3.380505),(3.94348,-3.208678,-3.308973),(4.707848,-3.551545,-3.209756),(5.520591,-3.918158,-3.006353),(6.284471,-4.250941,-2.649127),(6.895206,-4.497632,-2.126889),(7.264336,-4.619488,-1.468517),(7.339151,-4.597373,-0.734393),(7.114913,-4.434759,0.0),(6.207019,-4.80459,0.0),(5.656042,-4.399967,0.565972),(5.036303,-3.977247,1.018111),(4.447674,-3.602819,1.371926),(3.970726,-3.335485,1.673801),(3.650169,-3.21723,1.987776),(3.486836,-3.266625,2.377285),(3.439929,-3.475912,2.886443),(3.438808,-3.812225,3.525636),(3.401347,-4.222745,4.265154),(3.254335,-4.643001,5.038696),(2.951,-5.006994,5.756138),(2.481471,-5.257559,6.322686),(1.873819,-5.355345,6.65995),(1.185609,-5.284996,6.723924),(0.488274,-5.057559,6.515557),(-0.151659,-4.708753,6.081317),(-0.68968,-4.293357,5.503515),(-1.114422,-3.876609,4.8826),(-1.449935,-3.523956,4.315511),(-1.748522,-3.290783,3.875123),(-2.075885,-3.213709,3.595538),(-2.492293,-3.304838,3.466568),(-3.034517,-3.549859,3.438526),(-3.703143,-3.910291,3.436015),(-4.458594,-4.32953,3.377254),(-5.227103,-4.741735,3.194216),(-5.915421,-5.08217,2.848717),(-6.430917,-5.297371,2.340662),(-6.702337,-5.353541,1.706625),(-6.696287,-5.241859,1.009303),(-6.425457,-4.979864,0.320681),(-5.946551,-4.608702,-0.29678),(-5.348311,-4.186662,-0.806128),(-4.732383,-3.780026,-1.205013),(-4.191463,-3.452654,-1.525568),(-3.789793,-3.25596,-1.825068),(-3.55052,-3.220833,-2.169678),(-3.452738,-3.35279,-2.615347),(-3.43875,-3.631109,-3.190694),(-3.429636,-4.012078,-3.886249),(-3.345243,-4.435869,-4.652949),(-3.123751,-4.835926,-5.410495),(-2.736089,-5.149421,-6.063796),(-2.191848,-5.32712,-6.523703),(-1.535428,-5.341116,-6.727151),(-0.833589,-5.189211,-6.65188),(-0.157666,-4.895261,-6.32219),(0.434969,-4.505431,-5.804261),(0.915498,-4.080942,-5.192047),(1.290581,-3.68846,-4.586998),(1.599839,-3.389622,-4.076324),(1.904485,-3.23136,-3.714835),(2.269924,-3.23853,-3.51453),(2.746699,-3.410005,-3.444251),(3.354584,-3.718855,-3.439285),(4.07396,-4.116576,-3.418459),(4.846808,-4.540707,-3.304498),(5.587342,-4.92464,-3.042704),(6.199952,-5.208078,-2.613499),(6.600256,-5.346508,-2.035909),(6.734311,-5.318191,-1.36137),(6.591361,-5.127573,-0.659565),(6.207019,-4.80459,0.0),(5.20187,-4.944746,0.0),(4.678272,-4.469238,0.468132),(4.175348,-4.049251,0.844065),(3.77048,-3.750743,1.163039),(3.509777,-3.620594,1.479495),(3.399211,-3.679244,1.851112),(3.405085,-3.917481,2.321548),(3.463577,-4.297892,2.906287),(3.496971,-4.760733,3.585267),(3.432589,-5.233316,4.304331),(3.21989,-5.641425,4.985365),(2.841668,-5.920965,5.542879),(2.316807,-6.028036,5.903127),(1.694108,-5.945823,6.021217),(1.038932,-5.687237,5.892075),(0.416106,-5.292888,5.552545),(-0.126538,-4.824708,5.074012),(-0.569835,-4.356223,4.547179),(-0.92724,-3.961009,4.062504),(-1.240056,-3.701131,3.690838),(-1.565156,-3.617404,3.468742),(-1.958285,-3.722977,3.391849),(-2.457171,-4.001269,3.417717),(-3.068779,-4.408575,3.477349),(-3.764027,-4.88093,3.492507),(-4.481513,-5.344151,3.394614),(-5.139551,-5.725489,3.140714),(-5.653793,-5.965058,2.722723),(-5.95628,-6.025233,2.167909),(-6.011362,-5.896563,1.530681),(-5.824624,-5.599257,0.877921),(-5.442588,-5.180005,0.271628),(-4.943137,-4.70465,-0.246702),(-4.418819,-4.247845,-0.66603),(-3.956895,-3.881331,-1.007549),(-3.620751,-3.662667,-1.317846),(-3.436974,-3.626194,-1.65516),(-3.391042,-3.77764,-2.072223),(-3.432505,-4.093221,-2.600022),(-3.488292,-4.523376,-3.236662),(-3.480848,-5.000549,-3.94428),(-3.346713,-5.449803,-4.654994),(-3.051105,-5.800582,-5.284668),(-2.59509,-5.997798,-5.75131),(-2.013797,-6.010479,-5.993763),(-1.366308,-5.836632,-5.986187),(-0.719918,-5.503561,-5.744809),(-0.132803,-5.063572,-5.325219),(0.360515,-4.585767,-4.810734),(0.757233,-4.145181,-4.294479),(1.085848,-3.811009,-3.859333),(1.397352,-3.635732,-3.560394),(1.750257,-3.646875,-3.414003),(2.193248,-3.84269,-3.395811),(2.749857,-4.192424,-3.448211),(3.409134,-4.641152,-3.495212),(4.124809,-5.118402,-3.461126),(4.8234,-5.549224,-3.288539),(5.419491,-5.865957,-2.951297),(5.834638,-6.018861,-2.459506),(6.015408,-5.983921,-1.855508),(5.946202,-5.766625,-1.202051),(5.653717,-5.401098,-0.56574),(5.20187,-4.944746,0.0),(4.218363,-4.913805,0.0),(3.803691,-4.452898,0.380617),(3.472499,-4.126802,0.701981),(3.270443,-3.98673,1.008798),(3.2075,-4.054679,1.352075),(3.256955,-4.319979,1.773643),(3.362779,-4.740964,2.292704),(3.453545,-5.251521,2.897868),(3.459513,-5.771466,3.546864),(3.328788,-6.219145,4.174168),(3.038739,-6.52425,4.704889),(2.600072,-6.638865,5.071628),(2.052738,-6.54499,5.230291),(1.454894,-6.257369,5.171001),(0.867774,-5.82117,4.92139),(0.340329,-5.304899,4.541372),(-0.102509,-4.789634,4.110488),(-0.465015,-4.356297,3.710735),(-0.778046,-4.072941,3.408841),(-1.089291,-3.984068,3.242111),(-1.448905,-4.103635,3.211103),(-1.894159,-4.412863,3.28078),(-2.437078,-4.86319,3.389769),(-3.058259,-5.383893,3.465429),(-3.708614,-5.893196,3.441091),(-4.318796,-6.311115,3.271361),(-4.814174,-6.572016,2.941881),(-5.131826,-6.634926,2.471357),(-5.235453,-6.489965,1.905549),(-5.124577,-6.159899,1.304878),(-4.835718,-5.696563,0.728867),(-4.435117,-5.172724,0.221348),(-4.004636,-4.670648,-0.199863),(-3.624042,-4.269187,-0.546236),(-3.353815,-4.031388,-0.853986),(-3.22244,-3.994597,-1.172872),(-3.221131,-4.164592,-1.551215),(-3.307119,-4.514676,-2.020938),(-3.414646,-4.989869,-2.586494),(-3.470955,-5.515543,-3.220576),(-3.413425,-6.009142,-3.867881),(-3.203782,-6.393148,-4.45619),(-2.83607,-6.607253,-4.912218),(-2.336614,-6.617833,-5.178468),(-1.756186,-6.423226,-5.227022),(-1.156482,-6.053995,-5.06688),(-0.594373,-5.568127,-4.742983),(-0.107909,-5.041925,-4.327006),(0.292414,-4.55803,-3.901999),(0.624975,-4.192434,-3.544409),(0.93063,-4.002555,-3.307655),(1.260252,-4.018212,-3.21107),(1.659375,-4.236947,-3.23673),(2.153867,-4.624407,-3.334838),(2.740334,-5.119743,-3.436271),(3.383805,-5.645164,-3.469244),(4.023466,-6.118153,-3.376089),(4.585237,-6.464429,-3.126162),(4.998252,-6.62961,-2.721903),(5.211318,-6.587755,-2.196755),(5.205367,-6.345436,-1.605643),(4.998814,-5.94071,-1.010532),(4.644436,-5.437138,-0.464746),(4.218363,-4.913805,0.0),(3.347688,-4.809754,0.0),(3.088751,-4.459892,0.309076),(2.94167,-4.311907,0.594671),(2.919142,-4.389039,0.900436),(3.001066,-4.679176,1.265055),(3.139892,-5.136752,1.709894),(3.272146,-5.689906,2.230912),(3.333334,-6.251767,2.796999),(3.272683,-6.734094,3.355317),(3.064265,-7.061142,3.842467),(2.711919,-7.181546,4.198872),(2.246983,-7.076398,4.382902),(1.719528,-6.762212,4.381286),(1.185416,-6.288329,4.213219),(0.692443,-5.729171,3.92704),(0.269044,-5.172553,3.590137),(-0.081658,-4.705891,3.274379),(-0.381015,-4.402473,3.040431),(-0.667521,-4.309949,2.924601),(-0.984861,-4.44285,2.93129),(-1.368431,-4.780305,3.032754),(-1.833776,-5.269317,3.176194),(-2.36997,-5.833088,3.296427),(-2.939707,-6.383079,3.331093),(-3.486284,-6.832915,3.234799),(-3.945857,-7.111951,2.98887),(-4.2621,-7.176364,2.604515),(-4.399708,-7.01604,2.118788),(-4.353428,-6.656155,1.584518),(-4.15034,-6.15323,1.056806),(-3.844716,-5.586248,0.579498),(-3.506538,-5.044251,0.175004),(-3.206306,-4.612359,-0.16002),(-2.999654,-4.3584,-0.452125),(-2.915352,-4.322257,-0.74234),(-2.949487,-4.509606,-1.073525),(-3.067127,-4.891025,-1.47705),(-3.211031,-5.406613,-1.96222),(-3.315274,-5.975398,-2.511222),(-3.320533,-6.508053,-3.081005),(-3.187412,-6.920927,-3.611776),(-2.904694,-7.149178,-4.040183),(-2.490696,-7.156961,-4.314012),(-1.987548,-6.943052,-4.404859),(-1.449975,-6.541047,-4.315632),(-0.931455,-6.014078,-4.080972),(-0.471234,-5.444905,-3.760354),(-0.085424,-4.922916,-3.425385),(0.235626,-4.530086,-3.144217),(0.523107,-4.32811,-2.966688),(0.819777,-4.348708,-2.913661),(1.166822,-4.588643,-2.973015),(1.59091,-5.010236,-3.103185),(2.094781,-5.547275,-3.243355),(2.653859,-6.115421,-3.327833),(3.219882,-6.625447,-3.301182),(3.730815,-6.997255,-3.130526),(4.124729,-7.172454,-2.812192),(4.35433,-7.123528,-2.371241),(4.398594,-6.858162,-1.854163),(4.268621,-6.41803,-1.316695),(4.006171,-5.872255,-0.809865),(3.675113,-5.306549,-0.367751),(3.347688,-4.809754,0.0),(2.634628,-4.74669,0.0),(2.536552,-4.592814,0.25382),(2.54548,-4.678846,0.51458),(2.647303,-4.991275,0.816585),(2.803335,-5.481034,1.181705),(2.959427,-6.071208,1.611618),(3.058454,-6.669112,2.085219),(3.053219,-7.180846,2.561955),(2.916741,-7.526044,2.990387),(2.647568,-7.650493,3.319946),(2.268967,-7.534648,3.513048),(1.822332,-7.196704,3.55459),(1.356549,-6.689733,3.456432),(0.916006,-6.093353,3.255679),(0.530222,-5.501225,3.007041),(0.207656,-5.006342,2.770976),(-0.064849,-4.686422,2.600368),(-0.316903,-4.59171,2.528828),(-0.585073,-4.737078,2.563371),(-0.901497,-5.099699,2.683169),(-1.283549,-5.622621,2.844636),(-1.727224,-6.223723,2.99164),(-2.206016,-6.808603,3.068381),(-2.675679,-7.285406,3.031913),(-3.083823,-7.579252,2.86137),(-3.382043,-7.643992,2.561798),(-3.537649,-7.469461,2.161812),(-3.542089,-7.083067,1.70578),(-3.413945,-6.545492,1.242574),(-3.195643,-5.941162,0.813711),(-2.94455,-5.364985,0.443819),(-2.72047,-4.907448,0.135773),(-2.572434,-4.640407,-0.128385),(-2.527874,-4.605799,-0.381016),(-2.586705,-4.809059,-0.658656),(-2.721702,-5.218267,-0.990618),(-2.885031,-5.769156,-1.389358),(-3.019397,-6.375212,-1.845115),(-3.071121,-6.941254,-2.326284),(-3.002096,-7.378387,-2.785538),(-2.797815,-7.617961,-3.17031),(-2.469673,-7.62235,-3.435106),(-2.051133,-7.390866,-3.552666),(-1.588818,-6.959862,-3.521182),(-1.130831,-6.397027,-3.365749),(-0.715211,-5.790753,-3.133545),(-0.361387,-5.236253,-2.883802),(-0.066706,-4.82061,-2.674825),(0.191179,-4.6091,-2.551106),(0.446728,-4.634941,-2.533518),(0.73572,-4.894073,-2.614903),(1.084026,-5.345801,-2.762053),(1.498841,-5.919182,-2.923597),(1.964673,-6.524168,-3.041909),(2.445208,-7.065748,-3.066194),(2.890707,-7.458867,-2.963695),(3.249206,-7.641787,-2.726408),(3.478839,-7.585781,-2.371832),(3.558232,-7.299645,-1.93771),(3.492417,-6.828315,-1.472177),(3.312693,-6.245813,-1.02183),(3.070355,-5.64362,-0.620686),(2.825671,-5.116307,-0.282751),(2.634628,-4.74669,0.0),(2.071254,-4.826593,0.0),(2.101304,-4.921072,0.210267),(2.209522,-5.252949,0.446665),(2.366138,-5.770104,0.729857),(2.527361,-6.391319,1.065372),(2.645295,-7.019033,1.440551),(2.678635,-7.554666,1.826263),(2.601645,-7.914098,2.18304),(2.409345,-8.04088,2.47018),(2.117769,-7.915103,2.655599),(1.759346,-7.556518,2.724),(1.374626,-7.021441,2.681306),(1.002438,-6.393905,2.554169),(0.670915,-5.772462,2.384573),(0.391572,-5.254708,2.220715),(0.157843,-4.921956,2.106272),(-0.051636,-4.826464,2.070555),(-0.265905,-4.983227,2.121875),(-0.512562,-5.367628,2.245679),(-0.80901,-5.919296,2.407897),(-1.156338,-6.551594,2.562708),(-1.537419,-7.165221,2.662888),(-1.919815,-7.663807,2.670301),(-2.262826,-7.969052,2.564094),(-2.527005,-8.033018,2.344718),(-2.683815,-7.845658,2.032911),(-2.72303,-7.436397,1.664009),(-2.656001,-6.869509,1.279063),(-2.513893,-6.234022,0.914982),(-2.341204,-5.629737,0.596144),(-2.186015,-5.151557,0.329489),(-2.089246,-4.874577,0.10427),(-2.075411,-4.842298,-0.103579),(-2.147074,-5.059789,-0.323619),(-2.284295,-5.492892,-0.581653),(-2.449199,-6.073591,-0.891436),(-2.594595,-6.710688,-1.249491),(-2.674596,-7.304128,-1.634412),(-2.654758,-7.760713,-2.010901),(-2.519367,-8.008738,-2.337631),(-2.274241,-8.009251,-2.577028),(-1.944456,-7.76217,-2.704573),(-1.56769,-7.306301,-2.715319),(-1.184867,-6.713235,-2.625935),(-0.830443,-6.076113,-2.471688),(-0.524724,-5.494993,-2.298965),(-0.270063,-5.061138,-2.155049),(-0.05181,-4.842684,-2.077513),(0.156303,-4.873939,-2.085723),(0.383769,-5.149995,-2.176461),(0.654066,-5.627497,-2.324688),(0.976969,-6.231455,-2.489275),(1.344393,-6.867019,-2.622336),(1.730908,-7.434375,-2.679969),(2.098857,-7.844421,-2.631884),(2.406912,-8.03276,-2.467685),(2.619962,-7.969815,-2.198409),(2.717923,-7.66547,-1.853048),(2.701257,-7.167523,-1.471026),(2.59176,-6.554174,-1.092518),(2.428323,-5.921748,-0.749038),(2.258575,-5.369567,-0.456581),(2.128324,-4.98435,-0.212971),(2.071254,-4.826593,0.0),(1.604267,-5.113169,0.0),(1.705004,-5.46138,0.170611),(1.845436,-6.00081,0.373063),(1.99278,-6.646745,0.614691),(2.109887,-7.297742,0.889392),(2.163449,-7.851563,1.178152),(2.131223,-8.221231,1.453043),(2.006591,-8.348692,1.68373),(1.799452,-8.213928,1.844887),(1.533299,-7.838103,1.922696),(1.239279,-7.28024,1.918779),(0.948705,-6.62795,1.850517),(0.685887,-5.983673,1.747613),(0.463004,-5.448591,1.645612),(0.278228,-5.106739,1.577908),(0.11751,-5.011802,1.568066),(-0.040508,-5.17869,1.62432),(-0.21774,-5.581195,1.737521),(-0.429797,-6.156103,1.883063),(-0.680807,-6.813127,2.02632),(-0.961246,-7.449083,2.130339),(-1.249375,-7.964095,2.163982),(-1.51599,-8.277282,2.108614),(-1.731316,-8.339459,1.961819),(-1.87237,-8.140861,1.737305),(-1.928955,-7.712677,1.461127),(-1.906755,-7.122152,1.165194),(-1.826691,-6.462028,0.879688),(-1.720623,-5.835975,0.626256),(-1.62433,-5.342313,0.413605),(-1.56941,-5.05857,0.23655),(-1.575994,-5.029308,0.078655),(-1.648009,-5.259122,-0.082249),(-1.77211,-5.711921,-0.267103),(-1.92056,-6.316593,-0.489035),(-2.057379,-6.978176,-0.748825),(-2.14633,-7.592771,-1.033618),(-2.158869,-8.063856,-1.319258),(-2.08021,-8.317448,-1.575698),(-1.912127,-8.313723,-1.774195),(-1.6719,-8.053264,-1.894493),(-1.387729,-7.576977,-1.930214),(-1.091804,-6.95966,-1.89106),(-0.812741,-6.298263,-1.80122),(-0.569243,-5.696655,-1.694266),(-0.366488,-5.249318,-1.605691),(-0.1961,-5.026506,-1.564837),(-0.039605,-5.063209,-1.588098),(0.125526,-5.353665,-1.675026),(0.318845,-5.852257,-1.808262),(0.550707,-6.480684,-1.95733),(0.818462,-7.140251,-2.085407),(1.106074,-7.727376,-2.157476),(1.387309,-8.149852,-2.147974),(1.631741,-8.341331,-2.046139),(1.812117,-8.27174,-1.857872),(1.91125,-7.95201,-1.603729),(1.926719,-7.432352,-1.313615),(1.872149,-6.794378,-1.019518),(1.774669,-6.138281,-0.748086),(1.669088,-5.567098,-0.514845),(1.5901,-5.170533,-0.321446),(1.564356,-5.010865,-0.156537),(1.604267,-5.113169,0.0),(1.153765,-5.614286,0.0),(1.261787,-6.170592,0.126261),(1.376708,-6.834651,0.278307),(1.473241,-7.502174,0.454435),(1.527885,-8.068329,0.644057),(1.524002,-8.444201,0.829927),(1.455284,-8.570762,0.992196),(1.326809,-8.428135,1.113325),(1.153486,-8.03872,1.182611),(0.956323,-7.463673,1.199192),(0.757427,-6.793303,1.172726),(0.574981,-6.132892,1.121542),(0.419406,-5.586154,1.068628),(0.291596,-5.238954,1.036392),(0.183632,-5.145818,1.041427),(0.081723,-5.321374,1.090512),(-0.029398,-5.738051,1.178833),(-0.161763,-6.33041,1.290836),(-0.320353,-7.005423,1.403556),(-0.501161,-7.657081,1.49163),(-0.691644,-8.183043,1.532841),(-0.87347,-8.500707,1.512894),(-1.0269,-8.560186,1.428331),(-1.135723,-8.352137,1.28693),(-1.191495,-7.909236,1.105545),(-1.196019,-7.301037,0.905949),(-1.161391,-6.623058,0.709711),(-1.107548,-5.981774,0.533367),(-1.057846,-5.477896,0.385024),(-1.033702,-5.190557,0.263213),(-1.049556,-5.164884,0.158195),(-1.109356,-5.404907,0.055366),(-1.205418,-5.872933,-0.06016),(-1.319942,-6.495459,-0.198949),(-1.428848,-7.174718,-0.363829),(-1.507051,-7.804034,-0.548522),(-1.533921,-8.284576,-0.738697),(-1.497691,-8.540875,-0.91522),(-1.39778,-8.532679,-1.058777),(-1.244528,-8.261277,-1.154753),(-1.056467,-7.769291,-1.197123),(-0.85581,-7.133986,-1.190359),(-0.663282,-6.455135,-1.148838),(-0.493552,-5.839351,-1.093823),(-0.352343,-5.383341,-1.048696),(-0.235904,-5.158719,-1.033564),(-0.132897,-5.200763,-1.060489),(-0.028193,-5.502869,-1.130517),(0.092415,-6.017593,-1.233189),(0.237812,-6.664098,-1.348701),(0.408585,-7.340852,-1.452199),(0.596249,-7.941572,-1.519218),(0.784898,-8.371918,-1.531),(0.954886,-8.564304,-1.478453),(1.087637,-8.488516,-1.363854),(1.170381,-8.156457,-1.199932),(1.199631,-7.620276,-1.00661),(1.182492,-6.964179,-0.80621),(1.135431,-6.291203,-0.618323),(1.080732,-5.70704,-0.455567),(1.041462,-5.303429,-0.321248),(1.03611,-5.143757,-0.209454),(1.074175,-5.2531,-0.107487),(1.153765,-5.614286,0.0),(0.63836,-6.277503,0.0),(0.703526,-6.952883,0.070398),(0.760513,-7.630022,0.153741),(0.797063,-8.202577,0.245861),(0.804048,-8.58063,0.338935),(0.777395,-8.704809,0.423347),(0.718845,-8.555611,0.4901),(0.635382,-8.156468,0.533148),(0.537503,-7.570064,0.551074),(0.436749,-6.888493,0.547666),(0.343101,-6.218793,0.531224),(0.262864,-5.66614,0.512735),(0.197547,-5.317326,0.503341),(0.143965,-5.227131,0.51168),(0.095526,-5.409721,0.541757),(0.044353,-5.83642,0.591846),(-0.016327,-6.440216,0.654702),(-0.090108,-7.126285,0.719048),(-0.176203,-7.78688,0.771995),(-0.269403,-8.318258,0.801837),(-0.361231,-8.636966,0.80057),(-0.441993,-8.692952,0.765555),(-0.503228,-8.477424,0.699947),(-0.539925,-8.02423,0.61181),(-0.551965,-7.404542,0.512149),(-0.544376,-6.715682,0.412349),(-0.52634,-6.065833,0.321639),(-0.509135,-5.557052,0.245186),(-0.503515,-5.269243,0.183265),(-0.517128,-5.247604,0.131677),(-0.552599,-5.495535,0.083291),(-0.606751,-5.974098,0.030282),(-0.671146,-6.608136,-0.033496),(-0.733853,-7.298075,-0.11061),(-0.782014,-7.935561,-0.199125),(-0.804639,-8.42048,-0.292865),(-0.794953,-8.676676,-0.382829),(-0.751778,-8.663913,-0.459402),(-0.679627,-8.384197,-0.514797),(-0.587516,-7.881455,-0.545135),(-0.486796,-7.234643,-0.551607),(-0.388537,-6.54534,-0.540423),(-0.301094,-5.9218,-0.52151),(-0.22844,-5.461949,-0.506274),(-0.169643,-5.238004,-0.504916),(-0.119593,-5.285137,-0.523971),(-0.070758,-5.595944,-0.564636),(-0.01552,-6.121614,-0.622314),(0.05152,-6.779592,-0.687489),(0.131846,-7.466545,-0.747738),(0.222389,-8.074588,-0.790416),(0.316094,-8.508228,-0.805394),(0.403582,-8.699365,-0.787215),(0.475467,-8.617981,-0.736168),(0.524775,-8.276856,-0.658047),(0.548828,-7.729563,-0.562685),(0.550128,-7.062055,-0.461612),(0.535979,-6.37916,-0.365424),(0.516917,-5.788126,-0.281498),(0.504299,-5.381774,-0.21258),(0.50762,-5.22392,-0.15658),(0.532194,-5.339355,-0.107585),(0.57776,-5.70995,-0.057814),(0.63836,-6.277503,0.0),(0.0,-7.0,0.0),(0.0,-7.679761,0.0),(0.0,-8.252767,0.0),(0.0,-8.629029,0.0),(0.0,-8.749456,0.0),(0.0,-8.595135,0.0),(0.0,-8.190302,0.0),(0.0,-7.598535,0.0),(0.0,-6.91277,0.0),(0.0,-6.240703,0.0),(0.0,-5.687883,0.0),(0.0,-5.341127,0.0),(0.0,-5.254893,0.0),(0.0,-5.442724,0.0),(0.0,-5.875122,0.0),(0.0,-6.484178,0.0),(0.0,-7.174244,0.0),(0.0,-7.836944,0.0),(0.0,-8.368205,0.0),(0.0,-8.684592,0.0),(0.0,-8.736419,0.0),(0.0,-8.515544,0.0),(0.0,-8.056658,0.0),(0.0,-7.431825,0.0),(0.0,-6.739176,0.0),(0.0,-6.087488,0.0),(0.0,-5.579108,0.0),(0.0,-5.293876,0.0),(0.0,-5.276586,0.0),(0.0,-5.529955,0.0),(0.0,-6.01419,0.0),(0.0,-6.653244,0.0),(0.0,-7.346756,0.0),(0.0,-7.98581,0.0),(0.0,-8.470045,0.0),(0.0,-8.723414,0.0),(0.0,-8.706124,0.0),(0.0,-8.420892,0.0),(0.0,-7.912512,0.0),(0.0,-7.260824,0.0),(0.0,-6.568175,0.0),(0.0,-5.943342,0.0),(0.0,-5.484456,0.0),(0.0,-5.263581,0.0),(0.0,-5.315408,0.0),(0.0,-5.631795,0.0),(0.0,-6.163056,0.0),(0.0,-6.825756,0.0),(0.0,-7.515822,0.0),(0.0,-8.124878,0.0),(0.0,-8.557276,0.0),(0.0,-8.745107,0.0),(0.0,-8.658873,0.0),(0.0,-8.312117,0.0),(0.0,-7.759297,0.0),(0.0,-7.08723,0.0),(0.0,-6.401465,0.0),(0.0,-5.809698,0.0),(0.0,-5.404865,0.0),(0.0,-5.250544,0.0),(0.0,-5.370971,0.0),(0.0,-5.747233,0.0),(0.0,-6.320239,0.0),(0.0,-7.0,0.0)]))),
    Shape(
      appearance=Appearance(
        material=Material(diffuseColor=(1.0,1.0,0.0))),
      geometry=IndexedFaceSet(ccw=False,coordIndex=[0,1,65,64,-1,1,2,66,65,-1,2,3,67,66,-1,3,4,68,67,-1,4,5,69,68,-1,5,6,70,69,-1,6,7,71,70,-1,7,8,72,71,-1,8,9,73,72,-1,9,10,74,73,-1,10,11,75,74,-1,11,12,76,75,-1,12,13,77,76,-1,13,14,78,77,-1,14,15,79,78,-1,15,16,80,79,-1,16,17,81,80,-1,17,18,82,81,-1,18,19,83,82,-1,19,20,84,83,-1,20,21,85,84,-1,21,22,86,85,-1,22,23,87,86,-1,23,24,88,87,-1,24,25,89,88,-1,25,26,90,89,-1,26,27,91,90,-1,27,28,92,91,-1,28,29,93,92,-1,29,30,94,93,-1,30,31,95,94,-1,31,32,96,95,-1,32,33,97,96,-1,33,34,98,97,-1,34,35,99,98,-1,35,36,100,99,-1,36,37,101,100,-1,37,38,102,101,-1,38,39,103,102,-1,39,40,104,103,-1,40,41,105,104,-1,41,42,106,105,-1,42,43,107,106,-1,43,44,108,107,-1,44,45,109,108,-1,45,46,110,109,-1,46,47,111,110,-1,47,48,112,111,-1,48,49,113,112,-1,49,50,114,113,-1,50,51,115,114,-1,51,52,116,115,-1,52,53,117,116,-1,53,54,118,117,-1,54,55,119,118,-1,55,56,120,119,-1,56,57,121,120,-1,57,58,122,121,-1,58,59,123,122,-1,59,60,124,123,-1,60,61,125,124,-1,61,62,126,125,-1,62,63,127,126,-1,63,0,64,127,-1,64,65,129,128,-1,65,66,130,129,-1,66,67,131,130,-1,67,68,132,131,-1,68,69,133,132,-1,69,70,134,133,-1,70,71,135,134,-1,71,72,136,135,-1,72,73,137,136,-1,73,74,138,137,-1,74,75,139,138,-1,75,76,140,139,-1,76,77,141,140,-1,77,78,142,141,-1,78,79,143,142,-1,79,80,144,143,-1,80,81,145,144,-1,81,82,146,145,-1,82,83,147,146,-1,83,84,148,147,-1,84,85,149,148,-1,85,86,150,149,-1,86,87,151,150,-1,87,88,152,151,-1,88,89,153,152,-1,89,90,154,153,-1,90,91,155,154,-1,91,92,156,155,-1,92,93,157,156,-1,93,94,158,157,-1,94,95,159,158,-1,95,96,160,159,-1,96,97,161,160,-1,97,98,162,161,-1,98,99,163,162,-1,99,100,164,163,-1,100,101,165,164,-1,101,102,166,165,-1,102,103,167,166,-1,103,104,168,167,-1,104,105,169,168,-1,105,106,170,169,-1,106,107,171,170,-1,107,108,172,171,-1,108,109,173,172,-1,109,110,174,173,-1,110,111,175,174,-1,111,112,176,175,-1,112,113,177,176,-1,113,114,178,177,-1,114,115,179,178,-1,115,116,180,179,-1,116,117,181,180,-1,117,118,182,181,-1,118,119,183,182,-1,119,120,184,183,-1,120,121,185,184,-1,121,122,186,185,-1,122,123,187,186,-1,123,124,188,187,-1,124,125,189,188,-1,125,126,190,189,-1,126,127,191,190,-1,127,64,128,191,-1,128,129,193,192,-1,129,130,194,193,-1,130,131,195,194,-1,131,132,196,195,-1,132,133,197,196,-1,133,134,198,197,-1,134,135,199,198,-1,135,136,200,199,-1,136,137,201,200,-1,137,138,202,201,-1,138,139,203,202,-1,139,140,204,203,-1,140,141,205,204,-1,141,142,206,205,-1,142,143,207,206,-1,143,144,208,207,-1,144,145,209,208,-1,145,146,210,209,-1,146,147,211,210,-1,147,148,212,211,-1,148,149,213,212,-1,149,150,214,213,-1,150,151,215,214,-1,151,152,216,215,-1,152,153,217,216,-1,153,154,218,217,-1,154,155,219,218,-1,155,156,220,219,-1,156,157,221,220,-1,157,158,222,221,-1,158,159,223,222,-1,159,160,224,223,-1,160,161,225,224,-1,161,162,226,225,-1,162,163,227,226,-1,163,164,228,227,-1,164,165,229,228,-1,165,166,230,229,-1,166,167,231,230,-1,167,168,232,231,-1,168,169,233,232,-1,169,170,234,233,-1,170,171,235,234,-1,171,172,236,235,-1,172,173,237,236,-1,173,174,238,237,-1,174,175,239,238,-1,175,176,240,239,-1,176,177,241,240,-1,177,178,242,241,-1,178,179,243,242,-1,179,180,244,243,-1,180,181,245,244,-1,181,182,246,245,-1,182,183,247,246,-1,183,184,248,247,-1,184,185,249,248,-1,185,186,250,249,-1,186,187,251,250,-1,187,188,252,251,-1,188,189,253,252,-1,189,190,254,253,-1,190,191,255,254,-1,191,128,192,255,-1,192,193,257,256,-1,193,194,258,257,-1,194,195,259,258,-1,195,196,260,259,-1,196,197,261,260,-1,197,198,262,261,-1,198,199,263,262,-1,199,200,264,263,-1,200,201,265,264,-1,201,202,266,265,-1,202,203,267,266,-1,203,204,268,267,-1,204,205,269,268,-1,205,206,270,269,-1,206,207,271,270,-1,207,208,272,271,-1,208,209,273,272,-1,209,210,274,273,-1,210,211,275,274,-1,211,212,276,275,-1,212,213,277,276,-1,213,214,278,277,-1,214,215,279,278,-1,215,216,280,279,-1,216,217,281,280,-1,217,218,282,281,-1,218,219,283,282,-1,219,220,284,283,-1,220,221,285,284,-1,221,222,286,285,-1,222,223,287,286,-1,223,224,288,287,-1,224,225,289,288,-1,225,226,290,289,-1,226,227,291,290,-1,227,228,292,291,-1,228,229,293,292,-1,229,230,294,293,-1,230,231,295,294,-1,231,232,296,295,-1,232,233,297,296,-1,233,234,298,297,-1,234,235,299,298,-1,235,236,300,299,-1,236,237,301,300,-1,237,238,302,301,-1,238,239,303,302,-1,239,240,304,303,-1,240,241,305,304,-1,241,242,306,305,-1,242,243,307,306,-1,243,244,308,307,-1,244,245,309,308,-1,245,246,310,309,-1,246,247,311,310,-1,247,248,312,311,-1,248,249,313,312,-1,249,250,314,313,-1,250,251,315,314,-1,251,252,316,315,-1,252,253,317,316,-1,253,254,318,317,-1,254,255,319,318,-1,255,192,256,319,-1,256,257,321,320,-1,257,258,322,321,-1,258,259,323,322,-1,259,260,324,323,-1,260,261,325,324,-1,261,262,326,325,-1,262,263,327,326,-1,263,264,328,327,-1,264,265,329,328,-1,265,266,330,329,-1,266,267,331,330,-1,267,268,332,331,-1,268,269,333,332,-1,269,270,334,333,-1,270,271,335,334,-1,271,272,336,335,-1,272,273,337,336,-1,273,274,338,337,-1,274,275,339,338,-1,275,276,340,339,-1,276,277,341,340,-1,277,278,342,341,-1,278,279,343,342,-1,279,280,344,343,-1,280,281,345,344,-1,281,282,346,345,-1,282,283,347,346,-1,283,284,348,347,-1,284,285,349,348,-1,285,286,350,349,-1,286,287,351,350,-1,287,288,352,351,-1,288,289,353,352,-1,289,290,354,353,-1,290,291,355,354,-1,291,292,356,355,-1,292,293,357,356,-1,293,294,358,357,-1,294,295,359,358,-1,295,296,360,359,-1,296,297,361,360,-1,297,298,362,361,-1,298,299,363,362,-1,299,300,364,363,-1,300,301,365,364,-1,301,302,366,365,-1,302,303,367,366,-1,303,304,368,367,-1,304,305,369,368,-1,305,306,370,369,-1,306,307,371,370,-1,307,308,372,371,-1,308,309,373,372,-1,309,310,374,373,-1,310,311,375,374,-1,311,312,376,375,-1,312,313,377,376,-1,313,314,378,377,-1,314,315,379,378,-1,315,316,380,379,-1,316,317,381,380,-1,317,318,382,381,-1,318,319,383,382,-1,319,256,320,383,-1,320,321,385,384,-1,321,322,386,385,-1,322,323,387,386,-1,323,324,388,387,-1,324,325,389,388,-1,325,326,390,389,-1,326,327,391,390,-1,327,328,392,391,-1,328,329,393,392,-1,329,330,394,393,-1,330,331,395,394,-1,331,332,396,395,-1,332,333,397,396,-1,333,334,398,397,-1,334,335,399,398,-1,335,336,400,399,-1,336,337,401,400,-1,337,338,402,401,-1,338,339,403,402,-1,339,340,404,403,-1,340,341,405,404,-1,341,342,406,405,-1,342,343,407,406,-1,343,344,408,407,-1,344,345,409,408,-1,345,346,410,409,-1,346,347,411,410,-1,347,348,412,411,-1,348,349,413,412,-1,349,350,414,413,-1,350,351,415,414,-1,351,352,416,415,-1,352,353,417,416,-1,353,354,418,417,-1,354,355,419,418,-1,355,356,420,419,-1,356,357,421,420,-1,357,358,422,421,-1,358,359,423,422,-1,359,360,424,423,-1,360,361,425,424,-1,361,362,426,425,-1,362,363,427,426,-1,363,364,428,427,-1,364,365,429,428,-1,365,366,430,429,-1,366,367,431,430,-1,367,368,432,431,-1,368,369,433,432,-1,369,370,434,433,-1,370,371,435,434,-1,371,372,436,435,-1,372,373,437,436,-1,373,374,438,437,-1,374,375,439,438,-1,375,376,440,439,-1,376,377,441,440,-1,377,378,442,441,-1,378,379,443,442,-1,379,380,444,443,-1,380,381,445,444,-1,381,382,446,445,-1,382,383,447,446,-1,383,320,384,447,-1,384,385,449,448,-1,385,386,450,449,-1,386,387,451,450,-1,387,388,452,451,-1,388,389,453,452,-1,389,390,454,453,-1,390,391,455,454,-1,391,392,456,455,-1,392,393,457,456,-1,393,394,458,457,-1,394,395,459,458,-1,395,396,460,459,-1,396,397,461,460,-1,397,398,462,461,-1,398,399,463,462,-1,399,400,464,463,-1,400,401,465,464,-1,401,402,466,465,-1,402,403,467,466,-1,403,404,468,467,-1,404,405,469,468,-1,405,406,470,469,-1,406,407,471,470,-1,407,408,472,471,-1,408,409,473,472,-1,409,410,474,473,-1,410,411,475,474,-1,411,412,476,475,-1,412,413,477,476,-1,413,414,478,477,-1,414,415,479,478,-1,415,416,480,479,-1,416,417,481,480,-1,417,418,482,481,-1,418,419,483,482,-1,419,420,484,483,-1,420,421,485,484,-1,421,422,486,485,-1,422,423,487,486,-1,423,424,488,487,-1,424,425,489,488,-1,425,426,490,489,-1,426,427,491,490,-1,427,428,492,491,-1,428,429,493,492,-1,429,430,494,493,-1,430,431,495,494,-1,431,432,496,495,-1,432,433,497,496,-1,433,434,498,497,-1,434,435,499,498,-1,435,436,500,499,-1,436,437,501,500,-1,437,438,502,501,-1,438,439,503,502,-1,439,440,504,503,-1,440,441,505,504,-1,441,442,506,505,-1,442,443,507,506,-1,443,444,508,507,-1,444,445,509,508,-1,445,446,510,509,-1,446,447,511,510,-1,447,384,448,511,-1,448,449,513,512,-1,449,450,514,513,-1,450,451,515,514,-1,451,452,516,515,-1,452,453,517,516,-1,453,454,518,517,-1,454,455,519,518,-1,455,456,520,519,-1,456,457,521,520,-1,457,458,522,521,-1,458,459,523,522,-1,459,460,524,523,-1,460,461,525,524,-1,461,462,526,525,-1,462,463,527,526,-1,463,464,528,527,-1,464,465,529,528,-1,465,466,530,529,-1,466,467,531,530,-1,467,468,532,531,-1,468,469,533,532,-1,469,470,534,533,-1,470,471,535,534,-1,471,472,536,535,-1,472,473,537,536,-1,473,474,538,537,-1,474,475,539,538,-1,475,476,540,539,-1,476,477,541,540,-1,477,478,542,541,-1,478,479,543,542,-1,479,480,544,543,-1,480,481,545,544,-1,481,482,546,545,-1,482,483,547,546,-1,483,484,548,547,-1,484,485,549,548,-1,485,486,550,549,-1,486,487,551,550,-1,487,488,552,551,-1,488,489,553,552,-1,489,490,554,553,-1,490,491,555,554,-1,491,492,556,555,-1,492,493,557,556,-1,493,494,558,557,-1,494,495,559,558,-1,495,496,560,559,-1,496,497,561,560,-1,497,498,562,561,-1,498,499,563,562,-1,499,500,564,563,-1,500,501,565,564,-1,501,502,566,565,-1,502,503,567,566,-1,503,504,568,567,-1,504,505,569,568,-1,505,506,570,569,-1,506,507,571,570,-1,507,508,572,571,-1,508,509,573,572,-1,509,510,574,573,-1,510,511,575,574,-1,511,448,512,575,-1,512,513,577,576,-1,513,514,578,577,-1,514,515,579,578,-1,515,516,580,579,-1,516,517,581,580,-1,517,518,582,581,-1,518,519,583,582,-1,519,520,584,583,-1,520,521,585,584,-1,521,522,586,585,-1,522,523,587,586,-1,523,524,588,587,-1,524,525,589,588,-1,525,526,590,589,-1,526,527,591,590,-1,527,528,592,591,-1,528,529,593,592,-1,529,530,594,593,-1,530,531,595,594,-1,531,532,596,595,-1,532,533,597,596,-1,533,534,598,597,-1,534,535,599,598,-1,535,536,600,599,-1,536,537,601,600,-1,537,538,602,601,-1,538,539,603,602,-1,539,540,604,603,-1,540,541,605,604,-1,541,542,606,605,-1,542,543,607,606,-1,543,544,608,607,-1,544,545,609,608,-1,545,546,610,609,-1,546,547,611,610,-1,547,548,612,611,-1,548,549,613,612,-1,549,550,614,613,-1,550,551,615,614,-1,551,552,616,615,-1,552,553,617,616,-1,553,554,618,617,-1,554,555,619,618,-1,555,556,620,619,-1,556,557,621,620,-1,557,558,622,621,-1,558,559,623,622,-1,559,560,624,623,-1,560,561,625,624,-1,561,562,626,625,-1,562,563,627,626,-1,563,564,628,627,-1,564,565,629,628,-1,565,566,630,629,-1,566,567,631,630,-1,567,568,632,631,-1,568,569,633,632,-1,569,570,634,633,-1,570,571,635,634,-1,571,572,636,635,-1,572,573,637,636,-1,573,574,638,637,-1,574,575,639,638,-1,575,512,576,639,-1,576,577,641,640,-1,577,578,642,641,-1,578,579,643,642,-1,579,580,644,643,-1,580,581,645,644,-1,581,582,646,645,-1,582,583,647,646,-1,583,584,648,647,-1,584,585,649,648,-1,585,586,650,649,-1,586,587,651,650,-1,587,588,652,651,-1,588,589,653,652,-1,589,590,654,653,-1,590,591,655,654,-1,591,592,656,655,-1,592,593,657,656,-1,593,594,658,657,-1,594,595,659,658,-1,595,596,660,659,-1,596,597,661,660,-1,597,598,662,661,-1,598,599,663,662,-1,599,600,664,663,-1,600,601,665,664,-1,601,602,666,665,-1,602,603,667,666,-1,603,604,668,667,-1,604,605,669,668,-1,605,606,670,669,-1,606,607,671,670,-1,607,608,672,671,-1,608,609,673,672,-1,609,610,674,673,-1,610,611,675,674,-1,611,612,676,675,-1,612,613,677,676,-1,613,614,678,677,-1,614,615,679,678,-1,615,616,680,679,-1,616,617,681,680,-1,617,618,682,681,-1,618,619,683,682,-1,619,620,684,683,-1,620,621,685,684,-1,621,622,686,685,-1,622,623,687,686,-1,623,624,688,687,-1,624,625,689,688,-1,625,626,690,689,-1,626,627,691,690,-1,627,628,692,691,-1,628,629,693,692,-1,629,630,694,693,-1,630,631,695,694,-1,631,632,696,695,-1,632,633,697,696,-1,633,634,698,697,-1,634,635,699,698,-1,635,636,700,699,-1,636,637,701,700,-1,637,638,702,701,-1,638,639,703,702,-1,639,576,640,703,-1,640,641,705,704,-1,641,642,706,705,-1,642,643,707,706,-1,643,644,708,707,-1,644,645,709,708,-1,645,646,710,709,-1,646,647,711,710,-1,647,648,712,711,-1,648,649,713,712,-1,649,650,714,713,-1,650,651,715,714,-1,651,652,716,715,-1,652,653,717,716,-1,653,654,718,717,-1,654,655,719,718,-1,655,656,720,719,-1,656,657,721,720,-1,657,658,722,721,-1,658,659,723,722,-1,659,660,724,723,-1,660,661,725,724,-1,661,662,726,725,-1,662,663,727,726,-1,663,664,728,727,-1,664,665,729,728,-1,665,666,730,729,-1,666,667,731,730,-1,667,668,732,731,-1,668,669,733,732,-1,669,670,734,733,-1,670,671,735,734,-1,671,672,736,735,-1,672,673,737,736,-1,673,674,738,737,-1,674,675,739,738,-1,675,676,740,739,-1,676,677,741,740,-1,677,678,742,741,-1,678,679,743,742,-1,679,680,744,743,-1,680,681,745,744,-1,681,682,746,745,-1,682,683,747,746,-1,683,684,748,747,-1,684,685,749,748,-1,685,686,750,749,-1,686,687,751,750,-1,687,688,752,751,-1,688,689,753,752,-1,689,690,754,753,-1,690,691,755,754,-1,691,692,756,755,-1,692,693,757,756,-1,693,694,758,757,-1,694,695,759,758,-1,695,696,760,759,-1,696,697,761,760,-1,697,698,762,761,-1,698,699,763,762,-1,699,700,764,763,-1,700,701,765,764,-1,701,702,766,765,-1,702,703,767,766,-1,703,640,704,767,-1,704,705,769,768,-1,705,706,770,769,-1,706,707,771,770,-1,707,708,772,771,-1,708,709,773,772,-1,709,710,774,773,-1,710,711,775,774,-1,711,712,776,775,-1,712,713,777,776,-1,713,714,778,777,-1,714,715,779,778,-1,715,716,780,779,-1,716,717,781,780,-1,717,718,782,781,-1,718,719,783,782,-1,719,720,784,783,-1,720,721,785,784,-1,721,722,786,785,-1,722,723,787,786,-1,723,724,788,787,-1,724,725,789,788,-1,725,726,790,789,-1,726,727,791,790,-1,727,728,792,791,-1,728,729,793,792,-1,729,730,794,793,-1,730,731,795,794,-1,731,732,796,795,-1,732,733,797,796,-1,733,734,798,797,-1,734,735,799,798,-1,735,736,800,799,-1,736,737,801,800,-1,737,738,802,801,-1,738,739,803,802,-1,739,740,804,803,-1,740,741,805,804,-1,741,742,806,805,-1,742,743,807,806,-1,743,744,808,807,-1,744,745,809,808,-1,745,746,810,809,-1,746,747,811,810,-1,747,748,812,811,-1,748,749,813,812,-1,749,750,814,813,-1,750,751,815,814,-1,751,752,816,815,-1,752,753,817,816,-1,753,754,818,817,-1,754,755,819,818,-1,755,756,820,819,-1,756,757,821,820,-1,757,758,822,821,-1,758,759,823,822,-1,759,760,824,823,-1,760,761,825,824,-1,761,762,826,825,-1,762,763,827,826,-1,763,764,828,827,-1,764,765,829,828,-1,765,766,830,829,-1,766,767,831,830,-1,767,704,768,831,-1,768,769,833,832,-1,769,770,834,833,-1,770,771,835,834,-1,771,772,836,835,-1,772,773,837,836,-1,773,774,838,837,-1,774,775,839,838,-1,775,776,840,839,-1,776,777,841,840,-1,777,778,842,841,-1,778,779,843,842,-1,779,780,844,843,-1,780,781,845,844,-1,781,782,846,845,-1,782,783,847,846,-1,783,784,848,847,-1,784,785,849,848,-1,785,786,850,849,-1,786,787,851,850,-1,787,788,852,851,-1,788,789,853,852,-1,789,790,854,853,-1,790,791,855,854,-1,791,792,856,855,-1,792,793,857,856,-1,793,794,858,857,-1,794,795,859,858,-1,795,796,860,859,-1,796,797,861,860,-1,797,798,862,861,-1,798,799,863,862,-1,799,800,864,863,-1,800,801,865,864,-1,801,802,866,865,-1,802,803,867,866,-1,803,804,868,867,-1,804,805,869,868,-1,805,806,870,869,-1,806,807,871,870,-1,807,808,872,871,-1,808,809,873,872,-1,809,810,874,873,-1,810,811,875,874,-1,811,812,876,875,-1,812,813,877,876,-1,813,814,878,877,-1,814,815,879,878,-1,815,816,880,879,-1,816,817,881,880,-1,817,818,882,881,-1,818,819,883,882,-1,819,820,884,883,-1,820,821,885,884,-1,821,822,886,885,-1,822,823,887,886,-1,823,824,888,887,-1,824,825,889,888,-1,825,826,890,889,-1,826,827,891,890,-1,827,828,892,891,-1,828,829,893,892,-1,829,830,894,893,-1,830,831,895,894,-1,831,768,832,895,-1,832,833,897,896,-1,833,834,898,897,-1,834,835,899,898,-1,835,836,900,899,-1,836,837,901,900,-1,837,838,902,901,-1,838,839,903,902,-1,839,840,904,903,-1,840,841,905,904,-1,841,842,906,905,-1,842,843,907,906,-1,843,844,908,907,-1,844,845,909,908,-1,845,846,910,909,-1,846,847,911,910,-1,847,848,912,911,-1,848,849,913,912,-1,849,850,914,913,-1,850,851,915,914,-1,851,852,916,915,-1,852,853,917,916,-1,853,854,918,917,-1,854,855,919,918,-1,855,856,920,919,-1,856,857,921,920,-1,857,858,922,921,-1,858,859,923,922,-1,859,860,924,923,-1,860,861,925,924,-1,861,862,926,925,-1,862,863,927,926,-1,863,864,928,927,-1,864,865,929,928,-1,865,866,930,929,-1,866,867,931,930,-1,867,868,932,931,-1,868,869,933,932,-1,869,870,934,933,-1,870,871,935,934,-1,871,872,936,935,-1,872,873,937,936,-1,873,874,938,937,-1,874,875,939,938,-1,875,876,940,939,-1,876,877,941,940,-1,877,878,942,941,-1,878,879,943,942,-1,879,880,944,943,-1,880,881,945,944,-1,881,882,946,945,-1,882,883,947,946,-1,883,884,948,947,-1,884,885,949,948,-1,885,886,950,949,-1,886,887,951,950,-1,887,888,952,951,-1,888,889,953,952,-1,889,890,954,953,-1,890,891,955,954,-1,891,892,956,955,-1,892,893,957,956,-1,893,894,958,957,-1,894,895,959,958,-1,895,832,896,959,-1,896,897,961,960,-1,897,898,962,961,-1,898,899,963,962,-1,899,900,964,963,-1,900,901,965,964,-1,901,902,966,965,-1,902,903,967,966,-1,903,904,968,967,-1,904,905,969,968,-1,905,906,970,969,-1,906,907,971,970,-1,907,908,972,971,-1,908,909,973,972,-1,909,910,974,973,-1,910,911,975,974,-1,911,912,976,975,-1,912,913,977,976,-1,913,914,978,977,-1,914,915,979,978,-1,915,916,980,979,-1,916,917,981,980,-1,917,918,982,981,-1,918,919,983,982,-1,919,920,984,983,-1,920,921,985,984,-1,921,922,986,985,-1,922,923,987,986,-1,923,924,988,987,-1,924,925,989,988,-1,925,926,990,989,-1,926,927,991,990,-1,927,928,992,991,-1,928,929,993,992,-1,929,930,994,993,-1,930,931,995,994,-1,931,932,996,995,-1,932,933,997,996,-1,933,934,998,997,-1,934,935,999,998,-1,935,936,1000,999,-1,936,937,1001,1000,-1,937,938,1002,1001,-1,938,939,1003,1002,-1,939,940,1004,1003,-1,940,941,1005,1004,-1,941,942,1006,1005,-1,942,943,1007,1006,-1,943,944,1008,1007,-1,944,945,1009,1008,-1,945,946,1010,1009,-1,946,947,1011,1010,-1,947,948,1012,1011,-1,948,949,1013,1012,-1,949,950,1014,1013,-1,950,951,1015,1014,-1,951,952,1016,1015,-1,952,953,1017,1016,-1,953,954,1018,1017,-1,954,955,1019,1018,-1,955,956,1020,1019,-1,956,957,1021,1020,-1,957,958,1022,1021,-1,958,959,1023,1022,-1,959,896,960,1023,-1,960,961,1025,1024,-1,961,962,1026,1025,-1,962,963,1027,1026,-1,963,964,1028,1027,-1,964,965,1029,1028,-1,965,966,1030,1029,-1,966,967,1031,1030,-1,967,968,1032,1031,-1,968,969,1033,1032,-1,969,970,1034,1033,-1,970,971,1035,1034,-1,971,972,1036,1035,-1,972,973,1037,1036,-1,973,974,1038,1037,-1,974,975,1039,1038,-1,975,976,1040,1039,-1,976,977,1041,1040,-1,977,978,1042,1041,-1,978,979,1043,1042,-1,979,980,1044,1043,-1,980,981,1045,1044,-1,981,982,1046,1045,-1,982,983,1047,1046,-1,983,984,1048,1047,-1,984,985,1049,1048,-1,985,986,1050,1049,-1,986,987,1051,1050,-1,987,988,1052,1051,-1,988,989,1053,1052,-1,989,990,1054,1053,-1,990,991,1055,1054,-1,991,992,1056,1055,-1,992,993,1057,1056,-1,993,994,1058,1057,-1,994,995,1059,1058,-1,995,996,1060,1059,-1,996,997,1061,1060,-1,997,998,1062,1061,-1,998,999,1063,1062,-1,999,1000,1064,1063,-1,1000,1001,1065,1064,-1,1001,1002,1066,1065,-1,1002,1003,1067,1066,-1,1003,1004,1068,1067,-1,1004,1005,1069,1068,-1,1005,1006,1070,1069,-1,1006,1007,1071,1070,-1,1007,1008,1072,1071,-1,1008,1009,1073,1072,-1,1009,1010,1074,1073,-1,1010,1011,1075,1074,-1,1011,1012,1076,1075,-1,1012,1013,1077,1076,-1,1013,1014,1078,1077,-1,1014,1015,1079,1078,-1,1015,1016,1080,1079,-1,1016,1017,1081,1080,-1,1017,1018,1082,1081,-1,1018,1019,1083,1082,-1,1019,1020,1084,1083,-1,1020,1021,1085,1084,-1,1021,1022,1086,1085,-1,1022,1023,1087,1086,-1,1023,960,1024,1087,-1,1024,1025,1089,1088,-1,1025,1026,1090,1089,-1,1026,1027,1091,1090,-1,1027,1028,1092,1091,-1,1028,1029,1093,1092,-1,1029,1030,1094,1093,-1,1030,1031,1095,1094,-1,1031,1032,1096,1095,-1,1032,1033,1097,1096,-1,1033,1034,1098,1097,-1,1034,1035,1099,1098,-1,1035,1036,1100,1099,-1,1036,1037,1101,1100,-1,1037,1038,1102,1101,-1,1038,1039,1103,1102,-1,1039,1040,1104,1103,-1,1040,1041,1105,1104,-1,1041,1042,1106,1105,-1,1042,1043,1107,1106,-1,1043,1044,1108,1107,-1,1044,1045,1109,1108,-1,1045,1046,1110,1109,-1,1046,1047,1111,1110,-1,1047,1048,1112,1111,-1,1048,1049,1113,1112,-1,1049,1050,1114,1113,-1,1050,1051,1115,1114,-1,1051,1052,1116,1115,-1,1052,1053,1117,1116,-1,1053,1054,1118,1117,-1,1054,1055,1119,1118,-1,1055,1056,1120,1119,-1,1056,1057,1121,1120,-1,1057,1058,1122,1121,-1,1058,1059,1123,1122,-1,1059,1060,1124,1123,-1,1060,1061,1125,1124,-1,1061,1062,1126,1125,-1,1062,1063,1127,1126,-1,1063,1064,1128,1127,-1,1064,1065,1129,1128,-1,1065,1066,1130,1129,-1,1066,1067,1131,1130,-1,1067,1068,1132,1131,-1,1068,1069,1133,1132,-1,1069,1070,1134,1133,-1,1070,1071,1135,1134,-1,1071,1072,1136,1135,-1,1072,1073,1137,1136,-1,1073,1074,1138,1137,-1,1074,1075,1139,1138,-1,1075,1076,1140,1139,-1,1076,1077,1141,1140,-1,1077,1078,1142,1141,-1,1078,1079,1143,1142,-1,1079,1080,1144,1143,-1,1080,1081,1145,1144,-1,1081,1082,1146,1145,-1,1082,1083,1147,1146,-1,1083,1084,1148,1147,-1,1084,1085,1149,1148,-1,1085,1086,1150,1149,-1,1086,1087,1151,1150,-1,1087,1024,1088,1151,-1,1088,1089,1153,1152,-1,1089,1090,1154,1153,-1,1090,1091,1155,1154,-1,1091,1092,1156,1155,-1,1092,1093,1157,1156,-1,1093,1094,1158,1157,-1,1094,1095,1159,1158,-1,1095,1096,1160,1159,-1,1096,1097,1161,1160,-1,1097,1098,1162,1161,-1,1098,1099,1163,1162,-1,1099,1100,1164,1163,-1,1100,1101,1165,1164,-1,1101,1102,1166,1165,-1,1102,1103,1167,1166,-1,1103,1104,1168,1167,-1,1104,1105,1169,1168,-1,1105,1106,1170,1169,-1,1106,1107,1171,1170,-1,1107,1108,1172,1171,-1,1108,1109,1173,1172,-1,1109,1110,1174,1173,-1,1110,1111,1175,1174,-1,1111,1112,1176,1175,-1,1112,1113,1177,1176,-1,1113,1114,1178,1177,-1,1114,1115,1179,1178,-1,1115,1116,1180,1179,-1,1116,1117,1181,1180,-1,1117,1118,1182,1181,-1,1118,1119,1183,1182,-1,1119,1120,1184,1183,-1,1120,1121,1185,1184,-1,1121,1122,1186,1185,-1,1122,1123,1187,1186,-1,1123,1124,1188,1187,-1,1124,1125,1189,1188,-1,1125,1126,1190,1189,-1,1126,1127,1191,1190,-1,1127,1128,1192,1191,-1,1128,1129,1193,1192,-1,1129,1130,1194,1193,-1,1130,1131,1195,1194,-1,1131,1132,1196,1195,-1,1132,1133,1197,1196,-1,1133,1134,1198,1197,-1,1134,1135,1199,1198,-1,1135,1136,1200,1199,-1,1136,1137,1201,1200,-1,1137,1138,1202,1201,-1,1138,1139,1203,1202,-1,1139,1140,1204,1203,-1,1140,1141,1205,1204,-1,1141,1142,1206,1205,-1,1142,1143,1207,1206,-1,1143,1144,1208,1207,-1,1144,1145,1209,1208,-1,1145,1146,1210,1209,-1,1146,1147,1211,1210,-1,1147,1148,1212,1211,-1,1148,1149,1213,1212,-1,1149,1150,1214,1213,-1,1150,1151,1215,1214,-1,1151,1088,1152,1215,-1,1152,1153,1217,1216,-1,1153,1154,1218,1217,-1,1154,1155,1219,1218,-1,1155,1156,1220,1219,-1,1156,1157,1221,1220,-1,1157,1158,1222,1221,-1,1158,1159,1223,1222,-1,1159,1160,1224,1223,-1,1160,1161,1225,1224,-1,1161,1162,1226,1225,-1,1162,1163,1227,1226,-1,1163,1164,1228,1227,-1,1164,1165,1229,1228,-1,1165,1166,1230,1229,-1,1166,1167,1231,1230,-1,1167,1168,1232,1231,-1,1168,1169,1233,1232,-1,1169,1170,1234,1233,-1,1170,1171,1235,1234,-1,1171,1172,1236,1235,-1,1172,1173,1237,1236,-1,1173,1174,1238,1237,-1,1174,1175,1239,1238,-1,1175,1176,1240,1239,-1,1176,1177,1241,1240,-1,1177,1178,1242,1241,-1,1178,1179,1243,1242,-1,1179,1180,1244,1243,-1,1180,1181,1245,1244,-1,1181,1182,1246,1245,-1,1182,1183,1247,1246,-1,1183,1184,1248,1247,-1,1184,1185,1249,1248,-1,1185,1186,1250,1249,-1,1186,1187,1251,1250,-1,1187,1188,1252,1251,-1,1188,1189,1253,1252,-1,1189,1190,1254,1253,-1,1190,1191,1255,1254,-1,1191,1192,1256,1255,-1,1192,1193,1257,1256,-1,1193,1194,1258,1257,-1,1194,1195,1259,1258,-1,1195,1196,1260,1259,-1,1196,1197,1261,1260,-1,1197,1198,1262,1261,-1,1198,1199,1263,1262,-1,1199,1200,1264,1263,-1,1200,1201,1265,1264,-1,1201,1202,1266,1265,-1,1202,1203,1267,1266,-1,1203,1204,1268,1267,-1,1204,1205,1269,1268,-1,1205,1206,1270,1269,-1,1206,1207,1271,1270,-1,1207,1208,1272,1271,-1,1208,1209,1273,1272,-1,1209,1210,1274,1273,-1,1210,1211,1275,1274,-1,1211,1212,1276,1275,-1,1212,1213,1277,1276,-1,1213,1214,1278,1277,-1,1214,1215,1279,1278,-1,1215,1152,1216,1279,-1,1216,1217,1281,1280,-1,1217,1218,1282,1281,-1,1218,1219,1283,1282,-1,1219,1220,1284,1283,-1,1220,1221,1285,1284,-1,1221,1222,1286,1285,-1,1222,1223,1287,1286,-1,1223,1224,1288,1287,-1,1224,1225,1289,1288,-1,1225,1226,1290,1289,-1,1226,1227,1291,1290,-1,1227,1228,1292,1291,-1,1228,1229,1293,1292,-1,1229,1230,1294,1293,-1,1230,1231,1295,1294,-1,1231,1232,1296,1295,-1,1232,1233,1297,1296,-1,1233,1234,1298,1297,-1,1234,1235,1299,1298,-1,1235,1236,1300,1299,-1,1236,1237,1301,1300,-1,1237,1238,1302,1301,-1,1238,1239,1303,1302,-1,1239,1240,1304,1303,-1,1240,1241,1305,1304,-1,1241,1242,1306,1305,-1,1242,1243,1307,1306,-1,1243,1244,1308,1307,-1,1244,1245,1309,1308,-1,1245,1246,1310,1309,-1,1246,1247,1311,1310,-1,1247,1248,1312,1311,-1,1248,1249,1313,1312,-1,1249,1250,1314,1313,-1,1250,1251,1315,1314,-1,1251,1252,1316,1315,-1,1252,1253,1317,1316,-1,1253,1254,1318,1317,-1,1254,1255,1319,1318,-1,1255,1256,1320,1319,-1,1256,1257,1321,1320,-1,1257,1258,1322,1321,-1,1258,1259,1323,1322,-1,1259,1260,1324,1323,-1,1260,1261,1325,1324,-1,1261,1262,1326,1325,-1,1262,1263,1327,1326,-1,1263,1264,1328,1327,-1,1264,1265,1329,1328,-1,1265,1266,1330,1329,-1,1266,1267,1331,1330,-1,1267,1268,1332,1331,-1,1268,1269,1333,1332,-1,1269,1270,1334,1333,-1,1270,1271,1335,1334,-1,1271,1272,1336,1335,-1,1272,1273,1337,1336,-1,1273,1274,1338,1337,-1,1274,1275,1339,1338,-1,1275,1276,1340,1339,-1,1276,1277,1341,1340,-1,1277,1278,1342,1341,-1,1278,1279,1343,1342,-1,1279,1216,1280,1343,-1,1280,1281,1345,1344,-1,1281,1282,1346,1345,-1,1282,1283,1347,1346,-1,1283,1284,1348,1347,-1,1284,1285,1349,1348,-1,1285,1286,1350,1349,-1,1286,1287,1351,1350,-1,1287,1288,1352,1351,-1,1288,1289,1353,1352,-1,1289,1290,1354,1353,-1,1290,1291,1355,1354,-1,1291,1292,1356,1355,-1,1292,1293,1357,1356,-1,1293,1294,1358,1357,-1,1294,1295,1359,1358,-1,1295,1296,1360,1359,-1,1296,1297,1361,1360,-1,1297,1298,1362,1361,-1,1298,1299,1363,1362,-1,1299,1300,1364,1363,-1,1300,1301,1365,1364,-1,1301,1302,1366,1365,-1,1302,1303,1367,1366,-1,1303,1304,1368,1367,-1,1304,1305,1369,1368,-1,1305,1306,1370,1369,-1,1306,1307,1371,1370,-1,1307,1308,1372,1371,-1,1308,1309,1373,1372,-1,1309,1310,1374,1373,-1,1310,1311,1375,1374,-1,1311,1312,1376,1375,-1,1312,1313,1377,1376,-1,1313,1314,1378,1377,-1,1314,1315,1379,1378,-1,1315,1316,1380,1379,-1,1316,1317,1381,1380,-1,1317,1318,1382,1381,-1,1318,1319,1383,1382,-1,1319,1320,1384,1383,-1,1320,1321,1385,1384,-1,1321,1322,1386,1385,-1,1322,1323,1387,1386,-1,1323,1324,1388,1387,-1,1324,1325,1389,1388,-1,1325,1326,1390,1389,-1,1326,1327,1391,1390,-1,1327,1328,1392,1391,-1,1328,1329,1393,1392,-1,1329,1330,1394,1393,-1,1330,1331,1395,1394,-1,1331,1332,1396,1395,-1,1332,1333,1397,1396,-1,1333,1334,1398,1397,-1,1334,1335,1399,1398,-1,1335,1336,1400,1399,-1,1336,1337,1401,1400,-1,1337,1338,1402,1401,-1,1338,1339,1403,1402,-1,1339,1340,1404,1403,-1,1340,1341,1405,1404,-1,1341,1342,1406,1405,-1,1342,1343,1407,1406,-1,1343,1280,1344,1407,-1,1344,1345,1409,1408,-1,1345,1346,1410,1409,-1,1346,1347,1411,1410,-1,1347,1348,1412,1411,-1,1348,1349,1413,1412,-1,1349,1350,1414,1413,-1,1350,1351,1415,1414,-1,1351,1352,1416,1415,-1,1352,1353,1417,1416,-1,1353,1354,1418,1417,-1,1354,1355,1419,1418,-1,1355,1356,1420,1419,-1,1356,1357,1421,1420,-1,1357,1358,1422,1421,-1,1358,1359,1423,1422,-1,1359,1360,1424,1423,-1,1360,1361,1425,1424,-1,1361,1362,1426,1425,-1,1362,1363,1427,1426,-1,1363,1364,1428,1427,-1,1364,1365,1429,1428,-1,1365,1366,1430,1429,-1,1366,1367,1431,1430,-1,1367,1368,1432,1431,-1,1368,1369,1433,1432,-1,1369,1370,1434,1433,-1,1370,1371,1435,1434,-1,1371,1372,1436,1435,-1,1372,1373,1437,1436,-1,1373,1374,1438,1437,-1,1374,1375,1439,1438,-1,1375,1376,1440,1439,-1,1376,1377,1441,1440,-1,1377,1378,1442,1441,-1,1378,1379,1443,1442,-1,1379,1380,1444,1443,-1,1380,1381,1445,1444,-1,1381,1382,1446,1445,-1,1382,1383,1447,1446,-1,1383,1384,1448,1447,-1,1384,1385,1449,1448,-1,1385,1386,1450,1449,-1,1386,1387,1451,1450,-1,1387,1388,1452,1451,-1,1388,1389,1453,1452,-1,1389,1390,1454,1453,-1,1390,1391,1455,1454,-1,1391,1392,1456,1455,-1,1392,1393,1457,1456,-1,1393,1394,1458,1457,-1,1394,1395,1459,1458,-1,1395,1396,1460,1459,-1,1396,1397,1461,1460,-1,1397,1398,1462,1461,-1,1398,1399,1463,1462,-1,1399,1400,1464,1463,-1,1400,1401,1465,1464,-1,1401,1402,1466,1465,-1,1402,1403,1467,1466,-1,1403,1404,1468,1467,-1,1404,1405,1469,1468,-1,1405,1406,1470,1469,-1,1406,1407,1471,1470,-1,1407,1344,1408,1471,-1,1408,1409,1473,1472,-1,1409,1410,1474,1473,-1,1410,1411,1475,1474,-1,1411,1412,1476,1475,-1,1412,1413,1477,1476,-1,1413,1414,1478,1477,-1,1414,1415,1479,1478,-1,1415,1416,1480,1479,-1,1416,1417,1481,1480,-1,1417,1418,1482,1481,-1,1418,1419,1483,1482,-1,1419,1420,1484,1483,-1,1420,1421,1485,1484,-1,1421,1422,1486,1485,-1,1422,1423,1487,1486,-1,1423,1424,1488,1487,-1,1424,1425,1489,1488,-1,1425,1426,1490,1489,-1,1426,1427,1491,1490,-1,1427,1428,1492,1491,-1,1428,1429,1493,1492,-1,1429,1430,1494,1493,-1,1430,1431,1495,1494,-1,1431,1432,1496,1495,-1,1432,1433,1497,1496,-1,1433,1434,1498,1497,-1,1434,1435,1499,1498,-1,1435,1436,1500,1499,-1,1436,1437,1501,1500,-1,1437,1438,1502,1501,-1,1438,1439,1503,1502,-1,1439,1440,1504,1503,-1,1440,1441,1505,1504,-1,1441,1442,1506,1505,-1,1442,1443,1507,1506,-1,1443,1444,1508,1507,-1,1444,1445,1509,1508,-1,1445,1446,1510,1509,-1,1446,1447,1511,1510,-1,1447,1448,1512,1511,-1,1448,1449,1513,1512,-1,1449,1450,1514,1513,-1,1450,1451,1515,1514,-1,1451,1452,1516,1515,-1,1452,1453,1517,1516,-1,1453,1454,1518,1517,-1,1454,1455,1519,1518,-1,1455,1456,1520,1519,-1,1456,1457,1521,1520,-1,1457,1458,1522,1521,-1,1458,1459,1523,1522,-1,1459,1460,1524,1523,-1,1460,1461,1525,1524,-1,1461,1462,1526,1525,-1,1462,1463,1527,1526,-1,1463,1464,1528,1527,-1,1464,1465,1529,1528,-1,1465,1466,1530,1529,-1,1466,1467,1531,1530,-1,1467,1468,1532,1531,-1,1468,1469,1533,1532,-1,1469,1470,1534,1533,-1,1470,1471,1535,1534,-1,1471,1408,1472,1535,-1,1472,1473,1537,1536,-1,1473,1474,1538,1537,-1,1474,1475,1539,1538,-1,1475,1476,1540,1539,-1,1476,1477,1541,1540,-1,1477,1478,1542,1541,-1,1478,1479,1543,1542,-1,1479,1480,1544,1543,-1,1480,1481,1545,1544,-1,1481,1482,1546,1545,-1,1482,1483,1547,1546,-1,1483,1484,1548,1547,-1,1484,1485,1549,1548,-1,1485,1486,1550,1549,-1,1486,1487,1551,1550,-1,1487,1488,1552,1551,-1,1488,1489,1553,1552,-1,1489,1490,1554,1553,-1,1490,1491,1555,1554,-1,1491,1492,1556,1555,-1,1492,1493,1557,1556,-1,1493,1494,1558,1557,-1,1494,1495,1559,1558,-1,1495,1496,1560,1559,-1,1496,1497,1561,1560,-1,1497,1498,1562,1561,-1,1498,1499,1563,1562,-1,1499,1500,1564,1563,-1,1500,1501,1565,1564,-1,1501,1502,1566,1565,-1,1502,1503,1567,1566,-1,1503,1504,1568,1567,-1,1504,1505,1569,1568,-1,1505,1506,1570,1569,-1,1506,1507,1571,1570,-1,1507,1508,1572,1571,-1,1508,1509,1573,1572,-1,1509,1510,1574,1573,-1,1510,1511,1575,1574,-1,1511,1512,1576,1575,-1,1512,1513,1577,1576,-1,1513,1514,1578,1577,-1,1514,1515,1579,1578,-1,1515,1516,1580,1579,-1,1516,1517,1581,1580,-1,1517,1518,1582,1581,-1,1518,1519,1583,1582,-1,1519,1520,1584,1583,-1,1520,1521,1585,1584,-1,1521,1522,1586,1585,-1,1522,1523,1587,1586,-1,1523,1524,1588,1587,-1,1524,1525,1589,1588,-1,1525,1526,1590,1589,-1,1526,1527,1591,1590,-1,1527,1528,1592,1591,-1,1528,1529,1593,1592,-1,1529,1530,1594,1593,-1,1530,1531,1595,1594,-1,1531,1532,1596,1595,-1,1532,1533,1597,1596,-1,1533,1534,1598,1597,-1,1534,1535,1599,1598,-1,1535,1472,1536,1599,-1,1536,1537,1601,1600,-1,1537,1538,1602,1601,-1,1538,1539,1603,1602,-1,1539,1540,1604,1603,-1,1540,1541,1605,1604,-1,1541,1542,1606,1605,-1,1542,1543,1607,1606,-1,1543,1544,1608,1607,-1,1544,1545,1609,1608,-1,1545,1546,1610,1609,-1,1546,1547,1611,1610,-1,1547,1548,1612,1611,-1,1548,1549,1613,1612,-1,1549,1550,1614,1613,-1,1550,1551,1615,1614,-1,1551,1552,1616,1615,-1,1552,1553,1617,1616,-1,1553,1554,1618,1617,-1,1554,1555,1619,1618,-1,1555,1556,1620,1619,-1,1556,1557,1621,1620,-1,1557,1558,1622,1621,-1,1558,1559,1623,1622,-1,1559,1560,1624,1623,-1,1560,1561,1625,1624,-1,1561,1562,1626,1625,-1,1562,1563,1627,1626,-1,1563,1564,1628,1627,-1,1564,1565,1629,1628,-1,1565,1566,1630,1629,-1,1566,1567,1631,1630,-1,1567,1568,1632,1631,-1,1568,1569,1633,1632,-1,1569,1570,1634,1633,-1,1570,1571,1635,1634,-1,1571,1572,1636,1635,-1,1572,1573,1637,1636,-1,1573,1574,1638,1637,-1,1574,1575,1639,1638,-1,1575,1576,1640,1639,-1,1576,1577,1641,1640,-1,1577,1578,1642,1641,-1,1578,1579,1643,1642,-1,1579,1580,1644,1643,-1,1580,1581,1645,1644,-1,1581,1582,1646,1645,-1,1582,1583,1647,1646,-1,1583,1584,1648,1647,-1,1584,1585,1649,1648,-1,1585,1586,1650,1649,-1,1586,1587,1651,1650,-1,1587,1588,1652,1651,-1,1588,1589,1653,1652,-1,1589,1590,1654,1653,-1,1590,1591,1655,1654,-1,1591,1592,1656,1655,-1,1592,1593,1657,1656,-1,1593,1594,1658,1657,-1,1594,1595,1659,1658,-1,1595,1596,1660,1659,-1,1596,1597,1661,1660,-1,1597,1598,1662,1661,-1,1598,1599,1663,1662,-1,1599,1536,1600,1663,-1,1600,1601,1665,1664,-1,1601,1602,1666,1665,-1,1602,1603,1667,1666,-1,1603,1604,1668,1667,-1,1604,1605,1669,1668,-1,1605,1606,1670,1669,-1,1606,1607,1671,1670,-1,1607,1608,1672,1671,-1,1608,1609,1673,1672,-1,1609,1610,1674,1673,-1,1610,1611,1675,1674,-1,1611,1612,1676,1675,-1,1612,1613,1677,1676,-1,1613,1614,1678,1677,-1,1614,1615,1679,1678,-1,1615,1616,1680,1679,-1,1616,1617,1681,1680,-1,1617,1618,1682,1681,-1,1618,1619,1683,1682,-1,1619,1620,1684,1683,-1,1620,1621,1685,1684,-1,1621,1622,1686,1685,-1,1622,1623,1687,1686,-1,1623,1624,1688,1687,-1,1624,1625,1689,1688,-1,1625,1626,1690,1689,-1,1626,1627,1691,1690,-1,1627,1628,1692,1691,-1,1628,1629,1693,1692,-1,1629,1630,1694,1693,-1,1630,1631,1695,1694,-1,1631,1632,1696,1695,-1,1632,1633,1697,1696,-1,1633,1634,1698,1697,-1,1634,1635,1699,1698,-1,1635,1636,1700,1699,-1,1636,1637,1701,1700,-1,1637,1638,1702,1701,-1,1638,1639,1703,1702,-1,1639,1640,1704,1703,-1,1640,1641,1705,1704,-1,1641,1642,1706,1705,-1,1642,1643,1707,1706,-1,1643,1644,1708,1707,-1,1644,1645,1709,1708,-1,1645,1646,1710,1709,-1,1646,1647,1711,1710,-1,1647,1648,1712,1711,-1,1648,1649,1713,1712,-1,1649,1650,1714,1713,-1,1650,1651,1715,1714,-1,1651,1652,1716,1715,-1,1652,1653,1717,1716,-1,1653,1654,1718,1717,-1,1654,1655,1719,1718,-1,1655,1656,1720,1719,-1,1656,1657,1721,1720,-1,1657,1658,1722,1721,-1,1658,1659,1723,1722,-1,1659,1660,1724,1723,-1,1660,1661,1725,1724,-1,1661,1662,1726,1725,-1,1662,1663,1727,1726,-1,1663,1600,1664,1727,-1,1664,1665,1729,1728,-1,1665,1666,1730,1729,-1,1666,1667,1731,1730,-1,1667,1668,1732,1731,-1,1668,1669,1733,1732,-1,1669,1670,1734,1733,-1,1670,1671,1735,1734,-1,1671,1672,1736,1735,-1,1672,1673,1737,1736,-1,1673,1674,1738,1737,-1,1674,1675,1739,1738,-1,1675,1676,1740,1739,-1,1676,1677,1741,1740,-1,1677,1678,1742,1741,-1,1678,1679,1743,1742,-1,1679,1680,1744,1743,-1,1680,1681,1745,1744,-1,1681,1682,1746,1745,-1,1682,1683,1747,1746,-1,1683,1684,1748,1747,-1,1684,1685,1749,1748,-1,1685,1686,1750,1749,-1,1686,1687,1751,1750,-1,1687,1688,1752,1751,-1,1688,1689,1753,1752,-1,1689,1690,1754,1753,-1,1690,1691,1755,1754,-1,1691,1692,1756,1755,-1,1692,1693,1757,1756,-1,1693,1694,1758,1757,-1,1694,1695,1759,1758,-1,1695,1696,1760,1759,-1,1696,1697,1761,1760,-1,1697,1698,1762,1761,-1,1698,1699,1763,1762,-1,1699,1700,1764,1763,-1,1700,1701,1765,1764,-1,1701,1702,1766,1765,-1,1702,1703,1767,1766,-1,1703,1704,1768,1767,-1,1704,1705,1769,1768,-1,1705,1706,1770,1769,-1,1706,1707,1771,1770,-1,1707,1708,1772,1771,-1,1708,1709,1773,1772,-1,1709,1710,1774,1773,-1,1710,1711,1775,1774,-1,1711,1712,1776,1775,-1,1712,1713,1777,1776,-1,1713,1714,1778,1777,-1,1714,1715,1779,1778,-1,1715,1716,1780,1779,-1,1716,1717,1781,1780,-1,1717,1718,1782,1781,-1,1718,1719,1783,1782,-1,1719,1720,1784,1783,-1,1720,1721,1785,1784,-1,1721,1722,1786,1785,-1,1722,1723,1787,1786,-1,1723,1724,1788,1787,-1,1724,1725,1789,1788,-1,1725,1726,1790,1789,-1,1726,1727,1791,1790,-1,1727,1664,1728,1791,-1,1728,1729,1793,1792,-1,1729,1730,1794,1793,-1,1730,1731,1795,1794,-1,1731,1732,1796,1795,-1,1732,1733,1797,1796,-1,1733,1734,1798,1797,-1,1734,1735,1799,1798,-1,1735,1736,1800,1799,-1,1736,1737,1801,1800,-1,1737,1738,1802,1801,-1,1738,1739,1803,1802,-1,1739,1740,1804,1803,-1,1740,1741,1805,1804,-1,1741,1742,1806,1805,-1,1742,1743,1807,1806,-1,1743,1744,1808,1807,-1,1744,1745,1809,1808,-1,1745,1746,1810,1809,-1,1746,1747,1811,1810,-1,1747,1748,1812,1811,-1,1748,1749,1813,1812,-1,1749,1750,1814,1813,-1,1750,1751,1815,1814,-1,1751,1752,1816,1815,-1,1752,1753,1817,1816,-1,1753,1754,1818,1817,-1,1754,1755,1819,1818,-1,1755,1756,1820,1819,-1,1756,1757,1821,1820,-1,1757,1758,1822,1821,-1,1758,1759,1823,1822,-1,1759,1760,1824,1823,-1,1760,1761,1825,1824,-1,1761,1762,1826,1825,-1,1762,1763,1827,1826,-1,1763,1764,1828,1827,-1,1764,1765,1829,1828,-1,1765,1766,1830,1829,-1,1766,1767,1831,1830,-1,1767,1768,1832,1831,-1,1768,1769,1833,1832,-1,1769,1770,1834,1833,-1,1770,1771,1835,1834,-1,1771,1772,1836,1835,-1,1772,1773,1837,1836,-1,1773,1774,1838,1837,-1,1774,1775,1839,1838,-1,1775,1776,1840,1839,-1,1776,1777,1841,1840,-1,1777,1778,1842,1841,-1,1778,1779,1843,1842,-1,1779,1780,1844,1843,-1,1780,1781,1845,1844,-1,1781,1782,1846,1845,-1,1782,1783,1847,1846,-1,1783,1784,1848,1847,-1,1784,1785,1849,1848,-1,1785,1786,1850,1849,-1,1786,1787,1851,1850,-1,1787,1788,1852,1851,-1,1788,1789,1853,1852,-1,1789,1790,1854,1853,-1,1790,1791,1855,1854,-1,1791,1728,1792,1855,-1,1792,1793,1857,1856,-1,1793,1794,1858,1857,-1,1794,1795,1859,1858,-1,1795,1796,1860,1859,-1,1796,1797,1861,1860,-1,1797,1798,1862,1861,-1,1798,1799,1863,1862,-1,1799,1800,1864,1863,-1,1800,1801,1865,1864,-1,1801,1802,1866,1865,-1,1802,1803,1867,1866,-1,1803,1804,1868,1867,-1,1804,1805,1869,1868,-1,1805,1806,1870,1869,-1,1806,1807,1871,1870,-1,1807,1808,1872,1871,-1,1808,1809,1873,1872,-1,1809,1810,1874,1873,-1,1810,1811,1875,1874,-1,1811,1812,1876,1875,-1,1812,1813,1877,1876,-1,1813,1814,1878,1877,-1,1814,1815,1879,1878,-1,1815,1816,1880,1879,-1,1816,1817,1881,1880,-1,1817,1818,1882,1881,-1,1818,1819,1883,1882,-1,1819,1820,1884,1883,-1,1820,1821,1885,1884,-1,1821,1822,1886,1885,-1,1822,1823,1887,1886,-1,1823,1824,1888,1887,-1,1824,1825,1889,1888,-1,1825,1826,1890,1889,-1,1826,1827,1891,1890,-1,1827,1828,1892,1891,-1,1828,1829,1893,1892,-1,1829,1830,1894,1893,-1,1830,1831,1895,1894,-1,1831,1832,1896,1895,-1,1832,1833,1897,1896,-1,1833,1834,1898,1897,-1,1834,1835,1899,1898,-1,1835,1836,1900,1899,-1,1836,1837,1901,1900,-1,1837,1838,1902,1901,-1,1838,1839,1903,1902,-1,1839,1840,1904,1903,-1,1840,1841,1905,1904,-1,1841,1842,1906,1905,-1,1842,1843,1907,1906,-1,1843,1844,1908,1907,-1,1844,1845,1909,1908,-1,1845,1846,1910,1909,-1,1846,1847,1911,1910,-1,1847,1848,1912,1911,-1,1848,1849,1913,1912,-1,1849,1850,1914,1913,-1,1850,1851,1915,1914,-1,1851,1852,1916,1915,-1,1852,1853,1917,1916,-1,1853,1854,1918,1917,-1,1854,1855,1919,1918,-1,1855,1792,1856,1919,-1,1856,1857,1921,1920,-1,1857,1858,1922,1921,-1,1858,1859,1923,1922,-1,1859,1860,1924,1923,-1,1860,1861,1925,1924,-1,1861,1862,1926,1925,-1,1862,1863,1927,1926,-1,1863,1864,1928,1927,-1,1864,1865,1929,1928,-1,1865,1866,1930,1929,-1,1866,1867,1931,1930,-1,1867,1868,1932,1931,-1,1868,1869,1933,1932,-1,1869,1870,1934,1933,-1,1870,1871,1935,1934,-1,1871,1872,1936,1935,-1,1872,1873,1937,1936,-1,1873,1874,1938,1937,-1,1874,1875,1939,1938,-1,1875,1876,1940,1939,-1,1876,1877,1941,1940,-1,1877,1878,1942,1941,-1,1878,1879,1943,1942,-1,1879,1880,1944,1943,-1,1880,1881,1945,1944,-1,1881,1882,1946,1945,-1,1882,1883,1947,1946,-1,1883,1884,1948,1947,-1,1884,1885,1949,1948,-1,1885,1886,1950,1949,-1,1886,1887,1951,1950,-1,1887,1888,1952,1951,-1,1888,1889,1953,1952,-1,1889,1890,1954,1953,-1,1890,1891,1955,1954,-1,1891,1892,1956,1955,-1,1892,1893,1957,1956,-1,1893,1894,1958,1957,-1,1894,1895,1959,1958,-1,1895,1896,1960,1959,-1,1896,1897,1961,1960,-1,1897,1898,1962,1961,-1,1898,1899,1963,1962,-1,1899,1900,1964,1963,-1,1900,1901,1965,1964,-1,1901,1902,1966,1965,-1,1902,1903,1967,1966,-1,1903,1904,1968,1967,-1,1904,1905,1969,1968,-1,1905,1906,1970,1969,-1,1906,1907,1971,1970,-1,1907,1908,1972,1971,-1,1908,1909,1973,1972,-1,1909,1910,1974,1973,-1,1910,1911,1975,1974,-1,1911,1912,1976,1975,-1,1912,1913,1977,1976,-1,1913,1914,1978,1977,-1,1914,1915,1979,1978,-1,1915,1916,1980,1979,-1,1916,1917,1981,1980,-1,1917,1918,1982,1981,-1,1918,1919,1983,1982,-1,1919,1856,1920,1983,-1,1920,1921,1985,1984,-1,1921,1922,1986,1985,-1,1922,1923,1987,1986,-1,1923,1924,1988,1987,-1,1924,1925,1989,1988,-1,1925,1926,1990,1989,-1,1926,1927,1991,1990,-1,1927,1928,1992,1991,-1,1928,1929,1993,1992,-1,1929,1930,1994,1993,-1,1930,1931,1995,1994,-1,1931,1932,1996,1995,-1,1932,1933,1997,1996,-1,1933,1934,1998,1997,-1,1934,1935,1999,1998,-1,1935,1936,2000,1999,-1,1936,1937,2001,2000,-1,1937,1938,2002,2001,-1,1938,1939,2003,2002,-1,1939,1940,2004,2003,-1,1940,1941,2005,2004,-1,1941,1942,2006,2005,-1,1942,1943,2007,2006,-1,1943,1944,2008,2007,-1,1944,1945,2009,2008,-1,1945,1946,2010,2009,-1,1946,1947,2011,2010,-1,1947,1948,2012,2011,-1,1948,1949,2013,2012,-1,1949,1950,2014,2013,-1,1950,1951,2015,2014,-1,1951,1952,2016,2015,-1,1952,1953,2017,2016,-1,1953,1954,2018,2017,-1,1954,1955,2019,2018,-1,1955,1956,2020,2019,-1,1956,1957,2021,2020,-1,1957,1958,2022,2021,-1,1958,1959,2023,2022,-1,1959,1960,2024,2023,-1,1960,1961,2025,2024,-1,1961,1962,2026,2025,-1,1962,1963,2027,2026,-1,1963,1964,2028,2027,-1,1964,1965,2029,2028,-1,1965,1966,2030,2029,-1,1966,1967,2031,2030,-1,1967,1968,2032,2031,-1,1968,1969,2033,2032,-1,1969,1970,2034,2033,-1,1970,1971,2035,2034,-1,1971,1972,2036,2035,-1,1972,1973,2037,2036,-1,1973,1974,2038,2037,-1,1974,1975,2039,2038,-1,1975,1976,2040,2039,-1,1976,1977,2041,2040,-1,1977,1978,2042,2041,-1,1978,1979,2043,2042,-1,1979,1980,2044,2043,-1,1980,1981,2045,2044,-1,1981,1982,2046,2045,-1,1982,1983,2047,2046,-1,1983,1920,1984,2047,-1],creaseAngle=1.571,solid=False,
        coord=Coordinate(point=[(0.0,3.0,0.0),(0.0,3.221066,0.0),(0.0,3.42249,0.0),(0.0,3.586374,0.0),(0.0,3.698155,0.0),(0.0,3.747903,0.0),(0.0,3.731196,0.0),(0.0,3.649519,0.0),(0.0,3.51013,0.0),(0.0,3.325413,0.0),(0.0,3.111782,0.0),(0.0,2.888218,0.0),(0.0,2.674587,0.0),(0.0,2.48987,0.0),(0.0,2.350481,0.0),(0.0,2.268804,0.0),(0.0,2.252097,0.0),(0.0,2.301845,0.0),(0.0,2.413626,0.0),(0.0,2.57751,0.0),(0.0,2.778934,0.0),(0.0,3.0,0.0),(0.0,3.221066,0.0),(0.0,3.42249,0.0),(0.0,3.586374,0.0),(0.0,3.698155,0.0),(0.0,3.747903,0.0),(0.0,3.731196,0.0),(0.0,3.649519,0.0),(0.0,3.51013,0.0),(0.0,3.325413,0.0),(0.0,3.111782,0.0),(0.0,2.888218,0.0),(0.0,2.674587,0.0),(0.0,2.48987,0.0),(0.0,2.350481,0.0),(0.0,2.268804,0.0),(0.0,2.252097,0.0),(0.0,2.301845,0.0),(0.0,2.413626,0.0),(0.0,2.57751,0.0),(0.0,2.778934,0.0),(0.0,3.0,0.0),(0.0,3.221066,0.0),(0.0,3.42249,0.0),(0.0,3.586374,0.0),(0.0,3.698155,0.0),(0.0,3.747903,0.0),(0.0,3.731196,0.0),(0.0,3.649519,0.0),(0.0,3.51013,0.0),(0.0,3.325413,0.0),(0.0,3.111782,0.0),(0.0,2.888218,0.0),(0.0,2.674587,0.0),(0.0,2.48987,0.0),(0.0,2.350481,0.0),(0.0,2.268804,0.0),(0.0,2.252097,0.0),(0.0,2.301845,0.0),(0.0,2.413626,0.0),(0.0,2.57751,0.0),(0.0,2.778934,0.0),(0.0,3.0,0.0),(0.318779,3.134807,0.0),(0.338318,3.343564,0.033854),(0.350894,3.520427,0.070935),(0.354648,3.649679,0.109394),(0.348567,3.719837,0.146933),(0.332637,3.724667,0.181144),(0.307828,3.663739,0.209874),(0.275955,3.542467,0.231554),(0.239398,3.371628,0.245443),(0.200758,3.166399,0.251743),(0.162481,2.945018,0.25157),(0.126518,2.727155,0.246783),(0.094074,2.532167,0.239696),(0.065477,2.377381,0.23272),(0.0402,2.276549,0.227985),(0.017012,2.238632,0.22701),(-0.005747,2.266998,0.230459),(-0.02983,2.359127,0.238038),(-0.056725,2.506832,0.248529),(-0.087347,2.69699,0.259976),(-0.12182,2.912704,0.269982),(-0.159389,3.134807,0.27607),(-0.198477,3.343564,0.276065),(-0.236879,3.520427,0.268416),(-0.272062,3.649679,0.252437),(-0.301532,3.719837,0.228401),(-0.323194,3.724667,0.1975),(-0.33567,3.663739,0.16165),(-0.338509,3.542467,0.123207),(-0.332259,3.371628,0.084603),(-0.318395,3.166399,0.04799),(-0.299107,2.945018,0.014928),(-0.27698,2.727155,-0.013823),(-0.25462,2.532167,-0.038378),(-0.23428,2.377381,-0.059655),(-0.217541,2.276549,-0.079178),(-0.205103,2.238632,-0.098772),(-0.19671,2.266998,-0.120207),(-0.191232,2.359127,-0.144853),(-0.18687,2.506832,-0.17339),(-0.181472,2.69699,-0.205633),(-0.172901,2.912704,-0.24049),(-0.159389,3.134807,-0.27607),(-0.139841,3.343564,-0.309919),(-0.114016,3.520427,-0.339351),(-0.082586,3.649679,-0.361831),(-0.047036,3.719837,-0.375335),(-0.009443,3.724667,-0.378644),(0.027842,3.663739,-0.371524),(0.062554,3.542467,-0.354761),(0.092861,3.371628,-0.330046),(0.117637,3.166399,-0.299733),(0.136626,2.945018,-0.266498),(0.150461,2.727155,-0.23296),(0.160546,2.532167,-0.201319),(0.168803,2.377381,-0.173065),(0.177341,2.276549,-0.148807),(0.18809,2.238632,-0.128238),(0.202457,2.266998,-0.110252),(0.221062,2.359127,-0.093185),(0.243595,2.506832,-0.075139),(0.268819,2.69699,-0.054343),(0.294721,2.912704,-0.029491),(0.318779,3.134807,0.0),(0.663433,3.228302,0.0),(0.698195,3.414423,0.069865),(0.716743,3.558265,0.144893),(0.716189,3.647045,0.220915),(0.695526,3.672876,0.293189),(0.655764,3.633462,0.35711),(0.599773,3.532306,0.408918),(0.531848,3.378396,0.446273),(0.457078,3.185407,0.468619),(0.38061,2.970487,0.47727),(0.306919,2.752733,0.475204),(0.239212,2.551493,0.4666),(0.179038,2.384649,0.456182),(0.126181,2.267024,0.448472),(0.078832,2.209071,0.447079),(0.034031,2.215939,0.454114),(-0.011717,2.287018,0.469848),(-0.061737,2.415992,0.492646),(-0.118503,2.5914,0.519194),(-0.183109,2.797659,0.544995),(-0.254954,3.016439,0.565037),(-0.331716,3.228302,0.57455),(-0.409602,3.414423,0.569722),(-0.483852,3.558265,0.548271),(-0.549413,3.647045,0.50978),(-0.601672,3.672876,0.455749),(-0.637148,3.633462,0.389353),(-0.65402,3.532306,0.314959),(-0.652408,3.378396,0.237457),(-0.634375,3.185407,0.161532),(-0.603632,2.970487,0.090983),(-0.564998,2.752733,0.028198),(-0.523693,2.551493,-0.026136),(-0.484584,2.384649,-0.073039),(-0.451479,2.267024,-0.114961),(-0.426598,2.209071,-0.155269),(-0.41029,2.215939,-0.197585),(-0.401042,2.287018,-0.245071),(-0.395775,2.415992,-0.299788),(-0.390384,2.5914,-0.362223),(-0.380425,2.797659,-0.431074),(-0.361859,3.016439,-0.503315),(-0.331716,3.228302,-0.57455),(-0.288593,3.414423,-0.639587),(-0.232891,3.558265,-0.693164),(-0.166776,3.647045,-0.730696),(-0.093854,3.672876,-0.748937),(-0.018616,3.633462,-0.746463),(0.054247,3.532306,-0.723878),(0.12056,3.378396,-0.68373),(0.177297,3.185407,-0.630151),(0.223023,2.970487,-0.568252),(0.258079,2.752733,-0.503401),(0.284482,2.551493,-0.440464),(0.305546,2.384649,-0.383143),(0.325298,2.267024,-0.333512),(0.347766,2.209071,-0.29181),(0.376258,2.215939,-0.256529),(0.412759,2.287018,-0.224777),(0.457512,2.415992,-0.192857),(0.508887,2.5914,-0.156971),(0.563534,2.797659,-0.113921),(0.616814,3.016439,-0.061722),(0.663433,3.228302,0.0),(1.026352,3.27122,0.0),(1.069629,3.42618,0.107033),(1.085907,3.531047,0.219521),(1.072282,3.576504,0.330755),(1.028819,3.558511,0.433684),(0.958525,3.478667,0.521985),(0.866896,3.344067,0.59104),(0.761103,3.16667,0.638641),(0.648947,2.962239,0.665333),(0.537751,2.748938,0.674318),(0.433345,2.54572,0.67095),(0.339327,2.370643,0.661881),(0.256679,2.239262,0.654007),(0.183826,2.163251,0.653356),(0.117103,2.149364,0.664122),(0.051555,2.198835,0.68796),(-0.018048,2.307268,0.723685),(-0.096168,2.465029,0.767405),(-0.185579,2.658099,0.813074),(-0.28672,2.869324,0.853378),(-0.397442,3.079936,0.880821),(-0.513176,3.27122,0.888847),(-0.627507,3.42618,0.87281),(-0.733064,3.531047,0.830663),(-0.822583,3.576504,0.763246),(-0.889991,3.558511,0.674142),(-0.931315,3.478667,0.569115),(-0.945304,3.344067,0.455234),(-0.933631,3.16667,0.339814),(-0.900669,2.962239,0.229338),(-0.852852,2.748938,0.128547),(-0.797732,2.54572,0.039813),(-0.742869,2.370643,-0.037075),(-0.694726,2.239262,-0.104713),(-0.657736,2.163251,-0.16748),(-0.633698,2.149364,-0.230647),(-0.621568,2.198835,-0.299332),(-0.617706,2.307268,-0.377472),(-0.616508,2.465029,-0.466987),(-0.611354,2.658099,-0.567253),(-0.595687,2.869324,-0.674995),(-0.564093,3.079936,-0.784605),(-0.513176,3.27122,-0.888847),(-0.442122,3.42618,-0.979842),(-0.352843,3.531047,-1.050183),(-0.249699,3.576504,-1.094001),(-0.138829,3.558511,-1.107825),(-0.02721,3.478667,-1.0911),(0.078407,3.344067,-1.046274),(0.172528,3.16667,-0.978455),(0.251721,2.962239,-0.894671),(0.315101,2.748938,-0.802865),(0.364387,2.54572,-0.710763),(0.403543,2.370643,-0.624806),(0.438047,2.239262,-0.549294),(0.47391,2.163251,-0.485876),(0.516595,2.149364,-0.433475),(0.570013,2.198835,-0.388628),(0.635753,2.307268,-0.346213),(0.712677,2.465029,-0.300418),(0.796932,2.658099,-0.245821),(0.882406,2.869324,-0.178382),(0.961534,3.079936,-0.096216),(1.026352,3.27122,0.0),(1.397437,3.256414,0.0),(1.440781,3.374185,0.144172),(1.445733,3.437105,0.292261),(1.410465,3.439583,0.435071),(1.337129,3.3814,0.563647),(1.231522,3.267725,0.670651),(1.102228,3.108658,0.751486),(0.95936,2.918334,0.804999),(0.813114,2.713663,0.833645),(0.672335,2.512832,0.843081),(0.54334,2.333685,0.841255),(0.429167,2.19214,0.837121),(0.32936,2.100774,0.839195),(0.240323,2.067705,0.854158),(0.156181,2.095872,0.885746),(0.07,2.182772,0.934082),(-0.024828,2.320683,0.995574),(-0.133259,2.497352,1.063381),(-0.257548,2.69708,1.12839),(-0.396643,2.902121,1.180547),(-0.546128,3.094257,1.210343),(-0.698719,3.256414,1.210216),(-0.845247,3.374185,1.175667),(-0.975972,3.437105,1.105911),(-1.082015,3.439583,1.003963),(-1.156698,3.3814,0.876164),(-1.196562,3.267725,0.731204),(-1.20192,3.108658,0.578814),(-1.17683,2.918334,0.428331),(-1.128514,2.713663,0.287355),(-1.066297,2.512832,0.160718),(-1.000218,2.333685,0.049919),(-0.939552,2.19214,-0.046891),(-0.891444,2.100774,-0.134364),(-0.859884,2.067705,-0.218953),(-0.845169,2.095872,-0.307616),(-0.843939,2.182772,-0.406419),(-0.849778,2.320683,-0.519289),(-0.854285,2.497352,-0.647096),(-0.84844,2.69708,-0.787238),(-0.824062,2.902121,-0.933776),(-0.775124,3.094257,-1.078132),(-0.698719,3.256414,-1.210216),(-0.595534,3.374185,-1.319839),(-0.469761,3.437105,-1.398172),(-0.32845,3.439583,-1.439034),(-0.180432,3.3814,-1.439812),(-0.03496,3.267725,-1.401855),(0.099692,3.108658,-1.3303),(0.217469,2.918334,-1.23333),(0.3154,2.713663,-1.121),(0.393962,2.512832,-1.0038),(0.456878,2.333685,-0.891174),(0.510385,2.19214,-0.79023),(0.562084,2.100774,-0.704831),(0.619561,2.067705,-0.635205),(0.688988,2.095872,-0.578129),(0.773939,2.182772,-0.527663),(0.874606,2.320683,-0.476285),(0.987544,2.497352,-0.416285),(1.105988,2.69708,-0.341152),(1.220705,2.902121,-0.246771),(1.321252,3.094257,-0.132211),(1.397437,3.256414,0.0),(1.764792,3.179547,0.0),(1.798835,3.257065,0.180001),(1.783499,3.278248,0.360542),(1.719094,3.241213,0.53027),(1.610719,3.14925,0.678975),(1.467492,3.010531,0.799153),(1.301223,2.837382,0.887159),(1.124706,2.645188,0.94374),(0.949902,2.451025,0.973887),(0.786311,2.272147,0.986003),(0.639751,2.124447,0.990529),(0.511765,2.02105,0.998235),(0.39971,1.971142,1.018444),(0.297524,1.979158,1.057464),(0.197043,2.044385,1.117487),(0.089636,2.161029,1.196115),(-0.032086,2.318724,1.286597),(-0.17278,2.503459,1.378749),(-0.333329,2.69882,1.46041),(-0.510427,2.887447,1.519209),(-0.696852,3.05258,1.544383),(-0.882396,3.179547,1.528355),(-1.055303,3.257065,1.467837),(-1.203988,3.278248,1.364284),(-1.318775,3.241213,1.223644),(-1.393369,3.14925,1.055436),(-1.425833,3.010531,0.871308),(-1.418914,2.837382,0.683313),(-1.379656,2.645188,0.502154),(-1.318362,2.451025,0.335696),(-1.247059,2.272147,0.187964),(-1.177699,2.124447,0.058777),(-1.12038,2.02105,-0.055916),(-1.081853,1.971142,-0.163063),(-1.064553,1.979158,-0.271068),(-1.066294,2.044385,-0.388099),(-1.080684,2.161029,-0.52043),(-1.098183,2.318724,-0.671085),(-1.107642,2.503459,-0.839006),(-1.098088,2.69882,-1.018876),(-1.06046,2.887447,-1.201647),(-0.989049,3.05258,-1.375683),(-0.882396,3.179547,-1.528355),(-0.743533,3.257065,-1.647837),(-0.579511,3.278248,-1.724826),(-0.40032,3.241213,-1.753915),(-0.21735,3.14925,-1.734411),(-0.041659,3.010531,-1.670462),(0.117691,2.837382,-1.570472),(0.25495,2.645188,-1.445894),(0.368459,2.451025,-1.309583),(0.460748,2.272147,-1.173966),(0.537947,2.124447,-1.049305),(0.608614,2.02105,-0.942319),(0.682143,1.971142,-0.855381),(0.767029,1.979158,-0.786396),(0.869251,2.044385,-0.729388),(0.991048,2.161029,-0.675685),(1.130268,2.318724,-0.615511),(1.280422,2.503459,-0.539743),(1.431417,2.69882,-0.441534),(1.570887,2.887447,-0.317562),(1.685901,3.05258,-0.1687),(1.764792,3.179547,0.0),(2.115586,3.039545,0.0),(2.130954,3.076915,0.213234),(2.087371,3.059673,0.421971),(1.988213,2.989352,0.613282),(1.842131,2.872198,0.776523),(1.661786,2.718622,0.90496),(1.462007,2.542271,0.996779),(1.257678,2.358812,1.055317),(1.061662,2.184548,1.088469),(0.883096,2.034963,1.107367),(0.726301,1.923347,1.124534),(0.590489,1.859619,1.151791),(0.470285,1.849441,1.198266),(0.356986,1.893718,1.268803),(0.240337,1.988514,1.36302),(0.11055,2.125408,1.475191),(-0.039775,2.292235,1.594947),(-0.214129,2.474172,1.70871),(-0.411212,2.655054,1.801639),(-0.624854,2.818807,1.859784),(-0.844732,2.950883,1.872119),(-1.057793,3.039545,1.832151),(-1.250143,3.076915,1.738843),(-1.409123,3.059673,1.596731),(-1.525224,2.989352,1.415201),(-1.593555,2.872198,1.207071),(-1.614612,2.718622,0.986669),(-1.59424,2.542271,0.767745),(-1.54277,2.358812,0.561522),(-1.473473,2.184548,0.375192),(-1.400556,2.034963,0.2111),(-1.337025,1.923347,0.066728),(-1.292724,1.859619,-0.064517),(-1.272872,1.849441,-0.191855),(-1.277308,1.893718,-0.325243),(-1.300578,1.988514,-0.473372),(-1.332828,2.125408,-0.641856),(-1.361377,2.292235,-0.83192),(-1.372722,2.474172,-1.039796),(-1.354659,2.655054,-1.25694),(-1.298193,2.818807,-1.471032),(-1.198937,2.950883,-1.667619),(-1.057793,3.039545,-1.832151),(-0.880811,3.076915,-1.952077),(-0.678248,3.059673,-2.018702),(-0.462988,2.989352,-2.028484),(-0.248577,2.872198,-1.983594),(-0.047174,2.718622,-1.891629),(0.132233,2.542271,-1.764525),(0.285092,2.358812,-1.616839),(0.41181,2.184548,-1.463661),(0.51746,2.034963,-1.318467),(0.610724,1.923347,-1.191262),(0.702236,1.859619,-1.087273),(0.802587,1.849441,-1.006412),(0.920322,1.893718,-0.94356),(1.060241,1.988514,-0.889648),(1.222278,2.125408,-0.833335),(1.401152,2.292235,-0.763027),(1.586851,2.474172,-0.668914),(1.765872,2.655054,-0.544699),(1.923047,2.818807,-0.388752),(2.043669,2.950883,-0.2045),(2.115586,3.039545,0.0),(2.437013,2.838781,0.0),(2.425253,2.83919,0.242683),(2.347295,2.789582,0.474516),(2.210274,2.694364,0.681779),(2.026697,2.561997,0.854324),(1.812627,2.404242,0.987104),(1.585375,2.235117,1.08089),(1.361058,2.069649,1.142064),(1.152403,1.92254,1.1815),(0.96712,1.806863,1.212731),(0.807114,1.732894,1.249657),(0.668618,1.707207,1.304187),(0.543242,1.732085,1.384159),(0.419752,1.805316,1.491887),(0.286277,1.920393,1.623558),(0.132612,2.067093,1.769579),(-0.047778,2.232379,1.915839),(-0.256356,2.401565,2.045676),(-0.488959,2.559619,2.142268),(-0.73616,2.692496,2.19107),(-0.98452,2.78839,2.181921),(-1.218507,2.838781,2.110515),(-1.422796,2.83919,1.978989),(-1.58459,2.789582,1.795559),(-1.695575,2.694364,1.573264),(-1.753215,2.561997,1.328009),(-1.76117,2.404242,1.076229),(-1.728766,2.235117,0.83253),(-1.669585,2.069649,0.607679),(-1.599411,1.92254,0.40726),(-1.533816,1.806863,0.231186),(-1.485792,1.732894,0.074153),(-1.463768,1.707207,-0.073054),(-1.470338,1.732085,-0.221618),(-1.501888,1.805316,-0.382428),(-1.549181,1.920393,-0.563856),(-1.598806,2.067093,-0.769944),(-1.635276,2.232379,-0.999296),(-1.643429,2.401565,-1.244849),(-1.610779,2.559619,-1.494585),(-1.529442,2.692496,-1.733068),(-1.397339,2.78839,-1.94358),(-1.218507,2.838781,-2.110515),(-1.002457,2.83919,-2.221672),(-0.762705,2.789582,-2.270075),(-0.514699,2.694364,-2.255043),(-0.273482,2.561997,-2.182333),(-0.051456,2.404242,-2.063333),(0.143391,2.235117,-1.91342),(0.308527,2.069649,-1.749743),(0.447008,1.92254,-1.58876),(0.566695,1.806863,-1.443916),(0.678678,1.732894,-1.32381),(0.79515,1.707207,-1.231133),(0.927096,1.732085,-1.162541),(1.082136,1.805316,-1.10946),(1.262904,1.920393,-1.059702),(1.466194,2.067093,-0.999634),(1.683054,2.232379,-0.916542),(1.899785,2.401565,-0.800827),(2.099738,2.559619,-0.647683),(2.265602,2.692496,-0.458001),(2.381859,2.78839,-0.238341),(2.437013,2.838781,0.0),(2.717275,2.582963,0.0),(2.671698,2.552321,0.267344),(2.555732,2.478548,0.516652),(2.38066,2.368198,0.734336),(2.162789,2.231077,0.911692),(1.921104,2.079368,1.046177),(1.674563,1.926551,1.141698),(1.439463,1.786204,1.207853),(1.227277,1.670799,1.258265),(1.043285,1.59059,1.308238),(0.886218,1.552702,1.372133),(0.748938,1.560503,1.460857),(0.620054,1.6133,1.579871),(0.486195,1.706402,1.728039),(0.334581,1.831535,1.897502),(0.15547,1.977582,2.074597),(-0.055905,2.131565,2.241708),(-0.29822,2.279802,2.379737),(-0.563956,2.409122,2.470852),(-0.840311,2.508034,2.501059),(-1.110998,2.56775,2.462225),(-1.358638,2.582963,2.353229),(-1.567375,2.552321,2.180086),(-1.7253,2.478548,1.955003),(-1.826284,2.368198,1.694544),(-1.870943,2.231077,1.417184),(-1.866568,2.079368,1.140636),(-1.826021,1.926551,0.879365),(-1.765763,1.786204,0.642685),(-1.703328,1.670799,0.433721),(-1.65461,1.59059,0.249392),(-1.631411,1.552702,0.08142),(-1.639608,1.560503,-0.081829),(-1.678235,1.6133,-0.252953),(-1.739623,1.706402,-0.442963),(-1.810575,1.831535,-0.658995),(-1.874389,1.977582,-0.902658),(-1.913424,2.131565,-1.169269),(-1.911803,2.279802,-1.448134),(-1.857843,2.409122,-1.723826),(-1.745825,2.508034,-1.978261),(-1.57685,2.56775,-2.193265),(-1.358638,2.582963,-2.353229),(-1.104323,2.552321,-2.44743),(-0.830432,2.478548,-2.471655),(-0.554376,2.368198,-2.42888),(-0.291846,2.231077,-2.328876),(-0.054536,2.079368,-2.186814),(0.151458,1.926551,-2.021063),(0.3263,1.786204,-1.850538),(0.476051,1.670799,-1.691985),(0.611325,1.59059,-1.55763),(0.745193,1.552702,-1.453554),(0.89067,1.560503,-1.379027),(1.058181,1.6133,-1.326917),(1.253428,1.706402,-1.285077),(1.475994,1.831535,-1.238506),(1.718919,1.977582,-1.171939),(1.969328,2.131565,-1.072439),(2.210023,2.279802,-0.931603),(2.421799,2.409122,-0.747026),(2.586137,2.508034,-0.522799),(2.687848,2.56775,-0.26896),(2.717275,2.582963,0.0),(2.946476,2.280742,0.0),(2.862854,2.22708,0.286472),(2.708187,2.138698,0.547472),(2.497942,2.023447,0.770513),(2.251817,1.891569,0.94922),(1.990921,1.754782,1.084198),(1.734801,1.62524,1.182767),(1.498775,1.514453,1.257621),(1.291971,1.432265,1.324592),(1.116381,1.385979,1.399898),(0.967053,1.379707,1.497291),(0.833382,1.414008,1.625571),(0.701286,1.485832,1.786847),(0.555916,1.588799,1.975843),(0.384456,1.713759,2.180358),(0.178567,1.849609,2.382816),(-0.063909,1.984277,2.562678),(-0.338273,2.1058,2.699356),(-0.633412,2.203377,2.77516),(-0.93331,2.268339,2.777857),(-1.219378,2.294915,2.70242),(-1.473238,2.280742,2.551723),(-1.679519,2.22708,2.336068),(-1.828218,2.138698,2.071623),(-1.916255,2.023447,1.778025),(-1.947958,1.891569,1.47552),(-1.934403,1.754782,1.182089),(-1.891707,1.62524,0.910998),(-1.83852,1.514453,0.669166),(-1.793116,1.432265,0.456583),(-1.770538,1.385979,0.266866),(-1.780219,1.379707,0.088847),(-1.824477,1.414008,-0.091056),(-1.898097,1.485832,-0.286092),(-1.989088,1.588799,-0.506484),(-2.080474,1.713759,-0.757231),(-2.152863,1.849609,-1.036764),(-2.18739,1.984277,-1.336686),(-2.168574,2.1058,-1.642631),(-2.086653,2.203377,-1.936131),(-1.939039,2.268339,-2.197199),(-1.730675,2.294915,-2.407222),(-1.473238,2.280742,-2.551723),(-1.183335,2.22708,-2.62254),(-0.879969,2.138698,-2.619094),(-0.581687,2.023447,-2.548538),(-0.303859,1.891569,-2.424741),(-0.056518,1.754782,-2.266287),(0.156906,1.62524,-2.093766),(0.339745,1.514453,-1.926788),(0.501145,1.432265,-1.781176),(0.654157,1.385979,-1.666764),(0.813166,1.379707,-1.586138),(0.991095,1.414008,-1.534515),(1.196812,1.485832,-1.500754),(1.433172,1.588799,-1.469359),(1.696018,1.713759,-1.423128),(1.974295,1.849609,-1.346052),(2.251299,1.984277,-1.225992),(2.506847,2.1058,-1.056725),(2.720065,2.203377,-0.839029),(2.872349,2.268339,-0.580658),(2.950053,2.294915,-0.295197),(2.946476,2.280742,0.0),(3.11737,1.943072,0.0),(2.994408,1.87575,0.299636),(2.803466,1.782761,0.566733),(2.563867,1.672369,0.790848),(2.297955,1.554382,0.968669),(2.027916,1.439283,1.104344),(1.772696,1.337301,1.208603),(1.545467,1.257495,1.296801),(1.352055,1.206958,1.386194),(1.190533,1.190179,1.492881),(1.052052,1.208651,1.628895),(0.922757,1.26073,1.799904),(0.786471,1.341791,2.003896),(0.627725,1.44463,2.231069),(0.434635,1.560109,2.464938),(0.201177,1.677969,2.684524),(-0.071505,1.787735,2.867265),(-0.374975,1.879656,2.992226),(-0.69457,1.945564,3.043109),(-1.011506,1.979602,3.010596),(-1.305674,1.978746,2.89367),(-1.558685,1.943072,2.699722),(-1.756696,1.87575,2.443415),(-1.892538,1.782761,2.144506),(-1.966828,1.672369,1.82495),(-1.987869,1.554382,1.505752),(-1.970348,1.439283,1.204055),(-1.933029,1.337301,0.930898),(-1.895796,1.257495,0.690013),(-1.876506,1.206958,0.477817),(-1.888139,1.190179,0.284591),(-1.93669,1.208651,0.096656),(-2.020141,1.26073,-0.100821),(-2.128661,1.341791,-0.320844),(-2.246025,1.44463,-0.571908),(-2.352017,1.560109,-0.856064),(-2.425455,1.677969,-1.168037),(-2.447371,1.787735,-1.495558),(-2.403856,1.879656,-1.82085),(-2.288125,1.945564,-2.12307),(-2.101499,1.979602,-2.381288),(-1.853155,1.978746,-2.577581),(-1.558685,1.943072,-2.699722),(-1.237712,1.87575,-2.743051),(-0.910928,1.782761,-2.711239),(-0.597039,1.672369,-2.615798),(-0.310085,1.554382,-2.474422),(-0.057568,1.439283,-2.308399),(0.160333,1.337301,-2.139501),(0.350329,1.257495,-1.986814),(0.524451,1.206958,-1.864011),(0.697606,1.190179,-1.777472),(0.884638,1.208651,-1.725551),(1.097384,1.26073,-1.699082),(1.342189,1.341791,-1.683052),(1.618299,1.44463,-1.65916),(1.917382,1.560109,-1.608874),(2.224277,1.677969,-1.516487),(2.518877,1.787735,-1.371707),(2.778831,1.879656,-1.171375),(2.982695,1.945564,-0.920039),(3.113005,1.979602,-0.629308),(3.158828,1.978746,-0.316088),(3.11737,1.943072,0.0),(3.225885,1.582372,0.0),(3.065433,1.511176,0.306743),(2.843659,1.423098,0.574858),(2.583068,1.325964,0.796771),(2.30763,1.228406,0.972748),(2.039401,1.139091,1.110599),(1.795498,1.065955,1.22415),(1.585891,1.015498,1.330721),(1.412353,0.992202,1.448014),(1.268703,0.998138,1.590904),(1.142309,1.032777,1.768641),(1.016583,1.093043,1.982918),(0.87408,1.173579,2.22712),(0.699697,1.267231,2.486869),(0.483458,1.365677,2.741825),(0.222453,1.460169,2.968434),(-0.078387,1.542312,3.143239),(-0.406805,1.604806,3.246229),(-0.744921,1.642099,3.263714),(-1.07188,1.650877,3.19029),(-1.367002,1.630361,3.029587),(-1.612943,1.582372,2.793698),(-1.798363,1.511176,2.501371),(-1.919671,1.423098,2.175252),(-1.981558,1.325964,1.838617),(-1.996239,1.228406,1.512092),(-1.981507,1.139091,1.210874),(-1.957893,1.065955,0.942872),(-1.945383,1.015498,0.708062),(-1.960193,0.992202,0.499127),(-2.012115,0.998138,0.303277),(-2.102842,1.032777,0.104948),(-2.225549,1.093043,-0.111073),(-2.365782,1.173579,-0.356584),(-2.50354,1.267231,-0.63748),(-2.616219,1.365677,-0.952226),(-2.681966,1.460169,-1.291567),(-2.682931,1.542312,-1.639505),(-2.607914,1.604806,-1.975418),(-2.453999,1.642099,-2.276978),(-2.226932,1.650877,-2.52342),(-1.940198,1.630361,-2.698652),(-1.612943,1.582372,-2.793698),(-1.267069,1.511176,-2.808114),(-0.923988,1.423098,-2.75011),(-0.60151,1.325964,-2.635388),(-0.311391,1.228406,-2.48484),(-0.057894,1.139091,-2.321472),(0.162396,1.065955,-2.167021),(0.359492,1.015498,-2.038782),(0.54784,0.992202,-1.94714),(0.743411,0.998138,-1.894181),(0.960533,1.032777,-1.873589),(1.208966,1.093043,-1.871846),(1.491702,1.173579,-1.870535),(1.803844,1.267231,-1.84939),(2.132761,1.365677,-1.789599),(2.459512,1.460169,-1.676867),(2.761319,1.542312,-1.503734),(3.01472,1.604806,-1.270811),(3.19892,1.642099,-0.986736),(3.298812,1.650877,-0.666869),(3.3072,1.630361,-0.330935),(3.225885,1.582372,0.0),(3.271376,1.211585,0.0),(3.078355,1.145791,0.308036),(2.833835,1.070768,0.572872),(2.56253,0.993181,0.790436),(2.288827,0.919924,0.964821),(2.03338,0.857507,1.10732),(1.81033,0.811476,1.234262),(1.625582,0.78592,1.364025),(1.476394,0.78311,1.513672),(1.352328,0.803296,1.695765),(1.237395,0.844685,1.915862),(1.113058,0.903599,2.1711),(0.961594,0.974802,2.450102),(0.769296,1.051969,2.73424),(0.528993,1.128243,3.000066),(0.241496,1.196846,3.222545),(-0.084257,1.251683,3.378594),(-0.432391,1.287881,3.450395),(-0.782408,1.302224,3.427954),(-1.112278,1.293438,3.310528),(-1.401797,1.262302,3.106701),(-1.635688,1.211585,2.833095),(-1.805944,1.145791,2.511915),(-1.913039,1.070768,2.167737),(-1.965802,0.993181,1.823998),(-1.979973,0.919924,1.499772),(-1.975657,0.857507,1.207299),(-1.974067,0.811476,0.950661),(-1.994071,0.78592,0.725783),(-2.049075,0.78311,0.521759),(-2.144739,0.803296,0.323267),(-2.277883,0.844685,0.113684),(-2.436757,0.903599,-0.121613),(-2.602647,0.974802,-0.392286),(-2.752569,1.051969,-0.70089),(-2.86263,1.128243,-1.041912),(-2.911554,1.196846,-1.40213),(-2.88382,1.251683,-1.762266),(-2.771935,1.287881,-2.099659),(-2.577491,1.302224,-2.391562),(-2.310862,1.293438,-2.618525),(-1.989584,1.262302,-2.767343),(-1.635688,1.211585,-2.833095),(-1.27241,1.145791,-2.819951),(-0.920796,1.070768,-2.740609),(-0.596727,0.993181,-2.614433),(-0.308854,0.919924,-2.464593),(-0.057723,0.857507,-2.314619),(0.163737,0.811476,-2.184923),(0.368489,0.78592,-2.089808),(0.572681,0.78311,-2.035431),(0.792412,0.803296,-2.019033),(1.040488,0.844685,-2.029547),(1.323699,0.903599,-2.049486),(1.641053,0.974802,-2.057816),(1.983273,1.051969,-2.03335),(2.333637,1.128243,-1.958154),(2.670057,1.196846,-1.820414),(2.968077,1.251683,-1.616329),(3.204325,1.287881,-1.350736),(3.359899,1.302224,-1.036392),(3.42314,1.293438,-0.692003),(3.391381,1.262302,-0.339359),(3.271376,1.211585,0.0),(3.256589,0.843189,0.0),(3.038641,0.790688,0.304062),(2.781487,0.734745,0.56229),(2.510859,0.680332,0.774497),(2.250262,0.632282,0.948565),(2.017725,0.594867,1.098794),(1.823438,0.57141,1.243199),(1.668657,0.563995,1.40017),(1.545997,0.573282,1.585032),(1.441089,0.598444,1.807069),(1.335311,0.637247,2.067466),(1.209152,0.686243,2.358539),(1.045682,0.741077,2.664355),(0.833573,0.796879,2.962694),(0.569189,0.848689,3.228031),(0.257425,0.891903,3.435102),(-0.088843,0.922684,3.562507),(-0.45061,0.938294,3.595781),(-0.805581,0.937348,3.529482),(-1.131574,0.919928,3.36796),(-1.409914,0.887584,3.12469),(-1.628294,0.843189,2.820289),(-1.782646,0.790688,2.479509),(-1.8777,0.734745,2.127693),(-1.926164,0.680332,1.787219),(-1.946613,0.632282,1.474502),(-1.960446,0.594867,1.198004),(-1.988361,0.57141,0.957544),(-2.046911,0.563995,0.745015),(-2.145676,0.573282,0.546356),(-2.285512,0.598444,0.344486),(-2.458134,0.637247,0.12268),(-2.647131,0.686243,-0.132113),(-2.830241,0.741077,-0.42659),(-2.982555,0.796879,-0.759452),(-3.080151,0.848689,-1.121083),(-3.103598,0.891903,-1.494614),(-3.040799,0.922684,-1.858194),(-2.888732,0.938294,-2.18813),(-2.653831,0.937348,-2.462395),(-2.350952,0.919928,-2.663952),(-2.001104,0.887584,-2.783366),(-1.628294,0.843189,-2.820289),(-1.255995,0.790688,-2.783571),(-0.903786,0.734745,-2.689983),(-0.584695,0.680332,-2.561716),(-0.30365,0.632282,-2.423067),(-0.057279,0.594867,-2.296798),(0.164923,0.57141,-2.200744),(0.378254,0.563995,-2.145184),(0.59968,0.573282,-2.131388),(0.844423,0.598444,-2.151554),(1.122823,0.637247,-2.190147),(1.437978,0.686243,-2.226426),(1.784558,0.741077,-2.237765),(2.148982,0.796879,-2.203242),(2.510962,0.848689,-2.106947),(2.846173,0.891903,-1.940488),(3.129643,0.922684,-1.704313),(3.339342,0.938294,-1.407651),(3.459412,0.937348,-1.067087),(3.482526,0.919928,-0.704008),(3.411018,0.887584,-0.341324),(3.256589,0.843189,0.0),(3.187338,0.488282,0.0),(2.954229,0.454831,0.295615),(2.695777,0.421332,0.544963),(2.437425,0.39076,0.751846),(2.200513,0.365833,0.927594),(1.999373,0.348765,1.0888),(1.83954,0.341072,1.254177),(1.717359,0.343439,1.441036),(1.621023,0.355655,1.661953),(1.532875,0.376635,1.922165),(1.432607,0.404514,2.21811),(1.300828,0.436815,2.537359),(1.122459,0.470668,2.859978),(0.889396,0.503066,3.161102),(0.602042,0.531128,3.414352),(0.26945,0.552363,3.595556),(-0.091929,0.564883,3.686218),(-0.460686,0.567576,3.676189),(-0.813716,0.560202,3.565125),(-1.129749,0.543417,3.362526),(-1.392607,0.518712,3.086335),(-1.593669,0.488282,2.760316),(-1.733125,0.454831,2.41063),(-1.819841,0.421332,2.06213),(-1.86983,0.39076,1.734949),(-1.903577,0.365833,1.441903),(-1.942615,0.348765,1.187108),(-2.005919,0.341072,0.966),(-2.106653,0.343439,0.766759),(-2.249805,0.355655,0.572871),(-2.431082,0.376635,0.366427),(-2.637243,0.404514,0.131619),(-2.847831,0.436815,-0.142129),(-3.038043,0.470668,-0.457911),(-3.182293,0.503066,-0.810311),(-3.257936,0.531128,-1.185792),(-3.248567,0.552363,-1.564428),(-3.146394,0.564883,-1.922722),(-2.95333,0.567576,-2.23706),(-2.68063,0.560202,-2.487261),(-2.347159,0.543417,-2.659654),(-1.976541,0.518712,-2.749201),(-1.593669,0.488282,-2.760316),(-1.221104,0.454831,-2.706245),(-0.875937,0.421332,-2.607093),(-0.567595,0.39076,-2.486795),(-0.296937,0.365833,-2.369498),(-0.056758,0.348765,-2.275908),(0.166379,0.341072,-2.220177),(0.389294,0.343439,-2.207794),(0.628782,0.355655,-2.234823),(0.898206,0.376635,-2.288592),(1.204636,0.404514,-2.349729),(1.547003,0.436815,-2.39523),(1.915584,0.470668,-2.402067),(2.292897,0.503066,-2.350791),(2.655894,0.531128,-2.22856),(2.979118,0.552363,-2.031128),(3.238323,0.564883,-1.763497),(3.414016,0.567576,-1.439128),(3.494347,0.560202,-1.077863),(3.476908,0.543417,-0.702872),(3.369148,0.518712,-0.337134),(3.187338,0.488282,0.0),(3.071928,0.155791,0.0),(2.834755,0.14448,0.28366),(2.586654,0.133834,0.522903),(2.351455,0.124797,0.725328),(2.14718,0.118172,0.905112),(1.983641,0.114548,1.080233),(1.861331,0.114248,1.269034),(1.771786,0.117297,1.486705),(1.699326,0.123425,1.742233),(1.623909,0.132088,2.036317),(1.524637,0.142515,2.3606),(1.38336,0.15378,2.698343),(1.187798,0.164882,3.026459),(0.933712,0.174835,3.318609),(0.625762,0.182755,3.54887),(0.276935,0.187937,3.695436),(-0.093364,0.189921,3.743759),(-0.46225,0.188531,3.688666),(-0.806864,0.183891,3.535102),(-1.10787,0.176412,3.297407),(-1.352399,0.166759,2.997224),(-1.535964,0.155791,2.660368),(-1.663034,0.14448,2.31314),(-1.746174,0.133834,1.978656),(-1.80388,0.124797,1.673756),(-1.857441,0.118172,1.406957),(-1.92733,0.114548,1.177767),(-2.029681,0.114248,0.977443),(-2.173418,0.117297,0.791059),(-2.358481,0.123425,0.600543),(-2.575457,0.132088,0.388188),(-2.806658,0.142515,0.140074),(-3.028513,0.15378,-0.151147),(-3.21489,0.164882,-0.484567),(-3.340856,0.174835,-0.850686),(-3.386293,0.182755,-1.23251),(-3.338809,0.187937,-1.607885),(-3.195509,0.189921,-1.952735),(-2.963353,0.188531,-2.244653),(-2.658056,0.183891,-2.466315),(-2.301703,0.176412,-2.608147),(-1.919473,0.166759,-2.669824),(-1.535964,0.155791,-2.660368),(-1.171721,0.14448,-2.5968),(-0.840479,0.133834,-2.501559),(-0.547575,0.124797,-2.399084),(-0.28974,0.118172,-2.312069),(-0.056311,0.114548,-2.258),(0.16835,0.114248,-2.246477),(0.401631,0.117297,-2.277765),(0.659155,0.123425,-2.342776),(0.951548,0.132088,-2.424505),(1.282021,0.142515,-2.500675),(1.645154,0.15378,-2.547196),(2.027092,0.164882,-2.541893),(2.407144,0.174835,-2.467923),(2.760531,0.182755,-2.316361),(3.061874,0.187937,-2.08755),(3.288872,0.189921,-1.791024),(3.425603,0.188531,-1.444013),(3.46492,0.183891,-1.068786),(3.409573,0.176412,-0.68926),(3.271872,0.166759,-0.3274),(3.071928,0.155791,0.0),(2.920371,-0.148104,0.0),(2.69065,-0.137136,0.26924),(2.463914,-0.127483,0.498091),(2.261158,-0.120004,0.697475),(2.096158,-0.115364,0.883605),(1.973694,-0.113974,1.074816),(1.889196,-0.115958,1.288032),(1.829836,-0.12114,1.535415),(1.7769,-0.12906,1.821766),(1.709046,-0.139013,2.143075),(1.605946,-0.150115,2.486491),(1.45173,-0.16138,2.831703),(1.237685,-0.171807,3.153569),(0.963802,-0.18047,3.425556),(0.63892,-0.186598,3.623498),(0.279455,-0.189647,3.729066),(-0.093081,-0.189347,3.732437),(-0.455365,-0.185723,3.633725),(-0.785837,-0.179098,3.442976),(-1.067988,-0.170061,3.178705),(-1.292835,-0.159415,2.865216),(-1.460185,-0.148104,2.529115),(-1.578494,-0.137136,2.195551),(-1.663316,-0.127483,1.884766),(-1.73461,-0.120004,1.609483),(-1.813303,-0.115364,1.373524),(-1.917665,-0.113974,1.171861),(-2.060066,-0.115958,0.992076),(-2.244627,-0.12114,0.816977),(-2.466145,-0.12906,0.627958),(-2.71048,-0.139013,0.408539),(-2.956337,-0.150115,0.147545),(-3.178192,-0.16138,-0.158617),(-3.349913,-0.171807,-0.504918),(-3.44852,-0.18047,-0.878101),(-3.457501,-0.186598,-1.258428),(-3.369193,-0.189647,-1.622518),(-3.185844,-0.189347,-1.946829),(-2.919216,-0.185723,-2.21122),(-2.588786,-0.179098,-2.402043),(-2.218845,-0.170061,-2.514257),(-1.834932,-0.159415,-2.552236),(-1.460185,-0.148104,-2.529115),(-1.112156,-0.137136,-2.464792),(-0.800597,-0.127483,-2.382857),(-0.526548,-0.120004,-2.306958),(-0.282855,-0.115364,-2.257128),(-0.056029,-0.113974,-2.246677),(0.17087,-0.115958,-2.280108),(0.41479,-0.12114,-2.352392),(0.689245,-0.12906,-2.449723),(1.001435,-0.139013,-2.551615),(1.350391,-0.150115,-2.634035),(1.726462,-0.16138,-2.673086),(2.112229,-0.171807,-2.648651),(2.484718,-0.18047,-2.547455),(2.818581,-0.186598,-2.36507),(3.089739,-0.189647,-2.106548),(3.278926,-0.189347,-1.785608),(3.374581,-0.185723,-1.422505),(3.374623,-0.179098,-1.040933),(3.286833,-0.170061,-0.664448),(3.127767,-0.159415,-0.31298),(2.920371,-0.148104,0.0),(2.743472,-0.420284,0.0),(2.53219,-0.389855,0.253384),(2.336309,-0.365149,0.472295),(2.172974,-0.348364,0.670274),(2.051084,-0.34099,0.864605),(1.970242,-0.343683,1.072937),(1.921147,-0.356203,1.309816),(1.88737,-0.377438,1.583691),(1.848213,-0.405501,1.894879),(1.782215,-0.437899,2.234827),(1.670735,-0.471752,2.586804),(1.501063,-0.504053,2.927932),(1.268562,-0.531932,3.232244),(0.977522,-0.552911,3.474318),(0.640581,-0.565127,3.632913),(0.276831,-0.567494,3.694049),(-0.091102,-0.559802,3.653059),(-0.440522,-0.542734,3.515285),(-0.752135,-0.517806,3.295317),(-1.012947,-0.487235,3.014884),(-1.218161,-0.453735,2.699723),(-1.371736,-0.420284,2.375916),(-1.485532,-0.389855,2.066249),(-1.577174,-0.365149,1.787156),(-1.666961,-0.348364,1.546714),(-1.774312,-0.34099,1.343989),(-1.914312,-0.343683,1.169811),(-2.094908,-0.356203,1.008854),(-2.315202,-0.377438,0.842665),(-2.56512,-0.405501,0.65316),(-2.826525,-0.437899,0.42603),(-3.075606,-0.471752,0.153497),(-3.286195,-0.504053,-0.164007),(-3.433486,-0.531932,-0.517515),(-3.497609,-0.552911,-0.890601),(-3.466485,-0.565127,-1.261697),(-3.337556,-0.567494,-1.607282),(-3.118091,-0.559802,-1.905426),(-2.824065,-0.542734,-2.139146),(-2.477761,-0.517806,-2.299026),(-2.104492,-0.487235,-2.38468),(-1.728948,-0.453735,-2.40482),(-1.371736,-0.420284,-2.375916),(-1.046658,-0.389855,-2.319633),(-0.759135,-0.365149,-2.259451),(-0.506013,-0.348364,-2.216988),(-0.276773,-0.34099,-2.208593),(-0.055931,-0.343683,-2.242748),(0.17376,-0.356203,-2.318671),(0.427832,-0.377438,-2.426356),(0.716907,-0.405501,-2.548039),(1.044309,-0.437899,-2.660857),(1.404871,-0.471752,-2.740301),(1.785132,-0.504053,-2.763925),(2.164924,-0.531932,-2.714729),(2.520087,-0.552911,-2.583718),(2.825905,-0.565127,-2.371216),(3.060725,-0.567494,-2.086767),(3.209192,-0.559802,-1.747633),(3.264587,-0.542734,-1.376139),(3.229896,-0.517806,-0.996291),(3.117439,-0.487235,-0.630204),(2.947109,-0.453735,-0.294903),(2.743472,-0.420284,0.0),(2.551874,-0.660726,0.0),(2.368581,-0.616331,0.237012),(2.210769,-0.583987,0.446917),(2.090997,-0.566568,0.644987),(2.013018,-0.565621,0.848558),(1.971474,-0.581232,1.073608),(1.953004,-0.612012,1.331536),(1.938578,-0.655227,1.62666),(1.9067,-0.707037,1.954843),(1.836959,-0.762838,2.303474),(1.713381,-0.817672,2.652833),(1.52706,-0.866668,2.97864),(1.277647,-0.905471,3.255391),(0.973487,-0.930634,3.459979),(0.630375,-0.93992,3.575035),(0.269144,-0.932505,3.591477),(-0.08753,-0.909048,3.50986),(-0.418596,-0.871633,3.340318),(-0.70781,-0.823584,3.101116),(-0.946132,-0.76917,2.816018),(-1.132951,-0.713227,2.510877),(-1.275937,-0.660726,2.209988),(-1.389549,-0.616331,1.932745),(-1.492426,-0.583987,1.691124),(-1.604074,-0.566568,1.488363),(-1.741382,-0.565621,1.319046),(-1.915509,-0.581232,1.170543),(-2.129646,-0.612012,1.025583),(-2.378018,-0.655227,0.865528),(-2.646294,-0.707037,0.673829),(-2.913346,-0.762838,0.439116),(-3.154111,-0.817672,0.157415),(-3.343108,-0.866668,-0.166848),(-3.458075,-0.905471,-0.521221),(-3.483173,-0.930634,-0.886925),(-3.411259,-0.93992,-1.241597),(-3.244883,-0.932505,-1.562653),(-2.995862,-0.909048,-1.830733),(-2.683502,-0.871633,-2.032674),(-2.331741,-0.823584,-2.163539),(-1.965677,-0.76917,-2.227383),(-1.608008,-0.713227,-2.236602),(-1.275937,-0.660726,-2.209988),(-0.979032,-0.616331,-2.169758),(-0.718343,-0.583987,-2.13804),(-0.486923,-0.566568,-2.13335),(-0.271636,-0.565621,-2.167604),(-0.055966,-0.581232,-2.244151),(0.176642,-0.612012,-2.357119),(0.43944,-0.655227,-2.492188),(0.739594,-0.707037,-2.628673),(1.076387,-0.762838,-2.74259),(1.44073,-0.817672,-2.810248),(1.816048,-0.866668,-2.811793),(2.180428,-0.905471,-2.73417),(2.509686,-0.930634,-2.573054),(2.780884,-0.93992,-2.333438),(2.975739,-0.932505,-2.028824),(3.083393,-0.909048,-1.679126),(3.102098,-0.871633,-1.307644),(3.03955,-0.823584,-0.937577),(2.911809,-0.76917,-0.588635),(2.740958,-0.713227,-0.274274),(2.551874,-0.660726,0.0),(2.355137,-0.872247,0.0),(2.207172,-0.821529,0.220861),(2.091813,-0.790394,0.422869),(2.016644,-0.781607,0.622052),(1.980372,-0.79595,0.834797),(1.973248,-0.832149,1.074574),(1.978786,-0.886985,1.349113),(1.976522,-0.955588,1.658499),(1.945365,-1.031862,1.994484),(1.86702,-1.109029,2.341169),(1.728945,-1.180233,2.67693),(1.526387,-1.239146,2.977328),(1.263184,-1.280535,3.21854),(0.951206,-1.300721,3.380787),(0.608544,-1.297912,3.451226),(0.256732,-1.272356,3.425857),(-0.08255,-1.226324,3.310145),(-0.390768,-1.163907,3.118254),(-0.655289,-1.090651,2.871011),(-0.871174,-1.013064,2.592916),(-1.041702,-0.93804,2.308648),(-1.177568,-0.872247,2.039608),(-1.294857,-0.821529,1.801037),(-1.412122,-0.790394,1.600128),(-1.547035,-0.781607,1.435439),(-1.713142,-0.79595,1.297654),(-1.917232,-0.832149,1.171596),(-2.157759,-0.886985,1.039122),(-2.424563,-0.955588,0.882469),(-2.699957,-1.031862,0.687493),(-2.961022,-1.109029,0.446302),(-3.182762,-1.180233,0.158845),(-3.341636,-1.239146,-0.166774),(-3.41893,-1.280535,-0.515321),(-3.40345,-1.300721,-0.866625),(-3.293121,-1.297912,-1.198598),(-3.095245,-1.272356,-1.490592),(-2.825395,-1.226324,-1.726563),(-2.505103,-1.163907,-1.897542),(-2.158724,-1.090651,-2.003003),(-1.809945,-1.013064,-2.050917),(-1.478497,-0.93804,-2.056464),(-1.177568,-0.872247,-2.039608),(-0.912315,-0.821529,-2.021898),(-0.679691,-0.790394,-2.022998),(-0.469609,-0.781607,-2.057491),(-0.267231,-0.79595,-2.132451),(-0.056016,-0.832149,-2.24617),(0.178973,-0.886985,-2.388235),(0.448041,-0.955588,-2.540967),(0.754592,-1.031862,-2.681978),(1.094002,-1.109029,-2.787471),(1.453817,-1.180233,-2.835775),(1.815248,-1.239146,-2.810554),(2.155746,-1.280535,-2.70322),(2.452244,-1.300721,-2.514162),(2.684577,-1.297912,-2.252628),(2.838513,-1.272356,-1.935265),(2.907945,-1.226324,-1.583582),(2.895871,-1.163907,-1.220712),(2.814013,-1.090651,-0.868008),(2.681118,-1.013064,-0.542),(2.520199,-0.93804,-0.252184),(2.355137,-0.872247,0.0),(2.160942,-1.059993,0.0),(2.052859,-1.012004,0.20542),(1.981208,-0.991488,0.40051),(1.948585,-1.000266,0.601059),(1.949113,-1.037559,0.82162),(1.969509,-1.100053,1.072538),(1.991293,-1.182196,1.357641),(1.993788,-1.276688,1.672987),(1.957437,-1.375134,2.006861),(1.86693,-1.468785,2.341056),(1.713637,-1.549322,2.653229),(1.496995,-1.609588,2.919997),(1.224618,-1.644227,3.120275),(0.91113,-1.650163,3.23835),(0.57592,-1.626867,3.266207),(0.240162,-1.57641,3.204743),(-0.076403,-1.503274,3.063681),(-0.358427,-1.413959,2.860181),(-0.597172,-1.316401,2.61638),(-0.791645,-1.219267,2.356211),(-0.948463,-1.131189,2.102011),(-1.080471,-1.059993,1.871431),(-1.204328,-1.012004,1.675118),(-1.337456,-0.991488,1.515521),(-1.494825,-1.000266,1.386995),(-1.686101,-1.037559,1.277172),(-1.913599,-1.100053,1.169376),(-2.171398,-1.182196,1.04569),(-2.445743,-1.276688,0.890178),(-2.716712,-1.375134,0.69176),(-2.960879,-1.468785,0.446281),(-3.154582,-1.549322,0.157439),(-3.277289,-1.609588,-0.163563),(-3.314546,-1.644227,-0.499587),(-3.260059,-1.650163,-0.830113),(-3.116579,-1.626867,-1.134342),(-2.89547,-1.57641,-1.394385),(-2.615024,-1.503274,-1.598008),(-2.297776,-1.413959,-1.740498),(-1.967266,-1.316401,-1.825356),(-1.644716,-1.219267,-1.86369),(-1.346163,-1.131189,-1.872399),(-1.080471,-1.059993,-1.871431),(-0.848531,-1.012004,-1.880538),(-0.643752,-0.991488,-1.916031),(-0.45376,-1.000266,-1.988054),(-0.263013,-1.037559,-2.098792),(-0.05591,-1.100053,-2.241914),(0.180105,-1.182196,-2.403331),(0.451955,-1.276688,-2.563164),(0.759274,-1.375134,-2.698621),(1.093949,-1.468785,-2.787336),(1.440945,-1.549322,-2.810667),(1.780294,-1.609588,-2.756434),(2.089928,-1.644227,-2.620687),(2.348928,-1.650163,-2.408237),(2.540658,-1.626867,-2.131865),(2.655308,-1.57641,-1.810358),(2.691427,-1.503274,-1.465673),(2.656203,-1.413959,-1.119684),(2.564438,-1.316401,-0.791024),(2.436361,-1.219267,-0.492521),(2.294626,-1.131189,-0.229612),(2.160942,-1.059993,0.0),(1.974495,-1.230712,0.0),(1.907734,-1.195038,0.190898),(1.877901,-1.194182,0.379626),(1.882954,-1.22822,0.580814),(1.913202,-1.294128,0.806482),(1.95291,-1.386049,1.063498),(1.982819,-1.495815,1.351863),(1.983214,-1.613675,1.664114),(1.937029,-1.729154,1.985937),(1.832537,-1.831993,2.297929),(1.665189,-1.913054,2.578217),(1.438325,-1.965133,2.805557),(1.162661,-1.983605,2.962412),(0.854632,-1.966826,3.037542),(0.533864,-1.916289,3.027694),(0.220182,-1.836484,2.938127),(-0.069376,-1.734501,2.781884),(-0.323056,-1.619402,2.577927),(-0.536008,-1.501415,2.348404),(-0.710763,-1.391023,2.11548),(-0.856507,-1.298034,1.898214),(-0.987248,-1.230712,1.709963),(-1.119189,-1.195038,1.556698),(-1.267716,-1.194182,1.436497),(-1.444477,-1.22822,1.340279),(-1.655035,-1.294128,1.25364),(-1.897471,-1.386049,1.15952),(-2.162158,-1.495815,1.04124),(-2.432772,-1.613675,0.885456),(-2.688386,-1.729154,0.684547),(-2.906333,-1.831993,0.438059),(-3.065395,-1.913054,0.152988),(-3.148846,-1.965133,-0.157152),(-3.146855,-1.983605,-0.474312),(-3.057905,-1.966826,-0.778638),(-2.888992,-1.916289,-1.051507),(-2.654583,-1.836484,-1.27838),(-2.374494,-1.734501,-1.451023),(-2.071022,-1.619402,-1.568738),(-1.765773,-1.501415,-1.638398),(-1.476677,-1.391023,-1.673279),(-1.215648,-1.298034,-1.690864),(-0.987248,-1.230712,-1.709963),(-0.788545,-1.195038,-1.747595),(-0.610185,-1.194182,-1.816123),(-0.438477,-1.22822,-1.921093),(-0.258167,-1.294128,-2.060123),(-0.055439,-1.386049,-2.223018),(0.179338,-1.495815,-2.393104),(0.449558,-1.613675,-2.54957),(0.751358,-1.729154,-2.670485),(1.073796,-1.831993,-2.735988),(1.400207,-1.913054,-2.731204),(1.710521,-1.965133,-2.648404),(1.984194,-1.983605,-2.4881),(2.203273,-1.966826,-2.258904),(2.355128,-1.916289,-1.976187),(2.434401,-1.836484,-1.659747),(2.44387,-1.734501,-1.330861),(2.394078,-1.619402,-1.009189),(2.301781,-1.501415,-0.710005),(2.187441,-1.391023,-0.442201),(2.072155,-1.298034,-0.20735),(1.974495,-1.230712,0.0),(1.798178,-1.391894,0.0),(1.771024,-1.377721,0.177218),(1.77823,-1.404296,0.359477),(1.813798,-1.469259,0.559482),(1.865239,-1.566836,0.786264),(1.915559,-1.688358,1.043158),(1.945922,-1.823027,1.326707),(1.938598,-1.958877,1.626677),(1.87972,-2.083837,1.927182),(1.761432,-2.186804,2.208766),(1.5831,-2.258628,2.451118),(1.351396,-2.292929,2.635996),(1.07926,-2.286657,2.74991),(0.783899,-2.240371,2.786143),(0.484156,-2.158183,2.745785),(0.197662,-2.047396,2.637622),(-0.06177,-1.917854,2.476893),(-0.286108,-1.781067,2.283091),(-0.474098,-1.649189,2.077158),(-0.63114,-1.533938,1.878493),(-0.76808,-1.445555,1.702241),(-0.899089,-1.391894,1.557268),(-1.038987,-1.377721,1.445143),(-1.200431,-1.404296,1.360254),(-1.391425,-1.469259,1.291054),(-1.613544,-1.566836,1.222212),(-1.86118,-1.688358,1.137344),(-2.121923,-1.823027,1.021864),(-2.378043,-1.958877,0.865537),(-2.608849,-2.083837,0.664294),(-2.793563,-2.186804,0.421062),(-2.91428,-2.258628,0.145446),(-2.958537,-2.292929,-0.147654),(-2.921123,-2.286657,-0.440288),(-2.804821,-2.240371,-0.714195),(-2.619997,-2.158183,-0.953601),(-2.383079,-2.047396,-1.14763),(-2.114167,-1.917854,-1.291941),(-1.834161,-1.781067,-1.389323),(-1.561823,-1.649189,-1.44916),(-1.311253,-1.533938,-1.48583),(-1.090143,-1.445555,-1.516297),(-0.899089,-1.391894,-1.557268),(-0.732037,-1.377721,-1.622361),(-0.577799,-1.404296,-1.719731),(-0.422373,-1.469259,-1.850536),(-0.251695,-1.566836,-2.008476),(-0.054378,-1.688358,-2.180501),(0.176001,-1.823027,-2.348572),(0.439445,-1.958877,-2.492214),(0.729128,-2.083837,-2.591476),(1.032131,-2.186804,-2.629828),(1.33118,-2.258628,-2.596563),(1.607141,-2.292929,-2.488341),(1.841862,-2.286657,-2.309622),(2.020921,-2.240371,-2.071948),(2.135841,-2.158183,-1.792184),(2.185416,-2.047396,-1.489992),(2.175937,-1.917854,-1.184952),(2.120269,-1.781067,-0.893768),(2.035921,-1.649189,-0.627998),(1.942393,-1.533938,-0.392663),(1.858224,-1.445555,-0.185943),(1.798178,-1.391894,0.0),(1.631481,-1.550839,0.0),(1.639299,-1.566052,0.164037),(1.676395,-1.625767,0.338891),(1.733755,-1.72468,0.534793),(1.797253,-1.854,0.757606),(1.849844,-2.002237,1.007371),(1.874192,-2.15622,1.277803),(1.855347,-2.302266,1.556821),(1.783034,-2.4274,1.828054),(1.653224,-2.520501,2.073077),(1.468731,-2.573298,2.274041),(1.238756,-2.581099,2.416282),(0.977454,-2.543212,2.490513),(0.701768,-2.463002,2.494233),(0.428854,-2.347597,2.432151),(0.173525,-2.207251,2.315534),(-0.053882,-2.054434,2.160591),(-0.248894,-1.902725,1.986131),(-0.413313,-1.765603,1.810844),(-0.554589,-1.655253,1.65065),(-0.684265,-1.58148,1.516487),(-0.815741,-1.550839,1.412904),(-0.961709,-1.566052,1.337656),(-1.131685,-1.625767,1.282355),(-1.330021,-1.72468,1.234079),(-1.554732,-1.854,1.177664),(-1.797331,-2.002237,1.098326),(-2.043705,-2.15622,0.984197),(-2.275919,-2.302266,0.828367),(-2.474658,-2.4274,0.630125),(-2.62195,-2.520501,0.395195),(-2.703743,-2.573298,0.134938),(-2.71194,-2.581099,-0.135347),(-2.645575,-2.543212,-0.398756),(-2.510954,-2.463002,-0.639367),(-2.320731,-2.347597,-0.844677),(-2.092074,-2.207251,-1.00749),(-1.844186,-2.054434,-1.126959),(-1.595592,-1.902725,-1.208614),(-1.36158,-1.765603,-1.263362),(-1.15221,-1.655253,-1.305613),(-0.971184,-1.58148,-1.350834),(-0.815741,-1.550839,-1.412904),(-0.67759,-1.566052,-1.501693),(-0.54471,-1.625767,-1.621246),(-0.403733,-1.72468,-1.768872),(-0.242521,-1.854,-1.93527),(-0.052513,-2.002237,-2.105697),(0.169513,-2.15622,-2.261999),(0.420573,-2.302266,-2.385188),(0.691624,-2.4274,-2.458179),(0.968726,-2.520501,-2.468273),(1.235012,-2.573298,-2.408979),(1.473184,-2.581099,-2.280935),(1.66812,-2.543212,-2.091757),(1.809185,-2.463002,-1.854866),(1.891878,-2.347597,-1.587474),(1.918548,-2.207251,-1.308044),(1.898068,-2.054434,-1.033633),(1.844487,-1.902725,-0.777516),(1.774894,-1.765603,-0.547482),(1.706799,-1.655253,-0.345037),(1.655449,-1.58148,-0.165653),(1.631481,-1.550839,0.0),(1.471222,-1.713768,0.0),(1.506955,-1.764159,0.150794),(1.565142,-1.860053,0.3164),(1.634865,-1.99293,0.504289),(1.70156,-2.150984,0.717268),(1.749242,-2.32017,0.952587),(1.762941,-2.485456,1.201953),(1.730978,-2.632155,1.452463),(1.646737,-2.747233,1.688316),(1.509649,-2.820464,1.89304),(1.325248,-2.845341,2.051885),(1.104301,-2.819655,2.154018),(0.861143,-2.745686,2.194157),(0.6115,-2.630008,2.173402),(0.370131,-2.4829,2.099117),(0.148672,-2.317432,1.983887),(-0.045979,-2.148306,1.843687),(-0.212483,-1.990552,1.695571),(-0.354965,-1.858185,1.555204),(-0.482016,-1.762967,1.434648),(-0.60495,-1.713359,1.340707),(-0.735611,-1.713768,1.274115),(-0.884068,-1.764159,1.229664),(-1.056582,-1.860053,1.197253),(-1.25416,-1.99293,1.16369),(-1.471952,-2.150984,1.11496),(-1.699585,-2.32017,1.038595),(-1.922392,-2.485456,0.925775),(-2.123359,-2.632155,0.772839),(-2.285493,-2.747233,0.581958),(-2.394245,-2.820464,0.360874),(-2.439609,-2.845341,0.121756),(-2.417585,-2.819655,-0.120657),(-2.330767,-2.745686,-0.351307),(-2.187971,-2.630008,-0.557126),(-2.002954,-2.4829,-0.729016),(-1.792432,-2.317432,-0.86319),(-1.573691,-2.148306,-0.961662),(-1.362166,-1.990552,-1.031801),(-1.169364,-1.858185,-1.085011),(-1.001433,-1.762967,-1.134762),(-0.858611,-1.713359,-1.194255),(-0.735611,-1.713768,-1.274115),(-0.622886,-1.764159,-1.380458),(-0.50856,-1.860053,-1.513653),(-0.380705,-1.99293,-1.667979),(-0.229608,-2.150984,-1.832228),(-0.049657,-2.32017,-1.991182),(0.159451,-2.485456,-2.127728),(0.392381,-2.632155,-2.225302),(0.638756,-2.747233,-2.270274),(0.884596,-2.820464,-2.253914),(1.114361,-2.845341,-2.173641),(1.313284,-2.819655,-2.033362),(1.469624,-2.745686,-1.84285),(1.576471,-2.630008,-1.616276),(1.632823,-2.4829,-1.370101),(1.64376,-2.317432,-1.120697),(1.619669,-2.148306,-0.882025),(1.574649,-1.990552,-0.66377),(1.524329,-1.858185,-0.470193),(1.483449,-1.762967,-0.299886),(1.463561,-1.713359,-0.146451),(1.471222,-1.713768,0.0),(1.312024,-1.885036,0.0),(1.366908,-1.973698,0.13678),(1.436601,-2.105773,0.290415),(1.509459,-2.269527,0.465606),(1.57161,-2.450409,0.662489),(1.609048,-2.632346,0.876241),(1.609746,-2.799173,1.097506),(1.56546,-2.936067,1.313577),(1.472961,-3.030863,1.510152),(1.334493,-3.075139,1.673401),(1.157401,-3.064961,1.792007),(0.952988,-3.001233,1.858871),(0.734786,-2.889618,1.872204),(0.516525,-2.740033,1.835839),(0.310106,-2.565769,1.758697),(0.123913,-2.38231,1.6535),(-0.038278,-2.205958,1.534915),(-0.177625,-2.052383,1.417414),(-0.299727,-1.935229,1.313188),(-0.4134,-1.864907,1.230423),(-0.528921,-1.847665,1.172208),(-0.656012,-1.885036,1.136246),(-0.801909,-1.973698,1.115387),(-0.969807,-2.105773,1.098925),(-1.157956,-2.269527,1.074426),(-1.359537,-2.450409,1.029809),(-1.563371,-2.632346,0.955356),(-1.755341,-2.799173,0.845328),(-1.920321,-2.936067,0.69894),(-2.04431,-3.030863,0.520545),(-2.116454,-3.075139,0.319004),(-2.130624,-3.064961,0.106335),(-2.086323,-3.001233,-0.104124),(-1.98877,-2.889618,-0.299759),(-1.848146,-2.740033,-0.470596),(-1.678129,-2.565769,-0.610789),(-1.49393,-2.38231,-0.719439),(-1.310136,-2.205958,-0.800608),(-1.138704,-2.052383,-0.862535),(-0.987391,-1.935229,-0.916165),(-0.858877,-1.864907,-0.973226),(-0.750702,-1.847665,-1.044163),(-0.656012,-1.885036,-1.136246),(-0.564999,-1.973698,-1.252167),(-0.466794,-2.105773,-1.389341),(-0.351502,-2.269527,-1.540033),(-0.212073,-2.450409,-1.692298),(-0.045677,-2.632346,-1.831597),(0.145595,-2.799173,-1.942834),(0.354861,-2.936067,-2.012516),(0.57135,-3.030863,-2.030697),(0.781961,-3.075139,-1.992405),(0.973223,-3.064961,-1.898342),(1.133336,-3.001233,-1.754747),(1.253984,-2.889618,-1.572446),(1.331621,-2.740033,-1.365243),(1.368023,-2.565769,-1.147908),(1.370017,-2.38231,-0.934062),(1.348415,-2.205958,-0.734307),(1.316329,-2.052383,-0.554879),(1.287118,-1.935229,-0.397023),(1.272277,-1.864907,-0.257196),(1.279623,-1.847665,-0.128046),(1.312024,-1.885036,0.0),(1.147019,-2.066533,0.0),(1.211442,-2.1935,0.121223),(1.283191,-2.358633,0.259403),(1.351031,-2.54726,0.416738),(1.402743,-2.74262,0.591306),(1.426947,-2.927356,0.777074),(1.414804,-3.085051,0.964597),(1.361326,-3.201695,1.142288),(1.266106,-3.266922,1.298074),(1.133342,-3.274938,1.421165),(0.971178,-3.22503,1.503678),(0.790452,-3.121632,1.541834),(0.603056,-2.973933,1.536563),(0.420177,-2.795054,1.493398),(0.250681,-2.600892,1.421681),(0.099909,-2.408698,1.333198),(-0.030935,-2.235549,1.240445),(-0.144716,-2.09683,1.154803),(-0.247619,-2.004867,1.084892),(-0.347862,-1.967831,1.03536),(-0.454058,-1.989014,1.006296),(-0.57351,-2.066533,0.993348),(-0.710703,-2.1935,0.988528),(-0.866245,-2.358633,0.981575),(-1.036421,-2.54726,0.961659),(-1.213458,-2.74262,0.919158),(-1.38644,-2.927356,0.847236),(-1.542768,-3.085051,0.742958),(-1.669914,-3.201695,0.607799),(-1.757218,-3.266922,0.447443),(-1.797436,-3.274938,0.27092),(-1.787812,-3.22503,0.089226),(-1.730493,-3.121632,-0.086365),(-1.632231,-2.973933,-0.246019),(-1.503409,-2.795054,-0.382815),(-1.356552,-2.600892,-0.493745),(-1.204538,-2.408698,-0.580075),(-1.058789,-2.235549,-0.647013),(-0.927731,-2.09683,-0.702729),(-0.815734,-2.004867,-0.756891),(-0.722717,-1.967831,-0.818938),(-0.644449,-1.989014,-0.896374),(-0.57351,-2.066533,-0.993348),(-0.500739,-2.1935,-1.109751),(-0.416946,-2.358633,-1.240977),(-0.31461,-2.54726,-1.378397),(-0.189286,-2.74262,-1.510464),(-0.040508,-2.927356,-1.62431),(0.127964,-3.085051,-1.707555),(0.308588,-3.201695,-1.750088),(0.491112,-3.266922,-1.745517),(0.664095,-3.274938,-1.692085),(0.816634,-3.22503,-1.592904),(0.940041,-3.121632,-1.455469),(1.029174,-2.973933,-1.290544),(1.083232,-2.795054,-1.110583),(1.105872,-2.600892,-0.927936),(1.104629,-2.408698,-0.753123),(1.089724,-2.235549,-0.593432),(1.072447,-2.09683,-0.452074),(1.063354,-2.004867,-0.328001),(1.070579,-1.967831,-0.216422),(1.098507,-1.989014,-0.109922),(1.147019,-2.066533,0.0),(0.968698,-2.257333,0.0),(1.033126,-2.41949,0.10338),(1.098515,-2.611625,0.22207),(1.155027,-2.816667,0.356278),(1.192793,-3.016395,0.502804),(1.203384,-3.193064,0.655328),(1.181054,-3.330975,0.805229),(1.123577,-3.417875,0.942793),(1.032562,-3.446042,1.058633),(0.913177,-3.412973,1.145088),(0.773353,-3.321607,1.197385),(0.622578,-3.180062,1.214383),(0.470484,-3.000915,1.198774),(0.325445,-2.800083,1.156699),(0.193406,-2.595413,1.096858),(0.077129,-2.405088,1.029219),(-0.024029,-2.246022,0.963544),(-0.113782,-2.132347,0.90796),(-0.198064,-2.074163,0.867777),(-0.283822,-2.076642,0.844752),(-0.377627,-2.139562,0.836907),(-0.484349,-2.257333,0.838917),(-0.606092,-2.41949,0.843023),(-0.741576,-2.611625,0.840307),(-0.886059,-2.816667,0.822143),(-1.031838,-3.016395,0.781587),(-1.169223,-3.193064,0.714497),(-1.287875,-3.330975,0.620208),(-1.378271,-3.417875,0.50165),(-1.433084,-3.446042,0.364908),(-1.448263,-3.412973,0.218291),(-1.423642,-3.321607,0.071051),(-1.362976,-3.180062,-0.068023),(-1.27341,-3.000915,-0.191936),(-1.164453,-2.800083,-0.296506),(-1.04661,-2.595413,-0.380935),(-0.929894,-2.405088,-0.447813),(-0.822439,-2.246022,-0.502582),(-0.729426,-2.132347,-0.552518),(-0.652485,-2.074163,-0.605417),(-0.589666,-2.076642,-0.668173),(-0.535969,-2.139562,-0.745488),(-0.484349,-2.257333,-0.838917),(-0.427033,-2.41949,-0.946403),(-0.35694,-2.611625,-1.062377),(-0.268967,-2.816667,-1.178422),(-0.160955,-3.016395,-1.284391),(-0.034161,-3.193064,-1.369826),(0.106822,-3.330975,-1.425437),(0.254694,-3.417875,-1.444443),(0.400522,-3.446042,-1.423541),(0.535087,-3.412973,-1.363378),(0.650289,-3.321607,-1.268436),(0.740398,-3.180062,-1.14636),(0.802926,-3.000915,-1.006838),(0.839009,-2.800083,-0.860193),(0.853204,-2.595413,-0.715924),(0.852765,-2.405088,-0.581405),(0.846468,-2.246022,-0.460962),(0.843208,-2.132347,-0.355442),(0.850549,-2.074163,-0.26236),(0.873488,-2.076642,-0.176579),(0.913596,-2.139562,-0.091419),(0.968698,-2.257333,0.0),(0.769827,-2.453616,0.0),(0.825719,-2.6449,0.082626),(0.878158,-2.855511,0.177524),(0.919447,-3.066736,0.283612),(0.942459,-3.259807,0.39728),(0.94169,-3.417568,0.512817),(0.91406,-3.526001,0.623195),(0.859357,-3.575472,0.721087),(0.780248,-3.561585,0.799949),(0.681852,-3.485574,0.855015),(0.570967,-3.354193,0.88403),(0.455049,-3.179115,0.887606),(0.341117,-2.975898,0.869151),(0.234756,-2.762597,0.834374),(0.139375,-2.558166,0.790436),(0.055821,-2.380769,0.744882),(-0.01757,-2.246168,0.704521),(-0.084515,-2.166324,0.674414),(-0.149989,-2.148331,0.657144),(-0.219216,-2.193788,0.652464),(-0.296623,-2.298656,0.657385),(-0.384913,-2.453616,0.66669),(-0.484415,-2.6449,0.673781),(-0.592819,-2.855511,0.671746),(-0.705339,-3.066736,0.654459),(-0.815284,-3.259807,0.617554),(-0.914957,-3.417568,0.559119),(-0.996733,-3.526001,0.480001),(-1.054158,-3.575472,0.383682),(-1.0829,-3.561585,0.27574),(-1.081391,-3.485574,0.162993),(-1.051077,-3.354193,0.052457),(-0.996214,-3.179115,-0.049719),(-0.923265,-2.975898,-0.13916),(-0.839967,-2.762597,-0.213882),(-0.754225,-2.558166,-0.274516),(-0.672998,-2.380769,-0.324099),(-0.601348,-2.246168,-0.367476),(-0.541802,-2.166324,-0.410399),(-0.494109,-2.148331,-0.458466),(-0.455442,-2.193788,-0.516079),(-0.421001,-2.298656,-0.585576),(-0.384913,-2.453616,-0.66669),(-0.341304,-2.6449,-0.756406),(-0.285339,-2.855511,-0.849269),(-0.214108,-3.066736,-0.93807),(-0.127175,-3.259807,-1.014833),(-0.026732,-3.417568,-1.071935),(0.082673,-3.526001,-1.103196),(0.194801,-3.575472,-1.104769),(0.302652,-3.561585,-1.075689),(0.399539,-3.485574,-1.018009),(0.480109,-3.354193,-0.936488),(0.541165,-3.179115,-0.837887),(0.582149,-2.975898,-0.729991),(0.605211,-2.762597,-0.620492),(0.61485,-2.558166,-0.51592),(0.617176,-2.380769,-0.420784),(0.618918,-2.246168,-0.337045),(0.626317,-2.166324,-0.264015),(0.644097,-2.148331,-0.198678),(0.674658,-2.193788,-0.136385),(0.717624,-2.298656,-0.071809),(0.769827,-2.453616,0.0),(0.544358,-2.648877,0.0),(0.584976,-2.860741,0.058536),(0.62031,-3.079521,0.125398),(0.645246,-3.285779,0.199032),(0.655439,-3.461188,0.276291),(0.647949,-3.590162,0.352854),(0.621665,-3.661241,0.423844),(0.577456,-3.668109,0.484543),(0.518026,-3.610156,0.531106),(0.447499,-3.492531,0.561147),(0.370801,-3.325686,0.574112),(0.292928,-3.124447,0.571378),(0.218233,-2.906693,0.556049),(0.149822,-2.691773,0.532498),(0.089171,-2.498784,0.505712),(0.036011,-2.344873,0.480536),(-0.011495,-2.243717,0.460952),(-0.056327,-2.204304,0.44948),(-0.101982,-2.230135,0.446814),(-0.151775,-2.318915,0.451734),(-0.208156,-2.462756,0.461322),(-0.272179,-2.648877,0.471428),(-0.343181,-2.860741,0.477336),(-0.418753,-3.079521,0.474505),(-0.494989,-3.285779,0.459283),(-0.566994,-3.461188,0.429481),(-0.629555,-3.590162,0.384713),(-0.677893,-3.661241,0.326456),(-0.708355,-3.668109,0.25782),(-0.718964,-3.610156,0.183071),(-0.709717,-3.492531,0.106973),(-0.682596,-3.325686,0.034067),(-0.641292,-3.124447,-0.032006),(-0.590669,-2.906693,-0.089029),(-0.536068,-2.691773,-0.1365),(-0.482544,-2.498784,-0.175632),(-0.434162,-2.344873,-0.209082),(-0.393449,-2.243717,-0.240431),(-0.361098,-2.204304,-0.273521),(-0.335961,-2.230135,-0.311726),(-0.315326,-2.318915,-0.357308),(-0.295438,-2.462756,-0.410929),(-0.272179,-2.648877,-0.471428),(-0.241795,-2.860741,-0.535872),(-0.201557,-3.079521,-0.599903),(-0.150256,-3.285779,-0.658315),(-0.088445,-3.461188,-0.705772),(-0.018394,-3.590162,-0.737568),(0.056227,-3.661241,-0.7503),(0.130899,-3.668109,-0.742363),(0.200938,-3.610156,-0.714177),(0.262217,-3.492531,-0.668119),(0.311795,-3.325686,-0.608179),(0.348364,-3.124447,-0.539372),(0.372436,-2.906693,-0.46702),(0.386246,-2.691773,-0.395998),(0.393374,-2.498784,-0.33008),(0.398151,-2.344873,-0.271455),(0.404944,-2.243717,-0.220521),(0.417425,-2.204304,-0.175959),(0.437943,-2.230135,-0.135088),(0.4671,-2.318915,-0.094426),(0.503594,-2.462756,-0.050392),(0.544358,-2.648877,0.0),(0.288231,-2.834409,0.0),(0.309272,-3.056512,0.030947),(0.326155,-3.272226,0.065934),(0.336448,-3.462384,0.10378),(0.338283,-3.610089,0.142598),(0.330632,-3.702218,0.180052),(0.313445,-3.730584,0.213703),(0.287655,-3.692667,0.241372),(0.255034,-3.591835,0.261473),(0.217918,-3.437049,0.273261),(0.17887,-3.242061,0.276944),(0.140299,-3.024198,0.273663),(0.104129,-2.802817,0.265316),(0.071542,-2.597588,0.254276),(0.042852,-2.426749,0.243027),(0.01752,-2.305477,0.233789),(-0.00569,-2.244549,0.228177),(-0.028442,-2.249379,0.226964),(-0.052487,-2.319537,0.22996),(-0.079309,-2.448789,0.236051),(-0.109815,-2.625651,0.243374),(-0.144116,-2.834409,0.249616),(-0.181437,-3.056512,0.252364),(-0.220178,-3.272226,0.249492),(-0.2581,-3.462384,0.239482),(-0.292635,-3.610089,0.221663),(-0.321246,-3.702218,0.196309),(-0.341795,-3.730584,0.1646),(-0.352862,-3.692667,0.128431),(-0.353959,-3.591835,0.090129),(-0.34561,-3.437049,0.052092),(-0.329276,-3.242061,0.016433),(-0.307149,-3.024198,-0.015329),(-0.281835,-2.802817,-0.04248),(-0.255981,-2.597588,-0.065181),(-0.231894,-2.426749,-0.084402),(-0.211227,-2.305477,-0.101721),(-0.194762,-2.244549,-0.119017),(-0.182336,-2.249379,-0.138114),(-0.172908,-2.319537,-0.160435),(-0.164771,-2.448789,-0.186709),(-0.155861,-2.625651,-0.21679),(-0.144116,-2.834409,-0.249616),(-0.127835,-3.056512,-0.283311),(-0.105977,-3.272226,-0.315426),(-0.078347,-3.462384,-0.343262),(-0.045648,-3.610089,-0.364261),(-0.009386,-3.702218,-0.376362),(0.02835,-3.730584,-0.378303),(0.065206,-3.692667,-0.369803),(0.098926,-3.591835,-0.351602),(0.127692,-3.437049,-0.325353),(0.150406,-3.242061,-0.293378),(0.16685,-3.024198,-0.258334),(0.177706,-2.802817,-0.222837),(0.184439,-2.597588,-0.189095),(0.189042,-2.426749,-0.158625),(0.193707,-2.305477,-0.132067),(0.200453,-2.244549,-0.109161),(0.210778,-2.249379,-0.08885),(0.225395,-2.319537,-0.069525),(0.24408,-2.448789,-0.049342),(0.265676,-2.625651,-0.026585),(0.288231,-2.834409,0.0),(0.0,-3.0,0.0),(0.0,-3.221066,0.0),(0.0,-3.42249,0.0),(0.0,-3.586374,0.0),(0.0,-3.698155,0.0),(0.0,-3.747903,0.0),(0.0,-3.731196,0.0),(0.0,-3.649519,0.0),(0.0,-3.51013,0.0),(0.0,-3.325413,0.0),(0.0,-3.111782,0.0),(0.0,-2.888218,0.0),(0.0,-2.674587,0.0),(0.0,-2.48987,0.0),(0.0,-2.350481,0.0),(0.0,-2.268804,0.0),(0.0,-2.252097,0.0),(0.0,-2.301845,0.0),(0.0,-2.413626,0.0),(0.0,-2.57751,0.0),(0.0,-2.778934,0.0),(0.0,-3.0,0.0),(0.0,-3.221066,0.0),(0.0,-3.42249,0.0),(0.0,-3.586374,0.0),(0.0,-3.698155,0.0),(0.0,-3.747903,0.0),(0.0,-3.731196,0.0),(0.0,-3.649519,0.0),(0.0,-3.51013,0.0),(0.0,-3.325413,0.0),(0.0,-3.111782,0.0),(0.0,-2.888218,0.0),(0.0,-2.674587,0.0),(0.0,-2.48987,0.0),(0.0,-2.350481,0.0),(0.0,-2.268804,0.0),(0.0,-2.252097,0.0),(0.0,-2.301845,0.0),(0.0,-2.413626,0.0),(0.0,-2.57751,0.0),(0.0,-2.778934,0.0),(0.0,-3.0,0.0),(0.0,-3.221066,0.0),(0.0,-3.42249,0.0),(0.0,-3.586374,0.0),(0.0,-3.698155,0.0),(0.0,-3.747903,0.0),(0.0,-3.731196,0.0),(0.0,-3.649519,0.0),(0.0,-3.51013,0.0),(0.0,-3.325413,0.0),(0.0,-3.111782,0.0),(0.0,-2.888218,0.0),(0.0,-2.674587,0.0),(0.0,-2.48987,0.0),(0.0,-2.350481,0.0),(0.0,-2.268804,0.0),(0.0,-2.252097,0.0),(0.0,-2.301845,0.0),(0.0,-2.413626,0.0),(0.0,-2.57751,0.0),(0.0,-2.778934,0.0),(0.0,-3.0,0.0)])))])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for IsoSurface.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python IsoSurface.py load and self-test diagnostics complete.")
