####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python HeadsUpDisplayHUD.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    meta(content='HeadsUpDisplayHUD.x3d',name='title'),
    meta(content='The Heads-up Display (HUD) world illustrates creation of a heads-up display that is locked in place to the screen. Such positioning is done by using proximity sensor translation and rotation output to position and orient a set of shapes every time the viewer moves. That set of shapes can include anything. In this example, that set of shapes includes a thumb wheel with which world content can be rotated, and a pair of start and stop buttons that control an animation of that content.',name='description'),
    meta(content='David R. Nadeau',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='1 July 1998',name='created'),
    meta(content='2 February 2014',name='translated'),
    meta(content='20 October 2019',name='modified'),
    meta(content='originals/hud.wrl',name='reference'),
    meta(content='http://www.siggraph.org/s98',name='reference'),
    meta(content='http://www.siggraph.org/s98/conference/courses/18.html',name='reference'),
    meta(content='http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0386.htm',name='reference'),
    meta(content='http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/X3dResources.html',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/HeadsUpDisplayHUD.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(info=["Copyright (c) 1997, David R. Nadeau"],title='Heads-up Display'),
    Viewpoint(description='Entry view',orientation=(0.0,1.0,0.0,0.785),position=(8.0,0.4,8.0)),
    NavigationInfo(),
    Background(skyAngle=[1.57,1.87],skyColor=[(0.0,0.0,0.0),(0.0,0.0,0.0),(0.0,0.1,0.3)]),
    Shape(
      appearance=Appearance(
        textureTransform=TextureTransform(translation=(0.5,0.5)),
        texture=ImageTexture(DEF='Grill',url=["grill.png","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/grill.png"])),
      geometry=IndexedFaceSet(coordIndex=[0,1,2,3,-1,4,5,6,7,-1,8,9,10,11,-1],solid=False,texCoordIndex=[0,1,2,3,-1,1,2,3,0,-1,0,1,2,3,-1],
        texCoord=TextureCoordinate(point=[(0.0,0.0),(4.0,0.0),(4.0,4.0),(0.0,4.0)]),
        coord=Coordinate(point=[(-2.0,-2.0,2.0),(-2.0,-2.0,-2.0),(-2.0,2.0,-2.0),(-2.0,2.0,2.0),(-2.0,-2.0,2.0),(2.0,-2.0,2.0),(2.0,-2.0,-2.0),(-2.0,-2.0,-2.0),(-2.0,-2.0,-2.0),(2.0,-2.0,-2.0),(2.0,2.0,-2.0),(-2.0,2.0,-2.0)]))),
    Transform(DEF='Blob',scale=(0.2,0.2,0.2),
      children=[
      Shape(
        appearance=Appearance(
          material=Material(diffuseColor=(1.0,0.5,0.0),transparency=0.5)),
        geometry=IndexedFaceSet(ccw=False,coordIndex=[0,1,65,64,-1,1,2,66,65,-1,2,3,67,66,-1,3,4,68,67,-1,4,5,69,68,-1,5,6,70,69,-1,6,7,71,70,-1,7,8,72,71,-1,8,9,73,72,-1,9,10,74,73,-1,10,11,75,74,-1,11,12,76,75,-1,12,13,77,76,-1,13,14,78,77,-1,14,15,79,78,-1,15,16,80,79,-1,16,17,81,80,-1,17,18,82,81,-1,18,19,83,82,-1,19,20,84,83,-1,20,21,85,84,-1,21,22,86,85,-1,22,23,87,86,-1,23,24,88,87,-1,24,25,89,88,-1,25,26,90,89,-1,26,27,91,90,-1,27,28,92,91,-1,28,29,93,92,-1,29,30,94,93,-1,30,31,95,94,-1,31,32,96,95,-1,32,33,97,96,-1,33,34,98,97,-1,34,35,99,98,-1,35,36,100,99,-1,36,37,101,100,-1,37,38,102,101,-1,38,39,103,102,-1,39,40,104,103,-1,40,41,105,104,-1,41,42,106,105,-1,42,43,107,106,-1,43,44,108,107,-1,44,45,109,108,-1,45,46,110,109,-1,46,47,111,110,-1,47,48,112,111,-1,48,49,113,112,-1,49,50,114,113,-1,50,51,115,114,-1,51,52,116,115,-1,52,53,117,116,-1,53,54,118,117,-1,54,55,119,118,-1,55,56,120,119,-1,56,57,121,120,-1,57,58,122,121,-1,58,59,123,122,-1,59,60,124,123,-1,60,61,125,124,-1,61,62,126,125,-1,62,63,127,126,-1,63,0,64,127,-1,64,65,129,128,-1,65,66,130,129,-1,66,67,131,130,-1,67,68,132,131,-1,68,69,133,132,-1,69,70,134,133,-1,70,71,135,134,-1,71,72,136,135,-1,72,73,137,136,-1,73,74,138,137,-1,74,75,139,138,-1,75,76,140,139,-1,76,77,141,140,-1,77,78,142,141,-1,78,79,143,142,-1,79,80,144,143,-1,80,81,145,144,-1,81,82,146,145,-1,82,83,147,146,-1,83,84,148,147,-1,84,85,149,148,-1,85,86,150,149,-1,86,87,151,150,-1,87,88,152,151,-1,88,89,153,152,-1,89,90,154,153,-1,90,91,155,154,-1,91,92,156,155,-1,92,93,157,156,-1,93,94,158,157,-1,94,95,159,158,-1,95,96,160,159,-1,96,97,161,160,-1,97,98,162,161,-1,98,99,163,162,-1,99,100,164,163,-1,100,101,165,164,-1,101,102,166,165,-1,102,103,167,166,-1,103,104,168,167,-1,104,105,169,168,-1,105,106,170,169,-1,106,107,171,170,-1,107,108,172,171,-1,108,109,173,172,-1,109,110,174,173,-1,110,111,175,174,-1,111,112,176,175,-1,112,113,177,176,-1,113,114,178,177,-1,114,115,179,178,-1,115,116,180,179,-1,116,117,181,180,-1,117,118,182,181,-1,118,119,183,182,-1,119,120,184,183,-1,120,121,185,184,-1,121,122,186,185,-1,122,123,187,186,-1,123,124,188,187,-1,124,125,189,188,-1,125,126,190,189,-1,126,127,191,190,-1,127,64,128,191,-1,128,129,193,192,-1,129,130,194,193,-1,130,131,195,194,-1,131,132,196,195,-1,132,133,197,196,-1,133,134,198,197,-1,134,135,199,198,-1,135,136,200,199,-1,136,137,201,200,-1,137,138,202,201,-1,138,139,203,202,-1,139,140,204,203,-1,140,141,205,204,-1,141,142,206,205,-1,142,143,207,206,-1,143,144,208,207,-1,144,145,209,208,-1,145,146,210,209,-1,146,147,211,210,-1,147,148,212,211,-1,148,149,213,212,-1,149,150,214,213,-1,150,151,215,214,-1,151,152,216,215,-1,152,153,217,216,-1,153,154,218,217,-1,154,155,219,218,-1,155,156,220,219,-1,156,157,221,220,-1,157,158,222,221,-1,158,159,223,222,-1,159,160,224,223,-1,160,161,225,224,-1,161,162,226,225,-1,162,163,227,226,-1,163,164,228,227,-1,164,165,229,228,-1,165,166,230,229,-1,166,167,231,230,-1,167,168,232,231,-1,168,169,233,232,-1,169,170,234,233,-1,170,171,235,234,-1,171,172,236,235,-1,172,173,237,236,-1,173,174,238,237,-1,174,175,239,238,-1,175,176,240,239,-1,176,177,241,240,-1,177,178,242,241,-1,178,179,243,242,-1,179,180,244,243,-1,180,181,245,244,-1,181,182,246,245,-1,182,183,247,246,-1,183,184,248,247,-1,184,185,249,248,-1,185,186,250,249,-1,186,187,251,250,-1,187,188,252,251,-1,188,189,253,252,-1,189,190,254,253,-1,190,191,255,254,-1,191,128,192,255,-1,192,193,257,256,-1,193,194,258,257,-1,194,195,259,258,-1,195,196,260,259,-1,196,197,261,260,-1,197,198,262,261,-1,198,199,263,262,-1,199,200,264,263,-1,200,201,265,264,-1,201,202,266,265,-1,202,203,267,266,-1,203,204,268,267,-1,204,205,269,268,-1,205,206,270,269,-1,206,207,271,270,-1,207,208,272,271,-1,208,209,273,272,-1,209,210,274,273,-1,210,211,275,274,-1,211,212,276,275,-1,212,213,277,276,-1,213,214,278,277,-1,214,215,279,278,-1,215,216,280,279,-1,216,217,281,280,-1,217,218,282,281,-1,218,219,283,282,-1,219,220,284,283,-1,220,221,285,284,-1,221,222,286,285,-1,222,223,287,286,-1,223,224,288,287,-1,224,225,289,288,-1,225,226,290,289,-1,226,227,291,290,-1,227,228,292,291,-1,228,229,293,292,-1,229,230,294,293,-1,230,231,295,294,-1,231,232,296,295,-1,232,233,297,296,-1,233,234,298,297,-1,234,235,299,298,-1,235,236,300,299,-1,236,237,301,300,-1,237,238,302,301,-1,238,239,303,302,-1,239,240,304,303,-1,240,241,305,304,-1,241,242,306,305,-1,242,243,307,306,-1,243,244,308,307,-1,244,245,309,308,-1,245,246,310,309,-1,246,247,311,310,-1,247,248,312,311,-1,248,249,313,312,-1,249,250,314,313,-1,250,251,315,314,-1,251,252,316,315,-1,252,253,317,316,-1,253,254,318,317,-1,254,255,319,318,-1,255,192,256,319,-1,256,257,321,320,-1,257,258,322,321,-1,258,259,323,322,-1,259,260,324,323,-1,260,261,325,324,-1,261,262,326,325,-1,262,263,327,326,-1,263,264,328,327,-1,264,265,329,328,-1,265,266,330,329,-1,266,267,331,330,-1,267,268,332,331,-1,268,269,333,332,-1,269,270,334,333,-1,270,271,335,334,-1,271,272,336,335,-1,272,273,337,336,-1,273,274,338,337,-1,274,275,339,338,-1,275,276,340,339,-1,276,277,341,340,-1,277,278,342,341,-1,278,279,343,342,-1,279,280,344,343,-1,280,281,345,344,-1,281,282,346,345,-1,282,283,347,346,-1,283,284,348,347,-1,284,285,349,348,-1,285,286,350,349,-1,286,287,351,350,-1,287,288,352,351,-1,288,289,353,352,-1,289,290,354,353,-1,290,291,355,354,-1,291,292,356,355,-1,292,293,357,356,-1,293,294,358,357,-1,294,295,359,358,-1,295,296,360,359,-1,296,297,361,360,-1,297,298,362,361,-1,298,299,363,362,-1,299,300,364,363,-1,300,301,365,364,-1,301,302,366,365,-1,302,303,367,366,-1,303,304,368,367,-1,304,305,369,368,-1,305,306,370,369,-1,306,307,371,370,-1,307,308,372,371,-1,308,309,373,372,-1,309,310,374,373,-1,310,311,375,374,-1,311,312,376,375,-1,312,313,377,376,-1,313,314,378,377,-1,314,315,379,378,-1,315,316,380,379,-1,316,317,381,380,-1,317,318,382,381,-1,318,319,383,382,-1,319,256,320,383,-1,320,321,385,384,-1,321,322,386,385,-1,322,323,387,386,-1,323,324,388,387,-1,324,325,389,388,-1,325,326,390,389,-1,326,327,391,390,-1,327,328,392,391,-1,328,329,393,392,-1,329,330,394,393,-1,330,331,395,394,-1,331,332,396,395,-1,332,333,397,396,-1,333,334,398,397,-1,334,335,399,398,-1,335,336,400,399,-1,336,337,401,400,-1,337,338,402,401,-1,338,339,403,402,-1,339,340,404,403,-1,340,341,405,404,-1,341,342,406,405,-1,342,343,407,406,-1,343,344,408,407,-1,344,345,409,408,-1,345,346,410,409,-1,346,347,411,410,-1,347,348,412,411,-1,348,349,413,412,-1,349,350,414,413,-1,350,351,415,414,-1,351,352,416,415,-1,352,353,417,416,-1,353,354,418,417,-1,354,355,419,418,-1,355,356,420,419,-1,356,357,421,420,-1,357,358,422,421,-1,358,359,423,422,-1,359,360,424,423,-1,360,361,425,424,-1,361,362,426,425,-1,362,363,427,426,-1,363,364,428,427,-1,364,365,429,428,-1,365,366,430,429,-1,366,367,431,430,-1,367,368,432,431,-1,368,369,433,432,-1,369,370,434,433,-1,370,371,435,434,-1,371,372,436,435,-1,372,373,437,436,-1,373,374,438,437,-1,374,375,439,438,-1,375,376,440,439,-1,376,377,441,440,-1,377,378,442,441,-1,378,379,443,442,-1,379,380,444,443,-1,380,381,445,444,-1,381,382,446,445,-1,382,383,447,446,-1,383,320,384,447,-1,384,385,449,448,-1,385,386,450,449,-1,386,387,451,450,-1,387,388,452,451,-1,388,389,453,452,-1,389,390,454,453,-1,390,391,455,454,-1,391,392,456,455,-1,392,393,457,456,-1,393,394,458,457,-1,394,395,459,458,-1,395,396,460,459,-1,396,397,461,460,-1,397,398,462,461,-1,398,399,463,462,-1,399,400,464,463,-1,400,401,465,464,-1,401,402,466,465,-1,402,403,467,466,-1,403,404,468,467,-1,404,405,469,468,-1,405,406,470,469,-1,406,407,471,470,-1,407,408,472,471,-1,408,409,473,472,-1,409,410,474,473,-1,410,411,475,474,-1,411,412,476,475,-1,412,413,477,476,-1,413,414,478,477,-1,414,415,479,478,-1,415,416,480,479,-1,416,417,481,480,-1,417,418,482,481,-1,418,419,483,482,-1,419,420,484,483,-1,420,421,485,484,-1,421,422,486,485,-1,422,423,487,486,-1,423,424,488,487,-1,424,425,489,488,-1,425,426,490,489,-1,426,427,491,490,-1,427,428,492,491,-1,428,429,493,492,-1,429,430,494,493,-1,430,431,495,494,-1,431,432,496,495,-1,432,433,497,496,-1,433,434,498,497,-1,434,435,499,498,-1,435,436,500,499,-1,436,437,501,500,-1,437,438,502,501,-1,438,439,503,502,-1,439,440,504,503,-1,440,441,505,504,-1,441,442,506,505,-1,442,443,507,506,-1,443,444,508,507,-1,444,445,509,508,-1,445,446,510,509,-1,446,447,511,510,-1,447,384,448,511,-1,448,449,513,512,-1,449,450,514,513,-1,450,451,515,514,-1,451,452,516,515,-1,452,453,517,516,-1,453,454,518,517,-1,454,455,519,518,-1,455,456,520,519,-1,456,457,521,520,-1,457,458,522,521,-1,458,459,523,522,-1,459,460,524,523,-1,460,461,525,524,-1,461,462,526,525,-1,462,463,527,526,-1,463,464,528,527,-1,464,465,529,528,-1,465,466,530,529,-1,466,467,531,530,-1,467,468,532,531,-1,468,469,533,532,-1,469,470,534,533,-1,470,471,535,534,-1,471,472,536,535,-1,472,473,537,536,-1,473,474,538,537,-1,474,475,539,538,-1,475,476,540,539,-1,476,477,541,540,-1,477,478,542,541,-1,478,479,543,542,-1,479,480,544,543,-1,480,481,545,544,-1,481,482,546,545,-1,482,483,547,546,-1,483,484,548,547,-1,484,485,549,548,-1,485,486,550,549,-1,486,487,551,550,-1,487,488,552,551,-1,488,489,553,552,-1,489,490,554,553,-1,490,491,555,554,-1,491,492,556,555,-1,492,493,557,556,-1,493,494,558,557,-1,494,495,559,558,-1,495,496,560,559,-1,496,497,561,560,-1,497,498,562,561,-1,498,499,563,562,-1,499,500,564,563,-1,500,501,565,564,-1,501,502,566,565,-1,502,503,567,566,-1,503,504,568,567,-1,504,505,569,568,-1,505,506,570,569,-1,506,507,571,570,-1,507,508,572,571,-1,508,509,573,572,-1,509,510,574,573,-1,510,511,575,574,-1,511,448,512,575,-1,512,513,577,576,-1,513,514,578,577,-1,514,515,579,578,-1,515,516,580,579,-1,516,517,581,580,-1,517,518,582,581,-1,518,519,583,582,-1,519,520,584,583,-1,520,521,585,584,-1,521,522,586,585,-1,522,523,587,586,-1,523,524,588,587,-1,524,525,589,588,-1,525,526,590,589,-1,526,527,591,590,-1,527,528,592,591,-1,528,529,593,592,-1,529,530,594,593,-1,530,531,595,594,-1,531,532,596,595,-1,532,533,597,596,-1,533,534,598,597,-1,534,535,599,598,-1,535,536,600,599,-1,536,537,601,600,-1,537,538,602,601,-1,538,539,603,602,-1,539,540,604,603,-1,540,541,605,604,-1,541,542,606,605,-1,542,543,607,606,-1,543,544,608,607,-1,544,545,609,608,-1,545,546,610,609,-1,546,547,611,610,-1,547,548,612,611,-1,548,549,613,612,-1,549,550,614,613,-1,550,551,615,614,-1,551,552,616,615,-1,552,553,617,616,-1,553,554,618,617,-1,554,555,619,618,-1,555,556,620,619,-1,556,557,621,620,-1,557,558,622,621,-1,558,559,623,622,-1,559,560,624,623,-1,560,561,625,624,-1,561,562,626,625,-1,562,563,627,626,-1,563,564,628,627,-1,564,565,629,628,-1,565,566,630,629,-1,566,567,631,630,-1,567,568,632,631,-1,568,569,633,632,-1,569,570,634,633,-1,570,571,635,634,-1,571,572,636,635,-1,572,573,637,636,-1,573,574,638,637,-1,574,575,639,638,-1,575,512,576,639,-1,576,577,641,640,-1,577,578,642,641,-1,578,579,643,642,-1,579,580,644,643,-1,580,581,645,644,-1,581,582,646,645,-1,582,583,647,646,-1,583,584,648,647,-1,584,585,649,648,-1,585,586,650,649,-1,586,587,651,650,-1,587,588,652,651,-1,588,589,653,652,-1,589,590,654,653,-1,590,591,655,654,-1,591,592,656,655,-1,592,593,657,656,-1,593,594,658,657,-1,594,595,659,658,-1,595,596,660,659,-1,596,597,661,660,-1,597,598,662,661,-1,598,599,663,662,-1,599,600,664,663,-1,600,601,665,664,-1,601,602,666,665,-1,602,603,667,666,-1,603,604,668,667,-1,604,605,669,668,-1,605,606,670,669,-1,606,607,671,670,-1,607,608,672,671,-1,608,609,673,672,-1,609,610,674,673,-1,610,611,675,674,-1,611,612,676,675,-1,612,613,677,676,-1,613,614,678,677,-1,614,615,679,678,-1,615,616,680,679,-1,616,617,681,680,-1,617,618,682,681,-1,618,619,683,682,-1,619,620,684,683,-1,620,621,685,684,-1,621,622,686,685,-1,622,623,687,686,-1,623,624,688,687,-1,624,625,689,688,-1,625,626,690,689,-1,626,627,691,690,-1,627,628,692,691,-1,628,629,693,692,-1,629,630,694,693,-1,630,631,695,694,-1,631,632,696,695,-1,632,633,697,696,-1,633,634,698,697,-1,634,635,699,698,-1,635,636,700,699,-1,636,637,701,700,-1,637,638,702,701,-1,638,639,703,702,-1,639,576,640,703,-1,640,641,705,704,-1,641,642,706,705,-1,642,643,707,706,-1,643,644,708,707,-1,644,645,709,708,-1,645,646,710,709,-1,646,647,711,710,-1,647,648,712,711,-1,648,649,713,712,-1,649,650,714,713,-1,650,651,715,714,-1,651,652,716,715,-1,652,653,717,716,-1,653,654,718,717,-1,654,655,719,718,-1,655,656,720,719,-1,656,657,721,720,-1,657,658,722,721,-1,658,659,723,722,-1,659,660,724,723,-1,660,661,725,724,-1,661,662,726,725,-1,662,663,727,726,-1,663,664,728,727,-1,664,665,729,728,-1,665,666,730,729,-1,666,667,731,730,-1,667,668,732,731,-1,668,669,733,732,-1,669,670,734,733,-1,670,671,735,734,-1,671,672,736,735,-1,672,673,737,736,-1,673,674,738,737,-1,674,675,739,738,-1,675,676,740,739,-1,676,677,741,740,-1,677,678,742,741,-1,678,679,743,742,-1,679,680,744,743,-1,680,681,745,744,-1,681,682,746,745,-1,682,683,747,746,-1,683,684,748,747,-1,684,685,749,748,-1,685,686,750,749,-1,686,687,751,750,-1,687,688,752,751,-1,688,689,753,752,-1,689,690,754,753,-1,690,691,755,754,-1,691,692,756,755,-1,692,693,757,756,-1,693,694,758,757,-1,694,695,759,758,-1,695,696,760,759,-1,696,697,761,760,-1,697,698,762,761,-1,698,699,763,762,-1,699,700,764,763,-1,700,701,765,764,-1,701,702,766,765,-1,702,703,767,766,-1,703,640,704,767,-1,704,705,769,768,-1,705,706,770,769,-1,706,707,771,770,-1,707,708,772,771,-1,708,709,773,772,-1,709,710,774,773,-1,710,711,775,774,-1,711,712,776,775,-1,712,713,777,776,-1,713,714,778,777,-1,714,715,779,778,-1,715,716,780,779,-1,716,717,781,780,-1,717,718,782,781,-1,718,719,783,782,-1,719,720,784,783,-1,720,721,785,784,-1,721,722,786,785,-1,722,723,787,786,-1,723,724,788,787,-1,724,725,789,788,-1,725,726,790,789,-1,726,727,791,790,-1,727,728,792,791,-1,728,729,793,792,-1,729,730,794,793,-1,730,731,795,794,-1,731,732,796,795,-1,732,733,797,796,-1,733,734,798,797,-1,734,735,799,798,-1,735,736,800,799,-1,736,737,801,800,-1,737,738,802,801,-1,738,739,803,802,-1,739,740,804,803,-1,740,741,805,804,-1,741,742,806,805,-1,742,743,807,806,-1,743,744,808,807,-1,744,745,809,808,-1,745,746,810,809,-1,746,747,811,810,-1,747,748,812,811,-1,748,749,813,812,-1,749,750,814,813,-1,750,751,815,814,-1,751,752,816,815,-1,752,753,817,816,-1,753,754,818,817,-1,754,755,819,818,-1,755,756,820,819,-1,756,757,821,820,-1,757,758,822,821,-1,758,759,823,822,-1,759,760,824,823,-1,760,761,825,824,-1,761,762,826,825,-1,762,763,827,826,-1,763,764,828,827,-1,764,765,829,828,-1,765,766,830,829,-1,766,767,831,830,-1,767,704,768,831,-1,768,769,833,832,-1,769,770,834,833,-1,770,771,835,834,-1,771,772,836,835,-1,772,773,837,836,-1,773,774,838,837,-1,774,775,839,838,-1,775,776,840,839,-1,776,777,841,840,-1,777,778,842,841,-1,778,779,843,842,-1,779,780,844,843,-1,780,781,845,844,-1,781,782,846,845,-1,782,783,847,846,-1,783,784,848,847,-1,784,785,849,848,-1,785,786,850,849,-1,786,787,851,850,-1,787,788,852,851,-1,788,789,853,852,-1,789,790,854,853,-1,790,791,855,854,-1,791,792,856,855,-1,792,793,857,856,-1,793,794,858,857,-1,794,795,859,858,-1,795,796,860,859,-1,796,797,861,860,-1,797,798,862,861,-1,798,799,863,862,-1,799,800,864,863,-1,800,801,865,864,-1,801,802,866,865,-1,802,803,867,866,-1,803,804,868,867,-1,804,805,869,868,-1,805,806,870,869,-1,806,807,871,870,-1,807,808,872,871,-1,808,809,873,872,-1,809,810,874,873,-1,810,811,875,874,-1,811,812,876,875,-1,812,813,877,876,-1,813,814,878,877,-1,814,815,879,878,-1,815,816,880,879,-1,816,817,881,880,-1,817,818,882,881,-1,818,819,883,882,-1,819,820,884,883,-1,820,821,885,884,-1,821,822,886,885,-1,822,823,887,886,-1,823,824,888,887,-1,824,825,889,888,-1,825,826,890,889,-1,826,827,891,890,-1,827,828,892,891,-1,828,829,893,892,-1,829,830,894,893,-1,830,831,895,894,-1,831,768,832,895,-1,832,833,897,896,-1,833,834,898,897,-1,834,835,899,898,-1,835,836,900,899,-1,836,837,901,900,-1,837,838,902,901,-1,838,839,903,902,-1,839,840,904,903,-1,840,841,905,904,-1,841,842,906,905,-1,842,843,907,906,-1,843,844,908,907,-1,844,845,909,908,-1,845,846,910,909,-1,846,847,911,910,-1,847,848,912,911,-1,848,849,913,912,-1,849,850,914,913,-1,850,851,915,914,-1,851,852,916,915,-1,852,853,917,916,-1,853,854,918,917,-1,854,855,919,918,-1,855,856,920,919,-1,856,857,921,920,-1,857,858,922,921,-1,858,859,923,922,-1,859,860,924,923,-1,860,861,925,924,-1,861,862,926,925,-1,862,863,927,926,-1,863,864,928,927,-1,864,865,929,928,-1,865,866,930,929,-1,866,867,931,930,-1,867,868,932,931,-1,868,869,933,932,-1,869,870,934,933,-1,870,871,935,934,-1,871,872,936,935,-1,872,873,937,936,-1,873,874,938,937,-1,874,875,939,938,-1,875,876,940,939,-1,876,877,941,940,-1,877,878,942,941,-1,878,879,943,942,-1,879,880,944,943,-1,880,881,945,944,-1,881,882,946,945,-1,882,883,947,946,-1,883,884,948,947,-1,884,885,949,948,-1,885,886,950,949,-1,886,887,951,950,-1,887,888,952,951,-1,888,889,953,952,-1,889,890,954,953,-1,890,891,955,954,-1,891,892,956,955,-1,892,893,957,956,-1,893,894,958,957,-1,894,895,959,958,-1,895,832,896,959,-1,896,897,961,960,-1,897,898,962,961,-1,898,899,963,962,-1,899,900,964,963,-1,900,901,965,964,-1,901,902,966,965,-1,902,903,967,966,-1,903,904,968,967,-1,904,905,969,968,-1,905,906,970,969,-1,906,907,971,970,-1,907,908,972,971,-1,908,909,973,972,-1,909,910,974,973,-1,910,911,975,974,-1,911,912,976,975,-1,912,913,977,976,-1,913,914,978,977,-1,914,915,979,978,-1,915,916,980,979,-1,916,917,981,980,-1,917,918,982,981,-1,918,919,983,982,-1,919,920,984,983,-1,920,921,985,984,-1,921,922,986,985,-1,922,923,987,986,-1,923,924,988,987,-1,924,925,989,988,-1,925,926,990,989,-1,926,927,991,990,-1,927,928,992,991,-1,928,929,993,992,-1,929,930,994,993,-1,930,931,995,994,-1,931,932,996,995,-1,932,933,997,996,-1,933,934,998,997,-1,934,935,999,998,-1,935,936,1000,999,-1,936,937,1001,1000,-1,937,938,1002,1001,-1,938,939,1003,1002,-1,939,940,1004,1003,-1,940,941,1005,1004,-1,941,942,1006,1005,-1,942,943,1007,1006,-1,943,944,1008,1007,-1,944,945,1009,1008,-1,945,946,1010,1009,-1,946,947,1011,1010,-1,947,948,1012,1011,-1,948,949,1013,1012,-1,949,950,1014,1013,-1,950,951,1015,1014,-1,951,952,1016,1015,-1,952,953,1017,1016,-1,953,954,1018,1017,-1,954,955,1019,1018,-1,955,956,1020,1019,-1,956,957,1021,1020,-1,957,958,1022,1021,-1,958,959,1023,1022,-1,959,896,960,1023,-1,960,961,1025,1024,-1,961,962,1026,1025,-1,962,963,1027,1026,-1,963,964,1028,1027,-1,964,965,1029,1028,-1,965,966,1030,1029,-1,966,967,1031,1030,-1,967,968,1032,1031,-1,968,969,1033,1032,-1,969,970,1034,1033,-1,970,971,1035,1034,-1,971,972,1036,1035,-1,972,973,1037,1036,-1,973,974,1038,1037,-1,974,975,1039,1038,-1,975,976,1040,1039,-1,976,977,1041,1040,-1,977,978,1042,1041,-1,978,979,1043,1042,-1,979,980,1044,1043,-1,980,981,1045,1044,-1,981,982,1046,1045,-1,982,983,1047,1046,-1,983,984,1048,1047,-1,984,985,1049,1048,-1,985,986,1050,1049,-1,986,987,1051,1050,-1,987,988,1052,1051,-1,988,989,1053,1052,-1,989,990,1054,1053,-1,990,991,1055,1054,-1,991,992,1056,1055,-1,992,993,1057,1056,-1,993,994,1058,1057,-1,994,995,1059,1058,-1,995,996,1060,1059,-1,996,997,1061,1060,-1,997,998,1062,1061,-1,998,999,1063,1062,-1,999,1000,1064,1063,-1,1000,1001,1065,1064,-1,1001,1002,1066,1065,-1,1002,1003,1067,1066,-1,1003,1004,1068,1067,-1,1004,1005,1069,1068,-1,1005,1006,1070,1069,-1,1006,1007,1071,1070,-1,1007,1008,1072,1071,-1,1008,1009,1073,1072,-1,1009,1010,1074,1073,-1,1010,1011,1075,1074,-1,1011,1012,1076,1075,-1,1012,1013,1077,1076,-1,1013,1014,1078,1077,-1,1014,1015,1079,1078,-1,1015,1016,1080,1079,-1,1016,1017,1081,1080,-1,1017,1018,1082,1081,-1,1018,1019,1083,1082,-1,1019,1020,1084,1083,-1,1020,1021,1085,1084,-1,1021,1022,1086,1085,-1,1022,1023,1087,1086,-1,1023,960,1024,1087,-1,1024,1025,1089,1088,-1,1025,1026,1090,1089,-1,1026,1027,1091,1090,-1,1027,1028,1092,1091,-1,1028,1029,1093,1092,-1,1029,1030,1094,1093,-1,1030,1031,1095,1094,-1,1031,1032,1096,1095,-1,1032,1033,1097,1096,-1,1033,1034,1098,1097,-1,1034,1035,1099,1098,-1,1035,1036,1100,1099,-1,1036,1037,1101,1100,-1,1037,1038,1102,1101,-1,1038,1039,1103,1102,-1,1039,1040,1104,1103,-1,1040,1041,1105,1104,-1,1041,1042,1106,1105,-1,1042,1043,1107,1106,-1,1043,1044,1108,1107,-1,1044,1045,1109,1108,-1,1045,1046,1110,1109,-1,1046,1047,1111,1110,-1,1047,1048,1112,1111,-1,1048,1049,1113,1112,-1,1049,1050,1114,1113,-1,1050,1051,1115,1114,-1,1051,1052,1116,1115,-1,1052,1053,1117,1116,-1,1053,1054,1118,1117,-1,1054,1055,1119,1118,-1,1055,1056,1120,1119,-1,1056,1057,1121,1120,-1,1057,1058,1122,1121,-1,1058,1059,1123,1122,-1,1059,1060,1124,1123,-1,1060,1061,1125,1124,-1,1061,1062,1126,1125,-1,1062,1063,1127,1126,-1,1063,1064,1128,1127,-1,1064,1065,1129,1128,-1,1065,1066,1130,1129,-1,1066,1067,1131,1130,-1,1067,1068,1132,1131,-1,1068,1069,1133,1132,-1,1069,1070,1134,1133,-1,1070,1071,1135,1134,-1,1071,1072,1136,1135,-1,1072,1073,1137,1136,-1,1073,1074,1138,1137,-1,1074,1075,1139,1138,-1,1075,1076,1140,1139,-1,1076,1077,1141,1140,-1,1077,1078,1142,1141,-1,1078,1079,1143,1142,-1,1079,1080,1144,1143,-1,1080,1081,1145,1144,-1,1081,1082,1146,1145,-1,1082,1083,1147,1146,-1,1083,1084,1148,1147,-1,1084,1085,1149,1148,-1,1085,1086,1150,1149,-1,1086,1087,1151,1150,-1,1087,1024,1088,1151,-1,1088,1089,1153,1152,-1,1089,1090,1154,1153,-1,1090,1091,1155,1154,-1,1091,1092,1156,1155,-1,1092,1093,1157,1156,-1,1093,1094,1158,1157,-1,1094,1095,1159,1158,-1,1095,1096,1160,1159,-1,1096,1097,1161,1160,-1,1097,1098,1162,1161,-1,1098,1099,1163,1162,-1,1099,1100,1164,1163,-1,1100,1101,1165,1164,-1,1101,1102,1166,1165,-1,1102,1103,1167,1166,-1,1103,1104,1168,1167,-1,1104,1105,1169,1168,-1,1105,1106,1170,1169,-1,1106,1107,1171,1170,-1,1107,1108,1172,1171,-1,1108,1109,1173,1172,-1,1109,1110,1174,1173,-1,1110,1111,1175,1174,-1,1111,1112,1176,1175,-1,1112,1113,1177,1176,-1,1113,1114,1178,1177,-1,1114,1115,1179,1178,-1,1115,1116,1180,1179,-1,1116,1117,1181,1180,-1,1117,1118,1182,1181,-1,1118,1119,1183,1182,-1,1119,1120,1184,1183,-1,1120,1121,1185,1184,-1,1121,1122,1186,1185,-1,1122,1123,1187,1186,-1,1123,1124,1188,1187,-1,1124,1125,1189,1188,-1,1125,1126,1190,1189,-1,1126,1127,1191,1190,-1,1127,1128,1192,1191,-1,1128,1129,1193,1192,-1,1129,1130,1194,1193,-1,1130,1131,1195,1194,-1,1131,1132,1196,1195,-1,1132,1133,1197,1196,-1,1133,1134,1198,1197,-1,1134,1135,1199,1198,-1,1135,1136,1200,1199,-1,1136,1137,1201,1200,-1,1137,1138,1202,1201,-1,1138,1139,1203,1202,-1,1139,1140,1204,1203,-1,1140,1141,1205,1204,-1,1141,1142,1206,1205,-1,1142,1143,1207,1206,-1,1143,1144,1208,1207,-1,1144,1145,1209,1208,-1,1145,1146,1210,1209,-1,1146,1147,1211,1210,-1,1147,1148,1212,1211,-1,1148,1149,1213,1212,-1,1149,1150,1214,1213,-1,1150,1151,1215,1214,-1,1151,1088,1152,1215,-1,1152,1153,1217,1216,-1,1153,1154,1218,1217,-1,1154,1155,1219,1218,-1,1155,1156,1220,1219,-1,1156,1157,1221,1220,-1,1157,1158,1222,1221,-1,1158,1159,1223,1222,-1,1159,1160,1224,1223,-1,1160,1161,1225,1224,-1,1161,1162,1226,1225,-1,1162,1163,1227,1226,-1,1163,1164,1228,1227,-1,1164,1165,1229,1228,-1,1165,1166,1230,1229,-1,1166,1167,1231,1230,-1,1167,1168,1232,1231,-1,1168,1169,1233,1232,-1,1169,1170,1234,1233,-1,1170,1171,1235,1234,-1,1171,1172,1236,1235,-1,1172,1173,1237,1236,-1,1173,1174,1238,1237,-1,1174,1175,1239,1238,-1,1175,1176,1240,1239,-1,1176,1177,1241,1240,-1,1177,1178,1242,1241,-1,1178,1179,1243,1242,-1,1179,1180,1244,1243,-1,1180,1181,1245,1244,-1,1181,1182,1246,1245,-1,1182,1183,1247,1246,-1,1183,1184,1248,1247,-1,1184,1185,1249,1248,-1,1185,1186,1250,1249,-1,1186,1187,1251,1250,-1,1187,1188,1252,1251,-1,1188,1189,1253,1252,-1,1189,1190,1254,1253,-1,1190,1191,1255,1254,-1,1191,1192,1256,1255,-1,1192,1193,1257,1256,-1,1193,1194,1258,1257,-1,1194,1195,1259,1258,-1,1195,1196,1260,1259,-1,1196,1197,1261,1260,-1,1197,1198,1262,1261,-1,1198,1199,1263,1262,-1,1199,1200,1264,1263,-1,1200,1201,1265,1264,-1,1201,1202,1266,1265,-1,1202,1203,1267,1266,-1,1203,1204,1268,1267,-1,1204,1205,1269,1268,-1,1205,1206,1270,1269,-1,1206,1207,1271,1270,-1,1207,1208,1272,1271,-1,1208,1209,1273,1272,-1,1209,1210,1274,1273,-1,1210,1211,1275,1274,-1,1211,1212,1276,1275,-1,1212,1213,1277,1276,-1,1213,1214,1278,1277,-1,1214,1215,1279,1278,-1,1215,1152,1216,1279,-1,1216,1217,1281,1280,-1,1217,1218,1282,1281,-1,1218,1219,1283,1282,-1,1219,1220,1284,1283,-1,1220,1221,1285,1284,-1,1221,1222,1286,1285,-1,1222,1223,1287,1286,-1,1223,1224,1288,1287,-1,1224,1225,1289,1288,-1,1225,1226,1290,1289,-1,1226,1227,1291,1290,-1,1227,1228,1292,1291,-1,1228,1229,1293,1292,-1,1229,1230,1294,1293,-1,1230,1231,1295,1294,-1,1231,1232,1296,1295,-1,1232,1233,1297,1296,-1,1233,1234,1298,1297,-1,1234,1235,1299,1298,-1,1235,1236,1300,1299,-1,1236,1237,1301,1300,-1,1237,1238,1302,1301,-1,1238,1239,1303,1302,-1,1239,1240,1304,1303,-1,1240,1241,1305,1304,-1,1241,1242,1306,1305,-1,1242,1243,1307,1306,-1,1243,1244,1308,1307,-1,1244,1245,1309,1308,-1,1245,1246,1310,1309,-1,1246,1247,1311,1310,-1,1247,1248,1312,1311,-1,1248,1249,1313,1312,-1,1249,1250,1314,1313,-1,1250,1251,1315,1314,-1,1251,1252,1316,1315,-1,1252,1253,1317,1316,-1,1253,1254,1318,1317,-1,1254,1255,1319,1318,-1,1255,1256,1320,1319,-1,1256,1257,1321,1320,-1,1257,1258,1322,1321,-1,1258,1259,1323,1322,-1,1259,1260,1324,1323,-1,1260,1261,1325,1324,-1,1261,1262,1326,1325,-1,1262,1263,1327,1326,-1,1263,1264,1328,1327,-1,1264,1265,1329,1328,-1,1265,1266,1330,1329,-1,1266,1267,1331,1330,-1,1267,1268,1332,1331,-1,1268,1269,1333,1332,-1,1269,1270,1334,1333,-1,1270,1271,1335,1334,-1,1271,1272,1336,1335,-1,1272,1273,1337,1336,-1,1273,1274,1338,1337,-1,1274,1275,1339,1338,-1,1275,1276,1340,1339,-1,1276,1277,1341,1340,-1,1277,1278,1342,1341,-1,1278,1279,1343,1342,-1,1279,1216,1280,1343,-1,1280,1281,1345,1344,-1,1281,1282,1346,1345,-1,1282,1283,1347,1346,-1,1283,1284,1348,1347,-1,1284,1285,1349,1348,-1,1285,1286,1350,1349,-1,1286,1287,1351,1350,-1,1287,1288,1352,1351,-1,1288,1289,1353,1352,-1,1289,1290,1354,1353,-1,1290,1291,1355,1354,-1,1291,1292,1356,1355,-1,1292,1293,1357,1356,-1,1293,1294,1358,1357,-1,1294,1295,1359,1358,-1,1295,1296,1360,1359,-1,1296,1297,1361,1360,-1,1297,1298,1362,1361,-1,1298,1299,1363,1362,-1,1299,1300,1364,1363,-1,1300,1301,1365,1364,-1,1301,1302,1366,1365,-1,1302,1303,1367,1366,-1,1303,1304,1368,1367,-1,1304,1305,1369,1368,-1,1305,1306,1370,1369,-1,1306,1307,1371,1370,-1,1307,1308,1372,1371,-1,1308,1309,1373,1372,-1,1309,1310,1374,1373,-1,1310,1311,1375,1374,-1,1311,1312,1376,1375,-1,1312,1313,1377,1376,-1,1313,1314,1378,1377,-1,1314,1315,1379,1378,-1,1315,1316,1380,1379,-1,1316,1317,1381,1380,-1,1317,1318,1382,1381,-1,1318,1319,1383,1382,-1,1319,1320,1384,1383,-1,1320,1321,1385,1384,-1,1321,1322,1386,1385,-1,1322,1323,1387,1386,-1,1323,1324,1388,1387,-1,1324,1325,1389,1388,-1,1325,1326,1390,1389,-1,1326,1327,1391,1390,-1,1327,1328,1392,1391,-1,1328,1329,1393,1392,-1,1329,1330,1394,1393,-1,1330,1331,1395,1394,-1,1331,1332,1396,1395,-1,1332,1333,1397,1396,-1,1333,1334,1398,1397,-1,1334,1335,1399,1398,-1,1335,1336,1400,1399,-1,1336,1337,1401,1400,-1,1337,1338,1402,1401,-1,1338,1339,1403,1402,-1,1339,1340,1404,1403,-1,1340,1341,1405,1404,-1,1341,1342,1406,1405,-1,1342,1343,1407,1406,-1,1343,1280,1344,1407,-1,1344,1345,1409,1408,-1,1345,1346,1410,1409,-1,1346,1347,1411,1410,-1,1347,1348,1412,1411,-1,1348,1349,1413,1412,-1,1349,1350,1414,1413,-1,1350,1351,1415,1414,-1,1351,1352,1416,1415,-1,1352,1353,1417,1416,-1,1353,1354,1418,1417,-1,1354,1355,1419,1418,-1,1355,1356,1420,1419,-1,1356,1357,1421,1420,-1,1357,1358,1422,1421,-1,1358,1359,1423,1422,-1,1359,1360,1424,1423,-1,1360,1361,1425,1424,-1,1361,1362,1426,1425,-1,1362,1363,1427,1426,-1,1363,1364,1428,1427,-1,1364,1365,1429,1428,-1,1365,1366,1430,1429,-1,1366,1367,1431,1430,-1,1367,1368,1432,1431,-1,1368,1369,1433,1432,-1,1369,1370,1434,1433,-1,1370,1371,1435,1434,-1,1371,1372,1436,1435,-1,1372,1373,1437,1436,-1,1373,1374,1438,1437,-1,1374,1375,1439,1438,-1,1375,1376,1440,1439,-1,1376,1377,1441,1440,-1,1377,1378,1442,1441,-1,1378,1379,1443,1442,-1,1379,1380,1444,1443,-1,1380,1381,1445,1444,-1,1381,1382,1446,1445,-1,1382,1383,1447,1446,-1,1383,1384,1448,1447,-1,1384,1385,1449,1448,-1,1385,1386,1450,1449,-1,1386,1387,1451,1450,-1,1387,1388,1452,1451,-1,1388,1389,1453,1452,-1,1389,1390,1454,1453,-1,1390,1391,1455,1454,-1,1391,1392,1456,1455,-1,1392,1393,1457,1456,-1,1393,1394,1458,1457,-1,1394,1395,1459,1458,-1,1395,1396,1460,1459,-1,1396,1397,1461,1460,-1,1397,1398,1462,1461,-1,1398,1399,1463,1462,-1,1399,1400,1464,1463,-1,1400,1401,1465,1464,-1,1401,1402,1466,1465,-1,1402,1403,1467,1466,-1,1403,1404,1468,1467,-1,1404,1405,1469,1468,-1,1405,1406,1470,1469,-1,1406,1407,1471,1470,-1,1407,1344,1408,1471,-1,1408,1409,1473,1472,-1,1409,1410,1474,1473,-1,1410,1411,1475,1474,-1,1411,1412,1476,1475,-1,1412,1413,1477,1476,-1,1413,1414,1478,1477,-1,1414,1415,1479,1478,-1,1415,1416,1480,1479,-1,1416,1417,1481,1480,-1,1417,1418,1482,1481,-1,1418,1419,1483,1482,-1,1419,1420,1484,1483,-1,1420,1421,1485,1484,-1,1421,1422,1486,1485,-1,1422,1423,1487,1486,-1,1423,1424,1488,1487,-1,1424,1425,1489,1488,-1,1425,1426,1490,1489,-1,1426,1427,1491,1490,-1,1427,1428,1492,1491,-1,1428,1429,1493,1492,-1,1429,1430,1494,1493,-1,1430,1431,1495,1494,-1,1431,1432,1496,1495,-1,1432,1433,1497,1496,-1,1433,1434,1498,1497,-1,1434,1435,1499,1498,-1,1435,1436,1500,1499,-1,1436,1437,1501,1500,-1,1437,1438,1502,1501,-1,1438,1439,1503,1502,-1,1439,1440,1504,1503,-1,1440,1441,1505,1504,-1,1441,1442,1506,1505,-1,1442,1443,1507,1506,-1,1443,1444,1508,1507,-1,1444,1445,1509,1508,-1,1445,1446,1510,1509,-1,1446,1447,1511,1510,-1,1447,1448,1512,1511,-1,1448,1449,1513,1512,-1,1449,1450,1514,1513,-1,1450,1451,1515,1514,-1,1451,1452,1516,1515,-1,1452,1453,1517,1516,-1,1453,1454,1518,1517,-1,1454,1455,1519,1518,-1,1455,1456,1520,1519,-1,1456,1457,1521,1520,-1,1457,1458,1522,1521,-1,1458,1459,1523,1522,-1,1459,1460,1524,1523,-1,1460,1461,1525,1524,-1,1461,1462,1526,1525,-1,1462,1463,1527,1526,-1,1463,1464,1528,1527,-1,1464,1465,1529,1528,-1,1465,1466,1530,1529,-1,1466,1467,1531,1530,-1,1467,1468,1532,1531,-1,1468,1469,1533,1532,-1,1469,1470,1534,1533,-1,1470,1471,1535,1534,-1,1471,1408,1472,1535,-1,1472,1473,1537,1536,-1,1473,1474,1538,1537,-1,1474,1475,1539,1538,-1,1475,1476,1540,1539,-1,1476,1477,1541,1540,-1,1477,1478,1542,1541,-1,1478,1479,1543,1542,-1,1479,1480,1544,1543,-1,1480,1481,1545,1544,-1,1481,1482,1546,1545,-1,1482,1483,1547,1546,-1,1483,1484,1548,1547,-1,1484,1485,1549,1548,-1,1485,1486,1550,1549,-1,1486,1487,1551,1550,-1,1487,1488,1552,1551,-1,1488,1489,1553,1552,-1,1489,1490,1554,1553,-1,1490,1491,1555,1554,-1,1491,1492,1556,1555,-1,1492,1493,1557,1556,-1,1493,1494,1558,1557,-1,1494,1495,1559,1558,-1,1495,1496,1560,1559,-1,1496,1497,1561,1560,-1,1497,1498,1562,1561,-1,1498,1499,1563,1562,-1,1499,1500,1564,1563,-1,1500,1501,1565,1564,-1,1501,1502,1566,1565,-1,1502,1503,1567,1566,-1,1503,1504,1568,1567,-1,1504,1505,1569,1568,-1,1505,1506,1570,1569,-1,1506,1507,1571,1570,-1,1507,1508,1572,1571,-1,1508,1509,1573,1572,-1,1509,1510,1574,1573,-1,1510,1511,1575,1574,-1,1511,1512,1576,1575,-1,1512,1513,1577,1576,-1,1513,1514,1578,1577,-1,1514,1515,1579,1578,-1,1515,1516,1580,1579,-1,1516,1517,1581,1580,-1,1517,1518,1582,1581,-1,1518,1519,1583,1582,-1,1519,1520,1584,1583,-1,1520,1521,1585,1584,-1,1521,1522,1586,1585,-1,1522,1523,1587,1586,-1,1523,1524,1588,1587,-1,1524,1525,1589,1588,-1,1525,1526,1590,1589,-1,1526,1527,1591,1590,-1,1527,1528,1592,1591,-1,1528,1529,1593,1592,-1,1529,1530,1594,1593,-1,1530,1531,1595,1594,-1,1531,1532,1596,1595,-1,1532,1533,1597,1596,-1,1533,1534,1598,1597,-1,1534,1535,1599,1598,-1,1535,1472,1536,1599,-1,1536,1537,1601,1600,-1,1537,1538,1602,1601,-1,1538,1539,1603,1602,-1,1539,1540,1604,1603,-1,1540,1541,1605,1604,-1,1541,1542,1606,1605,-1,1542,1543,1607,1606,-1,1543,1544,1608,1607,-1,1544,1545,1609,1608,-1,1545,1546,1610,1609,-1,1546,1547,1611,1610,-1,1547,1548,1612,1611,-1,1548,1549,1613,1612,-1,1549,1550,1614,1613,-1,1550,1551,1615,1614,-1,1551,1552,1616,1615,-1,1552,1553,1617,1616,-1,1553,1554,1618,1617,-1,1554,1555,1619,1618,-1,1555,1556,1620,1619,-1,1556,1557,1621,1620,-1,1557,1558,1622,1621,-1,1558,1559,1623,1622,-1,1559,1560,1624,1623,-1,1560,1561,1625,1624,-1,1561,1562,1626,1625,-1,1562,1563,1627,1626,-1,1563,1564,1628,1627,-1,1564,1565,1629,1628,-1,1565,1566,1630,1629,-1,1566,1567,1631,1630,-1,1567,1568,1632,1631,-1,1568,1569,1633,1632,-1,1569,1570,1634,1633,-1,1570,1571,1635,1634,-1,1571,1572,1636,1635,-1,1572,1573,1637,1636,-1,1573,1574,1638,1637,-1,1574,1575,1639,1638,-1,1575,1576,1640,1639,-1,1576,1577,1641,1640,-1,1577,1578,1642,1641,-1,1578,1579,1643,1642,-1,1579,1580,1644,1643,-1,1580,1581,1645,1644,-1,1581,1582,1646,1645,-1,1582,1583,1647,1646,-1,1583,1584,1648,1647,-1,1584,1585,1649,1648,-1,1585,1586,1650,1649,-1,1586,1587,1651,1650,-1,1587,1588,1652,1651,-1,1588,1589,1653,1652,-1,1589,1590,1654,1653,-1,1590,1591,1655,1654,-1,1591,1592,1656,1655,-1,1592,1593,1657,1656,-1,1593,1594,1658,1657,-1,1594,1595,1659,1658,-1,1595,1596,1660,1659,-1,1596,1597,1661,1660,-1,1597,1598,1662,1661,-1,1598,1599,1663,1662,-1,1599,1536,1600,1663,-1,1600,1601,1665,1664,-1,1601,1602,1666,1665,-1,1602,1603,1667,1666,-1,1603,1604,1668,1667,-1,1604,1605,1669,1668,-1,1605,1606,1670,1669,-1,1606,1607,1671,1670,-1,1607,1608,1672,1671,-1,1608,1609,1673,1672,-1,1609,1610,1674,1673,-1,1610,1611,1675,1674,-1,1611,1612,1676,1675,-1,1612,1613,1677,1676,-1,1613,1614,1678,1677,-1,1614,1615,1679,1678,-1,1615,1616,1680,1679,-1,1616,1617,1681,1680,-1,1617,1618,1682,1681,-1,1618,1619,1683,1682,-1,1619,1620,1684,1683,-1,1620,1621,1685,1684,-1,1621,1622,1686,1685,-1,1622,1623,1687,1686,-1,1623,1624,1688,1687,-1,1624,1625,1689,1688,-1,1625,1626,1690,1689,-1,1626,1627,1691,1690,-1,1627,1628,1692,1691,-1,1628,1629,1693,1692,-1,1629,1630,1694,1693,-1,1630,1631,1695,1694,-1,1631,1632,1696,1695,-1,1632,1633,1697,1696,-1,1633,1634,1698,1697,-1,1634,1635,1699,1698,-1,1635,1636,1700,1699,-1,1636,1637,1701,1700,-1,1637,1638,1702,1701,-1,1638,1639,1703,1702,-1,1639,1640,1704,1703,-1,1640,1641,1705,1704,-1,1641,1642,1706,1705,-1,1642,1643,1707,1706,-1,1643,1644,1708,1707,-1,1644,1645,1709,1708,-1,1645,1646,1710,1709,-1,1646,1647,1711,1710,-1,1647,1648,1712,1711,-1,1648,1649,1713,1712,-1,1649,1650,1714,1713,-1,1650,1651,1715,1714,-1,1651,1652,1716,1715,-1,1652,1653,1717,1716,-1,1653,1654,1718,1717,-1,1654,1655,1719,1718,-1,1655,1656,1720,1719,-1,1656,1657,1721,1720,-1,1657,1658,1722,1721,-1,1658,1659,1723,1722,-1,1659,1660,1724,1723,-1,1660,1661,1725,1724,-1,1661,1662,1726,1725,-1,1662,1663,1727,1726,-1,1663,1600,1664,1727,-1,1664,1665,1729,1728,-1,1665,1666,1730,1729,-1,1666,1667,1731,1730,-1,1667,1668,1732,1731,-1,1668,1669,1733,1732,-1,1669,1670,1734,1733,-1,1670,1671,1735,1734,-1,1671,1672,1736,1735,-1,1672,1673,1737,1736,-1,1673,1674,1738,1737,-1,1674,1675,1739,1738,-1,1675,1676,1740,1739,-1,1676,1677,1741,1740,-1,1677,1678,1742,1741,-1,1678,1679,1743,1742,-1,1679,1680,1744,1743,-1,1680,1681,1745,1744,-1,1681,1682,1746,1745,-1,1682,1683,1747,1746,-1,1683,1684,1748,1747,-1,1684,1685,1749,1748,-1,1685,1686,1750,1749,-1,1686,1687,1751,1750,-1,1687,1688,1752,1751,-1,1688,1689,1753,1752,-1,1689,1690,1754,1753,-1,1690,1691,1755,1754,-1,1691,1692,1756,1755,-1,1692,1693,1757,1756,-1,1693,1694,1758,1757,-1,1694,1695,1759,1758,-1,1695,1696,1760,1759,-1,1696,1697,1761,1760,-1,1697,1698,1762,1761,-1,1698,1699,1763,1762,-1,1699,1700,1764,1763,-1,1700,1701,1765,1764,-1,1701,1702,1766,1765,-1,1702,1703,1767,1766,-1,1703,1704,1768,1767,-1,1704,1705,1769,1768,-1,1705,1706,1770,1769,-1,1706,1707,1771,1770,-1,1707,1708,1772,1771,-1,1708,1709,1773,1772,-1,1709,1710,1774,1773,-1,1710,1711,1775,1774,-1,1711,1712,1776,1775,-1,1712,1713,1777,1776,-1,1713,1714,1778,1777,-1,1714,1715,1779,1778,-1,1715,1716,1780,1779,-1,1716,1717,1781,1780,-1,1717,1718,1782,1781,-1,1718,1719,1783,1782,-1,1719,1720,1784,1783,-1,1720,1721,1785,1784,-1,1721,1722,1786,1785,-1,1722,1723,1787,1786,-1,1723,1724,1788,1787,-1,1724,1725,1789,1788,-1,1725,1726,1790,1789,-1,1726,1727,1791,1790,-1,1727,1664,1728,1791,-1,1728,1729,1793,1792,-1,1729,1730,1794,1793,-1,1730,1731,1795,1794,-1,1731,1732,1796,1795,-1,1732,1733,1797,1796,-1,1733,1734,1798,1797,-1,1734,1735,1799,1798,-1,1735,1736,1800,1799,-1,1736,1737,1801,1800,-1,1737,1738,1802,1801,-1,1738,1739,1803,1802,-1,1739,1740,1804,1803,-1,1740,1741,1805,1804,-1,1741,1742,1806,1805,-1,1742,1743,1807,1806,-1,1743,1744,1808,1807,-1,1744,1745,1809,1808,-1,1745,1746,1810,1809,-1,1746,1747,1811,1810,-1,1747,1748,1812,1811,-1,1748,1749,1813,1812,-1,1749,1750,1814,1813,-1,1750,1751,1815,1814,-1,1751,1752,1816,1815,-1,1752,1753,1817,1816,-1,1753,1754,1818,1817,-1,1754,1755,1819,1818,-1,1755,1756,1820,1819,-1,1756,1757,1821,1820,-1,1757,1758,1822,1821,-1,1758,1759,1823,1822,-1,1759,1760,1824,1823,-1,1760,1761,1825,1824,-1,1761,1762,1826,1825,-1,1762,1763,1827,1826,-1,1763,1764,1828,1827,-1,1764,1765,1829,1828,-1,1765,1766,1830,1829,-1,1766,1767,1831,1830,-1,1767,1768,1832,1831,-1,1768,1769,1833,1832,-1,1769,1770,1834,1833,-1,1770,1771,1835,1834,-1,1771,1772,1836,1835,-1,1772,1773,1837,1836,-1,1773,1774,1838,1837,-1,1774,1775,1839,1838,-1,1775,1776,1840,1839,-1,1776,1777,1841,1840,-1,1777,1778,1842,1841,-1,1778,1779,1843,1842,-1,1779,1780,1844,1843,-1,1780,1781,1845,1844,-1,1781,1782,1846,1845,-1,1782,1783,1847,1846,-1,1783,1784,1848,1847,-1,1784,1785,1849,1848,-1,1785,1786,1850,1849,-1,1786,1787,1851,1850,-1,1787,1788,1852,1851,-1,1788,1789,1853,1852,-1,1789,1790,1854,1853,-1,1790,1791,1855,1854,-1,1791,1728,1792,1855,-1,1792,1793,1857,1856,-1,1793,1794,1858,1857,-1,1794,1795,1859,1858,-1,1795,1796,1860,1859,-1,1796,1797,1861,1860,-1,1797,1798,1862,1861,-1,1798,1799,1863,1862,-1,1799,1800,1864,1863,-1,1800,1801,1865,1864,-1,1801,1802,1866,1865,-1,1802,1803,1867,1866,-1,1803,1804,1868,1867,-1,1804,1805,1869,1868,-1,1805,1806,1870,1869,-1,1806,1807,1871,1870,-1,1807,1808,1872,1871,-1,1808,1809,1873,1872,-1,1809,1810,1874,1873,-1,1810,1811,1875,1874,-1,1811,1812,1876,1875,-1,1812,1813,1877,1876,-1,1813,1814,1878,1877,-1,1814,1815,1879,1878,-1,1815,1816,1880,1879,-1,1816,1817,1881,1880,-1,1817,1818,1882,1881,-1,1818,1819,1883,1882,-1,1819,1820,1884,1883,-1,1820,1821,1885,1884,-1,1821,1822,1886,1885,-1,1822,1823,1887,1886,-1,1823,1824,1888,1887,-1,1824,1825,1889,1888,-1,1825,1826,1890,1889,-1,1826,1827,1891,1890,-1,1827,1828,1892,1891,-1,1828,1829,1893,1892,-1,1829,1830,1894,1893,-1,1830,1831,1895,1894,-1,1831,1832,1896,1895,-1,1832,1833,1897,1896,-1,1833,1834,1898,1897,-1,1834,1835,1899,1898,-1,1835,1836,1900,1899,-1,1836,1837,1901,1900,-1,1837,1838,1902,1901,-1,1838,1839,1903,1902,-1,1839,1840,1904,1903,-1,1840,1841,1905,1904,-1,1841,1842,1906,1905,-1,1842,1843,1907,1906,-1,1843,1844,1908,1907,-1,1844,1845,1909,1908,-1,1845,1846,1910,1909,-1,1846,1847,1911,1910,-1,1847,1848,1912,1911,-1,1848,1849,1913,1912,-1,1849,1850,1914,1913,-1,1850,1851,1915,1914,-1,1851,1852,1916,1915,-1,1852,1853,1917,1916,-1,1853,1854,1918,1917,-1,1854,1855,1919,1918,-1,1855,1792,1856,1919,-1,1856,1857,1921,1920,-1,1857,1858,1922,1921,-1,1858,1859,1923,1922,-1,1859,1860,1924,1923,-1,1860,1861,1925,1924,-1,1861,1862,1926,1925,-1,1862,1863,1927,1926,-1,1863,1864,1928,1927,-1,1864,1865,1929,1928,-1,1865,1866,1930,1929,-1,1866,1867,1931,1930,-1,1867,1868,1932,1931,-1,1868,1869,1933,1932,-1,1869,1870,1934,1933,-1,1870,1871,1935,1934,-1,1871,1872,1936,1935,-1,1872,1873,1937,1936,-1,1873,1874,1938,1937,-1,1874,1875,1939,1938,-1,1875,1876,1940,1939,-1,1876,1877,1941,1940,-1,1877,1878,1942,1941,-1,1878,1879,1943,1942,-1,1879,1880,1944,1943,-1,1880,1881,1945,1944,-1,1881,1882,1946,1945,-1,1882,1883,1947,1946,-1,1883,1884,1948,1947,-1,1884,1885,1949,1948,-1,1885,1886,1950,1949,-1,1886,1887,1951,1950,-1,1887,1888,1952,1951,-1,1888,1889,1953,1952,-1,1889,1890,1954,1953,-1,1890,1891,1955,1954,-1,1891,1892,1956,1955,-1,1892,1893,1957,1956,-1,1893,1894,1958,1957,-1,1894,1895,1959,1958,-1,1895,1896,1960,1959,-1,1896,1897,1961,1960,-1,1897,1898,1962,1961,-1,1898,1899,1963,1962,-1,1899,1900,1964,1963,-1,1900,1901,1965,1964,-1,1901,1902,1966,1965,-1,1902,1903,1967,1966,-1,1903,1904,1968,1967,-1,1904,1905,1969,1968,-1,1905,1906,1970,1969,-1,1906,1907,1971,1970,-1,1907,1908,1972,1971,-1,1908,1909,1973,1972,-1,1909,1910,1974,1973,-1,1910,1911,1975,1974,-1,1911,1912,1976,1975,-1,1912,1913,1977,1976,-1,1913,1914,1978,1977,-1,1914,1915,1979,1978,-1,1915,1916,1980,1979,-1,1916,1917,1981,1980,-1,1917,1918,1982,1981,-1,1918,1919,1983,1982,-1,1919,1856,1920,1983,-1,1920,1921,1985,1984,-1,1921,1922,1986,1985,-1,1922,1923,1987,1986,-1,1923,1924,1988,1987,-1,1924,1925,1989,1988,-1,1925,1926,1990,1989,-1,1926,1927,1991,1990,-1,1927,1928,1992,1991,-1,1928,1929,1993,1992,-1,1929,1930,1994,1993,-1,1930,1931,1995,1994,-1,1931,1932,1996,1995,-1,1932,1933,1997,1996,-1,1933,1934,1998,1997,-1,1934,1935,1999,1998,-1,1935,1936,2000,1999,-1,1936,1937,2001,2000,-1,1937,1938,2002,2001,-1,1938,1939,2003,2002,-1,1939,1940,2004,2003,-1,1940,1941,2005,2004,-1,1941,1942,2006,2005,-1,1942,1943,2007,2006,-1,1943,1944,2008,2007,-1,1944,1945,2009,2008,-1,1945,1946,2010,2009,-1,1946,1947,2011,2010,-1,1947,1948,2012,2011,-1,1948,1949,2013,2012,-1,1949,1950,2014,2013,-1,1950,1951,2015,2014,-1,1951,1952,2016,2015,-1,1952,1953,2017,2016,-1,1953,1954,2018,2017,-1,1954,1955,2019,2018,-1,1955,1956,2020,2019,-1,1956,1957,2021,2020,-1,1957,1958,2022,2021,-1,1958,1959,2023,2022,-1,1959,1960,2024,2023,-1,1960,1961,2025,2024,-1,1961,1962,2026,2025,-1,1962,1963,2027,2026,-1,1963,1964,2028,2027,-1,1964,1965,2029,2028,-1,1965,1966,2030,2029,-1,1966,1967,2031,2030,-1,1967,1968,2032,2031,-1,1968,1969,2033,2032,-1,1969,1970,2034,2033,-1,1970,1971,2035,2034,-1,1971,1972,2036,2035,-1,1972,1973,2037,2036,-1,1973,1974,2038,2037,-1,1974,1975,2039,2038,-1,1975,1976,2040,2039,-1,1976,1977,2041,2040,-1,1977,1978,2042,2041,-1,1978,1979,2043,2042,-1,1979,1980,2044,2043,-1,1980,1981,2045,2044,-1,1981,1982,2046,2045,-1,1982,1983,2047,2046,-1,1983,1920,1984,2047,-1],creaseAngle=1.571,solid=False,
          coord=Coordinate(point=[(0.0,7.0,0.0),(0.0,7.679761,0.0),(0.0,8.252767,0.0),(0.0,8.629029,0.0),(0.0,8.749456,0.0),(0.0,8.595135,0.0),(0.0,8.190302,0.0),(0.0,7.598535,0.0),(0.0,6.91277,0.0),(0.0,6.240703,0.0),(0.0,5.687883,0.0),(0.0,5.341127,0.0),(0.0,5.254893,0.0),(0.0,5.442724,0.0),(0.0,5.875122,0.0),(0.0,6.484178,0.0),(0.0,7.174244,0.0),(0.0,7.836944,0.0),(0.0,8.368205,0.0),(0.0,8.684592,0.0),(0.0,8.736419,0.0),(0.0,8.515544,0.0),(0.0,8.056658,0.0),(0.0,7.431825,0.0),(0.0,6.739176,0.0),(0.0,6.087488,0.0),(0.0,5.579108,0.0),(0.0,5.293876,0.0),(0.0,5.276586,0.0),(0.0,5.529955,0.0),(0.0,6.01419,0.0),(0.0,6.653244,0.0),(0.0,7.346756,0.0),(0.0,7.98581,0.0),(0.0,8.470045,0.0),(0.0,8.723414,0.0),(0.0,8.706124,0.0),(0.0,8.420892,0.0),(0.0,7.912512,0.0),(0.0,7.260824,0.0),(0.0,6.568175,0.0),(0.0,5.943342,0.0),(0.0,5.484456,0.0),(0.0,5.263581,0.0),(0.0,5.315408,0.0),(0.0,5.631795,0.0),(0.0,6.163056,0.0),(0.0,6.825756,0.0),(0.0,7.515822,0.0),(0.0,8.124878,0.0),(0.0,8.557276,0.0),(0.0,8.745107,0.0),(0.0,8.658873,0.0),(0.0,8.312117,0.0),(0.0,7.759297,0.0),(0.0,7.08723,0.0),(0.0,6.401465,0.0),(0.0,5.809698,0.0),(0.0,5.404865,0.0),(0.0,5.250544,0.0),(0.0,5.370971,0.0),(0.0,5.747233,0.0),(0.0,6.320239,0.0),(0.0,7.0,0.0),(0.777997,7.650667,0.0),(0.831559,8.218221,0.08321),(0.85608,8.588815,0.17306),(0.845812,8.70425,0.260898),(0.80084,8.546396,0.337582),(0.726958,8.140044,0.39588),(0.63427,7.549011,0.432438),(0.534864,6.866116,0.448804),(0.440124,6.198607,0.451237),(0.358309,5.651315,0.449305),(0.292971,5.31019,0.453609),(0.242575,5.228805,0.47316),(0.201359,5.419942,0.513055),(0.161218,5.853583,0.573003),(0.114101,6.461625,0.647101),(0.054324,7.148578,0.724907),(-0.019791,7.806557,0.793602),(-0.105357,8.332227,0.840729),(-0.195576,8.643034,0.856875),(-0.281448,8.690166,0.837687),(-0.35409,8.466222,0.784743),(-0.407084,8.00637,0.70509),(-0.438252,7.38283,0.609571),(-0.450387,6.693528,0.51035),(-0.450747,6.046715,0.418232),(-0.449397,5.543974,0.340405),(-0.456786,5.264257,0.279136),(-0.48114,5.251495,0.231705),(-0.526301,5.50769,0.191558),(-0.590545,5.992609,0.150371),(-0.666684,6.630096,0.100487),(-0.743449,7.320035,0.037104),(-0.807845,7.954073,-0.040318),(-0.847938,8.432636,-0.127806),(-0.855431,8.680566,-0.217819),(-0.827425,8.658928,-0.301158),(-0.766958,8.371118,-0.369348),(-0.682224,7.862337,-0.416899),(-0.584648,7.212488,-0.442853),(-0.486298,6.523628,-0.451219),(-0.397258,5.903941,-0.450148),(-0.323561,5.450747,-0.450046),(-0.266185,5.235218,-0.461046),(-0.221298,5.291205,-0.490448),(-0.181688,5.609913,-0.540766),(-0.138966,6.14129,-0.60885),(-0.086007,6.801886,-0.686316),(-0.018983,7.487954,-0.761214),(0.061492,8.091751,-0.82055),(0.150421,8.51845,-0.853082),(0.239642,8.70104,-0.851739),(0.319906,8.610845,-0.815108),(0.383293,8.262031,-0.74764),(0.425338,7.709378,-0.658553),(0.446335,7.039678,-0.559686),(0.451449,6.358106,-0.462848),(0.44961,5.771703,-0.377268),(0.451404,5.37256,-0.307762),(0.46648,5.223362,-0.254031),(0.501091,5.34754,-0.211228),(0.556369,5.725594,-0.171617),(0.62776,6.298149,-0.126905),(0.705793,6.975288,-0.070625),(0.777997,7.650667,0.0),(1.664414,8.099133,0.0),(1.73,8.460319,0.173113),(1.726192,8.569662,0.348957),(1.651514,8.40999,0.509424),(1.516153,8.00638,0.639112),(1.339555,7.422216,0.729483),(1.145997,6.749241,0.781327),(0.95922,6.093143,0.804881),(0.797376,5.556962,0.817509),(0.669469,5.224903,0.839488),(0.574106,5.149115,0.88889),(0.500785,5.341501,0.976818),(0.433347,5.771847,1.104151),(0.354692,6.372568,1.260649),(0.251559,7.049322,1.426664),(0.118188,7.695826,1.57711),(-0.042066,8.21055,1.686786),(-0.217526,8.512656,1.735819),(-0.3912,8.5547,1.713958),(-0.545209,8.330078,1.622733),(-0.665529,7.874068,1.474964),(-0.745808,7.258284,1.291777),(-0.789284,6.579433,1.097828),(-0.808282,5.944129,0.915895),(-0.821343,5.452142,0.762095),(-0.848682,5.18074,0.642852),(-0.907035,5.172545,0.554278),(-1.005171,5.428843,0.484065),(-1.141172,5.909385,0.415352),(-1.302185,6.538701,0.331577),(-1.466761,7.217961,0.221079),(-1.609258,7.840486,0.080315),(-1.70532,8.308512,-0.085109),(-1.737147,8.548535,-0.261833),(-1.697332,8.522862,-0.432194),(-1.590376,8.235523,-0.57885),(-1.431544,7.731645,-0.689395),(-1.243335,7.090361,-0.759786),(-1.050444,6.412382,-0.79568),(-0.874377,5.804184,-0.811303),(-0.729027,5.361282,-0.826088),(-0.618194,5.153234,-0.859856),(-0.53562,5.212712,-0.927721),(-0.467437,5.530376,-1.035946),(-0.396391,6.056338,-1.179799),(-0.306751,6.707996,-1.343966),(-0.18866,7.383009,-1.505472),(-0.040861,7.975368,-1.63847),(0.12888,8.392045,-1.719787),(0.30574,8.567601,-1.733938),(0.471681,8.474465,-1.676455),(0.610191,8.127265,-1.554741),(0.710702,7.580527,-1.386276),(0.771566,6.920116,-1.194618),(0.800783,6.249746,-1.00415),(0.81427,5.674699,-0.83483),(0.832042,5.285284,-0.698166),(0.873205,5.142657,-0.595341),(0.950984,5.269218,-0.517878),(1.069001,5.645091,-0.450622),(1.219735,6.211245,-0.376238),(1.385594,6.878768,-0.280104),(1.542388,7.542827,-0.154339),(1.664414,8.099133,0.0),(2.586817,8.244781,0.0),(2.605901,8.347085,0.26076),(2.517885,8.187417,0.509002),(2.335798,7.790852,0.720498),(2.087315,7.219669,0.879877),(1.808551,6.563571,0.984885),(1.536117,5.925597,1.047307),(1.299307,5.40594,1.090248),(1.114252,5.086209,1.142386),(0.981357,5.016619,1.230583),(0.886548,5.208097,1.372645),(0.805943,5.630573,1.572051),(0.712713,6.217698,1.815963),(0.584408,6.877266,2.077108),(0.408929,7.505692,2.319149),(0.187674,8.004284,2.504338),(-0.064882,8.29474,2.601683),(-0.325035,8.331444,2.593721),(-0.566115,8.108631,2.480314),(-0.765561,7.661295,2.278577),(-0.910997,7.059687,2.018977),(-1.003738,6.398289,1.738525),(-1.05879,5.780973,1.472687),(-1.101281,5.304685,1.247903),(-1.160155,5.044227,1.076466),(-1.260639,5.040501,0.954897),(-1.417344,5.294094,0.866121),(-1.629705,5.765179,0.784825),(-1.880952,6.379773,0.68461),(-2.140924,7.041357,0.545146),(-2.372163,7.646029,0.357546),(-2.537865,8.098827,0.12666),(-2.60988,8.328642,-0.130254),(-2.574863,8.29938,-0.388098),(-2.437154,8.015637,-0.620576),(-2.217707,7.521975,-0.807179),(-1.949345,6.895921,-0.938755),(-1.669458,6.235797,-1.020185),(-1.411894,5.645273,-1.069468),(-1.199912,5.217089,-1.113356),(-1.041865,5.018491,-1.180577),(-0.930528,5.080667,-1.294286),(-0.846166,5.393854,-1.465603),(-0.762493,5.908867,-1.689858),(-0.653997,6.544822,-1.946523),(-0.502807,7.201846,-2.202941),(-0.303395,7.776755,-2.421036),(-0.063979,8.179259,-2.565461),(0.19569,8.346148,-2.611299),(0.449546,8.251211,-2.549504),(0.672112,7.909358,-2.388826),(0.845287,7.374277,-2.153757),(0.963312,6.73,-1.87901),(1.034578,6.07771,-1.60184),(1.079799,5.519846,-1.354025),(1.126917,5.144022,-1.155371),(1.203965,5.009258,-1.010247),(1.331613,5.136718,-0.907878),(1.517251,5.506387,-0.826251),(1.752097,6.060208,-0.738571),(2.012106,6.711204,-0.620652),(2.262549,7.357139,-0.457384),(2.465253,7.89657,-0.246686),(2.586817,8.244781,0.0),(3.449728,8.038817,0.0),(3.365223,7.88106,0.336741),(3.15294,7.495842,0.63738),(2.847377,6.943661,0.8783),(2.495694,6.311236,1.052023),(2.147389,5.697887,1.169405),(1.843727,5.199939,1.257032),(1.609356,4.895595,1.35041),(1.448041,4.832649,1.484603),(1.343418,5.020989,1.684593),(1.26448,5.431035,1.957799),(1.174337,5.998391,2.29063),(1.040073,6.633955,2.650062),(0.841239,7.237913,2.989943),(0.57494,7.715415,3.260645),(0.25628,7.99147,3.419821),(-0.085832,8.022726,3.441753),(-0.416437,7.804272,3.323085),(-0.70381,7.370417,3.083595),(-0.927916,6.789296,2.761802),(-1.085841,6.152174,2.406472),(-1.192801,5.559108,2.065991),(-1.278382,5.103239,1.778122),(-1.378915,4.856159,1.5625),(-1.527799,4.856671,1.41759),(-1.746197,5.104696,1.322693),(-2.036408,5.561282,1.244423),(-2.379638,6.154722,1.145973),(-2.738827,6.791818,0.996852),(-3.065963,7.372517,0.78069),(-3.312243,7.805621,0.49924),(-3.438708,8.023111,0.171619),(-3.424873,7.990832,-0.170928),(-3.273302,7.713853,-0.493371),(-3.009054,7.235672,-0.766199),(-2.674133,6.631388,-0.973305),(-2.318232,5.995901,-1.116402),(-1.987974,5.429012,-1.214825),(-1.717139,5.019752,-1.300682),(-1.520161,4.832392,-1.410503),(-1.390329,4.896357,-1.575434),(-1.303023,5.201602,-1.812394),(-1.223072,5.700189,-2.118423),(-1.114371,6.313815,-2.469699),(-0.949349,6.946113,-2.825593),(-0.715973,7.497782,-3.136881),(-0.420594,7.882182,-3.35626),(-0.086005,8.038946,-3.448711),(0.25474,7.943453,-3.399272),(0.567137,7.610701,-3.216391),(0.824391,7.092948,-2.930058),(1.014604,6.471505,-2.585168),(1.144105,5.843968,-2.23166),(1.236042,5.308891,-1.913768),(1.324507,4.950307,-1.660879),(1.445607,4.824529,-1.482108),(1.627672,4.951311,-1.365779),(1.883014,5.310743,-1.283817),(2.20335,5.846376,-1.199881),(2.560092,6.474091,-1.079169),(2.909562,7.095306,-0.897481),(3.201992,7.612461,-0.647297),(3.392243,7.944338,-0.339445),(3.449728,8.038817,0.0),(4.1596,7.494163,0.0),(3.934795,7.124545,0.393736),(3.589159,6.597233,0.725564),(3.179686,5.995039,0.980803),(2.768302,5.412538,1.166937),(2.408605,4.941208,1.311657),(2.134816,4.655072,1.455493),(1.955474,4.599066,1.640837),(1.853273,4.781986,1.900067),(1.790923,5.175105,2.245746),(1.721509,5.716684,2.665418),(1.600758,6.32167,3.122394),(1.398184,6.895052,3.562515),(1.104432,7.34678,3.925385),(0.733078,7.605912,4.15749),(0.316554,7.631752,4.224124),(-0.102679,7.420243,4.117291),(-0.483432,7.0046,3.857697),(-0.796647,6.4501,3.490337),(-1.033039,5.843825,3.074686),(-1.20556,5.28099,2.671796),(-1.345981,4.849987,2.331308),(-1.496414,4.618503,2.081385),(-1.697829,4.622892,1.923874),(-1.978425,4.862465,1.83571),(-2.344779,5.299598,1.776101),(-2.778056,5.865641,1.697635),(-3.236356,6.471696,1.558547),(-3.662784,7.022586,1.333144),(-3.997426,7.431793,1.01787),(-4.190468,7.635054,0.631611),(-4.213348,7.600446,0.210279),(-4.065312,7.333404,-0.202891),(-3.773792,6.875868,-0.568808),(-3.388489,6.299691,-0.862815),(-2.97054,5.69536,-1.081188),(-2.579298,5.157786,-1.242124),(-2.259803,4.771392,-1.380937),(-2.033856,4.59686,-1.540586),(-1.896698,4.661601,-1.759879),(-1.819965,4.955447,-2.062271),(-1.760072,5.43225,-2.44811),(-1.66989,6.017129,-2.892334),(-1.510829,6.618231,-3.348342),(-1.262374,7.141154,-3.757265),(-0.926785,7.503774,-4.060511),(-0.527916,7.649143,-4.212671),(-0.104536,7.55443,-4.191748),(0.300077,7.234511,-4.004253),(0.649583,6.739627,-3.683967),(0.924146,6.147499,-3.284609),(1.125661,5.55112,-2.868136),(1.277267,5.044149,-2.491402),(1.417216,4.706204,-2.194279),(1.588563,4.59036,-1.991995),(1.827238,4.714809,-1.873375),(2.151461,5.060006,-1.80529),(2.5552,5.57174,-1.742106),(3.00741,6.169644,-1.637748),(3.457384,6.759819,-1.457409),(3.845076,7.249578,-1.186049),(4.114035,7.562007,-0.83167),(4.223913,7.648039,-0.422666),(4.1596,7.494163,0.0),(4.650067,6.680934,0.0),(4.282899,6.184139,0.428569),(3.833008,5.618433,0.774859),(3.373816,5.072658,1.040684),(2.971147,4.632526,1.252443),(2.669471,4.36716,1.453717),(2.483327,4.318235,1.693103),(2.395821,4.493433,2.010332),(2.364445,4.865241,2.424145),(2.33266,5.375267,2.925063),(2.244371,5.943413,3.474967),(2.057751,6.480452,4.013792),(1.755086,6.902045,4.471885),(1.346339,7.141981,4.785172),(0.865688,7.162578,4.909563),(0.362047,6.960602,4.831175),(-0.113966,6.567773,4.569884),(-0.523237,6.045783,4.175332),(-0.848213,5.47661,3.716263),(-1.097203,4.949641,3.265659),(-1.301826,4.547636,2.885142),(-1.508182,4.333727,2.612247),(-1.763945,4.34151,2.453498),(-2.10459,4.569761,2.38479),(-2.542236,4.982635,2.35885),(-3.059997,5.51529,2.317857),(-3.613381,6.084075,2.208091),(-4.138601,6.599663,1.993045),(-4.565944,6.981082,1.661868),(-4.835091,7.168432,1.231165),(-4.908773,7.132289,0.739879),(-4.781507,6.878329,0.238635),(-4.481275,6.446437,-0.223651),(-4.063711,5.904441,-0.612506),(-3.600103,5.337458,-0.916699),(-3.162004,4.834533,-1.150875),(-2.80602,4.474649,-1.351308),(-2.562311,4.314324,-1.565796),(-2.429414,4.378737,-1.840209),(-2.376485,4.657773,-2.205056),(-2.352294,5.107609,-2.665473),(-2.298669,5.6576,-3.197254),(-2.165101,6.221371,-3.750065),(-1.920943,6.710383,-4.257247),(-1.562317,7.047838,-4.650001),(-1.112147,7.180739,-4.872633),(-0.613455,7.088216,-4.895255),(-0.117732,6.784797,-4.72089),(0.328629,6.318135,-4.385255),(0.696353,5.761517,-3.949211),(0.9807,5.20236,-3.485613),(1.20238,4.728477,-3.063614),(1.401678,4.41429,-2.734075),(1.627233,4.309142,-2.519449),(1.922254,4.429547,-2.41043),(2.311644,4.756594,-2.370011),(2.793302,5.238922,-2.343859),(3.335909,5.800782,-2.274384),(3.883909,6.353936,-2.115064),(4.368675,6.811512,-1.841551),(4.723295,7.101649,-1.456943),(4.89751,7.178782,-0.990053),(4.869261,7.030796,-0.487243),(4.650067,6.680934,0.0),(4.900852,5.708809,0.0),(4.429464,5.185476,0.443235),(3.93959,4.681903,0.796405),(3.508707,4.277177,1.082293),(3.191821,4.034859,1.345465),(3.010439,3.993004,1.639398),(2.949412,4.158185,2.010875),(2.962258,4.504461,2.485629),(2.983566,4.97745,3.0589),(2.945403,5.502871,3.693418),(2.793729,5.998207,4.325538),(2.500908,6.385667,4.878202),(2.071371,6.604401,5.277768),(1.539223,6.620058,5.470722),(0.95856,6.430179,5.436265),(0.389065,6.064584,5.191717),(-0.11944,5.580688,4.789375),(-0.539544,5.054487,4.30546),(-0.872734,4.568619,3.823697),(-1.148162,4.199388,3.417331),(-1.414002,4.004781,3.133749),(-1.723537,4.015361,2.985254),(-2.119502,4.229466,2.948047),(-2.62063,4.613472,2.969535),(-3.213902,5.107071,2.982065),(-3.854576,5.632744,2.919728),(-4.474224,6.107937,2.734141),(-4.994998,6.458021,2.405464),(-5.346819,6.628016,1.946083),(-5.483409,6.591226,1.396248),(-5.393319,6.353427,0.812912),(-5.103243,5.951965,0.254692),(-4.672761,5.44989,-0.233208),(-4.181643,4.926051,-0.630281),(-3.712647,4.462715,-0.945356),(-3.333806,4.132648,-1.213406),(-3.084302,3.987687,-1.485322),(-2.967169,4.050597,-1.813199),(-2.950427,4.311499,-2.234862),(-2.976243,4.729418,-2.76155),(-2.975796,5.238721,-3.371987),(-2.886206,5.759424,-4.014468),(-2.665448,6.209751,-4.616691),(-2.301711,6.518979,-5.101115),(-1.815057,6.638546,-5.402242),(-1.251171,6.549673,-5.481736),(-0.668902,6.266317,-5.337708),(-0.124839,5.83298,-5.005892),(0.341151,5.317715,-4.552343),(0.715761,4.801443,-4.059283),(1.014958,4.365245,-3.607376),(1.278885,4.077623,-3.258547),(1.560211,3.983749,-3.043305),(1.908857,4.098364,-2.955488),(2.35695,4.403469,-2.955521),(2.907858,4.851147,-2.98128),(3.532179,5.371093,-2.96385),(4.17187,5.881649,-2.844333),(4.751736,6.302635,-2.587657),(5.195639,6.567935,-2.190146),(5.44363,6.635884,-1.679138),(5.465904,6.495812,-1.104956),(5.270208,6.169716,-0.527364),(4.900852,5.708809,0.0),(4.945229,4.700791,0.0),(4.442959,4.244439,0.444585),(3.999705,3.878912,0.808558),(3.680884,3.661616,1.135402),(3.515672,3.626676,1.48198),(3.49191,3.77958,1.901593),(3.560526,4.096313,2.427526),(3.64832,4.527135,3.061304),(3.675945,5.004385,3.76876),(3.576756,5.453113,4.48511),(3.312023,5.802847,5.128015),(2.878958,5.998661,5.615615),(2.3098,6.009805,5.885274),(1.662397,5.834527,5.90851),(1.004793,5.500356,5.698463),(0.397779,5.05977,5.307992),(-0.120172,4.581964,4.818726),(-0.54181,4.141976,4.32354),(-0.891634,3.808905,3.906503),(-1.217918,3.635058,3.624949),(-1.578281,3.647739,3.49783),(-2.022445,3.844955,3.502977),(-2.576592,4.195734,3.583821),(-3.233344,4.644987,3.663824),(-3.950058,5.122161,3.665118),(-4.656077,5.552316,3.526841),(-5.267385,5.867897,3.218832),(-5.705246,6.019343,2.747502),(-5.914403,5.98287,2.152666),(-5.876428,5.764206,1.496322),(-5.614945,5.397691,0.846317),(-5.191348,4.940887,0.259089),(-4.691897,4.465532,-0.234163),(-4.20914,4.04628,-0.634426),(-3.821961,3.748974,-0.973191),(-3.578874,3.620304,-1.302604),(-3.488427,3.680479,-1.679938),(-3.518876,3.920048,-2.15034),(-3.607069,4.301386,-2.732249),(-3.674322,4.764607,-3.409273),(-3.645413,5.236961,-4.130755),(-3.466134,5.644268,-4.821098),(-3.115265,5.92256,-5.395797),(-2.608215,6.028133,-5.780398),(-1.99166,5.944406,-5.927874),(-1.330702,5.684528,-5.830186),(-0.691892,5.289313,-5.521171),(-0.126436,4.820829,-5.069933),(0.342188,4.352649,-4.56618),(0.723094,3.9583,-4.100867),(1.054137,3.699714,-3.746627),(1.390345,3.617501,-3.542541),(1.787546,3.724572,-3.486738),(2.285381,4.004112,-3.538461),(2.894024,4.41222,-3.628991),(3.588107,4.884804,-3.678705),(4.309551,5.347645,-3.616143),(4.978842,5.728056,-3.394517),(5.51219,5.966293,-3.001779),(5.840534,6.024943,-2.461991),(5.925812,5.894794,-1.827871),(5.770559,5.596286,-1.166544),(5.418403,5.176299,-0.542193),(4.945229,4.700791,0.0),(4.863841,3.764893,0.0),(4.424486,3.441911,0.442737),(4.117042,3.251293,0.832278),(3.978758,3.222975,1.227284),(4.001583,3.361406,1.686808),(4.135326,3.644844,2.251979),(4.300366,4.028777,2.93194),(4.406811,4.452908,3.697753),(4.375498,4.850629,4.485977),(4.15587,5.159479,5.211296),(3.736529,5.330954,5.785279),(3.14616,5.338123,6.136811),(2.4448,5.179862,6.229249),(1.707856,4.881024,6.070081),(1.006937,4.488542,5.710622),(0.392357,4.064053,5.235642),(-0.118339,3.674223,4.745229),(-0.543003,3.380273,4.333062),(-0.92807,3.228368,4.06614),(-1.334073,3.242364,3.970668),(-1.817213,3.420063,4.027358),(-2.411679,3.733558,4.177151),(-3.117302,4.133614,4.335903),(-3.895796,4.557405,4.414473),(-4.676764,4.938375,4.339403),(-5.372205,5.216693,4.069287),(-5.896144,5.348651,3.603059),(-6.184707,5.313524,2.978398),(-6.211743,5.11683,2.26089),(-5.996136,4.789458,1.526804),(-5.598897,4.382821,0.843898),(-5.110548,3.960782,0.255057),(-4.631642,3.58962,-0.231156),(-4.250921,3.327625,-0.640723),(-4.026182,3.215942,-1.025192),(-3.972288,3.272113,-1.445795),(-4.059079,3.487314,-1.95475),(-4.219561,3.827749,-2.57852),(-4.366348,4.239954,-3.30738),(-4.412372,4.659193,-4.094083),(-4.290914,5.019625,-4.862197),(-3.970252,5.264646,-5.522284),(-3.459545,5.355775,-5.992108),(-2.80478,5.2787,-6.216031),(-2.075987,5.045528,-6.17886),(-1.349077,4.692875,-5.910691),(-0.686912,4.276126,-5.481427),(-0.124346,3.860731,-4.986103),(0.339053,3.511925,-4.524346),(0.736825,3.284488,-4.178745),(1.124618,3.214139,-3.997129),(1.563168,3.311925,-3.982887),(2.099645,3.56249,-4.095508),(2.752119,3.926483,-4.261113),(3.501222,4.346739,-4.390393),(4.291274,4.757259,-4.399626),(5.040842,5.093571,-4.229769),(5.660338,5.302859,-3.859153),(6.0725,5.352254,-3.306907),(6.230809,5.233998,-2.626506),(6.131339,4.966665,-1.891268),(5.81505,4.592236,-1.175538),(5.359805,4.169517,-0.536329),(4.863841,3.764893,0.0),(4.766107,2.970737,0.0),(4.482829,2.808123,0.448575),(4.381112,2.786008,0.885661),(4.457973,2.907864,1.375103),(4.663606,3.154555,1.965875),(4.913577,3.487339,2.675791),(5.108711,3.853951,3.48306),(5.157909,4.196818,4.328),(4.998514,4.462093,5.124723),(4.609482,4.608114,5.780107),(4.014402,4.611949,6.21551),(3.273886,4.472997,6.385951),(2.469435,4.213079,6.292018),(1.682915,3.873015,5.981437),(0.976805,3.506211,5.539735),(0.380095,3.170272,5.072009),(-0.116711,2.917958,4.679975),(-0.556359,2.788893,4.43964),(-1.0008,2.803347,4.38479),(-1.511969,2.959049,4.500148),(-2.132334,3.231548,4.725738),(-2.870223,3.578047,4.971372),(-3.693797,3.944131,5.137759),(-4.53538,4.272306,5.139211),(-5.305304,4.511033,4.922603),(-5.912037,4.622821,4.478194),(-6.283768,4.590114,3.83993),(-6.38616,4.418048,3.075412),(-6.231874,4.133646,2.268217),(-5.879365,3.781573,1.49707),(-5.42103,3.41712,0.817089),(-4.963341,3.097524,0.24771),(-4.603537,2.872978,-0.229753),(-4.40829,2.778745,-0.664443),(-4.399332,2.829624,-1.120207),(-4.549364,3.017625,-1.655833),(-4.789168,3.313224,-2.306342),(-5.024145,3.669996,-3.070191),(-5.156334,4.031911,-3.905771),(-5.106665,4.342133,-4.738293),(-4.832234,4.55194,-5.475587),(-4.334621,4.628384,-6.029091),(-3.657488,4.55946,-6.334955),(-2.874296,4.35599,-6.370095),(-2.069371,4.049931,-6.15917),(-1.317104,3.689347,-5.770608),(-0.664478,3.330868,-5.302411),(-0.121224,3.030792,-4.860944),(0.340047,2.836245,-4.53761),(0.773869,2.77778,-4.388831),(1.244726,2.864579,-4.424021),(1.807062,3.083011,-4.604319),(2.487636,3.398771,-4.852313),(3.274811,3.762269,-5.070399),(4.117642,4.11642,-5.16336),(4.935236,4.405605,-5.059847),(5.634259,4.584408,-4.727705),(6.130463,4.624748,-4.179679),(6.368982,4.520291,-3.468363),(6.338431,4.28744,-2.671873),(6.075215,3.962765,-1.873956),(5.656831,3.597255,-1.143553),(5.185538,3.248312,-0.518891),(4.766107,2.970737,0.0),(4.76363,2.336672,0.0),(4.706588,2.320221,0.470965),(4.842732,2.423526,0.978979),(5.124121,2.630361,1.580582),(5.463303,2.908244,2.302975),(5.753437,3.213535,3.133155),(5.892523,3.498287,4.017454),(5.806014,3.717782,4.871825),(5.462567,3.837548,5.600493),(4.879355,3.838776,6.118517),(4.115936,3.721274,6.372716),(3.25842,3.503494,6.355783),(2.397982,3.219639,6.109958),(1.609112,2.914287,5.719123),(0.932945,2.635394,5.290994),(0.369711,2.426758,4.933449),(-0.117971,2.321145,4.730506),(-0.59194,2.335142,4.723566),(-1.118926,2.466551,4.902333),(-1.749634,2.694733,5.207522),(-2.50186,2.983854,5.54469),(-3.35204,3.288508,5.805903),(-4.237562,3.560849,5.894089),(-5.069456,3.758108,5.744391),(-5.752508,3.849304,5.337547),(-6.207939,3.820117,4.702331),(-6.393077,3.675129,3.906728),(-6.313114,3.437111,3.040235),(-6.021874,3.143443,2.191783),(-5.611183,2.840245,1.428783),(-5.191129,2.575132,0.782437),(-4.865764,2.389742,0.24284),(-4.709892,2.313188,-0.235061),(-4.752397,2.357493,-0.716309),(-4.970013,2.5157,-1.265521),(-5.292989,2.762962,-1.92649),(-5.621276,3.060447,-2.707064),(-5.847392,3.361436,-3.573267),(-5.880558,3.61866,-4.45435),(-5.666455,3.791722,-5.257702),(-5.198056,3.853443,-5.890114),(-4.515175,3.794129,-6.280226),(-3.693093,3.623097,-6.396625),(-2.823287,3.367206,-6.257048),(-1.991108,3.066644,-5.926232),(-1.255952,2.768612,-5.502687),(-0.638778,2.519916,-5.09733),(-0.119927,2.359613,-4.808904),(0.352362,2.312879,-4.70194),(0.845031,2.387052,-4.792407),(1.419283,2.570485,-5.04443),(2.111033,2.834369,-5.378825),(2.917806,3.137262,-5.691391),(3.795536,3.431595,-5.876639),(4.666283,3.671145,-5.851334),(5.435154,3.81829,-5.572388),(6.012375,3.849921,-5.044982),(6.335159,3.761072,-4.319238),(6.383937,3.565696,-3.476507),(6.188859,3.294475,-2.608823),(5.824731,2.990005,-1.796692),(5.39539,2.700101,-1.090702),(5.011011,2.470294,-0.501427),(4.76363,2.336672,0.0),(4.942123,1.830361,0.0),(5.140356,1.913286,0.51437),(5.498298,2.077538,1.111505),(5.927375,2.297322,1.828353),(6.314998,2.538121,2.661995),(6.549726,2.762119,3.566791),(6.545797,2.934136,4.462849),(6.26132,3.027159,5.253871),(5.705994,3.026578,5.850066),(4.936757,2.932484,6.190497),(4.04267,2.759655,6.259277),(3.122914,2.535233,6.091469),(2.263373,2.294463,5.766981),(1.517544,2.075157,5.393671),(0.896354,1.911757,5.083477),(0.369237,1.829924,4.927127),(-0.124028,1.842511,4.97338),(-0.653863,1.947539,5.217702),(-1.278864,2.128516,5.60307),(-2.026893,2.357018,6.032741),(-2.884168,2.597161,6.391974),(-3.795273,2.811229,6.573606),(-4.674254,2.965606,6.501491),(-5.424213,3.036045,6.146381),(-5.960629,3.011485,5.530656),(-6.232656,2.895782,4.721054),(-6.237054,2.707109,3.811384),(-6.021133,2.475094,2.899625),(-5.673728,2.236176,2.065068),(-5.306114,2.027876,1.351103),(-5.027217,1.882907,0.757731),(-4.918924,1.824037,0.245493),(-5.017281,1.86051,-0.250402),(-5.304064,1.986598,-0.799459),(-5.710702,2.1825,-1.454123),(-6.133666,2.41745,-2.232472),(-6.457693,2.65455,-3.109861),(-6.581389,2.856563,-4.021803),(-6.439238,2.991763,-4.877533),(-6.01493,3.038919,-5.581039),(-5.343064,2.990624,-6.054428),(-4.499076,2.854463,-6.257833),(-3.580063,2.651819,-6.200851),(-2.681343,2.414518,-5.942465),(-1.874519,2.179827,-5.579224),(-1.192398,1.984603,-5.224237),(-0.624307,1.859507,-4.981852),(-0.122795,1.824183,-4.92391),(0.380185,1.88418,-5.073212),(0.951829,2.030075,-5.398092),(1.637329,2.238956,-5.819412),(2.444442,2.478019,-6.228337),(3.337846,2.709719,-6.51071),(4.244847,2.897668,-6.572309),(5.071208,3.012349,-6.359093),(5.723292,3.035753,-5.867801),(6.131103,2.964203,-5.144606),(6.266487,2.808936,-4.272419),(6.151871,2.594337,-3.35013),(5.857161,2.354108,-2.469),(5.485279,2.125976,-1.691985),(5.149562,1.945768,-1.041006),(4.948261,1.841787,-0.495148),(4.942123,1.830361,0.0),(5.338822,1.382317,0.0),(5.770987,1.501674,0.577474),(6.287009,1.660748,1.270946),(6.770685,1.834556,2.08848),(7.102961,1.995802,2.994149),(7.18797,2.119163,3.91436),(6.973446,2.185265,4.754415),(6.460857,2.183727,5.421302),(5.70306,2.11479,5.847059),(4.790309,1.989282,6.006858),(3.82818,1.826912,5.927182),(2.912888,1.653181,5.681797),(2.110016,1.495372,5.376232),(1.441736,1.37827,5.124233),(0.88546,1.320264,5.021691),(0.384005,1.330464,5.124186),(-0.135503,1.407269,5.433503),(-0.738911,1.538616,5.896367),(-1.464358,1.703878,6.415772),(-2.308961,1.877101,6.872274),(-3.226339,2.03108,7.150301),(-4.135738,2.141633,7.163308),(-4.940621,2.191399,6.871986),(-5.552158,2.172562,6.29136),(-5.911798,2.088079,5.485347),(-6.007234,1.95122,4.550303),(-5.877631,1.783476,3.591745),(-5.606543,1.611193,2.699969),(-5.303964,1.461426,1.930485),(-5.081583,1.357697,1.29393),(-5.027048,1.316295,0.757706),(-5.183311,1.343723,0.258688),(-5.538002,1.435673,-0.27639),(-6.025394,1.577704,-0.908182),(-6.540583,1.747512,-1.665437),(-6.962563,1.918428,-2.534166),(-7.18084,2.06361,-3.45811),(-7.119352,2.160257,-4.350545),(-6.752197,2.193192,-5.114591),(-6.107614,2.157243,-5.667037),(-5.259523,2.058054,-5.959764),(-4.308904,1.911203,-5.993321),(-3.359661,1.739753,-5.819103),(-2.494921,1.57063,-5.529312),(-1.759481,1.430393,-5.236829),(-1.152549,1.341068,-5.049649),(-0.632328,1.316682,-5.045858),(-0.131054,1.361064,-5.255106),(0.423483,1.467246,-5.650991),(1.085511,1.61855,-6.156239),(1.873697,1.791216,-6.659516),(2.762975,1.958126,-7.039947),(3.687964,2.093068,-7.19364),(4.55726,2.174849,-7.056019),(5.275159,2.190626,-6.61484),(5.765439,2.137921,-5.911012),(5.991277,2.025012,-5.027278),(5.966216,1.869629,-4.067697),(5.753248,1.696177,-3.133052),(5.451937,1.531895,-2.298184),(5.176426,1.402582,-1.596716),(5.02942,1.328549,-1.016719),(5.078265,1.32142,-0.508157),(5.338822,1.382317,0.0),(5.931087,0.908609,0.0),(6.527574,1.004982,0.653182),(7.101992,1.109994,1.435699),(7.5298,1.207153,2.322636),(7.706532,1.281202,3.248576),(7.570129,1.320511,4.122473),(7.11339,1.318906,4.849828),(6.383804,1.27664,5.356648),(5.471014,1.20035,5.609154),(4.485131,1.102018,5.624176),(3.531234,0.997086,5.467419),(2.686243,0.902033,5.23971),(1.983666,0.831788,5.054298),(1.409735,0.797383,5.010497),(0.911595,0.80422,5.169914),(0.415238,0.851225,5.540967),(-0.151513,0.931018,6.075473),(-0.836888,1.031065,6.678206),(-1.649586,1.135657,7.227311),(-2.553735,1.228365,7.600807),(-3.475749,1.294631,7.703052),(-4.321466,1.324049,7.484999),(-4.999334,1.311997,6.95365),(-5.443856,1.260369,6.168638),(-5.633376,1.177272,5.227009),(-5.597602,1.075757,4.240019),(-5.412732,0.971767,3.307652),(-5.185072,0.881633,2.496999),(-5.026865,0.81951,1.829629),(-5.029989,0.795154,1.280793),(-5.24378,0.812391,0.790373),(-5.662311,0.868514,0.282594),(-6.224256,0.954708,-0.31064),(-6.825487,1.057437,-1.028777),(-7.341521,1.160568,-1.869381),(-7.654627,1.247904,-2.786056),(-7.679271,1.305729,-3.698142),(-7.380024,1.324962,-4.509839),(-6.777868,1.302583,-5.134035),(-5.943612,1.242106,-5.514866),(-4.980226,1.153028,-5.643282),(-3.998488,1.04934,-5.561558),(-3.091907,0.947326,-5.35534),(-2.316945,0.863005,-5.134877),(-1.683179,0.809621,-5.009728),(-1.15558,0.795558,-5.062926),(-0.668026,0.823024,-5.330722),(-0.144464,0.887705,-5.792833),(0.477785,0.979444,-6.375598),(1.228542,1.083834,-6.967409),(2.094103,1.184479,-7.442886),(3.018167,1.265574,-7.690165),(3.914217,1.314384,-7.634962),(4.686335,1.323242,-7.255866),(5.253291,1.290758,-6.587418),(5.569843,1.222033,-5.710477),(5.639836,1.12786,-4.732384),(5.517608,1.023029,-3.761842),(5.297061,0.924004,-2.884626),(5.090772,0.846335,-2.14594),(5.003974,0.802221,-1.543522),(5.10956,0.79859,-1.03292),(5.430077,0.836011,-0.543361),(5.931087,0.908609,0.0),(6.639195,0.336702,0.0),(7.29538,0.371827,0.730013),(7.812866,0.404239,1.579405),(8.080434,0.428846,2.492484),(8.027193,0.441784,3.383746),(7.637183,0.441021,4.158988),(6.951443,0.426677,4.739413),(6.057228,0.401005,5.082618),(5.067149,0.368037,5.195091),(4.093332,0.332949,5.132877),(3.222834,0.301253,4.989923),(2.500142,0.277926,4.876707),(1.920793,0.266632,4.8941),(1.43737,0.269144,5.108715),(0.976088,0.285068,5.535671),(0.459606,0.311903,6.133014),(-0.169813,0.345435,6.809284),(-0.932677,0.380397,7.442587),(-1.804675,0.4113,7.906799),(-2.721061,0.433288,8.098825),(-3.591957,0.442911,7.960594),(-4.324771,0.438655,7.490723),(-4.848086,0.42119,6.743277),(-5.130976,0.393259,5.814103),(-5.192756,0.359247,4.818173),(-5.100481,0.324497,3.863464),(-4.954522,0.294466,3.027645),(-4.865456,0.27387,2.34308),(-4.927705,0.265943,1.793538),(-5.196223,0.271931,1.323121),(-5.671871,0.290894,0.854897),(-6.299109,0.319852,0.314375),(-6.976709,0.354259,-0.348193),(-7.579111,0.388711,-1.142367),(-7.983493,0.417796,-2.032847),(-8.096289,0.436949,-2.946808),(-7.872988,0.443159,-3.791431),(-7.326703,0.435453,-4.477255),(-6.523657,0.415041,-4.941478),(-5.566842,0.385127,-5.165275),(-4.571927,0.350411,-5.180623),(-3.641255,0.316344,-5.064677),(-2.842155,0.288276,-4.922757),(-2.194657,0.270615,-4.86386),(-1.671334,0.266135,-4.974474),(-1.208997,0.27554,-5.29696),(-0.729062,0.297352,-5.817776),(-0.161314,0.328146,-6.468475),(0.535026,0.363086,-7.139421),(1.358266,0.396684,-7.70311),(2.262588,0.423664,-8.041716),(3.168206,0.43979,-8.072457),(3.980847,0.442527,-7.764929),(4.615668,0.431447,-7.146452),(5.019588,0.40829,-6.294364),(5.186317,0.376692,-5.317268),(5.160143,0.341616,-4.329874),(5.027231,0.30857,-3.427508),(4.896294,0.282744,-2.666379),(4.873081,0.268194,-2.054176),(5.034766,0.267206,-1.55302),(5.41037,0.279933,-1.09373),(5.972006,0.304378,-0.597589),(6.639195,0.336702,0.0),(7.342836,-0.372386,0.0),(7.940546,-0.40471,0.794571),(8.294432,-0.429155,1.676756),(8.326082,-0.441883,2.568256),(8.011028,-0.440894,3.376932),(7.383028,-0.426344,4.020583),(6.525265,-0.400519,4.44885),(5.550715,-0.367473,4.657603),(4.576452,-0.332396,4.692004),(3.698066,-0.300798,4.637228),(2.970231,-0.277641,4.598817),(2.397905,-0.266561,4.677287),(1.940004,-0.269299,4.943048),(1.524312,-0.285424,5.417726),(1.069688,-0.312404,6.066502),(0.509853,-0.346003,6.803514),(-0.187268,-0.380942,7.509211),(-1.009516,-0.411736,8.055744),(-1.902298,-0.433549,8.334512),(-2.781756,-0.442953,8.279476),(-3.555972,-0.438473,7.880843),(-4.148861,-0.420813,7.186037),(-4.520667,-0.392745,6.287865),(-4.679785,-0.358677,5.302841),(-4.682712,-0.323961,4.344922),(-4.621874,-0.294048,3.500934),(-4.604036,-0.273635,2.813468),(-4.724387,-0.265929,2.275145),(-5.042522,-0.27214,1.835328),(-5.566175,-0.291292,1.417322),(-6.246753,-0.320378,0.941546),(-6.987941,-0.354829,0.348754),(-7.665541,-0.389236,-0.382571),(-8.153992,-0.418195,-1.229017),(-8.353446,-0.437157,-2.127049),(-8.211106,-0.443145,-2.988598),(-7.731919,-0.435219,-3.723496),(-6.976218,-0.414623,-4.263078),(-6.045051,-0.384591,-4.578948),(-5.056798,-0.349841,-4.692023),(-4.120736,-0.31583,-4.669361),(-3.313836,-0.287898,-4.609265),(-2.666245,-0.270433,-4.618071),(-2.158672,-0.266178,-4.78411),(-1.73203,-0.2758,-5.155125),(-1.306619,-0.297789,-5.724674),(-0.8059,-0.328691,-6.430932),(-0.178769,-0.363653,-7.168401),(0.585273,-0.397185,-7.80992),(1.451866,-0.42402,-8.233941),(2.34953,-0.439944,-8.350727),(3.187417,-0.442456,-8.121406),(3.87861,-0.431162,-7.565508),(4.363065,-0.407835,-6.755345),(4.624321,-0.376139,-5.798716),(4.69562,-0.341052,-4.814181),(4.65363,-0.308083,-3.904859),(4.601053,-0.282411,-3.136945),(4.642138,-0.268067,-2.527974),(4.856916,-0.267305,-2.047362),(5.280414,-0.280243,-1.628792),(5.891936,-0.30485,-1.191081),(6.617172,-0.337261,-0.662148),(7.342836,-0.372386,0.0),(7.907469,-1.21138,0.0),(8.339713,-1.283977,0.834514),(8.454613,-1.321399,1.709137),(8.219774,-1.317768,2.535465),(7.661129,-1.273654,3.229437),(6.856258,-1.195985,3.733719),(5.916344,-1.09696,4.033695),(4.961113,-0.992129,4.162868),(4.092747,-0.897956,4.196086),(3.374908,-0.829231,4.232001),(2.821722,-0.796747,4.36888),(2.39908,-0.805605,4.679579),(2.037625,-0.854414,5.191784),(1.653938,-0.93551,5.878444),(1.174498,-1.036155,6.660909),(0.556372,-1.140545,7.424263),(-0.200541,-1.232284,8.041422),(-1.052711,-1.296965,8.400437),(-1.923789,-1.324431,8.428669),(-2.724216,-1.310368,8.108218),(-3.374675,-1.256984,7.479049),(-3.827371,-1.172663,6.629201),(-4.079682,-1.070648,5.674492),(-4.176551,-0.96696,4.732607),(-4.200767,-0.877883,3.897742),(-4.253295,-0.817406,3.221746),(-4.42829,-0.795027,2.706072),(-4.788838,-0.81426,2.306183),(-5.349363,-0.872085,1.947009),(-6.06911,-0.959421,1.545385),(-6.858504,-1.062552,1.033753),(-7.597098,-1.165281,0.379155),(-8.159043,-1.251475,-0.407201),(-8.440211,-1.307598,-1.272157),(-8.380642,-1.324835,-2.133974),(-7.977125,-1.300479,-2.903436),(-7.283037,-1.238356,-3.507326),(-6.395582,-1.148222,-3.908259),(-5.433561,-1.044232,-4.115762),(-4.511004,-0.942717,-4.1856),(-3.712921,-0.85962,-4.207251),(-3.078836,-0.807992,-4.2824),(-2.597812,-0.79594,-4.499542),(-2.21587,-0.825357,-4.910873),(-1.85366,-0.891624,-5.517139),(-1.429782,-0.984332,-6.264285),(-0.88385,-1.088923,-7.052952),(-0.193492,-1.188971,-7.758783),(0.618919,-1.268764,-8.258894),(1.491445,-1.315769,-8.458404),(2.338306,-1.322606,-8.310833),(3.072127,-1.2882,-7.827651),(3.627054,-1.217956,-7.074831),(3.976824,-1.122903,-6.157327),(4.143068,-1.017971,-5.195243),(4.191575,-0.919639,-4.29741),(4.217145,-0.843349,-3.538605),(4.320562,-0.801083,-2.945709),(4.58319,-0.799478,-2.495872),(5.045368,-0.838787,-2.126801),(5.693949,-0.912836,-1.756351),(6.462181,-1.009995,-1.306358),(7.242216,-1.115007,-0.724693),(7.907469,-1.21138,0.0),(8.214258,-2.126819,0.0),(8.407466,-2.187715,0.841294),(8.254936,-2.180587,1.668771),(7.774528,-2.106553,2.398124),(7.036903,-1.977241,2.966303),(6.149359,-1.812959,3.348762),(5.231864,-1.639506,3.567025),(4.390985,-1.484124,3.684474),(3.697821,-1.371214,3.791188),(3.175048,-1.318509,3.981384),(2.795912,-1.334286,4.328919),(2.495095,-1.416067,4.866863),(2.188521,-1.551009,5.57626),(1.797025,-1.717919,6.387008),(1.267956,-1.890585,7.190938),(0.58934,-2.04189,7.864192),(-0.206833,-2.148071,8.293761),(-1.052912,-2.192454,8.402039),(-1.863295,-2.168067,8.163627),(-2.556994,-2.078742,7.610505),(-3.079286,-1.938506,6.824399),(-3.416879,-1.769382,5.918208),(-3.60262,-1.597933,5.01094),(-3.708358,-1.451082,4.20208),(-3.827497,-1.351893,3.551398),(-4.051403,-1.315943,3.068819),(-4.445367,-1.348878,2.716507),(-5.030063,-1.445526,2.422351),(-5.773166,-1.590708,2.101261),(-6.593399,-1.761623,1.678886),(-7.376309,-1.931431,1.1118),(-7.998231,-2.073463,0.399175),(-8.352921,-2.165413,-0.416877),(-8.374655,-2.192841,-1.262276),(-8.052399,-2.151439,-2.050393),(-7.431765,-2.047709,-2.704941),(-6.604359,-1.897943,-3.180492),(-5.687088,-1.725659,-3.475307),(-4.796366,-1.557916,-3.633106),(-4.023313,-1.421056,-3.733089),(-3.415723,-1.336574,-3.870484),(-2.970903,-1.317736,-4.132275),(-2.640802,-1.367502,-4.574003),(-2.347868,-1.478056,-5.20341),(-2.007514,-1.632035,-5.97506),(-1.551486,-1.805257,-6.797504),(-0.946329,-1.970519,-7.55153),(-0.202385,-2.101867,-8.115364),(0.628818,-2.178671,-8.390996),(1.468008,-2.188872,-8.325487),(2.228987,-2.130866,-7.92229),(2.84148,-2.013763,-7.239974),(3.270172,-1.855954,-6.378706),(3.524993,-1.682223,-5.457756),(3.659897,-1.519853,-4.589366),(3.760199,-1.394345,-3.855142),(3.921405,-1.325409,-3.290449),(4.224634,-1.323871,-2.880306),(4.714637,-1.389973,-2.567455),(5.38588,-1.513334,-2.270339),(6.18027,-1.67458,-1.906361),(6.997347,-1.848387,-1.414544),(7.714744,-2.007461,-0.771977),(8.214258,-2.126819,0.0),(8.186407,-3.031912,0.0),(8.115031,-3.020487,0.812031),(7.718662,-2.916505,1.560361),(7.059987,-2.736298,2.177718),(6.240467,-2.508166,2.630577),(5.377887,-2.267936,2.928641),(4.580813,-2.053337,3.123145),(3.925934,-1.898071,3.29425),(3.443531,-1.826521,3.530478),(3.114297,-1.849924,3.905205),(2.877987,-1.964606,4.455996),(2.651529,-2.152555,5.171999),(2.351948,-2.384255,5.992667),(1.918408,-2.623317,6.818429),(1.327916,-2.832198,7.530986),(0.600912,-2.978094,8.018608),(-0.204509,-3.038091,8.200539),(-1.008143,-3.002767,8.04479),(-1.728975,-2.87767,7.575133),(-2.306742,-2.682447,6.865669),(-2.718252,-2.447755,6.024266),(-2.984202,-2.210454,5.168789),(-3.16462,-2.007811,4.401719),(-3.343898,-1.871649,3.789097),(-3.608964,-1.823354,3.348629),(-4.02594,-1.87051,3.049531),(-4.621066,-2.005711,2.823874),(-5.370704,-2.207724,2.586395),(-6.203117,-2.444823,2.25775),(-7.011859,-2.679773,1.785439),(-7.677831,-2.875675,1.157247),(-8.094929,-3.001764,0.404001),(-8.193286,-3.038237,-0.40891),(-7.954678,-2.979366,-1.198975),(-7.416446,-2.834397,-1.888459),(-6.663055,-2.626098,-2.425154),(-5.807264,-2.38718,-2.796631),(-4.965401,-2.155165,-3.034293),(-4.232522,-1.966491,-3.206011),(-3.663264,-1.850789,-3.399013),(-3.262749,-1.826229,-3.697144),(-2.989442,-1.896668,-4.158061),(-2.768992,-2.051044,-4.796035),(-2.515427,-2.265113,-5.574758),(-2.154368,-2.505256,-6.412152),(-1.642509,-2.733758,-7.1963),(-0.978587,-2.914734,-7.80894),(-0.203275,-3.019763,-8.151069),(0.611859,-3.032349,-8.164693),(1.383391,-2.950517,-7.845601),(2.038193,-2.787117,-7.24417),(2.533017,-2.567811,-6.454023),(2.866462,-2.327041,-5.59124),(3.080165,-2.102619,-4.769028),(3.248748,-1.929789,-4.073801),(3.460829,-1.835696,-3.548213),(3.795717,-1.835115,-3.184985),(4.301503,-1.928137,-2.932715),(4.980032,-2.100155,-2.711981),(5.78263,-2.324152,-2.437583),(6.617891,-2.564951,-2.041349),(7.369926,-2.784735,-1.489863),(7.922935,-2.948987,-0.792809),(8.186407,-3.031912,0.0),(7.805634,-3.828846,0.0),(7.495793,-3.695225,0.750067),(6.924656,-3.465417,1.399849),(6.186115,-3.175513,1.908164),(5.393419,-2.871043,2.273517),(4.654661,-2.599823,2.534793),(4.050054,-2.404446,2.76128),(3.616239,-2.315597,3.034385),(3.341168,-2.347228,3.425531),(3.170524,-2.494373,3.975712),(3.023871,-2.733923,4.681869),(2.816426,-3.028256,5.493642),(2.481035,-3.331149,6.321573),(1.984983,-3.595033,7.055048),(1.337599,-3.778466,7.585901),(0.586941,-3.852639,7.832177),(-0.193434,-3.805905,7.756453),(-0.924131,-3.645602,7.374386),(-1.540972,-3.396906,6.751438),(-2.012035,-3.098874,5.988517),(-2.346289,-2.798312,5.19991),(-2.591539,-2.542421,4.488677),(-2.822053,-2.371389,3.925237),(-3.118847,-2.312076,3.534084),(-3.547468,-2.373796,3.291569),(-4.13881,-2.546858,3.135027),(-4.877846,-2.804082,2.980789),(-5.703239,-3.105071,2.746535),(-6.518256,-3.402556,2.372451),(-7.210575,-3.649818,1.836038),(-7.676478,-3.808025,1.157043),(-7.843746,-3.85233,0.391465),(-7.687875,-3.775776,-0.383686),(-7.237746,-3.590386,-1.090915),(-6.569405,-3.325274,-1.672776),(-5.78937,-3.022075,-2.107158),(-5.011401,-2.728407,-2.413364),(-4.332161,-2.490389,-2.647328),(-3.81143,-2.345401,-2.887046),(-3.461415,-2.316214,-3.211723),(-3.247448,-2.40741,-3.679806),(-3.099666,-2.604669,-4.311373),(-2.932592,-2.87701,-5.079399),(-2.667716,-3.181664,-5.912267),(-2.253508,-3.470785,-6.707227),(-1.677999,-3.698967,-7.351793),(-0.970969,-3.830376,-7.74815),(-0.195389,-3.844373,-7.834851),(0.569591,-3.73876,-7.600668),(1.249685,-3.530124,-7.087314),(1.795154,-3.251231,-6.380355),(2.194086,-2.945879,-5.590439),(2.475812,-2.662024,-4.82925),(2.703471,-2.444245,-4.185792),(2.957453,-2.326742,-3.708529),(3.313755,-2.32797,-3.397426),(3.8226,-2.447736,-3.207542),(4.49269,-2.667231,-3.063064),(5.285162,-2.951984,-2.878146),(6.118975,-3.257274,-2.579364),(6.886725,-3.535157,-2.124273),(7.477315,-3.741992,-1.511572),(7.800216,-3.845297,-0.780529),(7.805634,-3.828846,0.0),(7.114913,-4.434759,0.0),(6.636443,-4.157184,0.664076),(5.988617,-3.808242,1.210625),(5.277964,-3.442731,1.628036),(4.609646,-3.118056,1.943129),(4.065186,-2.885205,2.213782),(3.686097,-2.780748,2.513138),(3.46713,-2.821088,2.909268),(3.36053,-2.999891,3.445381),(3.290052,-3.289076,4.125595),(3.171192,-3.643227,4.909966),(2.932612,-4.006726,5.720271),(2.533562,-4.322485,6.455411),(1.973134,-4.540917,7.012937),(1.289248,-4.627716,7.311689),(0.547823,-4.569251,7.310188),(-0.174978,-4.374704,7.016383),(-0.812852,-4.074628,6.486403),(-1.326672,-3.716149,5.81253),(-1.714575,-3.355565,5.103173),(-2.012214,-3.049506,4.459524),(-2.283022,-2.846037,3.95431),(-2.600849,-2.777112,3.61756),(-3.029268,-2.853556,3.432578),(-3.602739,-3.063363,3.342853),(-4.314413,-3.373585,3.268041),(-5.11382,-3.735501,3.124991),(-5.915261,-4.092273,2.848639),(-6.615142,-4.387871,2.407715),(-7.114295,-4.575872,1.811522),(-7.340028,-4.626751,1.106331),(-7.262714,-4.532518,0.362467),(-6.90291,-4.307972,-0.34451),(-6.327289,-3.988376,-0.953685),(-5.634261,-3.623924,-1.434659),(-4.932633,-3.27185,-1.795331),(-4.318269,-2.987448,-2.079569),(-3.854198,-2.815382,-2.355251),(-3.55871,-2.782675,-2.695618),(-3.4041,-2.894463,-3.158543),(-3.326122,-3.13319,-3.768954),(-3.241673,-3.461365,-4.508892),(-3.070287,-3.827449,-5.317893),(-2.754176,-4.173948,-6.103881),(-2.271977,-4.446447,-6.762196),(-1.642976,-4.60215,-7.198347),(-0.920971,-4.616603,-7.349173),(-0.179491,-4.487538,-7.197352),(0.507775,-4.235224,-6.775789),(1.086313,-3.899286,-6.160785),(1.534946,-3.532481,-5.455521),(1.871189,-3.192417,-4.767711),(2.146362,-2.932499,-4.186633),(2.431601,-2.793547,-3.764855),(2.798213,-2.797383,-3.508848),(3.297252,-2.943404,-3.380505),(3.94348,-3.208678,-3.308973),(4.707848,-3.551545,-3.209756),(5.520591,-3.918158,-3.006353),(6.284471,-4.250941,-2.649127),(6.895206,-4.497632,-2.126889),(7.264336,-4.619488,-1.468517),(7.339151,-4.597373,-0.734393),(7.114913,-4.434759,0.0),(6.207019,-4.80459,0.0),(5.656042,-4.399967,0.565972),(5.036303,-3.977247,1.018111),(4.447674,-3.602819,1.371926),(3.970726,-3.335485,1.673801),(3.650169,-3.21723,1.987776),(3.486836,-3.266625,2.377285),(3.439929,-3.475912,2.886443),(3.438808,-3.812225,3.525636),(3.401347,-4.222745,4.265154),(3.254335,-4.643001,5.038696),(2.951,-5.006994,5.756138),(2.481471,-5.257559,6.322686),(1.873819,-5.355345,6.65995),(1.185609,-5.284996,6.723924),(0.488274,-5.057559,6.515557),(-0.151659,-4.708753,6.081317),(-0.68968,-4.293357,5.503515),(-1.114422,-3.876609,4.8826),(-1.449935,-3.523956,4.315511),(-1.748522,-3.290783,3.875123),(-2.075885,-3.213709,3.595538),(-2.492293,-3.304838,3.466568),(-3.034517,-3.549859,3.438526),(-3.703143,-3.910291,3.436015),(-4.458594,-4.32953,3.377254),(-5.227103,-4.741735,3.194216),(-5.915421,-5.08217,2.848717),(-6.430917,-5.297371,2.340662),(-6.702337,-5.353541,1.706625),(-6.696287,-5.241859,1.009303),(-6.425457,-4.979864,0.320681),(-5.946551,-4.608702,-0.29678),(-5.348311,-4.186662,-0.806128),(-4.732383,-3.780026,-1.205013),(-4.191463,-3.452654,-1.525568),(-3.789793,-3.25596,-1.825068),(-3.55052,-3.220833,-2.169678),(-3.452738,-3.35279,-2.615347),(-3.43875,-3.631109,-3.190694),(-3.429636,-4.012078,-3.886249),(-3.345243,-4.435869,-4.652949),(-3.123751,-4.835926,-5.410495),(-2.736089,-5.149421,-6.063796),(-2.191848,-5.32712,-6.523703),(-1.535428,-5.341116,-6.727151),(-0.833589,-5.189211,-6.65188),(-0.157666,-4.895261,-6.32219),(0.434969,-4.505431,-5.804261),(0.915498,-4.080942,-5.192047),(1.290581,-3.68846,-4.586998),(1.599839,-3.389622,-4.076324),(1.904485,-3.23136,-3.714835),(2.269924,-3.23853,-3.51453),(2.746699,-3.410005,-3.444251),(3.354584,-3.718855,-3.439285),(4.07396,-4.116576,-3.418459),(4.846808,-4.540707,-3.304498),(5.587342,-4.92464,-3.042704),(6.199952,-5.208078,-2.613499),(6.600256,-5.346508,-2.035909),(6.734311,-5.318191,-1.36137),(6.591361,-5.127573,-0.659565),(6.207019,-4.80459,0.0),(5.20187,-4.944746,0.0),(4.678272,-4.469238,0.468132),(4.175348,-4.049251,0.844065),(3.77048,-3.750743,1.163039),(3.509777,-3.620594,1.479495),(3.399211,-3.679244,1.851112),(3.405085,-3.917481,2.321548),(3.463577,-4.297892,2.906287),(3.496971,-4.760733,3.585267),(3.432589,-5.233316,4.304331),(3.21989,-5.641425,4.985365),(2.841668,-5.920965,5.542879),(2.316807,-6.028036,5.903127),(1.694108,-5.945823,6.021217),(1.038932,-5.687237,5.892075),(0.416106,-5.292888,5.552545),(-0.126538,-4.824708,5.074012),(-0.569835,-4.356223,4.547179),(-0.92724,-3.961009,4.062504),(-1.240056,-3.701131,3.690838),(-1.565156,-3.617404,3.468742),(-1.958285,-3.722977,3.391849),(-2.457171,-4.001269,3.417717),(-3.068779,-4.408575,3.477349),(-3.764027,-4.88093,3.492507),(-4.481513,-5.344151,3.394614),(-5.139551,-5.725489,3.140714),(-5.653793,-5.965058,2.722723),(-5.95628,-6.025233,2.167909),(-6.011362,-5.896563,1.530681),(-5.824624,-5.599257,0.877921),(-5.442588,-5.180005,0.271628),(-4.943137,-4.70465,-0.246702),(-4.418819,-4.247845,-0.66603),(-3.956895,-3.881331,-1.007549),(-3.620751,-3.662667,-1.317846),(-3.436974,-3.626194,-1.65516),(-3.391042,-3.77764,-2.072223),(-3.432505,-4.093221,-2.600022),(-3.488292,-4.523376,-3.236662),(-3.480848,-5.000549,-3.94428),(-3.346713,-5.449803,-4.654994),(-3.051105,-5.800582,-5.284668),(-2.59509,-5.997798,-5.75131),(-2.013797,-6.010479,-5.993763),(-1.366308,-5.836632,-5.986187),(-0.719918,-5.503561,-5.744809),(-0.132803,-5.063572,-5.325219),(0.360515,-4.585767,-4.810734),(0.757233,-4.145181,-4.294479),(1.085848,-3.811009,-3.859333),(1.397352,-3.635732,-3.560394),(1.750257,-3.646875,-3.414003),(2.193248,-3.84269,-3.395811),(2.749857,-4.192424,-3.448211),(3.409134,-4.641152,-3.495212),(4.124809,-5.118402,-3.461126),(4.8234,-5.549224,-3.288539),(5.419491,-5.865957,-2.951297),(5.834638,-6.018861,-2.459506),(6.015408,-5.983921,-1.855508),(5.946202,-5.766625,-1.202051),(5.653717,-5.401098,-0.56574),(5.20187,-4.944746,0.0),(4.218363,-4.913805,0.0),(3.803691,-4.452898,0.380617),(3.472499,-4.126802,0.701981),(3.270443,-3.98673,1.008798),(3.2075,-4.054679,1.352075),(3.256955,-4.319979,1.773643),(3.362779,-4.740964,2.292704),(3.453545,-5.251521,2.897868),(3.459513,-5.771466,3.546864),(3.328788,-6.219145,4.174168),(3.038739,-6.52425,4.704889),(2.600072,-6.638865,5.071628),(2.052738,-6.54499,5.230291),(1.454894,-6.257369,5.171001),(0.867774,-5.82117,4.92139),(0.340329,-5.304899,4.541372),(-0.102509,-4.789634,4.110488),(-0.465015,-4.356297,3.710735),(-0.778046,-4.072941,3.408841),(-1.089291,-3.984068,3.242111),(-1.448905,-4.103635,3.211103),(-1.894159,-4.412863,3.28078),(-2.437078,-4.86319,3.389769),(-3.058259,-5.383893,3.465429),(-3.708614,-5.893196,3.441091),(-4.318796,-6.311115,3.271361),(-4.814174,-6.572016,2.941881),(-5.131826,-6.634926,2.471357),(-5.235453,-6.489965,1.905549),(-5.124577,-6.159899,1.304878),(-4.835718,-5.696563,0.728867),(-4.435117,-5.172724,0.221348),(-4.004636,-4.670648,-0.199863),(-3.624042,-4.269187,-0.546236),(-3.353815,-4.031388,-0.853986),(-3.22244,-3.994597,-1.172872),(-3.221131,-4.164592,-1.551215),(-3.307119,-4.514676,-2.020938),(-3.414646,-4.989869,-2.586494),(-3.470955,-5.515543,-3.220576),(-3.413425,-6.009142,-3.867881),(-3.203782,-6.393148,-4.45619),(-2.83607,-6.607253,-4.912218),(-2.336614,-6.617833,-5.178468),(-1.756186,-6.423226,-5.227022),(-1.156482,-6.053995,-5.06688),(-0.594373,-5.568127,-4.742983),(-0.107909,-5.041925,-4.327006),(0.292414,-4.55803,-3.901999),(0.624975,-4.192434,-3.544409),(0.93063,-4.002555,-3.307655),(1.260252,-4.018212,-3.21107),(1.659375,-4.236947,-3.23673),(2.153867,-4.624407,-3.334838),(2.740334,-5.119743,-3.436271),(3.383805,-5.645164,-3.469244),(4.023466,-6.118153,-3.376089),(4.585237,-6.464429,-3.126162),(4.998252,-6.62961,-2.721903),(5.211318,-6.587755,-2.196755),(5.205367,-6.345436,-1.605643),(4.998814,-5.94071,-1.010532),(4.644436,-5.437138,-0.464746),(4.218363,-4.913805,0.0),(3.347688,-4.809754,0.0),(3.088751,-4.459892,0.309076),(2.94167,-4.311907,0.594671),(2.919142,-4.389039,0.900436),(3.001066,-4.679176,1.265055),(3.139892,-5.136752,1.709894),(3.272146,-5.689906,2.230912),(3.333334,-6.251767,2.796999),(3.272683,-6.734094,3.355317),(3.064265,-7.061142,3.842467),(2.711919,-7.181546,4.198872),(2.246983,-7.076398,4.382902),(1.719528,-6.762212,4.381286),(1.185416,-6.288329,4.213219),(0.692443,-5.729171,3.92704),(0.269044,-5.172553,3.590137),(-0.081658,-4.705891,3.274379),(-0.381015,-4.402473,3.040431),(-0.667521,-4.309949,2.924601),(-0.984861,-4.44285,2.93129),(-1.368431,-4.780305,3.032754),(-1.833776,-5.269317,3.176194),(-2.36997,-5.833088,3.296427),(-2.939707,-6.383079,3.331093),(-3.486284,-6.832915,3.234799),(-3.945857,-7.111951,2.98887),(-4.2621,-7.176364,2.604515),(-4.399708,-7.01604,2.118788),(-4.353428,-6.656155,1.584518),(-4.15034,-6.15323,1.056806),(-3.844716,-5.586248,0.579498),(-3.506538,-5.044251,0.175004),(-3.206306,-4.612359,-0.16002),(-2.999654,-4.3584,-0.452125),(-2.915352,-4.322257,-0.74234),(-2.949487,-4.509606,-1.073525),(-3.067127,-4.891025,-1.47705),(-3.211031,-5.406613,-1.96222),(-3.315274,-5.975398,-2.511222),(-3.320533,-6.508053,-3.081005),(-3.187412,-6.920927,-3.611776),(-2.904694,-7.149178,-4.040183),(-2.490696,-7.156961,-4.314012),(-1.987548,-6.943052,-4.404859),(-1.449975,-6.541047,-4.315632),(-0.931455,-6.014078,-4.080972),(-0.471234,-5.444905,-3.760354),(-0.085424,-4.922916,-3.425385),(0.235626,-4.530086,-3.144217),(0.523107,-4.32811,-2.966688),(0.819777,-4.348708,-2.913661),(1.166822,-4.588643,-2.973015),(1.59091,-5.010236,-3.103185),(2.094781,-5.547275,-3.243355),(2.653859,-6.115421,-3.327833),(3.219882,-6.625447,-3.301182),(3.730815,-6.997255,-3.130526),(4.124729,-7.172454,-2.812192),(4.35433,-7.123528,-2.371241),(4.398594,-6.858162,-1.854163),(4.268621,-6.41803,-1.316695),(4.006171,-5.872255,-0.809865),(3.675113,-5.306549,-0.367751),(3.347688,-4.809754,0.0),(2.634628,-4.74669,0.0),(2.536552,-4.592814,0.25382),(2.54548,-4.678846,0.51458),(2.647303,-4.991275,0.816585),(2.803335,-5.481034,1.181705),(2.959427,-6.071208,1.611618),(3.058454,-6.669112,2.085219),(3.053219,-7.180846,2.561955),(2.916741,-7.526044,2.990387),(2.647568,-7.650493,3.319946),(2.268967,-7.534648,3.513048),(1.822332,-7.196704,3.55459),(1.356549,-6.689733,3.456432),(0.916006,-6.093353,3.255679),(0.530222,-5.501225,3.007041),(0.207656,-5.006342,2.770976),(-0.064849,-4.686422,2.600368),(-0.316903,-4.59171,2.528828),(-0.585073,-4.737078,2.563371),(-0.901497,-5.099699,2.683169),(-1.283549,-5.622621,2.844636),(-1.727224,-6.223723,2.99164),(-2.206016,-6.808603,3.068381),(-2.675679,-7.285406,3.031913),(-3.083823,-7.579252,2.86137),(-3.382043,-7.643992,2.561798),(-3.537649,-7.469461,2.161812),(-3.542089,-7.083067,1.70578),(-3.413945,-6.545492,1.242574),(-3.195643,-5.941162,0.813711),(-2.94455,-5.364985,0.443819),(-2.72047,-4.907448,0.135773),(-2.572434,-4.640407,-0.128385),(-2.527874,-4.605799,-0.381016),(-2.586705,-4.809059,-0.658656),(-2.721702,-5.218267,-0.990618),(-2.885031,-5.769156,-1.389358),(-3.019397,-6.375212,-1.845115),(-3.071121,-6.941254,-2.326284),(-3.002096,-7.378387,-2.785538),(-2.797815,-7.617961,-3.17031),(-2.469673,-7.62235,-3.435106),(-2.051133,-7.390866,-3.552666),(-1.588818,-6.959862,-3.521182),(-1.130831,-6.397027,-3.365749),(-0.715211,-5.790753,-3.133545),(-0.361387,-5.236253,-2.883802),(-0.066706,-4.82061,-2.674825),(0.191179,-4.6091,-2.551106),(0.446728,-4.634941,-2.533518),(0.73572,-4.894073,-2.614903),(1.084026,-5.345801,-2.762053),(1.498841,-5.919182,-2.923597),(1.964673,-6.524168,-3.041909),(2.445208,-7.065748,-3.066194),(2.890707,-7.458867,-2.963695),(3.249206,-7.641787,-2.726408),(3.478839,-7.585781,-2.371832),(3.558232,-7.299645,-1.93771),(3.492417,-6.828315,-1.472177),(3.312693,-6.245813,-1.02183),(3.070355,-5.64362,-0.620686),(2.825671,-5.116307,-0.282751),(2.634628,-4.74669,0.0),(2.071254,-4.826593,0.0),(2.101304,-4.921072,0.210267),(2.209522,-5.252949,0.446665),(2.366138,-5.770104,0.729857),(2.527361,-6.391319,1.065372),(2.645295,-7.019033,1.440551),(2.678635,-7.554666,1.826263),(2.601645,-7.914098,2.18304),(2.409345,-8.04088,2.47018),(2.117769,-7.915103,2.655599),(1.759346,-7.556518,2.724),(1.374626,-7.021441,2.681306),(1.002438,-6.393905,2.554169),(0.670915,-5.772462,2.384573),(0.391572,-5.254708,2.220715),(0.157843,-4.921956,2.106272),(-0.051636,-4.826464,2.070555),(-0.265905,-4.983227,2.121875),(-0.512562,-5.367628,2.245679),(-0.80901,-5.919296,2.407897),(-1.156338,-6.551594,2.562708),(-1.537419,-7.165221,2.662888),(-1.919815,-7.663807,2.670301),(-2.262826,-7.969052,2.564094),(-2.527005,-8.033018,2.344718),(-2.683815,-7.845658,2.032911),(-2.72303,-7.436397,1.664009),(-2.656001,-6.869509,1.279063),(-2.513893,-6.234022,0.914982),(-2.341204,-5.629737,0.596144),(-2.186015,-5.151557,0.329489),(-2.089246,-4.874577,0.10427),(-2.075411,-4.842298,-0.103579),(-2.147074,-5.059789,-0.323619),(-2.284295,-5.492892,-0.581653),(-2.449199,-6.073591,-0.891436),(-2.594595,-6.710688,-1.249491),(-2.674596,-7.304128,-1.634412),(-2.654758,-7.760713,-2.010901),(-2.519367,-8.008738,-2.337631),(-2.274241,-8.009251,-2.577028),(-1.944456,-7.76217,-2.704573),(-1.56769,-7.306301,-2.715319),(-1.184867,-6.713235,-2.625935),(-0.830443,-6.076113,-2.471688),(-0.524724,-5.494993,-2.298965),(-0.270063,-5.061138,-2.155049),(-0.05181,-4.842684,-2.077513),(0.156303,-4.873939,-2.085723),(0.383769,-5.149995,-2.176461),(0.654066,-5.627497,-2.324688),(0.976969,-6.231455,-2.489275),(1.344393,-6.867019,-2.622336),(1.730908,-7.434375,-2.679969),(2.098857,-7.844421,-2.631884),(2.406912,-8.03276,-2.467685),(2.619962,-7.969815,-2.198409),(2.717923,-7.66547,-1.853048),(2.701257,-7.167523,-1.471026),(2.59176,-6.554174,-1.092518),(2.428323,-5.921748,-0.749038),(2.258575,-5.369567,-0.456581),(2.128324,-4.98435,-0.212971),(2.071254,-4.826593,0.0),(1.604267,-5.113169,0.0),(1.705004,-5.46138,0.170611),(1.845436,-6.00081,0.373063),(1.99278,-6.646745,0.614691),(2.109887,-7.297742,0.889392),(2.163449,-7.851563,1.178152),(2.131223,-8.221231,1.453043),(2.006591,-8.348692,1.68373),(1.799452,-8.213928,1.844887),(1.533299,-7.838103,1.922696),(1.239279,-7.28024,1.918779),(0.948705,-6.62795,1.850517),(0.685887,-5.983673,1.747613),(0.463004,-5.448591,1.645612),(0.278228,-5.106739,1.577908),(0.11751,-5.011802,1.568066),(-0.040508,-5.17869,1.62432),(-0.21774,-5.581195,1.737521),(-0.429797,-6.156103,1.883063),(-0.680807,-6.813127,2.02632),(-0.961246,-7.449083,2.130339),(-1.249375,-7.964095,2.163982),(-1.51599,-8.277282,2.108614),(-1.731316,-8.339459,1.961819),(-1.87237,-8.140861,1.737305),(-1.928955,-7.712677,1.461127),(-1.906755,-7.122152,1.165194),(-1.826691,-6.462028,0.879688),(-1.720623,-5.835975,0.626256),(-1.62433,-5.342313,0.413605),(-1.56941,-5.05857,0.23655),(-1.575994,-5.029308,0.078655),(-1.648009,-5.259122,-0.082249),(-1.77211,-5.711921,-0.267103),(-1.92056,-6.316593,-0.489035),(-2.057379,-6.978176,-0.748825),(-2.14633,-7.592771,-1.033618),(-2.158869,-8.063856,-1.319258),(-2.08021,-8.317448,-1.575698),(-1.912127,-8.313723,-1.774195),(-1.6719,-8.053264,-1.894493),(-1.387729,-7.576977,-1.930214),(-1.091804,-6.95966,-1.89106),(-0.812741,-6.298263,-1.80122),(-0.569243,-5.696655,-1.694266),(-0.366488,-5.249318,-1.605691),(-0.1961,-5.026506,-1.564837),(-0.039605,-5.063209,-1.588098),(0.125526,-5.353665,-1.675026),(0.318845,-5.852257,-1.808262),(0.550707,-6.480684,-1.95733),(0.818462,-7.140251,-2.085407),(1.106074,-7.727376,-2.157476),(1.387309,-8.149852,-2.147974),(1.631741,-8.341331,-2.046139),(1.812117,-8.27174,-1.857872),(1.91125,-7.95201,-1.603729),(1.926719,-7.432352,-1.313615),(1.872149,-6.794378,-1.019518),(1.774669,-6.138281,-0.748086),(1.669088,-5.567098,-0.514845),(1.5901,-5.170533,-0.321446),(1.564356,-5.010865,-0.156537),(1.604267,-5.113169,0.0),(1.153765,-5.614286,0.0),(1.261787,-6.170592,0.126261),(1.376708,-6.834651,0.278307),(1.473241,-7.502174,0.454435),(1.527885,-8.068329,0.644057),(1.524002,-8.444201,0.829927),(1.455284,-8.570762,0.992196),(1.326809,-8.428135,1.113325),(1.153486,-8.03872,1.182611),(0.956323,-7.463673,1.199192),(0.757427,-6.793303,1.172726),(0.574981,-6.132892,1.121542),(0.419406,-5.586154,1.068628),(0.291596,-5.238954,1.036392),(0.183632,-5.145818,1.041427),(0.081723,-5.321374,1.090512),(-0.029398,-5.738051,1.178833),(-0.161763,-6.33041,1.290836),(-0.320353,-7.005423,1.403556),(-0.501161,-7.657081,1.49163),(-0.691644,-8.183043,1.532841),(-0.87347,-8.500707,1.512894),(-1.0269,-8.560186,1.428331),(-1.135723,-8.352137,1.28693),(-1.191495,-7.909236,1.105545),(-1.196019,-7.301037,0.905949),(-1.161391,-6.623058,0.709711),(-1.107548,-5.981774,0.533367),(-1.057846,-5.477896,0.385024),(-1.033702,-5.190557,0.263213),(-1.049556,-5.164884,0.158195),(-1.109356,-5.404907,0.055366),(-1.205418,-5.872933,-0.06016),(-1.319942,-6.495459,-0.198949),(-1.428848,-7.174718,-0.363829),(-1.507051,-7.804034,-0.548522),(-1.533921,-8.284576,-0.738697),(-1.497691,-8.540875,-0.91522),(-1.39778,-8.532679,-1.058777),(-1.244528,-8.261277,-1.154753),(-1.056467,-7.769291,-1.197123),(-0.85581,-7.133986,-1.190359),(-0.663282,-6.455135,-1.148838),(-0.493552,-5.839351,-1.093823),(-0.352343,-5.383341,-1.048696),(-0.235904,-5.158719,-1.033564),(-0.132897,-5.200763,-1.060489),(-0.028193,-5.502869,-1.130517),(0.092415,-6.017593,-1.233189),(0.237812,-6.664098,-1.348701),(0.408585,-7.340852,-1.452199),(0.596249,-7.941572,-1.519218),(0.784898,-8.371918,-1.531),(0.954886,-8.564304,-1.478453),(1.087637,-8.488516,-1.363854),(1.170381,-8.156457,-1.199932),(1.199631,-7.620276,-1.00661),(1.182492,-6.964179,-0.80621),(1.135431,-6.291203,-0.618323),(1.080732,-5.70704,-0.455567),(1.041462,-5.303429,-0.321248),(1.03611,-5.143757,-0.209454),(1.074175,-5.2531,-0.107487),(1.153765,-5.614286,0.0),(0.63836,-6.277503,0.0),(0.703526,-6.952883,0.070398),(0.760513,-7.630022,0.153741),(0.797063,-8.202577,0.245861),(0.804048,-8.58063,0.338935),(0.777395,-8.704809,0.423347),(0.718845,-8.555611,0.4901),(0.635382,-8.156468,0.533148),(0.537503,-7.570064,0.551074),(0.436749,-6.888493,0.547666),(0.343101,-6.218793,0.531224),(0.262864,-5.66614,0.512735),(0.197547,-5.317326,0.503341),(0.143965,-5.227131,0.51168),(0.095526,-5.409721,0.541757),(0.044353,-5.83642,0.591846),(-0.016327,-6.440216,0.654702),(-0.090108,-7.126285,0.719048),(-0.176203,-7.78688,0.771995),(-0.269403,-8.318258,0.801837),(-0.361231,-8.636966,0.80057),(-0.441993,-8.692952,0.765555),(-0.503228,-8.477424,0.699947),(-0.539925,-8.02423,0.61181),(-0.551965,-7.404542,0.512149),(-0.544376,-6.715682,0.412349),(-0.52634,-6.065833,0.321639),(-0.509135,-5.557052,0.245186),(-0.503515,-5.269243,0.183265),(-0.517128,-5.247604,0.131677),(-0.552599,-5.495535,0.083291),(-0.606751,-5.974098,0.030282),(-0.671146,-6.608136,-0.033496),(-0.733853,-7.298075,-0.11061),(-0.782014,-7.935561,-0.199125),(-0.804639,-8.42048,-0.292865),(-0.794953,-8.676676,-0.382829),(-0.751778,-8.663913,-0.459402),(-0.679627,-8.384197,-0.514797),(-0.587516,-7.881455,-0.545135),(-0.486796,-7.234643,-0.551607),(-0.388537,-6.54534,-0.540423),(-0.301094,-5.9218,-0.52151),(-0.22844,-5.461949,-0.506274),(-0.169643,-5.238004,-0.504916),(-0.119593,-5.285137,-0.523971),(-0.070758,-5.595944,-0.564636),(-0.01552,-6.121614,-0.622314),(0.05152,-6.779592,-0.687489),(0.131846,-7.466545,-0.747738),(0.222389,-8.074588,-0.790416),(0.316094,-8.508228,-0.805394),(0.403582,-8.699365,-0.787215),(0.475467,-8.617981,-0.736168),(0.524775,-8.276856,-0.658047),(0.548828,-7.729563,-0.562685),(0.550128,-7.062055,-0.461612),(0.535979,-6.37916,-0.365424),(0.516917,-5.788126,-0.281498),(0.504299,-5.381774,-0.21258),(0.50762,-5.22392,-0.15658),(0.532194,-5.339355,-0.107585),(0.57776,-5.70995,-0.057814),(0.63836,-6.277503,0.0),(0.0,-7.0,0.0),(0.0,-7.679761,0.0),(0.0,-8.252767,0.0),(0.0,-8.629029,0.0),(0.0,-8.749456,0.0),(0.0,-8.595135,0.0),(0.0,-8.190302,0.0),(0.0,-7.598535,0.0),(0.0,-6.91277,0.0),(0.0,-6.240703,0.0),(0.0,-5.687883,0.0),(0.0,-5.341127,0.0),(0.0,-5.254893,0.0),(0.0,-5.442724,0.0),(0.0,-5.875122,0.0),(0.0,-6.484178,0.0),(0.0,-7.174244,0.0),(0.0,-7.836944,0.0),(0.0,-8.368205,0.0),(0.0,-8.684592,0.0),(0.0,-8.736419,0.0),(0.0,-8.515544,0.0),(0.0,-8.056658,0.0),(0.0,-7.431825,0.0),(0.0,-6.739176,0.0),(0.0,-6.087488,0.0),(0.0,-5.579108,0.0),(0.0,-5.293876,0.0),(0.0,-5.276586,0.0),(0.0,-5.529955,0.0),(0.0,-6.01419,0.0),(0.0,-6.653244,0.0),(0.0,-7.346756,0.0),(0.0,-7.98581,0.0),(0.0,-8.470045,0.0),(0.0,-8.723414,0.0),(0.0,-8.706124,0.0),(0.0,-8.420892,0.0),(0.0,-7.912512,0.0),(0.0,-7.260824,0.0),(0.0,-6.568175,0.0),(0.0,-5.943342,0.0),(0.0,-5.484456,0.0),(0.0,-5.263581,0.0),(0.0,-5.315408,0.0),(0.0,-5.631795,0.0),(0.0,-6.163056,0.0),(0.0,-6.825756,0.0),(0.0,-7.515822,0.0),(0.0,-8.124878,0.0),(0.0,-8.557276,0.0),(0.0,-8.745107,0.0),(0.0,-8.658873,0.0),(0.0,-8.312117,0.0),(0.0,-7.759297,0.0),(0.0,-7.08723,0.0),(0.0,-6.401465,0.0),(0.0,-5.809698,0.0),(0.0,-5.404865,0.0),(0.0,-5.250544,0.0),(0.0,-5.370971,0.0),(0.0,-5.747233,0.0),(0.0,-6.320239,0.0),(0.0,-7.0,0.0)]))),
      Shape(
        appearance=Appearance(
          material=Material(diffuseColor=(1.0,1.0,0.0))),
        geometry=IndexedFaceSet(ccw=False,coordIndex=[0,1,65,64,-1,1,2,66,65,-1,2,3,67,66,-1,3,4,68,67,-1,4,5,69,68,-1,5,6,70,69,-1,6,7,71,70,-1,7,8,72,71,-1,8,9,73,72,-1,9,10,74,73,-1,10,11,75,74,-1,11,12,76,75,-1,12,13,77,76,-1,13,14,78,77,-1,14,15,79,78,-1,15,16,80,79,-1,16,17,81,80,-1,17,18,82,81,-1,18,19,83,82,-1,19,20,84,83,-1,20,21,85,84,-1,21,22,86,85,-1,22,23,87,86,-1,23,24,88,87,-1,24,25,89,88,-1,25,26,90,89,-1,26,27,91,90,-1,27,28,92,91,-1,28,29,93,92,-1,29,30,94,93,-1,30,31,95,94,-1,31,32,96,95,-1,32,33,97,96,-1,33,34,98,97,-1,34,35,99,98,-1,35,36,100,99,-1,36,37,101,100,-1,37,38,102,101,-1,38,39,103,102,-1,39,40,104,103,-1,40,41,105,104,-1,41,42,106,105,-1,42,43,107,106,-1,43,44,108,107,-1,44,45,109,108,-1,45,46,110,109,-1,46,47,111,110,-1,47,48,112,111,-1,48,49,113,112,-1,49,50,114,113,-1,50,51,115,114,-1,51,52,116,115,-1,52,53,117,116,-1,53,54,118,117,-1,54,55,119,118,-1,55,56,120,119,-1,56,57,121,120,-1,57,58,122,121,-1,58,59,123,122,-1,59,60,124,123,-1,60,61,125,124,-1,61,62,126,125,-1,62,63,127,126,-1,63,0,64,127,-1,64,65,129,128,-1,65,66,130,129,-1,66,67,131,130,-1,67,68,132,131,-1,68,69,133,132,-1,69,70,134,133,-1,70,71,135,134,-1,71,72,136,135,-1,72,73,137,136,-1,73,74,138,137,-1,74,75,139,138,-1,75,76,140,139,-1,76,77,141,140,-1,77,78,142,141,-1,78,79,143,142,-1,79,80,144,143,-1,80,81,145,144,-1,81,82,146,145,-1,82,83,147,146,-1,83,84,148,147,-1,84,85,149,148,-1,85,86,150,149,-1,86,87,151,150,-1,87,88,152,151,-1,88,89,153,152,-1,89,90,154,153,-1,90,91,155,154,-1,91,92,156,155,-1,92,93,157,156,-1,93,94,158,157,-1,94,95,159,158,-1,95,96,160,159,-1,96,97,161,160,-1,97,98,162,161,-1,98,99,163,162,-1,99,100,164,163,-1,100,101,165,164,-1,101,102,166,165,-1,102,103,167,166,-1,103,104,168,167,-1,104,105,169,168,-1,105,106,170,169,-1,106,107,171,170,-1,107,108,172,171,-1,108,109,173,172,-1,109,110,174,173,-1,110,111,175,174,-1,111,112,176,175,-1,112,113,177,176,-1,113,114,178,177,-1,114,115,179,178,-1,115,116,180,179,-1,116,117,181,180,-1,117,118,182,181,-1,118,119,183,182,-1,119,120,184,183,-1,120,121,185,184,-1,121,122,186,185,-1,122,123,187,186,-1,123,124,188,187,-1,124,125,189,188,-1,125,126,190,189,-1,126,127,191,190,-1,127,64,128,191,-1,128,129,193,192,-1,129,130,194,193,-1,130,131,195,194,-1,131,132,196,195,-1,132,133,197,196,-1,133,134,198,197,-1,134,135,199,198,-1,135,136,200,199,-1,136,137,201,200,-1,137,138,202,201,-1,138,139,203,202,-1,139,140,204,203,-1,140,141,205,204,-1,141,142,206,205,-1,142,143,207,206,-1,143,144,208,207,-1,144,145,209,208,-1,145,146,210,209,-1,146,147,211,210,-1,147,148,212,211,-1,148,149,213,212,-1,149,150,214,213,-1,150,151,215,214,-1,151,152,216,215,-1,152,153,217,216,-1,153,154,218,217,-1,154,155,219,218,-1,155,156,220,219,-1,156,157,221,220,-1,157,158,222,221,-1,158,159,223,222,-1,159,160,224,223,-1,160,161,225,224,-1,161,162,226,225,-1,162,163,227,226,-1,163,164,228,227,-1,164,165,229,228,-1,165,166,230,229,-1,166,167,231,230,-1,167,168,232,231,-1,168,169,233,232,-1,169,170,234,233,-1,170,171,235,234,-1,171,172,236,235,-1,172,173,237,236,-1,173,174,238,237,-1,174,175,239,238,-1,175,176,240,239,-1,176,177,241,240,-1,177,178,242,241,-1,178,179,243,242,-1,179,180,244,243,-1,180,181,245,244,-1,181,182,246,245,-1,182,183,247,246,-1,183,184,248,247,-1,184,185,249,248,-1,185,186,250,249,-1,186,187,251,250,-1,187,188,252,251,-1,188,189,253,252,-1,189,190,254,253,-1,190,191,255,254,-1,191,128,192,255,-1,192,193,257,256,-1,193,194,258,257,-1,194,195,259,258,-1,195,196,260,259,-1,196,197,261,260,-1,197,198,262,261,-1,198,199,263,262,-1,199,200,264,263,-1,200,201,265,264,-1,201,202,266,265,-1,202,203,267,266,-1,203,204,268,267,-1,204,205,269,268,-1,205,206,270,269,-1,206,207,271,270,-1,207,208,272,271,-1,208,209,273,272,-1,209,210,274,273,-1,210,211,275,274,-1,211,212,276,275,-1,212,213,277,276,-1,213,214,278,277,-1,214,215,279,278,-1,215,216,280,279,-1,216,217,281,280,-1,217,218,282,281,-1,218,219,283,282,-1,219,220,284,283,-1,220,221,285,284,-1,221,222,286,285,-1,222,223,287,286,-1,223,224,288,287,-1,224,225,289,288,-1,225,226,290,289,-1,226,227,291,290,-1,227,228,292,291,-1,228,229,293,292,-1,229,230,294,293,-1,230,231,295,294,-1,231,232,296,295,-1,232,233,297,296,-1,233,234,298,297,-1,234,235,299,298,-1,235,236,300,299,-1,236,237,301,300,-1,237,238,302,301,-1,238,239,303,302,-1,239,240,304,303,-1,240,241,305,304,-1,241,242,306,305,-1,242,243,307,306,-1,243,244,308,307,-1,244,245,309,308,-1,245,246,310,309,-1,246,247,311,310,-1,247,248,312,311,-1,248,249,313,312,-1,249,250,314,313,-1,250,251,315,314,-1,251,252,316,315,-1,252,253,317,316,-1,253,254,318,317,-1,254,255,319,318,-1,255,192,256,319,-1,256,257,321,320,-1,257,258,322,321,-1,258,259,323,322,-1,259,260,324,323,-1,260,261,325,324,-1,261,262,326,325,-1,262,263,327,326,-1,263,264,328,327,-1,264,265,329,328,-1,265,266,330,329,-1,266,267,331,330,-1,267,268,332,331,-1,268,269,333,332,-1,269,270,334,333,-1,270,271,335,334,-1,271,272,336,335,-1,272,273,337,336,-1,273,274,338,337,-1,274,275,339,338,-1,275,276,340,339,-1,276,277,341,340,-1,277,278,342,341,-1,278,279,343,342,-1,279,280,344,343,-1,280,281,345,344,-1,281,282,346,345,-1,282,283,347,346,-1,283,284,348,347,-1,284,285,349,348,-1,285,286,350,349,-1,286,287,351,350,-1,287,288,352,351,-1,288,289,353,352,-1,289,290,354,353,-1,290,291,355,354,-1,291,292,356,355,-1,292,293,357,356,-1,293,294,358,357,-1,294,295,359,358,-1,295,296,360,359,-1,296,297,361,360,-1,297,298,362,361,-1,298,299,363,362,-1,299,300,364,363,-1,300,301,365,364,-1,301,302,366,365,-1,302,303,367,366,-1,303,304,368,367,-1,304,305,369,368,-1,305,306,370,369,-1,306,307,371,370,-1,307,308,372,371,-1,308,309,373,372,-1,309,310,374,373,-1,310,311,375,374,-1,311,312,376,375,-1,312,313,377,376,-1,313,314,378,377,-1,314,315,379,378,-1,315,316,380,379,-1,316,317,381,380,-1,317,318,382,381,-1,318,319,383,382,-1,319,256,320,383,-1,320,321,385,384,-1,321,322,386,385,-1,322,323,387,386,-1,323,324,388,387,-1,324,325,389,388,-1,325,326,390,389,-1,326,327,391,390,-1,327,328,392,391,-1,328,329,393,392,-1,329,330,394,393,-1,330,331,395,394,-1,331,332,396,395,-1,332,333,397,396,-1,333,334,398,397,-1,334,335,399,398,-1,335,336,400,399,-1,336,337,401,400,-1,337,338,402,401,-1,338,339,403,402,-1,339,340,404,403,-1,340,341,405,404,-1,341,342,406,405,-1,342,343,407,406,-1,343,344,408,407,-1,344,345,409,408,-1,345,346,410,409,-1,346,347,411,410,-1,347,348,412,411,-1,348,349,413,412,-1,349,350,414,413,-1,350,351,415,414,-1,351,352,416,415,-1,352,353,417,416,-1,353,354,418,417,-1,354,355,419,418,-1,355,356,420,419,-1,356,357,421,420,-1,357,358,422,421,-1,358,359,423,422,-1,359,360,424,423,-1,360,361,425,424,-1,361,362,426,425,-1,362,363,427,426,-1,363,364,428,427,-1,364,365,429,428,-1,365,366,430,429,-1,366,367,431,430,-1,367,368,432,431,-1,368,369,433,432,-1,369,370,434,433,-1,370,371,435,434,-1,371,372,436,435,-1,372,373,437,436,-1,373,374,438,437,-1,374,375,439,438,-1,375,376,440,439,-1,376,377,441,440,-1,377,378,442,441,-1,378,379,443,442,-1,379,380,444,443,-1,380,381,445,444,-1,381,382,446,445,-1,382,383,447,446,-1,383,320,384,447,-1,384,385,449,448,-1,385,386,450,449,-1,386,387,451,450,-1,387,388,452,451,-1,388,389,453,452,-1,389,390,454,453,-1,390,391,455,454,-1,391,392,456,455,-1,392,393,457,456,-1,393,394,458,457,-1,394,395,459,458,-1,395,396,460,459,-1,396,397,461,460,-1,397,398,462,461,-1,398,399,463,462,-1,399,400,464,463,-1,400,401,465,464,-1,401,402,466,465,-1,402,403,467,466,-1,403,404,468,467,-1,404,405,469,468,-1,405,406,470,469,-1,406,407,471,470,-1,407,408,472,471,-1,408,409,473,472,-1,409,410,474,473,-1,410,411,475,474,-1,411,412,476,475,-1,412,413,477,476,-1,413,414,478,477,-1,414,415,479,478,-1,415,416,480,479,-1,416,417,481,480,-1,417,418,482,481,-1,418,419,483,482,-1,419,420,484,483,-1,420,421,485,484,-1,421,422,486,485,-1,422,423,487,486,-1,423,424,488,487,-1,424,425,489,488,-1,425,426,490,489,-1,426,427,491,490,-1,427,428,492,491,-1,428,429,493,492,-1,429,430,494,493,-1,430,431,495,494,-1,431,432,496,495,-1,432,433,497,496,-1,433,434,498,497,-1,434,435,499,498,-1,435,436,500,499,-1,436,437,501,500,-1,437,438,502,501,-1,438,439,503,502,-1,439,440,504,503,-1,440,441,505,504,-1,441,442,506,505,-1,442,443,507,506,-1,443,444,508,507,-1,444,445,509,508,-1,445,446,510,509,-1,446,447,511,510,-1,447,384,448,511,-1,448,449,513,512,-1,449,450,514,513,-1,450,451,515,514,-1,451,452,516,515,-1,452,453,517,516,-1,453,454,518,517,-1,454,455,519,518,-1,455,456,520,519,-1,456,457,521,520,-1,457,458,522,521,-1,458,459,523,522,-1,459,460,524,523,-1,460,461,525,524,-1,461,462,526,525,-1,462,463,527,526,-1,463,464,528,527,-1,464,465,529,528,-1,465,466,530,529,-1,466,467,531,530,-1,467,468,532,531,-1,468,469,533,532,-1,469,470,534,533,-1,470,471,535,534,-1,471,472,536,535,-1,472,473,537,536,-1,473,474,538,537,-1,474,475,539,538,-1,475,476,540,539,-1,476,477,541,540,-1,477,478,542,541,-1,478,479,543,542,-1,479,480,544,543,-1,480,481,545,544,-1,481,482,546,545,-1,482,483,547,546,-1,483,484,548,547,-1,484,485,549,548,-1,485,486,550,549,-1,486,487,551,550,-1,487,488,552,551,-1,488,489,553,552,-1,489,490,554,553,-1,490,491,555,554,-1,491,492,556,555,-1,492,493,557,556,-1,493,494,558,557,-1,494,495,559,558,-1,495,496,560,559,-1,496,497,561,560,-1,497,498,562,561,-1,498,499,563,562,-1,499,500,564,563,-1,500,501,565,564,-1,501,502,566,565,-1,502,503,567,566,-1,503,504,568,567,-1,504,505,569,568,-1,505,506,570,569,-1,506,507,571,570,-1,507,508,572,571,-1,508,509,573,572,-1,509,510,574,573,-1,510,511,575,574,-1,511,448,512,575,-1,512,513,577,576,-1,513,514,578,577,-1,514,515,579,578,-1,515,516,580,579,-1,516,517,581,580,-1,517,518,582,581,-1,518,519,583,582,-1,519,520,584,583,-1,520,521,585,584,-1,521,522,586,585,-1,522,523,587,586,-1,523,524,588,587,-1,524,525,589,588,-1,525,526,590,589,-1,526,527,591,590,-1,527,528,592,591,-1,528,529,593,592,-1,529,530,594,593,-1,530,531,595,594,-1,531,532,596,595,-1,532,533,597,596,-1,533,534,598,597,-1,534,535,599,598,-1,535,536,600,599,-1,536,537,601,600,-1,537,538,602,601,-1,538,539,603,602,-1,539,540,604,603,-1,540,541,605,604,-1,541,542,606,605,-1,542,543,607,606,-1,543,544,608,607,-1,544,545,609,608,-1,545,546,610,609,-1,546,547,611,610,-1,547,548,612,611,-1,548,549,613,612,-1,549,550,614,613,-1,550,551,615,614,-1,551,552,616,615,-1,552,553,617,616,-1,553,554,618,617,-1,554,555,619,618,-1,555,556,620,619,-1,556,557,621,620,-1,557,558,622,621,-1,558,559,623,622,-1,559,560,624,623,-1,560,561,625,624,-1,561,562,626,625,-1,562,563,627,626,-1,563,564,628,627,-1,564,565,629,628,-1,565,566,630,629,-1,566,567,631,630,-1,567,568,632,631,-1,568,569,633,632,-1,569,570,634,633,-1,570,571,635,634,-1,571,572,636,635,-1,572,573,637,636,-1,573,574,638,637,-1,574,575,639,638,-1,575,512,576,639,-1,576,577,641,640,-1,577,578,642,641,-1,578,579,643,642,-1,579,580,644,643,-1,580,581,645,644,-1,581,582,646,645,-1,582,583,647,646,-1,583,584,648,647,-1,584,585,649,648,-1,585,586,650,649,-1,586,587,651,650,-1,587,588,652,651,-1,588,589,653,652,-1,589,590,654,653,-1,590,591,655,654,-1,591,592,656,655,-1,592,593,657,656,-1,593,594,658,657,-1,594,595,659,658,-1,595,596,660,659,-1,596,597,661,660,-1,597,598,662,661,-1,598,599,663,662,-1,599,600,664,663,-1,600,601,665,664,-1,601,602,666,665,-1,602,603,667,666,-1,603,604,668,667,-1,604,605,669,668,-1,605,606,670,669,-1,606,607,671,670,-1,607,608,672,671,-1,608,609,673,672,-1,609,610,674,673,-1,610,611,675,674,-1,611,612,676,675,-1,612,613,677,676,-1,613,614,678,677,-1,614,615,679,678,-1,615,616,680,679,-1,616,617,681,680,-1,617,618,682,681,-1,618,619,683,682,-1,619,620,684,683,-1,620,621,685,684,-1,621,622,686,685,-1,622,623,687,686,-1,623,624,688,687,-1,624,625,689,688,-1,625,626,690,689,-1,626,627,691,690,-1,627,628,692,691,-1,628,629,693,692,-1,629,630,694,693,-1,630,631,695,694,-1,631,632,696,695,-1,632,633,697,696,-1,633,634,698,697,-1,634,635,699,698,-1,635,636,700,699,-1,636,637,701,700,-1,637,638,702,701,-1,638,639,703,702,-1,639,576,640,703,-1,640,641,705,704,-1,641,642,706,705,-1,642,643,707,706,-1,643,644,708,707,-1,644,645,709,708,-1,645,646,710,709,-1,646,647,711,710,-1,647,648,712,711,-1,648,649,713,712,-1,649,650,714,713,-1,650,651,715,714,-1,651,652,716,715,-1,652,653,717,716,-1,653,654,718,717,-1,654,655,719,718,-1,655,656,720,719,-1,656,657,721,720,-1,657,658,722,721,-1,658,659,723,722,-1,659,660,724,723,-1,660,661,725,724,-1,661,662,726,725,-1,662,663,727,726,-1,663,664,728,727,-1,664,665,729,728,-1,665,666,730,729,-1,666,667,731,730,-1,667,668,732,731,-1,668,669,733,732,-1,669,670,734,733,-1,670,671,735,734,-1,671,672,736,735,-1,672,673,737,736,-1,673,674,738,737,-1,674,675,739,738,-1,675,676,740,739,-1,676,677,741,740,-1,677,678,742,741,-1,678,679,743,742,-1,679,680,744,743,-1,680,681,745,744,-1,681,682,746,745,-1,682,683,747,746,-1,683,684,748,747,-1,684,685,749,748,-1,685,686,750,749,-1,686,687,751,750,-1,687,688,752,751,-1,688,689,753,752,-1,689,690,754,753,-1,690,691,755,754,-1,691,692,756,755,-1,692,693,757,756,-1,693,694,758,757,-1,694,695,759,758,-1,695,696,760,759,-1,696,697,761,760,-1,697,698,762,761,-1,698,699,763,762,-1,699,700,764,763,-1,700,701,765,764,-1,701,702,766,765,-1,702,703,767,766,-1,703,640,704,767,-1,704,705,769,768,-1,705,706,770,769,-1,706,707,771,770,-1,707,708,772,771,-1,708,709,773,772,-1,709,710,774,773,-1,710,711,775,774,-1,711,712,776,775,-1,712,713,777,776,-1,713,714,778,777,-1,714,715,779,778,-1,715,716,780,779,-1,716,717,781,780,-1,717,718,782,781,-1,718,719,783,782,-1,719,720,784,783,-1,720,721,785,784,-1,721,722,786,785,-1,722,723,787,786,-1,723,724,788,787,-1,724,725,789,788,-1,725,726,790,789,-1,726,727,791,790,-1,727,728,792,791,-1,728,729,793,792,-1,729,730,794,793,-1,730,731,795,794,-1,731,732,796,795,-1,732,733,797,796,-1,733,734,798,797,-1,734,735,799,798,-1,735,736,800,799,-1,736,737,801,800,-1,737,738,802,801,-1,738,739,803,802,-1,739,740,804,803,-1,740,741,805,804,-1,741,742,806,805,-1,742,743,807,806,-1,743,744,808,807,-1,744,745,809,808,-1,745,746,810,809,-1,746,747,811,810,-1,747,748,812,811,-1,748,749,813,812,-1,749,750,814,813,-1,750,751,815,814,-1,751,752,816,815,-1,752,753,817,816,-1,753,754,818,817,-1,754,755,819,818,-1,755,756,820,819,-1,756,757,821,820,-1,757,758,822,821,-1,758,759,823,822,-1,759,760,824,823,-1,760,761,825,824,-1,761,762,826,825,-1,762,763,827,826,-1,763,764,828,827,-1,764,765,829,828,-1,765,766,830,829,-1,766,767,831,830,-1,767,704,768,831,-1,768,769,833,832,-1,769,770,834,833,-1,770,771,835,834,-1,771,772,836,835,-1,772,773,837,836,-1,773,774,838,837,-1,774,775,839,838,-1,775,776,840,839,-1,776,777,841,840,-1,777,778,842,841,-1,778,779,843,842,-1,779,780,844,843,-1,780,781,845,844,-1,781,782,846,845,-1,782,783,847,846,-1,783,784,848,847,-1,784,785,849,848,-1,785,786,850,849,-1,786,787,851,850,-1,787,788,852,851,-1,788,789,853,852,-1,789,790,854,853,-1,790,791,855,854,-1,791,792,856,855,-1,792,793,857,856,-1,793,794,858,857,-1,794,795,859,858,-1,795,796,860,859,-1,796,797,861,860,-1,797,798,862,861,-1,798,799,863,862,-1,799,800,864,863,-1,800,801,865,864,-1,801,802,866,865,-1,802,803,867,866,-1,803,804,868,867,-1,804,805,869,868,-1,805,806,870,869,-1,806,807,871,870,-1,807,808,872,871,-1,808,809,873,872,-1,809,810,874,873,-1,810,811,875,874,-1,811,812,876,875,-1,812,813,877,876,-1,813,814,878,877,-1,814,815,879,878,-1,815,816,880,879,-1,816,817,881,880,-1,817,818,882,881,-1,818,819,883,882,-1,819,820,884,883,-1,820,821,885,884,-1,821,822,886,885,-1,822,823,887,886,-1,823,824,888,887,-1,824,825,889,888,-1,825,826,890,889,-1,826,827,891,890,-1,827,828,892,891,-1,828,829,893,892,-1,829,830,894,893,-1,830,831,895,894,-1,831,768,832,895,-1,832,833,897,896,-1,833,834,898,897,-1,834,835,899,898,-1,835,836,900,899,-1,836,837,901,900,-1,837,838,902,901,-1,838,839,903,902,-1,839,840,904,903,-1,840,841,905,904,-1,841,842,906,905,-1,842,843,907,906,-1,843,844,908,907,-1,844,845,909,908,-1,845,846,910,909,-1,846,847,911,910,-1,847,848,912,911,-1,848,849,913,912,-1,849,850,914,913,-1,850,851,915,914,-1,851,852,916,915,-1,852,853,917,916,-1,853,854,918,917,-1,854,855,919,918,-1,855,856,920,919,-1,856,857,921,920,-1,857,858,922,921,-1,858,859,923,922,-1,859,860,924,923,-1,860,861,925,924,-1,861,862,926,925,-1,862,863,927,926,-1,863,864,928,927,-1,864,865,929,928,-1,865,866,930,929,-1,866,867,931,930,-1,867,868,932,931,-1,868,869,933,932,-1,869,870,934,933,-1,870,871,935,934,-1,871,872,936,935,-1,872,873,937,936,-1,873,874,938,937,-1,874,875,939,938,-1,875,876,940,939,-1,876,877,941,940,-1,877,878,942,941,-1,878,879,943,942,-1,879,880,944,943,-1,880,881,945,944,-1,881,882,946,945,-1,882,883,947,946,-1,883,884,948,947,-1,884,885,949,948,-1,885,886,950,949,-1,886,887,951,950,-1,887,888,952,951,-1,888,889,953,952,-1,889,890,954,953,-1,890,891,955,954,-1,891,892,956,955,-1,892,893,957,956,-1,893,894,958,957,-1,894,895,959,958,-1,895,832,896,959,-1,896,897,961,960,-1,897,898,962,961,-1,898,899,963,962,-1,899,900,964,963,-1,900,901,965,964,-1,901,902,966,965,-1,902,903,967,966,-1,903,904,968,967,-1,904,905,969,968,-1,905,906,970,969,-1,906,907,971,970,-1,907,908,972,971,-1,908,909,973,972,-1,909,910,974,973,-1,910,911,975,974,-1,911,912,976,975,-1,912,913,977,976,-1,913,914,978,977,-1,914,915,979,978,-1,915,916,980,979,-1,916,917,981,980,-1,917,918,982,981,-1,918,919,983,982,-1,919,920,984,983,-1,920,921,985,984,-1,921,922,986,985,-1,922,923,987,986,-1,923,924,988,987,-1,924,925,989,988,-1,925,926,990,989,-1,926,927,991,990,-1,927,928,992,991,-1,928,929,993,992,-1,929,930,994,993,-1,930,931,995,994,-1,931,932,996,995,-1,932,933,997,996,-1,933,934,998,997,-1,934,935,999,998,-1,935,936,1000,999,-1,936,937,1001,1000,-1,937,938,1002,1001,-1,938,939,1003,1002,-1,939,940,1004,1003,-1,940,941,1005,1004,-1,941,942,1006,1005,-1,942,943,1007,1006,-1,943,944,1008,1007,-1,944,945,1009,1008,-1,945,946,1010,1009,-1,946,947,1011,1010,-1,947,948,1012,1011,-1,948,949,1013,1012,-1,949,950,1014,1013,-1,950,951,1015,1014,-1,951,952,1016,1015,-1,952,953,1017,1016,-1,953,954,1018,1017,-1,954,955,1019,1018,-1,955,956,1020,1019,-1,956,957,1021,1020,-1,957,958,1022,1021,-1,958,959,1023,1022,-1,959,896,960,1023,-1,960,961,1025,1024,-1,961,962,1026,1025,-1,962,963,1027,1026,-1,963,964,1028,1027,-1,964,965,1029,1028,-1,965,966,1030,1029,-1,966,967,1031,1030,-1,967,968,1032,1031,-1,968,969,1033,1032,-1,969,970,1034,1033,-1,970,971,1035,1034,-1,971,972,1036,1035,-1,972,973,1037,1036,-1,973,974,1038,1037,-1,974,975,1039,1038,-1,975,976,1040,1039,-1,976,977,1041,1040,-1,977,978,1042,1041,-1,978,979,1043,1042,-1,979,980,1044,1043,-1,980,981,1045,1044,-1,981,982,1046,1045,-1,982,983,1047,1046,-1,983,984,1048,1047,-1,984,985,1049,1048,-1,985,986,1050,1049,-1,986,987,1051,1050,-1,987,988,1052,1051,-1,988,989,1053,1052,-1,989,990,1054,1053,-1,990,991,1055,1054,-1,991,992,1056,1055,-1,992,993,1057,1056,-1,993,994,1058,1057,-1,994,995,1059,1058,-1,995,996,1060,1059,-1,996,997,1061,1060,-1,997,998,1062,1061,-1,998,999,1063,1062,-1,999,1000,1064,1063,-1,1000,1001,1065,1064,-1,1001,1002,1066,1065,-1,1002,1003,1067,1066,-1,1003,1004,1068,1067,-1,1004,1005,1069,1068,-1,1005,1006,1070,1069,-1,1006,1007,1071,1070,-1,1007,1008,1072,1071,-1,1008,1009,1073,1072,-1,1009,1010,1074,1073,-1,1010,1011,1075,1074,-1,1011,1012,1076,1075,-1,1012,1013,1077,1076,-1,1013,1014,1078,1077,-1,1014,1015,1079,1078,-1,1015,1016,1080,1079,-1,1016,1017,1081,1080,-1,1017,1018,1082,1081,-1,1018,1019,1083,1082,-1,1019,1020,1084,1083,-1,1020,1021,1085,1084,-1,1021,1022,1086,1085,-1,1022,1023,1087,1086,-1,1023,960,1024,1087,-1,1024,1025,1089,1088,-1,1025,1026,1090,1089,-1,1026,1027,1091,1090,-1,1027,1028,1092,1091,-1,1028,1029,1093,1092,-1,1029,1030,1094,1093,-1,1030,1031,1095,1094,-1,1031,1032,1096,1095,-1,1032,1033,1097,1096,-1,1033,1034,1098,1097,-1,1034,1035,1099,1098,-1,1035,1036,1100,1099,-1,1036,1037,1101,1100,-1,1037,1038,1102,1101,-1,1038,1039,1103,1102,-1,1039,1040,1104,1103,-1,1040,1041,1105,1104,-1,1041,1042,1106,1105,-1,1042,1043,1107,1106,-1,1043,1044,1108,1107,-1,1044,1045,1109,1108,-1,1045,1046,1110,1109,-1,1046,1047,1111,1110,-1,1047,1048,1112,1111,-1,1048,1049,1113,1112,-1,1049,1050,1114,1113,-1,1050,1051,1115,1114,-1,1051,1052,1116,1115,-1,1052,1053,1117,1116,-1,1053,1054,1118,1117,-1,1054,1055,1119,1118,-1,1055,1056,1120,1119,-1,1056,1057,1121,1120,-1,1057,1058,1122,1121,-1,1058,1059,1123,1122,-1,1059,1060,1124,1123,-1,1060,1061,1125,1124,-1,1061,1062,1126,1125,-1,1062,1063,1127,1126,-1,1063,1064,1128,1127,-1,1064,1065,1129,1128,-1,1065,1066,1130,1129,-1,1066,1067,1131,1130,-1,1067,1068,1132,1131,-1,1068,1069,1133,1132,-1,1069,1070,1134,1133,-1,1070,1071,1135,1134,-1,1071,1072,1136,1135,-1,1072,1073,1137,1136,-1,1073,1074,1138,1137,-1,1074,1075,1139,1138,-1,1075,1076,1140,1139,-1,1076,1077,1141,1140,-1,1077,1078,1142,1141,-1,1078,1079,1143,1142,-1,1079,1080,1144,1143,-1,1080,1081,1145,1144,-1,1081,1082,1146,1145,-1,1082,1083,1147,1146,-1,1083,1084,1148,1147,-1,1084,1085,1149,1148,-1,1085,1086,1150,1149,-1,1086,1087,1151,1150,-1,1087,1024,1088,1151,-1,1088,1089,1153,1152,-1,1089,1090,1154,1153,-1,1090,1091,1155,1154,-1,1091,1092,1156,1155,-1,1092,1093,1157,1156,-1,1093,1094,1158,1157,-1,1094,1095,1159,1158,-1,1095,1096,1160,1159,-1,1096,1097,1161,1160,-1,1097,1098,1162,1161,-1,1098,1099,1163,1162,-1,1099,1100,1164,1163,-1,1100,1101,1165,1164,-1,1101,1102,1166,1165,-1,1102,1103,1167,1166,-1,1103,1104,1168,1167,-1,1104,1105,1169,1168,-1,1105,1106,1170,1169,-1,1106,1107,1171,1170,-1,1107,1108,1172,1171,-1,1108,1109,1173,1172,-1,1109,1110,1174,1173,-1,1110,1111,1175,1174,-1,1111,1112,1176,1175,-1,1112,1113,1177,1176,-1,1113,1114,1178,1177,-1,1114,1115,1179,1178,-1,1115,1116,1180,1179,-1,1116,1117,1181,1180,-1,1117,1118,1182,1181,-1,1118,1119,1183,1182,-1,1119,1120,1184,1183,-1,1120,1121,1185,1184,-1,1121,1122,1186,1185,-1,1122,1123,1187,1186,-1,1123,1124,1188,1187,-1,1124,1125,1189,1188,-1,1125,1126,1190,1189,-1,1126,1127,1191,1190,-1,1127,1128,1192,1191,-1,1128,1129,1193,1192,-1,1129,1130,1194,1193,-1,1130,1131,1195,1194,-1,1131,1132,1196,1195,-1,1132,1133,1197,1196,-1,1133,1134,1198,1197,-1,1134,1135,1199,1198,-1,1135,1136,1200,1199,-1,1136,1137,1201,1200,-1,1137,1138,1202,1201,-1,1138,1139,1203,1202,-1,1139,1140,1204,1203,-1,1140,1141,1205,1204,-1,1141,1142,1206,1205,-1,1142,1143,1207,1206,-1,1143,1144,1208,1207,-1,1144,1145,1209,1208,-1,1145,1146,1210,1209,-1,1146,1147,1211,1210,-1,1147,1148,1212,1211,-1,1148,1149,1213,1212,-1,1149,1150,1214,1213,-1,1150,1151,1215,1214,-1,1151,1088,1152,1215,-1,1152,1153,1217,1216,-1,1153,1154,1218,1217,-1,1154,1155,1219,1218,-1,1155,1156,1220,1219,-1,1156,1157,1221,1220,-1,1157,1158,1222,1221,-1,1158,1159,1223,1222,-1,1159,1160,1224,1223,-1,1160,1161,1225,1224,-1,1161,1162,1226,1225,-1,1162,1163,1227,1226,-1,1163,1164,1228,1227,-1,1164,1165,1229,1228,-1,1165,1166,1230,1229,-1,1166,1167,1231,1230,-1,1167,1168,1232,1231,-1,1168,1169,1233,1232,-1,1169,1170,1234,1233,-1,1170,1171,1235,1234,-1,1171,1172,1236,1235,-1,1172,1173,1237,1236,-1,1173,1174,1238,1237,-1,1174,1175,1239,1238,-1,1175,1176,1240,1239,-1,1176,1177,1241,1240,-1,1177,1178,1242,1241,-1,1178,1179,1243,1242,-1,1179,1180,1244,1243,-1,1180,1181,1245,1244,-1,1181,1182,1246,1245,-1,1182,1183,1247,1246,-1,1183,1184,1248,1247,-1,1184,1185,1249,1248,-1,1185,1186,1250,1249,-1,1186,1187,1251,1250,-1,1187,1188,1252,1251,-1,1188,1189,1253,1252,-1,1189,1190,1254,1253,-1,1190,1191,1255,1254,-1,1191,1192,1256,1255,-1,1192,1193,1257,1256,-1,1193,1194,1258,1257,-1,1194,1195,1259,1258,-1,1195,1196,1260,1259,-1,1196,1197,1261,1260,-1,1197,1198,1262,1261,-1,1198,1199,1263,1262,-1,1199,1200,1264,1263,-1,1200,1201,1265,1264,-1,1201,1202,1266,1265,-1,1202,1203,1267,1266,-1,1203,1204,1268,1267,-1,1204,1205,1269,1268,-1,1205,1206,1270,1269,-1,1206,1207,1271,1270,-1,1207,1208,1272,1271,-1,1208,1209,1273,1272,-1,1209,1210,1274,1273,-1,1210,1211,1275,1274,-1,1211,1212,1276,1275,-1,1212,1213,1277,1276,-1,1213,1214,1278,1277,-1,1214,1215,1279,1278,-1,1215,1152,1216,1279,-1,1216,1217,1281,1280,-1,1217,1218,1282,1281,-1,1218,1219,1283,1282,-1,1219,1220,1284,1283,-1,1220,1221,1285,1284,-1,1221,1222,1286,1285,-1,1222,1223,1287,1286,-1,1223,1224,1288,1287,-1,1224,1225,1289,1288,-1,1225,1226,1290,1289,-1,1226,1227,1291,1290,-1,1227,1228,1292,1291,-1,1228,1229,1293,1292,-1,1229,1230,1294,1293,-1,1230,1231,1295,1294,-1,1231,1232,1296,1295,-1,1232,1233,1297,1296,-1,1233,1234,1298,1297,-1,1234,1235,1299,1298,-1,1235,1236,1300,1299,-1,1236,1237,1301,1300,-1,1237,1238,1302,1301,-1,1238,1239,1303,1302,-1,1239,1240,1304,1303,-1,1240,1241,1305,1304,-1,1241,1242,1306,1305,-1,1242,1243,1307,1306,-1,1243,1244,1308,1307,-1,1244,1245,1309,1308,-1,1245,1246,1310,1309,-1,1246,1247,1311,1310,-1,1247,1248,1312,1311,-1,1248,1249,1313,1312,-1,1249,1250,1314,1313,-1,1250,1251,1315,1314,-1,1251,1252,1316,1315,-1,1252,1253,1317,1316,-1,1253,1254,1318,1317,-1,1254,1255,1319,1318,-1,1255,1256,1320,1319,-1,1256,1257,1321,1320,-1,1257,1258,1322,1321,-1,1258,1259,1323,1322,-1,1259,1260,1324,1323,-1,1260,1261,1325,1324,-1,1261,1262,1326,1325,-1,1262,1263,1327,1326,-1,1263,1264,1328,1327,-1,1264,1265,1329,1328,-1,1265,1266,1330,1329,-1,1266,1267,1331,1330,-1,1267,1268,1332,1331,-1,1268,1269,1333,1332,-1,1269,1270,1334,1333,-1,1270,1271,1335,1334,-1,1271,1272,1336,1335,-1,1272,1273,1337,1336,-1,1273,1274,1338,1337,-1,1274,1275,1339,1338,-1,1275,1276,1340,1339,-1,1276,1277,1341,1340,-1,1277,1278,1342,1341,-1,1278,1279,1343,1342,-1,1279,1216,1280,1343,-1,1280,1281,1345,1344,-1,1281,1282,1346,1345,-1,1282,1283,1347,1346,-1,1283,1284,1348,1347,-1,1284,1285,1349,1348,-1,1285,1286,1350,1349,-1,1286,1287,1351,1350,-1,1287,1288,1352,1351,-1,1288,1289,1353,1352,-1,1289,1290,1354,1353,-1,1290,1291,1355,1354,-1,1291,1292,1356,1355,-1,1292,1293,1357,1356,-1,1293,1294,1358,1357,-1,1294,1295,1359,1358,-1,1295,1296,1360,1359,-1,1296,1297,1361,1360,-1,1297,1298,1362,1361,-1,1298,1299,1363,1362,-1,1299,1300,1364,1363,-1,1300,1301,1365,1364,-1,1301,1302,1366,1365,-1,1302,1303,1367,1366,-1,1303,1304,1368,1367,-1,1304,1305,1369,1368,-1,1305,1306,1370,1369,-1,1306,1307,1371,1370,-1,1307,1308,1372,1371,-1,1308,1309,1373,1372,-1,1309,1310,1374,1373,-1,1310,1311,1375,1374,-1,1311,1312,1376,1375,-1,1312,1313,1377,1376,-1,1313,1314,1378,1377,-1,1314,1315,1379,1378,-1,1315,1316,1380,1379,-1,1316,1317,1381,1380,-1,1317,1318,1382,1381,-1,1318,1319,1383,1382,-1,1319,1320,1384,1383,-1,1320,1321,1385,1384,-1,1321,1322,1386,1385,-1,1322,1323,1387,1386,-1,1323,1324,1388,1387,-1,1324,1325,1389,1388,-1,1325,1326,1390,1389,-1,1326,1327,1391,1390,-1,1327,1328,1392,1391,-1,1328,1329,1393,1392,-1,1329,1330,1394,1393,-1,1330,1331,1395,1394,-1,1331,1332,1396,1395,-1,1332,1333,1397,1396,-1,1333,1334,1398,1397,-1,1334,1335,1399,1398,-1,1335,1336,1400,1399,-1,1336,1337,1401,1400,-1,1337,1338,1402,1401,-1,1338,1339,1403,1402,-1,1339,1340,1404,1403,-1,1340,1341,1405,1404,-1,1341,1342,1406,1405,-1,1342,1343,1407,1406,-1,1343,1280,1344,1407,-1,1344,1345,1409,1408,-1,1345,1346,1410,1409,-1,1346,1347,1411,1410,-1,1347,1348,1412,1411,-1,1348,1349,1413,1412,-1,1349,1350,1414,1413,-1,1350,1351,1415,1414,-1,1351,1352,1416,1415,-1,1352,1353,1417,1416,-1,1353,1354,1418,1417,-1,1354,1355,1419,1418,-1,1355,1356,1420,1419,-1,1356,1357,1421,1420,-1,1357,1358,1422,1421,-1,1358,1359,1423,1422,-1,1359,1360,1424,1423,-1,1360,1361,1425,1424,-1,1361,1362,1426,1425,-1,1362,1363,1427,1426,-1,1363,1364,1428,1427,-1,1364,1365,1429,1428,-1,1365,1366,1430,1429,-1,1366,1367,1431,1430,-1,1367,1368,1432,1431,-1,1368,1369,1433,1432,-1,1369,1370,1434,1433,-1,1370,1371,1435,1434,-1,1371,1372,1436,1435,-1,1372,1373,1437,1436,-1,1373,1374,1438,1437,-1,1374,1375,1439,1438,-1,1375,1376,1440,1439,-1,1376,1377,1441,1440,-1,1377,1378,1442,1441,-1,1378,1379,1443,1442,-1,1379,1380,1444,1443,-1,1380,1381,1445,1444,-1,1381,1382,1446,1445,-1,1382,1383,1447,1446,-1,1383,1384,1448,1447,-1,1384,1385,1449,1448,-1,1385,1386,1450,1449,-1,1386,1387,1451,1450,-1,1387,1388,1452,1451,-1,1388,1389,1453,1452,-1,1389,1390,1454,1453,-1,1390,1391,1455,1454,-1,1391,1392,1456,1455,-1,1392,1393,1457,1456,-1,1393,1394,1458,1457,-1,1394,1395,1459,1458,-1,1395,1396,1460,1459,-1,1396,1397,1461,1460,-1,1397,1398,1462,1461,-1,1398,1399,1463,1462,-1,1399,1400,1464,1463,-1,1400,1401,1465,1464,-1,1401,1402,1466,1465,-1,1402,1403,1467,1466,-1,1403,1404,1468,1467,-1,1404,1405,1469,1468,-1,1405,1406,1470,1469,-1,1406,1407,1471,1470,-1,1407,1344,1408,1471,-1,1408,1409,1473,1472,-1,1409,1410,1474,1473,-1,1410,1411,1475,1474,-1,1411,1412,1476,1475,-1,1412,1413,1477,1476,-1,1413,1414,1478,1477,-1,1414,1415,1479,1478,-1,1415,1416,1480,1479,-1,1416,1417,1481,1480,-1,1417,1418,1482,1481,-1,1418,1419,1483,1482,-1,1419,1420,1484,1483,-1,1420,1421,1485,1484,-1,1421,1422,1486,1485,-1,1422,1423,1487,1486,-1,1423,1424,1488,1487,-1,1424,1425,1489,1488,-1,1425,1426,1490,1489,-1,1426,1427,1491,1490,-1,1427,1428,1492,1491,-1,1428,1429,1493,1492,-1,1429,1430,1494,1493,-1,1430,1431,1495,1494,-1,1431,1432,1496,1495,-1,1432,1433,1497,1496,-1,1433,1434,1498,1497,-1,1434,1435,1499,1498,-1,1435,1436,1500,1499,-1,1436,1437,1501,1500,-1,1437,1438,1502,1501,-1,1438,1439,1503,1502,-1,1439,1440,1504,1503,-1,1440,1441,1505,1504,-1,1441,1442,1506,1505,-1,1442,1443,1507,1506,-1,1443,1444,1508,1507,-1,1444,1445,1509,1508,-1,1445,1446,1510,1509,-1,1446,1447,1511,1510,-1,1447,1448,1512,1511,-1,1448,1449,1513,1512,-1,1449,1450,1514,1513,-1,1450,1451,1515,1514,-1,1451,1452,1516,1515,-1,1452,1453,1517,1516,-1,1453,1454,1518,1517,-1,1454,1455,1519,1518,-1,1455,1456,1520,1519,-1,1456,1457,1521,1520,-1,1457,1458,1522,1521,-1,1458,1459,1523,1522,-1,1459,1460,1524,1523,-1,1460,1461,1525,1524,-1,1461,1462,1526,1525,-1,1462,1463,1527,1526,-1,1463,1464,1528,1527,-1,1464,1465,1529,1528,-1,1465,1466,1530,1529,-1,1466,1467,1531,1530,-1,1467,1468,1532,1531,-1,1468,1469,1533,1532,-1,1469,1470,1534,1533,-1,1470,1471,1535,1534,-1,1471,1408,1472,1535,-1,1472,1473,1537,1536,-1,1473,1474,1538,1537,-1,1474,1475,1539,1538,-1,1475,1476,1540,1539,-1,1476,1477,1541,1540,-1,1477,1478,1542,1541,-1,1478,1479,1543,1542,-1,1479,1480,1544,1543,-1,1480,1481,1545,1544,-1,1481,1482,1546,1545,-1,1482,1483,1547,1546,-1,1483,1484,1548,1547,-1,1484,1485,1549,1548,-1,1485,1486,1550,1549,-1,1486,1487,1551,1550,-1,1487,1488,1552,1551,-1,1488,1489,1553,1552,-1,1489,1490,1554,1553,-1,1490,1491,1555,1554,-1,1491,1492,1556,1555,-1,1492,1493,1557,1556,-1,1493,1494,1558,1557,-1,1494,1495,1559,1558,-1,1495,1496,1560,1559,-1,1496,1497,1561,1560,-1,1497,1498,1562,1561,-1,1498,1499,1563,1562,-1,1499,1500,1564,1563,-1,1500,1501,1565,1564,-1,1501,1502,1566,1565,-1,1502,1503,1567,1566,-1,1503,1504,1568,1567,-1,1504,1505,1569,1568,-1,1505,1506,1570,1569,-1,1506,1507,1571,1570,-1,1507,1508,1572,1571,-1,1508,1509,1573,1572,-1,1509,1510,1574,1573,-1,1510,1511,1575,1574,-1,1511,1512,1576,1575,-1,1512,1513,1577,1576,-1,1513,1514,1578,1577,-1,1514,1515,1579,1578,-1,1515,1516,1580,1579,-1,1516,1517,1581,1580,-1,1517,1518,1582,1581,-1,1518,1519,1583,1582,-1,1519,1520,1584,1583,-1,1520,1521,1585,1584,-1,1521,1522,1586,1585,-1,1522,1523,1587,1586,-1,1523,1524,1588,1587,-1,1524,1525,1589,1588,-1,1525,1526,1590,1589,-1,1526,1527,1591,1590,-1,1527,1528,1592,1591,-1,1528,1529,1593,1592,-1,1529,1530,1594,1593,-1,1530,1531,1595,1594,-1,1531,1532,1596,1595,-1,1532,1533,1597,1596,-1,1533,1534,1598,1597,-1,1534,1535,1599,1598,-1,1535,1472,1536,1599,-1,1536,1537,1601,1600,-1,1537,1538,1602,1601,-1,1538,1539,1603,1602,-1,1539,1540,1604,1603,-1,1540,1541,1605,1604,-1,1541,1542,1606,1605,-1,1542,1543,1607,1606,-1,1543,1544,1608,1607,-1,1544,1545,1609,1608,-1,1545,1546,1610,1609,-1,1546,1547,1611,1610,-1,1547,1548,1612,1611,-1,1548,1549,1613,1612,-1,1549,1550,1614,1613,-1,1550,1551,1615,1614,-1,1551,1552,1616,1615,-1,1552,1553,1617,1616,-1,1553,1554,1618,1617,-1,1554,1555,1619,1618,-1,1555,1556,1620,1619,-1,1556,1557,1621,1620,-1,1557,1558,1622,1621,-1,1558,1559,1623,1622,-1,1559,1560,1624,1623,-1,1560,1561,1625,1624,-1,1561,1562,1626,1625,-1,1562,1563,1627,1626,-1,1563,1564,1628,1627,-1,1564,1565,1629,1628,-1,1565,1566,1630,1629,-1,1566,1567,1631,1630,-1,1567,1568,1632,1631,-1,1568,1569,1633,1632,-1,1569,1570,1634,1633,-1,1570,1571,1635,1634,-1,1571,1572,1636,1635,-1,1572,1573,1637,1636,-1,1573,1574,1638,1637,-1,1574,1575,1639,1638,-1,1575,1576,1640,1639,-1,1576,1577,1641,1640,-1,1577,1578,1642,1641,-1,1578,1579,1643,1642,-1,1579,1580,1644,1643,-1,1580,1581,1645,1644,-1,1581,1582,1646,1645,-1,1582,1583,1647,1646,-1,1583,1584,1648,1647,-1,1584,1585,1649,1648,-1,1585,1586,1650,1649,-1,1586,1587,1651,1650,-1,1587,1588,1652,1651,-1,1588,1589,1653,1652,-1,1589,1590,1654,1653,-1,1590,1591,1655,1654,-1,1591,1592,1656,1655,-1,1592,1593,1657,1656,-1,1593,1594,1658,1657,-1,1594,1595,1659,1658,-1,1595,1596,1660,1659,-1,1596,1597,1661,1660,-1,1597,1598,1662,1661,-1,1598,1599,1663,1662,-1,1599,1536,1600,1663,-1,1600,1601,1665,1664,-1,1601,1602,1666,1665,-1,1602,1603,1667,1666,-1,1603,1604,1668,1667,-1,1604,1605,1669,1668,-1,1605,1606,1670,1669,-1,1606,1607,1671,1670,-1,1607,1608,1672,1671,-1,1608,1609,1673,1672,-1,1609,1610,1674,1673,-1,1610,1611,1675,1674,-1,1611,1612,1676,1675,-1,1612,1613,1677,1676,-1,1613,1614,1678,1677,-1,1614,1615,1679,1678,-1,1615,1616,1680,1679,-1,1616,1617,1681,1680,-1,1617,1618,1682,1681,-1,1618,1619,1683,1682,-1,1619,1620,1684,1683,-1,1620,1621,1685,1684,-1,1621,1622,1686,1685,-1,1622,1623,1687,1686,-1,1623,1624,1688,1687,-1,1624,1625,1689,1688,-1,1625,1626,1690,1689,-1,1626,1627,1691,1690,-1,1627,1628,1692,1691,-1,1628,1629,1693,1692,-1,1629,1630,1694,1693,-1,1630,1631,1695,1694,-1,1631,1632,1696,1695,-1,1632,1633,1697,1696,-1,1633,1634,1698,1697,-1,1634,1635,1699,1698,-1,1635,1636,1700,1699,-1,1636,1637,1701,1700,-1,1637,1638,1702,1701,-1,1638,1639,1703,1702,-1,1639,1640,1704,1703,-1,1640,1641,1705,1704,-1,1641,1642,1706,1705,-1,1642,1643,1707,1706,-1,1643,1644,1708,1707,-1,1644,1645,1709,1708,-1,1645,1646,1710,1709,-1,1646,1647,1711,1710,-1,1647,1648,1712,1711,-1,1648,1649,1713,1712,-1,1649,1650,1714,1713,-1,1650,1651,1715,1714,-1,1651,1652,1716,1715,-1,1652,1653,1717,1716,-1,1653,1654,1718,1717,-1,1654,1655,1719,1718,-1,1655,1656,1720,1719,-1,1656,1657,1721,1720,-1,1657,1658,1722,1721,-1,1658,1659,1723,1722,-1,1659,1660,1724,1723,-1,1660,1661,1725,1724,-1,1661,1662,1726,1725,-1,1662,1663,1727,1726,-1,1663,1600,1664,1727,-1,1664,1665,1729,1728,-1,1665,1666,1730,1729,-1,1666,1667,1731,1730,-1,1667,1668,1732,1731,-1,1668,1669,1733,1732,-1,1669,1670,1734,1733,-1,1670,1671,1735,1734,-1,1671,1672,1736,1735,-1,1672,1673,1737,1736,-1,1673,1674,1738,1737,-1,1674,1675,1739,1738,-1,1675,1676,1740,1739,-1,1676,1677,1741,1740,-1,1677,1678,1742,1741,-1,1678,1679,1743,1742,-1,1679,1680,1744,1743,-1,1680,1681,1745,1744,-1,1681,1682,1746,1745,-1,1682,1683,1747,1746,-1,1683,1684,1748,1747,-1,1684,1685,1749,1748,-1,1685,1686,1750,1749,-1,1686,1687,1751,1750,-1,1687,1688,1752,1751,-1,1688,1689,1753,1752,-1,1689,1690,1754,1753,-1,1690,1691,1755,1754,-1,1691,1692,1756,1755,-1,1692,1693,1757,1756,-1,1693,1694,1758,1757,-1,1694,1695,1759,1758,-1,1695,1696,1760,1759,-1,1696,1697,1761,1760,-1,1697,1698,1762,1761,-1,1698,1699,1763,1762,-1,1699,1700,1764,1763,-1,1700,1701,1765,1764,-1,1701,1702,1766,1765,-1,1702,1703,1767,1766,-1,1703,1704,1768,1767,-1,1704,1705,1769,1768,-1,1705,1706,1770,1769,-1,1706,1707,1771,1770,-1,1707,1708,1772,1771,-1,1708,1709,1773,1772,-1,1709,1710,1774,1773,-1,1710,1711,1775,1774,-1,1711,1712,1776,1775,-1,1712,1713,1777,1776,-1,1713,1714,1778,1777,-1,1714,1715,1779,1778,-1,1715,1716,1780,1779,-1,1716,1717,1781,1780,-1,1717,1718,1782,1781,-1,1718,1719,1783,1782,-1,1719,1720,1784,1783,-1,1720,1721,1785,1784,-1,1721,1722,1786,1785,-1,1722,1723,1787,1786,-1,1723,1724,1788,1787,-1,1724,1725,1789,1788,-1,1725,1726,1790,1789,-1,1726,1727,1791,1790,-1,1727,1664,1728,1791,-1,1728,1729,1793,1792,-1,1729,1730,1794,1793,-1,1730,1731,1795,1794,-1,1731,1732,1796,1795,-1,1732,1733,1797,1796,-1,1733,1734,1798,1797,-1,1734,1735,1799,1798,-1,1735,1736,1800,1799,-1,1736,1737,1801,1800,-1,1737,1738,1802,1801,-1,1738,1739,1803,1802,-1,1739,1740,1804,1803,-1,1740,1741,1805,1804,-1,1741,1742,1806,1805,-1,1742,1743,1807,1806,-1,1743,1744,1808,1807,-1,1744,1745,1809,1808,-1,1745,1746,1810,1809,-1,1746,1747,1811,1810,-1,1747,1748,1812,1811,-1,1748,1749,1813,1812,-1,1749,1750,1814,1813,-1,1750,1751,1815,1814,-1,1751,1752,1816,1815,-1,1752,1753,1817,1816,-1,1753,1754,1818,1817,-1,1754,1755,1819,1818,-1,1755,1756,1820,1819,-1,1756,1757,1821,1820,-1,1757,1758,1822,1821,-1,1758,1759,1823,1822,-1,1759,1760,1824,1823,-1,1760,1761,1825,1824,-1,1761,1762,1826,1825,-1,1762,1763,1827,1826,-1,1763,1764,1828,1827,-1,1764,1765,1829,1828,-1,1765,1766,1830,1829,-1,1766,1767,1831,1830,-1,1767,1768,1832,1831,-1,1768,1769,1833,1832,-1,1769,1770,1834,1833,-1,1770,1771,1835,1834,-1,1771,1772,1836,1835,-1,1772,1773,1837,1836,-1,1773,1774,1838,1837,-1,1774,1775,1839,1838,-1,1775,1776,1840,1839,-1,1776,1777,1841,1840,-1,1777,1778,1842,1841,-1,1778,1779,1843,1842,-1,1779,1780,1844,1843,-1,1780,1781,1845,1844,-1,1781,1782,1846,1845,-1,1782,1783,1847,1846,-1,1783,1784,1848,1847,-1,1784,1785,1849,1848,-1,1785,1786,1850,1849,-1,1786,1787,1851,1850,-1,1787,1788,1852,1851,-1,1788,1789,1853,1852,-1,1789,1790,1854,1853,-1,1790,1791,1855,1854,-1,1791,1728,1792,1855,-1,1792,1793,1857,1856,-1,1793,1794,1858,1857,-1,1794,1795,1859,1858,-1,1795,1796,1860,1859,-1,1796,1797,1861,1860,-1,1797,1798,1862,1861,-1,1798,1799,1863,1862,-1,1799,1800,1864,1863,-1,1800,1801,1865,1864,-1,1801,1802,1866,1865,-1,1802,1803,1867,1866,-1,1803,1804,1868,1867,-1,1804,1805,1869,1868,-1,1805,1806,1870,1869,-1,1806,1807,1871,1870,-1,1807,1808,1872,1871,-1,1808,1809,1873,1872,-1,1809,1810,1874,1873,-1,1810,1811,1875,1874,-1,1811,1812,1876,1875,-1,1812,1813,1877,1876,-1,1813,1814,1878,1877,-1,1814,1815,1879,1878,-1,1815,1816,1880,1879,-1,1816,1817,1881,1880,-1,1817,1818,1882,1881,-1,1818,1819,1883,1882,-1,1819,1820,1884,1883,-1,1820,1821,1885,1884,-1,1821,1822,1886,1885,-1,1822,1823,1887,1886,-1,1823,1824,1888,1887,-1,1824,1825,1889,1888,-1,1825,1826,1890,1889,-1,1826,1827,1891,1890,-1,1827,1828,1892,1891,-1,1828,1829,1893,1892,-1,1829,1830,1894,1893,-1,1830,1831,1895,1894,-1,1831,1832,1896,1895,-1,1832,1833,1897,1896,-1,1833,1834,1898,1897,-1,1834,1835,1899,1898,-1,1835,1836,1900,1899,-1,1836,1837,1901,1900,-1,1837,1838,1902,1901,-1,1838,1839,1903,1902,-1,1839,1840,1904,1903,-1,1840,1841,1905,1904,-1,1841,1842,1906,1905,-1,1842,1843,1907,1906,-1,1843,1844,1908,1907,-1,1844,1845,1909,1908,-1,1845,1846,1910,1909,-1,1846,1847,1911,1910,-1,1847,1848,1912,1911,-1,1848,1849,1913,1912,-1,1849,1850,1914,1913,-1,1850,1851,1915,1914,-1,1851,1852,1916,1915,-1,1852,1853,1917,1916,-1,1853,1854,1918,1917,-1,1854,1855,1919,1918,-1,1855,1792,1856,1919,-1,1856,1857,1921,1920,-1,1857,1858,1922,1921,-1,1858,1859,1923,1922,-1,1859,1860,1924,1923,-1,1860,1861,1925,1924,-1,1861,1862,1926,1925,-1,1862,1863,1927,1926,-1,1863,1864,1928,1927,-1,1864,1865,1929,1928,-1,1865,1866,1930,1929,-1,1866,1867,1931,1930,-1,1867,1868,1932,1931,-1,1868,1869,1933,1932,-1,1869,1870,1934,1933,-1,1870,1871,1935,1934,-1,1871,1872,1936,1935,-1,1872,1873,1937,1936,-1,1873,1874,1938,1937,-1,1874,1875,1939,1938,-1,1875,1876,1940,1939,-1,1876,1877,1941,1940,-1,1877,1878,1942,1941,-1,1878,1879,1943,1942,-1,1879,1880,1944,1943,-1,1880,1881,1945,1944,-1,1881,1882,1946,1945,-1,1882,1883,1947,1946,-1,1883,1884,1948,1947,-1,1884,1885,1949,1948,-1,1885,1886,1950,1949,-1,1886,1887,1951,1950,-1,1887,1888,1952,1951,-1,1888,1889,1953,1952,-1,1889,1890,1954,1953,-1,1890,1891,1955,1954,-1,1891,1892,1956,1955,-1,1892,1893,1957,1956,-1,1893,1894,1958,1957,-1,1894,1895,1959,1958,-1,1895,1896,1960,1959,-1,1896,1897,1961,1960,-1,1897,1898,1962,1961,-1,1898,1899,1963,1962,-1,1899,1900,1964,1963,-1,1900,1901,1965,1964,-1,1901,1902,1966,1965,-1,1902,1903,1967,1966,-1,1903,1904,1968,1967,-1,1904,1905,1969,1968,-1,1905,1906,1970,1969,-1,1906,1907,1971,1970,-1,1907,1908,1972,1971,-1,1908,1909,1973,1972,-1,1909,1910,1974,1973,-1,1910,1911,1975,1974,-1,1911,1912,1976,1975,-1,1912,1913,1977,1976,-1,1913,1914,1978,1977,-1,1914,1915,1979,1978,-1,1915,1916,1980,1979,-1,1916,1917,1981,1980,-1,1917,1918,1982,1981,-1,1918,1919,1983,1982,-1,1919,1856,1920,1983,-1,1920,1921,1985,1984,-1,1921,1922,1986,1985,-1,1922,1923,1987,1986,-1,1923,1924,1988,1987,-1,1924,1925,1989,1988,-1,1925,1926,1990,1989,-1,1926,1927,1991,1990,-1,1927,1928,1992,1991,-1,1928,1929,1993,1992,-1,1929,1930,1994,1993,-1,1930,1931,1995,1994,-1,1931,1932,1996,1995,-1,1932,1933,1997,1996,-1,1933,1934,1998,1997,-1,1934,1935,1999,1998,-1,1935,1936,2000,1999,-1,1936,1937,2001,2000,-1,1937,1938,2002,2001,-1,1938,1939,2003,2002,-1,1939,1940,2004,2003,-1,1940,1941,2005,2004,-1,1941,1942,2006,2005,-1,1942,1943,2007,2006,-1,1943,1944,2008,2007,-1,1944,1945,2009,2008,-1,1945,1946,2010,2009,-1,1946,1947,2011,2010,-1,1947,1948,2012,2011,-1,1948,1949,2013,2012,-1,1949,1950,2014,2013,-1,1950,1951,2015,2014,-1,1951,1952,2016,2015,-1,1952,1953,2017,2016,-1,1953,1954,2018,2017,-1,1954,1955,2019,2018,-1,1955,1956,2020,2019,-1,1956,1957,2021,2020,-1,1957,1958,2022,2021,-1,1958,1959,2023,2022,-1,1959,1960,2024,2023,-1,1960,1961,2025,2024,-1,1961,1962,2026,2025,-1,1962,1963,2027,2026,-1,1963,1964,2028,2027,-1,1964,1965,2029,2028,-1,1965,1966,2030,2029,-1,1966,1967,2031,2030,-1,1967,1968,2032,2031,-1,1968,1969,2033,2032,-1,1969,1970,2034,2033,-1,1970,1971,2035,2034,-1,1971,1972,2036,2035,-1,1972,1973,2037,2036,-1,1973,1974,2038,2037,-1,1974,1975,2039,2038,-1,1975,1976,2040,2039,-1,1976,1977,2041,2040,-1,1977,1978,2042,2041,-1,1978,1979,2043,2042,-1,1979,1980,2044,2043,-1,1980,1981,2045,2044,-1,1981,1982,2046,2045,-1,1982,1983,2047,2046,-1,1983,1920,1984,2047,-1],creaseAngle=1.571,solid=False,
          coord=Coordinate(point=[(0.0,3.0,0.0),(0.0,3.221066,0.0),(0.0,3.42249,0.0),(0.0,3.586374,0.0),(0.0,3.698155,0.0),(0.0,3.747903,0.0),(0.0,3.731196,0.0),(0.0,3.649519,0.0),(0.0,3.51013,0.0),(0.0,3.325413,0.0),(0.0,3.111782,0.0),(0.0,2.888218,0.0),(0.0,2.674587,0.0),(0.0,2.48987,0.0),(0.0,2.350481,0.0),(0.0,2.268804,0.0),(0.0,2.252097,0.0),(0.0,2.301845,0.0),(0.0,2.413626,0.0),(0.0,2.57751,0.0),(0.0,2.778934,0.0),(0.0,3.0,0.0),(0.0,3.221066,0.0),(0.0,3.42249,0.0),(0.0,3.586374,0.0),(0.0,3.698155,0.0),(0.0,3.747903,0.0),(0.0,3.731196,0.0),(0.0,3.649519,0.0),(0.0,3.51013,0.0),(0.0,3.325413,0.0),(0.0,3.111782,0.0),(0.0,2.888218,0.0),(0.0,2.674587,0.0),(0.0,2.48987,0.0),(0.0,2.350481,0.0),(0.0,2.268804,0.0),(0.0,2.252097,0.0),(0.0,2.301845,0.0),(0.0,2.413626,0.0),(0.0,2.57751,0.0),(0.0,2.778934,0.0),(0.0,3.0,0.0),(0.0,3.221066,0.0),(0.0,3.42249,0.0),(0.0,3.586374,0.0),(0.0,3.698155,0.0),(0.0,3.747903,0.0),(0.0,3.731196,0.0),(0.0,3.649519,0.0),(0.0,3.51013,0.0),(0.0,3.325413,0.0),(0.0,3.111782,0.0),(0.0,2.888218,0.0),(0.0,2.674587,0.0),(0.0,2.48987,0.0),(0.0,2.350481,0.0),(0.0,2.268804,0.0),(0.0,2.252097,0.0),(0.0,2.301845,0.0),(0.0,2.413626,0.0),(0.0,2.57751,0.0),(0.0,2.778934,0.0),(0.0,3.0,0.0),(0.318779,3.134807,0.0),(0.338318,3.343564,0.033854),(0.350894,3.520427,0.070935),(0.354648,3.649679,0.109394),(0.348567,3.719837,0.146933),(0.332637,3.724667,0.181144),(0.307828,3.663739,0.209874),(0.275955,3.542467,0.231554),(0.239398,3.371628,0.245443),(0.200758,3.166399,0.251743),(0.162481,2.945018,0.25157),(0.126518,2.727155,0.246783),(0.094074,2.532167,0.239696),(0.065477,2.377381,0.23272),(0.0402,2.276549,0.227985),(0.017012,2.238632,0.22701),(-0.005747,2.266998,0.230459),(-0.02983,2.359127,0.238038),(-0.056725,2.506832,0.248529),(-0.087347,2.69699,0.259976),(-0.12182,2.912704,0.269982),(-0.159389,3.134807,0.27607),(-0.198477,3.343564,0.276065),(-0.236879,3.520427,0.268416),(-0.272062,3.649679,0.252437),(-0.301532,3.719837,0.228401),(-0.323194,3.724667,0.1975),(-0.33567,3.663739,0.16165),(-0.338509,3.542467,0.123207),(-0.332259,3.371628,0.084603),(-0.318395,3.166399,0.04799),(-0.299107,2.945018,0.014928),(-0.27698,2.727155,-0.013823),(-0.25462,2.532167,-0.038378),(-0.23428,2.377381,-0.059655),(-0.217541,2.276549,-0.079178),(-0.205103,2.238632,-0.098772),(-0.19671,2.266998,-0.120207),(-0.191232,2.359127,-0.144853),(-0.18687,2.506832,-0.17339),(-0.181472,2.69699,-0.205633),(-0.172901,2.912704,-0.24049),(-0.159389,3.134807,-0.27607),(-0.139841,3.343564,-0.309919),(-0.114016,3.520427,-0.339351),(-0.082586,3.649679,-0.361831),(-0.047036,3.719837,-0.375335),(-0.009443,3.724667,-0.378644),(0.027842,3.663739,-0.371524),(0.062554,3.542467,-0.354761),(0.092861,3.371628,-0.330046),(0.117637,3.166399,-0.299733),(0.136626,2.945018,-0.266498),(0.150461,2.727155,-0.23296),(0.160546,2.532167,-0.201319),(0.168803,2.377381,-0.173065),(0.177341,2.276549,-0.148807),(0.18809,2.238632,-0.128238),(0.202457,2.266998,-0.110252),(0.221062,2.359127,-0.093185),(0.243595,2.506832,-0.075139),(0.268819,2.69699,-0.054343),(0.294721,2.912704,-0.029491),(0.318779,3.134807,0.0),(0.663433,3.228302,0.0),(0.698195,3.414423,0.069865),(0.716743,3.558265,0.144893),(0.716189,3.647045,0.220915),(0.695526,3.672876,0.293189),(0.655764,3.633462,0.35711),(0.599773,3.532306,0.408918),(0.531848,3.378396,0.446273),(0.457078,3.185407,0.468619),(0.38061,2.970487,0.47727),(0.306919,2.752733,0.475204),(0.239212,2.551493,0.4666),(0.179038,2.384649,0.456182),(0.126181,2.267024,0.448472),(0.078832,2.209071,0.447079),(0.034031,2.215939,0.454114),(-0.011717,2.287018,0.469848),(-0.061737,2.415992,0.492646),(-0.118503,2.5914,0.519194),(-0.183109,2.797659,0.544995),(-0.254954,3.016439,0.565037),(-0.331716,3.228302,0.57455),(-0.409602,3.414423,0.569722),(-0.483852,3.558265,0.548271),(-0.549413,3.647045,0.50978),(-0.601672,3.672876,0.455749),(-0.637148,3.633462,0.389353),(-0.65402,3.532306,0.314959),(-0.652408,3.378396,0.237457),(-0.634375,3.185407,0.161532),(-0.603632,2.970487,0.090983),(-0.564998,2.752733,0.028198),(-0.523693,2.551493,-0.026136),(-0.484584,2.384649,-0.073039),(-0.451479,2.267024,-0.114961),(-0.426598,2.209071,-0.155269),(-0.41029,2.215939,-0.197585),(-0.401042,2.287018,-0.245071),(-0.395775,2.415992,-0.299788),(-0.390384,2.5914,-0.362223),(-0.380425,2.797659,-0.431074),(-0.361859,3.016439,-0.503315),(-0.331716,3.228302,-0.57455),(-0.288593,3.414423,-0.639587),(-0.232891,3.558265,-0.693164),(-0.166776,3.647045,-0.730696),(-0.093854,3.672876,-0.748937),(-0.018616,3.633462,-0.746463),(0.054247,3.532306,-0.723878),(0.12056,3.378396,-0.68373),(0.177297,3.185407,-0.630151),(0.223023,2.970487,-0.568252),(0.258079,2.752733,-0.503401),(0.284482,2.551493,-0.440464),(0.305546,2.384649,-0.383143),(0.325298,2.267024,-0.333512),(0.347766,2.209071,-0.29181),(0.376258,2.215939,-0.256529),(0.412759,2.287018,-0.224777),(0.457512,2.415992,-0.192857),(0.508887,2.5914,-0.156971),(0.563534,2.797659,-0.113921),(0.616814,3.016439,-0.061722),(0.663433,3.228302,0.0),(1.026352,3.27122,0.0),(1.069629,3.42618,0.107033),(1.085907,3.531047,0.219521),(1.072282,3.576504,0.330755),(1.028819,3.558511,0.433684),(0.958525,3.478667,0.521985),(0.866896,3.344067,0.59104),(0.761103,3.16667,0.638641),(0.648947,2.962239,0.665333),(0.537751,2.748938,0.674318),(0.433345,2.54572,0.67095),(0.339327,2.370643,0.661881),(0.256679,2.239262,0.654007),(0.183826,2.163251,0.653356),(0.117103,2.149364,0.664122),(0.051555,2.198835,0.68796),(-0.018048,2.307268,0.723685),(-0.096168,2.465029,0.767405),(-0.185579,2.658099,0.813074),(-0.28672,2.869324,0.853378),(-0.397442,3.079936,0.880821),(-0.513176,3.27122,0.888847),(-0.627507,3.42618,0.87281),(-0.733064,3.531047,0.830663),(-0.822583,3.576504,0.763246),(-0.889991,3.558511,0.674142),(-0.931315,3.478667,0.569115),(-0.945304,3.344067,0.455234),(-0.933631,3.16667,0.339814),(-0.900669,2.962239,0.229338),(-0.852852,2.748938,0.128547),(-0.797732,2.54572,0.039813),(-0.742869,2.370643,-0.037075),(-0.694726,2.239262,-0.104713),(-0.657736,2.163251,-0.16748),(-0.633698,2.149364,-0.230647),(-0.621568,2.198835,-0.299332),(-0.617706,2.307268,-0.377472),(-0.616508,2.465029,-0.466987),(-0.611354,2.658099,-0.567253),(-0.595687,2.869324,-0.674995),(-0.564093,3.079936,-0.784605),(-0.513176,3.27122,-0.888847),(-0.442122,3.42618,-0.979842),(-0.352843,3.531047,-1.050183),(-0.249699,3.576504,-1.094001),(-0.138829,3.558511,-1.107825),(-0.02721,3.478667,-1.0911),(0.078407,3.344067,-1.046274),(0.172528,3.16667,-0.978455),(0.251721,2.962239,-0.894671),(0.315101,2.748938,-0.802865),(0.364387,2.54572,-0.710763),(0.403543,2.370643,-0.624806),(0.438047,2.239262,-0.549294),(0.47391,2.163251,-0.485876),(0.516595,2.149364,-0.433475),(0.570013,2.198835,-0.388628),(0.635753,2.307268,-0.346213),(0.712677,2.465029,-0.300418),(0.796932,2.658099,-0.245821),(0.882406,2.869324,-0.178382),(0.961534,3.079936,-0.096216),(1.026352,3.27122,0.0),(1.397437,3.256414,0.0),(1.440781,3.374185,0.144172),(1.445733,3.437105,0.292261),(1.410465,3.439583,0.435071),(1.337129,3.3814,0.563647),(1.231522,3.267725,0.670651),(1.102228,3.108658,0.751486),(0.95936,2.918334,0.804999),(0.813114,2.713663,0.833645),(0.672335,2.512832,0.843081),(0.54334,2.333685,0.841255),(0.429167,2.19214,0.837121),(0.32936,2.100774,0.839195),(0.240323,2.067705,0.854158),(0.156181,2.095872,0.885746),(0.07,2.182772,0.934082),(-0.024828,2.320683,0.995574),(-0.133259,2.497352,1.063381),(-0.257548,2.69708,1.12839),(-0.396643,2.902121,1.180547),(-0.546128,3.094257,1.210343),(-0.698719,3.256414,1.210216),(-0.845247,3.374185,1.175667),(-0.975972,3.437105,1.105911),(-1.082015,3.439583,1.003963),(-1.156698,3.3814,0.876164),(-1.196562,3.267725,0.731204),(-1.20192,3.108658,0.578814),(-1.17683,2.918334,0.428331),(-1.128514,2.713663,0.287355),(-1.066297,2.512832,0.160718),(-1.000218,2.333685,0.049919),(-0.939552,2.19214,-0.046891),(-0.891444,2.100774,-0.134364),(-0.859884,2.067705,-0.218953),(-0.845169,2.095872,-0.307616),(-0.843939,2.182772,-0.406419),(-0.849778,2.320683,-0.519289),(-0.854285,2.497352,-0.647096),(-0.84844,2.69708,-0.787238),(-0.824062,2.902121,-0.933776),(-0.775124,3.094257,-1.078132),(-0.698719,3.256414,-1.210216),(-0.595534,3.374185,-1.319839),(-0.469761,3.437105,-1.398172),(-0.32845,3.439583,-1.439034),(-0.180432,3.3814,-1.439812),(-0.03496,3.267725,-1.401855),(0.099692,3.108658,-1.3303),(0.217469,2.918334,-1.23333),(0.3154,2.713663,-1.121),(0.393962,2.512832,-1.0038),(0.456878,2.333685,-0.891174),(0.510385,2.19214,-0.79023),(0.562084,2.100774,-0.704831),(0.619561,2.067705,-0.635205),(0.688988,2.095872,-0.578129),(0.773939,2.182772,-0.527663),(0.874606,2.320683,-0.476285),(0.987544,2.497352,-0.416285),(1.105988,2.69708,-0.341152),(1.220705,2.902121,-0.246771),(1.321252,3.094257,-0.132211),(1.397437,3.256414,0.0),(1.764792,3.179547,0.0),(1.798835,3.257065,0.180001),(1.783499,3.278248,0.360542),(1.719094,3.241213,0.53027),(1.610719,3.14925,0.678975),(1.467492,3.010531,0.799153),(1.301223,2.837382,0.887159),(1.124706,2.645188,0.94374),(0.949902,2.451025,0.973887),(0.786311,2.272147,0.986003),(0.639751,2.124447,0.990529),(0.511765,2.02105,0.998235),(0.39971,1.971142,1.018444),(0.297524,1.979158,1.057464),(0.197043,2.044385,1.117487),(0.089636,2.161029,1.196115),(-0.032086,2.318724,1.286597),(-0.17278,2.503459,1.378749),(-0.333329,2.69882,1.46041),(-0.510427,2.887447,1.519209),(-0.696852,3.05258,1.544383),(-0.882396,3.179547,1.528355),(-1.055303,3.257065,1.467837),(-1.203988,3.278248,1.364284),(-1.318775,3.241213,1.223644),(-1.393369,3.14925,1.055436),(-1.425833,3.010531,0.871308),(-1.418914,2.837382,0.683313),(-1.379656,2.645188,0.502154),(-1.318362,2.451025,0.335696),(-1.247059,2.272147,0.187964),(-1.177699,2.124447,0.058777),(-1.12038,2.02105,-0.055916),(-1.081853,1.971142,-0.163063),(-1.064553,1.979158,-0.271068),(-1.066294,2.044385,-0.388099),(-1.080684,2.161029,-0.52043),(-1.098183,2.318724,-0.671085),(-1.107642,2.503459,-0.839006),(-1.098088,2.69882,-1.018876),(-1.06046,2.887447,-1.201647),(-0.989049,3.05258,-1.375683),(-0.882396,3.179547,-1.528355),(-0.743533,3.257065,-1.647837),(-0.579511,3.278248,-1.724826),(-0.40032,3.241213,-1.753915),(-0.21735,3.14925,-1.734411),(-0.041659,3.010531,-1.670462),(0.117691,2.837382,-1.570472),(0.25495,2.645188,-1.445894),(0.368459,2.451025,-1.309583),(0.460748,2.272147,-1.173966),(0.537947,2.124447,-1.049305),(0.608614,2.02105,-0.942319),(0.682143,1.971142,-0.855381),(0.767029,1.979158,-0.786396),(0.869251,2.044385,-0.729388),(0.991048,2.161029,-0.675685),(1.130268,2.318724,-0.615511),(1.280422,2.503459,-0.539743),(1.431417,2.69882,-0.441534),(1.570887,2.887447,-0.317562),(1.685901,3.05258,-0.1687),(1.764792,3.179547,0.0),(2.115586,3.039545,0.0),(2.130954,3.076915,0.213234),(2.087371,3.059673,0.421971),(1.988213,2.989352,0.613282),(1.842131,2.872198,0.776523),(1.661786,2.718622,0.90496),(1.462007,2.542271,0.996779),(1.257678,2.358812,1.055317),(1.061662,2.184548,1.088469),(0.883096,2.034963,1.107367),(0.726301,1.923347,1.124534),(0.590489,1.859619,1.151791),(0.470285,1.849441,1.198266),(0.356986,1.893718,1.268803),(0.240337,1.988514,1.36302),(0.11055,2.125408,1.475191),(-0.039775,2.292235,1.594947),(-0.214129,2.474172,1.70871),(-0.411212,2.655054,1.801639),(-0.624854,2.818807,1.859784),(-0.844732,2.950883,1.872119),(-1.057793,3.039545,1.832151),(-1.250143,3.076915,1.738843),(-1.409123,3.059673,1.596731),(-1.525224,2.989352,1.415201),(-1.593555,2.872198,1.207071),(-1.614612,2.718622,0.986669),(-1.59424,2.542271,0.767745),(-1.54277,2.358812,0.561522),(-1.473473,2.184548,0.375192),(-1.400556,2.034963,0.2111),(-1.337025,1.923347,0.066728),(-1.292724,1.859619,-0.064517),(-1.272872,1.849441,-0.191855),(-1.277308,1.893718,-0.325243),(-1.300578,1.988514,-0.473372),(-1.332828,2.125408,-0.641856),(-1.361377,2.292235,-0.83192),(-1.372722,2.474172,-1.039796),(-1.354659,2.655054,-1.25694),(-1.298193,2.818807,-1.471032),(-1.198937,2.950883,-1.667619),(-1.057793,3.039545,-1.832151),(-0.880811,3.076915,-1.952077),(-0.678248,3.059673,-2.018702),(-0.462988,2.989352,-2.028484),(-0.248577,2.872198,-1.983594),(-0.047174,2.718622,-1.891629),(0.132233,2.542271,-1.764525),(0.285092,2.358812,-1.616839),(0.41181,2.184548,-1.463661),(0.51746,2.034963,-1.318467),(0.610724,1.923347,-1.191262),(0.702236,1.859619,-1.087273),(0.802587,1.849441,-1.006412),(0.920322,1.893718,-0.94356),(1.060241,1.988514,-0.889648),(1.222278,2.125408,-0.833335),(1.401152,2.292235,-0.763027),(1.586851,2.474172,-0.668914),(1.765872,2.655054,-0.544699),(1.923047,2.818807,-0.388752),(2.043669,2.950883,-0.2045),(2.115586,3.039545,0.0),(2.437013,2.838781,0.0),(2.425253,2.83919,0.242683),(2.347295,2.789582,0.474516),(2.210274,2.694364,0.681779),(2.026697,2.561997,0.854324),(1.812627,2.404242,0.987104),(1.585375,2.235117,1.08089),(1.361058,2.069649,1.142064),(1.152403,1.92254,1.1815),(0.96712,1.806863,1.212731),(0.807114,1.732894,1.249657),(0.668618,1.707207,1.304187),(0.543242,1.732085,1.384159),(0.419752,1.805316,1.491887),(0.286277,1.920393,1.623558),(0.132612,2.067093,1.769579),(-0.047778,2.232379,1.915839),(-0.256356,2.401565,2.045676),(-0.488959,2.559619,2.142268),(-0.73616,2.692496,2.19107),(-0.98452,2.78839,2.181921),(-1.218507,2.838781,2.110515),(-1.422796,2.83919,1.978989),(-1.58459,2.789582,1.795559),(-1.695575,2.694364,1.573264),(-1.753215,2.561997,1.328009),(-1.76117,2.404242,1.076229),(-1.728766,2.235117,0.83253),(-1.669585,2.069649,0.607679),(-1.599411,1.92254,0.40726),(-1.533816,1.806863,0.231186),(-1.485792,1.732894,0.074153),(-1.463768,1.707207,-0.073054),(-1.470338,1.732085,-0.221618),(-1.501888,1.805316,-0.382428),(-1.549181,1.920393,-0.563856),(-1.598806,2.067093,-0.769944),(-1.635276,2.232379,-0.999296),(-1.643429,2.401565,-1.244849),(-1.610779,2.559619,-1.494585),(-1.529442,2.692496,-1.733068),(-1.397339,2.78839,-1.94358),(-1.218507,2.838781,-2.110515),(-1.002457,2.83919,-2.221672),(-0.762705,2.789582,-2.270075),(-0.514699,2.694364,-2.255043),(-0.273482,2.561997,-2.182333),(-0.051456,2.404242,-2.063333),(0.143391,2.235117,-1.91342),(0.308527,2.069649,-1.749743),(0.447008,1.92254,-1.58876),(0.566695,1.806863,-1.443916),(0.678678,1.732894,-1.32381),(0.79515,1.707207,-1.231133),(0.927096,1.732085,-1.162541),(1.082136,1.805316,-1.10946),(1.262904,1.920393,-1.059702),(1.466194,2.067093,-0.999634),(1.683054,2.232379,-0.916542),(1.899785,2.401565,-0.800827),(2.099738,2.559619,-0.647683),(2.265602,2.692496,-0.458001),(2.381859,2.78839,-0.238341),(2.437013,2.838781,0.0),(2.717275,2.582963,0.0),(2.671698,2.552321,0.267344),(2.555732,2.478548,0.516652),(2.38066,2.368198,0.734336),(2.162789,2.231077,0.911692),(1.921104,2.079368,1.046177),(1.674563,1.926551,1.141698),(1.439463,1.786204,1.207853),(1.227277,1.670799,1.258265),(1.043285,1.59059,1.308238),(0.886218,1.552702,1.372133),(0.748938,1.560503,1.460857),(0.620054,1.6133,1.579871),(0.486195,1.706402,1.728039),(0.334581,1.831535,1.897502),(0.15547,1.977582,2.074597),(-0.055905,2.131565,2.241708),(-0.29822,2.279802,2.379737),(-0.563956,2.409122,2.470852),(-0.840311,2.508034,2.501059),(-1.110998,2.56775,2.462225),(-1.358638,2.582963,2.353229),(-1.567375,2.552321,2.180086),(-1.7253,2.478548,1.955003),(-1.826284,2.368198,1.694544),(-1.870943,2.231077,1.417184),(-1.866568,2.079368,1.140636),(-1.826021,1.926551,0.879365),(-1.765763,1.786204,0.642685),(-1.703328,1.670799,0.433721),(-1.65461,1.59059,0.249392),(-1.631411,1.552702,0.08142),(-1.639608,1.560503,-0.081829),(-1.678235,1.6133,-0.252953),(-1.739623,1.706402,-0.442963),(-1.810575,1.831535,-0.658995),(-1.874389,1.977582,-0.902658),(-1.913424,2.131565,-1.169269),(-1.911803,2.279802,-1.448134),(-1.857843,2.409122,-1.723826),(-1.745825,2.508034,-1.978261),(-1.57685,2.56775,-2.193265),(-1.358638,2.582963,-2.353229),(-1.104323,2.552321,-2.44743),(-0.830432,2.478548,-2.471655),(-0.554376,2.368198,-2.42888),(-0.291846,2.231077,-2.328876),(-0.054536,2.079368,-2.186814),(0.151458,1.926551,-2.021063),(0.3263,1.786204,-1.850538),(0.476051,1.670799,-1.691985),(0.611325,1.59059,-1.55763),(0.745193,1.552702,-1.453554),(0.89067,1.560503,-1.379027),(1.058181,1.6133,-1.326917),(1.253428,1.706402,-1.285077),(1.475994,1.831535,-1.238506),(1.718919,1.977582,-1.171939),(1.969328,2.131565,-1.072439),(2.210023,2.279802,-0.931603),(2.421799,2.409122,-0.747026),(2.586137,2.508034,-0.522799),(2.687848,2.56775,-0.26896),(2.717275,2.582963,0.0),(2.946476,2.280742,0.0),(2.862854,2.22708,0.286472),(2.708187,2.138698,0.547472),(2.497942,2.023447,0.770513),(2.251817,1.891569,0.94922),(1.990921,1.754782,1.084198),(1.734801,1.62524,1.182767),(1.498775,1.514453,1.257621),(1.291971,1.432265,1.324592),(1.116381,1.385979,1.399898),(0.967053,1.379707,1.497291),(0.833382,1.414008,1.625571),(0.701286,1.485832,1.786847),(0.555916,1.588799,1.975843),(0.384456,1.713759,2.180358),(0.178567,1.849609,2.382816),(-0.063909,1.984277,2.562678),(-0.338273,2.1058,2.699356),(-0.633412,2.203377,2.77516),(-0.93331,2.268339,2.777857),(-1.219378,2.294915,2.70242),(-1.473238,2.280742,2.551723),(-1.679519,2.22708,2.336068),(-1.828218,2.138698,2.071623),(-1.916255,2.023447,1.778025),(-1.947958,1.891569,1.47552),(-1.934403,1.754782,1.182089),(-1.891707,1.62524,0.910998),(-1.83852,1.514453,0.669166),(-1.793116,1.432265,0.456583),(-1.770538,1.385979,0.266866),(-1.780219,1.379707,0.088847),(-1.824477,1.414008,-0.091056),(-1.898097,1.485832,-0.286092),(-1.989088,1.588799,-0.506484),(-2.080474,1.713759,-0.757231),(-2.152863,1.849609,-1.036764),(-2.18739,1.984277,-1.336686),(-2.168574,2.1058,-1.642631),(-2.086653,2.203377,-1.936131),(-1.939039,2.268339,-2.197199),(-1.730675,2.294915,-2.407222),(-1.473238,2.280742,-2.551723),(-1.183335,2.22708,-2.62254),(-0.879969,2.138698,-2.619094),(-0.581687,2.023447,-2.548538),(-0.303859,1.891569,-2.424741),(-0.056518,1.754782,-2.266287),(0.156906,1.62524,-2.093766),(0.339745,1.514453,-1.926788),(0.501145,1.432265,-1.781176),(0.654157,1.385979,-1.666764),(0.813166,1.379707,-1.586138),(0.991095,1.414008,-1.534515),(1.196812,1.485832,-1.500754),(1.433172,1.588799,-1.469359),(1.696018,1.713759,-1.423128),(1.974295,1.849609,-1.346052),(2.251299,1.984277,-1.225992),(2.506847,2.1058,-1.056725),(2.720065,2.203377,-0.839029),(2.872349,2.268339,-0.580658),(2.950053,2.294915,-0.295197),(2.946476,2.280742,0.0),(3.11737,1.943072,0.0),(2.994408,1.87575,0.299636),(2.803466,1.782761,0.566733),(2.563867,1.672369,0.790848),(2.297955,1.554382,0.968669),(2.027916,1.439283,1.104344),(1.772696,1.337301,1.208603),(1.545467,1.257495,1.296801),(1.352055,1.206958,1.386194),(1.190533,1.190179,1.492881),(1.052052,1.208651,1.628895),(0.922757,1.26073,1.799904),(0.786471,1.341791,2.003896),(0.627725,1.44463,2.231069),(0.434635,1.560109,2.464938),(0.201177,1.677969,2.684524),(-0.071505,1.787735,2.867265),(-0.374975,1.879656,2.992226),(-0.69457,1.945564,3.043109),(-1.011506,1.979602,3.010596),(-1.305674,1.978746,2.89367),(-1.558685,1.943072,2.699722),(-1.756696,1.87575,2.443415),(-1.892538,1.782761,2.144506),(-1.966828,1.672369,1.82495),(-1.987869,1.554382,1.505752),(-1.970348,1.439283,1.204055),(-1.933029,1.337301,0.930898),(-1.895796,1.257495,0.690013),(-1.876506,1.206958,0.477817),(-1.888139,1.190179,0.284591),(-1.93669,1.208651,0.096656),(-2.020141,1.26073,-0.100821),(-2.128661,1.341791,-0.320844),(-2.246025,1.44463,-0.571908),(-2.352017,1.560109,-0.856064),(-2.425455,1.677969,-1.168037),(-2.447371,1.787735,-1.495558),(-2.403856,1.879656,-1.82085),(-2.288125,1.945564,-2.12307),(-2.101499,1.979602,-2.381288),(-1.853155,1.978746,-2.577581),(-1.558685,1.943072,-2.699722),(-1.237712,1.87575,-2.743051),(-0.910928,1.782761,-2.711239),(-0.597039,1.672369,-2.615798),(-0.310085,1.554382,-2.474422),(-0.057568,1.439283,-2.308399),(0.160333,1.337301,-2.139501),(0.350329,1.257495,-1.986814),(0.524451,1.206958,-1.864011),(0.697606,1.190179,-1.777472),(0.884638,1.208651,-1.725551),(1.097384,1.26073,-1.699082),(1.342189,1.341791,-1.683052),(1.618299,1.44463,-1.65916),(1.917382,1.560109,-1.608874),(2.224277,1.677969,-1.516487),(2.518877,1.787735,-1.371707),(2.778831,1.879656,-1.171375),(2.982695,1.945564,-0.920039),(3.113005,1.979602,-0.629308),(3.158828,1.978746,-0.316088),(3.11737,1.943072,0.0),(3.225885,1.582372,0.0),(3.065433,1.511176,0.306743),(2.843659,1.423098,0.574858),(2.583068,1.325964,0.796771),(2.30763,1.228406,0.972748),(2.039401,1.139091,1.110599),(1.795498,1.065955,1.22415),(1.585891,1.015498,1.330721),(1.412353,0.992202,1.448014),(1.268703,0.998138,1.590904),(1.142309,1.032777,1.768641),(1.016583,1.093043,1.982918),(0.87408,1.173579,2.22712),(0.699697,1.267231,2.486869),(0.483458,1.365677,2.741825),(0.222453,1.460169,2.968434),(-0.078387,1.542312,3.143239),(-0.406805,1.604806,3.246229),(-0.744921,1.642099,3.263714),(-1.07188,1.650877,3.19029),(-1.367002,1.630361,3.029587),(-1.612943,1.582372,2.793698),(-1.798363,1.511176,2.501371),(-1.919671,1.423098,2.175252),(-1.981558,1.325964,1.838617),(-1.996239,1.228406,1.512092),(-1.981507,1.139091,1.210874),(-1.957893,1.065955,0.942872),(-1.945383,1.015498,0.708062),(-1.960193,0.992202,0.499127),(-2.012115,0.998138,0.303277),(-2.102842,1.032777,0.104948),(-2.225549,1.093043,-0.111073),(-2.365782,1.173579,-0.356584),(-2.50354,1.267231,-0.63748),(-2.616219,1.365677,-0.952226),(-2.681966,1.460169,-1.291567),(-2.682931,1.542312,-1.639505),(-2.607914,1.604806,-1.975418),(-2.453999,1.642099,-2.276978),(-2.226932,1.650877,-2.52342),(-1.940198,1.630361,-2.698652),(-1.612943,1.582372,-2.793698),(-1.267069,1.511176,-2.808114),(-0.923988,1.423098,-2.75011),(-0.60151,1.325964,-2.635388),(-0.311391,1.228406,-2.48484),(-0.057894,1.139091,-2.321472),(0.162396,1.065955,-2.167021),(0.359492,1.015498,-2.038782),(0.54784,0.992202,-1.94714),(0.743411,0.998138,-1.894181),(0.960533,1.032777,-1.873589),(1.208966,1.093043,-1.871846),(1.491702,1.173579,-1.870535),(1.803844,1.267231,-1.84939),(2.132761,1.365677,-1.789599),(2.459512,1.460169,-1.676867),(2.761319,1.542312,-1.503734),(3.01472,1.604806,-1.270811),(3.19892,1.642099,-0.986736),(3.298812,1.650877,-0.666869),(3.3072,1.630361,-0.330935),(3.225885,1.582372,0.0),(3.271376,1.211585,0.0),(3.078355,1.145791,0.308036),(2.833835,1.070768,0.572872),(2.56253,0.993181,0.790436),(2.288827,0.919924,0.964821),(2.03338,0.857507,1.10732),(1.81033,0.811476,1.234262),(1.625582,0.78592,1.364025),(1.476394,0.78311,1.513672),(1.352328,0.803296,1.695765),(1.237395,0.844685,1.915862),(1.113058,0.903599,2.1711),(0.961594,0.974802,2.450102),(0.769296,1.051969,2.73424),(0.528993,1.128243,3.000066),(0.241496,1.196846,3.222545),(-0.084257,1.251683,3.378594),(-0.432391,1.287881,3.450395),(-0.782408,1.302224,3.427954),(-1.112278,1.293438,3.310528),(-1.401797,1.262302,3.106701),(-1.635688,1.211585,2.833095),(-1.805944,1.145791,2.511915),(-1.913039,1.070768,2.167737),(-1.965802,0.993181,1.823998),(-1.979973,0.919924,1.499772),(-1.975657,0.857507,1.207299),(-1.974067,0.811476,0.950661),(-1.994071,0.78592,0.725783),(-2.049075,0.78311,0.521759),(-2.144739,0.803296,0.323267),(-2.277883,0.844685,0.113684),(-2.436757,0.903599,-0.121613),(-2.602647,0.974802,-0.392286),(-2.752569,1.051969,-0.70089),(-2.86263,1.128243,-1.041912),(-2.911554,1.196846,-1.40213),(-2.88382,1.251683,-1.762266),(-2.771935,1.287881,-2.099659),(-2.577491,1.302224,-2.391562),(-2.310862,1.293438,-2.618525),(-1.989584,1.262302,-2.767343),(-1.635688,1.211585,-2.833095),(-1.27241,1.145791,-2.819951),(-0.920796,1.070768,-2.740609),(-0.596727,0.993181,-2.614433),(-0.308854,0.919924,-2.464593),(-0.057723,0.857507,-2.314619),(0.163737,0.811476,-2.184923),(0.368489,0.78592,-2.089808),(0.572681,0.78311,-2.035431),(0.792412,0.803296,-2.019033),(1.040488,0.844685,-2.029547),(1.323699,0.903599,-2.049486),(1.641053,0.974802,-2.057816),(1.983273,1.051969,-2.03335),(2.333637,1.128243,-1.958154),(2.670057,1.196846,-1.820414),(2.968077,1.251683,-1.616329),(3.204325,1.287881,-1.350736),(3.359899,1.302224,-1.036392),(3.42314,1.293438,-0.692003),(3.391381,1.262302,-0.339359),(3.271376,1.211585,0.0),(3.256589,0.843189,0.0),(3.038641,0.790688,0.304062),(2.781487,0.734745,0.56229),(2.510859,0.680332,0.774497),(2.250262,0.632282,0.948565),(2.017725,0.594867,1.098794),(1.823438,0.57141,1.243199),(1.668657,0.563995,1.40017),(1.545997,0.573282,1.585032),(1.441089,0.598444,1.807069),(1.335311,0.637247,2.067466),(1.209152,0.686243,2.358539),(1.045682,0.741077,2.664355),(0.833573,0.796879,2.962694),(0.569189,0.848689,3.228031),(0.257425,0.891903,3.435102),(-0.088843,0.922684,3.562507),(-0.45061,0.938294,3.595781),(-0.805581,0.937348,3.529482),(-1.131574,0.919928,3.36796),(-1.409914,0.887584,3.12469),(-1.628294,0.843189,2.820289),(-1.782646,0.790688,2.479509),(-1.8777,0.734745,2.127693),(-1.926164,0.680332,1.787219),(-1.946613,0.632282,1.474502),(-1.960446,0.594867,1.198004),(-1.988361,0.57141,0.957544),(-2.046911,0.563995,0.745015),(-2.145676,0.573282,0.546356),(-2.285512,0.598444,0.344486),(-2.458134,0.637247,0.12268),(-2.647131,0.686243,-0.132113),(-2.830241,0.741077,-0.42659),(-2.982555,0.796879,-0.759452),(-3.080151,0.848689,-1.121083),(-3.103598,0.891903,-1.494614),(-3.040799,0.922684,-1.858194),(-2.888732,0.938294,-2.18813),(-2.653831,0.937348,-2.462395),(-2.350952,0.919928,-2.663952),(-2.001104,0.887584,-2.783366),(-1.628294,0.843189,-2.820289),(-1.255995,0.790688,-2.783571),(-0.903786,0.734745,-2.689983),(-0.584695,0.680332,-2.561716),(-0.30365,0.632282,-2.423067),(-0.057279,0.594867,-2.296798),(0.164923,0.57141,-2.200744),(0.378254,0.563995,-2.145184),(0.59968,0.573282,-2.131388),(0.844423,0.598444,-2.151554),(1.122823,0.637247,-2.190147),(1.437978,0.686243,-2.226426),(1.784558,0.741077,-2.237765),(2.148982,0.796879,-2.203242),(2.510962,0.848689,-2.106947),(2.846173,0.891903,-1.940488),(3.129643,0.922684,-1.704313),(3.339342,0.938294,-1.407651),(3.459412,0.937348,-1.067087),(3.482526,0.919928,-0.704008),(3.411018,0.887584,-0.341324),(3.256589,0.843189,0.0),(3.187338,0.488282,0.0),(2.954229,0.454831,0.295615),(2.695777,0.421332,0.544963),(2.437425,0.39076,0.751846),(2.200513,0.365833,0.927594),(1.999373,0.348765,1.0888),(1.83954,0.341072,1.254177),(1.717359,0.343439,1.441036),(1.621023,0.355655,1.661953),(1.532875,0.376635,1.922165),(1.432607,0.404514,2.21811),(1.300828,0.436815,2.537359),(1.122459,0.470668,2.859978),(0.889396,0.503066,3.161102),(0.602042,0.531128,3.414352),(0.26945,0.552363,3.595556),(-0.091929,0.564883,3.686218),(-0.460686,0.567576,3.676189),(-0.813716,0.560202,3.565125),(-1.129749,0.543417,3.362526),(-1.392607,0.518712,3.086335),(-1.593669,0.488282,2.760316),(-1.733125,0.454831,2.41063),(-1.819841,0.421332,2.06213),(-1.86983,0.39076,1.734949),(-1.903577,0.365833,1.441903),(-1.942615,0.348765,1.187108),(-2.005919,0.341072,0.966),(-2.106653,0.343439,0.766759),(-2.249805,0.355655,0.572871),(-2.431082,0.376635,0.366427),(-2.637243,0.404514,0.131619),(-2.847831,0.436815,-0.142129),(-3.038043,0.470668,-0.457911),(-3.182293,0.503066,-0.810311),(-3.257936,0.531128,-1.185792),(-3.248567,0.552363,-1.564428),(-3.146394,0.564883,-1.922722),(-2.95333,0.567576,-2.23706),(-2.68063,0.560202,-2.487261),(-2.347159,0.543417,-2.659654),(-1.976541,0.518712,-2.749201),(-1.593669,0.488282,-2.760316),(-1.221104,0.454831,-2.706245),(-0.875937,0.421332,-2.607093),(-0.567595,0.39076,-2.486795),(-0.296937,0.365833,-2.369498),(-0.056758,0.348765,-2.275908),(0.166379,0.341072,-2.220177),(0.389294,0.343439,-2.207794),(0.628782,0.355655,-2.234823),(0.898206,0.376635,-2.288592),(1.204636,0.404514,-2.349729),(1.547003,0.436815,-2.39523),(1.915584,0.470668,-2.402067),(2.292897,0.503066,-2.350791),(2.655894,0.531128,-2.22856),(2.979118,0.552363,-2.031128),(3.238323,0.564883,-1.763497),(3.414016,0.567576,-1.439128),(3.494347,0.560202,-1.077863),(3.476908,0.543417,-0.702872),(3.369148,0.518712,-0.337134),(3.187338,0.488282,0.0),(3.071928,0.155791,0.0),(2.834755,0.14448,0.28366),(2.586654,0.133834,0.522903),(2.351455,0.124797,0.725328),(2.14718,0.118172,0.905112),(1.983641,0.114548,1.080233),(1.861331,0.114248,1.269034),(1.771786,0.117297,1.486705),(1.699326,0.123425,1.742233),(1.623909,0.132088,2.036317),(1.524637,0.142515,2.3606),(1.38336,0.15378,2.698343),(1.187798,0.164882,3.026459),(0.933712,0.174835,3.318609),(0.625762,0.182755,3.54887),(0.276935,0.187937,3.695436),(-0.093364,0.189921,3.743759),(-0.46225,0.188531,3.688666),(-0.806864,0.183891,3.535102),(-1.10787,0.176412,3.297407),(-1.352399,0.166759,2.997224),(-1.535964,0.155791,2.660368),(-1.663034,0.14448,2.31314),(-1.746174,0.133834,1.978656),(-1.80388,0.124797,1.673756),(-1.857441,0.118172,1.406957),(-1.92733,0.114548,1.177767),(-2.029681,0.114248,0.977443),(-2.173418,0.117297,0.791059),(-2.358481,0.123425,0.600543),(-2.575457,0.132088,0.388188),(-2.806658,0.142515,0.140074),(-3.028513,0.15378,-0.151147),(-3.21489,0.164882,-0.484567),(-3.340856,0.174835,-0.850686),(-3.386293,0.182755,-1.23251),(-3.338809,0.187937,-1.607885),(-3.195509,0.189921,-1.952735),(-2.963353,0.188531,-2.244653),(-2.658056,0.183891,-2.466315),(-2.301703,0.176412,-2.608147),(-1.919473,0.166759,-2.669824),(-1.535964,0.155791,-2.660368),(-1.171721,0.14448,-2.5968),(-0.840479,0.133834,-2.501559),(-0.547575,0.124797,-2.399084),(-0.28974,0.118172,-2.312069),(-0.056311,0.114548,-2.258),(0.16835,0.114248,-2.246477),(0.401631,0.117297,-2.277765),(0.659155,0.123425,-2.342776),(0.951548,0.132088,-2.424505),(1.282021,0.142515,-2.500675),(1.645154,0.15378,-2.547196),(2.027092,0.164882,-2.541893),(2.407144,0.174835,-2.467923),(2.760531,0.182755,-2.316361),(3.061874,0.187937,-2.08755),(3.288872,0.189921,-1.791024),(3.425603,0.188531,-1.444013),(3.46492,0.183891,-1.068786),(3.409573,0.176412,-0.68926),(3.271872,0.166759,-0.3274),(3.071928,0.155791,0.0),(2.920371,-0.148104,0.0),(2.69065,-0.137136,0.26924),(2.463914,-0.127483,0.498091),(2.261158,-0.120004,0.697475),(2.096158,-0.115364,0.883605),(1.973694,-0.113974,1.074816),(1.889196,-0.115958,1.288032),(1.829836,-0.12114,1.535415),(1.7769,-0.12906,1.821766),(1.709046,-0.139013,2.143075),(1.605946,-0.150115,2.486491),(1.45173,-0.16138,2.831703),(1.237685,-0.171807,3.153569),(0.963802,-0.18047,3.425556),(0.63892,-0.186598,3.623498),(0.279455,-0.189647,3.729066),(-0.093081,-0.189347,3.732437),(-0.455365,-0.185723,3.633725),(-0.785837,-0.179098,3.442976),(-1.067988,-0.170061,3.178705),(-1.292835,-0.159415,2.865216),(-1.460185,-0.148104,2.529115),(-1.578494,-0.137136,2.195551),(-1.663316,-0.127483,1.884766),(-1.73461,-0.120004,1.609483),(-1.813303,-0.115364,1.373524),(-1.917665,-0.113974,1.171861),(-2.060066,-0.115958,0.992076),(-2.244627,-0.12114,0.816977),(-2.466145,-0.12906,0.627958),(-2.71048,-0.139013,0.408539),(-2.956337,-0.150115,0.147545),(-3.178192,-0.16138,-0.158617),(-3.349913,-0.171807,-0.504918),(-3.44852,-0.18047,-0.878101),(-3.457501,-0.186598,-1.258428),(-3.369193,-0.189647,-1.622518),(-3.185844,-0.189347,-1.946829),(-2.919216,-0.185723,-2.21122),(-2.588786,-0.179098,-2.402043),(-2.218845,-0.170061,-2.514257),(-1.834932,-0.159415,-2.552236),(-1.460185,-0.148104,-2.529115),(-1.112156,-0.137136,-2.464792),(-0.800597,-0.127483,-2.382857),(-0.526548,-0.120004,-2.306958),(-0.282855,-0.115364,-2.257128),(-0.056029,-0.113974,-2.246677),(0.17087,-0.115958,-2.280108),(0.41479,-0.12114,-2.352392),(0.689245,-0.12906,-2.449723),(1.001435,-0.139013,-2.551615),(1.350391,-0.150115,-2.634035),(1.726462,-0.16138,-2.673086),(2.112229,-0.171807,-2.648651),(2.484718,-0.18047,-2.547455),(2.818581,-0.186598,-2.36507),(3.089739,-0.189647,-2.106548),(3.278926,-0.189347,-1.785608),(3.374581,-0.185723,-1.422505),(3.374623,-0.179098,-1.040933),(3.286833,-0.170061,-0.664448),(3.127767,-0.159415,-0.31298),(2.920371,-0.148104,0.0),(2.743472,-0.420284,0.0),(2.53219,-0.389855,0.253384),(2.336309,-0.365149,0.472295),(2.172974,-0.348364,0.670274),(2.051084,-0.34099,0.864605),(1.970242,-0.343683,1.072937),(1.921147,-0.356203,1.309816),(1.88737,-0.377438,1.583691),(1.848213,-0.405501,1.894879),(1.782215,-0.437899,2.234827),(1.670735,-0.471752,2.586804),(1.501063,-0.504053,2.927932),(1.268562,-0.531932,3.232244),(0.977522,-0.552911,3.474318),(0.640581,-0.565127,3.632913),(0.276831,-0.567494,3.694049),(-0.091102,-0.559802,3.653059),(-0.440522,-0.542734,3.515285),(-0.752135,-0.517806,3.295317),(-1.012947,-0.487235,3.014884),(-1.218161,-0.453735,2.699723),(-1.371736,-0.420284,2.375916),(-1.485532,-0.389855,2.066249),(-1.577174,-0.365149,1.787156),(-1.666961,-0.348364,1.546714),(-1.774312,-0.34099,1.343989),(-1.914312,-0.343683,1.169811),(-2.094908,-0.356203,1.008854),(-2.315202,-0.377438,0.842665),(-2.56512,-0.405501,0.65316),(-2.826525,-0.437899,0.42603),(-3.075606,-0.471752,0.153497),(-3.286195,-0.504053,-0.164007),(-3.433486,-0.531932,-0.517515),(-3.497609,-0.552911,-0.890601),(-3.466485,-0.565127,-1.261697),(-3.337556,-0.567494,-1.607282),(-3.118091,-0.559802,-1.905426),(-2.824065,-0.542734,-2.139146),(-2.477761,-0.517806,-2.299026),(-2.104492,-0.487235,-2.38468),(-1.728948,-0.453735,-2.40482),(-1.371736,-0.420284,-2.375916),(-1.046658,-0.389855,-2.319633),(-0.759135,-0.365149,-2.259451),(-0.506013,-0.348364,-2.216988),(-0.276773,-0.34099,-2.208593),(-0.055931,-0.343683,-2.242748),(0.17376,-0.356203,-2.318671),(0.427832,-0.377438,-2.426356),(0.716907,-0.405501,-2.548039),(1.044309,-0.437899,-2.660857),(1.404871,-0.471752,-2.740301),(1.785132,-0.504053,-2.763925),(2.164924,-0.531932,-2.714729),(2.520087,-0.552911,-2.583718),(2.825905,-0.565127,-2.371216),(3.060725,-0.567494,-2.086767),(3.209192,-0.559802,-1.747633),(3.264587,-0.542734,-1.376139),(3.229896,-0.517806,-0.996291),(3.117439,-0.487235,-0.630204),(2.947109,-0.453735,-0.294903),(2.743472,-0.420284,0.0),(2.551874,-0.660726,0.0),(2.368581,-0.616331,0.237012),(2.210769,-0.583987,0.446917),(2.090997,-0.566568,0.644987),(2.013018,-0.565621,0.848558),(1.971474,-0.581232,1.073608),(1.953004,-0.612012,1.331536),(1.938578,-0.655227,1.62666),(1.9067,-0.707037,1.954843),(1.836959,-0.762838,2.303474),(1.713381,-0.817672,2.652833),(1.52706,-0.866668,2.97864),(1.277647,-0.905471,3.255391),(0.973487,-0.930634,3.459979),(0.630375,-0.93992,3.575035),(0.269144,-0.932505,3.591477),(-0.08753,-0.909048,3.50986),(-0.418596,-0.871633,3.340318),(-0.70781,-0.823584,3.101116),(-0.946132,-0.76917,2.816018),(-1.132951,-0.713227,2.510877),(-1.275937,-0.660726,2.209988),(-1.389549,-0.616331,1.932745),(-1.492426,-0.583987,1.691124),(-1.604074,-0.566568,1.488363),(-1.741382,-0.565621,1.319046),(-1.915509,-0.581232,1.170543),(-2.129646,-0.612012,1.025583),(-2.378018,-0.655227,0.865528),(-2.646294,-0.707037,0.673829),(-2.913346,-0.762838,0.439116),(-3.154111,-0.817672,0.157415),(-3.343108,-0.866668,-0.166848),(-3.458075,-0.905471,-0.521221),(-3.483173,-0.930634,-0.886925),(-3.411259,-0.93992,-1.241597),(-3.244883,-0.932505,-1.562653),(-2.995862,-0.909048,-1.830733),(-2.683502,-0.871633,-2.032674),(-2.331741,-0.823584,-2.163539),(-1.965677,-0.76917,-2.227383),(-1.608008,-0.713227,-2.236602),(-1.275937,-0.660726,-2.209988),(-0.979032,-0.616331,-2.169758),(-0.718343,-0.583987,-2.13804),(-0.486923,-0.566568,-2.13335),(-0.271636,-0.565621,-2.167604),(-0.055966,-0.581232,-2.244151),(0.176642,-0.612012,-2.357119),(0.43944,-0.655227,-2.492188),(0.739594,-0.707037,-2.628673),(1.076387,-0.762838,-2.74259),(1.44073,-0.817672,-2.810248),(1.816048,-0.866668,-2.811793),(2.180428,-0.905471,-2.73417),(2.509686,-0.930634,-2.573054),(2.780884,-0.93992,-2.333438),(2.975739,-0.932505,-2.028824),(3.083393,-0.909048,-1.679126),(3.102098,-0.871633,-1.307644),(3.03955,-0.823584,-0.937577),(2.911809,-0.76917,-0.588635),(2.740958,-0.713227,-0.274274),(2.551874,-0.660726,0.0),(2.355137,-0.872247,0.0),(2.207172,-0.821529,0.220861),(2.091813,-0.790394,0.422869),(2.016644,-0.781607,0.622052),(1.980372,-0.79595,0.834797),(1.973248,-0.832149,1.074574),(1.978786,-0.886985,1.349113),(1.976522,-0.955588,1.658499),(1.945365,-1.031862,1.994484),(1.86702,-1.109029,2.341169),(1.728945,-1.180233,2.67693),(1.526387,-1.239146,2.977328),(1.263184,-1.280535,3.21854),(0.951206,-1.300721,3.380787),(0.608544,-1.297912,3.451226),(0.256732,-1.272356,3.425857),(-0.08255,-1.226324,3.310145),(-0.390768,-1.163907,3.118254),(-0.655289,-1.090651,2.871011),(-0.871174,-1.013064,2.592916),(-1.041702,-0.93804,2.308648),(-1.177568,-0.872247,2.039608),(-1.294857,-0.821529,1.801037),(-1.412122,-0.790394,1.600128),(-1.547035,-0.781607,1.435439),(-1.713142,-0.79595,1.297654),(-1.917232,-0.832149,1.171596),(-2.157759,-0.886985,1.039122),(-2.424563,-0.955588,0.882469),(-2.699957,-1.031862,0.687493),(-2.961022,-1.109029,0.446302),(-3.182762,-1.180233,0.158845),(-3.341636,-1.239146,-0.166774),(-3.41893,-1.280535,-0.515321),(-3.40345,-1.300721,-0.866625),(-3.293121,-1.297912,-1.198598),(-3.095245,-1.272356,-1.490592),(-2.825395,-1.226324,-1.726563),(-2.505103,-1.163907,-1.897542),(-2.158724,-1.090651,-2.003003),(-1.809945,-1.013064,-2.050917),(-1.478497,-0.93804,-2.056464),(-1.177568,-0.872247,-2.039608),(-0.912315,-0.821529,-2.021898),(-0.679691,-0.790394,-2.022998),(-0.469609,-0.781607,-2.057491),(-0.267231,-0.79595,-2.132451),(-0.056016,-0.832149,-2.24617),(0.178973,-0.886985,-2.388235),(0.448041,-0.955588,-2.540967),(0.754592,-1.031862,-2.681978),(1.094002,-1.109029,-2.787471),(1.453817,-1.180233,-2.835775),(1.815248,-1.239146,-2.810554),(2.155746,-1.280535,-2.70322),(2.452244,-1.300721,-2.514162),(2.684577,-1.297912,-2.252628),(2.838513,-1.272356,-1.935265),(2.907945,-1.226324,-1.583582),(2.895871,-1.163907,-1.220712),(2.814013,-1.090651,-0.868008),(2.681118,-1.013064,-0.542),(2.520199,-0.93804,-0.252184),(2.355137,-0.872247,0.0),(2.160942,-1.059993,0.0),(2.052859,-1.012004,0.20542),(1.981208,-0.991488,0.40051),(1.948585,-1.000266,0.601059),(1.949113,-1.037559,0.82162),(1.969509,-1.100053,1.072538),(1.991293,-1.182196,1.357641),(1.993788,-1.276688,1.672987),(1.957437,-1.375134,2.006861),(1.86693,-1.468785,2.341056),(1.713637,-1.549322,2.653229),(1.496995,-1.609588,2.919997),(1.224618,-1.644227,3.120275),(0.91113,-1.650163,3.23835),(0.57592,-1.626867,3.266207),(0.240162,-1.57641,3.204743),(-0.076403,-1.503274,3.063681),(-0.358427,-1.413959,2.860181),(-0.597172,-1.316401,2.61638),(-0.791645,-1.219267,2.356211),(-0.948463,-1.131189,2.102011),(-1.080471,-1.059993,1.871431),(-1.204328,-1.012004,1.675118),(-1.337456,-0.991488,1.515521),(-1.494825,-1.000266,1.386995),(-1.686101,-1.037559,1.277172),(-1.913599,-1.100053,1.169376),(-2.171398,-1.182196,1.04569),(-2.445743,-1.276688,0.890178),(-2.716712,-1.375134,0.69176),(-2.960879,-1.468785,0.446281),(-3.154582,-1.549322,0.157439),(-3.277289,-1.609588,-0.163563),(-3.314546,-1.644227,-0.499587),(-3.260059,-1.650163,-0.830113),(-3.116579,-1.626867,-1.134342),(-2.89547,-1.57641,-1.394385),(-2.615024,-1.503274,-1.598008),(-2.297776,-1.413959,-1.740498),(-1.967266,-1.316401,-1.825356),(-1.644716,-1.219267,-1.86369),(-1.346163,-1.131189,-1.872399),(-1.080471,-1.059993,-1.871431),(-0.848531,-1.012004,-1.880538),(-0.643752,-0.991488,-1.916031),(-0.45376,-1.000266,-1.988054),(-0.263013,-1.037559,-2.098792),(-0.05591,-1.100053,-2.241914),(0.180105,-1.182196,-2.403331),(0.451955,-1.276688,-2.563164),(0.759274,-1.375134,-2.698621),(1.093949,-1.468785,-2.787336),(1.440945,-1.549322,-2.810667),(1.780294,-1.609588,-2.756434),(2.089928,-1.644227,-2.620687),(2.348928,-1.650163,-2.408237),(2.540658,-1.626867,-2.131865),(2.655308,-1.57641,-1.810358),(2.691427,-1.503274,-1.465673),(2.656203,-1.413959,-1.119684),(2.564438,-1.316401,-0.791024),(2.436361,-1.219267,-0.492521),(2.294626,-1.131189,-0.229612),(2.160942,-1.059993,0.0),(1.974495,-1.230712,0.0),(1.907734,-1.195038,0.190898),(1.877901,-1.194182,0.379626),(1.882954,-1.22822,0.580814),(1.913202,-1.294128,0.806482),(1.95291,-1.386049,1.063498),(1.982819,-1.495815,1.351863),(1.983214,-1.613675,1.664114),(1.937029,-1.729154,1.985937),(1.832537,-1.831993,2.297929),(1.665189,-1.913054,2.578217),(1.438325,-1.965133,2.805557),(1.162661,-1.983605,2.962412),(0.854632,-1.966826,3.037542),(0.533864,-1.916289,3.027694),(0.220182,-1.836484,2.938127),(-0.069376,-1.734501,2.781884),(-0.323056,-1.619402,2.577927),(-0.536008,-1.501415,2.348404),(-0.710763,-1.391023,2.11548),(-0.856507,-1.298034,1.898214),(-0.987248,-1.230712,1.709963),(-1.119189,-1.195038,1.556698),(-1.267716,-1.194182,1.436497),(-1.444477,-1.22822,1.340279),(-1.655035,-1.294128,1.25364),(-1.897471,-1.386049,1.15952),(-2.162158,-1.495815,1.04124),(-2.432772,-1.613675,0.885456),(-2.688386,-1.729154,0.684547),(-2.906333,-1.831993,0.438059),(-3.065395,-1.913054,0.152988),(-3.148846,-1.965133,-0.157152),(-3.146855,-1.983605,-0.474312),(-3.057905,-1.966826,-0.778638),(-2.888992,-1.916289,-1.051507),(-2.654583,-1.836484,-1.27838),(-2.374494,-1.734501,-1.451023),(-2.071022,-1.619402,-1.568738),(-1.765773,-1.501415,-1.638398),(-1.476677,-1.391023,-1.673279),(-1.215648,-1.298034,-1.690864),(-0.987248,-1.230712,-1.709963),(-0.788545,-1.195038,-1.747595),(-0.610185,-1.194182,-1.816123),(-0.438477,-1.22822,-1.921093),(-0.258167,-1.294128,-2.060123),(-0.055439,-1.386049,-2.223018),(0.179338,-1.495815,-2.393104),(0.449558,-1.613675,-2.54957),(0.751358,-1.729154,-2.670485),(1.073796,-1.831993,-2.735988),(1.400207,-1.913054,-2.731204),(1.710521,-1.965133,-2.648404),(1.984194,-1.983605,-2.4881),(2.203273,-1.966826,-2.258904),(2.355128,-1.916289,-1.976187),(2.434401,-1.836484,-1.659747),(2.44387,-1.734501,-1.330861),(2.394078,-1.619402,-1.009189),(2.301781,-1.501415,-0.710005),(2.187441,-1.391023,-0.442201),(2.072155,-1.298034,-0.20735),(1.974495,-1.230712,0.0),(1.798178,-1.391894,0.0),(1.771024,-1.377721,0.177218),(1.77823,-1.404296,0.359477),(1.813798,-1.469259,0.559482),(1.865239,-1.566836,0.786264),(1.915559,-1.688358,1.043158),(1.945922,-1.823027,1.326707),(1.938598,-1.958877,1.626677),(1.87972,-2.083837,1.927182),(1.761432,-2.186804,2.208766),(1.5831,-2.258628,2.451118),(1.351396,-2.292929,2.635996),(1.07926,-2.286657,2.74991),(0.783899,-2.240371,2.786143),(0.484156,-2.158183,2.745785),(0.197662,-2.047396,2.637622),(-0.06177,-1.917854,2.476893),(-0.286108,-1.781067,2.283091),(-0.474098,-1.649189,2.077158),(-0.63114,-1.533938,1.878493),(-0.76808,-1.445555,1.702241),(-0.899089,-1.391894,1.557268),(-1.038987,-1.377721,1.445143),(-1.200431,-1.404296,1.360254),(-1.391425,-1.469259,1.291054),(-1.613544,-1.566836,1.222212),(-1.86118,-1.688358,1.137344),(-2.121923,-1.823027,1.021864),(-2.378043,-1.958877,0.865537),(-2.608849,-2.083837,0.664294),(-2.793563,-2.186804,0.421062),(-2.91428,-2.258628,0.145446),(-2.958537,-2.292929,-0.147654),(-2.921123,-2.286657,-0.440288),(-2.804821,-2.240371,-0.714195),(-2.619997,-2.158183,-0.953601),(-2.383079,-2.047396,-1.14763),(-2.114167,-1.917854,-1.291941),(-1.834161,-1.781067,-1.389323),(-1.561823,-1.649189,-1.44916),(-1.311253,-1.533938,-1.48583),(-1.090143,-1.445555,-1.516297),(-0.899089,-1.391894,-1.557268),(-0.732037,-1.377721,-1.622361),(-0.577799,-1.404296,-1.719731),(-0.422373,-1.469259,-1.850536),(-0.251695,-1.566836,-2.008476),(-0.054378,-1.688358,-2.180501),(0.176001,-1.823027,-2.348572),(0.439445,-1.958877,-2.492214),(0.729128,-2.083837,-2.591476),(1.032131,-2.186804,-2.629828),(1.33118,-2.258628,-2.596563),(1.607141,-2.292929,-2.488341),(1.841862,-2.286657,-2.309622),(2.020921,-2.240371,-2.071948),(2.135841,-2.158183,-1.792184),(2.185416,-2.047396,-1.489992),(2.175937,-1.917854,-1.184952),(2.120269,-1.781067,-0.893768),(2.035921,-1.649189,-0.627998),(1.942393,-1.533938,-0.392663),(1.858224,-1.445555,-0.185943),(1.798178,-1.391894,0.0),(1.631481,-1.550839,0.0),(1.639299,-1.566052,0.164037),(1.676395,-1.625767,0.338891),(1.733755,-1.72468,0.534793),(1.797253,-1.854,0.757606),(1.849844,-2.002237,1.007371),(1.874192,-2.15622,1.277803),(1.855347,-2.302266,1.556821),(1.783034,-2.4274,1.828054),(1.653224,-2.520501,2.073077),(1.468731,-2.573298,2.274041),(1.238756,-2.581099,2.416282),(0.977454,-2.543212,2.490513),(0.701768,-2.463002,2.494233),(0.428854,-2.347597,2.432151),(0.173525,-2.207251,2.315534),(-0.053882,-2.054434,2.160591),(-0.248894,-1.902725,1.986131),(-0.413313,-1.765603,1.810844),(-0.554589,-1.655253,1.65065),(-0.684265,-1.58148,1.516487),(-0.815741,-1.550839,1.412904),(-0.961709,-1.566052,1.337656),(-1.131685,-1.625767,1.282355),(-1.330021,-1.72468,1.234079),(-1.554732,-1.854,1.177664),(-1.797331,-2.002237,1.098326),(-2.043705,-2.15622,0.984197),(-2.275919,-2.302266,0.828367),(-2.474658,-2.4274,0.630125),(-2.62195,-2.520501,0.395195),(-2.703743,-2.573298,0.134938),(-2.71194,-2.581099,-0.135347),(-2.645575,-2.543212,-0.398756),(-2.510954,-2.463002,-0.639367),(-2.320731,-2.347597,-0.844677),(-2.092074,-2.207251,-1.00749),(-1.844186,-2.054434,-1.126959),(-1.595592,-1.902725,-1.208614),(-1.36158,-1.765603,-1.263362),(-1.15221,-1.655253,-1.305613),(-0.971184,-1.58148,-1.350834),(-0.815741,-1.550839,-1.412904),(-0.67759,-1.566052,-1.501693),(-0.54471,-1.625767,-1.621246),(-0.403733,-1.72468,-1.768872),(-0.242521,-1.854,-1.93527),(-0.052513,-2.002237,-2.105697),(0.169513,-2.15622,-2.261999),(0.420573,-2.302266,-2.385188),(0.691624,-2.4274,-2.458179),(0.968726,-2.520501,-2.468273),(1.235012,-2.573298,-2.408979),(1.473184,-2.581099,-2.280935),(1.66812,-2.543212,-2.091757),(1.809185,-2.463002,-1.854866),(1.891878,-2.347597,-1.587474),(1.918548,-2.207251,-1.308044),(1.898068,-2.054434,-1.033633),(1.844487,-1.902725,-0.777516),(1.774894,-1.765603,-0.547482),(1.706799,-1.655253,-0.345037),(1.655449,-1.58148,-0.165653),(1.631481,-1.550839,0.0),(1.471222,-1.713768,0.0),(1.506955,-1.764159,0.150794),(1.565142,-1.860053,0.3164),(1.634865,-1.99293,0.504289),(1.70156,-2.150984,0.717268),(1.749242,-2.32017,0.952587),(1.762941,-2.485456,1.201953),(1.730978,-2.632155,1.452463),(1.646737,-2.747233,1.688316),(1.509649,-2.820464,1.89304),(1.325248,-2.845341,2.051885),(1.104301,-2.819655,2.154018),(0.861143,-2.745686,2.194157),(0.6115,-2.630008,2.173402),(0.370131,-2.4829,2.099117),(0.148672,-2.317432,1.983887),(-0.045979,-2.148306,1.843687),(-0.212483,-1.990552,1.695571),(-0.354965,-1.858185,1.555204),(-0.482016,-1.762967,1.434648),(-0.60495,-1.713359,1.340707),(-0.735611,-1.713768,1.274115),(-0.884068,-1.764159,1.229664),(-1.056582,-1.860053,1.197253),(-1.25416,-1.99293,1.16369),(-1.471952,-2.150984,1.11496),(-1.699585,-2.32017,1.038595),(-1.922392,-2.485456,0.925775),(-2.123359,-2.632155,0.772839),(-2.285493,-2.747233,0.581958),(-2.394245,-2.820464,0.360874),(-2.439609,-2.845341,0.121756),(-2.417585,-2.819655,-0.120657),(-2.330767,-2.745686,-0.351307),(-2.187971,-2.630008,-0.557126),(-2.002954,-2.4829,-0.729016),(-1.792432,-2.317432,-0.86319),(-1.573691,-2.148306,-0.961662),(-1.362166,-1.990552,-1.031801),(-1.169364,-1.858185,-1.085011),(-1.001433,-1.762967,-1.134762),(-0.858611,-1.713359,-1.194255),(-0.735611,-1.713768,-1.274115),(-0.622886,-1.764159,-1.380458),(-0.50856,-1.860053,-1.513653),(-0.380705,-1.99293,-1.667979),(-0.229608,-2.150984,-1.832228),(-0.049657,-2.32017,-1.991182),(0.159451,-2.485456,-2.127728),(0.392381,-2.632155,-2.225302),(0.638756,-2.747233,-2.270274),(0.884596,-2.820464,-2.253914),(1.114361,-2.845341,-2.173641),(1.313284,-2.819655,-2.033362),(1.469624,-2.745686,-1.84285),(1.576471,-2.630008,-1.616276),(1.632823,-2.4829,-1.370101),(1.64376,-2.317432,-1.120697),(1.619669,-2.148306,-0.882025),(1.574649,-1.990552,-0.66377),(1.524329,-1.858185,-0.470193),(1.483449,-1.762967,-0.299886),(1.463561,-1.713359,-0.146451),(1.471222,-1.713768,0.0),(1.312024,-1.885036,0.0),(1.366908,-1.973698,0.13678),(1.436601,-2.105773,0.290415),(1.509459,-2.269527,0.465606),(1.57161,-2.450409,0.662489),(1.609048,-2.632346,0.876241),(1.609746,-2.799173,1.097506),(1.56546,-2.936067,1.313577),(1.472961,-3.030863,1.510152),(1.334493,-3.075139,1.673401),(1.157401,-3.064961,1.792007),(0.952988,-3.001233,1.858871),(0.734786,-2.889618,1.872204),(0.516525,-2.740033,1.835839),(0.310106,-2.565769,1.758697),(0.123913,-2.38231,1.6535),(-0.038278,-2.205958,1.534915),(-0.177625,-2.052383,1.417414),(-0.299727,-1.935229,1.313188),(-0.4134,-1.864907,1.230423),(-0.528921,-1.847665,1.172208),(-0.656012,-1.885036,1.136246),(-0.801909,-1.973698,1.115387),(-0.969807,-2.105773,1.098925),(-1.157956,-2.269527,1.074426),(-1.359537,-2.450409,1.029809),(-1.563371,-2.632346,0.955356),(-1.755341,-2.799173,0.845328),(-1.920321,-2.936067,0.69894),(-2.04431,-3.030863,0.520545),(-2.116454,-3.075139,0.319004),(-2.130624,-3.064961,0.106335),(-2.086323,-3.001233,-0.104124),(-1.98877,-2.889618,-0.299759),(-1.848146,-2.740033,-0.470596),(-1.678129,-2.565769,-0.610789),(-1.49393,-2.38231,-0.719439),(-1.310136,-2.205958,-0.800608),(-1.138704,-2.052383,-0.862535),(-0.987391,-1.935229,-0.916165),(-0.858877,-1.864907,-0.973226),(-0.750702,-1.847665,-1.044163),(-0.656012,-1.885036,-1.136246),(-0.564999,-1.973698,-1.252167),(-0.466794,-2.105773,-1.389341),(-0.351502,-2.269527,-1.540033),(-0.212073,-2.450409,-1.692298),(-0.045677,-2.632346,-1.831597),(0.145595,-2.799173,-1.942834),(0.354861,-2.936067,-2.012516),(0.57135,-3.030863,-2.030697),(0.781961,-3.075139,-1.992405),(0.973223,-3.064961,-1.898342),(1.133336,-3.001233,-1.754747),(1.253984,-2.889618,-1.572446),(1.331621,-2.740033,-1.365243),(1.368023,-2.565769,-1.147908),(1.370017,-2.38231,-0.934062),(1.348415,-2.205958,-0.734307),(1.316329,-2.052383,-0.554879),(1.287118,-1.935229,-0.397023),(1.272277,-1.864907,-0.257196),(1.279623,-1.847665,-0.128046),(1.312024,-1.885036,0.0),(1.147019,-2.066533,0.0),(1.211442,-2.1935,0.121223),(1.283191,-2.358633,0.259403),(1.351031,-2.54726,0.416738),(1.402743,-2.74262,0.591306),(1.426947,-2.927356,0.777074),(1.414804,-3.085051,0.964597),(1.361326,-3.201695,1.142288),(1.266106,-3.266922,1.298074),(1.133342,-3.274938,1.421165),(0.971178,-3.22503,1.503678),(0.790452,-3.121632,1.541834),(0.603056,-2.973933,1.536563),(0.420177,-2.795054,1.493398),(0.250681,-2.600892,1.421681),(0.099909,-2.408698,1.333198),(-0.030935,-2.235549,1.240445),(-0.144716,-2.09683,1.154803),(-0.247619,-2.004867,1.084892),(-0.347862,-1.967831,1.03536),(-0.454058,-1.989014,1.006296),(-0.57351,-2.066533,0.993348),(-0.710703,-2.1935,0.988528),(-0.866245,-2.358633,0.981575),(-1.036421,-2.54726,0.961659),(-1.213458,-2.74262,0.919158),(-1.38644,-2.927356,0.847236),(-1.542768,-3.085051,0.742958),(-1.669914,-3.201695,0.607799),(-1.757218,-3.266922,0.447443),(-1.797436,-3.274938,0.27092),(-1.787812,-3.22503,0.089226),(-1.730493,-3.121632,-0.086365),(-1.632231,-2.973933,-0.246019),(-1.503409,-2.795054,-0.382815),(-1.356552,-2.600892,-0.493745),(-1.204538,-2.408698,-0.580075),(-1.058789,-2.235549,-0.647013),(-0.927731,-2.09683,-0.702729),(-0.815734,-2.004867,-0.756891),(-0.722717,-1.967831,-0.818938),(-0.644449,-1.989014,-0.896374),(-0.57351,-2.066533,-0.993348),(-0.500739,-2.1935,-1.109751),(-0.416946,-2.358633,-1.240977),(-0.31461,-2.54726,-1.378397),(-0.189286,-2.74262,-1.510464),(-0.040508,-2.927356,-1.62431),(0.127964,-3.085051,-1.707555),(0.308588,-3.201695,-1.750088),(0.491112,-3.266922,-1.745517),(0.664095,-3.274938,-1.692085),(0.816634,-3.22503,-1.592904),(0.940041,-3.121632,-1.455469),(1.029174,-2.973933,-1.290544),(1.083232,-2.795054,-1.110583),(1.105872,-2.600892,-0.927936),(1.104629,-2.408698,-0.753123),(1.089724,-2.235549,-0.593432),(1.072447,-2.09683,-0.452074),(1.063354,-2.004867,-0.328001),(1.070579,-1.967831,-0.216422),(1.098507,-1.989014,-0.109922),(1.147019,-2.066533,0.0),(0.968698,-2.257333,0.0),(1.033126,-2.41949,0.10338),(1.098515,-2.611625,0.22207),(1.155027,-2.816667,0.356278),(1.192793,-3.016395,0.502804),(1.203384,-3.193064,0.655328),(1.181054,-3.330975,0.805229),(1.123577,-3.417875,0.942793),(1.032562,-3.446042,1.058633),(0.913177,-3.412973,1.145088),(0.773353,-3.321607,1.197385),(0.622578,-3.180062,1.214383),(0.470484,-3.000915,1.198774),(0.325445,-2.800083,1.156699),(0.193406,-2.595413,1.096858),(0.077129,-2.405088,1.029219),(-0.024029,-2.246022,0.963544),(-0.113782,-2.132347,0.90796),(-0.198064,-2.074163,0.867777),(-0.283822,-2.076642,0.844752),(-0.377627,-2.139562,0.836907),(-0.484349,-2.257333,0.838917),(-0.606092,-2.41949,0.843023),(-0.741576,-2.611625,0.840307),(-0.886059,-2.816667,0.822143),(-1.031838,-3.016395,0.781587),(-1.169223,-3.193064,0.714497),(-1.287875,-3.330975,0.620208),(-1.378271,-3.417875,0.50165),(-1.433084,-3.446042,0.364908),(-1.448263,-3.412973,0.218291),(-1.423642,-3.321607,0.071051),(-1.362976,-3.180062,-0.068023),(-1.27341,-3.000915,-0.191936),(-1.164453,-2.800083,-0.296506),(-1.04661,-2.595413,-0.380935),(-0.929894,-2.405088,-0.447813),(-0.822439,-2.246022,-0.502582),(-0.729426,-2.132347,-0.552518),(-0.652485,-2.074163,-0.605417),(-0.589666,-2.076642,-0.668173),(-0.535969,-2.139562,-0.745488),(-0.484349,-2.257333,-0.838917),(-0.427033,-2.41949,-0.946403),(-0.35694,-2.611625,-1.062377),(-0.268967,-2.816667,-1.178422),(-0.160955,-3.016395,-1.284391),(-0.034161,-3.193064,-1.369826),(0.106822,-3.330975,-1.425437),(0.254694,-3.417875,-1.444443),(0.400522,-3.446042,-1.423541),(0.535087,-3.412973,-1.363378),(0.650289,-3.321607,-1.268436),(0.740398,-3.180062,-1.14636),(0.802926,-3.000915,-1.006838),(0.839009,-2.800083,-0.860193),(0.853204,-2.595413,-0.715924),(0.852765,-2.405088,-0.581405),(0.846468,-2.246022,-0.460962),(0.843208,-2.132347,-0.355442),(0.850549,-2.074163,-0.26236),(0.873488,-2.076642,-0.176579),(0.913596,-2.139562,-0.091419),(0.968698,-2.257333,0.0),(0.769827,-2.453616,0.0),(0.825719,-2.6449,0.082626),(0.878158,-2.855511,0.177524),(0.919447,-3.066736,0.283612),(0.942459,-3.259807,0.39728),(0.94169,-3.417568,0.512817),(0.91406,-3.526001,0.623195),(0.859357,-3.575472,0.721087),(0.780248,-3.561585,0.799949),(0.681852,-3.485574,0.855015),(0.570967,-3.354193,0.88403),(0.455049,-3.179115,0.887606),(0.341117,-2.975898,0.869151),(0.234756,-2.762597,0.834374),(0.139375,-2.558166,0.790436),(0.055821,-2.380769,0.744882),(-0.01757,-2.246168,0.704521),(-0.084515,-2.166324,0.674414),(-0.149989,-2.148331,0.657144),(-0.219216,-2.193788,0.652464),(-0.296623,-2.298656,0.657385),(-0.384913,-2.453616,0.66669),(-0.484415,-2.6449,0.673781),(-0.592819,-2.855511,0.671746),(-0.705339,-3.066736,0.654459),(-0.815284,-3.259807,0.617554),(-0.914957,-3.417568,0.559119),(-0.996733,-3.526001,0.480001),(-1.054158,-3.575472,0.383682),(-1.0829,-3.561585,0.27574),(-1.081391,-3.485574,0.162993),(-1.051077,-3.354193,0.052457),(-0.996214,-3.179115,-0.049719),(-0.923265,-2.975898,-0.13916),(-0.839967,-2.762597,-0.213882),(-0.754225,-2.558166,-0.274516),(-0.672998,-2.380769,-0.324099),(-0.601348,-2.246168,-0.367476),(-0.541802,-2.166324,-0.410399),(-0.494109,-2.148331,-0.458466),(-0.455442,-2.193788,-0.516079),(-0.421001,-2.298656,-0.585576),(-0.384913,-2.453616,-0.66669),(-0.341304,-2.6449,-0.756406),(-0.285339,-2.855511,-0.849269),(-0.214108,-3.066736,-0.93807),(-0.127175,-3.259807,-1.014833),(-0.026732,-3.417568,-1.071935),(0.082673,-3.526001,-1.103196),(0.194801,-3.575472,-1.104769),(0.302652,-3.561585,-1.075689),(0.399539,-3.485574,-1.018009),(0.480109,-3.354193,-0.936488),(0.541165,-3.179115,-0.837887),(0.582149,-2.975898,-0.729991),(0.605211,-2.762597,-0.620492),(0.61485,-2.558166,-0.51592),(0.617176,-2.380769,-0.420784),(0.618918,-2.246168,-0.337045),(0.626317,-2.166324,-0.264015),(0.644097,-2.148331,-0.198678),(0.674658,-2.193788,-0.136385),(0.717624,-2.298656,-0.071809),(0.769827,-2.453616,0.0),(0.544358,-2.648877,0.0),(0.584976,-2.860741,0.058536),(0.62031,-3.079521,0.125398),(0.645246,-3.285779,0.199032),(0.655439,-3.461188,0.276291),(0.647949,-3.590162,0.352854),(0.621665,-3.661241,0.423844),(0.577456,-3.668109,0.484543),(0.518026,-3.610156,0.531106),(0.447499,-3.492531,0.561147),(0.370801,-3.325686,0.574112),(0.292928,-3.124447,0.571378),(0.218233,-2.906693,0.556049),(0.149822,-2.691773,0.532498),(0.089171,-2.498784,0.505712),(0.036011,-2.344873,0.480536),(-0.011495,-2.243717,0.460952),(-0.056327,-2.204304,0.44948),(-0.101982,-2.230135,0.446814),(-0.151775,-2.318915,0.451734),(-0.208156,-2.462756,0.461322),(-0.272179,-2.648877,0.471428),(-0.343181,-2.860741,0.477336),(-0.418753,-3.079521,0.474505),(-0.494989,-3.285779,0.459283),(-0.566994,-3.461188,0.429481),(-0.629555,-3.590162,0.384713),(-0.677893,-3.661241,0.326456),(-0.708355,-3.668109,0.25782),(-0.718964,-3.610156,0.183071),(-0.709717,-3.492531,0.106973),(-0.682596,-3.325686,0.034067),(-0.641292,-3.124447,-0.032006),(-0.590669,-2.906693,-0.089029),(-0.536068,-2.691773,-0.1365),(-0.482544,-2.498784,-0.175632),(-0.434162,-2.344873,-0.209082),(-0.393449,-2.243717,-0.240431),(-0.361098,-2.204304,-0.273521),(-0.335961,-2.230135,-0.311726),(-0.315326,-2.318915,-0.357308),(-0.295438,-2.462756,-0.410929),(-0.272179,-2.648877,-0.471428),(-0.241795,-2.860741,-0.535872),(-0.201557,-3.079521,-0.599903),(-0.150256,-3.285779,-0.658315),(-0.088445,-3.461188,-0.705772),(-0.018394,-3.590162,-0.737568),(0.056227,-3.661241,-0.7503),(0.130899,-3.668109,-0.742363),(0.200938,-3.610156,-0.714177),(0.262217,-3.492531,-0.668119),(0.311795,-3.325686,-0.608179),(0.348364,-3.124447,-0.539372),(0.372436,-2.906693,-0.46702),(0.386246,-2.691773,-0.395998),(0.393374,-2.498784,-0.33008),(0.398151,-2.344873,-0.271455),(0.404944,-2.243717,-0.220521),(0.417425,-2.204304,-0.175959),(0.437943,-2.230135,-0.135088),(0.4671,-2.318915,-0.094426),(0.503594,-2.462756,-0.050392),(0.544358,-2.648877,0.0),(0.288231,-2.834409,0.0),(0.309272,-3.056512,0.030947),(0.326155,-3.272226,0.065934),(0.336448,-3.462384,0.10378),(0.338283,-3.610089,0.142598),(0.330632,-3.702218,0.180052),(0.313445,-3.730584,0.213703),(0.287655,-3.692667,0.241372),(0.255034,-3.591835,0.261473),(0.217918,-3.437049,0.273261),(0.17887,-3.242061,0.276944),(0.140299,-3.024198,0.273663),(0.104129,-2.802817,0.265316),(0.071542,-2.597588,0.254276),(0.042852,-2.426749,0.243027),(0.01752,-2.305477,0.233789),(-0.00569,-2.244549,0.228177),(-0.028442,-2.249379,0.226964),(-0.052487,-2.319537,0.22996),(-0.079309,-2.448789,0.236051),(-0.109815,-2.625651,0.243374),(-0.144116,-2.834409,0.249616),(-0.181437,-3.056512,0.252364),(-0.220178,-3.272226,0.249492),(-0.2581,-3.462384,0.239482),(-0.292635,-3.610089,0.221663),(-0.321246,-3.702218,0.196309),(-0.341795,-3.730584,0.1646),(-0.352862,-3.692667,0.128431),(-0.353959,-3.591835,0.090129),(-0.34561,-3.437049,0.052092),(-0.329276,-3.242061,0.016433),(-0.307149,-3.024198,-0.015329),(-0.281835,-2.802817,-0.04248),(-0.255981,-2.597588,-0.065181),(-0.231894,-2.426749,-0.084402),(-0.211227,-2.305477,-0.101721),(-0.194762,-2.244549,-0.119017),(-0.182336,-2.249379,-0.138114),(-0.172908,-2.319537,-0.160435),(-0.164771,-2.448789,-0.186709),(-0.155861,-2.625651,-0.21679),(-0.144116,-2.834409,-0.249616),(-0.127835,-3.056512,-0.283311),(-0.105977,-3.272226,-0.315426),(-0.078347,-3.462384,-0.343262),(-0.045648,-3.610089,-0.364261),(-0.009386,-3.702218,-0.376362),(0.02835,-3.730584,-0.378303),(0.065206,-3.692667,-0.369803),(0.098926,-3.591835,-0.351602),(0.127692,-3.437049,-0.325353),(0.150406,-3.242061,-0.293378),(0.16685,-3.024198,-0.258334),(0.177706,-2.802817,-0.222837),(0.184439,-2.597588,-0.189095),(0.189042,-2.426749,-0.158625),(0.193707,-2.305477,-0.132067),(0.200453,-2.244549,-0.109161),(0.210778,-2.249379,-0.08885),(0.225395,-2.319537,-0.069525),(0.24408,-2.448789,-0.049342),(0.265676,-2.625651,-0.026585),(0.288231,-2.834409,0.0),(0.0,-3.0,0.0),(0.0,-3.221066,0.0),(0.0,-3.42249,0.0),(0.0,-3.586374,0.0),(0.0,-3.698155,0.0),(0.0,-3.747903,0.0),(0.0,-3.731196,0.0),(0.0,-3.649519,0.0),(0.0,-3.51013,0.0),(0.0,-3.325413,0.0),(0.0,-3.111782,0.0),(0.0,-2.888218,0.0),(0.0,-2.674587,0.0),(0.0,-2.48987,0.0),(0.0,-2.350481,0.0),(0.0,-2.268804,0.0),(0.0,-2.252097,0.0),(0.0,-2.301845,0.0),(0.0,-2.413626,0.0),(0.0,-2.57751,0.0),(0.0,-2.778934,0.0),(0.0,-3.0,0.0),(0.0,-3.221066,0.0),(0.0,-3.42249,0.0),(0.0,-3.586374,0.0),(0.0,-3.698155,0.0),(0.0,-3.747903,0.0),(0.0,-3.731196,0.0),(0.0,-3.649519,0.0),(0.0,-3.51013,0.0),(0.0,-3.325413,0.0),(0.0,-3.111782,0.0),(0.0,-2.888218,0.0),(0.0,-2.674587,0.0),(0.0,-2.48987,0.0),(0.0,-2.350481,0.0),(0.0,-2.268804,0.0),(0.0,-2.252097,0.0),(0.0,-2.301845,0.0),(0.0,-2.413626,0.0),(0.0,-2.57751,0.0),(0.0,-2.778934,0.0),(0.0,-3.0,0.0),(0.0,-3.221066,0.0),(0.0,-3.42249,0.0),(0.0,-3.586374,0.0),(0.0,-3.698155,0.0),(0.0,-3.747903,0.0),(0.0,-3.731196,0.0),(0.0,-3.649519,0.0),(0.0,-3.51013,0.0),(0.0,-3.325413,0.0),(0.0,-3.111782,0.0),(0.0,-2.888218,0.0),(0.0,-2.674587,0.0),(0.0,-2.48987,0.0),(0.0,-2.350481,0.0),(0.0,-2.268804,0.0),(0.0,-2.252097,0.0),(0.0,-2.301845,0.0),(0.0,-2.413626,0.0),(0.0,-2.57751,0.0),(0.0,-2.778934,0.0),(0.0,-3.0,0.0)])))]),
    ProximitySensor(DEF='Proximity',size=(1000.0,1000.0,1000.0)),
    Transform(DEF='Panel',
      children=[
      Transform(translation=(0.0,0.75,-2.75),
        children=[
        Shape(
          appearance=Appearance(),
          geometry=IndexedFaceSet(colorIndex=[0,0,1,1],coordIndex=[0,1,2,3],solid=False,
            coord=Coordinate(point=[(-2.5,0.0,0.0),(2.5,0.0,0.0),(2.5,0.4,0.0),(-2.5,0.4,0.0)]),
            color=Color(color=[(0.0,0.1,0.3),(0.7,0.7,0.8)]))),
        Transform(translation=(-1.35,0.15,0.05),
          children=[
          Shape(
            appearance=Appearance(),
            geometry=Text(string=["Vis-o-rama"],
              fontStyle=FontStyle(justify=["MIDDLE","MIDDLE"],size=0.125,style_='BOLDITALIC')))]),
        Transform(translation=(1.2,0.075,0.005),
          children=[
          Shape(
            appearance=Appearance(),
            geometry=IndexedFaceSet(colorIndex=[1,1,0,0],coordIndex=[0,1,2,3],solid=False,
              coord=Coordinate(point=[(0.0,0.0,0.0),(0.475,0.0,0.0),(0.475,0.275,0.0),(0.0,0.275,0.0)]),
              color=Color(color=[(0.1,0.1,0.1),(0.3,0.3,0.3)]))),
          Transform(translation=(0.025,0.035,0.005),
            children=[
            TouchSensor(DEF='Start'),
            Shape(
              appearance=Appearance(
                texture=ImageTexture(repeatS=False,repeatT=False,url=["start.jpg","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/start.jpg"])),
              geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,texCoordIndex=[0,1,2,3],
                texCoord=TextureCoordinate(point=[(0.0,0.0),(1.0,0.0),(1.0,1.0),(0.0,1.0)]),
                coord=Coordinate(point=[(0.0,0.0,0.01),(0.2,0.0,0.01),(0.2,0.2,0.01),(0.0,0.2,0.01)])))]),
          Transform(translation=(0.25,0.035,0.005),
            children=[
            TouchSensor(DEF='Stop'),
            Shape(
              appearance=Appearance(
                texture=ImageTexture(repeatS=False,repeatT=False,url=["stop.jpg","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/stop.jpg"])),
              geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,texCoordIndex=[0,1,2,3],
                texCoord=TextureCoordinate(point=[(0.0,0.0),(1.0,0.0),(1.0,1.0),(0.0,1.0)]),
                coord=Coordinate(point=[(0.0,0.0,0.0),(0.2,0.0,0.0),(0.2,0.2,0.0),(0.0,0.2,0.0)])))])]),
        Transform(scale=(1.0,1.0,0.1),translation=(0.0,0.2,0.05),
          children=[
          CylinderSensor(DEF='ThumbWheel'),
          Shape(
            appearance=Appearance(),
            geometry=IndexedFaceSet(colorIndex=[1,1,0,0],coordIndex=[0,1,2,3],solid=False,
              coord=Coordinate(point=[(-1.025,-0.1375,0.0),(1.025,-0.1375,0.0),(1.025,0.1375,0.0),(-1.025,0.1375,0.0)]),
              color=Color(color=[(0.1,0.1,0.1),(0.3,0.3,0.3)]))),
          Transform(DEF='Wheel',translation=(0.0,-0.02,0.0),
            children=[
            Shape(
              appearance=Appearance(
                textureTransform=TextureTransform(scale=(16.0,1.0),translation=(0.5,0.5)),
                texture=ImageTexture(USE='Grill')),
              geometry=Cylinder(bottom=False,height=0.125,top=False)),
            Shape(
              appearance=Appearance(
                material=Material(ambientIntensity=0.0,diffuseColor=(0.0,0.0,0.0),emissiveColor=(0.1,0.1,0.1))),
              geometry=Cylinder(height=0.125,side=False,top=False))])])])]),
    TimeSensor(DEF='Clock',cycleInterval=10.0,loop=True,stopTime=1.0),
    OrientationInterpolator(DEF='Turner',key=[0.0,0.5,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.1415),(0.0,1.0,0.0,6.28)]),
    ROUTE(fromField='rotation_changed',fromNode='ThumbWheel',toField='set_rotation',toNode='Wheel'),
    ROUTE(fromField='rotation_changed',fromNode='ThumbWheel',toField='set_rotation',toNode='Blob'),
    ROUTE(fromField='position_changed',fromNode='Proximity',toField='set_translation',toNode='Panel'),
    ROUTE(fromField='orientation_changed',fromNode='Proximity',toField='set_rotation',toNode='Panel'),
    ROUTE(fromField='touchTime',fromNode='Start',toField='set_startTime',toNode='Clock'),
    ROUTE(fromField='touchTime',fromNode='Stop',toField='set_stopTime',toNode='Clock'),
    ROUTE(fromField='fraction_changed',fromNode='Clock',toField='set_fraction',toNode='Turner'),
    ROUTE(fromField='value_changed',fromNode='Turner',toField='set_rotation',toNode='Blob'),
    ROUTE(fromField='value_changed',fromNode='Turner',toField='set_rotation',toNode='Wheel')])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for HeadsUpDisplayHUD.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python HeadsUpDisplayHUD.py load and self-test diagnostics complete.")
