####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python ExtrusionSpiral.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    meta(content='ExtrusionSpiral.x3d',name='title'),
    meta(content='Supporting geometry for animation in ExtrusionSpiralMotion.',name='description'),
    meta(content='David R. Nadeau',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='1 July 1998',name='created'),
    meta(content='2 February 2014',name='translated'),
    meta(content='20 October 2019',name='modified'),
    meta(content='originals/espiral.wrl',name='reference'),
    meta(content='ExtrusionSpiralMotion.x3d',name='reference'),
    meta(content='http://www.siggraph.org/s98',name='reference'),
    meta(content='http://www.siggraph.org/s98/conference/courses/18.html',name='reference'),
    meta(content='http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0255.htm',name='reference'),
    meta(content='http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/vrml97.htm',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/X3dResources.html',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Siggraph98Course/ExtrusionSpiral.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='ExtrusionSpiral.x3d'),
    Shape(
      appearance=Appearance(
        material=Material(diffuseColor=(0.75,0.0,0.0))),
      geometry=Extrusion(creaseAngle=0.785,crossSection=[(-0.5,0.1),(0.5,0.1),(0.5,-0.1),(-0.5,-0.1),(-0.5,0.1)],solid=False,spine=[(4.5,16.0,0.0),(4.519218,15.937255,0.705224),(4.426933,15.87451,1.415671),(4.222285,15.811765,2.113152),(3.907535,15.74902,2.779409),(3.488044,15.686275,3.396681),(2.972147,15.623529,3.948261),(2.37093,15.560784,4.419013),(1.697899,15.498039,4.795848),(0.968577,15.435294,5.068115),(0.200033,15.372549,5.227915),(-0.589644,15.309804,5.270316),(-1.381887,15.247059,5.193465),(-2.158203,15.184314,4.998591),(-2.900711,15.121569,4.689915),(-3.59264,15.058824,4.274449),(-4.218781,14.996078,3.761724),(-4.765862,14.933333,3.16344),(-5.222854,14.870588,2.493058),(-5.58119,14.807843,1.765356),(-5.834888,14.745098,0.995971),(-5.980592,14.682353,0.200924),(-6.017533,14.619608,-0.603825),(-5.9474,14.556863,-1.402801),(-5.774154,14.494118,-2.181397),(-5.503784,14.431373,-2.926199),(-5.144015,14.368627,-3.625256),(-4.703992,14.305882,-4.268284),(-4.193941,14.243137,-4.846807),(-3.624837,14.180392,-5.354229),(-3.008067,14.117647,-5.785853),(-2.355118,14.054902,-6.138834),(-1.677292,13.992157,-6.412097),(-0.985454,13.929412,-6.606203),(-0.289809,13.866667,-6.72319),(0.400263,13.803922,-6.766385),(1.076352,13.741176,-6.74021),(1.731104,13.678431,-6.64997),(2.35828,13.615686,-6.501656),(2.952774,13.552941,-6.301735),(3.510603,13.490196,-6.056975),(4.028864,13.427451,-5.774267),(4.505675,13.364706,-5.460474),(4.940095,13.301961,-5.122305),(5.33203,13.239216,-4.766201),(5.682133,13.176471,-4.398251),(5.991697,13.113725,-4.024127),(6.262547,13.05098,-3.649035),(6.496936,12.988235,-3.277692),(6.697444,12.92549,-2.914314),(6.866878,12.862745,-2.562615),(7.008193,12.8,-2.225831),(7.124401,12.737255,-1.906734),(7.218511,12.67451,-1.607673),(7.293459,12.611765,-1.330604),(7.352059,12.54902,-1.077135),(7.396953,12.486275,-0.848564),(7.43058,12.423529,-0.645923),(7.455139,12.360784,-0.470015),(7.472565,12.298039,-0.321455),(7.484512,12.235294,-0.2007),(7.492336,12.172549,-0.108082),(7.497083,12.109804,-0.043828),(7.499483,12.047059,-0.008087),(7.499943,11.984314,-9.33E-4),(7.498544,11.921569,-0.022383),(7.495041,11.858824,-0.072391),(7.488867,11.796078,-0.150847),(7.479132,11.733333,-0.257566),(7.464635,11.670588,-0.392269),(7.443868,11.607843,-0.554566),(7.415035,11.545098,-0.743926),(7.376066,11.482353,-0.959643),(7.324639,11.419608,-1.200805),(7.258209,11.356863,-1.466252),(7.174043,11.294118,-1.754536),(7.069259,11.231373,-2.063881),(6.940878,11.168627,-2.392139),(6.785881,11.105882,-2.736753),(6.601275,11.043137,-3.094724),(6.38417,10.980392,-3.46258),(6.131858,10.917647,-3.836355),(5.841913,10.854902,-4.211584),(5.512281,10.792157,-4.583302),(5.141391,10.729412,-4.946066),(4.728255,10.666667,-5.29399),(4.272582,10.603922,-5.620798),(3.774876,10.541176,-5.919903),(3.236538,10.478431,-6.184504),(2.659951,10.415686,-6.407707),(2.048552,10.352941,-6.582661),(1.406882,10.290196,-6.702728),(0.740614,10.227451,-6.761652),(0.056548,10.164706,-6.753763),(-0.637425,10.101961,-6.674169),(-1.332395,10.039216,-6.518971),(-2.01855,9.976471,-6.285461),(-2.685331,9.913725,-5.972319),(-3.321625,9.85098,-5.579783),(-3.916004,9.788235,-5.109798),(-4.456993,9.72549,-4.566128),(-4.93337,9.662745,-3.954416),(-5.334494,9.6,-3.282204),(-5.650635,9.537255,-2.558886),(-5.873318,9.47451,-1.7956),(-5.995646,9.411765,-1.005058),(-6.012612,9.34902,-0.201308),(-5.921362,9.286275,0.600565),(-5.721417,9.223529,1.384793),(-5.414829,9.160784,2.135331),(-5.006263,9.098039,2.836291),(-4.503007,9.035294,3.472408),(-3.91488,8.972549,4.029504),(-3.254064,8.909804,4.494945),(-2.534843,8.847059,4.85807),(-1.773258,8.784314,5.110564),(-0.986694,8.721569,5.246783),(-0.193405,8.658824,5.263984),(0.588012,8.596078,5.16247),(1.339159,8.533333,4.945643),(2.04239,8.470588,4.619938),(2.681347,8.407843,4.194662),(3.241459,8.345098,3.681731),(3.710384,8.282353,3.09531),(4.078376,8.219608,2.451384),(4.338564,8.156863,1.767254),(4.48713,8.094118,1.061),(4.523376,8.031373,0.350916),(4.449691,7.968627,-0.34505),(4.271404,7.905882,-1.00984),(3.996544,7.843137,-1.627781),(3.635507,7.780392,-2.185025),(3.200663,7.717647,-2.669906),(2.705892,7.654902,-3.073216),(2.166104,7.592157,-3.388378),(1.596733,7.529412,-3.61153),(1.013238,7.466667,-3.741503),(0.430638,7.403922,-3.779712),(-0.136923,7.341176,-3.729968),(-0.676549,7.278431,-3.598209),(-1.176898,7.215686,-3.392191),(-1.628415,7.152941,-3.121126),(-2.023492,7.090196,-2.795299),(-2.356543,7.027451,-2.42569),(-2.624009,6.964706,-2.023582),(-2.824297,6.901961,-1.600214),(-2.957656,6.839216,-1.16645),(-3.026001,6.776471,-0.732498),(-3.032706,6.713725,-0.307677),(-2.982364,6.65098,0.099766),(-2.880534,6.588235,0.482784),(-2.733483,6.52549,0.835601),(-2.547937,6.462745,1.153747),(-2.330841,6.4,1.434032),(-2.08914,6.337255,1.67449),(-1.829593,6.27451,1.874296),(-1.558611,6.211765,2.033647),(-1.282123,6.14902,2.153633),(-1.005481,6.086275,2.236099),(-0.733395,6.023529,2.283495),(-0.469888,5.960784,2.298737),(-0.218291,5.898039,2.285069),(0.018755,5.835294,2.245933),(0.239263,5.772549,2.184857),(0.441862,5.709804,2.105355),(0.625739,5.647059,2.010844),(0.790579,5.584314,1.904574),(0.936496,5.521569,1.789575),(1.063969,5.458824,1.668624),(1.173773,5.396078,1.544213),(1.266911,5.333333,1.418545),(1.344565,5.270588,1.293526),(1.408032,5.207843,1.170774),(1.458682,5.145098,1.051633),(1.497913,5.082353,0.937188),(1.527123,5.019608,0.828291),(1.547673,4.956863,0.725583),(1.560872,4.894118,0.629522),(1.567957,4.831373,0.540407),(1.570079,4.768627,0.458404),(1.568301,4.705882,0.38357),(1.563587,4.643137,0.315878),(1.556803,4.580392,0.255235),(1.548719,4.517647,0.201502),(1.540011,4.454902,0.154513),(1.531261,4.392157,0.114086),(1.522966,4.329412,0.080039),(1.515537,4.266667,0.052197),(1.509309,4.203922,0.030406),(1.50454,4.141176,0.014534),(1.501417,4.078431,0.004483),(1.500057,4.015686,1.87E-4),(1.500511,3.952941,0.001617),(1.502762,3.890196,0.008783),(1.506727,3.827451,0.021732),(1.512253,3.764706,0.040547),(1.519118,3.701961,0.065344),(1.527026,3.639216,0.096265),(1.535606,3.576471,0.133478),(1.544402,3.513725,0.177161),(1.552877,3.45098,0.227497),(1.560401,3.388235,0.284664),(1.566253,3.32549,0.348814),(1.569615,3.262745,0.420067),(1.56957,3.2,0.498484),(1.565107,3.137255,0.584054),(1.555116,3.07451,0.676669),(1.538403,3.011765,0.776097),(1.513694,2.94902,0.881966),(1.47965,2.886275,0.993728),(1.434888,2.823529,1.11064),(1.378008,2.760784,1.231737),(1.30762,2.698039,1.355806),(1.222385,2.635294,1.481369),(1.121057,2.572549,1.606666),(1.002537,2.509804,1.729642),(0.865928,2.447059,1.847949),(0.710594,2.384314,1.95895),(0.536231,2.321569,2.059738),(0.34293,2.258824,2.147167),(0.131247,2.196078,2.217896),(-0.097733,2.133333,2.268452),(-0.342338,2.070588,2.295301),(-0.60026,2.007843,2.294944),(-0.868513,1.945098,2.264023),(-1.143422,1.882353,2.199442),(-1.420617,1.819608,2.0985),(-1.695061,1.756863,1.959031),(-1.961103,1.694118,1.779549),(-2.212559,1.631373,1.559394),(-2.442826,1.568627,1.298863),(-2.645031,1.505882,0.99934),(-2.812201,1.443137,0.663391),(-2.937474,1.380392,0.294843),(-3.014322,1.317647,-0.101182),(-3.0368,1.254902,-0.518267),(-2.999798,1.192157,-0.948752),(-2.899303,1.129412,-1.383835),(-2.732641,1.066667,-1.813728),(-2.498705,1.003922,-2.227861),(-2.198148,0.941176,-2.615145),(-1.833533,0.878431,-2.964278),(-1.409429,0.815686,-3.26408),(-0.932436,0.752941,-3.50387),(-0.411151,0.690196,-3.673851),(0.143955,0.627451,-3.765493),(0.720729,0.564706,-3.771905),(1.305608,0.501961,-3.688176),(1.883961,0.439216,-3.511663),(2.440493,0.376471,-3.242222),(2.959695,0.313725,-2.882362),(3.426333,0.25098,-2.437304),(3.825949,0.188235,-1.914955),(4.145358,0.12549,-1.32578),(4.373123,0.062745,-0.682575),(4.499984,0.0,-1.5E-4)])),
    Transform(DEF='Particle1',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(diffuseColor=(1.0,0.0,0.0))),
        geometry=Sphere(radius=0.8))]),
    PositionInterpolator(DEF='Position1',key=[0.0,0.003922,0.007843,0.011765,0.015686,0.019608,0.023529,0.027451,0.031373,0.035294,0.039216,0.043137,0.047059,0.05098,0.054902,0.058824,0.062745,0.066667,0.070588,0.07451,0.078431,0.082353,0.086275,0.090196,0.094118,0.098039,0.101961,0.105882,0.109804,0.113725,0.117647,0.121569,0.12549,0.129412,0.133333,0.137255,0.141176,0.145098,0.14902,0.152941,0.156863,0.160784,0.164706,0.168627,0.172549,0.176471,0.180392,0.184314,0.188235,0.192157,0.196078,0.2,0.203922,0.207843,0.211765,0.215686,0.219608,0.223529,0.227451,0.231373,0.235294,0.239216,0.243137,0.247059,0.25098,0.254902,0.258824,0.262745,0.266667,0.270588,0.27451,0.278431,0.282353,0.286275,0.290196,0.294118,0.298039,0.301961,0.305882,0.309804,0.313725,0.317647,0.321569,0.32549,0.329412,0.333333,0.337255,0.341176,0.345098,0.34902,0.352941,0.356863,0.360784,0.364706,0.368627,0.372549,0.376471,0.380392,0.384314,0.388235,0.392157,0.396078,0.4,0.403922,0.407843,0.411765,0.415686,0.419608,0.423529,0.427451,0.431373,0.435294,0.439216,0.443137,0.447059,0.45098,0.454902,0.458824,0.462745,0.466667,0.470588,0.47451,0.478431,0.482353,0.486275,0.490196,0.494118,0.498039,0.501961,0.505882,0.509804,0.513725,0.517647,0.521569,0.52549,0.529412,0.533333,0.537255,0.541176,0.545098,0.54902,0.552941,0.556863,0.560784,0.564706,0.568627,0.572549,0.576471,0.580392,0.584314,0.588235,0.592157,0.596078,0.6,0.603922,0.607843,0.611765,0.615686,0.619608,0.623529,0.627451,0.631373,0.635294,0.639216,0.643137,0.647059,0.65098,0.654902,0.658824,0.662745,0.666667,0.670588,0.67451,0.678431,0.682353,0.686275,0.690196,0.694118,0.698039,0.701961,0.705882,0.709804,0.713725,0.717647,0.721569,0.72549,0.729412,0.733333,0.737255,0.741176,0.745098,0.74902,0.752941,0.756863,0.760784,0.764706,0.768627,0.772549,0.776471,0.780392,0.784314,0.788235,0.792157,0.796078,0.8,0.803922,0.807843,0.811765,0.815686,0.819608,0.823529,0.827451,0.831373,0.835294,0.839216,0.843137,0.847059,0.85098,0.854902,0.858824,0.862745,0.866667,0.870588,0.87451,0.878431,0.882353,0.886275,0.890196,0.894118,0.898039,0.901961,0.905882,0.909804,0.913725,0.917647,0.921569,0.92549,0.929412,0.933333,0.937255,0.941176,0.945098,0.94902,0.952941,0.956863,0.960784,0.964706,0.968627,0.972549,0.976471,0.980392,0.984314,0.988235,0.992157,0.996078,1.0],keyValue=[(4.5,16.0,0.0),(4.519218,15.937255,0.705224),(4.426933,15.87451,1.415671),(4.222285,15.811765,2.113152),(3.907535,15.74902,2.779409),(3.488044,15.686275,3.396681),(2.972147,15.623529,3.948261),(2.37093,15.560784,4.419013),(1.697899,15.498039,4.795848),(0.968577,15.435294,5.068115),(0.200033,15.372549,5.227915),(-0.589644,15.309804,5.270316),(-1.381887,15.247059,5.193465),(-2.158203,15.184314,4.998591),(-2.900711,15.121569,4.689915),(-3.59264,15.058824,4.274449),(-4.218781,14.996078,3.761724),(-4.765862,14.933333,3.16344),(-5.222854,14.870588,2.493058),(-5.58119,14.807843,1.765356),(-5.834888,14.745098,0.995971),(-5.980592,14.682353,0.200924),(-6.017533,14.619608,-0.603825),(-5.9474,14.556863,-1.402801),(-5.774154,14.494118,-2.181397),(-5.503784,14.431373,-2.926199),(-5.144015,14.368627,-3.625256),(-4.703992,14.305882,-4.268284),(-4.193941,14.243137,-4.846807),(-3.624837,14.180392,-5.354229),(-3.008067,14.117647,-5.785853),(-2.355118,14.054902,-6.138834),(-1.677292,13.992157,-6.412097),(-0.985454,13.929412,-6.606203),(-0.289809,13.866667,-6.72319),(0.400263,13.803922,-6.766385),(1.076352,13.741176,-6.74021),(1.731104,13.678431,-6.64997),(2.35828,13.615686,-6.501656),(2.952774,13.552941,-6.301735),(3.510603,13.490196,-6.056975),(4.028864,13.427451,-5.774267),(4.505675,13.364706,-5.460474),(4.940095,13.301961,-5.122305),(5.33203,13.239216,-4.766201),(5.682133,13.176471,-4.398251),(5.991697,13.113725,-4.024127),(6.262547,13.05098,-3.649035),(6.496936,12.988235,-3.277692),(6.697444,12.92549,-2.914314),(6.866878,12.862745,-2.562615),(7.008193,12.8,-2.225831),(7.124401,12.737255,-1.906734),(7.218511,12.67451,-1.607673),(7.293459,12.611765,-1.330604),(7.352059,12.54902,-1.077135),(7.396953,12.486275,-0.848564),(7.43058,12.423529,-0.645923),(7.455139,12.360784,-0.470015),(7.472565,12.298039,-0.321455),(7.484512,12.235294,-0.2007),(7.492336,12.172549,-0.108082),(7.497083,12.109804,-0.043828),(7.499483,12.047059,-0.008087),(7.499943,11.984314,-9.33E-4),(7.498544,11.921569,-0.022383),(7.495041,11.858824,-0.072391),(7.488867,11.796078,-0.150847),(7.479132,11.733333,-0.257566),(7.464635,11.670588,-0.392269),(7.443868,11.607843,-0.554566),(7.415035,11.545098,-0.743926),(7.376066,11.482353,-0.959643),(7.324639,11.419608,-1.200805),(7.258209,11.356863,-1.466252),(7.174043,11.294118,-1.754536),(7.069259,11.231373,-2.063881),(6.940878,11.168627,-2.392139),(6.785881,11.105882,-2.736753),(6.601275,11.043137,-3.094724),(6.38417,10.980392,-3.46258),(6.131858,10.917647,-3.836355),(5.841913,10.854902,-4.211584),(5.512281,10.792157,-4.583302),(5.141391,10.729412,-4.946066),(4.728255,10.666667,-5.29399),(4.272582,10.603922,-5.620798),(3.774876,10.541176,-5.919903),(3.236538,10.478431,-6.184504),(2.659951,10.415686,-6.407707),(2.048552,10.352941,-6.582661),(1.406882,10.290196,-6.702728),(0.740614,10.227451,-6.761652),(0.056548,10.164706,-6.753763),(-0.637425,10.101961,-6.674169),(-1.332395,10.039216,-6.518971),(-2.01855,9.976471,-6.285461),(-2.685331,9.913725,-5.972319),(-3.321625,9.85098,-5.579783),(-3.916004,9.788235,-5.109798),(-4.456993,9.72549,-4.566128),(-4.93337,9.662745,-3.954416),(-5.334494,9.6,-3.282204),(-5.650635,9.537255,-2.558886),(-5.873318,9.47451,-1.7956),(-5.995646,9.411765,-1.005058),(-6.012612,9.34902,-0.201308),(-5.921362,9.286275,0.600565),(-5.721417,9.223529,1.384793),(-5.414829,9.160784,2.135331),(-5.006263,9.098039,2.836291),(-4.503007,9.035294,3.472408),(-3.91488,8.972549,4.029504),(-3.254064,8.909804,4.494945),(-2.534843,8.847059,4.85807),(-1.773258,8.784314,5.110564),(-0.986694,8.721569,5.246783),(-0.193405,8.658824,5.263984),(0.588012,8.596078,5.16247),(1.339159,8.533333,4.945643),(2.04239,8.470588,4.619938),(2.681347,8.407843,4.194662),(3.241459,8.345098,3.681731),(3.710384,8.282353,3.09531),(4.078376,8.219608,2.451384),(4.338564,8.156863,1.767254),(4.48713,8.094118,1.061),(4.523376,8.031373,0.350916),(4.449691,7.968627,-0.34505),(4.271404,7.905882,-1.00984),(3.996544,7.843137,-1.627781),(3.635507,7.780392,-2.185025),(3.200663,7.717647,-2.669906),(2.705892,7.654902,-3.073216),(2.166104,7.592157,-3.388378),(1.596733,7.529412,-3.61153),(1.013238,7.466667,-3.741503),(0.430638,7.403922,-3.779712),(-0.136923,7.341176,-3.729968),(-0.676549,7.278431,-3.598209),(-1.176898,7.215686,-3.392191),(-1.628415,7.152941,-3.121126),(-2.023492,7.090196,-2.795299),(-2.356543,7.027451,-2.42569),(-2.624009,6.964706,-2.023582),(-2.824297,6.901961,-1.600214),(-2.957656,6.839216,-1.16645),(-3.026001,6.776471,-0.732498),(-3.032706,6.713725,-0.307677),(-2.982364,6.65098,0.099766),(-2.880534,6.588235,0.482784),(-2.733483,6.52549,0.835601),(-2.547937,6.462745,1.153747),(-2.330841,6.4,1.434032),(-2.08914,6.337255,1.67449),(-1.829593,6.27451,1.874296),(-1.558611,6.211765,2.033647),(-1.282123,6.14902,2.153633),(-1.005481,6.086275,2.236099),(-0.733395,6.023529,2.283495),(-0.469888,5.960784,2.298737),(-0.218291,5.898039,2.285069),(0.018755,5.835294,2.245933),(0.239263,5.772549,2.184857),(0.441862,5.709804,2.105355),(0.625739,5.647059,2.010844),(0.790579,5.584314,1.904574),(0.936496,5.521569,1.789575),(1.063969,5.458824,1.668624),(1.173773,5.396078,1.544213),(1.266911,5.333333,1.418545),(1.344565,5.270588,1.293526),(1.408032,5.207843,1.170774),(1.458682,5.145098,1.051633),(1.497913,5.082353,0.937188),(1.527123,5.019608,0.828291),(1.547673,4.956863,0.725583),(1.560872,4.894118,0.629522),(1.567957,4.831373,0.540407),(1.570079,4.768627,0.458404),(1.568301,4.705882,0.38357),(1.563587,4.643137,0.315878),(1.556803,4.580392,0.255235),(1.548719,4.517647,0.201502),(1.540011,4.454902,0.154513),(1.531261,4.392157,0.114086),(1.522966,4.329412,0.080039),(1.515537,4.266667,0.052197),(1.509309,4.203922,0.030406),(1.50454,4.141176,0.014534),(1.501417,4.078431,0.004483),(1.500057,4.015686,1.87E-4),(1.500511,3.952941,0.001617),(1.502762,3.890196,0.008783),(1.506727,3.827451,0.021732),(1.512253,3.764706,0.040547),(1.519118,3.701961,0.065344),(1.527026,3.639216,0.096265),(1.535606,3.576471,0.133478),(1.544402,3.513725,0.177161),(1.552877,3.45098,0.227497),(1.560401,3.388235,0.284664),(1.566253,3.32549,0.348814),(1.569615,3.262745,0.420067),(1.56957,3.2,0.498484),(1.565107,3.137255,0.584054),(1.555116,3.07451,0.676669),(1.538403,3.011765,0.776097),(1.513694,2.94902,0.881966),(1.47965,2.886275,0.993728),(1.434888,2.823529,1.11064),(1.378008,2.760784,1.231737),(1.30762,2.698039,1.355806),(1.222385,2.635294,1.481369),(1.121057,2.572549,1.606666),(1.002537,2.509804,1.729642),(0.865928,2.447059,1.847949),(0.710594,2.384314,1.95895),(0.536231,2.321569,2.059738),(0.34293,2.258824,2.147167),(0.131247,2.196078,2.217896),(-0.097733,2.133333,2.268452),(-0.342338,2.070588,2.295301),(-0.60026,2.007843,2.294944),(-0.868513,1.945098,2.264023),(-1.143422,1.882353,2.199442),(-1.420617,1.819608,2.0985),(-1.695061,1.756863,1.959031),(-1.961103,1.694118,1.779549),(-2.212559,1.631373,1.559394),(-2.442826,1.568627,1.298863),(-2.645031,1.505882,0.99934),(-2.812201,1.443137,0.663391),(-2.937474,1.380392,0.294843),(-3.014322,1.317647,-0.101182),(-3.0368,1.254902,-0.518267),(-2.999798,1.192157,-0.948752),(-2.899303,1.129412,-1.383835),(-2.732641,1.066667,-1.813728),(-2.498705,1.003922,-2.227861),(-2.198148,0.941176,-2.615145),(-1.833533,0.878431,-2.964278),(-1.409429,0.815686,-3.26408),(-0.932436,0.752941,-3.50387),(-0.411151,0.690196,-3.673851),(0.143955,0.627451,-3.765493),(0.720729,0.564706,-3.771905),(1.305608,0.501961,-3.688176),(1.883961,0.439216,-3.511663),(2.440493,0.376471,-3.242222),(2.959695,0.313725,-2.882362),(3.426333,0.25098,-2.437304),(3.825949,0.188235,-1.914955),(4.145358,0.12549,-1.32578),(4.373123,0.062745,-0.682575),(4.499984,0.0,-1.5E-4)]),
    TimeSensor(DEF='Timer1',cycleInterval=36.0,loop=True,stopTime=-1.0),
    ROUTE(fromField='fraction_changed',fromNode='Timer1',toField='set_fraction',toNode='Position1'),
    ROUTE(fromField='value_changed',fromNode='Position1',toField='set_translation',toNode='Particle1'),
    Shape(
      appearance=Appearance(
        material=Material(diffuseColor=(0.75,0.75,0.0))),
      geometry=Extrusion(creaseAngle=0.785,crossSection=[(-0.5,0.1),(0.5,0.1),(0.5,-0.1),(-0.5,-0.1),(-0.5,0.1)],solid=False,spine=[(4.5,16.0,0.0),(4.426933,15.937255,1.415671),(3.907535,15.87451,2.779409),(2.972147,15.811765,3.948261),(1.697899,15.74902,4.795848),(0.200033,15.686275,5.227915),(-1.381887,15.623529,5.193465),(-2.900711,15.560784,4.689915),(-4.218781,15.498039,3.761724),(-5.222854,15.435294,2.493058),(-5.834888,15.372549,0.995971),(-6.017533,15.309804,-0.603825),(-5.774154,15.247059,-2.181397),(-5.144015,15.184314,-3.625256),(-4.193941,15.121569,-4.846807),(-3.008067,15.058824,-5.785853),(-1.677292,14.996078,-6.412097),(-0.289809,14.933333,-6.72319),(1.076352,14.870588,-6.74021),(2.35828,14.807843,-6.501656),(3.510603,14.745098,-6.056975),(4.505675,14.682353,-5.460474),(5.33203,14.619608,-4.766201),(5.991697,14.556863,-4.024127),(6.496936,14.494118,-3.277692),(6.866878,14.431373,-2.562615),(7.124401,14.368627,-1.906734),(7.293459,14.305882,-1.330604),(7.396953,14.243137,-0.848564),(7.455139,14.180392,-0.470015),(7.484512,14.117647,-0.2007),(7.497083,14.054902,-0.043828),(7.499943,13.992157,-9.33E-4),(7.495041,13.929412,-0.072391),(7.479132,13.866667,-0.257566),(7.443868,13.803922,-0.554566),(7.376066,13.741176,-0.959643),(7.258209,13.678431,-1.466252),(7.069259,13.615686,-2.063881),(6.785881,13.552941,-2.736753),(6.38417,13.490196,-3.46258),(5.841913,13.427451,-4.211584),(5.141391,13.364706,-4.946066),(4.272582,13.301961,-5.620798),(3.236538,13.239216,-6.184504),(2.048552,13.176471,-6.582661),(0.740614,13.113725,-6.761652),(-0.637425,13.05098,-6.674169),(-2.01855,12.988235,-6.285461),(-3.321625,12.92549,-5.579783),(-4.456993,12.862745,-4.566128),(-5.334494,12.8,-3.282204),(-5.873318,12.737255,-1.7956),(-6.012612,12.67451,-0.201308),(-5.721417,12.611765,1.384793),(-5.006263,12.54902,2.836291),(-3.91488,12.486275,4.029504),(-2.534843,12.423529,4.85807),(-0.986694,12.360784,5.246783),(0.588012,12.298039,5.16247),(2.04239,12.235294,4.619938),(3.241459,12.172549,3.681731),(4.078376,12.109804,2.451384),(4.48713,12.047059,1.061),(4.449691,11.984314,-0.34505),(3.996544,11.921569,-1.627781),(3.200663,11.858824,-2.669906),(2.166104,11.796078,-3.388378),(1.013238,11.733333,-3.741503),(-0.136923,11.670588,-3.729968),(-1.176898,11.607843,-3.392191),(-2.023492,11.545098,-2.795299),(-2.624009,11.482353,-2.023582),(-2.957656,11.419608,-1.16645),(-3.032706,11.356863,-0.307677),(-2.880534,11.294118,0.482784),(-2.547937,11.231373,1.153747),(-2.08914,11.168627,1.67449),(-1.558611,11.105882,2.033647),(-1.005481,11.043137,2.236099),(-0.469888,10.980392,2.298737),(0.018755,10.917647,2.245933),(0.441862,10.854902,2.105355),(0.790579,10.792157,1.904574),(1.063969,10.729412,1.668624),(1.266911,10.666667,1.418545),(1.408032,10.603922,1.170774),(1.497913,10.541176,0.937188),(1.547673,10.478431,0.725583),(1.567957,10.415686,0.540407),(1.568301,10.352941,0.38357),(1.556803,10.290196,0.255235),(1.540011,10.227451,0.154513),(1.522966,10.164706,0.080039),(1.509309,10.101961,0.030406),(1.501417,10.039216,0.004483),(1.500511,9.976471,0.001617),(1.506727,9.913725,0.021732),(1.519118,9.85098,0.065344),(1.535606,9.788235,0.133478),(1.552877,9.72549,0.227497),(1.566253,9.662745,0.348814),(1.56957,9.6,0.498484),(1.555116,9.537255,0.676669),(1.513694,9.47451,0.881966),(1.434888,9.411765,1.11064),(1.30762,9.34902,1.355806),(1.121057,9.286275,1.606666),(0.865928,9.223529,1.847949),(0.536231,9.160784,2.059738),(0.131247,9.098039,2.217896),(-0.342338,9.035294,2.295301),(-0.868513,8.972549,2.264023),(-1.420617,8.909804,2.0985),(-1.961103,8.847059,1.779549),(-2.442826,8.784314,1.298863),(-2.812201,8.721569,0.663391),(-3.014322,8.658824,-0.101182),(-2.999798,8.596078,-0.948752),(-2.732641,8.533333,-1.813728),(-2.198148,8.470588,-2.615145),(-1.409429,8.407843,-3.26408),(-0.411151,8.345098,-3.673851),(0.720729,8.282353,-3.771905),(1.883961,8.219608,-3.511663),(2.959695,8.156863,-2.882362),(3.825949,8.094118,-1.914955),(4.373123,8.031373,-0.682575),(4.519226,7.968627,0.70507),(4.222341,7.905882,2.113005),(3.488145,7.843137,3.396555),(2.371068,7.780392,4.418922),(0.968739,7.717647,5.068068),(-0.589473,7.654902,5.27032),(-2.158039,7.592157,4.998646),(-3.592498,7.529412,4.274549),(-4.765753,7.466667,3.163577),(-5.581124,7.403922,1.765518),(-5.980573,7.341176,0.201097),(-5.947426,7.278431,-1.40263),(-5.503853,7.215686,-2.926043),(-4.704094,7.152941,-4.268152),(-3.624966,7.090196,-5.354128),(-2.355262,7.027451,-6.138766),(-0.985603,6.964706,-6.60617),(0.400116,6.901961,-6.766383),(1.730966,6.839216,-6.649996),(2.95265,6.776471,-6.301783),(4.028756,6.713725,-5.774331),(4.940006,6.65098,-5.12238),(5.682062,6.588235,-4.398331),(6.262492,6.52549,-3.649115),(6.697404,6.462745,-2.914391),(7.008165,6.4,-2.225901),(7.218493,6.337255,-1.607735),(7.352048,6.27451,-1.077187),(7.430574,6.211765,-0.645964),(7.472561,6.14902,-0.321484),(7.492334,6.086275,-0.108098),(7.499483,6.023529,-0.008091),(7.498544,5.960784,-0.022376),(7.488869,5.898039,-0.150827),(7.464639,5.835294,-0.392237),(7.415043,5.772549,-0.743882),(7.324652,5.709804,-1.20075),(7.174063,5.647059,-1.754471),(6.940908,5.584314,-2.392066),(6.601319,5.521569,-3.094646),(6.131916,5.458824,-3.836274),(5.512356,5.396078,-4.583223),(4.728348,5.333333,-5.293917),(3.774987,5.270588,-5.919842),(2.660079,5.207843,-6.407663),(1.407023,5.145098,-6.702708),(0.056696,5.082353,-6.753772),(-1.332245,5.019608,-6.519013),(-2.68519,4.956863,-5.972395),(-3.915881,4.894118,-5.109908),(-4.933275,4.831373,-3.954555),(-5.650577,4.768627,-2.559047),(-5.995631,4.705882,-1.00523),(-5.921394,4.643137,0.600394),(-5.414906,4.580392,2.135174),(-4.503125,4.517647,3.472279),(-3.254214,4.454902,4.494856),(-1.773425,4.392157,5.110522),(-0.193575,4.329412,5.263993),(1.339002,4.266667,4.945702),(2.681218,4.203922,4.194764),(3.710293,4.141176,3.095443),(4.33852,4.078431,1.767404),(4.52338,4.015686,0.351068),(4.271453,3.952941,-1.009701),(3.635594,3.890196,-2.184913),(2.706004,3.827451,-3.073138),(1.596858,3.764706,-3.611492),(0.430763,3.701961,-3.779714),(-0.676437,3.639216,-3.598246),(-1.628324,3.576471,-3.12119),(-2.356478,3.513725,-2.425773),(-2.824262,3.45098,-1.600307),(-3.025993,3.388235,-0.732591),(-2.982381,3.32549,0.099681),(-2.733519,3.262745,0.835529),(-2.33089,3.2,1.433975),(-1.829651,3.137255,1.874257),(-1.282183,3.07451,2.153611),(-0.733453,3.011765,2.283488),(-0.218343,2.94902,2.285075),(0.239218,2.886275,2.184872),(0.625702,2.823529,2.010866),(0.936467,2.760784,1.789601),(1.173751,2.698039,1.54424),(1.34455,2.635294,1.293553),(1.458672,2.572549,1.051658),(1.527117,2.509804,0.828313),(1.56087,2.447059,0.629542),(1.570079,2.384314,0.458421),(1.563588,2.321569,0.315892),(1.548721,2.258824,0.201513),(1.531263,2.196078,0.114094),(1.515538,2.133333,0.052203),(1.50454,2.070588,0.014537),(1.500057,2.007843,1.87E-4),(1.502762,1.945098,0.008781),(1.512252,1.882353,0.040542),(1.527025,1.819608,0.096258),(1.5444,1.756863,0.177151),(1.560399,1.694118,0.284651),(1.569614,1.631373,0.420051),(1.565108,1.568627,0.584035),(1.538408,1.505882,0.776075),(1.479658,1.443137,0.993703),(1.378022,1.380392,1.23171),(1.222405,1.317647,1.481342),(1.002565,1.254902,1.729616),(0.710629,1.192157,1.958927),(0.342974,1.129412,2.14715),(-0.097682,1.066667,2.268443),(-0.600203,1.003922,2.294947),(-1.143362,0.941176,2.19946),(-1.695003,0.878431,1.959065),(-2.212506,0.815686,1.559446),(-2.644991,0.752941,0.999409),(-2.937452,0.690196,0.294926),(-3.036801,0.627451,-0.518175),(-2.899332,0.564706,-1.383742),(-2.498762,0.501961,-2.227774),(-1.833619,0.439216,-2.964207),(-0.932544,0.376471,-3.503826),(0.143833,0.313725,-3.765483),(1.305482,0.25098,-3.688204),(2.440376,0.188235,-3.24229),(3.426239,0.12549,-2.437408),(4.145299,0.062745,-1.325913),(4.499968,0.0,-3.0E-4)])),
    Transform(DEF='Particle2',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(diffuseColor=(1.0,1.0,0.0))),
        geometry=Sphere(radius=0.8))]),
    PositionInterpolator(DEF='Position2',key=[0.0,0.003922,0.007843,0.011765,0.015686,0.019608,0.023529,0.027451,0.031373,0.035294,0.039216,0.043137,0.047059,0.05098,0.054902,0.058824,0.062745,0.066667,0.070588,0.07451,0.078431,0.082353,0.086275,0.090196,0.094118,0.098039,0.101961,0.105882,0.109804,0.113725,0.117647,0.121569,0.12549,0.129412,0.133333,0.137255,0.141176,0.145098,0.14902,0.152941,0.156863,0.160784,0.164706,0.168627,0.172549,0.176471,0.180392,0.184314,0.188235,0.192157,0.196078,0.2,0.203922,0.207843,0.211765,0.215686,0.219608,0.223529,0.227451,0.231373,0.235294,0.239216,0.243137,0.247059,0.25098,0.254902,0.258824,0.262745,0.266667,0.270588,0.27451,0.278431,0.282353,0.286275,0.290196,0.294118,0.298039,0.301961,0.305882,0.309804,0.313725,0.317647,0.321569,0.32549,0.329412,0.333333,0.337255,0.341176,0.345098,0.34902,0.352941,0.356863,0.360784,0.364706,0.368627,0.372549,0.376471,0.380392,0.384314,0.388235,0.392157,0.396078,0.4,0.403922,0.407843,0.411765,0.415686,0.419608,0.423529,0.427451,0.431373,0.435294,0.439216,0.443137,0.447059,0.45098,0.454902,0.458824,0.462745,0.466667,0.470588,0.47451,0.478431,0.482353,0.486275,0.490196,0.494118,0.498039,0.501961,0.505882,0.509804,0.513725,0.517647,0.521569,0.52549,0.529412,0.533333,0.537255,0.541176,0.545098,0.54902,0.552941,0.556863,0.560784,0.564706,0.568627,0.572549,0.576471,0.580392,0.584314,0.588235,0.592157,0.596078,0.6,0.603922,0.607843,0.611765,0.615686,0.619608,0.623529,0.627451,0.631373,0.635294,0.639216,0.643137,0.647059,0.65098,0.654902,0.658824,0.662745,0.666667,0.670588,0.67451,0.678431,0.682353,0.686275,0.690196,0.694118,0.698039,0.701961,0.705882,0.709804,0.713725,0.717647,0.721569,0.72549,0.729412,0.733333,0.737255,0.741176,0.745098,0.74902,0.752941,0.756863,0.760784,0.764706,0.768627,0.772549,0.776471,0.780392,0.784314,0.788235,0.792157,0.796078,0.8,0.803922,0.807843,0.811765,0.815686,0.819608,0.823529,0.827451,0.831373,0.835294,0.839216,0.843137,0.847059,0.85098,0.854902,0.858824,0.862745,0.866667,0.870588,0.87451,0.878431,0.882353,0.886275,0.890196,0.894118,0.898039,0.901961,0.905882,0.909804,0.913725,0.917647,0.921569,0.92549,0.929412,0.933333,0.937255,0.941176,0.945098,0.94902,0.952941,0.956863,0.960784,0.964706,0.968627,0.972549,0.976471,0.980392,0.984314,0.988235,0.992157,0.996078,1.0],keyValue=[(4.5,16.0,0.0),(4.426933,15.937255,1.415671),(3.907535,15.87451,2.779409),(2.972147,15.811765,3.948261),(1.697899,15.74902,4.795848),(0.200033,15.686275,5.227915),(-1.381887,15.623529,5.193465),(-2.900711,15.560784,4.689915),(-4.218781,15.498039,3.761724),(-5.222854,15.435294,2.493058),(-5.834888,15.372549,0.995971),(-6.017533,15.309804,-0.603825),(-5.774154,15.247059,-2.181397),(-5.144015,15.184314,-3.625256),(-4.193941,15.121569,-4.846807),(-3.008067,15.058824,-5.785853),(-1.677292,14.996078,-6.412097),(-0.289809,14.933333,-6.72319),(1.076352,14.870588,-6.74021),(2.35828,14.807843,-6.501656),(3.510603,14.745098,-6.056975),(4.505675,14.682353,-5.460474),(5.33203,14.619608,-4.766201),(5.991697,14.556863,-4.024127),(6.496936,14.494118,-3.277692),(6.866878,14.431373,-2.562615),(7.124401,14.368627,-1.906734),(7.293459,14.305882,-1.330604),(7.396953,14.243137,-0.848564),(7.455139,14.180392,-0.470015),(7.484512,14.117647,-0.2007),(7.497083,14.054902,-0.043828),(7.499943,13.992157,-9.33E-4),(7.495041,13.929412,-0.072391),(7.479132,13.866667,-0.257566),(7.443868,13.803922,-0.554566),(7.376066,13.741176,-0.959643),(7.258209,13.678431,-1.466252),(7.069259,13.615686,-2.063881),(6.785881,13.552941,-2.736753),(6.38417,13.490196,-3.46258),(5.841913,13.427451,-4.211584),(5.141391,13.364706,-4.946066),(4.272582,13.301961,-5.620798),(3.236538,13.239216,-6.184504),(2.048552,13.176471,-6.582661),(0.740614,13.113725,-6.761652),(-0.637425,13.05098,-6.674169),(-2.01855,12.988235,-6.285461),(-3.321625,12.92549,-5.579783),(-4.456993,12.862745,-4.566128),(-5.334494,12.8,-3.282204),(-5.873318,12.737255,-1.7956),(-6.012612,12.67451,-0.201308),(-5.721417,12.611765,1.384793),(-5.006263,12.54902,2.836291),(-3.91488,12.486275,4.029504),(-2.534843,12.423529,4.85807),(-0.986694,12.360784,5.246783),(0.588012,12.298039,5.16247),(2.04239,12.235294,4.619938),(3.241459,12.172549,3.681731),(4.078376,12.109804,2.451384),(4.48713,12.047059,1.061),(4.449691,11.984314,-0.34505),(3.996544,11.921569,-1.627781),(3.200663,11.858824,-2.669906),(2.166104,11.796078,-3.388378),(1.013238,11.733333,-3.741503),(-0.136923,11.670588,-3.729968),(-1.176898,11.607843,-3.392191),(-2.023492,11.545098,-2.795299),(-2.624009,11.482353,-2.023582),(-2.957656,11.419608,-1.16645),(-3.032706,11.356863,-0.307677),(-2.880534,11.294118,0.482784),(-2.547937,11.231373,1.153747),(-2.08914,11.168627,1.67449),(-1.558611,11.105882,2.033647),(-1.005481,11.043137,2.236099),(-0.469888,10.980392,2.298737),(0.018755,10.917647,2.245933),(0.441862,10.854902,2.105355),(0.790579,10.792157,1.904574),(1.063969,10.729412,1.668624),(1.266911,10.666667,1.418545),(1.408032,10.603922,1.170774),(1.497913,10.541176,0.937188),(1.547673,10.478431,0.725583),(1.567957,10.415686,0.540407),(1.568301,10.352941,0.38357),(1.556803,10.290196,0.255235),(1.540011,10.227451,0.154513),(1.522966,10.164706,0.080039),(1.509309,10.101961,0.030406),(1.501417,10.039216,0.004483),(1.500511,9.976471,0.001617),(1.506727,9.913725,0.021732),(1.519118,9.85098,0.065344),(1.535606,9.788235,0.133478),(1.552877,9.72549,0.227497),(1.566253,9.662745,0.348814),(1.56957,9.6,0.498484),(1.555116,9.537255,0.676669),(1.513694,9.47451,0.881966),(1.434888,9.411765,1.11064),(1.30762,9.34902,1.355806),(1.121057,9.286275,1.606666),(0.865928,9.223529,1.847949),(0.536231,9.160784,2.059738),(0.131247,9.098039,2.217896),(-0.342338,9.035294,2.295301),(-0.868513,8.972549,2.264023),(-1.420617,8.909804,2.0985),(-1.961103,8.847059,1.779549),(-2.442826,8.784314,1.298863),(-2.812201,8.721569,0.663391),(-3.014322,8.658824,-0.101182),(-2.999798,8.596078,-0.948752),(-2.732641,8.533333,-1.813728),(-2.198148,8.470588,-2.615145),(-1.409429,8.407843,-3.26408),(-0.411151,8.345098,-3.673851),(0.720729,8.282353,-3.771905),(1.883961,8.219608,-3.511663),(2.959695,8.156863,-2.882362),(3.825949,8.094118,-1.914955),(4.373123,8.031373,-0.682575),(4.519226,7.968627,0.70507),(4.222341,7.905882,2.113005),(3.488145,7.843137,3.396555),(2.371068,7.780392,4.418922),(0.968739,7.717647,5.068068),(-0.589473,7.654902,5.27032),(-2.158039,7.592157,4.998646),(-3.592498,7.529412,4.274549),(-4.765753,7.466667,3.163577),(-5.581124,7.403922,1.765518),(-5.980573,7.341176,0.201097),(-5.947426,7.278431,-1.40263),(-5.503853,7.215686,-2.926043),(-4.704094,7.152941,-4.268152),(-3.624966,7.090196,-5.354128),(-2.355262,7.027451,-6.138766),(-0.985603,6.964706,-6.60617),(0.400116,6.901961,-6.766383),(1.730966,6.839216,-6.649996),(2.95265,6.776471,-6.301783),(4.028756,6.713725,-5.774331),(4.940006,6.65098,-5.12238),(5.682062,6.588235,-4.398331),(6.262492,6.52549,-3.649115),(6.697404,6.462745,-2.914391),(7.008165,6.4,-2.225901),(7.218493,6.337255,-1.607735),(7.352048,6.27451,-1.077187),(7.430574,6.211765,-0.645964),(7.472561,6.14902,-0.321484),(7.492334,6.086275,-0.108098),(7.499483,6.023529,-0.008091),(7.498544,5.960784,-0.022376),(7.488869,5.898039,-0.150827),(7.464639,5.835294,-0.392237),(7.415043,5.772549,-0.743882),(7.324652,5.709804,-1.20075),(7.174063,5.647059,-1.754471),(6.940908,5.584314,-2.392066),(6.601319,5.521569,-3.094646),(6.131916,5.458824,-3.836274),(5.512356,5.396078,-4.583223),(4.728348,5.333333,-5.293917),(3.774987,5.270588,-5.919842),(2.660079,5.207843,-6.407663),(1.407023,5.145098,-6.702708),(0.056696,5.082353,-6.753772),(-1.332245,5.019608,-6.519013),(-2.68519,4.956863,-5.972395),(-3.915881,4.894118,-5.109908),(-4.933275,4.831373,-3.954555),(-5.650577,4.768627,-2.559047),(-5.995631,4.705882,-1.00523),(-5.921394,4.643137,0.600394),(-5.414906,4.580392,2.135174),(-4.503125,4.517647,3.472279),(-3.254214,4.454902,4.494856),(-1.773425,4.392157,5.110522),(-0.193575,4.329412,5.263993),(1.339002,4.266667,4.945702),(2.681218,4.203922,4.194764),(3.710293,4.141176,3.095443),(4.33852,4.078431,1.767404),(4.52338,4.015686,0.351068),(4.271453,3.952941,-1.009701),(3.635594,3.890196,-2.184913),(2.706004,3.827451,-3.073138),(1.596858,3.764706,-3.611492),(0.430763,3.701961,-3.779714),(-0.676437,3.639216,-3.598246),(-1.628324,3.576471,-3.12119),(-2.356478,3.513725,-2.425773),(-2.824262,3.45098,-1.600307),(-3.025993,3.388235,-0.732591),(-2.982381,3.32549,0.099681),(-2.733519,3.262745,0.835529),(-2.33089,3.2,1.433975),(-1.829651,3.137255,1.874257),(-1.282183,3.07451,2.153611),(-0.733453,3.011765,2.283488),(-0.218343,2.94902,2.285075),(0.239218,2.886275,2.184872),(0.625702,2.823529,2.010866),(0.936467,2.760784,1.789601),(1.173751,2.698039,1.54424),(1.34455,2.635294,1.293553),(1.458672,2.572549,1.051658),(1.527117,2.509804,0.828313),(1.56087,2.447059,0.629542),(1.570079,2.384314,0.458421),(1.563588,2.321569,0.315892),(1.548721,2.258824,0.201513),(1.531263,2.196078,0.114094),(1.515538,2.133333,0.052203),(1.50454,2.070588,0.014537),(1.500057,2.007843,1.87E-4),(1.502762,1.945098,0.008781),(1.512252,1.882353,0.040542),(1.527025,1.819608,0.096258),(1.5444,1.756863,0.177151),(1.560399,1.694118,0.284651),(1.569614,1.631373,0.420051),(1.565108,1.568627,0.584035),(1.538408,1.505882,0.776075),(1.479658,1.443137,0.993703),(1.378022,1.380392,1.23171),(1.222405,1.317647,1.481342),(1.002565,1.254902,1.729616),(0.710629,1.192157,1.958927),(0.342974,1.129412,2.14715),(-0.097682,1.066667,2.268443),(-0.600203,1.003922,2.294947),(-1.143362,0.941176,2.19946),(-1.695003,0.878431,1.959065),(-2.212506,0.815686,1.559446),(-2.644991,0.752941,0.999409),(-2.937452,0.690196,0.294926),(-3.036801,0.627451,-0.518175),(-2.899332,0.564706,-1.383742),(-2.498762,0.501961,-2.227774),(-1.833619,0.439216,-2.964207),(-0.932544,0.376471,-3.503826),(0.143833,0.313725,-3.765483),(1.305482,0.25098,-3.688204),(2.440376,0.188235,-3.24229),(3.426239,0.12549,-2.437408),(4.145299,0.062745,-1.325913),(4.499968,0.0,-3.0E-4)]),
    TimeSensor(DEF='Timer2',cycleInterval=36.0,loop=True,stopTime=-1.0),
    ROUTE(fromField='fraction_changed',fromNode='Timer2',toField='set_fraction',toNode='Position2'),
    ROUTE(fromField='value_changed',fromNode='Position2',toField='set_translation',toNode='Particle2'),
    Shape(
      appearance=Appearance(
        material=Material(diffuseColor=(0.0,0.75,0.0))),
      geometry=Extrusion(creaseAngle=0.785,crossSection=[(-0.5,0.1),(0.5,0.1),(0.5,-0.1),(-0.5,-0.1),(-0.5,0.1)],solid=False,spine=[(4.5,16.0,0.0),(4.222285,15.937255,2.113152),(2.972147,15.87451,3.948261),(0.968577,15.811765,5.068115),(-1.381887,15.74902,5.193465),(-3.59264,15.686275,4.274449),(-5.222854,15.623529,2.493058),(-5.980592,15.560784,0.200924),(-5.774154,15.498039,-2.181397),(-4.703992,15.435294,-4.268284),(-3.008067,15.372549,-5.785853),(-0.985454,15.309804,-6.606203),(1.076352,15.247059,-6.74021),(2.952774,15.184314,-6.301735),(4.505675,15.121569,-5.460474),(5.682133,15.058824,-4.398251),(6.496936,14.996078,-3.277692),(7.008193,14.933333,-2.225831),(7.293459,14.870588,-1.330604),(7.43058,14.807843,-0.645923),(7.484512,14.745098,-0.2007),(7.499483,14.682353,-0.008087),(7.495041,14.619608,-0.072391),(7.464635,14.556863,-0.392269),(7.376066,14.494118,-0.959643),(7.174043,14.431373,-1.754536),(6.785881,14.368627,-2.736753),(6.131858,14.305882,-3.836355),(5.141391,14.243137,-4.946066),(3.774876,14.180392,-5.919903),(2.048552,14.117647,-6.582661),(0.056548,14.054902,-6.753763),(-2.01855,13.992157,-6.285461),(-3.916004,13.929412,-5.109798),(-5.334494,13.866667,-3.282204),(-5.995646,13.803922,-1.005058),(-5.721417,13.741176,1.384793),(-4.503007,13.678431,3.472408),(-2.534843,13.615686,4.85807),(-0.193405,13.552941,5.263984),(2.04239,13.490196,4.619938),(3.710384,13.427451,3.09531),(4.48713,13.364706,1.061),(4.271404,13.301961,-1.00984),(3.200663,13.239216,-2.669906),(1.596733,13.176471,-3.61153),(-0.136923,13.113725,-3.729968),(-1.628415,13.05098,-3.121126),(-2.624009,12.988235,-2.023582),(-3.026001,12.92549,-0.732498),(-2.880534,12.862745,0.482784),(-2.330841,12.8,1.434032),(-1.558611,12.737255,2.033647),(-0.733395,12.67451,2.283495),(0.018755,12.611765,2.245933),(0.625739,12.54902,2.010844),(1.063969,12.486275,1.668624),(1.344565,12.423529,1.293526),(1.497913,12.360784,0.937188),(1.560872,12.298039,0.629522),(1.568301,12.235294,0.38357),(1.548719,12.172549,0.201502),(1.522966,12.109804,0.080039),(1.50454,12.047059,0.014534),(1.500511,11.984314,0.001617),(1.512253,11.921569,0.040547),(1.535606,11.858824,0.133478),(1.560401,11.796078,0.284664),(1.56957,11.733333,0.498484),(1.538403,11.670588,0.776097),(1.434888,11.607843,1.11064),(1.222385,11.545098,1.481369),(0.865928,11.482353,1.847949),(0.34293,11.419608,2.147167),(-0.342338,11.356863,2.295301),(-1.143422,11.294118,2.199442),(-1.961103,11.231373,1.779549),(-2.645031,11.168627,0.99934),(-3.014322,11.105882,-0.101182),(-2.899303,11.043137,-1.383835),(-2.198148,10.980392,-2.615145),(-0.932436,10.917647,-3.50387),(0.720729,10.854902,-3.771905),(2.440493,10.792157,-3.242222),(3.825949,10.729412,-1.914955),(4.499984,10.666667,-1.5E-4),(4.222341,10.603922,2.113005),(2.972268,10.541176,3.94815),(0.968739,10.478431,5.068068),(-1.381718,10.415686,5.193494),(-3.592498,10.352941,4.274549),(-5.222766,10.290196,2.493209),(-5.980573,10.227451,0.201097),(-5.774202,10.164706,-2.181232),(-4.704094,10.101961,-4.268152),(-3.008204,10.039216,-5.785768),(-0.985603,9.976471,-6.60617),(1.076209,9.913725,-6.740222),(2.95265,9.85098,-6.301783),(4.505577,9.788235,-5.460544),(5.682062,9.72549,-4.398331),(6.496889,9.662745,-3.277772),(7.008165,9.6,-2.225901),(7.293445,9.537255,-1.330661),(7.430574,9.47451,-0.645964),(7.48451,9.411765,-0.200723),(7.499483,9.34902,-0.008091),(7.495042,9.286275,-0.072378),(7.464639,9.223529,-0.392237),(7.376076,9.160784,-0.959594),(7.174063,9.098039,-1.754471),(6.785918,9.035294,-2.736678),(6.131916,8.972549,-3.836274),(5.141475,8.909804,-4.94599),(3.774987,8.847059,-5.919842),(2.048687,8.784314,-6.582629),(0.056696,8.721569,-6.753772),(-2.018404,8.658824,-6.28552),(-3.915881,8.596078,-5.109908),(-5.334416,8.533333,-3.282355),(-5.995631,8.470588,-1.00523),(-5.721472,8.407843,1.384627),(-4.503125,8.345098,3.472279),(-2.535003,8.282353,4.858003),(-0.193575,8.219608,5.263993),(2.042245,8.156863,4.620019),(3.710293,8.094118,3.095443),(4.48711,8.031373,1.061153),(4.271453,7.968627,-1.009701),(3.200763,7.905882,-2.66981),(1.596858,7.843137,-3.611492),(-0.136803,7.780392,-3.729987),(-1.628324,7.717647,-3.12119),(-2.623958,7.654902,-2.023671),(-3.025993,7.592157,-0.732591),(-2.880561,7.529412,0.482704),(-2.33089,7.466667,1.433975),(-1.55867,7.403922,2.033617),(-0.733453,7.341176,2.283488),(0.018706,7.278431,2.245944),(0.625702,7.215686,2.010866),(1.063944,7.152941,1.66865),(1.34455,7.090196,1.293553),(1.497906,7.027451,0.937212),(1.56087,6.964706,0.629542),(1.568302,6.901961,0.383586),(1.548721,6.839216,0.201513),(1.522967,6.776471,0.080046),(1.50454,6.713725,0.014537),(1.500511,6.65098,0.001616),(1.512252,6.588235,0.040542),(1.535604,6.52549,0.133469),(1.560399,6.462745,0.284651),(1.569571,6.4,0.498467),(1.538408,6.337255,0.776075),(1.434899,6.27451,1.110614),(1.222405,6.211765,1.481342),(0.865959,6.14902,1.847924),(0.342974,6.086275,2.14715),(-0.342284,6.023529,2.295298),(-1.143362,5.960784,2.19946),(-1.961047,5.898039,1.779592),(-2.644991,5.835294,0.999409),(-3.014311,5.772549,-0.101094),(-2.899332,5.709804,-1.383742),(-2.19822,5.647059,-2.615066),(-0.932544,5.584314,-3.503826),(0.720603,5.521569,-3.771914),(2.440376,5.458824,-3.24229),(3.825871,5.396078,-1.915075),(4.499968,5.333333,-3.0E-4),(4.222397,5.270588,2.112857),(2.972389,5.207843,3.948039),(0.968901,5.145098,5.068022),(-1.381548,5.082353,5.193523),(-3.592355,5.019608,4.274649),(-5.222678,4.956863,2.49336),(-5.980553,4.894118,0.20127),(-5.77425,4.831373,-2.181068),(-4.704197,4.768627,-4.26802),(-3.008341,4.705882,-5.785683),(-0.985753,4.643137,-6.606136),(1.076065,4.580392,-6.740235),(2.952526,4.517647,-6.301832),(4.505478,4.454902,-5.460615),(5.681991,4.392157,-4.398411),(6.496843,4.329412,-3.277851),(7.008137,4.266667,-2.225972),(7.293431,4.203922,-1.330719),(7.430568,4.141176,-0.646005),(7.484508,4.078431,-0.200746),(7.499483,4.015686,-0.008096),(7.495043,3.952941,-0.072364),(7.464642,3.890196,-0.392205),(7.376086,3.827451,-0.959544),(7.174083,3.764706,-1.754407),(6.785954,3.701961,-2.736602),(6.131975,3.639216,-3.836193),(5.141559,3.576471,-4.945913),(3.775099,3.513725,-5.919781),(2.048823,3.45098,-6.582597),(0.056845,3.388235,-6.753781),(-2.018258,3.32549,-6.285579),(-3.915759,3.262745,-5.110017),(-5.334339,3.2,-3.282506),(-5.995616,3.137255,-1.005402),(-5.721527,3.07451,1.384462),(-4.503243,3.011765,3.47215),(-2.535163,2.94902,4.857936),(-0.193746,2.886275,5.264002),(2.0421,2.823529,4.620101),(3.710203,2.760784,3.095576),(4.48709,2.698039,1.061306),(4.271502,2.635294,-1.009563),(3.200864,2.572549,-2.669714),(1.596982,2.509804,-3.611454),(-0.136684,2.447059,-3.730007),(-1.628232,2.384314,-3.121255),(-2.623908,2.321569,-2.023761),(-3.025985,2.258824,-0.732684),(-2.880588,2.196078,0.482625),(-2.33094,2.133333,1.433919),(-1.558729,2.070588,2.033587),(-0.73351,2.007843,2.283482),(0.018657,1.945098,2.245955),(0.625664,1.882353,2.010888),(1.063918,1.819608,1.668677),(1.344535,1.756863,1.293579),(1.497899,1.694118,0.937236),(1.560868,1.631373,0.629562),(1.568303,1.568627,0.383601),(1.548723,1.505882,0.201524),(1.522969,1.443137,0.080052),(1.504541,1.380392,0.01454),(1.500511,1.317647,0.001615),(1.51225,1.254902,0.040538),(1.535602,1.192157,0.133461),(1.560398,1.129412,0.284638),(1.569571,1.066667,0.498449),(1.538412,1.003922,0.776053),(1.43491,0.941176,1.110589),(1.222425,0.878431,1.481315),(0.865991,0.815686,1.847899),(0.343017,0.752941,2.147132),(-0.34223,0.690196,2.295295),(-1.143303,0.627451,2.199477),(-1.960991,0.564706,1.779635),(-2.644951,0.501961,0.999477),(-3.0143,0.439216,-0.101006),(-2.89936,0.376471,-1.383648),(-2.198291,0.313725,-2.614986),(-0.932652,0.25098,-3.503781),(0.720478,0.188235,-3.771922),(2.44026,0.12549,-3.242358),(3.825793,0.062745,-1.915195),(4.499952,0.0,-4.5E-4)])),
    Transform(DEF='Particle3',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(diffuseColor=(0.0,1.0,0.0))),
        geometry=Sphere(radius=0.8))]),
    PositionInterpolator(DEF='Position3',key=[0.0,0.003922,0.007843,0.011765,0.015686,0.019608,0.023529,0.027451,0.031373,0.035294,0.039216,0.043137,0.047059,0.05098,0.054902,0.058824,0.062745,0.066667,0.070588,0.07451,0.078431,0.082353,0.086275,0.090196,0.094118,0.098039,0.101961,0.105882,0.109804,0.113725,0.117647,0.121569,0.12549,0.129412,0.133333,0.137255,0.141176,0.145098,0.14902,0.152941,0.156863,0.160784,0.164706,0.168627,0.172549,0.176471,0.180392,0.184314,0.188235,0.192157,0.196078,0.2,0.203922,0.207843,0.211765,0.215686,0.219608,0.223529,0.227451,0.231373,0.235294,0.239216,0.243137,0.247059,0.25098,0.254902,0.258824,0.262745,0.266667,0.270588,0.27451,0.278431,0.282353,0.286275,0.290196,0.294118,0.298039,0.301961,0.305882,0.309804,0.313725,0.317647,0.321569,0.32549,0.329412,0.333333,0.337255,0.341176,0.345098,0.34902,0.352941,0.356863,0.360784,0.364706,0.368627,0.372549,0.376471,0.380392,0.384314,0.388235,0.392157,0.396078,0.4,0.403922,0.407843,0.411765,0.415686,0.419608,0.423529,0.427451,0.431373,0.435294,0.439216,0.443137,0.447059,0.45098,0.454902,0.458824,0.462745,0.466667,0.470588,0.47451,0.478431,0.482353,0.486275,0.490196,0.494118,0.498039,0.501961,0.505882,0.509804,0.513725,0.517647,0.521569,0.52549,0.529412,0.533333,0.537255,0.541176,0.545098,0.54902,0.552941,0.556863,0.560784,0.564706,0.568627,0.572549,0.576471,0.580392,0.584314,0.588235,0.592157,0.596078,0.6,0.603922,0.607843,0.611765,0.615686,0.619608,0.623529,0.627451,0.631373,0.635294,0.639216,0.643137,0.647059,0.65098,0.654902,0.658824,0.662745,0.666667,0.670588,0.67451,0.678431,0.682353,0.686275,0.690196,0.694118,0.698039,0.701961,0.705882,0.709804,0.713725,0.717647,0.721569,0.72549,0.729412,0.733333,0.737255,0.741176,0.745098,0.74902,0.752941,0.756863,0.760784,0.764706,0.768627,0.772549,0.776471,0.780392,0.784314,0.788235,0.792157,0.796078,0.8,0.803922,0.807843,0.811765,0.815686,0.819608,0.823529,0.827451,0.831373,0.835294,0.839216,0.843137,0.847059,0.85098,0.854902,0.858824,0.862745,0.866667,0.870588,0.87451,0.878431,0.882353,0.886275,0.890196,0.894118,0.898039,0.901961,0.905882,0.909804,0.913725,0.917647,0.921569,0.92549,0.929412,0.933333,0.937255,0.941176,0.945098,0.94902,0.952941,0.956863,0.960784,0.964706,0.968627,0.972549,0.976471,0.980392,0.984314,0.988235,0.992157,0.996078,1.0],keyValue=[(4.5,16.0,0.0),(4.222285,15.937255,2.113152),(2.972147,15.87451,3.948261),(0.968577,15.811765,5.068115),(-1.381887,15.74902,5.193465),(-3.59264,15.686275,4.274449),(-5.222854,15.623529,2.493058),(-5.980592,15.560784,0.200924),(-5.774154,15.498039,-2.181397),(-4.703992,15.435294,-4.268284),(-3.008067,15.372549,-5.785853),(-0.985454,15.309804,-6.606203),(1.076352,15.247059,-6.74021),(2.952774,15.184314,-6.301735),(4.505675,15.121569,-5.460474),(5.682133,15.058824,-4.398251),(6.496936,14.996078,-3.277692),(7.008193,14.933333,-2.225831),(7.293459,14.870588,-1.330604),(7.43058,14.807843,-0.645923),(7.484512,14.745098,-0.2007),(7.499483,14.682353,-0.008087),(7.495041,14.619608,-0.072391),(7.464635,14.556863,-0.392269),(7.376066,14.494118,-0.959643),(7.174043,14.431373,-1.754536),(6.785881,14.368627,-2.736753),(6.131858,14.305882,-3.836355),(5.141391,14.243137,-4.946066),(3.774876,14.180392,-5.919903),(2.048552,14.117647,-6.582661),(0.056548,14.054902,-6.753763),(-2.01855,13.992157,-6.285461),(-3.916004,13.929412,-5.109798),(-5.334494,13.866667,-3.282204),(-5.995646,13.803922,-1.005058),(-5.721417,13.741176,1.384793),(-4.503007,13.678431,3.472408),(-2.534843,13.615686,4.85807),(-0.193405,13.552941,5.263984),(2.04239,13.490196,4.619938),(3.710384,13.427451,3.09531),(4.48713,13.364706,1.061),(4.271404,13.301961,-1.00984),(3.200663,13.239216,-2.669906),(1.596733,13.176471,-3.61153),(-0.136923,13.113725,-3.729968),(-1.628415,13.05098,-3.121126),(-2.624009,12.988235,-2.023582),(-3.026001,12.92549,-0.732498),(-2.880534,12.862745,0.482784),(-2.330841,12.8,1.434032),(-1.558611,12.737255,2.033647),(-0.733395,12.67451,2.283495),(0.018755,12.611765,2.245933),(0.625739,12.54902,2.010844),(1.063969,12.486275,1.668624),(1.344565,12.423529,1.293526),(1.497913,12.360784,0.937188),(1.560872,12.298039,0.629522),(1.568301,12.235294,0.38357),(1.548719,12.172549,0.201502),(1.522966,12.109804,0.080039),(1.50454,12.047059,0.014534),(1.500511,11.984314,0.001617),(1.512253,11.921569,0.040547),(1.535606,11.858824,0.133478),(1.560401,11.796078,0.284664),(1.56957,11.733333,0.498484),(1.538403,11.670588,0.776097),(1.434888,11.607843,1.11064),(1.222385,11.545098,1.481369),(0.865928,11.482353,1.847949),(0.34293,11.419608,2.147167),(-0.342338,11.356863,2.295301),(-1.143422,11.294118,2.199442),(-1.961103,11.231373,1.779549),(-2.645031,11.168627,0.99934),(-3.014322,11.105882,-0.101182),(-2.899303,11.043137,-1.383835),(-2.198148,10.980392,-2.615145),(-0.932436,10.917647,-3.50387),(0.720729,10.854902,-3.771905),(2.440493,10.792157,-3.242222),(3.825949,10.729412,-1.914955),(4.499984,10.666667,-1.5E-4),(4.222341,10.603922,2.113005),(2.972268,10.541176,3.94815),(0.968739,10.478431,5.068068),(-1.381718,10.415686,5.193494),(-3.592498,10.352941,4.274549),(-5.222766,10.290196,2.493209),(-5.980573,10.227451,0.201097),(-5.774202,10.164706,-2.181232),(-4.704094,10.101961,-4.268152),(-3.008204,10.039216,-5.785768),(-0.985603,9.976471,-6.60617),(1.076209,9.913725,-6.740222),(2.95265,9.85098,-6.301783),(4.505577,9.788235,-5.460544),(5.682062,9.72549,-4.398331),(6.496889,9.662745,-3.277772),(7.008165,9.6,-2.225901),(7.293445,9.537255,-1.330661),(7.430574,9.47451,-0.645964),(7.48451,9.411765,-0.200723),(7.499483,9.34902,-0.008091),(7.495042,9.286275,-0.072378),(7.464639,9.223529,-0.392237),(7.376076,9.160784,-0.959594),(7.174063,9.098039,-1.754471),(6.785918,9.035294,-2.736678),(6.131916,8.972549,-3.836274),(5.141475,8.909804,-4.94599),(3.774987,8.847059,-5.919842),(2.048687,8.784314,-6.582629),(0.056696,8.721569,-6.753772),(-2.018404,8.658824,-6.28552),(-3.915881,8.596078,-5.109908),(-5.334416,8.533333,-3.282355),(-5.995631,8.470588,-1.00523),(-5.721472,8.407843,1.384627),(-4.503125,8.345098,3.472279),(-2.535003,8.282353,4.858003),(-0.193575,8.219608,5.263993),(2.042245,8.156863,4.620019),(3.710293,8.094118,3.095443),(4.48711,8.031373,1.061153),(4.271453,7.968627,-1.009701),(3.200763,7.905882,-2.66981),(1.596858,7.843137,-3.611492),(-0.136803,7.780392,-3.729987),(-1.628324,7.717647,-3.12119),(-2.623958,7.654902,-2.023671),(-3.025993,7.592157,-0.732591),(-2.880561,7.529412,0.482704),(-2.33089,7.466667,1.433975),(-1.55867,7.403922,2.033617),(-0.733453,7.341176,2.283488),(0.018706,7.278431,2.245944),(0.625702,7.215686,2.010866),(1.063944,7.152941,1.66865),(1.34455,7.090196,1.293553),(1.497906,7.027451,0.937212),(1.56087,6.964706,0.629542),(1.568302,6.901961,0.383586),(1.548721,6.839216,0.201513),(1.522967,6.776471,0.080046),(1.50454,6.713725,0.014537),(1.500511,6.65098,0.001616),(1.512252,6.588235,0.040542),(1.535604,6.52549,0.133469),(1.560399,6.462745,0.284651),(1.569571,6.4,0.498467),(1.538408,6.337255,0.776075),(1.434899,6.27451,1.110614),(1.222405,6.211765,1.481342),(0.865959,6.14902,1.847924),(0.342974,6.086275,2.14715),(-0.342284,6.023529,2.295298),(-1.143362,5.960784,2.19946),(-1.961047,5.898039,1.779592),(-2.644991,5.835294,0.999409),(-3.014311,5.772549,-0.101094),(-2.899332,5.709804,-1.383742),(-2.19822,5.647059,-2.615066),(-0.932544,5.584314,-3.503826),(0.720603,5.521569,-3.771914),(2.440376,5.458824,-3.24229),(3.825871,5.396078,-1.915075),(4.499968,5.333333,-3.0E-4),(4.222397,5.270588,2.112857),(2.972389,5.207843,3.948039),(0.968901,5.145098,5.068022),(-1.381548,5.082353,5.193523),(-3.592355,5.019608,4.274649),(-5.222678,4.956863,2.49336),(-5.980553,4.894118,0.20127),(-5.77425,4.831373,-2.181068),(-4.704197,4.768627,-4.26802),(-3.008341,4.705882,-5.785683),(-0.985753,4.643137,-6.606136),(1.076065,4.580392,-6.740235),(2.952526,4.517647,-6.301832),(4.505478,4.454902,-5.460615),(5.681991,4.392157,-4.398411),(6.496843,4.329412,-3.277851),(7.008137,4.266667,-2.225972),(7.293431,4.203922,-1.330719),(7.430568,4.141176,-0.646005),(7.484508,4.078431,-0.200746),(7.499483,4.015686,-0.008096),(7.495043,3.952941,-0.072364),(7.464642,3.890196,-0.392205),(7.376086,3.827451,-0.959544),(7.174083,3.764706,-1.754407),(6.785954,3.701961,-2.736602),(6.131975,3.639216,-3.836193),(5.141559,3.576471,-4.945913),(3.775099,3.513725,-5.919781),(2.048823,3.45098,-6.582597),(0.056845,3.388235,-6.753781),(-2.018258,3.32549,-6.285579),(-3.915759,3.262745,-5.110017),(-5.334339,3.2,-3.282506),(-5.995616,3.137255,-1.005402),(-5.721527,3.07451,1.384462),(-4.503243,3.011765,3.47215),(-2.535163,2.94902,4.857936),(-0.193746,2.886275,5.264002),(2.0421,2.823529,4.620101),(3.710203,2.760784,3.095576),(4.48709,2.698039,1.061306),(4.271502,2.635294,-1.009563),(3.200864,2.572549,-2.669714),(1.596982,2.509804,-3.611454),(-0.136684,2.447059,-3.730007),(-1.628232,2.384314,-3.121255),(-2.623908,2.321569,-2.023761),(-3.025985,2.258824,-0.732684),(-2.880588,2.196078,0.482625),(-2.33094,2.133333,1.433919),(-1.558729,2.070588,2.033587),(-0.73351,2.007843,2.283482),(0.018657,1.945098,2.245955),(0.625664,1.882353,2.010888),(1.063918,1.819608,1.668677),(1.344535,1.756863,1.293579),(1.497899,1.694118,0.937236),(1.560868,1.631373,0.629562),(1.568303,1.568627,0.383601),(1.548723,1.505882,0.201524),(1.522969,1.443137,0.080052),(1.504541,1.380392,0.01454),(1.500511,1.317647,0.001615),(1.51225,1.254902,0.040538),(1.535602,1.192157,0.133461),(1.560398,1.129412,0.284638),(1.569571,1.066667,0.498449),(1.538412,1.003922,0.776053),(1.43491,0.941176,1.110589),(1.222425,0.878431,1.481315),(0.865991,0.815686,1.847899),(0.343017,0.752941,2.147132),(-0.34223,0.690196,2.295295),(-1.143303,0.627451,2.199477),(-1.960991,0.564706,1.779635),(-2.644951,0.501961,0.999477),(-3.0143,0.439216,-0.101006),(-2.89936,0.376471,-1.383648),(-2.198291,0.313725,-2.614986),(-0.932652,0.25098,-3.503781),(0.720478,0.188235,-3.771922),(2.44026,0.12549,-3.242358),(3.825793,0.062745,-1.915195),(4.499952,0.0,-4.5E-4)]),
    TimeSensor(DEF='Timer3',cycleInterval=36.0,loop=True,stopTime=-1.0),
    ROUTE(fromField='fraction_changed',fromNode='Timer3',toField='set_fraction',toNode='Position3'),
    ROUTE(fromField='value_changed',fromNode='Position3',toField='set_translation',toNode='Particle3')])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for ExtrusionSpiral.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python ExtrusionSpiral.py load and self-test diagnostics complete.")
