package Vrml2Sourcebook.Chapter28Anchor;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Anchor parameter/target demonstrations: click left text to load another scene in the same window, or click right text to load another scene in a new window. </p>
 <p> Related links: Catalog page <a href="../../../Chapter28Anchor/Figure28_2AnchorLoadAnotherWorldIndex.html" target="_blank">Figure28_2AnchorLoadAnotherWorld</a>,  source <a href="../../../Chapter28Anchor/Figure28_2AnchorLoadAnotherWorld.java">Figure28_2AnchorLoadAnotherWorld.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Chapter28Anchor/Figure28_2AnchorLoadAnotherWorld.x3d">Figure28_2AnchorLoadAnotherWorld.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Figure 28.2, The VRML 2.0 Sourcebook, Copyright [1997] By Andrea L. Ames, David R. Nadeau, and John L. Moreland </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.wiley.com/legacy/compbooks/vrml2sbk/ch28/28fig02.htm" target="_blank">http://www.wiley.com/legacy/compbooks/vrml2sbk/ch28/28fig02.htm</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 6 October 2000 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Anchor parameter/target demonstrations: click left text to load another scene in the same window, or click right text to load another scene in a new window. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter28Anchor/Figure28_2AnchorLoadAnotherWorld.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter28Anchor/Figure28_2AnchorLoadAnotherWorld.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Chapter28Anchor/../../license.html">../../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Figure 28.2, The VRML 2.0 Sourcebook, Copyright [1997] By Andrea L. Ames, David R. Nadeau, and John L. Moreland
 */

public class Figure28_2AnchorLoadAnotherWorld
{
	/** Default constructor to create this object. */
	public Figure28_2AnchorLoadAnotherWorld ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("Figure28_2AnchorLoadAnotherWorld.x3d"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Figure 28.2, The VRML 2.0 Sourcebook, Copyright [1997] By Andrea L. Ames, David R. Nadeau, and John L. Moreland"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.wiley.com/legacy/compbooks/vrml2sbk/ch28/28fig02.htm"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("6 October 2000"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Anchor parameter/target demonstrations: click left text to load another scene in the same window, or click right text to load another scene in a new window."))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter28Anchor/Figure28_2AnchorLoadAnotherWorld.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("Figure28_2AnchorLoadAnotherWorld.x3d"))
    .addChild(new Viewpoint().setDescription("Forward view").setPosition(0.0,1.6,5.0))
    .addChild(new Viewpoint("RIGHT_CORNER_DEF_NAME").setDescription("Right corner view").setOrientation(0.0,1.0,0.0,0.611).setPosition(3.5,1.6,3.5))
    .addChild(new Viewpoint("LEFT_CORNER_DEF_NAME").setDescription("Left corner view").setOrientation(0.0,1.0,0.0,-0.611).setPosition(-3.5,1.6,3.5))
    .addChild(new NavigationInfo().setAvatarSize(new double[] {2.0,1.0,0.5}).setHeadlight(false).setSpeed(2).setType("\"EXAMINE\" \"WALK\" \"ANY\""))
    .addChild(new Inline().setUrl(new String[] {"../Chapter25LevelOfDetail/Figure25_12DungeonRoomsWithSlidingDoors.x3d","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter25LevelOfDetail/Figure25_12DungeonRoomsWithSlidingDoors.x3d","../Chapter25LevelOfDetail/Figure25_12DungeonRoomsWithSlidingDoors.wrl","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter25LevelOfDetail/Figure25_12DungeonRoomsWithSlidingDoors.wrl"}))
    .addChild(new Anchor().setDescription("Replace this scene by loading a new world").setUrl(new String[] {"../../Basic/course/HelloX3dAuthors.x3d","https://www.web3d.org/x3d/content/examples/Basic/course/HelloX3dAuthors.x3d","../../Basic/course/HelloX3dAuthors.wrl","https://www.web3d.org/x3d/content/examples/Basic/course/HelloX3dAuthors.wrl"})
      .addChild(new Transform().setTranslation(-1.75,0.6,0.15)
        .addChild(new Collision().setEnabled(false)
          .addChild(new Shape()
            .setGeometry(new Text().setString(new String[] {"Click for","new world in","same window"})
              .setFontStyle(new FontStyle("TextFontStyle").setJustify(FontStyle.JUSTIFY_MIDDLE_MIDDLE).setSize(0.2)))
            .setAppearance(new Appearance("TextAppearance")
              .setMaterial(new Material().setDiffuseColor(0.1,0.8,0.8).setEmissiveColor(0.0,0.4,0.4).setShininess(0.4).setSpecularColor(0.8,0.8,0.8))))
          .addChild(new Transform("BackingBoxForText").setTranslation(0.0,-0.175,-0.1)
            .addChild(new Shape()
              .setGeometry(new Box().setSize(1.2,0.75,0.02))
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9).setEmissiveColor(0.9,0.9,0.9))))))))
    .addComments(" Anchor parameter target=_blank launches browser results into a new window ")
    .addChild(new Anchor().setDescription("Pop up a new world in a different window").setParameter(new String[] {"target=_blank"}).setUrl(new String[] {"../../Basic/course/HelloX3dAuthors.x3d","https://www.web3d.org/x3d/content/examples/Basic/course/HelloX3dAuthors.x3d","../../Basic/course/HelloX3dAuthors.wrl","https://www.web3d.org/x3d/content/examples/Basic/course/HelloX3dAuthors.wrl"})
      .addChild(new Transform().setTranslation(1.75,0.6,0.15)
        .addChild(new Collision().setEnabled(false)
          .addChild(new Shape()
            .setGeometry(new Text().setString(new String[] {"Click for","new world in","new window"})
              .setFontStyle(new FontStyle().setUSE("TextFontStyle")))
            .setAppearance(new Appearance().setUSE("TextAppearance")))
          .addChild(new Transform().setUSE("BackingBoxForText"))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return Figure28_2AnchorLoadAnotherWorld model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new Figure28_2AnchorLoadAnotherWorld().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Vrml2Sourcebook.Chapter28Anchor.Figure28_2AnchorLoadAnotherWorld\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Vrml2Sourcebook.Chapter28Anchor.Figure28_2AnchorLoadAnotherWorld self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Chapter28Anchor/Figure28_2AnchorLoadAnotherWorld_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Chapter28Anchor/Figure28_2AnchorLoadAnotherWorld_JavaExport.x3d"; 
                String filenameX3DV = "Chapter28Anchor/Figure28_2AnchorLoadAnotherWorld_JavaExport.x3dv"; 
                String filenameJSON = "Chapter28Anchor/Figure28_2AnchorLoadAnotherWorld_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
