package Vrml2Sourcebook.Chapter25LevelOfDetail;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> A high-detail torch. </p>
 <p> Related links: Catalog page <a href="../../../Chapter25LevelOfDetail/Figure25_01TorchHighDetailIndex.html" target="_blank">Figure25_01TorchHighDetail</a>,  source <a href="../../../Chapter25LevelOfDetail/Figure25_01TorchHighDetail.java">Figure25_01TorchHighDetail.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Chapter25LevelOfDetail/Figure25_01TorchHighDetail.x3d">Figure25_01TorchHighDetail.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Figure 25.1, The VRML 2.0 Sourcebook, Copyright [1997] By Andrea L. Ames, David R. Nadeau, and John L. Moreland </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.wiley.com/legacy/compbooks/vrml2sbk/ch25/25fig01.htm" target="_blank">http://www.wiley.com/legacy/compbooks/vrml2sbk/ch25/25fig01.htm</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 3 October 2000 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> A high-detail torch. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter25LevelOfDetail/Figure25_01TorchHighDetail.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter25LevelOfDetail/Figure25_01TorchHighDetail.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Chapter25LevelOfDetail/../../license.html">../../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Figure 25.1, The VRML 2.0 Sourcebook, Copyright [1997] By Andrea L. Ames, David R. Nadeau, and John L. Moreland
 */

public class Figure25_01TorchHighDetail
{
	/** Default constructor to create this object. */
	public Figure25_01TorchHighDetail ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERCHANGE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("Figure25_01TorchHighDetail.x3d"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Figure 25.1, The VRML 2.0 Sourcebook, Copyright [1997] By Andrea L. Ames, David R. Nadeau, and John L. Moreland"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.wiley.com/legacy/compbooks/vrml2sbk/ch25/25fig01.htm"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("3 October 2000"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("A high-detail torch."))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter25LevelOfDetail/Figure25_01TorchHighDetail.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("Figure25_01TorchHighDetail.x3d"))
    .addChild(new Viewpoint().setDescription("Torch (high detail)").setPosition(0.0,0.0,2.0))
    .addChild(new Transform().setScale(0.5,0.5,0.5).setTranslation(0.0,0.0,0.2)
      .addChild(new Transform().setRotation(1.0,0.0,0.0,3.14).setTranslation(0.0,-0.75,0.0)
        .addChild(new Shape()
          .setGeometry(new Cone().setBottomRadius(0.15).setHeight(1.5))
          .setAppearance(new Appearance("Gray")
            .setMaterial(new Material().setDiffuseColor(0.4,0.4,0.4).setSpecularColor(0.7,0.7,0.7)))))
      .addChild(new Shape("Ring")
        .setGeometry(new Cylinder().setBottom(false).setHeight(0.1).setRadius(0.4).setTop(false))
        .setAppearance(new Appearance().setUSE("Gray")))
      .addChild(new Transform().setTranslation(0.0,0.2,0.0)
        .addChild(new Shape().setUSE("Ring")))
      .addChild(new Shape("Bar")
        .setGeometry(new IndexedFaceSet().setCoordIndex(new int[] {0,1,2,3})
          .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.04,0.00,0.38,0.04,0.35,0.38,-0.04,0.35,0.38,-0.04,0.00,0.38}))))
        .setAppearance(new Appearance().setUSE("Gray")))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,-1.571)
        .addChild(new Shape().setUSE("Bar")))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.785)
        .addChild(new Shape().setUSE("Bar")))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,0.785)
        .addChild(new Shape().setUSE("Bar")))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.571)
        .addChild(new Shape().setUSE("Bar")))
      .addChild(new Transform().setTranslation(0.0,-0.35,0.0)
        .addChild(new Shape()
          .setGeometry(new Cylinder().setHeight(0.15).setRadius(0.20))
          .setAppearance(new Appearance().setUSE("Gray")))
        .addChild(new Transform().setTranslation(0.0,0.0,-0.2)
          .addChild(new Shape()
            .setGeometry(new Box().setSize(0.45,0.25,0.39))
            .setAppearance(new Appearance().setUSE("Gray")))))
      .addChild(new Shape("Flames")
        .addComments(" No appearance, use emissive shading ")
        .setGeometry(new IndexedFaceSet().setCoordIndex(new int[] {0,1,2,-1,3,4,5,-1,6,7,8,-1})
          .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.25,0.0,0.00,0.15,1.0,0.10,0.05,0.0,0.15,0.18,0.0,0.05,0.00,1.2,0.05,-0.10,0.0,0.05,-0.00,0.0,0.15,-0.13,0.8,0.10,-0.25,0.0,0.00})))
          .setColor(new Color().setColor(new MFColor(new double[] {1.0,0.0,0.0,0.9,0.5,0.0,1.0,0.0,0.0,0.9,0.3,0.0,1.0,1.0,0.0,0.9,0.3,0.0,0.7,0.1,0.2,0.9,0.8,0.0,1.0,0.0,0.0})))))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setScale(0.9,0.9,1.0)
        .addChild(new Shape().setUSE("Flames")))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,-1.57).setScale(0.9,0.9,1.0)
        .addChild(new Shape().setUSE("Flames")))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return Figure25_01TorchHighDetail model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new Figure25_01TorchHighDetail().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Vrml2Sourcebook.Chapter25LevelOfDetail.Figure25_01TorchHighDetail\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Vrml2Sourcebook.Chapter25LevelOfDetail.Figure25_01TorchHighDetail self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Chapter25LevelOfDetail/Figure25_01TorchHighDetail_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Chapter25LevelOfDetail/Figure25_01TorchHighDetail_JavaExport.x3d"; 
                String filenameX3DV = "Chapter25LevelOfDetail/Figure25_01TorchHighDetail_JavaExport.x3dv"; 
                String filenameJSON = "Chapter25LevelOfDetail/Figure25_01TorchHighDetail_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
