/**
 *<p>
 *	Fog simulates atmospheric effects by blending distant objects with fog color.
 *</p>
 * 
 *<p>
 *    Fog increases realism and can be used to set a mood, even indoors.
 *    Add fog outside to create hazy worlds, or add fog inside to create dark dungeons.
 *    Fog has a color, a type, and a visibility range.
 *    Fog limits the viewer's sight, reducing the amount of the world you have to build and the amount of the world that must be drawn.
 *</p>
 *
 *<p>
 *       These X3D scenes are adapted directly from the
 *       <a href="http://www.wiley.com/legacy/compbooks/vrml2sbk/toc/ch23.htm" target="Vrml2Sourcebook">original VRML 2.0 Sourcebook chapter examples</a>.
 *       Also available:
 *       <a href="http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0325.htm" target="Vrml2SourcebookCourse">Introduction to VRML97 SIGGRAPH98 course notes</a>.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter23Fog" target="_blank">X3D VRML2 Sourcebook Chapter 23 Fog</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Vrml2Sourcebook.Chapter23Fog;

