/**
 *<p>
 *	Lights provide virtual illumination that allows objects to be seen.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/" target="_blank">X3D VRML2 Sourcebook </a> examples archive
 *      is online.
 *</p>
 *<p>
 *        By default, you have one light in the scene, attached to your head.
 *        For more realism, you can add multiple lights: suns, light bulbs, candles, flashlights, spotlights, firelight.
 *        Lights can be positioned, oriented, and colored.
 *        Lights do not cast shadows.
 *</p>
 *
 *<p>
 *        There are three types of lights: PointLight, DirectionalLight, and SpotLight.
 *        All lights have an on/off, intensity, ambient effect, and color fields.
 *        PointLight and SpotLight nodes have a location, radius, and attenuation.
 *        DirectionalLight and SpotLight nodes have a direction.
 *</p>
 *
 *<p>
 *       These X3D scenes are adapted directly from the
 *       <a href="http://www.wiley.com/legacy/compbooks/vrml2sbk/toc/ch20.htm" target="Vrml2Sourcebook">original VRML 2.0 Sourcebook chapter examples</a>.
 *       Also available:
 *       <a href="http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0299.htm" target="Vrml2SourcebookCourse">Introduction to VRML97 SIGGRAPH98 course notes</a>.
 *</p>
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter20Lighting" target="_blank">X3D VRML2 Sourcebook Chapter 20 Lighting</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Vrml2Sourcebook.Chapter20Lighting;

