/**
 *<p>
 *	Normal (perpendicular) vectors defined for individual points or polygons can change the shading of geometry.
 *</p>
 *<p>
 *    When shaded, the faces on a shape are obvious.
 *    Creating a smooth shape may require a large number of small faces.
 *    An alternative is to instead use smooth shading to create the illusion of a smooth shape, but with a smaller number of faces.
 *</p>
 *
 *
 *<p>
 *    The Normal node lists normal vectors to use for parts of a shape which can change shading.
 *    These are used as the value of the normal field, and normal index values select which normals to use (similar to color index values).
 *    Ordinarily the creaseAngle field controls faceted or smooth shading.
 *    Normals override the normal effect of the creaseAngle value.
 *    The normalPerVertex field selects normal per face/grid square or normal per coordinate.
 *    The NormalInterpolator node converts time values to normal values for animation effects.
 *</p>
 *
 *<p>
 *       These X3D scenes are adapted directly from the
 *       <a href="http://www.wiley.com/legacy/compbooks/vrml2sbk/toc/ch19.htm" target="Vrml2Sourcebook">original VRML 2.0 Sourcebook chapter examples</a>.
 *       Also available:
 *       <a href="http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0238.htm" target="Vrml2SourcebookCourse">Introduction to VRML97 SIGGRAPH98 course notes</a>.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter19NormalsShading" target="_blank">X3D VRML2 Sourcebook Chapter 19 Normals Shading</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Vrml2Sourcebook.Chapter19NormalsShading;

