/**
 *<p>
 *	Textures are 2D images that can be wrapped on top of 3D geometry.
 *</p>
 *<p>
 *    You can model every tiny texture detail of a world using a vast number of colored faces, but this is time consuming and difficult.
 *    Use a trick instead:  take a picture of the real thing, then paste that picture on the shape, like sticking on a decal image.
 *    Specify the texture using an ImageTexture, PixelTexture, or MovieTexture node within an Appearance node.
 *    Color textures override material, greyscale textures multiply against the color values.
 *    Textures with transparency create holes that can be seen through.
 *</p>
 *
 *<p>
 *       These X3D scenes are adapted directly from the
 *       <a href="http://www.wiley.com/legacy/compbooks/vrml2sbk/toc/ch17.htm" target="Vrml2Sourcebook">original VRML 2.0 Sourcebook chapter examples</a>.
 *       Also available:
 *       <a href="http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0259.htm" target="Vrml2SourcebookCourse">Introduction to VRML97 SIGGRAPH98 course notes</a>.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter17Textures" target="_blank">X3D VRML2 Sourcebook Chapter 17 Textures</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Vrml2Sourcebook.Chapter17Textures;

