####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python Figure14_5ElevationGridTerrain.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interactive',version='3.0',
  head=head(
    children=[
    meta(content='Figure14_5ElevationGridTerrain.x3d',name='title'),
    meta(content='Figure 14.5, The VRML 2.0 Sourcebook, Copyright [1997] By Andrea L. Ames, David R. Nadeau, and John L. Moreland',name='creator'),
    meta(content='http://www.wiley.com/legacy/compbooks/vrml2sbk/ch14/14fig05.htm',name='reference'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='19 August 2000',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='An elevation grid built using an automatic terrain-generator application.',name='description'),
    meta(content='https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter14ElevationGrid/Figure14_5ElevationGridTerrain.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../../license.html',name='license')]),
  Scene=Scene(
    #  WALK mode permits the camera to move around in terrain-following mode. ANY gives the user liberty to change navigation modes if desired. 
    #  Note that avatarSize must be adjusted to match collision distance between camera and geometry, height of eye above ground, and highest distance that camera is able to walk over.. 
    children=[
    WorldInfo(title='Figure14_5ElevationGridTerrain.x3d'),
    NavigationInfo(avatarSize=[0.1,0.1,4],type='"WALK" "ANY"'),
    #  A height of 10m above the ElevationGrid ensures that the camera will fall and land on top of the ground while in WALK mode. 
    #  Be careful not to provide viewpoints that are beneath terrain or initially locked in a collision location, or else the camera will not be able to move. 
    Viewpoint(description='Look at all terrain',orientation=(1,0,0,-0.6),position=(0,20,25)),
    Viewpoint(description='Walk around using mouse or arrow keys',position=(0,10,0)),
    Transform(center=(0.9,0,0.9),rotation=(0,1,0,1.57),scale=(10,10,10),translation=(-0.9,0.0,-0.9),
      children=[
      Shape(
        appearance=Appearance(
          material=Material(diffuseColor=(0.4,0.6,0.3),emissiveColor=(0,0.05,0))),
        geometry=ElevationGrid(creaseAngle=0.785,height=[0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.37,0.36,0.36,0.35,0.35,0.35,0.35,0.34,0.33,0.32,0.32,0.31,0.31,0.31,0.31,0.30,0.29,0.28,0.28,0.27,0.27,0.27,0.27,0.27,0.27,0.27,0.27,0.27,0.27,0.27,0.28,0.28,0.29,0.30,0.30,0.31,0.31,0.32,0.32,0.33,0.33,0.33,0.33,0.32,0.32,0.32,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.30,0.30,0.28,0.27,0.27,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.21,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.39,0.39,0.38,0.38,0.37,0.37,0.37,0.36,0.36,0.36,0.35,0.35,0.35,0.34,0.34,0.33,0.32,0.32,0.31,0.31,0.31,0.30,0.29,0.28,0.28,0.27,0.27,0.27,0.27,0.27,0.26,0.26,0.26,0.26,0.26,0.27,0.27,0.28,0.29,0.29,0.30,0.30,0.30,0.31,0.32,0.32,0.33,0.33,0.32,0.32,0.32,0.32,0.32,0.31,0.32,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.30,0.29,0.28,0.28,0.27,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.21,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.37,0.36,0.36,0.36,0.35,0.35,0.35,0.35,0.34,0.33,0.32,0.32,0.31,0.31,0.31,0.30,0.29,0.28,0.27,0.27,0.27,0.27,0.26,0.26,0.26,0.26,0.25,0.25,0.25,0.26,0.26,0.27,0.28,0.29,0.29,0.29,0.30,0.30,0.31,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.30,0.31,0.30,0.29,0.28,0.27,0.27,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.21,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.36,0.36,0.36,0.35,0.35,0.35,0.34,0.33,0.32,0.32,0.31,0.31,0.30,0.29,0.29,0.28,0.27,0.27,0.26,0.26,0.26,0.25,0.25,0.24,0.24,0.24,0.24,0.24,0.25,0.26,0.27,0.28,0.28,0.29,0.29,0.29,0.30,0.31,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.30,0.30,0.30,0.29,0.28,0.27,0.27,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.21,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.36,0.36,0.36,0.36,0.35,0.35,0.34,0.33,0.32,0.31,0.31,0.30,0.29,0.29,0.28,0.27,0.27,0.26,0.26,0.25,0.25,0.24,0.24,0.24,0.23,0.23,0.23,0.23,0.24,0.25,0.26,0.27,0.27,0.28,0.28,0.29,0.30,0.30,0.31,0.31,0.32,0.32,0.32,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.30,0.30,0.30,0.29,0.29,0.28,0.27,0.27,0.26,0.24,0.24,0.22,0.22,0.21,0.21,0.21,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.36,0.36,0.36,0.36,0.36,0.35,0.34,0.33,0.32,0.31,0.30,0.29,0.29,0.28,0.28,0.27,0.27,0.26,0.25,0.24,0.24,0.24,0.23,0.23,0.22,0.22,0.22,0.22,0.22,0.23,0.24,0.25,0.26,0.27,0.27,0.28,0.28,0.29,0.30,0.30,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.30,0.30,0.30,0.30,0.29,0.28,0.27,0.27,0.26,0.25,0.24,0.23,0.22,0.22,0.21,0.21,0.20,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.36,0.36,0.36,0.36,0.36,0.35,0.35,0.34,0.32,0.31,0.30,0.29,0.28,0.28,0.27,0.27,0.26,0.25,0.25,0.24,0.24,0.23,0.22,0.22,0.22,0.21,0.21,0.21,0.21,0.21,0.22,0.23,0.24,0.25,0.26,0.26,0.27,0.28,0.28,0.29,0.30,0.30,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.30,0.31,0.30,0.30,0.29,0.29,0.28,0.27,0.27,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.21,0.20,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.36,0.36,0.36,0.36,0.36,0.35,0.34,0.33,0.31,0.30,0.29,0.28,0.27,0.26,0.26,0.25,0.25,0.24,0.24,0.23,0.22,0.22,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.22,0.23,0.23,0.24,0.25,0.26,0.27,0.27,0.28,0.29,0.29,0.30,0.30,0.30,0.31,0.31,0.31,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.29,0.29,0.28,0.27,0.27,0.26,0.25,0.24,0.24,0.23,0.22,0.21,0.21,0.21,0.20,0.39,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.36,0.36,0.36,0.36,0.35,0.35,0.34,0.33,0.32,0.30,0.29,0.28,0.27,0.26,0.25,0.25,0.24,0.24,0.23,0.23,0.22,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.22,0.22,0.23,0.24,0.25,0.26,0.27,0.27,0.28,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.29,0.29,0.29,0.28,0.28,0.27,0.27,0.26,0.25,0.24,0.23,0.22,0.22,0.21,0.21,0.20,0.20,0.39,0.39,0.40,0.39,0.40,0.40,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.36,0.35,0.35,0.36,0.36,0.35,0.35,0.34,0.32,0.31,0.29,0.28,0.27,0.25,0.24,0.24,0.24,0.23,0.23,0.22,0.22,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.22,0.23,0.24,0.25,0.25,0.26,0.27,0.27,0.28,0.28,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.28,0.28,0.28,0.27,0.27,0.26,0.25,0.24,0.24,0.23,0.22,0.22,0.21,0.21,0.20,0.20,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.35,0.35,0.35,0.35,0.35,0.35,0.35,0.34,0.32,0.31,0.30,0.28,0.27,0.26,0.25,0.24,0.23,0.23,0.22,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.22,0.22,0.23,0.24,0.24,0.25,0.26,0.26,0.27,0.27,0.28,0.28,0.28,0.28,0.29,0.29,0.29,0.28,0.28,0.28,0.28,0.28,0.27,0.27,0.26,0.25,0.25,0.24,0.23,0.23,0.22,0.21,0.21,0.20,0.20,0.20,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.36,0.35,0.35,0.35,0.35,0.35,0.34,0.34,0.33,0.31,0.30,0.29,0.27,0.26,0.25,0.24,0.23,0.22,0.22,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.22,0.22,0.23,0.24,0.24,0.25,0.25,0.26,0.27,0.27,0.27,0.27,0.28,0.28,0.28,0.28,0.28,0.27,0.27,0.27,0.27,0.26,0.25,0.24,0.24,0.23,0.23,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.38,0.37,0.37,0.36,0.35,0.35,0.35,0.35,0.34,0.34,0.34,0.33,0.32,0.31,0.30,0.29,0.28,0.27,0.26,0.24,0.23,0.22,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.21,0.22,0.23,0.23,0.24,0.25,0.25,0.26,0.26,0.27,0.27,0.27,0.27,0.27,0.27,0.27,0.27,0.26,0.26,0.25,0.25,0.24,0.23,0.23,0.22,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.39,0.39,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.35,0.35,0.34,0.34,0.33,0.33,0.32,0.31,0.30,0.29,0.28,0.27,0.27,0.26,0.24,0.23,0.22,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.21,0.22,0.23,0.23,0.24,0.25,0.26,0.26,0.27,0.27,0.27,0.27,0.27,0.26,0.26,0.26,0.25,0.24,0.24,0.23,0.23,0.22,0.22,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.38,0.38,0.39,0.39,0.38,0.38,0.38,0.38,0.38,0.38,0.37,0.36,0.36,0.35,0.35,0.34,0.33,0.33,0.32,0.31,0.30,0.29,0.28,0.27,0.26,0.26,0.25,0.25,0.23,0.22,0.22,0.21,0.21,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.22,0.23,0.24,0.25,0.25,0.26,0.26,0.26,0.26,0.26,0.25,0.25,0.25,0.24,0.24,0.23,0.23,0.22,0.22,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.35,0.34,0.33,0.32,0.31,0.30,0.29,0.28,0.26,0.25,0.24,0.24,0.24,0.24,0.23,0.22,0.21,0.21,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.22,0.23,0.23,0.24,0.25,0.25,0.25,0.25,0.25,0.25,0.25,0.24,0.24,0.24,0.23,0.23,0.22,0.22,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.37,0.37,0.36,0.35,0.35,0.34,0.33,0.32,0.32,0.30,0.29,0.28,0.26,0.24,0.23,0.23,0.23,0.23,0.22,0.22,0.21,0.20,0.19,0.19,0.19,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.22,0.23,0.24,0.24,0.24,0.24,0.24,0.24,0.24,0.24,0.24,0.24,0.23,0.23,0.22,0.22,0.22,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.35,0.34,0.33,0.32,0.32,0.30,0.29,0.27,0.25,0.24,0.23,0.21,0.21,0.21,0.21,0.21,0.20,0.19,0.19,0.18,0.17,0.17,0.16,0.16,0.16,0.16,0.17,0.17,0.17,0.17,0.18,0.18,0.18,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.22,0.23,0.23,0.24,0.24,0.24,0.23,0.23,0.24,0.23,0.24,0.24,0.23,0.23,0.22,0.22,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.37,0.38,0.38,0.38,0.38,0.37,0.37,0.37,0.36,0.36,0.35,0.34,0.33,0.32,0.32,0.31,0.29,0.28,0.26,0.24,0.23,0.21,0.21,0.20,0.20,0.19,0.19,0.18,0.17,0.16,0.16,0.15,0.15,0.14,0.14,0.14,0.14,0.15,0.15,0.15,0.16,0.16,0.16,0.17,0.17,0.18,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.22,0.22,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.22,0.22,0.22,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.36,0.36,0.35,0.34,0.34,0.33,0.32,0.31,0.30,0.28,0.27,0.25,0.23,0.22,0.21,0.20,0.19,0.18,0.18,0.17,0.16,0.15,0.14,0.13,0.12,0.12,0.12,0.12,0.12,0.12,0.12,0.13,0.13,0.14,0.14,0.15,0.15,0.16,0.17,0.17,0.18,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.22,0.22,0.22,0.23,0.23,0.22,0.23,0.23,0.23,0.24,0.23,0.23,0.22,0.22,0.22,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.20,0.37,0.37,0.37,0.37,0.37,0.37,0.36,0.36,0.35,0.35,0.34,0.33,0.32,0.31,0.30,0.29,0.27,0.25,0.24,0.22,0.21,0.20,0.19,0.18,0.16,0.15,0.14,0.13,0.12,0.11,0.10,0.10,0.10,0.10,0.10,0.09,0.10,0.10,0.10,0.11,0.11,0.12,0.13,0.14,0.14,0.15,0.16,0.17,0.18,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.22,0.22,0.22,0.22,0.22,0.23,0.23,0.23,0.23,0.23,0.23,0.22,0.22,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.20,0.20,0.20,0.37,0.37,0.37,0.37,0.36,0.36,0.36,0.35,0.34,0.34,0.33,0.32,0.32,0.31,0.29,0.28,0.26,0.24,0.23,0.21,0.20,0.19,0.17,0.16,0.14,0.12,0.11,0.10,0.09,0.08,0.08,0.08,0.08,0.07,0.07,0.07,0.07,0.07,0.08,0.08,0.09,0.10,0.11,0.12,0.13,0.13,0.14,0.15,0.16,0.17,0.18,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.22,0.22,0.22,0.22,0.22,0.22,0.23,0.23,0.23,0.23,0.22,0.22,0.22,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.20,0.20,0.20,0.36,0.36,0.36,0.36,0.36,0.35,0.35,0.34,0.34,0.33,0.33,0.32,0.31,0.30,0.29,0.27,0.25,0.23,0.21,0.19,0.18,0.16,0.14,0.12,0.10,0.09,0.08,0.07,0.06,0.06,0.06,0.06,0.06,0.05,0.05,0.05,0.05,0.05,0.05,0.06,0.07,0.07,0.09,0.10,0.11,0.12,0.13,0.14,0.15,0.16,0.17,0.18,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.22,0.22,0.22,0.22,0.22,0.22,0.23,0.23,0.23,0.22,0.22,0.22,0.21,0.21,0.21,0.21,0.20,0.20,0.19,0.19,0.19,0.19,0.20,0.20,0.36,0.36,0.36,0.36,0.35,0.35,0.35,0.34,0.33,0.33,0.32,0.31,0.30,0.29,0.28,0.25,0.23,0.21,0.20,0.18,0.16,0.13,0.11,0.09,0.07,0.06,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.05,0.05,0.06,0.06,0.08,0.09,0.10,0.11,0.12,0.13,0.14,0.15,0.17,0.18,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.22,0.22,0.22,0.22,0.22,0.22,0.22,0.22,0.22,0.22,0.22,0.21,0.21,0.21,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.35,0.35,0.35,0.35,0.35,0.34,0.34,0.33,0.33,0.32,0.31,0.31,0.29,0.28,0.26,0.24,0.22,0.20,0.18,0.15,0.12,0.10,0.07,0.06,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.05,0.05,0.06,0.07,0.09,0.10,0.11,0.12,0.13,0.14,0.15,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.21,0.22,0.22,0.22,0.22,0.22,0.22,0.22,0.22,0.22,0.21,0.21,0.21,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.35,0.34,0.34,0.34,0.34,0.34,0.33,0.33,0.32,0.32,0.31,0.30,0.28,0.27,0.24,0.22,0.20,0.17,0.15,0.12,0.09,0.06,0.05,0.04,0.03,0.03,0.03,0.03,0.03,0.04,0.04,0.04,0.05,0.04,0.04,0.05,0.05,0.04,0.04,0.04,0.04,0.04,0.05,0.05,0.06,0.07,0.08,0.10,0.10,0.11,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.21,0.22,0.22,0.22,0.22,0.22,0.21,0.21,0.21,0.21,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.34,0.34,0.34,0.34,0.33,0.33,0.33,0.32,0.32,0.31,0.30,0.29,0.27,0.25,0.22,0.20,0.17,0.15,0.12,0.08,0.05,0.04,0.03,0.02,0.02,0.02,0.02,0.02,0.03,0.04,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.04,0.04,0.04,0.05,0.05,0.06,0.07,0.08,0.10,0.10,0.11,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.33,0.33,0.33,0.33,0.33,0.33,0.32,0.32,0.31,0.30,0.29,0.27,0.25,0.23,0.20,0.18,0.15,0.12,0.08,0.05,0.03,0.02,0.02,0.01,0.01,0.01,0.02,0.02,0.03,0.04,0.05,0.05,0.06,0.06,0.07,0.07,0.07,0.07,0.06,0.06,0.05,0.05,0.04,0.05,0.05,0.05,0.06,0.08,0.09,0.09,0.10,0.11,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.33,0.33,0.33,0.33,0.33,0.32,0.32,0.31,0.30,0.29,0.28,0.26,0.23,0.21,0.18,0.15,0.12,0.08,0.06,0.04,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.04,0.05,0.06,0.06,0.07,0.07,0.08,0.08,0.08,0.08,0.08,0.07,0.06,0.05,0.05,0.05,0.05,0.05,0.06,0.07,0.08,0.08,0.09,0.10,0.11,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.34,0.33,0.33,0.33,0.32,0.32,0.31,0.31,0.29,0.28,0.26,0.24,0.21,0.19,0.15,0.12,0.09,0.06,0.04,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.03,0.05,0.06,0.07,0.08,0.08,0.08,0.09,0.09,0.09,0.10,0.09,0.08,0.08,0.07,0.06,0.05,0.05,0.05,0.06,0.06,0.06,0.07,0.08,0.09,0.09,0.11,0.12,0.13,0.14,0.16,0.17,0.18,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.33,0.33,0.33,0.32,0.32,0.31,0.31,0.30,0.28,0.27,0.24,0.22,0.19,0.16,0.13,0.09,0.06,0.04,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.05,0.06,0.07,0.08,0.08,0.09,0.09,0.10,0.10,0.11,0.11,0.10,0.10,0.09,0.08,0.07,0.06,0.06,0.06,0.06,0.06,0.06,0.06,0.06,0.07,0.08,0.09,0.10,0.12,0.13,0.15,0.16,0.18,0.18,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.33,0.33,0.32,0.32,0.31,0.30,0.29,0.28,0.27,0.24,0.22,0.19,0.16,0.13,0.10,0.07,0.04,0.03,0.02,0.01,0.01,0.01,0.01,0.02,0.02,0.03,0.05,0.06,0.08,0.08,0.09,0.09,0.10,0.11,0.12,0.12,0.12,0.12,0.12,0.11,0.10,0.09,0.08,0.08,0.07,0.06,0.06,0.06,0.06,0.05,0.05,0.05,0.06,0.08,0.09,0.11,0.12,0.13,0.15,0.16,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.33,0.32,0.32,0.31,0.30,0.29,0.28,0.27,0.25,0.22,0.20,0.17,0.14,0.10,0.07,0.04,0.03,0.02,0.01,0.01,0.01,0.01,0.02,0.02,0.03,0.05,0.06,0.08,0.09,0.09,0.10,0.11,0.12,0.13,0.14,0.14,0.14,0.14,0.13,0.13,0.12,0.11,0.10,0.09,0.08,0.08,0.07,0.06,0.06,0.05,0.05,0.05,0.05,0.06,0.08,0.09,0.11,0.12,0.13,0.15,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.32,0.31,0.31,0.30,0.29,0.28,0.26,0.25,0.22,0.20,0.17,0.14,0.11,0.07,0.05,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.05,0.07,0.08,0.09,0.10,0.11,0.11,0.13,0.14,0.15,0.16,0.16,0.16,0.16,0.15,0.14,0.13,0.12,0.12,0.11,0.10,0.09,0.08,0.07,0.06,0.05,0.04,0.04,0.05,0.05,0.07,0.08,0.10,0.11,0.12,0.14,0.15,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.31,0.30,0.29,0.28,0.27,0.26,0.24,0.22,0.20,0.17,0.14,0.11,0.08,0.05,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.05,0.07,0.08,0.10,0.10,0.11,0.12,0.13,0.14,0.16,0.17,0.17,0.18,0.17,0.17,0.17,0.16,0.15,0.14,0.13,0.12,0.11,0.10,0.09,0.08,0.07,0.06,0.05,0.04,0.04,0.05,0.05,0.07,0.08,0.10,0.11,0.13,0.14,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.21,0.21,0.20,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.18,0.18,0.18,0.18,0.19,0.29,0.28,0.27,0.26,0.25,0.24,0.22,0.20,0.17,0.14,0.11,0.08,0.05,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.04,0.06,0.08,0.10,0.11,0.11,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.19,0.19,0.19,0.18,0.17,0.17,0.16,0.15,0.14,0.13,0.12,0.11,0.09,0.08,0.06,0.05,0.05,0.04,0.04,0.05,0.05,0.07,0.09,0.10,0.11,0.13,0.14,0.16,0.17,0.18,0.19,0.20,0.20,0.20,0.20,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.18,0.18,0.18,0.18,0.18,0.18,0.27,0.26,0.25,0.24,0.23,0.21,0.19,0.17,0.14,0.11,0.08,0.06,0.04,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.02,0.04,0.05,0.08,0.09,0.11,0.11,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.18,0.17,0.16,0.15,0.14,0.13,0.12,0.11,0.09,0.08,0.06,0.05,0.05,0.04,0.04,0.05,0.06,0.07,0.09,0.10,0.12,0.13,0.15,0.16,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.21,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.18,0.18,0.18,0.17,0.17,0.17,0.17,0.17,0.25,0.24,0.23,0.21,0.20,0.18,0.16,0.14,0.11,0.08,0.06,0.04,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.02,0.03,0.05,0.07,0.09,0.10,0.11,0.13,0.13,0.15,0.16,0.17,0.18,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.16,0.15,0.14,0.13,0.12,0.11,0.09,0.08,0.06,0.05,0.04,0.04,0.04,0.05,0.06,0.08,0.09,0.11,0.12,0.13,0.15,0.16,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.18,0.18,0.18,0.17,0.17,0.16,0.16,0.16,0.16,0.16,0.24,0.22,0.21,0.19,0.17,0.15,0.13,0.11,0.08,0.06,0.04,0.02,0.01,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.04,0.06,0.08,0.09,0.11,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.15,0.14,0.13,0.12,0.11,0.09,0.08,0.06,0.05,0.04,0.04,0.04,0.05,0.06,0.08,0.10,0.11,0.12,0.14,0.15,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.18,0.18,0.18,0.18,0.17,0.16,0.16,0.15,0.15,0.15,0.15,0.22,0.20,0.18,0.16,0.14,0.12,0.10,0.08,0.06,0.04,0.02,0.01,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.04,0.05,0.07,0.08,0.10,0.12,0.13,0.14,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.16,0.14,0.13,0.12,0.11,0.09,0.07,0.06,0.05,0.04,0.04,0.04,0.05,0.07,0.08,0.10,0.11,0.13,0.14,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.18,0.18,0.17,0.17,0.16,0.15,0.15,0.14,0.14,0.14,0.14,0.20,0.18,0.16,0.13,0.11,0.09,0.07,0.05,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.03,0.04,0.06,0.08,0.09,0.11,0.13,0.14,0.15,0.16,0.17,0.18,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.20,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.15,0.14,0.13,0.12,0.10,0.09,0.07,0.05,0.05,0.04,0.04,0.05,0.06,0.07,0.09,0.10,0.11,0.13,0.15,0.16,0.17,0.18,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.18,0.18,0.17,0.17,0.16,0.15,0.15,0.14,0.14,0.14,0.14,0.14,0.17,0.15,0.12,0.10,0.08,0.06,0.05,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.02,0.03,0.04,0.04,0.05,0.07,0.09,0.10,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.15,0.14,0.13,0.11,0.10,0.08,0.07,0.05,0.04,0.04,0.04,0.05,0.06,0.08,0.09,0.11,0.12,0.13,0.15,0.16,0.18,0.18,0.19,0.19,0.19,0.19,0.19,0.19,0.18,0.18,0.18,0.17,0.17,0.16,0.16,0.15,0.14,0.14,0.13,0.13,0.14,0.14,0.14,0.11,0.09,0.07,0.05,0.04,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.04,0.04,0.05,0.07,0.08,0.10,0.11,0.13,0.14,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.18,0.16,0.15,0.14,0.13,0.11,0.10,0.08,0.06,0.05,0.04,0.04,0.05,0.05,0.07,0.08,0.10,0.11,0.12,0.14,0.15,0.17,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.17,0.16,0.16,0.15,0.14,0.14,0.14,0.13,0.14,0.14,0.14,0.11,0.09,0.06,0.05,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.01,0.02,0.02,0.03,0.04,0.04,0.05,0.06,0.08,0.09,0.11,0.12,0.14,0.15,0.16,0.17,0.18,0.19,0.20,0.20,0.21,0.21,0.21,0.21,0.22,0.22,0.22,0.22,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.18,0.16,0.15,0.14,0.12,0.11,0.09,0.07,0.06,0.05,0.04,0.04,0.05,0.06,0.07,0.09,0.10,0.11,0.13,0.14,0.15,0.16,0.17,0.18,0.18,0.18,0.18,0.17,0.17,0.17,0.17,0.16,0.16,0.15,0.15,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.08,0.06,0.04,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.01,0.02,0.02,0.03,0.04,0.05,0.05,0.06,0.07,0.08,0.10,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.19,0.20,0.21,0.21,0.21,0.22,0.22,0.23,0.23,0.23,0.23,0.23,0.22,0.22,0.21,0.21,0.20,0.20,0.20,0.19,0.18,0.17,0.16,0.15,0.13,0.12,0.11,0.09,0.07,0.05,0.05,0.04,0.04,0.05,0.06,0.08,0.09,0.11,0.12,0.13,0.14,0.15,0.16,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.16,0.16,0.15,0.15,0.14,0.14,0.14,0.13,0.14,0.14,0.13,0.14,0.06,0.04,0.02,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.02,0.02,0.03,0.04,0.05,0.05,0.06,0.07,0.08,0.09,0.11,0.13,0.14,0.16,0.17,0.18,0.18,0.19,0.20,0.21,0.21,0.21,0.22,0.23,0.23,0.24,0.24,0.24,0.24,0.23,0.23,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.18,0.17,0.16,0.14,0.13,0.12,0.10,0.08,0.06,0.05,0.04,0.04,0.05,0.05,0.07,0.08,0.10,0.11,0.12,0.13,0.14,0.15,0.16,0.16,0.16,0.16,0.16,0.16,0.16,0.16,0.15,0.15,0.14,0.14,0.14,0.14,0.13,0.14,0.14,0.14,0.14,0.04,0.02,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.04,0.04,0.05,0.06,0.06,0.07,0.08,0.09,0.10,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.20,0.20,0.21,0.22,0.22,0.23,0.23,0.24,0.24,0.24,0.24,0.24,0.24,0.24,0.23,0.22,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.15,0.14,0.13,0.11,0.09,0.07,0.05,0.05,0.04,0.04,0.05,0.06,0.08,0.09,0.10,0.11,0.12,0.13,0.14,0.15,0.15,0.15,0.16,0.16,0.15,0.15,0.15,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.02,0.03,0.04,0.05,0.05,0.06,0.07,0.08,0.08,0.08,0.10,0.11,0.12,0.14,0.15,0.17,0.18,0.19,0.20,0.20,0.21,0.22,0.22,0.23,0.24,0.24,0.24,0.25,0.25,0.25,0.25,0.25,0.24,0.24,0.23,0.22,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.18,0.16,0.15,0.14,0.12,0.11,0.09,0.06,0.05,0.04,0.04,0.05,0.05,0.07,0.08,0.09,0.10,0.11,0.12,0.13,0.14,0.14,0.15,0.15,0.15,0.15,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.03,0.02,0.02,0.01,0.01,0.02,0.02,0.03,0.04,0.04,0.05,0.06,0.07,0.07,0.08,0.08,0.08,0.09,0.10,0.11,0.13,0.15,0.16,0.17,0.18,0.19,0.20,0.21,0.22,0.22,0.23,0.24,0.24,0.25,0.25,0.25,0.26,0.26,0.26,0.25,0.25,0.24,0.23,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.18,0.18,0.16,0.15,0.13,0.12,0.10,0.08,0.06,0.05,0.04,0.04,0.05,0.06,0.07,0.09,0.10,0.11,0.11,0.12,0.13,0.13,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.13,0.14,0.14,0.13,0.14,0.14,0.14,0.13,0.04,0.03,0.02,0.02,0.03,0.03,0.03,0.04,0.05,0.06,0.06,0.07,0.07,0.08,0.08,0.09,0.09,0.10,0.11,0.12,0.14,0.16,0.17,0.18,0.19,0.20,0.21,0.22,0.22,0.23,0.24,0.25,0.25,0.26,0.26,0.26,0.26,0.26,0.27,0.26,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.20,0.20,0.20,0.20,0.19,0.18,0.17,0.16,0.14,0.13,0.11,0.09,0.07,0.05,0.04,0.04,0.05,0.05,0.07,0.08,0.09,0.10,0.11,0.12,0.12,0.13,0.13,0.13,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.05,0.04,0.04,0.04,0.04,0.04,0.05,0.06,0.06,0.07,0.08,0.08,0.09,0.09,0.09,0.09,0.09,0.10,0.11,0.13,0.15,0.16,0.17,0.19,0.20,0.21,0.21,0.22,0.23,0.24,0.25,0.25,0.26,0.27,0.27,0.27,0.27,0.28,0.28,0.27,0.27,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.18,0.17,0.16,0.14,0.12,0.10,0.08,0.06,0.05,0.04,0.04,0.05,0.06,0.07,0.08,0.09,0.10,0.11,0.12,0.12,0.13,0.13,0.13,0.13,0.13,0.13,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.13,0.13,0.14,0.06,0.05,0.05,0.05,0.05,0.06,0.06,0.07,0.08,0.08,0.09,0.09,0.09,0.09,0.09,0.09,0.10,0.11,0.12,0.14,0.15,0.17,0.18,0.19,0.20,0.21,0.22,0.23,0.24,0.25,0.26,0.26,0.27,0.28,0.28,0.29,0.29,0.29,0.29,0.29,0.28,0.27,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.18,0.17,0.15,0.13,0.12,0.09,0.07,0.05,0.05,0.04,0.04,0.05,0.06,0.08,0.09,0.10,0.10,0.11,0.11,0.12,0.12,0.13,0.13,0.13,0.13,0.14,0.14,0.14,0.14,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.08,0.07,0.07,0.07,0.07,0.08,0.08,0.09,0.09,0.10,0.10,0.09,0.09,0.09,0.09,0.10,0.11,0.12,0.14,0.15,0.16,0.18,0.19,0.20,0.21,0.22,0.23,0.24,0.25,0.26,0.27,0.28,0.28,0.29,0.29,0.30,0.30,0.30,0.30,0.30,0.29,0.29,0.28,0.27,0.26,0.24,0.24,0.22,0.22,0.21,0.21,0.20,0.20,0.19,0.19,0.18,0.16,0.15,0.13,0.11,0.08,0.06,0.05,0.04,0.04,0.05,0.05,0.06,0.08,0.09,0.10,0.10,0.11,0.11,0.12,0.12,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.10,0.10,0.10,0.10,0.10,0.10,0.10,0.10,0.10,0.10,0.10,0.10,0.09,0.09,0.10,0.11,0.12,0.13,0.15,0.16,0.18,0.19,0.20,0.21,0.22,0.23,0.24,0.25,0.26,0.27,0.28,0.29,0.30,0.30,0.31,0.31,0.31,0.31,0.31,0.31,0.30,0.30,0.29,0.28,0.27,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.20,0.20,0.19,0.19,0.17,0.16,0.14,0.12,0.10,0.08,0.06,0.05,0.04,0.05,0.05,0.06,0.07,0.08,0.09,0.10,0.11,0.11,0.12,0.12,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.12,0.12,0.11,0.11,0.11,0.11,0.11,0.11,0.11,0.10,0.10,0.10,0.10,0.10,0.11,0.12,0.13,0.15,0.16,0.17,0.18,0.20,0.21,0.22,0.23,0.24,0.25,0.26,0.27,0.28,0.29,0.30,0.31,0.31,0.32,0.32,0.32,0.31,0.31,0.31,0.31,0.30,0.29,0.29,0.28,0.27,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.20,0.20,0.19,0.19,0.17,0.16,0.14,0.12,0.09,0.07,0.05,0.05,0.04,0.05,0.05,0.06,0.07,0.08,0.09,0.10,0.11,0.11,0.11,0.12,0.12,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.12,0.12,0.12,0.12,0.13,0.13,0.12,0.12,0.12,0.12,0.11,0.11,0.11,0.10,0.10,0.10,0.10,0.11,0.12,0.13,0.14,0.16,0.17,0.18,0.19,0.20,0.21,0.22,0.24,0.25,0.26,0.27,0.28,0.29,0.30,0.31,0.32,0.32,0.32,0.32,0.32,0.31,0.31,0.31,0.31,0.30,0.30,0.30,0.29,0.29,0.28,0.27,0.26,0.24,0.23,0.22,0.21,0.21,0.20,0.20,0.19,0.18,0.17,0.15,0.13,0.11,0.08,0.06,0.05,0.05,0.04,0.05,0.05,0.06,0.07,0.08,0.09,0.10,0.10,0.11,0.11,0.12,0.12,0.13,0.13,0.13,0.13,0.13,0.12,0.12,0.12,0.11,0.11,0.12,0.14,0.13,0.13,0.12,0.12,0.12,0.11,0.11,0.11,0.11,0.11,0.11,0.12,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.20,0.21,0.22,0.23,0.24,0.25,0.27,0.28,0.29,0.30,0.31,0.32,0.32,0.32,0.32,0.32,0.32,0.31,0.31,0.31,0.30,0.30,0.30,0.30,0.30,0.29,0.29,0.28,0.27,0.26,0.24,0.23,0.22,0.21,0.21,0.20,0.20,0.19,0.18,0.16,0.15,0.12,0.10,0.08,0.06,0.05,0.04,0.04,0.05,0.05,0.06,0.07,0.08,0.09,0.10,0.10,0.11,0.11,0.12,0.12,0.13,0.13,0.12,0.12,0.11,0.11,0.11,0.11,0.11,0.11,0.15,0.14,0.13,0.13,0.13,0.12,0.12,0.11,0.11,0.11,0.12,0.12,0.13,0.14,0.15,0.16,0.17,0.18,0.19,0.20,0.21,0.22,0.23,0.24,0.25,0.26,0.27,0.29,0.30,0.31,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.31,0.31,0.31,0.31,0.31,0.30,0.30,0.30,0.30,0.29,0.29,0.28,0.27,0.26,0.24,0.23,0.22,0.21,0.21,0.20,0.19,0.19,0.17,0.16,0.14,0.12,0.09,0.07,0.06,0.05,0.04,0.05,0.05,0.05,0.06,0.07,0.08,0.09,0.10,0.10,0.11,0.11,0.12,0.12,0.12,0.12,0.11,0.11,0.10,0.10,0.10,0.10,0.10,0.16,0.15,0.14,0.13,0.13,0.13,0.12,0.12,0.12,0.12,0.13,0.13,0.14,0.15,0.16,0.17,0.18,0.19,0.20,0.21,0.22,0.23,0.24,0.25,0.26,0.27,0.28,0.30,0.31,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.31,0.31,0.31,0.31,0.31,0.31,0.30,0.30,0.30,0.30,0.30,0.29,0.28,0.27,0.26,0.24,0.23,0.22,0.21,0.21,0.20,0.19,0.18,0.17,0.15,0.13,0.11,0.09,0.07,0.06,0.05,0.05,0.05,0.05,0.05,0.06,0.07,0.08,0.09,0.09,0.10,0.10,0.11,0.11,0.11,0.11,0.11,0.10,0.10,0.10,0.09,0.09,0.10,0.16,0.15,0.15,0.14,0.14,0.13,0.13,0.13,0.13,0.13,0.14,0.14,0.15,0.16,0.17,0.18,0.19,0.20,0.21,0.21,0.22,0.23,0.24,0.25,0.26,0.28,0.29,0.30,0.31,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.31,0.31,0.31,0.31,0.30,0.30,0.29,0.28,0.27,0.25,0.24,0.22,0.21,0.21,0.20,0.20,0.19,0.18,0.16,0.14,0.13,0.10,0.08,0.07,0.05,0.05,0.05,0.05,0.05,0.05,0.06,0.07,0.07,0.08,0.09,0.10,0.10,0.11,0.11,0.11,0.10,0.10,0.09,0.09,0.09,0.09,0.09,0.16,0.15,0.14,0.14,0.14,0.13,0.13,0.13,0.13,0.14,0.15,0.16,0.16,0.17,0.18,0.19,0.20,0.21,0.21,0.22,0.23,0.24,0.25,0.26,0.27,0.28,0.29,0.31,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.33,0.33,0.33,0.34,0.34,0.33,0.33,0.33,0.32,0.32,0.32,0.31,0.31,0.30,0.30,0.29,0.28,0.27,0.25,0.23,0.22,0.21,0.21,0.20,0.19,0.18,0.17,0.16,0.14,0.12,0.10,0.08,0.07,0.06,0.05,0.05,0.05,0.05,0.05,0.06,0.06,0.07,0.08,0.09,0.09,0.10,0.10,0.10,0.10,0.09,0.09,0.09,0.09,0.09,0.09,0.16,0.15,0.15,0.14,0.14,0.14,0.14,0.14,0.14,0.15,0.16,0.17,0.17,0.18,0.19,0.20,0.21,0.21,0.22,0.23,0.24,0.24,0.25,0.26,0.28,0.29,0.30,0.32,0.32,0.32,0.33,0.33,0.33,0.33,0.34,0.34,0.35,0.35,0.35,0.35,0.35,0.35,0.34,0.34,0.33,0.33,0.32,0.32,0.31,0.31,0.30,0.29,0.28,0.26,0.24,0.23,0.22,0.21,0.20,0.19,0.19,0.18,0.16,0.15,0.13,0.11,0.10,0.08,0.07,0.06,0.05,0.05,0.05,0.05,0.05,0.05,0.06,0.06,0.07,0.08,0.09,0.09,0.10,0.09,0.09,0.09,0.08,0.08,0.09,0.09,0.16,0.15,0.15,0.14,0.14,0.14,0.15,0.15,0.15,0.16,0.17,0.17,0.18,0.19,0.20,0.21,0.21,0.22,0.23,0.23,0.24,0.25,0.26,0.27,0.29,0.30,0.31,0.32,0.33,0.33,0.33,0.33,0.33,0.34,0.35,0.35,0.35,0.36,0.36,0.36,0.36,0.36,0.35,0.35,0.35,0.34,0.33,0.33,0.32,0.32,0.31,0.30,0.29,0.27,0.25,0.24,0.22,0.21,0.20,0.20,0.19,0.19,0.17,0.16,0.14,0.13,0.11,0.10,0.08,0.07,0.06,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.06,0.07,0.08,0.08,0.09,0.09,0.08,0.08,0.07,0.07,0.07,0.08,0.16,0.15,0.15,0.15,0.15,0.15,0.15,0.16,0.16,0.17,0.18,0.19,0.19,0.20,0.21,0.21,0.22,0.23,0.23,0.24,0.25,0.26,0.27,0.28,0.29,0.31,0.32,0.33,0.33,0.33,0.34,0.34,0.34,0.35,0.35,0.36,0.36,0.37,0.37,0.37,0.37,0.37,0.36,0.36,0.36,0.35,0.34,0.34,0.33,0.32,0.32,0.31,0.30,0.28,0.26,0.24,0.23,0.21,0.21,0.20,0.20,0.19,0.18,0.17,0.15,0.14,0.13,0.11,0.10,0.08,0.07,0.06,0.05,0.05,0.05,0.04,0.04,0.05,0.05,0.05,0.06,0.07,0.07,0.07,0.07,0.07,0.06,0.06,0.06,0.07,0.16,0.16,0.15,0.15,0.15,0.16,0.16,0.16,0.17,0.18,0.19,0.19,0.20,0.21,0.21,0.22,0.22,0.23,0.24,0.25,0.25,0.26,0.27,0.29,0.31,0.32,0.33,0.34,0.34,0.34,0.34,0.34,0.35,0.35,0.36,0.36,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.36,0.36,0.35,0.35,0.34,0.33,0.32,0.32,0.31,0.29,0.27,0.25,0.23,0.22,0.21,0.20,0.20,0.19,0.19,0.18,0.16,0.15,0.14,0.13,0.12,0.10,0.09,0.08,0.07,0.06,0.05,0.05,0.04,0.04,0.04,0.04,0.05,0.05,0.06,0.06,0.06,0.06,0.06,0.06,0.06,0.07,0.17,0.16,0.16,0.16,0.16,0.16,0.17,0.17,0.18,0.19,0.20,0.20,0.21,0.21,0.22,0.22,0.23,0.24,0.24,0.25,0.26,0.27,0.29,0.30,0.32,0.33,0.34,0.35,0.35,0.35,0.35,0.35,0.35,0.36,0.37,0.38,0.38,0.38,0.39,0.39,0.39,0.38,0.38,0.37,0.37,0.37,0.36,0.35,0.35,0.34,0.33,0.33,0.32,0.30,0.28,0.26,0.24,0.22,0.21,0.20,0.20,0.20,0.19,0.18,0.17,0.16,0.15,0.13,0.12,0.12,0.11,0.10,0.08,0.07,0.06,0.05,0.05,0.04,0.04,0.04,0.04,0.05,0.05,0.05,0.05,0.06,0.06,0.06,0.06,0.07,0.17,0.17,0.16,0.16,0.17,0.17,0.18,0.19,0.19,0.20,0.20,0.21,0.21,0.22,0.23,0.23,0.24,0.24,0.25,0.26,0.27,0.28,0.30,0.31,0.33,0.34,0.35,0.35,0.35,0.35,0.35,0.35,0.36,0.37,0.38,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.38,0.37,0.37,0.36,0.36,0.35,0.35,0.34,0.33,0.32,0.31,0.29,0.27,0.25,0.23,0.21,0.21,0.20,0.20,0.19,0.19,0.18,0.17,0.15,0.14,0.13,0.13,0.12,0.11,0.10,0.09,0.08,0.07,0.06,0.05,0.05,0.04,0.04,0.04,0.04,0.04,0.05,0.05,0.05,0.06,0.06,0.06,0.18,0.17,0.17,0.17,0.18,0.18,0.19,0.20,0.20,0.21,0.21,0.22,0.22,0.23,0.23,0.24,0.24,0.25,0.26,0.27,0.28,0.29,0.31,0.32,0.33,0.34,0.35,0.35,0.35,0.35,0.36,0.36,0.37,0.38,0.39,0.39,0.39,0.40,0.40,0.40,0.39,0.39,0.39,0.39,0.38,0.37,0.37,0.36,0.35,0.35,0.35,0.34,0.33,0.32,0.30,0.28,0.26,0.24,0.22,0.21,0.20,0.20,0.20,0.19,0.18,0.17,0.16,0.15,0.14,0.13,0.12,0.12,0.11,0.11,0.10,0.09,0.07,0.06,0.05,0.05,0.05,0.04,0.04,0.04,0.04,0.04,0.05,0.05,0.05,0.06,0.19,0.18,0.19,0.19,0.19,0.19,0.20,0.20,0.21,0.21,0.22,0.22,0.23,0.23,0.24,0.24,0.25,0.25,0.26,0.27,0.29,0.30,0.32,0.33,0.34,0.35,0.35,0.35,0.35,0.36,0.36,0.36,0.38,0.39,0.39,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.38,0.37,0.36,0.36,0.35,0.35,0.34,0.34,0.33,0.31,0.29,0.27,0.24,0.22,0.21,0.21,0.20,0.20,0.19,0.19,0.18,0.17,0.16,0.14,0.13,0.13,0.12,0.12,0.11,0.11,0.10,0.09,0.08,0.07,0.06,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.05,0.05,0.19,0.19,0.19,0.19,0.20,0.20,0.21,0.21,0.22,0.22,0.23,0.23,0.24,0.24,0.24,0.25,0.25,0.26,0.27,0.28,0.30,0.31,0.32,0.33,0.34,0.35,0.35,0.35,0.35,0.35,0.36,0.37,0.38,0.39,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.38,0.37,0.36,0.35,0.35,0.35,0.34,0.33,0.32,0.30,0.27,0.25,0.23,0.22,0.21,0.20,0.20,0.20,0.19,0.19,0.18,0.16,0.15,0.14,0.13,0.13,0.12,0.12,0.11,0.11,0.10,0.09,0.08,0.07,0.05,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.05,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.22,0.22,0.23,0.23,0.24,0.24,0.24,0.25,0.25,0.26,0.27,0.28,0.29,0.30,0.31,0.32,0.33,0.34,0.34,0.35,0.35,0.35,0.35,0.36,0.37,0.39,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.38,0.37,0.36,0.36,0.35,0.35,0.35,0.34,0.33,0.31,0.28,0.26,0.24,0.22,0.21,0.21,0.20,0.20,0.19,0.19,0.18,0.17,0.16,0.14,0.14,0.13,0.13,0.12,0.12,0.11,0.10,0.10,0.09,0.08,0.06,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.05,0.20,0.21,0.21,0.21,0.21,0.22,0.22,0.23,0.23,0.23,0.24,0.24,0.25,0.25,0.25,0.26,0.26,0.27,0.29,0.30,0.31,0.32,0.32,0.33,0.33,0.34,0.35,0.35,0.35,0.35,0.36,0.37,0.39,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.38,0.37,0.36,0.36,0.35,0.35,0.35,0.34,0.33,0.32,0.29,0.27,0.24,0.23,0.21,0.21,0.20,0.20,0.20,0.19,0.18,0.17,0.16,0.15,0.14,0.13,0.13,0.13,0.12,0.11,0.11,0.10,0.10,0.09,0.07,0.06,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.05,0.21,0.21,0.21,0.22,0.22,0.23,0.23,0.23,0.24,0.24,0.24,0.25,0.25,0.25,0.26,0.26,0.27,0.28,0.29,0.30,0.31,0.32,0.32,0.32,0.33,0.34,0.34,0.35,0.35,0.36,0.36,0.37,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.38,0.37,0.36,0.35,0.35,0.35,0.35,0.35,0.34,0.32,0.30,0.28,0.25,0.23,0.22,0.21,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.16,0.14,0.14,0.13,0.13,0.12,0.12,0.11,0.11,0.10,0.09,0.08,0.07,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.21,0.22,0.22,0.23,0.23,0.23,0.24,0.24,0.24,0.24,0.25,0.25,0.25,0.26,0.26,0.27,0.27,0.29,0.30,0.31,0.31,0.32,0.32,0.32,0.33,0.34,0.34,0.35,0.35,0.35,0.36,0.37,0.39,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.38,0.37,0.36,0.36,0.35,0.35,0.35,0.35,0.34,0.33,0.31,0.29,0.26,0.24,0.22,0.21,0.21,0.20,0.20,0.20,0.19,0.18,0.17,0.16,0.15,0.14,0.13,0.13,0.13,0.12,0.12,0.11,0.10,0.10,0.09,0.07,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.22,0.23,0.23,0.23,0.24,0.24,0.24,0.24,0.25,0.25,0.25,0.26,0.26,0.26,0.27,0.27,0.28,0.29,0.30,0.31,0.31,0.31,0.32,0.32,0.33,0.33,0.34,0.35,0.35,0.36,0.36,0.37,0.38,0.39,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.38,0.37,0.36,0.36,0.35,0.35,0.35,0.35,0.34,0.33,0.31,0.29,0.27,0.25,0.23,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.15,0.14,0.14,0.13,0.13,0.13,0.12,0.11,0.11,0.10,0.09,0.08,0.06,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.23,0.23,0.24,0.24,0.24,0.24,0.25,0.25,0.25,0.25,0.26,0.26,0.26,0.27,0.27,0.28,0.29,0.29,0.30,0.30,0.30,0.31,0.31,0.32,0.32,0.33,0.34,0.35,0.35,0.35,0.36,0.37,0.38,0.39,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.38,0.37,0.37,0.36,0.35,0.35,0.35,0.35,0.35,0.34,0.33,0.32,0.30,0.28,0.25,0.23,0.22,0.21,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.16,0.15,0.14,0.13,0.13,0.13,0.13,0.12,0.11,0.11,0.10,0.09,0.07,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.23,0.24,0.24,0.24,0.24,0.24,0.25,0.25,0.25,0.25,0.26,0.26,0.27,0.28,0.28,0.29,0.29,0.29,0.29,0.30,0.30,0.31,0.31,0.31,0.32,0.33,0.34,0.35,0.35,0.35,0.36,0.37,0.38,0.38,0.39,0.39,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.39,0.38,0.37,0.36,0.36,0.35,0.35,0.35,0.35,0.35,0.34,0.33,0.32,0.30,0.28,0.26,0.24,0.22,0.21,0.20,0.20,0.20,0.20,0.19,0.19,0.17,0.16,0.15,0.14,0.14,0.13,0.13,0.13,0.12,0.12,0.11,0.10,0.09,0.07,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.24,0.24,0.24,0.25,0.25,0.25,0.25,0.25,0.25,0.26,0.26,0.27,0.27,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.31,0.31,0.32,0.33,0.33,0.34,0.35,0.36,0.36,0.37,0.37,0.38,0.38,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.38,0.38,0.37,0.36,0.35,0.35,0.35,0.35,0.35,0.35,0.34,0.33,0.32,0.30,0.29,0.26,0.24,0.22,0.20,0.20,0.20,0.20,0.19,0.19,0.19,0.18,0.16,0.15,0.14,0.14,0.13,0.13,0.13,0.13,0.12,0.12,0.11,0.10,0.08,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.24,0.25,0.25,0.25,0.25,0.25,0.25,0.25,0.25,0.26,0.27,0.27,0.28,0.28,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.31,0.31,0.32,0.32,0.33,0.34,0.35,0.36,0.36,0.37,0.37,0.37,0.38,0.38,0.39,0.39,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.36,0.35,0.35,0.35,0.35,0.35,0.34,0.34,0.33,0.32,0.30,0.29,0.27,0.24,0.22,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.18,0.17,0.16,0.15,0.14,0.13,0.13,0.13,0.13,0.13,0.12,0.11,0.10,0.09,0.06,0.05,0.04,0.04,0.04,0.04,0.04,0.25,0.25,0.25,0.25,0.25,0.25,0.25,0.25,0.26,0.26,0.27,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.31,0.31,0.32,0.33,0.34,0.35,0.35,0.36,0.37,0.37,0.37,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.37,0.37,0.37,0.36,0.35,0.35,0.35,0.35,0.34,0.34,0.33,0.32,0.31,0.30,0.29,0.27,0.24,0.22,0.20,0.19,0.19,0.19,0.20,0.20,0.19,0.18,0.17,0.16,0.15,0.14,0.14,0.13,0.13,0.13,0.13,0.12,0.11,0.11,0.09,0.07,0.05,0.04,0.04,0.04,0.04,0.04,0.25,0.25,0.26,0.26,0.26,0.26,0.26,0.26,0.27,0.27,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.31,0.31,0.32,0.33,0.34,0.35,0.35,0.36,0.37,0.37,0.37,0.37,0.37,0.37,0.38,0.38,0.38,0.38,0.38,0.38,0.37,0.37,0.37,0.36,0.36,0.35,0.35,0.35,0.34,0.34,0.33,0.32,0.32,0.31,0.30,0.29,0.27,0.25,0.22,0.21,0.19,0.19,0.19,0.20,0.20,0.19,0.19,0.17,0.16,0.15,0.14,0.14,0.14,0.13,0.13,0.13,0.13,0.12,0.11,0.10,0.08,0.05,0.04,0.04,0.04,0.04,0.04,0.25,0.26,0.26,0.26,0.26,0.26,0.27,0.27,0.27,0.28,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.31,0.31,0.32,0.32,0.34,0.34,0.35,0.36,0.36,0.37,0.37,0.37,0.37,0.37,0.38,0.37,0.37,0.38,0.38,0.37,0.37,0.37,0.37,0.36,0.36,0.35,0.35,0.34,0.34,0.33,0.33,0.32,0.31,0.31,0.30,0.28,0.27,0.25,0.23,0.21,0.20,0.20,0.20,0.20,0.20,0.19,0.19,0.18,0.16,0.15,0.14,0.14,0.14,0.13,0.13,0.13,0.13,0.12,0.11,0.10,0.08,0.06,0.04,0.04,0.04,0.04,0.04,0.26,0.26,0.27,0.27,0.27,0.27,0.27,0.27,0.28,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.30,0.31,0.32,0.32,0.33,0.34,0.35,0.36,0.36,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.36,0.35,0.35,0.34,0.33,0.32,0.32,0.31,0.31,0.30,0.29,0.28,0.26,0.25,0.23,0.22,0.21,0.20,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.15,0.14,0.14,0.14,0.14,0.13,0.13,0.13,0.12,0.11,0.10,0.09,0.06,0.04,0.04,0.04,0.04,0.04,0.26,0.27,0.27,0.28,0.28,0.28,0.28,0.28,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.30,0.31,0.31,0.32,0.33,0.34,0.35,0.35,0.36,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.36,0.36,0.35,0.34,0.33,0.32,0.32,0.31,0.31,0.30,0.29,0.28,0.27,0.26,0.25,0.24,0.23,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.18,0.17,0.15,0.14,0.14,0.14,0.14,0.13,0.13,0.13,0.12,0.11,0.11,0.09,0.07,0.05,0.04,0.04,0.04,0.04,0.27,0.28,0.28,0.28,0.28,0.28,0.28,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.30,0.31,0.32,0.32,0.33,0.34,0.35,0.36,0.36,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.36,0.35,0.34,0.33,0.33,0.32,0.31,0.31,0.30,0.29,0.29,0.28,0.27,0.26,0.25,0.24,0.23,0.22,0.22,0.21,0.21,0.20,0.20,0.19,0.18,0.17,0.15,0.14,0.14,0.14,0.14,0.13,0.13,0.13,0.12,0.12,0.11,0.09,0.07,0.05,0.04,0.04,0.04,0.04,0.27,0.28,0.29,0.29,0.29,0.28,0.29,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.31,0.31,0.32,0.33,0.34,0.34,0.35,0.36,0.36,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.36,0.35,0.34,0.33,0.32,0.32,0.31,0.31,0.30,0.30,0.29,0.28,0.27,0.26,0.26,0.25,0.25,0.24,0.23,0.23,0.22,0.21,0.20,0.20,0.19,0.18,0.17,0.16,0.14,0.14,0.14,0.14,0.13,0.13,0.13,0.13,0.12,0.11,0.09,0.07,0.05,0.04,0.04,0.04,0.04,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.31,0.31,0.31,0.32,0.33,0.34,0.34,0.35,0.36,0.36,0.36,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.36,0.36,0.35,0.34,0.33,0.32,0.32,0.31,0.31,0.30,0.30,0.29,0.28,0.28,0.27,0.26,0.26,0.26,0.25,0.25,0.24,0.23,0.22,0.21,0.20,0.20,0.19,0.18,0.17,0.16,0.15,0.14,0.14,0.14,0.13,0.13,0.13,0.13,0.12,0.11,0.10,0.07,0.05,0.04,0.04,0.04,0.04,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.28,0.28,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.31,0.31,0.32,0.32,0.33,0.33,0.34,0.35,0.35,0.36,0.36,0.36,0.36,0.36,0.36,0.36,0.36,0.35,0.35,0.34,0.33,0.32,0.32,0.31,0.31,0.30,0.30,0.29,0.29,0.28,0.27,0.27,0.26,0.26,0.26,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.20,0.19,0.18,0.17,0.16,0.15,0.14,0.14,0.14,0.14,0.13,0.13,0.13,0.12,0.11,0.10,0.08,0.05,0.04,0.04,0.04,0.04,0.29,0.30,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.28,0.28,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.31,0.31,0.32,0.32,0.33,0.34,0.34,0.35,0.35,0.35,0.35,0.35,0.35,0.35,0.34,0.34,0.33,0.32,0.32,0.31,0.30,0.30,0.30,0.30,0.30,0.29,0.29,0.28,0.28,0.27,0.27,0.27,0.27,0.27,0.26,0.24,0.23,0.22,0.21,0.21,0.20,0.19,0.19,0.17,0.16,0.15,0.14,0.14,0.14,0.14,0.13,0.13,0.13,0.12,0.12,0.10,0.08,0.05,0.04,0.04,0.04,0.04,0.29,0.29,0.30,0.30,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.31,0.31,0.31,0.32,0.33,0.33,0.33,0.34,0.34,0.34,0.34,0.34,0.34,0.33,0.32,0.32,0.31,0.30,0.30,0.30,0.29,0.30,0.29,0.30,0.29,0.29,0.29,0.28,0.28,0.28,0.27,0.27,0.27,0.26,0.25,0.23,0.22,0.21,0.21,0.20,0.19,0.19,0.18,0.17,0.15,0.14,0.14,0.14,0.14,0.13,0.13,0.13,0.13,0.12,0.11,0.09,0.06,0.05,0.04,0.04,0.05],solid=False,xDimension=90,xSpacing=0.02,zDimension=90,zSpacing=0.02))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for Figure14_5ElevationGridTerrain.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python Figure14_5ElevationGridTerrain.py load and self-test diagnostics complete.")
