package Vrml2Sourcebook.Chapter14ElevationGrid;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> An elevation grid built using an automatic terrain-generator application. </p>
 <p> Related links: Catalog page <a href="../../../Chapter14ElevationGrid/Figure14_5ElevationGridTerrainIndex.html" target="_blank">Figure14_5ElevationGridTerrain</a>,  source <a href="../../../Chapter14ElevationGrid/Figure14_5ElevationGridTerrain.java">Figure14_5ElevationGridTerrain.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Chapter14ElevationGrid/Figure14_5ElevationGridTerrain.x3d">Figure14_5ElevationGridTerrain.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Figure 14.5, The VRML 2.0 Sourcebook, Copyright [1997] By Andrea L. Ames, David R. Nadeau, and John L. Moreland </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.wiley.com/legacy/compbooks/vrml2sbk/ch14/14fig05.htm" target="_blank">http://www.wiley.com/legacy/compbooks/vrml2sbk/ch14/14fig05.htm</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 19 August 2000 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> An elevation grid built using an automatic terrain-generator application. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter14ElevationGrid/Figure14_5ElevationGridTerrain.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter14ElevationGrid/Figure14_5ElevationGridTerrain.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Chapter14ElevationGrid/../../license.html">../../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Figure 14.5, The VRML 2.0 Sourcebook, Copyright [1997] By Andrea L. Ames, David R. Nadeau, and John L. Moreland
 */

public class Figure14_5ElevationGridTerrain
{
	/** Default constructor to create this object. */
	public Figure14_5ElevationGridTerrain ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERACTIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("Figure14_5ElevationGridTerrain.x3d"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Figure 14.5, The VRML 2.0 Sourcebook, Copyright [1997] By Andrea L. Ames, David R. Nadeau, and John L. Moreland"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.wiley.com/legacy/compbooks/vrml2sbk/ch14/14fig05.htm"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("19 August 2000"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("An elevation grid built using an automatic terrain-generator application."))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter14ElevationGrid/Figure14_5ElevationGridTerrain.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../../license.html")))
  .setScene(new Scene()
    .addComments(" WALK mode permits the camera to move around in terrain-following mode. ANY gives the user liberty to change navigation modes if desired. ")
    .addComments(" Note that avatarSize must be adjusted to match collision distance between camera and geometry, height of eye above ground, and highest distance that camera is able to walk over.. ")
    .addChild(new WorldInfo().setTitle("Figure14_5ElevationGridTerrain.x3d"))
    .addChild(new NavigationInfo().setAvatarSize(new double[] {0.1,0.1,4.0}).setType("\"WALK\" \"ANY\""))
    .addComments(" A height of 10m above the ElevationGrid ensures that the camera will fall and land on top of the ground while in WALK mode. ")
    .addComments(" Be careful not to provide viewpoints that are beneath terrain or initially locked in a collision location, or else the camera will not be able to move. ")
    .addChild(new Viewpoint().setDescription("Look at all terrain").setOrientation(1.0,0.0,0.0,-0.6).setPosition(0.0,20.0,25.0))
    .addChild(new Viewpoint().setDescription("Walk around using mouse or arrow keys").setPosition(0.0,10.0,0.0))
    .addChild(new Transform().setCenter(0.9,0.0,0.9).setRotation(0.0,1.0,0.0,1.57).setScale(10.0,10.0,10.0).setTranslation(-0.9,0.0,-0.9)
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setDiffuseColor(0.4,0.6,0.3).setEmissiveColor(0.0,0.05,0.0)))
        .setGeometry(new ElevationGrid().setCreaseAngle(0.785).setSolid(false).setXDimension(90).setXSpacing(0.02).setZDimension(90).setZSpacing(0.02).setHeight(getElevationGrid_5_18_height())))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getElevationGrid_5_18_height_1()
		{
			double[] value = {0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.37,0.36,0.36,0.35,0.35,0.35,0.35,0.34,0.33,0.32,0.32,0.31,0.31,0.31,0.31,0.30,0.29,0.28,0.28,0.27,0.27,0.27,0.27,0.27,0.27,0.27,0.27,0.27,0.27,0.27,0.28,0.28,0.29,0.30,0.30,0.31,0.31,0.32,0.32,0.33,0.33,0.33,0.33,0.32,0.32,0.32,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.30,0.30,0.28,0.27,0.27,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.21,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.39,0.39,0.38,0.38,0.37,0.37,0.37,0.36,0.36,0.36,0.35,0.35,0.35,0.34,0.34,0.33,0.32,0.32,0.31,0.31,0.31,0.30,0.29,0.28,0.28,0.27,0.27,0.27,0.27,0.27,0.26,0.26,0.26,0.26,0.26,0.27,0.27,0.28,0.29,0.29,0.30,0.30,0.30,0.31,0.32,0.32,0.33,0.33,0.32,0.32,0.32,0.32,0.32,0.31,0.32,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.30,0.29,0.28,0.28,0.27,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.21,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.37,0.36,0.36,0.36,0.35,0.35,0.35,0.35,0.34,0.33,0.32,0.32,0.31,0.31,0.31,0.30,0.29,0.28,0.27,0.27,0.27,0.27,0.26,0.26,0.26,0.26,0.25,0.25,0.25,0.26,0.26,0.27,0.28,0.29,0.29,0.29,0.30,0.30,0.31,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.30,0.31,0.30,0.29,0.28,0.27,0.27,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.21,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.36,0.36,0.36,0.35,0.35,0.35,0.34,0.33,0.32,0.32,0.31,0.31,0.30,0.29,0.29,0.28,0.27,0.27,0.26,0.26,0.26,0.25,0.25,0.24,0.24,0.24,0.24,0.24,0.25,0.26,0.27,0.28,0.28,0.29,0.29,0.29,0.30,0.31,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.30,0.30,0.30,0.29,0.28,0.27,0.27,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.21,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.36,0.36,0.36,0.36,0.35,0.35,0.34,0.33,0.32,0.31,0.31,0.30,0.29,0.29,0.28,0.27,0.27,0.26,0.26,0.25,0.25,0.24,0.24,0.24,0.23,0.23,0.23,0.23,0.24,0.25,0.26,0.27,0.27,0.28,0.28,0.29,0.30,0.30,0.31,0.31,0.32,0.32,0.32,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.30,0.30,0.30,0.29,0.29,0.28,0.27,0.27,0.26,0.24,0.24,0.22,0.22,0.21,0.21,0.21,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.36,0.36,0.36,0.36,0.36,0.35,0.34,0.33,0.32,0.31,0.30,0.29,0.29,0.28,0.28,0.27,0.27,0.26,0.25,0.24,0.24,0.24,0.23,0.23,0.22,0.22,0.22,0.22,0.22,0.23,0.24,0.25,0.26,0.27,0.27,0.28,0.28,0.29,0.30,0.30,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.30,0.30,0.30,0.30,0.29,0.28,0.27,0.27,0.26,0.25,0.24,0.23,0.22,0.22,0.21,0.21,0.20,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.36,0.36,0.36,0.36,0.36,0.35,0.35,0.34,0.32,0.31,0.30,0.29,0.28,0.28,0.27,0.27,0.26,0.25,0.25,0.24,0.24,0.23,0.22,0.22,0.22,0.21,0.21,0.21,0.21,0.21,0.22,0.23,0.24,0.25,0.26,0.26,0.27,0.28,0.28,0.29,0.30,0.30,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.31,0.30,0.31,0.30,0.30,0.29,0.29,0.28,0.27,0.27,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.21,0.20,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.36,0.36,0.36,0.36,0.36,0.35,0.34,0.33,0.31,0.30,0.29,0.28,0.27,0.26,0.26,0.25,0.25,0.24,0.24,0.23,0.22,0.22,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.22,0.23,0.23,0.24,0.25,0.26,0.27,0.27,0.28,0.29,0.29,0.30,0.30,0.30,0.31,0.31,0.31,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.29,0.29,0.28,0.27,0.27,0.26,0.25,0.24,0.24,0.23,0.22,0.21,0.21,0.21,0.20,0.39,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.36,0.36,0.36,0.36,0.35,0.35,0.34,0.33,0.32,0.30,0.29,0.28,0.27,0.26,0.25,0.25,0.24,0.24,0.23,0.23,0.22,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.22,0.22,0.23,0.24,0.25,0.26,0.27,0.27,0.28,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.29,0.29,0.29,0.28,0.28,0.27,0.27,0.26,0.25,0.24,0.23,0.22,0.22,0.21,0.21,0.20,0.20,0.39,0.39,0.40,0.39,0.40,0.40,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.36,0.35,0.35,0.36,0.36,0.35,0.35,0.34,0.32,0.31,0.29,0.28,0.27,0.25,0.24,0.24,0.24,0.23,0.23,0.22,0.22,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.22,0.23,0.24,0.25,0.25,0.26,0.27,0.27,0.28,0.28,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.28,0.28,0.28,0.27,0.27,0.26,0.25,0.24,0.24,0.23,0.22,0.22,0.21,0.21,0.20,0.20,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.35,0.35,0.35,0.35,0.35,0.35,0.35,0.34,0.32,0.31,0.30,0.28,0.27,0.26,0.25,0.24,0.23,0.23,0.22,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.22,0.22,0.23,0.24,0.24,0.25,0.26,0.26,0.27,0.27,0.28,0.28,0.28,0.28,0.29,0.29,0.29,0.28,0.28,0.28,0.28,0.28,0.27,0.27,0.26,0.25,0.25,0.24,0.23,0.23,0.22,0.21,0.21,0.20,0.20,0.20,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.38,0.38};
			return value;
		}
		private double[] getElevationGrid_5_18_height_2()
		{
			double[] value = {0.38,0.37,0.37,0.36,0.36,0.36,0.35,0.35,0.35,0.35,0.35,0.34,0.34,0.33,0.31,0.30,0.29,0.27,0.26,0.25,0.24,0.23,0.22,0.22,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.22,0.22,0.23,0.24,0.24,0.25,0.25,0.26,0.27,0.27,0.27,0.27,0.28,0.28,0.28,0.28,0.28,0.27,0.27,0.27,0.27,0.26,0.25,0.24,0.24,0.23,0.23,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.38,0.37,0.37,0.36,0.35,0.35,0.35,0.35,0.34,0.34,0.34,0.33,0.32,0.31,0.30,0.29,0.28,0.27,0.26,0.24,0.23,0.22,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.21,0.22,0.23,0.23,0.24,0.25,0.25,0.26,0.26,0.27,0.27,0.27,0.27,0.27,0.27,0.27,0.27,0.26,0.26,0.25,0.25,0.24,0.23,0.23,0.22,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.39,0.39,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.35,0.35,0.34,0.34,0.33,0.33,0.32,0.31,0.30,0.29,0.28,0.27,0.27,0.26,0.24,0.23,0.22,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.21,0.22,0.23,0.23,0.24,0.25,0.26,0.26,0.27,0.27,0.27,0.27,0.27,0.26,0.26,0.26,0.25,0.24,0.24,0.23,0.23,0.22,0.22,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.38,0.38,0.39,0.39,0.38,0.38,0.38,0.38,0.38,0.38,0.37,0.36,0.36,0.35,0.35,0.34,0.33,0.33,0.32,0.31,0.30,0.29,0.28,0.27,0.26,0.26,0.25,0.25,0.23,0.22,0.22,0.21,0.21,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.22,0.23,0.24,0.25,0.25,0.26,0.26,0.26,0.26,0.26,0.25,0.25,0.25,0.24,0.24,0.23,0.23,0.22,0.22,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.35,0.34,0.33,0.32,0.31,0.30,0.29,0.28,0.26,0.25,0.24,0.24,0.24,0.24,0.23,0.22,0.21,0.21,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.22,0.23,0.23,0.24,0.25,0.25,0.25,0.25,0.25,0.25,0.25,0.24,0.24,0.24,0.23,0.23,0.22,0.22,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.37,0.37,0.36,0.35,0.35,0.34,0.33,0.32,0.32,0.30,0.29,0.28,0.26,0.24,0.23,0.23,0.23,0.23,0.22,0.22,0.21,0.20,0.19,0.19,0.19,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.22,0.23,0.24,0.24,0.24,0.24,0.24,0.24,0.24,0.24,0.24,0.24,0.23,0.23,0.22,0.22,0.22,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.37,0.37,0.36,0.36,0.35,0.34,0.33,0.32,0.32,0.30,0.29,0.27,0.25,0.24,0.23,0.21,0.21,0.21,0.21,0.21,0.20,0.19,0.19,0.18,0.17,0.17,0.16,0.16,0.16,0.16,0.17,0.17,0.17,0.17,0.18,0.18,0.18,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.22,0.23,0.23,0.24,0.24,0.24,0.23,0.23,0.24,0.23,0.24,0.24,0.23,0.23,0.22,0.22,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.37,0.38,0.38,0.38,0.38,0.37,0.37,0.37,0.36,0.36,0.35,0.34,0.33,0.32,0.32,0.31,0.29,0.28,0.26,0.24,0.23,0.21,0.21,0.20,0.20,0.19,0.19,0.18,0.17,0.16,0.16,0.15,0.15,0.14,0.14,0.14,0.14,0.15,0.15,0.15,0.16,0.16,0.16,0.17,0.17,0.18,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.22,0.22,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.22,0.22,0.22,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.36,0.36,0.35,0.34,0.34,0.33,0.32,0.31,0.30,0.28,0.27,0.25,0.23,0.22,0.21,0.20,0.19,0.18,0.18,0.17,0.16,0.15,0.14,0.13,0.12,0.12,0.12,0.12,0.12,0.12,0.12,0.13,0.13,0.14,0.14,0.15,0.15,0.16,0.17,0.17,0.18,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.22,0.22,0.22,0.23,0.23,0.22,0.23,0.23,0.23,0.24,0.23,0.23,0.22,0.22,0.22,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.20,0.37,0.37,0.37,0.37,0.37,0.37,0.36,0.36,0.35,0.35,0.34,0.33,0.32,0.31,0.30,0.29,0.27,0.25,0.24,0.22,0.21,0.20,0.19,0.18,0.16,0.15,0.14,0.13,0.12,0.11,0.10,0.10,0.10,0.10,0.10,0.09,0.10,0.10,0.10,0.11,0.11,0.12,0.13,0.14,0.14,0.15,0.16,0.17,0.18,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.22,0.22,0.22,0.22,0.22,0.23,0.23,0.23,0.23,0.23,0.23,0.22,0.22,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.20,0.20,0.20,0.37,0.37,0.37,0.37,0.36,0.36,0.36,0.35,0.34,0.34,0.33,0.32,0.32,0.31,0.29,0.28,0.26,0.24,0.23,0.21,0.20,0.19,0.17,0.16,0.14,0.12,0.11,0.10,0.09,0.08,0.08,0.08,0.08,0.07,0.07,0.07,0.07,0.07,0.08,0.08,0.09,0.10,0.11,0.12,0.13,0.13,0.14,0.15,0.16,0.17,0.18,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.22,0.22,0.22,0.22,0.22,0.22,0.23,0.23,0.23,0.23,0.22,0.22,0.22,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.20,0.20,0.20,0.36,0.36,0.36,0.36,0.36,0.35,0.35,0.34,0.34,0.33,0.33,0.32,0.31,0.30,0.29,0.27,0.25,0.23,0.21,0.19};
			return value;
		}
		private double[] getElevationGrid_5_18_height_3()
		{
			double[] value = {0.18,0.16,0.14,0.12,0.10,0.09,0.08,0.07,0.06,0.06,0.06,0.06,0.06,0.05,0.05,0.05,0.05,0.05,0.05,0.06,0.07,0.07,0.09,0.10,0.11,0.12,0.13,0.14,0.15,0.16,0.17,0.18,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.22,0.22,0.22,0.22,0.22,0.22,0.23,0.23,0.23,0.22,0.22,0.22,0.21,0.21,0.21,0.21,0.20,0.20,0.19,0.19,0.19,0.19,0.20,0.20,0.36,0.36,0.36,0.36,0.35,0.35,0.35,0.34,0.33,0.33,0.32,0.31,0.30,0.29,0.28,0.25,0.23,0.21,0.20,0.18,0.16,0.13,0.11,0.09,0.07,0.06,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.05,0.05,0.06,0.06,0.08,0.09,0.10,0.11,0.12,0.13,0.14,0.15,0.17,0.18,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.22,0.22,0.22,0.22,0.22,0.22,0.22,0.22,0.22,0.22,0.22,0.21,0.21,0.21,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.35,0.35,0.35,0.35,0.35,0.34,0.34,0.33,0.33,0.32,0.31,0.31,0.29,0.28,0.26,0.24,0.22,0.20,0.18,0.15,0.12,0.10,0.07,0.06,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.05,0.05,0.06,0.07,0.09,0.10,0.11,0.12,0.13,0.14,0.15,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.21,0.22,0.22,0.22,0.22,0.22,0.22,0.22,0.22,0.22,0.21,0.21,0.21,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.35,0.34,0.34,0.34,0.34,0.34,0.33,0.33,0.32,0.32,0.31,0.30,0.28,0.27,0.24,0.22,0.20,0.17,0.15,0.12,0.09,0.06,0.05,0.04,0.03,0.03,0.03,0.03,0.03,0.04,0.04,0.04,0.05,0.04,0.04,0.05,0.05,0.04,0.04,0.04,0.04,0.04,0.05,0.05,0.06,0.07,0.08,0.10,0.10,0.11,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.21,0.22,0.22,0.22,0.22,0.22,0.21,0.21,0.21,0.21,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.34,0.34,0.34,0.34,0.33,0.33,0.33,0.32,0.32,0.31,0.30,0.29,0.27,0.25,0.22,0.20,0.17,0.15,0.12,0.08,0.05,0.04,0.03,0.02,0.02,0.02,0.02,0.02,0.03,0.04,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.04,0.04,0.04,0.05,0.05,0.06,0.07,0.08,0.10,0.10,0.11,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.33,0.33,0.33,0.33,0.33,0.33,0.32,0.32,0.31,0.30,0.29,0.27,0.25,0.23,0.20,0.18,0.15,0.12,0.08,0.05,0.03,0.02,0.02,0.01,0.01,0.01,0.02,0.02,0.03,0.04,0.05,0.05,0.06,0.06,0.07,0.07,0.07,0.07,0.06,0.06,0.05,0.05,0.04,0.05,0.05,0.05,0.06,0.08,0.09,0.09,0.10,0.11,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.33,0.33,0.33,0.33,0.33,0.32,0.32,0.31,0.30,0.29,0.28,0.26,0.23,0.21,0.18,0.15,0.12,0.08,0.06,0.04,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.04,0.05,0.06,0.06,0.07,0.07,0.08,0.08,0.08,0.08,0.08,0.07,0.06,0.05,0.05,0.05,0.05,0.05,0.06,0.07,0.08,0.08,0.09,0.10,0.11,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.34,0.33,0.33,0.33,0.32,0.32,0.31,0.31,0.29,0.28,0.26,0.24,0.21,0.19,0.15,0.12,0.09,0.06,0.04,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.03,0.05,0.06,0.07,0.08,0.08,0.08,0.09,0.09,0.09,0.10,0.09,0.08,0.08,0.07,0.06,0.05,0.05,0.05,0.06,0.06,0.06,0.07,0.08,0.09,0.09,0.11,0.12,0.13,0.14,0.16,0.17,0.18,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.33,0.33,0.33,0.32,0.32,0.31,0.31,0.30,0.28,0.27,0.24,0.22,0.19,0.16,0.13,0.09,0.06,0.04,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.05,0.06,0.07,0.08,0.08,0.09,0.09,0.10,0.10,0.11,0.11,0.10,0.10,0.09,0.08,0.07,0.06,0.06,0.06,0.06,0.06,0.06,0.06,0.06,0.07,0.08,0.09,0.10,0.12,0.13,0.15,0.16,0.18,0.18,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.20,0.20,0.33,0.33,0.32,0.32,0.31,0.30,0.29,0.28,0.27,0.24,0.22,0.19,0.16,0.13,0.10,0.07,0.04,0.03,0.02,0.01,0.01,0.01,0.01,0.02,0.02,0.03,0.05,0.06,0.08,0.08,0.09,0.09,0.10,0.11,0.12,0.12,0.12,0.12,0.12,0.11,0.10,0.09,0.08,0.08,0.07,0.06,0.06,0.06,0.06,0.05,0.05,0.05,0.06,0.08,0.09,0.11,0.12,0.13,0.15,0.16,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.20,0.20,0.33,0.32,0.32,0.31,0.30,0.29,0.28,0.27,0.25,0.22,0.20,0.17,0.14,0.10,0.07,0.04,0.03,0.02,0.01,0.01,0.01,0.01,0.02,0.02,0.03,0.05,0.06,0.08,0.09,0.09,0.10,0.11,0.12,0.13,0.14,0.14,0.14,0.14,0.13,0.13,0.12,0.11,0.10,0.09,0.08,0.08,0.07,0.06,0.06,0.05,0.05,0.05,0.05,0.06,0.08,0.09,0.11,0.12,0.13,0.15,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.32,0.31,0.31,0.30,0.29,0.28,0.26,0.25,0.22,0.20,0.17,0.14,0.11,0.07,0.05,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.05,0.07,0.08,0.09,0.10,0.11};
			return value;
		}
		private double[] getElevationGrid_5_18_height_4()
		{
			double[] value = {0.11,0.13,0.14,0.15,0.16,0.16,0.16,0.16,0.15,0.14,0.13,0.12,0.12,0.11,0.10,0.09,0.08,0.07,0.06,0.05,0.04,0.04,0.05,0.05,0.07,0.08,0.10,0.11,0.12,0.14,0.15,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.21,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.31,0.30,0.29,0.28,0.27,0.26,0.24,0.22,0.20,0.17,0.14,0.11,0.08,0.05,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.05,0.07,0.08,0.10,0.10,0.11,0.12,0.13,0.14,0.16,0.17,0.17,0.18,0.17,0.17,0.17,0.16,0.15,0.14,0.13,0.12,0.11,0.10,0.09,0.08,0.07,0.06,0.05,0.04,0.04,0.05,0.05,0.07,0.08,0.10,0.11,0.13,0.14,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.21,0.21,0.20,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.18,0.18,0.18,0.18,0.19,0.29,0.28,0.27,0.26,0.25,0.24,0.22,0.20,0.17,0.14,0.11,0.08,0.05,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.04,0.06,0.08,0.10,0.11,0.11,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.19,0.19,0.19,0.18,0.17,0.17,0.16,0.15,0.14,0.13,0.12,0.11,0.09,0.08,0.06,0.05,0.05,0.04,0.04,0.05,0.05,0.07,0.09,0.10,0.11,0.13,0.14,0.16,0.17,0.18,0.19,0.20,0.20,0.20,0.20,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.18,0.18,0.18,0.18,0.18,0.18,0.27,0.26,0.25,0.24,0.23,0.21,0.19,0.17,0.14,0.11,0.08,0.06,0.04,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.02,0.04,0.05,0.08,0.09,0.11,0.11,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.18,0.17,0.16,0.15,0.14,0.13,0.12,0.11,0.09,0.08,0.06,0.05,0.05,0.04,0.04,0.05,0.06,0.07,0.09,0.10,0.12,0.13,0.15,0.16,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.21,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.18,0.18,0.18,0.17,0.17,0.17,0.17,0.17,0.25,0.24,0.23,0.21,0.20,0.18,0.16,0.14,0.11,0.08,0.06,0.04,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.02,0.03,0.05,0.07,0.09,0.10,0.11,0.13,0.13,0.15,0.16,0.17,0.18,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.16,0.15,0.14,0.13,0.12,0.11,0.09,0.08,0.06,0.05,0.04,0.04,0.04,0.05,0.06,0.08,0.09,0.11,0.12,0.13,0.15,0.16,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.18,0.18,0.18,0.17,0.17,0.16,0.16,0.16,0.16,0.16,0.24,0.22,0.21,0.19,0.17,0.15,0.13,0.11,0.08,0.06,0.04,0.02,0.01,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.04,0.06,0.08,0.09,0.11,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.15,0.14,0.13,0.12,0.11,0.09,0.08,0.06,0.05,0.04,0.04,0.04,0.05,0.06,0.08,0.10,0.11,0.12,0.14,0.15,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.18,0.18,0.18,0.18,0.17,0.16,0.16,0.15,0.15,0.15,0.15,0.22,0.20,0.18,0.16,0.14,0.12,0.10,0.08,0.06,0.04,0.02,0.01,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.04,0.05,0.07,0.08,0.10,0.12,0.13,0.14,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.16,0.14,0.13,0.12,0.11,0.09,0.07,0.06,0.05,0.04,0.04,0.04,0.05,0.07,0.08,0.10,0.11,0.13,0.14,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.20,0.19,0.19,0.19,0.19,0.19,0.18,0.18,0.17,0.17,0.16,0.15,0.15,0.14,0.14,0.14,0.14,0.20,0.18,0.16,0.13,0.11,0.09,0.07,0.05,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.03,0.04,0.06,0.08,0.09,0.11,0.13,0.14,0.15,0.16,0.17,0.18,0.19,0.20,0.20,0.20,0.20,0.20,0.20,0.20,0.21,0.20,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.15,0.14,0.13,0.12,0.10,0.09,0.07,0.05,0.05,0.04,0.04,0.05,0.06,0.07,0.09,0.10,0.11,0.13,0.15,0.16,0.17,0.18,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.18,0.18,0.17,0.17,0.16,0.15,0.15,0.14,0.14,0.14,0.14,0.14,0.17,0.15,0.12,0.10,0.08,0.06,0.05,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.02,0.03,0.04,0.04,0.05,0.07,0.09,0.10,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.20,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.15,0.14,0.13,0.11,0.10,0.08,0.07,0.05,0.04,0.04,0.04,0.05,0.06,0.08,0.09,0.11,0.12,0.13,0.15,0.16,0.18,0.18,0.19,0.19,0.19,0.19,0.19,0.19,0.18,0.18,0.18,0.17,0.17,0.16,0.16,0.15,0.14,0.14,0.13,0.13,0.14,0.14,0.14,0.11,0.09,0.07,0.05,0.04,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.04,0.04,0.05,0.07,0.08,0.10,0.11,0.13,0.14,0.16,0.17,0.18,0.19,0.19,0.20,0.20,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.18,0.16,0.15,0.14,0.13,0.11,0.10,0.08,0.06,0.05,0.04,0.04,0.05,0.05,0.07,0.08,0.10,0.11,0.12,0.14,0.15,0.17,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.18,0.17,0.16,0.16,0.15,0.14,0.14,0.14,0.13,0.14,0.14,0.14,0.11,0.09,0.06,0.05,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.01,0.02,0.02,0.03,0.04,0.04,0.05,0.06,0.08,0.09,0.11,0.12,0.14,0.15,0.16,0.17,0.18,0.19,0.20,0.20,0.21,0.21,0.21,0.21,0.22,0.22,0.22,0.22,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.18,0.16,0.15,0.14,0.12,0.11,0.09,0.07,0.06,0.05,0.04,0.04,0.05,0.06,0.07,0.09,0.10,0.11,0.13,0.14,0.15,0.16,0.17,0.18,0.18,0.18,0.18,0.17,0.17,0.17,0.17,0.16,0.16,0.15,0.15,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.08,0.06,0.04,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.01,0.02,0.02,0.03,0.04,0.05,0.05,0.06,0.07,0.08,0.10,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.19,0.20,0.21,0.21,0.21,0.22,0.22,0.23,0.23,0.23,0.23,0.23};
			return value;
		}
		private double[] getElevationGrid_5_18_height_5()
		{
			double[] value = {0.22,0.22,0.21,0.21,0.20,0.20,0.20,0.19,0.18,0.17,0.16,0.15,0.13,0.12,0.11,0.09,0.07,0.05,0.05,0.04,0.04,0.05,0.06,0.08,0.09,0.11,0.12,0.13,0.14,0.15,0.16,0.17,0.17,0.17,0.17,0.17,0.17,0.17,0.16,0.16,0.15,0.15,0.14,0.14,0.14,0.13,0.14,0.14,0.13,0.14,0.06,0.04,0.02,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.02,0.02,0.03,0.04,0.05,0.05,0.06,0.07,0.08,0.09,0.11,0.13,0.14,0.16,0.17,0.18,0.18,0.19,0.20,0.21,0.21,0.21,0.22,0.23,0.23,0.24,0.24,0.24,0.24,0.23,0.23,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.18,0.17,0.16,0.14,0.13,0.12,0.10,0.08,0.06,0.05,0.04,0.04,0.05,0.05,0.07,0.08,0.10,0.11,0.12,0.13,0.14,0.15,0.16,0.16,0.16,0.16,0.16,0.16,0.16,0.16,0.15,0.15,0.14,0.14,0.14,0.14,0.13,0.14,0.14,0.14,0.14,0.04,0.02,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.02,0.03,0.04,0.04,0.05,0.06,0.06,0.07,0.08,0.09,0.10,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.20,0.20,0.21,0.22,0.22,0.23,0.23,0.24,0.24,0.24,0.24,0.24,0.24,0.24,0.23,0.22,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.15,0.14,0.13,0.11,0.09,0.07,0.05,0.05,0.04,0.04,0.05,0.06,0.08,0.09,0.10,0.11,0.12,0.13,0.14,0.15,0.15,0.15,0.16,0.16,0.15,0.15,0.15,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.03,0.02,0.01,0.01,0.01,0.01,0.01,0.02,0.02,0.03,0.04,0.05,0.05,0.06,0.07,0.08,0.08,0.08,0.10,0.11,0.12,0.14,0.15,0.17,0.18,0.19,0.20,0.20,0.21,0.22,0.22,0.23,0.24,0.24,0.24,0.25,0.25,0.25,0.25,0.25,0.24,0.24,0.23,0.22,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.18,0.16,0.15,0.14,0.12,0.11,0.09,0.06,0.05,0.04,0.04,0.05,0.05,0.07,0.08,0.09,0.10,0.11,0.12,0.13,0.14,0.14,0.15,0.15,0.15,0.15,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.03,0.02,0.02,0.01,0.01,0.02,0.02,0.03,0.04,0.04,0.05,0.06,0.07,0.07,0.08,0.08,0.08,0.09,0.10,0.11,0.13,0.15,0.16,0.17,0.18,0.19,0.20,0.21,0.22,0.22,0.23,0.24,0.24,0.25,0.25,0.25,0.26,0.26,0.26,0.25,0.25,0.24,0.23,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.18,0.18,0.16,0.15,0.13,0.12,0.10,0.08,0.06,0.05,0.04,0.04,0.05,0.06,0.07,0.09,0.10,0.11,0.11,0.12,0.13,0.13,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.13,0.14,0.14,0.13,0.14,0.14,0.14,0.13,0.04,0.03,0.02,0.02,0.03,0.03,0.03,0.04,0.05,0.06,0.06,0.07,0.07,0.08,0.08,0.09,0.09,0.10,0.11,0.12,0.14,0.16,0.17,0.18,0.19,0.20,0.21,0.22,0.22,0.23,0.24,0.25,0.25,0.26,0.26,0.26,0.26,0.26,0.27,0.26,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.20,0.20,0.20,0.20,0.19,0.18,0.17,0.16,0.14,0.13,0.11,0.09,0.07,0.05,0.04,0.04,0.05,0.05,0.07,0.08,0.09,0.10,0.11,0.12,0.12,0.13,0.13,0.13,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.05,0.04,0.04,0.04,0.04,0.04,0.05,0.06,0.06,0.07,0.08,0.08,0.09,0.09,0.09,0.09,0.09,0.10,0.11,0.13,0.15,0.16,0.17,0.19,0.20,0.21,0.21,0.22,0.23,0.24,0.25,0.25,0.26,0.27,0.27,0.27,0.27,0.28,0.28,0.27,0.27,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.18,0.17,0.16,0.14,0.12,0.10,0.08,0.06,0.05,0.04,0.04,0.05,0.06,0.07,0.08,0.09,0.10,0.11,0.12,0.12,0.13,0.13,0.13,0.13,0.13,0.13,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.13,0.13,0.14,0.06,0.05,0.05,0.05,0.05,0.06,0.06,0.07,0.08,0.08,0.09,0.09,0.09,0.09,0.09,0.09,0.10,0.11,0.12,0.14,0.15,0.17,0.18,0.19,0.20,0.21,0.22,0.23,0.24,0.25,0.26,0.26,0.27,0.28,0.28,0.29,0.29,0.29,0.29,0.29,0.28,0.27,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.18,0.17,0.15,0.13,0.12,0.09,0.07,0.05,0.05,0.04,0.04,0.05,0.06,0.08,0.09,0.10,0.10,0.11,0.11,0.12,0.12,0.13,0.13,0.13,0.13,0.14,0.14,0.14,0.14,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.08,0.07,0.07,0.07,0.07,0.08,0.08,0.09,0.09,0.10,0.10,0.09,0.09,0.09,0.09,0.10,0.11,0.12,0.14,0.15,0.16,0.18,0.19,0.20,0.21,0.22,0.23,0.24,0.25,0.26,0.27,0.28,0.28,0.29,0.29,0.30,0.30,0.30,0.30,0.30,0.29,0.29,0.28,0.27,0.26,0.24,0.24,0.22,0.22,0.21,0.21,0.20,0.20,0.19,0.19,0.18,0.16,0.15,0.13,0.11,0.08,0.06,0.05,0.04,0.04,0.05,0.05,0.06,0.08,0.09,0.10,0.10,0.11,0.11,0.12,0.12,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.10,0.10,0.10,0.10,0.10,0.10,0.10,0.10,0.10,0.10,0.10,0.10,0.09,0.09,0.10,0.11,0.12,0.13,0.15,0.16,0.18,0.19,0.20,0.21,0.22,0.23,0.24,0.25,0.26,0.27,0.28,0.29,0.30,0.30,0.31,0.31,0.31,0.31,0.31,0.31,0.30,0.30,0.29,0.28,0.27,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.20,0.20,0.19,0.19,0.17,0.16,0.14,0.12,0.10,0.08,0.06,0.05,0.04,0.05,0.05,0.06,0.07,0.08,0.09,0.10,0.11,0.11,0.12,0.12,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.12,0.12,0.11,0.11,0.11,0.11,0.11,0.11,0.11,0.10,0.10,0.10,0.10,0.10,0.11,0.12,0.13,0.15,0.16,0.17,0.18,0.20,0.21,0.22,0.23,0.24,0.25,0.26,0.27,0.28,0.29,0.30,0.31,0.31,0.32,0.32,0.32,0.31,0.31,0.31,0.31,0.30,0.29,0.29,0.28,0.27,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.20,0.20,0.19,0.19,0.17,0.16,0.14,0.12,0.09,0.07,0.05,0.05,0.04,0.05,0.05,0.06,0.07,0.08,0.09,0.10,0.11,0.11,0.11,0.12,0.12,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.13,0.12,0.12,0.12,0.12,0.13,0.13,0.12,0.12,0.12,0.12,0.11,0.11,0.11,0.10,0.10,0.10,0.10,0.11,0.12,0.13,0.14,0.16,0.17,0.18,0.19,0.20,0.21,0.22,0.24,0.25,0.26,0.27,0.28,0.29,0.30,0.31,0.32,0.32,0.32,0.32,0.32,0.31,0.31,0.31,0.31,0.30,0.30,0.30,0.29,0.29,0.28,0.27,0.26,0.24};
			return value;
		}
		private double[] getElevationGrid_5_18_height_6()
		{
			double[] value = {0.23,0.22,0.21,0.21,0.20,0.20,0.19,0.18,0.17,0.15,0.13,0.11,0.08,0.06,0.05,0.05,0.04,0.05,0.05,0.06,0.07,0.08,0.09,0.10,0.10,0.11,0.11,0.12,0.12,0.13,0.13,0.13,0.13,0.13,0.12,0.12,0.12,0.11,0.11,0.12,0.14,0.13,0.13,0.12,0.12,0.12,0.11,0.11,0.11,0.11,0.11,0.11,0.12,0.12,0.13,0.15,0.16,0.17,0.18,0.19,0.20,0.21,0.22,0.23,0.24,0.25,0.27,0.28,0.29,0.30,0.31,0.32,0.32,0.32,0.32,0.32,0.32,0.31,0.31,0.31,0.30,0.30,0.30,0.30,0.30,0.29,0.29,0.28,0.27,0.26,0.24,0.23,0.22,0.21,0.21,0.20,0.20,0.19,0.18,0.16,0.15,0.12,0.10,0.08,0.06,0.05,0.04,0.04,0.05,0.05,0.06,0.07,0.08,0.09,0.10,0.10,0.11,0.11,0.12,0.12,0.13,0.13,0.12,0.12,0.11,0.11,0.11,0.11,0.11,0.11,0.15,0.14,0.13,0.13,0.13,0.12,0.12,0.11,0.11,0.11,0.12,0.12,0.13,0.14,0.15,0.16,0.17,0.18,0.19,0.20,0.21,0.22,0.23,0.24,0.25,0.26,0.27,0.29,0.30,0.31,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.31,0.31,0.31,0.31,0.31,0.30,0.30,0.30,0.30,0.29,0.29,0.28,0.27,0.26,0.24,0.23,0.22,0.21,0.21,0.20,0.19,0.19,0.17,0.16,0.14,0.12,0.09,0.07,0.06,0.05,0.04,0.05,0.05,0.05,0.06,0.07,0.08,0.09,0.10,0.10,0.11,0.11,0.12,0.12,0.12,0.12,0.11,0.11,0.10,0.10,0.10,0.10,0.10,0.16,0.15,0.14,0.13,0.13,0.13,0.12,0.12,0.12,0.12,0.13,0.13,0.14,0.15,0.16,0.17,0.18,0.19,0.20,0.21,0.22,0.23,0.24,0.25,0.26,0.27,0.28,0.30,0.31,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.31,0.31,0.31,0.31,0.31,0.31,0.30,0.30,0.30,0.30,0.30,0.29,0.28,0.27,0.26,0.24,0.23,0.22,0.21,0.21,0.20,0.19,0.18,0.17,0.15,0.13,0.11,0.09,0.07,0.06,0.05,0.05,0.05,0.05,0.05,0.06,0.07,0.08,0.09,0.09,0.10,0.10,0.11,0.11,0.11,0.11,0.11,0.10,0.10,0.10,0.09,0.09,0.10,0.16,0.15,0.15,0.14,0.14,0.13,0.13,0.13,0.13,0.13,0.14,0.14,0.15,0.16,0.17,0.18,0.19,0.20,0.21,0.21,0.22,0.23,0.24,0.25,0.26,0.28,0.29,0.30,0.31,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.31,0.31,0.31,0.31,0.30,0.30,0.29,0.28,0.27,0.25,0.24,0.22,0.21,0.21,0.20,0.20,0.19,0.18,0.16,0.14,0.13,0.10,0.08,0.07,0.05,0.05,0.05,0.05,0.05,0.05,0.06,0.07,0.07,0.08,0.09,0.10,0.10,0.11,0.11,0.11,0.10,0.10,0.09,0.09,0.09,0.09,0.09,0.16,0.15,0.14,0.14,0.14,0.13,0.13,0.13,0.13,0.14,0.15,0.16,0.16,0.17,0.18,0.19,0.20,0.21,0.21,0.22,0.23,0.24,0.25,0.26,0.27,0.28,0.29,0.31,0.32,0.32,0.32,0.32,0.32,0.32,0.32,0.33,0.33,0.33,0.34,0.34,0.33,0.33,0.33,0.32,0.32,0.32,0.31,0.31,0.30,0.30,0.29,0.28,0.27,0.25,0.23,0.22,0.21,0.21,0.20,0.19,0.18,0.17,0.16,0.14,0.12,0.10,0.08,0.07,0.06,0.05,0.05,0.05,0.05,0.05,0.06,0.06,0.07,0.08,0.09,0.09,0.10,0.10,0.10,0.10,0.09,0.09,0.09,0.09,0.09,0.09,0.16,0.15,0.15,0.14,0.14,0.14,0.14,0.14,0.14,0.15,0.16,0.17,0.17,0.18,0.19,0.20,0.21,0.21,0.22,0.23,0.24,0.24,0.25,0.26,0.28,0.29,0.30,0.32,0.32,0.32,0.33,0.33,0.33,0.33,0.34,0.34,0.35,0.35,0.35,0.35,0.35,0.35,0.34,0.34,0.33,0.33,0.32,0.32,0.31,0.31,0.30,0.29,0.28,0.26,0.24,0.23,0.22,0.21,0.20,0.19,0.19,0.18,0.16,0.15,0.13,0.11,0.10,0.08,0.07,0.06,0.05,0.05,0.05,0.05,0.05,0.05,0.06,0.06,0.07,0.08,0.09,0.09,0.10,0.09,0.09,0.09,0.08,0.08,0.09,0.09,0.16,0.15,0.15,0.14,0.14,0.14,0.15,0.15,0.15,0.16,0.17,0.17,0.18,0.19,0.20,0.21,0.21,0.22,0.23,0.23,0.24,0.25,0.26,0.27,0.29,0.30,0.31,0.32,0.33,0.33,0.33,0.33,0.33,0.34,0.35,0.35,0.35,0.36,0.36,0.36,0.36,0.36,0.35,0.35,0.35,0.34,0.33,0.33,0.32,0.32,0.31,0.30,0.29,0.27,0.25,0.24,0.22,0.21,0.20,0.20,0.19,0.19,0.17,0.16,0.14,0.13,0.11,0.10,0.08,0.07,0.06,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.06,0.07,0.08,0.08,0.09,0.09,0.08,0.08,0.07,0.07,0.07,0.08,0.16,0.15,0.15,0.15,0.15,0.15,0.15,0.16,0.16,0.17,0.18,0.19,0.19,0.20,0.21,0.21,0.22,0.23,0.23,0.24,0.25,0.26,0.27,0.28,0.29,0.31,0.32,0.33,0.33,0.33,0.34,0.34,0.34,0.35,0.35,0.36,0.36,0.37,0.37,0.37,0.37,0.37,0.36,0.36,0.36,0.35,0.34,0.34,0.33,0.32,0.32,0.31,0.30,0.28,0.26,0.24,0.23,0.21,0.21,0.20,0.20,0.19,0.18,0.17,0.15,0.14,0.13,0.11,0.10,0.08,0.07,0.06,0.05,0.05,0.05,0.04,0.04,0.05,0.05,0.05,0.06,0.07,0.07,0.07,0.07,0.07,0.06,0.06,0.06,0.07,0.16,0.16,0.15,0.15,0.15,0.16,0.16,0.16,0.17,0.18,0.19,0.19,0.20,0.21,0.21,0.22,0.22,0.23,0.24,0.25,0.25,0.26,0.27,0.29,0.31,0.32,0.33,0.34,0.34,0.34,0.34,0.34,0.35,0.35,0.36,0.36,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.36,0.36,0.35,0.35,0.34,0.33,0.32,0.32,0.31,0.29,0.27,0.25,0.23,0.22,0.21,0.20,0.20,0.19,0.19,0.18,0.16,0.15,0.14,0.13,0.12,0.10,0.09,0.08,0.07,0.06,0.05,0.05,0.04,0.04,0.04,0.04,0.05,0.05,0.06,0.06,0.06,0.06,0.06,0.06,0.06,0.07,0.17,0.16,0.16,0.16,0.16,0.16,0.17,0.17,0.18,0.19,0.20,0.20,0.21,0.21,0.22,0.22,0.23,0.24,0.24,0.25,0.26,0.27,0.29,0.30,0.32,0.33,0.34,0.35,0.35,0.35,0.35,0.35,0.35,0.36,0.37,0.38,0.38,0.38,0.39,0.39,0.39,0.38,0.38,0.37,0.37,0.37,0.36,0.35,0.35,0.34,0.33,0.33,0.32,0.30,0.28,0.26,0.24,0.22,0.21,0.20,0.20,0.20,0.19,0.18,0.17,0.16,0.15,0.13,0.12,0.12,0.11,0.10,0.08,0.07,0.06,0.05,0.05,0.04,0.04,0.04,0.04,0.05,0.05,0.05,0.05,0.06,0.06,0.06,0.06,0.07,0.17,0.17,0.16,0.16,0.17,0.17,0.18,0.19,0.19,0.20,0.20,0.21,0.21,0.22,0.23,0.23,0.24,0.24,0.25,0.26,0.27,0.28,0.30,0.31,0.33,0.34,0.35,0.35,0.35,0.35,0.35,0.35,0.36,0.37,0.38,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.38,0.37,0.37,0.36,0.36,0.35,0.35,0.34,0.33,0.32,0.31,0.29,0.27,0.25,0.23,0.21,0.21};
			return value;
		}
		private double[] getElevationGrid_5_18_height_7()
		{
			double[] value = {0.20,0.20,0.19,0.19,0.18,0.17,0.15,0.14,0.13,0.13,0.12,0.11,0.10,0.09,0.08,0.07,0.06,0.05,0.05,0.04,0.04,0.04,0.04,0.04,0.05,0.05,0.05,0.06,0.06,0.06,0.18,0.17,0.17,0.17,0.18,0.18,0.19,0.20,0.20,0.21,0.21,0.22,0.22,0.23,0.23,0.24,0.24,0.25,0.26,0.27,0.28,0.29,0.31,0.32,0.33,0.34,0.35,0.35,0.35,0.35,0.36,0.36,0.37,0.38,0.39,0.39,0.39,0.40,0.40,0.40,0.39,0.39,0.39,0.39,0.38,0.37,0.37,0.36,0.35,0.35,0.35,0.34,0.33,0.32,0.30,0.28,0.26,0.24,0.22,0.21,0.20,0.20,0.20,0.19,0.18,0.17,0.16,0.15,0.14,0.13,0.12,0.12,0.11,0.11,0.10,0.09,0.07,0.06,0.05,0.05,0.05,0.04,0.04,0.04,0.04,0.04,0.05,0.05,0.05,0.06,0.19,0.18,0.19,0.19,0.19,0.19,0.20,0.20,0.21,0.21,0.22,0.22,0.23,0.23,0.24,0.24,0.25,0.25,0.26,0.27,0.29,0.30,0.32,0.33,0.34,0.35,0.35,0.35,0.35,0.36,0.36,0.36,0.38,0.39,0.39,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.38,0.37,0.36,0.36,0.35,0.35,0.34,0.34,0.33,0.31,0.29,0.27,0.24,0.22,0.21,0.21,0.20,0.20,0.19,0.19,0.18,0.17,0.16,0.14,0.13,0.13,0.12,0.12,0.11,0.11,0.10,0.09,0.08,0.07,0.06,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.05,0.05,0.19,0.19,0.19,0.19,0.20,0.20,0.21,0.21,0.22,0.22,0.23,0.23,0.24,0.24,0.24,0.25,0.25,0.26,0.27,0.28,0.30,0.31,0.32,0.33,0.34,0.35,0.35,0.35,0.35,0.35,0.36,0.37,0.38,0.39,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.38,0.37,0.36,0.35,0.35,0.35,0.34,0.33,0.32,0.30,0.27,0.25,0.23,0.22,0.21,0.20,0.20,0.20,0.19,0.19,0.18,0.16,0.15,0.14,0.13,0.13,0.12,0.12,0.11,0.11,0.10,0.09,0.08,0.07,0.05,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.05,0.20,0.20,0.20,0.20,0.21,0.21,0.21,0.22,0.22,0.23,0.23,0.24,0.24,0.24,0.25,0.25,0.26,0.27,0.28,0.29,0.30,0.31,0.32,0.33,0.34,0.34,0.35,0.35,0.35,0.35,0.36,0.37,0.39,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.38,0.37,0.36,0.36,0.35,0.35,0.35,0.34,0.33,0.31,0.28,0.26,0.24,0.22,0.21,0.21,0.20,0.20,0.19,0.19,0.18,0.17,0.16,0.14,0.14,0.13,0.13,0.12,0.12,0.11,0.10,0.10,0.09,0.08,0.06,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.05,0.20,0.21,0.21,0.21,0.21,0.22,0.22,0.23,0.23,0.23,0.24,0.24,0.25,0.25,0.25,0.26,0.26,0.27,0.29,0.30,0.31,0.32,0.32,0.33,0.33,0.34,0.35,0.35,0.35,0.35,0.36,0.37,0.39,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.38,0.37,0.36,0.36,0.35,0.35,0.35,0.34,0.33,0.32,0.29,0.27,0.24,0.23,0.21,0.21,0.20,0.20,0.20,0.19,0.18,0.17,0.16,0.15,0.14,0.13,0.13,0.13,0.12,0.11,0.11,0.10,0.10,0.09,0.07,0.06,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.05,0.21,0.21,0.21,0.22,0.22,0.23,0.23,0.23,0.24,0.24,0.24,0.25,0.25,0.25,0.26,0.26,0.27,0.28,0.29,0.30,0.31,0.32,0.32,0.32,0.33,0.34,0.34,0.35,0.35,0.36,0.36,0.37,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.38,0.37,0.36,0.35,0.35,0.35,0.35,0.35,0.34,0.32,0.30,0.28,0.25,0.23,0.22,0.21,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.16,0.14,0.14,0.13,0.13,0.12,0.12,0.11,0.11,0.10,0.09,0.08,0.07,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.21,0.22,0.22,0.23,0.23,0.23,0.24,0.24,0.24,0.24,0.25,0.25,0.25,0.26,0.26,0.27,0.27,0.29,0.30,0.31,0.31,0.32,0.32,0.32,0.33,0.34,0.34,0.35,0.35,0.35,0.36,0.37,0.39,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.38,0.37,0.36,0.36,0.35,0.35,0.35,0.35,0.34,0.33,0.31,0.29,0.26,0.24,0.22,0.21,0.21,0.20,0.20,0.20,0.19,0.18,0.17,0.16,0.15,0.14,0.13,0.13,0.13,0.12,0.12,0.11,0.10,0.10,0.09,0.07,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.22,0.23,0.23,0.23,0.24,0.24,0.24,0.24,0.25,0.25,0.25,0.26,0.26,0.26,0.27,0.27,0.28,0.29,0.30,0.31,0.31,0.31,0.32,0.32,0.33,0.33,0.34,0.35,0.35,0.36,0.36,0.37,0.38,0.39,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.38,0.37,0.36,0.36,0.35,0.35,0.35,0.35,0.34,0.33,0.31,0.29,0.27,0.25,0.23,0.21,0.21,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.15,0.14,0.14,0.13,0.13,0.13,0.12,0.11,0.11,0.10,0.09,0.08,0.06,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.23,0.23,0.24,0.24,0.24,0.24,0.25,0.25,0.25,0.25,0.26,0.26,0.26,0.27,0.27,0.28,0.29,0.29,0.30,0.30,0.30,0.31,0.31,0.32,0.32,0.33,0.34,0.35,0.35,0.35,0.36,0.37,0.38,0.39,0.39,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.38,0.37,0.37,0.36,0.35,0.35,0.35,0.35,0.35,0.34,0.33,0.32,0.30,0.28,0.25,0.23,0.22,0.21,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.16,0.15,0.14,0.13,0.13,0.13,0.13,0.12,0.11,0.11,0.10,0.09,0.07,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.23,0.24,0.24,0.24,0.24,0.24,0.25,0.25,0.25,0.25,0.26,0.26,0.27,0.28,0.28,0.29,0.29,0.29,0.29,0.30,0.30,0.31,0.31,0.31,0.32,0.33,0.34,0.35,0.35,0.35,0.36,0.37,0.38,0.38,0.39,0.39,0.40,0.40,0.40,0.40,0.40,0.39,0.39,0.39,0.39,0.38,0.37,0.36,0.36,0.35,0.35,0.35,0.35,0.35,0.34,0.33,0.32,0.30,0.28,0.26,0.24,0.22,0.21,0.20,0.20,0.20,0.20,0.19,0.19,0.17,0.16,0.15,0.14,0.14,0.13,0.13,0.13,0.12,0.12,0.11,0.10,0.09,0.07,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.24,0.24,0.24,0.25,0.25,0.25,0.25,0.25,0.25,0.26,0.26,0.27,0.27,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.31,0.31,0.32,0.33,0.33,0.34,0.35,0.36,0.36,0.37,0.37,0.38,0.38,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.39,0.38,0.38,0.37,0.36,0.35,0.35,0.35,0.35,0.35,0.35,0.34,0.33,0.32,0.30,0.29,0.26,0.24,0.22,0.20,0.20,0.20,0.20,0.19,0.19,0.19,0.18};
			return value;
		}
		private double[] getElevationGrid_5_18_height_8()
		{
			double[] value = {0.16,0.15,0.14,0.14,0.13,0.13,0.13,0.13,0.12,0.12,0.11,0.10,0.08,0.05,0.04,0.04,0.04,0.04,0.04,0.04,0.24,0.25,0.25,0.25,0.25,0.25,0.25,0.25,0.25,0.26,0.27,0.27,0.28,0.28,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.31,0.31,0.32,0.32,0.33,0.34,0.35,0.36,0.36,0.37,0.37,0.37,0.38,0.38,0.39,0.39,0.39,0.39,0.39,0.39,0.38,0.38,0.38,0.37,0.37,0.36,0.35,0.35,0.35,0.35,0.35,0.34,0.34,0.33,0.32,0.30,0.29,0.27,0.24,0.22,0.20,0.19,0.19,0.19,0.19,0.19,0.19,0.18,0.17,0.16,0.15,0.14,0.13,0.13,0.13,0.13,0.13,0.12,0.11,0.10,0.09,0.06,0.05,0.04,0.04,0.04,0.04,0.04,0.25,0.25,0.25,0.25,0.25,0.25,0.25,0.25,0.26,0.26,0.27,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.31,0.31,0.32,0.33,0.34,0.35,0.35,0.36,0.37,0.37,0.37,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.38,0.37,0.37,0.37,0.36,0.35,0.35,0.35,0.35,0.34,0.34,0.33,0.32,0.31,0.30,0.29,0.27,0.24,0.22,0.20,0.19,0.19,0.19,0.20,0.20,0.19,0.18,0.17,0.16,0.15,0.14,0.14,0.13,0.13,0.13,0.13,0.12,0.11,0.11,0.09,0.07,0.05,0.04,0.04,0.04,0.04,0.04,0.25,0.25,0.26,0.26,0.26,0.26,0.26,0.26,0.27,0.27,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.31,0.31,0.32,0.33,0.34,0.35,0.35,0.36,0.37,0.37,0.37,0.37,0.37,0.37,0.38,0.38,0.38,0.38,0.38,0.38,0.37,0.37,0.37,0.36,0.36,0.35,0.35,0.35,0.34,0.34,0.33,0.32,0.32,0.31,0.30,0.29,0.27,0.25,0.22,0.21,0.19,0.19,0.19,0.20,0.20,0.19,0.19,0.17,0.16,0.15,0.14,0.14,0.14,0.13,0.13,0.13,0.13,0.12,0.11,0.10,0.08,0.05,0.04,0.04,0.04,0.04,0.04,0.25,0.26,0.26,0.26,0.26,0.26,0.27,0.27,0.27,0.28,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.31,0.31,0.32,0.32,0.34,0.34,0.35,0.36,0.36,0.37,0.37,0.37,0.37,0.37,0.38,0.37,0.37,0.38,0.38,0.37,0.37,0.37,0.37,0.36,0.36,0.35,0.35,0.34,0.34,0.33,0.33,0.32,0.31,0.31,0.30,0.28,0.27,0.25,0.23,0.21,0.20,0.20,0.20,0.20,0.20,0.19,0.19,0.18,0.16,0.15,0.14,0.14,0.14,0.13,0.13,0.13,0.13,0.12,0.11,0.10,0.08,0.06,0.04,0.04,0.04,0.04,0.04,0.26,0.26,0.27,0.27,0.27,0.27,0.27,0.27,0.28,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.30,0.31,0.32,0.32,0.33,0.34,0.35,0.36,0.36,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.36,0.35,0.35,0.34,0.33,0.32,0.32,0.31,0.31,0.30,0.29,0.28,0.26,0.25,0.23,0.22,0.21,0.20,0.20,0.20,0.20,0.19,0.19,0.18,0.17,0.15,0.14,0.14,0.14,0.14,0.13,0.13,0.13,0.12,0.11,0.10,0.09,0.06,0.04,0.04,0.04,0.04,0.04,0.26,0.27,0.27,0.28,0.28,0.28,0.28,0.28,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.30,0.31,0.31,0.32,0.33,0.34,0.35,0.35,0.36,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.36,0.36,0.35,0.34,0.33,0.32,0.32,0.31,0.31,0.30,0.29,0.28,0.27,0.26,0.25,0.24,0.23,0.21,0.21,0.21,0.20,0.20,0.20,0.19,0.18,0.17,0.15,0.14,0.14,0.14,0.14,0.13,0.13,0.13,0.12,0.11,0.11,0.09,0.07,0.05,0.04,0.04,0.04,0.04,0.27,0.28,0.28,0.28,0.28,0.28,0.28,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.30,0.31,0.32,0.32,0.33,0.34,0.35,0.36,0.36,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.36,0.35,0.34,0.33,0.33,0.32,0.31,0.31,0.30,0.29,0.29,0.28,0.27,0.26,0.25,0.24,0.23,0.22,0.22,0.21,0.21,0.20,0.20,0.19,0.18,0.17,0.15,0.14,0.14,0.14,0.14,0.13,0.13,0.13,0.12,0.12,0.11,0.09,0.07,0.05,0.04,0.04,0.04,0.04,0.27,0.28,0.29,0.29,0.29,0.28,0.29,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.31,0.31,0.32,0.33,0.34,0.34,0.35,0.36,0.36,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.36,0.35,0.34,0.33,0.32,0.32,0.31,0.31,0.30,0.30,0.29,0.28,0.27,0.26,0.26,0.25,0.25,0.24,0.23,0.23,0.22,0.21,0.20,0.20,0.19,0.18,0.17,0.16,0.14,0.14,0.14,0.14,0.13,0.13,0.13,0.13,0.12,0.11,0.09,0.07,0.05,0.04,0.04,0.04,0.04,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.31,0.31,0.31,0.32,0.33,0.34,0.34,0.35,0.36,0.36,0.36,0.37,0.37,0.37,0.37,0.37,0.37,0.37,0.36,0.36,0.35,0.34,0.33,0.32,0.32,0.31,0.31,0.30,0.30,0.29,0.28,0.28,0.27,0.26,0.26,0.26,0.25,0.25,0.24,0.23,0.22,0.21,0.20,0.20,0.19,0.18,0.17,0.16,0.15,0.14,0.14,0.14,0.13,0.13,0.13,0.13,0.12,0.11,0.10,0.07,0.05,0.04,0.04,0.04,0.04,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.28,0.28,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.31,0.31,0.32,0.32,0.33,0.33,0.34,0.35,0.35,0.36,0.36,0.36,0.36,0.36,0.36,0.36,0.36,0.35,0.35,0.34,0.33,0.32,0.32,0.31,0.31,0.30,0.30,0.29,0.29,0.28,0.27,0.27,0.26,0.26,0.26,0.26,0.25,0.24,0.23,0.22,0.21,0.21,0.20,0.19,0.18,0.17,0.16,0.15,0.14,0.14,0.14,0.14,0.13,0.13,0.13,0.12,0.11,0.10,0.08,0.05,0.04,0.04,0.04,0.04,0.29,0.30,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.28,0.28,0.28,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.31,0.31,0.32,0.32,0.33,0.34,0.34,0.35,0.35,0.35,0.35,0.35,0.35,0.35,0.34,0.34,0.33,0.32,0.32,0.31,0.30,0.30,0.30,0.30,0.30,0.29,0.29,0.28,0.28,0.27,0.27,0.27,0.27,0.27,0.26,0.24,0.23,0.22,0.21,0.21,0.20,0.19,0.19,0.17,0.16,0.15,0.14,0.14,0.14,0.14,0.13,0.13};
			return value;
		}
		private double[] getElevationGrid_5_18_height_9()
		{
			double[] value = {0.13,0.12,0.12,0.10,0.08,0.05,0.04,0.04,0.04,0.04,0.29,0.29,0.30,0.30,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.29,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.31,0.31,0.31,0.32,0.33,0.33,0.33,0.34,0.34,0.34,0.34,0.34,0.34,0.33,0.32,0.32,0.31,0.30,0.30,0.30,0.29,0.30,0.29,0.30,0.29,0.29,0.29,0.28,0.28,0.28,0.27,0.27,0.27,0.26,0.25,0.23,0.22,0.21,0.21,0.20,0.19,0.19,0.18,0.17,0.15,0.14,0.14,0.14,0.14,0.13,0.13,0.13,0.13,0.12,0.11,0.09,0.06,0.05,0.04,0.04,0.05};
			return value;
		}

		/** Large attribute array: ElevationGrid height field, scene-graph level=5, element #18, 8100 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFFloat getElevationGrid_5_18_height()
		{
			MFFloat ElevationGrid_5_18_height = new MFFloat()/*2.finalize*/
				.append(new MFFloat(getElevationGrid_5_18_height_1()))
				.append(new MFFloat(getElevationGrid_5_18_height_2()))
				.append(new MFFloat(getElevationGrid_5_18_height_3()))
				.append(new MFFloat(getElevationGrid_5_18_height_4()))
				.append(new MFFloat(getElevationGrid_5_18_height_5()))
				.append(new MFFloat(getElevationGrid_5_18_height_6()))
				.append(new MFFloat(getElevationGrid_5_18_height_7()))
				.append(new MFFloat(getElevationGrid_5_18_height_8()))
				.append(new MFFloat(getElevationGrid_5_18_height_9()));
			return ElevationGrid_5_18_height;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return Figure14_5ElevationGridTerrain model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new Figure14_5ElevationGridTerrain().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Vrml2Sourcebook.Chapter14ElevationGrid.Figure14_5ElevationGridTerrain\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Vrml2Sourcebook.Chapter14ElevationGrid.Figure14_5ElevationGridTerrain self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Chapter14ElevationGrid/Figure14_5ElevationGridTerrain_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Chapter14ElevationGrid/Figure14_5ElevationGridTerrain_JavaExport.x3d"; 
                String filenameX3DV = "Chapter14ElevationGrid/Figure14_5ElevationGridTerrain_JavaExport.x3dv"; 
                String filenameJSON = "Chapter14ElevationGrid/Figure14_5ElevationGridTerrain_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
