/**
 *<p>
 *	Points, lines and mesh faces allow authors to build a complete variety of geometry.
 *</p>
 *<p>
 *    Complex shapes are hard to build with primitive shapes (for example: terrain, animals, plants, machinery).
 *    Instead, build shapes out of atomic components: points, lines, and polygon faces.
 *    Shape building is like a 3D connect-the-dots game: place dots at 3D locations, and connect-the-dots to form shapes
 *    A coordinate specifies a 3D dot location, measured relative to a coordinate system origin.
 *    A geometry node then specifies how to connect the dots: for example,
 *    PointSet, IndexedLineSet, or IndexedFaceSet.
 *    Animation is accomplished using a CoordinateInterpolator node.
 *</p>
 *
 *<p>
 *       These X3D scenes are adapted directly from the
 *       <a href="http://www.wiley.com/legacy/compbooks/vrml2sbk/toc/ch13.htm" target="Vrml2Sourcebook">original VRML 2.0 Sourcebook chapter examples</a>.
 *       Also available:
 *       <a href="http://www.sdsc.edu/~moreland/courses/Siggraph98/vrml97/slides/mt0175.htm" target="Vrml2SourcebookCourse">Introduction to VRML97 SIGGRAPH98 course notes</a>.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter13PointsLinesFaces" target="_blank">X3D VRML2 Sourcebook Chapter 13 Points Lines Faces</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Vrml2Sourcebook.Chapter13PointsLinesFaces;

