package Vrml2Sourcebook.Chapter09SensingViewer;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.PointingDeviceSensor.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Two shapes that rotate about an axis when the viewer drags them, with coordinate axes superimposed to show X3D/VRML directions. </p>
 <p> Related links: Catalog page <a href="../../../Chapter09SensingViewer/Figure09_7CylinderSensorWithAxesIndex.html" target="_blank">Figure09_7CylinderSensorWithAxes</a>,  source <a href="../../../Chapter09SensingViewer/Figure09_7CylinderSensorWithAxes.java">Figure09_7CylinderSensorWithAxes.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Chapter09SensingViewer/Figure09_7CylinderSensorWithAxes.x3d">Figure09_7CylinderSensorWithAxes.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Figure 9.7, The VRML 2.0 Sourcebook, Copyright [1997] By Andrea L. Ames, David R. Nadeau, and John L. Moreland </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.wiley.com/legacy/compbooks/vrml2sbk/ch09/09fig07.htm" target="_blank">http://www.wiley.com/legacy/compbooks/vrml2sbk/ch09/09fig07.htm</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 12 August 2000 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Two shapes that rotate about an axis when the viewer drags them, with coordinate axes superimposed to show X3D/VRML directions. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter09SensingViewer/Figure09_7CylinderSensorWithAxes.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter09SensingViewer/Figure09_7CylinderSensorWithAxes.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Chapter09SensingViewer/../../license.html">../../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Figure 9.7, The VRML 2.0 Sourcebook, Copyright [1997] By Andrea L. Ames, David R. Nadeau, and John L. Moreland
 */

public class Figure09_7CylinderSensorWithAxes
{
	/** Default constructor to create this object. */
	public Figure09_7CylinderSensorWithAxes ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("Figure09_7CylinderSensorWithAxes.x3d"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Figure 9.7, The VRML 2.0 Sourcebook, Copyright [1997] By Andrea L. Ames, David R. Nadeau, and John L. Moreland"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.wiley.com/legacy/compbooks/vrml2sbk/ch09/09fig07.htm"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("12 August 2000"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Two shapes that rotate about an axis when the viewer drags them, with coordinate axes superimposed to show X3D/VRML directions."))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter09SensingViewer/Figure09_7CylinderSensorWithAxes.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../../license.html")))
  .setScene(new Scene()
    .addComments(" Click and drag to rotate shapes. Superfluous Group nodes removed. ")
    .addComments(" First rotate to reorient the first CylinderSensor ")
    .addChild(new WorldInfo().setTitle("Figure09_7CylinderSensorWithAxes.x3d"))
    .addChild(new Transform().setRotation(1.0,0.0,0.0,1.57).setTranslation(-2.0,0.0,0.0)
      .addChild(new CylinderSensor("FIRST_CYLINDERSENSOR").setDescription("Click and drag to rotate").setMaxAngle(1.57).setMinAngle(-0.78))
      .addChild(new Transform("FIRST_TRANSFORM")
        .addComments(" Note that we are connecting a rotation output to a rotation input in these ROUTEs. ")
        .addChild(new ROUTE().setFromNode("FIRST_CYLINDERSENSOR").setFromField("rotation_changed").setToNode("FIRST_TRANSFORM").setToField("set_rotation"))
        .addComments(" Keep transparent user-interface geometry in this rotated CylinderSensor coordinate frame ")
        .addChild(new Transform("TRANSPARENT_CYLINDER_TRANSFORM")
          .addChild(new Shape()
            .setGeometry(new Cylinder().setHeight(.5))
            .setAppearance(new Appearance()
              .setMaterial(new Material().setDiffuseColor(.7,.7,.7).setTransparency(.5)))))
        .addComments(" Now restore original Y=up coordinate frame prior to drawing actual geometry ")
        .addChild(new Transform().setRotation(1.0,0.0,0.0,-1.57)
          .addChild(new Shape()
            .setGeometry(new Box().setSize(1.0,3.0,1.0))
            .setAppearance(new Appearance("FIRST_APPEARANCE")
              .setMaterial(new Material().setDiffuseColor(.9,.9,.1).setEmissiveColor(.2,.2,.05)))))))
    .addComments(" Note this second example uses a simpler pattern: since we are not rotating the axis of the CylinderSensor away from the vertical, we do not need to change that rotation back again for the target geometry. ")
    .addChild(new Transform("SECOND_TRANSFORM").setTranslation(2.0,0.0,0.0)
      .addChild(new CylinderSensor("SECOND_CYLINDERSENSOR").setDescription("Click and drag to rotate"))
      .addChild(new ROUTE().setFromNode("SECOND_CYLINDERSENSOR").setFromField("rotation_changed").setToNode("SECOND_TRANSFORM").setToField("set_rotation"))
      .addComments(" Keep transparent user-interface geometry in this rotated CylinderSensor coordinate frame ")
      .addChild(new Transform().setUSE("TRANSPARENT_CYLINDER_TRANSFORM"))
      .addComments(" Rotate actual geometry ")
      .addChild(new Transform().setRotation(1.0,0.0,0.0,0.52)
        .addChild(new Shape()
          .setGeometry(new Cone())
          .setAppearance(new Appearance().setUSE("FIRST_APPEARANCE")))))
    .addComments(" Adding this Inline reference to another scene superimposes X3D/VRML coordinate system axes. ")
    .addChild(new Transform().setScale(4.0,4.0,4.0)
      .addChild(new Inline("CoordinateAxes").setUrl(new String[] {"../../X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.x3d","https://www.web3d.org/x3d/content/examples/X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.x3d","https://savage.nps.edu/Savage/Tools/Authoring/CoordinateAxes.x3d","../../X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.wrl","https://www.web3d.org/x3d/content/examples/X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.wrl","https://savage.nps.edu/Savage/Tools/Authoring/CoordinateAxes.wrl"}))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return Figure09_7CylinderSensorWithAxes model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new Figure09_7CylinderSensorWithAxes().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Vrml2Sourcebook.Chapter09SensingViewer.Figure09_7CylinderSensorWithAxes\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Vrml2Sourcebook.Chapter09SensingViewer.Figure09_7CylinderSensorWithAxes self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Chapter09SensingViewer/Figure09_7CylinderSensorWithAxes_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Chapter09SensingViewer/Figure09_7CylinderSensorWithAxes_JavaExport.x3d"; 
                String filenameX3DV = "Chapter09SensingViewer/Figure09_7CylinderSensorWithAxes_JavaExport.x3dv"; 
                String filenameJSON = "Chapter09SensingViewer/Figure09_7CylinderSensorWithAxes_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
