import X3Dpackage


X3D0 = (X3Dpackage.X3D().setProfile("Immersive").setVersion("3.3")
      .setHead(X3Dpackage.head()
        .addMeta(X3Dpackage.meta().setContent("PixelTextureComponentExamples.x3d").setName("title"))
        .addMeta(X3Dpackage.meta().setContent("This example shows the five PixelTexture components, with 0 to 4 components each, shown in Table 5-18.").setName("description"))
        .addMeta(X3Dpackage.meta().setContent("Leonard Daly and Don Brutzman").setName("creator"))
        .addMeta(X3Dpackage.meta().setContent("25 August 2008").setName("created"))
        .addMeta(X3Dpackage.meta().setContent("7 January 2014").setName("modified"))
        .addMeta(X3Dpackage.meta().setContent("http://X3dGraphics.com").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("X3D for Web Authors, Table 5.18").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("http://www.web3d.org/x3d/content/examples/X3dResources.html").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("Copyright (c) 2006, Daly Realism and Don Brutzman").setName("rights"))
        .addMeta(X3Dpackage.meta().setContent("X3D book, X3D graphics, X3D-Edit, http://www.x3dGraphics.com").setName("subject"))
        .addMeta(X3Dpackage.meta().setContent("http://X3dGraphics.com/examples/X3dForWebAuthors/Chapter05AppearanceMaterialTextures/PixelTextureComponentExamples.x3d").setName("identifier"))
        .addMeta(X3Dpackage.meta().setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit").setName("generator"))
        .addMeta(X3Dpackage.meta().setContent("../license.html").setName("license")))
      .setScene(X3Dpackage.Scene()
        .addChildren(X3Dpackage.Background().setSkyColor([0.1,0.1,0.4]))
        .addChildren(X3Dpackage.Viewpoint().setDescription("Table 5.18 SFImage component examples").setPosition([0,0,14]))
        .addChildren(X3Dpackage.Transform().setTranslation([-6,0,0])
          .addChildren(X3Dpackage.Shape()
            .setAppearance(X3Dpackage.Appearance()
              .setTexture(X3Dpackage.PixelTexture().setDEF("ZeroComponents")))
            .setGeometry(X3Dpackage.Box()))
          .addChildren(X3Dpackage.Transform().setTranslation([0,-2,0])
            .addChildren(X3Dpackage.Shape()
              .setGeometry(X3Dpackage.Text().setString(["0"])
                .setFontStyle(X3Dpackage.FontStyle(setJustify = ["MIDDLE","MIDDLE"]).setDEF("CenterJustify")))
              .setAppearance(X3Dpackage.Appearance().setDEF("TextMaterial")
                .setMaterial(X3Dpackage.Material().setDiffuseColor([1,1,1]))))))
        .addChildren(X3Dpackage.Transform().setTranslation([-3,0,0])
          .addChildren(X3Dpackage.Shape()
            .setAppearance(X3Dpackage.Appearance()
              .setTexture(X3Dpackage.PixelTexture().setDEF("OneComponent").setImage([1,2,1,0xFF,0x00])))
            .setGeometry(X3Dpackage.Box()))
          .addChildren(X3Dpackage.Transform().setTranslation([0,-2,0])
            .addChildren(X3Dpackage.Shape()
              .setGeometry(X3Dpackage.Text().setString(["1"])
                .setFontStyle(X3Dpackage.FontStyle().setUSE("CenterJustify")))
              .setAppearance(X3Dpackage.Appearance().setUSE("TextMaterial")))))
        .addChildren(X3Dpackage.Transform()
          .addChildren(X3Dpackage.Shape()
            .setAppearance(X3Dpackage.Appearance()
              .setTexture(X3Dpackage.PixelTexture().setDEF("TwoComponents").setImage([2,1,2,0xCCFF,0x2277])))
            .setGeometry(X3Dpackage.Box()))
          .addChildren(X3Dpackage.Transform().setTranslation([0,-2,0])
            .addChildren(X3Dpackage.Shape()
              .setGeometry(X3Dpackage.Text().setString(["2"])
                .setFontStyle(X3Dpackage.FontStyle().setUSE("CenterJustify")))
              .setAppearance(X3Dpackage.Appearance().setUSE("TextMaterial")))))
        .addChildren(X3Dpackage.Transform().setTranslation([3,0,0])
          .addChildren(X3Dpackage.Shape()
            .setAppearance(X3Dpackage.Appearance()
              # note 0x000000 = 0 

              .setTexture(X3Dpackage.PixelTexture().setDEF("ThreeComponents").setImage([2,4,3,0xFF0000,0xFF00,0x000000,0,0,0,0xFFFFFF,0xFFFF00])))
            .setGeometry(X3Dpackage.Box()))
          .addChildren(X3Dpackage.Transform().setTranslation([0,-2,0])
            .addChildren(X3Dpackage.Shape()
              .setGeometry(X3Dpackage.Text().setString(["3"])
                .setFontStyle(X3Dpackage.FontStyle().setUSE("CenterJustify")))
              .setAppearance(X3Dpackage.Appearance().setUSE("TextMaterial")))))
        .addChildren(X3Dpackage.Transform().setTranslation([6,0,0])
          .addChildren(X3Dpackage.Shape()
            .setAppearance(X3Dpackage.Appearance()
              # Erroneous value in book: 1 0 0 255, 0 1 0 255, 0 0 1 255, 1 0 0 127, 0 1 0 127, 0 0 1 127 

              .setTexture(X3Dpackage.PixelTexture().setDEF("FourComponents").setImage([3,2,4,-16776961,0x00FF00FF,0x0000FFFF,-16777089,0x00FF007F,0x0000FF7F])))
            .setGeometry(X3Dpackage.Box()))
          .addChildren(X3Dpackage.Transform().setTranslation([0,-2,0])
            .addChildren(X3Dpackage.Shape()
              .setGeometry(X3Dpackage.Text().setString(["4"])
                .setFontStyle(X3Dpackage.FontStyle().setUSE("CenterJustify")))
              .setAppearance(X3Dpackage.Appearance().setUSE("TextMaterial")))))
        # Background from PixelTextureBW.x3d 

        .addChildren(X3Dpackage.Transform().setTranslation([0,6,-2])
          .addChildren(X3Dpackage.Shape()
            .setAppearance(X3Dpackage.Appearance()
              .setTexture(X3Dpackage.PixelTexture().setImage([8,8,1,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc])))
            .setGeometry(X3Dpackage.Box(setSize = [16,16,.1]))))))

