from X3Dpackage import *
X3D0 = X3D(profile="Immersive", version="3.3",    head1 = head(    meta2 = meta(content="CameraExamples.x3d", name="title"), 
    meta3 = meta(content="Camera, CameraShot and CameraMove examples that demonstrate storyboard capabilities and precise camera operation. This is a developmental effort for potential X3D Specification improvement.", name="description"), 
    meta4 = meta(content="Two demos are found in the scene, click the \"red text\" on left or right to start. (a) SimpleShotsTest shows Zoom in/out, Pan left/right, Boom up/down, Tilt left/right, with each is defined by a CameraShot collecting a series of CameraMovements. (b) AimPointTest gradually slews the camera view to look at the sliding cube, then follows it around before returning to original viewpoint.", name="documentation"), 
    meta5 = meta(content="Don Brutzman and Jeff Weekley", name="creator"), 
    meta6 = meta(content="18 June 2009", name="created"), 
    meta7 = meta(content="12 January 2014", name="modified"), 
    meta8 = meta(content="Schematron rules, backed up by initialize() checks", name="TODO"), 
    meta9 = meta(content="BeyondViewpointCameraNodesWeb3D2009.pdf", name="reference"), 
    meta10 = meta(content="CameraExamplesDemo.mp4", name="MovingImage"), 
    meta11 = meta(content="http://www.web3d.org/x3d/specifications/ISO-IEC-FDIS-19775-1.2-X3D-AbstractSpecification/Part01/components/navigation.html", name="reference"), 
    meta12 = meta(content="Camera nodes for Viewpoint navigation control", name="subject"), 
    meta13 = meta(content="CameraPrototypes.x3d", name="reference"), 
    meta14 = meta(content="CameraExamplesConsoleLog.txt", name="reference"), 
    meta15 = meta(content="http://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/content/examples/Basic/development/CameraExamples.avi", name="reference"), 
    meta16 = meta(content="http://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.x3d", name="reference"),     # TODO warn if more than one identifier present 

    meta17 = meta(content="http://www.web3d.org/x3d/content/examples/Basic/development/CameraExamples.x3d", name="identifier"), 
    meta18 = meta(content="http://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/content/examples/Basic/development/CameraExamples.x3d", name="identifier"), 
    meta19 = meta(content="X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit", name="generator"), 
    meta20 = meta(content="../license.html", name="license")), 
   Scene21 = Scene(    # =============== Camera ============== 

    ExternProtoDeclare22 = ExternProtoDeclare(appinfo="Camera node provides direct control of scene view to enable cinematic camera animation shot by shot and move by move along with still digital-photography settings for offline rendering of camera images", name="Camera", url=["CameraPrototypes.x3d#Camera","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.x3d#Camera","CameraPrototypes.wrl#Camera","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.wrl#Camera"],      # Viewpoint-related fields, NavigationInfo-related fields and Camera-unique fields 

     field23 = field(accessType="inputOutput", appinfo="Text description to be displayed for this Camera", name="description", type="SFString"), 
     field24 = field(accessType="inputOutput", appinfo="Camera position in local transformation frame, which is default prior to first CameraShot initialPosition getting activated", name="position", type="SFVec3f"), 
     field25 = field(accessType="inputOutput", appinfo="Camera rotation in local transformation frame, which is default prior to first CameraShot initialPosition getting activated", name="orientation", type="SFRotation"), 
     field26 = field(accessType="inputOutput", appinfo="pi/4", name="fieldOfView", type="SFFloat"), 
     field27 = field(accessType="inputOnly", appinfo="input fraction drives interpolators", name="set_fraction", type="SFFloat"), 
     field28 = field(accessType="inputOnly", appinfo="input event binds or unbinds this Camera", name="set_bind", type="SFBool"), 
     field29 = field(accessType="outputOnly", appinfo="output event indicates when this Camera is bound", name="bindTime", type="SFTime"), 
     field30 = field(accessType="outputOnly", appinfo="output event indicates whether this Camera is bound or unbound", name="isBound", type="SFBool"), 
     field31 = field(accessType="inputOutput", appinfo="Vector distance to near clipping plane corresponds to NavigationInfo.avatarSize[0]", name="nearClipPlane", type="SFFloat"), 
     field32 = field(accessType="inputOutput", appinfo="Vector distance to far clipping plane corresponds to NavigationInfo.visibilityLimit", name="farClipPlane", type="SFFloat"), 
     field33 = field(accessType="inputOutput", appinfo="Array of CameraShot nodes which in turn contain CameraMovement nodes", name="shots", type="MFNode"), 
     field34 = field(accessType="inputOutput", appinfo="Whether camera headlight is on or off", name="headlight", type="SFBool"), 
     field35 = field(accessType="inputOutput", appinfo="Camera headlight color", name="headlightColor", type="SFColor"), 
     field36 = field(accessType="inputOutput", appinfo="Camera headlight intensity", name="headlightIntensity", type="SFFloat"), 
     field37 = field(accessType="inputOutput", appinfo="Camera filter color that modifies virtual lens capture", name="filterColor", type="SFColor"), 
     field38 = field(accessType="inputOutput", appinfo="Camera filter transparency that modifies virtual lens capture", name="filterTransparency", type="SFFloat"), 
     field39 = field(accessType="inputOutput", appinfo="upVector changes modify camera orientation (and possibly vice versa)", name="upVector", type="SFVec3f"), 
     field40 = field(accessType="inputOutput", appinfo="Focal length divided effective aperture diameter indicating width of focal plane", name="fStop", type="SFFloat"), 
     field41 = field(accessType="inputOutput", appinfo="Distance to focal plane of sharpest focus", name="focusDistance", type="SFFloat"), 
     field42 = field(accessType="outputOnly", appinfo="Mark start/stop with true/false output respectively useful to trigger external animations", name="isActive", type="SFBool"), 
     field43 = field(accessType="outputOnly", appinfo="Total duration of contained enabled CameraShot (and thus CameraMovement) move durations", name="totalDuration", type="SFTime"), 
     field44 = field(accessType="inputOutput", appinfo="OfflineRender node", name="offlineRender", type="SFNode"), 
     field45 = field(accessType="initializeOnly", appinfo="enable console output to trace script computations and prototype progress", name="traceEnabled", type="SFBool")),     # =============== CameraShot ============== 

    ExternProtoDeclare46 = ExternProtoDeclare(appinfo="CameraShot collects a specific set of CameraMovement animations that make up an individual shot", name="CameraShot", url=["CameraPrototypes.x3d#CameraShot","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.x3d#CameraShot","CameraPrototypes.wrl#CameraShot","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.wrl#CameraShot"],      field47 = field(accessType="inputOutput", appinfo="Text description to be displayed for this CameraShot", name="description", type="SFString"), 
     field48 = field(accessType="inputOutput", appinfo="Whether this CameraShot can be activated", name="enabled", type="SFBool"), 
     field49 = field(accessType="inputOutput", appinfo="Set of CameraMovement nodes", name="moves", type="MFNode",       # initializing CameraMovement nodes are inserted here by scene author using ProtoInstance 
), 
     field50 = field(accessType="inputOutput", appinfo="Setup to reinitialize camera position for this shot", name="initialPosition", type="SFVec3f"), 
     field51 = field(accessType="inputOutput", appinfo="Setup to reinitialize camera rotation for this shot", name="initialOrientation", type="SFRotation"), 
     field52 = field(accessType="inputOutput", appinfo="Setup to reinitialize aimpoint (relative location for camera direction) for this shot", name="initialAimPoint", type="SFVec3f"), 
     field53 = field(accessType="inputOutput", appinfo="pi/4", name="initialFieldOfView", type="SFFloat"), 
     field54 = field(accessType="inputOutput", appinfo="Focal length divided effective aperture diameter indicating width of focal plane", name="initialFStop", type="SFFloat"), 
     field55 = field(accessType="inputOutput", appinfo="Distance to focal plane of sharpest focus", name="initialFocusDistance", type="SFFloat"), 
     field56 = field(accessType="outputOnly", appinfo="Subtotal duration of contained CameraMovement move durations", name="shotDuration", type="SFTime"), 
     field57 = field(accessType="outputOnly", appinfo="Mark start/stop with true/false output respectively useful to trigger external animations", name="isActive", type="SFBool"), 
     field58 = field(accessType="initializeOnly", appinfo="enable console output to trace script computations and prototype progress", name="traceEnabled", type="SFBool")),     # =============== CameraMovement ============== 

    ExternProtoDeclare59 = ExternProtoDeclare(appinfo="CameraMovement defines a single camera movement animation", name="CameraMovement", url=["CameraPrototypes.x3d#CameraMovement","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.x3d#CameraMovement","CameraPrototypes.wrl#CameraMovement","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.wrl#CameraMovement"],      field60 = field(accessType="inputOutput", appinfo="Text description to be displayed for this CameraMovement", name="description", type="SFString"), 
     field61 = field(accessType="inputOutput", appinfo="Whether this CameraMovement can be activated", name="enabled", type="SFBool"), 
     field62 = field(accessType="inputOutput", appinfo="Duration in seconds for this move", name="duration", type="SFFloat"), 
     field63 = field(accessType="inputOutput", appinfo="Goal camera position for this move", name="goalPosition", type="SFVec3f"), 
     field64 = field(accessType="inputOutput", appinfo="Goal camera rotation for this move", name="goalOrientation", type="SFRotation"), 
     field65 = field(accessType="inputOutput", appinfo="Whether or not camera direction is tracking towards the aimPoint", name="tracking", type="SFBool"), 
     field66 = field(accessType="inputOutput", appinfo="Goal aimPoint for this move, ignored if tracking=false", name="goalAimPoint", type="SFVec3f"), 
     field67 = field(accessType="inputOutput", appinfo="Goal fieldOfView for this move", name="goalFieldOfView", type="SFFloat"), 
     field68 = field(accessType="inputOutput", appinfo="Focal length divided effective aperture diameter indicating width of focal plane", name="goalFStop", type="SFFloat"), 
     field69 = field(accessType="inputOutput", appinfo="Distance to focal plane of sharpest focus", name="goalFocusDistance", type="SFFloat"), 
     field70 = field(accessType="outputOnly", appinfo="Mark start/stop with true/false output respectively useful to trigger external animations", name="isActive", type="SFBool"), 
     field71 = field(accessType="initializeOnly", appinfo="enable console output to trace script computations and prototype progress", name="traceEnabled", type="SFBool")),     # =============== OfflineRender ============== 

    ExternProtoDeclare72 = ExternProtoDeclare(appinfo="OfflineRender defines a parameters for offline rendering of Camera animation output to a movie file (or possibly a still shot)", name="OfflineRender", url=["CameraPrototypes.x3d#OfflineRender","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.x3d#OfflineRender","CameraPrototypes.wrl#OfflineRender","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.wrl#OfflineRender"],      # TODO non-photorealistic rendering (NPR) parameters 

     field73 = field(accessType="inputOutput", appinfo="Text description to be displayed for this OfflineRender", name="description", type="SFString"), 
     field74 = field(accessType="inputOutput", appinfo="Whether this OfflineRender can be activated", name="enabled", type="SFBool"), 
     field75 = field(accessType="inputOutput", appinfo="Frames per second recorded for this rendering", name="frameRate", type="SFFloat"), 
     field76 = field(accessType="inputOutput", appinfo="Size of frame in number of pixels width and height", name="frameSize", type="SFVec2f"), 
     field77 = field(accessType="inputOutput", appinfo="Relative dimensions of pixel height/width typically 1.33 or 1", name="pixelAspectRatio", type="SFFloat"), 
     field78 = field(accessType="inputOnly", appinfo="Begin render operation", name="set_startTime", type="SFTime"), 
     field79 = field(accessType="outputOnly", appinfo="Progress performing render operation (0..1)", name="progress", type="SFFloat"), 
     field80 = field(accessType="outputOnly", appinfo="Render operation complete", name="renderCompleteTime", type="SFTime"), 
     field81 = field(accessType="initializeOnly", appinfo="Format of rendered output movie (mpeg mp4 etc.), use first supported format", name="movieFormat", type="MFString"), 
     field82 = field(accessType="initializeOnly", appinfo="Format of rendered output images (png jpeg gif tiff etc.) use first supported format", name="imageFormat", type="MFString"), 
     field83 = field(accessType="initializeOnly", appinfo="enable console output to trace script computations and prototype progress", name="traceEnabled", type="SFBool")),     # =============== Lights, camera, action! ============== 

    DirectionalLight84 = DirectionalLight(direction=[0,-1,0], Global=True, intensity=0.8), 
    NavigationInfo85 = NavigationInfo(type=["EXAMINE","FLY","ANY"]), 
    Viewpoint86 = Viewpoint(description="Camera test scene entry view", position=[0,2,12]), 
    Viewpoint87 = Viewpoint(description="Camera test scene from above", orientation=[1,0,0,-1.57079], position=[0,150,0]),     # Keep prototype instances in same file while developing, then move later 
    # We will create examples matching those in the paper 
    # =============== Camera.SimpleShotsTest ============== 

    ProtoInstance88 = ProtoInstance(DEF="Camera.SimpleShotsTest", name="Camera",      fieldValue89 = fieldValue(name="description", value="SimpleShotsTest for camera Zoom Dolly Pan Boom and Tilt"), 
     fieldValue90 = fieldValue(name="headlight", value="true"), 
     fieldValue91 = fieldValue(name="position", value="-4 4 10"), 
     fieldValue92 = fieldValue(name="shots",       ProtoInstance93 = ProtoInstance(DEF="Zoom", name="CameraShot",        fieldValue94 = fieldValue(name="description", value="Simple shot of Camera Zoom"), 
       fieldValue95 = fieldValue(name="initialPosition", value="-50 1 -10"), 
       fieldValue96 = fieldValue(name="initialOrientation", value="0 1 0 0"), 
       fieldValue97 = fieldValue(name="moves",         ProtoInstance98 = ProtoInstance(name="CameraMovement",          fieldValue99 = fieldValue(name="description", value="Camera Zoom In"), 
         fieldValue100 = fieldValue(name="duration", value="3"), 
         fieldValue101 = fieldValue(name="goalPosition", value="-50 1 -15"), 
         fieldValue102 = fieldValue(name="goalOrientation", value="0 1 0 0")), 
        ProtoInstance103 = ProtoInstance(name="CameraMovement",          fieldValue104 = fieldValue(name="description", value="Camera Zoom Out"), 
         fieldValue105 = fieldValue(name="duration", value="3"), 
         fieldValue106 = fieldValue(name="goalPosition", value="-50 1 -10"), 
         fieldValue107 = fieldValue(name="goalOrientation", value="0 1 0 0")), 
        ProtoInstance108 = ProtoInstance(name="CameraMovement",          fieldValue109 = fieldValue(name="description", value="Camera Pause"), 
         fieldValue110 = fieldValue(name="duration", value="1"), 
         fieldValue111 = fieldValue(name="goalPosition", value="-50 1 -10"), 
         fieldValue112 = fieldValue(name="goalOrientation", value="0 1 0 0")))), 
      ProtoInstance113 = ProtoInstance(DEF="Dolly", name="CameraShot",        fieldValue114 = fieldValue(name="description", value="Simple shot of Camera Dolly"), 
       fieldValue115 = fieldValue(name="initialPosition", value="-40 1 -10"), 
       fieldValue116 = fieldValue(name="initialOrientation", value="0 1 0 0"), 
       fieldValue117 = fieldValue(name="moves",         ProtoInstance118 = ProtoInstance(DEF="DollyMove1", name="CameraMovement",          fieldValue119 = fieldValue(name="description", value="Camera Dolly from Right to Left"), 
         fieldValue120 = fieldValue(name="duration", value="3"), 
         fieldValue121 = fieldValue(name="goalPosition", value="-45 1 -10"), 
         fieldValue122 = fieldValue(name="goalOrientation", value="0 1 0 0")), 
        ProtoInstance123 = ProtoInstance(name="CameraMovement",          fieldValue124 = fieldValue(name="description", value="Camera Dolly from Left to Right"), 
         fieldValue125 = fieldValue(name="duration", value="3"), 
         fieldValue126 = fieldValue(name="goalPosition", value="-40 1 -10"), 
         fieldValue127 = fieldValue(name="goalOrientation", value="0 1 0 0")), 
        ProtoInstance128 = ProtoInstance(name="CameraMovement",          fieldValue129 = fieldValue(name="description", value="Camera Pause"), 
         fieldValue130 = fieldValue(name="duration", value="1"), 
         fieldValue131 = fieldValue(name="goalPosition", value="-40 1 -10"), 
         fieldValue132 = fieldValue(name="goalOrientation", value="0 1 0 0")))), 
      ProtoInstance133 = ProtoInstance(DEF="Pan", name="CameraShot",        fieldValue134 = fieldValue(name="description", value="Simple shot of Camera Pan left right and back to center"), 
       fieldValue135 = fieldValue(name="initialPosition", value="-30 1 -10"), 
       fieldValue136 = fieldValue(name="initialOrientation", value="0 1 0 0"), 
       fieldValue137 = fieldValue(name="moves",         ProtoInstance138 = ProtoInstance(DEF="PanLeft", name="CameraMovement",          fieldValue139 = fieldValue(name="description", value="Pan Left"), 
         fieldValue140 = fieldValue(name="duration", value="2"), 
         fieldValue141 = fieldValue(name="goalPosition", value="-30 1 -10"), 
         fieldValue142 = fieldValue(name="goalOrientation", value="0 1 0 0.4")), 
        ProtoInstance143 = ProtoInstance(DEF="PanRight", name="CameraMovement",          fieldValue144 = fieldValue(name="description", value="Pan Right"), 
         fieldValue145 = fieldValue(name="duration", value="3"), 
         fieldValue146 = fieldValue(name="goalPosition", value="-30 1 -10"), 
         fieldValue147 = fieldValue(name="goalOrientation", value="0 1 0 -0.4")), 
        ProtoInstance148 = ProtoInstance(name="CameraMovement",          fieldValue149 = fieldValue(name="description", value="Camera Pan back to Center"), 
         fieldValue150 = fieldValue(name="duration", value="2"), 
         fieldValue151 = fieldValue(name="goalPosition", value="-30 1 -10"), 
         fieldValue152 = fieldValue(name="goalOrientation", value="0 1 0 0")), 
        ProtoInstance153 = ProtoInstance(name="CameraMovement",          fieldValue154 = fieldValue(name="description", value="Camera Pause"), 
         fieldValue155 = fieldValue(name="duration", value="2"), 
         fieldValue156 = fieldValue(name="goalPosition", value="-30 1 -10"), 
         fieldValue157 = fieldValue(name="goalOrientation", value="0 1 0 0")))), 
      ProtoInstance158 = ProtoInstance(DEF="CameraBoom", name="CameraShot",        fieldValue159 = fieldValue(name="description", value="Camera Boom"), 
       fieldValue160 = fieldValue(name="initialPosition", value="-20 1 -10"), 
       fieldValue161 = fieldValue(name="initialOrientation", value="0 1 0 0"), 
       fieldValue162 = fieldValue(name="moves",         ProtoInstance163 = ProtoInstance(DEF="CameraBoomUp", name="CameraMovement",          fieldValue164 = fieldValue(name="description", value="Camera Boom Up"), 
         fieldValue165 = fieldValue(name="duration", value="3"), 
         fieldValue166 = fieldValue(name="goalPosition", value="-20 5 -10"), 
         fieldValue167 = fieldValue(name="goalOrientation", value="0 1 0 0")), 
        ProtoInstance168 = ProtoInstance(DEF="BoomDown", name="CameraMovement",          fieldValue169 = fieldValue(name="description", value="Camera Boom Down"), 
         fieldValue170 = fieldValue(name="duration", value="3"), 
         fieldValue171 = fieldValue(name="goalPosition", value="-20 1 -10"), 
         fieldValue172 = fieldValue(name="goalOrientation", value="0 1 0 0")), 
        ProtoInstance173 = ProtoInstance(DEF="BoomPause", name="CameraMovement",          fieldValue174 = fieldValue(name="description", value="Camera Pause"), 
         fieldValue175 = fieldValue(name="duration", value="2"), 
         fieldValue176 = fieldValue(name="goalPosition", value="-20 1 -10"), 
         fieldValue177 = fieldValue(name="goalOrientation", value="0 1 0 0")))), 
      ProtoInstance178 = ProtoInstance(DEF="CameraTilt", name="CameraShot",        fieldValue179 = fieldValue(name="description", value="Camera Tilt"), 
       fieldValue180 = fieldValue(name="initialPosition", value="-10 1 -10"), 
       fieldValue181 = fieldValue(name="initialOrientation", value="0 0 1 0"), 
       fieldValue182 = fieldValue(name="traceEnabled", value="true"), 
       fieldValue183 = fieldValue(name="moves",         ProtoInstance184 = ProtoInstance(name="CameraMovement",          fieldValue185 = fieldValue(name="description", value="Camera Tilt Pause"), 
         fieldValue186 = fieldValue(name="duration", value="1"), 
         fieldValue187 = fieldValue(name="goalPosition", value="-10 1 -10"), 
         fieldValue188 = fieldValue(name="goalOrientation", value="0 0 1 0")), 
        ProtoInstance189 = ProtoInstance(DEF="TiltDown", name="CameraMovement",          fieldValue190 = fieldValue(name="description", value="Camera Tilt Left"), 
         fieldValue191 = fieldValue(name="duration", value="3"), 
         fieldValue192 = fieldValue(name="goalPosition", value="-10 1 -10"), 
         fieldValue193 = fieldValue(name="goalOrientation", value="0 0 1 0.785")), 
        ProtoInstance194 = ProtoInstance(DEF="TiltPause", name="CameraMovement",          fieldValue195 = fieldValue(name="description", value="Camera Tilt Pause"), 
         fieldValue196 = fieldValue(name="duration", value="1"), 
         fieldValue197 = fieldValue(name="goalPosition", value="-10 1 -10"), 
         fieldValue198 = fieldValue(name="goalOrientation", value="0 0 1 0.785")), 
        ProtoInstance199 = ProtoInstance(name="CameraMovement",          fieldValue200 = fieldValue(name="description", value="Camera Tilt Right"), 
         fieldValue201 = fieldValue(name="duration", value="3"), 
         fieldValue202 = fieldValue(name="goalPosition", value="-10 1 -10"), 
         fieldValue203 = fieldValue(name="goalOrientation", value="0 0 1 -0.785")), 
        ProtoInstance204 = ProtoInstance(name="CameraMovement",          fieldValue205 = fieldValue(name="description", value="Camera Tilt Pause"), 
         fieldValue206 = fieldValue(name="duration", value="1"), 
         fieldValue207 = fieldValue(name="goalPosition", value="-10 1 -10"), 
         fieldValue208 = fieldValue(name="goalOrientation", value="0 0 1 -0.785")), 
        ProtoInstance209 = ProtoInstance(DEF="TiltReset", name="CameraMovement",          fieldValue210 = fieldValue(name="description", value="Camera Tilt Reset"), 
         fieldValue211 = fieldValue(name="duration", value="1"), 
         fieldValue212 = fieldValue(name="goalPosition", value="-10 1 -10"), 
         fieldValue213 = fieldValue(name="goalOrientation", value="0 0 1 0")), 
        ProtoInstance214 = ProtoInstance(DEF="TiltUp", name="CameraMovement",          fieldValue215 = fieldValue(name="description", value="Return to home"), 
         fieldValue216 = fieldValue(name="duration", value="2"), 
         fieldValue217 = fieldValue(name="goalPosition", value="0 2 12"), 
         fieldValue218 = fieldValue(name="goalOrientation", value="0 0 1 0")))))), 
    Group219 = Group(DEF="AnimationGroup.SimpleShots",      TimeSensor220 = TimeSensor(DEF="CameraTimer.SimpleShots"),      # initialize clock to match totalDuration of combined Shot Moves 

     ROUTE221 = ROUTE(fromField="totalDuration", fromNode="Camera.SimpleShotsTest", toField="cycleInterval", toNode="CameraTimer.SimpleShots"),      # TimeSensor animates the CameraClock since that maintains the computed PositionInterpolator and OrientationInterpolator 

     ROUTE222 = ROUTE(fromField="fraction_changed", fromNode="CameraTimer.SimpleShots", toField="set_fraction", toNode="Camera.SimpleShotsTest"), 
     Transform223 = Transform(DEF="Trigger.SimpleShots", translation=[-4,4,0],       BooleanFilter224 = BooleanFilter(DEF="TextTouchActive.SimpleShotsFilter"), 
      TouchSensor225 = TouchSensor(DEF="TextTouch.SimpleShots", description="touch to animate Camera SimpleShotsTest"), 
      ROUTE226 = ROUTE(fromField="inputTrue", fromNode="TextTouchActive.SimpleShotsFilter", toField="set_bind", toNode="Camera.SimpleShotsTest"), 
      ROUTE227 = ROUTE(fromField="isActive", fromNode="TextTouch.SimpleShots", toField="set_boolean", toNode="TextTouchActive.SimpleShotsFilter"), 
      ROUTE228 = ROUTE(fromField="touchTime", fromNode="TextTouch.SimpleShots", toField="startTime", toNode="CameraTimer.SimpleShots"), 
      Shape229 = Shape(       Text230 = Text(string=["Click to animate","SimpleShotsTest"],         FontStyle231 = FontStyle(justify=["MIDDLE","MIDDLE"])), 
       Appearance232 = Appearance(        Material233 = Material(DEF="ArtDeco5", ambientIntensity=0.24, diffuseColor=[0.945455,0.318988,0.321717], shininess=0.01, specularColor=[0.072727,0.021705,0.010732],          # Universal Media Library: ArtDeco 5 
))),       # Simplify intersection test for user selecting text 

      Shape234 = Shape(DEF="TransparentBox",        Appearance235 = Appearance(        Material236 = Material(transparency=1)), 
       Box237 = Box(size=[6,2,0.0001])))), 
    Group238 = Group(DEF="SimpleShotsTargets",      Transform239 = Transform(DEF="TargetBoxZoom", translation=[-50,1,-20],       Shape240 = Shape(       Box241 = Box(), 
       Appearance242 = Appearance(        Material243 = Material(), 
        ImageTexture244 = ImageTexture(url=["images/CameraMoveZoom.png","http://www.web3d.org/x3d/content/examples/Basic/development/images/CameraMoveZoom.png"]))), 
      Transform245 = Transform(translation=[0,2,0],        Shape246 = Shape(        Text247 = Text(string=["Zoom in, out"],          FontStyle248 = FontStyle(justify=["MIDDLE","MIDDLE"])), 
        Appearance249 = Appearance(         Material250 = Material())))), 
     Transform251 = Transform(DEF="TargetBoxDolly", translation=[-40,1,-20],       Shape252 = Shape(       Box253 = Box(), 
       Appearance254 = Appearance(        Material255 = Material(), 
        ImageTexture256 = ImageTexture(url=["images/CameraMoveDolly.png","http://www.web3d.org/x3d/content/examples/Basic/development/images/CameraMoveDolly.png"]))), 
      Transform257 = Transform(translation=[0,2,0],        Shape258 = Shape(        Text259 = Text(string=["Dolly left, right"],          FontStyle260 = FontStyle(justify=["MIDDLE","MIDDLE"])), 
        Appearance261 = Appearance(         Material262 = Material())))), 
     Transform263 = Transform(DEF="TargetBoxPan", translation=[-30,1,-20],       Shape264 = Shape(       Box265 = Box(), 
       Appearance266 = Appearance(        Material267 = Material(), 
        ImageTexture268 = ImageTexture(url=["images/CameraMovePan.png","http://www.web3d.org/x3d/content/examples/Basic/development/images/CameraMovePan.png"]))), 
      Transform269 = Transform(translation=[0,2,0],        Shape270 = Shape(        Text271 = Text(string=["Pan left, right"],          FontStyle272 = FontStyle(justify=["MIDDLE","MIDDLE"])), 
        Appearance273 = Appearance(         Material274 = Material())))), 
     Transform275 = Transform(DEF="TargetBoxBoom", translation=[-20,1,-20],       Shape276 = Shape(       Box277 = Box(), 
       Appearance278 = Appearance(        Material279 = Material(), 
        ImageTexture280 = ImageTexture(url=["images/CameraMoveBoom.png","http://www.web3d.org/x3d/content/examples/Basic/development/images/CameraMoveBoom.png"]))), 
      Transform281 = Transform(translation=[0,2,0],        Shape282 = Shape(        Text283 = Text(string=["Boom up, down"],          FontStyle284 = FontStyle(justify=["MIDDLE","MIDDLE"])), 
        Appearance285 = Appearance(         Material286 = Material())))), 
     Transform287 = Transform(DEF="TargetBoxTilt", translation=[-10,1,-20],       Shape288 = Shape(       Box289 = Box(), 
       Appearance290 = Appearance(        Material291 = Material(), 
        ImageTexture292 = ImageTexture(url=["images/CameraMoveTilt.png","http://www.web3d.org/x3d/content/examples/Basic/development/images/CameraMoveTilt.png"]))), 
      Transform293 = Transform(translation=[0,2,0],        Shape294 = Shape(        Text295 = Text(string=["Tilt left, right"],          FontStyle296 = FontStyle(justify=["MIDDLE","MIDDLE"])), 
        Appearance297 = Appearance(         Material298 = Material()))))),     # =============== Camera.AimPointTest ============== 

    ProtoInstance299 = ProtoInstance(DEF="Camera.AimPointTest", name="Camera",      fieldValue300 = fieldValue(name="description", value="AimPointTest for moving camera tracking moving target"), 
     fieldValue301 = fieldValue(name="position", value="4 4 10"), 
     fieldValue302 = fieldValue(name="shots",       ProtoInstance303 = ProtoInstance(DEF="Shot5", name="CameraShot",        fieldValue304 = fieldValue(name="description", value="#3 Tracking shot"), 
       fieldValue305 = fieldValue(name="initialPosition", value="6 6 10"), 
       fieldValue306 = fieldValue(name="initialOrientation", value="0 1 0 0"), 
       fieldValue307 = fieldValue(name="moves",         ProtoInstance308 = ProtoInstance(DEF="MoveAimPoint3.1", name="CameraMovement",          fieldValue309 = fieldValue(name="description", value="AimPoint 3.1 moving BoxPath"), 
         fieldValue310 = fieldValue(name="tracking", value="true"), 
         fieldValue311 = fieldValue(name="duration", value="8"), 
         fieldValue312 = fieldValue(name="goalPosition", value="6 6 10"),          # goalAimPoint modified by ROUTE to match moving Box 
), 
        ProtoInstance313 = ProtoInstance(DEF="MoveAimPoint3.2", name="CameraMovement",          fieldValue314 = fieldValue(name="description", value="AimPoint 3.2 pan right while tracking"), 
         fieldValue315 = fieldValue(name="tracking", value="true"), 
         fieldValue316 = fieldValue(name="duration", value="8"), 
         fieldValue317 = fieldValue(name="goalPosition", value="40 6 12"),          # goalAimPoint modified by ROUTE to match moving Box 
), 
        ProtoInstance318 = ProtoInstance(DEF="MoveAimPoint3.3", name="CameraMovement",          fieldValue319 = fieldValue(name="description", value="AimPoint 3.3 boom up while tracking"), 
         fieldValue320 = fieldValue(name="tracking", value="true"), 
         fieldValue321 = fieldValue(name="duration", value="3"), 
         fieldValue322 = fieldValue(name="goalPosition", value="40 20 13"),          # goalAimPoint modified by ROUTE to match moving Box 
), 
        ProtoInstance323 = ProtoInstance(DEF="MoveAimPoint3.4", name="CameraMovement",          fieldValue324 = fieldValue(name="description", value="AimPoint 3.4 restore camera back to home"),          # can test tracking or not using following values 

         fieldValue325 = fieldValue(name="tracking", value="true"), 
         fieldValue326 = fieldValue(name="duration", value="5"), 
         fieldValue327 = fieldValue(name="goalPosition", value="4 4 10"), 
         fieldValue328 = fieldValue(name="goalAimPoint", value="4 4 0"), 
         fieldValue329 = fieldValue(name="goalOrientation", value="0 1 0 0")))))), 
    Group330 = Group(DEF="AnimationGroup.AimPointTest",      TimeSensor331 = TimeSensor(DEF="CameraTimer.AimPointTest"),      # initialize clock to match totalDuration of combined Shot Moves 

     ROUTE332 = ROUTE(fromField="totalDuration", fromNode="Camera.AimPointTest", toField="cycleInterval", toNode="CameraTimer.AimPointTest"),      # TimeSensor animates the CameraClock since that maintains the computed PositionInterpolator and OrientationInterpolator 

     ROUTE333 = ROUTE(fromField="fraction_changed", fromNode="CameraTimer.AimPointTest", toField="set_fraction", toNode="Camera.AimPointTest"), 
     Transform334 = Transform(DEF="Trigger.AimPointTest", translation=[4,4,0],       BooleanFilter335 = BooleanFilter(DEF="TextTouchActive.AimPointFilter"), 
      TouchSensor336 = TouchSensor(DEF="TextTouch.AimPointTest", description="touch to animate Camera AimPointTest"), 
      ROUTE337 = ROUTE(fromField="inputTrue", fromNode="TextTouchActive.AimPointFilter", toField="set_bind", toNode="Camera.AimPointTest"), 
      ROUTE338 = ROUTE(fromField="isActive", fromNode="TextTouch.AimPointTest", toField="set_boolean", toNode="TextTouchActive.AimPointFilter"), 
      ROUTE339 = ROUTE(fromField="touchTime", fromNode="TextTouch.AimPointTest", toField="startTime", toNode="CameraTimer.AimPointTest"), 
      Shape340 = Shape(       Text341 = Text(string=["Click to animate","AimPointTest"],         FontStyle342 = FontStyle(justify=["MIDDLE","MIDDLE"])), 
       Appearance343 = Appearance(        Material344 = Material(USE="ArtDeco5"))), 
      Shape345 = Shape(USE="TransparentBox"))),     # TODO build a test once implemented 

    ProtoInstance346 = ProtoInstance(name="OfflineRender"),     # =============== animate a camera shape to visualize view changes ============== 

    Transform347 = Transform(DEF="CameraShapeTransform", translation=[0,0.5,0],      # move CameraShape using active Camera 

     ROUTE348 = ROUTE(fromField="position_changed", fromNode="Camera.SimpleShotsTest", toField="translation", toNode="CameraShapeTransform"), 
     ROUTE349 = ROUTE(fromField="orientation_changed", fromNode="Camera.SimpleShotsTest", toField="rotation", toNode="CameraShapeTransform"), 
     ROUTE350 = ROUTE(fromField="position", fromNode="Camera.AimPointTest", toField="translation", toNode="CameraShapeTransform"), 
     ROUTE351 = ROUTE(fromField="orientation_changed", fromNode="Camera.AimPointTest", toField="rotation", toNode="CameraShapeTransform"), 
     Transform352 = Transform(DEF="CameraOffsetTransform", translation=[0,0,0.25],       TouchSensor353 = TouchSensor(DEF="CameraShapeTouched"), 
      Inline354 = Inline(DEF="CameraShape", url=["CameraShape.x3d","http://www.web3d.org/x3d/content/examples/Basic/development/CameraShape.x3d"]), 
      Shape355 = Shape(DEF="SightLine",        IndexedLineSet356 = IndexedLineSet(coordIndex=[0,1],         Coordinate357 = Coordinate(point=[0,0,0,0,0,-100])), 
       Appearance358 = Appearance(        Material359 = Material(emissiveColor=[0.8,0.8,0.4])))),      # Display frustum to show camera view within the scene, toggled by user selecting CameraShape 

     ExternProtoDeclare360 = ExternProtoDeclare(appinfo="Display view frustum associated with a given pair of Viewpoint NavigationInfo nodes", name="ViewFrustum", url=["../../X3dForWebAuthors/Chapter14Prototypes/ViewFrustumPrototype.x3d#ViewFrustum","http://X3dGraphics.com/examples/X3dForWebAuthors/Chapter14Prototypes/ViewFrustumPrototype.x3d#ViewFrustum","../../X3dForWebAuthors/Chapter14Prototypes/ViewFrustumPrototype.wrl#ViewFrustum","http://X3dGraphics.com/examples/X3dForWebAuthors/Chapter14Prototypes/ViewFrustumPrototype.wrl#ViewFrustum"],       field361 = field(accessType="initializeOnly", appinfo="required: insert Viewpoint DEF or USE node for view of interest", name="ViewpointNode", type="SFNode"), 
      field362 = field(accessType="initializeOnly", appinfo="required: insert NavigationInfo DEF or USE node of interest", name="NavigationInfoNode", type="SFNode"), 
      field363 = field(accessType="inputOutput", appinfo="whether or not frustum geometry is rendered", name="visible", type="SFBool"), 
      field364 = field(accessType="inputOutput", appinfo="RGB color of ViewFrustum outline, default value 0.9 0.9 0.9", name="lineColor", type="SFColor"), 
      field365 = field(accessType="inputOutput", appinfo="RGB color of ViewFrustum hull geometry, default value 0.8 0.8 0.8", name="frustumColor", type="SFColor"), 
      field366 = field(accessType="inputOutput", appinfo="transparency of ViewFrustum hull geometry, default value 0.5", name="transparency", type="SFFloat"), 
      field367 = field(accessType="inputOutput", appinfo="assumed ratio height/width, default value 0.75", name="aspectRatio", type="SFFloat"), 
      field368 = field(accessType="initializeOnly", appinfo="debug support, default false", name="trace", type="SFBool")), 
     ProtoInstance369 = ProtoInstance(DEF="ViewFrustumNode", name="ViewFrustum",       fieldValue370 = fieldValue(name="ViewpointNode",        Viewpoint371 = Viewpoint(DEF="FrustumViewpoint", description="viewpoint for ViewFrustum", position=[0,0,0])), 
      fieldValue372 = fieldValue(name="NavigationInfoNode",        NavigationInfo373 = NavigationInfo(DEF="TestNavigationInfo", transitionType=["ANIMATE"], visibilityLimit=100)), 
      fieldValue374 = fieldValue(name="visible", value="false"), 
      fieldValue375 = fieldValue(name="lineColor", value="0.9 0.9 0.9"), 
      fieldValue376 = fieldValue(name="frustumColor", value="0.8 0.8 0.8"), 
      fieldValue377 = fieldValue(name="transparency", value="0.95")), 
     BooleanToggle378 = BooleanToggle(DEF="ViewFrustumToggle"), 
     ROUTE379 = ROUTE(fromField="isActive", fromNode="CameraShapeTouched", toField="set_boolean", toNode="ViewFrustumToggle"), 
     ROUTE380 = ROUTE(fromField="toggle", fromNode="ViewFrustumToggle", toField="set_visible", toNode="ViewFrustumNode")),     # =============== add checkerboard, axes and other things to look at while animating ============== 

    Background381 = Background(skyColor=[0.282353,0.380392,0.470588]), 
    Transform382 = Transform(rotation=[1,0,0,-1.57079], scale=[10,10,10],      Shape383 = Shape(      Appearance384 = Appearance(       Material385 = Material(ambientIntensity=0.01, diffuseColor=[1.0,1.0,1.0], shininess=0.05)), 
      IndexedFaceSet386 = IndexedFaceSet(colorIndex=[0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0], colorPerVertex=False, coordIndex=[0,8,9,1,-1,1,9,10,2,-1,2,10,11,3,-1,3,11,12,4,-1,4,12,13,5,-1,5,13,14,6,-1,6,14,15,7,-1,8,16,17,9,-1,9,17,18,10,-1,10,18,19,11,-1,11,19,20,12,-1,12,20,21,13,-1,13,21,22,14,-1,14,22,23,15,-1,16,24,25,17,-1,17,25,26,18,-1,18,26,27,19,-1,19,27,28,20,-1,20,28,29,21,-1,21,29,30,22,-1,22,30,31,23,-1,24,32,33,25,-1,25,33,34,26,-1,26,34,35,27,-1,27,35,36,28,-1,28,36,37,29,-1,29,37,38,30,-1,30,38,39,31,-1,32,40,41,33,-1,33,41,42,34,-1,34,42,43,35,-1,35,43,44,36,-1,36,44,45,37,-1,37,45,46,38,-1,38,46,47,39,-1,40,48,49,41,-1,41,49,50,42,-1,42,50,51,43,-1,43,51,52,44,-1,44,52,53,45,-1,45,53,54,46,-1,46,54,55,47,-1,48,56,57,49,-1,49,57,58,50,-1,50,58,59,51,-1,51,59,60,52,-1,52,60,61,53,-1,53,61,62,54,-1,54,62,63,55,-1], normalPerVertex=False, solid=False,        Coordinate387 = Coordinate(point=[-5.25,5.25,0.0,-3.75,5.25,0.0,-2.25,5.25,0.0,-0.75,5.25,0.0,0.75,5.25,0.0,2.25,5.25,0.0,3.75,5.25,0.0,5.25,5.25,0.0,-5.25,3.75,0.0,-3.75,3.75,0.0,-2.25,3.75,0.0,-0.75,3.75,0.0,0.75,3.75,0.0,2.25,3.75,0.0,3.75,3.75,0.0,5.25,3.75,0.0,-5.25,2.25,0.0,-3.75,2.25,0.0,-2.25,2.25,0.0,-0.75,2.25,0.0,0.75,2.25,0.0,2.25,2.25,0.0,3.75,2.25,0.0,5.25,2.25,0.0,-5.25,0.75,0.0,-3.75,0.75,0.0,-2.25,0.75,0.0,-0.75,0.75,0.0,0.75,0.75,0.0,2.25,0.75,0.0,3.75,0.75,0.0,5.25,0.75,0.0,-5.25,-0.75,0.0,-3.75,-0.75,0.0,-2.25,-0.75,0.0,-0.75,-0.75,0.0,0.75,-0.75,0.0,2.25,-0.75,0.0,3.75,-0.75,0.0,5.25,-0.75,0.0,-5.25,-2.25,0.0,-3.75,-2.25,0.0,-2.25,-2.25,0.0,-0.75,-2.25,0.0,0.75,-2.25,0.0,2.25,-2.25,0.0,3.75,-2.25,0.0,5.25,-2.25,0.0,-5.25,-3.75,0.0,-3.75,-3.75,0.0,-2.25,-3.75,0.0,-0.75,-3.75,0.0,0.75,-3.75,0.0,2.25,-3.75,0.0,3.75,-3.75,0.0,5.25,-3.75,0.0,-5.25,-5.25,0.0,-3.75,-5.25,0.0,-2.25,-5.25,0.0,-0.75,-5.25,0.0,0.75,-5.25,0.0,2.25,-5.25,0.0,3.75,-5.25,0.0,5.25,-5.25,0.0]), 
       Color388 = Color(color=[0.435294,0.741176,0,0,0.560784,0.580392])))), 
    Transform389 = Transform(scale=[3,3,3], translation=[0,0.25,0],      Inline390 = Inline(DEF="CoordinateAxes", url=["../../X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.x3d","../../Savage/Tools/Authoring/CoordinateAxes.x3d","http://X3dGraphics.com/examples/X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.x3d","https://savage.nps.edu/Savage/Tools/Authoring/CoordinateAxes.x3d","../../X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.wrl","../../Savage/Tools/Authoring/CoordinateAxes.wrl","http://X3dGraphics.com/examples/X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.wrl","https://savage.nps.edu/Savage/Tools/Authoring/CoordinateAxes.wrl"])), 
    Transform391 = Transform(DEF="MovingBoxTransform",      PositionInterpolator392 = PositionInterpolator(DEF="BoxPath", key=[0,0.25,0.5,0.75,1], keyValue=[-5,1,5,45,1,5,45,1,-45,-5,1,-45,-5,1,5]), 
     TimeSensor393 = TimeSensor(DEF="BoxTimer", cycleInterval=10, loop=True), 
     ROUTE394 = ROUTE(fromField="value_changed", fromNode="BoxPath", toField="translation", toNode="MovingBoxTransform"), 
     ROUTE395 = ROUTE(fromField="value_changed", fromNode="BoxPath", toField="goalAimPoint", toNode="MoveAimPoint3.1"), 
     ROUTE396 = ROUTE(fromField="value_changed", fromNode="BoxPath", toField="goalAimPoint", toNode="MoveAimPoint3.2"), 
     ROUTE397 = ROUTE(fromField="value_changed", fromNode="BoxPath", toField="goalAimPoint", toNode="MoveAimPoint3.3"), 
     ROUTE398 = ROUTE(fromField="fraction_changed", fromNode="BoxTimer", toField="set_fraction", toNode="BoxPath"), 
     Shape399 = Shape(      Box400 = Box(), 
      Appearance401 = Appearance(       Material402 = Material(), 
       ImageTexture403 = ImageTexture(url=["../earth-topo.png","http://www.web3d.org/x3d/content/examples/Basic/earth-topo.png"])))),     # ================ CrossHair visualization for center of screen ================ 

    ExternProtoDeclare404 = ExternProtoDeclare(appinfo="CrossHair prototype provides a heads-up display (HUD) crosshair at the view center, which is useful for assessing NavigationInfo lookAt point", name="CrossHair", url=["../../Savage/Tools/HeadsUpDisplays/CrossHairPrototype.x3d#CrossHair","https://savage.nps.edu/Savage/Tools/HeadsUpDisplays/CrossHairPrototype.x3d#CrossHair","../../Savage/Tools/HeadsUpDisplays/CrossHairPrototype.wrl#CrossHair","https://savage.nps.edu/Savage/Tools/HeadsUpDisplays/CrossHairPrototype.wrl#CrossHair"],      field405 = field(accessType="initializeOnly", appinfo="whether CrissHair orititype is enabled or not", name="enabled", type="SFBool"), 
     field406 = field(accessType="inputOnly", appinfo="control whether enabled/disabled", name="set_enabled", type="SFBool"), 
     field407 = field(accessType="inputOutput", appinfo="color of CrossHair marker", name="markerColor", type="SFColor"), 
     field408 = field(accessType="inputOutput", appinfo="size of CrossHair in meters", name="scale", type="SFVec3f"), 
     field409 = field(accessType="inputOutput", appinfo="distance in front of HUD viewpoint", name="positionOffsetFromCamera", type="SFVec3f")), 
    ProtoInstance410 = ProtoInstance(DEF="CrossHairInstance", name="CrossHair",      fieldValue411 = fieldValue(name="enabled", value="true"), 
     fieldValue412 = fieldValue(name="markerColor", value="1 0.5 0"), 
     fieldValue413 = fieldValue(name="scale", value="1 1 1"), 
     fieldValue414 = fieldValue(name="positionOffsetFromCamera", value="0 0 -6")),     # turn on CrossHairInstance when animated camera viewpoints are bound 

    ROUTE415 = ROUTE(fromField="isBound", fromNode="Camera.SimpleShotsTest", toField="set_enabled", toNode="CrossHairInstance"), 
    ROUTE416 = ROUTE(fromField="isBound", fromNode="Camera.AimPointTest", toField="set_enabled", toNode="CrossHairInstance"),     # turn off CrossHairInstance when animated camera viewpoints are unbound <BooleanFilter DEF='NegateCrossHair'/> <ROUTE fromField='isBound' fromNode='Camera.SimpleShotsTest' toField='set_boolean' toNode='NegateCrossHair'/> <ROUTE fromField='isBound' fromNode='Camera.AimPointTest' toField='set_boolean' toNode='NegateCrossHair'/> <ROUTE fromField='inputNegate' fromNode='NegateCrossHair' toField='set_enabled' toNode='CrossHairInstance'/> 
    # =============== TODO Launch Prototype Example ============== 

    Anchor417 = Anchor(description="launch CameraExample scene", parameter=["target=_blank"], url=["CameraExample.x3d","http://www.web3d.org/x3d/content/examples/Basic/development/CameraExample.x3d","CameraExample.wrl","http://www.web3d.org/x3d/content/examples/Basic/development/CameraExample.wrl"],      Transform418 = Transform(translation=[0,-3,0],       Shape419 = Shape(       Text420 = Text(string=["CameraPrototype","defines a prototype","","Click on this text to see","CameraExample scene"],         FontStyle421 = FontStyle(justify=["MIDDLE","MIDDLE"], size=0.5)), 
       Appearance422 = Appearance(        Material423 = Material(diffuseColor=[1,1,0.2])))))))
