import X3Dpackage


X3D0 = (X3Dpackage.X3D().setProfile("Immersive").setVersion("3.3")
      .setHead(X3Dpackage.head()
        .addMeta(X3Dpackage.meta().setName("title").setContent("abox.x3d"))
        .addMeta(X3Dpackage.meta().setName("creator").setContent("John Carlson"))
        .addMeta(X3Dpackage.meta().setName("generator").setContent("manual"))
        .addMeta(X3Dpackage.meta().setName("identifier").setContent("https://coderextreme.net/X3DJSONLD/abox.x3d"))
        .addMeta(X3Dpackage.meta().setName("description").setContent("a box")))
      .setScene(X3Dpackage.Scene()
        .addChildren(X3Dpackage.ProtoDeclare().setName("anyShape")
          .setProtoInterface(X3Dpackage.ProtoInterface()
            .addField(X3Dpackage.field().setName("myShape").setAccessType("inputOutput").setType("MFNode")
              .addChildren(X3Dpackage.Shape()
                .setGeometry(X3Dpackage.Sphere()))))
          .setProtoBody(X3Dpackage.ProtoBody()
            .addChildren(X3Dpackage.Transform()
              .setIS(X3Dpackage.IS()
                .addConnect(X3Dpackage.connect().setNodeField("children").setProtoField("myShape"))))))
        .addChildren(X3Dpackage.ProtoDeclare().setName("one")
          .setProtoInterface(X3Dpackage.ProtoInterface()
            .addField(X3Dpackage.field().setName("myShape").setAccessType("inputOutput").setType("MFNode")
              .addChildren(X3Dpackage.Shape()
                .setGeometry(X3Dpackage.Cylinder()))))
          .setProtoBody(X3Dpackage.ProtoBody()
            .addChildren(X3Dpackage.Transform()
              .addChildren(X3Dpackage.ProtoInstance().setName("anyShape")
                .setIS(X3Dpackage.IS()
                  .addConnect(X3Dpackage.connect().setNodeField("myShape").setProtoField("myShape")))))))
        .addChildren(X3Dpackage.ProtoInstance().setName("one")
          .addFieldValue(X3Dpackage.fieldValue().setName("myShape")
            .addChildren(X3Dpackage.Shape()
              .setGeometry(X3Dpackage.Box(setSize = [140,140,140])))))))

