import x3dpsail as x3d


X3D0 = (x3d.X3D().setProfile("Immersive").setVersion("3.3")
      .setHead(x3d.head()
        .addMeta(x3d.meta().setContent("HelloWorld.x3d").setName("title"))
        .addMeta(x3d.meta().setContent("Simple X3D scene example: Hello World!").setName("description"))
        .addMeta(x3d.meta().setContent("30 October 2000").setName("created"))
        .addMeta(x3d.meta().setContent("14 April 2017").setName("modified"))
        .addMeta(x3d.meta().setContent("Don Brutzman").setName("creator"))
        .addMeta(x3d.meta().setContent("HelloWorld.tall.png").setName("Image"))
        .addMeta(x3d.meta().setContent("http://en.wikipedia.org/wiki/Hello_world").setName("reference"))
        .addMeta(x3d.meta().setContent("https://en.wikipedia.org/wiki/Hello#.22Hello.2C_World.22_computer_program").setName("reference"))
        .addMeta(x3d.meta().setContent("https://en.wikipedia.org/wiki/\"Hello,_World!\"_program").setName("reference"))
        .addMeta(x3d.meta().setContent("http://en.wikibooks.org/w/index.php?title=Computer_Programming/Hello_world").setName("reference"))
        .addMeta(x3d.meta().setContent("http://www.HelloWorldExample.net").setName("reference"))
        .addMeta(x3d.meta().setContent("http://www.web3D.org").setName("reference"))
        .addMeta(x3d.meta().setContent("http://www.web3d.org/realtime-3d/news/internationalization-x3d").setName("reference"))
        .addMeta(x3d.meta().setContent("http://www.web3d.org/x3d/content/examples/HelloWorld.x3d").setName("reference"))
        .addMeta(x3d.meta().setContent("http://X3dGraphics.com/examples/X3dForAdvancedModeling/HelloWorldScenes").setName("reference"))
        .addMeta(x3d.meta().setContent("http://X3dGraphics.com/examples/X3dForWebAuthors/Chapter01TechnicalOverview/HelloWorld.x3d").setName("identifier"))
        .addMeta(x3d.meta().setContent("http://www.web3d.org/x3d/content/examples/license.html").setName("license"))
        .addMeta(x3d.meta().setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit").setName("generator"))
        # Alternate encodings: VRML97, X3D ClassicVRML Encoding, X3D Compressed Binary Encoding (CBE), X3DOM, JSON 

        .addMeta(x3d.meta().setContent("HelloWorld.wrl").setName("reference"))
        .addMeta(x3d.meta().setContent("HelloWorld.x3dv").setName("reference"))
        .addMeta(x3d.meta().setContent("HelloWorld.x3db").setName("reference"))
        .addMeta(x3d.meta().setContent("HelloWorld.xhtml").setName("reference"))
        .addMeta(x3d.meta().setContent("HelloWorld.json").setName("reference")))
      .setScene(x3d.Scene()
        # Example scene to illustrate X3D nodes and fields (XML elements and attributes) 

        .addChild(x3d.WorldInfo().setTitle("Hello world!"))
        .addChild(x3d.Group()
          .addChild(x3d.Viewpoint().setDEF("ViewUpClose").setCenterOfRotation([0,-1,0]).setDescription("Hello world!").setPosition([0,-1,7]))
          .addChild(x3d.Transform().setRotation([0,1,0,3])
            .addChild(x3d.Shape()
              .setGeometry(x3d.Sphere())
              .setAppearance(x3d.Appearance()
                .setMaterial(x3d.Material().setDEF("MaterialLightBlue").setDiffuseColor([0.1,0.5,1]))
                .setTexture(x3d.ImageTexture().setDEF("ImageCloudlessEarth").setUrl(["earth-topo.png","earth-topo.jpg","earth-topo-small.gif","http://www.web3d.org/x3d/content/examples/Basic/earth-topo.png","http://www.web3d.org/x3d/content/examples/Basic/earth-topo.jpg","http://www.web3d.org/x3d/content/examples/Basic/earth-topo-small.gif"])))))
          .addChild(x3d.Transform().setTranslation([0,-2,0])
            .addChild(x3d.Shape()
              .setGeometry(x3d.Text().setDEF("TextMessage").setString(["Hello","world!"])
                .setFontStyle(x3d.FontStyle().setJustify(["MIDDLE","MIDDLE"])))
              .setAppearance(x3d.Appearance()
                .setMaterial(x3d.Material().setUSE("MaterialLightBlue"))))))))

X3D0.toFileX3D("examples/HelloWorld_RoundTrip.x3d")
