/*
Web3D Consortium Open-Source License for Models and Software

Copyright (c) 1995-2025 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.Sound;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;

/**
 * StreamAudioSource operates as an audio source whose media is received from a MediaStream obtained using the WebRTC or Media Capture and Streams APIs.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>StreamAudioSource node tooltip</i>: [X3DSoundSourceNode] StreamAudioSource operates as an audio source whose media is received from a MediaStream obtained using the WebRTC or Media Capture and Streams APIs. This media source might originate from a remote microphone or sound-processing channed provided by a remote peer on a WebRTC call.\.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#mediastreamaudiosourcenode" target="_blank">https://www.w3.org/TR/webaudio/#mediastreamaudiosourcenode</a> </li> 
 * </ul>
 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#StreamAudioSource" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#StreamAudioSource" target="blank">X3D Abstract Specification: StreamAudioSource</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#StreamAudioSource" target="_blank">X3D Tooltips: StreamAudioSource</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public interface StreamAudioSource extends  org.web3d.x3d.sai.Sound.X3DSoundSourceNode
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide String enumeration value (baseType SFString) ["MAX" | "CLAMPED_MAX" | "EXPLICIT"] from inputOutput SFString field named <i>channelCountMode</i>.
	 * <br><br>
	 * <i>Tooltip:</i> channelCountMode determines how individual channels are counted when up-mixing and down-mixing connections to any inputs.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#dom-audionode-channelcountmode" target="_blank">https://www.w3.org/TR/webaudio/#dom-audionode-channelcountmode</a> </li> 
 * </ul>
	 * @return value of channelCountMode field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=, $thisClassName=StreamAudioSource, $CamelCaseName=ChannelCountMode, $memberObjectName=channelCountMode, $memberObjectName=channelCountMode)
	public String getChannelCountMode();

	/**
	 * Accessor method to assign String enumeration value ("MAX" | "CLAMPED_MAX" | "EXPLICIT") to inputOutput SFString field named <i>channelCountMode</i>.
	 * <br><br>
	 * <i>Tooltip:</i> channelCountMode determines how individual channels are counted when up-mixing and down-mixing connections to any inputs.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#dom-audionode-channelcountmode" target="_blank">https://www.w3.org/TR/webaudio/#dom-audionode-channelcountmode</a> </li> 
 * </ul>
	 * @param newValue is new value for the channelCountMode field.
	 * @return {@link StreamAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public StreamAudioSource setChannelCountMode(String newValue);

	/**
	 * Provide String enumeration value (baseType SFString) ["SPEAKERS" | "DISCRETE"] from inputOutput SFString field named <i>channelInterpretation</i>.
	 * <br><br>
	 * <i>Tooltip:</i> channelInterpretation determines how individual channels are treated when up-mixing and down-mixing connections to any inputs.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#dom-audionode-channelinterpretation" target="_blank">https://www.w3.org/TR/webaudio/#dom-audionode-channelinterpretation</a> </li> 
 * </ul>
	 * @return value of channelInterpretation field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=, $thisClassName=StreamAudioSource, $CamelCaseName=ChannelInterpretation, $memberObjectName=channelInterpretation, $memberObjectName=channelInterpretation)
	public String getChannelInterpretation();

	/**
	 * Accessor method to assign String enumeration value ("SPEAKERS" | "DISCRETE") to inputOutput SFString field named <i>channelInterpretation</i>.
	 * <br><br>
	 * <i>Tooltip:</i> channelInterpretation determines how individual channels are treated when up-mixing and down-mixing connections to any inputs.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#dom-audionode-channelinterpretation" target="_blank">https://www.w3.org/TR/webaudio/#dom-audionode-channelinterpretation</a> </li> 
 * </ul>
	 * @param newValue is new value for the channelInterpretation field.
	 * @return {@link StreamAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public StreamAudioSource setChannelInterpretation(String newValue);

	/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Author-provided prose that describes intended purpose of the url asset.
 * <ul>
 *  <li> <i> Hint:</i>  many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character). </li> 
 * </ul>
	 * @return value of description field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=, $thisClassName=StreamAudioSource, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)

	public String getDescription();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Author-provided prose that describes intended purpose of the url asset.
 * <ul>
 *  <li> <i> Hint:</i>  many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character). </li> 
 * </ul>
	 * @param newValue is new value for the description field.
	 * @return {@link StreamAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public StreamAudioSource setDescription(String newValue);

	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from outputOnly SFTime field named <i>elapsedTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,+infinity) Current elapsed time since AudioClip activated/running, cumulative in seconds, and not counting any paused time.
 * <ul>
 *  <li> <i>Warning:</i> it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events. </li> 
 *  <li> <i>Hint:</i>  elapsedTime is a nonnegative SFTime duration interval, not an absolute clock time. </li> 
 * </ul>
	 * @return value of elapsedTime field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=, $thisClassName=StreamAudioSource, $CamelCaseName=ElapsedTime, $memberObjectName=elapsedTime, $memberObjectName=elapsedTime)

	public double getElapsedTime();
	/**
	 * Provide boolean value from inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @return value of enabled field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=, $thisClassName=StreamAudioSource, $CamelCaseName=Enabled, $memberObjectName=enabled, $memberObjectName=enabled)

	public boolean getEnabled();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @param newValue is new value for the enabled field.
	 * @return {@link StreamAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public StreamAudioSource setEnabled(boolean newValue);

	/**
	 * Provide float value from inputOutput SFFloat field named <i>gain</i>.
	 * <br><br>
	 * <i>Tooltip:</i> (-infinity,+infinity) The gain field is a factor that represents the amount of linear amplification to apply to the output of the node.
 * <ul>
 *  <li> <i>Warning:</i> Decibel values shall not be used. </li> 
 *  <li> <i>Hint:</i>  Negative gain factors negate the input signal. </li> 
 * </ul>
	 * @return value of gain field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=, $thisClassName=StreamAudioSource, $CamelCaseName=Gain, $memberObjectName=gain, $memberObjectName=gain)

	public float getGain();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>gain</i>.
	 * <br><br>
	 * <i>Tooltip:</i> (-infinity,+infinity) The gain field is a factor that represents the amount of linear amplification to apply to the output of the node.
 * <ul>
 *  <li> <i>Warning:</i> Decibel values shall not be used. </li> 
 *  <li> <i>Hint:</i>  Negative gain factors negate the input signal. </li> 
 * </ul>
	 * @param newValue is new value for the gain field.
	 * @return {@link StreamAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public StreamAudioSource setGain(float newValue);

	/**
	 * Provide boolean value from outputOnly SFBool field named <i>isActive</i>.
	 * <br><br>
	 * <i>Tooltip:</i> isActive true/false events are sent when playback starts/stops.
 * <ul>
 *  <li> <i> Warning:</i>  it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events. </li> 
 * </ul>
	 * @return value of isActive field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=, $thisClassName=StreamAudioSource, $CamelCaseName=IsActive, $memberObjectName=isActive, $memberObjectName=isActive)

	public boolean getIsActive();
	/**
	 * Provide boolean value from outputOnly SFBool field named <i>isPaused</i>.
	 * <br><br>
	 * <i>Tooltip:</i> isPaused true/false events are sent when AudioClip is paused/resumed.
 * <ul>
 *  <li> <i> Warning:</i>  it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events. </li> 
 * </ul>
	 * @return value of isPaused field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=, $thisClassName=StreamAudioSource, $CamelCaseName=IsPaused, $memberObjectName=isPaused, $memberObjectName=isPaused)

	public boolean getIsPaused();
	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=, $thisClassName=StreamAudioSource, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link StreamAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public StreamAudioSource setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide double value in seconds from inputOutput SFTime field named <i>pauseTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i> When time now &amp;gt;= pauseTime, isPaused becomes true and AudioClip becomes paused. Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT.
 * <ul>
 *  <li> <i> Hint:</i>  ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. </li> 
 * </ul>
	 * @return value of pauseTime field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=, $thisClassName=StreamAudioSource, $CamelCaseName=PauseTime, $memberObjectName=pauseTime, $memberObjectName=pauseTime)

	public double getPauseTime();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>pauseTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i> When time now &amp;gt;= pauseTime, isPaused becomes true and AudioClip becomes paused. Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT.
 * <ul>
 *  <li> <i> Hint:</i>  ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. </li> 
 * </ul>
	 * @param newValue is new value for the pauseTime field.
	 * @return {@link StreamAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public StreamAudioSource setPauseTime(double newValue);

	/**
	 * Provide double value in seconds from inputOutput SFTime field named <i>resumeTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i> When resumeTime becomes &amp;lt;= time now, isPaused becomes false and AudioClip becomes active. Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT.
 * <ul>
 *  <li> <i> Hint:</i>  ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. </li> 
 * </ul>
	 * @return value of resumeTime field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=, $thisClassName=StreamAudioSource, $CamelCaseName=ResumeTime, $memberObjectName=resumeTime, $memberObjectName=resumeTime)

	public double getResumeTime();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>resumeTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i> When resumeTime becomes &amp;lt;= time now, isPaused becomes false and AudioClip becomes active. Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT.
 * <ul>
 *  <li> <i> Hint:</i>  ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. </li> 
 * </ul>
	 * @param newValue is new value for the resumeTime field.
	 * @return {@link StreamAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public StreamAudioSource setResumeTime(double newValue);

	/**
	 * Provide double value in seconds from inputOutput SFTime field named <i>startTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT.
 * <ul>
 *  <li> <i> Hint:</i>  ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. </li> 
 * </ul>
	 * @return value of startTime field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=, $thisClassName=StreamAudioSource, $CamelCaseName=StartTime, $memberObjectName=startTime, $memberObjectName=startTime)

	public double getStartTime();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>startTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT.
 * <ul>
 *  <li> <i> Hint:</i>  ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. </li> 
 * </ul>
	 * @param newValue is new value for the startTime field.
	 * @return {@link StreamAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public StreamAudioSource setStartTime(double newValue);

	/**
	 * Provide double value in seconds from inputOutput SFTime field named <i>stopTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT.
 * <ul>
 *  <li> <i>Hint:</i> ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. </li> 
 *  <li> <i>Warning:</i> An active TimeSensor node ignores set_cycleInterval and set_startTime events. </li> 
 *  <li> <i>Warning:</i>  An active TimeSensor node ignores set_stopTime event values less than or equal to startTime. </li> 
 * </ul>
	 * @return value of stopTime field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=, $thisClassName=StreamAudioSource, $CamelCaseName=StopTime, $memberObjectName=stopTime, $memberObjectName=stopTime)

	public double getStopTime();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>stopTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT.
 * <ul>
 *  <li> <i>Hint:</i> ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. </li> 
 *  <li> <i>Warning:</i> An active TimeSensor node ignores set_cycleInterval and set_startTime events. </li> 
 *  <li> <i>Warning:</i>  An active TimeSensor node ignores set_stopTime event values less than or equal to startTime. </li> 
 * </ul>
	 * @param newValue is new value for the stopTime field.
	 * @return {@link StreamAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public StreamAudioSource setStopTime(double newValue);

	/**
	 * Provide String value from inputOutput SFString field named <i>streamIdentifier</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Stream identification TBD
 * <ul>
 *  <li> <i> Hint:</i>  W3C Media Capture and Streams <a href="https://www.w3.org/TR/mediacapture-streams" target="_blank">https://www.w3.org/TR/mediacapture-streams</a> </li> 
 * </ul>
	 * @return value of streamIdentifier field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=, $thisClassName=StreamAudioSource, $CamelCaseName=StreamIdentifier, $memberObjectName=streamIdentifier, $memberObjectName=streamIdentifier)
	public String getStreamIdentifier();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>streamIdentifier</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Stream identification TBD
 * <ul>
 *  <li> <i> Hint:</i>  W3C Media Capture and Streams <a href="https://www.w3.org/TR/mediacapture-streams" target="_blank">https://www.w3.org/TR/mediacapture-streams</a> </li> 
 * </ul>
	 * @param newValue is new value for the streamIdentifier field.
	 * @return {@link StreamAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public StreamAudioSource setStreamIdentifier(String newValue);

}
