/*
Web3D Consortium Open-Source License for Models and Software

Copyright (c) 1995-2025 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.Shaders;
// import org.web3d.x3d.sai.Networking.X3DUrlObject;

import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;
import java.util.Arrays;

/**
 * PackagedShader can contain field declarations, but no CDATA section of plain-text source code.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>PackagedShader node tooltip</i>: (X3D version 3.1 or later) [X3DShaderNode,X3DUrlObject,X3DProgrammableShaderObject] PackagedShader contains a url for a single file that may contain a number of shaders and combined effects.
 * <ul>
 *  <li> <i>Hint:</i> PackagedShader contains field declarations and then corresponding IS/connect statements (if any). </li> 
 *  <li> <i>Warning:</i> PackagedShader does not contain CDATA section of plain-text source code. </li> 
 *  <li> <i>Hint:</i> apply default containerField='shaders' when parent node is Appearance. </li> 
 *  <li> <i>Hint:</i>  when parent node is LoadSensor, apply containerField='children' (X3Dv4) or containerField='watchList' (X3Dv3). <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#PackagedShader" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/shaders.html#PackagedShader" target="blank">X3D Abstract Specification: PackagedShader</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#PackagedShader" target="_blank">X3D Tooltips: PackagedShader</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public interface PackagedShader extends  org.web3d.x3d.sai.Shaders.X3DShaderNode,  org.web3d.x3d.sai.Networking.X3DUrlObject,  org.web3d.x3d.sai.Shaders.X3DProgrammableShaderObject
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness


	/**
	 * Accessor method to assign boolean value to inputOnly SFBool field named <i>activate</i>.
	 * <br><br>
	 * <i>Tooltip:</i> activate forces the shader to activate the contained objects.
 * <ul>
 *  <li> <i> Warning:</i>  it is an error to define this transient inputOnly field in an X3D file, instead only use it a destination for ROUTE events. </li> 
 * </ul>
	 * @param newValue is new value for the activate field.
	 * @return {@link PackagedShader} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PackagedShader setActivate(boolean newValue);

	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>autoRefresh</i>.
	 * <br><br>
	 * <i>Tooltip:</i> autoRefresh defines interval in seconds before automatic reload of current url asset is performed.
 * <ul>
 *  <li> <i>Hint:</i> if preceding file loading fails or load field is false, no refresh is performed. </li> 
 *  <li> <i>Hint:</i> repeated refresh attempts to reload currently loaded entry of url list. If that fails, the browser retries other entries in the url list. </li> 
 *  <li> <i>Warning:</i>  automatically reloading content has security considerations and needs to be considered carefully. </li> 
 * </ul>
	 * @return value of autoRefresh field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DShaderNode, $additionalInheritanceBaseType=X3DUrlObject X3DProgrammableShaderObject, $thisClassName=PackagedShader, $CamelCaseName=AutoRefresh, $memberObjectName=autoRefresh, $memberObjectName=autoRefresh)

	public double getAutoRefresh();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>autoRefresh</i>.
	 * <br><br>
	 * <i>Tooltip:</i> autoRefresh defines interval in seconds before automatic reload of current url asset is performed.
 * <ul>
 *  <li> <i>Hint:</i> if preceding file loading fails or load field is false, no refresh is performed. </li> 
 *  <li> <i>Hint:</i> repeated refresh attempts to reload currently loaded entry of url list. If that fails, the browser retries other entries in the url list. </li> 
 *  <li> <i>Warning:</i>  automatically reloading content has security considerations and needs to be considered carefully. </li> 
 * </ul>
	 * @param newValue is new value for the autoRefresh field.
	 * @return {@link PackagedShader} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PackagedShader setAutoRefresh(double newValue);

	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>autoRefreshTimeLimit</i>.
	 * <br><br>
	 * <i>Tooltip:</i> autoRefreshTimeLimit defines maximum duration that automatic refresh activity can occur.
 * <ul>
 *  <li> <i>Hint:</i> Automatic refresh is different than query and response timeouts performed by a networking library while sequentially attempting to retrieve addressed content from a url list. </li> 
 *  <li> <i>Warning:</i>  automatically reloading content has security considerations and needs to be considered carefully. </li> 
 * </ul>
	 * @return value of autoRefreshTimeLimit field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DShaderNode, $additionalInheritanceBaseType=X3DUrlObject X3DProgrammableShaderObject, $thisClassName=PackagedShader, $CamelCaseName=AutoRefreshTimeLimit, $memberObjectName=autoRefreshTimeLimit, $memberObjectName=autoRefreshTimeLimit)

	public double getAutoRefreshTimeLimit();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>autoRefreshTimeLimit</i>.
	 * <br><br>
	 * <i>Tooltip:</i> autoRefreshTimeLimit defines maximum duration that automatic refresh activity can occur.
 * <ul>
 *  <li> <i>Hint:</i> Automatic refresh is different than query and response timeouts performed by a networking library while sequentially attempting to retrieve addressed content from a url list. </li> 
 *  <li> <i>Warning:</i>  automatically reloading content has security considerations and needs to be considered carefully. </li> 
 * </ul>
	 * @param newValue is new value for the autoRefreshTimeLimit field.
	 * @return {@link PackagedShader} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PackagedShader setAutoRefreshTimeLimit(double newValue);

	/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Author-provided prose that describes intended purpose of the url asset.
 * <ul>
 *  <li> <i> Hint:</i>  many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character). </li> 
 * </ul>
	 * @return value of description field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DShaderNode, $additionalInheritanceBaseType=X3DUrlObject X3DProgrammableShaderObject, $thisClassName=PackagedShader, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)

	public String getDescription();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Author-provided prose that describes intended purpose of the url asset.
 * <ul>
 *  <li> <i> Hint:</i>  many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character). </li> 
 * </ul>
	 * @param newValue is new value for the description field.
	 * @return {@link PackagedShader} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PackagedShader setDescription(String newValue);

	/**
	 * Provide boolean value from outputOnly SFBool field named <i>isSelected</i>.
	 * <br><br>
	 * <i>Tooltip:</i> isSelected indicates this shader instance is selected for use by browser
 * <ul>
 *  <li> <i> Warning:</i>  it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events. </li> 
 * </ul>
	 * @return value of isSelected field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DShaderNode, $additionalInheritanceBaseType=X3DUrlObject X3DProgrammableShaderObject, $thisClassName=PackagedShader, $CamelCaseName=IsSelected, $memberObjectName=isSelected, $memberObjectName=isSelected)

	public boolean getIsSelected();
	/**
	 * Provide boolean value from outputOnly SFBool field named <i>isValid</i>.
	 * <br><br>
	 * <i>Tooltip:</i> isValid indicates whether current shader objects can be run as a shader program.
 * <ul>
 *  <li> <i> Warning:</i>  it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events. </li> 
 * </ul>
	 * @return value of isValid field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DShaderNode, $additionalInheritanceBaseType=X3DUrlObject X3DProgrammableShaderObject, $thisClassName=PackagedShader, $CamelCaseName=IsValid, $memberObjectName=isValid, $memberObjectName=isValid)

	public boolean getIsValid();
	/**
	 * Provide String enumeration value (baseType xs:NMTOKEN) ["Cg" | "GLSL" | "HLSL" | 'etc.'] from initializeOnly SFString field named <i>language</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The language field indicates to the X3D player which shading language is used. The language field may be used to optionally determine the language type if no MIME-type information is available.
 * <ul>
 *  <li> <i> Hint:</i>  recognized values include "Cg" "GLSL" "HLSL". </li> 
 * </ul>
	 * @return value of language field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DShaderNode, $additionalInheritanceBaseType=X3DUrlObject X3DProgrammableShaderObject, $thisClassName=PackagedShader, $CamelCaseName=Language, $memberObjectName=language, $memberObjectName=language)

	public String getLanguage();

	/**
	 * Accessor method to assign String enumeration value ("Cg" | "GLSL" | "HLSL") to initializeOnly SFString field named <i>language</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The language field indicates to the X3D player which shading language is used. The language field may be used to optionally determine the language type if no MIME-type information is available.
 * <ul>
 *  <li> <i> Hint:</i>  recognized values include "Cg" "GLSL" "HLSL". </li> 
 * </ul>
	 * @param newValue is new value for the language field.
	 * @return {@link PackagedShader} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PackagedShader setLanguage(String newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>load</i>.
	 * <br><br>
	 * <i>Tooltip:</i> load=true means load immediately, load=false means defer loading or else unload a previously loaded scene.
 * <ul>
 *  <li> <i>Hint:</i> allows author to design when Inline loading occurs via user interaction, event chains or scripting. </li> 
 *  <li> <i>Hint:</i>  use a separate LoadSensor node to detect when loading is complete. </li> 
 * </ul>
	 * @return value of load field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DShaderNode, $additionalInheritanceBaseType=X3DUrlObject X3DProgrammableShaderObject, $thisClassName=PackagedShader, $CamelCaseName=Load, $memberObjectName=load, $memberObjectName=load)

	public boolean getLoad();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>load</i>.
	 * <br><br>
	 * <i>Tooltip:</i> load=true means load immediately, load=false means defer loading or else unload a previously loaded scene.
 * <ul>
 *  <li> <i>Hint:</i> allows author to design when Inline loading occurs via user interaction, event chains or scripting. </li> 
 *  <li> <i>Hint:</i>  use a separate LoadSensor node to detect when loading is complete. </li> 
 * </ul>
	 * @param newValue is new value for the load field.
	 * @return {@link PackagedShader} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PackagedShader setLoad(boolean newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DShaderNode, $additionalInheritanceBaseType=X3DUrlObject X3DProgrammableShaderObject, $thisClassName=PackagedShader, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link PackagedShader} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PackagedShader setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide array of String results from inputOutput MFString field named <i>url</i>.
	 * <br><br>
	 * <i>Tooltip:</i> url points to a shader source-code file that may contain a number of shaders and combined effects.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Scene Authoring Hints, urls <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls</a> </li> 
 * </ul>
	 * @return value of url field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DShaderNode, $additionalInheritanceBaseType=X3DUrlObject X3DProgrammableShaderObject, $thisClassName=PackagedShader, $CamelCaseName=Url, $memberObjectName=url, $memberObjectName=url)

	public String[] getUrl();

	/**
	 * Accessor method to assign String array to inputOutput MFString field named <i>url</i>.
	 * <br><br>
	 * <i>Tooltip:</i> url points to a shader source-code file that may contain a number of shaders and combined effects.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Scene Authoring Hints, urls <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls</a> </li> 
 * </ul>
	 * @param newValue is new value for the url field.
	 * @return {@link PackagedShader} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PackagedShader setUrl(String[] newValue);

}
