/*
Web3D Consortium Open-Source License for Models and Software

Copyright (c) 1995-2025 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.jsail.Sound;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
import org.web3d.x3d.jsail.fields.*; // making sure #4
// import org.web3d.x3d.jsail.Sound.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
// import org.web3d.x3d.jsail.Sound.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
import java.util.Arrays;

/**
 * WaveShaper node represents a nonlinear distorter that applies a wave-shaping distortion curve to the signal.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>WaveShaper node tooltip</i>: [X3DSoundProcessingNode] WaveShaper node represents a nonlinear distorter that applies a wave-shaping distortion curve to the signal. Non-linear waveshaping distortion is commonly used for both subtle non-linear warming, or more obvious distortion effects. Arbitrary non-linear shaping curves may be specified.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#waveshapernode" target="_blank">https://www.w3.org/TR/webaudio/#waveshapernode</a> </li> 
 * </ul>
 * <br>
 * <i>Package hint:</i>  This org.web3d.x3d.jsail concrete class is used for implementing a standalone X3D object as a <a href="https://en.wikipedia.org/wiki/Plain_old_Java_object" target="_blank">Plain Old Java Object (POJO)</a>.
 * If you are writing Java code for use inside an X3D Script node, compile separate code using only the <i>org.web3d.x3d.sai</i> package instead.
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#WaveShaper" target="blank">X3D Abstract Specification: WaveShaper</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#WaveShaper" target="_blank">X3D Tooltips: WaveShaper</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public class WaveShaper extends org.web3d.x3d.jsail.X3DConcreteNode implements org.web3d.x3d.sai.Sound.WaveShaper
{
    // Member value declarations are encapsulated and private, using preferred Java types for concretes library

    /* @name=channelCount, @type=SFInt32, $javaType=int, $javaReferenceType=int, $javaPrimitiveType=int, $normalizedMemberObjectName=channelCount, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private int channelCount; //  X3D field type: SFInt32

    /* @name=channelCountMode, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=channelCountMode, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String channelCountMode = new String(); //  X3D field type: SFString

    /* @name=channelInterpretation, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=channelInterpretation, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String channelInterpretation = new String(); //  X3D field type: SFString

    /* @name=children, @type=MFNode, $javaType=ArrayList<org.web3d.x3d.sai.Core.X3DNode>, $javaReferenceType=org.web3d.x3d.sai.Core.X3DNode, $javaPrimitiveType=ArrayList<org.web3d.x3d.sai.Core.X3DNode>, $normalizedMemberObjectName=children, $isX3dStatement=false, @acceptableNodeTypes=Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper */ 
    private ArrayList<org.web3d.x3d.sai.Core.X3DNode> children = new ArrayList<>(); //  X3D field type: MFNode acceptable node types: Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper or ProtoInstance

    /* @name=description, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=description, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String description = new String(); //  X3D field type: SFString

    /* @name=elapsedTime, @type=SFTime, $javaType=double, $javaReferenceType=double, $javaPrimitiveType=double, $normalizedMemberObjectName=elapsedTime, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private double elapsedTime; //  X3D field type: SFTime

    /* @name=enabled, @type=SFBool, $javaType=boolean, $javaReferenceType=boolean, $javaPrimitiveType=boolean, $normalizedMemberObjectName=enabled, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private boolean enabled; //  X3D field type: SFBool

    /* @name=gain, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=gain, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float gain; //  X3D field type: SFFloat

    /* @name=IS, @type=SFNode, $javaType=IS, $javaReferenceType=IS, $javaPrimitiveType=IS, $normalizedMemberObjectName=IS, $isX3dStatement=true, @acceptableNodeTypes=IS */ 
    private IS IS; //  X3D field type: SFNode acceptable node types: IS

    /* @name=isActive, @type=SFBool, $javaType=boolean, $javaReferenceType=boolean, $javaPrimitiveType=boolean, $normalizedMemberObjectName=isActive, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private boolean isActive; //  X3D field type: SFBool

    /* @name=isPaused, @type=SFBool, $javaType=boolean, $javaReferenceType=boolean, $javaPrimitiveType=boolean, $normalizedMemberObjectName=isPaused, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private boolean isPaused; //  X3D field type: SFBool

    /* @name=metadata, @type=SFNode, $javaType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaReferenceType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaPrimitiveType= org.web3d.x3d.sai.Core.X3DMetadataObject, $normalizedMemberObjectName=metadata, $isX3dStatement=false, @acceptableNodeTypes=X3DMetadataObject */ 
    private  org.web3d.x3d.sai.Core.X3DMetadataObject metadata; //  X3D field type: SFNode acceptable node types: X3DMetadataObject or ProtoInstance
	private ProtoInstance metadataProtoInstance; // allowed alternative for metadata field

    /* @name=oversample, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=oversample, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String oversample = new String(); //  X3D field type: SFString

    /* @name=pauseTime, @type=SFTime, $javaType=double, $javaReferenceType=double, $javaPrimitiveType=double, $normalizedMemberObjectName=pauseTime, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private double pauseTime; //  X3D field type: SFTime

    /* @name=resumeTime, @type=SFTime, $javaType=double, $javaReferenceType=double, $javaPrimitiveType=double, $normalizedMemberObjectName=resumeTime, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private double resumeTime; //  X3D field type: SFTime

    /* @name=startTime, @type=SFTime, $javaType=double, $javaReferenceType=double, $javaPrimitiveType=double, $normalizedMemberObjectName=startTime, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private double startTime; //  X3D field type: SFTime

    /* @name=stopTime, @type=SFTime, $javaType=double, $javaReferenceType=double, $javaPrimitiveType=double, $normalizedMemberObjectName=stopTime, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private double stopTime; //  X3D field type: SFTime

    /* @name=tailTime, @type=SFTime, $javaType=double, $javaReferenceType=double, $javaPrimitiveType=double, $normalizedMemberObjectName=tailTime, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private double tailTime; //  X3D field type: SFTime

	// ==== String constants for enumeration values ensure correct syntax and avoid run-time errors ====

	/** Reduce excessive warning information for this attribute. */ 
	static boolean channelCountModeWarningAlreadyProvided = false;

	/** 
	 * <i>Tooltip:</i> X3D version of "max" in Web Audio API.
	 * SFString field named <i>channelCountMode</i> with X3DUOM simpleType <i>channelCountModeChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"MAX"</i> (Java syntax) or <i>MAX</i> (XML syntax).
	 * @see #CHANNELCOUNTMODE_MAX_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_channelCountModeChoices.html">XML Schema: channelCountModeChoices</a>
	 * @see  <a href="https://www.w3.org/TR/webaudio/#enumdef-channelcountmode" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-channelcountmode</a>  */
	public static final String CHANNELCOUNTMODE_MAX = "MAX";
	/** SFString SFString enumeration value "<i>MAX</i>" has alias "<i>max</i>"
	 * @see #CHANNELCOUNTMODE_MAX */
	public static final String CHANNELCOUNTMODE_MAX_ALIAS = "max";

	/** 
	 * <i>Tooltip:</i> X3D version of "clamped-max" in Web Audio API.
	 * SFString field named <i>channelCountMode</i> with X3DUOM simpleType <i>channelCountModeChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"CLAMPED_MAX"</i> (Java syntax) or <i>CLAMPED_MAX</i> (XML syntax).
	 * @see #CHANNELCOUNTMODE_CLAMPED_MAX_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_channelCountModeChoices.html">XML Schema: channelCountModeChoices</a>
	 * @see  <a href="https://www.w3.org/TR/webaudio/#enumdef-channelcountmode" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-channelcountmode</a>  */
	public static final String CHANNELCOUNTMODE_CLAMPED_MAX = "CLAMPED_MAX";
	/** SFString SFString enumeration value "<i>CLAMPED_MAX</i>" has alias "<i>clamped-max</i>"
	 * @see #CHANNELCOUNTMODE_CLAMPED_MAX */
	public static final String CHANNELCOUNTMODE_CLAMPED_MAX_ALIAS = "clamped-max";

	/** 
	 * <i>Tooltip:</i> X3D version of "explicit" in Web Audio API.
	 * SFString field named <i>channelCountMode</i> with X3DUOM simpleType <i>channelCountModeChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"EXPLICIT"</i> (Java syntax) or <i>EXPLICIT</i> (XML syntax).
	 * @see #CHANNELCOUNTMODE_EXPLICIT_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_channelCountModeChoices.html">XML Schema: channelCountModeChoices</a>
	 * @see  <a href="https://www.w3.org/TR/webaudio/#enumdef-channelcountmode" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-channelcountmode</a>  */
	public static final String CHANNELCOUNTMODE_EXPLICIT = "EXPLICIT";
	/** SFString SFString enumeration value "<i>EXPLICIT</i>" has alias "<i>explicit</i>"
	 * @see #CHANNELCOUNTMODE_EXPLICIT */
	public static final String CHANNELCOUNTMODE_EXPLICIT_ALIAS = "explicit";

	// special enumeration utility methods

	/** Get alias for this channelCountMode
	 * @param channelCountModeValue of interest
	 * @return alias value, otherwise empty string if not found
	 */
	public static String getChannelCountModeAlias(String channelCountModeValue)
	{
		if      (channelCountModeValue.equalsIgnoreCase(CHANNELCOUNTMODE_MAX)) return CHANNELCOUNTMODE_MAX_ALIAS;
		else if (channelCountModeValue.equalsIgnoreCase(CHANNELCOUNTMODE_CLAMPED_MAX)) return CHANNELCOUNTMODE_CLAMPED_MAX_ALIAS;
		else if (channelCountModeValue.equalsIgnoreCase(CHANNELCOUNTMODE_EXPLICIT)) return CHANNELCOUNTMODE_EXPLICIT_ALIAS;
		else return ""; // not found
	}
	/** Whether a alias exists for this channelCountMode
	 * @param channelCountMode of interest
	 * @return true if found
	 */
	public static boolean hasChannelCountModeAlias(String channelCountMode)
	{
		return !getChannelCountModeAlias(channelCountMode).isEmpty();
	}

	// ==== String constants for enumeration values ensure correct syntax and avoid run-time errors ====

	/** Reduce excessive warning information for this attribute. */ 
	static boolean channelInterpretationWarningAlreadyProvided = false;

	/** 
	 * <i>Tooltip:</i> X3D version of "speakers" in Web Audio API.
	 * SFString field named <i>channelInterpretation</i> with X3DUOM simpleType <i>channelInterpretationChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"SPEAKERS"</i> (Java syntax) or <i>SPEAKERS</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_channelInterpretationChoices.html">XML Schema: channelInterpretationChoices</a>
	 * @see  <a href="https://www.w3.org/TR/webaudio/#enumdef-channelinterpretation" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-channelinterpretation</a>  */
	public static final String CHANNELINTERPRETATION_SPEAKERS = "SPEAKERS";

	/** 
	 * <i>Tooltip:</i> X3D version of "discrete" in Web Audio API.
	 * SFString field named <i>channelInterpretation</i> with X3DUOM simpleType <i>channelInterpretationChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"DISCRETE"</i> (Java syntax) or <i>DISCRETE</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_channelInterpretationChoices.html">XML Schema: channelInterpretationChoices</a>
	 * @see  <a href="https://www.w3.org/TR/webaudio/#enumdef-channelinterpretation" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-channelinterpretation</a>  */
	public static final String CHANNELINTERPRETATION_DISCRETE = "DISCRETE";

	// ==== String constants for enumeration values ensure correct syntax and avoid run-time errors ====

	/** Reduce excessive warning information for this attribute. */ 
	static boolean oversampleWarningAlreadyProvided = false;

	/** 
	 * <i>Tooltip:</i> No oversampling. X3D version of "none" in Web Audio API.
	 * SFString field named <i>oversample</i> with X3DUOM simpleType <i>waveShaperOversampleChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"NONE"</i> (Java syntax) or <i>NONE</i> (XML syntax).
	 * @see #OVERSAMPLE_NONE_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_waveShaperOversampleChoices.html">XML Schema: waveShaperOversampleChoices</a>
	 * @see  <a href="https://www.w3.org/TR/webaudio/#enumdef-oversampletype" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-oversampletype</a>  */
	public static final String OVERSAMPLE_NONE = "NONE";
	/** SFString SFString enumeration value "<i>NONE</i>" has alias "<i>none</i>"
	 * @see #OVERSAMPLE_NONE */
	public static final String OVERSAMPLE_NONE_ALIAS = "none";

	/** 
	 * <i>Tooltip:</i> Double sampling rate. X3D version of "2x" in Web Audio API.
	 * SFString field named <i>oversample</i> with X3DUOM simpleType <i>waveShaperOversampleChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"2X"</i> (Java syntax) or <i>2X</i> (XML syntax).
	 * @see #OVERSAMPLE_2X_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_waveShaperOversampleChoices.html">XML Schema: waveShaperOversampleChoices</a>
	 * @see  <a href="https://www.w3.org/TR/webaudio/#enumdef-oversampletype" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-oversampletype</a>  */
	public static final String OVERSAMPLE_2X = "2X";
	/** SFString SFString enumeration value "<i>2X</i>" has alias "<i>2x</i>"
	 * @see #OVERSAMPLE_2X */
	public static final String OVERSAMPLE_2X_ALIAS = "2x";

	/** 
	 * <i>Tooltip:</i> Quadruple sampling rate. X3D version of "4x" in Web Audio API.
	 * SFString field named <i>oversample</i> with X3DUOM simpleType <i>waveShaperOversampleChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"4X"</i> (Java syntax) or <i>4X</i> (XML syntax).
	 * @see #OVERSAMPLE_4X_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_waveShaperOversampleChoices.html">XML Schema: waveShaperOversampleChoices</a>
	 * @see  <a href="https://www.w3.org/TR/webaudio/#enumdef-oversampletype" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-oversampletype</a>  */
	public static final String OVERSAMPLE_4X = "4X";
	/** SFString SFString enumeration value "<i>4X</i>" has alias "<i>4x</i>"
	 * @see #OVERSAMPLE_4X */
	public static final String OVERSAMPLE_4X_ALIAS = "4x";

	// special enumeration utility methods

	/** Get alias for this oversample
	 * @param oversampleValue of interest
	 * @return alias value, otherwise empty string if not found
	 */
	public static String getOversampleAlias(String oversampleValue)
	{
		if      (oversampleValue.equalsIgnoreCase(OVERSAMPLE_NONE)) return OVERSAMPLE_NONE_ALIAS;
		else if (oversampleValue.equalsIgnoreCase(OVERSAMPLE_2X)) return OVERSAMPLE_2X_ALIAS;
		else if (oversampleValue.equalsIgnoreCase(OVERSAMPLE_4X)) return OVERSAMPLE_4X_ALIAS;
		else return ""; // not found
	}
	/** Whether a alias exists for this oversample
	 * @param oversample of interest
	 * @return true if found
	 */
	public static boolean hasOversampleAlias(String oversample)
	{
		return !getOversampleAlias(oversample).isEmpty();
	}

	// String constants for default field values match X3D Schema definitions

	/** String constant <i>NAME</i> provides name of this element: <i>WaveShaper</i>. */
	@SuppressWarnings("FieldNameHidesFieldInSuperclass")
	public static final String NAME = "WaveShaper";

	/** Provides name of this element: <i>WaveShaper</i>
	 * @return name of this element
	 */
	@Override
	public final String getElementName()
	{
		return NAME;
	}

	/** String constant <i>COMPONENT</i> defines X3D component for the <i>WaveShaper</i> element: <i>Sound</i> */
	public static final String COMPONENT = "Sound";

	/** Defines X3D component for the <i>WaveShaper</i> element: <i>Sound</i>
	 * @return X3D component for this element
	 */
	/* @Override */
	public final String getComponent()
	{
		return COMPONENT;
	}

	/** Integer constant <i>LEVEL</i> provides default X3D <i>Sound</i> component level for this element: <i>2</i> */
	public static final int LEVEL = 2;

	/** Provides default X3D component level for this element: <i>2</i>
	 * @return default X3D component level for this element
	 */
	/* @Override */
	public final int getComponentLevel()
	{
		return LEVEL;
	}

            // DEFAULT_VALUE declarations

	/** SFString field named <i>channelCountMode</i> has default value <i>"MAX"</i> (Java syntax) or <i>MAX</i> (XML syntax). */
	public static final String CHANNELCOUNTMODE_DEFAULT_VALUE = "MAX";

	/** SFString field named <i>channelInterpretation</i> has default value <i>"SPEAKERS"</i> (Java syntax) or <i>SPEAKERS</i> (XML syntax). */
	public static final String CHANNELINTERPRETATION_DEFAULT_VALUE = "SPEAKERS";

	/** SFString field named <i>description</i> has default value equal to an empty string. */
	public static final String DESCRIPTION_DEFAULT_VALUE = "";

	/** SFBool field named <i>enabled</i> has default value <i>true</i> (Java syntax) or <i>true</i> (XML syntax). */
	public static final boolean ENABLED_DEFAULT_VALUE = true;

	/** SFFloat field named <i>gain</i> has default value <i>1f</i> (Java syntax) or <i>1</i> (XML syntax). */
	public static final float GAIN_DEFAULT_VALUE = 1f;

	/** SFNode field named <i>IS</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final IS IS_DEFAULT_VALUE = null;

	/** SFNode field named <i>metadata</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Core.X3DMetadataObject METADATA_DEFAULT_VALUE = null;

	/** SFString field named <i>oversample</i> has default value <i>"NONE"</i> (Java syntax) or <i>NONE</i> (XML syntax). */
	public static final String OVERSAMPLE_DEFAULT_VALUE = "NONE";

	/** SFTime field named <i>pauseTime</i> has default value <i>0</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final double PAUSETIME_DEFAULT_VALUE = 0;

	/** SFTime field named <i>resumeTime</i> has default value <i>0</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final double RESUMETIME_DEFAULT_VALUE = 0;

	/** SFTime field named <i>startTime</i> has default value <i>0</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final double STARTTIME_DEFAULT_VALUE = 0;

	/** SFTime field named <i>stopTime</i> has default value <i>0</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final double STOPTIME_DEFAULT_VALUE = 0;

	/** SFTime field named <i>tailTime</i> has default value <i>0</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final double TAILTIME_DEFAULT_VALUE = 0;

	/** Indicate type corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_TYPE
	 * @return X3D type (SFvec3f etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE if not recognized
	 */
	/* @Override */
	public String getFieldType(String fieldName)
	{
		String result;

		switch (fieldName)
		{
			// String constants for exact field type values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing type-matching checks

			case "containerField":
				result = "SFString";
				break;
			case "channelCount":
				result = "SFInt32";
				break;
			case "channelCountMode":
				result = "SFString";
				break;
			case "channelInterpretation":
				result = "SFString";
				break;
			case "children":
				result = "MFNode";
				break;
			case "description":
				result = "SFString";
				break;
			case "elapsedTime":
				result = "SFTime";
				break;
			case "enabled":
				result = "SFBool";
				break;
			case "gain":
				result = "SFFloat";
				break;
			case "IS":
				result = "SFNode";
				break;
			case "isActive":
				result = "SFBool";
				break;
			case "isPaused":
				result = "SFBool";
				break;
			case "metadata":
				result = "SFNode";
				break;
			case "oversample":
				result = "SFString";
				break;
			case "pauseTime":
				result = "SFTime";
				break;
			case "resumeTime":
				result = "SFTime";
				break;
			case "startTime":
				result = "SFTime";
				break;
			case "stopTime":
				result = "SFTime";
				break;
			case "tailTime":
				result = "SFTime";
				break;
			case "DEF":
				result = "SFString";
				break;
			case "USE":
				result = "SFString";
				break;
			case "class":
				result = "SFString";
				break;
			case "id":
				result = "SFString";
				break;
			case "style":
				result = "SFString";
				break;
			default:
			{
				// if fieldName has a prefix "set_" prepended (or a suffix "_changed" appended) then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getFieldType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/** Indicate accessType corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_ACCESSTYPE
	 * @return X3D accessType (inputOnly etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE if not recognized
	 */
	/* @Override */
	public String getAccessType(String fieldName)
	{
		String result; // set by following checks
		switch (fieldName)
		{
			// String constants for field accessType values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing accessType-matching checks
			case "channelCount":
				result = "outputOnly";
				break;
			case "channelCountMode":
				result = "inputOutput";
				break;
			case "channelInterpretation":
				result = "inputOutput";
				break;
			case "children":
				result = "inputOutput";
				break;
			case "description":
				result = "inputOutput";
				break;
			case "elapsedTime":
				result = "outputOnly";
				break;
			case "enabled":
				result = "inputOutput";
				break;
			case "gain":
				result = "inputOutput";
				break;
			case "IS":
				result = "inputOutput";
				break;
			case "isActive":
				result = "outputOnly";
				break;
			case "isPaused":
				result = "outputOnly";
				break;
			case "metadata":
				result = "inputOutput";
				break;
			case "oversample":
				result = "inputOutput";
				break;
			case "pauseTime":
				result = "inputOutput";
				break;
			case "resumeTime":
				result = "inputOutput";
				break;
			case "startTime":
				result = "inputOutput";
				break;
			case "stopTime":
				result = "inputOutput";
				break;
			case "tailTime":
				result = "inputOutput";
				break;
			case "DEF":
				result = "inputOutput";
				break;
			case "USE":
				result = "inputOutput";
				break;
			case "class":
				result = "inputOutput";
				break;
			case "id":
				result = "inputOutput";
				break;
			case "style":
				result = "inputOutput";
				break;
			default:
			{
				// if user has added a prefix "set_" or suffix "_changed" then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getAccessType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/**
         * containerField describes typical field relationship of a node to its parent.
	 * Usage is not ordinarily needed when using this API, this default value is provided for informational purposes only.
         * <br />
         * containerField_DEFAULT_VALUE = "children";
         * <br />
         * containerField_ALLOWED_VALUES = {"children" };  type X3DUOM containerFieldChoicesAudioGraph
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField" target="_blank">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerFieldChoices" target="_blank">X3D Scene Authoring Hints: validation choices for containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html" target="_blank">X3D Unified Object Model (X3DUOM)</a>
	 */

	public static final String containerField_DEFAULT_VALUE = "children"; // type containerFieldChoicesAudioGraph
	/**
         * containerField describes typical field relationship of a node to its parent.
	 * Programmer usage is not ordinarily needed when using this API, since this default value is provided for informational purposes only.
	 * @see #containerField_DEFAULT_VALUE
         * @see org.web3d.x3d.jsail.X3DConcreteNode#containerField_ALLOWED_VALUES
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField" target="_blank">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerFieldChoices" target="_blank">X3D Scene Authoring Hints: validation choices for containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html" target="_blank">X3D Unified Object Model (X3DUOM)</a>
         * @return default containerField value
	 */
        @Override
        public final String getContainerFieldDefault()
        {
            return containerField_DEFAULT_VALUE;
        }

	// String constants for field names usable in ROUTE statements

	/** fromField ROUTE name for SFInt32 field named <i>channelCount</i>. */
	public static final String fromField_CHANNELCOUNT = "channelCount";

	/** fromField ROUTE name for SFString field named <i>channelCountMode</i>. */
	public static final String fromField_CHANNELCOUNTMODE = "channelCountMode";

	/** toField ROUTE name for SFString field named <i>channelCountMode</i>. */
	public static final String toField_CHANNELCOUNTMODE = "channelCountMode";

	/** fromField ROUTE name for SFString field named <i>channelInterpretation</i>. */
	public static final String fromField_CHANNELINTERPRETATION = "channelInterpretation";

	/** toField ROUTE name for SFString field named <i>channelInterpretation</i>. */
	public static final String toField_CHANNELINTERPRETATION = "channelInterpretation";

	/** fromField ROUTE name for MFNode field named <i>children</i>. */
	public static final String fromField_CHILDREN = "children";

	/** toField ROUTE name for MFNode field named <i>children</i>. */
	public static final String toField_CHILDREN = "children";

	/** fromField ROUTE name for SFString field named <i>description</i>. */
	public static final String fromField_DESCRIPTION = "description";

	/** toField ROUTE name for SFString field named <i>description</i>. */
	public static final String toField_DESCRIPTION = "description";

	/** fromField ROUTE name for SFTime field named <i>elapsedTime</i>. */
	public static final String fromField_ELAPSEDTIME = "elapsedTime";

	/** fromField ROUTE name for SFBool field named <i>enabled</i>. */
	public static final String fromField_ENABLED = "enabled";

	/** toField ROUTE name for SFBool field named <i>enabled</i>. */
	public static final String toField_ENABLED = "enabled";

	/** fromField ROUTE name for SFFloat field named <i>gain</i>. */
	public static final String fromField_GAIN = "gain";

	/** toField ROUTE name for SFFloat field named <i>gain</i>. */
	public static final String toField_GAIN = "gain";

	/** fromField ROUTE name for SFNode field named <i>IS</i>. */
	public static final String fromField_IS = "IS";

	/** fromField ROUTE name for SFBool field named <i>isActive</i>. */
	public static final String fromField_ISACTIVE = "isActive";

	/** fromField ROUTE name for SFBool field named <i>isPaused</i>. */
	public static final String fromField_ISPAUSED = "isPaused";

	/** fromField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String fromField_METADATA = "metadata";

	/** toField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String toField_METADATA = "metadata";

	/** fromField ROUTE name for SFString field named <i>oversample</i>. */
	public static final String fromField_OVERSAMPLE = "oversample";

	/** toField ROUTE name for SFString field named <i>oversample</i>. */
	public static final String toField_OVERSAMPLE = "oversample";

	/** fromField ROUTE name for SFTime field named <i>pauseTime</i>. */
	public static final String fromField_PAUSETIME = "pauseTime";

	/** toField ROUTE name for SFTime field named <i>pauseTime</i>. */
	public static final String toField_PAUSETIME = "pauseTime";

	/** fromField ROUTE name for SFTime field named <i>resumeTime</i>. */
	public static final String fromField_RESUMETIME = "resumeTime";

	/** toField ROUTE name for SFTime field named <i>resumeTime</i>. */
	public static final String toField_RESUMETIME = "resumeTime";

	/** fromField ROUTE name for SFTime field named <i>startTime</i>. */
	public static final String fromField_STARTTIME = "startTime";

	/** toField ROUTE name for SFTime field named <i>startTime</i>. */
	public static final String toField_STARTTIME = "startTime";

	/** fromField ROUTE name for SFTime field named <i>stopTime</i>. */
	public static final String fromField_STOPTIME = "stopTime";

	/** toField ROUTE name for SFTime field named <i>stopTime</i>. */
	public static final String toField_STOPTIME = "stopTime";

	/** fromField ROUTE name for SFTime field named <i>tailTime</i>. */
	public static final String fromField_TAILTIME = "tailTime";

	/** toField ROUTE name for SFTime field named <i>tailTime</i>. */
	public static final String toField_TAILTIME = "tailTime";

	/** Constructor for WaveShaper to initialize member variables with default values. */
	public WaveShaper()
	{
		super(); // constructor invocation and corresponding initialize()
		initialize();
	}

	/** Initialize all member variables to default values. */
	@Override
	public final void initialize()
	{
		super.initialize();

        setContainerFieldOverride(""); // ensuring default value used
	containerField_ALLOWED_VALUES = new String[] { "children" }; // type X3DUOM containerFieldChoicesAudioGraph

		channelCountMode = CHANNELCOUNTMODE_DEFAULT_VALUE;
		channelInterpretation = CHANNELINTERPRETATION_DEFAULT_VALUE;
		children = new ArrayList<>();
		description = DESCRIPTION_DEFAULT_VALUE;
		enabled = ENABLED_DEFAULT_VALUE;
		gain = GAIN_DEFAULT_VALUE;
		IS = null; // clear out any prior node
		metadata = null;              // clear out any prior node
		metadataProtoInstance = null; // clear out any prior node
		oversample = OVERSAMPLE_DEFAULT_VALUE;
		pauseTime = PAUSETIME_DEFAULT_VALUE;
		resumeTime = RESUMETIME_DEFAULT_VALUE;
		startTime = STARTTIME_DEFAULT_VALUE;
		stopTime = STOPTIME_DEFAULT_VALUE;
		tailTime = TAILTIME_DEFAULT_VALUE;
	}

	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide int value from outputOnly SFInt32 field named <i>channelCount</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,+infinity) channelCount reports number of channels provided by input nodes.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#dom-audionode-channelcount" target="_blank">https://www.w3.org/TR/webaudio/#dom-audionode-channelcount</a> </li> 
 * </ul>
	 * @return value of channelCount field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=ChannelCount, $memberObjectName=channelCount, $memberObjectName=channelCount)

	public int getChannelCount()
	{
		return channelCount;
	}
	/**
	 * Provide String enumeration value (baseType SFString) ["MAX" | "CLAMPED_MAX" | "EXPLICIT"] from inputOutput SFString field named <i>channelCountMode</i>.
	 * <br><br>
	 * <i>Tooltip:</i> channelCountMode determines how individual channels are counted when up-mixing and down-mixing connections to any inputs.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#dom-audionode-channelcountmode" target="_blank">https://www.w3.org/TR/webaudio/#dom-audionode-channelcountmode</a> </li> 
 * </ul>
	 * <br><br>
	 * Available enumeration values for string comparison: {@link #CHANNELCOUNTMODE_MAX MAX}, {@link #CHANNELCOUNTMODE_CLAMPED_MAX CLAMPED_MAX}, {@link #CHANNELCOUNTMODE_EXPLICIT EXPLICIT}.
	 * @return value of channelCountMode field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=ChannelCountMode, $memberObjectName=channelCountMode, $memberObjectName=channelCountMode)

	public String getChannelCountMode()
	{
		return channelCountMode;
	}

	/**
	 * Accessor method to assign String enumeration value ("MAX" | "CLAMPED_MAX" | "EXPLICIT") to inputOutput SFString field named <i>channelCountMode</i>.
	 * <br><br>
	 * <i>Warning:</i> authors can only choose from a strict list of enumeration values ({@link #CHANNELCOUNTMODE_MAX MAX}, {@link #CHANNELCOUNTMODE_CLAMPED_MAX CLAMPED_MAX}, {@link #CHANNELCOUNTMODE_EXPLICIT EXPLICIT}).
	 * <br><br>
	 * <i>Tooltip:</i> channelCountMode determines how individual channels are counted when up-mixing and down-mixing connections to any inputs.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#dom-audionode-channelcountmode" target="_blank">https://www.w3.org/TR/webaudio/#dom-audionode-channelcountmode</a> </li> 
 * </ul>
	 * @param newValue is new value for the channelCountMode field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public WaveShaper setChannelCountMode(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
		{
                    newValue = new String(); // null string check
		}
		newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue); // handle potential enumeration value
                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.isEmpty() ||
			newValue.toString().replace("\"","").equals(CHANNELCOUNTMODE_MAX) ||
			newValue.toString().replace("\"","").equals(CHANNELCOUNTMODE_CLAMPED_MAX) ||
			newValue.toString().replace("\"","").equals(CHANNELCOUNTMODE_EXPLICIT)))
		{
			String warningMessage = "[warning] WaveShaper channelCountMode newValue='" + newValue + "' includes an unrecognized optional value not matching any of the required enumeration string tokens.";
			if (!channelCountModeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "       Supported values are MAX, CLAMPED_MAX, EXPLICIT";
			    channelCountModeWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);

            if (!newValue.isEmpty()) // @additionalEnumerationValuesAllowed='false'
            {
                throw new org.web3d.x3d.sai.InvalidFieldValueException(warningMessage);
            }
		}
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		channelCountMode = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString channelCountMode field, similar to {@link #setChannelCountMode(String)}.
	 * @param newValue is new value for the channelCountMode field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setChannelCountMode(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setChannelCountMode(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String enumeration value (baseType SFString) ["SPEAKERS" | "DISCRETE"] from inputOutput SFString field named <i>channelInterpretation</i>.
	 * <br><br>
	 * <i>Tooltip:</i> channelInterpretation determines how individual channels are treated when up-mixing and down-mixing connections to any inputs.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#dom-audionode-channelinterpretation" target="_blank">https://www.w3.org/TR/webaudio/#dom-audionode-channelinterpretation</a> </li> 
 * </ul>
	 * <br><br>
	 * Available enumeration values for string comparison: {@link #CHANNELINTERPRETATION_SPEAKERS SPEAKERS}, {@link #CHANNELINTERPRETATION_DISCRETE DISCRETE}.
	 * @return value of channelInterpretation field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=ChannelInterpretation, $memberObjectName=channelInterpretation, $memberObjectName=channelInterpretation)

	public String getChannelInterpretation()
	{
		return channelInterpretation;
	}

	/**
	 * Accessor method to assign String enumeration value ("SPEAKERS" | "DISCRETE") to inputOutput SFString field named <i>channelInterpretation</i>.
	 * <br><br>
	 * <i>Warning:</i> authors can only choose from a strict list of enumeration values ({@link #CHANNELINTERPRETATION_SPEAKERS SPEAKERS}, {@link #CHANNELINTERPRETATION_DISCRETE DISCRETE}).
	 * <br><br>
	 * <i>Tooltip:</i> channelInterpretation determines how individual channels are treated when up-mixing and down-mixing connections to any inputs.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#dom-audionode-channelinterpretation" target="_blank">https://www.w3.org/TR/webaudio/#dom-audionode-channelinterpretation</a> </li> 
 * </ul>
	 * @param newValue is new value for the channelInterpretation field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public WaveShaper setChannelInterpretation(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
		{
                    newValue = new String(); // null string check
		}
		newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue); // handle potential enumeration value
                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.isEmpty() ||
			newValue.toString().replace("\"","").equals(CHANNELINTERPRETATION_SPEAKERS) ||
			newValue.toString().replace("\"","").equals(CHANNELINTERPRETATION_DISCRETE)))
		{
			String warningMessage = "[warning] WaveShaper channelInterpretation newValue='" + newValue + "' includes an unrecognized optional value not matching any of the required enumeration string tokens.";
			if (!channelInterpretationWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "       Supported values are SPEAKERS, DISCRETE";
			    channelInterpretationWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);

            if (!newValue.isEmpty()) // @additionalEnumerationValuesAllowed='false'
            {
                throw new org.web3d.x3d.sai.InvalidFieldValueException(warningMessage);
            }
		}
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		channelInterpretation = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString channelInterpretation field, similar to {@link #setChannelInterpretation(String)}.
	 * @param newValue is new value for the channelInterpretation field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setChannelInterpretation(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setChannelInterpretation(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide array of org.web3d.x3d.sai.Core.X3DNode results (using an array consisting of properly typed nodes or ProtoInstances) with acceptable node types limited to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper, from inputOutput MFNode field <i>children</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSoundChannelNode|X3DSoundProcessingNode|X3DSoundSourceNode] The children field specifies audio-graph sound sources providing input signals for this node. If multiple input signals are provided by the inputs children field, all channels are mixed together and merged prior to presentation.
 * <ul>
 *  <li> <i>Warning:</i> contained AudioClip or MovieTexture nodes must have containerField='children' to override otherwise-incorrect defaults. </li> 
 *  <li> <i>Hint:</i>  can be original (DEF) or referenced (USE) nodes. </li> 
 * </ul>
	 * <br><br>
	 * <i>Warning:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper.
	 * @see org.web3d.x3d.jsail.Sound.Analyser
	 * @see org.web3d.x3d.jsail.Sound.AudioClip
	 * @see org.web3d.x3d.jsail.Sound.AudioDestination
	 * @see org.web3d.x3d.jsail.Sound.BiquadFilter
	 * @see org.web3d.x3d.jsail.Sound.BufferAudioSource
	 * @see org.web3d.x3d.jsail.Sound.ChannelMerger
	 * @see org.web3d.x3d.jsail.Sound.ChannelSelector
	 * @see org.web3d.x3d.jsail.Sound.ChannelSplitter
	 * @see org.web3d.x3d.jsail.Sound.Convolver
	 * @see org.web3d.x3d.jsail.Sound.Delay
	 * @see org.web3d.x3d.jsail.Sound.DynamicsCompressor
	 * @see org.web3d.x3d.jsail.Sound.Gain
	 * @see org.web3d.x3d.jsail.Sound.ListenerPointSource
	 * @see org.web3d.x3d.jsail.Sound.MicrophoneSource
	 * @see org.web3d.x3d.jsail.Texturing.MovieTexture
	 * @see org.web3d.x3d.jsail.Sound.OscillatorSource
	 * @see org.web3d.x3d.jsail.Sound.Sound
	 * @see org.web3d.x3d.jsail.Sound.SpatialSound
	 * @see org.web3d.x3d.jsail.Sound.StreamAudioDestination
	 * @see org.web3d.x3d.jsail.Sound.StreamAudioSource
	 * @see org.web3d.x3d.jsail.Sound.WaveShaper
	 * @return value of children field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=Children, $memberObjectName=children, $memberObjectName=children)

	public org.web3d.x3d.sai.Core.X3DNode[] getChildren()
	{
		final org.web3d.x3d.sai.Core.X3DNode[] valuesArray = new org.web3d.x3d.sai.Core.X3DNode[children.size()];
		int i = 0;
		for (org.web3d.x3d.sai.Core.X3DNode arrayElement : children) {
			valuesArray[i++] = arrayElement;
		}
		return valuesArray;
	}
	/**
	 * Utility method to get ArrayList value of MFNode children field, similar to {@link #getChildren()}.
	 * @return value of children field
	 */
	public ArrayList<org.web3d.x3d.sai.Core.X3DNode> getChildrenList()
	{
		return children;
	}

	/**
	 * Accessor method to assign org.web3d.x3d.sai.Core.X3DNode array (using an array consisting of properly typed nodes or ProtoInstances) to inputOutput MFNode field <i>children</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSoundChannelNode|X3DSoundProcessingNode|X3DSoundSourceNode] The children field specifies audio-graph sound sources providing input signals for this node. If multiple input signals are provided by the inputs children field, all channels are mixed together and merged prior to presentation.
 * <ul>
 *  <li> <i>Warning:</i> contained AudioClip or MovieTexture nodes must have containerField='children' to override otherwise-incorrect defaults. </li> 
 *  <li> <i>Hint:</i>  can be original (DEF) or referenced (USE) nodes. </li> 
 * </ul>
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper.
	 * @param newValue is new value for the children field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public WaveShaper setChildren(org.web3d.x3d.sai.Core.X3DNode[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)			// reset value field to empty array
		{
			clearChildren(); // newValueNullSetDEFAULT_VALUE
			return this;
		}

		// newValueArrayAcceptableNodeTypesTest checks are needed for methods that override/subset X3DNode interfaces #2
		for (int i = 0; i < newValue.length; i++)
		{
			boolean isNodeTypeAllowed = 
				(newValue[i] instanceof org.web3d.x3d.jsail.Core.CommentsBlock) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Core.ROUTE) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Networking.IMPORT) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Networking.EXPORT) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Core.ProtoDeclare) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Core.ExternProtoDeclare) ||
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Analyser) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.AudioClip) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.AudioDestination) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.BiquadFilter) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.BufferAudioSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.ChannelMerger) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.ChannelSelector) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.ChannelSplitter) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Convolver) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Delay) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.DynamicsCompressor) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Gain) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.ListenerPointSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.MicrophoneSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Texturing.MovieTexture) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.OscillatorSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Sound) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.SpatialSound) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.StreamAudioDestination) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.StreamAudioSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.WaveShaper);
			if  (!isNodeTypeAllowed)
			{
				throw new org.web3d.x3d.sai.InvalidFieldValueException("X3DNode[] newValue["+i+"] is not instanceof " +
					"acceptableNodeTypes Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper; newValue["+i+"]=" + newValue[i]);
			}
		}
		clearChildren(); // reset
		for (int i = 0; i < newValue.length; i++)
		{
			if  ((newValue[i] instanceof org.web3d.x3d.sai.Core.X3DNode) || (newValue[i] instanceof ProtoInstance))
			{
				children.add((org.web3d.x3d.sai.Core.X3DNode)newValue[i]);
				((X3DConcreteElement) newValue[i]).setParent(this); // parentTest12
			}
			else throw new org.web3d.x3d.sai.InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue["+i+"] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance array newValue=" + Arrays.toString(newValue));
		}
		return this;
	}

	/**
	 * Assign ArrayList value of MFNode children field, similar to {@link #setChildren(org.web3d.x3d.sai.Core.X3DNode[])}.
	 * @param newValue is new value for the children field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setChildren(ArrayList<org.web3d.x3d.sai.Core.X3DNode> newValue)
	{
		if (newValue == null)			// reset value field to empty array
		{
			clearChildren(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		// set-newValue-validity-checks #4

		// newValueArrayListAcceptableNodeTypesTest checks are needed for methods that override/subset X3DNode interfaces #3
		for (org.web3d.x3d.sai.Core.X3DNode element : newValue)
		{
			boolean isNodeTypeAllowed = 
				(element instanceof org.web3d.x3d.jsail.Core.CommentsBlock) ||
				(element instanceof org.web3d.x3d.jsail.Core.ROUTE) ||
				(element instanceof org.web3d.x3d.jsail.Networking.IMPORT) ||
				(element instanceof org.web3d.x3d.jsail.Networking.EXPORT) ||
				(element instanceof org.web3d.x3d.jsail.Core.ProtoDeclare) ||
				(element instanceof org.web3d.x3d.jsail.Core.ExternProtoDeclare) ||
				(element instanceof org.web3d.x3d.jsail.Sound.Analyser) || 
				(element instanceof org.web3d.x3d.jsail.Sound.AudioClip) || 
				(element instanceof org.web3d.x3d.jsail.Sound.AudioDestination) || 
				(element instanceof org.web3d.x3d.jsail.Sound.BiquadFilter) || 
				(element instanceof org.web3d.x3d.jsail.Sound.BufferAudioSource) || 
				(element instanceof org.web3d.x3d.jsail.Sound.ChannelMerger) || 
				(element instanceof org.web3d.x3d.jsail.Sound.ChannelSelector) || 
				(element instanceof org.web3d.x3d.jsail.Sound.ChannelSplitter) || 
				(element instanceof org.web3d.x3d.jsail.Sound.Convolver) || 
				(element instanceof org.web3d.x3d.jsail.Sound.Delay) || 
				(element instanceof org.web3d.x3d.jsail.Sound.DynamicsCompressor) || 
				(element instanceof org.web3d.x3d.jsail.Sound.Gain) || 
				(element instanceof org.web3d.x3d.jsail.Sound.ListenerPointSource) || 
				(element instanceof org.web3d.x3d.jsail.Sound.MicrophoneSource) || 
				(element instanceof org.web3d.x3d.jsail.Texturing.MovieTexture) || 
				(element instanceof org.web3d.x3d.jsail.Sound.OscillatorSource) || 
				(element instanceof org.web3d.x3d.jsail.Sound.Sound) || 
				(element instanceof org.web3d.x3d.jsail.Sound.SpatialSound) || 
				(element instanceof org.web3d.x3d.jsail.Sound.StreamAudioDestination) || 
				(element instanceof org.web3d.x3d.jsail.Sound.StreamAudioSource) || 
				(element instanceof org.web3d.x3d.jsail.Sound.WaveShaper);
			if  (!isNodeTypeAllowed)
			{
				throw new org.web3d.x3d.sai.InvalidFieldValueException("X3DNode[] element is not instanceof " +
					"acceptableNodeTypes Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper; element=" + element);
			}
		}
        if (newValue.isEmpty())
            clearChildren(); // reset
        else
        {
            org.web3d.x3d.sai.Core.X3DNode[] newArray = new org.web3d.x3d.sai.Core.X3DNode[newValue.size()];
            for (int i = 0; i < newValue.size(); i++)
                newArray[i] = newValue.get(i);
            setChildren(newArray);
        }
		for (org.web3d.x3d.sai.Core.X3DNode element : newValue)
		{
			children.add(element);
			((X3DConcreteElement) element).setParent(this); // parentTest13
		}
		return this;
	}
	/**
	 * Add single node to existing array of children nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper and ProtoInstance.
	 * @param newValue is new value to be appended the children field.	 */
	public void addChildren(org.web3d.x3d.sai.Core.X3DNode newValue)
	{
		if (newValue == null) return; // newValueNullReturnSelf

		// newValueInstanceAcceptableNodeTypesTest checks are needed for methods that override/subset X3DNode interfaces #1
		boolean isNodeTypeAllowed =
				(newValue instanceof org.web3d.x3d.jsail.Core.CommentsBlock) ||
				(newValue instanceof org.web3d.x3d.jsail.Core.ROUTE) ||
				(newValue instanceof org.web3d.x3d.jsail.Networking.IMPORT) ||
				(newValue instanceof org.web3d.x3d.jsail.Networking.EXPORT) ||
				(newValue instanceof org.web3d.x3d.jsail.Core.ProtoDeclare) ||
				(newValue instanceof org.web3d.x3d.jsail.Core.ExternProtoDeclare) ||
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Analyser) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.AudioClip) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.AudioDestination) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.BiquadFilter) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.BufferAudioSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ChannelMerger) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ChannelSelector) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ChannelSplitter) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Convolver) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Delay) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.DynamicsCompressor) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Gain) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ListenerPointSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.MicrophoneSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Texturing.MovieTexture) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.OscillatorSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Sound) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.SpatialSound) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.StreamAudioDestination) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.StreamAudioSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.WaveShaper);
		if  (!isNodeTypeAllowed)
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("X3DNode newValue is not instanceof " +
				"acceptableNodeTypes Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper; newValue=" + newValue);
		}
		children.add(newValue);
		((X3DConcreteElement) newValue).setParent(this); // parentTest2
	}
	/**
	 * Add single ProtoInstance (with appropriate node type and containerField value) to MFNode array for children field.
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to ShaderPart and ProtoInstance.
	 * @param newValue is new value to be appended the parts field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).	 */
	public WaveShaper addChildren(ProtoInstance newValue)
	{
		if (newValue == null) return this; // newValueNullReturnThis
		children.add(newValue);
		((X3DConcreteElement) newValue).setParent(this); // parentTest16
		return this;
	}

	/**
	 * Utility method to add single child element to contained list of existing children nodes (if any).
	 * @param newValue is new node value to be appended the children field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	*/
	public WaveShaper addChild(org.web3d.x3d.sai.Core.X3DChildNode newValue)
	{
		if (newValue == null) return this; // newValueNullReturnThis

		// newValueInstanceAcceptableNodeTypesTest checks are needed for methods that override/subset X3DNode interfaces #1
		boolean isNodeTypeAllowed =
				(newValue instanceof org.web3d.x3d.jsail.Core.CommentsBlock) ||
				(newValue instanceof org.web3d.x3d.jsail.Core.ROUTE) ||
				(newValue instanceof org.web3d.x3d.jsail.Networking.IMPORT) ||
				(newValue instanceof org.web3d.x3d.jsail.Networking.EXPORT) ||
				(newValue instanceof org.web3d.x3d.jsail.Core.ProtoDeclare) ||
				(newValue instanceof org.web3d.x3d.jsail.Core.ExternProtoDeclare) ||
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Analyser) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.AudioClip) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.AudioDestination) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.BiquadFilter) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.BufferAudioSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ChannelMerger) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ChannelSelector) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ChannelSplitter) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Convolver) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Delay) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.DynamicsCompressor) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Gain) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ListenerPointSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.MicrophoneSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Texturing.MovieTexture) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.OscillatorSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Sound) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.SpatialSound) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.StreamAudioDestination) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.StreamAudioSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.WaveShaper);
		if  (!isNodeTypeAllowed)
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("X3DNode newValue is not instanceof " +
				"acceptableNodeTypes Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper; newValue=" + newValue);
		}

		children.add((org.web3d.x3d.sai.Core.X3DNode)newValue);
		((X3DConcreteElement) newValue).setParent(this); // parentTest3
//      if  (newValue instanceof ProtoInstance)
//           ((ProtoInstance) newValue).setContainerField("children");

		return this;
	}
	/**
	 * Add array of children nodes to array of existing nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper.
	 * @param newValue is new value array to be appended the children field.
	 */
	public void addChildren(org.web3d.x3d.sai.Core.X3DNode[] newValue)
	{
		if (newValue == null) return; // newValueNullReturnSelf

		// newValueArrayAcceptableNodeTypesTest checks are needed for methods that override/subset X3DNode interfaces #2
		for (int i = 0; i < newValue.length; i++)
		{
			boolean isNodeTypeAllowed = 
				(newValue[i] instanceof org.web3d.x3d.jsail.Core.CommentsBlock) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Core.ROUTE) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Networking.IMPORT) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Networking.EXPORT) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Core.ProtoDeclare) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Core.ExternProtoDeclare) ||
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Analyser) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.AudioClip) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.AudioDestination) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.BiquadFilter) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.BufferAudioSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.ChannelMerger) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.ChannelSelector) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.ChannelSplitter) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Convolver) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Delay) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.DynamicsCompressor) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Gain) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.ListenerPointSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.MicrophoneSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Texturing.MovieTexture) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.OscillatorSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Sound) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.SpatialSound) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.StreamAudioDestination) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.StreamAudioSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.WaveShaper);
			if  (!isNodeTypeAllowed)
			{
				throw new org.web3d.x3d.sai.InvalidFieldValueException("X3DNode[] newValue["+i+"] is not instanceof " +
					"acceptableNodeTypes Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper; newValue["+i+"]=" + newValue[i]);
			}
		}
		for (int i = 0; i < newValue.length; i++)
		{
			if  ((newValue[i] instanceof org.web3d.x3d.sai.Core.X3DNode) || (newValue[i] instanceof ProtoInstance))
			{
				children.add(newValue[i]);
				((X3DConcreteElement) newValue[i]).setParent(this); // parentTest6
				if (newValue[i] instanceof ProtoInstance)
					((ProtoInstance) newValue[i]).setContainerField("children");
			}
			else throw new org.web3d.x3d.sai.InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue["+i+"] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance, array newValue=" + Arrays.toString(newValue));
		}
	}

	/**
	 * Set single children node, replacing prior array of existing nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are restricted to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper.
	 * @param newValue is new node for the children field (restricted to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper)
	 */
	/* @Override */
	public void setChildren(org.web3d.x3d.sai.Core.X3DNode newValue)
	{
		if (newValue == null)
		{
			clearChildren(); // reset newValueNullClearsFieldReturnVoid
			return;
		}

		// newValueInstanceAcceptableNodeTypesTest checks are needed for methods that override/subset X3DNode interfaces #1
		boolean isNodeTypeAllowed =
				(newValue instanceof org.web3d.x3d.jsail.Core.CommentsBlock) ||
				(newValue instanceof org.web3d.x3d.jsail.Core.ROUTE) ||
				(newValue instanceof org.web3d.x3d.jsail.Networking.IMPORT) ||
				(newValue instanceof org.web3d.x3d.jsail.Networking.EXPORT) ||
				(newValue instanceof org.web3d.x3d.jsail.Core.ProtoDeclare) ||
				(newValue instanceof org.web3d.x3d.jsail.Core.ExternProtoDeclare) ||
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Analyser) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.AudioClip) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.AudioDestination) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.BiquadFilter) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.BufferAudioSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ChannelMerger) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ChannelSelector) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ChannelSplitter) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Convolver) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Delay) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.DynamicsCompressor) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Gain) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ListenerPointSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.MicrophoneSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Texturing.MovieTexture) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.OscillatorSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Sound) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.SpatialSound) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.StreamAudioDestination) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.StreamAudioSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.WaveShaper);
		if  (!isNodeTypeAllowed)
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("X3DNode newValue is not instanceof " +
				"acceptableNodeTypes Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper; newValue=" + newValue);
		}
		if  (newValue instanceof org.web3d.x3d.sai.Core.X3DNode)
		{
			for (org.web3d.x3d.sai.Core.X3DNode element : children)
				((X3DConcreteElement) element).clearParent(); // remove references to facilitate Java memory management
			clearChildren(); // reset
			((X3DConcreteElement) newValue).setParent(this); // parentTest8
			children.add(newValue);
		}
		else throw new org.web3d.x3d.sai.InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode newValue is not instanceof org.web3d.x3d.sai.Core.X3DNode; newValue=" + newValue);
}
	/**
	 * Utility method to clear MFNode value of children field.  This method does not initialize withCHILDREN_DEFAULT_VALUE.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	public WaveShaper clearChildren()
	{
		for (org.web3d.x3d.sai.Core.X3DNode element : children)
			((X3DConcreteElement) element).clearParent(); // remove references to facilitate Java memory management
		children.clear(); // reset MF field
		return this;
	}

	/**
	 * Indicate whether an object is available for inputOutput MFNode field <i>children</i>.
	 * @return whether a properly typed node or ProtoInstance array or CommentsBlock is available.
	 * @see #getChildren()
	 */
	public boolean hasChildren()
	{
		return (!children.isEmpty());
	}

	/**
	 * Add comment as CommentsBlock to children field
	 * @param newComment initial value
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public WaveShaper addComments (String newComment)
	{
		if (newComment == null) return this;
		children.add(new CommentsBlock (newComment));
		return this;
	}
	/**
	 * Add comments as String[] array to children field
	 * @param newComments array of comments
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public WaveShaper addComments (String[] newComments)
	{
		if (newComments == null) return this;
		children.add(new CommentsBlock (newComments));
		return this;
	}
	/**
	 * Add CommentsBlock to children field
	 * @param newCommentsBlock block of comments to add
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public WaveShaper addComments (CommentsBlock newCommentsBlock)
	{
		if (newCommentsBlock == null) return this;
		children.add(newCommentsBlock);
		return this;
	}
											/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Author-provided prose that describes intended purpose of the url asset.
 * <ul>
 *  <li> <i> Hint:</i>  many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character). </li> 
 * </ul>
	 * @return value of description field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)

	public String getDescription()
	{
		return description;
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Author-provided prose that describes intended purpose of the url asset.
 * <ul>
 *  <li> <i> Hint:</i>  many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character). </li> 
 * </ul>
	 * @param newValue is new value for the description field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public WaveShaper setDescription(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		description = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString description field, similar to {@link #setDescription(String)}.
	 * @param newValue is new value for the description field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setDescription(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDescription(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from outputOnly SFTime field named <i>elapsedTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,+infinity) Current elapsed time since AudioClip activated/running, cumulative in seconds, and not counting any paused time.
 * <ul>
 *  <li> <i>Warning:</i> it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events. </li> 
 *  <li> <i>Hint:</i>  elapsedTime is a nonnegative SFTime duration interval, not an absolute clock time. </li> 
 * </ul>
	 * @return value of elapsedTime field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=ElapsedTime, $memberObjectName=elapsedTime, $memberObjectName=elapsedTime)

	public double getElapsedTime()
	{
		return elapsedTime;
	}
	/**
	 * Provide boolean value from inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @return value of enabled field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=Enabled, $memberObjectName=enabled, $memberObjectName=enabled)

	public boolean getEnabled()
	{
		return enabled;
	}

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @param newValue is new value for the enabled field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public WaveShaper setEnabled(boolean newValue)
	{
		// set-newValue-validity-checks #0.a
		enabled = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFBool enabled field, similar to {@link #setEnabled(boolean)}.
	 * @param newValue is new value for the enabled field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setEnabled(SFBool newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setEnabled(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide float value from inputOutput SFFloat field named <i>gain</i>.
	 * <br><br>
	 * <i>Tooltip:</i> (-infinity,+infinity) The gain field is a factor that represents the amount of linear amplification to apply to the output of the node.
 * <ul>
 *  <li> <i>Warning:</i> Decibel values shall not be used. </li> 
 *  <li> <i>Hint:</i>  Negative gain factors negate the input signal. </li> 
 * </ul>
	 * @return value of gain field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=Gain, $memberObjectName=gain, $memberObjectName=gain)

	public float getGain()
	{
		return gain;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>gain</i>.
	 * <br><br>
	 * <i>Tooltip:</i> (-infinity,+infinity) The gain field is a factor that represents the amount of linear amplification to apply to the output of the node.
 * <ul>
 *  <li> <i>Warning:</i> Decibel values shall not be used. </li> 
 *  <li> <i>Hint:</i>  Negative gain factors negate the input signal. </li> 
 * </ul>
	 * @param newValue is new value for the gain field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public WaveShaper setGain(float newValue)
	{
		// set-newValue-validity-checks #0.a
		gain = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat gain field, similar to {@link #setGain(float)}.
	 * @param newValue is new value for the gain field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setGain(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setGain(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setGain(float)}.
	 * @param newValue is new value for field
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setGain(double newValue)
	{
		return setGain((float) newValue);
	}
	/**
	 * Provide IS instance (using a properly typed node) from inputOutput SFNode field <i>IS</i>.
	 * @return value of IS field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=true, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=IS, $memberObjectName=IS, $memberObjectName=IS)
	public IS getIS()
	{
		return IS;
	}

	/**
	 * Accessor method to assign IS instance (using a properly typed node) to inputOutput SFNode field <i>IS</i>.
	 * @param newValue is new value for the IS field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setIS(IS newValue)
	{
		// set-newValue-validity-checks #0.a
		IS = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) IS).setParent(this); // parentTest15.1
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of IS field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public WaveShaper clearIS()
	{
		((X3DConcreteElement) IS).clearParent(); // remove references to facilitate Java memory management
		IS = null; // reset SFNode field
		return this;
	}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>IS</i>.
	 * @return whether a concrete statement or CommentsBlock is available.
	 * @see #getIS()
	 */
	public boolean hasIS()
	{
		return (IS != null);
	}
	/**
	 * Provide boolean value from outputOnly SFBool field named <i>isActive</i>.
	 * <br><br>
	 * <i>Tooltip:</i> isActive true/false events are sent when playback starts/stops.
 * <ul>
 *  <li> <i> Warning:</i>  it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events. </li> 
 * </ul>
	 * @return value of isActive field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=IsActive, $memberObjectName=isActive, $memberObjectName=isActive)

	public boolean getIsActive()
	{
		return isActive;
	}
	/**
	 * Provide boolean value from outputOnly SFBool field named <i>isPaused</i>.
	 * <br><br>
	 * <i>Tooltip:</i> isPaused true/false events are sent when AudioClip is paused/resumed.
 * <ul>
 *  <li> <i> Warning:</i>  it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events. </li> 
 * </ul>
	 * @return value of isPaused field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=IsPaused, $memberObjectName=isPaused, $memberObjectName=isPaused)

	public boolean getIsPaused()
	{
		return isPaused;
	}
	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * @see #getMetadataProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata()
	{
		return metadata;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public WaveShaper setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue)
	{
		// set-newValue-validity-checks #0.a
		metadata = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadata).setParent(this); // parentTest15.1
			// change X3D4 MetadataSet default 'value' back to 'metadata' if parent is not another Metadata* node */
			if (metadata instanceof org.web3d.x3d.jsail.Core.MetadataSet)
{
				((X3DConcreteNode) metadata).setContainerFieldOverride("metadata");
}
		}
		if (metadataProtoInstance != null)
		{
			metadataProtoInstance.setParent(null); // housekeeping, clear prior object
			metadataProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of metadata field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public WaveShaper clearMetadata()
	{
		((X3DConcreteElement) metadata).clearParent(); // remove references to facilitate Java memory management
		metadata = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject)
	 * @param newValue is new value for the metadata field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public WaveShaper setMetadata(ProtoInstance newValue)
	{
		if (metadataProtoInstance != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(null); // parentTest15.5
	    }
		metadataProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(this); // parentTest15.6
            metadataProtoInstance.setContainerField("metadata");
	    }
		if (metadata != null)
		{
			((X3DConcreteElement) metadata).setParent(null); // housekeeping, clear prior object
			metadata = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getMetadataProtoInstance()
		{
			return metadataProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>metadata</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getMetadata()
	 * @see #getMetadataProtoInstance()
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 */
	public boolean hasMetadata()
	{
		return (metadata != null) || (metadataProtoInstance != null);
	}
	/**
	 * Provide String enumeration value (baseType SFString) ["NONE" | "2X" | "4X"] from inputOutput SFString field named <i>oversample</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The oversample field is specifies what type of oversampling (if any) should be used when applying the shaping curve. Allowed values follow. Note that for some applications, avoiding oversampling can produce a precise shaping curve.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#enumdef-oversampletype" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-oversampletype</a> </li> 
 * </ul>
	 * <br><br>
	 * Available enumeration values for string comparison: {@link #OVERSAMPLE_NONE NONE}, {@link #OVERSAMPLE_2X 2X}, {@link #OVERSAMPLE_4X 4X}.
	 * @return value of oversample field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=Oversample, $memberObjectName=oversample, $memberObjectName=oversample)

	public String getOversample()
	{
		return oversample;
	}

	/**
	 * Accessor method to assign String enumeration value ("NONE" | "2X" | "4X") to inputOutput SFString field named <i>oversample</i>.
	 * <br><br>
	 * <i>Warning:</i> authors can only choose from a strict list of enumeration values ({@link #OVERSAMPLE_NONE NONE}, {@link #OVERSAMPLE_2X 2X}, {@link #OVERSAMPLE_4X 4X}).
	 * <br><br>
	 * <i>Tooltip:</i> The oversample field is specifies what type of oversampling (if any) should be used when applying the shaping curve. Allowed values follow. Note that for some applications, avoiding oversampling can produce a precise shaping curve.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#enumdef-oversampletype" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-oversampletype</a> </li> 
 * </ul>
	 * @param newValue is new value for the oversample field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public WaveShaper setOversample(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
		{
                    newValue = new String(); // null string check
		}
		newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue); // handle potential enumeration value
                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.isEmpty() ||
			newValue.toString().replace("\"","").equals(OVERSAMPLE_NONE) ||
			newValue.toString().replace("\"","").equals(OVERSAMPLE_2X) ||
			newValue.toString().replace("\"","").equals(OVERSAMPLE_4X)))
		{
			String warningMessage = "[warning] WaveShaper oversample newValue='" + newValue + "' includes an unrecognized optional value not matching any of the required enumeration string tokens.";
			if (!oversampleWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "       Supported values are NONE, 2X, 4X";
			    oversampleWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);

            if (!newValue.isEmpty()) // @additionalEnumerationValuesAllowed='false'
            {
                throw new org.web3d.x3d.sai.InvalidFieldValueException(warningMessage);
            }
		}
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		oversample = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString oversample field, similar to {@link #setOversample(String)}.
	 * @param newValue is new value for the oversample field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setOversample(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setOversample(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide double value in seconds from inputOutput SFTime field named <i>pauseTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i> When time now &amp;gt;= pauseTime, isPaused becomes true and AudioClip becomes paused. Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT.
 * <ul>
 *  <li> <i> Hint:</i>  ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. </li> 
 * </ul>
	 * @return value of pauseTime field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=PauseTime, $memberObjectName=pauseTime, $memberObjectName=pauseTime)

	public double getPauseTime()
	{
		return pauseTime;
	}

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>pauseTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i> When time now &amp;gt;= pauseTime, isPaused becomes true and AudioClip becomes paused. Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT.
 * <ul>
 *  <li> <i> Hint:</i>  ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. </li> 
 * </ul>
	 * @param newValue is new value for the pauseTime field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public WaveShaper setPauseTime(double newValue)
	{
		// set-newValue-validity-checks #0.a
		pauseTime = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFTime pauseTime field, similar to {@link #setPauseTime(double)}.
	 * @param newValue is new value for the pauseTime field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setPauseTime(SFTime newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setPauseTime(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide double value in seconds from inputOutput SFTime field named <i>resumeTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i> When resumeTime becomes &amp;lt;= time now, isPaused becomes false and AudioClip becomes active. Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT.
 * <ul>
 *  <li> <i> Hint:</i>  ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. </li> 
 * </ul>
	 * @return value of resumeTime field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=ResumeTime, $memberObjectName=resumeTime, $memberObjectName=resumeTime)

	public double getResumeTime()
	{
		return resumeTime;
	}

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>resumeTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i> When resumeTime becomes &amp;lt;= time now, isPaused becomes false and AudioClip becomes active. Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT.
 * <ul>
 *  <li> <i> Hint:</i>  ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. </li> 
 * </ul>
	 * @param newValue is new value for the resumeTime field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public WaveShaper setResumeTime(double newValue)
	{
		// set-newValue-validity-checks #0.a
		resumeTime = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFTime resumeTime field, similar to {@link #setResumeTime(double)}.
	 * @param newValue is new value for the resumeTime field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setResumeTime(SFTime newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setResumeTime(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide double value in seconds from inputOutput SFTime field named <i>startTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT.
 * <ul>
 *  <li> <i> Hint:</i>  ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. </li> 
 * </ul>
	 * @return value of startTime field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=StartTime, $memberObjectName=startTime, $memberObjectName=startTime)

	public double getStartTime()
	{
		return startTime;
	}

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>startTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT.
 * <ul>
 *  <li> <i> Hint:</i>  ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. </li> 
 * </ul>
	 * @param newValue is new value for the startTime field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public WaveShaper setStartTime(double newValue)
	{
		// set-newValue-validity-checks #0.a
		startTime = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFTime startTime field, similar to {@link #setStartTime(double)}.
	 * @param newValue is new value for the startTime field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setStartTime(SFTime newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setStartTime(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide double value in seconds from inputOutput SFTime field named <i>stopTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT.
 * <ul>
 *  <li> <i>Hint:</i> ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. </li> 
 *  <li> <i>Warning:</i> An active TimeSensor node ignores set_cycleInterval and set_startTime events. </li> 
 *  <li> <i>Warning:</i>  An active TimeSensor node ignores set_stopTime event values less than or equal to startTime. </li> 
 * </ul>
	 * @return value of stopTime field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=StopTime, $memberObjectName=stopTime, $memberObjectName=stopTime)

	public double getStopTime()
	{
		return stopTime;
	}

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>stopTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT.
 * <ul>
 *  <li> <i>Hint:</i> ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. </li> 
 *  <li> <i>Warning:</i> An active TimeSensor node ignores set_cycleInterval and set_startTime events. </li> 
 *  <li> <i>Warning:</i>  An active TimeSensor node ignores set_stopTime event values less than or equal to startTime. </li> 
 * </ul>
	 * @param newValue is new value for the stopTime field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public WaveShaper setStopTime(double newValue)
	{
		// set-newValue-validity-checks #0.a
		stopTime = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFTime stopTime field, similar to {@link #setStopTime(double)}.
	 * @param newValue is new value for the stopTime field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setStopTime(SFTime newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setStopTime(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>tailTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) tailTime is duration of time that a node continues to provide output signal after the input signal becomes silent.  * <br>

	 * @return value of tailTime field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=TailTime, $memberObjectName=tailTime, $memberObjectName=tailTime)

	public double getTailTime()
	{
		return tailTime;
	}

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>tailTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) tailTime is duration of time that a node continues to provide output signal after the input signal becomes silent.  * <br>

	 * @param newValue is new value for the tailTime field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public WaveShaper setTailTime(double newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("WaveShaper tailTime newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
		tailTime = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFTime tailTime field, similar to {@link #setTailTime(double)}.
	 * @param newValue is new value for the tailTime field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setTailTime(SFTime newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setTailTime(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i> DEF defines a unique ID name for this node, referenceable by other nodes.
 * <ul>
 *  <li> <i>Hint:</i> descriptive DEF names improve clarity and help document a model. </li> 
 *  <li> <i>Hint:</i> well-defined names can simplify design and debugging through improved author understanding. </li> 
 *  <li> <i>Hint:</i>  X3D Scene Authoring Hints, Naming Conventions <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions</a> </li> 
 * </ul>
	 * @return value of DEF field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=DEF, $memberObjectName=DEF, $memberObjectName=DEF)

	public String getDEF()
	{
		// override abstract method in X3DConcreteNode
		return super.getDEF();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i> DEF defines a unique ID name for this node, referenceable by other nodes.
 * <ul>
 *  <li> <i>Hint:</i> descriptive DEF names improve clarity and help document a model. </li> 
 *  <li> <i>Hint:</i> well-defined names can simplify design and debugging through improved author understanding. </li> 
 *  <li> <i>Hint:</i>  X3D Scene Authoring Hints, Naming Conventions <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions</a> </li> 
 * </ul>
	 * <br><br>
	 *  Note that setting the DEF value clears the USE value.
	 * @param newValue is new value for the DEF field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final WaveShaper setDEF(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to WaveShaper DEF
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("WaveShaper DEF newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteUSE(""); // ensure that no previous USE value remains
		setConcreteDEF(newValue); // private superclass methods
		return this;
	}

	/**
	 * Assign typed object value to SFString DEF field, similar to {@link #setDEF(String)}.
	 * @param newValue is new value for the DEF field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setDEF(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDEF(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i> USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value).
 * <ul>
 *  <li> <i>Hint:</i> USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. </li> 
 *  <li> <i>Warning:</i> do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. </li> 
 *  <li> <i>Warning:</i>  each USE value must match a corresponding DEF value that is defined earlier in the scene. </li> 
 * </ul>
	 * @return value of USE field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=USE, $memberObjectName=USE, $memberObjectName=USE)

	public String getUSE()
	{
		// override abstract method in X3DConcreteNode
		return super.getUSE();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i> USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value).
 * <ul>
 *  <li> <i>Hint:</i> USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. </li> 
 *  <li> <i>Warning:</i> do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. </li> 
 *  <li> <i>Warning:</i>  each USE value must match a corresponding DEF value that is defined earlier in the scene. </li> 
 * </ul>
	 * <br><br>
	 * <i>Note:</i> each <code>USE</code> node is still an independent object, with the <code>USE</code> value matching the <code>DEF</code> value in the preceding object. 
	 * <br><br>
	 * <i>Warning:</i> invoking the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.<br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param newValue is new value for the USE field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final WaveShaper setUSE(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to WaveShaper USE
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("WaveShaper USE newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteDEF(""); // ensure that no previous DEF value remains
		setConcreteUSE(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString USE field, similar to {@link #setUSE(String)}.
	 * @param newValue is new value for the USE field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setUSE(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setUSE(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>class</i>.
	 * @return value of class field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=CssClass, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssClass()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssClass();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>class</i>.
	 * @param newValue is new value for the class field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final WaveShaper setCssClass(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssClass(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssClass(String)}.
	 * @param newValue is new value for the class field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setCssClass(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssClass(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>id</i>.
	 * @return value of id field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=HtmlID, $memberObjectName=HtmlID, $memberObjectName=HtmlID)

	public String getHtmlID()
	{
		// override abstract method in X3DConcreteNode
		return super.getHtmlID();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>id</i>.
	 * @param newValue is new value for the id field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final WaveShaper setHtmlID(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteHtmlID(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString HtmlID field, similar to {@link #setHtmlID(String)}.
	 * @param newValue is new value for the id field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setHtmlID(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setHtmlID(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>style</i>.
	 * @return value of style field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=WaveShaper, $CamelCaseName=CssStyle, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssStyle()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssStyle();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>style</i>.
	 * @param newValue is new value for the style field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final WaveShaper setCssStyle(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssStyle(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssStyle(String)}.
	 * @param newValue is new value for the style field.
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setCssStyle(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssStyle(newValue.getPrimitiveValue());
			return this;
	}

	// Additional utility methods for this class ==============================

	/**
	 * Assign a USE reference to another DEF node of same node type, similar to {@link #setUSE(String)}.
	 * <br ><br >
	 * <i>Warning:</i> note that the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.
	 * <br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param DEFnode must have a DEF value defined
	 * @return {@link WaveShaper} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public WaveShaper setUSE(WaveShaper DEFnode)
	{
		if (DEFnode.getDEF().isEmpty())
		{
			String errorNotice = "*** setUSE(DEFnode) invoked on WaveShaper" +
				" that has no DEF name defined, thus a copy cannot be referenced as a USE node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		setUSE(DEFnode.getDEF());
		return this;
	}
	/**
	 * Utility constructor that assigns DEF label after initializing member variables with default values.
	 * @param DEFlabel unique DEF name for this X3D node
	 */
	public WaveShaper (String DEFlabel)
	{
		initialize();
		setDEF(DEFlabel); // apply checks
	}

	/**
	 * Utility method to adjust field synonyms
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges">X3D Scene Authoring Hints: X3D4 Field name changes for improved consistency</a>
     */
    private void handleFieldSynonyms()
    {
            // no synonyms to handle
	}

	/**
	 * Recursive method to provide X3D string serialization of this model subgraph, utilizing XML encoding and conforming to X3D Canonical Form.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_X3D
	 * @see X3D#FILE_EXTENSION_XML
	 * @see X3D#toStringXML()
	 * @see X3D#toFileXML(String)
	 * @see X3D#toFileX3D(String)
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-1/V3.3/Part01/X3D_XML.html">X3D XML Encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-3/V3.3/Part03/concepts.html#X3DCanonicalForm" target="blank">X3D Compressed Binary Encoding: X3D Canonical Form</a>
	 * @see <a href="https://www.web3d.org/x3d/tools/canonical/doc/x3dTools.htm">X3D Canonicalization (C14N) Tool</a>
	 * @return X3D string
	 */
	@Override
	public String toStringX3D(int indentLevel)
	{
		boolean hasAttributes = true; // TODO check for non-default attribute values
		boolean      hasChild = (IS != null) || (!children.isEmpty()) || 
		                        (IS != null) || 
		                        (metadata != null) || (metadataProtoInstance != null);
		if (hasUSE())
			hasChild = false; // USE nodes only include attributes for USE and non-default containerField
		handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder indent = new StringBuilder();
		int  indentIncrement = ConfigurationProperties.getIndentIncrement();
		char indentCharacter = ConfigurationProperties.getIndentCharacter();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		StringBuilder stringX3D = new StringBuilder();

		stringX3D.append(indent).append("<WaveShaper"); // start opening tag
		if (hasAttributes)
		{
			if (!getDEF().equals(DEF_DEFAULT_VALUE) && !hasUSE())
			{
				stringX3D.append(" DEF='").append(SFString.toString(getDEF())).append("'");
			}
			
			if (!getUSE().equals(USE_DEFAULT_VALUE))
			{
				stringX3D.append(" USE='").append(SFString.toString(getUSE())).append("'");
			}
			
            // containerField is critical for ProtoInstance relationship to parent node
            if (!getContainerFieldOverride().isBlank() && !getContainerFieldOverride().equals(this.getContainerFieldDefault())) // output if not default ProtoInstance containerField
            {
                    stringX3D.append(" containerField='").append(getContainerFieldOverride()).append("'");
            }

            // test attributes

			if ((!getChannelCountMode().equals(CHANNELCOUNTMODE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" channelCountMode='").append(new SFString(getChannelCountMode()).toStringX3D()).append("'");
			}
			if ((!getChannelInterpretation().equals(CHANNELINTERPRETATION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" channelInterpretation='").append(new SFString(getChannelInterpretation()).toStringX3D()).append("'");
			}
			if ((!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" class='").append(new SFString(getCssClass()).toStringX3D()).append("'");
			}
			if ((!getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" description='").append(new SFString(getDescription()).toStringX3D()).append("'");
			}
			if (((getEnabled() != ENABLED_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" enabled='").append(SFBool.toString(getEnabled())).append("'");
			}
			if (((getGain() != GAIN_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" gain='").append(SFFloat.toString(getGain())).append("'");
			}
			if ((!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" id='").append(new SFString(getHtmlID()).toStringX3D()).append("'");
			}
			if ((!getOversample().equals(OVERSAMPLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" oversample='").append(new SFString(getOversample()).toStringX3D()).append("'");
			}
			if (((getPauseTime() != PAUSETIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" pauseTime='").append(SFTime.toString(getPauseTime())).append("'");
			}
			if (((getResumeTime() != RESUMETIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" resumeTime='").append(SFTime.toString(getResumeTime())).append("'");
			}
			if (((getStartTime() != STARTTIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" startTime='").append(SFTime.toString(getStartTime())).append("'");
			}
			if (((getStopTime() != STOPTIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" stopTime='").append(SFTime.toString(getStopTime())).append("'");
			}
			if ((!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" style='").append(new SFString(getCssStyle()).toStringX3D()).append("'");
			}
			if (((getTailTime() != TAILTIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" tailTime='").append(SFTime.toString(getTailTime())).append("'");
			}
		}
		if ((hasChild) && !hasUSE()) // has contained node(s), comment(s), IS/connect and/or source code
		{
			stringX3D.append(">").append("\n"); // finish opening tag

			// recursively iterate over child elements
			if      (IS != null)
			{
				stringX3D.append(((X3DConcreteElement)IS).toStringX3D(indentLevel + indentIncrement));
			}
			if      (metadata != null)
			{
				stringX3D.append(((X3DConcreteElement)metadata).toStringX3D(indentLevel + indentIncrement));
			}
			else if (metadataProtoInstance != null)
			{
				stringX3D.append(((X3DConcreteElement)metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			for (org.web3d.x3d.sai.Core.X3DNode element : children)
			{
				stringX3D.append(((X3DConcreteElement)element).toStringX3D(indentLevel + indentIncrement));
			}
			stringX3D.append(indent).append("</WaveShaper>").append("\n"); // finish closing tag
		}
		else
		{
			stringX3D.append("/>").append("\n"); // otherwise finish singleton tag
		}
		return stringX3D.toString();
	}
// ($name=WaveShaper, isX3dStatement=false, isClassX3dStatement=false, $hasChild=true, $hasAttributes=true
	/**
	 * Recursive method to provide ClassicVRML string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_CLASSICVRML
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/X3D_ClassicVRML.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/grammar.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding, Annex A: Grammar</a>
	 * @return ClassicVRML string
	 */
	@Override
	public String toStringClassicVRML(int indentLevel)
	{
		StringBuilder stringClassicVRML = new StringBuilder();
		boolean hasAttributes = true; // TODO further refinement
		boolean      hasChild = (IS != null) || (!children.isEmpty()) || 
		                        (IS != null) || 
		                        (metadata != null) || (metadataProtoInstance != null);
		if (hasUSE())
		{
			hasAttributes = false;
			hasChild      = false; // USE nodes include no other fields
		}
                if (!serializingVRML97output)
                    handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder  indent = new StringBuilder();
		char  indentCharacter = ConfigurationProperties.getIndentCharacter();
		int   indentIncrement = ConfigurationProperties.getIndentIncrement();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		if (!getDEF().equals(DEF_DEFAULT_VALUE))
		{
			stringClassicVRML.append("DEF ").append(SFString.toString(getDEF())).append(" ");
		}
		if (!getUSE().equals(USE_DEFAULT_VALUE))
		{
			 stringClassicVRML.append("USE ").append(SFString.toString(getUSE())).append("\n");
		}
		else // only have further output if not a USE node
		{
			stringClassicVRML.append("WaveShaper").append(" { "); // define node name, node content follows

			if (hasAttributes || hasChild)
			{
				stringClassicVRML.append("\n").append(indent).append(indentCharacter); // fields for this node follow
			}
			if (hasAttributes)
			{
				boolean hasISconnect = (getIS() != null) && !getIS().getConnectList().isEmpty();
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("channelCountMode"))
						{
							stringClassicVRML.append(indentCharacter).append("channelCountMode").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getChannelCountMode().equals(CHANNELCOUNTMODE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("channelCountMode ").append("\"").append(SFString.toString(getChannelCountMode())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("channelInterpretation"))
						{
							stringClassicVRML.append(indentCharacter).append("channelInterpretation").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getChannelInterpretation().equals(CHANNELINTERPRETATION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("channelInterpretation ").append("\"").append(SFString.toString(getChannelInterpretation())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("class"))
						{
							stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(getCssClass())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("description"))
						{
							stringClassicVRML.append(indentCharacter).append("description").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("description ").append("\"").append(SFString.toString(getDescription())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("enabled"))
						{
							stringClassicVRML.append(indentCharacter).append("enabled").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getEnabled() != ENABLED_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("enabled ").append(SFBool.toStringClassicVRML(getEnabled())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("gain"))
						{
							stringClassicVRML.append(indentCharacter).append("gain").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getGain() != GAIN_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("gain ").append(SFFloat.toString(getGain())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("id"))
						{
							stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(getHtmlID())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("oversample"))
						{
							stringClassicVRML.append(indentCharacter).append("oversample").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getOversample().equals(OVERSAMPLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("oversample ").append("\"").append(SFString.toString(getOversample())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("pauseTime"))
						{
							stringClassicVRML.append(indentCharacter).append("pauseTime").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getPauseTime() != PAUSETIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("pauseTime ").append(SFTime.toString(getPauseTime())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("resumeTime"))
						{
							stringClassicVRML.append(indentCharacter).append("resumeTime").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getResumeTime() != RESUMETIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("resumeTime ").append(SFTime.toString(getResumeTime())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("startTime"))
						{
							stringClassicVRML.append(indentCharacter).append("startTime").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getStartTime() != STARTTIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("startTime ").append(SFTime.toString(getStartTime())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("stopTime"))
						{
							stringClassicVRML.append(indentCharacter).append("stopTime").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getStopTime() != STOPTIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("stopTime ").append(SFTime.toString(getStopTime())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("style"))
						{
							stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(getCssStyle())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("tailTime"))
						{
							stringClassicVRML.append(indentCharacter).append("tailTime").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getTailTime() != TAILTIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("tailTime ").append(SFTime.toString(getTailTime())).append("\n").append(indent).append(indentCharacter);
				}
			}
		}
		if (hasChild) // has contained node(s) (including USE), comment(s), IS/connect and/or source code
		{
                        // recursively iterate over child elements

			if (metadata != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadata).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (metadataProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (!children.isEmpty())
			{
				stringClassicVRML.append(indentCharacter).append(indentCharacter).append("children").append(" [").append("\n")
					.append(indent).append(indentCharacter).append(indentCharacter); // containerField for MFNode array
                            for (org.web3d.x3d.sai.Core.X3DNode element : children)
                            {
				stringClassicVRML.append(((X3DConcreteElement)element).toStringClassicVRML(indentLevel + indentIncrement + indentIncrement));
                            }
                            stringClassicVRML.append(indent).append(indentCharacter).append(indentCharacter).append("]").append("\n")
				.append(indent); // end MFNode array
			}
			if (IS != null)
			{
				stringClassicVRML.append(((X3DConcreteElement) IS).toStringClassicVRML(indentLevel)); // end X3D statement
			}stringClassicVRML.append("\n").append(indent).append("\n"); // .append(" ### trace field initialization value #8")

		}
		if (getUSE().isEmpty() && (hasAttributes || hasChild))
		{
			stringClassicVRML.append("}").append("\n"); // finish node content
		}
		return stringClassicVRML.toString();
	}


    private boolean serializingVRML97output = false; // whether to avoid handling field name synonyms

	/**
	 * Recursive method to provide VRML97 string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_VRML97
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772/V2.0/index.html">Virtual Reality Modeling Language (VRML) 97 specification</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772-1/V2.1/index.html">VRML 97 v2.1 Amendment</a>
	 * @return VRML97 string
	 */
	@Override
	public String toStringVRML97(int indentLevel)
	{
            serializingVRML97output = true;
            String result = toStringClassicVRML(indentLevel);
            serializingVRML97output = false;

            return result;
	}

	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue)
	{
		return findElementByNameValue(nameValue, ""); // empty string is wildcard, any element match is allowed
	}

	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue, String elementName)
	{
		if ((nameValue == null) || nameValue.isEmpty())
		{
			String errorNotice = "*** findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		// no name field available for this element
		X3DConcreteElement referenceElement;
		for (org.web3d.x3d.sai.Core.X3DNode element : children) // MFNode
		{
			if (element instanceof X3DConcreteElement)
			{
				referenceElement = ((X3DConcreteElement) element).findElementByNameValue(nameValue, elementName);
				if (referenceElement != null)
					return referenceElement;
			}
		}
		if (IS != null)
		{
			referenceElement = ((X3DConcreteElement) IS).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadata != null)
		{
			referenceElement = ((X3DConcreteElement) metadata).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadataProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) metadataProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node or statement with given name attribute is found, meaning both objects are attached to same scene graph.
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @see #findElementByNameValue(String, String)
	 * @return whether node is found
	 */
	public boolean hasElementByNameValue(String nameValue, String elementName)
	{
		return (findElementByNameValue(nameValue, elementName) != null);
	}

	/**
	 * Recursive method to provide object reference to node by DEF, if found as this node or in a contained node.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same DEF, this method does not handle that case.
	 * @see #findElementByNameValue(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found node, null otherwise
	 */
	/* @Override */
	public X3DConcreteNode findNodeByDEF(String DEFvalue)
	{
		if ((DEFvalue == null) || DEFvalue.isEmpty())
		{
			String errorNotice = "*** findNodeByDEF(\"\") cannot use empty string to find a name";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		if (getDEF().equals(DEFvalue))
			return this;
		X3DConcreteNode referenceNode;
		for (org.web3d.x3d.sai.Core.X3DNode element : children) // MFNode
		{
			if (element instanceof org.web3d.x3d.jsail.X3DConcreteNode)
			{
				referenceNode = ((X3DConcreteElement) element).findNodeByDEF(DEFvalue);
				if (referenceNode != null)
					return referenceNode;
			}
		}
		if (IS != null)
		{
			referenceNode = ((X3DConcreteElement) IS).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadata != null)
		{
			referenceNode = ((X3DConcreteElement) metadata).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadataProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) metadataProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node with DEFvalue is found, meaning both objects are attached to same scene graph.
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @see #findNodeByDEF(String)
	 * @return whether node is found
	 */
	public boolean hasNodeByDEF(String DEFvalue)
	{
		return (findNodeByDEF(DEFvalue) != null);
	}


	/**
	 * Recursive method to validate this element plus all contained nodes and statements,
	 * using both datatype-specification value checks and regular expression (regex) checking of corresponding string values.
         * TODO document specific validation methods.
	 * @return validation results (if any)
	 */
	@Override
	public String validate()
	{
		validationResult = new StringBuilder(); // prepare for updated results

		setChannelCountMode(getChannelCountMode()); // exercise field checks, simple types
        
		setChannelInterpretation(getChannelInterpretation()); // exercise field checks, simple types
        
		setDescription(getDescription()); // exercise field checks, simple types
        
		setEnabled(getEnabled()); // exercise field checks, simple types
        
		setGain(getGain()); // exercise field checks, simple types
        
		setOversample(getOversample()); // exercise field checks, simple types
        
		setPauseTime(getPauseTime()); // exercise field checks, simple types
        
		setResumeTime(getResumeTime()); // exercise field checks, simple types
        
		setStartTime(getStartTime()); // exercise field checks, simple types
        
		setStopTime(getStopTime()); // exercise field checks, simple types
        
		setTailTime(getTailTime()); // exercise field checks, simple types
        
		if (!hasUSE()) // be careful! setting DEF via setDEF() method will reset USE value
			setDEF(getDEF()); // exercise field checks, simple types
        
		if (hasUSE()) // be careful! setting USE via setUSE() method resets all attributes to default values and wipes out all children
			setUSE(getUSE()); // exercise field checks, simple types
        
		setCssClass(getCssClass()); // exercise field checks, simple types
        
		setHtmlID(getHtmlID()); // exercise field checks, simple types
        
		setCssStyle(getCssStyle()); // exercise field checks, simple types
        
		for (org.web3d.x3d.sai.Core.X3DNode element : children) // MFNode
		{
			try {
                            ((X3DConcreteElement) element).validate(); // exercise field checks, MFNode element
                            validationResult.append(((X3DConcreteElement) element).getValidationResult());
                        }
                        catch (Exception e)
                        {
                            String exceptionMessage = "[exception] during validation: " + e.getMessage();
                            validationResult.append(exceptionMessage);
                        //  System.err.println(exceptionMessage);
                            e.printStackTrace();
                        }
		}
		setChildren(getChildren()); // also test getter/setter validation, which also includes checks for acceptableNodeTypes (if applicable)

		if (hasUSE() && hasChildren()) // test USE restrictions
		{
                    String errorNotice = "*** WaveShaper USE='" + getUSE() + "' is not allowed to have contained MFNode children";
                    validationResult.append(errorNotice);
                    throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (IS != null)
		{
			setIS(getIS());
			((X3DConcreteElement) IS).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) IS).getValidationResult());
		}
            if (hasUSE() && hasIS()) // test USE restrictions
            {
                String errorNotice = "*** WaveShaper USE='" + getUSE() + "' is not allowed to have contained SFNode IS";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (metadata != null)
		{
			setMetadata(getMetadata());
			((X3DConcreteElement) metadata).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadata).getValidationResult());
		}
		if (metadataProtoInstance != null)
		{
			setMetadata(getMetadataProtoInstance());
			((X3DConcreteElement) metadataProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadataProtoInstance).getValidationResult());
		}
		if ((metadata != null) && (metadataProtoInstance != null))
		{
			String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
            if (hasUSE() && hasMetadata()) // test USE restrictions
            {
                String errorNotice = "*** WaveShaper USE='" + getUSE() + "' is not allowed to have contained SFNode metadata";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (getIS() != null)
		{
			if (getIS().getConnectList().isEmpty())
			{
				String errorNotice = "*** IS statement present, but contains no connect statements";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
			}
			// TODO also check that this node has ancestor ProtoBody, and that a field with same name also exists, so that IS is legal
		}
		if (!getContainerFieldOverride().isBlank() &&
			!Arrays.asList(containerField_ALLOWED_VALUES).contains(getContainerFieldOverride()))
		{
			String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE +
				": illegal value encountered, containerField='" + getContainerFieldOverride() +
				"' but allowed values are containerField_ALLOWED_VALUES='" +
				new MFString(containerField_ALLOWED_VALUES).toStringX3D() + "'.";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
		}

		// profile validation test, if connected to full scene
		if (findAncestorX3D() != null)
		{
			String     modelProfile = findAncestorX3D().getProfile();

			// check whether model has a satisfactory profile for this node
			boolean hasSatisfactorySupport = findAncestorX3D().supportsX3dProfile   (modelProfile) ||
                                             findAncestorX3D().supportsX3dComponent (COMPONENT, LEVEL);

			if (!hasSatisfactorySupport)
			{
				String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE +
					" insufficient X3D profile='" + modelProfile +
					"' for current X3D model containing 'WaveShaper' node, ensure sufficient support by adding head statement <component name='Sound' level='2'/>\n" +
					"or Java source-code assignment: " +
					" findAncestorX3D().getHead().addComponent(\"Sound\").setLevel(2);";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
			}
		}
		return validationResult.toString();
	}
}
