/*
Web3D Consortium Open-Source License for Models and Software

Copyright (c) 1995-2025 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.jsail.Sound;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
import org.web3d.x3d.jsail.fields.*; // making sure #4
// import org.web3d.x3d.jsail.Sound.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
// import org.web3d.x3d.jsail.Sound.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
import java.util.Arrays;

/**
 * The SpatialSound node controls the 3D spatialization of sound playback by a child AudioClip or MovieTexture node.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>SpatialSound node tooltip</i>: [X3DSoundNode] The SpatialSound node controls the 3D spatialization of sound playback by a child AudioClip or MovieTexture node. Sound intensity includes stereo support, varying according to user location and view direction in the scene.
 * <ul>
 *  <li> <i>Hint:</i> if the audio source is stereo or multi-channel, channel separation is retained during playback. </li> 
 *  <li> <i>Warning:</i> while providing sounds on the ground plane, ensure that the audible auralization volume is sufficiently elevated to match avatar height. </li> 
 *  <li> <i>Hint:</i> X3D Sound component Figure 16.2 Sound Node Geometry, <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-Soundnodegeometry" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-Soundnodegeometry</a> </li> 
 *  <li> <i>Hint:</i> W3C Web Audio API, PannerNode Interface <a href="https://www.w3.org/TR/webaudio/#pannernode" target="_blank">https://www.w3.org/TR/webaudio/#pannernode</a> </li> 
 *  <li> <i>Hint:</i> X3D Scene Authoring Hints:Audio <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Audio" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Audio</a> </li> 
 *  <li> <i>Hint:</i>  Wikipedia 3D sound localization <a href="https://en.wikipedia.org/wiki/3D_sound_localization" target="_blank">https://en.wikipedia.org/wiki/3D_sound_localization</a> </li> 
 * </ul>
 * <br>
 * <i>Package hint:</i>  This org.web3d.x3d.jsail concrete class is used for implementing a standalone X3D object as a <a href="https://en.wikipedia.org/wiki/Plain_old_Java_object" target="_blank">Plain Old Java Object (POJO)</a>.
 * If you are writing Java code for use inside an X3D Script node, compile separate code using only the <i>org.web3d.x3d.sai</i> package instead.
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#Sound" target="blank">X3D Abstract Specification: SpatialSound</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#SpatialSound" target="_blank">X3D Tooltips: SpatialSound</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public class SpatialSound extends org.web3d.x3d.jsail.X3DConcreteNode implements org.web3d.x3d.sai.Sound.SpatialSound
{
    // Member value declarations are encapsulated and private, using preferred Java types for concretes library

    /* @name=children, @type=MFNode, $javaType=ArrayList<org.web3d.x3d.sai.Core.X3DNode>, $javaReferenceType=org.web3d.x3d.sai.Core.X3DNode, $javaPrimitiveType=ArrayList<org.web3d.x3d.sai.Core.X3DNode>, $normalizedMemberObjectName=children, $isX3dStatement=false, @acceptableNodeTypes=Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper */ 
    private ArrayList<org.web3d.x3d.sai.Core.X3DNode> children = new ArrayList<>(); //  X3D field type: MFNode acceptable node types: Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper or ProtoInstance

    /* @name=coneInnerAngle, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=coneInnerAngle, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float coneInnerAngle; //  X3D field type: SFFloat

    /* @name=coneOuterAngle, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=coneOuterAngle, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float coneOuterAngle; //  X3D field type: SFFloat

    /* @name=coneOuterGain, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=coneOuterGain, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float coneOuterGain; //  X3D field type: SFFloat

    /* @name=description, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=description, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String description = new String(); //  X3D field type: SFString

    /* @name=direction, @type=SFVec3f, $javaType=float[], $javaReferenceType=float[], $javaPrimitiveType=float[], $normalizedMemberObjectName=direction, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float[] direction; //  X3D field type: SFVec3f

    /* @name=distanceModel, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=distanceModel, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String distanceModel = new String(); //  X3D field type: SFString

    /* @name=dopplerEnabled, @type=SFBool, $javaType=boolean, $javaReferenceType=boolean, $javaPrimitiveType=boolean, $normalizedMemberObjectName=dopplerEnabled, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private boolean dopplerEnabled; //  X3D field type: SFBool

    /* @name=enabled, @type=SFBool, $javaType=boolean, $javaReferenceType=boolean, $javaPrimitiveType=boolean, $normalizedMemberObjectName=enabled, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private boolean enabled; //  X3D field type: SFBool

    /* @name=enableHRTF, @type=SFBool, $javaType=boolean, $javaReferenceType=boolean, $javaPrimitiveType=boolean, $normalizedMemberObjectName=enableHRTF, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private boolean enableHRTF; //  X3D field type: SFBool

    /* @name=gain, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=gain, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float gain; //  X3D field type: SFFloat

    /* @name=intensity, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=intensity, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float intensity; //  X3D field type: SFFloat

    /* @name=IS, @type=SFNode, $javaType=IS, $javaReferenceType=IS, $javaPrimitiveType=IS, $normalizedMemberObjectName=IS, $isX3dStatement=true, @acceptableNodeTypes=IS */ 
    private IS IS; //  X3D field type: SFNode acceptable node types: IS

    /* @name=location, @type=SFVec3f, $javaType=float[], $javaReferenceType=float[], $javaPrimitiveType=float[], $normalizedMemberObjectName=location, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float[] location; //  X3D field type: SFVec3f

    /* @name=maxDistance, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=maxDistance, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float maxDistance; //  X3D field type: SFFloat

    /* @name=metadata, @type=SFNode, $javaType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaReferenceType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaPrimitiveType= org.web3d.x3d.sai.Core.X3DMetadataObject, $normalizedMemberObjectName=metadata, $isX3dStatement=false, @acceptableNodeTypes=X3DMetadataObject */ 
    private  org.web3d.x3d.sai.Core.X3DMetadataObject metadata; //  X3D field type: SFNode acceptable node types: X3DMetadataObject or ProtoInstance
	private ProtoInstance metadataProtoInstance; // allowed alternative for metadata field

    /* @name=priority, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=priority, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float priority; //  X3D field type: SFFloat

    /* @name=referenceDistance, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=referenceDistance, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float referenceDistance; //  X3D field type: SFFloat

    /* @name=rolloffFactor, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=rolloffFactor, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float rolloffFactor; //  X3D field type: SFFloat

    /* @name=spatialize, @type=SFBool, $javaType=boolean, $javaReferenceType=boolean, $javaPrimitiveType=boolean, $normalizedMemberObjectName=spatialize, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private boolean spatialize; //  X3D field type: SFBool

	// ==== String constants for enumeration values ensure correct syntax and avoid run-time errors ====

	/** Reduce excessive warning information for this attribute. */ 
	static boolean distanceModelWarningAlreadyProvided = false;

	/** 
	 * <i>Tooltip:</i> X3D version of "linear" in Web Audio API.
	 * SFString field named <i>distanceModel</i> with X3DUOM simpleType <i>distanceModelChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"LINEAR"</i> (Java syntax) or <i>LINEAR</i> (XML syntax).
	 * @see #DISTANCEMODEL_LINEAR_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_distanceModelChoices.html">XML Schema: distanceModelChoices</a>
	 * @see  <a href="https://www.w3.org/TR/webaudio/#enumdef-distancemodeltype" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-distancemodeltype</a>  */
	public static final String DISTANCEMODEL_LINEAR = "LINEAR";
	/** SFString SFString enumeration value "<i>LINEAR</i>" has alias "<i>linear</i>"
	 * @see #DISTANCEMODEL_LINEAR */
	public static final String DISTANCEMODEL_LINEAR_ALIAS = "linear";

	/** 
	 * <i>Tooltip:</i> X3D version of "inverse" in Web Audio API.
	 * SFString field named <i>distanceModel</i> with X3DUOM simpleType <i>distanceModelChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"INVERSE"</i> (Java syntax) or <i>INVERSE</i> (XML syntax).
	 * @see #DISTANCEMODEL_INVERSE_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_distanceModelChoices.html">XML Schema: distanceModelChoices</a>
	 * @see  <a href="https://www.w3.org/TR/webaudio/#enumdef-distancemodeltype" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-distancemodeltype</a>  */
	public static final String DISTANCEMODEL_INVERSE = "INVERSE";
	/** SFString SFString enumeration value "<i>INVERSE</i>" has alias "<i>inverse</i>"
	 * @see #DISTANCEMODEL_INVERSE */
	public static final String DISTANCEMODEL_INVERSE_ALIAS = "inverse";

	/** 
	 * <i>Tooltip:</i> X3D version of "exponential" in Web Audio API.
	 * SFString field named <i>distanceModel</i> with X3DUOM simpleType <i>distanceModelChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"EXPONENTIAL"</i> (Java syntax) or <i>EXPONENTIAL</i> (XML syntax).
	 * @see #DISTANCEMODEL_EXPONENTIAL_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_distanceModelChoices.html">XML Schema: distanceModelChoices</a>
	 * @see  <a href="https://www.w3.org/TR/webaudio/#enumdef-distancemodeltype" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-distancemodeltype</a>  */
	public static final String DISTANCEMODEL_EXPONENTIAL = "EXPONENTIAL";
	/** SFString SFString enumeration value "<i>EXPONENTIAL</i>" has alias "<i>exponential</i>"
	 * @see #DISTANCEMODEL_EXPONENTIAL */
	public static final String DISTANCEMODEL_EXPONENTIAL_ALIAS = "exponential";

	// special enumeration utility methods

	/** Get alias for this distanceModel
	 * @param distanceModelValue of interest
	 * @return alias value, otherwise empty string if not found
	 */
	public static String getDistanceModelAlias(String distanceModelValue)
	{
		if      (distanceModelValue.equalsIgnoreCase(DISTANCEMODEL_LINEAR)) return DISTANCEMODEL_LINEAR_ALIAS;
		else if (distanceModelValue.equalsIgnoreCase(DISTANCEMODEL_INVERSE)) return DISTANCEMODEL_INVERSE_ALIAS;
		else if (distanceModelValue.equalsIgnoreCase(DISTANCEMODEL_EXPONENTIAL)) return DISTANCEMODEL_EXPONENTIAL_ALIAS;
		else return ""; // not found
	}
	/** Whether a alias exists for this distanceModel
	 * @param distanceModel of interest
	 * @return true if found
	 */
	public static boolean hasDistanceModelAlias(String distanceModel)
	{
		return !getDistanceModelAlias(distanceModel).isEmpty();
	}

	// String constants for default field values match X3D Schema definitions

	/** String constant <i>NAME</i> provides name of this element: <i>SpatialSound</i>. */
	@SuppressWarnings("FieldNameHidesFieldInSuperclass")
	public static final String NAME = "SpatialSound";

	/** Provides name of this element: <i>SpatialSound</i>
	 * @return name of this element
	 */
	@Override
	public final String getElementName()
	{
		return NAME;
	}

	/** String constant <i>COMPONENT</i> defines X3D component for the <i>SpatialSound</i> element: <i>Sound</i> */
	public static final String COMPONENT = "Sound";

	/** Defines X3D component for the <i>SpatialSound</i> element: <i>Sound</i>
	 * @return X3D component for this element
	 */
	/* @Override */
	public final String getComponent()
	{
		return COMPONENT;
	}

	/** Integer constant <i>LEVEL</i> provides default X3D <i>Sound</i> component level for this element: <i>2</i> */
	public static final int LEVEL = 2;

	/** Provides default X3D component level for this element: <i>2</i>
	 * @return default X3D component level for this element
	 */
	/* @Override */
	public final int getComponentLevel()
	{
		return LEVEL;
	}

            // DEFAULT_VALUE declarations

	/** SFFloat field named <i>coneInnerAngle</i> has default value <i>6.2832f</i> (Java syntax) or <i>6.2832</i> (XML syntax). */
	public static final float CONEINNERANGLE_DEFAULT_VALUE = 6.2832f;

	/** SFFloat field named <i>coneOuterAngle</i> has default value <i>6.2832f</i> (Java syntax) or <i>6.2832</i> (XML syntax). */
	public static final float CONEOUTERANGLE_DEFAULT_VALUE = 6.2832f;

	/** SFFloat field named <i>coneOuterGain</i> has default value <i>0f</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final float CONEOUTERGAIN_DEFAULT_VALUE = 0f;

	/** SFString field named <i>description</i> has default value equal to an empty string. */
	public static final String DESCRIPTION_DEFAULT_VALUE = "";

	/** SFVec3f field named <i>direction</i> has default value <i>{0f,0f,1f}</i> (Java syntax) or <i>0 0 1</i> (XML syntax). */
	public static final float[] DIRECTION_DEFAULT_VALUE = {0f,0f,1f};

	/** SFString field named <i>distanceModel</i> has default value <i>"INVERSE"</i> (Java syntax) or <i>INVERSE</i> (XML syntax). */
	public static final String DISTANCEMODEL_DEFAULT_VALUE = "INVERSE";

	/** SFBool field named <i>dopplerEnabled</i> has default value <i>false</i> (Java syntax) or <i>false</i> (XML syntax). */
	public static final boolean DOPPLERENABLED_DEFAULT_VALUE = false;

	/** SFBool field named <i>enabled</i> has default value <i>true</i> (Java syntax) or <i>true</i> (XML syntax). */
	public static final boolean ENABLED_DEFAULT_VALUE = true;

	/** SFBool field named <i>enableHRTF</i> has default value <i>false</i> (Java syntax) or <i>false</i> (XML syntax). */
	public static final boolean ENABLEHRTF_DEFAULT_VALUE = false;

	/** SFFloat field named <i>gain</i> has default value <i>1f</i> (Java syntax) or <i>1</i> (XML syntax). */
	public static final float GAIN_DEFAULT_VALUE = 1f;

	/** SFFloat field named <i>intensity</i> has default value <i>1f</i> (Java syntax) or <i>1</i> (XML syntax). */
	public static final float INTENSITY_DEFAULT_VALUE = 1f;

	/** SFNode field named <i>IS</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final IS IS_DEFAULT_VALUE = null;

	/** SFVec3f field named <i>location</i> has default value <i>{0f,0f,0f}</i> (Java syntax) or <i>0 0 0</i> (XML syntax). */
	public static final float[] LOCATION_DEFAULT_VALUE = {0f,0f,0f};

	/** SFFloat field named <i>maxDistance</i> has default value <i>10000f</i> (Java syntax) or <i>10000</i> (XML syntax). */
	public static final float MAXDISTANCE_DEFAULT_VALUE = 10000f;

	/** SFNode field named <i>metadata</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Core.X3DMetadataObject METADATA_DEFAULT_VALUE = null;

	/** SFFloat field named <i>priority</i> has default value <i>0f</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final float PRIORITY_DEFAULT_VALUE = 0f;

	/** SFFloat field named <i>referenceDistance</i> has default value <i>1f</i> (Java syntax) or <i>1</i> (XML syntax). */
	public static final float REFERENCEDISTANCE_DEFAULT_VALUE = 1f;

	/** SFFloat field named <i>rolloffFactor</i> has default value <i>1f</i> (Java syntax) or <i>1</i> (XML syntax). */
	public static final float ROLLOFFFACTOR_DEFAULT_VALUE = 1f;

	/** SFBool field named <i>spatialize</i> has default value <i>true</i> (Java syntax) or <i>true</i> (XML syntax). */
	public static final boolean SPATIALIZE_DEFAULT_VALUE = true;

	/** Indicate type corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_TYPE
	 * @return X3D type (SFvec3f etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE if not recognized
	 */
	/* @Override */
	public String getFieldType(String fieldName)
	{
		String result;

		switch (fieldName)
		{
			// String constants for exact field type values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing type-matching checks

			case "containerField":
				result = "SFString";
				break;
			case "children":
				result = "MFNode";
				break;
			case "coneInnerAngle":
				result = "SFFloat";
				break;
			case "coneOuterAngle":
				result = "SFFloat";
				break;
			case "coneOuterGain":
				result = "SFFloat";
				break;
			case "description":
				result = "SFString";
				break;
			case "direction":
				result = "SFVec3f";
				break;
			case "distanceModel":
				result = "SFString";
				break;
			case "dopplerEnabled":
				result = "SFBool";
				break;
			case "enabled":
				result = "SFBool";
				break;
			case "enableHRTF":
				result = "SFBool";
				break;
			case "gain":
				result = "SFFloat";
				break;
			case "intensity":
				result = "SFFloat";
				break;
			case "IS":
				result = "SFNode";
				break;
			case "location":
				result = "SFVec3f";
				break;
			case "maxDistance":
				result = "SFFloat";
				break;
			case "metadata":
				result = "SFNode";
				break;
			case "priority":
				result = "SFFloat";
				break;
			case "referenceDistance":
				result = "SFFloat";
				break;
			case "rolloffFactor":
				result = "SFFloat";
				break;
			case "spatialize":
				result = "SFBool";
				break;
			case "DEF":
				result = "SFString";
				break;
			case "USE":
				result = "SFString";
				break;
			case "class":
				result = "SFString";
				break;
			case "id":
				result = "SFString";
				break;
			case "style":
				result = "SFString";
				break;
			default:
			{
				// if fieldName has a prefix "set_" prepended (or a suffix "_changed" appended) then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getFieldType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/** Indicate accessType corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_ACCESSTYPE
	 * @return X3D accessType (inputOnly etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE if not recognized
	 */
	/* @Override */
	public String getAccessType(String fieldName)
	{
		String result; // set by following checks
		switch (fieldName)
		{
			// String constants for field accessType values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing accessType-matching checks
			case "children":
				result = "inputOutput";
				break;
			case "coneInnerAngle":
				result = "inputOutput";
				break;
			case "coneOuterAngle":
				result = "inputOutput";
				break;
			case "coneOuterGain":
				result = "inputOutput";
				break;
			case "description":
				result = "inputOutput";
				break;
			case "direction":
				result = "inputOutput";
				break;
			case "distanceModel":
				result = "inputOutput";
				break;
			case "dopplerEnabled":
				result = "inputOutput";
				break;
			case "enabled":
				result = "inputOutput";
				break;
			case "enableHRTF":
				result = "inputOutput";
				break;
			case "gain":
				result = "inputOutput";
				break;
			case "intensity":
				result = "inputOutput";
				break;
			case "IS":
				result = "inputOutput";
				break;
			case "location":
				result = "inputOutput";
				break;
			case "maxDistance":
				result = "inputOutput";
				break;
			case "metadata":
				result = "inputOutput";
				break;
			case "priority":
				result = "inputOutput";
				break;
			case "referenceDistance":
				result = "inputOutput";
				break;
			case "rolloffFactor":
				result = "inputOutput";
				break;
			case "spatialize":
				result = "initializeOnly";
				break;
			case "DEF":
				result = "inputOutput";
				break;
			case "USE":
				result = "inputOutput";
				break;
			case "class":
				result = "inputOutput";
				break;
			case "id":
				result = "inputOutput";
				break;
			case "style":
				result = "inputOutput";
				break;
			default:
			{
				// if user has added a prefix "set_" or suffix "_changed" then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getAccessType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/**
         * containerField describes typical field relationship of a node to its parent.
	 * Usage is not ordinarily needed when using this API, this default value is provided for informational purposes only.
         * <br />
         * containerField_DEFAULT_VALUE = "children";
         * <br />
         * containerField_ALLOWED_VALUES = {"children" };  type xs:NMTOKEN
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField" target="_blank">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerFieldChoices" target="_blank">X3D Scene Authoring Hints: validation choices for containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html" target="_blank">X3D Unified Object Model (X3DUOM)</a>
	 */

	public static final String containerField_DEFAULT_VALUE = "children"; // type xs:NMTOKEN
	/**
         * containerField describes typical field relationship of a node to its parent.
	 * Programmer usage is not ordinarily needed when using this API, since this default value is provided for informational purposes only.
	 * @see #containerField_DEFAULT_VALUE
         * @see org.web3d.x3d.jsail.X3DConcreteNode#containerField_ALLOWED_VALUES
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField" target="_blank">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerFieldChoices" target="_blank">X3D Scene Authoring Hints: validation choices for containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html" target="_blank">X3D Unified Object Model (X3DUOM)</a>
         * @return default containerField value
	 */
        @Override
        public final String getContainerFieldDefault()
        {
            return containerField_DEFAULT_VALUE;
        }

	// String constants for field names usable in ROUTE statements

	/** fromField ROUTE name for MFNode field named <i>children</i>. */
	public static final String fromField_CHILDREN = "children";

	/** toField ROUTE name for MFNode field named <i>children</i>. */
	public static final String toField_CHILDREN = "children";

	/** fromField ROUTE name for SFFloat field named <i>coneInnerAngle</i>. */
	public static final String fromField_CONEINNERANGLE = "coneInnerAngle";

	/** toField ROUTE name for SFFloat field named <i>coneInnerAngle</i>. */
	public static final String toField_CONEINNERANGLE = "coneInnerAngle";

	/** fromField ROUTE name for SFFloat field named <i>coneOuterAngle</i>. */
	public static final String fromField_CONEOUTERANGLE = "coneOuterAngle";

	/** toField ROUTE name for SFFloat field named <i>coneOuterAngle</i>. */
	public static final String toField_CONEOUTERANGLE = "coneOuterAngle";

	/** fromField ROUTE name for SFFloat field named <i>coneOuterGain</i>. */
	public static final String fromField_CONEOUTERGAIN = "coneOuterGain";

	/** toField ROUTE name for SFFloat field named <i>coneOuterGain</i>. */
	public static final String toField_CONEOUTERGAIN = "coneOuterGain";

	/** fromField ROUTE name for SFString field named <i>description</i>. */
	public static final String fromField_DESCRIPTION = "description";

	/** toField ROUTE name for SFString field named <i>description</i>. */
	public static final String toField_DESCRIPTION = "description";

	/** fromField ROUTE name for SFVec3f field named <i>direction</i>. */
	public static final String fromField_DIRECTION = "direction";

	/** toField ROUTE name for SFVec3f field named <i>direction</i>. */
	public static final String toField_DIRECTION = "direction";

	/** fromField ROUTE name for SFString field named <i>distanceModel</i>. */
	public static final String fromField_DISTANCEMODEL = "distanceModel";

	/** toField ROUTE name for SFString field named <i>distanceModel</i>. */
	public static final String toField_DISTANCEMODEL = "distanceModel";

	/** fromField ROUTE name for SFBool field named <i>dopplerEnabled</i>. */
	public static final String fromField_DOPPLERENABLED = "dopplerEnabled";

	/** toField ROUTE name for SFBool field named <i>dopplerEnabled</i>. */
	public static final String toField_DOPPLERENABLED = "dopplerEnabled";

	/** fromField ROUTE name for SFBool field named <i>enabled</i>. */
	public static final String fromField_ENABLED = "enabled";

	/** toField ROUTE name for SFBool field named <i>enabled</i>. */
	public static final String toField_ENABLED = "enabled";

	/** fromField ROUTE name for SFBool field named <i>enableHRTF</i>. */
	public static final String fromField_ENABLEHRTF = "enableHRTF";

	/** toField ROUTE name for SFBool field named <i>enableHRTF</i>. */
	public static final String toField_ENABLEHRTF = "enableHRTF";

	/** fromField ROUTE name for SFFloat field named <i>gain</i>. */
	public static final String fromField_GAIN = "gain";

	/** toField ROUTE name for SFFloat field named <i>gain</i>. */
	public static final String toField_GAIN = "gain";

	/** fromField ROUTE name for SFFloat field named <i>intensity</i>. */
	public static final String fromField_INTENSITY = "intensity";

	/** toField ROUTE name for SFFloat field named <i>intensity</i>. */
	public static final String toField_INTENSITY = "intensity";

	/** fromField ROUTE name for SFNode field named <i>IS</i>. */
	public static final String fromField_IS = "IS";

	/** fromField ROUTE name for SFVec3f field named <i>location</i>. */
	public static final String fromField_LOCATION = "location";

	/** toField ROUTE name for SFVec3f field named <i>location</i>. */
	public static final String toField_LOCATION = "location";

	/** fromField ROUTE name for SFFloat field named <i>maxDistance</i>. */
	public static final String fromField_MAXDISTANCE = "maxDistance";

	/** toField ROUTE name for SFFloat field named <i>maxDistance</i>. */
	public static final String toField_MAXDISTANCE = "maxDistance";

	/** fromField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String fromField_METADATA = "metadata";

	/** toField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String toField_METADATA = "metadata";

	/** fromField ROUTE name for SFFloat field named <i>priority</i>. */
	public static final String fromField_PRIORITY = "priority";

	/** toField ROUTE name for SFFloat field named <i>priority</i>. */
	public static final String toField_PRIORITY = "priority";

	/** fromField ROUTE name for SFFloat field named <i>referenceDistance</i>. */
	public static final String fromField_REFERENCEDISTANCE = "referenceDistance";

	/** toField ROUTE name for SFFloat field named <i>referenceDistance</i>. */
	public static final String toField_REFERENCEDISTANCE = "referenceDistance";

	/** fromField ROUTE name for SFFloat field named <i>rolloffFactor</i>. */
	public static final String fromField_ROLLOFFFACTOR = "rolloffFactor";

	/** toField ROUTE name for SFFloat field named <i>rolloffFactor</i>. */
	public static final String toField_ROLLOFFFACTOR = "rolloffFactor";

	/** Constructor for SpatialSound to initialize member variables with default values. */
	public SpatialSound()
	{
		super(); // constructor invocation and corresponding initialize()
		initialize();
	}

	/** Initialize all member variables to default values. */
	@Override
	public final void initialize()
	{
		super.initialize();

        setContainerFieldOverride(""); // ensuring default value used
	containerField_ALLOWED_VALUES = new String[] { "children" }; // type xs:NMTOKEN

		children = new ArrayList<>();
		coneInnerAngle = CONEINNERANGLE_DEFAULT_VALUE;
		coneOuterAngle = CONEOUTERANGLE_DEFAULT_VALUE;
		coneOuterGain = CONEOUTERGAIN_DEFAULT_VALUE;
		description = DESCRIPTION_DEFAULT_VALUE;
		direction = DIRECTION_DEFAULT_VALUE;
		distanceModel = DISTANCEMODEL_DEFAULT_VALUE;
		dopplerEnabled = DOPPLERENABLED_DEFAULT_VALUE;
		enabled = ENABLED_DEFAULT_VALUE;
		enableHRTF = ENABLEHRTF_DEFAULT_VALUE;
		gain = GAIN_DEFAULT_VALUE;
		intensity = INTENSITY_DEFAULT_VALUE;
		IS = null; // clear out any prior node
		location = LOCATION_DEFAULT_VALUE;
		maxDistance = MAXDISTANCE_DEFAULT_VALUE;
		metadata = null;              // clear out any prior node
		metadataProtoInstance = null; // clear out any prior node
		priority = PRIORITY_DEFAULT_VALUE;
		referenceDistance = REFERENCEDISTANCE_DEFAULT_VALUE;
		rolloffFactor = ROLLOFFFACTOR_DEFAULT_VALUE;
		spatialize = SPATIALIZE_DEFAULT_VALUE;
	}

	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide array of org.web3d.x3d.sai.Core.X3DNode results (using an array consisting of properly typed nodes or ProtoInstances) with acceptable node types limited to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper, from inputOutput MFNode field <i>children</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSoundChannelNode|X3DSoundProcessingNode|X3DSoundSourceNode] The children field specifies audio-graph sound sources providing input signals for this node. If multiple input signals are provided by the inputs children field, all channels are mixed together and merged prior to presentation.
 * <ul>
 *  <li> <i>Warning:</i> contained AudioClip or MovieTexture nodes must have containerField='children' to override otherwise-incorrect defaults. </li> 
 *  <li> <i>Hint:</i>  can be original (DEF) or referenced (USE) nodes. </li> 
 * </ul>
	 * <br><br>
	 * <i>Warning:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper.
	 * @see org.web3d.x3d.jsail.Sound.Analyser
	 * @see org.web3d.x3d.jsail.Sound.AudioClip
	 * @see org.web3d.x3d.jsail.Sound.AudioDestination
	 * @see org.web3d.x3d.jsail.Sound.BiquadFilter
	 * @see org.web3d.x3d.jsail.Sound.BufferAudioSource
	 * @see org.web3d.x3d.jsail.Sound.ChannelMerger
	 * @see org.web3d.x3d.jsail.Sound.ChannelSelector
	 * @see org.web3d.x3d.jsail.Sound.ChannelSplitter
	 * @see org.web3d.x3d.jsail.Sound.Convolver
	 * @see org.web3d.x3d.jsail.Sound.Delay
	 * @see org.web3d.x3d.jsail.Sound.DynamicsCompressor
	 * @see org.web3d.x3d.jsail.Sound.Gain
	 * @see org.web3d.x3d.jsail.Sound.ListenerPointSource
	 * @see org.web3d.x3d.jsail.Sound.MicrophoneSource
	 * @see org.web3d.x3d.jsail.Texturing.MovieTexture
	 * @see org.web3d.x3d.jsail.Sound.OscillatorSource
	 * @see org.web3d.x3d.jsail.Sound.Sound
	 * @see org.web3d.x3d.jsail.Sound.SpatialSound
	 * @see org.web3d.x3d.jsail.Sound.StreamAudioDestination
	 * @see org.web3d.x3d.jsail.Sound.StreamAudioSource
	 * @see org.web3d.x3d.jsail.Sound.WaveShaper
	 * @return value of children field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Children, $memberObjectName=children, $memberObjectName=children)

	public org.web3d.x3d.sai.Core.X3DNode[] getChildren()
	{
		final org.web3d.x3d.sai.Core.X3DNode[] valuesArray = new org.web3d.x3d.sai.Core.X3DNode[children.size()];
		int i = 0;
		for (org.web3d.x3d.sai.Core.X3DNode arrayElement : children) {
			valuesArray[i++] = arrayElement;
		}
		return valuesArray;
	}
	/**
	 * Utility method to get ArrayList value of MFNode children field, similar to {@link #getChildren()}.
	 * @return value of children field
	 */
	public ArrayList<org.web3d.x3d.sai.Core.X3DNode> getChildrenList()
	{
		return children;
	}

	/**
	 * Accessor method to assign org.web3d.x3d.sai.Core.X3DNode array (using an array consisting of properly typed nodes or ProtoInstances) to inputOutput MFNode field <i>children</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSoundChannelNode|X3DSoundProcessingNode|X3DSoundSourceNode] The children field specifies audio-graph sound sources providing input signals for this node. If multiple input signals are provided by the inputs children field, all channels are mixed together and merged prior to presentation.
 * <ul>
 *  <li> <i>Warning:</i> contained AudioClip or MovieTexture nodes must have containerField='children' to override otherwise-incorrect defaults. </li> 
 *  <li> <i>Hint:</i>  can be original (DEF) or referenced (USE) nodes. </li> 
 * </ul>
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper.
	 * @param newValue is new value for the children field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setChildren(org.web3d.x3d.sai.Core.X3DNode[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)			// reset value field to empty array
		{
			clearChildren(); // newValueNullSetDEFAULT_VALUE
			return this;
		}

		// newValueArrayAcceptableNodeTypesTest checks are needed for methods that override/subset X3DNode interfaces #2
		for (int i = 0; i < newValue.length; i++)
		{
			boolean isNodeTypeAllowed = 
				(newValue[i] instanceof org.web3d.x3d.jsail.Core.CommentsBlock) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Core.ROUTE) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Networking.IMPORT) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Networking.EXPORT) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Core.ProtoDeclare) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Core.ExternProtoDeclare) ||
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Analyser) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.AudioClip) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.AudioDestination) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.BiquadFilter) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.BufferAudioSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.ChannelMerger) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.ChannelSelector) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.ChannelSplitter) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Convolver) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Delay) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.DynamicsCompressor) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Gain) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.ListenerPointSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.MicrophoneSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Texturing.MovieTexture) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.OscillatorSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Sound) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.SpatialSound) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.StreamAudioDestination) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.StreamAudioSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.WaveShaper);
			if  (!isNodeTypeAllowed)
			{
				throw new org.web3d.x3d.sai.InvalidFieldValueException("X3DNode[] newValue["+i+"] is not instanceof " +
					"acceptableNodeTypes Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper; newValue["+i+"]=" + newValue[i]);
			}
		}
		clearChildren(); // reset
		for (int i = 0; i < newValue.length; i++)
		{
			if  ((newValue[i] instanceof org.web3d.x3d.sai.Core.X3DNode) || (newValue[i] instanceof ProtoInstance))
			{
				children.add((org.web3d.x3d.sai.Core.X3DNode)newValue[i]);
				((X3DConcreteElement) newValue[i]).setParent(this); // parentTest12
			}
			else throw new org.web3d.x3d.sai.InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue["+i+"] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance array newValue=" + Arrays.toString(newValue));
		}
		return this;
	}

	/**
	 * Assign ArrayList value of MFNode children field, similar to {@link #setChildren(org.web3d.x3d.sai.Core.X3DNode[])}.
	 * @param newValue is new value for the children field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setChildren(ArrayList<org.web3d.x3d.sai.Core.X3DNode> newValue)
	{
		if (newValue == null)			// reset value field to empty array
		{
			clearChildren(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		// set-newValue-validity-checks #4

		// newValueArrayListAcceptableNodeTypesTest checks are needed for methods that override/subset X3DNode interfaces #3
		for (org.web3d.x3d.sai.Core.X3DNode element : newValue)
		{
			boolean isNodeTypeAllowed = 
				(element instanceof org.web3d.x3d.jsail.Core.CommentsBlock) ||
				(element instanceof org.web3d.x3d.jsail.Core.ROUTE) ||
				(element instanceof org.web3d.x3d.jsail.Networking.IMPORT) ||
				(element instanceof org.web3d.x3d.jsail.Networking.EXPORT) ||
				(element instanceof org.web3d.x3d.jsail.Core.ProtoDeclare) ||
				(element instanceof org.web3d.x3d.jsail.Core.ExternProtoDeclare) ||
				(element instanceof org.web3d.x3d.jsail.Sound.Analyser) || 
				(element instanceof org.web3d.x3d.jsail.Sound.AudioClip) || 
				(element instanceof org.web3d.x3d.jsail.Sound.AudioDestination) || 
				(element instanceof org.web3d.x3d.jsail.Sound.BiquadFilter) || 
				(element instanceof org.web3d.x3d.jsail.Sound.BufferAudioSource) || 
				(element instanceof org.web3d.x3d.jsail.Sound.ChannelMerger) || 
				(element instanceof org.web3d.x3d.jsail.Sound.ChannelSelector) || 
				(element instanceof org.web3d.x3d.jsail.Sound.ChannelSplitter) || 
				(element instanceof org.web3d.x3d.jsail.Sound.Convolver) || 
				(element instanceof org.web3d.x3d.jsail.Sound.Delay) || 
				(element instanceof org.web3d.x3d.jsail.Sound.DynamicsCompressor) || 
				(element instanceof org.web3d.x3d.jsail.Sound.Gain) || 
				(element instanceof org.web3d.x3d.jsail.Sound.ListenerPointSource) || 
				(element instanceof org.web3d.x3d.jsail.Sound.MicrophoneSource) || 
				(element instanceof org.web3d.x3d.jsail.Texturing.MovieTexture) || 
				(element instanceof org.web3d.x3d.jsail.Sound.OscillatorSource) || 
				(element instanceof org.web3d.x3d.jsail.Sound.Sound) || 
				(element instanceof org.web3d.x3d.jsail.Sound.SpatialSound) || 
				(element instanceof org.web3d.x3d.jsail.Sound.StreamAudioDestination) || 
				(element instanceof org.web3d.x3d.jsail.Sound.StreamAudioSource) || 
				(element instanceof org.web3d.x3d.jsail.Sound.WaveShaper);
			if  (!isNodeTypeAllowed)
			{
				throw new org.web3d.x3d.sai.InvalidFieldValueException("X3DNode[] element is not instanceof " +
					"acceptableNodeTypes Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper; element=" + element);
			}
		}
        if (newValue.isEmpty())
            clearChildren(); // reset
        else
        {
            org.web3d.x3d.sai.Core.X3DNode[] newArray = new org.web3d.x3d.sai.Core.X3DNode[newValue.size()];
            for (int i = 0; i < newValue.size(); i++)
                newArray[i] = newValue.get(i);
            setChildren(newArray);
        }
		for (org.web3d.x3d.sai.Core.X3DNode element : newValue)
		{
			children.add(element);
			((X3DConcreteElement) element).setParent(this); // parentTest13
		}
		return this;
	}
	/**
	 * Add single node to existing array of children nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper and ProtoInstance.
	 * @param newValue is new value to be appended the children field.	 */
	public void addChildren(org.web3d.x3d.sai.Core.X3DNode newValue)
	{
		if (newValue == null) return; // newValueNullReturnSelf

		// newValueInstanceAcceptableNodeTypesTest checks are needed for methods that override/subset X3DNode interfaces #1
		boolean isNodeTypeAllowed =
				(newValue instanceof org.web3d.x3d.jsail.Core.CommentsBlock) ||
				(newValue instanceof org.web3d.x3d.jsail.Core.ROUTE) ||
				(newValue instanceof org.web3d.x3d.jsail.Networking.IMPORT) ||
				(newValue instanceof org.web3d.x3d.jsail.Networking.EXPORT) ||
				(newValue instanceof org.web3d.x3d.jsail.Core.ProtoDeclare) ||
				(newValue instanceof org.web3d.x3d.jsail.Core.ExternProtoDeclare) ||
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Analyser) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.AudioClip) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.AudioDestination) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.BiquadFilter) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.BufferAudioSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ChannelMerger) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ChannelSelector) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ChannelSplitter) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Convolver) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Delay) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.DynamicsCompressor) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Gain) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ListenerPointSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.MicrophoneSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Texturing.MovieTexture) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.OscillatorSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Sound) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.SpatialSound) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.StreamAudioDestination) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.StreamAudioSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.WaveShaper);
		if  (!isNodeTypeAllowed)
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("X3DNode newValue is not instanceof " +
				"acceptableNodeTypes Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper; newValue=" + newValue);
		}
		children.add(newValue);
		((X3DConcreteElement) newValue).setParent(this); // parentTest2
	}
	/**
	 * Add single ProtoInstance (with appropriate node type and containerField value) to MFNode array for children field.
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to ShaderPart and ProtoInstance.
	 * @param newValue is new value to be appended the parts field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).	 */
	public SpatialSound addChildren(ProtoInstance newValue)
	{
		if (newValue == null) return this; // newValueNullReturnThis
		children.add(newValue);
		((X3DConcreteElement) newValue).setParent(this); // parentTest16
		return this;
	}

	/**
	 * Utility method to add single child element to contained list of existing children nodes (if any).
	 * @param newValue is new node value to be appended the children field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	*/
	public SpatialSound addChild(org.web3d.x3d.sai.Core.X3DChildNode newValue)
	{
		if (newValue == null) return this; // newValueNullReturnThis

		// newValueInstanceAcceptableNodeTypesTest checks are needed for methods that override/subset X3DNode interfaces #1
		boolean isNodeTypeAllowed =
				(newValue instanceof org.web3d.x3d.jsail.Core.CommentsBlock) ||
				(newValue instanceof org.web3d.x3d.jsail.Core.ROUTE) ||
				(newValue instanceof org.web3d.x3d.jsail.Networking.IMPORT) ||
				(newValue instanceof org.web3d.x3d.jsail.Networking.EXPORT) ||
				(newValue instanceof org.web3d.x3d.jsail.Core.ProtoDeclare) ||
				(newValue instanceof org.web3d.x3d.jsail.Core.ExternProtoDeclare) ||
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Analyser) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.AudioClip) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.AudioDestination) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.BiquadFilter) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.BufferAudioSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ChannelMerger) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ChannelSelector) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ChannelSplitter) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Convolver) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Delay) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.DynamicsCompressor) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Gain) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ListenerPointSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.MicrophoneSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Texturing.MovieTexture) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.OscillatorSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Sound) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.SpatialSound) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.StreamAudioDestination) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.StreamAudioSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.WaveShaper);
		if  (!isNodeTypeAllowed)
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("X3DNode newValue is not instanceof " +
				"acceptableNodeTypes Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper; newValue=" + newValue);
		}

		children.add((org.web3d.x3d.sai.Core.X3DNode)newValue);
		((X3DConcreteElement) newValue).setParent(this); // parentTest3
//      if  (newValue instanceof ProtoInstance)
//           ((ProtoInstance) newValue).setContainerField("children");

		return this;
	}
	/**
	 * Add array of children nodes to array of existing nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper.
	 * @param newValue is new value array to be appended the children field.
	 */
	public void addChildren(org.web3d.x3d.sai.Core.X3DNode[] newValue)
	{
		if (newValue == null) return; // newValueNullReturnSelf

		// newValueArrayAcceptableNodeTypesTest checks are needed for methods that override/subset X3DNode interfaces #2
		for (int i = 0; i < newValue.length; i++)
		{
			boolean isNodeTypeAllowed = 
				(newValue[i] instanceof org.web3d.x3d.jsail.Core.CommentsBlock) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Core.ROUTE) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Networking.IMPORT) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Networking.EXPORT) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Core.ProtoDeclare) ||
				(newValue[i] instanceof org.web3d.x3d.jsail.Core.ExternProtoDeclare) ||
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Analyser) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.AudioClip) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.AudioDestination) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.BiquadFilter) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.BufferAudioSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.ChannelMerger) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.ChannelSelector) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.ChannelSplitter) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Convolver) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Delay) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.DynamicsCompressor) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Gain) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.ListenerPointSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.MicrophoneSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Texturing.MovieTexture) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.OscillatorSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.Sound) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.SpatialSound) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.StreamAudioDestination) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.StreamAudioSource) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Sound.WaveShaper);
			if  (!isNodeTypeAllowed)
			{
				throw new org.web3d.x3d.sai.InvalidFieldValueException("X3DNode[] newValue["+i+"] is not instanceof " +
					"acceptableNodeTypes Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper; newValue["+i+"]=" + newValue[i]);
			}
		}
		for (int i = 0; i < newValue.length; i++)
		{
			if  ((newValue[i] instanceof org.web3d.x3d.sai.Core.X3DNode) || (newValue[i] instanceof ProtoInstance))
			{
				children.add(newValue[i]);
				((X3DConcreteElement) newValue[i]).setParent(this); // parentTest6
				if (newValue[i] instanceof ProtoInstance)
					((ProtoInstance) newValue[i]).setContainerField("children");
			}
			else throw new org.web3d.x3d.sai.InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue["+i+"] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance, array newValue=" + Arrays.toString(newValue));
		}
	}

	/**
	 * Set single children node, replacing prior array of existing nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are restricted to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper.
	 * @param newValue is new node for the children field (restricted to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper)
	 */
	/* @Override */
	public void setChildren(org.web3d.x3d.sai.Core.X3DNode newValue)
	{
		if (newValue == null)
		{
			clearChildren(); // reset newValueNullClearsFieldReturnVoid
			return;
		}

		// newValueInstanceAcceptableNodeTypesTest checks are needed for methods that override/subset X3DNode interfaces #1
		boolean isNodeTypeAllowed =
				(newValue instanceof org.web3d.x3d.jsail.Core.CommentsBlock) ||
				(newValue instanceof org.web3d.x3d.jsail.Core.ROUTE) ||
				(newValue instanceof org.web3d.x3d.jsail.Networking.IMPORT) ||
				(newValue instanceof org.web3d.x3d.jsail.Networking.EXPORT) ||
				(newValue instanceof org.web3d.x3d.jsail.Core.ProtoDeclare) ||
				(newValue instanceof org.web3d.x3d.jsail.Core.ExternProtoDeclare) ||
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Analyser) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.AudioClip) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.AudioDestination) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.BiquadFilter) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.BufferAudioSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ChannelMerger) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ChannelSelector) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ChannelSplitter) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Convolver) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Delay) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.DynamicsCompressor) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Gain) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.ListenerPointSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.MicrophoneSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Texturing.MovieTexture) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.OscillatorSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.Sound) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.SpatialSound) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.StreamAudioDestination) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.StreamAudioSource) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Sound.WaveShaper);
		if  (!isNodeTypeAllowed)
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("X3DNode newValue is not instanceof " +
				"acceptableNodeTypes Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper; newValue=" + newValue);
		}
		if  (newValue instanceof org.web3d.x3d.sai.Core.X3DNode)
		{
			for (org.web3d.x3d.sai.Core.X3DNode element : children)
				((X3DConcreteElement) element).clearParent(); // remove references to facilitate Java memory management
			clearChildren(); // reset
			((X3DConcreteElement) newValue).setParent(this); // parentTest8
			children.add(newValue);
		}
		else throw new org.web3d.x3d.sai.InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode newValue is not instanceof org.web3d.x3d.sai.Core.X3DNode; newValue=" + newValue);
}
	/**
	 * Utility method to clear MFNode value of children field.  This method does not initialize withCHILDREN_DEFAULT_VALUE.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	public SpatialSound clearChildren()
	{
		for (org.web3d.x3d.sai.Core.X3DNode element : children)
			((X3DConcreteElement) element).clearParent(); // remove references to facilitate Java memory management
		children.clear(); // reset MF field
		return this;
	}

	/**
	 * Indicate whether an object is available for inputOutput MFNode field <i>children</i>.
	 * @return whether a properly typed node or ProtoInstance array or CommentsBlock is available.
	 * @see #getChildren()
	 */
	public boolean hasChildren()
	{
		return (!children.isEmpty());
	}

	/**
	 * Add comment as CommentsBlock to children field
	 * @param newComment initial value
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public SpatialSound addComments (String newComment)
	{
		if (newComment == null) return this;
		children.add(new CommentsBlock (newComment));
		return this;
	}
	/**
	 * Add comments as String[] array to children field
	 * @param newComments array of comments
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public SpatialSound addComments (String[] newComments)
	{
		if (newComments == null) return this;
		children.add(new CommentsBlock (newComments));
		return this;
	}
	/**
	 * Add CommentsBlock to children field
	 * @param newCommentsBlock block of comments to add
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public SpatialSound addComments (CommentsBlock newCommentsBlock)
	{
		if (newCommentsBlock == null) return this;
		children.add(newCommentsBlock);
		return this;
	}
											/**
	 * Provide float value unit axis, angle (in radians) within allowed range of [0,6.2832] from inputOutput SFFloat field named <i>coneInnerAngle</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,2pi] coneInnerAngle is centered along direction and defines the inner conical volume, inside of which no source gain reduction occurs.
 * <ul>
 *  <li> <i>Hint:</i> coneOuterAngle value is greater than or equal to coneInnerAngle. </li> 
 *  <li> <i>Hint:</i>  X3D4 Architecture Figure 16.3, SpatialSound Panning Gain Relationships <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-AudioPannerListenerRelationships" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-AudioPannerListenerRelationships</a> </li> 
 * </ul>
	 * @return value of coneInnerAngle field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=ConeInnerAngle, $memberObjectName=coneInnerAngle, $memberObjectName=coneInnerAngle)

	public float getConeInnerAngle()
	{
		return coneInnerAngle;
	}

	/**
	 * Accessor method to assign float value unit axis, angle (in radians) to inputOutput SFFloat field named <i>coneInnerAngle</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,2pi] coneInnerAngle is centered along direction and defines the inner conical volume, inside of which no source gain reduction occurs.
 * <ul>
 *  <li> <i>Hint:</i> coneOuterAngle value is greater than or equal to coneInnerAngle. </li> 
 *  <li> <i>Hint:</i>  X3D4 Architecture Figure 16.3, SpatialSound Panning Gain Relationships <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-AudioPannerListenerRelationships" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-AudioPannerListenerRelationships</a> </li> 
 * </ul>
	 * @param newValue is new value for the coneInnerAngle field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setConeInnerAngle(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("SpatialSound coneInnerAngle newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 6.2832f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("SpatialSound coneInnerAngle newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=6.2832");
            }
		coneInnerAngle = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat coneInnerAngle field, similar to {@link #setConeInnerAngle(float)}.
	 * @param newValue is new value for the coneInnerAngle field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setConeInnerAngle(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setConeInnerAngle(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setConeInnerAngle(float)}.
	 * @param newValue is new value for field
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setConeInnerAngle(double newValue)
	{
		return setConeInnerAngle((float) newValue);
	}
	/**
	 * Provide float value unit axis, angle (in radians) within allowed range of [0,6.2832] from inputOutput SFFloat field named <i>coneOuterAngle</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,2pi] coneOuterAngle is centered along direction and defines an outer conical volume, within which the sound gain decreases linearly from full gain to coneOuterGain. Outside of coneOuterAngle, gain equals coneOuterGain.
 * <ul>
 *  <li> <i>Hint:</i> coneOuterAngle value is greater than or equal to coneInnerAngle. </li> 
 *  <li> <i>Hint:</i>  X3D4 Architecture Figure 16.3, SpatialSound Panning Gain Relationships <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-AudioPannerListenerRelationships" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-AudioPannerListenerRelationships</a> </li> 
 * </ul>
	 * @return value of coneOuterAngle field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=ConeOuterAngle, $memberObjectName=coneOuterAngle, $memberObjectName=coneOuterAngle)

	public float getConeOuterAngle()
	{
		return coneOuterAngle;
	}

	/**
	 * Accessor method to assign float value unit axis, angle (in radians) to inputOutput SFFloat field named <i>coneOuterAngle</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,2pi] coneOuterAngle is centered along direction and defines an outer conical volume, within which the sound gain decreases linearly from full gain to coneOuterGain. Outside of coneOuterAngle, gain equals coneOuterGain.
 * <ul>
 *  <li> <i>Hint:</i> coneOuterAngle value is greater than or equal to coneInnerAngle. </li> 
 *  <li> <i>Hint:</i>  X3D4 Architecture Figure 16.3, SpatialSound Panning Gain Relationships <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-AudioPannerListenerRelationships" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-AudioPannerListenerRelationships</a> </li> 
 * </ul>
	 * @param newValue is new value for the coneOuterAngle field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setConeOuterAngle(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("SpatialSound coneOuterAngle newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 6.2832f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("SpatialSound coneOuterAngle newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=6.2832");
            }
		coneOuterAngle = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat coneOuterAngle field, similar to {@link #setConeOuterAngle(float)}.
	 * @param newValue is new value for the coneOuterAngle field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setConeOuterAngle(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setConeOuterAngle(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setConeOuterAngle(float)}.
	 * @param newValue is new value for field
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setConeOuterAngle(double newValue)
	{
		return setConeOuterAngle((float) newValue);
	}
	/**
	 * Provide float value from inputOutput SFFloat field named <i>coneOuterGain</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (-infinity,+infinity) coneOuterGain is minimum gain value found outside coneOuterAngle.  * <br>

	 * @return value of coneOuterGain field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=ConeOuterGain, $memberObjectName=coneOuterGain, $memberObjectName=coneOuterGain)

	public float getConeOuterGain()
	{
		return coneOuterGain;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>coneOuterGain</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (-infinity,+infinity) coneOuterGain is minimum gain value found outside coneOuterAngle.  * <br>

	 * @param newValue is new value for the coneOuterGain field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setConeOuterGain(float newValue)
	{
		// set-newValue-validity-checks #0.a
		coneOuterGain = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat coneOuterGain field, similar to {@link #setConeOuterGain(float)}.
	 * @param newValue is new value for the coneOuterGain field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setConeOuterGain(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setConeOuterGain(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setConeOuterGain(float)}.
	 * @param newValue is new value for field
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setConeOuterGain(double newValue)
	{
		return setConeOuterGain((float) newValue);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Author-provided prose that describes intended purpose of the url asset.
 * <ul>
 *  <li> <i> Hint:</i>  many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character). </li> 
 * </ul>
	 * @return value of description field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)

	public String getDescription()
	{
		return description;
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Author-provided prose that describes intended purpose of the url asset.
 * <ul>
 *  <li> <i> Hint:</i>  many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character). </li> 
 * </ul>
	 * @param newValue is new value for the description field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setDescription(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		description = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString description field, similar to {@link #setDescription(String)}.
	 * @param newValue is new value for the description field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setDescription(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDescription(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide array of 3-tuple float results from inputOutput SFVec3f field named <i>direction</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  direction of sound axis, relative to local coordinate system.  * <br>

	 * @return value of direction field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Direction, $memberObjectName=direction, $memberObjectName=direction)

	public float[] getDirection()
	{
		return direction;
	}

	/**
	 * Accessor method to assign 3-tuple float array to inputOutput SFVec3f field named <i>direction</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  direction of sound axis, relative to local coordinate system.  * <br>

	 * @param newValue is new value for the direction field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setDirection(float[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new float[0];
		// Check that newValue parameter has legal size before assigning to scene graph
		if (newValue.length != 3) // 3-tuple check
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("SpatialSound direction newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
		}
		direction = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFVec3f direction field, similar to {@link #setDirection(float[])}.
	 * @param newValue is new value for the direction field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setDirection(SFVec3f newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDirection(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Assign values to SFVec3f direction field, similar to {@link #setDirection(float[])}.

	 * @param x first component
	 * @param y second component
	 * @param z third component

	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setDirection(float x, float y, float z)
	{
		setDirection(new float[] {x, y, z});
		return this;
	}

	/**
	 * Utility method: double-precision set-parameters accessor for X3D floating-point type, similar to {@link #setDirection(float[])}.
	 * @param x first component
	 * @param y second component
	 * @param z third component
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setDirection(double x, double y, double z)
	{
		return setDirection(new SFVec3f(x, y, z));
	}
	/**
	 * Utility method: double-precision set-array accessor for X3D floating-point type, similar to {@link #setDirection(float[])}.
	 * @param newArray is new value for field
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setDirection(double[] newArray)
	{
		return setDirection(new SFVec3f(newArray));
	}
	/**
	 * Provide String enumeration value (baseType SFString) ["LINEAR" | "INVERSE" | "EXPONENTIAL"] from inputOutput SFString field named <i>distanceModel</i>.
	 * <br><br>
	 * <i>Tooltip:</i> distanceModel determines how field specifies which algorithm to use for sound attenuation, corresponding to distance between an audio source and a listener, as it moves away from the listener.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#enumdef-distancemodeltype" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-distancemodeltype</a> </li> 
 * </ul>
	 * <br><br>
	 * Available enumeration values for string comparison: {@link #DISTANCEMODEL_LINEAR LINEAR}, {@link #DISTANCEMODEL_INVERSE INVERSE}, {@link #DISTANCEMODEL_EXPONENTIAL EXPONENTIAL}.
	 * @return value of distanceModel field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=DistanceModel, $memberObjectName=distanceModel, $memberObjectName=distanceModel)

	public String getDistanceModel()
	{
		return distanceModel;
	}

	/**
	 * Accessor method to assign String enumeration value ("LINEAR" | "INVERSE" | "EXPONENTIAL") to inputOutput SFString field named <i>distanceModel</i>.
	 * <br><br>
	 * <i>Warning:</i> authors can only choose from a strict list of enumeration values ({@link #DISTANCEMODEL_LINEAR LINEAR}, {@link #DISTANCEMODEL_INVERSE INVERSE}, {@link #DISTANCEMODEL_EXPONENTIAL EXPONENTIAL}).
	 * <br><br>
	 * <i>Tooltip:</i> distanceModel determines how field specifies which algorithm to use for sound attenuation, corresponding to distance between an audio source and a listener, as it moves away from the listener.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#enumdef-distancemodeltype" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-distancemodeltype</a> </li> 
 * </ul>
	 * @param newValue is new value for the distanceModel field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setDistanceModel(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
		{
                    newValue = new String(); // null string check
		}
		newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue); // handle potential enumeration value
                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.isEmpty() ||
			newValue.toString().replace("\"","").equals(DISTANCEMODEL_LINEAR) ||
			newValue.toString().replace("\"","").equals(DISTANCEMODEL_INVERSE) ||
			newValue.toString().replace("\"","").equals(DISTANCEMODEL_EXPONENTIAL)))
		{
			String warningMessage = "[warning] SpatialSound distanceModel newValue='" + newValue + "' includes an unrecognized optional value not matching any of the required enumeration string tokens.";
			if (!distanceModelWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "       Supported values are LINEAR, INVERSE, EXPONENTIAL";
			    distanceModelWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);

            if (!newValue.isEmpty()) // @additionalEnumerationValuesAllowed='false'
            {
                throw new org.web3d.x3d.sai.InvalidFieldValueException(warningMessage);
            }
		}
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		distanceModel = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString distanceModel field, similar to {@link #setDistanceModel(String)}.
	 * @param newValue is new value for the distanceModel field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setDistanceModel(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDistanceModel(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide boolean value from inputOutput SFBool field named <i>dopplerEnabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i> dopplerEnabled enables/disables whether real-time Doppler effects (due to relation motion between sources and listeners) are computed by browser between virtual sound sources and active listening locations, then applied to received frequency at active listening locations.
 * <ul>
 *  <li> <i>Hint:</i> functional support requires player support for Sound component level 3. </li> 
 *  <li> <i>Hint:</i>  Wikipedia Doppler effect <a href="https://en.wikipedia.org/wiki/Doppler_effect" target="_blank">https://en.wikipedia.org/wiki/Doppler_effect</a> </li> 
 * </ul>
	 * @return value of dopplerEnabled field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=DopplerEnabled, $memberObjectName=dopplerEnabled, $memberObjectName=dopplerEnabled)

	public boolean getDopplerEnabled()
	{
		return dopplerEnabled;
	}

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>dopplerEnabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i> dopplerEnabled enables/disables whether real-time Doppler effects (due to relation motion between sources and listeners) are computed by browser between virtual sound sources and active listening locations, then applied to received frequency at active listening locations.
 * <ul>
 *  <li> <i>Hint:</i> functional support requires player support for Sound component level 3. </li> 
 *  <li> <i>Hint:</i>  Wikipedia Doppler effect <a href="https://en.wikipedia.org/wiki/Doppler_effect" target="_blank">https://en.wikipedia.org/wiki/Doppler_effect</a> </li> 
 * </ul>
	 * @param newValue is new value for the dopplerEnabled field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setDopplerEnabled(boolean newValue)
	{
		// set-newValue-validity-checks #0.a
		dopplerEnabled = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFBool dopplerEnabled field, similar to {@link #setDopplerEnabled(boolean)}.
	 * @param newValue is new value for the dopplerEnabled field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setDopplerEnabled(SFBool newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDopplerEnabled(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide boolean value from inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @return value of enabled field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Enabled, $memberObjectName=enabled, $memberObjectName=enabled)

	public boolean getEnabled()
	{
		return enabled;
	}

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @param newValue is new value for the enabled field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setEnabled(boolean newValue)
	{
		// set-newValue-validity-checks #0.a
		enabled = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFBool enabled field, similar to {@link #setEnabled(boolean)}.
	 * @param newValue is new value for the enabled field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setEnabled(SFBool newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setEnabled(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide boolean value from inputOutput SFBool field named <i>enableHRTF</i>.
	 * <br><br>
	 * <i>Tooltip:</i> enableHRTF enables/disables Head Related Transfer Function (HRTF) auralization, if available. SpatialSound enabledHRTF=true corresponds to panningModelType HRTF, enabledHRTF=false corresponds to panningModelType equalpower.
 * <ul>
 *  <li> <i>Hint:</i> W3C Audio API <a href="https://www.w3.org/TR/webaudio/#enumdef-panningmodeltype" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-panningmodeltype</a> </li> 
 *  <li> <i>Hint:</i>  Wikipedia HRTF <a href="https://en.wikipedia.org/wiki/3D_sound_localization#Head-related_Transfer_Function_(HRTF)" target="_blank">https://en.wikipedia.org/wiki/3D_sound_localization#Head-related_Transfer_Function_(HRTF)</a> </li> 
 * </ul>
	 * @return value of enableHRTF field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=EnableHRTF, $memberObjectName=enableHRTF, $memberObjectName=enableHRTF)

	public boolean getEnableHRTF()
	{
		return enableHRTF;
	}

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>enableHRTF</i>.
	 * <br><br>
	 * <i>Tooltip:</i> enableHRTF enables/disables Head Related Transfer Function (HRTF) auralization, if available. SpatialSound enabledHRTF=true corresponds to panningModelType HRTF, enabledHRTF=false corresponds to panningModelType equalpower.
 * <ul>
 *  <li> <i>Hint:</i> W3C Audio API <a href="https://www.w3.org/TR/webaudio/#enumdef-panningmodeltype" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-panningmodeltype</a> </li> 
 *  <li> <i>Hint:</i>  Wikipedia HRTF <a href="https://en.wikipedia.org/wiki/3D_sound_localization#Head-related_Transfer_Function_(HRTF)" target="_blank">https://en.wikipedia.org/wiki/3D_sound_localization#Head-related_Transfer_Function_(HRTF)</a> </li> 
 * </ul>
	 * @param newValue is new value for the enableHRTF field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setEnableHRTF(boolean newValue)
	{
		// set-newValue-validity-checks #0.a
		enableHRTF = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFBool enableHRTF field, similar to {@link #setEnableHRTF(boolean)}.
	 * @param newValue is new value for the enableHRTF field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setEnableHRTF(SFBool newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setEnableHRTF(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide float value from inputOutput SFFloat field named <i>gain</i>.
	 * <br><br>
	 * <i>Tooltip:</i> (-infinity,+infinity) The gain field is a factor that represents the amount of linear amplification to apply to the output of the node.
 * <ul>
 *  <li> <i>Warning:</i> Decibel values shall not be used. </li> 
 *  <li> <i>Hint:</i>  Negative gain factors negate the input signal. </li> 
 * </ul>
	 * @return value of gain field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Gain, $memberObjectName=gain, $memberObjectName=gain)

	public float getGain()
	{
		return gain;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>gain</i>.
	 * <br><br>
	 * <i>Tooltip:</i> (-infinity,+infinity) The gain field is a factor that represents the amount of linear amplification to apply to the output of the node.
 * <ul>
 *  <li> <i>Warning:</i> Decibel values shall not be used. </li> 
 *  <li> <i>Hint:</i>  Negative gain factors negate the input signal. </li> 
 * </ul>
	 * @param newValue is new value for the gain field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setGain(float newValue)
	{
		// set-newValue-validity-checks #0.a
		gain = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat gain field, similar to {@link #setGain(float)}.
	 * @param newValue is new value for the gain field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setGain(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setGain(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setGain(float)}.
	 * @param newValue is new value for field
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setGain(double newValue)
	{
		return setGain((float) newValue);
	}
	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>intensity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Factor [0,1] adjusting loudness (decibels) of emitted sound.  * <br>

	 * @return value of intensity field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Intensity, $memberObjectName=intensity, $memberObjectName=intensity)

	public float getIntensity()
	{
		return intensity;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>intensity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Factor [0,1] adjusting loudness (decibels) of emitted sound.  * <br>

	 * @param newValue is new value for the intensity field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setIntensity(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("SpatialSound intensity newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("SpatialSound intensity newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
            }
		intensity = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat intensity field, similar to {@link #setIntensity(float)}.
	 * @param newValue is new value for the intensity field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setIntensity(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setIntensity(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setIntensity(float)}.
	 * @param newValue is new value for field
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setIntensity(double newValue)
	{
		return setIntensity((float) newValue);
	}
	/**
	 * Provide IS instance (using a properly typed node) from inputOutput SFNode field <i>IS</i>.
	 * @return value of IS field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=true, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=IS, $memberObjectName=IS, $memberObjectName=IS)
	public IS getIS()
	{
		return IS;
	}

	/**
	 * Accessor method to assign IS instance (using a properly typed node) to inputOutput SFNode field <i>IS</i>.
	 * @param newValue is new value for the IS field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setIS(IS newValue)
	{
		// set-newValue-validity-checks #0.a
		IS = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) IS).setParent(this); // parentTest15.1
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of IS field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public SpatialSound clearIS()
	{
		((X3DConcreteElement) IS).clearParent(); // remove references to facilitate Java memory management
		IS = null; // reset SFNode field
		return this;
	}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>IS</i>.
	 * @return whether a concrete statement or CommentsBlock is available.
	 * @see #getIS()
	 */
	public boolean hasIS()
	{
		return (IS != null);
	}
	/**
	 * Provide array of 3-tuple float results from inputOutput SFVec3f field named <i>location</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,+infinity) Position of sound ellipsoid center, relative to local coordinate system.
 * <ul>
 *  <li> <i> Hint:</i>  improve audibility by setting location='0 1.6 0' so that center height of sound ellipsoid matches typical NavigationInfo avatarSize height. </li> 
 * </ul>
	 * @return value of location field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Location, $memberObjectName=location, $memberObjectName=location)

	public float[] getLocation()
	{
		return location;
	}

	/**
	 * Accessor method to assign 3-tuple float array to inputOutput SFVec3f field named <i>location</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,+infinity) Position of sound ellipsoid center, relative to local coordinate system.
 * <ul>
 *  <li> <i> Hint:</i>  improve audibility by setting location='0 1.6 0' so that center height of sound ellipsoid matches typical NavigationInfo avatarSize height. </li> 
 * </ul>
	 * @param newValue is new value for the location field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setLocation(float[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new float[0];
		// Check that newValue parameter has legal size before assigning to scene graph
		if (newValue.length != 3) // 3-tuple check
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("SpatialSound location newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
		}
		location = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFVec3f location field, similar to {@link #setLocation(float[])}.
	 * @param newValue is new value for the location field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setLocation(SFVec3f newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setLocation(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Assign values to SFVec3f location field, similar to {@link #setLocation(float[])}.

	 * @param x first component
	 * @param y second component
	 * @param z third component

	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setLocation(float x, float y, float z)
	{
		setLocation(new float[] {x, y, z});
		return this;
	}

	/**
	 * Utility method: double-precision set-parameters accessor for X3D floating-point type, similar to {@link #setLocation(float[])}.
	 * @param x first component
	 * @param y second component
	 * @param z third component
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setLocation(double x, double y, double z)
	{
		return setLocation(new SFVec3f(x, y, z));
	}
	/**
	 * Utility method: double-precision set-array accessor for X3D floating-point type, similar to {@link #setLocation(float[])}.
	 * @param newArray is new value for field
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setLocation(double[] newArray)
	{
		return setLocation(new SFVec3f(newArray));
	}
	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>maxDistance</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) maxDistance is the maximum distance where sound is renderable between source and listener, after which no reduction in sound volume occurs.  * <br>

	 * @return value of maxDistance field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=MaxDistance, $memberObjectName=maxDistance, $memberObjectName=maxDistance)

	public float getMaxDistance()
	{
		return maxDistance;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>maxDistance</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) maxDistance is the maximum distance where sound is renderable between source and listener, after which no reduction in sound volume occurs.  * <br>

	 * @param newValue is new value for the maxDistance field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setMaxDistance(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("SpatialSound maxDistance newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
		maxDistance = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat maxDistance field, similar to {@link #setMaxDistance(float)}.
	 * @param newValue is new value for the maxDistance field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setMaxDistance(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setMaxDistance(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setMaxDistance(float)}.
	 * @param newValue is new value for field
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setMaxDistance(double newValue)
	{
		return setMaxDistance((float) newValue);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * @see #getMetadataProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata()
	{
		return metadata;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue)
	{
		// set-newValue-validity-checks #0.a
		metadata = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadata).setParent(this); // parentTest15.1
			// change X3D4 MetadataSet default 'value' back to 'metadata' if parent is not another Metadata* node */
			if (metadata instanceof org.web3d.x3d.jsail.Core.MetadataSet)
{
				((X3DConcreteNode) metadata).setContainerFieldOverride("metadata");
}
		}
		if (metadataProtoInstance != null)
		{
			metadataProtoInstance.setParent(null); // housekeeping, clear prior object
			metadataProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of metadata field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public SpatialSound clearMetadata()
	{
		((X3DConcreteElement) metadata).clearParent(); // remove references to facilitate Java memory management
		metadata = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject)
	 * @param newValue is new value for the metadata field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public SpatialSound setMetadata(ProtoInstance newValue)
	{
		if (metadataProtoInstance != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(null); // parentTest15.5
	    }
		metadataProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(this); // parentTest15.6
            metadataProtoInstance.setContainerField("metadata");
	    }
		if (metadata != null)
		{
			((X3DConcreteElement) metadata).setParent(null); // housekeeping, clear prior object
			metadata = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getMetadataProtoInstance()
		{
			return metadataProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>metadata</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getMetadata()
	 * @see #getMetadataProtoInstance()
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 */
	public boolean hasMetadata()
	{
		return (metadata != null) || (metadataProtoInstance != null);
	}
	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>priority</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Player hint [0,1] if needed to choose which sounds to play.  * <br>

	 * @return value of priority field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Priority, $memberObjectName=priority, $memberObjectName=priority)

	public float getPriority()
	{
		return priority;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>priority</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Player hint [0,1] if needed to choose which sounds to play.  * <br>

	 * @param newValue is new value for the priority field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setPriority(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("SpatialSound priority newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("SpatialSound priority newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
            }
		priority = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat priority field, similar to {@link #setPriority(float)}.
	 * @param newValue is new value for the priority field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setPriority(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setPriority(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setPriority(float)}.
	 * @param newValue is new value for field
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setPriority(double newValue)
	{
		return setPriority((float) newValue);
	}
	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>referenceDistance</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,+infinity) referenceDistance for reducing volume as source moves further from the listener. For distances less than this value, volume is not reduced.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#dom-pannernode-refdistance" target="_blank">https://www.w3.org/TR/webaudio/#dom-pannernode-refdistance</a> </li> 
 * </ul>
	 * @return value of referenceDistance field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=ReferenceDistance, $memberObjectName=referenceDistance, $memberObjectName=referenceDistance)

	public float getReferenceDistance()
	{
		return referenceDistance;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>referenceDistance</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,+infinity) referenceDistance for reducing volume as source moves further from the listener. For distances less than this value, volume is not reduced.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#dom-pannernode-refdistance" target="_blank">https://www.w3.org/TR/webaudio/#dom-pannernode-refdistance</a> </li> 
 * </ul>
	 * @param newValue is new value for the referenceDistance field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setReferenceDistance(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("SpatialSound referenceDistance newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
		referenceDistance = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat referenceDistance field, similar to {@link #setReferenceDistance(float)}.
	 * @param newValue is new value for the referenceDistance field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setReferenceDistance(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setReferenceDistance(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setReferenceDistance(float)}.
	 * @param newValue is new value for field
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setReferenceDistance(double newValue)
	{
		return setReferenceDistance((float) newValue);
	}
	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>rolloffFactor</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,+infinity) rolloffFactor indicates how quickly volume is reduced as source moves further from listener.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#dom-pannernode-rollofffactor" target="_blank">https://www.w3.org/TR/webaudio/#dom-pannernode-rollofffactor</a> </li> 
 * </ul>
	 * @return value of rolloffFactor field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=RolloffFactor, $memberObjectName=rolloffFactor, $memberObjectName=rolloffFactor)

	public float getRolloffFactor()
	{
		return rolloffFactor;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>rolloffFactor</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,+infinity) rolloffFactor indicates how quickly volume is reduced as source moves further from listener.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#dom-pannernode-rollofffactor" target="_blank">https://www.w3.org/TR/webaudio/#dom-pannernode-rollofffactor</a> </li> 
 * </ul>
	 * @param newValue is new value for the rolloffFactor field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setRolloffFactor(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("SpatialSound rolloffFactor newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
		rolloffFactor = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat rolloffFactor field, similar to {@link #setRolloffFactor(float)}.
	 * @param newValue is new value for the rolloffFactor field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setRolloffFactor(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setRolloffFactor(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setRolloffFactor(float)}.
	 * @param newValue is new value for field
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setRolloffFactor(double newValue)
	{
		return setRolloffFactor((float) newValue);
	}
	/**
	 * Provide boolean value from initializeOnly SFBool field named <i>spatialize</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Whether to spatialize sound playback relative to viewer.
 * <ul>
 *  <li> <i> Hint:</i>  only effective within the auralization volume. </li> 
 * </ul>
	 * @return value of spatialize field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Spatialize, $memberObjectName=spatialize, $memberObjectName=spatialize)

	public boolean getSpatialize()
	{
		return spatialize;
	}

	/**
	 * Accessor method to assign boolean value to initializeOnly SFBool field named <i>spatialize</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Whether to spatialize sound playback relative to viewer.
 * <ul>
 *  <li> <i> Hint:</i>  only effective within the auralization volume. </li> 
 * </ul>
	 * @param newValue is new value for the spatialize field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setSpatialize(boolean newValue)
	{
		// set-newValue-validity-checks #0.a
		spatialize = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFBool spatialize field, similar to {@link #setSpatialize(boolean)}.
	 * @param newValue is new value for the spatialize field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setSpatialize(SFBool newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setSpatialize(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i> DEF defines a unique ID name for this node, referenceable by other nodes.
 * <ul>
 *  <li> <i>Hint:</i> descriptive DEF names improve clarity and help document a model. </li> 
 *  <li> <i>Hint:</i> well-defined names can simplify design and debugging through improved author understanding. </li> 
 *  <li> <i>Hint:</i>  X3D Scene Authoring Hints, Naming Conventions <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions</a> </li> 
 * </ul>
	 * @return value of DEF field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=DEF, $memberObjectName=DEF, $memberObjectName=DEF)

	public String getDEF()
	{
		// override abstract method in X3DConcreteNode
		return super.getDEF();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i> DEF defines a unique ID name for this node, referenceable by other nodes.
 * <ul>
 *  <li> <i>Hint:</i> descriptive DEF names improve clarity and help document a model. </li> 
 *  <li> <i>Hint:</i> well-defined names can simplify design and debugging through improved author understanding. </li> 
 *  <li> <i>Hint:</i>  X3D Scene Authoring Hints, Naming Conventions <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions</a> </li> 
 * </ul>
	 * <br><br>
	 *  Note that setting the DEF value clears the USE value.
	 * @param newValue is new value for the DEF field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final SpatialSound setDEF(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to SpatialSound DEF
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("SpatialSound DEF newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteUSE(""); // ensure that no previous USE value remains
		setConcreteDEF(newValue); // private superclass methods
		return this;
	}

	/**
	 * Assign typed object value to SFString DEF field, similar to {@link #setDEF(String)}.
	 * @param newValue is new value for the DEF field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setDEF(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDEF(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i> USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value).
 * <ul>
 *  <li> <i>Hint:</i> USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. </li> 
 *  <li> <i>Warning:</i> do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. </li> 
 *  <li> <i>Warning:</i>  each USE value must match a corresponding DEF value that is defined earlier in the scene. </li> 
 * </ul>
	 * @return value of USE field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=USE, $memberObjectName=USE, $memberObjectName=USE)

	public String getUSE()
	{
		// override abstract method in X3DConcreteNode
		return super.getUSE();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i> USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value).
 * <ul>
 *  <li> <i>Hint:</i> USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. </li> 
 *  <li> <i>Warning:</i> do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. </li> 
 *  <li> <i>Warning:</i>  each USE value must match a corresponding DEF value that is defined earlier in the scene. </li> 
 * </ul>
	 * <br><br>
	 * <i>Note:</i> each <code>USE</code> node is still an independent object, with the <code>USE</code> value matching the <code>DEF</code> value in the preceding object. 
	 * <br><br>
	 * <i>Warning:</i> invoking the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.<br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param newValue is new value for the USE field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final SpatialSound setUSE(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to SpatialSound USE
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("SpatialSound USE newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteDEF(""); // ensure that no previous DEF value remains
		setConcreteUSE(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString USE field, similar to {@link #setUSE(String)}.
	 * @param newValue is new value for the USE field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setUSE(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setUSE(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>class</i>.
	 * @return value of class field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=CssClass, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssClass()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssClass();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>class</i>.
	 * @param newValue is new value for the class field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final SpatialSound setCssClass(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssClass(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssClass(String)}.
	 * @param newValue is new value for the class field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setCssClass(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssClass(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>id</i>.
	 * @return value of id field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=HtmlID, $memberObjectName=HtmlID, $memberObjectName=HtmlID)

	public String getHtmlID()
	{
		// override abstract method in X3DConcreteNode
		return super.getHtmlID();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>id</i>.
	 * @param newValue is new value for the id field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final SpatialSound setHtmlID(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteHtmlID(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString HtmlID field, similar to {@link #setHtmlID(String)}.
	 * @param newValue is new value for the id field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setHtmlID(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setHtmlID(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>style</i>.
	 * @return value of style field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=CssStyle, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssStyle()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssStyle();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>style</i>.
	 * @param newValue is new value for the style field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final SpatialSound setCssStyle(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssStyle(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssStyle(String)}.
	 * @param newValue is new value for the style field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setCssStyle(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssStyle(newValue.getPrimitiveValue());
			return this;
	}

	// Additional utility methods for this class ==============================

	/**
	 * Assign a USE reference to another DEF node of same node type, similar to {@link #setUSE(String)}.
	 * <br ><br >
	 * <i>Warning:</i> note that the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.
	 * <br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param DEFnode must have a DEF value defined
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setUSE(SpatialSound DEFnode)
	{
		if (DEFnode.getDEF().isEmpty())
		{
			String errorNotice = "*** setUSE(DEFnode) invoked on SpatialSound" +
				" that has no DEF name defined, thus a copy cannot be referenced as a USE node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		setUSE(DEFnode.getDEF());
		return this;
	}
	/**
	 * Utility constructor that assigns DEF label after initializing member variables with default values.
	 * @param DEFlabel unique DEF name for this X3D node
	 */
	public SpatialSound (String DEFlabel)
	{
		initialize();
		setDEF(DEFlabel); // apply checks
	}

	/**
	 * Utility method to adjust field synonyms
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges">X3D Scene Authoring Hints: X3D4 Field name changes for improved consistency</a>
     */
    private void handleFieldSynonyms()
    {
            // no synonyms to handle
	}

	/**
	 * Recursive method to provide X3D string serialization of this model subgraph, utilizing XML encoding and conforming to X3D Canonical Form.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_X3D
	 * @see X3D#FILE_EXTENSION_XML
	 * @see X3D#toStringXML()
	 * @see X3D#toFileXML(String)
	 * @see X3D#toFileX3D(String)
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-1/V3.3/Part01/X3D_XML.html">X3D XML Encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-3/V3.3/Part03/concepts.html#X3DCanonicalForm" target="blank">X3D Compressed Binary Encoding: X3D Canonical Form</a>
	 * @see <a href="https://www.web3d.org/x3d/tools/canonical/doc/x3dTools.htm">X3D Canonicalization (C14N) Tool</a>
	 * @return X3D string
	 */
	@Override
	public String toStringX3D(int indentLevel)
	{
		boolean hasAttributes = true; // TODO check for non-default attribute values
		boolean      hasChild = (IS != null) || (!children.isEmpty()) || 
		                        (IS != null) || 
		                        (metadata != null) || (metadataProtoInstance != null);
		if (hasUSE())
			hasChild = false; // USE nodes only include attributes for USE and non-default containerField
		handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder indent = new StringBuilder();
		int  indentIncrement = ConfigurationProperties.getIndentIncrement();
		char indentCharacter = ConfigurationProperties.getIndentCharacter();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		StringBuilder stringX3D = new StringBuilder();

		stringX3D.append(indent).append("<SpatialSound"); // start opening tag
		if (hasAttributes)
		{
			if (!getDEF().equals(DEF_DEFAULT_VALUE) && !hasUSE())
			{
				stringX3D.append(" DEF='").append(SFString.toString(getDEF())).append("'");
			}
			
			if (!getUSE().equals(USE_DEFAULT_VALUE))
			{
				stringX3D.append(" USE='").append(SFString.toString(getUSE())).append("'");
			}
			
            // containerField is critical for ProtoInstance relationship to parent node
            if (!getContainerFieldOverride().isBlank() && !getContainerFieldOverride().equals(this.getContainerFieldDefault())) // output if not default ProtoInstance containerField
            {
                    stringX3D.append(" containerField='").append(getContainerFieldOverride()).append("'");
            }

            // test attributes

			if ((!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" class='").append(new SFString(getCssClass()).toStringX3D()).append("'");
			}
			if (((getConeInnerAngle() != CONEINNERANGLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" coneInnerAngle='").append(SFFloat.toString(getConeInnerAngle())).append("'");
			}
			if (((getConeOuterAngle() != CONEOUTERANGLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" coneOuterAngle='").append(SFFloat.toString(getConeOuterAngle())).append("'");
			}
			if (((getConeOuterGain() != CONEOUTERGAIN_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" coneOuterGain='").append(SFFloat.toString(getConeOuterGain())).append("'");
			}
			if ((!getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" description='").append(new SFString(getDescription()).toStringX3D()).append("'");
			}
			if ((!Arrays.equals(getDirection(), DIRECTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* (string-length(@default) > 0) */ && !hasUSE())
			{
				stringX3D.append(" direction='").append(SFVec3f.toString(getDirection())).append("'");
			}
			if ((!getDistanceModel().equals(DISTANCEMODEL_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" distanceModel='").append(new SFString(getDistanceModel()).toStringX3D()).append("'");
			}
			if (((getDopplerEnabled() != DOPPLERENABLED_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" dopplerEnabled='").append(SFBool.toString(getDopplerEnabled())).append("'");
			}
			if (((getEnableHRTF() != ENABLEHRTF_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" enableHRTF='").append(SFBool.toString(getEnableHRTF())).append("'");
			}
			if (((getEnabled() != ENABLED_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" enabled='").append(SFBool.toString(getEnabled())).append("'");
			}
			if (((getGain() != GAIN_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" gain='").append(SFFloat.toString(getGain())).append("'");
			}
			if ((!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" id='").append(new SFString(getHtmlID()).toStringX3D()).append("'");
			}
			if (((getIntensity() != INTENSITY_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" intensity='").append(SFFloat.toString(getIntensity())).append("'");
			}
			if ((!Arrays.equals(getLocation(), LOCATION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* (string-length(@default) > 0) */ && !hasUSE())
			{
				stringX3D.append(" location='").append(SFVec3f.toString(getLocation())).append("'");
			}
			if (((getMaxDistance() != MAXDISTANCE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" maxDistance='").append(SFFloat.toString(getMaxDistance())).append("'");
			}
			if (((getPriority() != PRIORITY_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" priority='").append(SFFloat.toString(getPriority())).append("'");
			}
			if (((getReferenceDistance() != REFERENCEDISTANCE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" referenceDistance='").append(SFFloat.toString(getReferenceDistance())).append("'");
			}
			if (((getRolloffFactor() != ROLLOFFFACTOR_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" rolloffFactor='").append(SFFloat.toString(getRolloffFactor())).append("'");
			}
			if (((getSpatialize() != SPATIALIZE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" spatialize='").append(SFBool.toString(getSpatialize())).append("'");
			}
			if ((!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" style='").append(new SFString(getCssStyle()).toStringX3D()).append("'");
			}
		}
		if ((hasChild) && !hasUSE()) // has contained node(s), comment(s), IS/connect and/or source code
		{
			stringX3D.append(">").append("\n"); // finish opening tag

			// recursively iterate over child elements
			if      (IS != null)
			{
				stringX3D.append(((X3DConcreteElement)IS).toStringX3D(indentLevel + indentIncrement));
			}
			if      (metadata != null)
			{
				stringX3D.append(((X3DConcreteElement)metadata).toStringX3D(indentLevel + indentIncrement));
			}
			else if (metadataProtoInstance != null)
			{
				stringX3D.append(((X3DConcreteElement)metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			for (org.web3d.x3d.sai.Core.X3DNode element : children)
			{
				stringX3D.append(((X3DConcreteElement)element).toStringX3D(indentLevel + indentIncrement));
			}
			stringX3D.append(indent).append("</SpatialSound>").append("\n"); // finish closing tag
		}
		else
		{
			stringX3D.append("/>").append("\n"); // otherwise finish singleton tag
		}
		return stringX3D.toString();
	}
// ($name=SpatialSound, isX3dStatement=false, isClassX3dStatement=false, $hasChild=true, $hasAttributes=true
	/**
	 * Recursive method to provide ClassicVRML string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_CLASSICVRML
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/X3D_ClassicVRML.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/grammar.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding, Annex A: Grammar</a>
	 * @return ClassicVRML string
	 */
	@Override
	public String toStringClassicVRML(int indentLevel)
	{
		StringBuilder stringClassicVRML = new StringBuilder();
		boolean hasAttributes = true; // TODO further refinement
		boolean      hasChild = (IS != null) || (!children.isEmpty()) || 
		                        (IS != null) || 
		                        (metadata != null) || (metadataProtoInstance != null);
		if (hasUSE())
		{
			hasAttributes = false;
			hasChild      = false; // USE nodes include no other fields
		}
                if (!serializingVRML97output)
                    handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder  indent = new StringBuilder();
		char  indentCharacter = ConfigurationProperties.getIndentCharacter();
		int   indentIncrement = ConfigurationProperties.getIndentIncrement();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		if (!getDEF().equals(DEF_DEFAULT_VALUE))
		{
			stringClassicVRML.append("DEF ").append(SFString.toString(getDEF())).append(" ");
		}
		if (!getUSE().equals(USE_DEFAULT_VALUE))
		{
			 stringClassicVRML.append("USE ").append(SFString.toString(getUSE())).append("\n");
		}
		else // only have further output if not a USE node
		{
			stringClassicVRML.append("SpatialSound").append(" { "); // define node name, node content follows

			if (hasAttributes || hasChild)
			{
				stringClassicVRML.append("\n").append(indent).append(indentCharacter); // fields for this node follow
			}
			if (hasAttributes)
			{
				boolean hasISconnect = (getIS() != null) && !getIS().getConnectList().isEmpty();
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("class"))
						{
							stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(getCssClass())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("coneInnerAngle"))
						{
							stringClassicVRML.append(indentCharacter).append("coneInnerAngle").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getConeInnerAngle() != CONEINNERANGLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("coneInnerAngle ").append(SFFloat.toString(getConeInnerAngle())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("coneOuterAngle"))
						{
							stringClassicVRML.append(indentCharacter).append("coneOuterAngle").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getConeOuterAngle() != CONEOUTERANGLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("coneOuterAngle ").append(SFFloat.toString(getConeOuterAngle())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("coneOuterGain"))
						{
							stringClassicVRML.append(indentCharacter).append("coneOuterGain").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getConeOuterGain() != CONEOUTERGAIN_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("coneOuterGain ").append(SFFloat.toString(getConeOuterGain())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("description"))
						{
							stringClassicVRML.append(indentCharacter).append("description").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("description ").append("\"").append(SFString.toString(getDescription())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("direction"))
						{
							stringClassicVRML.append(indentCharacter).append("direction").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!Arrays.equals(getDirection(), DIRECTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("direction ").append(SFVec3f.toString(getDirection())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("distanceModel"))
						{
							stringClassicVRML.append(indentCharacter).append("distanceModel").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getDistanceModel().equals(DISTANCEMODEL_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("distanceModel ").append("\"").append(SFString.toString(getDistanceModel())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("dopplerEnabled"))
						{
							stringClassicVRML.append(indentCharacter).append("dopplerEnabled").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getDopplerEnabled() != DOPPLERENABLED_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("dopplerEnabled ").append(SFBool.toStringClassicVRML(getDopplerEnabled())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("enableHRTF"))
						{
							stringClassicVRML.append(indentCharacter).append("enableHRTF").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getEnableHRTF() != ENABLEHRTF_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("enableHRTF ").append(SFBool.toStringClassicVRML(getEnableHRTF())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("enabled"))
						{
							stringClassicVRML.append(indentCharacter).append("enabled").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getEnabled() != ENABLED_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("enabled ").append(SFBool.toStringClassicVRML(getEnabled())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("gain"))
						{
							stringClassicVRML.append(indentCharacter).append("gain").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getGain() != GAIN_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("gain ").append(SFFloat.toString(getGain())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("id"))
						{
							stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(getHtmlID())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("intensity"))
						{
							stringClassicVRML.append(indentCharacter).append("intensity").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getIntensity() != INTENSITY_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("intensity ").append(SFFloat.toString(getIntensity())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("location"))
						{
							stringClassicVRML.append(indentCharacter).append("location").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!Arrays.equals(getLocation(), LOCATION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("location ").append(SFVec3f.toString(getLocation())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("maxDistance"))
						{
							stringClassicVRML.append(indentCharacter).append("maxDistance").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getMaxDistance() != MAXDISTANCE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("maxDistance ").append(SFFloat.toString(getMaxDistance())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("priority"))
						{
							stringClassicVRML.append(indentCharacter).append("priority").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getPriority() != PRIORITY_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("priority ").append(SFFloat.toString(getPriority())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("referenceDistance"))
						{
							stringClassicVRML.append(indentCharacter).append("referenceDistance").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getReferenceDistance() != REFERENCEDISTANCE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("referenceDistance ").append(SFFloat.toString(getReferenceDistance())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("rolloffFactor"))
						{
							stringClassicVRML.append(indentCharacter).append("rolloffFactor").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getRolloffFactor() != ROLLOFFFACTOR_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("rolloffFactor ").append(SFFloat.toString(getRolloffFactor())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("spatialize"))
						{
							stringClassicVRML.append(indentCharacter).append("spatialize").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getSpatialize() != SPATIALIZE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("spatialize ").append(SFBool.toStringClassicVRML(getSpatialize())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("style"))
						{
							stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(getCssStyle())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
			}
		}
		if (hasChild) // has contained node(s) (including USE), comment(s), IS/connect and/or source code
		{
                        // recursively iterate over child elements

			if (metadata != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadata).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (metadataProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (!children.isEmpty())
			{
				stringClassicVRML.append(indentCharacter).append(indentCharacter).append("children").append(" [").append("\n")
					.append(indent).append(indentCharacter).append(indentCharacter); // containerField for MFNode array
                            for (org.web3d.x3d.sai.Core.X3DNode element : children)
                            {
				stringClassicVRML.append(((X3DConcreteElement)element).toStringClassicVRML(indentLevel + indentIncrement + indentIncrement));
                            }
                            stringClassicVRML.append(indent).append(indentCharacter).append(indentCharacter).append("]").append("\n")
				.append(indent); // end MFNode array
			}
			if (IS != null)
			{
				stringClassicVRML.append(((X3DConcreteElement) IS).toStringClassicVRML(indentLevel)); // end X3D statement
			}stringClassicVRML.append("\n").append(indent).append("\n"); // .append(" ### trace field initialization value #8")

		}
		if (getUSE().isEmpty() && (hasAttributes || hasChild))
		{
			stringClassicVRML.append("}").append("\n"); // finish node content
		}
		return stringClassicVRML.toString();
	}


    private boolean serializingVRML97output = false; // whether to avoid handling field name synonyms

	/**
	 * Recursive method to provide VRML97 string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_VRML97
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772/V2.0/index.html">Virtual Reality Modeling Language (VRML) 97 specification</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772-1/V2.1/index.html">VRML 97 v2.1 Amendment</a>
	 * @return VRML97 string
	 */
	@Override
	public String toStringVRML97(int indentLevel)
	{
            serializingVRML97output = true;
            String result = toStringClassicVRML(indentLevel);
            serializingVRML97output = false;

            return result;
	}

	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue)
	{
		return findElementByNameValue(nameValue, ""); // empty string is wildcard, any element match is allowed
	}

	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue, String elementName)
	{
		if ((nameValue == null) || nameValue.isEmpty())
		{
			String errorNotice = "*** findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		// no name field available for this element
		X3DConcreteElement referenceElement;
		for (org.web3d.x3d.sai.Core.X3DNode element : children) // MFNode
		{
			if (element instanceof X3DConcreteElement)
			{
				referenceElement = ((X3DConcreteElement) element).findElementByNameValue(nameValue, elementName);
				if (referenceElement != null)
					return referenceElement;
			}
		}
		if (IS != null)
		{
			referenceElement = ((X3DConcreteElement) IS).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadata != null)
		{
			referenceElement = ((X3DConcreteElement) metadata).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadataProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) metadataProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node or statement with given name attribute is found, meaning both objects are attached to same scene graph.
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @see #findElementByNameValue(String, String)
	 * @return whether node is found
	 */
	public boolean hasElementByNameValue(String nameValue, String elementName)
	{
		return (findElementByNameValue(nameValue, elementName) != null);
	}

	/**
	 * Recursive method to provide object reference to node by DEF, if found as this node or in a contained node.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same DEF, this method does not handle that case.
	 * @see #findElementByNameValue(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found node, null otherwise
	 */
	/* @Override */
	public X3DConcreteNode findNodeByDEF(String DEFvalue)
	{
		if ((DEFvalue == null) || DEFvalue.isEmpty())
		{
			String errorNotice = "*** findNodeByDEF(\"\") cannot use empty string to find a name";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		if (getDEF().equals(DEFvalue))
			return this;
		X3DConcreteNode referenceNode;
		for (org.web3d.x3d.sai.Core.X3DNode element : children) // MFNode
		{
			if (element instanceof org.web3d.x3d.jsail.X3DConcreteNode)
			{
				referenceNode = ((X3DConcreteElement) element).findNodeByDEF(DEFvalue);
				if (referenceNode != null)
					return referenceNode;
			}
		}
		if (IS != null)
		{
			referenceNode = ((X3DConcreteElement) IS).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadata != null)
		{
			referenceNode = ((X3DConcreteElement) metadata).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadataProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) metadataProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node with DEFvalue is found, meaning both objects are attached to same scene graph.
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @see #findNodeByDEF(String)
	 * @return whether node is found
	 */
	public boolean hasNodeByDEF(String DEFvalue)
	{
		return (findNodeByDEF(DEFvalue) != null);
	}


	/**
	 * Recursive method to validate this element plus all contained nodes and statements,
	 * using both datatype-specification value checks and regular expression (regex) checking of corresponding string values.
         * TODO document specific validation methods.
	 * @return validation results (if any)
	 */
	@Override
	public String validate()
	{
		validationResult = new StringBuilder(); // prepare for updated results

		setConeInnerAngle(getConeInnerAngle()); // exercise field checks, simple types
        
		setConeOuterAngle(getConeOuterAngle()); // exercise field checks, simple types
        
		setConeOuterGain(getConeOuterGain()); // exercise field checks, simple types
        
		setDescription(getDescription()); // exercise field checks, simple types
        
		setDirection(getDirection()); // exercise field checks, simple types
        
		setDistanceModel(getDistanceModel()); // exercise field checks, simple types
        
		setDopplerEnabled(getDopplerEnabled()); // exercise field checks, simple types
        
		setEnabled(getEnabled()); // exercise field checks, simple types
        
		setEnableHRTF(getEnableHRTF()); // exercise field checks, simple types
        
		setGain(getGain()); // exercise field checks, simple types
        
		setIntensity(getIntensity()); // exercise field checks, simple types
        
		setLocation(getLocation()); // exercise field checks, simple types
        
		setMaxDistance(getMaxDistance()); // exercise field checks, simple types
        
		setPriority(getPriority()); // exercise field checks, simple types
        
		setReferenceDistance(getReferenceDistance()); // exercise field checks, simple types
        
		setRolloffFactor(getRolloffFactor()); // exercise field checks, simple types
        
		setSpatialize(getSpatialize()); // exercise field checks, simple types
        
		if (!hasUSE()) // be careful! setting DEF via setDEF() method will reset USE value
			setDEF(getDEF()); // exercise field checks, simple types
        
		if (hasUSE()) // be careful! setting USE via setUSE() method resets all attributes to default values and wipes out all children
			setUSE(getUSE()); // exercise field checks, simple types
        
		setCssClass(getCssClass()); // exercise field checks, simple types
        
		setHtmlID(getHtmlID()); // exercise field checks, simple types
        
		setCssStyle(getCssStyle()); // exercise field checks, simple types
        
		for (org.web3d.x3d.sai.Core.X3DNode element : children) // MFNode
		{
			try {
                            ((X3DConcreteElement) element).validate(); // exercise field checks, MFNode element
                            validationResult.append(((X3DConcreteElement) element).getValidationResult());
                        }
                        catch (Exception e)
                        {
                            String exceptionMessage = "[exception] during validation: " + e.getMessage();
                            validationResult.append(exceptionMessage);
                        //  System.err.println(exceptionMessage);
                            e.printStackTrace();
                        }
		}
		setChildren(getChildren()); // also test getter/setter validation, which also includes checks for acceptableNodeTypes (if applicable)

		if (hasUSE() && hasChildren()) // test USE restrictions
		{
                    String errorNotice = "*** SpatialSound USE='" + getUSE() + "' is not allowed to have contained MFNode children";
                    validationResult.append(errorNotice);
                    throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (IS != null)
		{
			setIS(getIS());
			((X3DConcreteElement) IS).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) IS).getValidationResult());
		}
            if (hasUSE() && hasIS()) // test USE restrictions
            {
                String errorNotice = "*** SpatialSound USE='" + getUSE() + "' is not allowed to have contained SFNode IS";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (metadata != null)
		{
			setMetadata(getMetadata());
			((X3DConcreteElement) metadata).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadata).getValidationResult());
		}
		if (metadataProtoInstance != null)
		{
			setMetadata(getMetadataProtoInstance());
			((X3DConcreteElement) metadataProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadataProtoInstance).getValidationResult());
		}
		if ((metadata != null) && (metadataProtoInstance != null))
		{
			String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
            if (hasUSE() && hasMetadata()) // test USE restrictions
            {
                String errorNotice = "*** SpatialSound USE='" + getUSE() + "' is not allowed to have contained SFNode metadata";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (getIS() != null)
		{
			if (getIS().getConnectList().isEmpty())
			{
				String errorNotice = "*** IS statement present, but contains no connect statements";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
			}
			// TODO also check that this node has ancestor ProtoBody, and that a field with same name also exists, so that IS is legal
		}
		if (!getContainerFieldOverride().isBlank() &&
			!Arrays.asList(containerField_ALLOWED_VALUES).contains(getContainerFieldOverride()))
		{
			String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE +
				": illegal value encountered, containerField='" + getContainerFieldOverride() +
				"' but allowed values are containerField_ALLOWED_VALUES='" +
				new MFString(containerField_ALLOWED_VALUES).toStringX3D() + "'.";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
		}

		// profile validation test, if connected to full scene
		if (findAncestorX3D() != null)
		{
			String     modelProfile = findAncestorX3D().getProfile();

			// check whether model has a satisfactory profile for this node
			boolean hasSatisfactorySupport = findAncestorX3D().supportsX3dProfile   (modelProfile) ||
                                             findAncestorX3D().supportsX3dComponent (COMPONENT, LEVEL);

			if (!hasSatisfactorySupport)
			{
				String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE +
					" insufficient X3D profile='" + modelProfile +
					"' for current X3D model containing 'SpatialSound' node, ensure sufficient support by adding head statement <component name='Sound' level='2'/>\n" +
					"or Java source-code assignment: " +
					" findAncestorX3D().getHead().addComponent(\"Sound\").setLevel(2);";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
			}
		}
		return validationResult.toString();
	}
}
