/*
Web3D Consortium Open-Source License for Models and Software

Copyright (c) 1995-2025 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.VolumeRendering;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Texturing3D.*;

/**
 * SilhouetteEnhancementVolumeStyle specifies that volumetric data is rendered with silhouette enhancement.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>SilhouetteEnhancementVolumeStyle node tooltip</i>: (X3D version 3.3 or later) [X3DComposableVolumeRenderStyleNode] SilhouetteEnhancementVolumeStyle specifies that volumetric data is rendered with silhouette enhancement.
 * <ul>
 *  <li> <i>Hint:</i> SilhouetteEnhancementVolumeStyle can contain a single Texture3D node with containerField='surfaceNormals' </li> 
 *  <li> <i>Warning:</i>  requires X3D profile='Full' or else include &amp;lt;component name='VolumeRendering' level='2'/&amp;gt; </li> 
 * </ul>
 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#SilhouetteEnhancementVolumeStyle" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/volume.html#SilhouetteEnhancementVolumeStyle" target="blank">X3D Abstract Specification: SilhouetteEnhancementVolumeStyle</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#SilhouetteEnhancementVolumeStyle" target="_blank">X3D Tooltips: SilhouetteEnhancementVolumeStyle</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Volume" target="_blank">X3D Scene Authoring Hints: Volume</a>
 */
public interface SilhouetteEnhancementVolumeStyle extends  org.web3d.x3d.sai.VolumeRendering.X3DComposableVolumeRenderStyleNode
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @return value of enabled field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DComposableVolumeRenderStyleNode, $additionalInheritanceBaseType=, $thisClassName=SilhouetteEnhancementVolumeStyle, $CamelCaseName=Enabled, $memberObjectName=enabled, $memberObjectName=enabled)

	public boolean getEnabled();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @param newValue is new value for the enabled field.
	 * @return {@link SilhouetteEnhancementVolumeStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SilhouetteEnhancementVolumeStyle setEnabled(boolean newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DComposableVolumeRenderStyleNode, $additionalInheritanceBaseType=, $thisClassName=SilhouetteEnhancementVolumeStyle, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link SilhouetteEnhancementVolumeStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SilhouetteEnhancementVolumeStyle setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>silhouetteBoundaryOpacity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] amount of the silhouette enhancement to use.  * <br>

	 * @return value of silhouetteBoundaryOpacity field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DComposableVolumeRenderStyleNode, $additionalInheritanceBaseType=, $thisClassName=SilhouetteEnhancementVolumeStyle, $CamelCaseName=SilhouetteBoundaryOpacity, $memberObjectName=silhouetteBoundaryOpacity, $memberObjectName=silhouetteBoundaryOpacity)
	public float getSilhouetteBoundaryOpacity();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>silhouetteBoundaryOpacity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] amount of the silhouette enhancement to use.  * <br>

	 * @param newValue is new value for the silhouetteBoundaryOpacity field.
	 * @return {@link SilhouetteEnhancementVolumeStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SilhouetteEnhancementVolumeStyle setSilhouetteBoundaryOpacity(float newValue);

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>silhouetteRetainedOpacity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] scaling of non-silhouette regions.  * <br>

	 * @return value of silhouetteRetainedOpacity field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DComposableVolumeRenderStyleNode, $additionalInheritanceBaseType=, $thisClassName=SilhouetteEnhancementVolumeStyle, $CamelCaseName=SilhouetteRetainedOpacity, $memberObjectName=silhouetteRetainedOpacity, $memberObjectName=silhouetteRetainedOpacity)
	public float getSilhouetteRetainedOpacity();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>silhouetteRetainedOpacity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] scaling of non-silhouette regions.  * <br>

	 * @param newValue is new value for the silhouetteRetainedOpacity field.
	 * @return {@link SilhouetteEnhancementVolumeStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SilhouetteEnhancementVolumeStyle setSilhouetteRetainedOpacity(float newValue);

	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>silhouetteSharpness</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) power function to control sharpness of the silhouette.  * <br>

	 * @return value of silhouetteSharpness field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DComposableVolumeRenderStyleNode, $additionalInheritanceBaseType=, $thisClassName=SilhouetteEnhancementVolumeStyle, $CamelCaseName=SilhouetteSharpness, $memberObjectName=silhouetteSharpness, $memberObjectName=silhouetteSharpness)
	public float getSilhouetteSharpness();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>silhouetteSharpness</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) power function to control sharpness of the silhouette.  * <br>

	 * @param newValue is new value for the silhouetteSharpness field.
	 * @return {@link SilhouetteEnhancementVolumeStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SilhouetteEnhancementVolumeStyle setSilhouetteSharpness(float newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Texturing3D.X3DTexture3DNode instance (using a properly typed node) from inputOutput SFNode field <i>surfaceNormals</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DTexture3DNode] The surfaceNormals field contains a 3D texture with at least three component values. Each voxel in the texture represents the surface normal direction for the corresponding voxel in the base data source.  * <br>

	 * @return value of surfaceNormals field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DComposableVolumeRenderStyleNode, $additionalInheritanceBaseType=, $thisClassName=SilhouetteEnhancementVolumeStyle, $CamelCaseName=SurfaceNormals, $memberObjectName=surfaceNormals, $memberObjectName=surfaceNormals)
	public  org.web3d.x3d.sai.Texturing3D.X3DTexture3DNode getSurfaceNormals(); // acceptable node types #1: X3DTexture3DNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing3D.X3DTexture3DNode instance (using a properly typed node) to inputOutput SFNode field <i>surfaceNormals</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DTexture3DNode] The surfaceNormals field contains a 3D texture with at least three component values. Each voxel in the texture represents the surface normal direction for the corresponding voxel in the base data source.  * <br>

	 * @param newValue is new value for the surfaceNormals field.
	 * @return {@link SilhouetteEnhancementVolumeStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SilhouetteEnhancementVolumeStyle setSurfaceNormals( org.web3d.x3d.sai.Texturing3D.X3DTexture3DNode newValue); // acceptable node types #2: X3DTexture3DNode

}
