/*
Web3D Consortium Open-Source License for Models and Software

Copyright (c) 1995-2025 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.Sound;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;
import java.util.Arrays;

/**
 * The SpatialSound node controls the 3D spatialization of sound playback by a child AudioClip or MovieTexture node.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>SpatialSound node tooltip</i>: [X3DSoundNode] The SpatialSound node controls the 3D spatialization of sound playback by a child AudioClip or MovieTexture node. Sound intensity includes stereo support, varying according to user location and view direction in the scene.
 * <ul>
 *  <li> <i>Hint:</i> if the audio source is stereo or multi-channel, channel separation is retained during playback. </li> 
 *  <li> <i>Warning:</i> while providing sounds on the ground plane, ensure that the audible auralization volume is sufficiently elevated to match avatar height. </li> 
 *  <li> <i>Hint:</i> X3D Sound component Figure 16.2 Sound Node Geometry, <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-Soundnodegeometry" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-Soundnodegeometry</a> </li> 
 *  <li> <i>Hint:</i> W3C Web Audio API, PannerNode Interface <a href="https://www.w3.org/TR/webaudio/#pannernode" target="_blank">https://www.w3.org/TR/webaudio/#pannernode</a> </li> 
 *  <li> <i>Hint:</i> X3D Scene Authoring Hints:Audio <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Audio" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Audio</a> </li> 
 *  <li> <i>Hint:</i>  Wikipedia 3D sound localization <a href="https://en.wikipedia.org/wiki/3D_sound_localization" target="_blank">https://en.wikipedia.org/wiki/3D_sound_localization</a> </li> 
 * </ul>
 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#SpatialSound" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#Sound" target="blank">X3D Abstract Specification: SpatialSound</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#SpatialSound" target="_blank">X3D Tooltips: SpatialSound</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public interface SpatialSound extends  org.web3d.x3d.sai.Sound.X3DSoundNode
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide array of org.web3d.x3d.sai.Core.X3DNode results (using an array consisting of properly typed nodes or ProtoInstances) with acceptable node types limited to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper, from inputOutput MFNode field <i>children</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSoundChannelNode|X3DSoundProcessingNode|X3DSoundSourceNode] The children field specifies audio-graph sound sources providing input signals for this node. If multiple input signals are provided by the inputs children field, all channels are mixed together and merged prior to presentation.
 * <ul>
 *  <li> <i>Warning:</i> contained AudioClip or MovieTexture nodes must have containerField='children' to override otherwise-incorrect defaults. </li> 
 *  <li> <i>Hint:</i>  can be original (DEF) or referenced (USE) nodes. </li> 
 * </ul>
	 * <br><br>
	 * <i>Warning:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper.
	 * @see org.web3d.x3d.jsail.Sound.Analyser
	 * @see org.web3d.x3d.jsail.Sound.AudioClip
	 * @see org.web3d.x3d.jsail.Sound.AudioDestination
	 * @see org.web3d.x3d.jsail.Sound.BiquadFilter
	 * @see org.web3d.x3d.jsail.Sound.BufferAudioSource
	 * @see org.web3d.x3d.jsail.Sound.ChannelMerger
	 * @see org.web3d.x3d.jsail.Sound.ChannelSelector
	 * @see org.web3d.x3d.jsail.Sound.ChannelSplitter
	 * @see org.web3d.x3d.jsail.Sound.Convolver
	 * @see org.web3d.x3d.jsail.Sound.Delay
	 * @see org.web3d.x3d.jsail.Sound.DynamicsCompressor
	 * @see org.web3d.x3d.jsail.Sound.Gain
	 * @see org.web3d.x3d.jsail.Sound.ListenerPointSource
	 * @see org.web3d.x3d.jsail.Sound.MicrophoneSource
	 * @see org.web3d.x3d.jsail.Texturing.MovieTexture
	 * @see org.web3d.x3d.jsail.Sound.OscillatorSource
	 * @see org.web3d.x3d.jsail.Sound.Sound
	 * @see org.web3d.x3d.jsail.Sound.SpatialSound
	 * @see org.web3d.x3d.jsail.Sound.StreamAudioDestination
	 * @see org.web3d.x3d.jsail.Sound.StreamAudioSource
	 * @see org.web3d.x3d.jsail.Sound.WaveShaper
	 * @return value of children field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Children, $memberObjectName=children, $memberObjectName=children)
	public org.web3d.x3d.sai.Core.X3DNode[] getChildren(); // acceptable node types #1: Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper

	/**
	 * Accessor method to assign org.web3d.x3d.sai.Core.X3DNode array (using an array consisting of properly typed nodes or ProtoInstances) to inputOutput MFNode field <i>children</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSoundChannelNode|X3DSoundProcessingNode|X3DSoundSourceNode] The children field specifies audio-graph sound sources providing input signals for this node. If multiple input signals are provided by the inputs children field, all channels are mixed together and merged prior to presentation.
 * <ul>
 *  <li> <i>Warning:</i> contained AudioClip or MovieTexture nodes must have containerField='children' to override otherwise-incorrect defaults. </li> 
 *  <li> <i>Hint:</i>  can be original (DEF) or referenced (USE) nodes. </li> 
 * </ul>
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper.
	 * @param newValue is new value for the children field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setChildren(org.web3d.x3d.sai.Core.X3DNode[] newValue); // acceptable node types #2: Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper

	/**
	 * Add array of children nodes to array of existing nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper.
	 * @param newValue is new value array to be appended the children field.
	 */
	public void addChildren(org.web3d.x3d.sai.Core.X3DNode[] newValue); // acceptable node types #3: Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper
	/**
	 * Set single children node, replacing prior array of existing nodes (if any).
	 * @param newValue is new node for the children field
	 */
	public void setChildren(org.web3d.x3d.sai.Core.X3DNode newValue); // acceptable node types #5: Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper
	/**
	 * Provide float value unit axis, angle (in radians) within allowed range of [0,6.2832] from inputOutput SFFloat field named <i>coneInnerAngle</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,2pi] coneInnerAngle is centered along direction and defines the inner conical volume, inside of which no source gain reduction occurs.
 * <ul>
 *  <li> <i>Hint:</i> coneOuterAngle value is greater than or equal to coneInnerAngle. </li> 
 *  <li> <i>Hint:</i>  X3D4 Architecture Figure 16.3, SpatialSound Panning Gain Relationships <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-AudioPannerListenerRelationships" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-AudioPannerListenerRelationships</a> </li> 
 * </ul>
	 * @return value of coneInnerAngle field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=ConeInnerAngle, $memberObjectName=coneInnerAngle, $memberObjectName=coneInnerAngle)
	public float getConeInnerAngle();

	/**
	 * Accessor method to assign float value unit axis, angle (in radians) to inputOutput SFFloat field named <i>coneInnerAngle</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,2pi] coneInnerAngle is centered along direction and defines the inner conical volume, inside of which no source gain reduction occurs.
 * <ul>
 *  <li> <i>Hint:</i> coneOuterAngle value is greater than or equal to coneInnerAngle. </li> 
 *  <li> <i>Hint:</i>  X3D4 Architecture Figure 16.3, SpatialSound Panning Gain Relationships <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-AudioPannerListenerRelationships" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-AudioPannerListenerRelationships</a> </li> 
 * </ul>
	 * @param newValue is new value for the coneInnerAngle field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setConeInnerAngle(float newValue);

	/**
	 * Provide float value unit axis, angle (in radians) within allowed range of [0,6.2832] from inputOutput SFFloat field named <i>coneOuterAngle</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,2pi] coneOuterAngle is centered along direction and defines an outer conical volume, within which the sound gain decreases linearly from full gain to coneOuterGain. Outside of coneOuterAngle, gain equals coneOuterGain.
 * <ul>
 *  <li> <i>Hint:</i> coneOuterAngle value is greater than or equal to coneInnerAngle. </li> 
 *  <li> <i>Hint:</i>  X3D4 Architecture Figure 16.3, SpatialSound Panning Gain Relationships <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-AudioPannerListenerRelationships" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-AudioPannerListenerRelationships</a> </li> 
 * </ul>
	 * @return value of coneOuterAngle field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=ConeOuterAngle, $memberObjectName=coneOuterAngle, $memberObjectName=coneOuterAngle)
	public float getConeOuterAngle();

	/**
	 * Accessor method to assign float value unit axis, angle (in radians) to inputOutput SFFloat field named <i>coneOuterAngle</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,2pi] coneOuterAngle is centered along direction and defines an outer conical volume, within which the sound gain decreases linearly from full gain to coneOuterGain. Outside of coneOuterAngle, gain equals coneOuterGain.
 * <ul>
 *  <li> <i>Hint:</i> coneOuterAngle value is greater than or equal to coneInnerAngle. </li> 
 *  <li> <i>Hint:</i>  X3D4 Architecture Figure 16.3, SpatialSound Panning Gain Relationships <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-AudioPannerListenerRelationships" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/sound.html#f-AudioPannerListenerRelationships</a> </li> 
 * </ul>
	 * @param newValue is new value for the coneOuterAngle field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setConeOuterAngle(float newValue);

	/**
	 * Provide float value from inputOutput SFFloat field named <i>coneOuterGain</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (-infinity,+infinity) coneOuterGain is minimum gain value found outside coneOuterAngle.  * <br>

	 * @return value of coneOuterGain field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=ConeOuterGain, $memberObjectName=coneOuterGain, $memberObjectName=coneOuterGain)
	public float getConeOuterGain();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>coneOuterGain</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (-infinity,+infinity) coneOuterGain is minimum gain value found outside coneOuterAngle.  * <br>

	 * @param newValue is new value for the coneOuterGain field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setConeOuterGain(float newValue);

	/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Author-provided prose that describes intended purpose of the url asset.
 * <ul>
 *  <li> <i> Hint:</i>  many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character). </li> 
 * </ul>
	 * @return value of description field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)

	public String getDescription();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Author-provided prose that describes intended purpose of the url asset.
 * <ul>
 *  <li> <i> Hint:</i>  many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character). </li> 
 * </ul>
	 * @param newValue is new value for the description field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setDescription(String newValue);

	/**
	 * Provide array of 3-tuple float results from inputOutput SFVec3f field named <i>direction</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  direction of sound axis, relative to local coordinate system.  * <br>

	 * @return value of direction field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Direction, $memberObjectName=direction, $memberObjectName=direction)
	public float[] getDirection();

	/**
	 * Accessor method to assign 3-tuple float array to inputOutput SFVec3f field named <i>direction</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  direction of sound axis, relative to local coordinate system.  * <br>

	 * @param newValue is new value for the direction field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setDirection(float[] newValue);

	/**
	 * Provide String enumeration value (baseType SFString) ["LINEAR" | "INVERSE" | "EXPONENTIAL"] from inputOutput SFString field named <i>distanceModel</i>.
	 * <br><br>
	 * <i>Tooltip:</i> distanceModel determines how field specifies which algorithm to use for sound attenuation, corresponding to distance between an audio source and a listener, as it moves away from the listener.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#enumdef-distancemodeltype" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-distancemodeltype</a> </li> 
 * </ul>
	 * @return value of distanceModel field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=DistanceModel, $memberObjectName=distanceModel, $memberObjectName=distanceModel)
	public String getDistanceModel();

	/**
	 * Accessor method to assign String enumeration value ("LINEAR" | "INVERSE" | "EXPONENTIAL") to inputOutput SFString field named <i>distanceModel</i>.
	 * <br><br>
	 * <i>Tooltip:</i> distanceModel determines how field specifies which algorithm to use for sound attenuation, corresponding to distance between an audio source and a listener, as it moves away from the listener.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#enumdef-distancemodeltype" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-distancemodeltype</a> </li> 
 * </ul>
	 * @param newValue is new value for the distanceModel field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setDistanceModel(String newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>dopplerEnabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i> dopplerEnabled enables/disables whether real-time Doppler effects (due to relation motion between sources and listeners) are computed by browser between virtual sound sources and active listening locations, then applied to received frequency at active listening locations.
 * <ul>
 *  <li> <i>Hint:</i> functional support requires player support for Sound component level 3. </li> 
 *  <li> <i>Hint:</i>  Wikipedia Doppler effect <a href="https://en.wikipedia.org/wiki/Doppler_effect" target="_blank">https://en.wikipedia.org/wiki/Doppler_effect</a> </li> 
 * </ul>
	 * @return value of dopplerEnabled field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=DopplerEnabled, $memberObjectName=dopplerEnabled, $memberObjectName=dopplerEnabled)
	public boolean getDopplerEnabled();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>dopplerEnabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i> dopplerEnabled enables/disables whether real-time Doppler effects (due to relation motion between sources and listeners) are computed by browser between virtual sound sources and active listening locations, then applied to received frequency at active listening locations.
 * <ul>
 *  <li> <i>Hint:</i> functional support requires player support for Sound component level 3. </li> 
 *  <li> <i>Hint:</i>  Wikipedia Doppler effect <a href="https://en.wikipedia.org/wiki/Doppler_effect" target="_blank">https://en.wikipedia.org/wiki/Doppler_effect</a> </li> 
 * </ul>
	 * @param newValue is new value for the dopplerEnabled field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setDopplerEnabled(boolean newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @return value of enabled field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Enabled, $memberObjectName=enabled, $memberObjectName=enabled)

	public boolean getEnabled();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @param newValue is new value for the enabled field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setEnabled(boolean newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>enableHRTF</i>.
	 * <br><br>
	 * <i>Tooltip:</i> enableHRTF enables/disables Head Related Transfer Function (HRTF) auralization, if available. SpatialSound enabledHRTF=true corresponds to panningModelType HRTF, enabledHRTF=false corresponds to panningModelType equalpower.
 * <ul>
 *  <li> <i>Hint:</i> W3C Audio API <a href="https://www.w3.org/TR/webaudio/#enumdef-panningmodeltype" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-panningmodeltype</a> </li> 
 *  <li> <i>Hint:</i>  Wikipedia HRTF <a href="https://en.wikipedia.org/wiki/3D_sound_localization#Head-related_Transfer_Function_(HRTF)" target="_blank">https://en.wikipedia.org/wiki/3D_sound_localization#Head-related_Transfer_Function_(HRTF)</a> </li> 
 * </ul>
	 * @return value of enableHRTF field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=EnableHRTF, $memberObjectName=enableHRTF, $memberObjectName=enableHRTF)
	public boolean getEnableHRTF();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>enableHRTF</i>.
	 * <br><br>
	 * <i>Tooltip:</i> enableHRTF enables/disables Head Related Transfer Function (HRTF) auralization, if available. SpatialSound enabledHRTF=true corresponds to panningModelType HRTF, enabledHRTF=false corresponds to panningModelType equalpower.
 * <ul>
 *  <li> <i>Hint:</i> W3C Audio API <a href="https://www.w3.org/TR/webaudio/#enumdef-panningmodeltype" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-panningmodeltype</a> </li> 
 *  <li> <i>Hint:</i>  Wikipedia HRTF <a href="https://en.wikipedia.org/wiki/3D_sound_localization#Head-related_Transfer_Function_(HRTF)" target="_blank">https://en.wikipedia.org/wiki/3D_sound_localization#Head-related_Transfer_Function_(HRTF)</a> </li> 
 * </ul>
	 * @param newValue is new value for the enableHRTF field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setEnableHRTF(boolean newValue);

	/**
	 * Provide float value from inputOutput SFFloat field named <i>gain</i>.
	 * <br><br>
	 * <i>Tooltip:</i> (-infinity,+infinity) The gain field is a factor that represents the amount of linear amplification to apply to the output of the node.
 * <ul>
 *  <li> <i>Warning:</i> Decibel values shall not be used. </li> 
 *  <li> <i>Hint:</i>  Negative gain factors negate the input signal. </li> 
 * </ul>
	 * @return value of gain field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Gain, $memberObjectName=gain, $memberObjectName=gain)
	public float getGain();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>gain</i>.
	 * <br><br>
	 * <i>Tooltip:</i> (-infinity,+infinity) The gain field is a factor that represents the amount of linear amplification to apply to the output of the node.
 * <ul>
 *  <li> <i>Warning:</i> Decibel values shall not be used. </li> 
 *  <li> <i>Hint:</i>  Negative gain factors negate the input signal. </li> 
 * </ul>
	 * @param newValue is new value for the gain field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setGain(float newValue);

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>intensity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Factor [0,1] adjusting loudness (decibels) of emitted sound.  * <br>

	 * @return value of intensity field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Intensity, $memberObjectName=intensity, $memberObjectName=intensity)
	public float getIntensity();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>intensity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Factor [0,1] adjusting loudness (decibels) of emitted sound.  * <br>

	 * @param newValue is new value for the intensity field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setIntensity(float newValue);

	/**
	 * Provide array of 3-tuple float results from inputOutput SFVec3f field named <i>location</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,+infinity) Position of sound ellipsoid center, relative to local coordinate system.
 * <ul>
 *  <li> <i> Hint:</i>  improve audibility by setting location='0 1.6 0' so that center height of sound ellipsoid matches typical NavigationInfo avatarSize height. </li> 
 * </ul>
	 * @return value of location field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Location, $memberObjectName=location, $memberObjectName=location)
	public float[] getLocation();

	/**
	 * Accessor method to assign 3-tuple float array to inputOutput SFVec3f field named <i>location</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,+infinity) Position of sound ellipsoid center, relative to local coordinate system.
 * <ul>
 *  <li> <i> Hint:</i>  improve audibility by setting location='0 1.6 0' so that center height of sound ellipsoid matches typical NavigationInfo avatarSize height. </li> 
 * </ul>
	 * @param newValue is new value for the location field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setLocation(float[] newValue);

	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>maxDistance</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) maxDistance is the maximum distance where sound is renderable between source and listener, after which no reduction in sound volume occurs.  * <br>

	 * @return value of maxDistance field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=MaxDistance, $memberObjectName=maxDistance, $memberObjectName=maxDistance)
	public float getMaxDistance();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>maxDistance</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) maxDistance is the maximum distance where sound is renderable between source and listener, after which no reduction in sound volume occurs.  * <br>

	 * @param newValue is new value for the maxDistance field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setMaxDistance(float newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SpatialSound setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>priority</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Player hint [0,1] if needed to choose which sounds to play.  * <br>

	 * @return value of priority field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Priority, $memberObjectName=priority, $memberObjectName=priority)
	public float getPriority();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>priority</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Player hint [0,1] if needed to choose which sounds to play.  * <br>

	 * @param newValue is new value for the priority field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setPriority(float newValue);

	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>referenceDistance</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,+infinity) referenceDistance for reducing volume as source moves further from the listener. For distances less than this value, volume is not reduced.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#dom-pannernode-refdistance" target="_blank">https://www.w3.org/TR/webaudio/#dom-pannernode-refdistance</a> </li> 
 * </ul>
	 * @return value of referenceDistance field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=ReferenceDistance, $memberObjectName=referenceDistance, $memberObjectName=referenceDistance)
	public float getReferenceDistance();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>referenceDistance</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,+infinity) referenceDistance for reducing volume as source moves further from the listener. For distances less than this value, volume is not reduced.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#dom-pannernode-refdistance" target="_blank">https://www.w3.org/TR/webaudio/#dom-pannernode-refdistance</a> </li> 
 * </ul>
	 * @param newValue is new value for the referenceDistance field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setReferenceDistance(float newValue);

	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>rolloffFactor</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,+infinity) rolloffFactor indicates how quickly volume is reduced as source moves further from listener.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#dom-pannernode-rollofffactor" target="_blank">https://www.w3.org/TR/webaudio/#dom-pannernode-rollofffactor</a> </li> 
 * </ul>
	 * @return value of rolloffFactor field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=RolloffFactor, $memberObjectName=rolloffFactor, $memberObjectName=rolloffFactor)
	public float getRolloffFactor();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>rolloffFactor</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,+infinity) rolloffFactor indicates how quickly volume is reduced as source moves further from listener.
 * <ul>
 *  <li> <i> Hint:</i>  W3C Web Audio API <a href="https://www.w3.org/TR/webaudio/#dom-pannernode-rollofffactor" target="_blank">https://www.w3.org/TR/webaudio/#dom-pannernode-rollofffactor</a> </li> 
 * </ul>
	 * @param newValue is new value for the rolloffFactor field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setRolloffFactor(float newValue);

	/**
	 * Provide boolean value from initializeOnly SFBool field named <i>spatialize</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Whether to spatialize sound playback relative to viewer.
 * <ul>
 *  <li> <i> Hint:</i>  only effective within the auralization volume. </li> 
 * </ul>
	 * @return value of spatialize field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundNode, $additionalInheritanceBaseType=, $thisClassName=SpatialSound, $CamelCaseName=Spatialize, $memberObjectName=spatialize, $memberObjectName=spatialize)
	public boolean getSpatialize();

	/**
	 * Accessor method to assign boolean value to initializeOnly SFBool field named <i>spatialize</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Whether to spatialize sound playback relative to viewer.
 * <ul>
 *  <li> <i> Hint:</i>  only effective within the auralization volume. </li> 
 * </ul>
	 * @param newValue is new value for the spatialize field.
	 * @return {@link SpatialSound} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SpatialSound setSpatialize(boolean newValue);

}
