/*
Web3D Consortium Open-Source License for Models and Software

Copyright (c) 1995-2025 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.Shape;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Texturing.*;
// import org.web3d.x3d.sai.Texturing.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Texturing.*;
// import org.web3d.x3d.sai.Texturing.*;
// import org.web3d.x3d.sai.Texturing.*;

/**
 * PhysicalMaterial specifies surface rendering properties for associated geometry nodes.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>PhysicalMaterial node tooltip</i>: [X3DOneSidedMaterialNode] PhysicalMaterial specifies surface rendering properties for associated geometry nodes. Material attributes are used by the X3D lighting equations during rendering.
 * <ul>
 *  <li> <i>Hint:</i> insert Shape and Appearance nodes before adding material. </li> 
 *  <li> <i>Hint:</i> DEF/USE copies of a single node can provide a similar "look + feel" style for related shapes in a scene. </li> 
 *  <li> <i>Hint:</i> X3D Scene Authoring Hints, Color <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Color" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Color</a> </li> 
 *  <li> <i>Hint:</i> X3D Example Archives, Basic, Universal Media Materials <a href="https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials</a> </li> 
 *  <li> <i>Hint:</i> X3D Architecture 17.2.2 Lighting model <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/lighting.html#Lightingmodel" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/lighting.html#Lightingmodel</a> </li> 
 *  <li> <i>Hint:</i> Rendering <a href="https://en.wikipedia.org/wiki/Rendering_(computer_graphics)" target="_blank">https://en.wikipedia.org/wiki/Rendering_(computer_graphics)</a> </li> 
 *  <li> <i>Hint:</i> 3D rendering <a href="https://en.wikipedia.org/wiki/3D_rendering" target="_blank">https://en.wikipedia.org/wiki/3D_rendering</a> </li> 
 *  <li> <i>Hint:</i>  Physically based rendering (PBR) <a href="https://en.wikipedia.org/wiki/Physically_based_rendering" target="_blank">https://en.wikipedia.org/wiki/Physically_based_rendering</a> </li> 
 * </ul>
 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#PhysicalMaterial" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/shape.html#PhysicalMaterial" target="blank">X3D Abstract Specification: PhysicalMaterial</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#PhysicalMaterial" target="_blank">X3D Tooltips: PhysicalMaterial</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public interface PhysicalMaterial extends  org.web3d.x3d.sai.Shape.X3DOneSidedMaterialNode
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide array of 3-tuple float results using RGB values [0..1] using RGB values [0..1] from inputOutput SFColor field named <i>baseColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] similar to diffuseColor, TODO define more precisely.  * <br>

	 * @return value of baseColor field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=BaseColor, $memberObjectName=baseColor, $memberObjectName=baseColor)
	public float[] getBaseColor();

	/**
	 * Accessor method to assign 3-tuple float array using RGB values [0..1] to inputOutput SFColor field named <i>baseColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] similar to diffuseColor, TODO define more precisely.  * <br>

	 * @param newValue is new value for the baseColor field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setBaseColor(float[] newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>baseTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying baseColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='baseTexture'. </li> 
 * </ul>
	 * @return value of baseTexture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=BaseTexture, $memberObjectName=baseTexture, $memberObjectName=baseTexture)
	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getBaseTexture(); // acceptable node types #1: X3DSingleTextureNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>baseTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying baseColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='baseTexture'. </li> 
 * </ul>
	 * @param newValue is new value for the baseTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setBaseTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue); // acceptable node types #2: X3DSingleTextureNode

	/**
	 * Provide String value from inputOutput SFString field named <i>baseTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @return value of baseTextureMapping field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=BaseTextureMapping, $memberObjectName=baseTextureMapping, $memberObjectName=baseTextureMapping)
	public String getBaseTextureMapping();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>baseTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @param newValue is new value for the baseTextureMapping field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setBaseTextureMapping(String newValue);

	/**
	 * Provide array of 3-tuple float results using RGB values [0..1] using RGB values [0..1] from inputOutput SFColor field named <i>emissiveColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] how much glowing light is emitted from this object.
 * <ul>
 *  <li> <i>Hint:</i> emissiveColors glow even when all lights are off. </li> 
 *  <li> <i>Hint:</i> reset diffuseColor from default (.8 .8 .8) to (0 0 0) to avoid washout. </li> 
 *  <li> <i>Hint:</i> only emissiveColor affects IndexedLineSet, LineSet and PointSet. </li> 
 *  <li> <i>Warning:</i>  bright emissiveColor values can wash out other colors and some textures. </li> 
 * </ul>
	 * @return value of emissiveColor field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=EmissiveColor, $memberObjectName=emissiveColor, $memberObjectName=emissiveColor)
	public float[] getEmissiveColor();

	/**
	 * Accessor method to assign 3-tuple float array using RGB values [0..1] to inputOutput SFColor field named <i>emissiveColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] how much glowing light is emitted from this object.
 * <ul>
 *  <li> <i>Hint:</i> emissiveColors glow even when all lights are off. </li> 
 *  <li> <i>Hint:</i> reset diffuseColor from default (.8 .8 .8) to (0 0 0) to avoid washout. </li> 
 *  <li> <i>Hint:</i> only emissiveColor affects IndexedLineSet, LineSet and PointSet. </li> 
 *  <li> <i>Warning:</i>  bright emissiveColor values can wash out other colors and some textures. </li> 
 * </ul>
	 * @param newValue is new value for the emissiveColor field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setEmissiveColor(float[] newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>emissiveTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying emissiveColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='emissiveTexture'. </li> 
 * </ul>
	 * @return value of emissiveTexture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=EmissiveTexture, $memberObjectName=emissiveTexture, $memberObjectName=emissiveTexture)
	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getEmissiveTexture(); // acceptable node types #1: X3DSingleTextureNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>emissiveTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying emissiveColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='emissiveTexture'. </li> 
 * </ul>
	 * @param newValue is new value for the emissiveTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setEmissiveTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue); // acceptable node types #2: X3DSingleTextureNode

	/**
	 * Provide String value from inputOutput SFString field named <i>emissiveTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @return value of emissiveTextureMapping field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=EmissiveTextureMapping, $memberObjectName=emissiveTextureMapping, $memberObjectName=emissiveTextureMapping)

	public String getEmissiveTextureMapping();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>emissiveTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @param newValue is new value for the emissiveTextureMapping field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setEmissiveTextureMapping(String newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>metallic</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] metallic is a PBR parameter (TODO elaborate).  * <br>

	 * @return value of metallic field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=Metallic, $memberObjectName=metallic, $memberObjectName=metallic)
	public float getMetallic();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>metallic</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] metallic is a PBR parameter (TODO elaborate).  * <br>

	 * @param newValue is new value for the metallic field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setMetallic(float newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>metallicRoughnessTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying metallic for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='metallicRoughnessTexture'. </li> 
 * </ul>
	 * @return value of metallicRoughnessTexture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=MetallicRoughnessTexture, $memberObjectName=metallicRoughnessTexture, $memberObjectName=metallicRoughnessTexture)
	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getMetallicRoughnessTexture(); // acceptable node types #1: X3DSingleTextureNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>metallicRoughnessTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying metallic for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='metallicRoughnessTexture'. </li> 
 * </ul>
	 * @param newValue is new value for the metallicRoughnessTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setMetallicRoughnessTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue); // acceptable node types #2: X3DSingleTextureNode

	/**
	 * Provide String value from inputOutput SFString field named <i>metallicRoughnessTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @return value of metallicRoughnessTextureMapping field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=MetallicRoughnessTextureMapping, $memberObjectName=metallicRoughnessTextureMapping, $memberObjectName=metallicRoughnessTextureMapping)
	public String getMetallicRoughnessTextureMapping();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>metallicRoughnessTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @param newValue is new value for the metallicRoughnessTextureMapping field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setMetallicRoughnessTextureMapping(String newValue);

	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>normalScale</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,infinity] normalScale controls the degree to which normalTexture RGB values apply XYZ-normal bump mapping to pixels in the parent material.
 * <ul>
 *  <li> <i>Hint:</i> normalScale only affects computation of normalTexture modulations that affect lighting of characteristics of the parent Material and has no relation to normal vectors defined by corresponding geometry. </li> 
 *  <li> <i>Hint:</i>  normalTexture techniques apply Bump mapping <a href="https://en.wikipedia.org/wiki/Bump_mapping" target="_blank">https://en.wikipedia.org/wiki/Bump_mapping</a> </li> 
 * </ul>
	 * @return value of normalScale field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=NormalScale, $memberObjectName=normalScale, $memberObjectName=normalScale)

	public float getNormalScale();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>normalScale</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,infinity] normalScale controls the degree to which normalTexture RGB values apply XYZ-normal bump mapping to pixels in the parent material.
 * <ul>
 *  <li> <i>Hint:</i> normalScale only affects computation of normalTexture modulations that affect lighting of characteristics of the parent Material and has no relation to normal vectors defined by corresponding geometry. </li> 
 *  <li> <i>Hint:</i>  normalTexture techniques apply Bump mapping <a href="https://en.wikipedia.org/wiki/Bump_mapping" target="_blank">https://en.wikipedia.org/wiki/Bump_mapping</a> </li> 
 * </ul>
	 * @param newValue is new value for the normalScale field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setNormalScale(float newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>normalTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying normalScale for this material node, the contained texture modulates the texture across the surface.
 * <ul>
 *  <li> <i>Hint:</i> normalTexture techniques apply Bump mapping <a href="https://en.wikipedia.org/wiki/Bump_mapping" target="_blank">https://en.wikipedia.org/wiki/Bump_mapping</a> </li> 
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='normalTexture' </li> 
 * </ul>
	 * @return value of normalTexture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=NormalTexture, $memberObjectName=normalTexture, $memberObjectName=normalTexture)
	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getNormalTexture(); // acceptable node types #1: X3DSingleTextureNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>normalTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying normalScale for this material node, the contained texture modulates the texture across the surface.
 * <ul>
 *  <li> <i>Hint:</i> normalTexture techniques apply Bump mapping <a href="https://en.wikipedia.org/wiki/Bump_mapping" target="_blank">https://en.wikipedia.org/wiki/Bump_mapping</a> </li> 
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='normalTexture' </li> 
 * </ul>
	 * @param newValue is new value for the normalTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setNormalTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue); // acceptable node types #2: X3DSingleTextureNode

	/**
	 * Provide String value from inputOutput SFString field named <i>normalTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @return value of normalTextureMapping field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=NormalTextureMapping, $memberObjectName=normalTextureMapping, $memberObjectName=normalTextureMapping)

	public String getNormalTextureMapping();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>normalTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @param newValue is new value for the normalTextureMapping field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setNormalTextureMapping(String newValue);

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>occlusionStrength</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] occlusionStrength indicates areas of indirect lighting, typically called ambient occlusion. Higher values indicate areas that should receive full indirect lighting and lower values indicate no indirect lighting.
 * <ul>
 *  <li> <i>Hint:</i> only the Red channel of the texture is used for occlusion computations, other channels are ignored. </li> 
 *  <li> <i>Hint:</i>  <a href="https://en.wikipedia.org/wiki/Ambient_occlusion" target="_blank">https://en.wikipedia.org/wiki/Ambient_occlusion</a> </li> 
 * </ul>
	 * @return value of occlusionStrength field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=OcclusionStrength, $memberObjectName=occlusionStrength, $memberObjectName=occlusionStrength)
	public float getOcclusionStrength();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>occlusionStrength</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] occlusionStrength indicates areas of indirect lighting, typically called ambient occlusion. Higher values indicate areas that should receive full indirect lighting and lower values indicate no indirect lighting.
 * <ul>
 *  <li> <i>Hint:</i> only the Red channel of the texture is used for occlusion computations, other channels are ignored. </li> 
 *  <li> <i>Hint:</i>  <a href="https://en.wikipedia.org/wiki/Ambient_occlusion" target="_blank">https://en.wikipedia.org/wiki/Ambient_occlusion</a> </li> 
 * </ul>
	 * @param newValue is new value for the occlusionStrength field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setOcclusionStrength(float newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>occlusionTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying occlusionStrength for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='occlusionTexture'. </li> 
 * </ul>
	 * @return value of occlusionTexture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=OcclusionTexture, $memberObjectName=occlusionTexture, $memberObjectName=occlusionTexture)
	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getOcclusionTexture(); // acceptable node types #1: X3DSingleTextureNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>occlusionTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying occlusionStrength for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='occlusionTexture'. </li> 
 * </ul>
	 * @param newValue is new value for the occlusionTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setOcclusionTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue); // acceptable node types #2: X3DSingleTextureNode

	/**
	 * Provide String value from inputOutput SFString field named <i>occlusionTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @return value of occlusionTextureMapping field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=OcclusionTextureMapping, $memberObjectName=occlusionTextureMapping, $memberObjectName=occlusionTextureMapping)
	public String getOcclusionTextureMapping();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>occlusionTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @param newValue is new value for the occlusionTextureMapping field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setOcclusionTextureMapping(String newValue);

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>roughness</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] roughness is a PBR parameter (TODO elaborate).  * <br>

	 * @return value of roughness field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=Roughness, $memberObjectName=roughness, $memberObjectName=roughness)
	public float getRoughness();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>roughness</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] roughness is a PBR parameter (TODO elaborate).  * <br>

	 * @param newValue is new value for the roughness field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setRoughness(float newValue);

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>transparency</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] how "clear" an object is: 1.0 is completely transparent, 0.0 is completely opaque. Interchange profile
 * <ul>
 *  <li> <i> Hint:</i>  transparency &amp;lt; .5 opaque, transparency &amp;gt; .5 transparent. </li> 
 * </ul>
	 * @return value of transparency field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=Transparency, $memberObjectName=transparency, $memberObjectName=transparency)
	public float getTransparency();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>transparency</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] how "clear" an object is: 1.0 is completely transparent, 0.0 is completely opaque. Interchange profile
 * <ul>
 *  <li> <i> Hint:</i>  transparency &amp;lt; .5 opaque, transparency &amp;gt; .5 transparent. </li> 
 * </ul>
	 * @param newValue is new value for the transparency field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setTransparency(float newValue);

}
