/*
Web3D Consortium Open-Source License for Models and Software

Copyright (c) 1995-2025 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.CubeMapTexturing;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Texturing.*;
// import org.web3d.x3d.sai.Texturing.*;
// import org.web3d.x3d.sai.Texturing.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Texturing.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Texturing.*;
// import org.web3d.x3d.sai.Texturing.*;
// import org.web3d.x3d.sai.Texturing.*;

/**
 * ComposedCubeMapTexture is a texture node that defines a cubic environment map source as an explicit set of images drawn from individual 2D texture nodes.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>ComposedCubeMapTexture node tooltip</i>: (X3D version 3.1 or later) [X3DEnvironmentTextureNode] ComposedCubeMapTexture is a texture node that defines a cubic environment map source as an explicit set of images drawn from individual 2D texture nodes.
 * <ul>
 *  <li> <i>Hint:</i> 0..6 child image nodes are allowed (ImageTexture MovieTexture PixelTexture) with corresponding containerField values: front back left right top bottom. </li> 
 *  <li> <i>Warning:</i> each of the child ImageTexture or PixelTexture nodes must have unique containerField values for backTexture, bottomTexture, frontTexture, leftTexture, rightTexture, or topTexture. </li> 
 *  <li> <i>Warning:</i>  fields originally named back, bottom, front, left, right, or top in X3Dv3. </li> 
 * </ul>
 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#ComposedCubeMapTexture" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/environmentalTexturing.html#ComposedCubeMapTexture" target="blank">X3D Abstract Specification: ComposedCubeMapTexture</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#ComposedCubeMapTexture" target="_blank">X3D Tooltips: ComposedCubeMapTexture</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images" target="_blank">X3D Scene Authoring Hints: Images</a>
 */
public interface ComposedCubeMapTexture extends  org.web3d.x3d.sai.CubeMapTexturing.X3DEnvironmentTextureNode
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) from inputOutput SFNode field <i>backTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'back' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @return value of backTexture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=BackTexture, $memberObjectName=backTexture, $memberObjectName=backTexture)
	public  org.web3d.x3d.sai.Texturing.X3DTexture2DNode getBackTexture(); // acceptable node types #1: X3DTexture2DNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) to inputOutput SFNode field <i>backTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'back' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @param newValue is new value for the backTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setBackTexture( org.web3d.x3d.sai.Texturing.X3DTexture2DNode newValue); // acceptable node types #2: X3DTexture2DNode

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) from inputOutput SFNode field <i>bottomTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'bottom' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @return value of bottomTexture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=BottomTexture, $memberObjectName=bottomTexture, $memberObjectName=bottomTexture)
	public  org.web3d.x3d.sai.Texturing.X3DTexture2DNode getBottomTexture(); // acceptable node types #1: X3DTexture2DNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) to inputOutput SFNode field <i>bottomTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'bottom' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @param newValue is new value for the bottomTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setBottomTexture( org.web3d.x3d.sai.Texturing.X3DTexture2DNode newValue); // acceptable node types #2: X3DTexture2DNode

	/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Author-provided prose that describes intended purpose of the url asset.
 * <ul>
 *  <li> <i> Hint:</i>  many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character). </li> 
 * </ul>
	 * @return value of description field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)

	public String getDescription();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Author-provided prose that describes intended purpose of the url asset.
 * <ul>
 *  <li> <i> Hint:</i>  many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character). </li> 
 * </ul>
	 * @param newValue is new value for the description field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ComposedCubeMapTexture setDescription(String newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) from inputOutput SFNode field <i>frontTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'front' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @return value of frontTexture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=FrontTexture, $memberObjectName=frontTexture, $memberObjectName=frontTexture)
	public  org.web3d.x3d.sai.Texturing.X3DTexture2DNode getFrontTexture(); // acceptable node types #1: X3DTexture2DNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) to inputOutput SFNode field <i>frontTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'front' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @param newValue is new value for the frontTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setFrontTexture( org.web3d.x3d.sai.Texturing.X3DTexture2DNode newValue); // acceptable node types #2: X3DTexture2DNode

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) from inputOutput SFNode field <i>leftTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodese).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'left' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @return value of leftTexture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=LeftTexture, $memberObjectName=leftTexture, $memberObjectName=leftTexture)
	public  org.web3d.x3d.sai.Texturing.X3DTexture2DNode getLeftTexture(); // acceptable node types #1: X3DTexture2DNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) to inputOutput SFNode field <i>leftTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodese).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'left' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @param newValue is new value for the leftTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setLeftTexture( org.web3d.x3d.sai.Texturing.X3DTexture2DNode newValue); // acceptable node types #2: X3DTexture2DNode

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ComposedCubeMapTexture setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) from inputOutput SFNode field <i>rightTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'right' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @return value of rightTexture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=RightTexture, $memberObjectName=rightTexture, $memberObjectName=rightTexture)
	public  org.web3d.x3d.sai.Texturing.X3DTexture2DNode getRightTexture(); // acceptable node types #1: X3DTexture2DNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) to inputOutput SFNode field <i>rightTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'right' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @param newValue is new value for the rightTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setRightTexture( org.web3d.x3d.sai.Texturing.X3DTexture2DNode newValue); // acceptable node types #2: X3DTexture2DNode

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.TextureProperties instance (using a properly typed node) from initializeOnly SFNode field <i>textureProperties</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [TextureProperties] Single contained TextureProperties node that can specify additional visual attributes applied to corresponding texture images.
 * <ul>
 *  <li> <i> Warning:</i>  TextureProperties must follow other textures in order to meet XML validation requirements. </li> 
 * </ul>
	 * @return value of textureProperties field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=TextureProperties, $memberObjectName=textureProperties, $memberObjectName=textureProperties)
	public  org.web3d.x3d.sai.Texturing.TextureProperties getTextureProperties(); // acceptable node types #1: TextureProperties

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.TextureProperties instance (using a properly typed node) to initializeOnly SFNode field <i>textureProperties</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [TextureProperties] Single contained TextureProperties node that can specify additional visual attributes applied to corresponding texture images.
 * <ul>
 *  <li> <i> Warning:</i>  TextureProperties must follow other textures in order to meet XML validation requirements. </li> 
 * </ul>
	 * @param newValue is new value for the textureProperties field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setTextureProperties( org.web3d.x3d.sai.Texturing.TextureProperties newValue); // acceptable node types #2: TextureProperties

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) from inputOutput SFNode field <i>topTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'top' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @return value of topTexture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=TopTexture, $memberObjectName=topTexture, $memberObjectName=topTexture)
	public  org.web3d.x3d.sai.Texturing.X3DTexture2DNode getTopTexture(); // acceptable node types #1: X3DTexture2DNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) to inputOutput SFNode field <i>topTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'top' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @param newValue is new value for the topTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setTopTexture( org.web3d.x3d.sai.Texturing.X3DTexture2DNode newValue); // acceptable node types #2: X3DTexture2DNode

}
