/*
Web3D Consortium Open-Source License for Models and Software

Copyright (c) 1995-2025 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.jsail.Shape;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
import org.web3d.x3d.jsail.fields.*; // making sure #4
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;

/**
 * Material specifies surface rendering properties for associated geometry nodes.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>Material node tooltip</i>: [X3DOneSidedMaterialNode] Material specifies surface rendering properties for associated geometry nodes. Material attributes are used by the X3D lighting equations during rendering.
 * <ul>
 *  <li> <i>Hint:</i> insert Shape and Appearance nodes before adding material. </li> 
 *  <li> <i>Hint:</i> DEF/USE copies of a single node can provide a similar "look + feel" style for related shapes in a scene. </li> 
 *  <li> <i>Hint:</i> X3D Scene Authoring Hints, Color <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Color" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Color</a> </li> 
 *  <li> <i>Hint:</i> X3D Example Archives, Basic, Universal Media Materials <a href="https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials</a> </li> 
 *  <li> <i>Hint:</i> X3D Architecture 17.2.2 Lighting model <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/lighting.html#Lightingmodel" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/lighting.html#Lightingmodel</a> </li> 
 *  <li> <i>Hint:</i> Rendering <a href="https://en.wikipedia.org/wiki/Rendering_(computer_graphics)" target="_blank">https://en.wikipedia.org/wiki/Rendering_(computer_graphics)</a> </li> 
 *  <li> <i>Hint:</i> 3D rendering <a href="https://en.wikipedia.org/wiki/3D_rendering" target="_blank">https://en.wikipedia.org/wiki/3D_rendering</a> </li> 
 *  <li> <i>Hint:</i>  Physically based rendering (PBR) <a href="https://en.wikipedia.org/wiki/Physically_based_rendering" target="_blank">https://en.wikipedia.org/wiki/Physically_based_rendering</a> </li> 
 * </ul>
 * <br>
 * Note that {@linkplain SFColor#ALICEBLUE SFColor} provides a variety of color constants.
 * <br>

 * <br>
 * <i>Package hint:</i>  This org.web3d.x3d.jsail concrete class is used for implementing a standalone X3D object as a <a href="https://en.wikipedia.org/wiki/Plain_old_Java_object" target="_blank">Plain Old Java Object (POJO)</a>.
 * If you are writing Java code for use inside an X3D Script node, compile separate code using only the <i>org.web3d.x3d.sai</i> package instead.
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/shape.html#Material" target="blank">X3D Abstract Specification: Material</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#Material" target="_blank">X3D Tooltips: Material</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public class Material extends org.web3d.x3d.jsail.X3DConcreteNode implements org.web3d.x3d.sai.Shape.Material
{
    /** required by internal interface, empty list provided since no children array present in this class */
    private ArrayList<String> commentsList;

    // Member value declarations are encapsulated and private, using preferred Java types for concretes library

    /* @name=ambientIntensity, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=ambientIntensity, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float ambientIntensity; //  X3D field type: SFFloat

    /* @name=ambientTexture, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $normalizedMemberObjectName=ambientTexture, $isX3dStatement=false, @acceptableNodeTypes=X3DSingleTextureNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode ambientTexture; //  X3D field type: SFNode acceptable node types: X3DSingleTextureNode or ProtoInstance
	private ProtoInstance ambientTextureProtoInstance; // allowed alternative for ambientTexture field

    /* @name=ambientTextureMapping, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=ambientTextureMapping, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String ambientTextureMapping = new String(); //  X3D field type: SFString

    /* @name=diffuseColor, @type=SFColor, $javaType=float[], $javaReferenceType=float[], $javaPrimitiveType=float[], $normalizedMemberObjectName=diffuseColor, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float[] diffuseColor; //  X3D field type: SFColor

    /* @name=diffuseTexture, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $normalizedMemberObjectName=diffuseTexture, $isX3dStatement=false, @acceptableNodeTypes=X3DSingleTextureNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode diffuseTexture; //  X3D field type: SFNode acceptable node types: X3DSingleTextureNode or ProtoInstance
	private ProtoInstance diffuseTextureProtoInstance; // allowed alternative for diffuseTexture field

    /* @name=diffuseTextureMapping, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=diffuseTextureMapping, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String diffuseTextureMapping = new String(); //  X3D field type: SFString

    /* @name=emissiveColor, @type=SFColor, $javaType=float[], $javaReferenceType=float[], $javaPrimitiveType=float[], $normalizedMemberObjectName=emissiveColor, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float[] emissiveColor; //  X3D field type: SFColor

    /* @name=emissiveTexture, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $normalizedMemberObjectName=emissiveTexture, $isX3dStatement=false, @acceptableNodeTypes=X3DSingleTextureNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode emissiveTexture; //  X3D field type: SFNode acceptable node types: X3DSingleTextureNode or ProtoInstance
	private ProtoInstance emissiveTextureProtoInstance; // allowed alternative for emissiveTexture field

    /* @name=emissiveTextureMapping, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=emissiveTextureMapping, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String emissiveTextureMapping = new String(); //  X3D field type: SFString

    /* @name=IS, @type=SFNode, $javaType=IS, $javaReferenceType=IS, $javaPrimitiveType=IS, $normalizedMemberObjectName=IS, $isX3dStatement=true, @acceptableNodeTypes=IS */ 
    private IS IS; //  X3D field type: SFNode acceptable node types: IS

    /* @name=metadata, @type=SFNode, $javaType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaReferenceType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaPrimitiveType= org.web3d.x3d.sai.Core.X3DMetadataObject, $normalizedMemberObjectName=metadata, $isX3dStatement=false, @acceptableNodeTypes=X3DMetadataObject */ 
    private  org.web3d.x3d.sai.Core.X3DMetadataObject metadata; //  X3D field type: SFNode acceptable node types: X3DMetadataObject or ProtoInstance
	private ProtoInstance metadataProtoInstance; // allowed alternative for metadata field

    /* @name=normalScale, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=normalScale, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float normalScale; //  X3D field type: SFFloat

    /* @name=normalTexture, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $normalizedMemberObjectName=normalTexture, $isX3dStatement=false, @acceptableNodeTypes=X3DSingleTextureNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode normalTexture; //  X3D field type: SFNode acceptable node types: X3DSingleTextureNode or ProtoInstance
	private ProtoInstance normalTextureProtoInstance; // allowed alternative for normalTexture field

    /* @name=normalTextureMapping, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=normalTextureMapping, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String normalTextureMapping = new String(); //  X3D field type: SFString

    /* @name=occlusionStrength, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=occlusionStrength, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float occlusionStrength; //  X3D field type: SFFloat

    /* @name=occlusionTexture, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $normalizedMemberObjectName=occlusionTexture, $isX3dStatement=false, @acceptableNodeTypes=X3DSingleTextureNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode occlusionTexture; //  X3D field type: SFNode acceptable node types: X3DSingleTextureNode or ProtoInstance
	private ProtoInstance occlusionTextureProtoInstance; // allowed alternative for occlusionTexture field

    /* @name=occlusionTextureMapping, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=occlusionTextureMapping, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String occlusionTextureMapping = new String(); //  X3D field type: SFString

    /* @name=shininess, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=shininess, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float shininess; //  X3D field type: SFFloat

    /* @name=shininessTexture, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $normalizedMemberObjectName=shininessTexture, $isX3dStatement=false, @acceptableNodeTypes=X3DSingleTextureNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode shininessTexture; //  X3D field type: SFNode acceptable node types: X3DSingleTextureNode or ProtoInstance
	private ProtoInstance shininessTextureProtoInstance; // allowed alternative for shininessTexture field

    /* @name=shininessTextureMapping, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=shininessTextureMapping, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String shininessTextureMapping = new String(); //  X3D field type: SFString

    /* @name=specularColor, @type=SFColor, $javaType=float[], $javaReferenceType=float[], $javaPrimitiveType=float[], $normalizedMemberObjectName=specularColor, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float[] specularColor; //  X3D field type: SFColor

    /* @name=specularTexture, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $normalizedMemberObjectName=specularTexture, $isX3dStatement=false, @acceptableNodeTypes=X3DSingleTextureNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode specularTexture; //  X3D field type: SFNode acceptable node types: X3DSingleTextureNode or ProtoInstance
	private ProtoInstance specularTextureProtoInstance; // allowed alternative for specularTexture field

    /* @name=specularTextureMapping, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=specularTextureMapping, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String specularTextureMapping = new String(); //  X3D field type: SFString

    /* @name=transparency, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=transparency, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float transparency; //  X3D field type: SFFloat

	// String constants for default field values match X3D Schema definitions

	/** String constant <i>NAME</i> provides name of this element: <i>Material</i>. */
	@SuppressWarnings("FieldNameHidesFieldInSuperclass")
	public static final String NAME = "Material";

	/** Provides name of this element: <i>Material</i>
	 * @return name of this element
	 */
	@Override
	public final String getElementName()
	{
		return NAME;
	}

	/** String constant <i>COMPONENT</i> defines X3D component for the <i>Material</i> element: <i>Shape</i> */
	public static final String COMPONENT = "Shape";

	/** Defines X3D component for the <i>Material</i> element: <i>Shape</i>
	 * @return X3D component for this element
	 */
	/* @Override */
	public final String getComponent()
	{
		return COMPONENT;
	}

	/** Integer constant <i>LEVEL</i> provides default X3D <i>Shape</i> component level for this element: <i>1</i> */
	public static final int LEVEL = 1;

	/** Provides default X3D component level for this element: <i>1</i>
	 * @return default X3D component level for this element
	 */
	/* @Override */
	public final int getComponentLevel()
	{
		return LEVEL;
	}

            // DEFAULT_VALUE declarations

	/** SFFloat field named <i>ambientIntensity</i> has default value <i>0.2f</i> (Java syntax) or <i>0.2</i> (XML syntax). */
	public static final float AMBIENTINTENSITY_DEFAULT_VALUE = 0.2f;

	/** SFNode field named <i>ambientTexture</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode AMBIENTTEXTURE_DEFAULT_VALUE = null;

	/** SFString field named <i>ambientTextureMapping</i> has default value equal to an empty string. */
	public static final String AMBIENTTEXTUREMAPPING_DEFAULT_VALUE = "";

	/** SFColor field named <i>diffuseColor</i> has default value <i>{0.8f,0.8f,0.8f}</i> (Java syntax) or <i>0.8 0.8 0.8</i> (XML syntax). */
	public static final float[] DIFFUSECOLOR_DEFAULT_VALUE = {0.8f,0.8f,0.8f};

	/** SFNode field named <i>diffuseTexture</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode DIFFUSETEXTURE_DEFAULT_VALUE = null;

	/** SFString field named <i>diffuseTextureMapping</i> has default value equal to an empty string. */
	public static final String DIFFUSETEXTUREMAPPING_DEFAULT_VALUE = "";

	/** SFColor field named <i>emissiveColor</i> has default value <i>{0f,0f,0f}</i> (Java syntax) or <i>0 0 0</i> (XML syntax). */
	public static final float[] EMISSIVECOLOR_DEFAULT_VALUE = {0f,0f,0f};

	/** SFNode field named <i>emissiveTexture</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode EMISSIVETEXTURE_DEFAULT_VALUE = null;

	/** SFString field named <i>emissiveTextureMapping</i> has default value equal to an empty string. */
	public static final String EMISSIVETEXTUREMAPPING_DEFAULT_VALUE = "";

	/** SFNode field named <i>IS</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final IS IS_DEFAULT_VALUE = null;

	/** SFNode field named <i>metadata</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Core.X3DMetadataObject METADATA_DEFAULT_VALUE = null;

	/** SFFloat field named <i>normalScale</i> has default value <i>1f</i> (Java syntax) or <i>1</i> (XML syntax). */
	public static final float NORMALSCALE_DEFAULT_VALUE = 1f;

	/** SFNode field named <i>normalTexture</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode NORMALTEXTURE_DEFAULT_VALUE = null;

	/** SFString field named <i>normalTextureMapping</i> has default value equal to an empty string. */
	public static final String NORMALTEXTUREMAPPING_DEFAULT_VALUE = "";

	/** SFFloat field named <i>occlusionStrength</i> has default value <i>1f</i> (Java syntax) or <i>1</i> (XML syntax). */
	public static final float OCCLUSIONSTRENGTH_DEFAULT_VALUE = 1f;

	/** SFNode field named <i>occlusionTexture</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode OCCLUSIONTEXTURE_DEFAULT_VALUE = null;

	/** SFString field named <i>occlusionTextureMapping</i> has default value equal to an empty string. */
	public static final String OCCLUSIONTEXTUREMAPPING_DEFAULT_VALUE = "";

	/** SFFloat field named <i>shininess</i> has default value <i>0.2f</i> (Java syntax) or <i>0.2</i> (XML syntax). */
	public static final float SHININESS_DEFAULT_VALUE = 0.2f;

	/** SFNode field named <i>shininessTexture</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode SHININESSTEXTURE_DEFAULT_VALUE = null;

	/** SFString field named <i>shininessTextureMapping</i> has default value equal to an empty string. */
	public static final String SHININESSTEXTUREMAPPING_DEFAULT_VALUE = "";

	/** SFColor field named <i>specularColor</i> has default value <i>{0f,0f,0f}</i> (Java syntax) or <i>0 0 0</i> (XML syntax). */
	public static final float[] SPECULARCOLOR_DEFAULT_VALUE = {0f,0f,0f};

	/** SFNode field named <i>specularTexture</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode SPECULARTEXTURE_DEFAULT_VALUE = null;

	/** SFString field named <i>specularTextureMapping</i> has default value equal to an empty string. */
	public static final String SPECULARTEXTUREMAPPING_DEFAULT_VALUE = "";

	/** SFFloat field named <i>transparency</i> has default value <i>0f</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final float TRANSPARENCY_DEFAULT_VALUE = 0f;

	/** Indicate type corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_TYPE
	 * @return X3D type (SFvec3f etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE if not recognized
	 */
	/* @Override */
	public String getFieldType(String fieldName)
	{
		String result;

		switch (fieldName)
		{
			// String constants for exact field type values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing type-matching checks

			case "containerField":
				result = "SFString";
				break;
			case "ambientIntensity":
				result = "SFFloat";
				break;
			case "ambientTexture":
				result = "SFNode";
				break;
			case "ambientTextureMapping":
				result = "SFString";
				break;
			case "diffuseColor":
				result = "SFColor";
				break;
			case "diffuseTexture":
				result = "SFNode";
				break;
			case "diffuseTextureMapping":
				result = "SFString";
				break;
			case "emissiveColor":
				result = "SFColor";
				break;
			case "emissiveTexture":
				result = "SFNode";
				break;
			case "emissiveTextureMapping":
				result = "SFString";
				break;
			case "IS":
				result = "SFNode";
				break;
			case "metadata":
				result = "SFNode";
				break;
			case "normalScale":
				result = "SFFloat";
				break;
			case "normalTexture":
				result = "SFNode";
				break;
			case "normalTextureMapping":
				result = "SFString";
				break;
			case "occlusionStrength":
				result = "SFFloat";
				break;
			case "occlusionTexture":
				result = "SFNode";
				break;
			case "occlusionTextureMapping":
				result = "SFString";
				break;
			case "shininess":
				result = "SFFloat";
				break;
			case "shininessTexture":
				result = "SFNode";
				break;
			case "shininessTextureMapping":
				result = "SFString";
				break;
			case "specularColor":
				result = "SFColor";
				break;
			case "specularTexture":
				result = "SFNode";
				break;
			case "specularTextureMapping":
				result = "SFString";
				break;
			case "transparency":
				result = "SFFloat";
				break;
			case "DEF":
				result = "SFString";
				break;
			case "USE":
				result = "SFString";
				break;
			case "class":
				result = "SFString";
				break;
			case "id":
				result = "SFString";
				break;
			case "style":
				result = "SFString";
				break;
			default:
			{
				// if fieldName has a prefix "set_" prepended (or a suffix "_changed" appended) then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getFieldType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/** Indicate accessType corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_ACCESSTYPE
	 * @return X3D accessType (inputOnly etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE if not recognized
	 */
	/* @Override */
	public String getAccessType(String fieldName)
	{
		String result; // set by following checks
		switch (fieldName)
		{
			// String constants for field accessType values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing accessType-matching checks
			case "ambientIntensity":
				result = "inputOutput";
				break;
			case "ambientTexture":
				result = "inputOutput";
				break;
			case "ambientTextureMapping":
				result = "inputOutput";
				break;
			case "diffuseColor":
				result = "inputOutput";
				break;
			case "diffuseTexture":
				result = "inputOutput";
				break;
			case "diffuseTextureMapping":
				result = "inputOutput";
				break;
			case "emissiveColor":
				result = "inputOutput";
				break;
			case "emissiveTexture":
				result = "inputOutput";
				break;
			case "emissiveTextureMapping":
				result = "inputOutput";
				break;
			case "IS":
				result = "inputOutput";
				break;
			case "metadata":
				result = "inputOutput";
				break;
			case "normalScale":
				result = "inputOutput";
				break;
			case "normalTexture":
				result = "inputOutput";
				break;
			case "normalTextureMapping":
				result = "inputOutput";
				break;
			case "occlusionStrength":
				result = "inputOutput";
				break;
			case "occlusionTexture":
				result = "inputOutput";
				break;
			case "occlusionTextureMapping":
				result = "inputOutput";
				break;
			case "shininess":
				result = "inputOutput";
				break;
			case "shininessTexture":
				result = "inputOutput";
				break;
			case "shininessTextureMapping":
				result = "inputOutput";
				break;
			case "specularColor":
				result = "inputOutput";
				break;
			case "specularTexture":
				result = "inputOutput";
				break;
			case "specularTextureMapping":
				result = "inputOutput";
				break;
			case "transparency":
				result = "inputOutput";
				break;
			case "DEF":
				result = "inputOutput";
				break;
			case "USE":
				result = "inputOutput";
				break;
			case "class":
				result = "inputOutput";
				break;
			case "id":
				result = "inputOutput";
				break;
			case "style":
				result = "inputOutput";
				break;
			default:
			{
				// if user has added a prefix "set_" or suffix "_changed" then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getAccessType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/**
         * containerField describes typical field relationship of a node to its parent.
	 * Usage is not ordinarily needed when using this API, this default value is provided for informational purposes only.
         * <br />
         * containerField_DEFAULT_VALUE = "material";
         * <br />
         * containerField_ALLOWED_VALUES = {"material" };  type xs:NMTOKEN
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField" target="_blank">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerFieldChoices" target="_blank">X3D Scene Authoring Hints: validation choices for containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html" target="_blank">X3D Unified Object Model (X3DUOM)</a>
	 */

	public static final String containerField_DEFAULT_VALUE = "material"; // type xs:NMTOKEN
	/**
         * containerField describes typical field relationship of a node to its parent.
	 * Programmer usage is not ordinarily needed when using this API, since this default value is provided for informational purposes only.
	 * @see #containerField_DEFAULT_VALUE
         * @see org.web3d.x3d.jsail.X3DConcreteNode#containerField_ALLOWED_VALUES
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField" target="_blank">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerFieldChoices" target="_blank">X3D Scene Authoring Hints: validation choices for containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html" target="_blank">X3D Unified Object Model (X3DUOM)</a>
         * @return default containerField value
	 */
        @Override
        public final String getContainerFieldDefault()
        {
            return containerField_DEFAULT_VALUE;
        }

	// String constants for field names usable in ROUTE statements

	/** fromField ROUTE name for SFFloat field named <i>ambientIntensity</i>. */
	public static final String fromField_AMBIENTINTENSITY = "ambientIntensity";

	/** toField ROUTE name for SFFloat field named <i>ambientIntensity</i>. */
	public static final String toField_AMBIENTINTENSITY = "ambientIntensity";

	/** fromField ROUTE name for SFNode field named <i>ambientTexture</i>. */
	public static final String fromField_AMBIENTTEXTURE = "ambientTexture";

	/** toField ROUTE name for SFNode field named <i>ambientTexture</i>. */
	public static final String toField_AMBIENTTEXTURE = "ambientTexture";

	/** fromField ROUTE name for SFString field named <i>ambientTextureMapping</i>. */
	public static final String fromField_AMBIENTTEXTUREMAPPING = "ambientTextureMapping";

	/** toField ROUTE name for SFString field named <i>ambientTextureMapping</i>. */
	public static final String toField_AMBIENTTEXTUREMAPPING = "ambientTextureMapping";

	/** fromField ROUTE name for SFColor field named <i>diffuseColor</i>. */
	public static final String fromField_DIFFUSECOLOR = "diffuseColor";

	/** toField ROUTE name for SFColor field named <i>diffuseColor</i>. */
	public static final String toField_DIFFUSECOLOR = "diffuseColor";

	/** fromField ROUTE name for SFNode field named <i>diffuseTexture</i>. */
	public static final String fromField_DIFFUSETEXTURE = "diffuseTexture";

	/** toField ROUTE name for SFNode field named <i>diffuseTexture</i>. */
	public static final String toField_DIFFUSETEXTURE = "diffuseTexture";

	/** fromField ROUTE name for SFString field named <i>diffuseTextureMapping</i>. */
	public static final String fromField_DIFFUSETEXTUREMAPPING = "diffuseTextureMapping";

	/** toField ROUTE name for SFString field named <i>diffuseTextureMapping</i>. */
	public static final String toField_DIFFUSETEXTUREMAPPING = "diffuseTextureMapping";

	/** fromField ROUTE name for SFColor field named <i>emissiveColor</i>. */
	public static final String fromField_EMISSIVECOLOR = "emissiveColor";

	/** toField ROUTE name for SFColor field named <i>emissiveColor</i>. */
	public static final String toField_EMISSIVECOLOR = "emissiveColor";

	/** fromField ROUTE name for SFNode field named <i>emissiveTexture</i>. */
	public static final String fromField_EMISSIVETEXTURE = "emissiveTexture";

	/** toField ROUTE name for SFNode field named <i>emissiveTexture</i>. */
	public static final String toField_EMISSIVETEXTURE = "emissiveTexture";

	/** fromField ROUTE name for SFString field named <i>emissiveTextureMapping</i>. */
	public static final String fromField_EMISSIVETEXTUREMAPPING = "emissiveTextureMapping";

	/** toField ROUTE name for SFString field named <i>emissiveTextureMapping</i>. */
	public static final String toField_EMISSIVETEXTUREMAPPING = "emissiveTextureMapping";

	/** fromField ROUTE name for SFNode field named <i>IS</i>. */
	public static final String fromField_IS = "IS";

	/** fromField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String fromField_METADATA = "metadata";

	/** toField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String toField_METADATA = "metadata";

	/** fromField ROUTE name for SFFloat field named <i>normalScale</i>. */
	public static final String fromField_NORMALSCALE = "normalScale";

	/** toField ROUTE name for SFFloat field named <i>normalScale</i>. */
	public static final String toField_NORMALSCALE = "normalScale";

	/** fromField ROUTE name for SFNode field named <i>normalTexture</i>. */
	public static final String fromField_NORMALTEXTURE = "normalTexture";

	/** toField ROUTE name for SFNode field named <i>normalTexture</i>. */
	public static final String toField_NORMALTEXTURE = "normalTexture";

	/** fromField ROUTE name for SFString field named <i>normalTextureMapping</i>. */
	public static final String fromField_NORMALTEXTUREMAPPING = "normalTextureMapping";

	/** toField ROUTE name for SFString field named <i>normalTextureMapping</i>. */
	public static final String toField_NORMALTEXTUREMAPPING = "normalTextureMapping";

	/** fromField ROUTE name for SFFloat field named <i>occlusionStrength</i>. */
	public static final String fromField_OCCLUSIONSTRENGTH = "occlusionStrength";

	/** toField ROUTE name for SFFloat field named <i>occlusionStrength</i>. */
	public static final String toField_OCCLUSIONSTRENGTH = "occlusionStrength";

	/** fromField ROUTE name for SFNode field named <i>occlusionTexture</i>. */
	public static final String fromField_OCCLUSIONTEXTURE = "occlusionTexture";

	/** toField ROUTE name for SFNode field named <i>occlusionTexture</i>. */
	public static final String toField_OCCLUSIONTEXTURE = "occlusionTexture";

	/** fromField ROUTE name for SFString field named <i>occlusionTextureMapping</i>. */
	public static final String fromField_OCCLUSIONTEXTUREMAPPING = "occlusionTextureMapping";

	/** toField ROUTE name for SFString field named <i>occlusionTextureMapping</i>. */
	public static final String toField_OCCLUSIONTEXTUREMAPPING = "occlusionTextureMapping";

	/** fromField ROUTE name for SFFloat field named <i>shininess</i>. */
	public static final String fromField_SHININESS = "shininess";

	/** toField ROUTE name for SFFloat field named <i>shininess</i>. */
	public static final String toField_SHININESS = "shininess";

	/** fromField ROUTE name for SFNode field named <i>shininessTexture</i>. */
	public static final String fromField_SHININESSTEXTURE = "shininessTexture";

	/** toField ROUTE name for SFNode field named <i>shininessTexture</i>. */
	public static final String toField_SHININESSTEXTURE = "shininessTexture";

	/** fromField ROUTE name for SFString field named <i>shininessTextureMapping</i>. */
	public static final String fromField_SHININESSTEXTUREMAPPING = "shininessTextureMapping";

	/** toField ROUTE name for SFString field named <i>shininessTextureMapping</i>. */
	public static final String toField_SHININESSTEXTUREMAPPING = "shininessTextureMapping";

	/** fromField ROUTE name for SFColor field named <i>specularColor</i>. */
	public static final String fromField_SPECULARCOLOR = "specularColor";

	/** toField ROUTE name for SFColor field named <i>specularColor</i>. */
	public static final String toField_SPECULARCOLOR = "specularColor";

	/** fromField ROUTE name for SFNode field named <i>specularTexture</i>. */
	public static final String fromField_SPECULARTEXTURE = "specularTexture";

	/** toField ROUTE name for SFNode field named <i>specularTexture</i>. */
	public static final String toField_SPECULARTEXTURE = "specularTexture";

	/** fromField ROUTE name for SFString field named <i>specularTextureMapping</i>. */
	public static final String fromField_SPECULARTEXTUREMAPPING = "specularTextureMapping";

	/** toField ROUTE name for SFString field named <i>specularTextureMapping</i>. */
	public static final String toField_SPECULARTEXTUREMAPPING = "specularTextureMapping";

	/** fromField ROUTE name for SFFloat field named <i>transparency</i>. */
	public static final String fromField_TRANSPARENCY = "transparency";

	/** toField ROUTE name for SFFloat field named <i>transparency</i>. */
	public static final String toField_TRANSPARENCY = "transparency";

	/** Constructor for Material to initialize member variables with default values. */
	public Material()
	{
		super(); // constructor invocation and corresponding initialize()
		initialize();
	}

	/** Initialize all member variables to default values. */
	@Override
	public final void initialize()
	{
		super.initialize();

        setContainerFieldOverride(""); // ensuring default value used
	containerField_ALLOWED_VALUES = new String[] { "material" }; // type xs:NMTOKEN

		ambientIntensity = AMBIENTINTENSITY_DEFAULT_VALUE;
		ambientTexture = null;              // clear out any prior node
		ambientTextureProtoInstance = null; // clear out any prior node
		ambientTextureMapping = AMBIENTTEXTUREMAPPING_DEFAULT_VALUE;
		diffuseColor = DIFFUSECOLOR_DEFAULT_VALUE;
		diffuseTexture = null;              // clear out any prior node
		diffuseTextureProtoInstance = null; // clear out any prior node
		diffuseTextureMapping = DIFFUSETEXTUREMAPPING_DEFAULT_VALUE;
		emissiveColor = EMISSIVECOLOR_DEFAULT_VALUE;
		emissiveTexture = null;              // clear out any prior node
		emissiveTextureProtoInstance = null; // clear out any prior node
		emissiveTextureMapping = EMISSIVETEXTUREMAPPING_DEFAULT_VALUE;
		IS = null; // clear out any prior node
		metadata = null;              // clear out any prior node
		metadataProtoInstance = null; // clear out any prior node
		normalScale = NORMALSCALE_DEFAULT_VALUE;
		normalTexture = null;              // clear out any prior node
		normalTextureProtoInstance = null; // clear out any prior node
		normalTextureMapping = NORMALTEXTUREMAPPING_DEFAULT_VALUE;
		occlusionStrength = OCCLUSIONSTRENGTH_DEFAULT_VALUE;
		occlusionTexture = null;              // clear out any prior node
		occlusionTextureProtoInstance = null; // clear out any prior node
		occlusionTextureMapping = OCCLUSIONTEXTUREMAPPING_DEFAULT_VALUE;
		shininess = SHININESS_DEFAULT_VALUE;
		shininessTexture = null;              // clear out any prior node
		shininessTextureProtoInstance = null; // clear out any prior node
		shininessTextureMapping = SHININESSTEXTUREMAPPING_DEFAULT_VALUE;
		specularColor = SPECULARCOLOR_DEFAULT_VALUE;
		specularTexture = null;              // clear out any prior node
		specularTextureProtoInstance = null; // clear out any prior node
		specularTextureMapping = SPECULARTEXTUREMAPPING_DEFAULT_VALUE;
		transparency = TRANSPARENCY_DEFAULT_VALUE;

		commentsList = new ArrayList<>(); // instantiate, initialize
	}

	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>ambientIntensity</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] how much ambient omnidirectional light is reflected from all light sources. Interchange profile
 * <ul>
 *  <li> <i> Hint:</i>  this field may be ignored, applying the default value regardless. </li> 
 * </ul>
	 * @return value of ambientIntensity field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=AmbientIntensity, $memberObjectName=ambientIntensity, $memberObjectName=ambientIntensity)

	public float getAmbientIntensity()
	{
		return ambientIntensity;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>ambientIntensity</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] how much ambient omnidirectional light is reflected from all light sources. Interchange profile
 * <ul>
 *  <li> <i> Hint:</i>  this field may be ignored, applying the default value regardless. </li> 
 * </ul>
	 * @param newValue is new value for the ambientIntensity field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setAmbientIntensity(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("Material ambientIntensity newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("Material ambientIntensity newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
            }
		ambientIntensity = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat ambientIntensity field, similar to {@link #setAmbientIntensity(float)}.
	 * @param newValue is new value for the ambientIntensity field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setAmbientIntensity(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setAmbientIntensity(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setAmbientIntensity(float)}.
	 * @param newValue is new value for field
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setAmbientIntensity(double newValue)
	{
		return setAmbientIntensity((float) newValue);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>ambientTexture</i>.
	 * @see #getAmbientTextureProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying ambientIntensity for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='ambientTexture'. </li> 
 * </ul>
	 * @return value of ambientTexture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=AmbientTexture, $memberObjectName=ambientTexture, $memberObjectName=ambientTexture)

	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getAmbientTexture()
	{
		return ambientTexture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>ambientTexture</i>.
	 * @see #setAmbientTexture(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying ambientIntensity for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='ambientTexture'. </li> 
 * </ul>
	 * @param newValue is new value for the ambientTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setAmbientTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue)
	{
		// set-newValue-validity-checks #0.a
		ambientTexture = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) ambientTexture).setParent(this); // parentTest15.1
		}
		if (ambientTextureProtoInstance != null)
		{
			ambientTextureProtoInstance.setParent(null); // housekeeping, clear prior object
			ambientTextureProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of ambientTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public Material clearAmbientTexture()
	{
		((X3DConcreteElement) ambientTexture).clearParent(); // remove references to facilitate Java memory management
		ambientTexture = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>ambientTexture</i>.
	 * @see #setAmbientTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode)
	 * @param newValue is new value for the ambientTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setAmbientTexture(ProtoInstance newValue)
	{
		if (ambientTextureProtoInstance != null)
		{
			((X3DConcreteElement) ambientTextureProtoInstance).setParent(null); // parentTest15.5
	    }
		ambientTextureProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) ambientTextureProtoInstance).setParent(this); // parentTest15.6
            ambientTextureProtoInstance.setContainerField("ambientTexture");
	    }
		if (ambientTexture != null)
		{
			((X3DConcreteElement) ambientTexture).setParent(null); // housekeeping, clear prior object
			ambientTexture = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getAmbientTextureProtoInstance()
		{
			return ambientTextureProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>ambientTexture</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getAmbientTexture()
	 * @see #getAmbientTextureProtoInstance()
	 */
	public boolean hasAmbientTexture()
	{
		return (ambientTexture != null) || (ambientTextureProtoInstance != null);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>ambientTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @return value of ambientTextureMapping field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=AmbientTextureMapping, $memberObjectName=ambientTextureMapping, $memberObjectName=ambientTextureMapping)

	public String getAmbientTextureMapping()
	{
		return ambientTextureMapping;
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>ambientTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @param newValue is new value for the ambientTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setAmbientTextureMapping(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		ambientTextureMapping = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString ambientTextureMapping field, similar to {@link #setAmbientTextureMapping(String)}.
	 * @param newValue is new value for the ambientTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setAmbientTextureMapping(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setAmbientTextureMapping(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide array of 3-tuple float results using RGB values [0..1] using RGB values [0..1] from inputOutput SFColor field named <i>diffuseColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] how much direct, angle-dependent light is reflected from all light sources.
 * <ul>
 *  <li> <i> Hint:</i>  only emissiveColor affects IndexedLineSet, LineSet and PointSet. </li> 
 * </ul>
	 * @return value of diffuseColor field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=DiffuseColor, $memberObjectName=diffuseColor, $memberObjectName=diffuseColor)

	public float[] getDiffuseColor()
	{
		return diffuseColor;
	}

	/**
	 * Accessor method to assign 3-tuple float array using RGB values [0..1] to inputOutput SFColor field named <i>diffuseColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] how much direct, angle-dependent light is reflected from all light sources.
 * <ul>
 *  <li> <i> Hint:</i>  only emissiveColor affects IndexedLineSet, LineSet and PointSet. </li> 
 * </ul>
	 * @param newValue is new value for the diffuseColor field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setDiffuseColor(float[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new float[0];
		// Check that newValue parameter has legal size before assigning to scene graph
		if (newValue.length != 3) // 3-tuple check
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("Material diffuseColor newValue=" + SFColor.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
		}
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if ((newValue[0] < 0) || (newValue[1] < 0) || (newValue[2] < 0)) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("Material diffuseColor newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if ((newValue[0] > 1f) || (newValue[1] > 1f) || (newValue[2] > 1f)) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("Material diffuseColor newValue=" + SFColor.toString(newValue) + " has component value greater than restriction maxInclusive=1");
            }
		diffuseColor = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFColor diffuseColor field, similar to {@link #setDiffuseColor(float[])}.
	 * @param newValue is new value for the diffuseColor field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setDiffuseColor(SFColor newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDiffuseColor(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Assign values to SFColor diffuseColor field, similar to {@link #setDiffuseColor(float[])}.

	 * @param red first component
	 * @param green second component
	 * @param blue third component

	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setDiffuseColor(float red, float green, float blue)
	{
		setDiffuseColor(new float[] {red, green, blue});
		return this;
	}

	/**
	 * Utility method: double-precision set-parameters accessor for X3D floating-point type, similar to {@link #setDiffuseColor(float[])}.
	 * @param red first component [0..1]
	 * @param green second component [0..1]
	 * @param blue third component [0..1]
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setDiffuseColor(double red, double green, double blue)
	{
		return setDiffuseColor((float) red, (float) green, (float) blue);
	}
	/**
	 * Utility method: double-precision set-parameters accessor for X3D floating-point type, similar to {@link #setDiffuseColor(float[])}.
	 * @param newArray is new value for field
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setDiffuseColor(double[] newArray)
	{
		return setDiffuseColor(new SFColor(newArray));
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>diffuseTexture</i>.
	 * @see #getDiffuseTextureProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying diffuseColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='diffuseTexture'. </li> 
 * </ul>
	 * @return value of diffuseTexture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=DiffuseTexture, $memberObjectName=diffuseTexture, $memberObjectName=diffuseTexture)

	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getDiffuseTexture()
	{
		return diffuseTexture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>diffuseTexture</i>.
	 * @see #setDiffuseTexture(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying diffuseColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='diffuseTexture'. </li> 
 * </ul>
	 * @param newValue is new value for the diffuseTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setDiffuseTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue)
	{
		// set-newValue-validity-checks #0.a
		diffuseTexture = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) diffuseTexture).setParent(this); // parentTest15.1
		}
		if (diffuseTextureProtoInstance != null)
		{
			diffuseTextureProtoInstance.setParent(null); // housekeeping, clear prior object
			diffuseTextureProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of diffuseTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public Material clearDiffuseTexture()
	{
		((X3DConcreteElement) diffuseTexture).clearParent(); // remove references to facilitate Java memory management
		diffuseTexture = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>diffuseTexture</i>.
	 * @see #setDiffuseTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode)
	 * @param newValue is new value for the diffuseTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setDiffuseTexture(ProtoInstance newValue)
	{
		if (diffuseTextureProtoInstance != null)
		{
			((X3DConcreteElement) diffuseTextureProtoInstance).setParent(null); // parentTest15.5
	    }
		diffuseTextureProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) diffuseTextureProtoInstance).setParent(this); // parentTest15.6
            diffuseTextureProtoInstance.setContainerField("diffuseTexture");
	    }
		if (diffuseTexture != null)
		{
			((X3DConcreteElement) diffuseTexture).setParent(null); // housekeeping, clear prior object
			diffuseTexture = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getDiffuseTextureProtoInstance()
		{
			return diffuseTextureProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>diffuseTexture</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getDiffuseTexture()
	 * @see #getDiffuseTextureProtoInstance()
	 */
	public boolean hasDiffuseTexture()
	{
		return (diffuseTexture != null) || (diffuseTextureProtoInstance != null);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>diffuseTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @return value of diffuseTextureMapping field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=DiffuseTextureMapping, $memberObjectName=diffuseTextureMapping, $memberObjectName=diffuseTextureMapping)

	public String getDiffuseTextureMapping()
	{
		return diffuseTextureMapping;
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>diffuseTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @param newValue is new value for the diffuseTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setDiffuseTextureMapping(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		diffuseTextureMapping = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString diffuseTextureMapping field, similar to {@link #setDiffuseTextureMapping(String)}.
	 * @param newValue is new value for the diffuseTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setDiffuseTextureMapping(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDiffuseTextureMapping(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide array of 3-tuple float results using RGB values [0..1] using RGB values [0..1] from inputOutput SFColor field named <i>emissiveColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] how much glowing light is emitted from this object.
 * <ul>
 *  <li> <i>Hint:</i> emissiveColors glow even when all lights are off. </li> 
 *  <li> <i>Hint:</i> reset diffuseColor from default (.8 .8 .8) to (0 0 0) to avoid washout. </li> 
 *  <li> <i>Hint:</i> only emissiveColor affects IndexedLineSet, LineSet and PointSet. </li> 
 *  <li> <i>Warning:</i>  bright emissiveColor values can wash out other colors and some textures. </li> 
 * </ul>
	 * @return value of emissiveColor field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=EmissiveColor, $memberObjectName=emissiveColor, $memberObjectName=emissiveColor)

	public float[] getEmissiveColor()
	{
		return emissiveColor;
	}

	/**
	 * Accessor method to assign 3-tuple float array using RGB values [0..1] to inputOutput SFColor field named <i>emissiveColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] how much glowing light is emitted from this object.
 * <ul>
 *  <li> <i>Hint:</i> emissiveColors glow even when all lights are off. </li> 
 *  <li> <i>Hint:</i> reset diffuseColor from default (.8 .8 .8) to (0 0 0) to avoid washout. </li> 
 *  <li> <i>Hint:</i> only emissiveColor affects IndexedLineSet, LineSet and PointSet. </li> 
 *  <li> <i>Warning:</i>  bright emissiveColor values can wash out other colors and some textures. </li> 
 * </ul>
	 * @param newValue is new value for the emissiveColor field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setEmissiveColor(float[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new float[0];
		// Check that newValue parameter has legal size before assigning to scene graph
		if (newValue.length != 3) // 3-tuple check
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("Material emissiveColor newValue=" + SFColor.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
		}
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if ((newValue[0] < 0) || (newValue[1] < 0) || (newValue[2] < 0)) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("Material emissiveColor newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if ((newValue[0] > 1f) || (newValue[1] > 1f) || (newValue[2] > 1f)) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("Material emissiveColor newValue=" + SFColor.toString(newValue) + " has component value greater than restriction maxInclusive=1");
            }
		emissiveColor = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFColor emissiveColor field, similar to {@link #setEmissiveColor(float[])}.
	 * @param newValue is new value for the emissiveColor field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setEmissiveColor(SFColor newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setEmissiveColor(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Assign values to SFColor emissiveColor field, similar to {@link #setEmissiveColor(float[])}.

	 * @param red first component
	 * @param green second component
	 * @param blue third component

	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setEmissiveColor(float red, float green, float blue)
	{
		setEmissiveColor(new float[] {red, green, blue});
		return this;
	}

	/**
	 * Utility method: double-precision set-parameters accessor for X3D floating-point type, similar to {@link #setEmissiveColor(float[])}.
	 * @param red first component [0..1]
	 * @param green second component [0..1]
	 * @param blue third component [0..1]
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setEmissiveColor(double red, double green, double blue)
	{
		return setEmissiveColor((float) red, (float) green, (float) blue);
	}
	/**
	 * Utility method: double-precision set-parameters accessor for X3D floating-point type, similar to {@link #setEmissiveColor(float[])}.
	 * @param newArray is new value for field
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setEmissiveColor(double[] newArray)
	{
		return setEmissiveColor(new SFColor(newArray));
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>emissiveTexture</i>.
	 * @see #getEmissiveTextureProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying emissiveColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='emissiveTexture'. </li> 
 * </ul>
	 * @return value of emissiveTexture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=EmissiveTexture, $memberObjectName=emissiveTexture, $memberObjectName=emissiveTexture)

	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getEmissiveTexture()
	{
		return emissiveTexture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>emissiveTexture</i>.
	 * @see #setEmissiveTexture(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying emissiveColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='emissiveTexture'. </li> 
 * </ul>
	 * @param newValue is new value for the emissiveTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setEmissiveTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue)
	{
		// set-newValue-validity-checks #0.a
		emissiveTexture = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) emissiveTexture).setParent(this); // parentTest15.1
		}
		if (emissiveTextureProtoInstance != null)
		{
			emissiveTextureProtoInstance.setParent(null); // housekeeping, clear prior object
			emissiveTextureProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of emissiveTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public Material clearEmissiveTexture()
	{
		((X3DConcreteElement) emissiveTexture).clearParent(); // remove references to facilitate Java memory management
		emissiveTexture = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>emissiveTexture</i>.
	 * @see #setEmissiveTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode)
	 * @param newValue is new value for the emissiveTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setEmissiveTexture(ProtoInstance newValue)
	{
		if (emissiveTextureProtoInstance != null)
		{
			((X3DConcreteElement) emissiveTextureProtoInstance).setParent(null); // parentTest15.5
	    }
		emissiveTextureProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) emissiveTextureProtoInstance).setParent(this); // parentTest15.6
            emissiveTextureProtoInstance.setContainerField("emissiveTexture");
	    }
		if (emissiveTexture != null)
		{
			((X3DConcreteElement) emissiveTexture).setParent(null); // housekeeping, clear prior object
			emissiveTexture = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getEmissiveTextureProtoInstance()
		{
			return emissiveTextureProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>emissiveTexture</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getEmissiveTexture()
	 * @see #getEmissiveTextureProtoInstance()
	 */
	public boolean hasEmissiveTexture()
	{
		return (emissiveTexture != null) || (emissiveTextureProtoInstance != null);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>emissiveTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @return value of emissiveTextureMapping field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=EmissiveTextureMapping, $memberObjectName=emissiveTextureMapping, $memberObjectName=emissiveTextureMapping)

	public String getEmissiveTextureMapping()
	{
		return emissiveTextureMapping;
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>emissiveTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @param newValue is new value for the emissiveTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setEmissiveTextureMapping(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		emissiveTextureMapping = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString emissiveTextureMapping field, similar to {@link #setEmissiveTextureMapping(String)}.
	 * @param newValue is new value for the emissiveTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setEmissiveTextureMapping(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setEmissiveTextureMapping(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide IS instance (using a properly typed node) from inputOutput SFNode field <i>IS</i>.
	 * @return value of IS field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=true, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=IS, $memberObjectName=IS, $memberObjectName=IS)
	public IS getIS()
	{
		return IS;
	}

	/**
	 * Accessor method to assign IS instance (using a properly typed node) to inputOutput SFNode field <i>IS</i>.
	 * @param newValue is new value for the IS field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setIS(IS newValue)
	{
		// set-newValue-validity-checks #0.a
		IS = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) IS).setParent(this); // parentTest15.1
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of IS field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public Material clearIS()
	{
		((X3DConcreteElement) IS).clearParent(); // remove references to facilitate Java memory management
		IS = null; // reset SFNode field
		return this;
	}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>IS</i>.
	 * @return whether a concrete statement or CommentsBlock is available.
	 * @see #getIS()
	 */
	public boolean hasIS()
	{
		return (IS != null);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * @see #getMetadataProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata()
	{
		return metadata;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue)
	{
		// set-newValue-validity-checks #0.a
		metadata = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadata).setParent(this); // parentTest15.1
			// change X3D4 MetadataSet default 'value' back to 'metadata' if parent is not another Metadata* node */
			if (metadata instanceof org.web3d.x3d.jsail.Core.MetadataSet)
{
				((X3DConcreteNode) metadata).setContainerFieldOverride("metadata");
}
		}
		if (metadataProtoInstance != null)
		{
			metadataProtoInstance.setParent(null); // housekeeping, clear prior object
			metadataProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of metadata field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public Material clearMetadata()
	{
		((X3DConcreteElement) metadata).clearParent(); // remove references to facilitate Java memory management
		metadata = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject)
	 * @param newValue is new value for the metadata field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public Material setMetadata(ProtoInstance newValue)
	{
		if (metadataProtoInstance != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(null); // parentTest15.5
	    }
		metadataProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(this); // parentTest15.6
            metadataProtoInstance.setContainerField("metadata");
	    }
		if (metadata != null)
		{
			((X3DConcreteElement) metadata).setParent(null); // housekeeping, clear prior object
			metadata = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getMetadataProtoInstance()
		{
			return metadataProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>metadata</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getMetadata()
	 * @see #getMetadataProtoInstance()
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 */
	public boolean hasMetadata()
	{
		return (metadata != null) || (metadataProtoInstance != null);
	}
	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>normalScale</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,infinity] normalScale controls the degree to which normalTexture RGB values apply XYZ-normal bump mapping to pixels in the parent material.
 * <ul>
 *  <li> <i>Hint:</i> normalScale only affects computation of normalTexture modulations that affect lighting of characteristics of the parent Material and has no relation to normal vectors defined by corresponding geometry. </li> 
 *  <li> <i>Hint:</i>  normalTexture techniques apply Bump mapping <a href="https://en.wikipedia.org/wiki/Bump_mapping" target="_blank">https://en.wikipedia.org/wiki/Bump_mapping</a> </li> 
 * </ul>
	 * @return value of normalScale field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=NormalScale, $memberObjectName=normalScale, $memberObjectName=normalScale)

	public float getNormalScale()
	{
		return normalScale;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>normalScale</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,infinity] normalScale controls the degree to which normalTexture RGB values apply XYZ-normal bump mapping to pixels in the parent material.
 * <ul>
 *  <li> <i>Hint:</i> normalScale only affects computation of normalTexture modulations that affect lighting of characteristics of the parent Material and has no relation to normal vectors defined by corresponding geometry. </li> 
 *  <li> <i>Hint:</i>  normalTexture techniques apply Bump mapping <a href="https://en.wikipedia.org/wiki/Bump_mapping" target="_blank">https://en.wikipedia.org/wiki/Bump_mapping</a> </li> 
 * </ul>
	 * @param newValue is new value for the normalScale field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setNormalScale(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("Material normalScale newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
		normalScale = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat normalScale field, similar to {@link #setNormalScale(float)}.
	 * @param newValue is new value for the normalScale field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setNormalScale(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setNormalScale(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setNormalScale(float)}.
	 * @param newValue is new value for field
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setNormalScale(double newValue)
	{
		return setNormalScale((float) newValue);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>normalTexture</i>.
	 * @see #getNormalTextureProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying normalScale for this material node, the contained texture modulates the texture across the surface.
 * <ul>
 *  <li> <i>Hint:</i> normalTexture techniques apply Bump mapping <a href="https://en.wikipedia.org/wiki/Bump_mapping" target="_blank">https://en.wikipedia.org/wiki/Bump_mapping</a> </li> 
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='normalTexture' </li> 
 * </ul>
	 * @return value of normalTexture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=NormalTexture, $memberObjectName=normalTexture, $memberObjectName=normalTexture)

	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getNormalTexture()
	{
		return normalTexture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>normalTexture</i>.
	 * @see #setNormalTexture(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying normalScale for this material node, the contained texture modulates the texture across the surface.
 * <ul>
 *  <li> <i>Hint:</i> normalTexture techniques apply Bump mapping <a href="https://en.wikipedia.org/wiki/Bump_mapping" target="_blank">https://en.wikipedia.org/wiki/Bump_mapping</a> </li> 
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='normalTexture' </li> 
 * </ul>
	 * @param newValue is new value for the normalTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setNormalTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue)
	{
		// set-newValue-validity-checks #0.a
		normalTexture = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) normalTexture).setParent(this); // parentTest15.1
		}
		if (normalTextureProtoInstance != null)
		{
			normalTextureProtoInstance.setParent(null); // housekeeping, clear prior object
			normalTextureProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of normalTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public Material clearNormalTexture()
	{
		((X3DConcreteElement) normalTexture).clearParent(); // remove references to facilitate Java memory management
		normalTexture = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>normalTexture</i>.
	 * @see #setNormalTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode)
	 * @param newValue is new value for the normalTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setNormalTexture(ProtoInstance newValue)
	{
		if (normalTextureProtoInstance != null)
		{
			((X3DConcreteElement) normalTextureProtoInstance).setParent(null); // parentTest15.5
	    }
		normalTextureProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) normalTextureProtoInstance).setParent(this); // parentTest15.6
            normalTextureProtoInstance.setContainerField("normalTexture");
	    }
		if (normalTexture != null)
		{
			((X3DConcreteElement) normalTexture).setParent(null); // housekeeping, clear prior object
			normalTexture = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getNormalTextureProtoInstance()
		{
			return normalTextureProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>normalTexture</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getNormalTexture()
	 * @see #getNormalTextureProtoInstance()
	 */
	public boolean hasNormalTexture()
	{
		return (normalTexture != null) || (normalTextureProtoInstance != null);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>normalTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @return value of normalTextureMapping field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=NormalTextureMapping, $memberObjectName=normalTextureMapping, $memberObjectName=normalTextureMapping)

	public String getNormalTextureMapping()
	{
		return normalTextureMapping;
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>normalTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @param newValue is new value for the normalTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setNormalTextureMapping(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		normalTextureMapping = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString normalTextureMapping field, similar to {@link #setNormalTextureMapping(String)}.
	 * @param newValue is new value for the normalTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setNormalTextureMapping(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setNormalTextureMapping(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>occlusionStrength</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] occlusionStrength indicates areas of indirect lighting, typically called ambient occlusion. Higher values indicate areas that should receive full indirect lighting and lower values indicate no indirect lighting.
 * <ul>
 *  <li> <i>Hint:</i> only the Red channel of the texture is used for occlusion computations, other channels are ignored. </li> 
 *  <li> <i>Hint:</i>  <a href="https://en.wikipedia.org/wiki/Ambient_occlusion" target="_blank">https://en.wikipedia.org/wiki/Ambient_occlusion</a> </li> 
 * </ul>
	 * @return value of occlusionStrength field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=OcclusionStrength, $memberObjectName=occlusionStrength, $memberObjectName=occlusionStrength)

	public float getOcclusionStrength()
	{
		return occlusionStrength;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>occlusionStrength</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] occlusionStrength indicates areas of indirect lighting, typically called ambient occlusion. Higher values indicate areas that should receive full indirect lighting and lower values indicate no indirect lighting.
 * <ul>
 *  <li> <i>Hint:</i> only the Red channel of the texture is used for occlusion computations, other channels are ignored. </li> 
 *  <li> <i>Hint:</i>  <a href="https://en.wikipedia.org/wiki/Ambient_occlusion" target="_blank">https://en.wikipedia.org/wiki/Ambient_occlusion</a> </li> 
 * </ul>
	 * @param newValue is new value for the occlusionStrength field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setOcclusionStrength(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("Material occlusionStrength newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("Material occlusionStrength newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
            }
		occlusionStrength = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat occlusionStrength field, similar to {@link #setOcclusionStrength(float)}.
	 * @param newValue is new value for the occlusionStrength field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setOcclusionStrength(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setOcclusionStrength(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setOcclusionStrength(float)}.
	 * @param newValue is new value for field
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setOcclusionStrength(double newValue)
	{
		return setOcclusionStrength((float) newValue);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>occlusionTexture</i>.
	 * @see #getOcclusionTextureProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying occlusionStrength for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='occlusionTexture'. </li> 
 * </ul>
	 * @return value of occlusionTexture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=OcclusionTexture, $memberObjectName=occlusionTexture, $memberObjectName=occlusionTexture)

	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getOcclusionTexture()
	{
		return occlusionTexture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>occlusionTexture</i>.
	 * @see #setOcclusionTexture(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying occlusionStrength for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='occlusionTexture'. </li> 
 * </ul>
	 * @param newValue is new value for the occlusionTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setOcclusionTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue)
	{
		// set-newValue-validity-checks #0.a
		occlusionTexture = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) occlusionTexture).setParent(this); // parentTest15.1
		}
		if (occlusionTextureProtoInstance != null)
		{
			occlusionTextureProtoInstance.setParent(null); // housekeeping, clear prior object
			occlusionTextureProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of occlusionTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public Material clearOcclusionTexture()
	{
		((X3DConcreteElement) occlusionTexture).clearParent(); // remove references to facilitate Java memory management
		occlusionTexture = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>occlusionTexture</i>.
	 * @see #setOcclusionTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode)
	 * @param newValue is new value for the occlusionTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setOcclusionTexture(ProtoInstance newValue)
	{
		if (occlusionTextureProtoInstance != null)
		{
			((X3DConcreteElement) occlusionTextureProtoInstance).setParent(null); // parentTest15.5
	    }
		occlusionTextureProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) occlusionTextureProtoInstance).setParent(this); // parentTest15.6
            occlusionTextureProtoInstance.setContainerField("occlusionTexture");
	    }
		if (occlusionTexture != null)
		{
			((X3DConcreteElement) occlusionTexture).setParent(null); // housekeeping, clear prior object
			occlusionTexture = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getOcclusionTextureProtoInstance()
		{
			return occlusionTextureProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>occlusionTexture</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getOcclusionTexture()
	 * @see #getOcclusionTextureProtoInstance()
	 */
	public boolean hasOcclusionTexture()
	{
		return (occlusionTexture != null) || (occlusionTextureProtoInstance != null);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>occlusionTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @return value of occlusionTextureMapping field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=OcclusionTextureMapping, $memberObjectName=occlusionTextureMapping, $memberObjectName=occlusionTextureMapping)

	public String getOcclusionTextureMapping()
	{
		return occlusionTextureMapping;
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>occlusionTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @param newValue is new value for the occlusionTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setOcclusionTextureMapping(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		occlusionTextureMapping = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString occlusionTextureMapping field, similar to {@link #setOcclusionTextureMapping(String)}.
	 * @param newValue is new value for the occlusionTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setOcclusionTextureMapping(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setOcclusionTextureMapping(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>shininess</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] Lower shininess values provide soft specular glows, while higher values result in sharper, smaller highlights. Interchange profile
 * <ul>
 *  <li> <i> Hint:</i>  this field may be ignored, applying the default value regardless. </li> 
 * </ul>
	 * @return value of shininess field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=Shininess, $memberObjectName=shininess, $memberObjectName=shininess)

	public float getShininess()
	{
		return shininess;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>shininess</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] Lower shininess values provide soft specular glows, while higher values result in sharper, smaller highlights. Interchange profile
 * <ul>
 *  <li> <i> Hint:</i>  this field may be ignored, applying the default value regardless. </li> 
 * </ul>
	 * @param newValue is new value for the shininess field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setShininess(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("Material shininess newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("Material shininess newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
            }
		shininess = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat shininess field, similar to {@link #setShininess(float)}.
	 * @param newValue is new value for the shininess field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setShininess(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setShininess(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setShininess(float)}.
	 * @param newValue is new value for field
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setShininess(double newValue)
	{
		return setShininess((float) newValue);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>shininessTexture</i>.
	 * @see #getShininessTextureProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying shininess for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='shininessTexture'. </li> 
 * </ul>
	 * @return value of shininessTexture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=ShininessTexture, $memberObjectName=shininessTexture, $memberObjectName=shininessTexture)

	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getShininessTexture()
	{
		return shininessTexture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>shininessTexture</i>.
	 * @see #setShininessTexture(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying shininess for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='shininessTexture'. </li> 
 * </ul>
	 * @param newValue is new value for the shininessTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setShininessTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue)
	{
		// set-newValue-validity-checks #0.a
		shininessTexture = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) shininessTexture).setParent(this); // parentTest15.1
		}
		if (shininessTextureProtoInstance != null)
		{
			shininessTextureProtoInstance.setParent(null); // housekeeping, clear prior object
			shininessTextureProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of shininessTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public Material clearShininessTexture()
	{
		((X3DConcreteElement) shininessTexture).clearParent(); // remove references to facilitate Java memory management
		shininessTexture = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>shininessTexture</i>.
	 * @see #setShininessTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode)
	 * @param newValue is new value for the shininessTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setShininessTexture(ProtoInstance newValue)
	{
		if (shininessTextureProtoInstance != null)
		{
			((X3DConcreteElement) shininessTextureProtoInstance).setParent(null); // parentTest15.5
	    }
		shininessTextureProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) shininessTextureProtoInstance).setParent(this); // parentTest15.6
            shininessTextureProtoInstance.setContainerField("shininessTexture");
	    }
		if (shininessTexture != null)
		{
			((X3DConcreteElement) shininessTexture).setParent(null); // housekeeping, clear prior object
			shininessTexture = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getShininessTextureProtoInstance()
		{
			return shininessTextureProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>shininessTexture</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getShininessTexture()
	 * @see #getShininessTextureProtoInstance()
	 */
	public boolean hasShininessTexture()
	{
		return (shininessTexture != null) || (shininessTextureProtoInstance != null);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>shininessTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @return value of shininessTextureMapping field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=ShininessTextureMapping, $memberObjectName=shininessTextureMapping, $memberObjectName=shininessTextureMapping)

	public String getShininessTextureMapping()
	{
		return shininessTextureMapping;
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>shininessTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @param newValue is new value for the shininessTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setShininessTextureMapping(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		shininessTextureMapping = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString shininessTextureMapping field, similar to {@link #setShininessTextureMapping(String)}.
	 * @param newValue is new value for the shininessTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setShininessTextureMapping(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setShininessTextureMapping(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide array of 3-tuple float results using RGB values [0..1] using RGB values [0..1] from inputOutput SFColor field named <i>specularColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] specular highlights are brightness reflections (example: shiny spots on an apple). Interchange profile
 * <ul>
 *  <li> <i> Hint:</i>  this field may be ignored, applying the default value regardless. </li> 
 * </ul>
	 * @return value of specularColor field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=SpecularColor, $memberObjectName=specularColor, $memberObjectName=specularColor)

	public float[] getSpecularColor()
	{
		return specularColor;
	}

	/**
	 * Accessor method to assign 3-tuple float array using RGB values [0..1] to inputOutput SFColor field named <i>specularColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] specular highlights are brightness reflections (example: shiny spots on an apple). Interchange profile
 * <ul>
 *  <li> <i> Hint:</i>  this field may be ignored, applying the default value regardless. </li> 
 * </ul>
	 * @param newValue is new value for the specularColor field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setSpecularColor(float[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new float[0];
		// Check that newValue parameter has legal size before assigning to scene graph
		if (newValue.length != 3) // 3-tuple check
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("Material specularColor newValue=" + SFColor.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
		}
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if ((newValue[0] < 0) || (newValue[1] < 0) || (newValue[2] < 0)) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("Material specularColor newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if ((newValue[0] > 1f) || (newValue[1] > 1f) || (newValue[2] > 1f)) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("Material specularColor newValue=" + SFColor.toString(newValue) + " has component value greater than restriction maxInclusive=1");
            }
		specularColor = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFColor specularColor field, similar to {@link #setSpecularColor(float[])}.
	 * @param newValue is new value for the specularColor field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setSpecularColor(SFColor newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setSpecularColor(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Assign values to SFColor specularColor field, similar to {@link #setSpecularColor(float[])}.

	 * @param red first component
	 * @param green second component
	 * @param blue third component

	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setSpecularColor(float red, float green, float blue)
	{
		setSpecularColor(new float[] {red, green, blue});
		return this;
	}

	/**
	 * Utility method: double-precision set-parameters accessor for X3D floating-point type, similar to {@link #setSpecularColor(float[])}.
	 * @param red first component [0..1]
	 * @param green second component [0..1]
	 * @param blue third component [0..1]
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setSpecularColor(double red, double green, double blue)
	{
		return setSpecularColor((float) red, (float) green, (float) blue);
	}
	/**
	 * Utility method: double-precision set-parameters accessor for X3D floating-point type, similar to {@link #setSpecularColor(float[])}.
	 * @param newArray is new value for field
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setSpecularColor(double[] newArray)
	{
		return setSpecularColor(new SFColor(newArray));
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>specularTexture</i>.
	 * @see #getSpecularTextureProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying specularColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='specularTexture'. </li> 
 * </ul>
	 * @return value of specularTexture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=SpecularTexture, $memberObjectName=specularTexture, $memberObjectName=specularTexture)

	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getSpecularTexture()
	{
		return specularTexture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>specularTexture</i>.
	 * @see #setSpecularTexture(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i> [X3DSingleTextureNode] When applying specularColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel.
 * <ul>
 *  <li> <i>Hint:</i> if texture node is NULL or unspecified, no effect is applied to material values. </li> 
 *  <li> <i>Hint:</i>  contained texture node must include containerField='specularTexture'. </li> 
 * </ul>
	 * @param newValue is new value for the specularTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setSpecularTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue)
	{
		// set-newValue-validity-checks #0.a
		specularTexture = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) specularTexture).setParent(this); // parentTest15.1
		}
		if (specularTextureProtoInstance != null)
		{
			specularTextureProtoInstance.setParent(null); // housekeeping, clear prior object
			specularTextureProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of specularTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public Material clearSpecularTexture()
	{
		((X3DConcreteElement) specularTexture).clearParent(); // remove references to facilitate Java memory management
		specularTexture = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>specularTexture</i>.
	 * @see #setSpecularTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode)
	 * @param newValue is new value for the specularTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setSpecularTexture(ProtoInstance newValue)
	{
		if (specularTextureProtoInstance != null)
		{
			((X3DConcreteElement) specularTextureProtoInstance).setParent(null); // parentTest15.5
	    }
		specularTextureProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) specularTextureProtoInstance).setParent(this); // parentTest15.6
            specularTextureProtoInstance.setContainerField("specularTexture");
	    }
		if (specularTexture != null)
		{
			((X3DConcreteElement) specularTexture).setParent(null); // housekeeping, clear prior object
			specularTexture = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getSpecularTextureProtoInstance()
		{
			return specularTextureProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>specularTexture</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getSpecularTexture()
	 * @see #getSpecularTextureProtoInstance()
	 */
	public boolean hasSpecularTexture()
	{
		return (specularTexture != null) || (specularTextureProtoInstance != null);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>specularTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @return value of specularTextureMapping field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=SpecularTextureMapping, $memberObjectName=specularTextureMapping, $memberObjectName=specularTextureMapping)

	public String getSpecularTextureMapping()
	{
		return specularTextureMapping;
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>specularTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i> The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material.
 * <ul>
 *  <li> <i> Hint:</i>  TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator <a href="https://savage.nps.edu/X3dValidator" target="_blank">https://savage.nps.edu/X3dValidator</a> </li> 
 * </ul>
	 * @param newValue is new value for the specularTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setSpecularTextureMapping(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		specularTextureMapping = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString specularTextureMapping field, similar to {@link #setSpecularTextureMapping(String)}.
	 * @param newValue is new value for the specularTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setSpecularTextureMapping(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setSpecularTextureMapping(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>transparency</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] how "clear" an object is: 1.0 is completely transparent, 0.0 is completely opaque. Interchange profile
 * <ul>
 *  <li> <i> Hint:</i>  transparency &amp;lt; .5 opaque, transparency &amp;gt; .5 transparent. </li> 
 * </ul>
	 * @return value of transparency field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=Transparency, $memberObjectName=transparency, $memberObjectName=transparency)

	public float getTransparency()
	{
		return transparency;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>transparency</i>.
	 * <br><br>
	 * <i>Tooltip:</i> [0,1] how "clear" an object is: 1.0 is completely transparent, 0.0 is completely opaque. Interchange profile
 * <ul>
 *  <li> <i> Hint:</i>  transparency &amp;lt; .5 opaque, transparency &amp;gt; .5 transparent. </li> 
 * </ul>
	 * @param newValue is new value for the transparency field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setTransparency(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("Material transparency newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("Material transparency newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
            }
		transparency = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat transparency field, similar to {@link #setTransparency(float)}.
	 * @param newValue is new value for the transparency field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setTransparency(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setTransparency(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setTransparency(float)}.
	 * @param newValue is new value for field
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setTransparency(double newValue)
	{
		return setTransparency((float) newValue);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i> DEF defines a unique ID name for this node, referenceable by other nodes.
 * <ul>
 *  <li> <i>Hint:</i> descriptive DEF names improve clarity and help document a model. </li> 
 *  <li> <i>Hint:</i> well-defined names can simplify design and debugging through improved author understanding. </li> 
 *  <li> <i>Hint:</i>  X3D Scene Authoring Hints, Naming Conventions <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions</a> </li> 
 * </ul>
	 * @return value of DEF field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=DEF, $memberObjectName=DEF, $memberObjectName=DEF)

	public String getDEF()
	{
		// override abstract method in X3DConcreteNode
		return super.getDEF();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i> DEF defines a unique ID name for this node, referenceable by other nodes.
 * <ul>
 *  <li> <i>Hint:</i> descriptive DEF names improve clarity and help document a model. </li> 
 *  <li> <i>Hint:</i> well-defined names can simplify design and debugging through improved author understanding. </li> 
 *  <li> <i>Hint:</i>  X3D Scene Authoring Hints, Naming Conventions <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions</a> </li> 
 * </ul>
	 * <br><br>
	 *  Note that setting the DEF value clears the USE value.
	 * @param newValue is new value for the DEF field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final Material setDEF(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to Material DEF
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("Material DEF newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteUSE(""); // ensure that no previous USE value remains
		setConcreteDEF(newValue); // private superclass methods
		return this;
	}

	/**
	 * Assign typed object value to SFString DEF field, similar to {@link #setDEF(String)}.
	 * @param newValue is new value for the DEF field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setDEF(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDEF(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i> USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value).
 * <ul>
 *  <li> <i>Hint:</i> USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. </li> 
 *  <li> <i>Warning:</i> do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. </li> 
 *  <li> <i>Warning:</i>  each USE value must match a corresponding DEF value that is defined earlier in the scene. </li> 
 * </ul>
	 * @return value of USE field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=USE, $memberObjectName=USE, $memberObjectName=USE)

	public String getUSE()
	{
		// override abstract method in X3DConcreteNode
		return super.getUSE();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i> USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value).
 * <ul>
 *  <li> <i>Hint:</i> USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. </li> 
 *  <li> <i>Warning:</i> do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. </li> 
 *  <li> <i>Warning:</i>  each USE value must match a corresponding DEF value that is defined earlier in the scene. </li> 
 * </ul>
	 * <br><br>
	 * <i>Note:</i> each <code>USE</code> node is still an independent object, with the <code>USE</code> value matching the <code>DEF</code> value in the preceding object. 
	 * <br><br>
	 * <i>Warning:</i> invoking the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.<br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param newValue is new value for the USE field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final Material setUSE(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to Material USE
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("Material USE newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteDEF(""); // ensure that no previous DEF value remains
		setConcreteUSE(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString USE field, similar to {@link #setUSE(String)}.
	 * @param newValue is new value for the USE field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setUSE(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setUSE(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>class</i>.
	 * @return value of class field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=CssClass, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssClass()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssClass();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>class</i>.
	 * @param newValue is new value for the class field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final Material setCssClass(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssClass(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssClass(String)}.
	 * @param newValue is new value for the class field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setCssClass(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssClass(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>id</i>.
	 * @return value of id field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=HtmlID, $memberObjectName=HtmlID, $memberObjectName=HtmlID)

	public String getHtmlID()
	{
		// override abstract method in X3DConcreteNode
		return super.getHtmlID();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>id</i>.
	 * @param newValue is new value for the id field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final Material setHtmlID(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteHtmlID(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString HtmlID field, similar to {@link #setHtmlID(String)}.
	 * @param newValue is new value for the id field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setHtmlID(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setHtmlID(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>style</i>.
	 * @return value of style field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=CssStyle, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssStyle()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssStyle();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>style</i>.
	 * @param newValue is new value for the style field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final Material setCssStyle(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssStyle(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssStyle(String)}.
	 * @param newValue is new value for the style field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setCssStyle(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssStyle(newValue.getPrimitiveValue());
			return this;
	}

	// Additional utility methods for this class ==============================

	/**
	 * Assign a USE reference to another DEF node of same node type, similar to {@link #setUSE(String)}.
	 * <br ><br >
	 * <i>Warning:</i> note that the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.
	 * <br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param DEFnode must have a DEF value defined
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setUSE(Material DEFnode)
	{
		if (DEFnode.getDEF().isEmpty())
		{
			String errorNotice = "*** setUSE(DEFnode) invoked on Material" +
				" that has no DEF name defined, thus a copy cannot be referenced as a USE node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		setUSE(DEFnode.getDEF());
		return this;
	}
	/**
	 * Utility constructor that assigns DEF label after initializing member variables with default values.
	 * @param DEFlabel unique DEF name for this X3D node
	 */
	public Material (String DEFlabel)
	{
		initialize();
		setDEF(DEFlabel); // apply checks
	}

	/**
	 * Add comment as String to contained commentsList.
	 * @param newComment initial value
	 * @see <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Organization">X3D Architecture, clause 7.2.5.1 Organization</a>
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public Material addComments (String newComment)
	{
		commentsList.add(newComment);
		return this;
	}
	/**
	 * Add comments as String[] array to contained commentsList.
	 * @param newComments array of comments
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public Material addComments (String[] newComments)
	{
		commentsList.addAll(Arrays.asList(newComments));
		return this;
	}
	/**
	 * Add CommentsBlock to contained commentsList.
	 * @param newCommentsBlock block of comments to add
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public Material addComments (CommentsBlock newCommentsBlock)
	{
		commentsList.addAll(newCommentsBlock.toStringList());
		return this;
	}
	/**
	 * Utility method to adjust field synonyms
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges">X3D Scene Authoring Hints: X3D4 Field name changes for improved consistency</a>
     */
    private void handleFieldSynonyms()
    {
            // no synonyms to handle
	}

	/**
	 * Recursive method to provide X3D string serialization of this model subgraph, utilizing XML encoding and conforming to X3D Canonical Form.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_X3D
	 * @see X3D#FILE_EXTENSION_XML
	 * @see X3D#toStringXML()
	 * @see X3D#toFileXML(String)
	 * @see X3D#toFileX3D(String)
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-1/V3.3/Part01/X3D_XML.html">X3D XML Encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-3/V3.3/Part03/concepts.html#X3DCanonicalForm" target="blank">X3D Compressed Binary Encoding: X3D Canonical Form</a>
	 * @see <a href="https://www.web3d.org/x3d/tools/canonical/doc/x3dTools.htm">X3D Canonicalization (C14N) Tool</a>
	 * @return X3D string
	 */
	@Override
	public String toStringX3D(int indentLevel)
	{
		boolean hasAttributes = true; // TODO check for non-default attribute values
		boolean      hasChild = (IS != null) || (ambientTexture != null) || (ambientTextureProtoInstance != null) || 
		                        (diffuseTexture != null) || (diffuseTextureProtoInstance != null) || 
		                        (emissiveTexture != null) || (emissiveTextureProtoInstance != null) || 
		                        (IS != null) || 
		                        (metadata != null) || (metadataProtoInstance != null) || 
		                        (normalTexture != null) || (normalTextureProtoInstance != null) || 
		                        (occlusionTexture != null) || (occlusionTextureProtoInstance != null) || 
		                        (shininessTexture != null) || (shininessTextureProtoInstance != null) || 
		                        (specularTexture != null) || (specularTextureProtoInstance != null) || 
		                        !commentsList.isEmpty();
		if (hasUSE())
			hasChild = false; // USE nodes only include attributes for USE and non-default containerField
		handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder indent = new StringBuilder();
		int  indentIncrement = ConfigurationProperties.getIndentIncrement();
		char indentCharacter = ConfigurationProperties.getIndentCharacter();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		StringBuilder stringX3D = new StringBuilder();

		stringX3D.append(indent).append("<Material"); // start opening tag
		if (hasAttributes)
		{
			if (!getDEF().equals(DEF_DEFAULT_VALUE) && !hasUSE())
			{
				stringX3D.append(" DEF='").append(SFString.toString(getDEF())).append("'");
			}
			
			if (!getUSE().equals(USE_DEFAULT_VALUE))
			{
				stringX3D.append(" USE='").append(SFString.toString(getUSE())).append("'");
			}
			
            // containerField is critical for ProtoInstance relationship to parent node
            if (!getContainerFieldOverride().isBlank() && !getContainerFieldOverride().equals(this.getContainerFieldDefault())) // output if not default ProtoInstance containerField
            {
                    stringX3D.append(" containerField='").append(getContainerFieldOverride()).append("'");
            }

            // test attributes

			if (((getAmbientIntensity() != AMBIENTINTENSITY_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" ambientIntensity='").append(SFFloat.toString(getAmbientIntensity())).append("'");
			}
			if ((!getAmbientTextureMapping().equals(AMBIENTTEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" ambientTextureMapping='").append(new SFString(getAmbientTextureMapping()).toStringX3D()).append("'");
			}
			if ((!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" class='").append(new SFString(getCssClass()).toStringX3D()).append("'");
			}
			if ((!Arrays.equals(getDiffuseColor(), DIFFUSECOLOR_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* (string-length(@default) > 0) */ && !hasUSE())
			{
				stringX3D.append(" diffuseColor='").append(SFColor.toString(getDiffuseColor())).append("'");
			}
			if ((!getDiffuseTextureMapping().equals(DIFFUSETEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" diffuseTextureMapping='").append(new SFString(getDiffuseTextureMapping()).toStringX3D()).append("'");
			}
			if ((!Arrays.equals(getEmissiveColor(), EMISSIVECOLOR_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* (string-length(@default) > 0) */ && !hasUSE())
			{
				stringX3D.append(" emissiveColor='").append(SFColor.toString(getEmissiveColor())).append("'");
			}
			if ((!getEmissiveTextureMapping().equals(EMISSIVETEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" emissiveTextureMapping='").append(new SFString(getEmissiveTextureMapping()).toStringX3D()).append("'");
			}
			if ((!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" id='").append(new SFString(getHtmlID()).toStringX3D()).append("'");
			}
			if (((getNormalScale() != NORMALSCALE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" normalScale='").append(SFFloat.toString(getNormalScale())).append("'");
			}
			if ((!getNormalTextureMapping().equals(NORMALTEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" normalTextureMapping='").append(new SFString(getNormalTextureMapping()).toStringX3D()).append("'");
			}
			if (((getOcclusionStrength() != OCCLUSIONSTRENGTH_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" occlusionStrength='").append(SFFloat.toString(getOcclusionStrength())).append("'");
			}
			if ((!getOcclusionTextureMapping().equals(OCCLUSIONTEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" occlusionTextureMapping='").append(new SFString(getOcclusionTextureMapping()).toStringX3D()).append("'");
			}
			if (((getShininess() != SHININESS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" shininess='").append(SFFloat.toString(getShininess())).append("'");
			}
			if ((!getShininessTextureMapping().equals(SHININESSTEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" shininessTextureMapping='").append(new SFString(getShininessTextureMapping()).toStringX3D()).append("'");
			}
			if ((!Arrays.equals(getSpecularColor(), SPECULARCOLOR_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* (string-length(@default) > 0) */ && !hasUSE())
			{
				stringX3D.append(" specularColor='").append(SFColor.toString(getSpecularColor())).append("'");
			}
			if ((!getSpecularTextureMapping().equals(SPECULARTEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" specularTextureMapping='").append(new SFString(getSpecularTextureMapping()).toStringX3D()).append("'");
			}
			if ((!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" style='").append(new SFString(getCssStyle()).toStringX3D()).append("'");
			}
			if (((getTransparency() != TRANSPARENCY_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" transparency='").append(SFFloat.toString(getTransparency())).append("'");
			}
		}
		if ((hasChild) && !hasUSE()) // has contained node(s), comment(s), IS/connect and/or source code
		{
			stringX3D.append(">").append("\n"); // finish opening tag

                        if (!commentsList.isEmpty())
                        {
                                CommentsBlock commentsBlock = new CommentsBlock(commentsList);
                                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
                        }
			// recursively iterate over child elements
			if      (IS != null)
			{
				stringX3D.append(((X3DConcreteElement)IS).toStringX3D(indentLevel + indentIncrement));
			}
			if      (metadata != null)
			{
				stringX3D.append(((X3DConcreteElement)metadata).toStringX3D(indentLevel + indentIncrement));
			}
			else if (metadataProtoInstance != null)
			{
				stringX3D.append(((X3DConcreteElement)metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (ambientTexture != null)
			{
				stringX3D.append(((X3DConcreteElement)ambientTexture).toStringX3D(indentLevel + indentIncrement));
			}
			else if (ambientTextureProtoInstance != null)
			{
				stringX3D.append(((X3DConcreteElement)ambientTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (diffuseTexture != null)
			{
				stringX3D.append(((X3DConcreteElement)diffuseTexture).toStringX3D(indentLevel + indentIncrement));
			}
			else if (diffuseTextureProtoInstance != null)
			{
				stringX3D.append(((X3DConcreteElement)diffuseTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (emissiveTexture != null)
			{
				stringX3D.append(((X3DConcreteElement)emissiveTexture).toStringX3D(indentLevel + indentIncrement));
			}
			else if (emissiveTextureProtoInstance != null)
			{
				stringX3D.append(((X3DConcreteElement)emissiveTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (normalTexture != null)
			{
				stringX3D.append(((X3DConcreteElement)normalTexture).toStringX3D(indentLevel + indentIncrement));
			}
			else if (normalTextureProtoInstance != null)
			{
				stringX3D.append(((X3DConcreteElement)normalTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (occlusionTexture != null)
			{
				stringX3D.append(((X3DConcreteElement)occlusionTexture).toStringX3D(indentLevel + indentIncrement));
			}
			else if (occlusionTextureProtoInstance != null)
			{
				stringX3D.append(((X3DConcreteElement)occlusionTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (shininessTexture != null)
			{
				stringX3D.append(((X3DConcreteElement)shininessTexture).toStringX3D(indentLevel + indentIncrement));
			}
			else if (shininessTextureProtoInstance != null)
			{
				stringX3D.append(((X3DConcreteElement)shininessTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (specularTexture != null)
			{
				stringX3D.append(((X3DConcreteElement)specularTexture).toStringX3D(indentLevel + indentIncrement));
			}
			else if (specularTextureProtoInstance != null)
			{
				stringX3D.append(((X3DConcreteElement)specularTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			stringX3D.append(indent).append("</Material>").append("\n"); // finish closing tag
		}
		else
		{
			stringX3D.append("/>").append("\n"); // otherwise finish singleton tag
		}
		return stringX3D.toString();
	}
// ($name=Material, isX3dStatement=false, isClassX3dStatement=false, $hasChild=true, $hasAttributes=true
	/**
	 * Recursive method to provide ClassicVRML string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_CLASSICVRML
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/X3D_ClassicVRML.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/grammar.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding, Annex A: Grammar</a>
	 * @return ClassicVRML string
	 */
	@Override
	public String toStringClassicVRML(int indentLevel)
	{
		StringBuilder stringClassicVRML = new StringBuilder();
		boolean hasAttributes = true; // TODO further refinement
		boolean      hasChild = (IS != null) || (ambientTexture != null) || (ambientTextureProtoInstance != null) || 
		                        (diffuseTexture != null) || (diffuseTextureProtoInstance != null) || 
		                        (emissiveTexture != null) || (emissiveTextureProtoInstance != null) || 
		                        (IS != null) || 
		                        (metadata != null) || (metadataProtoInstance != null) || 
		                        (normalTexture != null) || (normalTextureProtoInstance != null) || 
		                        (occlusionTexture != null) || (occlusionTextureProtoInstance != null) || 
		                        (shininessTexture != null) || (shininessTextureProtoInstance != null) || 
		                        (specularTexture != null) || (specularTextureProtoInstance != null) || 
		                        !commentsList.isEmpty();
		if (hasUSE())
		{
			hasAttributes = false;
			hasChild      = false; // USE nodes include no other fields
		}
                if (!serializingVRML97output)
                    handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder  indent = new StringBuilder();
		char  indentCharacter = ConfigurationProperties.getIndentCharacter();
		int   indentIncrement = ConfigurationProperties.getIndentIncrement();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		if (!getDEF().equals(DEF_DEFAULT_VALUE))
		{
			stringClassicVRML.append("DEF ").append(SFString.toString(getDEF())).append(" ");
		}
		if (!getUSE().equals(USE_DEFAULT_VALUE))
		{
			 stringClassicVRML.append("USE ").append(SFString.toString(getUSE())).append("\n");
		}
		else // only have further output if not a USE node
		{
			stringClassicVRML.append("Material").append(" { "); // define node name, node content follows

			if (hasAttributes || hasChild)
			{
				stringClassicVRML.append("\n").append(indent).append(indentCharacter); // fields for this node follow
			}
			if (hasAttributes)
			{
				boolean hasISconnect = (getIS() != null) && !getIS().getConnectList().isEmpty();
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("ambientIntensity"))
						{
							stringClassicVRML.append(indentCharacter).append("ambientIntensity").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getAmbientIntensity() != AMBIENTINTENSITY_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("ambientIntensity ").append(SFFloat.toString(getAmbientIntensity())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("ambientTextureMapping"))
						{
							stringClassicVRML.append(indentCharacter).append("ambientTextureMapping").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getAmbientTextureMapping().equals(AMBIENTTEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("ambientTextureMapping ").append("\"").append(SFString.toString(getAmbientTextureMapping())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("class"))
						{
							stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(getCssClass())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("diffuseColor"))
						{
							stringClassicVRML.append(indentCharacter).append("diffuseColor").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!Arrays.equals(getDiffuseColor(), DIFFUSECOLOR_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("diffuseColor ").append(SFColor.toString(getDiffuseColor())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("diffuseTextureMapping"))
						{
							stringClassicVRML.append(indentCharacter).append("diffuseTextureMapping").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getDiffuseTextureMapping().equals(DIFFUSETEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("diffuseTextureMapping ").append("\"").append(SFString.toString(getDiffuseTextureMapping())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("emissiveColor"))
						{
							stringClassicVRML.append(indentCharacter).append("emissiveColor").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!Arrays.equals(getEmissiveColor(), EMISSIVECOLOR_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("emissiveColor ").append(SFColor.toString(getEmissiveColor())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("emissiveTextureMapping"))
						{
							stringClassicVRML.append(indentCharacter).append("emissiveTextureMapping").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getEmissiveTextureMapping().equals(EMISSIVETEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("emissiveTextureMapping ").append("\"").append(SFString.toString(getEmissiveTextureMapping())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("id"))
						{
							stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(getHtmlID())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("normalScale"))
						{
							stringClassicVRML.append(indentCharacter).append("normalScale").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getNormalScale() != NORMALSCALE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("normalScale ").append(SFFloat.toString(getNormalScale())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("normalTextureMapping"))
						{
							stringClassicVRML.append(indentCharacter).append("normalTextureMapping").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getNormalTextureMapping().equals(NORMALTEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("normalTextureMapping ").append("\"").append(SFString.toString(getNormalTextureMapping())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("occlusionStrength"))
						{
							stringClassicVRML.append(indentCharacter).append("occlusionStrength").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getOcclusionStrength() != OCCLUSIONSTRENGTH_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("occlusionStrength ").append(SFFloat.toString(getOcclusionStrength())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("occlusionTextureMapping"))
						{
							stringClassicVRML.append(indentCharacter).append("occlusionTextureMapping").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getOcclusionTextureMapping().equals(OCCLUSIONTEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("occlusionTextureMapping ").append("\"").append(SFString.toString(getOcclusionTextureMapping())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("shininess"))
						{
							stringClassicVRML.append(indentCharacter).append("shininess").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getShininess() != SHININESS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("shininess ").append(SFFloat.toString(getShininess())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("shininessTextureMapping"))
						{
							stringClassicVRML.append(indentCharacter).append("shininessTextureMapping").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getShininessTextureMapping().equals(SHININESSTEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("shininessTextureMapping ").append("\"").append(SFString.toString(getShininessTextureMapping())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("specularColor"))
						{
							stringClassicVRML.append(indentCharacter).append("specularColor").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!Arrays.equals(getSpecularColor(), SPECULARCOLOR_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("specularColor ").append(SFColor.toString(getSpecularColor())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("specularTextureMapping"))
						{
							stringClassicVRML.append(indentCharacter).append("specularTextureMapping").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getSpecularTextureMapping().equals(SPECULARTEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("specularTextureMapping ").append("\"").append(SFString.toString(getSpecularTextureMapping())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("style"))
						{
							stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(getCssStyle())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("transparency"))
						{
							stringClassicVRML.append(indentCharacter).append("transparency").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getTransparency() != TRANSPARENCY_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("transparency ").append(SFFloat.toString(getTransparency())).append("\n").append(indent).append(indentCharacter);
				}
			}
		}
		if (hasChild) // has contained node(s) (including USE), comment(s), IS/connect and/or source code
		{
                        // recursively iterate over child elements

			if (metadata != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadata).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (metadataProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (IS != null)
			{
				stringClassicVRML.append(((X3DConcreteElement) IS).toStringClassicVRML(indentLevel)); // end X3D statement
			}
			if (ambientTexture != null)
			{
				stringClassicVRML.append(indentCharacter).append("ambientTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) ambientTexture).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (ambientTextureProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("ambientTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) ambientTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (diffuseTexture != null)
			{
				stringClassicVRML.append(indentCharacter).append("diffuseTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) diffuseTexture).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (diffuseTextureProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("diffuseTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) diffuseTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (emissiveTexture != null)
			{
				stringClassicVRML.append(indentCharacter).append("emissiveTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) emissiveTexture).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (emissiveTextureProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("emissiveTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) emissiveTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (normalTexture != null)
			{
				stringClassicVRML.append(indentCharacter).append("normalTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) normalTexture).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (normalTextureProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("normalTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) normalTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (occlusionTexture != null)
			{
				stringClassicVRML.append(indentCharacter).append("occlusionTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) occlusionTexture).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (occlusionTextureProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("occlusionTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) occlusionTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (shininessTexture != null)
			{
				stringClassicVRML.append(indentCharacter).append("shininessTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) shininessTexture).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (shininessTextureProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("shininessTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) shininessTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (specularTexture != null)
			{
				stringClassicVRML.append(indentCharacter).append("specularTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) specularTexture).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (specularTextureProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("specularTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) specularTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}stringClassicVRML.append("\n").append(indent).append("\n"); // .append(" ### trace field initialization value #8")

			if (!commentsList.isEmpty())
			{
				CommentsBlock commentsBlock = new CommentsBlock(commentsList);
				stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
				stringClassicVRML.append(indent); // end SFNode
			}
		}
		if (getUSE().isEmpty() && (hasAttributes || hasChild))
		{
			stringClassicVRML.append("}").append("\n"); // finish node content
		}
		return stringClassicVRML.toString();
	}


    private boolean serializingVRML97output = false; // whether to avoid handling field name synonyms

	/**
	 * Recursive method to provide VRML97 string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_VRML97
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772/V2.0/index.html">Virtual Reality Modeling Language (VRML) 97 specification</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772-1/V2.1/index.html">VRML 97 v2.1 Amendment</a>
	 * @return VRML97 string
	 */
	@Override
	public String toStringVRML97(int indentLevel)
	{
            serializingVRML97output = true;
            String result = toStringClassicVRML(indentLevel);
            serializingVRML97output = false;

            return result;
	}

	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue)
	{
		return findElementByNameValue(nameValue, ""); // empty string is wildcard, any element match is allowed
	}

	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue, String elementName)
	{
		if ((nameValue == null) || nameValue.isEmpty())
		{
			String errorNotice = "*** findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		// no name field available for this element
		X3DConcreteElement referenceElement;
		if (ambientTexture != null)
		{
			referenceElement = ((X3DConcreteElement) ambientTexture).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (ambientTextureProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) ambientTextureProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (diffuseTexture != null)
		{
			referenceElement = ((X3DConcreteElement) diffuseTexture).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (diffuseTextureProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) diffuseTextureProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (emissiveTexture != null)
		{
			referenceElement = ((X3DConcreteElement) emissiveTexture).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (emissiveTextureProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) emissiveTextureProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (IS != null)
		{
			referenceElement = ((X3DConcreteElement) IS).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadata != null)
		{
			referenceElement = ((X3DConcreteElement) metadata).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadataProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) metadataProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (normalTexture != null)
		{
			referenceElement = ((X3DConcreteElement) normalTexture).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (normalTextureProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) normalTextureProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (occlusionTexture != null)
		{
			referenceElement = ((X3DConcreteElement) occlusionTexture).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (occlusionTextureProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) occlusionTextureProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (shininessTexture != null)
		{
			referenceElement = ((X3DConcreteElement) shininessTexture).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (shininessTextureProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) shininessTextureProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (specularTexture != null)
		{
			referenceElement = ((X3DConcreteElement) specularTexture).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (specularTextureProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) specularTextureProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node or statement with given name attribute is found, meaning both objects are attached to same scene graph.
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @see #findElementByNameValue(String, String)
	 * @return whether node is found
	 */
	public boolean hasElementByNameValue(String nameValue, String elementName)
	{
		return (findElementByNameValue(nameValue, elementName) != null);
	}

	/**
	 * Recursive method to provide object reference to node by DEF, if found as this node or in a contained node.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same DEF, this method does not handle that case.
	 * @see #findElementByNameValue(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found node, null otherwise
	 */
	/* @Override */
	public X3DConcreteNode findNodeByDEF(String DEFvalue)
	{
		if ((DEFvalue == null) || DEFvalue.isEmpty())
		{
			String errorNotice = "*** findNodeByDEF(\"\") cannot use empty string to find a name";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		if (getDEF().equals(DEFvalue))
			return this;
		X3DConcreteNode referenceNode;
		if (ambientTexture != null)
		{
			referenceNode = ((X3DConcreteElement) ambientTexture).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (ambientTextureProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) ambientTextureProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (diffuseTexture != null)
		{
			referenceNode = ((X3DConcreteElement) diffuseTexture).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (diffuseTextureProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) diffuseTextureProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (emissiveTexture != null)
		{
			referenceNode = ((X3DConcreteElement) emissiveTexture).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (emissiveTextureProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) emissiveTextureProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (IS != null)
		{
			referenceNode = ((X3DConcreteElement) IS).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadata != null)
		{
			referenceNode = ((X3DConcreteElement) metadata).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadataProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) metadataProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (normalTexture != null)
		{
			referenceNode = ((X3DConcreteElement) normalTexture).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (normalTextureProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) normalTextureProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (occlusionTexture != null)
		{
			referenceNode = ((X3DConcreteElement) occlusionTexture).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (occlusionTextureProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) occlusionTextureProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (shininessTexture != null)
		{
			referenceNode = ((X3DConcreteElement) shininessTexture).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (shininessTextureProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) shininessTextureProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (specularTexture != null)
		{
			referenceNode = ((X3DConcreteElement) specularTexture).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (specularTextureProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) specularTextureProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node with DEFvalue is found, meaning both objects are attached to same scene graph.
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @see #findNodeByDEF(String)
	 * @return whether node is found
	 */
	public boolean hasNodeByDEF(String DEFvalue)
	{
		return (findNodeByDEF(DEFvalue) != null);
	}


	/**
	 * Recursive method to validate this element plus all contained nodes and statements,
	 * using both datatype-specification value checks and regular expression (regex) checking of corresponding string values.
         * TODO document specific validation methods.
	 * @return validation results (if any)
	 */
	@Override
	public String validate()
	{
		validationResult = new StringBuilder(); // prepare for updated results

		setAmbientIntensity(getAmbientIntensity()); // exercise field checks, simple types
        
		setAmbientTextureMapping(getAmbientTextureMapping()); // exercise field checks, simple types
        
		setDiffuseColor(getDiffuseColor()); // exercise field checks, simple types
        
		setDiffuseTextureMapping(getDiffuseTextureMapping()); // exercise field checks, simple types
        
		setEmissiveColor(getEmissiveColor()); // exercise field checks, simple types
        
		setEmissiveTextureMapping(getEmissiveTextureMapping()); // exercise field checks, simple types
        
		setNormalScale(getNormalScale()); // exercise field checks, simple types
        
		setNormalTextureMapping(getNormalTextureMapping()); // exercise field checks, simple types
        
		setOcclusionStrength(getOcclusionStrength()); // exercise field checks, simple types
        
		setOcclusionTextureMapping(getOcclusionTextureMapping()); // exercise field checks, simple types
        
		setShininess(getShininess()); // exercise field checks, simple types
        
		setShininessTextureMapping(getShininessTextureMapping()); // exercise field checks, simple types
        
		setSpecularColor(getSpecularColor()); // exercise field checks, simple types
        
		setSpecularTextureMapping(getSpecularTextureMapping()); // exercise field checks, simple types
        
		setTransparency(getTransparency()); // exercise field checks, simple types
        
		if (!hasUSE()) // be careful! setting DEF via setDEF() method will reset USE value
			setDEF(getDEF()); // exercise field checks, simple types
        
		if (hasUSE()) // be careful! setting USE via setUSE() method resets all attributes to default values and wipes out all children
			setUSE(getUSE()); // exercise field checks, simple types
        
		setCssClass(getCssClass()); // exercise field checks, simple types
        
		setHtmlID(getHtmlID()); // exercise field checks, simple types
        
		setCssStyle(getCssStyle()); // exercise field checks, simple types
        
		if (ambientTexture != null)
		{
			setAmbientTexture(getAmbientTexture());
			((X3DConcreteElement) ambientTexture).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) ambientTexture).getValidationResult());
		}
		if (ambientTextureProtoInstance != null)
		{
			setAmbientTexture(getAmbientTextureProtoInstance());
			((X3DConcreteElement) ambientTextureProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) ambientTextureProtoInstance).getValidationResult());
		}
		if ((ambientTexture != null) && (ambientTextureProtoInstance != null))
		{
			String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both ambientTexture and ambientTextureProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
            if (hasUSE() && hasAmbientTexture()) // test USE restrictions
            {
                String errorNotice = "*** Material USE='" + getUSE() + "' is not allowed to have contained SFNode ambientTexture";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (diffuseTexture != null)
		{
			setDiffuseTexture(getDiffuseTexture());
			((X3DConcreteElement) diffuseTexture).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) diffuseTexture).getValidationResult());
		}
		if (diffuseTextureProtoInstance != null)
		{
			setDiffuseTexture(getDiffuseTextureProtoInstance());
			((X3DConcreteElement) diffuseTextureProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) diffuseTextureProtoInstance).getValidationResult());
		}
		if ((diffuseTexture != null) && (diffuseTextureProtoInstance != null))
		{
			String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both diffuseTexture and diffuseTextureProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
            if (hasUSE() && hasDiffuseTexture()) // test USE restrictions
            {
                String errorNotice = "*** Material USE='" + getUSE() + "' is not allowed to have contained SFNode diffuseTexture";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (emissiveTexture != null)
		{
			setEmissiveTexture(getEmissiveTexture());
			((X3DConcreteElement) emissiveTexture).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) emissiveTexture).getValidationResult());
		}
		if (emissiveTextureProtoInstance != null)
		{
			setEmissiveTexture(getEmissiveTextureProtoInstance());
			((X3DConcreteElement) emissiveTextureProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) emissiveTextureProtoInstance).getValidationResult());
		}
		if ((emissiveTexture != null) && (emissiveTextureProtoInstance != null))
		{
			String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both emissiveTexture and emissiveTextureProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
            if (hasUSE() && hasEmissiveTexture()) // test USE restrictions
            {
                String errorNotice = "*** Material USE='" + getUSE() + "' is not allowed to have contained SFNode emissiveTexture";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (IS != null)
		{
			setIS(getIS());
			((X3DConcreteElement) IS).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) IS).getValidationResult());
		}
            if (hasUSE() && hasIS()) // test USE restrictions
            {
                String errorNotice = "*** Material USE='" + getUSE() + "' is not allowed to have contained SFNode IS";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (metadata != null)
		{
			setMetadata(getMetadata());
			((X3DConcreteElement) metadata).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadata).getValidationResult());
		}
		if (metadataProtoInstance != null)
		{
			setMetadata(getMetadataProtoInstance());
			((X3DConcreteElement) metadataProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadataProtoInstance).getValidationResult());
		}
		if ((metadata != null) && (metadataProtoInstance != null))
		{
			String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
            if (hasUSE() && hasMetadata()) // test USE restrictions
            {
                String errorNotice = "*** Material USE='" + getUSE() + "' is not allowed to have contained SFNode metadata";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (normalTexture != null)
		{
			setNormalTexture(getNormalTexture());
			((X3DConcreteElement) normalTexture).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) normalTexture).getValidationResult());
		}
		if (normalTextureProtoInstance != null)
		{
			setNormalTexture(getNormalTextureProtoInstance());
			((X3DConcreteElement) normalTextureProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) normalTextureProtoInstance).getValidationResult());
		}
		if ((normalTexture != null) && (normalTextureProtoInstance != null))
		{
			String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both normalTexture and normalTextureProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
            if (hasUSE() && hasNormalTexture()) // test USE restrictions
            {
                String errorNotice = "*** Material USE='" + getUSE() + "' is not allowed to have contained SFNode normalTexture";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (occlusionTexture != null)
		{
			setOcclusionTexture(getOcclusionTexture());
			((X3DConcreteElement) occlusionTexture).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) occlusionTexture).getValidationResult());
		}
		if (occlusionTextureProtoInstance != null)
		{
			setOcclusionTexture(getOcclusionTextureProtoInstance());
			((X3DConcreteElement) occlusionTextureProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) occlusionTextureProtoInstance).getValidationResult());
		}
		if ((occlusionTexture != null) && (occlusionTextureProtoInstance != null))
		{
			String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both occlusionTexture and occlusionTextureProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
            if (hasUSE() && hasOcclusionTexture()) // test USE restrictions
            {
                String errorNotice = "*** Material USE='" + getUSE() + "' is not allowed to have contained SFNode occlusionTexture";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (shininessTexture != null)
		{
			setShininessTexture(getShininessTexture());
			((X3DConcreteElement) shininessTexture).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) shininessTexture).getValidationResult());
		}
		if (shininessTextureProtoInstance != null)
		{
			setShininessTexture(getShininessTextureProtoInstance());
			((X3DConcreteElement) shininessTextureProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) shininessTextureProtoInstance).getValidationResult());
		}
		if ((shininessTexture != null) && (shininessTextureProtoInstance != null))
		{
			String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both shininessTexture and shininessTextureProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
            if (hasUSE() && hasShininessTexture()) // test USE restrictions
            {
                String errorNotice = "*** Material USE='" + getUSE() + "' is not allowed to have contained SFNode shininessTexture";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (specularTexture != null)
		{
			setSpecularTexture(getSpecularTexture());
			((X3DConcreteElement) specularTexture).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) specularTexture).getValidationResult());
		}
		if (specularTextureProtoInstance != null)
		{
			setSpecularTexture(getSpecularTextureProtoInstance());
			((X3DConcreteElement) specularTextureProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) specularTextureProtoInstance).getValidationResult());
		}
		if ((specularTexture != null) && (specularTextureProtoInstance != null))
		{
			String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both specularTexture and specularTextureProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
            if (hasUSE() && hasSpecularTexture()) // test USE restrictions
            {
                String errorNotice = "*** Material USE='" + getUSE() + "' is not allowed to have contained SFNode specularTexture";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (getIS() != null)
		{
			if (getIS().getConnectList().isEmpty())
			{
				String errorNotice = "*** IS statement present, but contains no connect statements";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
			}
			// TODO also check that this node has ancestor ProtoBody, and that a field with same name also exists, so that IS is legal
		}
		if (!getContainerFieldOverride().isBlank() &&
			!Arrays.asList(containerField_ALLOWED_VALUES).contains(getContainerFieldOverride()))
		{
			String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE +
				": illegal value encountered, containerField='" + getContainerFieldOverride() +
				"' but allowed values are containerField_ALLOWED_VALUES='" +
				new MFString(containerField_ALLOWED_VALUES).toStringX3D() + "'.";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
		}

		// profile validation test, if connected to full scene
		if (findAncestorX3D() != null)
		{
			String     modelProfile = findAncestorX3D().getProfile();

			// check whether model has a satisfactory profile for this node
			boolean hasSatisfactorySupport = findAncestorX3D().supportsX3dProfile   (modelProfile) ||
                                             findAncestorX3D().supportsX3dComponent (COMPONENT, LEVEL);

			if (!hasSatisfactorySupport)
			{
				String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE +
					" insufficient X3D profile='" + modelProfile +
					"' for current X3D model containing 'Material' node, ensure sufficient support by adding head statement <component name='Shape' level='1'/>\n" +
					"or Java source-code assignment: " +
					" findAncestorX3D().getHead().addComponent(\"Shape\").setLevel(1);";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
			}
		}
		return validationResult.toString();
	}
}
