/*
Web3D Consortium Open-Source License for Models and Software

Copyright (c) 1995-2025 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.jsail.CubeMapTexturing;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
import org.web3d.x3d.jsail.fields.*; // making sure #4
// import org.web3d.x3d.jsail.CubeMapTexturing.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;
// import org.web3d.x3d.jsail.CubeMapTexturing.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;
// import org.web3d.x3d.jsail.CubeMapTexturing.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;
// import org.web3d.x3d.jsail.CubeMapTexturing.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
// import org.web3d.x3d.jsail.CubeMapTexturing.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;
// import org.web3d.x3d.jsail.CubeMapTexturing.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
// import org.web3d.x3d.jsail.CubeMapTexturing.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;
// import org.web3d.x3d.jsail.CubeMapTexturing.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;
// import org.web3d.x3d.jsail.CubeMapTexturing.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;

/**
 * ComposedCubeMapTexture is a texture node that defines a cubic environment map source as an explicit set of images drawn from individual 2D texture nodes.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>ComposedCubeMapTexture node tooltip</i>: (X3D version 3.1 or later) [X3DEnvironmentTextureNode] ComposedCubeMapTexture is a texture node that defines a cubic environment map source as an explicit set of images drawn from individual 2D texture nodes.
 * <ul>
 *  <li> <i>Hint:</i> 0..6 child image nodes are allowed (ImageTexture MovieTexture PixelTexture) with corresponding containerField values: front back left right top bottom. </li> 
 *  <li> <i>Warning:</i> each of the child ImageTexture or PixelTexture nodes must have unique containerField values for backTexture, bottomTexture, frontTexture, leftTexture, rightTexture, or topTexture. </li> 
 *  <li> <i>Warning:</i>  fields originally named back, bottom, front, left, right, or top in X3Dv3. </li> 
 * </ul>
 * <br>
 * <i>Package hint:</i>  This org.web3d.x3d.jsail concrete class is used for implementing a standalone X3D object as a <a href="https://en.wikipedia.org/wiki/Plain_old_Java_object" target="_blank">Plain Old Java Object (POJO)</a>.
 * If you are writing Java code for use inside an X3D Script node, compile separate code using only the <i>org.web3d.x3d.sai</i> package instead.
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/environmentalTexturing.html#ComposedCubeMapTexture" target="blank">X3D Abstract Specification: ComposedCubeMapTexture</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#ComposedCubeMapTexture" target="_blank">X3D Tooltips: ComposedCubeMapTexture</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images" target="_blank">X3D Scene Authoring Hints: Images</a>
 */
public class ComposedCubeMapTexture extends org.web3d.x3d.jsail.X3DConcreteNode implements org.web3d.x3d.sai.CubeMapTexturing.ComposedCubeMapTexture
{
    /** required by internal interface, empty list provided since no children array present in this class */
    private ArrayList<String> commentsList;

    // Member value declarations are encapsulated and private, using preferred Java types for concretes library

    /* @name=backTexture, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DTexture2DNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DTexture2DNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DTexture2DNode, $normalizedMemberObjectName=backTexture, $isX3dStatement=false, @acceptableNodeTypes=X3DTexture2DNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DTexture2DNode backTexture; //  X3D field type: SFNode acceptable node types: X3DTexture2DNode or ProtoInstance
	private ProtoInstance backTextureProtoInstance; // allowed alternative for backTexture field

    /* @name=bottomTexture, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DTexture2DNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DTexture2DNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DTexture2DNode, $normalizedMemberObjectName=bottomTexture, $isX3dStatement=false, @acceptableNodeTypes=X3DTexture2DNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DTexture2DNode bottomTexture; //  X3D field type: SFNode acceptable node types: X3DTexture2DNode or ProtoInstance
	private ProtoInstance bottomTextureProtoInstance; // allowed alternative for bottomTexture field

    /* @name=description, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=description, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String description = new String(); //  X3D field type: SFString

    /* @name=frontTexture, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DTexture2DNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DTexture2DNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DTexture2DNode, $normalizedMemberObjectName=frontTexture, $isX3dStatement=false, @acceptableNodeTypes=X3DTexture2DNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DTexture2DNode frontTexture; //  X3D field type: SFNode acceptable node types: X3DTexture2DNode or ProtoInstance
	private ProtoInstance frontTextureProtoInstance; // allowed alternative for frontTexture field

    /* @name=IS, @type=SFNode, $javaType=IS, $javaReferenceType=IS, $javaPrimitiveType=IS, $normalizedMemberObjectName=IS, $isX3dStatement=true, @acceptableNodeTypes=IS */ 
    private IS IS; //  X3D field type: SFNode acceptable node types: IS

    /* @name=leftTexture, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DTexture2DNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DTexture2DNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DTexture2DNode, $normalizedMemberObjectName=leftTexture, $isX3dStatement=false, @acceptableNodeTypes=X3DTexture2DNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DTexture2DNode leftTexture; //  X3D field type: SFNode acceptable node types: X3DTexture2DNode or ProtoInstance
	private ProtoInstance leftTextureProtoInstance; // allowed alternative for leftTexture field

    /* @name=metadata, @type=SFNode, $javaType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaReferenceType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaPrimitiveType= org.web3d.x3d.sai.Core.X3DMetadataObject, $normalizedMemberObjectName=metadata, $isX3dStatement=false, @acceptableNodeTypes=X3DMetadataObject */ 
    private  org.web3d.x3d.sai.Core.X3DMetadataObject metadata; //  X3D field type: SFNode acceptable node types: X3DMetadataObject or ProtoInstance
	private ProtoInstance metadataProtoInstance; // allowed alternative for metadata field

    /* @name=rightTexture, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DTexture2DNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DTexture2DNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DTexture2DNode, $normalizedMemberObjectName=rightTexture, $isX3dStatement=false, @acceptableNodeTypes=X3DTexture2DNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DTexture2DNode rightTexture; //  X3D field type: SFNode acceptable node types: X3DTexture2DNode or ProtoInstance
	private ProtoInstance rightTextureProtoInstance; // allowed alternative for rightTexture field

    /* @name=textureProperties, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.TextureProperties, $javaReferenceType= org.web3d.x3d.sai.Texturing.TextureProperties, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.TextureProperties, $normalizedMemberObjectName=textureProperties, $isX3dStatement=false, @acceptableNodeTypes=TextureProperties */ 
    private  org.web3d.x3d.sai.Texturing.TextureProperties textureProperties; //  X3D field type: SFNode acceptable node types: TextureProperties or ProtoInstance
	private ProtoInstance texturePropertiesProtoInstance; // allowed alternative for textureProperties field

    /* @name=topTexture, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DTexture2DNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DTexture2DNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DTexture2DNode, $normalizedMemberObjectName=topTexture, $isX3dStatement=false, @acceptableNodeTypes=X3DTexture2DNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DTexture2DNode topTexture; //  X3D field type: SFNode acceptable node types: X3DTexture2DNode or ProtoInstance
	private ProtoInstance topTextureProtoInstance; // allowed alternative for topTexture field

	// String constants for default field values match X3D Schema definitions

	/** String constant <i>NAME</i> provides name of this element: <i>ComposedCubeMapTexture</i>. */
	@SuppressWarnings("FieldNameHidesFieldInSuperclass")
	public static final String NAME = "ComposedCubeMapTexture";

	/** Provides name of this element: <i>ComposedCubeMapTexture</i>
	 * @return name of this element
	 */
	@Override
	public final String getElementName()
	{
		return NAME;
	}

	/** String constant <i>COMPONENT</i> defines X3D component for the <i>ComposedCubeMapTexture</i> element: <i>CubeMapTexturing</i> */
	public static final String COMPONENT = "CubeMapTexturing";

	/** Defines X3D component for the <i>ComposedCubeMapTexture</i> element: <i>CubeMapTexturing</i>
	 * @return X3D component for this element
	 */
	/* @Override */
	public final String getComponent()
	{
		return COMPONENT;
	}

	/** Integer constant <i>LEVEL</i> provides default X3D <i>CubeMapTexturing</i> component level for this element: <i>1</i> */
	public static final int LEVEL = 1;

	/** Provides default X3D component level for this element: <i>1</i>
	 * @return default X3D component level for this element
	 */
	/* @Override */
	public final int getComponentLevel()
	{
		return LEVEL;
	}

            // DEFAULT_VALUE declarations

	/** SFNode field named <i>backTexture</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DTexture2DNode BACKTEXTURE_DEFAULT_VALUE = null;

	/** SFNode field named <i>bottomTexture</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DTexture2DNode BOTTOMTEXTURE_DEFAULT_VALUE = null;

	/** SFString field named <i>description</i> has default value equal to an empty string. */
	public static final String DESCRIPTION_DEFAULT_VALUE = "";

	/** SFNode field named <i>frontTexture</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DTexture2DNode FRONTTEXTURE_DEFAULT_VALUE = null;

	/** SFNode field named <i>IS</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final IS IS_DEFAULT_VALUE = null;

	/** SFNode field named <i>leftTexture</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DTexture2DNode LEFTTEXTURE_DEFAULT_VALUE = null;

	/** SFNode field named <i>metadata</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Core.X3DMetadataObject METADATA_DEFAULT_VALUE = null;

	/** SFNode field named <i>rightTexture</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DTexture2DNode RIGHTTEXTURE_DEFAULT_VALUE = null;

	/** SFNode field named <i>textureProperties</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.TextureProperties TEXTUREPROPERTIES_DEFAULT_VALUE = null;

	/** SFNode field named <i>topTexture</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DTexture2DNode TOPTEXTURE_DEFAULT_VALUE = null;

	/** Indicate type corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_TYPE
	 * @return X3D type (SFvec3f etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE if not recognized
	 */
	/* @Override */
	public String getFieldType(String fieldName)
	{
		String result;

		switch (fieldName)
		{
			// String constants for exact field type values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing type-matching checks

			case "containerField":
				result = "SFString";
				break;
			case "backTexture":
				result = "SFNode";
				break;
			case "bottomTexture":
				result = "SFNode";
				break;
			case "description":
				result = "SFString";
				break;
			case "frontTexture":
				result = "SFNode";
				break;
			case "IS":
				result = "SFNode";
				break;
			case "leftTexture":
				result = "SFNode";
				break;
			case "metadata":
				result = "SFNode";
				break;
			case "rightTexture":
				result = "SFNode";
				break;
			case "textureProperties":
				result = "SFNode";
				break;
			case "topTexture":
				result = "SFNode";
				break;
			case "DEF":
				result = "SFString";
				break;
			case "USE":
				result = "SFString";
				break;
			case "class":
				result = "SFString";
				break;
			case "id":
				result = "SFString";
				break;
			case "style":
				result = "SFString";
				break;
			default:
			{
				// if fieldName has a prefix "set_" prepended (or a suffix "_changed" appended) then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getFieldType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/** Indicate accessType corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_ACCESSTYPE
	 * @return X3D accessType (inputOnly etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE if not recognized
	 */
	/* @Override */
	public String getAccessType(String fieldName)
	{
		String result; // set by following checks
		switch (fieldName)
		{
			// String constants for field accessType values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing accessType-matching checks
			case "backTexture":
				result = "inputOutput";
				break;
			case "bottomTexture":
				result = "inputOutput";
				break;
			case "description":
				result = "inputOutput";
				break;
			case "frontTexture":
				result = "inputOutput";
				break;
			case "IS":
				result = "inputOutput";
				break;
			case "leftTexture":
				result = "inputOutput";
				break;
			case "metadata":
				result = "inputOutput";
				break;
			case "rightTexture":
				result = "inputOutput";
				break;
			case "textureProperties":
				result = "initializeOnly";
				break;
			case "topTexture":
				result = "inputOutput";
				break;
			case "DEF":
				result = "inputOutput";
				break;
			case "USE":
				result = "inputOutput";
				break;
			case "class":
				result = "inputOutput";
				break;
			case "id":
				result = "inputOutput";
				break;
			case "style":
				result = "inputOutput";
				break;
			default:
			{
				// if user has added a prefix "set_" or suffix "_changed" then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getAccessType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/**
         * containerField describes typical field relationship of a node to its parent.
	 * Usage is not ordinarily needed when using this API, this default value is provided for informational purposes only.
         * <br />
         * containerField_DEFAULT_VALUE = "texture";
         * <br />
         * containerField_ALLOWED_VALUES = {"texture" };  type xs:NMTOKEN
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField" target="_blank">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerFieldChoices" target="_blank">X3D Scene Authoring Hints: validation choices for containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html" target="_blank">X3D Unified Object Model (X3DUOM)</a>
	 */

	public static final String containerField_DEFAULT_VALUE = "texture"; // type xs:NMTOKEN
	/**
         * containerField describes typical field relationship of a node to its parent.
	 * Programmer usage is not ordinarily needed when using this API, since this default value is provided for informational purposes only.
	 * @see #containerField_DEFAULT_VALUE
         * @see org.web3d.x3d.jsail.X3DConcreteNode#containerField_ALLOWED_VALUES
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField" target="_blank">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerFieldChoices" target="_blank">X3D Scene Authoring Hints: validation choices for containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html" target="_blank">X3D Unified Object Model (X3DUOM)</a>
         * @return default containerField value
	 */
        @Override
        public final String getContainerFieldDefault()
        {
            return containerField_DEFAULT_VALUE;
        }

	// String constants for field names usable in ROUTE statements

	/** fromField ROUTE name for SFNode field named <i>backTexture</i>. */
	public static final String fromField_BACKTEXTURE = "backTexture";

	/** toField ROUTE name for SFNode field named <i>backTexture</i>. */
	public static final String toField_BACKTEXTURE = "backTexture";

	/** fromField ROUTE name for SFNode field named <i>bottomTexture</i>. */
	public static final String fromField_BOTTOMTEXTURE = "bottomTexture";

	/** toField ROUTE name for SFNode field named <i>bottomTexture</i>. */
	public static final String toField_BOTTOMTEXTURE = "bottomTexture";

	/** fromField ROUTE name for SFString field named <i>description</i>. */
	public static final String fromField_DESCRIPTION = "description";

	/** toField ROUTE name for SFString field named <i>description</i>. */
	public static final String toField_DESCRIPTION = "description";

	/** fromField ROUTE name for SFNode field named <i>frontTexture</i>. */
	public static final String fromField_FRONTTEXTURE = "frontTexture";

	/** toField ROUTE name for SFNode field named <i>frontTexture</i>. */
	public static final String toField_FRONTTEXTURE = "frontTexture";

	/** fromField ROUTE name for SFNode field named <i>IS</i>. */
	public static final String fromField_IS = "IS";

	/** fromField ROUTE name for SFNode field named <i>leftTexture</i>. */
	public static final String fromField_LEFTTEXTURE = "leftTexture";

	/** toField ROUTE name for SFNode field named <i>leftTexture</i>. */
	public static final String toField_LEFTTEXTURE = "leftTexture";

	/** fromField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String fromField_METADATA = "metadata";

	/** toField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String toField_METADATA = "metadata";

	/** fromField ROUTE name for SFNode field named <i>rightTexture</i>. */
	public static final String fromField_RIGHTTEXTURE = "rightTexture";

	/** toField ROUTE name for SFNode field named <i>rightTexture</i>. */
	public static final String toField_RIGHTTEXTURE = "rightTexture";

	/** fromField ROUTE name for SFNode field named <i>topTexture</i>. */
	public static final String fromField_TOPTEXTURE = "topTexture";

	/** toField ROUTE name for SFNode field named <i>topTexture</i>. */
	public static final String toField_TOPTEXTURE = "topTexture";

	/** Constructor for ComposedCubeMapTexture to initialize member variables with default values. */
	public ComposedCubeMapTexture()
	{
		super(); // constructor invocation and corresponding initialize()
		initialize();
	}

	/** Initialize all member variables to default values. */
	@Override
	public final void initialize()
	{
		super.initialize();

        setContainerFieldOverride(""); // ensuring default value used
	containerField_ALLOWED_VALUES = new String[] { "texture" }; // type xs:NMTOKEN

		backTexture = null;              // clear out any prior node
		backTextureProtoInstance = null; // clear out any prior node
		bottomTexture = null;              // clear out any prior node
		bottomTextureProtoInstance = null; // clear out any prior node
		description = DESCRIPTION_DEFAULT_VALUE;
		frontTexture = null;              // clear out any prior node
		frontTextureProtoInstance = null; // clear out any prior node
		IS = null; // clear out any prior node
		leftTexture = null;              // clear out any prior node
		leftTextureProtoInstance = null; // clear out any prior node
		metadata = null;              // clear out any prior node
		metadataProtoInstance = null; // clear out any prior node
		rightTexture = null;              // clear out any prior node
		rightTextureProtoInstance = null; // clear out any prior node
		textureProperties = null;              // clear out any prior node
		texturePropertiesProtoInstance = null; // clear out any prior node
		topTexture = null;              // clear out any prior node
		topTextureProtoInstance = null; // clear out any prior node

		commentsList = new ArrayList<>(); // instantiate, initialize
	}

	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) from inputOutput SFNode field <i>backTexture</i>.
	 * @see #getBackTextureProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'back' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @return value of backTexture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=BackTexture, $memberObjectName=backTexture, $memberObjectName=backTexture)

	public  org.web3d.x3d.sai.Texturing.X3DTexture2DNode getBackTexture()
	{
		return backTexture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) to inputOutput SFNode field <i>backTexture</i>.
	 * @see #setBackTexture(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'back' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @param newValue is new value for the backTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ComposedCubeMapTexture setBackTexture( org.web3d.x3d.sai.Texturing.X3DTexture2DNode newValue)
	{
		// set-newValue-validity-checks #0.a
		backTexture = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) backTexture).setParent(this); // parentTest15.1
			((X3DConcreteNode)backTexture).setContainerFieldOverride("backTexture");
		}
		if (backTextureProtoInstance != null)
		{
			backTextureProtoInstance.setParent(null); // housekeeping, clear prior object
			backTextureProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of backTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public ComposedCubeMapTexture clearBackTexture()
	{
		((X3DConcreteElement) backTexture).clearParent(); // remove references to facilitate Java memory management
		backTexture = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>backTexture</i>.
	 * @see #setBackTexture( org.web3d.x3d.sai.Texturing.X3DTexture2DNode)
	 * @param newValue is new value for the backTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setBackTexture(ProtoInstance newValue)
	{
		if (backTextureProtoInstance != null)
		{
			((X3DConcreteElement) backTextureProtoInstance).setParent(null); // parentTest15.5
	    }
		backTextureProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) backTextureProtoInstance).setParent(this); // parentTest15.6
            backTextureProtoInstance.setContainerField("backTexture");
	    }
		if (backTexture != null)
		{
			((X3DConcreteElement) backTexture).setParent(null); // housekeeping, clear prior object
			backTexture = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getBackTextureProtoInstance()
		{
			return backTextureProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>backTexture</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getBackTexture()
	 * @see #getBackTextureProtoInstance()
	 */
	public boolean hasBackTexture()
	{
		return (backTexture != null) || (backTextureProtoInstance != null);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) from inputOutput SFNode field <i>bottomTexture</i>.
	 * @see #getBottomTextureProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'bottom' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @return value of bottomTexture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=BottomTexture, $memberObjectName=bottomTexture, $memberObjectName=bottomTexture)

	public  org.web3d.x3d.sai.Texturing.X3DTexture2DNode getBottomTexture()
	{
		return bottomTexture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) to inputOutput SFNode field <i>bottomTexture</i>.
	 * @see #setBottomTexture(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'bottom' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @param newValue is new value for the bottomTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ComposedCubeMapTexture setBottomTexture( org.web3d.x3d.sai.Texturing.X3DTexture2DNode newValue)
	{
		// set-newValue-validity-checks #0.a
		bottomTexture = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) bottomTexture).setParent(this); // parentTest15.1
			((X3DConcreteNode)bottomTexture).setContainerFieldOverride("bottomTexture");
		}
		if (bottomTextureProtoInstance != null)
		{
			bottomTextureProtoInstance.setParent(null); // housekeeping, clear prior object
			bottomTextureProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of bottomTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public ComposedCubeMapTexture clearBottomTexture()
	{
		((X3DConcreteElement) bottomTexture).clearParent(); // remove references to facilitate Java memory management
		bottomTexture = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>bottomTexture</i>.
	 * @see #setBottomTexture( org.web3d.x3d.sai.Texturing.X3DTexture2DNode)
	 * @param newValue is new value for the bottomTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setBottomTexture(ProtoInstance newValue)
	{
		if (bottomTextureProtoInstance != null)
		{
			((X3DConcreteElement) bottomTextureProtoInstance).setParent(null); // parentTest15.5
	    }
		bottomTextureProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) bottomTextureProtoInstance).setParent(this); // parentTest15.6
            bottomTextureProtoInstance.setContainerField("bottomTexture");
	    }
		if (bottomTexture != null)
		{
			((X3DConcreteElement) bottomTexture).setParent(null); // housekeeping, clear prior object
			bottomTexture = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getBottomTextureProtoInstance()
		{
			return bottomTextureProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>bottomTexture</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getBottomTexture()
	 * @see #getBottomTextureProtoInstance()
	 */
	public boolean hasBottomTexture()
	{
		return (bottomTexture != null) || (bottomTextureProtoInstance != null);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Author-provided prose that describes intended purpose of the url asset.
 * <ul>
 *  <li> <i> Hint:</i>  many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character). </li> 
 * </ul>
	 * @return value of description field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)

	public String getDescription()
	{
		return description;
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i> Author-provided prose that describes intended purpose of the url asset.
 * <ul>
 *  <li> <i> Hint:</i>  many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character). </li> 
 * </ul>
	 * @param newValue is new value for the description field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ComposedCubeMapTexture setDescription(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		description = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString description field, similar to {@link #setDescription(String)}.
	 * @param newValue is new value for the description field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setDescription(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDescription(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) from inputOutput SFNode field <i>frontTexture</i>.
	 * @see #getFrontTextureProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'front' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @return value of frontTexture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=FrontTexture, $memberObjectName=frontTexture, $memberObjectName=frontTexture)

	public  org.web3d.x3d.sai.Texturing.X3DTexture2DNode getFrontTexture()
	{
		return frontTexture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) to inputOutput SFNode field <i>frontTexture</i>.
	 * @see #setFrontTexture(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'front' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @param newValue is new value for the frontTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ComposedCubeMapTexture setFrontTexture( org.web3d.x3d.sai.Texturing.X3DTexture2DNode newValue)
	{
		// set-newValue-validity-checks #0.a
		frontTexture = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) frontTexture).setParent(this); // parentTest15.1
			((X3DConcreteNode)frontTexture).setContainerFieldOverride("frontTexture");
		}
		if (frontTextureProtoInstance != null)
		{
			frontTextureProtoInstance.setParent(null); // housekeeping, clear prior object
			frontTextureProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of frontTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public ComposedCubeMapTexture clearFrontTexture()
	{
		((X3DConcreteElement) frontTexture).clearParent(); // remove references to facilitate Java memory management
		frontTexture = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>frontTexture</i>.
	 * @see #setFrontTexture( org.web3d.x3d.sai.Texturing.X3DTexture2DNode)
	 * @param newValue is new value for the frontTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setFrontTexture(ProtoInstance newValue)
	{
		if (frontTextureProtoInstance != null)
		{
			((X3DConcreteElement) frontTextureProtoInstance).setParent(null); // parentTest15.5
	    }
		frontTextureProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) frontTextureProtoInstance).setParent(this); // parentTest15.6
            frontTextureProtoInstance.setContainerField("frontTexture");
	    }
		if (frontTexture != null)
		{
			((X3DConcreteElement) frontTexture).setParent(null); // housekeeping, clear prior object
			frontTexture = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getFrontTextureProtoInstance()
		{
			return frontTextureProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>frontTexture</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getFrontTexture()
	 * @see #getFrontTextureProtoInstance()
	 */
	public boolean hasFrontTexture()
	{
		return (frontTexture != null) || (frontTextureProtoInstance != null);
	}
	/**
	 * Provide IS instance (using a properly typed node) from inputOutput SFNode field <i>IS</i>.
	 * @return value of IS field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=true, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=IS, $memberObjectName=IS, $memberObjectName=IS)
	public IS getIS()
	{
		return IS;
	}

	/**
	 * Accessor method to assign IS instance (using a properly typed node) to inputOutput SFNode field <i>IS</i>.
	 * @param newValue is new value for the IS field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setIS(IS newValue)
	{
		// set-newValue-validity-checks #0.a
		IS = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) IS).setParent(this); // parentTest15.1
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of IS field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public ComposedCubeMapTexture clearIS()
	{
		((X3DConcreteElement) IS).clearParent(); // remove references to facilitate Java memory management
		IS = null; // reset SFNode field
		return this;
	}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>IS</i>.
	 * @return whether a concrete statement or CommentsBlock is available.
	 * @see #getIS()
	 */
	public boolean hasIS()
	{
		return (IS != null);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) from inputOutput SFNode field <i>leftTexture</i>.
	 * @see #getLeftTextureProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodese).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'left' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @return value of leftTexture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=LeftTexture, $memberObjectName=leftTexture, $memberObjectName=leftTexture)

	public  org.web3d.x3d.sai.Texturing.X3DTexture2DNode getLeftTexture()
	{
		return leftTexture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) to inputOutput SFNode field <i>leftTexture</i>.
	 * @see #setLeftTexture(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodese).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'left' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @param newValue is new value for the leftTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ComposedCubeMapTexture setLeftTexture( org.web3d.x3d.sai.Texturing.X3DTexture2DNode newValue)
	{
		// set-newValue-validity-checks #0.a
		leftTexture = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) leftTexture).setParent(this); // parentTest15.1
			((X3DConcreteNode)leftTexture).setContainerFieldOverride("leftTexture");
		}
		if (leftTextureProtoInstance != null)
		{
			leftTextureProtoInstance.setParent(null); // housekeeping, clear prior object
			leftTextureProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of leftTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public ComposedCubeMapTexture clearLeftTexture()
	{
		((X3DConcreteElement) leftTexture).clearParent(); // remove references to facilitate Java memory management
		leftTexture = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>leftTexture</i>.
	 * @see #setLeftTexture( org.web3d.x3d.sai.Texturing.X3DTexture2DNode)
	 * @param newValue is new value for the leftTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setLeftTexture(ProtoInstance newValue)
	{
		if (leftTextureProtoInstance != null)
		{
			((X3DConcreteElement) leftTextureProtoInstance).setParent(null); // parentTest15.5
	    }
		leftTextureProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) leftTextureProtoInstance).setParent(this); // parentTest15.6
            leftTextureProtoInstance.setContainerField("leftTexture");
	    }
		if (leftTexture != null)
		{
			((X3DConcreteElement) leftTexture).setParent(null); // housekeeping, clear prior object
			leftTexture = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getLeftTextureProtoInstance()
		{
			return leftTextureProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>leftTexture</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getLeftTexture()
	 * @see #getLeftTextureProtoInstance()
	 */
	public boolean hasLeftTexture()
	{
		return (leftTexture != null) || (leftTextureProtoInstance != null);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * @see #getMetadataProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata()
	{
		return metadata;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i> [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node.
 * <ul>
 *  <li> <i> Hint:</i>  X3D Architecture 7.2.4 Metadata <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Metadata</a> </li> 
 * </ul>
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ComposedCubeMapTexture setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue)
	{
		// set-newValue-validity-checks #0.a
		metadata = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadata).setParent(this); // parentTest15.1
			// change X3D4 MetadataSet default 'value' back to 'metadata' if parent is not another Metadata* node */
			if (metadata instanceof org.web3d.x3d.jsail.Core.MetadataSet)
{
				((X3DConcreteNode) metadata).setContainerFieldOverride("metadata");
}
		}
		if (metadataProtoInstance != null)
		{
			metadataProtoInstance.setParent(null); // housekeeping, clear prior object
			metadataProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of metadata field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public ComposedCubeMapTexture clearMetadata()
	{
		((X3DConcreteElement) metadata).clearParent(); // remove references to facilitate Java memory management
		metadata = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject)
	 * @param newValue is new value for the metadata field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public ComposedCubeMapTexture setMetadata(ProtoInstance newValue)
	{
		if (metadataProtoInstance != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(null); // parentTest15.5
	    }
		metadataProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(this); // parentTest15.6
            metadataProtoInstance.setContainerField("metadata");
	    }
		if (metadata != null)
		{
			((X3DConcreteElement) metadata).setParent(null); // housekeeping, clear prior object
			metadata = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getMetadataProtoInstance()
		{
			return metadataProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>metadata</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getMetadata()
	 * @see #getMetadataProtoInstance()
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 */
	public boolean hasMetadata()
	{
		return (metadata != null) || (metadataProtoInstance != null);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) from inputOutput SFNode field <i>rightTexture</i>.
	 * @see #getRightTextureProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'right' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @return value of rightTexture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=RightTexture, $memberObjectName=rightTexture, $memberObjectName=rightTexture)

	public  org.web3d.x3d.sai.Texturing.X3DTexture2DNode getRightTexture()
	{
		return rightTexture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) to inputOutput SFNode field <i>rightTexture</i>.
	 * @see #setRightTexture(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'right' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @param newValue is new value for the rightTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ComposedCubeMapTexture setRightTexture( org.web3d.x3d.sai.Texturing.X3DTexture2DNode newValue)
	{
		// set-newValue-validity-checks #0.a
		rightTexture = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) rightTexture).setParent(this); // parentTest15.1
			((X3DConcreteNode)rightTexture).setContainerFieldOverride("rightTexture");
		}
		if (rightTextureProtoInstance != null)
		{
			rightTextureProtoInstance.setParent(null); // housekeeping, clear prior object
			rightTextureProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of rightTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public ComposedCubeMapTexture clearRightTexture()
	{
		((X3DConcreteElement) rightTexture).clearParent(); // remove references to facilitate Java memory management
		rightTexture = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>rightTexture</i>.
	 * @see #setRightTexture( org.web3d.x3d.sai.Texturing.X3DTexture2DNode)
	 * @param newValue is new value for the rightTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setRightTexture(ProtoInstance newValue)
	{
		if (rightTextureProtoInstance != null)
		{
			((X3DConcreteElement) rightTextureProtoInstance).setParent(null); // parentTest15.5
	    }
		rightTextureProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) rightTextureProtoInstance).setParent(this); // parentTest15.6
            rightTextureProtoInstance.setContainerField("rightTexture");
	    }
		if (rightTexture != null)
		{
			((X3DConcreteElement) rightTexture).setParent(null); // housekeeping, clear prior object
			rightTexture = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getRightTextureProtoInstance()
		{
			return rightTextureProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>rightTexture</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getRightTexture()
	 * @see #getRightTextureProtoInstance()
	 */
	public boolean hasRightTexture()
	{
		return (rightTexture != null) || (rightTextureProtoInstance != null);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.TextureProperties instance (using a properly typed node) from initializeOnly SFNode field <i>textureProperties</i>.
	 * @see #getTexturePropertiesProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i> [TextureProperties] Single contained TextureProperties node that can specify additional visual attributes applied to corresponding texture images.
 * <ul>
 *  <li> <i> Warning:</i>  TextureProperties must follow other textures in order to meet XML validation requirements. </li> 
 * </ul>
	 * @return value of textureProperties field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=TextureProperties, $memberObjectName=textureProperties, $memberObjectName=textureProperties)

	public  org.web3d.x3d.sai.Texturing.TextureProperties getTextureProperties()
	{
		return textureProperties;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.TextureProperties instance (using a properly typed node) to initializeOnly SFNode field <i>textureProperties</i>.
	 * @see #setTextureProperties(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i> [TextureProperties] Single contained TextureProperties node that can specify additional visual attributes applied to corresponding texture images.
 * <ul>
 *  <li> <i> Warning:</i>  TextureProperties must follow other textures in order to meet XML validation requirements. </li> 
 * </ul>
	 * @param newValue is new value for the textureProperties field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ComposedCubeMapTexture setTextureProperties( org.web3d.x3d.sai.Texturing.TextureProperties newValue)
	{
		// set-newValue-validity-checks #0.a
		textureProperties = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) textureProperties).setParent(this); // parentTest15.1
		}
		if (texturePropertiesProtoInstance != null)
		{
			texturePropertiesProtoInstance.setParent(null); // housekeeping, clear prior object
			texturePropertiesProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of textureProperties field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public ComposedCubeMapTexture clearTextureProperties()
	{
		((X3DConcreteElement) textureProperties).clearParent(); // remove references to facilitate Java memory management
		textureProperties = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to initializeOnly SFNode field <i>textureProperties</i>.
	 * @see #setTextureProperties( org.web3d.x3d.sai.Texturing.TextureProperties)
	 * @param newValue is new value for the textureProperties field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setTextureProperties(ProtoInstance newValue)
	{
		if (texturePropertiesProtoInstance != null)
		{
			((X3DConcreteElement) texturePropertiesProtoInstance).setParent(null); // parentTest15.5
	    }
		texturePropertiesProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) texturePropertiesProtoInstance).setParent(this); // parentTest15.6
            texturePropertiesProtoInstance.setContainerField("textureProperties");
	    }
		if (textureProperties != null)
		{
			((X3DConcreteElement) textureProperties).setParent(null); // housekeeping, clear prior object
			textureProperties = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getTexturePropertiesProtoInstance()
		{
			return texturePropertiesProtoInstance;
		}

	/**
	 * Indicate whether an object is available for initializeOnly SFNode field <i>textureProperties</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getTextureProperties()
	 * @see #getTexturePropertiesProtoInstance()
	 */
	public boolean hasTextureProperties()
	{
		return (textureProperties != null) || (texturePropertiesProtoInstance != null);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) from inputOutput SFNode field <i>topTexture</i>.
	 * @see #getTopTextureProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'top' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @return value of topTexture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=TopTexture, $memberObjectName=topTexture, $memberObjectName=topTexture)

	public  org.web3d.x3d.sai.Texturing.X3DTexture2DNode getTopTexture()
	{
		return topTexture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) to inputOutput SFNode field <i>topTexture</i>.
	 * @see #setTopTexture(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i> [X3DTexture2DNode] Parent ComposedCubeMapTexture element can contain up to six image nodes (ImageTexture PixelTexture MovieTexture, other texture nodes).
 * <ul>
 *  <li> <i>Warning:</i> each child image node must have a different containerField value. </li> 
 *  <li> <i>Warning:</i>  field originally named 'top' in X3Dv3. <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges</a> </li> 
 * </ul>
	 * @param newValue is new value for the topTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ComposedCubeMapTexture setTopTexture( org.web3d.x3d.sai.Texturing.X3DTexture2DNode newValue)
	{
		// set-newValue-validity-checks #0.a
		topTexture = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) topTexture).setParent(this); // parentTest15.1
			((X3DConcreteNode)topTexture).setContainerFieldOverride("topTexture");
		}
		if (topTextureProtoInstance != null)
		{
			topTextureProtoInstance.setParent(null); // housekeeping, clear prior object
			topTextureProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of topTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public ComposedCubeMapTexture clearTopTexture()
	{
		((X3DConcreteElement) topTexture).clearParent(); // remove references to facilitate Java memory management
		topTexture = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>topTexture</i>.
	 * @see #setTopTexture( org.web3d.x3d.sai.Texturing.X3DTexture2DNode)
	 * @param newValue is new value for the topTexture field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setTopTexture(ProtoInstance newValue)
	{
		if (topTextureProtoInstance != null)
		{
			((X3DConcreteElement) topTextureProtoInstance).setParent(null); // parentTest15.5
	    }
		topTextureProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) topTextureProtoInstance).setParent(this); // parentTest15.6
            topTextureProtoInstance.setContainerField("topTexture");
	    }
		if (topTexture != null)
		{
			((X3DConcreteElement) topTexture).setParent(null); // housekeeping, clear prior object
			topTexture = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getTopTextureProtoInstance()
		{
			return topTextureProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>topTexture</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getTopTexture()
	 * @see #getTopTextureProtoInstance()
	 */
	public boolean hasTopTexture()
	{
		return (topTexture != null) || (topTextureProtoInstance != null);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i> DEF defines a unique ID name for this node, referenceable by other nodes.
 * <ul>
 *  <li> <i>Hint:</i> descriptive DEF names improve clarity and help document a model. </li> 
 *  <li> <i>Hint:</i> well-defined names can simplify design and debugging through improved author understanding. </li> 
 *  <li> <i>Hint:</i>  X3D Scene Authoring Hints, Naming Conventions <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions</a> </li> 
 * </ul>
	 * @return value of DEF field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=DEF, $memberObjectName=DEF, $memberObjectName=DEF)

	public String getDEF()
	{
		// override abstract method in X3DConcreteNode
		return super.getDEF();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i> DEF defines a unique ID name for this node, referenceable by other nodes.
 * <ul>
 *  <li> <i>Hint:</i> descriptive DEF names improve clarity and help document a model. </li> 
 *  <li> <i>Hint:</i> well-defined names can simplify design and debugging through improved author understanding. </li> 
 *  <li> <i>Hint:</i>  X3D Scene Authoring Hints, Naming Conventions <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions</a> </li> 
 * </ul>
	 * <br><br>
	 *  Note that setting the DEF value clears the USE value.
	 * @param newValue is new value for the DEF field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final ComposedCubeMapTexture setDEF(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to ComposedCubeMapTexture DEF
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("ComposedCubeMapTexture DEF newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteUSE(""); // ensure that no previous USE value remains
		setConcreteDEF(newValue); // private superclass methods
		return this;
	}

	/**
	 * Assign typed object value to SFString DEF field, similar to {@link #setDEF(String)}.
	 * @param newValue is new value for the DEF field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setDEF(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDEF(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i> USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value).
 * <ul>
 *  <li> <i>Hint:</i> USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. </li> 
 *  <li> <i>Warning:</i> do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. </li> 
 *  <li> <i>Warning:</i>  each USE value must match a corresponding DEF value that is defined earlier in the scene. </li> 
 * </ul>
	 * @return value of USE field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=USE, $memberObjectName=USE, $memberObjectName=USE)

	public String getUSE()
	{
		// override abstract method in X3DConcreteNode
		return super.getUSE();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i> USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value).
 * <ul>
 *  <li> <i>Hint:</i> USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. </li> 
 *  <li> <i>Warning:</i> do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. </li> 
 *  <li> <i>Warning:</i>  each USE value must match a corresponding DEF value that is defined earlier in the scene. </li> 
 * </ul>
	 * <br><br>
	 * <i>Note:</i> each <code>USE</code> node is still an independent object, with the <code>USE</code> value matching the <code>DEF</code> value in the preceding object. 
	 * <br><br>
	 * <i>Warning:</i> invoking the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.<br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param newValue is new value for the USE field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final ComposedCubeMapTexture setUSE(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to ComposedCubeMapTexture USE
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("ComposedCubeMapTexture USE newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteDEF(""); // ensure that no previous DEF value remains
		setConcreteUSE(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString USE field, similar to {@link #setUSE(String)}.
	 * @param newValue is new value for the USE field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setUSE(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setUSE(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>class</i>.
	 * @return value of class field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=CssClass, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssClass()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssClass();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>class</i>.
	 * @param newValue is new value for the class field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final ComposedCubeMapTexture setCssClass(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssClass(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssClass(String)}.
	 * @param newValue is new value for the class field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setCssClass(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssClass(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>id</i>.
	 * @return value of id field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=HtmlID, $memberObjectName=HtmlID, $memberObjectName=HtmlID)

	public String getHtmlID()
	{
		// override abstract method in X3DConcreteNode
		return super.getHtmlID();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>id</i>.
	 * @param newValue is new value for the id field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final ComposedCubeMapTexture setHtmlID(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteHtmlID(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString HtmlID field, similar to {@link #setHtmlID(String)}.
	 * @param newValue is new value for the id field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setHtmlID(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setHtmlID(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>style</i>.
	 * @return value of style field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=ComposedCubeMapTexture, $CamelCaseName=CssStyle, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssStyle()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssStyle();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>style</i>.
	 * @param newValue is new value for the style field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final ComposedCubeMapTexture setCssStyle(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssStyle(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssStyle(String)}.
	 * @param newValue is new value for the style field.
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setCssStyle(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssStyle(newValue.getPrimitiveValue());
			return this;
	}

	// Additional utility methods for this class ==============================

	/**
	 * Assign a USE reference to another DEF node of same node type, similar to {@link #setUSE(String)}.
	 * <br ><br >
	 * <i>Warning:</i> note that the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.
	 * <br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param DEFnode must have a DEF value defined
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ComposedCubeMapTexture setUSE(ComposedCubeMapTexture DEFnode)
	{
		if (DEFnode.getDEF().isEmpty())
		{
			String errorNotice = "*** setUSE(DEFnode) invoked on ComposedCubeMapTexture" +
				" that has no DEF name defined, thus a copy cannot be referenced as a USE node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		setUSE(DEFnode.getDEF());
		return this;
	}
	/**
	 * Utility constructor that assigns DEF label after initializing member variables with default values.
	 * @param DEFlabel unique DEF name for this X3D node
	 */
	public ComposedCubeMapTexture (String DEFlabel)
	{
		initialize();
		setDEF(DEFlabel); // apply checks
	}

	/**
	 * Add comment as String to contained commentsList.
	 * @param newComment initial value
	 * @see <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#Organization">X3D Architecture, clause 7.2.5.1 Organization</a>
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public ComposedCubeMapTexture addComments (String newComment)
	{
		commentsList.add(newComment);
		return this;
	}
	/**
	 * Add comments as String[] array to contained commentsList.
	 * @param newComments array of comments
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public ComposedCubeMapTexture addComments (String[] newComments)
	{
		commentsList.addAll(Arrays.asList(newComments));
		return this;
	}
	/**
	 * Add CommentsBlock to contained commentsList.
	 * @param newCommentsBlock block of comments to add
	 * @return {@link ComposedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public ComposedCubeMapTexture addComments (CommentsBlock newCommentsBlock)
	{
		commentsList.addAll(newCommentsBlock.toStringList());
		return this;
	}
	/**
	 * Utility method to adjust field synonyms
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges">X3D Scene Authoring Hints: X3D4 Field name changes for improved consistency</a>
     */
    private void handleFieldSynonyms()
    {
        String correctedContainerField;
        if (hasAncestorX3D() && findAncestorX3D().getVersion().startsWith("3"))
             correctedContainerField = "back";
        else correctedContainerField = "backTexture";

        if      (getBackTexture() != null)
                 ((X3DConcreteNode) getBackTexture()).setContainerFieldOverride(correctedContainerField);
        else if (getBackTextureProtoInstance() != null)
                 ((X3DConcreteNode) getBackTextureProtoInstance()).setContainerFieldOverride(correctedContainerField);

        if (hasAncestorX3D() && findAncestorX3D().getVersion().startsWith("3"))
             correctedContainerField = "bottom";
        else correctedContainerField = "bottomTexture";

        if      (getBottomTexture() != null)
                 ((X3DConcreteNode) getBottomTexture()).setContainerFieldOverride(correctedContainerField);
        else if (getBottomTextureProtoInstance() != null)
                 ((X3DConcreteNode) getBottomTextureProtoInstance()).setContainerFieldOverride(correctedContainerField);

        if (hasAncestorX3D() && findAncestorX3D().getVersion().startsWith("3"))
             correctedContainerField = "front";
        else correctedContainerField = "frontTexture";

        if      (getFrontTexture() != null)
                 ((X3DConcreteNode) getFrontTexture()).setContainerFieldOverride(correctedContainerField);
        else if (getFrontTextureProtoInstance() != null)
                 ((X3DConcreteNode) getFrontTextureProtoInstance()).setContainerFieldOverride(correctedContainerField);

        if (hasAncestorX3D() && findAncestorX3D().getVersion().startsWith("3"))
             correctedContainerField = "left";
        else correctedContainerField = "leftTexture";

        if      (getLeftTexture() != null)
                 ((X3DConcreteNode) getLeftTexture()).setContainerFieldOverride(correctedContainerField);
        else if (getLeftTextureProtoInstance() != null)
                 ((X3DConcreteNode) getLeftTextureProtoInstance()).setContainerFieldOverride(correctedContainerField);

        if (hasAncestorX3D() && findAncestorX3D().getVersion().startsWith("3"))
             correctedContainerField = "right";
        else correctedContainerField = "rightTexture";

        if      (getRightTexture() != null)
                 ((X3DConcreteNode) getRightTexture()).setContainerFieldOverride(correctedContainerField);
        else if (getRightTextureProtoInstance() != null)
                 ((X3DConcreteNode) getRightTextureProtoInstance()).setContainerFieldOverride(correctedContainerField);

        if (hasAncestorX3D() && findAncestorX3D().getVersion().startsWith("3"))
             correctedContainerField = "top";
        else correctedContainerField = "topTexture";

        if      (getTopTexture() != null)
                 ((X3DConcreteNode) getTopTexture()).setContainerFieldOverride(correctedContainerField);
        else if (getTopTextureProtoInstance() != null)
                 ((X3DConcreteNode) getTopTextureProtoInstance()).setContainerFieldOverride(correctedContainerField);
	}

	/**
	 * Recursive method to provide X3D string serialization of this model subgraph, utilizing XML encoding and conforming to X3D Canonical Form.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_X3D
	 * @see X3D#FILE_EXTENSION_XML
	 * @see X3D#toStringXML()
	 * @see X3D#toFileXML(String)
	 * @see X3D#toFileX3D(String)
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-1/V3.3/Part01/X3D_XML.html">X3D XML Encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-3/V3.3/Part03/concepts.html#X3DCanonicalForm" target="blank">X3D Compressed Binary Encoding: X3D Canonical Form</a>
	 * @see <a href="https://www.web3d.org/x3d/tools/canonical/doc/x3dTools.htm">X3D Canonicalization (C14N) Tool</a>
	 * @return X3D string
	 */
	@Override
	public String toStringX3D(int indentLevel)
	{
		boolean hasAttributes = true; // TODO check for non-default attribute values
		boolean      hasChild = (IS != null) || (backTexture != null) || (backTextureProtoInstance != null) || 
		                        (bottomTexture != null) || (bottomTextureProtoInstance != null) || 
		                        (frontTexture != null) || (frontTextureProtoInstance != null) || 
		                        (IS != null) || 
		                        (leftTexture != null) || (leftTextureProtoInstance != null) || 
		                        (metadata != null) || (metadataProtoInstance != null) || 
		                        (rightTexture != null) || (rightTextureProtoInstance != null) || 
		                        (textureProperties != null) || (texturePropertiesProtoInstance != null) || 
		                        (topTexture != null) || (topTextureProtoInstance != null) || 
		                        !commentsList.isEmpty();
		if (hasUSE())
			hasChild = false; // USE nodes only include attributes for USE and non-default containerField
		handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder indent = new StringBuilder();
		int  indentIncrement = ConfigurationProperties.getIndentIncrement();
		char indentCharacter = ConfigurationProperties.getIndentCharacter();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		StringBuilder stringX3D = new StringBuilder();

		stringX3D.append(indent).append("<ComposedCubeMapTexture"); // start opening tag
		if (hasAttributes)
		{
			if (!getDEF().equals(DEF_DEFAULT_VALUE) && !hasUSE())
			{
				stringX3D.append(" DEF='").append(SFString.toString(getDEF())).append("'");
			}
			
			if (!getUSE().equals(USE_DEFAULT_VALUE))
			{
				stringX3D.append(" USE='").append(SFString.toString(getUSE())).append("'");
			}
			
            // containerField is critical for ProtoInstance relationship to parent node
            if (!getContainerFieldOverride().isBlank() && !getContainerFieldOverride().equals(this.getContainerFieldDefault())) // output if not default ProtoInstance containerField
            {
                    stringX3D.append(" containerField='").append(getContainerFieldOverride()).append("'");
            }

            // test attributes

			if ((!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" class='").append(new SFString(getCssClass()).toStringX3D()).append("'");
			}
			if ((!getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" description='").append(new SFString(getDescription()).toStringX3D()).append("'");
			}
			if ((!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" id='").append(new SFString(getHtmlID()).toStringX3D()).append("'");
			}
			if ((!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" style='").append(new SFString(getCssStyle()).toStringX3D()).append("'");
			}
		}
		if ((hasChild) && !hasUSE()) // has contained node(s), comment(s), IS/connect and/or source code
		{
			stringX3D.append(">").append("\n"); // finish opening tag

                        if (!commentsList.isEmpty())
                        {
                                CommentsBlock commentsBlock = new CommentsBlock(commentsList);
                                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
                        }
			// recursively iterate over child elements
			if      (IS != null)
			{
				stringX3D.append(((X3DConcreteElement)IS).toStringX3D(indentLevel + indentIncrement));
			}
			if      (metadata != null)
			{
				stringX3D.append(((X3DConcreteElement)metadata).toStringX3D(indentLevel + indentIncrement));
			}
			else if (metadataProtoInstance != null)
			{
				stringX3D.append(((X3DConcreteElement)metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (backTexture != null)
			{
				stringX3D.append(((X3DConcreteElement)backTexture).toStringX3D(indentLevel + indentIncrement));
			}
			else if (backTextureProtoInstance != null)
			{
				stringX3D.append(((X3DConcreteElement)backTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (bottomTexture != null)
			{
				stringX3D.append(((X3DConcreteElement)bottomTexture).toStringX3D(indentLevel + indentIncrement));
			}
			else if (bottomTextureProtoInstance != null)
			{
				stringX3D.append(((X3DConcreteElement)bottomTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (frontTexture != null)
			{
				stringX3D.append(((X3DConcreteElement)frontTexture).toStringX3D(indentLevel + indentIncrement));
			}
			else if (frontTextureProtoInstance != null)
			{
				stringX3D.append(((X3DConcreteElement)frontTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (leftTexture != null)
			{
				stringX3D.append(((X3DConcreteElement)leftTexture).toStringX3D(indentLevel + indentIncrement));
			}
			else if (leftTextureProtoInstance != null)
			{
				stringX3D.append(((X3DConcreteElement)leftTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (rightTexture != null)
			{
				stringX3D.append(((X3DConcreteElement)rightTexture).toStringX3D(indentLevel + indentIncrement));
			}
			else if (rightTextureProtoInstance != null)
			{
				stringX3D.append(((X3DConcreteElement)rightTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (textureProperties != null)
			{
				stringX3D.append(((X3DConcreteElement)textureProperties).toStringX3D(indentLevel + indentIncrement));
			}
			else if (texturePropertiesProtoInstance != null)
			{
				stringX3D.append(((X3DConcreteElement)texturePropertiesProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (topTexture != null)
			{
				stringX3D.append(((X3DConcreteElement)topTexture).toStringX3D(indentLevel + indentIncrement));
			}
			else if (topTextureProtoInstance != null)
			{
				stringX3D.append(((X3DConcreteElement)topTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			stringX3D.append(indent).append("</ComposedCubeMapTexture>").append("\n"); // finish closing tag
		}
		else
		{
			stringX3D.append("/>").append("\n"); // otherwise finish singleton tag
		}
		return stringX3D.toString();
	}
// ($name=ComposedCubeMapTexture, isX3dStatement=false, isClassX3dStatement=false, $hasChild=true, $hasAttributes=true
	/**
	 * Recursive method to provide ClassicVRML string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_CLASSICVRML
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/X3D_ClassicVRML.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/grammar.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding, Annex A: Grammar</a>
	 * @return ClassicVRML string
	 */
	@Override
	public String toStringClassicVRML(int indentLevel)
	{
		StringBuilder stringClassicVRML = new StringBuilder();
		boolean hasAttributes = true; // TODO further refinement
		boolean      hasChild = (IS != null) || (backTexture != null) || (backTextureProtoInstance != null) || 
		                        (bottomTexture != null) || (bottomTextureProtoInstance != null) || 
		                        (frontTexture != null) || (frontTextureProtoInstance != null) || 
		                        (IS != null) || 
		                        (leftTexture != null) || (leftTextureProtoInstance != null) || 
		                        (metadata != null) || (metadataProtoInstance != null) || 
		                        (rightTexture != null) || (rightTextureProtoInstance != null) || 
		                        (textureProperties != null) || (texturePropertiesProtoInstance != null) || 
		                        (topTexture != null) || (topTextureProtoInstance != null) || 
		                        !commentsList.isEmpty();
		if (hasUSE())
		{
			hasAttributes = false;
			hasChild      = false; // USE nodes include no other fields
		}
                if (!serializingVRML97output)
                    handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder  indent = new StringBuilder();
		char  indentCharacter = ConfigurationProperties.getIndentCharacter();
		int   indentIncrement = ConfigurationProperties.getIndentIncrement();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		if (!getDEF().equals(DEF_DEFAULT_VALUE))
		{
			stringClassicVRML.append("DEF ").append(SFString.toString(getDEF())).append(" ");
		}
		if (!getUSE().equals(USE_DEFAULT_VALUE))
		{
			 stringClassicVRML.append("USE ").append(SFString.toString(getUSE())).append("\n");
		}
		else // only have further output if not a USE node
		{
			stringClassicVRML.append("ComposedCubeMapTexture").append(" { "); // define node name, node content follows

			if (hasAttributes || hasChild)
			{
				stringClassicVRML.append("\n").append(indent).append(indentCharacter); // fields for this node follow
			}
			if (hasAttributes)
			{
				boolean hasISconnect = (getIS() != null) && !getIS().getConnectList().isEmpty();
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("class"))
						{
							stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(getCssClass())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("description"))
						{
							stringClassicVRML.append(indentCharacter).append("description").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("description ").append("\"").append(SFString.toString(getDescription())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("id"))
						{
							stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(getHtmlID())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("style"))
						{
							stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(getCssStyle())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
			}
		}
		if (hasChild) // has contained node(s) (including USE), comment(s), IS/connect and/or source code
		{
                        // recursively iterate over child elements

			if (metadata != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadata).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (metadataProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (IS != null)
			{
				stringClassicVRML.append(((X3DConcreteElement) IS).toStringClassicVRML(indentLevel)); // end X3D statement
			}
			if (backTexture != null)
			{
				stringClassicVRML.append(indentCharacter).append("backTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) backTexture).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (backTextureProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("backTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) backTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (bottomTexture != null)
			{
				stringClassicVRML.append(indentCharacter).append("bottomTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) bottomTexture).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (bottomTextureProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("bottomTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) bottomTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (frontTexture != null)
			{
				stringClassicVRML.append(indentCharacter).append("frontTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) frontTexture).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (frontTextureProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("frontTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) frontTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (leftTexture != null)
			{
				stringClassicVRML.append(indentCharacter).append("leftTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) leftTexture).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (leftTextureProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("leftTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) leftTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (rightTexture != null)
			{
				stringClassicVRML.append(indentCharacter).append("rightTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) rightTexture).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (rightTextureProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("rightTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) rightTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (textureProperties != null)
			{
				stringClassicVRML.append(indentCharacter).append("textureProperties").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) textureProperties).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (texturePropertiesProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("textureProperties").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) texturePropertiesProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (topTexture != null)
			{
				stringClassicVRML.append(indentCharacter).append("topTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) topTexture).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (topTextureProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("topTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) topTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}stringClassicVRML.append("\n").append(indent).append("\n"); // .append(" ### trace field initialization value #8")

			if (!commentsList.isEmpty())
			{
				CommentsBlock commentsBlock = new CommentsBlock(commentsList);
				stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
				stringClassicVRML.append(indent); // end SFNode
			}
		}
		if (getUSE().isEmpty() && (hasAttributes || hasChild))
		{
			stringClassicVRML.append("}").append("\n"); // finish node content
		}
		return stringClassicVRML.toString();
	}


    private boolean serializingVRML97output = false; // whether to avoid handling field name synonyms

	/**
	 * Recursive method to provide VRML97 string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_VRML97
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772/V2.0/index.html">Virtual Reality Modeling Language (VRML) 97 specification</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772-1/V2.1/index.html">VRML 97 v2.1 Amendment</a>
	 * @return VRML97 string
	 */
	@Override
	public String toStringVRML97(int indentLevel)
	{
            serializingVRML97output = true;
            String result = toStringClassicVRML(indentLevel);
            serializingVRML97output = false;

            return result;
	}

	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue)
	{
		return findElementByNameValue(nameValue, ""); // empty string is wildcard, any element match is allowed
	}

	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue, String elementName)
	{
		if ((nameValue == null) || nameValue.isEmpty())
		{
			String errorNotice = "*** findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		// no name field available for this element
		X3DConcreteElement referenceElement;
		if (backTexture != null)
		{
			referenceElement = ((X3DConcreteElement) backTexture).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (backTextureProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) backTextureProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (bottomTexture != null)
		{
			referenceElement = ((X3DConcreteElement) bottomTexture).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (bottomTextureProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) bottomTextureProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (frontTexture != null)
		{
			referenceElement = ((X3DConcreteElement) frontTexture).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (frontTextureProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) frontTextureProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (IS != null)
		{
			referenceElement = ((X3DConcreteElement) IS).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (leftTexture != null)
		{
			referenceElement = ((X3DConcreteElement) leftTexture).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (leftTextureProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) leftTextureProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadata != null)
		{
			referenceElement = ((X3DConcreteElement) metadata).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadataProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) metadataProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (rightTexture != null)
		{
			referenceElement = ((X3DConcreteElement) rightTexture).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (rightTextureProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) rightTextureProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (textureProperties != null)
		{
			referenceElement = ((X3DConcreteElement) textureProperties).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (texturePropertiesProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) texturePropertiesProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (topTexture != null)
		{
			referenceElement = ((X3DConcreteElement) topTexture).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (topTextureProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) topTextureProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node or statement with given name attribute is found, meaning both objects are attached to same scene graph.
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @see #findElementByNameValue(String, String)
	 * @return whether node is found
	 */
	public boolean hasElementByNameValue(String nameValue, String elementName)
	{
		return (findElementByNameValue(nameValue, elementName) != null);
	}

	/**
	 * Recursive method to provide object reference to node by DEF, if found as this node or in a contained node.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same DEF, this method does not handle that case.
	 * @see #findElementByNameValue(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found node, null otherwise
	 */
	/* @Override */
	public X3DConcreteNode findNodeByDEF(String DEFvalue)
	{
		if ((DEFvalue == null) || DEFvalue.isEmpty())
		{
			String errorNotice = "*** findNodeByDEF(\"\") cannot use empty string to find a name";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		if (getDEF().equals(DEFvalue))
			return this;
		X3DConcreteNode referenceNode;
		if (backTexture != null)
		{
			referenceNode = ((X3DConcreteElement) backTexture).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (backTextureProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) backTextureProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (bottomTexture != null)
		{
			referenceNode = ((X3DConcreteElement) bottomTexture).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (bottomTextureProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) bottomTextureProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (frontTexture != null)
		{
			referenceNode = ((X3DConcreteElement) frontTexture).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (frontTextureProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) frontTextureProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (IS != null)
		{
			referenceNode = ((X3DConcreteElement) IS).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (leftTexture != null)
		{
			referenceNode = ((X3DConcreteElement) leftTexture).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (leftTextureProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) leftTextureProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadata != null)
		{
			referenceNode = ((X3DConcreteElement) metadata).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadataProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) metadataProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (rightTexture != null)
		{
			referenceNode = ((X3DConcreteElement) rightTexture).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (rightTextureProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) rightTextureProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (textureProperties != null)
		{
			referenceNode = ((X3DConcreteElement) textureProperties).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (texturePropertiesProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) texturePropertiesProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (topTexture != null)
		{
			referenceNode = ((X3DConcreteElement) topTexture).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (topTextureProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) topTextureProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node with DEFvalue is found, meaning both objects are attached to same scene graph.
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @see #findNodeByDEF(String)
	 * @return whether node is found
	 */
	public boolean hasNodeByDEF(String DEFvalue)
	{
		return (findNodeByDEF(DEFvalue) != null);
	}


	/**
	 * Recursive method to validate this element plus all contained nodes and statements,
	 * using both datatype-specification value checks and regular expression (regex) checking of corresponding string values.
         * TODO document specific validation methods.
	 * @return validation results (if any)
	 */
	@Override
	public String validate()
	{
		validationResult = new StringBuilder(); // prepare for updated results

		setDescription(getDescription()); // exercise field checks, simple types
        
		if (!hasUSE()) // be careful! setting DEF via setDEF() method will reset USE value
			setDEF(getDEF()); // exercise field checks, simple types
        
		if (hasUSE()) // be careful! setting USE via setUSE() method resets all attributes to default values and wipes out all children
			setUSE(getUSE()); // exercise field checks, simple types
        
		setCssClass(getCssClass()); // exercise field checks, simple types
        
		setHtmlID(getHtmlID()); // exercise field checks, simple types
        
		setCssStyle(getCssStyle()); // exercise field checks, simple types
        
		if (backTexture != null)
		{
			setBackTexture(getBackTexture());
			((X3DConcreteElement) backTexture).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) backTexture).getValidationResult());
		}
		if (backTextureProtoInstance != null)
		{
			setBackTexture(getBackTextureProtoInstance());
			((X3DConcreteElement) backTextureProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) backTextureProtoInstance).getValidationResult());
		}
		if ((backTexture != null) && (backTextureProtoInstance != null))
		{
			String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both backTexture and backTextureProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
            if (hasUSE() && hasBackTexture()) // test USE restrictions
            {
                String errorNotice = "*** ComposedCubeMapTexture USE='" + getUSE() + "' is not allowed to have contained SFNode backTexture";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (bottomTexture != null)
		{
			setBottomTexture(getBottomTexture());
			((X3DConcreteElement) bottomTexture).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) bottomTexture).getValidationResult());
		}
		if (bottomTextureProtoInstance != null)
		{
			setBottomTexture(getBottomTextureProtoInstance());
			((X3DConcreteElement) bottomTextureProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) bottomTextureProtoInstance).getValidationResult());
		}
		if ((bottomTexture != null) && (bottomTextureProtoInstance != null))
		{
			String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both bottomTexture and bottomTextureProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
            if (hasUSE() && hasBottomTexture()) // test USE restrictions
            {
                String errorNotice = "*** ComposedCubeMapTexture USE='" + getUSE() + "' is not allowed to have contained SFNode bottomTexture";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (frontTexture != null)
		{
			setFrontTexture(getFrontTexture());
			((X3DConcreteElement) frontTexture).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) frontTexture).getValidationResult());
		}
		if (frontTextureProtoInstance != null)
		{
			setFrontTexture(getFrontTextureProtoInstance());
			((X3DConcreteElement) frontTextureProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) frontTextureProtoInstance).getValidationResult());
		}
		if ((frontTexture != null) && (frontTextureProtoInstance != null))
		{
			String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both frontTexture and frontTextureProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
            if (hasUSE() && hasFrontTexture()) // test USE restrictions
            {
                String errorNotice = "*** ComposedCubeMapTexture USE='" + getUSE() + "' is not allowed to have contained SFNode frontTexture";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (IS != null)
		{
			setIS(getIS());
			((X3DConcreteElement) IS).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) IS).getValidationResult());
		}
            if (hasUSE() && hasIS()) // test USE restrictions
            {
                String errorNotice = "*** ComposedCubeMapTexture USE='" + getUSE() + "' is not allowed to have contained SFNode IS";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (leftTexture != null)
		{
			setLeftTexture(getLeftTexture());
			((X3DConcreteElement) leftTexture).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) leftTexture).getValidationResult());
		}
		if (leftTextureProtoInstance != null)
		{
			setLeftTexture(getLeftTextureProtoInstance());
			((X3DConcreteElement) leftTextureProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) leftTextureProtoInstance).getValidationResult());
		}
		if ((leftTexture != null) && (leftTextureProtoInstance != null))
		{
			String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both leftTexture and leftTextureProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
            if (hasUSE() && hasLeftTexture()) // test USE restrictions
            {
                String errorNotice = "*** ComposedCubeMapTexture USE='" + getUSE() + "' is not allowed to have contained SFNode leftTexture";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (metadata != null)
		{
			setMetadata(getMetadata());
			((X3DConcreteElement) metadata).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadata).getValidationResult());
		}
		if (metadataProtoInstance != null)
		{
			setMetadata(getMetadataProtoInstance());
			((X3DConcreteElement) metadataProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadataProtoInstance).getValidationResult());
		}
		if ((metadata != null) && (metadataProtoInstance != null))
		{
			String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
            if (hasUSE() && hasMetadata()) // test USE restrictions
            {
                String errorNotice = "*** ComposedCubeMapTexture USE='" + getUSE() + "' is not allowed to have contained SFNode metadata";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (rightTexture != null)
		{
			setRightTexture(getRightTexture());
			((X3DConcreteElement) rightTexture).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) rightTexture).getValidationResult());
		}
		if (rightTextureProtoInstance != null)
		{
			setRightTexture(getRightTextureProtoInstance());
			((X3DConcreteElement) rightTextureProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) rightTextureProtoInstance).getValidationResult());
		}
		if ((rightTexture != null) && (rightTextureProtoInstance != null))
		{
			String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both rightTexture and rightTextureProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
            if (hasUSE() && hasRightTexture()) // test USE restrictions
            {
                String errorNotice = "*** ComposedCubeMapTexture USE='" + getUSE() + "' is not allowed to have contained SFNode rightTexture";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (textureProperties != null)
		{
			setTextureProperties(getTextureProperties());
			((X3DConcreteElement) textureProperties).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) textureProperties).getValidationResult());
		}
		if (texturePropertiesProtoInstance != null)
		{
			setTextureProperties(getTexturePropertiesProtoInstance());
			((X3DConcreteElement) texturePropertiesProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) texturePropertiesProtoInstance).getValidationResult());
		}
		if ((textureProperties != null) && (texturePropertiesProtoInstance != null))
		{
			String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both textureProperties and texturePropertiesProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
            if (hasUSE() && hasTextureProperties()) // test USE restrictions
            {
                String errorNotice = "*** ComposedCubeMapTexture USE='" + getUSE() + "' is not allowed to have contained SFNode textureProperties";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (topTexture != null)
		{
			setTopTexture(getTopTexture());
			((X3DConcreteElement) topTexture).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) topTexture).getValidationResult());
		}
		if (topTextureProtoInstance != null)
		{
			setTopTexture(getTopTextureProtoInstance());
			((X3DConcreteElement) topTextureProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) topTextureProtoInstance).getValidationResult());
		}
		if ((topTexture != null) && (topTextureProtoInstance != null))
		{
			String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both topTexture and topTextureProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
            if (hasUSE() && hasTopTexture()) // test USE restrictions
            {
                String errorNotice = "*** ComposedCubeMapTexture USE='" + getUSE() + "' is not allowed to have contained SFNode topTexture";
                validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice); // report error
            }
		
		if (getIS() != null)
		{
			if (getIS().getConnectList().isEmpty())
			{
				String errorNotice = "*** IS statement present, but contains no connect statements";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
			}
			// TODO also check that this node has ancestor ProtoBody, and that a field with same name also exists, so that IS is legal
		}
		if (!getContainerFieldOverride().isBlank() &&
			!Arrays.asList(containerField_ALLOWED_VALUES).contains(getContainerFieldOverride()))
		{
			String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE +
				": illegal value encountered, containerField='" + getContainerFieldOverride() +
				"' but allowed values are containerField_ALLOWED_VALUES='" +
				new MFString(containerField_ALLOWED_VALUES).toStringX3D() + "'.";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
		}

		// profile validation test, if connected to full scene
		if (findAncestorX3D() != null)
		{
			String     modelProfile = findAncestorX3D().getProfile();

			// check whether model has a satisfactory profile for this node
			boolean hasSatisfactorySupport = findAncestorX3D().supportsX3dProfile   (modelProfile) ||
                                             findAncestorX3D().supportsX3dComponent (COMPONENT, LEVEL);

			if (!hasSatisfactorySupport)
			{
				String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE +
					" insufficient X3D profile='" + modelProfile +
					"' for current X3D model containing 'ComposedCubeMapTexture' node, ensure sufficient support by adding head statement <component name='CubeMapTexturing' level='1'/>\n" +
					"or Java source-code assignment: " +
					" findAncestorX3D().getHead().addComponent(\"CubeMapTexturing\").setLevel(1);";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
			}
		}
		return validationResult.toString();
	}
}
