/*
 * Decompiled with CFR 0.152.
 */
import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class X3dCustomHandler
extends DefaultHandler {
    static Logger log = LogManager.getLogger(X3dCustomHandler.class);
    private static final HashMap<String, String> allowedIDs = new HashMap();
    private InputSource inputSource;
    private MessageFormat message = new MessageFormat("({0}: row {1}, column {2}):\n{3}\n");
    private String msg;
    private boolean localDTD = false;

    public void setInputSource(InputSource pInputSource) {
        this.inputSource = pInputSource;
    }

    private void setMessage(SAXParseException ex) {
        this.msg = this.message.format(new Object[]{this.inputSource.getSystemId(), ex.getLineNumber(), ex.getColumnNumber(), ex.getMessage()});
    }

    @Override
    public void warning(SAXParseException ex) {
        this.setMessage(ex);
        log.warn(this.msg);
    }

    @Override
    public void error(SAXParseException ex) {
        this.setMessage(ex);
        log.error(this.msg);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXParseException {
        this.setMessage(ex);
        log.fatal(this.msg);
        throw ex;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        InputSource source = null;
        if (!this.localDTD) {
            source = new InputSource(systemId);
        } else if (allowedIDs.containsKey(systemId)) {
            source = new InputSource(allowedIDs.get(systemId));
            log.debug("found systemId");
        }
        log.debug("localDTD: " + this.localDTD);
        log.debug("publicId: " + publicId);
        log.debug("systemId: " + systemId);
        return source;
    }

    public void setLocalDTD(boolean whetherLocalDTD) {
        this.localDTD = whetherLocalDTD;
    }

    static {
        allowedIDs.put("https://www.web3d.org/specifications/x3d-3.0.dtd", "/x3d-code/www.web3d.org/specifications/x3d-3.0.dtd");
        allowedIDs.put("https://www.web3d.org/specifications/x3d-3.1.dtd", "/x3d-code/www.web3d.org/specifications/x3d-3.1.dtd");
        allowedIDs.put("https://www.web3d.org/specifications/x3d-3.2.dtd", "/x3d-code/www.web3d.org/specifications/x3d-3.2.dtd");
        allowedIDs.put("https://www.web3d.org/specifications/x3d-3.3.dtd", "/x3d-code/www.web3d.org/specifications/x3d-3.3.dtd");
        allowedIDs.put("https://www.web3d.org/specifications/x3d-4.0.dtd", "/x3d-code/www.web3d.org/specifications/x3d-4.0.dtd");
    }
}

