/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FilterX3d
implements FilenameFilter {
    DocumentBuilderFactory documentBuilderFactory;
    DocumentBuilder documentBuilder;
    Document x3dDocument;

    @Override
    public boolean accept(File directory, String name) {
        if (name.endsWith(".x3d") && !name.endsWith("Canonical.x3d")) {
            try {
                this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
                this.documentBuilderFactory.setValidating(false);
                this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
                X3dCustomHandler handler = new X3dCustomHandler();
                this.documentBuilder.setEntityResolver(handler);
                this.documentBuilder.setErrorHandler(handler);
                try {
                    System.out.print("FilterX3d parsing " + String.valueOf(directory) + File.separator + name + ", validating=" + this.documentBuilder.isValidating());
                    this.x3dDocument = this.documentBuilder.newDocument();
                    handler.setInputSource(new InputSource(String.valueOf(directory) + File.separator + name));
                    this.x3dDocument = this.documentBuilder.parse(String.valueOf(directory) + File.separator + name);
                    if (this.x3dDocument.getDoctype() == null) {
                        System.out.println("\n*** Document type not found (or garbled), ignored");
                    } else {
                        if (!this.x3dDocument.getDoctype().getName().contains("X3D")) {
                            System.out.println("\n*** Document type " + this.x3dDocument.getDoctype().getName() + ", ignored");
                            return false;
                        }
                        System.out.println(" (Document type " + this.x3dDocument.getDoctype().getName() + ")");
                    }
                }
                catch (IOException | SAXException e) {
                    System.err.println("\nException in FilterX3d x3dDocument.getDoctype()\n  parsing " + String.valueOf(directory) + File.separator + name + "\n" + String.valueOf(e));
                    System.out.println("\n[Error] malformed, missing or unavailable DOCTYPE in X3D scene!");
                    System.out.println(e.getMessage());
                }
                return true;
            }
            catch (ParserConfigurationException badParse) {
                System.err.println("\n[Error] Exception in FilterX3d\n  parsing " + String.valueOf(directory) + File.separator + name);
                badParse.printStackTrace(System.out);
                if (badParse.getMessage().startsWith("No content model may contain ")) {
                    System.out.println("JAXP 1.1 exception likely due to incorrect parameter entity declarations");
                    System.out.println("  e.g. <!ENTITY % CoreProfile  \"INCLUDE\">");
                    System.out.println("  in the DTD declaration.");
                }
                return false;
            }
        }
        return false;
    }
}

