/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomDocumentPrinter {
    protected String indentLevel = "  ";
    protected int lineBreakWidth = 100;
    private int lineLength = 0;

    public int getIndentLevel() {
        return this.indentLevel.length();
    }

    public void setIndentLevel(int numberOfSpaces) {
        if (numberOfSpaces < 1) {
            numberOfSpaces = 1;
            System.out.println("*** error, numberOfSpaces=" + numberOfSpaces + ", reset to 1");
        }
        this.indentLevel = "";
        for (int i = 0; i < numberOfSpaces; ++i) {
            this.indentLevel = this.indentLevel + " ";
        }
    }

    public String getIndent() {
        return this.indentLevel;
    }

    public void setIndent(String newIndent) {
        this.indentLevel = newIndent;
    }

    public void printNode(Node node) {
        this.printNode(node, "");
        System.out.println();
        System.out.println();
    }

    public void printNode(Node node, String indent) {
        boolean nodeChildFound = false;
        switch (node.getNodeType()) {
            case 9: {
                System.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                NodeList nodes = node.getChildNodes();
                if (nodes == null) break;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    this.printNode(nodes.item(i), "");
                }
                break;
            }
            case 10: {
                DocumentType documentType = (DocumentType)node;
                System.out.print("<!DOCTYPE " + documentType.getName());
                if (documentType.getName().compareTo("X3D") == 0) {
                    System.out.print("\n");
                    System.out.print(" PUBLIC \"ISO//Web3D//DTD X3D 3.3//EN\"\n");
                    System.out.print("        \"https://www.web3d.org/specifications/x3d-3.3.dtd\"\n");
                } else if (documentType.getPublicId() != null && documentType.getSystemId() != null) {
                    System.out.print("\n");
                    System.out.print(" PUBLIC \"" + documentType.getPublicId() + "\"\n");
                    System.out.print("        \"" + documentType.getSystemId());
                } else if (documentType.getPublicId() == null && documentType.getSystemId() != null) {
                    System.out.print(" SYSTEM \"" + documentType.getSystemId());
                } else {
                    System.out.print("");
                }
                NodeList nodes = node.getChildNodes();
                if (nodes != null) {
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        this.printNode(nodes.item(i), "");
                    }
                }
                if (documentType.getPublicId() != null && documentType.getSystemId() != null) {
                    System.out.print(">\n");
                    break;
                }
                if (documentType.getPublicId() == null && documentType.getSystemId() != null) {
                    System.out.print("\">\n");
                    break;
                }
                System.out.print(">\n");
                break;
            }
            case 1: {
                int i;
                String name = node.getNodeName();
                System.out.print(indent + "<" + name);
                this.lineLength = name.length() + 2;
                NamedNodeMap attributes = node.getAttributes();
                for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                    Node current = attributes.item(i2);
                    this.lineLength = this.lineLength + current.getNodeName().length() + current.getNodeValue().length() + 4;
                    if (this.lineLength > this.lineBreakWidth) {
                        System.out.println();
                        System.out.print(indent + "  ");
                        this.lineLength = current.getNodeName().length() + indent.length() + current.getNodeValue().length() + 2;
                    }
                    System.out.print(" " + current.getNodeName() + "='" + current.getNodeValue() + "'");
                }
                NodeList children = node.getChildNodes();
                for (i = 0; i < children.getLength(); ++i) {
                    if (children.item(i).getNodeType() == 3) continue;
                    nodeChildFound = true;
                    break;
                }
                if (nodeChildFound) {
                    System.out.println(">");
                    for (i = 0; i < children.getLength(); ++i) {
                        this.printNode(children.item(i), indent + this.indentLevel);
                    }
                    System.out.println(indent + "</" + name + ">");
                    break;
                }
                System.out.println("/>");
                break;
            }
            case 3: {
                System.out.print(node.getNodeValue().trim());
                break;
            }
            case 4: {
                System.out.println(indent + "<![CDATA[" + node.getNodeValue() + "]]>");
                break;
            }
            case 8: {
                System.out.println(indent + "<!--" + node.getNodeValue() + "-->");
                break;
            }
            case 7: {
                System.out.println(indent + "<?" + node.getNodeName() + " " + node.getNodeValue() + "?>");
                break;
            }
            case 5: {
                System.out.print("&" + node.getNodeName() + ";");
            }
        }
    }

    public static void main(String[] argv) throws IOException, DOMException, ParserConfigurationException {
        if (argv.length < 1) {
            System.out.println("Usage: java DomDocumentPrinter filename.xml [otherFiles.xml]");
            System.exit(0);
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        X3dCustomHandler handler = new X3dCustomHandler();
        documentBuilder.setEntityResolver(handler);
        documentBuilder.setErrorHandler(handler);
        Document document = documentBuilder.newDocument();
        DomDocumentPrinter domDocumentPrinter = new DomDocumentPrinter();
        for (String fileName : argv) {
            try {
                if (argv.length > 1) {
                    System.out.println("\nParsing " + fileName + "\n");
                }
                handler.setInputSource(new InputSource(fileName));
                document = documentBuilder.parse(fileName);
            }
            catch (SAXException badParse) {
                System.out.println("Error in parsing: " + badParse.getMessage());
                badParse.printStackTrace();
            }
            catch (IOException badParse) {
                System.out.println("Error in parsing: " + badParse.getMessage());
                badParse.printStackTrace();
            }
            domDocumentPrinter.printNode(document);
        }
    }
}

