/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomDocumentOutputStreamWriter {
    private Writer output;
    protected String indentLevel = "  ";
    protected int lineBreakWidth = 100;
    private int lineLength = 0;
    private Charset charset = Charset.forName("UTF-8");

    public DomDocumentOutputStreamWriter(Writer out) {
        this.output = out;
    }

    public DomDocumentOutputStreamWriter() throws UnsupportedEncodingException {
        this(new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8")));
    }

    public int getIndentLevel() {
        return this.indentLevel.length();
    }

    public void setIndentLevel(int numberOfSpaces) {
        for (int i = 0; i < numberOfSpaces; ++i) {
            this.indentLevel = this.indentLevel + " ";
        }
    }

    public String getIndent() {
        return this.indentLevel;
    }

    public void setIndent(String newIndent) {
        this.indentLevel = newIndent;
    }

    public void flush() {
        try {
            this.output.flush();
        }
        catch (IOException badParse) {
            System.err.println("Error flushing: " + badParse.getMessage() + "\n");
            badParse.printStackTrace();
        }
    }

    public void close() {
        try {
            this.output.close();
        }
        catch (IOException badParse) {
            System.err.println("Error closing: " + badParse.getMessage() + "\n");
            badParse.printStackTrace();
        }
    }

    public void printNode(Node node) {
        this.printNode(node, "");
        try {
            this.output.write("\n\n");
        }
        catch (IOException badPrint) {
            System.err.println("Error in printNodes: " + badPrint.getMessage() + "\n");
            badPrint.printStackTrace();
        }
    }

    public void printNode(Node node, String indent) {
        boolean nodeChildFound = false;
        try {
            switch (node.getNodeType()) {
                case 9: {
                    this.output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    NodeList nodes = node.getChildNodes();
                    if (nodes == null) break;
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        this.printNode(nodes.item(i), "");
                    }
                    break;
                }
                case 10: {
                    DocumentType documentType = (DocumentType)node;
                    this.output.write("<!DOCTYPE " + documentType.getName());
                    if (documentType.getName().compareTo("X3D") == 0) {
                        this.output.write(" PUBLIC \"ISO//Web3D//DTD X3D 4.0//EN\" \"https://www.web3d.org/specifications/x3d-4.0.dtd");
                    } else if (documentType.getPublicId() != null && documentType.getSystemId() != null) {
                        this.output.write("\n");
                        this.output.write(" PUBLIC \"" + documentType.getPublicId() + "\"\n");
                        this.output.write("        \"" + documentType.getSystemId());
                    } else if (documentType.getPublicId() == null && documentType.getSystemId() != null) {
                        this.output.write(" SYSTEM \"" + documentType.getSystemId());
                    } else {
                        this.output.write("");
                    }
                    NodeList nodes = node.getChildNodes();
                    if (nodes != null) {
                        for (int i = 0; i < nodes.getLength(); ++i) {
                            this.printNode(nodes.item(i), "");
                        }
                    }
                    if (documentType.getPublicId() != null && documentType.getSystemId() != null) {
                        this.output.write("\">\n");
                        break;
                    }
                    if (documentType.getPublicId() == null && documentType.getSystemId() != null) {
                        this.output.write("\">\n");
                        break;
                    }
                    this.output.write(">\n");
                    break;
                }
                case 1: {
                    String name = node.getNodeName();
                    this.output.write(indent + "<" + name);
                    this.lineLength = name.length() + 2;
                    NamedNodeMap attributes = node.getAttributes();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        Node current = attributes.item(i);
                        if (current.getNodeValue().equals("")) continue;
                        this.lineLength = this.lineLength + current.getNodeName().length() + current.getNodeValue().length() + 4;
                        if (this.lineLength > this.lineBreakWidth) {
                            this.output.write("\n");
                            this.output.write(indent + "  ");
                            this.lineLength = current.getNodeName().length() + indent.length() + current.getNodeValue().length() + 2;
                        }
                        if (!current.getNodeValue().contains("&apos;") && !current.getNodeValue().contains("&lt;") && !current.getNodeValue().contains("&gt;") && current.getNodeValue().contains("&")) {
                            current.setNodeValue(current.getNodeValue().replace("&", "&amp;"));
                        }
                        try {
                            byte[] defaultBytes = current.getNodeValue().getBytes();
                            byte[] utf8Bytes = current.getNodeValue().getBytes("UTF-8");
                            String roundTrip = new String(utf8Bytes, "UTF-8");
                            if (defaultBytes.length != utf8Bytes.length) {
                                System.out.println("*** Found UTF-8 special characters in DomDocumentOutputStreamWriter current.getNodeValue()");
                                System.out.println(current.getNodeName() + " = [original=" + current.getNodeValue() + "] [defaultBytes.length=" + defaultBytes.length + "] [utf8Bytes.length=" + utf8Bytes.length + "] [roundTrip=" + roundTrip + "(length=" + roundTrip.length() + ")]");
                            }
                            this.output.write(" " + current.getNodeName() + "='" + roundTrip + "'");
                            continue;
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                    }
                    int i = 0;
                    NodeList children = node.getChildNodes();
                    if (i < children.getLength()) {
                        nodeChildFound = true;
                    }
                    if (nodeChildFound) {
                        this.output.write(">\n");
                        for (i = 0; i < children.getLength(); ++i) {
                            this.printNode(children.item(i), indent + this.indentLevel);
                        }
                        this.output.write(indent + "</" + name + ">\n");
                        break;
                    }
                    this.output.write("/>\n");
                    break;
                }
                case 4: {
                    this.output.write(indent + "<![CDATA[" + node.getNodeValue() + "]]>\n");
                    break;
                }
                case 8: {
                    StringBuilder normalizedLine = new StringBuilder(node.getNodeValue().replace('\n', ' '));
                    for (int i = 0; i < normalizedLine.length() - 1; ++i) {
                        if (normalizedLine.charAt(i) != ' ' || normalizedLine.charAt(i + 1) != ' ') continue;
                        normalizedLine.deleteCharAt(i);
                        --i;
                    }
                    this.output.write(indent + "<!--" + String.valueOf(normalizedLine) + "-->\n");
                    break;
                }
                case 3: {
                    if (node.getNodeValue().trim().length() <= 0) break;
                    this.output.write(node.getNodeValue().trim() + "\n");
                    break;
                }
                case 7: {
                    this.output.write(indent + "<?" + node.getNodeName() + " " + node.getNodeValue() + "?>\n");
                    break;
                }
                case 5: {
                    this.output.write("&" + node.getNodeName() + ";");
                }
            }
        }
        catch (IOException badPrint) {
            System.err.println("Error in printNode: " + badPrint.getMessage() + "\n");
            badPrint.printStackTrace();
        }
        catch (DOMException badPrint) {
            System.err.println("Error in printNode: " + badPrint.getMessage() + "\n");
            badPrint.printStackTrace();
        }
    }

    public static void main(String[] argv) throws IOException, DOMException, ParserConfigurationException {
        FileWriter fileWriter;
        if (argv.length < 1 || argv.length > 2) {
            System.err.println("Usage: java DomDocumentPrinter url://filename.xml [outputFilename.xml]");
            System.exit(0);
        }
        String fileName = argv[0];
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        X3dCustomHandler handler = new X3dCustomHandler();
        documentBuilder.setEntityResolver(handler);
        documentBuilder.setErrorHandler(handler);
        Document document = null;
        try {
            handler.setInputSource(new InputSource(fileName));
            document = documentBuilder.parse(fileName);
        }
        catch (SAXException badParse) {
            System.err.println("Error in parsing: " + badParse.getMessage() + "\n");
            badParse.printStackTrace();
            System.exit(0);
        }
        catch (IOException badParse) {
            System.err.println("Error in parsing: " + badParse.getMessage() + "\n");
            badParse.printStackTrace();
            System.exit(0);
        }
        if (argv.length == 2) {
            fileWriter = new FileWriter(argv[1]);
        } else {
            fileWriter = new FileWriter("exampleStreamOutput.xml");
            System.out.println("Sending results to exampleStreamOutput.xml");
        }
        DomDocumentOutputStreamWriter domDocumentOutputStreamWriter = new DomDocumentOutputStreamWriter(fileWriter);
        domDocumentOutputStreamWriter.printNode(document);
        domDocumentOutputStreamWriter.close();
        fileWriter.close();
    }
}

