/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ContentCatalogBuilder {
    private static final Logger logger = LogManager.getLogger((String)"ContentCatalogBuilder");
    static String directoryPath;
    static boolean prepareSections;
    static boolean validating;
    static boolean localDTD;
    DomDocumentPrinter domDocumentPrinter = new DomDocumentPrinter();
    DomDocumentOutputStreamWriter domDocumentOutputStreamWriter;
    String tocPage = "index.html";
    String helpPage = "X3dResources.html";
    String startDirectoryName = System.getProperty("user.dir");
    static String createContentCatalogDirectoryName;
    String layoutFilename = "ContentCatalog.xml";
    File layoutFile;
    FileOutputStream layoutFileOutputStream;
    String[] sectionNames;
    String[] directoryNames;
    String[] x3dFilenames;
    String[] imageFilenames;
    String[] imageIconFilenames;
    String[] packageFilenames;
    String currentSectionName;
    String currentDirectoryName;
    String referenceDirectoryName;
    String targetPageDirectoryName;
    String currentFilename;
    String swapName;
    String archiveName;
    File referenceDirectory;
    File currentSectionDirectory;
    File currentDirectory;
    File targetPageDirectory;
    File x3dLayoutFile;
    OutputStreamWriter outputStreamWriter;
    X3dCustomHandler handler;
    DocumentBuilderFactory documentBuilderFactory;
    DocumentBuilder documentBuilder;
    DocumentType layoutDocumentType;
    Document layoutDocument;
    Document defaultLayoutDocument;
    Document initializationLayoutDocument;
    Document x3dDocument;
    DOMImplementation domImplementation;
    NodeList metaTagNodeList;
    NodeList viewpointTagNodeList;
    NodeList metadataSetNodeList;
    NodeList savageMetadataTagNodeList;
    Element root;
    Element meta;
    Element section;
    Element chapter;
    Element page;
    Element MetadataSet;
    Element X3DModelArchiveData;
    Date creationDate = new Date();
    Calendar calendar = new GregorianCalendar();
    Boolean serverBased = false;

    public void initializeDocuments() {
        try {
            this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.documentBuilderFactory.setValidating(validating);
            this.documentBuilderFactory.setExpandEntityReferences(validating);
            this.documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            this.handler = new X3dCustomHandler();
            this.handler.setLocalDTD(localDTD);
            if (!this.serverBased.booleanValue()) {
                this.documentBuilder.setEntityResolver(this.handler);
                this.documentBuilder.setErrorHandler(this.handler);
            }
        }
        catch (ParserConfigurationException badInitialize) {
            logger.error("... initializing: " + badInitialize.getMessage());
            badInitialize.printStackTrace(System.err);
            System.exit(0);
        }
    }

    public void createNewLayout() {
        try {
            String localCatalogDTD;
            this.domImplementation = this.documentBuilder.newDocument().getImplementation();
            if (createContentCatalogDirectoryName == null) {
                System.out.println("ContentCatalogBuilder CreateContentCatalog.dir=null, error");
            } else if (createContentCatalogDirectoryName.isEmpty()) {
                System.out.println("ContentCatalogBuilder CreateContentCatalog.dir=empty, error");
            } else if (!createContentCatalogDirectoryName.isEmpty()) {
                System.out.println("ContentCatalogBuilder CreateContentCatalog.dir=" + createContentCatalogDirectoryName);
            } else {
                System.out.println("ContentCatalogBuilder localDTD=" + String.valueOf(localDTD));
            }
            if (createContentCatalogDirectoryName.contains("hudson")) {
                this.serverBased = true;
                localCatalogDTD = "hudson/CreateContentCatalog/ContentCatalog.dtd";
            } else if (createContentCatalogDirectoryName.contains("jenkins")) {
                this.serverBased = true;
                localCatalogDTD = "jenkins/CreateContentCatalog/ContentCatalog.dtd";
            } else {
                localCatalogDTD = "../../../tools/CreateContentCatalog/ContentCatalog.dtd";
            }
            System.out.println("ContentCatalogBuilder localCatalogDTD=" + localCatalogDTD);
            this.layoutDocumentType = this.domImplementation.createDocumentType("ContentCatalog", "http://svn.code.sf.net/p/x3d/code/www.web3d.org/x3d/tools/CreateContentCatalog/ContentCatalog.dtd", localCatalogDTD);
            System.out.println("layoutDocumentType=" + this.layoutDocumentType.getName());
            System.out.println("  PublicId=" + this.layoutDocumentType.getPublicId());
            System.out.println("  SystemId=" + this.layoutDocumentType.getSystemId());
            this.layoutDocument = this.domImplementation.createDocument("ContentCatalogNameSpace", "ContentCatalog", this.layoutDocumentType);
            this.root = this.layoutDocument.getDocumentElement();
            String createdDate = Integer.toString(this.calendar.get(2) + 1) + "/" + this.calendar.get(5) + "/" + this.calendar.get(1);
            System.out.println("Date:  " + createdDate);
            this.root.setAttribute("creationDate", createdDate);
        }
        catch (DOMException badInitialize) {
            logger.error("... initializing: " + badInitialize.getMessage());
            badInitialize.printStackTrace(System.err);
            System.exit(0);
        }
    }

    public String embedSpacesInName(String shortName) {
        StringBuilder newName = new StringBuilder(shortName);
        for (int i = shortName.length() - 1; i > 0; --i) {
            if (shortName.charAt(i) == '_') {
                newName.setCharAt(i, ' ');
                continue;
            }
            if (i >= 2 && shortName.charAt(i - 2) == 'X' && shortName.charAt(i - 1) == '3' && shortName.toLowerCase().charAt(i) == 'd') {
                newName.setCharAt(i, 'D');
                newName.insert(i - 2, ' ');
                i -= 2;
                continue;
            }
            if (i >= 5 && shortName.substring(i - 4).equalsIgnoreCase("Web3D")) {
                newName.setCharAt(i, 'D');
                newName.insert(i - 4, ' ');
                i -= 4;
                continue;
            }
            if (i >= 5 && shortName.substring(0, i).endsWith("ShayD")) {
                newName.setCharAt(i, 'P');
                newName.insert(i, ' ');
                newName.insert(i - 1, ' ');
                i -= 4;
                continue;
            }
            if (i >= 4 && shortName.substring(0, i).endsWith("STEP")) {
                newName.insert(i, ' ');
                i -= 4;
                continue;
            }
            if (i >= 3 && shortName.substring(0, i).endsWith("LPV")) {
                newName.insert(i, ' ');
                i -= 3;
                continue;
            }
            if (i >= 2 && shortName.substring(0, i).endsWith("UX")) {
                System.out.println("*** Found UX! shortName=" + shortName);
                newName.insert(i, ' ');
                i -= 2;
                continue;
            }
            if (!(i < 1 || shortName.charAt(i - 1) != '3' && shortName.charAt(i - 1) != '2' || shortName.charAt(i) != 'D' && shortName.charAt(i) != 'd')) {
                newName.setCharAt(i, 'D');
                newName.insert(i - 1, ' ');
                --i;
                continue;
            }
            if (!(i < 3 || shortName.charAt(i - 3) != 'V' && shortName.charAt(i - 3) != 'v' || shortName.charAt(i - 2) != 'R' && shortName.charAt(i - 2) != 'r' || shortName.charAt(i - 1) != 'M' && shortName.charAt(i - 1) != 'm' || shortName.charAt(i) != 'L' && shortName.charAt(i) != 'l')) {
                newName.setCharAt(i - 2, 'R');
                newName.setCharAt(i - 1, 'M');
                newName.setCharAt(i, 'L');
                if (newName.charAt(i + 1) != ' ') {
                    newName.insert(i + 1, ' ');
                }
                i -= 3;
                continue;
            }
            if (shortName.charAt(i) == '_') {
                newName.setCharAt(i, ' ');
                continue;
            }
            if (shortName.charAt(i - 1) == '_') {
                newName.setCharAt(i - 1, ' ');
                continue;
            }
            if (!(Character.isLowerCase(shortName.charAt(i - 1)) && Character.isUpperCase(shortName.charAt(i)) || Character.isDigit(shortName.charAt(i - 1)) && Character.isUpperCase(shortName.charAt(i)) || Character.isLetter(shortName.charAt(i - 1)) && Character.isDigit(shortName.charAt(i)) || shortName.charAt(i - 1) == '-' && (Character.isDigit(shortName.charAt(i)) || Character.isLetter(shortName.charAt(i)))) && (shortName.charAt(i) != '-' || !Character.isDigit(shortName.charAt(i - 1)) && !Character.isLetter(shortName.charAt(i - 1))) || newName.charAt(i) == ' ') continue;
            newName.insert(i, ' ');
        }
        return newName.toString();
    }

    public String normalizeAttribute(String attributeName) {
        int i;
        StringBuilder newName = new StringBuilder(attributeName);
        for (i = attributeName.length() - 1; i > 0; --i) {
            if (attributeName.charAt(i) == '\'') {
                newName.deleteCharAt(i);
                newName.insert(i, "&apos;");
            }
            if (attributeName.charAt(i) != '<') continue;
            newName.deleteCharAt(i);
            newName.insert(i, "&lt;");
        }
        int firstNonWhitespaceCharacter = 0;
        for (i = 0; i <= newName.length() - 1 && Character.isWhitespace(newName.charAt(i)); ++i) {
            firstNonWhitespaceCharacter = i + 1;
        }
        for (i = newName.length() - 1; i > firstNonWhitespaceCharacter && Character.isWhitespace(newName.charAt(i)); --i) {
            newName.deleteCharAt(i);
        }
        return newName.substring(firstNonWhitespaceCharacter);
    }

    public void processDocuments() {
        this.referenceDirectoryName = directoryPath;
        if (this.referenceDirectoryName.contains("Basic")) {
            prepareSections = false;
            this.archiveName = "Basic";
        } else if (this.referenceDirectoryName.contains("ConformanceNist")) {
            prepareSections = true;
            this.archiveName = "ConformanceNist";
        } else if (this.referenceDirectoryName.contains("HumanoidAnimation")) {
            prepareSections = false;
            this.archiveName = "HumanoidAnimation";
        } else if (this.referenceDirectoryName.contains("SavageDefense")) {
            prepareSections = true;
            this.archiveName = "SavageDefense";
        } else if (this.referenceDirectoryName.contains("Savage")) {
            prepareSections = true;
            this.archiveName = "Savage";
        } else if (this.referenceDirectoryName.contains("Vrml2Sourcebook")) {
            prepareSections = false;
            this.archiveName = "Vrml2Sourcebook";
        } else if (this.referenceDirectoryName.contains("X3dForAdvancedModeling")) {
            prepareSections = false;
            this.archiveName = "X3dForAdvancedModeling";
        } else if (this.referenceDirectoryName.contains("X3dForWebAuthors")) {
            prepareSections = false;
            this.archiveName = "X3dForWebAuthors";
        } else {
            System.out.println("[Error] ContentCatalogBuilder unrecognized referenceDirectoryName=" + this.referenceDirectoryName + " (expected Basic|ConformanceNist|HumanoidAnimation|Savage|SavageDefense|Vrml2Sourcebook|X3dForAdvancedModeling|X3dForWebAuthors)");
            return;
        }
        System.out.println("ContentCatalogBuilder found supported name=" + this.archiveName + ",");
        System.out.println("    referenceDirectoryName=" + this.referenceDirectoryName + ",");
        System.out.println("    prepareSections=" + prepareSections + ", documentBuilder.isValidating()=" + this.documentBuilder.isValidating());
        this.referenceDirectory = new File(this.referenceDirectoryName);
        try {
            int sectionCounter;
            int j;
            int i2;
            this.createNewLayout();
            this.root.setAttribute("name", this.archiveName);
            if (this.archiveName.compareTo("X3dForAdvancedModeling") == 0) {
                this.root.setAttribute("title", "X3D4AM, X3D for Advanced Modeling");
            } else if (this.archiveName.compareTo("X3dForWebAuthors") == 0) {
                this.root.setAttribute("title", "X3D4WA, X3D for Web Authors");
            } else {
                this.root.setAttribute("title", this.embedSpacesInName(this.archiveName));
            }
            this.root.setAttribute("toc", this.tocPage);
            this.root.setAttribute("helpPage", this.helpPage);
            this.meta = this.layoutDocument.createElement("meta");
            this.meta.setAttribute("name", "generator");
            this.meta.setAttribute("content", "ContentCatalogBuilder");
            this.root.appendChild(this.meta);
            if (prepareSections) {
                this.sectionNames = this.referenceDirectory.list(new FilterCatalogDirectory());
                System.out.println("Section listing " + this.referenceDirectory.getCanonicalPath() + " using FilterDirectory:");
                for (i2 = 0; i2 < this.sectionNames.length - 1; ++i2) {
                    for (j = 0; j < this.sectionNames.length - i2 - 1; ++j) {
                        if (this.sectionNames[j].compareToIgnoreCase(this.sectionNames[j + 1]) <= 0) continue;
                        this.swapName = this.sectionNames[j + 1];
                        this.sectionNames[j + 1] = this.sectionNames[j];
                        this.sectionNames[j] = this.swapName;
                    }
                }
                if (this.sectionNames.length == 0) {
                    System.out.println("\t[ignoring sections, none found]");
                    prepareSections = false;
                } else {
                    String[] i2 = this.sectionNames;
                    j = i2.length;
                    for (int k = 0; k < j; ++k) {
                        String sectionName = i2[k];
                        System.out.println("\t" + sectionName);
                    }
                }
                sectionCounter = this.sectionNames.length;
            } else {
                sectionCounter = 0;
            }
            while (sectionCounter >= 0) {
                if (prepareSections) {
                    System.out.println("section=" + (this.sectionNames.length - sectionCounter));
                    this.currentSectionName = this.sectionNames[this.sectionNames.length - sectionCounter];
                    this.currentSectionDirectory = new File(this.referenceDirectory.getCanonicalPath() + File.separator + this.currentSectionName + File.separator);
                    this.directoryNames = this.currentSectionDirectory.list(new FilterCatalogDirectory());
                    if (this.directoryNames.length > 0) {
                        this.section = this.layoutDocument.createElement("Section");
                        System.out.println("Section name=" + this.currentSectionName);
                        this.root.appendChild(this.section);
                        this.section.setAttribute("title", this.embedSpacesInName(this.currentSectionName));
                        this.section.setAttribute("name", this.currentSectionName);
                    }
                } else {
                    this.currentSectionName = "";
                    this.directoryNames = this.referenceDirectory.list(new FilterCatalogDirectory());
                }
                if (this.directoryNames == null) {
                    logger.error("*** error, directoryNames == null, bad path to referenceDirectory " + this.referenceDirectoryName);
                    System.exit(0);
                }
                for (i2 = 0; i2 < this.directoryNames.length - 1; ++i2) {
                    for (j = 0; j < this.directoryNames.length - i2 - 1; ++j) {
                        if (this.directoryNames[j].compareToIgnoreCase(this.directoryNames[j + 1]) <= 0) continue;
                        this.swapName = this.directoryNames[j + 1];
                        this.directoryNames[j + 1] = this.directoryNames[j];
                        this.directoryNames[j] = this.swapName;
                    }
                }
                System.out.println("Directory listing " + this.referenceDirectory.getCanonicalPath() + File.separator + this.currentSectionName + " using new FilterDirectory():");
                if (this.directoryNames.length == 0) {
                    System.out.println("\t[none found]");
                } else {
                    for (String directoryName : this.directoryNames) {
                        System.out.println("\t" + directoryName);
                    }
                }
                for (String directoryName : this.directoryNames) {
                    if (prepareSections) {
                        this.currentDirectoryName = this.referenceDirectory.getCanonicalPath() + File.separator + this.currentSectionName + File.separator + directoryName;
                        this.targetPageDirectoryName = this.referenceDirectory.getCanonicalPath() + File.separator + this.currentSectionName + File.separator + directoryName;
                    } else {
                        this.currentDirectoryName = this.referenceDirectory.getCanonicalPath() + File.separator + directoryName;
                        this.targetPageDirectoryName = this.referenceDirectory.getCanonicalPath() + File.separator + directoryName;
                    }
                    this.currentDirectory = new File(this.currentDirectoryName);
                    this.x3dFilenames = this.currentDirectory.list(new FilterX3d());
                    System.out.println("\nDirectory listing " + this.currentDirectory.getCanonicalPath() + " shows " + this.x3dFilenames.length + " .x3d files using FilterX3d:");
                    for (int i3 = 0; i3 < this.x3dFilenames.length - 1; ++i3) {
                        for (int j2 = 0; j2 < this.x3dFilenames.length - i3 - 1; ++j2) {
                            if (this.x3dFilenames[j2].compareToIgnoreCase(this.x3dFilenames[j2 + 1]) <= 0) continue;
                            this.swapName = this.x3dFilenames[j2 + 1];
                            this.x3dFilenames[j2 + 1] = this.x3dFilenames[j2];
                            this.x3dFilenames[j2] = this.swapName;
                        }
                    }
                    if (this.x3dFilenames.length == 0) {
                        System.out.println("\t[none found]");
                    } else {
                        for (String x3dFilename : this.x3dFilenames) {
                            System.out.println("\t" + x3dFilename);
                        }
                    }
                    this.imageFilenames = this.currentDirectory.list(new FilterImage());
                    System.out.println("Directory listing " + this.currentDirectory.getCanonicalPath() + " using FilterImage:");
                    if (this.imageFilenames.length == 0) {
                        System.out.println("\t[none found]");
                    } else {
                        for (String imageFilename : this.imageFilenames) {
                            System.out.println("\t" + imageFilename);
                        }
                    }
                    this.imageIconFilenames = this.currentDirectory.list(new FilterImageIcon());
                    System.out.println("Directory listing " + this.currentDirectory.getCanonicalPath() + " using FilterImageIcon:");
                    if (this.imageIconFilenames.length == 0) {
                        System.out.println("\t[none found]");
                    } else {
                        for (String imageIconFilename : this.imageIconFilenames) {
                            System.out.println("\t" + imageIconFilename);
                        }
                    }
                    this.packageFilenames = this.currentDirectory.list(new FilterPackageHtml());
                    System.out.println("Directory listing " + this.currentDirectory.getCanonicalPath() + " using FilterPackageHtml:");
                    if (this.packageFilenames.length == 0) {
                        System.out.println("\t[none found]");
                    } else {
                        for (String packageFilename : this.packageFilenames) {
                            System.out.println("\t" + packageFilename);
                        }
                    }
                    if (this.packageFilenames.length != 2 || !Arrays.asList(this.packageFilenames).contains("package.html") || !Arrays.asList(this.packageFilenames).contains("package-catalog.html")) {
                        System.out.println("\t*** Warning: expected package-catalog.html for catalog generation and package.html for javadoc");
                    }
                    if (this.x3dFilenames.length > 0) {
                        this.chapter = this.layoutDocument.createElement("Chapter");
                        if (prepareSections) {
                            this.section.appendChild(this.chapter);
                        } else {
                            this.root.appendChild(this.chapter);
                        }
                        this.chapter.setAttribute("title", this.embedSpacesInName(directoryName));
                        this.chapter.setAttribute("name", directoryName);
                        this.targetPageDirectory = new File(this.targetPageDirectoryName);
                        if (!this.targetPageDirectory.exists()) {
                            this.targetPageDirectory.mkdir();
                        }
                        if (this.targetPageDirectory.exists()) {
                            System.out.println("targetPageDirectory=" + this.targetPageDirectoryName);
                        } else {
                            System.out.println("*** failed to create targetPageDirectory=" + this.targetPageDirectoryName);
                        }
                    }
                    int viewImageCount = 1;
                    for (String x3dFilename : this.x3dFilenames) {
                        File viewSnapshotImageFile;
                        Object viewDescription;
                        this.currentFilename = String.valueOf(this.currentDirectory) + File.separator + x3dFilename;
                        System.out.println("\nParsing " + this.currentFilename);
                        try {
                            this.handler.setInputSource(new InputSource(this.currentFilename));
                            this.x3dDocument = this.documentBuilder.parse(this.currentFilename);
                        }
                        catch (IOException e) {
                            System.err.println("IOException in ContentCatalogBuilder processDocuments() x3dDocument.parse(), skipping file...");
                            System.out.println(e.getMessage());
                            e.printStackTrace(System.err);
                            continue;
                        }
                        catch (SAXException e) {
                            System.err.println("SAXException in ContentCatalogBuilder processDocuments() x3dDocument.parse(), skipping file...");
                            System.out.println(e.getMessage());
                            e.printStackTrace(System.err);
                            continue;
                        }
                        Element pageElement = this.layoutDocument.createElement("Page");
                        this.chapter.appendChild(pageElement);
                        pageElement.setAttribute("title", this.embedSpacesInName(x3dFilename.substring(0, x3dFilename.length() - 4)));
                        if (x3dFilename.length() > 4 && x3dFilename.endsWith(".x3d")) {
                            pageElement.setAttribute("name", x3dFilename.substring(0, x3dFilename.length() - 4));
                        } else {
                            pageElement.setAttribute("name", x3dFilename);
                        }
                        String thumbnailFilePath = "_thumbnails/";
                        String thumbnailFileName = x3dFilename.substring(0, x3dFilename.length() - 4) + "Thumbnail.png";
                        File thumbnailSnapshotImageFile = new File(this.currentDirectoryName + "/" + thumbnailFilePath, thumbnailFileName);
                        boolean thumbnailSnapshotImageFileFound = thumbnailSnapshotImageFile.exists();
                        System.out.print("\t Thumbnail image " + thumbnailFilePath + thumbnailFileName);
                        if (thumbnailSnapshotImageFileFound) {
                            System.out.println(" found");
                            pageElement.setAttribute("thumbnail", thumbnailFilePath + thumbnailFileName);
                        } else {
                            System.out.println(" not found");
                            System.out.println("\t*** Warning, thumbnail image file not found: " + thumbnailSnapshotImageFile.getPath());
                        }
                        this.metaTagNodeList = this.x3dDocument.getElementsByTagName("meta");
                        this.metadataSetNodeList = this.x3dDocument.getElementsByTagName("MetadataSet");
                        int listLength = this.metadataSetNodeList.getLength();
                        boolean smalEnabled = false;
                        if (listLength > 0) {
                            for (int ii = 0; ii < listLength; ++ii) {
                                if (this.metadataSetNodeList.item(ii).getAttributes().getNamedItem("name") == null || !this.metadataSetNodeList.item(ii).getAttributes().getNamedItem("name").getNodeValue().equals("SMAL")) continue;
                                smalEnabled = true;
                                this.savageMetadataTagNodeList = this.metadataSetNodeList.item(ii).getChildNodes();
                                for (int jj = this.savageMetadataTagNodeList.getLength() - 1; jj >= 0; --jj) {
                                    if (this.savageMetadataTagNodeList.item(jj).hasAttributes()) continue;
                                    this.metadataSetNodeList.item(ii).removeChild(this.savageMetadataTagNodeList.item(jj));
                                }
                                this.savageMetadataTagNodeList = this.metadataSetNodeList.item(ii).getChildNodes();
                            }
                        }
                        boolean foundFirstSpecificationUrl = false;
                        boolean foundFirstSpecificationSection = false;
                        for (int j3 = 0; j3 < this.metaTagNodeList.getLength(); ++j3) {
                            String metaAttributeName = "TODO";
                            String metaAttributeContent = "TODO";
                            try {
                                metaAttributeName = this.metaTagNodeList.item(j3).getAttributes().getNamedItem("name").getNodeValue();
                                metaAttributeContent = this.metaTagNodeList.item(j3).getAttributes().getNamedItem("content").getNodeValue();
                                byte[] defaultBytes = this.metaTagNodeList.item(j3).getAttributes().getNamedItem("content").getNodeValue().getBytes();
                                byte[] utf8Bytes = this.metaTagNodeList.item(j3).getAttributes().getNamedItem("content").getNodeValue().getBytes("UTF-8");
                                String roundTrip = new String(utf8Bytes, "UTF-8");
                                if (defaultBytes.length != utf8Bytes.length) {
                                    System.out.println("*** Found UTF-8 special characters in ContentCatalogBuilder metaAttributeContent");
                                    System.out.println(metaAttributeName + " = [original=" + metaAttributeContent + "] [defaultBytes.length=" + defaultBytes.length + "] [utf8Bytes.length=" + utf8Bytes.length + "] [roundTrip=" + roundTrip + "(length=" + roundTrip.length() + ")]");
                                    metaAttributeContent = roundTrip;
                                }
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace(System.err);
                            }
                            System.out.print("\t name=" + metaAttributeName);
                            if (metaAttributeName.length() < 10) {
                                System.out.print("\t");
                            }
                            System.out.println("\t content=" + metaAttributeContent);
                            boolean warningFound = false;
                            if (metaAttributeName.equalsIgnoreCase("description")) {
                                pageElement.setAttribute("description", this.normalizeAttribute(metaAttributeContent));
                                continue;
                            }
                            if (metaAttributeName.equalsIgnoreCase("creator")) {
                                pageElement.setAttribute("creator", this.normalizeAttribute(metaAttributeContent));
                                continue;
                            }
                            if (metaAttributeName.equalsIgnoreCase("creators")) {
                                pageElement.setAttribute("creator", this.normalizeAttribute(metaAttributeContent));
                                continue;
                            }
                            if (metaAttributeName.equalsIgnoreCase("translator")) {
                                pageElement.setAttribute("translator", this.normalizeAttribute(metaAttributeContent));
                                continue;
                            }
                            if (metaAttributeName.equalsIgnoreCase("translators")) {
                                pageElement.setAttribute("translator", this.normalizeAttribute(metaAttributeContent));
                                continue;
                            }
                            if (metaAttributeName.equalsIgnoreCase("created")) {
                                pageElement.setAttribute("created", this.normalizeAttribute(metaAttributeContent));
                                continue;
                            }
                            if (metaAttributeName.equalsIgnoreCase("tramslated")) {
                                pageElement.setAttribute("tramslated", this.normalizeAttribute(metaAttributeContent));
                                continue;
                            }
                            if (metaAttributeName.equalsIgnoreCase("modified")) {
                                pageElement.setAttribute("modified", this.normalizeAttribute(metaAttributeContent));
                                continue;
                            }
                            if (metaAttributeName.equalsIgnoreCase("url") | metaAttributeName.equalsIgnoreCase("identifier")) {
                                pageElement.setAttribute("url", this.normalizeAttribute(metaAttributeContent));
                                continue;
                            }
                            if (metaAttributeName.equalsIgnoreCase("subject")) {
                                pageElement.setAttribute("subject", this.normalizeAttribute(metaAttributeContent));
                                continue;
                            }
                            if (metaAttributeName.equalsIgnoreCase("TODO")) {
                                pageElement.setAttribute("TODO", this.normalizeAttribute(metaAttributeContent));
                                continue;
                            }
                            if (metaAttributeName.equalsIgnoreCase("hint")) {
                                pageElement.setAttribute("hint", this.normalizeAttribute(metaAttributeContent));
                                continue;
                            }
                            if (metaAttributeName.equalsIgnoreCase("info")) {
                                pageElement.setAttribute("info", this.normalizeAttribute(metaAttributeContent));
                                continue;
                            }
                            if (metaAttributeName.equalsIgnoreCase("warning")) {
                                warningFound = true;
                                pageElement.setAttribute("warning", this.normalizeAttribute(metaAttributeContent));
                                continue;
                            }
                            if (metaAttributeName.equalsIgnoreCase("error")) {
                                boolean errorFound = true;
                                pageElement.setAttribute("error", this.normalizeAttribute(metaAttributeContent));
                                continue;
                            }
                            if (metaAttributeName.equalsIgnoreCase("license")) {
                                pageElement.setAttribute("license", this.normalizeAttribute(metaAttributeContent));
                                continue;
                            }
                            if (metaAttributeName.equalsIgnoreCase("specificationSection") && !foundFirstSpecificationSection) {
                                pageElement.setAttribute("specificationSection", this.normalizeAttribute(metaAttributeContent));
                                foundFirstSpecificationSection = true;
                                continue;
                            }
                            if (metaAttributeName.equalsIgnoreCase("specificationUrl") && !foundFirstSpecificationUrl) {
                                pageElement.setAttribute("specificationUrl", this.normalizeAttribute(metaAttributeContent));
                                foundFirstSpecificationUrl = true;
                                continue;
                            }
                            if (metaAttributeName.equalsIgnoreCase("specificationSection") && foundFirstSpecificationSection) {
                                pageElement.setAttribute("specificationSection2", this.normalizeAttribute(metaAttributeContent));
                                continue;
                            }
                            if (!metaAttributeName.equalsIgnoreCase("specificationUrl") || !foundFirstSpecificationUrl) continue;
                            pageElement.setAttribute("specificationUrl2", this.normalizeAttribute(metaAttributeContent));
                        }
                        if (smalEnabled) {
                            this.MetadataSet = this.layoutDocument.createElement("SMAL");
                            pageElement.appendChild(this.MetadataSet);
                            System.out.println("\tSMAL metadata:");
                            int usableMetadataTags = this.nodeSetWalker(this.savageMetadataTagNodeList, this.MetadataSet);
                            System.out.println("\tSMAL processing found " + usableMetadataTags + " usable Metadata tags");
                        } else {
                            System.out.println("\tNot SMAL Enabled");
                        }
                        this.viewpointTagNodeList = this.x3dDocument.getElementsByTagName("Viewpoint");
                        int noDescriptionViewpointCounter = 0;
                        for (int j4 = 0; j4 < this.viewpointTagNodeList.getLength(); ++j4) {
                            if (this.viewpointTagNodeList.item(j4).getAttributes().getNamedItem("USE") != null) continue;
                            viewDescription = this.viewpointTagNodeList.item(j4).getAttributes().getNamedItem("description") == null ? "Unnamed_" + ++noDescriptionViewpointCounter : this.viewpointTagNodeList.item(j4).getAttributes().getNamedItem("description").getNodeValue();
                            viewDescription = ((String)viewDescription).replaceAll("\"", "").replaceAll(":", "").replaceAll("#", "");
                            Object viewFileName = pageElement.getAttribute("name") + ".x3d._VP_" + (String)viewDescription + ".png";
                            viewFileName = ((String)viewFileName).replaceAll("'", "&amp;apos;").replaceAll(" ", "_");
                            viewDescription = "[" + viewImageCount + "] " + pageElement.getAttribute("name") + ".x3d " + (String)viewDescription;
                            if (((String)viewDescription).contains("Unnamed_")) {
                                viewDescription = ((String)viewDescription).substring(0, ((String)viewDescription).indexOf("Unnamed_")).concat(" (Viewpoint contains no description)");
                            }
                            ++viewImageCount;
                            viewSnapshotImageFile = new File(this.currentDirectoryName + "/_viewpoints/", (String)viewFileName);
                            boolean viewSnapshotImageFileFound = viewSnapshotImageFile.exists();
                            if (!((String)viewDescription).equals("")) {
                                System.out.print("\tViewpoint fileName='" + (String)viewFileName + "' description='" + (String)viewDescription + "'");
                                Element viewpointElement = this.layoutDocument.createElement("Viewpoint");
                                viewDescription = ((String)viewDescription).replace("'", "&amp;apos;");
                                viewpointElement.setAttribute("fileName", (String)viewFileName);
                                viewpointElement.setAttribute("description", (String)viewDescription);
                                viewpointElement.setAttribute("found", Boolean.toString(viewSnapshotImageFileFound));
                                pageElement.appendChild(viewpointElement);
                                if (viewSnapshotImageFileFound) {
                                    System.out.println(" found");
                                    continue;
                                }
                                System.out.println(" not found");
                                System.out.println("\t*** Warning, image file not found: " + viewSnapshotImageFile.getPath());
                                continue;
                            }
                            System.out.println("\t*** Warning, skipped Viewpoint[" + j4 + "] since no description defined");
                        }
                        String viewFileName = pageElement.getAttribute("name") + ".x3d._VP_Default_viewpoint.png";
                        viewDescription = "[" + viewImageCount + "] " + pageElement.getAttribute("name") + ".x3d (default X3D view from 0 0 10)";
                        ++viewImageCount;
                        if (((String)viewDescription).length() > 75) {
                            viewDescription = ((String)viewDescription).replace(" from 0 0 10", "");
                        }
                        if (((String)viewDescription).length() > 75) {
                            viewDescription = ((String)viewDescription).replace(" (default X3D view)", "");
                        }
                        viewSnapshotImageFile = new File(this.currentDirectoryName + "/_viewpoints/", viewFileName);
                        boolean viewSnapshotImageFileFound = viewSnapshotImageFile.exists();
                        System.out.print("\tViewpoint fileName='" + viewFileName + "' description='" + (String)viewDescription + "'");
                        Element defaultViewpointElement = this.layoutDocument.createElement("Viewpoint");
                        defaultViewpointElement.setAttribute("fileName", viewFileName);
                        defaultViewpointElement.setAttribute("description", (String)viewDescription);
                        defaultViewpointElement.setAttribute("found", Boolean.toString(viewSnapshotImageFileFound));
                        if (viewSnapshotImageFileFound) {
                            System.out.println(" found");
                        } else {
                            System.out.println(" not found");
                            System.out.println("\t*** Warning, image file not found: " + viewSnapshotImageFile.getPath());
                        }
                        pageElement.appendChild(defaultViewpointElement);
                    }
                    System.out.println();
                }
                if (--sectionCounter != 0 || !prepareSections) continue;
                sectionCounter = -1;
            }
            this.layoutFilename = this.referenceDirectory.getCanonicalPath() + File.separator + this.layoutFilename;
            this.layoutFile = new File(this.layoutFilename);
            this.layoutFileOutputStream = new FileOutputStream(this.layoutFile);
            Charset charset = Charset.forName("UTF-8");
            this.outputStreamWriter = new OutputStreamWriter((OutputStream)this.layoutFileOutputStream, charset);
            this.domDocumentOutputStreamWriter = new DomDocumentOutputStreamWriter(this.outputStreamWriter);
            System.out.println("Writing " + this.layoutFilename + " ...");
            this.domDocumentOutputStreamWriter.printNode(this.layoutDocument);
            this.domDocumentOutputStreamWriter.close();
            this.outputStreamWriter.close();
        }
        catch (IOException badIO) {
            logger.error("... IOException in file input/output.. " + badIO.getMessage());
            badIO.printStackTrace(System.err);
            System.exit(0);
        }
        catch (DOMException badParse) {
            logger.error("... DOMException in parsing.. " + badParse.getMessage());
            badParse.printStackTrace(System.err);
            this.domDocumentOutputStreamWriter.flush();
            System.exit(0);
        }
    }

    private int nodeSetWalker(NodeList nodeList, Element element) {
        int nodeListLength = nodeList.getLength();
        int usableMetaTags = 0;
        for (int ii = 0; ii <= nodeListLength - 1; ++ii) {
            Node checkNode = nodeList.item(ii);
            if (checkNode.getNodeName().equals("MetadataSet")) {
                if (checkNode.getAttributes().getNamedItem("name") == null) continue;
                String setName = checkNode.getAttributes().getNamedItem("name").getNodeValue();
                String type = checkNode.getNodeName();
                System.out.println("\tSet name = " + setName);
                Element subElement = this.layoutDocument.createElement(setName);
                element.appendChild(subElement);
                if (setName.equals("X3DArchiveModel")) {
                    subElement.setAttribute("archive", "Savage");
                    subElement.setAttribute("section", this.section.getAttribute("name"));
                    subElement.setAttribute("chapter", this.chapter.getAttribute("name"));
                    NamedNodeMap nnm = element.getParentNode().getParentNode().getAttributes();
                    if (nnm.getNamedItem("name") != null) {
                        subElement.setAttribute("model", ((Element)element.getParentNode().getParentNode()).getAttribute("name") + ".x3d");
                    }
                    if (nnm.getNamedItem("url") == null) continue;
                    subElement.setAttribute("alternateBaseURL", ((Element)element.getParentNode().getParentNode()).getAttribute("url"));
                    continue;
                }
                if (!checkNode.hasChildNodes()) continue;
                usableMetaTags += this.nodeSetWalker(checkNode.getChildNodes(), subElement);
                continue;
            }
            if (!checkNode.hasAttributes() || checkNode.getAttributes().getNamedItem("name") == null || checkNode.getAttributes().getNamedItem("name").getNodeValue().equals("appinfo")) continue;
            String smalAttributeName = checkNode.getAttributes().getNamedItem("name").getNodeValue();
            System.out.print("\t " + smalAttributeName + "=");
            if (checkNode.getAttributes().getNamedItem("value") == null) continue;
            String smalAttributeValue = checkNode.getAttributes().getNamedItem("value").getNodeValue();
            ++usableMetaTags;
            if (element.getTagName().equals("IdentificationParameters") && smalAttributeValue.equals("")) {
                smalAttributeValue = this.chapter.getAttribute("name");
            }
            if (smalAttributeValue.startsWith("\"") && smalAttributeValue.endsWith("\"") && !checkNode.getAttributes().getNamedItem("name").getNodeValue().equals("geoSystem")) {
                smalAttributeValue = smalAttributeValue.substring(1, smalAttributeValue.length() - 1);
            }
            element.setAttribute(smalAttributeName, smalAttributeValue);
            System.out.println(smalAttributeValue);
        }
        return usableMetaTags;
    }

    public static void main(String[] argv) throws IOException, DOMException, ParserConfigurationException {
        if (argv.length == 0) {
            prepareSections = false;
            createContentCatalogDirectoryName = "C:\\x3d-code\\www.web3d.org\\x3d\\tools\\CreateContentCatalog";
            directoryPath = "../../content/examples/X3dForAdvancedModeling";
            logger.info("                  prepareSections = " + prepareSections);
            logger.info("                         localDTD = " + localDTD);
            logger.info("createContentCatalogDirectoryName = " + createContentCatalogDirectoryName);
            logger.info("                    directoryPath = " + directoryPath);
        } else {
            for (String arg : argv) {
                logger.info(arg);
                if (arg.equalsIgnoreCase("-sections")) {
                    prepareSections = true;
                    logger.info("                  prepareSections = " + prepareSections);
                    continue;
                }
                if (arg.equalsIgnoreCase("-localDTD")) {
                    localDTD = true;
                    logger.info("                         localDTD = " + localDTD);
                    continue;
                }
                if (arg.equalsIgnoreCase("-onlineDTD")) {
                    localDTD = false;
                    logger.info("                         localDTD = " + localDTD);
                    continue;
                }
                if (arg.contains("hudson")) {
                    createContentCatalogDirectoryName = arg;
                    logger.info("createContentCatalogDirectoryName = " + createContentCatalogDirectoryName);
                    continue;
                }
                if (arg.contains("jenkins")) {
                    createContentCatalogDirectoryName = arg;
                    logger.info("createContentCatalogDirectoryName = " + createContentCatalogDirectoryName);
                    continue;
                }
                if (arg.contains("CreateContentCatalog")) {
                    createContentCatalogDirectoryName = arg;
                    logger.info("createContentCatalogDirectoryName = " + createContentCatalogDirectoryName);
                    continue;
                }
                if (!arg.startsWith("-")) {
                    directoryPath = arg;
                    logger.info("                    directoryPath = " + directoryPath);
                    continue;
                }
                logger.info("Usage: java ContentCatalogBuilder -cp .;../canonical/lib/log4j-1.2.15.jar [-sections] [-localDTD] [directoryPath] \n-sections means 2 subdirectory levels correspond  to Section and Chapter \notherwise, single subdirectory level  corresponds to Chapter \nset local DTD for faster parser reference, otherwise onlin DTD will be fetched \nspecify another full directory path if base directory not desired");
                System.exit(0);
            }
        }
        ContentCatalogBuilder contentCatalogBuilder = new ContentCatalogBuilder();
        contentCatalogBuilder.initializeDocuments();
        contentCatalogBuilder.processDocuments();
    }

    static {
        prepareSections = false;
        validating = false;
        localDTD = true;
    }
}

