import X3Dpackage


X3D0 = (X3Dpackage.X3D().setProfile("Immersive").setVersion("3.3")
      .setHead(X3Dpackage.head()
        .addComponent(X3Dpackage.component().setName("Shaders").setLevel(1))
        .addComponent(X3Dpackage.component().setName("CubeMapTexturing").setLevel(1))
        .addMeta(X3Dpackage.meta().setName("title").setContent("geo.x3d"))
        .addMeta(X3Dpackage.meta().setName("creator").setContent("John Carlson"))
        .addMeta(X3Dpackage.meta().setName("generator").setContent("manual"))
        .addMeta(X3Dpackage.meta().setName("identifier").setContent("https://coderextreme.net/X3DJSONLD/geo.x3d"))
        .addMeta(X3Dpackage.meta().setName("description").setContent("a sphere")))
      .setScene(X3Dpackage.Scene()
        .addChildren(X3Dpackage.NavigationInfo().setType(["ANY","EXAMINE","FLY","LOOKAT"]))
        .addChildren(X3Dpackage.Viewpoint().setDEF("Tour").setDescription("Tour Views"))
        #Viewpoint position='0 0 4' description='sphere in road'/

        .addChildren(X3Dpackage.Background().setBackUrl(["resources/images/bBK.png","https://coderextreme.net/X3DJSONLD/src/main/resources/images/bBK.png"]).setBottomUrl(["resources/images/bBT.png","https://coderextreme.net/X3DJSONLD/src/main/resources/images/bBT.png"]).setFrontUrl(["resources/images/bFR.png","https://coderextreme.net/X3DJSONLD/src/main/resources/images/bFR.png"]).setLeftUrl(["resources/images/bLF.png","https://coderextreme.net/X3DJSONLD/src/main/resources/images/bLF.png"]).setRightUrl(["resources/images/bRT.png","https://coderextreme.net/X3DJSONLD/src/main/resources/images/bRT.png"]).setTopUrl(["resources/images/bTP.png","https://coderextreme.net/X3DJSONLD/src/main/resources/images/bTP.png"]))
        .addChildren(X3Dpackage.Transform()
          .addChildren(X3Dpackage.Shape()
            .setGeometry(X3Dpackage.Sphere())
            .setAppearance(X3Dpackage.Appearance()
              .setMaterial(X3Dpackage.Material().setDiffuseColor([0.7,0.7,0.7]).setSpecularColor([0.5,0.5,0.5]))
              .setTexture(X3Dpackage.ComposedCubeMapTexture().setDEF("texture")
                .setBack(X3Dpackage.ImageTexture().setUrl(["resources/images/bBK.png","https://coderextreme.net/X3DJSONLD/src/main/resources/images/bBK.png"]))
                .setBottom(X3Dpackage.ImageTexture().setUrl(["resources/images/bBT.png","https://coderextreme.net/X3DJSONLD/src/main/resources/images/bBT.png"]))
                .setFront(X3Dpackage.ImageTexture().setUrl(["resources/images/bFR.png","https://coderextreme.net/X3DJSONLD/src/main/resources/images/bFR.png"]))
                .setLeft(X3Dpackage.ImageTexture().setUrl(["resources/images/bLF.png","https://coderextreme.net/X3DJSONLD/src/main/resources/images/bLF.png"]))
                .setRight(X3Dpackage.ImageTexture().setUrl(["resources/images/bRT.png","https://coderextreme.net/X3DJSONLD/src/main/resources/images/bRT.png"]))
                .setTop(X3Dpackage.ImageTexture().setUrl(["resources/images/bTP.png","https://coderextreme.net/X3DJSONLD/src/main/resources/images/bTP.png"])))
              .addShaders(X3Dpackage.ComposedShader(setLanguage = "GLSL")
                .addField(X3Dpackage.field().setName("chromaticDispertion").setAccessType("inputOutput").setType("SFVec3f").setValue("0.98 1 1.033"))
                .addField(X3Dpackage.field().setName("cube").setType("SFNode").setAccessType("inputOutput")
                  .addChildren(X3Dpackage.ComposedCubeMapTexture().setUSE("texture")))
                .addField(X3Dpackage.field().setName("bias").setAccessType("inputOutput").setType("SFFloat").setValue("0.5"))
                .addField(X3Dpackage.field().setName("scale").setAccessType("inputOutput").setType("SFFloat").setValue("0.5"))
                .addField(X3Dpackage.field().setName("power").setAccessType("inputOutput").setType("SFFloat").setValue("2"))
                .setParts(X3Dpackage.ShaderPart().setUrl(["../shaders/x3dom.vs","https://coderextreme.net/X3DJSONLD/shaders/x3dom.vs"]).setType("VERTEX"))
                .setParts(X3Dpackage.ShaderPart().setDEF("common").setUrl(["../shaders/common.fs","https://coderextreme.net/X3DJSONLD/shaders/common.fs"]).setType("FRAGMENT")))
              .addShaders(X3Dpackage.ComposedShader(setLanguage = "GLSL")
                .addField(X3Dpackage.field().setName("chromaticDispertion").setAccessType("initializeOnly").setType("SFVec3f").setValue("0.98 1 1.033"))
                .addField(X3Dpackage.field().setName("cube").setType("SFNode").setAccessType("initializeOnly")
                  .addChildren(X3Dpackage.ComposedCubeMapTexture().setUSE("texture")))
                .addField(X3Dpackage.field().setName("bias").setAccessType("initializeOnly").setType("SFFloat").setValue("0.5"))
                .addField(X3Dpackage.field().setName("scale").setAccessType("initializeOnly").setType("SFFloat").setValue("0.5"))
                .addField(X3Dpackage.field().setName("power").setAccessType("initializeOnly").setType("SFFloat").setValue("2"))
                .setParts(X3Dpackage.ShaderPart().setUrl(["../shaders/cobweb.vs","https://coderextreme.net/X3DJSONLD/shaders/cobweb.vs"]).setType("VERTEX"))
                .addParts(X3Dpackage.ShaderPart().setUSE("common"))))))))

