import X3Dpackage


X3D0 = (X3Dpackage.X3D().setProfile("Immersive").setVersion("3.3")
      .setHead(X3Dpackage.head()
        .addMeta(X3Dpackage.meta().setContent("HelloWorld.x3d").setName("title"))
        .addMeta(X3Dpackage.meta().setContent("Simple X3D scene example: Hello World!").setName("description"))
        .addMeta(X3Dpackage.meta().setContent("30 October 2000").setName("created"))
        .addMeta(X3Dpackage.meta().setContent("14 April 2017").setName("modified"))
        .addMeta(X3Dpackage.meta().setContent("Don Brutzman").setName("creator"))
        .addMeta(X3Dpackage.meta().setContent("HelloWorld.tall.png").setName("Image"))
        .addMeta(X3Dpackage.meta().setContent("http://en.wikipedia.org/wiki/Hello_world").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("https://en.wikipedia.org/wiki/Hello#.22Hello.2C_World.22_computer_program").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("https://en.wikipedia.org/wiki/\"Hello,_World!\"_program").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("http://en.wikibooks.org/w/index.php?title=Computer_Programming/Hello_world").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("http://www.HelloWorldExample.net").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("http://www.web3D.org").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("http://www.web3d.org/realtime-3d/news/internationalization-x3d").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("http://www.web3d.org/x3d/content/examples/HelloWorld.x3d").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("http://X3dGraphics.com/examples/X3dForAdvancedModeling/HelloWorldScenes").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("http://X3dGraphics.com/examples/X3dForWebAuthors/Chapter01TechnicalOverview/HelloWorld.x3d").setName("identifier"))
        .addMeta(X3Dpackage.meta().setContent("http://www.web3d.org/x3d/content/examples/license.html").setName("license"))
        .addMeta(X3Dpackage.meta().setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit").setName("generator"))
        # Alternate encodings: VRML97, X3D ClassicVRML Encoding, X3D Compressed Binary Encoding (CBE), X3DOM, JSON 

        .addMeta(X3Dpackage.meta().setContent("HelloWorld.wrl").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("HelloWorld.x3dv").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("HelloWorld.x3db").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("HelloWorld.xhtml").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("HelloWorld.json").setName("reference")))
      .setScene(X3Dpackage.Scene()
        # Example scene to illustrate X3D nodes and fields (XML elements and attributes) 

        .addChildren(X3Dpackage.WorldInfo().setTitle("Hello world!"))
        .addChildren(X3Dpackage.Group()
          .addChildren(X3Dpackage.Viewpoint().setDEF("ViewUpClose").setCenterOfRotation([0,-1,0]).setDescription("Hello world!").setPosition([0,-1,7]))
          .addChildren(X3Dpackage.Transform().setRotation([0,1,0,3])
            .addChildren(X3Dpackage.Shape()
              .setGeometry(X3Dpackage.Sphere())
              .setAppearance(X3Dpackage.Appearance()
                .setMaterial(X3Dpackage.Material().setDEF("MaterialLightBlue").setDiffuseColor([0.1,0.5,1]))
                .setTexture(X3Dpackage.ImageTexture().setDEF("ImageCloudlessEarth").setUrl(["earth-topo.png","earth-topo.jpg","earth-topo-small.gif","http://www.web3d.org/x3d/content/examples/Basic/earth-topo.png","http://www.web3d.org/x3d/content/examples/Basic/earth-topo.jpg","http://www.web3d.org/x3d/content/examples/Basic/earth-topo-small.gif"])))))
          .addChildren(X3Dpackage.Transform().setTranslation([0,-2,0])
            .addChildren(X3Dpackage.Shape()
              .setGeometry(X3Dpackage.Text().setDEF("TextMessage").setString(["Hello","world!"])
                .setFontStyle(X3Dpackage.FontStyle(setJustify = ["MIDDLE","MIDDLE"])))
              .setAppearance(X3Dpackage.Appearance()
                .setMaterial(X3Dpackage.Material().setUSE("MaterialLightBlue"))))))))

